/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.RectF;
import android.graphics.Xfermode;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import androidx.annotation.RequiresApi;

public class CustomPaintView
extends View {
    private Paint mPaint;
    private Bitmap mDrawBit;
    private Paint mEraserPaint;
    private Canvas mPaintCanvas = null;
    private float last_x;
    private float last_y;
    private boolean eraser;
    private int mColor;
    private RectF bounds;

    public CustomPaintView(Context context) {
        super(context);
        this.init(context);
    }

    public CustomPaintView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init(context);
    }

    public CustomPaintView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context);
    }

    @RequiresApi(api=21)
    public CustomPaintView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (this.mDrawBit == null) {
            this.generatorBit();
        }
    }

    private void generatorBit() {
        this.mDrawBit = Bitmap.createBitmap((int)this.getMeasuredWidth(), (int)this.getMeasuredHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        this.mPaintCanvas = new Canvas(this.mDrawBit);
    }

    private void init(Context context) {
        this.mColor = -65536;
        this.bounds = new RectF(0.0f, 0.0f, (float)this.getMeasuredWidth(), (float)this.getMeasuredHeight());
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mPaint.setColor(this.mColor);
        this.mPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mPaint.setStrokeWidth(15.0f);
        this.mEraserPaint = new Paint();
        this.mEraserPaint.setAlpha(0);
        this.mEraserPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_IN));
        this.mEraserPaint.setAntiAlias(true);
        this.mEraserPaint.setDither(true);
        this.mEraserPaint.setStyle(Paint.Style.STROKE);
        this.mEraserPaint.setStrokeJoin(Paint.Join.ROUND);
        this.mEraserPaint.setStrokeCap(Paint.Cap.ROUND);
        this.mEraserPaint.setStrokeWidth(40.0f);
    }

    public int getColor() {
        return this.mColor;
    }

    public void setColor(int color) {
        this.mColor = color;
        this.mPaint.setColor(this.mColor);
    }

    public void setWidth(float width) {
        this.mPaint.setStrokeWidth(width);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mDrawBit != null) {
            canvas.drawBitmap(this.mDrawBit, 0.0f, 0.0f, null);
        }
    }

    public boolean onTouchEvent(MotionEvent event) {
        boolean ret = super.onTouchEvent(event);
        float x = event.getX();
        float y = event.getY();
        switch (event.getAction()) {
            case 0: {
                ret = true;
                this.last_x = x;
                this.last_y = y;
                break;
            }
            case 2: {
                ret = true;
                if (this.bounds.contains(x, y) && this.bounds.contains(this.last_x, this.last_y)) {
                    this.mPaintCanvas.drawLine(this.last_x, this.last_y, x, y, this.eraser ? this.mEraserPaint : this.mPaint);
                }
                this.last_x = x;
                this.last_y = y;
                this.postInvalidate();
                break;
            }
            case 1: 
            case 3: {
                ret = false;
            }
        }
        return ret;
    }

    protected void onDetachedFromWindow() {
        super.onDetachedFromWindow();
        if (this.mDrawBit != null && !this.mDrawBit.isRecycled()) {
            this.mDrawBit.recycle();
        }
    }

    public void setEraser(boolean eraser) {
        this.eraser = eraser;
        this.mPaint.setColor(eraser ? 0 : this.mColor);
    }

    public Bitmap getPaintBit() {
        return this.mDrawBit;
    }

    public void reset() {
        if (this.mDrawBit != null && !this.mDrawBit.isRecycled()) {
            this.mDrawBit.recycle();
        }
        this.generatorBit();
    }

    public void setBounds(RectF bitmapRect) {
        this.bounds = bitmapRect;
    }
}

