/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.utils;

import android.app.Activity;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.ImageView;
import com.droidninja.imageeditengine.views.PhotoEditorView;
import com.google.android.material.floatingactionbutton.FloatingActionButton;

public class FilterTouchListener
implements View.OnTouchListener {
    private final ImageView mainImageView;
    private final int screenHeight;
    private final View filterLabel;
    private final PhotoEditorView photoEditorView;
    private final FloatingActionButton doneBtn;
    private float viewHeight;
    private View mView;
    private float mMotionDownY;

    public FilterTouchListener(View filterLayout, float filterLayoutHeight, ImageView mainImageView, PhotoEditorView photoEditorView, View filterLabel, FloatingActionButton doneBtn) {
        this.mView = filterLayout;
        this.filterLabel = filterLabel;
        this.doneBtn = doneBtn;
        this.mainImageView = mainImageView;
        this.photoEditorView = photoEditorView;
        DisplayMetrics displayMetrics = new DisplayMetrics();
        ((Activity)mainImageView.getContext()).getWindowManager().getDefaultDisplay().getMetrics(displayMetrics);
        this.screenHeight = displayMetrics.heightPixels;
        this.viewHeight = filterLayoutHeight;
    }

    public boolean onTouch(View v, MotionEvent e) {
        int action = e.getAction();
        float yPost = 0.0f;
        switch (action & e.getActionMasked()) {
            case 0: {
                this.mMotionDownY = e.getRawY() - this.mView.getTranslationY();
                break;
            }
            case 2: {
                yPost = e.getRawY() - this.mMotionDownY;
                Log.i((String)FilterTouchListener.class.getSimpleName(), (String)(String.valueOf(1.0f - Math.abs(yPost) / 1000.0f) + "--" + yPost + " - " + this.viewHeight + " - " + this.mView.getY() + "s - " + this.screenHeight + " d=" + ((float)this.screenHeight - this.mView.getY())));
                if (!(yPost >= 0.0f) || !(yPost < this.viewHeight)) break;
                this.mView.setTranslationY(yPost);
                this.filterLabel.setAlpha(Math.abs(yPost) / 1000.0f);
                this.doneBtn.setAlpha(Math.abs(yPost) / 1000.0f);
                Log.i((String)FilterTouchListener.class.getSimpleName(), (String)"moved");
                break;
            }
            case 3: {
                Log.i((String)FilterTouchListener.class.getSimpleName(), (String)"ACTION_CANCEL");
                break;
            }
            case 1: {
                yPost = e.getRawY() - this.mMotionDownY;
                Log.i((String)FilterTouchListener.class.getSimpleName(), (String)("ACTION_UP" + yPost));
                float middle = this.viewHeight / 2.0f;
                float diff = (float)this.screenHeight - this.mView.getY();
                if (diff < middle) {
                    this.mView.animate().translationY(this.viewHeight);
                    this.mainImageView.animate().scaleX(1.0f);
                    this.mainImageView.animate().scaleY(1.0f);
                    this.photoEditorView.animate().scaleX(1.0f);
                    this.photoEditorView.animate().scaleY(1.0f);
                    this.filterLabel.animate().alpha(1.0f);
                    this.doneBtn.animate().alpha(1.0f);
                    break;
                }
                this.mView.animate().translationY(0.0f);
                this.mainImageView.animate().scaleX(0.7f);
                this.mainImageView.animate().scaleY(0.7f);
                this.photoEditorView.animate().scaleX(0.7f);
                this.photoEditorView.animate().scaleY(0.7f);
                this.filterLabel.animate().alpha(0.0f);
                this.doneBtn.animate().alpha(0.0f);
            }
        }
        return true;
    }
}

