/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import androidx.annotation.Nullable;
import com.droidninja.imageeditengine.BaseFragment;
import com.droidninja.imageeditengine.BaseImageEditActivity;
import com.droidninja.imageeditengine.CropFragment;
import com.droidninja.imageeditengine.PhotoEditorFragment;
import com.droidninja.imageeditengine.R;
import com.droidninja.imageeditengine.utils.FragmentUtil;

public class ImageEditActivity
extends BaseImageEditActivity
implements PhotoEditorFragment.OnFragmentInteractionListener,
CropFragment.OnFragmentInteractionListener {
    private Rect cropRect;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_image_edit);
        String imagePath = this.getIntent().getStringExtra("EXTRA_IMAGE_PATH");
        if (imagePath != null) {
            FragmentUtil.addFragment(this, R.id.fragment_container, PhotoEditorFragment.newInstance(imagePath));
        }
    }

    @Override
    public void onCropClicked(Bitmap bitmap) {
        FragmentUtil.replaceFragment(this, R.id.fragment_container, CropFragment.newInstance(bitmap, this.cropRect));
    }

    @Override
    public void onDoneClicked(String imagePath) {
        Intent intent = new Intent();
        intent.putExtra("EXTRA_EDITED_PATH", imagePath);
        this.setResult(-1, intent);
        this.finish();
    }

    @Override
    public void onImageCropped(Bitmap bitmap, Rect cropRect) {
        this.cropRect = cropRect;
        PhotoEditorFragment photoEditorFragment = (PhotoEditorFragment)FragmentUtil.getFragmentByTag(this, PhotoEditorFragment.class.getSimpleName());
        if (photoEditorFragment != null) {
            photoEditorFragment.setImageWithRect(cropRect);
            photoEditorFragment.reset();
            FragmentUtil.removeFragment(this, (BaseFragment)FragmentUtil.getFragmentByTag(this, CropFragment.class.getSimpleName()));
        }
    }

    @Override
    public void onCancelCrop() {
        FragmentUtil.removeFragment(this, (BaseFragment)FragmentUtil.getFragmentByTag(this, CropFragment.class.getSimpleName()));
    }

    public void onBackPressed() {
        super.onBackPressed();
    }
}

