/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views.cropimage;

import android.content.Context;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.AsyncTask;
import android.util.DisplayMetrics;
import com.droidninja.imageeditengine.views.cropimage.BitmapUtils;
import com.droidninja.imageeditengine.views.cropimage.IEECropImageView;
import java.lang.ref.WeakReference;

final class BitmapLoadingWorkerTask
extends AsyncTask<Void, Void, Result> {
    private final WeakReference<IEECropImageView> mCropImageViewReference;
    private final Uri mUri;
    private final Context mContext;
    private final int mWidth;
    private final int mHeight;

    public BitmapLoadingWorkerTask(IEECropImageView cropImageView, Uri uri) {
        this.mUri = uri;
        this.mCropImageViewReference = new WeakReference<IEECropImageView>(cropImageView);
        this.mContext = cropImageView.getContext();
        DisplayMetrics metrics = cropImageView.getResources().getDisplayMetrics();
        double densityAdj = metrics.density > 1.0f ? (double)(1.0f / metrics.density) : 1.0;
        this.mWidth = (int)((double)metrics.widthPixels * densityAdj);
        this.mHeight = (int)((double)metrics.heightPixels * densityAdj);
    }

    public Uri getUri() {
        return this.mUri;
    }

    protected Result doInBackground(Void ... params) {
        try {
            if (!this.isCancelled()) {
                BitmapUtils.BitmapSampled decodeResult = BitmapUtils.decodeSampledBitmap(this.mContext, this.mUri, this.mWidth, this.mHeight);
                if (!this.isCancelled()) {
                    BitmapUtils.RotateBitmapResult rotateResult = BitmapUtils.rotateBitmapByExif(decodeResult.bitmap, this.mContext, this.mUri);
                    return new Result(this.mUri, rotateResult.bitmap, decodeResult.sampleSize, rotateResult.degrees);
                }
            }
            return null;
        }
        catch (Exception e) {
            return new Result(this.mUri, e);
        }
    }

    protected void onPostExecute(Result result) {
        if (result != null) {
            IEECropImageView cropImageView;
            boolean completeCalled = false;
            if (!this.isCancelled() && (cropImageView = (IEECropImageView)((Object)this.mCropImageViewReference.get())) != null) {
                completeCalled = true;
                cropImageView.onSetImageUriAsyncComplete(result);
            }
            if (!completeCalled && result.bitmap != null) {
                result.bitmap.recycle();
            }
        }
    }

    public static final class Result {
        public final Uri uri;
        public final Bitmap bitmap;
        public final int loadSampleSize;
        public final int degreesRotated;
        public final Exception error;

        Result(Uri uri, Bitmap bitmap, int loadSampleSize, int degreesRotated) {
            this.uri = uri;
            this.bitmap = bitmap;
            this.loadSampleSize = loadSampleSize;
            this.degreesRotated = degreesRotated;
            this.error = null;
        }

        Result(Uri uri, Exception error) {
            this.uri = uri;
            this.bitmap = null;
            this.loadSampleSize = 0;
            this.degreesRotated = 0;
            this.error = error;
        }
    }
}

