/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.filter;

import android.graphics.Bitmap;
import com.droidninja.imageeditengine.filter.PhotoProcessing;
import com.droidninja.imageeditengine.model.ImageFilter;
import com.droidninja.imageeditengine.utils.FilterHelper;
import io.reactivex.Observable;
import io.reactivex.ObservableEmitter;
import io.reactivex.ObservableOnSubscribe;
import io.reactivex.Observer;
import java.util.ArrayList;

public final class GetFiltersObservable {
    private Bitmap srcBitmap;

    public Observable<ArrayList<ImageFilter>> getObservable() {
        new Observable<ArrayList<ImageFilter>>(){

            protected void subscribeActual(Observer<? super ArrayList<ImageFilter>> observer) {
            }
        };
        return 2.create((ObservableOnSubscribe)new ObservableOnSubscribe<ArrayList<ImageFilter>>(){

            public void subscribe(ObservableEmitter<ArrayList<ImageFilter>> emitter) throws Exception {
                FilterHelper filterHelper = new FilterHelper();
                ArrayList<ImageFilter> filters = filterHelper.getFilters();
                for (int index = 0; index < filters.size(); ++index) {
                    ImageFilter imageFilter = filters.get(index);
                    imageFilter.filterImage = PhotoProcessing.filterPhoto(GetFiltersObservable.this.getScaledBitmap(GetFiltersObservable.this.srcBitmap), imageFilter);
                }
                emitter.onNext(filters);
                emitter.onComplete();
            }
        });
    }

    public GetFiltersObservable(Bitmap srcBitmap) {
        this.srcBitmap = srcBitmap;
    }

    private Bitmap getScaledBitmap(Bitmap srcBitmap) {
        int srcWidth = srcBitmap.getWidth();
        int srcHeight = srcBitmap.getHeight();
        int targetWidth = 320;
        int targetHeight = 240;
        if (srcWidth < targetWidth || srcHeight < targetHeight) {
            return srcBitmap;
        }
        float scaleFactor = Math.max((float)srcWidth / (float)targetWidth, (float)srcHeight / (float)targetHeight);
        return Bitmap.createScaledBitmap((Bitmap)srcBitmap, (int)((int)((float)srcWidth / scaleFactor)), (int)((int)((float)srcHeight / scaleFactor)), (boolean)true);
    }
}

