/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.adapters;

import android.content.Context;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.ScaleAnimation;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.RecyclerView;
import com.droidninja.imageeditengine.R;
import com.droidninja.imageeditengine.model.ImageFilter;
import com.droidninja.imageeditengine.utils.Utility;
import java.util.ArrayList;
import java.util.List;

public class FilterImageAdapter
extends RecyclerView.Adapter<ViewHolder> {
    private final FilterImageAdapterListener mListener;
    private List<ImageFilter> imageFilters;
    private int lastCheckedPostion = 0;

    public FilterImageAdapter(ArrayList<ImageFilter> list, FilterImageAdapterListener listener) {
        this.imageFilters = list;
        this.mListener = listener;
    }

    public void setData(List<ImageFilter> stickersList) {
        this.imageFilters = stickersList;
        this.notifyDataSetChanged();
    }

    public void add(int position, ImageFilter item) {
        this.imageFilters.add(position, item);
        this.notifyItemInserted(position);
    }

    public void remove(int position) {
        this.imageFilters.remove(position);
        this.notifyItemRemoved(position);
    }

    public ViewHolder onCreateViewHolder(ViewGroup parent, int viewType) {
        LayoutInflater inflater = LayoutInflater.from((Context)parent.getContext());
        View v = inflater.inflate(R.layout.item_filter_layout, parent, false);
        return new ViewHolder(v);
    }

    public void onBindViewHolder(final ViewHolder holder, int position) {
        final ImageFilter imageFilter = this.imageFilters.get(position);
        Log.i((String)"filter", (String)imageFilter.filterName);
        if (imageFilter.filterImage != null) {
            holder.filterIV.setImageBitmap(imageFilter.filterImage);
        }
        FrameLayout.LayoutParams layoutParams = null;
        if (position == this.lastCheckedPostion) {
            holder.checkbox.setVisibility(0);
            layoutParams = new FrameLayout.LayoutParams(Utility.dpToPx(holder.checkbox.getContext(), 70), Utility.dpToPx(holder.checkbox.getContext(), 110));
        } else {
            holder.checkbox.setVisibility(8);
            layoutParams = new FrameLayout.LayoutParams(Utility.dpToPx(holder.checkbox.getContext(), 64), Utility.dpToPx(holder.checkbox.getContext(), 100));
        }
        holder.filterIV.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        holder.filterTv.setText((CharSequence)imageFilter.filterName);
        holder.itemView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                FilterImageAdapter.this.mListener.onFilterSelected(imageFilter);
                int lastPosition = FilterImageAdapter.this.lastCheckedPostion;
                holder.checkbox.setVisibility(0);
                FrameLayout.LayoutParams layoutParams = new FrameLayout.LayoutParams(Utility.dpToPx(holder.checkbox.getContext(), 70), Utility.dpToPx(holder.checkbox.getContext(), 110));
                holder.filterIV.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
                FilterImageAdapter.this.lastCheckedPostion = holder.getAdapterPosition();
                FilterImageAdapter.this.notifyItemChanged(lastPosition);
            }
        });
    }

    public int getItemCount() {
        return this.imageFilters.size();
    }

    public void scaleView(View v, float startScale, float endScale, int duration) {
        ScaleAnimation anim2 = new ScaleAnimation(startScale, endScale, startScale, endScale, 1, 0.5f, 1, 1.0f);
        anim2.setFillAfter(true);
        anim2.setDuration((long)duration);
        v.startAnimation((Animation)anim2);
    }

    public class ViewHolder
    extends RecyclerView.ViewHolder {
        ImageView filterIV;
        ImageView checkbox;
        TextView filterTv;
        FrameLayout container;

        public ViewHolder(View v) {
            super(v);
            this.filterIV = (ImageView)v.findViewById(R.id.filter_iv);
            this.filterTv = (TextView)v.findViewById(R.id.filter_name);
            this.checkbox = (ImageView)v.findViewById(R.id.check_box);
            this.container = (FrameLayout)v.findViewById(R.id.container);
            this.container.getLayoutTransition().enableTransitionType(4);
        }
    }

    public static interface FilterImageAdapterListener {
        public void onFilterSelected(ImageFilter var1);
    }
}

