/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.widget.Toast;
import com.droidninja.imageeditengine.ImageEditActivity;
import java.io.File;

public class ImageEditor {
    public static final int EDITOR_STICKER = 1;
    public static final int EDITOR_TEXT = 2;
    public static final int EDITOR_PAINT = 3;
    public static final int EDITOR_CROP = 4;
    public static final int EDITOR_FILTERS = 5;
    public static final String EXTRA_STICKER_FOLDER_NAME = "EXTRA_STICKER_FOLDER_NAME";
    public static final String EXTRA_IS_TEXT_MODE = "EXTRA_IS_TEXT_MODE";
    public static final String EXTRA_IS_PAINT_MODE = "EXTRA_IS_PAINT_MODE";
    public static final String EXTRA_IS_STICKER_MODE = "EXTRA_IS_STICKER_MODE";
    public static final String EXTRA_IS_CROP_MODE = "EXTRA_IS_CROP_MODE";
    public static final String EXTRA_HAS_FILTERS = "EXTRA_HAS_FILTERS";
    public static final String EXTRA_IMAGE_PATH = "EXTRA_IMAGE_PATH";
    public static final String EXTRA_ORIGINAL = "EXTRA_ORIGINAL";
    public static final String EXTRA_CROP_RECT = "EXTRA_CROP_RECT";
    public static final String EXTRA_EDITED_PATH = "EXTRA_EDITED_PATH";
    public static final int RC_IMAGE_EDITOR = 52;

    public static class Builder {
        private final String imagePath;
        private Activity context;
        private String stickerFolderName;
        private boolean enabledEditorText = true;
        private boolean enabledEditorPaint = true;
        private boolean enabledEditorSticker = false;
        private boolean enableEditorCrop = false;
        private boolean enableFilters = true;

        public Builder(Activity context, String imagePath) {
            this.context = context;
            this.imagePath = imagePath;
        }

        public Builder setStickerAssets(String folderName) {
            this.stickerFolderName = folderName;
            this.enabledEditorSticker = true;
            return this;
        }

        public Builder disable(int editorType) {
            if (editorType == 2) {
                this.enabledEditorText = false;
            } else if (editorType == 3) {
                this.enabledEditorPaint = false;
            } else if (editorType == 1) {
                this.enabledEditorSticker = false;
            } else if (editorType == 4) {
                this.enableEditorCrop = false;
            } else if (editorType == 5) {
                this.enableFilters = false;
            }
            return this;
        }

        public void open() {
            if (this.imagePath != null && new File(this.imagePath).exists()) {
                Intent intent = new Intent((Context)this.context, ImageEditActivity.class);
                intent.putExtra(ImageEditor.EXTRA_STICKER_FOLDER_NAME, this.stickerFolderName);
                intent.putExtra(ImageEditor.EXTRA_IS_PAINT_MODE, this.enabledEditorPaint);
                intent.putExtra(ImageEditor.EXTRA_IS_STICKER_MODE, this.enabledEditorSticker);
                intent.putExtra(ImageEditor.EXTRA_IS_TEXT_MODE, this.enabledEditorText);
                intent.putExtra(ImageEditor.EXTRA_IS_CROP_MODE, this.enableEditorCrop);
                intent.putExtra(ImageEditor.EXTRA_HAS_FILTERS, this.enableFilters);
                intent.putExtra(ImageEditor.EXTRA_IMAGE_PATH, this.imagePath);
                this.context.startActivityForResult(intent, 52);
            } else {
                Toast.makeText((Context)this.context, (CharSequence)"Invalid image path", (int)0).show();
            }
        }
    }
}

