/*
 * Decompiled with CFR 0.152.
 */
package com.cjt2325.cameralibrary;

import android.animation.Animator;
import android.animation.AnimatorSet;
import android.animation.ObjectAnimator;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.os.SystemClock;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.SurfaceHolder;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.widget.Chronometer;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.VideoView;
import androidx.annotation.RequiresApi;
import com.cjt2325.cameralibrary.CameraInterface;
import com.cjt2325.cameralibrary.CaptureLayout;
import com.cjt2325.cameralibrary.FoucsView;
import com.cjt2325.cameralibrary.R;
import com.cjt2325.cameralibrary.listener.CaptureListener;
import com.cjt2325.cameralibrary.listener.ClickListener;
import com.cjt2325.cameralibrary.listener.ErrorListener;
import com.cjt2325.cameralibrary.listener.JCameraListener;
import com.cjt2325.cameralibrary.listener.RecordStartListener;
import com.cjt2325.cameralibrary.listener.TypeListener;
import com.cjt2325.cameralibrary.state.CameraMachine;
import com.cjt2325.cameralibrary.util.FileUtil;
import com.cjt2325.cameralibrary.util.LogUtil;
import com.cjt2325.cameralibrary.util.ScreenUtils;
import com.cjt2325.cameralibrary.view.CameraView;
import java.io.IOException;

public class JCameraView
extends FrameLayout
implements CameraInterface.CameraOpenOverCallback,
SurfaceHolder.Callback,
CameraView {
    private static final String TAG = "JCameraView";
    private CameraMachine machine;
    private static final int TYPE_FLASH_AUTO = 33;
    private static final int TYPE_FLASH_ON = 34;
    private static final int TYPE_FLASH_OFF = 35;
    private int type_flash = 35;
    public static final int TYPE_PICTURE = 1;
    public static final int TYPE_VIDEO = 2;
    public static final int TYPE_SHORT = 3;
    public static final int TYPE_DEFAULT = 4;
    public static final int MEDIA_QUALITY_HIGH = 2000000;
    public static final int MEDIA_QUALITY_MIDDLE = 1600000;
    public static final int MEDIA_QUALITY_LOW = 1200000;
    public static final int MEDIA_QUALITY_POOR = 800000;
    public static final int MEDIA_QUALITY_FUNNY = 400000;
    public static final int MEDIA_QUALITY_DESPAIR = 200000;
    public static final int MEDIA_QUALITY_SORRY = 80000;
    public static final int BUTTON_STATE_ONLY_CAPTURE = 257;
    public static final int BUTTON_STATE_ONLY_RECORDER = 258;
    public static final int BUTTON_STATE_BOTH = 259;
    private JCameraListener jCameraLisenter;
    private ClickListener leftClickListener;
    private ClickListener rightClickListener;
    private ClickListener pickImageClickListener;
    private RecordStartListener recordStartListener;
    private Context mContext;
    private VideoView mVideoView;
    private ImageView mPhoto;
    private ImageView mSwitchCamera;
    private ImageView mFlashLamp;
    private ImageView pickImage;
    private CaptureLayout mCaptureLayout;
    private Chronometer chronometer;
    private LinearLayout chronometerLayout;
    private ImageView chronometerIcon;
    private FoucsView mFoucsView;
    private MediaPlayer mMediaPlayer;
    private int layout_width;
    private float screenProp = 0.0f;
    private Bitmap captureBitmap;
    private Bitmap firstFrame;
    private String videoUrl;
    private int iconSize = 0;
    private int iconMargin = 0;
    private int iconSrc;
    private int iconLeft = 0;
    private int iconRight = 0;
    private int duration = 0;
    private int zoomGradient = 0;
    private boolean firstTouch = true;
    private boolean isPickImageButtonEnabled = false;
    private float firstTouchLength = 0.0f;
    AlphaAnimation alphaAnimation1;
    AlphaAnimation alphaAnimation2;
    private ErrorListener errorLisenter;

    public JCameraView(Context context) {
        this(context, null);
    }

    public JCameraView(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public JCameraView(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mContext = context;
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.JCameraView, defStyleAttr, 0);
        this.iconSize = a.getDimensionPixelSize(R.styleable.JCameraView_iconSize, (int)TypedValue.applyDimension((int)2, (float)35.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconMargin = a.getDimensionPixelSize(R.styleable.JCameraView_iconMargin, (int)TypedValue.applyDimension((int)2, (float)15.0f, (DisplayMetrics)this.getResources().getDisplayMetrics()));
        this.iconSrc = a.getResourceId(R.styleable.JCameraView_iconSrc, R.drawable.ic_switch_camera);
        this.iconLeft = a.getResourceId(R.styleable.JCameraView_iconLeft, 0);
        this.iconRight = a.getResourceId(R.styleable.JCameraView_iconRight, 0);
        this.duration = a.getInteger(R.styleable.JCameraView_duration_max, 10000);
        a.recycle();
        this.initData();
        this.initView();
    }

    private void initData() {
        this.layout_width = ScreenUtils.getScreenWidth(this.mContext);
        this.zoomGradient = (int)((float)this.layout_width / 16.0f);
        LogUtil.i("zoom = " + this.zoomGradient);
        this.machine = new CameraMachine(this.getContext(), this, this);
    }

    private void initView() {
        this.setWillNotDraw(false);
        View view = LayoutInflater.from((Context)this.mContext).inflate(R.layout.camera_view, (ViewGroup)this);
        this.mVideoView = (VideoView)view.findViewById(R.id.video_preview);
        this.mPhoto = (ImageView)view.findViewById(R.id.image_photo);
        this.mSwitchCamera = (ImageView)view.findViewById(R.id.image_switch);
        this.mSwitchCamera.setImageResource(this.iconSrc);
        this.mFlashLamp = (ImageView)view.findViewById(R.id.image_flash);
        this.pickImage = (ImageView)this.findViewById(R.id.pick_image);
        this.chronometer = (Chronometer)this.findViewById(R.id.chronometer);
        this.chronometerLayout = (LinearLayout)this.findViewById(R.id.chronometer_layout);
        this.chronometerIcon = (ImageView)this.findViewById(R.id.chronometer_icon);
        this.setFlashRes();
        this.mFlashLamp.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                JCameraView.this.type_flash++;
                if (JCameraView.this.type_flash > 35) {
                    JCameraView.this.type_flash = 33;
                }
                JCameraView.this.setFlashRes();
            }
        });
        this.mCaptureLayout = (CaptureLayout)view.findViewById(R.id.capture_layout);
        this.mCaptureLayout.setDuration(this.duration);
        this.mCaptureLayout.setIconSrc(this.iconLeft, this.iconRight);
        this.mFoucsView = (FoucsView)view.findViewById(R.id.fouce_view);
        this.mVideoView.getHolder().addCallback((SurfaceHolder.Callback)this);
        this.mSwitchCamera.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                JCameraView.this.machine.swtich(JCameraView.this.mVideoView.getHolder(), JCameraView.this.screenProp);
            }
        });
        this.mCaptureLayout.setCaptureLisenter(new CaptureListener(){

            @Override
            public void takePictures() {
                JCameraView.this.mSwitchCamera.setVisibility(4);
                JCameraView.this.mFlashLamp.setVisibility(4);
                if (JCameraView.this.isPickImageButtonEnabled) {
                    JCameraView.this.pickImage.setVisibility(4);
                }
                JCameraView.this.machine.capture();
            }

            @Override
            public void recordStart() {
                JCameraView.this.mSwitchCamera.setVisibility(4);
                JCameraView.this.mFlashLamp.setVisibility(4);
                if (JCameraView.this.isPickImageButtonEnabled) {
                    JCameraView.this.pickImage.setVisibility(4);
                }
                JCameraView.this.machine.record(JCameraView.this.mVideoView.getHolder().getSurface(), JCameraView.this.screenProp);
                JCameraView.this.chronometerLayout.setVisibility(0);
                JCameraView.this.chronometer.setBase(SystemClock.elapsedRealtime());
                JCameraView.this.chronometer.start();
                JCameraView.this.animateChronometerIcon();
            }

            @Override
            public void recordShort(final long time) {
                JCameraView.this.mCaptureLayout.setTextWithAnimation("Time is too Short");
                JCameraView.this.mSwitchCamera.setVisibility(0);
                JCameraView.this.mFlashLamp.setVisibility(0);
                if (JCameraView.this.isPickImageButtonEnabled) {
                    JCameraView.this.pickImage.setVisibility(0);
                }
                JCameraView.this.chronometerLayout.setVisibility(8);
                JCameraView.this.stopChronometer();
                JCameraView.this.postDelayed(new Runnable(){

                    @Override
                    public void run() {
                        JCameraView.this.machine.stopRecord(true, time);
                    }
                }, 1500L - time);
            }

            @Override
            public void recordEnd(long time) {
                JCameraView.this.machine.stopRecord(false, time);
                JCameraView.this.stopChronometer();
            }

            @Override
            public void recordZoom(float zoom) {
                LogUtil.i("recordZoom");
                JCameraView.this.machine.zoom(zoom, 144);
            }

            @Override
            public void recordError() {
                if (JCameraView.this.errorLisenter != null) {
                    JCameraView.this.errorLisenter.AudioPermissionError();
                }
                JCameraView.this.stopChronometer();
            }
        });
        this.mCaptureLayout.setTypeLisenter(new TypeListener(){

            @Override
            public void cancel() {
                JCameraView.this.machine.cancle(JCameraView.this.mVideoView.getHolder(), JCameraView.this.screenProp);
                JCameraView.this.chronometerLayout.setVisibility(8);
                JCameraView.this.chronometer.setText((CharSequence)"00:00");
                JCameraView.this.stopChronometer();
            }

            @Override
            public void confirm() {
                JCameraView.this.machine.confirm();
            }
        });
        this.mCaptureLayout.setLeftClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (JCameraView.this.leftClickListener != null) {
                    JCameraView.this.leftClickListener.onClick();
                }
            }
        });
        this.mCaptureLayout.setRightClickListener(new ClickListener(){

            @Override
            public void onClick() {
                if (JCameraView.this.rightClickListener != null) {
                    JCameraView.this.rightClickListener.onClick();
                }
            }
        });
        this.pickImage.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (JCameraView.this.pickImageClickListener != null) {
                    JCameraView.this.pickImageClickListener.onClick();
                }
            }
        });
    }

    private void stopChronometer() {
        this.chronometer.stop();
        this.clearAlphaAnimation();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        float widthSize = this.mVideoView.getMeasuredWidth();
        float heightSize = this.mVideoView.getMeasuredHeight();
        if (this.screenProp == 0.0f) {
            this.screenProp = heightSize / widthSize;
        }
    }

    @Override
    public void cameraHasOpened() {
        CameraInterface.getInstance().doStartPreview(this.mVideoView.getHolder(), this.screenProp);
    }

    public void onResume() {
        LogUtil.i("JCameraView onResume");
        this.resetState(4);
        CameraInterface.getInstance().registerSensorManager(this.mContext);
        CameraInterface.getInstance().setSwitchView(this.mSwitchCamera, this.mFlashLamp);
        this.machine.start(this.mVideoView.getHolder(), this.screenProp);
    }

    public void onPause() {
        LogUtil.i("JCameraView onPause");
        this.stopVideo();
        this.resetState(1);
        CameraInterface.getInstance().isPreview(false);
        CameraInterface.getInstance().unregisterSensorManager(this.mContext);
    }

    public void surfaceCreated(SurfaceHolder holder) {
        LogUtil.i("JCameraView SurfaceCreated");
        new Thread(){

            @Override
            public void run() {
                CameraInterface.getInstance().doOpenCamera(JCameraView.this);
            }
        }.start();
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        LogUtil.i("JCameraView SurfaceDestroyed");
        CameraInterface.getInstance().doDestroyCamera();
    }

    public boolean onTouchEvent(MotionEvent event) {
        switch (event.getAction()) {
            case 0: {
                if (event.getPointerCount() == 1) {
                    this.setFocusViewWidthAnimation(event.getX(), event.getY());
                }
                if (event.getPointerCount() != 2) break;
                Log.i((String)"CJT", (String)"ACTION_DOWN = 2");
                break;
            }
            case 2: {
                if (event.getPointerCount() == 1) {
                    this.firstTouch = true;
                }
                if (event.getPointerCount() != 2) break;
                float point_1_X = event.getX(0);
                float point_1_Y = event.getY(0);
                float point_2_X = event.getX(1);
                float point_2_Y = event.getY(1);
                float result = (float)Math.sqrt(Math.pow(point_1_X - point_2_X, 2.0) + Math.pow(point_1_Y - point_2_Y, 2.0));
                if (this.firstTouch) {
                    this.firstTouchLength = result;
                    this.firstTouch = false;
                }
                if ((int)(result - this.firstTouchLength) / this.zoomGradient == 0) break;
                this.firstTouch = true;
                this.machine.zoom(result - this.firstTouchLength, 145);
                break;
            }
            case 1: {
                this.firstTouch = true;
            }
        }
        return true;
    }

    private void setFocusViewWidthAnimation(float x, float y) {
        this.machine.foucs(x, y, new CameraInterface.FocusCallback(){

            @Override
            public void focusSuccess() {
                JCameraView.this.mFoucsView.setVisibility(4);
            }
        });
    }

    private void updateVideoViewSize(float videoWidth, float videoHeight) {
        if (videoWidth > videoHeight) {
            int height = (int)(videoHeight / videoWidth * (float)this.getWidth());
            FrameLayout.LayoutParams videoViewParam = new FrameLayout.LayoutParams(-1, height);
            videoViewParam.gravity = 17;
            this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)videoViewParam);
        }
    }

    public void setSaveVideoPath(String path) {
        CameraInterface.getInstance().setSaveVideoPath(path);
    }

    public void setJCameraLisenter(JCameraListener jCameraLisenter) {
        this.jCameraLisenter = jCameraLisenter;
    }

    public void setErrorLisenter(ErrorListener errorLisenter) {
        this.errorLisenter = errorLisenter;
        CameraInterface.getInstance().setErrorLinsenter(errorLisenter);
    }

    public void setRecordStartListener(RecordStartListener recordStartListener) {
        this.recordStartListener = recordStartListener;
    }

    public void setFeatures(int state) {
        this.mCaptureLayout.setButtonFeatures(state);
    }

    public void setMediaQuality(int quality) {
        CameraInterface.getInstance().setMediaQuality(quality);
    }

    @Override
    public void resetState(int type) {
        switch (type) {
            case 2: {
                this.stopVideo();
                FileUtil.deleteFile(this.videoUrl);
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.machine.start(this.mVideoView.getHolder(), this.screenProp);
                break;
            }
            case 1: {
                this.mPhoto.setVisibility(4);
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
            }
        }
        this.mSwitchCamera.setVisibility(0);
        this.mFlashLamp.setVisibility(0);
        if (this.isPickImageButtonEnabled) {
            this.pickImage.setVisibility(0);
        }
        this.mCaptureLayout.resetCaptureLayout();
    }

    @Override
    public void confirmState(int type) {
        switch (type) {
            case 2: {
                this.stopVideo();
                this.mVideoView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
                this.machine.start(this.mVideoView.getHolder(), this.screenProp);
                if (this.jCameraLisenter == null) break;
                this.jCameraLisenter.recordSuccess(this.videoUrl, this.firstFrame);
                break;
            }
            case 1: {
                this.mPhoto.setVisibility(4);
                if (this.jCameraLisenter == null) break;
                this.jCameraLisenter.captureSuccess(this.captureBitmap);
                break;
            }
            case 3: {
                break;
            }
        }
        this.mCaptureLayout.resetCaptureLayout();
    }

    @Override
    public void showPicture(Bitmap bitmap, boolean isVertical) {
        if (isVertical) {
            this.mPhoto.setScaleType(ImageView.ScaleType.FIT_XY);
        } else {
            this.mPhoto.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
        this.captureBitmap = bitmap;
        this.mPhoto.setImageBitmap(bitmap);
        this.mPhoto.setVisibility(0);
        this.mCaptureLayout.startAlphaAnimation();
        this.mCaptureLayout.startTypeBtnAnimator();
    }

    @Override
    public void playVideo(Bitmap firstFrame, final String url) {
        this.videoUrl = url;
        this.firstFrame = firstFrame;
        new Thread(new Runnable(){

            @Override
            @RequiresApi(api=16)
            public void run() {
                try {
                    if (JCameraView.this.mMediaPlayer == null) {
                        JCameraView.this.mMediaPlayer = new MediaPlayer();
                    } else {
                        JCameraView.this.mMediaPlayer.reset();
                    }
                    JCameraView.this.mMediaPlayer.setDataSource(url);
                    JCameraView.this.mMediaPlayer.setSurface(JCameraView.this.mVideoView.getHolder().getSurface());
                    JCameraView.this.mMediaPlayer.setVideoScalingMode(1);
                    JCameraView.this.mMediaPlayer.setAudioStreamType(3);
                    JCameraView.this.mMediaPlayer.setOnVideoSizeChangedListener(new MediaPlayer.OnVideoSizeChangedListener(){

                        public void onVideoSizeChanged(MediaPlayer mp, int width, int height) {
                            JCameraView.this.updateVideoViewSize(JCameraView.this.mMediaPlayer.getVideoWidth(), JCameraView.this.mMediaPlayer.getVideoHeight());
                        }
                    });
                    JCameraView.this.mMediaPlayer.setOnPreparedListener(new MediaPlayer.OnPreparedListener(){

                        public void onPrepared(MediaPlayer mp) {
                            JCameraView.this.mMediaPlayer.start();
                        }
                    });
                    JCameraView.this.mMediaPlayer.setLooping(true);
                    JCameraView.this.mMediaPlayer.prepare();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }).start();
    }

    @Override
    public void stopVideo() {
        if (this.mMediaPlayer != null && this.mMediaPlayer.isPlaying()) {
            this.mMediaPlayer.stop();
            this.mMediaPlayer.release();
            this.mMediaPlayer = null;
            if (this.recordStartListener != null) {
                this.recordStartListener.onStop();
            }
        }
    }

    @Override
    public void setTip(String tip) {
        this.mCaptureLayout.setTip(tip);
    }

    @Override
    public void startPreviewCallback() {
        LogUtil.i("startPreviewCallback");
        this.handlerFoucs(this.mFoucsView.getWidth() / 2, this.mFoucsView.getHeight() / 2);
    }

    @Override
    public boolean handlerFoucs(float x, float y) {
        if (y > (float)this.mCaptureLayout.getTop()) {
            return false;
        }
        this.mFoucsView.setVisibility(0);
        if (x < (float)(this.mFoucsView.getWidth() / 2)) {
            x = this.mFoucsView.getWidth() / 2;
        }
        if (x > (float)(this.layout_width - this.mFoucsView.getWidth() / 2)) {
            x = this.layout_width - this.mFoucsView.getWidth() / 2;
        }
        if (y < (float)(this.mFoucsView.getWidth() / 2)) {
            y = this.mFoucsView.getWidth() / 2;
        }
        if (y > (float)(this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2)) {
            y = this.mCaptureLayout.getTop() - this.mFoucsView.getWidth() / 2;
        }
        this.mFoucsView.setX(x - (float)(this.mFoucsView.getWidth() / 2));
        this.mFoucsView.setY(y - (float)(this.mFoucsView.getHeight() / 2));
        ObjectAnimator scaleX = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleX", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator scaleY = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"scaleY", (float[])new float[]{1.0f, 0.6f});
        ObjectAnimator alpha = ObjectAnimator.ofFloat((Object)((Object)this.mFoucsView), (String)"alpha", (float[])new float[]{1.0f, 0.4f, 1.0f, 0.4f, 1.0f, 0.4f, 1.0f});
        AnimatorSet animSet = new AnimatorSet();
        animSet.play((Animator)scaleX).with((Animator)scaleY).before((Animator)alpha);
        animSet.setDuration(400L);
        animSet.start();
        return true;
    }

    public void setLeftClickListener(ClickListener clickListener) {
        this.leftClickListener = clickListener;
    }

    public void setRightClickListener(ClickListener clickListener) {
        this.rightClickListener = clickListener;
    }

    public void setPickImageListener(ClickListener pickImageClickListener) {
        this.pickImageClickListener = pickImageClickListener;
    }

    public void showPickImageButton() {
        this.isPickImageButtonEnabled = true;
        if (this.pickImage != null) {
            this.pickImage.setVisibility(0);
        }
    }

    private void setFlashRes() {
        switch (this.type_flash) {
            case 33: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_auto);
                this.machine.flash("auto");
                break;
            }
            case 34: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_on);
                this.machine.flash("on");
                break;
            }
            case 35: {
                this.mFlashLamp.setImageResource(R.drawable.ic_flash_off);
                this.machine.flash("off");
            }
        }
    }

    private void animateChronometerIcon() {
        this.alphaAnimation1 = new AlphaAnimation(0.0f, 1.0f);
        this.alphaAnimation1.setDuration(800L);
        this.alphaAnimation1.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation arg0) {
                JCameraView.this.chronometerIcon.startAnimation((Animation)JCameraView.this.alphaAnimation2);
            }

            public void onAnimationRepeat(Animation arg0) {
            }

            public void onAnimationStart(Animation arg0) {
            }
        });
        this.alphaAnimation2 = new AlphaAnimation(1.0f, 0.0f);
        this.alphaAnimation2.setDuration(800L);
        this.alphaAnimation2.setAnimationListener(new Animation.AnimationListener(){

            public void onAnimationEnd(Animation arg0) {
                JCameraView.this.chronometerIcon.startAnimation((Animation)JCameraView.this.alphaAnimation1);
            }

            public void onAnimationRepeat(Animation arg0) {
            }

            public void onAnimationStart(Animation arg0) {
            }
        });
        this.chronometerIcon.startAnimation((Animation)this.alphaAnimation1);
    }

    private void clearAlphaAnimation() {
        if (this.alphaAnimation1 == null || this.alphaAnimation2 == null) {
            return;
        }
        this.alphaAnimation1.cancel();
        this.alphaAnimation1.reset();
        this.alphaAnimation1.setAnimationListener(null);
        this.alphaAnimation2.cancel();
        this.alphaAnimation2.reset();
        this.alphaAnimation2.setAnimationListener(null);
        this.chronometerIcon.clearAnimation();
    }
}

