/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views.imagezoom.utils;

import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.os.ParcelFileDescriptor;
import java.io.Closeable;

public class IOUtils {
    public static void closeSilently(Closeable c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeSilently(ParcelFileDescriptor c) {
        if (c == null) {
            return;
        }
        try {
            c.close();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void closeSilently(Cursor cursor) {
        if (cursor == null) {
            return;
        }
        try {
            if (cursor != null) {
                cursor.close();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static String getRealFilePath(Context context, Uri uri) {
        Cursor cursor;
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        String data = null;
        if (scheme == null) {
            data = uri.getPath();
        } else if ("file".equals(scheme)) {
            data = uri.getPath();
        } else if ("content".equals(scheme) && null != (cursor = context.getContentResolver().query(uri, new String[]{"_data"}, null, null, null))) {
            int index;
            if (cursor.moveToFirst() && (index = cursor.getColumnIndex("_data")) > -1) {
                data = cursor.getString(index);
            }
            cursor.close();
        }
        return data;
    }
}

