/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views.imagezoom.utils;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import com.droidninja.imageeditengine.views.imagezoom.utils.BitmapUtils;
import com.droidninja.imageeditengine.views.imagezoom.utils.ExifUtils;
import com.droidninja.imageeditengine.views.imagezoom.utils.IOUtils;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;

public class DecodeUtils {
    public static Bitmap decode(Context context, Uri uri, int maxW, int maxH) {
        InputStream stream = DecodeUtils.openInputStream(context, uri);
        if (null == stream) {
            return null;
        }
        int orientation = ExifUtils.getExifOrientation(context, uri);
        Bitmap bitmap = null;
        int[] imageSize = new int[2];
        boolean decoded = DecodeUtils.decodeImageBounds(stream, imageSize);
        IOUtils.closeSilently(stream);
        if (decoded) {
            int sampleSize = maxW < 0 || maxH < 0 ? 1 : DecodeUtils.computeSampleSize(imageSize[0], imageSize[1], (int)((double)maxW * 1.2), (int)((double)maxH * 1.2), orientation);
            BitmapFactory.Options options = DecodeUtils.getDefaultOptions();
            options.inSampleSize = sampleSize;
            bitmap = DecodeUtils.decodeBitmap(context, uri, options, maxW, maxH, orientation, 0);
        }
        return bitmap;
    }

    static Bitmap decodeBitmap(Context context, Uri uri, BitmapFactory.Options options, int maxW, int maxH, int orientation, int pass) {
        Bitmap bitmap = null;
        Bitmap newBitmap = null;
        if (pass > 20) {
            return null;
        }
        InputStream stream = DecodeUtils.openInputStream(context, uri);
        if (null == stream) {
            return null;
        }
        try {
            bitmap = BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
            IOUtils.closeSilently(stream);
            if (bitmap != null && maxW > 0 && maxH > 0) {
                newBitmap = BitmapUtils.resizeBitmap(bitmap, maxW, maxH, orientation);
                if (bitmap != newBitmap) {
                    bitmap.recycle();
                }
                bitmap = newBitmap;
            }
        }
        catch (OutOfMemoryError error) {
            IOUtils.closeSilently(stream);
            if (null != bitmap) {
                bitmap.recycle();
            }
            ++options.inSampleSize;
            bitmap = DecodeUtils.decodeBitmap(context, uri, options, maxW, maxH, orientation, pass + 1);
        }
        return bitmap;
    }

    public static InputStream openInputStream(Context context, Uri uri) {
        if (null == uri) {
            return null;
        }
        String scheme = uri.getScheme();
        InputStream stream = null;
        if (scheme == null || "file".equals(scheme)) {
            stream = DecodeUtils.openFileInputStream(uri.getPath());
        } else if ("content".equals(scheme)) {
            stream = DecodeUtils.openContentInputStream(context, uri);
        } else if ("http".equals(scheme) || "https".equals(scheme)) {
            stream = DecodeUtils.openRemoteInputStream(uri);
        }
        return stream;
    }

    public static boolean decodeImageBounds(InputStream stream, int[] outSize) {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream((InputStream)stream, null, (BitmapFactory.Options)options);
        if (options.outHeight > 0 && options.outWidth > 0) {
            outSize[0] = options.outWidth;
            outSize[1] = options.outHeight;
            return true;
        }
        return false;
    }

    private static int computeSampleSize(int bitmapW, int bitmapH, int maxW, int maxH, int orientation) {
        double h;
        double w;
        if (orientation == 0 || orientation == 180) {
            w = bitmapW;
            h = bitmapH;
        } else {
            w = bitmapH;
            h = bitmapW;
        }
        int sampleSize = (int)Math.ceil(Math.max(w / (double)maxW, h / (double)maxH));
        return sampleSize;
    }

    static InputStream openFileInputStream(String path) {
        try {
            return new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static InputStream openContentInputStream(Context context, Uri uri) {
        try {
            return context.getContentResolver().openInputStream(uri);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return null;
        }
    }

    static InputStream openRemoteInputStream(Uri uri) {
        int code;
        HttpURLConnection connection;
        URL finalUrl;
        try {
            finalUrl = new URL(uri.toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
            return null;
        }
        try {
            connection = (HttpURLConnection)finalUrl.openConnection();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        connection.setInstanceFollowRedirects(false);
        try {
            code = connection.getResponseCode();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        if (code == 301 || code == 302 || code == 303) {
            String newLocation = connection.getHeaderField("Location");
            return DecodeUtils.openRemoteInputStream(Uri.parse((String)newLocation));
        }
        try {
            return (InputStream)finalUrl.getContent();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    static BitmapFactory.Options getDefaultOptions() {
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inScaled = false;
        options.inPreferredConfig = Bitmap.Config.ARGB_8888;
        options.inDither = false;
        options.inJustDecodeBounds = false;
        options.inPurgeable = true;
        options.inInputShareable = true;
        options.inTempStorage = new byte[16384];
        return options;
    }
}

