/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.views.imagezoom;

import android.annotation.SuppressLint;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Matrix;
import android.graphics.PointF;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.ImageView;
import androidx.appcompat.widget.AppCompatImageView;
import com.droidninja.imageeditengine.views.imagezoom.easing.Cubic;
import com.droidninja.imageeditengine.views.imagezoom.easing.Easing;
import com.droidninja.imageeditengine.views.imagezoom.graphic.FastBitmapDrawable;
import com.droidninja.imageeditengine.views.imagezoom.utils.IDisposable;

public abstract class ImageViewTouchBase
extends AppCompatImageView
implements IDisposable {
    public static final String LOG_TAG = "ImageViewTouchBase";
    protected static final boolean LOG_ENABLED = false;
    public static final float ZOOM_INVALID = -1.0f;
    protected Easing mEasing = new Cubic();
    protected Matrix mBaseMatrix = new Matrix();
    protected Matrix mSuppMatrix = new Matrix();
    protected Matrix mNextMatrix;
    protected Handler mHandler = new Handler();
    protected Runnable mLayoutRunnable = null;
    protected boolean mUserScaled = false;
    private float mMaxZoom = -1.0f;
    private float mMinZoom = -1.0f;
    private boolean mMaxZoomDefined;
    private boolean mMinZoomDefined;
    protected final Matrix mDisplayMatrix = new Matrix();
    protected final float[] mMatrixValues = new float[9];
    private int mThisWidth = -1;
    private int mThisHeight = -1;
    private PointF mCenter = new PointF();
    protected DisplayType mScaleType = DisplayType.NONE;
    private boolean mScaleTypeChanged;
    private boolean mBitmapChanged;
    protected final int DEFAULT_ANIMATION_DURATION = 200;
    protected RectF mBitmapRect = new RectF();
    protected RectF mCenterRect = new RectF();
    protected RectF mScrollRect = new RectF();
    private OnDrawableChangeListener mDrawableChangeListener;
    private OnLayoutChangeListener mOnLayoutChangeListener;

    public ImageViewTouchBase(Context context) {
        super(context);
        this.init();
    }

    public ImageViewTouchBase(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public void setOnDrawableChangedListener(OnDrawableChangeListener listener) {
        this.mDrawableChangeListener = listener;
    }

    public void setOnLayoutChangeListener(OnLayoutChangeListener listener) {
        this.mOnLayoutChangeListener = listener;
    }

    protected void init() {
        this.setScaleType(ImageView.ScaleType.MATRIX);
    }

    public void setScaleType(ImageView.ScaleType scaleType) {
        if (scaleType == ImageView.ScaleType.MATRIX) {
            super.setScaleType(scaleType);
        } else {
            Log.w((String)LOG_TAG, (String)"Unsupported scaletype. Only MATRIX can be used");
        }
    }

    public void clear() {
        this.setImageBitmap(null);
    }

    public void setDisplayType(DisplayType type) {
        if (type != this.mScaleType) {
            this.mUserScaled = false;
            this.mScaleType = type;
            this.mScaleTypeChanged = true;
            this.requestLayout();
        }
    }

    public DisplayType getDisplayType() {
        return this.mScaleType;
    }

    protected void setMinScale(float value) {
        this.mMinZoom = value;
    }

    protected void setMaxScale(float value) {
        this.mMaxZoom = value;
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        Drawable drawable2;
        Runnable r;
        super.onLayout(changed, left, top, right, bottom);
        int deltaX = 0;
        int deltaY = 0;
        if (changed) {
            int oldw = this.mThisWidth;
            int oldh = this.mThisHeight;
            this.mThisWidth = right - left;
            this.mThisHeight = bottom - top;
            deltaX = this.mThisWidth - oldw;
            deltaY = this.mThisHeight - oldh;
            this.mCenter.x = (float)this.mThisWidth / 2.0f;
            this.mCenter.y = (float)this.mThisHeight / 2.0f;
        }
        if ((r = this.mLayoutRunnable) != null) {
            this.mLayoutRunnable = null;
            r.run();
        }
        if ((drawable2 = this.getDrawable()) != null) {
            if (changed || this.mScaleTypeChanged || this.mBitmapChanged) {
                float scale = 1.0f;
                float old_default_scale = this.getDefaultScale(this.mScaleType);
                float old_matrix_scale = this.getScale(this.mBaseMatrix);
                float old_scale = this.getScale();
                float old_min_scale = Math.min(1.0f, 1.0f / old_matrix_scale);
                this.getProperBaseMatrix(drawable2, this.mBaseMatrix);
                float new_matrix_scale = this.getScale(this.mBaseMatrix);
                if (this.mBitmapChanged || this.mScaleTypeChanged) {
                    if (this.mNextMatrix != null) {
                        this.mSuppMatrix.set(this.mNextMatrix);
                        this.mNextMatrix = null;
                        scale = this.getScale();
                    } else {
                        this.mSuppMatrix.reset();
                        scale = this.getDefaultScale(this.mScaleType);
                    }
                    this.setImageMatrix(this.getImageViewMatrix());
                    if (scale != this.getScale()) {
                        this.zoomTo(scale);
                    }
                } else if (changed) {
                    if (!this.mMinZoomDefined) {
                        this.mMinZoom = -1.0f;
                    }
                    if (!this.mMaxZoomDefined) {
                        this.mMaxZoom = -1.0f;
                    }
                    this.setImageMatrix(this.getImageViewMatrix());
                    this.postTranslate(-deltaX, -deltaY);
                    if (!this.mUserScaled) {
                        scale = this.getDefaultScale(this.mScaleType);
                        this.zoomTo(scale);
                    } else {
                        if ((double)Math.abs(old_scale - old_min_scale) > 0.001) {
                            scale = old_matrix_scale / new_matrix_scale * old_scale;
                        }
                        this.zoomTo(scale);
                    }
                }
                this.mUserScaled = false;
                if (scale > this.getMaxScale() || scale < this.getMinScale()) {
                    this.zoomTo(scale);
                }
                this.center(true, true);
                if (this.mBitmapChanged) {
                    this.onDrawableChanged(drawable2);
                }
                if (changed || this.mBitmapChanged || this.mScaleTypeChanged) {
                    this.onLayoutChanged(left, top, right, bottom);
                }
                if (this.mScaleTypeChanged) {
                    this.mScaleTypeChanged = false;
                }
                if (this.mBitmapChanged) {
                    this.mBitmapChanged = false;
                }
            }
        } else {
            if (this.mBitmapChanged) {
                this.onDrawableChanged(drawable2);
            }
            if (changed || this.mBitmapChanged || this.mScaleTypeChanged) {
                this.onLayoutChanged(left, top, right, bottom);
            }
            if (this.mBitmapChanged) {
                this.mBitmapChanged = false;
            }
            if (this.mScaleTypeChanged) {
                this.mScaleTypeChanged = false;
            }
        }
    }

    public void resetDisplay() {
        this.mBitmapChanged = true;
        this.requestLayout();
    }

    protected float getDefaultScale(DisplayType type) {
        if (type == DisplayType.FIT_TO_SCREEN) {
            return 1.0f;
        }
        if (type == DisplayType.FIT_IF_BIGGER) {
            return Math.min(1.0f, 1.0f / this.getScale(this.mBaseMatrix));
        }
        return 1.0f / this.getScale(this.mBaseMatrix);
    }

    public void setImageResource(int resId) {
        this.setImageDrawable(this.getContext().getResources().getDrawable(resId));
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.setImageBitmap(bitmap, null, -1.0f, -1.0f);
    }

    public void setImageBitmap(Bitmap bitmap, Matrix matrix, float min_zoom, float max_zoom) {
        if (bitmap != null) {
            this.setImageDrawable(new FastBitmapDrawable(bitmap), matrix, min_zoom, max_zoom);
        } else {
            this.setImageDrawable(null, matrix, min_zoom, max_zoom);
        }
    }

    public void setImageDrawable(Drawable drawable2) {
        this.setImageDrawable(drawable2, null, -1.0f, -1.0f);
    }

    public void setImageDrawable(final Drawable drawable2, final Matrix initial_matrix, final float min_zoom, final float max_zoom) {
        int viewWidth = this.getWidth();
        if (viewWidth <= 0) {
            this.mLayoutRunnable = new Runnable(){

                @Override
                public void run() {
                    ImageViewTouchBase.this.setImageDrawable(drawable2, initial_matrix, min_zoom, max_zoom);
                }
            };
            return;
        }
        this._setImageDrawable(drawable2, initial_matrix, min_zoom, max_zoom);
    }

    protected void _setImageDrawable(Drawable drawable2, Matrix initial_matrix, float min_zoom, float max_zoom) {
        if (drawable2 != null) {
            super.setImageDrawable(drawable2);
        } else {
            this.mBaseMatrix.reset();
            super.setImageDrawable(null);
        }
        if (min_zoom != -1.0f && max_zoom != -1.0f) {
            min_zoom = Math.min(min_zoom, max_zoom);
            max_zoom = Math.max(min_zoom, max_zoom);
            this.mMinZoom = min_zoom;
            this.mMaxZoom = max_zoom;
            this.mMinZoomDefined = true;
            this.mMaxZoomDefined = true;
            if (this.mScaleType == DisplayType.FIT_TO_SCREEN || this.mScaleType == DisplayType.FIT_IF_BIGGER) {
                if (this.mMinZoom >= 1.0f) {
                    this.mMinZoomDefined = false;
                    this.mMinZoom = -1.0f;
                }
                if (this.mMaxZoom <= 1.0f) {
                    this.mMaxZoomDefined = true;
                    this.mMaxZoom = -1.0f;
                }
            }
        } else {
            this.mMinZoom = -1.0f;
            this.mMaxZoom = -1.0f;
            this.mMinZoomDefined = false;
            this.mMaxZoomDefined = false;
        }
        if (initial_matrix != null) {
            this.mNextMatrix = new Matrix(initial_matrix);
        }
        this.mBitmapChanged = true;
        this.requestLayout();
    }

    protected void onDrawableChanged(Drawable drawable2) {
        this.fireOnDrawableChangeListener(drawable2);
    }

    protected void fireOnLayoutChangeListener(int left, int top, int right, int bottom) {
        if (null != this.mOnLayoutChangeListener) {
            this.mOnLayoutChangeListener.onLayoutChanged(true, left, top, right, bottom);
        }
    }

    protected void fireOnDrawableChangeListener(Drawable drawable2) {
        if (null != this.mDrawableChangeListener) {
            this.mDrawableChangeListener.onDrawableChanged(drawable2);
        }
    }

    protected void onLayoutChanged(int left, int top, int right, int bottom) {
        this.fireOnLayoutChangeListener(left, top, right, bottom);
    }

    protected float computeMaxZoom() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return 1.0f;
        }
        float fw = (float)drawable2.getIntrinsicWidth() / (float)this.mThisWidth;
        float fh = (float)drawable2.getIntrinsicHeight() / (float)this.mThisHeight;
        float scale = Math.max(fw, fh) * 8.0f;
        return scale;
    }

    protected float computeMinZoom() {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return 1.0f;
        }
        float scale = this.getScale(this.mBaseMatrix);
        scale = Math.min(1.0f, 1.0f / scale);
        return scale;
    }

    public float getMaxScale() {
        if (this.mMaxZoom == -1.0f) {
            this.mMaxZoom = this.computeMaxZoom();
        }
        return this.mMaxZoom;
    }

    public float getMinScale() {
        if (this.mMinZoom == -1.0f) {
            this.mMinZoom = this.computeMinZoom();
        }
        return this.mMinZoom;
    }

    public Matrix getImageViewMatrix() {
        return this.getImageViewMatrix(this.mSuppMatrix);
    }

    public Matrix getImageViewMatrix(Matrix supportMatrix) {
        this.mDisplayMatrix.set(this.mBaseMatrix);
        this.mDisplayMatrix.postConcat(supportMatrix);
        return this.mDisplayMatrix;
    }

    public void setImageMatrix(Matrix matrix) {
        Matrix current = this.getImageMatrix();
        boolean needUpdate = false;
        if (matrix == null && !current.isIdentity() || matrix != null && !current.equals((Object)matrix)) {
            needUpdate = true;
        }
        super.setImageMatrix(matrix);
        if (needUpdate) {
            this.onImageMatrixChanged();
        }
    }

    protected void onImageMatrixChanged() {
    }

    public Matrix getDisplayMatrix() {
        return new Matrix(this.mSuppMatrix);
    }

    protected void getProperBaseMatrix(Drawable drawable2, Matrix matrix) {
        float viewWidth = this.mThisWidth;
        float viewHeight = this.mThisHeight;
        float w = drawable2.getIntrinsicWidth();
        float h = drawable2.getIntrinsicHeight();
        matrix.reset();
        if (w > viewWidth || h > viewHeight) {
            float widthScale = viewWidth / w;
            float heightScale = viewHeight / h;
            float scale = Math.min(widthScale, heightScale);
            matrix.postScale(scale, scale);
            float tw = (viewWidth - w * scale) / 2.0f;
            float th = (viewHeight - h * scale) / 2.0f;
            matrix.postTranslate(tw, th);
        } else {
            float widthScale = viewWidth / w;
            float heightScale = viewHeight / h;
            float scale = Math.min(widthScale, heightScale);
            matrix.postScale(scale, scale);
            float tw = (viewWidth - w * scale) / 2.0f;
            float th = (viewHeight - h * scale) / 2.0f;
            matrix.postTranslate(tw, th);
        }
    }

    protected void getProperBaseMatrix2(Drawable bitmap, Matrix matrix) {
        float viewWidth = this.mThisWidth;
        float viewHeight = this.mThisHeight;
        float w = bitmap.getIntrinsicWidth();
        float h = bitmap.getIntrinsicHeight();
        matrix.reset();
        float widthScale = viewWidth / w;
        float heightScale = viewHeight / h;
        float scale = Math.min(widthScale, heightScale);
        matrix.postScale(scale, scale);
        matrix.postTranslate((viewWidth - w * scale) / 2.0f, (viewHeight - h * scale) / 2.0f);
    }

    protected float getValue(Matrix matrix, int whichValue) {
        matrix.getValues(this.mMatrixValues);
        return this.mMatrixValues[whichValue];
    }

    public void printMatrix(Matrix matrix) {
        float scalex = this.getValue(matrix, 0);
        float scaley = this.getValue(matrix, 4);
        float tx = this.getValue(matrix, 2);
        float ty = this.getValue(matrix, 5);
        Log.d((String)LOG_TAG, (String)("matrix: { x: " + tx + ", y: " + ty + ", scalex: " + scalex + ", scaley: " + scaley + " }"));
    }

    public RectF getBitmapRect() {
        return this.getBitmapRect(this.mSuppMatrix);
    }

    protected RectF getBitmapRect(Matrix supportMatrix) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return null;
        }
        Matrix m = this.getImageViewMatrix(supportMatrix);
        this.mBitmapRect.set(0.0f, 0.0f, (float)drawable2.getIntrinsicWidth(), (float)drawable2.getIntrinsicHeight());
        m.mapRect(this.mBitmapRect);
        return this.mBitmapRect;
    }

    protected float getScale(Matrix matrix) {
        return this.getValue(matrix, 0);
    }

    @SuppressLint(value={"Override"})
    public float getRotation() {
        return 0.0f;
    }

    public float getScale() {
        return this.getScale(this.mSuppMatrix);
    }

    protected void center(boolean horizontal, boolean vertical) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return;
        }
        RectF rect = this.getCenter(this.mSuppMatrix, horizontal, vertical);
        if (rect.left != 0.0f || rect.top != 0.0f) {
            this.postTranslate(rect.left, rect.top);
        }
    }

    protected RectF getCenter(Matrix supportMatrix, boolean horizontal, boolean vertical) {
        Drawable drawable2 = this.getDrawable();
        if (drawable2 == null) {
            return new RectF(0.0f, 0.0f, 0.0f, 0.0f);
        }
        this.mCenterRect.set(0.0f, 0.0f, 0.0f, 0.0f);
        RectF rect = this.getBitmapRect(supportMatrix);
        float height = rect.height();
        float width = rect.width();
        float deltaX = 0.0f;
        float deltaY = 0.0f;
        if (vertical) {
            int viewHeight = this.mThisHeight;
            if (height < (float)viewHeight) {
                deltaY = ((float)viewHeight - height) / 2.0f - rect.top;
            } else if (rect.top > 0.0f) {
                deltaY = -rect.top;
            } else if (rect.bottom < (float)viewHeight) {
                deltaY = (float)this.mThisHeight - rect.bottom;
            }
        }
        if (horizontal) {
            int viewWidth = this.mThisWidth;
            if (width < (float)viewWidth) {
                deltaX = ((float)viewWidth - width) / 2.0f - rect.left;
            } else if (rect.left > 0.0f) {
                deltaX = -rect.left;
            } else if (rect.right < (float)viewWidth) {
                deltaX = (float)viewWidth - rect.right;
            }
        }
        this.mCenterRect.set(deltaX, deltaY, 0.0f, 0.0f);
        return this.mCenterRect;
    }

    protected void postTranslate(float deltaX, float deltaY) {
        if (deltaX != 0.0f || deltaY != 0.0f) {
            this.mSuppMatrix.postTranslate(deltaX, deltaY);
            this.setImageMatrix(this.getImageViewMatrix());
        }
    }

    protected void postScale(float scale, float centerX, float centerY) {
        this.mSuppMatrix.postScale(scale, scale, centerX, centerY);
        this.setImageMatrix(this.getImageViewMatrix());
    }

    protected PointF getCenter() {
        return this.mCenter;
    }

    protected void zoomTo(float scale) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        if (scale < this.getMinScale()) {
            scale = this.getMinScale();
        }
        PointF center = this.getCenter();
        this.zoomTo(scale, center.x, center.y);
    }

    public void zoomTo(float scale, float durationMs) {
        PointF center = this.getCenter();
        this.zoomTo(scale, center.x, center.y, durationMs);
    }

    protected void zoomTo(float scale, float centerX, float centerY) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        float oldScale = this.getScale();
        float deltaScale = scale / oldScale;
        this.postScale(deltaScale, centerX, centerY);
        this.onZoom(this.getScale());
        this.center(true, true);
    }

    protected void onZoom(float scale) {
    }

    protected void onZoomAnimationCompleted(float scale) {
    }

    public void scrollBy(float x, float y) {
        this.panBy(x, y);
    }

    protected void panBy(double dx, double dy) {
        RectF rect = this.getBitmapRect();
        this.mScrollRect.set((float)dx, (float)dy, 0.0f, 0.0f);
        this.updateRect(rect, this.mScrollRect);
        this.postTranslate(this.mScrollRect.left, this.mScrollRect.top);
        this.center(true, true);
    }

    protected void updateRect(RectF bitmapRect, RectF scrollRect) {
        if (bitmapRect == null) {
            return;
        }
        if (bitmapRect.top >= 0.0f && bitmapRect.bottom <= (float)this.mThisHeight) {
            scrollRect.top = 0.0f;
        }
        if (bitmapRect.left >= 0.0f && bitmapRect.right <= (float)this.mThisWidth) {
            scrollRect.left = 0.0f;
        }
        if (bitmapRect.top + scrollRect.top >= 0.0f && bitmapRect.bottom > (float)this.mThisHeight) {
            scrollRect.top = (int)(0.0f - bitmapRect.top);
        }
        if (bitmapRect.bottom + scrollRect.top <= (float)(this.mThisHeight - 0) && bitmapRect.top < 0.0f) {
            scrollRect.top = (int)((float)(this.mThisHeight - 0) - bitmapRect.bottom);
        }
        if (bitmapRect.left + scrollRect.left >= 0.0f) {
            scrollRect.left = (int)(0.0f - bitmapRect.left);
        }
        if (bitmapRect.right + scrollRect.left <= (float)(this.mThisWidth - 0)) {
            scrollRect.left = (int)((float)(this.mThisWidth - 0) - bitmapRect.right);
        }
    }

    protected void scrollBy(float distanceX, float distanceY, final double durationMs) {
        final double dx = distanceX;
        final double dy = distanceY;
        final long startTime = System.currentTimeMillis();
        this.mHandler.post(new Runnable(){
            double old_x = 0.0;
            double old_y = 0.0;

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                double currentMs = Math.min(durationMs, (double)(now - startTime));
                double x = ImageViewTouchBase.this.mEasing.easeOut(currentMs, 0.0, dx, durationMs);
                double y = ImageViewTouchBase.this.mEasing.easeOut(currentMs, 0.0, dy, durationMs);
                ImageViewTouchBase.this.panBy(x - this.old_x, y - this.old_y);
                this.old_x = x;
                this.old_y = y;
                if (currentMs < durationMs) {
                    ImageViewTouchBase.this.mHandler.post((Runnable)this);
                } else {
                    RectF centerRect = ImageViewTouchBase.this.getCenter(ImageViewTouchBase.this.mSuppMatrix, true, true);
                    if (centerRect.left != 0.0f || centerRect.top != 0.0f) {
                        ImageViewTouchBase.this.scrollBy(centerRect.left, centerRect.top);
                    }
                }
            }
        });
    }

    protected void zoomTo(float scale, float centerX, float centerY, final float durationMs) {
        if (scale > this.getMaxScale()) {
            scale = this.getMaxScale();
        }
        final long startTime = System.currentTimeMillis();
        final float oldScale = this.getScale();
        final float deltaScale = scale - oldScale;
        Matrix m = new Matrix(this.mSuppMatrix);
        m.postScale(scale, scale, centerX, centerY);
        RectF rect = this.getCenter(m, true, true);
        final float destX = centerX + rect.left * scale;
        final float destY = centerY + rect.top * scale;
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                long now = System.currentTimeMillis();
                float currentMs = Math.min(durationMs, (float)(now - startTime));
                float newScale = (float)ImageViewTouchBase.this.mEasing.easeInOut(currentMs, 0.0, deltaScale, durationMs);
                ImageViewTouchBase.this.zoomTo(oldScale + newScale, destX, destY);
                if (currentMs < durationMs) {
                    ImageViewTouchBase.this.mHandler.post((Runnable)this);
                } else {
                    ImageViewTouchBase.this.onZoomAnimationCompleted(ImageViewTouchBase.this.getScale());
                    ImageViewTouchBase.this.center(true, true);
                }
            }
        });
    }

    @Override
    public void dispose() {
        this.clear();
    }

    public static enum DisplayType {
        NONE,
        FIT_TO_SCREEN,
        FIT_IF_BIGGER;

    }

    public static interface OnLayoutChangeListener {
        public void onLayoutChanged(boolean var1, int var2, int var3, int var4, int var5);
    }

    public static interface OnDrawableChangeListener {
        public void onDrawableChanged(Drawable var1);
    }
}

