/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine.filter;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.util.Log;
import com.droidninja.imageeditengine.model.ImageFilter;

public class PhotoProcessing {
    private static final String TAG = "PhotoProcessing";

    public static Bitmap filterPhoto(Bitmap bitmap, ImageFilter filterConfig) {
        if (bitmap != null) {
            PhotoProcessing.sendBitmapToNative(bitmap);
        }
        switch (filterConfig.filterName) {
            case "None": {
                break;
            }
            case "Instafix": {
                PhotoProcessing.nativeApplyInstafix();
                break;
            }
            case "Ansel": {
                PhotoProcessing.nativeApplyAnsel();
                break;
            }
            case "Testino": {
                PhotoProcessing.nativeApplyTestino();
                break;
            }
            case "XPro": {
                PhotoProcessing.nativeApplyXPro();
                break;
            }
            case "Retro": {
                PhotoProcessing.nativeApplyRetro();
                break;
            }
            case "B&W": {
                PhotoProcessing.nativeApplyBW();
                break;
            }
            case "Sepia": {
                PhotoProcessing.nativeApplySepia();
                break;
            }
            case "Cyano": {
                PhotoProcessing.nativeApplyCyano();
                break;
            }
            case "Georgia": {
                PhotoProcessing.nativeApplyGeorgia();
                break;
            }
            case "Sahara": {
                PhotoProcessing.nativeApplySahara();
                break;
            }
            case "HDR": {
                PhotoProcessing.nativeApplyHDR();
            }
        }
        Bitmap filteredBitmap = PhotoProcessing.getBitmapFromNative(bitmap);
        PhotoProcessing.nativeDeleteBitmap();
        return filteredBitmap;
    }

    public static Bitmap combineImages(Bitmap bmp1, Bitmap bmp2, int alpha) {
        Bitmap bmOverlay = Bitmap.createBitmap((int)bmp1.getWidth(), (int)bmp1.getHeight(), (Bitmap.Config)bmp1.getConfig());
        Canvas canvas = new Canvas(bmOverlay);
        Log.i((String)"hasAlpha", (String)(bmp2.hasAlpha() + ""));
        canvas.drawBitmap(bmp1, new Matrix(), null);
        Paint alphaPaint = new Paint();
        alphaPaint.setAlpha(alpha);
        canvas.drawBitmap(bmp2, 0.0f, 0.0f, alphaPaint);
        return bmOverlay;
    }

    public static native int nativeInitBitmap(int var0, int var1);

    public static native void nativeGetBitmapRow(int var0, int[] var1);

    public static native void nativeSetBitmapRow(int var0, int[] var1);

    public static native int nativeGetBitmapWidth();

    public static native int nativeGetBitmapHeight();

    public static native void nativeDeleteBitmap();

    public static native int nativeRotate90();

    public static native void nativeRotate180();

    public static native void nativeFlipHorizontally();

    public static native void nativeApplyInstafix();

    public static native void nativeApplyCustomFilter(int var0);

    public static native void nativeApplyAnsel();

    public static native void nativeApplyTestino();

    public static native void nativeApplyXPro();

    public static native void nativeApplyRetro();

    public static native void nativeApplyBW();

    public static native void nativeApplySepia();

    public static native void nativeApplyCyano();

    public static native void nativeApplyGeorgia();

    public static native void nativeApplySahara();

    public static native void nativeApplyHDR();

    public static native void nativeLoadResizedJpegBitmap(byte[] var0, int var1, int var2);

    public static native void nativeResizeBitmap(int var0, int var1);

    public static native void handleSmooth(Bitmap var0, float var1);

    public static native void handleWhiteSkin(Bitmap var0, float var1);

    public static native void handleSmoothAndWhiteSkin(Bitmap var0, float var1, float var2);

    public static native void freeBeautifyMatrix();

    private static void sendBitmapToNative(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        PhotoProcessing.nativeInitBitmap(width, height);
        int[] pixels = new int[width];
        for (int y = 0; y < height; ++y) {
            bitmap.getPixels(pixels, 0, width, 0, y, width, 1);
            PhotoProcessing.nativeSetBitmapRow(y, pixels);
        }
    }

    private static Bitmap getBitmapFromNative(Bitmap bitmap) {
        int width = PhotoProcessing.nativeGetBitmapWidth();
        int height = PhotoProcessing.nativeGetBitmapHeight();
        if (bitmap == null || width != bitmap.getWidth() || height != bitmap.getHeight() || !bitmap.isMutable()) {
            Bitmap.Config config = Bitmap.Config.ARGB_8888;
            if (bitmap != null) {
                config = bitmap.getConfig();
                bitmap.recycle();
            }
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
        }
        int[] pixels = new int[width];
        for (int y = 0; y < height; ++y) {
            PhotoProcessing.nativeGetBitmapRow(y, pixels);
            bitmap.setPixels(pixels, 0, width, 0, y, width, 1);
        }
        return bitmap;
    }

    public static Bitmap makeBitmapMutable(Bitmap bitmap) {
        PhotoProcessing.sendBitmapToNative(bitmap);
        return PhotoProcessing.getBitmapFromNative(bitmap);
    }

    public static Bitmap rotate(Bitmap bitmap, int angle) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        Bitmap.Config config = bitmap.getConfig();
        PhotoProcessing.nativeInitBitmap(width, height);
        PhotoProcessing.sendBitmapToNative(bitmap);
        if (angle == 90) {
            PhotoProcessing.nativeRotate90();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        } else if (angle == 180) {
            PhotoProcessing.nativeRotate180();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        } else if (angle == 270) {
            PhotoProcessing.nativeRotate180();
            PhotoProcessing.nativeRotate90();
            bitmap.recycle();
            bitmap = Bitmap.createBitmap((int)height, (int)width, (Bitmap.Config)config);
            bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
            PhotoProcessing.nativeDeleteBitmap();
        }
        return bitmap;
    }

    public static Bitmap flipHorizontally(Bitmap bitmap) {
        PhotoProcessing.nativeInitBitmap(bitmap.getWidth(), bitmap.getHeight());
        PhotoProcessing.sendBitmapToNative(bitmap);
        PhotoProcessing.nativeFlipHorizontally();
        bitmap = PhotoProcessing.getBitmapFromNative(bitmap);
        PhotoProcessing.nativeDeleteBitmap();
        return bitmap;
    }

    static {
        System.loadLibrary("photoprocessing");
    }
}

