/*
 * Decompiled with CFR 0.152.
 */
package com.droidninja.imageeditengine;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import com.droidninja.imageeditengine.BaseFragment;
import com.droidninja.imageeditengine.R;
import com.droidninja.imageeditengine.views.cropimage.IEECropImageView;

public class CropFragment
extends BaseFragment
implements View.OnClickListener {
    private OnFragmentInteractionListener mListener;
    private IEECropImageView ieeCropImageView;
    private int currentAngle;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_crop, container, false);
    }

    public void onAttach(Context context) {
        super.onAttach(context);
        if (!(context instanceof OnFragmentInteractionListener)) {
            throw new RuntimeException(context.toString() + " must implement OnFragmentInteractionListener");
        }
        this.mListener = (OnFragmentInteractionListener)context;
    }

    public void onDetach() {
        super.onDetach();
        this.mListener = null;
    }

    public static CropFragment newInstance(Bitmap bitmap, Rect cropRect) {
        CropFragment cropFragment = new CropFragment();
        Bundle bundle = new Bundle();
        bundle.putParcelable("EXTRA_ORIGINAL", (Parcelable)bitmap);
        bundle.putParcelable("EXTRA_CROP_RECT", (Parcelable)cropRect);
        cropFragment.setArguments(bundle);
        return cropFragment;
    }

    public void setImageBitmap(Bitmap bitmap) {
        this.ieeCropImageView.setImageBitmap(bitmap);
    }

    @Override
    protected void initView(View view) {
        Bitmap bitmapimage;
        this.ieeCropImageView = (IEECropImageView)view.findViewById(R.id.image_iv);
        view.findViewById(R.id.cancel_tv).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.back_iv).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.rotate_iv).setOnClickListener((View.OnClickListener)this);
        view.findViewById(R.id.done_tv).setOnClickListener((View.OnClickListener)this);
        if (this.getArguments() != null && (bitmapimage = (Bitmap)this.getArguments().getParcelable("EXTRA_ORIGINAL")) != null) {
            this.ieeCropImageView.setImageBitmap(bitmapimage);
            this.ieeCropImageView.setAspectRatio(1, 1);
            this.ieeCropImageView.setGuidelines(IEECropImageView.Guidelines.ON_TOUCH);
            Rect cropRect = (Rect)this.getArguments().getParcelable("EXTRA_CROP_RECT");
            if (cropRect != null) {
                this.ieeCropImageView.setCropRect(cropRect);
            }
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.rotate_iv) {
            this.ieeCropImageView.rotateImage(90);
        } else if (view.getId() == R.id.cancel_tv) {
            this.mListener.onCancelCrop();
        } else if (view.getId() == R.id.done_tv) {
            Bitmap original = (Bitmap)this.getArguments().getParcelable("EXTRA_ORIGINAL");
            this.mListener.onImageCropped(this.ieeCropImageView.getCroppedImage(), this.ieeCropImageView.getCropRect());
        } else if (view.getId() == R.id.done_tv) {
            this.getActivity().onBackPressed();
        }
    }

    public static interface OnFragmentInteractionListener {
        public void onImageCropped(Bitmap var1, Rect var2);

        public void onCancelCrop();
    }
}

