/*
 * Decompiled with CFR 0.152.
 */
package jp.shts.android.storiesprogressview;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.TypedArray;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import jp.shts.android.storiesprogressview.PausableProgressBar;
import jp.shts.android.storiesprogressview.R;

public class StoriesProgressView
extends LinearLayout {
    private final LinearLayout.LayoutParams PROGRESS_BAR_LAYOUT_PARAM = new LinearLayout.LayoutParams(0, -2, 1.0f);
    private final LinearLayout.LayoutParams SPACE_LAYOUT_PARAM = new LinearLayout.LayoutParams(5, -2);
    private final List<PausableProgressBar> progressBars = new ArrayList<PausableProgressBar>();
    private int storiesCount = -1;
    private int current = -1;
    private StoriesListener storiesListener;

    public StoriesProgressView(Context context) {
        this(context, null);
    }

    public StoriesProgressView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    public StoriesProgressView(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init(context, attrs);
    }

    @TargetApi(value=21)
    public StoriesProgressView(Context context, AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        super(context, attrs, defStyleAttr, defStyleRes);
        this.init(context, attrs);
    }

    private void init(Context context, @Nullable AttributeSet attrs) {
        this.setOrientation(0);
        TypedArray typedArray = context.obtainStyledAttributes(attrs, R.styleable.StoriesProgressView);
        this.storiesCount = typedArray.getInt(R.styleable.StoriesProgressView_progressCount, 0);
        typedArray.recycle();
        this.bindViews();
    }

    private void bindViews() {
        this.progressBars.clear();
        this.removeAllViews();
        for (int i = 0; i < this.storiesCount; ++i) {
            PausableProgressBar p = this.createProgressBar();
            this.progressBars.add(p);
            this.addView((View)p);
            if (i + 1 >= this.storiesCount) continue;
            this.addView(this.createSpace());
        }
    }

    private PausableProgressBar createProgressBar() {
        PausableProgressBar p = new PausableProgressBar(this.getContext());
        p.setLayoutParams((ViewGroup.LayoutParams)this.PROGRESS_BAR_LAYOUT_PARAM);
        return p;
    }

    private View createSpace() {
        View v = new View(this.getContext());
        v.setLayoutParams((ViewGroup.LayoutParams)this.SPACE_LAYOUT_PARAM);
        return v;
    }

    public void setStoriesCount(int storiesCount) {
        this.storiesCount = storiesCount;
        this.bindViews();
    }

    public void setStoriesListener(StoriesListener storiesListener) {
        this.storiesListener = storiesListener;
    }

    public void setStoryDuration(long duration) {
        for (int i = 0; i < this.progressBars.size(); ++i) {
            this.progressBars.get(i).setDuration(duration);
            this.progressBars.get(i).setCallback(this.callback(i));
        }
    }

    public void setStoriesCountWithDurations(@NonNull long[] durations) {
        this.storiesCount = durations.length;
        this.bindViews();
        for (int i = 0; i < this.progressBars.size(); ++i) {
            this.progressBars.get(i).setDuration(durations[i]);
            this.progressBars.get(i).setCallback(this.callback(i));
        }
    }

    private PausableProgressBar.Callback callback(int index) {
        return new PausableProgressBar.Callback(){

            @Override
            public void onStartProgress() {
            }

            @Override
            public void onFinishProgress() {
                if (StoriesProgressView.this.current == StoriesProgressView.this.storiesCount - 1) {
                    if (StoriesProgressView.this.storiesListener != null) {
                        StoriesProgressView.this.storiesListener.onComplete();
                    }
                } else if (StoriesProgressView.this.storiesListener != null) {
                    StoriesProgressView.this.storiesListener.onNext();
                }
            }
        };
    }

    public void startStories() {
        this.progressBars.get(0).startProgress();
    }

    public void startStories(int from) {
        for (int i = 0; i < from; ++i) {
            this.progressBars.get(i).setMaxWithoutCallback();
        }
    }

    public void destroy() {
        for (PausableProgressBar p : this.progressBars) {
            p.clear();
        }
    }

    public void pause() {
        if (this.current < 0) {
            return;
        }
        this.progressBars.get(this.current).pauseProgress();
    }

    public void resume() {
        if (this.current < 0) {
            return;
        }
        this.progressBars.get(this.current).resumeProgress();
    }

    public void start(int index) {
        this.progressBars.get(index).startProgress();
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public void skip(int current) {
        this.progressBars.get(current).setMaxWithoutCallback();
        if (this.storiesListener != null) {
            this.storiesListener.onNext();
        }
        if (current == this.storiesCount - 1) {
            this.storiesListener.onComplete();
        }
    }

    public void reverse(int current) {
        if (current - 1 < 0) {
            return;
        }
        this.progressBars.get(current).setMinWithoutCallback();
        this.progressBars.get(current).hideProgress(false);
        if (this.storiesListener != null) {
            this.storiesListener.onPrev();
        }
    }

    public static interface StoriesListener {
        public void onNext();

        public void onPrev();

        public void onComplete();
    }
}

