<?php
$title = 'Подключение';
require ('../core/sys.php');
require ('../core/head.php');
$page = $db->prepare('SELECT * FROM `text` WHERE `id` = ?');
$page -> execute([1]);
$page = $page -> fetch(PDO :: FETCH_ASSOC);
?> <div class="top"> Подключение</div>
<div class="box">

<a href="#1"><strong>1. Инициализация платежа</strong></a><br />
<a href="#2"><strong>2. Обработчик платежа</strong></a><br />
<a href="#3"><strong>3. Дополнительная информация</strong></a><br />
<a href="#4"><strong>4. Автоматический вывод средств</strong></a><br />
<a href="#5"><strong>5. Готовые примеры для некоторых движков </strong></a><br />
</div>

<div class="box">

<a id="1"></a>
        <h3>Инициализация платежа</h3><br/>
Передать параметры платежа с вашего сайта на кассу можно несколькими способами. Все они равноценные, используйте способ какой подходит Вам.<br/><br/>
<strong>Параметры запроса:</strong><br/>
        <strong><span style="color:red;">Красные</span></strong> - обязательные поля.<br/>
        <strong><span style="color:green;">Зеленые</span></strong> - дополнительные поля.<br/><br/>
        <strong><span style="color:red;">MNM_PLATFORM</span></strong> -  ID PLATFORM <i>(ID площадки, целое число)</i><br/>
        <strong><span style="color:red;">MNM_COM</span></strong> -  Коментарий к платежу <i>(Он используется с функцией base64_encode)</i><br/>
        <strong><span style="color:green;">MNM_VAR</span></strong> -  Уникальный код к платежку <i>(Можете использовать при передаче ID запроса или ID пользователя)</i><br/>
        
       <br/> 
Форма оплаты:
</br><pre style="overflow:auto;">
<span style="color: #0000BB"></span><span style="color: #007700">&lt;?<br />&lt;</span><span style="color: #0000BB">form&nbsp;&nbsp;action</span><span style="color: #007700">=</span><span style="color: #DD0000">"http://wordpay.ru/payment/check.aspx"&nbsp;</span><span style="color: #0000BB">method</span><span style="color: #007700">=</span><span style="color: #DD0000">"POST"</span><span style="color: #007700">&gt;<br />&lt;</span><span style="color: #0000BB">input&nbsp;type</span><span style="color: #007700">=</span><span style="color: #DD0000">"hidden"&nbsp;</span><span style="color: #0000BB">name</span><span style="color: #007700">=</span><span style="color: #DD0000">"MNM_COM"&nbsp;</span><span style="color: #0000BB">value</span><span style="color: #007700">=</span><span style="color: #DD0000">"{base64_encode(Комментарий&nbsp;к&nbsp;платежу)}"</span><span style="color: #007700">&gt;<br />&lt;</span><span style="color: #0000BB">input&nbsp;type</span><span style="color: #007700">=</span><span style="color: #DD0000">"hidden"&nbsp;</span><span style="color: #0000BB">name</span><span style="color: #007700">=</span><span style="color: #DD0000">"MNM_PLATFORM"&nbsp;</span><span style="color: #0000BB">value</span><span style="color: #007700">=</span><span style="color: #DD0000">"ID&nbsp;вашей&nbsp;площадки"</span><span style="color: #007700">&gt;<br />&lt;</span><span style="color: #0000BB">input&nbsp;type</span><span style="color: #007700">=</span><span style="color: #DD0000">"hidden"&nbsp;</span><span style="color: #0000BB">name</span><span style="color: #007700">=</span><span style="color: #DD0000">"MNM_VAR"&nbsp;</span><span style="color: #0000BB">value</span><span style="color: #007700">=</span><span style="color: #DD0000">"4325743"</span><span style="color: #007700">&gt;&nbsp;<br /></span><span style="color: #0000BB">Сумма&nbsp;платежа</span><span style="color: #007700">:&lt;/</span><span style="color: #0000BB">br</span><span style="color: #007700">&gt;<br />&lt;</span><span style="color: #0000BB">input&nbsp;type</span><span style="color: #007700">=</span><span style="color: #DD0000">"number"&nbsp;</span><span style="color: #0000BB">name</span><span style="color: #007700">=</span><span style="color: #DD0000">"MNM_PRICE"</span><span style="color: #007700">&gt;&lt;/</span><span style="color: #0000BB">br</span><span style="color: #007700">&gt;<br />&lt;</span><span style="color: #0000BB">input&nbsp;type</span><span style="color: #007700">=</span><span style="color: #DD0000">"submit"&nbsp;</span><span style="color: #0000BB">value</span><span style="color: #007700">=</span><span style="color: #DD0000">"Оплатить"</span><span style="color: #007700">&gt;<br />&lt;/</span><span style="color: #0000BB">form</span><span style="color: #007700">&gt;<br /></span><span style="color: #0000BB">?&gt;</span></pre>
</div>
<div class="box">
<a id="2"></a>
        <h3>Обработчик платежа</h3><br/>
После оплаты данные о платеже отправляются на <strong>URL Result</strong>.<br />
        По этим данным производите зачисление на своем сайте.<br />
        При успешной обработке должна вернуться строка <strong>MNM_PAY_ID|YES</strong> (MNM_PAY_ID - id платежа),
        иначе платеж считается необработанным и касса будет присылать повторные уведомления.
        <br/>
        <br/>
<pre style="overflow:auto;">
<span style="color: #0000BB"></span><span style="color: #007700">&lt;?</span><span style="color: #0000BB">php
<br />$config&nbsp;</span><span style="color: #007700">=&nbsp;array(</span><span style="color: #DD0000">'platform'</span><span style="color: #007700">=&gt;</span><span style="color: #DD0000">'ID&nbsp;площадки'</span><span style="color: #007700">,</span><span style="color: #DD0000">'key'</span><span style="color: #007700">=&gt;</span><span style="color: #DD0000">'Секретный&nbsp;ключ'</span><span style="color: #007700">);
<br /></span><span style="color: #0000BB">$id&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">abs</span><span style="color: #007700">(</span><span style="color: #0000BB">intval</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_PAY_ID'</span><span style="color: #007700">]));&nbsp;</span><span style="color: #FF8000">///&nbsp;ID&nbsp;платежа
<br /></span><span style="color: #0000BB">$date&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">htmlspecialchars</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_DATE_PAY'</span><span style="color: #007700">]);&nbsp;</span><span style="color: #FF8000">///&nbsp;Дата&nbsp;платежа
<br /></span><span style="color: #0000BB">$var&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">htmlspecialchars</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_VAR'</span><span style="color: #007700">]);&nbsp;</span><span style="color: #FF8000">///&nbsp;Не&nbsp;трогаем
<br /></span><span style="color: #0000BB">$price&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">abs</span><span style="color: #007700">(</span><span style="color: #0000BB">intval</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_PRICE'</span><span style="color: #007700">]));&nbsp;</span><span style="color: #FF8000">///&nbsp;Сумма&nbsp;платежа
<br /></span><span style="color: #0000BB">$platform&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">abs</span><span style="color: #007700">(</span><span style="color: #0000BB">intval</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_PLATFORM'</span><span style="color: #007700">]));&nbsp;</span><span style="color: #FF8000">///&nbsp;ID&nbsp;площадки
<br /></span><span style="color: #0000BB">$com&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">htmlspecialchars</span><span style="color: #007700">(</span><span style="color: #0000BB">$_POST</span><span style="color: #007700">[</span><span style="color: #DD0000">'MNM_COM'</span><span style="color: #007700">]);&nbsp;</span><span style="color: #FF8000">///&nbsp;Комментарий&nbsp;к&nbsp;платежу
<br />//Если&nbsp;хотите&nbsp;получить&nbsp;раскодированный&nbsp;комментарий&nbsp;к&nbsp;платежу&nbsp;то&nbsp;используйте&nbsp;функцию&nbsp;base64_decode
<br />
<br /></span><span style="color: #007700">if(!isset(</span><span style="color: #0000BB">$id</span><span style="color: #007700">)&nbsp;||&nbsp;!isset(</span><span style="color: #0000BB">$date</span><span style="color: #007700">)&nbsp;||&nbsp;!isset(</span><span style="color: #0000BB">$var</span><span style="color: #007700">)&nbsp;||&nbsp;!isset(</span><span style="color: #0000BB">$price</span><span style="color: #007700">)&nbsp;||&nbsp;!isset(</span><span style="color: #0000BB">$platform</span><span style="color: #007700">)){
<br />exit(</span><span style="color: #DD0000">'NO'</span><span style="color: #007700">);
<br />}
<br /></span><span style="color: #FF8000">//Производим&nbsp;проверку&nbsp;id,key&nbsp;,а&nbsp;иначе&nbsp;платеж&nbsp;не&nbsp;пройдет&nbsp;
<br /></span><span style="color: #0000BB">$key&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">file_get_contents</span><span style="color: #007700">(</span><span style="color: #DD0000">'https://wordpay.ru/payment/hash.aspx?summa='</span><span style="color: #007700">.</span><span style="color: #0000BB">$price</span><span style="color: #007700">.</span><span style="color: #DD0000">'&amp;id='</span><span style="color: #007700">.</span><span style="color: #0000BB">$id</span><span style="color: #007700">.</span><span style="color: #DD0000">'&amp;platform='</span><span style="color: #007700">.</span><span style="color: #0000BB">$config</span><span style="color: #007700">[</span><span style="color: #DD0000">'platform'</span><span style="color: #007700">].</span><span style="color: #DD0000">'&amp;key='</span><span style="color: #007700">.</span><span style="color: #0000BB">md5</span><span style="color: #007700">(</span><span style="color: #0000BB">$config</span><span style="color: #007700">[</span><span style="color: #DD0000">'key'</span><span style="color: #007700">]));
<br /></span><span style="color: #FF8000">//key&nbsp;обязательно&nbsp;отдает&nbsp;в&nbsp;md5
<br /></span><span style="color: #007700">if(</span><span style="color: #0000BB">$key&nbsp;</span><span style="color: #007700">!=&nbsp;</span><span style="color: #0000BB">4</span><span style="color: #007700">)&nbsp;exit(</span><span style="color: #DD0000">'NO'</span><span style="color: #007700">);
<br />
<br /></span><span style="color: #FF8000">//Производим&nbsp;пополнение&nbsp;баланса&nbsp;(На&nbsp;примере&nbsp;использовано&nbsp;PDO)
<br /></span><span style="color: #0000BB">$update&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">$db</span><span style="color: #007700">-&gt;</span><span style="color: #0000BB">prepare</span><span style="color: #007700">(</span><span style="color: #DD0000">"UPDATE&nbsp;`users`&nbsp;SET&nbsp;`money`&nbsp;=&nbsp;`money`&nbsp;+&nbsp;?&nbsp;WHERE&nbsp;`id`&nbsp;=&nbsp;?"</span><span style="color: #007700">);
<br /></span><span style="color: #0000BB">$update&nbsp;</span><span style="color: #007700">-&gt;&nbsp;</span><span style="color: #0000BB">execute</span><span style="color: #007700">([</span><span style="color: #0000BB">$price</span><span style="color: #007700">,</span><span style="color: #0000BB">$var</span><span style="color: #007700">]);
<br />exit(</span><span style="color: #DD0000">'YES&nbsp;|&nbsp;'</span><span style="color: #007700">.</span><span style="color: #0000BB">$id</span><span style="color: #007700">);
<br /></span><span style="color: #0000BB">?&gt;</span></pre>
<br /><br />
<b>Возможные ошибки при проверки ключа :</b><br />
<b>Ошибка №1</b> - Не верный Key<br />
<b>Ошибка №2</b> - Подмена суммы оплаты<br />
<b>Ошибка №3</b> - Данная заявка еще не была оплачена<br />
</div>
<div class="box">
<a id="3"></a>
        <h3>Дополнительная информация</h3><br/>
Для подключения нашего сервиса для начала Вам необходимо пройти регистрацию на сайте. </br>
После регистрации перейдите в "Кабинет", в раздел "Площадки"</br>
Создайте свою площадку.</br>
Далее заполните поля: </br>
1. Success - адрес на который попадает покупатель, в случае успешной покупки товара.
</br>
2. Result - Происходит передача информации о проведение платежа 
</br>
3. Error - адрес на который попадает покупатель, в случае не удачной покупки товара.</br>
4. Адрес сайта - ссылка  на ваш проект, с http:// или https://</br>
5. Key - код для проверки подлинности платежа. Нужен для предотвращения подмены данных.  <strong>Никому не сообщайте данный код</strong></br>
</br>
</div>
<div class="box">
<a id="4"></a>
        <h3>Автоматический вывод средств</h3><br/>
Автоматический вывод средств происходит по адресу : <strong>https://wordpay.ru/api/moneyback/</strong> посредством POST запросов и ответ вы получаете в формате <strong>json_encode</strong><br />
<strong>Параметры запроса:</strong><br/>
        <strong><span style="color:red;">Красные</span></strong> - обязательные поля.<br/>
        <strong><span style="color:green;">Зеленые</span></strong> - дополнительные поля.<br/><br/>
         <strong><span style="color:red;">hash</span></strong> -  секретный код <br/>
         <strong><span style="color:red;">money</span></strong> -  сумма платежа <br/>
         <b>Платежные системы (Выбрать только один пункт)</b><br />
         <strong><span style="color:red;">qiwi</span></strong> -  qiwi платежная система <i>(Передавать сразу с номером куда отправлять , вид номер 792270277xx)</i><br/>
         <strong><span style="color:red;">mobile</span></strong> -  Мобильный телефон <i>(Передавать сразу с номером куда отправлять вид номер 792270277xx)</i><br/>
         <strong><span style="color:red;">card</span></strong> -  Банковская карта <i>(Передавать сразу с номером куда отправлять)</i><br/>
         <strong><span style="color:red;">ya</span></strong> -  Яндекс.деньги <i>(Передавать сразу с номером куда отправлять)</i><br/>
         <br />
         <h4>Готовые функции:</h4>
</br><pre style="overflow:auto;">
<span style="color: #0000BB"></span><span style="color: #007700">&lt;?
<br />function&nbsp;</span><span style="color: #0000BB">CurlWordPay</span><span style="color: #007700">(</span><span style="color: #0000BB">$money</span><span style="color: #007700">,</span><span style="color: #0000BB">$merch</span><span style="color: #007700">,</span><span style="color: #0000BB">$number</span><span style="color: #007700">,</span><span style="color: #0000BB">$hash</span><span style="color: #007700">){
<br />if(&nbsp;</span><span style="color: #0000BB">$curl&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">curl_init</span><span style="color: #007700">()&nbsp;)&nbsp;{
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">curl_setopt</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">,&nbsp;</span><span style="color: #0000BB">CURLOPT_URL</span><span style="color: #007700">,&nbsp;</span><span style="color: #DD0000">'https://wordpay.ru/api/moneyback/'</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">curl_setopt</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">,&nbsp;</span><span style="color: #0000BB">CURLOPT_RETURNTRANSFER</span><span style="color: #007700">,</span><span style="color: #0000BB">true</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">curl_setopt</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">,&nbsp;</span><span style="color: #0000BB">CURLOPT_POST</span><span style="color: #007700">,&nbsp;</span><span style="color: #0000BB">true</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">curl_setopt</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">,&nbsp;</span><span style="color: #0000BB">CURLOPT_POSTFIELDS</span><span style="color: #007700">,&nbsp;</span><span style="color: #DD0000">"money=</span><span style="color: #007700">{</span><span style="color: #0000BB">$money</span><span style="color: #007700">}</span><span style="color: #DD0000">&amp;</span><span style="color: #007700">{</span><span style="color: #0000BB">$merch</span><span style="color: #007700">}</span><span style="color: #DD0000">=</span><span style="color: #007700">{</span><span style="color: #0000BB">$number</span><span style="color: #007700">}</span><span style="color: #DD0000">&amp;hash=</span><span style="color: #007700">{</span><span style="color: #0000BB">$hash</span><span style="color: #007700">}</span><span style="color: #DD0000">"</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">$out&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">curl_exec</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;</span><span style="color: #0000BB">curl_close</span><span style="color: #007700">(</span><span style="color: #0000BB">$curl</span><span style="color: #007700">);
<br />&nbsp;&nbsp;&nbsp;&nbsp;return&nbsp;</span><span style="color: #0000BB">$out</span><span style="color: #007700">;
<br />}
<br />}
<br />function&nbsp;</span><span style="color: #0000BB">MoneyBack</span><span style="color: #007700">(</span><span style="color: #0000BB">$sp</span><span style="color: #007700">,</span><span style="color: #0000BB">$obj</span><span style="color: #007700">){
<br /></span><span style="color: #0000BB">$obj&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">json_decode</span><span style="color: #007700">(</span><span style="color: #0000BB">$obj</span><span style="color: #007700">);
<br />if(</span><span style="color: #0000BB">$sp&nbsp;</span><span style="color: #007700">==&nbsp;</span><span style="color: #0000BB">1</span><span style="color: #007700">)&nbsp;print&nbsp;</span><span style="color: #0000BB">$obj</span><span style="color: #007700">-&gt;{</span><span style="color: #DD0000">'message'</span><span style="color: #007700">};
<br />elseif(</span><span style="color: #0000BB">$sp&nbsp;</span><span style="color: #007700">==&nbsp;</span><span style="color: #0000BB">2</span><span style="color: #007700">)&nbsp;print&nbsp;</span><span style="color: #0000BB">$obj</span><span style="color: #007700">-&gt;{</span><span style="color: #DD0000">'money'</span><span style="color: #007700">};
<br />elseif(</span><span style="color: #0000BB">$sp&nbsp;</span><span style="color: #007700">==&nbsp;</span><span style="color: #0000BB">3</span><span style="color: #007700">)&nbsp;print&nbsp;</span><span style="color: #0000BB">$obj</span><span style="color: #007700">-&gt;{</span><span style="color: #DD0000">'money_go'</span><span style="color: #007700">};
<br />elseif(</span><span style="color: #0000BB">$sp&nbsp;</span><span style="color: #007700">==&nbsp;</span><span style="color: #0000BB">4</span><span style="color: #007700">)&nbsp;print&nbsp;</span><span style="color: #0000BB">$obj</span><span style="color: #007700">-&gt;{</span><span style="color: #DD0000">'status'</span><span style="color: #007700">};
<br />else&nbsp;return&nbsp;</span><span style="color: #DD0000">'Не&nbsp;выбран&nbsp;способ'</span><span style="color: #007700">;
<br />}
<br /></span><span style="color: #0000BB">?&gt;</span></pre>
<br />
<h4>Пример использования:</h4>
</br><pre style="overflow:auto;">
<span style="color: #0000BB"></span><span style="color: #007700">&lt;?</span><span style="color: #0000BB">php<br />$url&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">CurlWordPay</span><span style="color: #007700">(</span><span style="color: #0000BB">сумма</span><span style="color: #007700">,</span><span style="color: #0000BB">способ&nbsp;платежа</span><span style="color: #007700">,</span><span style="color: #0000BB">номер</span><span style="color: #007700">,</span><span style="color: #0000BB">секретный&nbsp;код</span><span style="color: #007700">);<br />if(</span><span style="color: #0000BB">MoneyBack</span><span style="color: #007700">(</span><span style="color: #0000BB">4</span><span style="color: #007700">,</span><span style="color: #0000BB">$url</span><span style="color: #007700">)&nbsp;==&nbsp;</span><span style="color: #0000BB">0</span><span style="color: #007700">){<br />echo&nbsp;</span><span style="color: #0000BB">MoneyBack</span><span style="color: #007700">(</span><span style="color: #0000BB">1</span><span style="color: #007700">,</span><span style="color: #0000BB">$url</span><span style="color: #007700">);<br />}else{<br />echo&nbsp;</span><span style="color: #0000BB">MoneyBack</span><span style="color: #007700">(</span><span style="color: #0000BB">1</span><span style="color: #007700">,</span><span style="color: #0000BB">$url</span><span style="color: #007700">);<br /></span><span style="color: #0000BB">$update&nbsp;</span><span style="color: #007700">=&nbsp;</span><span style="color: #0000BB">$db</span><span style="color: #007700">-&gt;</span><span style="color: #0000BB">prepare</span><span style="color: #007700">(</span><span style="color: #DD0000">"UPDATE&nbsp;`users`&nbsp;SET&nbsp;`money`&nbsp;=&nbsp;`money`&nbsp;-&nbsp;?&nbsp;WHERE&nbsp;`id`&nbsp;=&nbsp;?"</span><span style="color: #007700">);<br /></span><span style="color: #0000BB">$update&nbsp;</span><span style="color: #007700">-&gt;&nbsp;</span><span style="color: #0000BB">execute</span><span style="color: #007700">([</span><span style="color: #0000BB">MoneyBack</span><span style="color: #007700">(</span><span style="color: #0000BB">2</span><span style="color: #007700">,</span><span style="color: #0000BB">$url</span><span style="color: #007700">),</span><span style="color: #0000BB">$user</span><span style="color: #007700">-&gt;</span><span style="color: #0000BB">id</span><span style="color: #007700">);<br />}<br /></span><span style="color: #0000BB">?&gt;</span></pre>
<br />
<strong>Параметры получения ответа:</strong><br/>
         <strong><span style="color:red;">message</span></strong> -  сообщения с ответом <br/>
         <strong><span style="color:red;">money</span></strong> -  сумма платежа <br/>
         <strong><span style="color:red;">money_go</span></strong> -  сумма платежа без комиссии<br/>
         <strong><span style="color:red;">status</span></strong> -  статус платежа <br/>
</div>
<div class="wrap">
<a id="5"></a>
        <h3>Готовые примеры для некоторых движков</h3><br/>
 Готовые скрипты для различных CMS и т.п. Список будет постепенно пополняться. <br />
 <br />
<div style="text-align:center;">
<a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/1.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i><strong> Для DCMS 6.6.4 </strong></a>  
    <a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/2.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Для DCMS-Social 1.9.0</strong> </a> <br />

<a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/3.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Для JohnCMS 5.2.1</strong> </a> 
<a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/4.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Для StrongCms 0.9</strong> </a> <br />
<a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/5.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Для Колхоза</strong> </a> 
    <a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/6.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Продажа рекламы </strong></a> <br />
<br />
<a style="background: #fff;
    display: inline-block;
    margin: 1px;
    border-radius: 2px;
    border: 1px solid #ddd;
    padding: 6px;" href="/files/7.zip"><i style="color: #0088cc;width: 18px;height: 18px;" class="fa fa-fire"></i> <strong>Вывод средств DCMS </strong></a> <br />

<br />
<strong>Не нашли модуль под любую популярную CMS напишите в тикет и оставьте заявку на добавление !<strong>
</div>

</div>
<?
require ('../core/foot.php');
?>
