$(document).ready(function () {
  $('a[href^="#"]').click(function () {
    var elementClick = $(this).attr("href");
    var destination = $(elementClick).offset().top - 60;
    jQuery("html:not(:animated), body:not(:animated)").animate({scrollTop: destination}, 800);
    return false;
  });

  $('[name="country"]').on('change', function () {
    var geoKey = $(this).find('option:selected').val();
    var data = $jsonData.prices[geoKey];
    var price = data.price;
    var oldPrice = data.old_price;
    var currency = data.currency;
    $("[value = " + geoKey + "]").attr("selected", true).siblings().attr('selected', false);

    $('.price_land_s1').text(price);
    $('.price_land_s2').text(oldPrice);
    $('.price_land_curr').text(currency);
  });

  $('.rev-slider').slick({
    infinite: false,
    autoplay: false,
    dots: false,
    arrows: true,
    fade: false,
    speed: 300,
    slidesToShow: 3,
    prevArrow: '<span data-role="none" class="slick-prev animate" aria-label="Previous" tabindex="0" role="button"></span>',
    nextArrow: '<span data-role="none" class="slick-next animate" aria-label="Next" tabindex="0" role="button"></span>',
    responsive: [
      {
        breakpoint: 959,
        settings: {
          slidesToShow: 2,
          slidesToScroll: 1,
          infinite: true
        }
      },
      {
        breakpoint: 639,
        settings: {
          slidesToShow: 1,
          slidesToScroll: 1,
          infinite: true,
          adaptiveHeight: true
        }
      }
    ]
  });
});
