<?php
html::title('Подключить стикеры');
acms_header();
access('users');  
  
/*
------------------
Подключить стикеры
------------------
*/ 
  
if (get('id')){
  
  $dir = db::get_string("SELECT * FROM `SMILES_DIR` WHERE `ID` = ? AND `TYPE` = 'stickers' LIMIT 1", [intval(get('id'))]);
  
  if (isset($dir['ID'])){
    
    $stick_set = db::get_string("SELECT * FROM `STICKERS` WHERE `USER_ID` = ? AND `ID_DIR` = ? AND `TIME` > ? LIMIT 1", [user('ID'), $dir['ID'], TM]);
    
    ?>
    <div class='list'>
    <center><b><?=tabs($dir['NAME'])?><br /><?=lg('Стоимость пакета стикеров')?>: 1 <?=lg('день')?> = <?=money($dir['STICKERS_SUM'], 3)?></b></center>
    </div>
    <?
      
    if (post('ok')){
      
      valid::create(array(
        
        'STICKERS_TIME' => ['stickers_time', 'number', [1,9999], 'Количество дней']
      
      ));
      
      $st1 = STICKERS_TIME * 86400;
      $stick = TM + $st1;
      $stm = $dir['STICKERS_SUM'] * STICKERS_TIME;
      
      if (user('MONEY') < $stm){
        
        error('Недостаточно денег на счету');
        redirect('/shopping/stickers/?id='.$dir['ID']);
      
      }
      
      if (isset($stick_set['ID'])){
        
        error('Данный пакет стикеров уже подключен');
        redirect('/shopping/stickers/?id='.$dir['ID']);
      
      }
      
      if (ERROR_LOG == 1){
        
        redirect('/shopping/stickers/?id='.$dir['ID']);
      
      }
      
      db::get_add("INSERT INTO `STICKERS` (`USER_ID`, `ID_DIR`, `TIME`) values(?, ?, ?)", [user('ID'), $dir['ID'], $stick]);
      db::get_set("UPDATE `USERS` SET `MONEY` = ? WHERE `ID` = ? LIMIT 1", [(user('MONEY') - $stm), user('ID')]);
      
      success('Пакет стикеров успешно подключен');
      redirect('/shopping/stickers/?id='.$dir['ID']);
    
    }
    
    ?><div class='list'><?
      
    if (isset($stick_set['ID'])){
      
      ?><?=icons('clock-o', 15, 'fa-fw')?> <?=lg('Срок действия закончится')?>:<br /> <span class='count'><?=ftime($stick_set['TIME'])?></span><?
      
    }else{
      
      ?>
      <form method='post' class='ajax-form' action='/shopping/stickers/?id=<?=$dir['ID']?>'>
      <b><?=lg('На сколько дней подключить')?>:</b><br />
      <?=html::input('stickers_time', '0', null, null, null, 'form-control-30', 'number', null, 'clock-o')?>
      <?=html::button('button ajax-button', 'ok', 'plus', 'Подключить')?>
      </form>
      <?
      
    }
    
    ?>
    </div>
    <div class='list'>
    <?
      
    $column = db::get_string("SELECT COUNT(*) FROM `SMILES` WHERE `ID_DIR` = ?", [$dir['ID']]);
    
    if ($column == 0){
      
      echo lg('Пока пусто');
    
    }
    
    $data = db::get_string_all("SELECT * FROM `SMILES` WHERE `ID_DIR` = ? ORDER BY `ID` DESC", [$dir['ID']]);
    while ($list = $data->fetch()){
      
      echo " <img class='img' src='/files/upload/smiles/".$list['ID'].".".$list['EXT']."' style='max-width: 100px'> ";
    
    }
    
    ?></div><?
      
    back('/shopping/stickers/');
    acms_footer();
  
  }
  
}
  
/*
---------------
Список стикеров
---------------
*/
  
$column = db::get_column("SELECT COUNT(*) FROM `SMILES_DIR` WHERE `TYPE` = 'stickers'");
  
?><div class='list-body'><?

if ($column == 0){
  
  ?>
  <div class='list-menu'>
  <?=lg('Пока нет стикеров')?>
  </div>
  <?
  
}
  
$data = db::get_string_all("SELECT * FROM `SMILES_DIR` WHERE `TYPE` = 'stickers' ORDER BY `ID` DESC");
while ($list = $data->fetch()) {
  
  $stickers = db::get_string("SELECT * FROM `SMILES` WHERE `ID_DIR` = ? ORDER BY `ID` DESC LIMIT 1", [$list['ID']]);
  
  ?>
  <a href='/shopping/stickers/?id=<?=$list['ID']?>'>
  <div class='list-menu hover'>
  <?
  
  if (isset($stickers['ID'])){
    
    echo "<img class='img' src='/files/upload/smiles/".$stickers['ID'].".".$stickers['EXT']."' style='max-width: 100px'><br />";
    
  }
  
  ?>
  <b><?=tabs($list['NAME'])?></b><br />
  <b><?=lg('Стоимость в сутки')?>:</b> <?=money($list['STICKERS_SUM'], 3)?>
  </div></a>
  <?
  
}

?></div><?
  
back('/shopping/');
acms_footer();