<?php      
html::title('Добавить в черный список');
acms_header();
access('users');

$account = db::get_string("SELECT `ID` FROM `USERS` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);

if (!isset($account['ID']) && $account['ID'] == user('ID')){
  
  error('Пользователь не найден');
  redirect('/');
  
}

if (db::get_column("SELECT COUNT(*) FROM `BLACKLIST` WHERE `USER_ID` = ? AND `BLACK_LIST_ID` = ? AND (`BAN_TIME` = ? OR `BAN_TIME` > ?) LIMIT 1", [user('ID'), $account['ID'], 0, TM]) > 0){
  
  error('Пользователь уже в черном списке');
  redirect('/id'.$account['ID']);
  
}

if (post('ok')){
  
  valid::create(array(
    
    'B_MESSAGE' => ['message', 'text', [0, 500], 'Комментарий', 0],
    'B_BAN' => ['ban', 'number', [0, 99999999], 'Срок'],
    'B_REASON' => ['message', 'number', [0, 20000], 'Причина']
  
  ));
  
  if (B_BAN == 0){
    
    $nblock = 0;
  
  }else{
    
    $nblock = B_BAN + TM;
  
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/account/blacklist/add/?id='.$account['ID']);
  
  }
  
  db::get_add("INSERT INTO `BLACKLIST` (`REASON`, `BLACK_LIST_ID`, `USER_ID`, `MESSAGE`, `TIME`, `BAN_TIME`) VALUES (?, ?, ?, ?, ?, ?)", [B_REASON, $account['ID'], user('ID'), B_MESSAGE, TM, $nblock]);
  
  success('Пользователь успешно добавлен в черный список');
  redirect('/account/blacklist/');

}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/account/blacklist/add/?id=<?=$account['ID']?>'>
<?=html::select('reason', array(
  1 => ['СПАМ, реклама', 1], 
  2 => ['Мошенничество', 2], 
  3 => ['Нецензурная брань, оскорбления', 3], 
  4 => ['Разжигание ненависти', 4], 
  5 => ['Пропаганда нацизма', 5], 
  6 => ['Пропаганда наркотиков', 6], 
  7 => ['Систематические нарушения', 7], 
  0 => ['Иная', 0]
), 'Причина бана', 'form-control-100-modify-select', 'ban')?> 
<?=html::select('ban', array(
  0 => ['Навсегда', 0], 
  60 => ['1 '.lg('минута'), 60], 
  300 => ['5 '.lg('минут'), 300], 
  600 => ['10 '.lg('минут'), 600],  
  1200 => ['20 '.lg('минут'), 1200], 
  1800 => ['30 '.lg('минут'), 1800], 
  3600 => ['1 '.lg('час'), 3600], 
  7200 => ['2 '.lg('часа'), 7200], 
  10800 => ['3 '.lg('часа'), 10800], 
  14400 => ['4 '.lg('часа'), 14400], 
  18000 => ['5 '.lg('часов'), 18000], 
  36000 => ['10 '.lg('часов'), 36000],    
  86400 => ['1 '.lg('день'), 86400], 
  172800 => ['2 '.lg('дня'), 172800], 
  259200 => ['3 '.lg('дня'), 259200], 
  345600 => ['4 '.lg('дня'), 345600], 
  432000 => ['5 '.lg('дней'), 432000], 
  864000 => ['10 '.lg('дней'), 864000],   
  1728000 => ['20 '.lg('дней'), 1728000], 
  2592000 => ['1 '.lg('месяц'), 2592000], 
  5184000 => ['2 '.lg('месяца'), 5184000], 
  7776000 => ['3 '.lg('месяца'), 7776000], 
  10368000 => ['4 '.lg('месяца'), 10368000], 
  12960000 => ['5 '.lg('месяцев'), 12960000],    
  15552000 => ['6 '.lg('месяцев'), 15552000], 
  31104000 => ['1 '.lg('год'), 31104000]  
), 'Срок', 'form-control-100-modify-select', 'clock-o')?>
<?=html::textarea(null, 'message', 'Комментарий', null, 'form-control-textarea', 7, 0)?>
<br /><br />
<?=html::button('button ajax-button', 'ok', 'ban', 'Добавить')?>
<form>
</div>
<?

acms_footer();