<?php
$section = db::get_string("SELECT * FROM `SUPPORT_SECTION` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]); 
html::title('Редактировать раздел');
acms_header();
access('support');

if (config('PRIVATE_SUPPORT') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (!isset($section['ID'])){
  
  error('Неверная директива');
  redirect('/m/support/');

}

if (post('ok_edit_sc')){
  
  valid::create(array(
    
    'SC_NAME' => ['name', 'text', [3, 120], 'Название', 0],
    'SC_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
  
  ));
  
  if (SC_NAME != $section['NAME'] && db::get_column("SELECT COUNT(*) FROM `SUPPORT_SECTION` WHERE `NAME` = ? LIMIT 1", [SC_NAME]) > 0){
    
    error('Раздел с таким названием уже существует');
    redirect('/m/support/section_edit/?id='.$section['ID']);
  
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/support/section_edit/?id='.$section['ID']);
  
  }
  
  db::get_set("UPDATE `SUPPORT_SECTION` SET `NAME` = ?, `MESSAGE` = ? WHERE `ID` = ? LIMIT 1", [SC_NAME, SC_MESSAGE, $section['ID']]);
  
  logs('Техническая поддержка - редактирование [url=/m/support/section_edit/?id='.$section['ID'].']раздела[/url]', user('ID'));
  success('Изменения успешно приняты');
  redirect('/m/support/section_show/?id='.$section['ID']);

}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/m/support/section_edit/?id=<?=$section['ID']?>'>
<?=html::input('name', 'Название', null, null, tabs($section['NAME']), 'form-control-100', 'text', null, 'list')?>
<?=html::textarea(tabs($section['MESSAGE']), 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0)?>  
<br /><br />
<?=html::button('button ajax-button', 'ok_edit_sc', 'save', 'Сохранить')?>
<a class='button-o' href='/m/support/section_show/?id=<?=$section['ID']?>'><?=lg('Отмена')?></a>
</form>
</div>
<?
  
back('/m/support/section_show/?id='.$section['ID']);
acms_footer();