<?php
html::title('Пользователи на карте');
acms_header();

?>
  
<style>
  
.users_maps {
  
  overflow: auto;
  height: 300px;
  position: relative;
  
}

.um_left {

  position: absolute;
  top: 50%;
  left: 10px;
  transform: translateY(-50%);
  background-color: #8D6EFF;
  width: 35px;
  height: 35px;
  line-height: 23px;
  color: white;
  text-align: center;
  border-radius: 8px;
  border: none;
  box-shadow: 0 0 10px rgba(0,0,0,0.5);
  
}

.um_right {

  position: absolute;
  top: 50%;
  right: 10px;
  transform: translateY(-50%);
  background-color: #8D6EFF;
  width: 35px;
  height: 35px;
  line-height: 23px;
  color: white;
  text-align: center;
  border-radius: 8px;
  border: none;
  box-shadow: 0 0 10px rgba(0,0,0,0.5);
  
}

.um_top {

  position: absolute;
  top: 10px;
  left: 50%;
  transform: translateX(-50%);
  background-color: #8D6EFF;
  width: 35px;
  height: 35px;
  line-height: 23px;
  color: white;
  text-align: center;
  border-radius: 8px;
  border: none;
  box-shadow: 0 0 10px rgba(0,0,0,0.5);
  
}

.um_bottom {

  position: absolute;
  bottom: 10px;
  left: 50%;
  transform: translateX(-50%);
  background-color: #8D6EFF;
  width: 35px;
  height: 35px;
  line-height: 23px;
  color: white;
  text-align: center;
  border-radius: 8px;
  border: none;
  box-shadow: 0 0 10px rgba(0,0,0,0.5);
  
}

.users_maps::-webkit-scrollbar { height: 0px; width: 0px; }
.users_maps::-webkit-scrollbar-button {  display: none; }
.users_maps::scrollbar { height: 0px; width: 0px; }
.users_maps::scrollbar-button {  display: none; }

.loc-count {
  
  height: 16px;
  width: 16px;
  background-color: white;
  color: black;
  position: absolute;
  z-index: 1;
  border-radius: 100%;
  text-align: center;
  line-height: 16px;
  font-size: 7px;
  font-weight: bold;
  overflow: hidden;
  border: 1px #F44336 solid;
  
}

.loc-count:hover {
  
  background-color: #44E14A;
  
}
  
</style>
  
<div style='position: relative'>
<div class='users_maps'>  
<?
  
$data = db::get_string_all("SELECT `COUNTRY` FROM `USERS_SETTINGS` WHERE `COUNTRY` IS NOT NULL GROUP BY `COUNTRY`");
while ($list = $data->fetch()) {
  
  $country = db::get_string("SELECT `ID` FROM `COUNTRY` WHERE `NAME` = ? LIMIT 1", [$list['COUNTRY']]);
  $column = db::get_column("SELECT COUNT(`ID`) FROM `USERS_SETTINGS` WHERE `COUNTRY` = ?", [$list['COUNTRY']]);
  
  if (isset($country['ID'])){
    
    ?><a href='/m/users_maps/country/?id=<?=$country['ID']?>'><?    
    require (ROOT.'/modules/users_maps/plugins/country.php');    
    ?></span></a><?
    
  }
  
}

?>
<img src='/style/users_maps/map.jpg' style='max-width: 1000px'>
</div>
<button class='um_top' onclick="um_top('-1')"><?=icons('arrow-up', 16, 'fa-fw')?></button>
<button class='um_bottom' onclick="um_bottom('1')"><?=icons('arrow-down', 16, 'fa-fw')?></button>  
<button class='um_left' onclick="um_left('-1')"><?=icons('arrow-left', 16, 'fa-fw')?></button>
<button class='um_right' onclick="um_right('1')"><?=icons('arrow-right', 16, 'fa-fw')?></button>
</div>
<?

back('/', 'На главную');
acms_footer();