<?php  
$support = db::get_string("SELECT * FROM `SUPPORT_THEM` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
$section = db::get_string("SELECT `NAME` FROM `SUPPORT_SECTION` WHERE `ID` = ? LIMIT 1", [$support['SECTION_ID']]);
html::title(lg('Запрос - %s', $support['NAME']));
acms_header();

if (!isset($support['ID'])){
  
  error('Неверная директива');
  redirect('/m/support/');

}

if (config('PRIVATE_SUPPORT') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if ($support['USER_ID'] != user('ID')){
  
  if (access('support', null) == false){
    
    error('У вас нет доступа к этой теме');
    redirect('/m/support/');
    
  }
  
}

/*
------------------
Блокировка запроса
------------------
*/

require_once (ROOT.'/modules/support/plugins/them_block.php');

/*
-------------------------
Закрытие/открытие запроса
-------------------------
*/

require_once (ROOT.'/modules/support/plugins/them_on_off.php');

/*
----------------
Удаление запроса
----------------
*/

require_once (ROOT.'/modules/support/plugins/them_delete.php');

if (access('support', null) == true){
  
  db::get_set("UPDATE `SUPPORT_JOURNAL` SET `SHOW` = ? WHERE `THEM_ID` = ? LIMIT 1", [1, $support['ID']]);
  
  if (post('message')){
    
    $message = "Вы получили ответ на свой запрос в службе технической поддержки. [url=/m/support/show/?id=".$support['ID']."]Перейти[/url].";  
    messages::get(intval(config('SYSTEM')), $support['USER_ID'], $message);
    
  }
  
}else{
  
  if (post('message')){
    
    db::get_set("UPDATE `SUPPORT_JOURNAL` SET `SHOW` = ? WHERE `THEM_ID` = ? LIMIT 1", [2, $support['ID']]);
    $message = "Новый ответ в службе технической поддержки. [url=/m/support/show/?id=".$support['ID']."]Перейти[/url].";  
    messages::get(intval(config('SYSTEM')), 1, $message);
    
  }
  
}

if (access('support', null) == true || $support['USER_ID'] == user('ID')){
  
  ?>
  <div class='list'>
  <a href='/m/support/edit/?id=<?=$support['ID']?>' class='btn'><?=icons('pencil', 15, 'fa-fw')?> <?=lg('Редактировать')?></a>
  <?
  
  if (access('support', null) == true){
    
    ?>
    <a href='/m/support/show/?id=<?=$support['ID']?>&get=delete&<?=TOKEN_URL?>' class='btn'><?=icons('trash', 15, 'fa-fw')?> <?=lg('Удалить')?></a>
    <?
      
    if ($support['ACTIVE'] == 1){
      
      ?>
      <a href='/m/support/show/?id=<?=$support['ID']?>&them=off&<?=TOKEN_URL?>' class='btn'><?=icons('lock', 15, 'fa-fw')?> <?=lg('Закрыть')?></a>
      <?
      
    }else{
      
      ?>
      <a href='/m/support/show/?id=<?=$support['ID']?>&them=on&<?=TOKEN_URL?>' class='btn'><?=icons('unlock', 15, 'fa-fw')?> <?=lg('Открыть')?></a>
      <?
      
    }
    
    if ($support['BAN'] == 0){
      
      ?>        
      <a href='/m/support/show/?id=<?=$support['ID']?>&them=ban_on&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Заблокировать')?></a>
      <?
      
    }else{
      
      ?>        
      <a href='/m/support/show/?id=<?=$support['ID']?>&them=ban_off&<?=TOKEN_URL?>' class='btn'><?=icons('ban', 15, 'fa-fw')?> <?=lg('Разблокировать')?></a>
      <?
      
    }
    
  }
  
  ?></div><?

}

if ($support['BAN'] == 1){
  
  html::empty('Запрос заблокирован администрацией', 'ban');
  back('/m/support/section_show/?id='.$support['SECTION_ID']);
  acms_footer();
  
}

?>
<div class='list-body'>
<div class='list-menu'>
<div class='user-info-mini'>
<div class='user-avatar-mini'>
<?=user::avatar($support['USER_ID'], 45, 1)?> 
</div>
<div class='user-login-mini' style='top: 4px; left: 55px;'>
<?=user::login($support['USER_ID'], 0, 1)?><br />
<span class='time'><?=ftime($support['TIME'])?></span>
</div>
</div>  
<br />
<b><?=icons('bullhorn', 15, 'fa-fw')?> <?=tabs($support['NAME'])?></b>
<br />    
<?=attachments_files($support['ID'], 'support', 320)?>
<br />
<?=text($support['MESSAGE'])?>
<br /><br />
<?=lg('Раздел')?>:  
<a href='/m/support/section_show/?id=<?=$support['SECTION_ID']?>'>
<?=lg(tabs($section['NAME']))?>
</a><br />
  
<?php
  
if ($support['PRIORITET'] == 0){      
  
  ?><?=lg('Важность')?>: <span class='info gray'><?=lg('низкая')?></span><?
  
}elseif ($support['PRIORITET'] == 1){      
  
  ?><?=lg('Важность')?>: <span class='info blue'><?=lg('cредняя')?></span><?
  
}elseif ($support['PRIORITET'] == 2){      
  
  ?><?=lg('Важность')?>: <span class='info red'><?=lg('высокая')?></span><?
  
}

?></div><?
  
if ($support['ACTIVE'] == 0 || $support['EDIT_TIME'] > 0){      
  
  ?><div class='list-menu'><small><?
    
  if ($support['EDIT_TIME'] > 0){
    
    ?>
    <?=icons('pencil', 12, 'fa-fw')?> <?=lg('Последний раз запрос редактировал')?> <a href='/id<?=$support['EDIT_USER_ID']?>'><?=user::login_mini($support['EDIT_USER_ID'])?></a> - <?=ftime($support['EDIT_TIME'])?>
    <br />
    <?
    
  }
  
  if ($support['ACTIVE'] == 0){
    
    ?>
    <?=icons('lock', 12, 'fa-fw')?> <?=lg('Запрос закрыт')?> <a href='/id<?=$support['ACTIVE_USER_ID']?>'><?=user::login_mini($support['ACTIVE_USER_ID'])?></a> - <?=ftime($support['ACTIVE_TIME'])?>
    <br />
    <?
    
  }
  
  ?></small><?
  
}

?>  
</div>
</div>
  
<div class='list'>
<b><?=lg('Комментарии')?></b> <span class='count'><?=db::get_column("SELECT COUNT(`ID`) FROM `COMMENTS` WHERE `OBJECT_ID` = ? AND `OBJECT_TYPE` = ? LIMIT 1", [$support['ID'], 'support_comments'])?></span>
</div>
  
<?  
if (user('ID') == 0 || $support['ACTIVE'] == 0){
  
  $comments_set = 'Извините, для вас комментирование недоступно';
  
}

comments('/m/support/show/?id='.$support['ID'], 'support', 0, 'message', $support['USER_ID'], $support['ID']);

back('/m/support/section_show/?id='.$support['SECTION_ID']);
acms_footer();