<?php
html::title('Добавить раздел');
acms_header();
access('support');

if (config('PRIVATE_SUPPORT') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_add_sc')){
  
  valid::create(array(
    
    'SC_SUB_NAME' => ['name', 'text', [3, 120], 'Название', 0],
    'SC_SUB_MESSAGE' => ['message', 'text', [0, 200], 'Описание', 0]
  
  ));
  
  if (db::get_column("SELECT COUNT(*) FROM `SUPPORT_SECTION` WHERE `NAME` = ? LIMIT 1", [SC_SUB_NAME]) > 0){
    
    error('Раздел с таким названием уже существует');
    redirect('/m/support/section_add/');
  
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/support/section_add/');
  
  }
  
  $ID = db::get_add("INSERT INTO `SUPPORT_SECTION` (`NAME`, `MESSAGE`) VALUES (?, ?)", [SC_SUB_NAME, SC_SUB_MESSAGE]);
  
  logs('Техническая поддержка - добавление [url=/m/support/section_show/?id='.$ID.']раздела[/url]', user('ID'));
  success('Раздел успешно создан');
  redirect('/m/support/');

}

?>
<div class='list'>
<form method='post' class='ajax-form' action='/m/support/section_add/'>
<?=html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'list')?>
<?=html::textarea(null, 'message', 'Введите описание (не обязательно)', null, 'form-control-textarea', 9, 0)?>  
<br /><br />
<?=html::button('button ajax-button', 'ok_add_sc', 'plus', 'Добавить')?>
<a class='button-o' href='/m/support/'><?=lg('Отмена')?></a>
</form>
</div>
<?
  
back('/m/support/');
acms_footer();