<?php
$support = db::get_string("SELECT * FROM `SUPPORT_THEM` WHERE `ID` = ? LIMIT 1", [intval(get('id'))]);
html::title('Редактировать запрос');
acms_header();
access('users');

if (config('PRIVATE_SUPPORT') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (!isset($support['ID'])) {
  
  error('Неверная директива');
  redirect('/m/support/');

}

if (access('support', null) == false && $support['USER_ID'] != user('ID')){
  
  error('Нет прав');
  redirect('/m/support/show/?id='.$support['ID']);
  
}

if (post('ok_sp')){
  
  valid::create(array(
    
    'THEM_NAME' => ['name', 'text', [2, 200], 'Название', 0],
    'THEM_ID' => ['sc', 'number', [0, 99999], 'Раздел'],
    'THEM_PRIORITET' => ['prioritet', 'number', [0, 2], 'Приоритет важности'],
    'THEM_MESSAGE' => ['message', 'text', [10, 20000], 'Содержание', 0]
  
  ));
  
  if ($support['MESSAGE'] != THEM_MESSAGE && db::get_column("SELECT COUNT(*) FROM `SUPPORT_THEM` WHERE `MESSAGE` = ? LIMIT 1", [THEM_MESSAGE]) > 0){
    
    error('Запрос с таким содержимым уже существует');
    redirect('/m/support/edit/?id='.$support['ID']);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/support/edit/?id='.$support['ID']);
  
  }
  
  db::get_set("UPDATE `SUPPORT_THEM` SET `NAME` = ?, `MESSAGE` = ?, `EDIT_TIME` = ?, `EDIT_USER_ID` = ?, `SECTION_ID` = ?, `PRIORITET` = ? WHERE `ID` = ? LIMIT 1", [THEM_NAME, THEM_MESSAGE, TM, user('ID'), THEM_ID, THEM_PRIORITET, $support['ID']]);
  
  if (access('support', null) == true){
    
    logs('Техническая поддержка - редактирование запроса [url=/m/support/show/?id='.$support['ID'].']'.$support['NAME'].'[/url]', user('ID'));
    
  }
  
  success('Изменения успешно приняты');
  redirect('/m/support/show/?id='.$support['ID']);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/support/edit/?id=<?=$support['ID']?>'>
<?
html::input('name', 'Название', null, null, tabs($support['NAME']), 'form-control-100', 'text', null, 'bullhorn');
define('ACTION', '/m/support/edit/?id='.$support['ID']);
define('TYPE', 'support');
define('ID', $support['ID']);
html::textarea(tabs($support['MESSAGE']), 'message', 'Введите содержимое', null, 'form-control-textarea', 9);  
?><br /><br /><?
$array = array();
$data = db::get_string_all("SELECT * FROM `SUPPORT_SECTION` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($support['SECTION_ID'] == $list['ID'] ? "selected" : null)];

}
html::select('sc', $array, 'Раздел', 'form-control-100-modify-select', 'list'); 
html::select('prioritet', array(
  0 => ['Низкий', ($support['PRIORITET'] == 0 ? "selected" : null)], 
  1 => ['Средний', ($support['PRIORITET'] == 1 ? "selected" : null)], 
  2 => ['Высокий', ($support['PRIORITET'] == 2 ? "selected" : null)]
), 'Приоритет важности', 'form-control-100-modify-select', 'bullhorn');
html::button('button ajax-button', 'ok_sp', 'save', 'Сохранить');  
?>
<a class='button-o' href='/m/support/show/?id=<?=$support['ID']?>'><?=lg('Отмена')?></a>
<form>
</div>
<?

back('/m/support/show/?id='.$support['ID']);
acms_footer();