<?php
$id = intval(get('id'));
html::title('Создать запрос');
acms_header();
access('users');

if (config('PRIVATE_SUPPORT') == 0){
  
  error('Модуль отключен администратором');
  redirect('/');
  
}

if (post('ok_sp')){
  
  valid::create(array(
    
    'THEM_NAME' => ['name', 'text', [2, 200], 'Название', 0],
    'THEM_ID' => ['sc', 'number', [0, 99999], 'Раздел'],
    'THEM_PRIORITET' => ['prioritet', 'number', [0, 2], 'Приоритет важности'],
    'THEM_MESSAGE' => ['message', 'text', [10, 20000], 'Содержание', 0]
  
  ));
  
  if (db::get_column("SELECT COUNT(*) FROM `SUPPORT_THEM` WHERE `MESSAGE` = ? LIMIT 1", [THEM_MESSAGE]) > 0){
    
    error('Запрос с таким содержимым уже существует');
    redirect('/m/support/add/?id='.$id);
    
  }
  
  if (ERROR_LOG == 1){
    
    redirect('/m/support/add/?id='.$id);
  
  }
  
  $ID = db::get_add("INSERT INTO `SUPPORT_THEM` (`NAME`, `USER_ID`, `SECTION_ID`, `MESSAGE`, `TIME`, `EDIT_TIME`, `EDIT_USER_ID`, `PRIORITET`) VALUES (?, ?, ?, ?, ?, ?, ?, ?)", [THEM_NAME, user('ID'), THEM_ID, THEM_MESSAGE, TM, TM, user('ID'), THEM_PRIORITET]);
  db::get_add("INSERT INTO `SUPPORT_JOURNAL` (`USER_ID`, `THEM_ID`, `TIME`) VALUES (?, ?, ?)", [user('ID'), $ID, TM]);
  
  $message = "Новое обращение в службе технической поддержки. [url=/m/support/show/?id=".$ID."]Перейти[/url].";  
  messages::get(intval(config('SYSTEM')), 1, $message);
  
  db::get_set("UPDATE `ATTACHMENTS` SET `ID_POST` = ?, `ACT` = '1' WHERE `USER_ID` = ? AND `ACT` = '0' AND `TYPE_POST` = ?", [$ID, user('ID'), 'support']);
  
  success('Запрос успешно создан');
  redirect('/m/support/show/?id='.$ID);
  
}

?>    
<div class='list'>
<form method='post' class='ajax-form' action='/m/support/add/?id=<?=$id?>'>
<?
html::input('name', 'Название', null, null, null, 'form-control-100', 'text', null, 'bullhorn');
define('ACTION', '/m/support/add/?id='.$id);
define('TYPE', 'support');
define('ID', 0);
html::textarea(null, 'message', 'Введите содержимое', null, 'form-control-textarea', 9);  
?><br /><br /><?
$array = array();
$data = db::get_string_all("SELECT * FROM `SUPPORT_SECTION` ORDER BY `ID` DESC");  
while ($list = $data->fetch()){
  
  $array[$list['ID']] = [$list['NAME'], ($id == $list['ID'] ? "selected" : null)];

}
html::select('sc', $array, 'Раздел', 'form-control-100-modify-select', 'list'); 
html::select('prioritet', array(
  0 => ['Низкий', 0], 
  1 => ['Средний', 1], 
  2 => ['Высокий', 2]
), 'Приоритет важности', 'form-control-100-modify-select', 'bullhorn');
html::button('button ajax-button', 'ok_sp', 'plus', 'Добавить');  
?>
<a class='button-o' href='/m/support/section_show/?id=<?=$id?>'><?=lg('Отмена')?></a>
<form>
</div>
<?

back('/m/support/section_show/?id='.$id);
acms_footer();