<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if (!empty($id)) {

    $row = $db->selectRow("SELECT * FROM ?_data
                           WHERE `id` = ? LIMIT 1;", $id);

    if (!empty($row)) {

        $cid = intval($row['cid']);

        list($title,$about,$count) = $categories[$cid];

        $cat = '<a href="' . $config['site_url'] . '/' . gen_uri('category', $cid) . '">' . $title . '</a>';

        $url = '<a href="' . $config['site_url'] . '/' . gen_uri('post', $id) . '">' . $row['title'] . '</a>';

        $date = date('d.m.Y в H:i', strtotime($row['date']));

        $row['text'] = nl2br(smiles(bb_code($row['text'])));

        header('Content-type:text/html; charset=utf-8');

echo <<<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<style>
body,td { font-family: verdana, arial, sans-serif; color: #666; font-size: 80%; }
h1,h2,h3,h4 { font-family: verdana, arial, sans-serif; color: #666; font-size: 100%; margin: 0px; }
img {border:0}
</style>
<title>{$config['site_name']} > Версия для печати > {$row['title']}</title>
</head>
<body bgcolor="#ffffff" text="#000000">
<table border="0" width="100%" cellspacing="1" cellpadding="3">
<tr>
<td width="100%">
<a href="{$config['site_url']}">{$config['site_name']}</a> > {$cat}> {$url}
<hr><h1>{$row['title']}</h1><br />
<small>{$date}. Автор блога: <a href="/info.html">{$config['login']}</a></small></td>
</tr>
<tr>
<td width="100%">
{$row['text']}<br /><br />
<hr>
<a href="javascript:history.go(-1)">Вернуться назад</a>
</td>
</tr>
</table>
</body>
</html>
HTML;
exit;

    }
    else {

        addMessage('Ошибка! Выбранная вами статья не найдена, возможно она была удалена!', 'error');
        gen_red('index');
    }
}
else {

    $onpage = !empty($config['print_num']) ? (int) $config['print_num'] : 25;

    $rows = $db->select( "SELECT *
                          FROM ?_data ORDER BY `date` DESC 
                          LIMIT ?d, ?d", 0, $onpage );
    if (!empty($rows)) {

        header('Content-type:text/html; charset=utf-8');

        $date = date('d.m.Y в H:i', time());

echo <<<HTML
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
<style>
body,td { font-family: verdana, arial, sans-serif; color: #666; font-size: 80%; }
h1,h2,h3,h4 { font-family: verdana, arial, sans-serif; color: #666; font-size: 100%; margin: 0px; }
img {border:0}
</style>
<title>{$config['site_name']} > Версия для печати > Новое в блоге</title>
</head>
<body bgcolor="#ffffff" text="#000000">
<table border="0" width="100%" cellspacing="1" cellpadding="3">
<tr>
<td width="100%">
<hr><h1> Новое в блоге - {$config['site_name']}</h1><br />
<small>{$date}. Автор блога: <a href="/info.html">{$config['login']}</a></small></td>
</tr>
<tr>
<td width="100%">
HTML;

    $i = 0;
    foreach($rows as $row) {

        echo ++$i . '. <a href="' . $config['site_url'] . '/' . gen_uri('post', $row['id']) . '"><b>' . $row['title'] . '</b></a> (' . date('d.m.Y в H:i', strtotime($row['date'])) . ')<br />';

        echo nl2br(bb_code($row['text'])) . '<br /><br />';
    }

echo <<<HTML
<hr>
<a href="javascript:history.go(-1)">Вернуться назад</a>
</td>
</tr>
</table>
</body>
</html>
HTML;
exit;


    }
    else {

        addMessage('Произошла Ошибка! К сожалению статьи временно не доступны!', 'error');
        gen_red('index');
    }
}

?>
