<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if (!empty($_GET['id'])) {

    $post_id = intval($_GET['id']);

    $row = $db->selectRow( "SELECT * FROM ?_data WHERE `id` = ?", $post_id );

    if (!empty($row)) {

        if ($row['active'] == 0 && !$is_admin) {

            addMessage('Комментирование к данной статье запрещено!');
            gen_red('index');
        }

        show_header('Комментарии к статье: ' . $row['title'], $row['keys'], $row['desc']);

        $onpage = !empty($config['comm_num']) ? (int) $config['comm_num'] : 10;

        if ($page > 1) $from = ($page - 1) * $onpage; else $from = 0;

        $comms = $db->selectPage( $total, "SELECT * FROM ?_comments
                                           WHERE `post` = ? 
                                           ORDER BY `id` DESC LIMIT ?d, ?d", $post_id, $from, $onpage );

        if (!empty($comms) && $total > 0) {

            if ($row['comm'] <> $total) { /* Обновление подсчета комментов */

                $db->query("UPDATE ?_data SET `comm` = ? WHERE `id` = ?", $total, $post_id);
            }

            if ($is_admin) {

                echo '<form action="' . ADMIN_DIR . '?a=del_comm&amp;back=' . $post_id . '&amp;rnd=' . $_SESSION['token'] . '" method="post">';
            }

            foreach( $comms as $comm ) {

                echo '<div class="downlist2"><img src="' . ICONS . 'user.gif" alt=""/> ';

                if (!empty($comm['level'])) {

                    echo '<span style="color:red;font-weight:bold;">' . $config['login'] . '</span>';
                }
                else echo '<span style="color:SteelBlue;font-weight:bold;">' . $comm['name'] . '</span>';

                $comm['text'] = nl2br(smiles(bb_code($comm['text'])));

                if ($config['anti_ads'] == 1) $comm['text'] = anti_ads($comm['text']);

                echo ' (' . date('d.m.Y в H:i)', strtotime($comm['date'])) . '<br />' . $comm['text'] . '<br />';

                if ($is_admin) {

                    echo '<hr/><input type="checkbox" name="del[]" value="' . $comm['id'] . '" /> <b>IP:</b> ' . $comm['ip'] . '<br /><b>Юзер Агент:</b> ' . $comm['ua'] . '<br />';

                    if (!empty($row['email'])) echo '<b>E-mail:</b> ' . $comm['email'];			
                }

                echo '</div>';
            }

            if ($is_admin) echo '<div class="downlist2"><input type="submit" value="Удалить выбранное" /></form></div>';
				
            echo show_pages(gen_uri('comments', $post_id));
        }
        else {

            echo '<div class="downlist2"><b>Комментариев к данной статье еще нет!</b></div>';
        }

        echo '<div class="downlist2">';

        if ($row['acomm'] == 1) {

            echo '<img src="' . ICONS . 'add.png" alt=""/> <a href="/' . gen_uri('add_comments', $post_id) . '">Добавить комментарий</a><br />';
        }

        echo '<img src="' . ICONS . 'return.png" alt=""/> <a href="' . gen_uri('post', $post_id) . '">К статье</a><br />
              <img src="' . ICONS . 'home.png" alt=""/> <a href="' . $config['site_url'] . '">На главную</a></div>';

    }
    else {

        addMessage('Ошибка 404 - Страница не найдена или ссылка неверна!', 'error');
        gen_red('index');
    }
}
else {

    addMessage('Ошибка 404 - Страница не найдена или ссылка неверна!', 'error');
    gen_red('index');
}

?>