<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if (!empty($id) && array_key_exists($id,$categories)) {

    list($title,$about,$count) = $categories[$id];

    show_header('Раздел: ' . $title, '', $about);

    $onpage = !empty($config['post_num']) ? (int) $config['post_num'] : 10;

    if ($page > 1) $from = ($page - 1) * $onpage; else $from = 0;

    if ($is_admin) {

        $rows = $db->selectPage( $total, "SELECT *, (SELECT `name` FROM ?_comments WHERE ?_comments.`post` = ?_data.`id` ORDER BY ?_comments.`id` DESC LIMIT 1) AS `author` FROM ?_data WHERE `cid` = ? ORDER BY `date` DESC LIMIT ?d, ?d", $id, $from, $onpage );

    }
    else {

        $rows = $db->selectPage( $total, "SELECT *, (SELECT `name` FROM ?_comments WHERE ?_comments.`post` = ?_data.`id` ORDER BY ?_comments.`id` DESC LIMIT 1) AS `author` FROM ?_data WHERE `cid` = ? AND `active` = '1' ORDER BY `date` DESC LIMIT ?d, ?d", $id, $from, $onpage );

    }

    if (!empty($rows) && $total > 0) {

        foreach( $rows as $row ) {

            $row['author'] = !empty($row['author']) ? $row['author'] : '';
            echo '<div class="downlist2">
            <div class="title"><a href="/' . gen_uri('post', $row['id']) . '"><b>' . $row['title'] . '</b></a></div><div>';
            echo format_text($row['text']) . '...<br />';
            if ($row['active'] == 0 && $is_admin) echo '[<span class="blink">Не опубликовано</span>]<br />';
            echo '<a href="/' . gen_uri('post', $row['id']) . '">Читать далее &#187;</a> | ';
            echo' <a href="/' . gen_uri('comments', $row['id']) . '">Комментарии</a> (' . $row['comm'] . ') ';
            echo '<font color="OliveDrab"><small> ' . $row['author'] . ' </small></font></div></div>';
        }

        echo show_pages(gen_uri('category', $id));
    }
    else {

        echo '<div class="downlist2"><b>В разделе пока нет статей!</b></div>';
    }

    echo '<div class="downlist2"><img src="' . ICONS . 'return.png" alt=""/> <a href="/' . gen_uri('category') . '">К разделам</a><br />';

    if ($is_admin) {

        echo '<img src="' . ICONS . 'add.png" alt=""/> <a href="' . ADMIN_DIR . '?a=add_cat">Добавить раздел</a><br />';
        echo '<img src="' . ICONS . 'add.png" alt=""/> <a href="' . ADMIN_DIR . '?a=add_post&amp;id=' . $id . '">Добавить статью</a><br />';
        echo '<img src="' . ICONS . 'return.png" alt=""/> <a href="' . ADMIN_DIR . '">Админ-панель</a><br />';
    }

}
else {

    show_header('Разделы блога');

    if (!empty($categories)) {

        foreach( $categories as $key => $val ) {

            list($title,$text,$count) = $val;
			
            echo '<div class="downlist2"><img src="' . ICONS . 'site.png" alt="" />
                  <a href="' . gen_uri('category', $key) . '">' . $title . '</a> (' . $count . ')';
			
            if ( $is_admin) {

                echo' [<a href="' . ADMIN_DIR . '?a=edit_cat&amp;id=' . $key . '">Изменить</a> / ';
                echo '<a href="' . ADMIN_DIR . '?a=del_cat&amp;id=' . $key . '">Удалить</a>]<br />';
            }
            else echo '<br />';
			
            echo '<small>' . smiles(bb_code($text)) . '</small></div>';
        }
    }
    else {

        echo '<div class="downlist2">Разделов нет!</div>';
    }

    echo '<div class="downlist2">';

    if ($is_admin) {

        echo '<img src="' . ICONS . 'add.png" alt=""/> <a href="' . ADMIN_DIR . '?a=add_cat">Добавить раздел</a><br />';
        echo '<img src="' . ICONS . 'return.png" alt=""/> <a href="' . ADMIN_DIR . '">Админ-панель</a><br />';
    }
}

    echo '<img src="' . ICONS . 'home.png" alt=""/> <a href="' . $config['site_url'] . '">На главную</a></div>';

?>
