<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if ($config['open_stat'] == 0 && !$is_admin) {

    addMessage('Статистика закрыта администратором!');
    gen_red('index');
}

show_header('Статистика блога ' . $config['site_name']);

$_TIME = time();

# Определение веса папки
function dir_size($dir) {

    $totalsize = 0;

    if ($dirstream = @opendir($dir)) {

        while (false !== ($filename = readdir($dirstream))) {

            if ($filename != '.' && $filename != '..') {

                if (is_file($dir . '/' . $filename)) $totalsize += @filesize($dir . '/' . $filename);

                if (is_dir($dir . '/' . $filename)) $totalsize += dir_size($dir . '/' . $filename);
            }
        }
    }

    closedir($dirstream);
    return $totalsize;
}

# Функция подсчета файлов в папке
function count_dir($dir, $new = 7) {

    $count    = 0;
    $newcount = 0;
    $bad_file = array('.', '..', '.htaccess', 'index.php');
    $sitetime = time();

    if ( $path = opendir($dir) ) {

        while( $file = readdir($path) ) {

            if (!in_array($file,$bad_file )) {

                $count++;
                $filetime = filemtime($dir . '/' . $file) + (3600 * 24 * $new);

                if ($filetime > $sitetime) {

                    $newcount ++;
                }
            }
        }
        closedir($path);

        return array($count, $newcount);
    }
}

/*
Кеширование статаистики, обновление раз в 3600 сек.
*/

$stat = get_vars('stat_blog', 3600);

if ( !$stat ) {

    $stat = array(); $stat['count_dirs'] = $stat['count_files'] = 0;

    $tables = $db->select( "SHOW TABLE STATUS FROM `" . $config['db_name'] . "`" );

    $stat['mysql_size'] = 0;

    foreach( $tables as $table ) {

        //if( strpos( $table['Name'], $config['db_prefix'] ) !== false ) {

            $stat['mysql_size'] += $table['Data_length'] + $table['Index_length'];
        //}
    }

    $stat['mysql_size'] = size($stat['mysql_size']);

    $tmp_size = count_dir(ROOTPATH . '/files');

    $stat['file_num']  = $tmp_size[0]; // или можно оставить подсчет файлов из базы, тогда раскомментировать ниже...

    $stat['file_week'] = $tmp_size[1];

    $stat['file_size'] = size(dir_size(ROOTPATH . '/files/'));

    $stat['news_num']  = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_data" );

    $stat['news_allow'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_data WHERE active = '1'" );

    //$stat['file_num'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_list_file" );

    $stat['comm_num'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_comments" );

    $stat['news_moder'] = round($stat['news_num'] - $stat['news_allow']);

    $temp_date = date( 'Y-m-d H:i', $_TIME - (3596 * 24) );

    $stat['news_day'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_data WHERE date >= ? AND date <= ? + INTERVAL 24 HOUR AND active = '1'", $temp_date, $temp_date );

    $stat['comm_day'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_comments WHERE date >= ? AND date <= ? + INTERVAL 24 HOUR", $temp_date, $temp_date );

    $temp_date = date( 'Y-m-d H:i', $_TIME - (3600 * 24 * 7) );

    $stat['news_week'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_data WHERE date >= ? AND date <= ? + INTERVAL 7 DAY AND active = '1'", $temp_date, $temp_date );
	
    $stat['comm_week'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_comments WHERE date >= ? AND date <= ? + INTERVAL 7 DAY", $temp_date, $temp_date );
	
    $temp_date = date( 'Y-m-d H:i', $_TIME - (3600 * 24 * 31) );

    $stat['news_month'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_data WHERE date >= ? AND date <= ? + INTERVAL 31 DAY AND active = '1'", $temp_date, $temp_date );
	
    $stat['comm_month'] = (int) $db->selectCell( "SELECT COUNT(*) FROM ?_comments WHERE date >= ? AND date <= ? + INTERVAL 31 DAY", $temp_date, $temp_date );

    set_vars('stat_blog',$stat);

}

echo '<div class="downlist2">
Разделов в блоге: <b>' . count($categories) . '</b><br />
<b>Статьи:</b><br />
Общее кол-во статей: <b>' . $stat['news_num'] . '</b><br />
Из них опубликовано: <b>' . $stat['news_allow'] . '</b><br />
Ожидает публикации: <b>' . $stat['news_moder'] . '</b><br />
Опубликовано за месяц: <b>' . $stat['news_month'] . '</b><br />
Опубликовано за неделю: <b>' . $stat['news_week'] . '</b><br />
Опубликовано за сутки: <b>' . $stat['news_day'] . '</b><br />
</div>
<div class="downlist2">
<b>Комментарии:</b><br />
Всего комментариев: <b>' . $stat['comm_num'] . '</b><br />
[ <a href="/lastcomments.html">Посмотреть последние комментарии</a> ]<br />
Добавлено за месяц: <b>' . $stat['comm_month'] . '</b><br />
Добавлено за неделю: <b>' . $stat['comm_week'] . '</b><br />
Добавлено за сутки: <b>' . $stat['comm_day'] . '</b><br />
</div>
<div class="downlist2">
<b>Файлы:</b><br />
Всего файлов: <b>' . $stat['file_num'] . '</b><br /> 
Новых за неделю: <b>' . $stat['file_week'] . '</b><br />
Общим размером: <b>' . $stat['file_size'] . '</b><br />';

if ($is_admin) {

    echo 'Размер БД: <b>' . $stat['mysql_size'] . '</b><br />';
    echo '</div><div class="downlist2">';
    echo '<img src="' . ICONS . 'return.png" alt=""/> <a href="' . ADMIN_DIR . '">Админ-панель</a><br />';
}
else echo '</div><div class="downlist2">';

echo '<img src="' . ICONS . 'home.png" alt=""/> <a href="' . $config['site_url'] . '">На главную</a></div>';

?>
