<?php

if (!defined('BLOG')) { die('Access Denied!'); }

$rss_date    = date('r', time());

$rss_content = <<<XML
<?xml version="1.0" encoding="utf-8"?>
<rss version="2.0" xmlns:dc="http://purl.org/dc/elements/1.1/">
<channel>
<title>{$config['rss_title']}</title>
<link>{$config['site_url']}/</link>
<language>ru</language>
<description>{$config['rss_title']}</description>
<generator>{$config['site_name']}</generator>
XML;

if ( !$config['allow_rss'] ) {

	$rss_content .= <<<XML
<item>
<title>RSS новости выключены</title>
<guid isPermaLink="true"></guid>
<link></link>
<description>RSS лента новостей выключена</description>
<category>undefined</category>
<dc:creator>{$config['site_name']}</dc:creator>
<pubDate>{$rss_date}</pubDate>
</item>
XML;

} else {

    $onpage = !empty($config['rss_num']) ? (int) $config['rss_num'] : 25;

    $rows = $db->select( "SELECT * FROM ?_data 
                          WHERE `active` = '1'
                          ORDER BY `date` DESC 
                          LIMIT ?d, ?d", 0, $onpage );

    if (!empty($rows)) {

        foreach( $rows as $row ) {

            $row['text']     = smiles(bb_code($row['text']));
            $row['text']     = strip_str(htmlspecialchars(strip_tags($row['text'], '<img>')),50);
            $rss_link        = $config['site_url'] . '/' . gen_uri('post', $row['id']);
            $rss_date        = date('r', strtotime($row['date']));
            list($rss_cat,,) = $categories[$row['cid']];
		
            $rss_content .= <<<XML
<item>
<title>{$row['title']}</title>
<guid isPermaLink="true">{$rss_link}</guid>
<link>{$rss_link}</link>
<description>{$row['text']}</description>
<category>{$rss_cat}</category>
<dc:creator>{$config['login']}</dc:creator>
<pubDate>{$rss_date}</pubDate>
</item>
XML;
        }
    }
    else {

        $rss_content .= <<<XML
<item>
<title>RSS новости не найдены</title>
<guid isPermaLink="true"></guid>
<link></link>
<description>RSS новости не найдены</description>
<category>undefined</category>
<dc:creator>{$config['site_name']}</dc:creator>
<pubDate>{$rss_date}</pubDate>
</item>
XML;

    }
}

$rss_content .= <<<XML

</channel></rss>
XML;

header( 'Content-type: application/xml' );

echo $rss_content;

exit;

?>