<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if ( empty($config['email']) ) {

    addMessage('Сервис временно недоступен!', 'error');
    gen_red('index');
}

$dicq = 'none'; $dmail = 'block';

if (!empty($_POST['send'])) {

    $name    = !empty($_POST['name'])    ? check($_POST['name'])      : '';
    $mail    = !empty($_POST['mail'])    ? strtolower($_POST['mail']) : '';
    $icq     = !empty($_POST['icq'])     ? check($_POST['icq'])       : '';
    $subject = !empty($_POST['subject']) ? check($_POST['subject'])   : 'Письмо с сайта ' . $config['site_name'];
    $message = !empty($_POST['message']) ? check($_POST['message'])   : '';
    $type    = !empty($_POST['type'])    ? check($_POST['type'])      : '';
    $code    = !empty($_POST['code'])    ? num($_POST['code'])        : '';
    $error   = '';
    $_SESSION['captcha_key'] = !empty($_SESSION['captcha_key']) ? $_SESSION['captcha_key'] : NULL;
    $_SESSION['captcha_failures'] = !empty($_SESSION['captcha_failures']) ? (int) $_SESSION['captcha_failures'] : 0;
    $_SESSION['crc32'] = !empty($_SESSION['crc32']) ? (int) $_SESSION['crc32'] : 0;

    $len_name = cms_strlen($name);
    $len_subj = cms_strlen($subject);
    $len_mess = cms_strlen($message);

    if ( $_SESSION['captcha_key'] === NULL || $_SESSION['captcha_key'] != $code ) {

        if ( ++$_SESSION['captcha_failures'] == 3 ) {

            $error = 'Вы ввели несколько раз подряд неверный код с картинки. Сгенерирован новый код.';

            $_SESSION['captcha_key'] = NULL;
            $_SESSION['captcha_failures'] = 0;
        }
        else $error = 'Проверочное число не совпало с данными на картинке!';
    }
    else if ($len_name < 3) {

        $error = 'Слишком короткое имя, необходимо от 3 до 25 символов!';
    }
    else if ($len_name > 25) {

        $error = 'Слишком длинное имя, необходимо от 3 до 25 символов!';
    }
    else if ($type <> 'icq' && $type <> 'mail') {

        $error = 'Неверно указан &quot;Тип сообщения&quot;';
    }
    else if (empty($mail) && $type <> 'icq') {

        $error = 'Вы не указали свой E-Mail адресс!';
    }
    else if (!preg_match('#^([a-z0-9_\-\.])+\@([a-z0-9_\-\.])+(\.([a-z0-9])+)+$#', $mail) && $type <> 'icq') {

         $error = 'Вы ввели неверный адрес e-mail, необходим формат name@mail.ru!';
    }
    else if ( function_exists('dns_get_mx') && !dns_get_mx(substr(strrchr($mail, '@'), 1), $mx) && $type <> 'icq' ) {

        $error = 'Неверный E-Mail адрес! Почтовый сервер не найден!';
    }
    else if (empty($icq) && $type <> 'mail') {

        $error = 'Вы не указали свой ICQ номер!';
    }
    else if ( !is_numeric($icq)  && $type <> 'mail') {

        $error = 'Неверный формат ICQ! Разрешены только цифры!';
    }
    else if ($len_subj < 6) {

        $error = 'Слишком короткое название темы, необходимо от 5 до 100 символов!';
    }
    else if ($len_mess < 11) {

        $error = 'Слишком короткое сообшение, необходимо от 10 до 5000 символов!';
    }
    else if ($len_subj > 101) {

        $error = 'Слишком длинное название темы, необходимо от 5 до 100 символов!';
    }
    else if ($len_mess > 5000) {

        $error = 'Слишком длинное или короткое сообшение, необходимо от 10 до 5000 символов!';
    }
    else if ( crc32($message.$type) == $_SESSION['crc32'] ) {

        $error = 'Ваше сообщение <b>уже было успешно отправлено</b>!';
    }
    else $error = '';

    if ($type == 'icq') { $dicq  = 'block'; $dmail = 'none'; }
    else { $dicq = 'none'; $dmail = 'block'; }

    if (!empty($error)) {

        addMessage('Ошибка! ' . $error, 'error');
    }
    else {

        if ($type == 'mail') {

            $message .= "Ip: " . get_ip() . "\nБраузер: " . get_ua() . "\nОтправлено: " . date('j.m.Y / H:i', time());

            if ( SendMail($config['email'], $subject, $message, $mail, $name, '') ) {

                $_SESSION['crc32'] = crc32($message.$type);
                $_SESSION['captcha_key'] = NULL;
                $_SESSION['captcha_failures'] = 0;
                addMessage('Ваше сообщение успешно отправлено!', 'ok');
                gen_red('admin');
            }
            else addMessage('Произошла Ошибка! По тех. причинам в данный момент не удалось отправить сообщение. Попробуйте позже.', 'error');
        }
        else {

            include_once( ENGINE . '/classes/WebIcqPro.class.php' );

            $send = new WebIcqPro();
            $send->connect($config['icq_uin'], $config['icq_psd']) or die($send->error);

            $msg  = $subject . "\n" . $message . "\n---\n";
            $msg .= "Имя: " . $name . "\nICQ: " . $icq . "\n";
            $msg .= "Ip: " . get_ip() . "\nБраузер: " . get_ua() . "\nОтправлено: " . date('j.m.Y / H:i', time());
            $msg  = iconv('UTF-8', 'cp1251', $msg);

            if ($send->sendMessage($config['icq_uin'], $msg)) {

                $_SESSION['crc32'] = crc32($message.$type);
                $_SESSION['captcha_key'] = NULL;
                $_SESSION['captcha_failures'] = 0;
                addMessage('Ваше сообщение успешно отправлено!', 'ok');
                gen_red('admin');

            }
            else addMessage('Произошла Ошибка! По тех. причинам в данный момент не удалось отправить сообщение. Попробуйте позже.', 'error');
        }
    }
}

show_header('Письмо администратору сайта ' . $config['site_name']);

echo '<div class="downlist2"><form action="/' . gen_uri('feedback') . '" method="post" name="form">
<span class="blink">*</span> Ваше имя: <small>[max: ' . intval($config['max_author_comm']) . ']</small><br />
<input name="name" type="text" value="' . request('name') . '" /><br />';

if (!empty($config['icq_uin']) && !empty($config['icq_psd'])) {

    echo '<span class="blink">*</span> Тип сообщения:<br />';

    if (!empty($_REQUEST['type']) && $_REQUEST['type'] == 'icq') echo '<input type="radio" name="type" id="type"  value="icq" onchange="ShowType(this.value);" checked="checked" /> ICQ<br /><input type="radio" name="type" id="type" value="mail" onchange="ShowType(this.value);" /> E-Mail<br />';
else echo '<input type="radio" name="type" id="type"  value="icq" onchange="ShowType(this.value);" /> ICQ<br /><input type="radio" name="type" id="type" value="mail" onchange="ShowType(this.value);" checked="checked" /> E-Mail<br />';

    echo '<span style="display:' . $dmail . ';" id="dmail"><span class="blink">*</span> E-mail: <small>[max: 50]</small><br /><input name="mail" type="text" value="' . request('mail') . '" /><br /></span><span style="display:' . $dicq . ';" id="dicq"><span class="blink">*</span> ICQ: <small>[цифры 0-9]</small><br /><input name="icq" type="text" value="' . request('icq') . '" /><br /></span>';

}
else {

    echo '<span class="blink">*</span> E-mail: <small>[max: 50]</small><br /><input name="mail" type="text" value="' . request('mail') . '" /><br />';
}

echo '<span class="blink">*</span> Cообщение:<br />
<textarea name="message" cols="26" rows="5">' . request('message') . '</textarea><br />';

$pic_types = array('gif', 'jpg', 'png');
$pic_type  = !empty($_GET['type']) ? (string) $_GET['type'] : '';
$pic_type  = in_array($pic_type, $pic_types) ? $pic_type : 'gif';
$pic_links = array();

for ($i = 0; $i < count($pic_types); $i++) {

    if ( $pic_type != $pic_types[$i] ) {

        $pic_links[] = '<a title="' . strtoupper($pic_types[$i]) . '" href="' . gen_uri($mod, $id, 'type=' . $pic_types[$i]) . '">' . strtoupper($pic_types[$i]) . '</a>';
    }
}

echo '<span class="blink">*</span> Код с картинки:<br />
<input type="text" id="code" name="code" size="4" maxlength="3" />
<img align="absmiddle" src="/captcha.' . $pic_type . '" /> ' . implode(', ', $pic_links) . '<br />
<input name="send" type="submit" value="Отправить" /></form><br />
<span class="blink">*</span> обязательны к заполнению.</div>
<div class="downlist2">
<img src="' . ICONS . 'return.png" alt=""/> <a href="/' . gen_uri('admin') . '">Назад</a><br />
<img src="' . ICONS . 'home.png" alt=""/> <a href="' . $config['site_url'] . '">На главную</a></div>';

echo <<<HTML

<script type="text/javascript">
function ShowType(value) {
	if (value == 'icq') {
		document.getElementById('dicq').style.display = '';
	} else {
		document.getElementById('dicq').style.display = 'none';
	}
	if (value == 'mail') {
		document.getElementById('dmail').style.display = '';
	} else {
		document.getElementById('dmail').style.display = 'none';
	}
}
</script>

HTML;

?>