<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if (!empty($id)) {

    $row = $db->selectRow( "SELECT * FROM ?_data WHERE `id` = ? LIMIT 1", $id );

    if (!empty($row)) {

        if ( $row['active'] == 0 && !$is_admin ) {

            addMessage('Ошибка 404! Публикация не найдена или ссылка не верна!', 'error');
            gen_red('index');
        }

        if ( $row['acomm'] == 0 && !$is_admin ) {

            addMessage('Извините, комментирование этой статьи закрыто.!', 'info');
            gen_red('index');
        }

        if (!empty($_POST['send'])) {

            $_SESSION['crc32']            = !empty($_SESSION['crc32'])            ? $_SESSION['crc32'] : NULL;
            $_SESSION['captcha_key']      = !empty($_SESSION['captcha_key'])      ? $_SESSION['captcha_key'] : NULL;
            $_SESSION['captcha_failures'] = !empty($_SESSION['captcha_failures']) ? $_SESSION['captcha_failures'] : 0;

            $name     = !empty($_POST['name']) ? check($_POST['name']) : '';
            $mail     = !empty($_POST['mail']) ? strtolower(check($_POST['mail'])) : '';
            $text     = !empty($_POST['text']) ? check($_POST['text']) : '';
            $len_name = cms_strlen($name);
            $len_text = cms_strlen($text);
            $error    = '';

            if ( $_SESSION['captcha_key'] === NULL || $_SESSION['captcha_key'] != $_POST['code'] ) {

                $error = 'Неверный проверочный код с картинки!';

                if( ++$_SESSION['captcha_failures'] == 3 ) {

                    $error .= '<br />Вы ввели несколько раз подряд неверный код с картинки! Сгенерирован новый!';

                    $_SESSION['captcha_key'] = NULL; 
                    $_SESSION['captcha_failures'] = 0;
                }
            }
            else if ( $len_name < 3 || $len_name > $config['max_author_comm'] ) {

                $error = 'Слишком короткое или длинное имя!' . $len_name;
            }
            else if ( $len_text < 3 || $len_text > $config['max_text_comm'] ) {

                $error = 'Слишком короткий или длинный комментарий!';
            }
            else if ( crc32($text) == $_SESSION['crc32'] ) {

                $error = 'Ваш комментарий уже был успешно добавлен!';
            }
            else $error = '';

            if (!empty($error) && !$is_admin) {

                addMessage('Произошла Ошибка!<br />' . $error, 'error');
            }
            else {

                if ($is_admin) {

                    $name  = $uset['login'];
                    $mail  = $uset['email'];
                    $level = 1;
                }
                else $level = 0;

                $date = date('Y-m-d H:i:s', time());

                $com_id = (int) $db->query( "INSERT INTO ?_comments SET `post` = ?, `cat` = 'post', `name` = ?, `email` = ?, `text` = ?, `ip` = ?, `ua` = ?, `date` = ?, `level` = ?", $id, $name, $mail, $text, get_ip(), get_ua(), $date, $level );

                if ( $com_id < 1 ) {

                    addMessage('Произошла Ошибка! - В данный момент невозможно добавить ваш комментарий.', 'error');
                }
                else {

                    $_SESSION['crc32'] = crc32($text);

                    $db->query("UPDATE ?_data SET `comm` = (`comm` + 1) WHERE `id` = '$id' LIMIT 1;");

                    addMessage('Ваш комментарий успешно добавлен!', 'ok');

                    $_SESSION['captcha_key'] = NULL;
                    $_SESSION['captcha_failures'] = 0;

                    gen_red('comments', $id);
                }
            }
        }

        show_header('Комментарий к статье: ' . $row['title'], $row['keys'], $row['desc']);

        if (!empty($_GET['code'])) include( MODULES_PATH . 'code.inc.php' );
        else if (!empty($_GET['smiles'])) include( MODULES_PATH . 'smiles.inc.php' );

        echo '<div class="downlist2"><form action="/' . gen_uri($mod, $id) . '" method="post" name="form">';

        if (!$is_admin) {

            echo '<span class="blink">*</span> Ваше имя: <small>[max: ' . intval($config['max_author_comm']) . ']</small><br />
            <input name="name" type="text" value="' . request('name') . '" /><br />
            <span class="blink">*</span> E-mail: <small>[max: 50]</small><br />
            <input name="mail" type="text" value="' . request('mail') . '" /><br />
            <span class="blink">*</span> Cообщение: <small>[<a href="/' . gen_uri($mod, $id, 'smiles=1') . '">Смайлы</a>] 
            [<a href="/' . gen_uri($mod, $id, 'code=1') . '">ББ-коды</a>]</small><br />
            <textarea name="text" cols="26" rows="5">' . request('text') . '</textarea><br />';

            $pic_types = array('gif', 'jpg', 'png');
            $pic_type  = !empty($_GET['type']) ? (string) $_GET['type'] : '';
            $pic_type  = in_array($pic_type, $pic_types) ? $pic_type : 'gif';
            $pic_links = array();

            for ($i = 0; $i < count($pic_types); $i++) {

                if( $pic_type != $pic_types[$i] ) {

                    $pic_links[] = '<a title="' . strtoupper($pic_types[$i]) . '" href="' . gen_uri($mod, $id, 'type=' . $pic_types[$i]) . '">' . strtoupper($pic_types[$i]) . '</a>';
                }
            }

            echo '<span class="blink">*</span> Код с картинки:<br />
            <input type="text" id="code" name="code" size="4" maxlength="3" />
            <img align="absmiddle" src="/captcha.' . $pic_type . '" /> ' . implode(', ', $pic_links) . '<br />';
        }
        else {

            echo '<span class="blink">*</span> Cообщение: <small>[<a href="/' . gen_uri($mod, $id, 'smiles=1') . '">Смайлы</a>] [<a href="/' . gen_uri($mod, $id, 'code=1') . '">ББ-коды</a>]</small><br /><textarea name="text" cols="26" rows="5">' . request('text') . '</textarea><br />';
        }
        echo '<input name="send" type="submit" value="Добавить" /></form>
        <span class="blink">*</span> обязательны к заполнению.</div>
        <div class="downlist2">
        <img src="' . ICONS . 'return.png" alt=""/> <a href="/' . gen_uri('comments', $id) . '">К комментариям</a><br />
        <img src="' . ICONS . 'return.png" alt=""/> <a href="/' . gen_uri('post', $id) . '">К статье</a><br />
        <img src="' . ICONS . 'home.png" alt=""/> <a href="' . $config['site_url'] . '">На главную</a></div>';
    }
    else {

        addMessage('Ошибка 404 - Страница не найдена или ссылка неверна!', 'error');
        gen_red('index');
    }
}
else {

    addMessage('Ошибка 404 - Страница не найдена или ссылка неверна!', 'error');
    gen_red('index');

}

?>
