<?php

# Фиксирование времени начала выполнения скрипта
$mts = microtime(1);

define( 'DS', '/' );

define( 'VERSION', 'html' );

define( 'ENGINE', str_replace( "\\", "/", dirname(__FILE__) ) );

define( 'ROOTPATH', str_replace( "\\", "/", $_SERVER['DOCUMENT_ROOT'] ) );

define( 'CACHE_PATH', ENGINE . '/cache/' );

define( 'MODULES_PATH', ENGINE . '/modules/' );

define( 'TEMPLATES_PATH', ENGINE . '/templates/' );

define( 'THEMES_PATH', ROOTPATH . '/themes/' );

define( 'IMAGES_PATH', ROOTPATH . '/images/' );

define( 'IMAGES', '/images/' );

define( 'RND', mt_rand(1111, 9999) );

define( 'SP', 'blog' );
define( 'CP', 'blog' );

/* Настройки сайта */
if (!class_exists('ini')) {

    require_once( ENGINE . '/classes/ini.class.php' );
}

if (!file_exists( ENGINE . '/data/config.ini' )) {

    header('Location: /install.php'); die;
}

$config = ini::read( ENGINE . '/data/config.ini' );

define('ADMIN_DIR', DS . $config['admin_dir'] . DS);

error_reporting(0);
// Раскомментировать при отладке..
//error_reporting(E_ALL);
//ini_set('display_errors', true);
//ini_set('html_errors', true);
//ini_set('error_reporting', E_ALL);
//ini_set('error_log', '/error.log');

ini_set('register_globals', 0);
ini_set('url_rewriter.tags', '');
ini_set('session.use_cookies', 1);
ini_set('session.use_trans_sid', 1);
ini_set('date.timezone', 'Europe/Moscow');
mb_internal_encoding('UTF-8');
session_name('sid') or die('Невозможно инициализировать сессии!');
session_start() or die('Невозможно инициализировать сессии!');

$is_admin = false;

/* Подключили настройки БД и функции */
require_once( ENGINE . '/dbsimple/Generic.php' );
require_once( ENGINE . '/data/dbconfig.php' );
require_once( ENGINE . '/functions.php' );

$arr_themes = array('wap','web','touch');

if (!empty($_REQUEST['action_skin_change'])) {

    $skins = check($_REQUEST['action_skin_change']);

    if (preg_match('|^[a-z0-9_\-]+$|i', $skins)) {

        if (file_exists(THEMES_PATH . $skins . '/index.php')) {

            unset($_SESSION[SP]['themes']);

            $config['themes'] = $skins;
        }
    }

    addMessage('Тема успешно изменена!', 'ok');
}
else if (!empty($_SESSION[SP]['themes'])) {

    $config['themes'] = $_SESSION[SP]['themes'];
}

$_SESSION[SP]['themes'] = $config['themes'];

/* Подключаем шапку и ноги */

if (!is_file(THEMES_PATH . $config['themes'] . '/index.php')) {

    require_once( THEMES_PATH . 'html/index.php' );

    $_SESSION[SP]['themes'] = 'html';
}
else {

    require_once( THEMES_PATH . $config['themes'] . '/index.php' );
}

define( 'THEMES_DIR', '/themes/' . $_SESSION[SP]['themes'] . DS );

if (!defined('ICONS')) define('ICONS', '/images/icons/');

if (empty($_SESSION['token'])) {

    $_SESSION['token'] = random_string(6);
}

$id = !empty($_GET['id']) ? (int) $_GET['id'] : 0;
$mod = !empty($_GET['m']) ? (string) $_GET['m'] : '';
$page = !empty($_GET['page']) ? (int) $_GET['page'] : 1;

?>