<?php

if (!defined('BLOG')) { die('Access Denied!'); }

if (!defined('ENGINE')) { define('ENGINE', dirname(__FILE__)); }

#Фильтрация чисел
function num($id){return abs(intval($id));} 

#Фильтрация при записи в БД
function ms($text){return trim(mysql_real_escape_string($text));} 

#Фильтрация при выводе из БД
function html($text){return nl2br(stripslashes(htmlspecialchars($text, ENT_QUOTES)));}

#Переадресация
function go($url){header("Location: ".$url);}

#Антиреклама
function anti_ads($in){return preg_replace('#([a-z0-9\\s\-\.]){3,20}(\.|,)([a-z\\s]){2,4}#si','[реклама]',$in);}

# Функция подсветки кода
function highlight_code($code) {

    $code = nosmiles($code);
    $code = strtr($code, array('&lt;' => '<', '&gt;' => '>', '&amp;' => '&', '&quot;' => '"', '&#36;' => '$', '&#37;' => '%', '&#39;' => "'", '&#92;' => '\\', '&#94;' => '^', '&#96;' => '`', '&#124;' => '|', '<br />' => "\r\n"));
    $code = highlight_string($code, true);
    $code = strtr($code, array("\r\n" => '<br />', '$' => '&#36;', "'" => '&#39;', '%' => '&#37;', '\\' => '&#92;', '`' => '&#96;', '^' => '&#94;', '|' => '&#124;'));
    return $code;
}

# Вспомогательная функция для вставки ссылки
function url_replace($m) {

    if (!isset($m[3])) {

        $title = trim(stripslashes(preg_replace('/[\r\n\t]/i', ' ', strip_tags($m[2]))));

        $target = (strpos($m[1], $_SERVER['HTTP_HOST']) === false) ? ' target="_blank"' : '';

        return '<a href="' . $m[1] . '" title="' . $title . '"' . $target . '>' . $m[2] . '</a>';

    } else {

        $target = (strpos($m[3], $_SERVER['HTTP_HOST']) === false) ? ' target="_blank"' : '';

        return '<a href="' . $m[3] . '"' . $target . '>' . $m[3] . '</a>'; //http://...
    }
}

#BB-code
function bb_code($var) {

    if (strpos($var, '[') === false) {

        return $var;
    }

    $var = preg_replace('#\[b\](.*?)\[/b\]#si', '<b>\1</b>', $var);
    $var = preg_replace('#\[i\](.*?)\[/i\]#si', '<i>\1</i>', $var);
    $var = preg_replace('#\[u\](.*?)\[/u\]#si', '<u>\1</u>', $var);
    $var = preg_replace('#\[s\](.*?)\[/s\]#si', '<s>\1</s>', $var);
    $var = preg_replace('#\[big\](.*?)\[/big\]#si', '<big>\1</big>', $var);
    $var = preg_replace('#\[small\](.*?)\[/small\]#si', '<small>\1</small>', $var);
    $var = preg_replace('#\[del\](.*?)\[/del\]#si', '<del>\1</del>', $var);
    $var = preg_replace('#\[(red|green|blue|black|lime|maroon|yellow|orange)\](.*?)\[/\\1\]#is', '<span style="color:\1">\2</span>', $var);
    $var = preg_replace('#\[color=(\#[0-9A-F]{6}|[a-z]+)\](.*?)\[/color\]#si', '<span style="color: \1">\2</span>', $var);
    $var = preg_replace('#\[(left|right|center|justify)\](.*?)\[/\\1\]#is', '<div style="text-align:\1">\2</div>', $var);
    $var = preg_replace('#\[post=([0-9]+)\](.*?)\[/post\]#si', '<a href="' . gen_uri('post','\1') . '">\2</a>', $var);
    $var = preg_replace('#\[page=([a-zA-Z0-0\-\_]+)\](.*?)\[/page\]#si', '<a href="' . gen_uri('\1') . '">\2</a>', $var);

    $var = preg_replace('#\[url\=(http\://.+)\](.+)\[/url\]#i','<a href="\1">\2</a>',$var);
    $var = preg_replace('#\[img\](http\://.+)\[/img\]#i','<img src="\1">',$var);
    return $var;
}

function format_text($text = '') {

    global $config;
    $text = preg_replace('#\[(.*?)\](.*?)\[/(.*?)\]#siu', '\2', $text);
    $text = cms_substr($text, 0, $config['substr_text']);
    return nl2br($text);
}

# Функция замены и вывода смайлов
function smiles($str = '') {

    global $config;
    $str = str_replace(':','&#58;', $str);
    $str = preg_replace('|&#58;|',':', $str, 5); 
    $arrsmiles = array();
    $globsmiles = glob( ROOTPATH . '/images/smiles/*.gif' );
    foreach($globsmiles as $filename) {
        $arrsmiles[] = basename($filename, '.gif');
    }

    rsort($arrsmiles);

    foreach($arrsmiles as $smval){
        $str = str_replace(":$smval", '<img src="' . $config['site_url'] . '/images/smiles/' . $smval . '.gif" alt="" /> ', $str);
    }
    return str_replace('&#58;',':',$str);  
}

# Функция обратной замены смайлов
function nosmiles($str = '') {

    $str = preg_replace('|<img src="(.*?)/smiles/(.*?)\.gif" alt="(.*?)" />|', ':$2', $str);
    return $str;  
}

#функция определения размера файла или данных
function size($in){
	if($in>=1073741824){
		return '<b>'.round($in/1073741824 ,2).'</b> гб';
	}elseif($in>=1048576){
		return '<b>'.round($in/1048576 ,2).'</b> мб';
	}elseif($in>=1024){
		return '<b>'.round($in/1024 ,2).'</b> кб';
	}else{
		return '<b>'.round($in).'</b> байт';
	}
}

# Функция чтения шаблона
function loadTemplate($name = '') {

    if ( file_exists( TEMPLATES_PATH . $name . '.tpl') ) {

        $str = @file_get_contents( TEMPLATES_PATH . $name . '.tpl');
        $str = str_replace('<?', '', $str);
        $str = str_replace('?>', '', $str);
        $str = preg_replace( "#<iframe#i", "&lt;iframe", $str );
        //$str = preg_replace( "#<script#i", "&lt;script", $str );
        return $str;
    }
}


# Функция экранирования основных знаков
function check($str = '') {

    if (is_array($str)) {

        foreach( $str as $key => $val ) {

            $str[$key] = check($val);
        }
    }
    else {
        if (is_int($str)) {

            $str = intval($str);
        }
        else {
            $str     = htmlspecialchars($str);
            $search  = array('|', '\'', '$', '\\', '^', '%', '`', "\0", "\x00", "\x1A");
            $replace = array('&#124;', '&#39;', '&#36;', '&#92;', '&#94;', '&#37;', '&#96;', '', '', '');
            $str     = str_replace($search, $replace, $str);
            $str     = stripslashes(trim($str));
        }
    }
    return $str;
}

function request( $var, $default = NULL ) {

    if (!isset($_REQUEST[$var])) {

        return $default;
    }
    return htmlspecialchars(stripslashes(trim($_REQUEST[$var])));
}

# Функция преобразования в нижний регистр для UTF
function cms_tolower($str) {

    if (function_exists('mb_strtolower')) return mb_strtolower($str, 'utf-8');

    $arr = array('А' => 'а', 'Б' => 'б', 'В' => 'в', 'Г' => 'г', 'Д' => 'д', 'Е' => 'е', 'Ё' => 'ё', 'Ж' => 'ж', 'З' => 'з', 'И' => 'и', 'Й' => 'й', 'К' => 'к', 'Л' => 'л', 'М' => 'м', 'Н' => 'н', 'О' => 'о', 'П' => 'п', 'Р' => 'р', 'С' => 'с', 'Т' => 'т', 'У' => 'у', 'Ф' => 'ф', 'Х' => 'х', 'Ц' => 'ц', 'Ч' => 'ч', 'Ш' => 'ш', 'Щ' => 'щ', 'Ь' => 'ь', 'Ъ' => 'ъ', 'Ы' => 'ы', 'Э' => 'э', 'Ю' => 'ю', 'Я' => 'я', 'A' => 'a', 'B' => 'b', 'C' => 'c', 'D' => 'd', 'E' => 'e', 'I' => 'i', 'F' => 'f', 'G' => 'g', 'H' => 'h', 'J' => 'j', 'K' => 'k', 'L' => 'l', 'M' => 'm', 'N' => 'n', 'O' => 'o', 'P' => 'p', 'Q' => 'q', 'R' => 'r', 'S' => 's', 'T' => 't', 'U' => 'u', 'V' => 'v', 'W' => 'w', 'X' => 'x', 'Y' => 'y', 'Z' => 'z');
    return strtr($str,$arr);
}

# Функция транслита букв
function tr($s, $reverse = false) {

    $lat = array('Jo', 'jo', 'Yo', 'yo', 'Zh', 'zh', 'zh', 'Ch', 'ch', 'Sh', 'sh', 'Shc', 'shc', '', '', 'Ye', 'ye', 'Yu', 'yu', 'Ya', 'ya', 'Ja', 'ja', 'Y', 'y', 'A', 'a', 'B', 'b', 'C', 'c', 'D', 'd', 'E', 'e', 'F', 'f', 'G', 'g', 'H', 'h', 'I', 'i', 'K', 'k', 'L', 'l', 'M', 'm', 'N', 'n', 'O', 'o', 'P', 'p', 'Q', 'q', 'R', 'r', 'S', 's', 'T', 't', 'U', 'u', 'V', 'v', 'W', 'w', 'Y', 'y', 'Z', 'z');

    $cyr = array('Ё', 'ё', 'Ё', 'ё', 'Ж', 'ж', 'ж', 'Ч', 'ч', 'Ш', 'ш', 'Щ', 'щ', 'ъ', 'ь', 'Э', 'э', 'Ю', 'ю', 'Я', 'я', 'Я', 'я', 'Ы', 'ы', 'А', 'а', 'Б', 'б', 'Ц', 'ц', 'Д', 'д', 'Е', 'е', 'Ф', 'ф', 'Г', 'г', 'Х', 'х', 'И', 'и', 'К', 'к', 'Л', 'л', 'М', 'м', 'Н', 'н', 'О', 'о', 'П', 'п', 'Ь', 'ь', 'Р', 'р', 'С', 'с', 'Т', 'т', 'У', 'у', 'В', 'в', 'Ш', 'ш', 'Й', 'й', 'З', 'з');

    $result = array();

    if( $reverse ) {

        $tr = array_combine($cyr, $lat);
    }
    else
    {
        $tr = array_combine($lat, $cyr);    
    }

    for($p = 0; true; $p = strlen(implode($result))) {

        $part = substr($s, $p);
        $pos = strpos($part, '<');

        if( $pos !== false ) {

            $result[] = substr($part, 0, $pos); 
            $result[] = substr($part, $pos, strpos($part, '>') - $pos + 1);
        }
        else
        {
            if( $part !== '' ) {

                $result[] = $part;
            }

            break;
        }
    }

    for($i = 0; $i < count( $result ); $i++) {

        if( $result[$i] === '' ) {

            continue;
        }

        if( $result[$i][0] != '<' ) {

            $result[$i] = strtr($result[$i], $tr);
        }
        else if( !preg_match('#^<\d+>$#', rtrim($result[$i])) ) {

            $result[$i] = substr($result[$i], 1, strlen($result[$i]) - 2);
        }
    }

    return implode( $result );
}

# Функция генерации ссылок
function gen_uri($m, $id = '', $q = '', $v = '', $with_v = true, $with_sid = true) {
	
    $result = '';

    if ( $id ) {

        $result = $id . '.' . $m;
    }
    else if( $with_v == false && $m == 'index' ) {

        $result = '';
    }
    else {

        $result = $m;
    }

    if ( $with_v ) {

        if ( $v ) {

            $result .= '.' . $v;
        }
        else
        {
            $result .= '.' . VERSION;
        }
    }

    if ( $q ) {

        $result .= '?' . $q;
    }
    return $result;
}

# Функция переключения версий
function show_version($im = ' / ') {

    global $config, $arr_themes;

    $v = array();

    foreach($arr_themes as $val) {

        if ($config['themes'] == $val) $v[] = '<b>' . strtoupper($val) . '</b>';
        else $v[] = '<a href="?action_skin_change=' . $val . '">' . strtoupper($val) . '</a>';
    }

    return implode($im,$v);
}

# Функция обработки массива (int)
function intar($str) {
    if (is_array($str)) {
        return array_map('intval', $str);
    } else {
        return intval($str);
    }
}

# Функция обрезки по словам
function strip_str( $str, $num = 25 ) {

    $str = str_replace('<br />', ' ', $str);
    return implode(' ', array_slice(explode(' ', strip_tags($str)), 0, $num));
}

# Функция генерирования паролей
function random_string($len = '') {

    $chrs = 'AaBbCcDdEeFfGgHhIiJjKkLlMmNnPpQqRrSsTtUuVvWwXxYyZz0123456789';

    for($s = '', $i = 0; $i < $len; $i++) {

        $s .= $chrs[rand(0, strlen($chrs) - 1)];
    }

    return $s;
}

# Переадресация
function redirect($url, $code = '303') {

    if ($code == '301') {
        header('HTTP/1.1 301 Moved Permanently');
    } else {
        header('HTTP/1.1 303 See Other');
    }
    $url = str_replace('&amp;', '&', $url);
    header('Location: ' . $url);
    exit;
}

function gen_red($m = '', $id = '', $q = '', $code = '303') {

    if ($code == '301') {
        header('HTTP/1.1 301 Moved Permanently');
    } else {
        header('HTTP/1.1 303 See Other');
    }
    $url = gen_uri($m, $id, $q);
    $url = str_replace('&amp;', '&', $url);
    header('Location: /' . $url);
    exit;
}

/**
 * Добавляет сообщение в сессию
 * @param string $message
 * @param string $class
 */
function addMessage($message, $class = 'error') {

    if (!in_array($class, array('info', 'ok', 'warning', 'error', 'valid'))) return;
    $_SESSION['core_message'][] = array($class, $message);
}

# Функции кеширования
function set_vars($file, $data) {

    $fp = fopen( CACHE_PATH . $file . '.php', 'wb+' );
    fwrite( $fp, serialize( $data ) );
    fclose( $fp );
    @chmod( CACHE_PATH . $file . '.php', 0644 );
}

function get_vars($file, $time = 0) {

    if ( $time > 0 ) {

        if ( @filemtime( CACHE_PATH . $file . '.php' ) < time()-$time ) {

            return false;
        }
    }
    
    return unserialize( @file_get_contents( CACHE_PATH . $file . '.php' ) );
}

function del_vars($file) {
    
    return @unlink( CACHE_PATH . $file . '.php' );
}

# Постраничная навигация
function show_pages($path = '', $query = '', $rewrite = '') {

    global $config, $page, $onpage, $total;

    $onpage  = isset( $onpage ) ? (int) $onpage : $config['onpage'];
    $page    = isset( $_GET['page'] ) ? (int) $_GET['page'] : 1;
    $maxpage = ceil( $total / $onpage );
    if ( empty( $page ) || $page < 1 || $page > $maxpage ) $page = 1;

    $code = '';
    $links = array();
    $next = $page + 1;
    $prev = $page - 1;

    $show_start = '<div class="downlist2"><div class="navigation">';
    $show_stop  = '';

    if (!empty($rewrite)) {

        $path = empty($path) ? str_replace('.php', '', basename($_SERVER['PHP_SELF'])) : $path;

        if ($page > 1) $show_start .= '<a title="Назад" href="' . gen_uri($path, $rewrite . $prev, $query) . '">&lt;&lt; Назад</a>'; 
        else $show_start .= '<span>&lt;&lt; Назад</span>';

        if ($maxpage > $page) $show_stop .= '<a title="Далее  &gt;&gt;" href="' . gen_uri($path, $rewrite . $next, $query) . '">Далее  &gt;&gt;</a>'; 
        else $show_stop .= '<span>Далее &gt;&gt;</span>';

        if ($maxpage < 5) {

            $showform = false;

            for ($i = 1; $i < ($maxpage + 1); $i++)  {

                if ($i == $page) $links[] = '<span>' . $i . '</span>';
                else $links[] = '<a title="' . $i . '" href="' . gen_uri($path, $rewrite . $i, $query) . '">' . $i . '</a>';
            }
        }
        else {

            $showform = true;

            if ($page == 1) $links[] = '<span>1</span>';
            else $links[] = '<a title="1" href="' . gen_uri($path, $rewrite . '1', $query) . '">1</a>';

            if ($page > 2) {

                $links[] = '<span>...</span>';
                $links[] = '<a title="' . $prev . '" href="' . gen_uri($path, $rewrite . $prev, $query) . '">' . $prev . '</a>';
            }

            if ($page > 1) $links[] = '<span>' . $page . '</span>';

            if ($maxpage > $page) $links[] = '<a title="' . $next . '" href="' . gen_uri($path, $rewrite . $next, $query) . '">' . $next . '</a>';

            if ($maxpage > $page + 2) {

                $links[] .= '<span>...</span>';
                $links[] .= '<a title="' . $maxpage . '" href="' . gen_uri($path, $rewrite . $maxpage, $query) . '">' . $maxpage . '</a>';
            }
            else if ($maxpage > $page + 1) $links[] = '<a title="' . $maxpage . '" href="' . gen_uri($path, $rewrite . $maxpage, $query) . '">' . $maxpage . '</a>';
        }
    }
    else {

        $path = empty( $path ) ? $_SERVER['PHP_SELF'] : $path;
        
        if ( strpos($path, '?') === false ) {

            $path = $path . '?page=';
        }
        else {

            $path = $path . '&amp;page=';
        }

        if ($page > 1) $show_start .= '<a title="Назад" href="' . $path . $prev . $query . '">&lt;&lt; Назад</a>';
        else $show_start .= '<span>&lt;&lt; Назад</span>';

        if ($maxpage > $page) $show_stop .= '<a title="Далее" href="' . $path . $next . $query. '">Далее &gt;&gt;</a>';
        else $show_stop .= '<span>Далее &gt;&gt;</span>';

        if ($maxpage < 5) {

            $showform = false;

            for ($i = 1; $i < ($maxpage + 1); $i++) {

                if ($i == $page) $links[] = '<span>' . $i . '</span>';
                else $links[] = '<a title="' . $i . '" href="' . $path . $i . $query . '">' . $i . '</a>';
            }
        }
        else {

            $showform = true;

            if ($page == 1) $links[] = '<span>1</span>';
            else $links[] = '<a title="1" href="' . $path . '1' . $query . '">1</a>';

            if ($page > 2) {

                $links[] = '<span>...</span>';
                $links[] = '<a title="' . $prev . '" href="' . $path . $prev . $query . '">' . $prev . '</a>';
            }

            if ($page > 1) $links[] = '<span>' . $page . '</span>';

            if ($maxpage > $page) $links[] = '<a title="' . $next . '" href="' . $path . $next . $query . '">' . $next . '</a>';

            if ($maxpage > $page + 2) {

                $links[] .= '<span>...</span>';
                $links[] .= '<a title="' . $maxpage . '" href="' . $path . $maxpage . $query . '">' . $maxpage . '</a>';
            }
            else if ($maxpage > $page + 1) $links[] = '<a title="' . $maxpage . '" href="' . $path . $maxpage . $query . '">' . $maxpage . '</a>';
        }
    }

    if (count($links) < 2) return '';

    return $show_start . ' ' . implode(' ', $links) . ' ' . $show_stop . '</div></div>';
}

# Функции для обработки base64
function safe_encode($string) {
    $data = base64_encode($string);
    $data = str_replace(array('+', '/', '='), array('_', '-', ''), $data);
    return $data;
}

function safe_decode($string) {
    $string = str_replace(array('_', '-'), array('+', '/'), $string);
    $data = base64_decode($string);
    return $data;
}

# Функция шифрования по ключу
function xoft_encode($string, $key) {
    $result = '';
    for($i = 1; $i <= strlen($string); $i++) {
        $char = substr($string, $i-1, 1);
        $keychar = substr($key, ($i % strlen($key)) - 1, 1);
        $char = chr(ord($char) + ord($keychar));
        $result .= $char;
    }
    return safe_encode($result);
}

# Функция расшифровки по ключу
function xoft_decode($string, $key) {
    $string = safe_decode($string);
    $result = '';
    for($i = 1; $i <= strlen($string); $i++) {
        $char = substr($string, $i - 1, 1);
        $keychar = substr($key, ($i % strlen($key)) - 1, 1);
        $char = chr(ord($char) - ord($keychar));
        $result .= $char;
    }
    return $result;
}

# Аналог функции substr
function cms_substr($str, $start, $length = null, $charset = 'utf-8') {

    if ( strtolower($charset) == 'utf-8') {

        if (function_exists('mb_substr')) return mb_substr($str, $start, $length, 'utf-8');
        if (function_exists('iconv_substr')) return iconv_substr($str, $start, $length, 'utf-8');
        $str = utf_to_win($str);
        $str = substr($str, $start, $length);
        return win_to_utf($str);
    }
    else return substr($str, $start, $length);
}

# Аналог функции strlen
function cms_strlen($str, $charset = 'utf-8') {

    if ( strtolower($charset) == 'utf-8') {

        if (function_exists('mb_strlen')) return mb_strlen($str, 'utf-8');
        if (function_exists('iconv_strlen')) return iconv_strlen($str, 'utf-8');
        return strlen(utf8_decode($str));
    }
    else return strlen($str);
}

# Аналог функции strrpos
function cms_strrpos($str, $needle, $charset = 'utf-8') {

    if ( strtolower($charset) == 'utf-8') return iconv_strrpos($str, $needle, 'utf-8');
    else return strrpos($str, $needle);
}

# Функция определения реального IP
function get_ip() {

    if (isset($_SERVER['HTTP_X_FORWARDED_FOR']) && preg_match('|^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$|', $_SERVER['HTTP_X_FORWARDED_FOR'])) {

        $ip = $_SERVER['HTTP_X_FORWARDED_FOR'];
    }
    else if (isset($_SERVER['HTTP_CLIENT_IP']) && preg_match('|^[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}\.[0-9]{1,3}$|', $_SERVER['HTTP_CLIENT_IP'])) {

        $ip = $_SERVER['HTTP_CLIENT_IP'];
    }
    else {

        $ip = $_SERVER['REMOTE_ADDR'];
    }

    return check($ip);
}

# Функция определения реального браузера
function get_ua() {

    if (isset($_SERVER['HTTP_X_OPERAMINI_PHONE_UA'])) {

        $brow = $_SERVER['HTTP_X_OPERAMINI_PHONE_UA'];
    }
    else if (isset($_SERVER['HTTP_USER_AGENT'])) {

        $brow = $_SERVER['HTTP_USER_AGENT'];
    }
    else {

        $brow = 'unknown';
    }

    $brow = preg_replace('|http://|i','', $brow);
    $brow = strtok($brow,'( ');
    $brow = cms_substr($brow,0,22);
    return check($brow);
}

function StripMeta($str = '', $all = 0) {

    if ( $all ) $bad = array("\x22", "\x60", "\t", "\n", "\r", ",", ".", "/", "¬", "#", ";", ":", "@", "~", "[", "]", "{", "}", "=", "-", "+", ")", "(", "*", "^", "%", "$", "<", ">", "?", "!", '"');
    else $bad = array("\x22", "\x60", "\t", "\n", "\r", '"', "\\", '\r', '\n', "/", "{", "}", "[", "]");
    $str = html_entity_decode($str,ENT_QUOTES,'UTF-8');
    $str = preg_replace('#\[(.*?)\](.*?)\[/(.*?)\]#si', '\2', $str);
    $str = preg_replace('#\[(.*?)\]#siu', '', $str);
    $str = preg_replace('#\[/(.*?)\]#siu', '', $str);
    $str = str_replace(array('&nbsp;', '<br>', '<br/>', '<br />'), ' ', $str);
    $str = preg_replace('/\s/u', ' ', $str);
    $str = preg_replace('/ {2,}/u', ' ', $str);
    $str = str_replace($bad, '', trim(strip_tags(stripslashes($str))));
    return $str;
}

function genKeywords($str = '', $repeat = 0) {

    global $config;

    if ($str != '') {

        $offset = 0;
        $str = StripMeta($str,1);
        $str = cms_tolower($str);
        $str = str_replace(',', '', $str);
        $str = str_replace(' - ', ' ', $str);
        $keywords = Array();
        $keywords = str_word_count($str, 1, 'абвгдеёжзийклмнопрстуфхцчшщъьыэюя.');
        $new_keywords = $last_keywords = array();
        foreach($keywords as $key => $value) {

            if (cms_strlen(trim($value)) >= 4 && !is_numeric(trim($value))) $new_keywords[] = $value;
        }
        $new_keywords = array_count_values($new_keywords);
        foreach ($new_keywords as $new_key => $new_value) {

            if ($new_value > $repeat) $last_keywords[] = $new_key;
        }
        arsort($last_keywords);
        $total = count($last_keywords);
        $last_keywords = array_slice($last_keywords, $offset, 50);
        $last_keywords = implode(', ', $last_keywords);
        return $last_keywords;
    }
    else {

        return $config['site_keys'];
    }
}

function genDescription($str = '') {

    global $config;

    if ($str != '') {
        if ( cms_strlen($str) < 20 ) $str .= ' ' . $config['site_about'];
        $str = StripMeta($str);
        $str = implode(' ', array_slice(explode(' ', $str), 0, 40));
        if ( cms_strlen($str) > 300 ) {
            $str = implode(' ', array_slice(explode(' ', $str), 0, 25));
        }
        return $str;
    }
    else {

        return $config['site_desc'];
    }
}

# Функция приветствия
function WelCome($login = 'Гость') {

    if ( !defined('SITE_TIME') ):
      define( 'SITE_TIME', time() );
    endif;
    $chas = date( 'H', SITE_TIME );
    if ( $chas > 24 ):
      $chas = round($chas - 24);
    endif;
    if ( $chas < 0 ):
      $chas = round($chas + 24);
    endif;
    if ( $chas <= 4 || $chas >= 23 ):
      $welcome = 'Доброй ночи';
    else:
      if ( $chas >= 5 && $chas <= 10 ):
        $welcome = 'Доброе утро';
      else:
        if ( $chas >= 11 && $chas <= 17 ):
          $welcome = 'Добрый день';
        else:
          if ( $chas >= 18 && $chas <= 22 ):
            $welcome = 'Добрый вечер';
          endif;
        endif;
      endif;
    endif;
    return $welcome . ', ' . $login . '!';
}

# Функция показа рус. даты
function get_date($time = '', $format = 'd.m.y / H:i') {

    global $config;

    if (!is_numeric($time)) { $time = strtotime($time); }
    $date  = date($format, $time);
    $today = date('d.m.y', $time);
    $yesterday = date('d.m.y', strtotime('-1 day'));
    $date  = str_replace($today, 'Сегодня', $date);
    $date  = str_replace($yesterday, 'Вчера', $date);
    $eng   = array('January', 'February', 'March', 'April', 'May', 'June', 'July', 'August', 'September', 'October', 'November', 'December');
    $rus   = array('Января', 'Февраля', 'Марта', 'Апреля', 'Мая', 'Июня', 'Июля', 'Августа', 'Сентября', 'Октября', 'Ноября', 'Декабря');
    $date  = str_replace($eng, $rus, $date);
    return $date;
}

# Функция выводящая картинку рейтинга статьи
function raiting_vote($str ='') {

    global $rating_ext;

    $rating_ext = !empty($rating_ext) ? $rating_ext : 'gif';

    if (empty($str)) {
        $vote = '0';
    } 
    if ($str > '0' && $str <= '0.5') {
        $vote = 1;
    } 
    if ($str > '0.5' && $str <= '1') {
        $vote = 2;
    } 
    if ($str > '1' && $str <= '1.5') {
        $vote = 3;
    } 
    if ($str > '1.5' && $str <= '2') {
        $vote = 4;
    } 
    if ($str > '2' && $str <= '2.5') {
        $vote = 5;
    } 
    if ($str > '2.5' && $str <= '3') {
        $vote = 6;
    } 
    if ($str > '3' && $str <= '3.5') {
        $vote = 7;
    } 
    if ($str > '3.5' && $str <= '4') {
        $vote = 8;
    } 
    if ($str > '4' && $str <= '4.5') {
        $vote = 9;
    } 
    if ($str > '4.5' && $str <= '5') {
        $vote = 10;
    } 
    return '<img src="' . ICONS . 'rating' . $vote . '.' . $rating_ext . '" alt="" />';
}

# Функция отправки писем
function SendMail($to, $subject, $message, $from_mail = '', $from_name = '', $file_name = '') {

    global $config;

    $mail     = empty($from_mail) ? $config['admin_mail'] : $from_mail; // ??? - in config empty
    $name     = empty($from_name) ? $config['site_name'] : $from_name; // ??? - in config empty
    $subject  = iconv('UTF-8', 'cp1251', $subject);
    $message  = iconv('UTF-8', 'cp1251', $message);
    $name     = iconv('UTF-8', 'cp1251', $name);
    $subject  = convert_cyr_string($subject, 'w', 'k');
    $message  = convert_cyr_string($message, 'w', 'k');
    $name     = convert_cyr_string($name, 'w', 'k');
    $subject  = '=?KOI8-R?B?' . base64_encode($subject) . '?=';
    $br       = "\n";
    $uniqid   = md5(uniqid(time()));
    $headers  = 'From: ' . $name . ' <' . $mail . '>' . $br;
    $headers .= 'X-sender: ' . $name . ' <' . $mail . '>' . $br;
    $headers .= 'Reply-to: ' . $mail . $br;
    $headers .= 'Return-Path: ' . $mail . $br;
    $headers .= 'Message-ID: <' . $uniqid . '@' . $_SERVER['SERVER_NAME'] . '>' . $br;
    $headers .= 'MIME-Version: 1.0' . $br;
    $headers .= 'Date: ' . gmdate('D, d M Y H:i:s', time()) . $br;
    $headers .= 'X-Priority: 3' . $br;
    $headers .= 'X-MSMail-Priority: Normal' . $br;
    $headers .= 'X-Mailer: PHP v.' . phpversion() . $br;
    $headers .= 'X-MimeOLE: PHP v.' . phpversion() . $br;
    $headers .= 'Content-Type: multipart/mixed;boundary="----------' . $uniqid . '"' . $br . $br;
    $headers .= '------------' . $uniqid . $br;
    $headers .= 'Content-type: text/plain;charset=koi8-r' . $br;
    $headers .= 'Content-transfer-encoding: 7bit';

    if (!empty($file_name) && is_file($file_name)) {

        $file     = fopen($file_name, 'rb');
        $message .= $br . '------------' . $uniqid . $br;
        $message .= 'Content-Type: application/octet-stream;name="' . basename($file_name) . '"' . $br;
        $message .= 'Content-Transfer-Encoding: base64' . $br;
        $message .= 'Content-Disposition: attachment;';
        $message .= 'filename="' . basename($file_name) . '"' . $br . $br;
        $message .= chunk_split(base64_encode(fread($file, filesize($file_name)))) . $br;
    }

    if (!mail($to, $subject, $message, $headers)) {

        return false;
    }
    else {
        return true;
    }
}

function ChangeSkin($title = '') {

global $config;

$skin_list = <<<HTML

    <form method="post" action="">
        {$title} <select onchange="submit()" name="action_skin_change">

HTML;

$arrthemes = array();
$globs = glob(THEMES_PATH . '/*', GLOB_ONLYDIR);
foreach($globs as $glob) $arrthemes[] = basename($glob);
$arrthemes = array_unique($arrthemes);

foreach( $arrthemes as $theme ) {

    if( $theme == $config['themes'] ) $selected = ' selected="selected"';
    else $selected = '';

    $skin_list .= <<<HTML
        <option value="{$theme}"{$selected}>{$theme}</option>

HTML;
}

    $skin_list .= <<<HTML
    </select>
    </form>

HTML;

    return $skin_list;
}

?>