<?php
    /**
    * класс позволяет читать/сохранять массивы из/в INI файл(а)
    * (array) = ini::read(string file [, bool is_sectionize])
    * (bool) = ini::save(string file, array to_save[, bool is_sectionize])
    */

abstract class ini {

    static function value_encode($str) {

        $str = str_replace("\n", '\n', $str);
        $str = str_replace("\r", '\r', $str);
        return htmlentities($str, ENT_QUOTES, 'UTF-8');
    }

    static function value_decode($str) {

        $str = str_replace('\n', "\n", $str);
        $str = str_replace('\r', "\r", $str);
        return html_entity_decode($str, ENT_QUOTES, 'UTF-8');
    }

    static function read($file, $sect = false) {

        if (!is_readable($file)) {

            die('Не удается открыть файл конфигурации!' . $file);
        }

        $ini = parse_ini_file($file, $sect);

        if ($ini) {

            if ($sect) {

                foreach ($ini as $key => $val) {

                    foreach ($val as $keys => $vals) {

                        $ini[$key][$keys] = self::value_decode($vals);
                    }
                }
            }
            else {

                foreach ($ini as $key => $val) {

                    $ini[$key] = self::value_decode($val);
                }
            }
        }

        return $ini;
    }

    static function save($file, $array, $sect = false) {

        $ini = array();

        if (!is_writable($file)) {

            //die('Не удается записать в файл конфигурации!');
        }

        if ($sect) {

            foreach($array as $key => $val) {

                $ini[] = '['.self::value_encode($key).']';

                foreach($val as $keys => $vals) {

                    $ini[] = "$keys = \"".self::value_encode($vals, ENT_QUOTES, 'UTF-8')."\";";
                }
            }
        }
        else {

            foreach($array as $key => $val) {

                $ini[] = "$key = \"".self::value_encode($val, ENT_QUOTES, 'UTF-8')."\";";
            }
        }

        return file_put_contents($file, implode("\r\n",$ini));
    }
};
?>
