<?php

if (!defined('BLOG')) { die('Access Denied!'); }

define('ICONS','/themes/web/icons/');

$rating_ext = 'png'; // формат картинок рейтинга

# Валидный HTML
function valid_html($str) {

    $str = str_replace(' />', '>', $str);
    $str = str_replace('"/>', '">', $str);
    return $str;
}

/**
 * Шапка страницы
 * @param string $title
 * @param string $desc
 * @param string $header
 */
function show_header($title = '', $keys = '', $desc = '', $header = 'Y') {

global $db, $config, $categories;

$title = StripMeta($title);
$keys  = !empty($keys) ? $keys : $config['site_keys'];
$desc  = !empty($desc) ? $desc : $config['site_desc'];

header("Content-type:text/html; charset=utf-8");

echo '<!DOCTYPE html PUBLIC "-//W3C//DTD HTML 4.01 Transitional//EN"><html>
<head>
<meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
<title>' . $title . '</title>
<meta name="keywords" content="' . $keys . '">
<meta name="description" content="' . $desc . '">
<style type="text/css">' . file_get_contents(dirname(__FILE__) . '/style.css') . '</style>
' . ($config['allow_rss'] == 1 ? '<link rel="alternate" type="application/rss+xml" title="' . $config['rss_title'] . '" href="/rss.xml">' : '') . '
</head><body>';

$count_categories = count($categories);


echo <<<HTML

<center>
  <!-- Верхний блок -->
  <table align="center" cellpadding="0" cellspacing="0" width="810px">
    <tr>
      <td width="100%">

        <table cellpadding="0" cellspacing="0" width="810px" border="0">
          <tr>
            <td class="top"><br>
              <img src="/themes/web/img/logo.png" border="0" alt=""><br><br>
            </td>
          </tr>
        </table>

        <table cellpadding="0" cellspacing="0" width="810px" bgcolor="#FFFFFF">
          <tr>
            <td width="25%" valign="top">

              <table cellpadding="5" cellspacing="0" width="100%">
                <tr>
                  <td class="f">
                  <div class="e">Разделы блога ({$count_categories})</div>

HTML;

    ob_start('valid_html');

    if (!empty($categories)) {

        foreach( $categories as $key => $val ) {

            list($name,$text,$count) = $val;
			
            echo '
            <img src="' . ICONS . 'site.png" alt=""> <a href="' . gen_uri('category', $key) . '">' . $name . '</a> (' . $count . ')<br>
            ';
        }
    }

    echo <<<HTML

                  </td>
                </tr>
              </table>

HTML;

    if ($config['show_ads'] == 1 && !defined('IS_ADMINKA')) {

        echo <<<HTML

              <table cellpadding="5" cellspacing="0" width="100%">
                <tr>
                  <td class="f">
                  <div class="e">Рекомендую</div>

HTML;


        $ads = $db->select("SELECT * FROM ?_ads WHERE (`time` - UNIX_TIMESTAMP()) > 0 ORDER BY rand() LIMIT 0," . $config['ads_num']);

        if (!empty($ads)) {

            foreach( $ads as $ad ) echo '<img src="' . ICONS . 'site.png" alt=""> <a href="http://' . $ad['url'] . '">' . $ad['name'] . '</a><br>';
        }

        echo <<<HTML

                  </td>
                </tr>
              </table>
HTML;
    }

    echo <<<HTML

              <table cellpadding="5" cellspacing="0" width="100%">
                <tr>
                  <td class="f">
                  <div class="e">Статистика</div><br>
<center>
<a href="https://errgotop.ru/go/47"><img src="https://errgotop.ru/image/47" alt="errgotop.ru" /></a>
</center>
HTML;

    if (!defined('IS_ADMINKA')) {


        if (defined('IS_INDEX')) {

            echo loadTemplate( 'footer_index' );

            $show_title  = '<h1>' . $title . '</h1>';
            $show_title .= '<a href="/rss.xml" title="' . $config['rss_title'] . '"><img src="' . ICONS . 'rss.png" alt="" class="imgright"></a>';
            $show_title .= '<a href="/print.html" title="Версия для печати"><img src="' . ICONS . 'printer.png" alt="" class="imgright"></a>';
        }
        else {

            echo loadTemplate( 'footer' );

            $show_title = '<h1>' . $title . '</h1>';
        }
    }
    else $show_title = '<h1>' . $title . '</h1>';

    echo <<<HTML

                  
              </table>

            </td>

            <td width="100%" valign="top">

HTML;

    if (!empty($_SESSION['core_message'][0][0]) && !empty($_SESSION['core_message'][0][1])) {

        echo '<div class="message_' . $_SESSION['core_message'][0][0] . '">' . $_SESSION['core_message'][0][1] . '</div>';

        unset($_SESSION['core_message']);
    }

echo <<<HTML

              <table cellpadding="1" cellspacing="0" width="100%" style="margin-top:10px;">
                <tr>
                  <td>
                    <div class="header">{$show_title}</div>


HTML;
}

# Ноги
function show_footer() {

    global $db, $mts, $is_admin, $config, $count_posts;


    echo <<<HTML


                  </td>
                </tr>
                <!-- tr><td align="center"><img src="/themes/web/img/_banner_.gif" alt=""></td></tr -->
              </table>
  
            </td>
            <td width="25%" valign="top">

              <!-- table cellpadding="5" cellspacing="0" width="100%">
                <tr>
                  <td class=f>

                    <br><div class=e> Статистика</div>
                    <center><br></center>
                  </td>
                </tr>
              </table -->

            </td>
          </tr>
        </table>

        <table cellpadding="0" cellspacing="0" width="810px" border="0">
          <tr>
            <td class="foot">
              {$config['site_copy']}
            </td>  
          </tr>
HTML;

    if ($is_admin) {

        $stat = $db->getStatistics();

        echo '<tr><td align="center">' . round(microtime(1) - $mts, 4) . ' сек :: ' . $stat['count'] . ' запросов</td></tr>';
    }

echo <<<HTML

        </table>

      </td>
    </tr>
  </table>
</center>
</body>
</html>
HTML;

    ob_end_flush();
    exit;
}

?>