<?php

include_once __DIR__ . '/WapkassaClass.php';

try {
    // Инициализация класса с id сайта и секретным ключом
    $wapkassa = new WapkassaClass(1, '1234567890');

    // основные параметры - сумма и комментарий платежа
    $wapkassa->setParams(1.55, 'Тестовая покупка кирпича');

    // допольнительные параметры в виде массива, необязательно
    $wapkassa->setParamsAdd(array(
        'user_id' => 100,
        'count' => 10,
    ));

    // получаем данные для генерации формы
    $formValue = $wapkassa->getValue();

    // генерируем форму
    echo '<form method="post" action="https://wapkassa.ru/merchant/payment2">';
    foreach ($formValue as $key => $value) {
        echo '<input type="hidden" name="' . $key . '" value="' . $value . '">';
    }
    echo '<button>Оплатить</button>';
    echo '</form>';

} catch (Exception $e) {
    // вывод ошибки
    echo 'Ошибка: ' . $e->getMessage() . PHP_EOL;
}