<?php
class CurlClassConfig
{
public $userAgent;
public $referer;
public $proxytype;
public $proxy = FALSE;
public $cookiesFile = FALSE;
public $followLocations = TRUE;
public $timeout = 10;
}

class CurlClass
{
private $_ch;

public function __construct ()
{
if (!$this->_ch = curl_init ())
throw new Exception ('Неудалось установить сеанс CURL');
}

public function __destruct ()
{
curl_close ($this->_ch);
}

protected function execute (CurlClassConfig $config)
{
curl_setopt ($this->_ch, CURLOPT_RETURNTRANSFER, TRUE);
curl_setopt ($this->_ch, CURLOPT_USERAGENT, $config->userAgent);
curl_setopt ($this->_ch, CURLOPT_REFERER, $config->referer);
curl_setopt ($this->_ch, CURLOPT_FOLLOWLOCATION, $config->followLocations);
curl_setopt ($this->_ch, CURLOPT_TIMEOUT, $config->timeout);
curl_setopt ($this->_ch, CURLOPT_CONNECTTIMEOUT, $config->timeout);
curl_setopt ($this->_ch, CURLOPT_PROXYTYPE, $config->proxytype);

if ($config->proxy)
curl_setopt ($this->_ch, CURLOPT_PROXY, $config->proxy);

if ($config->cookiesFile)
{
$ololo = dirname (__FILE__) . DIRECTORY_SEPARATOR . $config->cookiesFile;
curl_setopt ($this->_ch, CURLOPT_COOKIEJAR, $ololo);
curl_setopt ($this->_ch, CURLOPT_COOKIEFILE, $ololo);
}

$data = curl_exec ($this->_ch);

if (curl_errno ($this->_ch) == 5)
{
curl_close ($this->_ch);
throw new Exception ('Нерабочая прокся :-(');
}
return $data;
}


public function getPage (CurlClassConfig $config, $url)
{
curl_setopt ($this->_ch, CURLOPT_URL, $url);
return $this->execute ($config);
}

public function sendPost (CurlClassConfig $config, $url, $params)
{
curl_setopt ($this->_ch, CURLOPT_URL, $url);
curl_setopt ($this->_ch, CURLOPT_POST, TRUE);
curl_setopt ($this->_ch, CURLOPT_POSTFIELDS, http_build_query ($params));
return $this->execute ($config);
}

public function sendGet (CurlClassConfig $config, $url, $params)
{
}

}