<?php

namespace app\controllers;

use app\configs\Controller;
use app\configs\View;

class ManekenImageController extends Controller
{
    public function __construct($routes)
    {
        parent::__construct($routes);
    }

    public function defaultAction()
    {
        View::error(404);
    }

    public function userAction()
    {
        header('content-type: image/jpeg');

        $image = imageCreateFromPng('./public/images/maneken/arena/0.png');

        $InventoryModel = $this->loadModel('Inventory');

        $items = $InventoryModel->getItems($this->route[3], 1);

        while($row = $items->fetch_assoc())
        {
            if(file_exists('./public/images/maneken/1/'.$row['item'].'.png'))
            {
                $item_image = imageCreateFromPng('./public/images/maneken/1/'.$row['item'].'.png');
                imagecopy($image, $item_image, 0, 0, 0, 0, 120, 160);
            }
        }
        imageJpeg($image);

    }
}