<?php

namespace app\configs;

class View
{
    public $path;
    public $route;
    public $themplate = 'default';

    public function __construct($routes)
    {
        $this->route = $routes;
    }

    public function showing($title, $meta = null, $vars = [])
    {
        if( ! empty($vars))
        {
            extract($vars);
        }

        if(empty($this->route[2]))
        {
            $this->route[2] = 'default';
        }

        if(file_exists('./app/views/'.$this->route[1].'/'.$this->route[2].'.php'))
        {
            ob_start();
            require_once './app/views/'.$this->route[1].'/'.$this->route[2].'.php';
            $content = ob_get_clean();

            if(file_exists('./app/views/layout/'.$this->themplate.'.php'))
            {
                require_once './app/views/layout/'.$this->themplate.'.php';
            }
        }
        else
        {
            exit('This page not found!!!<br> <small>Page is: <span style="color:red">./app/views/'.$this->route[1].'/'.$this->route[2].'.php</span></small>');
        }
    }

    public static function error($code)
    {
        http_response_code($code);
        require_once './app/views/errorsPages/'.$code.'.php';
    }
}