<?php

namespace app\models;

use app\configs\DB;

class User
{
    public static $user;

    private $sailt = 'tiwar.LocalHost.Created.By.DarksLight2';

    public function generateToken($user)
    {

        $user = DB::query('SELECT * FROM `users` WHERE `id` = ? LIMIT 1', [$user])->fetch_assoc();

        if($user)
        {
            $token_name = md5($_SERVER['HTTP_USER_AGENT'].$this->sailt);
            $chars = "qazxswedcvfrtgbnhyujmkiolp1234567890QAZXSWEDCVFRTGBNHYUJMKIOLP";
            $size = strlen($chars) - 1;
            $max = 20;
            $token = '';
            $token_time = time() + (86400 * 7);
            while ($max--) {
                $token .= $chars[rand(0, $size)];
            }

            DB::query('UPDATE `users` SET `token` = ?, `token-time` = ? WHERE `id` = ?', [$token, $token_time, $user['id']]);

            if(!isset($_COOKIE[$token_name]))
            {
                setcookie($token_name, $token, $token_time, '/');
            }
            else
            {
                $_COOKIE[$token_name] = $token;
            }

            return true;
        }
        else
        {
            return false;
        }
    }

    public function authorize($login, $pass, $auto = null)
    {
        if($auto == null)
        {
            $user = DB::query('SELECT * FROM `users` WHERE `login` = ? LIMIT 1', [$login])->fetch_assoc();

            if(strlen($login) < 2)
            {
                return 'Поле логин должно содержать минимум 3 символа.';
            }
            elseif (strlen($pass) < 5)
            {
                return 'Пароль неможет содержать меньше 6ти символов.';
            }
            elseif (!$user)
            {
                return 'Данного пользователя не существует.';
            }
            elseif(!password_verify($pass, $user['pswrd']))
            {
                return 'Неверно введены данные пользователя.';
            }
            else
            {
                $this->generateToken($user['id']);
                return 'ok';
            }
        }
        else
        {
            $this->generateToken($auto);
            return 'ok';
        }

    }

    public function user()
    {
        if(!empty(self::$user))
        {
            if(self::$user['token-time'] < (time() + 90720))
            {
                User::generateToken(self::$user['id']);
            }

            return self::$user;
        }
        else
        {
            $token_name = md5($_SERVER['HTTP_USER_AGENT'] . $this->sailt);

            if (isset($_COOKIE[$token_name]))
            {
                $user = DB::query('SELECT * FROM `users` WHERE `token` = ? LIMIT 1', [$_COOKIE[$token_name]])->fetch_assoc();

                if ($user['token-time'] < (time() + 90720))
                {
                    $this->generateToken($user['id']);
                }

                if ($user)
                {
                    self::$user = $user;

                    return self::$user;
                }
                else
                {
                    setcookie($token_name, '');

                    return false;
                }
            }
        }
    }

    public function logOut()
    {
        $token_name = md5($_SERVER['HTTP_USER_AGENT'] . $this->sailt);
        if($_COOKIE[$token_name])
        {
            setcookie($token_name, '', '', '/');
        }

        return true;
    }

    public function checkUserOnAdmin($login)
    {
        if(!empty($this->user()))
        {
            return $this->user()['admin'];
        }
        else
        {
            $user = DB::query('SELECT `admin` FROM `users` WHERE `login` = ? LIMIT 1', [$login])->fetch_assoc();
            return $user['admin'];
        }
    }

    public function lastUpdate()
    {
        if(!empty($this->user()))
        {

            $lastUpdateTime = time() + 60 * 5; // 5 минут
            $timeOut = time() + 60; // минута

            DB::query('UPDATE `users` SET `lastUpdate` = ? WHERE `id` = ? AND `lastUpdate` < ?', [$lastUpdateTime, $this->user()['id'], $timeOut]);
        }
        return false;
    }

    public function getUserById($id)
    {
        return DB::query('SELECT * FROM `users` WHERE `id` = ? LIMIT 1', [$id])->fetch_assoc();
    }

    public function getUsersCount($online = null)
    {
        if($online != null)
        {
            $time = time();

            return DB::query('SELECT * FROM `users` WHERE `lastUpdate` > ?', [$time])->num_rows;
        }

        return DB::query('SELECT * FROM `users`')->num_rows;
    }

    public function progressExp()
    {
        $user = $this->user();

        if($user['exp'] > 0)
        {
            return round( 100 / ($this->levels() / $user['exp']), 2);
        }
        return 0;
    }

    public function levels()
    {
        $user = $this->user();

        return ($user['level'] * 120) + 356;
    }

    public function setHp()
    {
        $user = $this->user();

        if($user['last_update_hp'] == 0 || $user['hp'] == $user['max_hp'])
        {
            $set = 0;
        }
        else
        {
            $set = time() - $user['last_update_hp'];
        }

        if($user['hp'] > $user['max_hp'])
        {
            DB::query('UPDATE `users` SET `hp` = `max_hp`, `last_update_hp` = ? WHERE `id` = ?', [time(), $user['id']]);
        }
        else
        {
            DB::query('UPDATE `users` SET `hp` = `hp` + ?, `last_update_hp` = ? WHERE `id` = ?', [$set, time(), $user['id']]);
        }

    }

    public function setMp()
    {
        $user = $this->user();

        if($user['last_update_mp'] == 0 || $user['mp'] == $user['max_mp'])
        {
            $set = 0;
        }
        else
        {
            $set = time() - $user['last_update_mp'];
        }

        if($user['mp'] > $user['max_mp'])
        {
            DB::query('UPDATE `users` SET `mp` = `max_mp`, `last_update_mp` = ? WHERE `id` = ?', [time(), $user['id']]);
        }
        else
        {
            DB::query('UPDATE `users` SET `mp` = `mp` + ?, `last_update_mp` = ? WHERE `id` = ?', [$set, time(), $user['id']]);
        }
    }

    public function createUser()
    {
        $pswrd = password_hash(rand(000000, 999999), PASSWORD_DEFAULT);

        DB::query('INSERT INTO `users` (`pswrd`, `email`, `token`) VALUES (?, ?, ?)', [$pswrd, '', '']);

        $this->authorize('Боец', $pswrd, DB::lastInsertID());
    }
}