<?php

namespace app\models;

use app\configs\DB;

class Arena extends User
{

    public function __construct()
    {
    }

    public function getEnemy()
    {
        $user = $this->user();

        $strength_max = $user['strength'] + 200;
        $health_max = $user['max_hp'] + 200;
        $defense_max = $user['defense'] + 200;

        $strength_min = $user['strength'] - 200;
        $health_min = $user['max_hp'] - 200;
        $defense_min = $user['defense'] - 200;

        $query = DB::query('SELECT * FROM `users` WHERE `strength` BETWEEN ? AND ? AND `max_hp` BETWEEN ? AND ? AND `defense` BETWEEN ? AND ? AND `id` <> ? ORDER BY RAND() LIMIT 1',
            [$strength_min, $strength_max, $health_min, $health_max, $defense_min, $defense_max, $user['id']]);

        if($query->num_rows > 0)
        {
            return $query->fetch_assoc();
        }
        else
        {
            return DB::query('SELECT * FROM `users` WHERE `level` = ? AND `id` != ?', [$user['level'], $user['id']])->fetch_assoc();
        }
    }

    public function getEnemyByID($id)
    {
        $query = DB::query('SELECT * FROM `users` WHERE `id` = ? LIMIT 1', [$id]);

        if($query->num_rows == 1)
        {
            return $query->fetch_assoc();
        }
        else
        {
            echo 'Ошибка!';
        }
    }

    public function reward($enemy, $user, $status, $enemyDMG)
    {
        if($status == 'win')
        {
            $silver = rand(1, 10) * $enemy['level'];
            $exp = rand(1, 5) * $enemy['level'];
        }
        else
        {
            $silver = rand(1, 5) * $enemy['level'];
            $exp = rand(1, 2) * $enemy['level'];
        }

        $enemyDMG = round($enemyDMG * 0.10);

        DB::query('UPDATE `users` SET `silver` = `silver` + ?, `exp` = `exp` + ?, `mp` = `mp` - ?, `hp` = `hp` - ? WHERE `id` = ? LIMIT 1', [$silver, $exp, '50', $enemyDMG, $user['id']]);

        return ['silver' => $silver, 'exp' => $exp];
    }
}