<?php

namespace app\controllers;

use app\configs\Controller;
use app\configs\View;

class MainController extends Controller
{
    public function __construct($routes)
    {
        parent::__construct($routes);

        $this->view = new View($routes);
    }

    public function defaultAction()
    {
        $UserModel = $this->loadModel('User');

        if(isset($_POST['authButton']))
        {
            $UserModel->authorize($_POST['login'], $_POST['password']);
            header('Location: '.$_SERVER['REQUEST_URI'].'');
        }

        $this->view->showing('Test', 'sdasdasd', [
            'user' => $UserModel->user(),
            'sectionGame' => 'Главная',
            'progressExp' => $UserModel->progressExp()
        ]);
    }
}
