<?php

namespace app\controllers;

use app\configs\Controller;
use app\configs\View;

class ArenaController extends Controller
{
    private $UserModel;
    private $user;

    public function __construct($routes)
    {
        parent::__construct($routes);

        $this->view = new View($routes);

        $this->UserModel = $this->loadModel('User');
        $this->user = $this->UserModel->user();
    }
    public function defaultAction()
    {
        $ArenaModel = $this->loadModel('Arena');

        $enemy = $ArenaModel->getEnemy();

        $this->view->showing('Арена', '', [
            'user' => $this->UserModel->user(),
            'sectionGame' => 'Арена',
            'progressExp' => $this->UserModel->progressExp(),
            'enemy' => $enemy
        ]);

        $_SESSION['enemy'] = $enemy;
    }

    public function attackAction()
    {
        if($this->user['mp'] >= 50 || $this->user['hp'] < ($this->user['max_hp'] * 0.10))
        {
            $ArenaModel = $this->loadModel('Arena');

            if(!isset($_SESSION['enemy']))
            {
                header('Location: /arena/');
                exit;
            }

            $enemy = $_SESSION['enemy'];

            $dmgEnemy = ($enemy['strength'] / $this->user['defense']) * $enemy['level'] * 10;
            $dmgUser = ($this->user['strength'] / $enemy['defense']) * $this->user['level'] * 10;

            if($dmgUser >= $dmgEnemy)
            {
                $_SESSION['rewards'] = $ArenaModel->reward($enemy, $this->user, 'win', $dmgEnemy);
                $_SESSION['msg'] = 'win';
            }
            else
            {
                $_SESSION['rewards'] = $ArenaModel->reward($enemy, $this->user, 'lose', $dmgEnemy);
                $_SESSION['msg'] = 'lose';
            }
        }
        else
        {
            $_SESSION['msg'] = 'need_hp_or_mp';
        }


        header('Location: /arena/');
    }

    public function generateEnemy()
    {
        return $this->UserModel->generateEnemy($this->user['id']);
    }
}