<?php

namespace app\configs;

use app\controllers;

class Router
{
    public function start()
    {
        if( ! empty($_POST['api']))
        {
            $controller = 'app\controllers\ApiController';

            if(class_exists($controller))
            {
                $Api = new $controller;
                $method = $_POST['api'];

                if(method_exists($controller, $method))
                {
                    exit($Api->$method());
                }
            }
        }

        $className = 'Main';
        $actionName = 'default';

        $routes = explode('/', $_SERVER['REQUEST_URI']);

        if(!empty($routes[1]))
        {
            $className = $routes[1];
        }
        if(!empty($routes[2]))
        {
            $actionName = $routes[2];
        }

        $classPath = 'app\controllers\\'.ucfirst($className).'Controller';

        if(class_exists($classPath))
        {
            $actionName = $actionName.'Action';
            if(method_exists($classPath, $actionName))
            {
                $controller = new $classPath($routes);
                $controller->$actionName();
            }
            else
            {
                exit('Данного экшена: <b>'.$actionName.'</b> не существует в контроллере <b>'.ucfirst($className).'Controller</b>');
            }
        }
        else
        {
            exit('Данного контроллера: <b>'.$classPath.'</b> не существует!');
        }
    }
}