<?php

namespace app\configs;

class Controller
{
    public $route;
    public $view;

    public function __construct($routes)
    {
        $this->route = $routes;

        $UserModel = $this->loadModel('User');

        $UserModel->lastUpdate();

        if(!empty($UserModel->user()))
        {
            $UserModel->setHp();
            $UserModel->setMp();
        }
    }

    public function loadModel($model, $params = [])
    {
        $pathToModels = 'app\models\\' . $model;

        if (class_exists($pathToModels))
        {
            if( ! empty($params))
            {
                return new $pathToModels(extract($params));
            }
            return new $pathToModels();
        }
        else
        {
            return 'Нету найдено модели: <b>'.$pathToModels.'</b>';
        }
    }
}