<?php


namespace core;


use Throwable;

class App
{
    private Router $router;

    public function __construct()
    {
        $routes = require_once 'config/routes.php';
        $this->router = new Router($routes);
    }

    public function run($mode)
    {
        if (!in_array($mode, ['dev', 'prod'])) die('Ошибка запуска');

        try {
            $this->router->resolve();
        } catch (Throwable $throwable) {
            if ($mode === 'dev') {
                echo "<pre>$throwable</pre>";
            } else {
                http_response_code(404);
                require_once 'app/views/404.html';
            }
        }
    }
}