CREATE TABLE `ability_store` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

INSERT INTO `ability_store` (`id`, `name`) VALUES 
	('1', 'Вампиришм');

CREATE TABLE `ability_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ability` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `abuse` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_abuse` int(11) NOT NULL,
  `comment` text NOT NULL,
  `abuse` set('0','1','2','3','4') NOT NULL DEFAULT '0',
  `success` set('0','1') NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `admin_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_adm` int(11) NOT NULL,
  `message` text NOT NULL,
  `time` int(11) NOT NULL,
  `section` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;
;


CREATE TABLE `adventurelocation` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `level` int(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

INSERT INTO `adventurelocation` (`id`, `name`, `level`) VALUES 
	('1', 'Город', '5');

CREATE TABLE `almaz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `almaz` int(11) NOT NULL,
  `bonus` int(11) NOT NULL,
  `price` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
;

INSERT INTO `almaz` (`id`, `almaz`, `bonus`, `price`) VALUES 
	('1', '100', '25', '10')
	,('2', '500', '125', '50')
	,('3', '2500', '600', '250')
	,('4', '5000', '1250', '500')
	,('5', '10000', '2500', '850');

CREATE TABLE `arena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `rating` int(11) DEFAULT 0,
  `rating_ok` int(11) DEFAULT 0,
  `id_opp` int(11) DEFAULT 0,
  `time` int(11) DEFAULT NULL,
  `coll` int(11) DEFAULT 0,
  `coll_max` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=42 DEFAULT CHARSET=utf8;
;


CREATE TABLE `arena_reset` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT NULL,
  `time_ok` int(11) DEFAULT 0,
  `ok` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;


CREATE TABLE `auction` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `a_1` int(11) DEFAULT 0,
  `a_2` int(11) DEFAULT 0,
  `a_3` int(11) DEFAULT 0,
  `a_4` int(11) DEFAULT 0,
  `a_5` int(11) DEFAULT 0,
  `a_6` int(11) DEFAULT 0,
  `a_7` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

INSERT INTO `auction` (`id`, `a_1`, `a_2`, `a_3`, `a_4`, `a_5`, `a_6`, `a_7`) VALUES 
	('1', '0', '0', '0', '0', '0', '0', '0');

CREATE TABLE `auth_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `browser` varchar(300) NOT NULL,
  `ip` varchar(30) NOT NULL,
  `password` varchar(32) NOT NULL,
  `status` enum('','success','error') NOT NULL,
  `time` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=305 DEFAULT CHARSET=utf8;
;

CREATE TABLE `avenax_admin` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_item` int(10) unsigned NOT NULL DEFAULT 0,
  `sale_item_time` int(10) unsigned NOT NULL DEFAULT 0,
  `sale_diamond` int(10) unsigned NOT NULL DEFAULT 0,
  `sale_diamond_time` int(10) unsigned NOT NULL DEFAULT 0,
  `sale_xsolla` int(10) unsigned NOT NULL DEFAULT 0,
  `sale_xsolla_time` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;


CREATE TABLE `awed` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `id_opp` int(11) DEFAULT 0,
  `ok` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ban` int(11) NOT NULL,
  `reason` text NOT NULL,
  `blocked` set('all','mute') NOT NULL DEFAULT 'all',
  `time_ban` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
;


CREATE TABLE `blacklist_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_add` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
CREATE TABLE `borrowing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `cost` int(11) NOT NULL DEFAULT 0,
  `times` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `boss_fight` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `boss_hp` int(11) NOT NULL,
  `user_hp` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `status` enum('fight','lose','win','') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1203 DEFAULT CHARSET=utf8;
;


CREATE TABLE `boss_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `level` int(11) NOT NULL,
  `last_fight` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=65 DEFAULT CHARSET=utf8;
;


CREATE TABLE `camp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `text` text NOT NULL,
  `level` int(11) NOT NULL,
  `image` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
;

INSERT INTO `camp` (`id`, `name`, `text`, `level`, `image`) VALUES 
	('1', 'Скалы', 'Темный лес ', '1', '/images/chapter/fon_1.png')
	,('2', 'Затерянный остров', ' Вам нужно пройти поле что бы пройти дальше', '5', '')
	,('3', 'Берега реки', '', '0', '')
	,('4', 'Необитаемый остров ', '', '0', '')
	,('5', 'Пиратская  Бухта', '', '0', '');

CREATE TABLE `camp_boss` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `chapter` int(11) NOT NULL,
  `power` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `block` int(11) NOT NULL,
  `resours` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `clothing_type` enum('head','body','gloves','weapon','shield','boots') NOT NULL,
  `point` int(11) NOT NULL,
  `who` enum('mob','boss') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8;
;

INSERT INTO `camp_boss` (`id`, `name`, `chapter`, `power`, `health`, `block`, `resours`, `exp`, `clothing_type`, `point`, `who`) VALUES 
	('1', 'Валькирия Орк', '1', '10', '25', '5', '15', '20', 'head', '0', 'mob')
	,('2', 'Гоблин', '1', '20', '55', '15', '25', '40', 'body', '1', 'mob')
	,('3', 'Волк', '1', '45', '90', '25', '30', '60', 'gloves', '2', 'mob')
	,('4', 'Разьяреный Кабан', '1', '70', '170', '30', '35', '80', 'weapon', '3', 'mob')
	,('5', 'Крысочеловек', '1', '100', '250', '35', '40', '100', 'shield', '4', 'mob')
	,('6', 'Гриморт', '1', '125', '400', '50', '45', '130', 'boots', '5', 'mob')
	,('7', 'Зеленый дракон', '1', '200', '800', '100', '100', '250', 'weapon', '6', 'boss')
	,('8', 'Костолом-Наемник', '2', '175', '750', '60', '110', '300', 'head', '7', 'mob')
	,('9', 'Наемник Убийца', '2', '225', '900', '80', '125', '320', 'body', '8', 'mob')
	,('10', 'Некромант', '2', '275', '1150', '110', '150', '340', 'gloves', '9', 'mob')
	,('11', 'Призрак', '2', '320', '1350', '140', '175', '360', 'weapon', '10', 'mob')
	,('12', 'Гниющая Крыса', '2', '400', '1500', '160', '200', '400', 'shield', '11', 'mob')
	,('13', 'Пес Войны', '2', '490', '1700', '200', '225', '450', 'boots', '12', 'mob')
	,('14', 'Красный дракон', '2', '510', '2000', '250', '350', '600', 'gloves', '13', 'boss')
	,('15', 'Гоблин Саблеруб', '3', '550', '2100', '250', '400', '550', 'head', '14', 'mob')
	,('16', 'Чудовищная Многоножка', '3', '620', '2250', '310', '465', '620', 'body', '15', 'mob')
	,('17', 'Гигантский Змей', '3', '700', '2400', '365', '550', '685', 'gloves', '16', 'mob')
	,('18', 'Тритон-Скаут', '3', '780', '2600', '425', '660', '740', 'weapon', '17', 'mob')
	,('19', 'Летающая пиранья', '3', '860', '2750', '500', '750', '815', 'shield', '18', 'mob')
	,('20', 'Карнозавр', '3', '1040', '2950', '700', '920', '1000', 'boots', '19', 'mob')
	,('21', 'Тритон берсерк', '3', '1200', '3200', '650', '1200', '1300', 'gloves', '20', 'boss')
	,('22', 'Вампирское Отродье', '4', '1300', '3410', '720', '1300', '1500', 'head', '21', 'mob')
	,('23', 'Скелет-Стражник', '4', '1410', '3650', '795', '1550', '1750', 'body', '22', 'mob')
	,('24', 'Малая Горгулья', '4', '1530', '3810', '830', '1850', '2100', 'gloves', '23', 'mob')
	,('25', 'Обреченный Воин', '4', '1660', '4000', '950', '2200', '2300', 'shield', '24', 'mob')
	,('26', 'Госпожа Вампиров', '4', '1800', '4230', '1015', '2500', '2650', 'weapon', '25', 'mob')
	,('27', 'Обреченный Повелитель', '4', '2050', '4400', '1260', '2800', '2900', 'boots', '26', 'mob')
	,('28', 'Обреченный Рыцарь', '4', '2300', '4700', '1500', '3500', '3500', 'head', '27', 'boss')
	,('29', 'Вождь гоблинов ', '5', '2550', '5100', '1850', '4300', '4200', 'head', '28', 'mob')
	,('30', 'Летучая мышь', '5', '2800', '5550', '2000', '4700', '4900', 'body', '29', 'mob')
	,('31', 'Воин-Миконид', '5', '3200', '6050', '2200', '5100', '5300', 'gloves', '30', 'mob')
	,('32', 'Рунический Медведь', '5', '3550', '6450', '2450', '5500', '6000', 'weapon', '31', 'mob')
	,('33', 'Дикий Троль', '5', '3900', '6790', '2800', '5950', '6500', 'shield', '32', 'mob')
	,('34', 'Малая стихия природы', '5', '4300', '7100', '3300', '6200', '6400', 'boots', '33', 'mob')
	,('35', 'Эпическая стихия природы', '5', '4700', '7500', '3550', '6500', '7500', 'weapon', '34', 'boss');

CREATE TABLE `camp_fight` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `chapter` int(11) NOT NULL,
  `enemyName` varchar(30) NOT NULL,
  `id_boss` int(11) NOT NULL,
  `healthEnemy` int(11) NOT NULL,
  `maxHealthEnemy` int(11) NOT NULL,
  `status` enum('battle','win','lose','') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8803 DEFAULT CHARSET=utf8;
;


CREATE TABLE `camp_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=86691 DEFAULT CHARSET=utf8;
;

CREATE TABLE `camp_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `chapter` int(11) NOT NULL,
  `bot` int(11) NOT NULL,
  `status` int(11) NOT NULL,
  `id_chapter` int(11) NOT NULL,
  `star` int(11) NOT NULL,
  `gold` int(11) NOT NULL,
  `point` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;
;


CREATE TABLE `castle_ad` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_castle` int(11) NOT NULL,
  `text` text NOT NULL,
  `id_send` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
;

CREATE TABLE `castle_build` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_castle` int(11) NOT NULL,
  `idBuild` int(11) NOT NULL,
  `levelBuild1` int(11) NOT NULL DEFAULT 1,
  `bonus` decimal(2,1) DEFAULT 0.0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;
;

CREATE TABLE `castle_chat` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_castle` int(16) NOT NULL,
  `id_send` int(16) NOT NULL,
  `message` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_recive` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;
;


CREATE TABLE `castle_journal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_castle` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(16) NOT NULL,
  `date` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=198 DEFAULT CHARSET=utf8;
;

CREATE TABLE `castle_level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;
;

INSERT INTO `castle_level` (`id`, `level`, `exp`) VALUES 
	('1', '1', '1000')
	,('2', '2', '2500')
	,('3', '3', '5000')
	,('4', '4', '10000')
	,('5', '5', '22000')
	,('6', '6', '50000')
	,('7', '7', '80000')
	,('8', '8', '145000')
	,('9', '9', '200000')
	,('10', '10', '250000')
	,('11', '11', '500000')
	,('12', '12', '700000')
	,('13', '13', '1000000')
	,('14', '14', '1450000')
	,('15', '15', '1900000')
	,('16', '16', '2500000')
	,('17', '17', '3400000')
	,('18', '18', '5000000')
	,('19', '19', '7000000')
	,('20', '20', '10000000')
	,('21', '21', '20000000')
	,('22', '22', '30000000')
	,('23', '23', '45000000')
	,('24', '24', '65000000')
	,('25', '25', '90000000')
	,('26', '26', '120000000')
	,('27', '27', '160000000')
	,('28', '28', '210000000')
	,('29', '29', '280000000')
	,('30', '30', '390000000')
	,('31', '0', '0');

CREATE TABLE `castle_members` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_castle` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `rank` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `data_join` int(16) NOT NULL,
  `addedGold` int(16) NOT NULL,
  `addedSilver` int(16) NOT NULL,
  `expDay` int(11) NOT NULL,
  `viewAd` enum('yes','no') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=35 DEFAULT CHARSET=utf8;
;

CREATE TABLE `castles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `level` int(11) NOT NULL,
  `exp` int(11) NOT NULL,
  `kindom` int(11) NOT NULL,
  `name` varchar(30) NOT NULL,
  `data_great` int(11) NOT NULL,
  `gold` int(11) NOT NULL,
  `allNumMember` smallint(7) NOT NULL DEFAULT 25,
  `stats` int(16) NOT NULL,
  `silver` int(16) NOT NULL,
  `description` varchar(300) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
;

CREATE TABLE `chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_from` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=188 DEFAULT CHARSET=utf8;
;

CREATE TABLE `elka` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_from` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `enchants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mark` enum('1','2','3','4','5') NOT NULL,
  `name` varchar(30) NOT NULL,
  `stats` smallint(11) NOT NULL,
  `price` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
;

INSERT INTO `enchants` (`id`, `mark`, `name`, `stats`, `price`) VALUES 
	('1', '1', 'Обычная руна', '25', '40')
	,('2', '2', 'Редкая руна ', '50', '100')
	,('3', '3', 'Эпическая руна', '100', '420')
	,('4', '4', 'Мифическая руна', '250', '1750')
	,('5', '5', 'Уникальная руна', '400', '3850');

CREATE TABLE `fight_clan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_clan` int(11) DEFAULT 0,
  `ok` int(11) DEFAULT 0,
  `hp_boss` int(11) DEFAULT 0,
  `id_boss` int(11) DEFAULT 0,
  `power_boss` int(11) DEFAULT 0,
  `name` text DEFAULT NULL,
  `end` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
;


CREATE TABLE `fight_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `fight_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coll` int(11) DEFAULT 0,
  `coll_max` int(11) DEFAULT 0,
  `id_user` int(11) DEFAULT 0,
  `time` int(11) DEFAULT NULL,
  `uron` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;
;


CREATE TABLE `forum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `access` enum('0','1','2') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
;

INSERT INTO `forum` (`id`, `name`, `access`) VALUES 
	('1', 'Новости', '2')
	,('2', 'Помощь по игре ', '0')
	,('3', 'Ошибки', '0')
	,('4', 'Предложения', '0')
	,('5', 'Правила', '0')
	,('6', 'Общение', '0');

CREATE TABLE `friend` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `sub` int(11) DEFAULT 0,
  `id_who` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8;
;


CREATE TABLE `friend_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'KEY ',
  `id_user` int(16) NOT NULL COMMENT 'ID USER',
  `id_friend` int(16) NOT NULL COMMENT 'ID FRIEND',
  `time` int(16) NOT NULL COMMENT 'TIME ADD FRIEND',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `friends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_1` int(11) NOT NULL,
  `user_2` int(11) NOT NULL,
  `status` enum('0','1') DEFAULT '0',
  `time` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `gifts` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cat` int(11) NOT NULL,
  `sum` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;
;

INSERT INTO `gifts` (`id`, `cat`, `sum`) VALUES 
	('1', '6', '50')
	,('2', '6', '50')
	,('3', '1', '50')
	,('4', '2', '500')
	,('5', '1', '50')
	,('6', '1', '50')
	,('7', '1', '50')
	,('8', '1', '50')
	,('9', '1', '50')
	,('10', '2', '500')
	,('11', '2', '500')
	,('12', '2', '500')
	,('13', '3', '50')
	,('14', '3', '50')
	,('15', '3', '50')
	,('16', '3', '50')
	,('17', '3', '50')
	,('18', '3', '50')
	,('19', '3', '50')
	,('20', '3', '50')
	,('21', '3', '50')
	,('22', '3', '50')
	,('23', '3', '50')
	,('24', '4', '50')
	,('25', '4', '50')
	,('26', '4', '50')
	,('27', '4', '50')
	,('28', '4', '50')
	,('29', '5', '50')
	,('30', '5', '50')
	,('31', '5', '50')
	,('32', '5', '50')
	,('33', '5', '50')
	,('34', '5', '50')
	,('35', '5', '50')
	,('36', '5', '50')
	,('37', '5', '50')
	,('38', '5', '50')
	,('39', '5', '50')
	,('40', '5', '50')
	,('41', '6', '50')
	,('42', '6', '50')
	,('43', '6', '50')
	,('44', '6', '50')
	,('45', '6', '50')
	,('46', '6', '50')
	,('47', '6', '50')
	,('48', '6', '50')
	,('49', '6', '50')
	,('50', '1', '50')
	,('51', '1', '50')
	,('52', '1', '50')
	,('53', '1', '50')
	,('54', '1', '50');

CREATE TABLE `gifts_cat` (
  `id` int(11) NOT NULL,
  `name` text NOT NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
;

INSERT INTO `gifts_cat` (`id`, `name`) VALUES 
	('1', 'Обычные')
	,('2', 'VIP')
	,('3', '8 марта')
	,('4', '23 февраля')
	,('5', '14 февраля')
	,('6', 'Новогодние');

CREATE TABLE `gifts_usr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `gift` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;


CREATE TABLE `harden_reward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `mark` enum('1','2','3','4','5') NOT NULL,
  `clothing_type` enum('head','body','gloves','weapon','shield','boots') NOT NULL,
  `rand` int(11) NOT NULL,
  `rand_win` int(11) NOT NULL,
  `amount` int(11) NOT NULL,
  `resours` int(16) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8737 DEFAULT CHARSET=utf8;
;


CREATE TABLE `harden_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `mark` enum('1','2','3','4','5') NOT NULL,
  `clothing_type` enum('head','body','gloves','weapon','shield','boots') NOT NULL,
  `amount` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=989 DEFAULT CHARSET=utf8;
;


CREATE TABLE `hram` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) DEFAULT NULL,
  `text` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `invite_castle` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_castle` int(16) NOT NULL,
  `id_send` int(16) NOT NULL,
  `time` int(16) NOT NULL,
  `id_invite` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;
;


CREATE TABLE `kids` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `level` set('1','5','10','15') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
;

INSERT INTO `kids` (`id`, `name`, `level`) VALUES 
	('1', 'Обычные вещи', '1')
	,('2', 'Редкие вещи', '5');

CREATE TABLE `kont` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `new_msg` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=133 DEFAULT CHARSET=utf8;
;


CREATE TABLE `les` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mir` text NOT NULL,
  `time` int(255) NOT NULL,
  `x_sapfir` int(11) DEFAULT NULL,
  `y_sapfir` int(11) DEFAULT NULL,
  `x_diamond` int(11) DEFAULT NULL,
  `y_diamond` int(11) DEFAULT NULL,
  `x_ruby` int(11) DEFAULT NULL,
  `y_ruby` int(11) DEFAULT NULL,
  `x_gold` int(11) DEFAULT NULL,
  `y_gold` int(11) DEFAULT NULL,
  `x_wolf` int(11) NOT NULL,
  `y_wolf` int(11) NOT NULL,
  `ttime` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

INSERT INTO `les` (`id`, `mir`, `time`, `x_sapfir`, `y_sapfir`, `x_diamond`, `y_diamond`, `x_ruby`, `y_ruby`, `x_gold`, `y_gold`, `x_wolf`, `y_wolf`, `ttime`) VALUES 
	('1', '[[\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\"],[\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],[\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\"],[\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"],[\"\",\"\",\"\",\"\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"background-image:url(/forest/4.png);\",\"\",\"\",\"\",\"\",\"\",\"\",\"\"]]', '2147483647', '5', '13', '8', '10', '9', '4', '-1', '-1', '-1', '-1', '1586105361');

CREATE TABLE `level` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `exp` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;
;

INSERT INTO `level` (`id`, `exp`) VALUES 
	('1', '30')
	,('2', '90')
	,('3', '250')
	,('4', '500')
	,('5', '1000')
	,('6', '1750')
	,('7', '3400')
	,('8', '8900')
	,('9', '15000')
	,('10', '25000')
	,('11', '44000')
	,('12', '60000')
	,('13', '81000')
	,('14', '89000')
	,('15', '100000')
	,('16', '125000')
	,('17', '151000')
	,('18', '178000')
	,('19', '210000')
	,('20', '240000')
	,('21', '285000')
	,('22', '330000')
	,('23', '400000')
	,('24', '490000')
	,('25', '700000')
	,('26', '850000')
	,('27', '1000000')
	,('28', '1300000')
	,('29', '2750000')
	,('30', '3500000')
	,('31', '5000000')
	,('32', '7000000')
	,('33', '9500000')
	,('34', '12000000')
	,('35', '16200000')
	,('36', '20000000')
	,('37', '25500000')
	,('38', '31000000')
	,('39', '37000000')
	,('40', '50000000')
	,('41', '55000000')
	,('42', '55000000')
	,('43', '55000000')
	,('44', '60000000')
	,('46', '60000000')
	,('47', '60000000')
	,('48', '65000000')
	,('49', '65000000')
	,('50', '65000000')
	,('51', '70000000')
	,('52', '70000000')
	,('53', '70000000')
	,('54', '75000000')
	,('55', '75000000')
	,('57', '75000000')
	,('58', '80000000')
	,('59', '80000000')
	,('60', '80000000');

CREATE TABLE `log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `sent_id` int(11) NOT NULL,
  `received_id` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `read` enum('no','yes') NOT NULL,
  `new_msg` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=209 DEFAULT CHARSET=utf8;
;

CREATE TABLE `pits` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `str` int(11) DEFAULT 0,
  `hp` int(11) DEFAULT 0,
  `def` int(11) DEFAULT 0,
  `lvl1` int(11) DEFAULT 0,
  `lvl2` int(11) DEFAULT 0,
  `lvl3` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
;


CREATE TABLE `ramp` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL DEFAULT 0,
  `time_wait` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_exp` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_silver` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_gold` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_emeralds` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_sapphire` int(10) unsigned NOT NULL DEFAULT 0,
  `reward_ruby` int(10) unsigned NOT NULL DEFAULT 0,
  `kill_enemy` int(10) unsigned NOT NULL DEFAULT 0,
  `id_enemy` int(10) unsigned NOT NULL DEFAULT 0,
  `statusBattle` enum('search','battle','end') NOT NULL DEFAULT 'search',
  `user_hp` int(10) unsigned NOT NULL DEFAULT 0,
  `time_fight` int(10) unsigned NOT NULL DEFAULT 0,
  `enemy_power` int(10) unsigned NOT NULL DEFAULT 0,
  `enemy_hp` int(10) unsigned NOT NULL DEFAULT 0,
  `enemy_hp_max` int(10) unsigned NOT NULL DEFAULT 0,
  `enemy_block` int(10) unsigned NOT NULL DEFAULT 0,
  `enemy_name` varchar(25) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `id` (`id`,`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=72 DEFAULT CHARSET=utf8;
;

CREATE TABLE `referals` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `id_who` int(11) DEFAULT 0,
  `prize` int(11) DEFAULT 0,
  `act` int(11) DEFAULT 0,
  `block` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `robbery` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'Ид',
  `id_user` int(11) NOT NULL COMMENT 'Id user',
  `time_wait` int(11) NOT NULL COMMENT 'Wait fight when you play',
  `time_fight` int(11) NOT NULL COMMENT 'Time fight',
  `reward_gold` int(11) NOT NULL COMMENT 'Reward ',
  `reward_exp` int(11) NOT NULL COMMENT 'Reward ',
  `reward_silver` int(11) NOT NULL COMMENT 'Reward ',
  `user_hp` int(11) NOT NULL,
  `enemy_hp` int(11) NOT NULL,
  `enemy_power` int(11) NOT NULL,
  `enemy_block` int(11) NOT NULL,
  `enemy_name` varchar(30) NOT NULL,
  `status` enum('default','seach','fight','end') NOT NULL,
  `enemy_hp_max` int(11) NOT NULL,
  `kill_enemy` int(11) NOT NULL,
  `id_enemy` int(16) NOT NULL,
  `reward_emeralds` int(11) NOT NULL,
  `reward_sapphire` int(11) NOT NULL,
  `reward_ruby` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `robbery_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=70888 DEFAULT CHARSET=utf8;
;


CREATE TABLE `robbery_rating` (
  `best_reward_gold_day` int(16) NOT NULL,
  `id_user_gold_day` int(16) NOT NULL,
  `best_reward_exp_day` int(16) NOT NULL,
  `id_user_exp_day` int(16) NOT NULL,
  `best_reward_silver_day` int(11) NOT NULL,
  `id_user_silver_day` int(11) NOT NULL,
  `id_user_kill_day` int(11) NOT NULL,
  `best_kill_day` int(16) NOT NULL,
  `best_reward_ruby_day` int(11) NOT NULL,
  `id_user_ruby_day` int(11) NOT NULL,
  `best_reward_sapphire_day` int(11) NOT NULL,
  `id_user_sapphire_day` int(11) NOT NULL,
  `best_reward_emeralds_day` int(11) NOT NULL,
  `id_user_emeralds_day` int(11) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `best_reward_gold_all` int(11) NOT NULL,
  `id_user_gold_all` int(11) NOT NULL,
  `best_reward_silver_all` int(11) NOT NULL,
  `id_user_silver_all` int(11) NOT NULL,
  `best_reward_exp_all` int(11) NOT NULL,
  `id_user_exp_all` int(11) NOT NULL,
  `id_user_kill_all` int(11) NOT NULL,
  `best_kill_all` int(11) NOT NULL,
  `best_reward_ruby_all` int(11) NOT NULL,
  `id_user_ruby_all` int(11) NOT NULL,
  `best_reward_sapphire_all` int(11) NOT NULL,
  `id_user_sapphire_all` int(11) NOT NULL,
  `best_reward_emeralds_all` int(11) NOT NULL,
  `id_user_emeralds_all` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
;

INSERT INTO `robbery_rating` (`best_reward_gold_day`, `id_user_gold_day`, `best_reward_exp_day`, `id_user_exp_day`, `best_reward_silver_day`, `id_user_silver_day`, `id_user_kill_day`, `best_kill_day`, `best_reward_ruby_day`, `id_user_ruby_day`, `best_reward_sapphire_day`, `id_user_sapphire_day`, `best_reward_emeralds_day`, `id_user_emeralds_day`, `id`, `best_reward_gold_all`, `id_user_gold_all`, `best_reward_silver_all`, `id_user_silver_all`, `best_reward_exp_all`, `id_user_exp_all`, `id_user_kill_all`, `best_kill_all`, `best_reward_ruby_all`, `id_user_ruby_all`, `best_reward_sapphire_all`, `id_user_sapphire_all`, `best_reward_emeralds_all`, `id_user_emeralds_all`) VALUES 
	('0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0', '0');

CREATE TABLE `scramble_fight` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time_ready` int(11) NOT NULL,
  `id_enemy` int(11) NOT NULL,
  `hpUser` int(11) DEFAULT NULL,
  `hpEnemy` int(11) DEFAULT NULL,
  `last_attack` int(11) NOT NULL COMMENT 'Время удара противника ',
  `status` enum('fight','win','lose') NOT NULL,
  `trophies` int(11) NOT NULL,
  `dmgAllUser` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2023 DEFAULT CHARSET=utf8;
;


CREATE TABLE `scramble_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=817931 DEFAULT CHARSET=utf8;
;

CREATE TABLE `scramble_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `trophies` int(11) NOT NULL DEFAULT 100,
  `numFight` smallint(6) DEFAULT 20,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;
;


CREATE TABLE `section` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_topic` int(11) NOT NULL,
  `name` text NOT NULL,
  `access` enum('1','2','','') NOT NULL,
  `id_autor` int(11) NOT NULL,
  `description` text NOT NULL,
  `status` enum('open','closed','','') NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=154 DEFAULT CHARSET=utf8;
;

CREATE TABLE `section_comments` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  `id_section` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
;

CREATE TABLE `setting_game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `timeonline` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

INSERT INTO `setting_game` (`id`, `timeonline`) VALUES 
	('1', '1586146561');

CREATE TABLE `skill_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_skill` int(11) NOT NULL,
  `name` varchar(30) NOT NULL,
  `level` int(11) NOT NULL,
  `chance_operation` text NOT NULL,
  `bonus_percent` int(11) NOT NULL,
  `tip` enum('power','max_health','block','') NOT NULL,
  `stat` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=103 DEFAULT CHARSET=utf8;
;


CREATE TABLE `skills` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(30) NOT NULL,
  `description` text NOT NULL,
  `bonus_text` text NOT NULL,
  `tip` enum('power','max_health','block') NOT NULL,
  `chance_operation` int(11) NOT NULL,
  `bonus_percent` int(11) NOT NULL,
  `stat` int(11) NOT NULL,
  `img` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;
;

INSERT INTO `skills` (`id`, `name`, `description`, `bonus_text`, `tip`, `chance_operation`, `bonus_percent`, `stat`, `img`) VALUES 
	('1', 'Критомания', 'Удар критом', 'Критический урон', 'power', '10', '100', '0', 'crito_mania')
	,('2', 'Уворот', 'Шанс увернуться от удара противника', 'Уворот', 'max_health', '10', '0', '0', 'dodge')
	,('3', 'Крепкая броня', 'Блокировка удара', 'Блокировка атаки', 'block', '10', '10', '0', 'strong_block');

CREATE TABLE `smile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `img` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
;

CREATE TABLE `smiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `adres` varchar(1024) NOT NULL,
  `name` varchar(250) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=85 DEFAULT CHARSET=utf8;
;

INSERT INTO `smiles` (`id`, `adres`, `name`) VALUES 
	('1', '/images/smiles/1.gif', 'chit')
	,('2', '/images/smiles/2.gif', 'krut')
	,('3', '/images/smiles/3.gif', 'king')
	,('4', '/images/smiles/4.gif', 'ded')
	,('5', '/images/smiles/5.gif', 'palm')
	,('6', '/images/smiles/6.gif', 'ha')
	,('7', '/images/smiles/7.gif', 'D')
	,('8', '/images/smiles/8.gif', 'klass')
	,('9', '/images/smiles/9.gif', 'grust')
	,('10', '/images/smiles/10.gif', '-)')
	,('11', '/images/smiles/11.gif', 'P')
	,('12', '/images/smiles/12.gif', 'son')
	,('13', '/images/smiles/13.gif', 'mig')
	,('14', '/images/smiles/14.gif', 'aaa')
	,('15', '/images/smiles/air_kiss.gif', 'air_kiss')
	,('16', '/images/smiles/akiss.gif', 'akiss')
	,('17', '/images/smiles/alkawi.gif', 'alkawi')
	,('18', '/images/smiles/angel.gif', 'angel')
	,('19', '/images/smiles/angry.gif', 'angry')
	,('20', '/images/smiles/antifem.gif', 'antifem')
	,('21', '/images/smiles/atata.gif', 'atata')
	,('22', '/images/smiles/atata2.gif', 'atata2')
	,('23', '/images/smiles/baby.gif', 'baby')
	,('24', '/images/smiles/banka.gif', 'banka')
	,('25', '/images/smiles/bash.gif', 'bash')
	,('26', '/images/smiles/beach.gif', 'beach')
	,('27', '/images/smiles/bear.gif', 'bear')
	,('28', '/images/smiles/bow.gif', 'bow')
	,('29', '/images/smiles/bye.gif', 'bye')
	,('30', '/images/smiles/cage.gif', 'cage')
	,('31', '/images/smiles/camomile.gif', 'camomile')
	,('32', '/images/smiles/celuju.gif', 'celuju')
	,('33', '/images/smiles/censored.gif', 'censored')
	,('34', '/images/smiles/chasy.gif', 'chasy')
	,('35', '/images/smiles/cheburashka.gif', 'cheburashka')
	,('36', '/images/smiles/chmok.gif', 'chmok')
	,('37', '/images/smiles/comando.gif', 'comando')
	,('38', '/images/smiles/crazy.gif', 'crazy')
	,('39', '/images/smiles/d_sunny.gif', 'd_sunny')
	,('40', '/images/smiles/deaf.gif', 'deaf')
	,('41', '/images/smiles/diablo.gif', 'diablo')
	,('42', '/images/smiles/dovolen.gif', 'dovolen')
	,('43', '/images/smiles/draka.gif', 'draka')
	,('44', '/images/smiles/duw.gif', 'duw')
	,('45', '/images/smiles/eda.gif', 'eda')
	,('46', '/images/smiles/elka.gif', 'elka')
	,('47', '/images/smiles/hi.gif', 'hi')
	,('48', '/images/smiles/holms.gif', 'holms')
	,('49', '/images/smiles/hooray.gif', 'hooray')
	,('50', '/images/smiles/karty.gif', 'karty')
	,('51', '/images/smiles/lechitsja.gif', 'lechitsja')
	,('52', '/images/smiles/mad.gif', 'mad')
	,('53', '/images/smiles/nea.gif', 'nea')
	,('54', '/images/smiles/newyear.gif', 'newyear')
	,('55', '/images/smiles/nhl.gif', 'nhl')
	,('56', '/images/smiles/nono.gif', 'nono')
	,('57', '/images/smiles/nyam.gif', 'nyam')
	,('58', '/images/smiles/olimp.gif', 'olimp')
	,('59', '/images/smiles/osen.gif', 'osen')
	,('60', '/images/smiles/pardon.gif', 'pardon')
	,('61', '/images/smiles/poka.gif', 'poka')
	,('62', '/images/smiles/popcorn.gif', 'popcorn')
	,('63', '/images/smiles/preved.gif', 'preved')
	,('64', '/images/smiles/privet.gif', 'privet')
	,('65', '/images/smiles/puzyr.gif', 'puzyr')
	,('66', '/images/smiles/roulette.gif', 'roulette')
	,('67', '/images/smiles/roza.gif', 'roza')
	,('68', '/images/smiles/santa.gif', 'santa')
	,('69', '/images/smiles/sarkastik.gif', 'sarkastik')
	,('70', '/images/smiles/scare.gif', 'scare')
	,('71', '/images/smiles/shout.gif', 'shout')
	,('72', '/images/smiles/snegur.gif', 'snegur')
	,('73', '/images/smiles/sorri.gif', 'sorri')
	,('74', '/images/smiles/stena.gif', 'stena')
	,('75', '/images/smiles/sumas.gif', 'sumas')
	,('76', '/images/smiles/superstition.gif', 'superstition')
	,('77', '/images/smiles/wiz23.gif', 'svadba')
	,('78', '/images/smiles/wizghost.gif', 'swoon')
	,('79', '/images/smiles/wizsanta.gif', 'tanec')
	,('80', '/images/smiles/wizsgirl.gif', 'tommy')
	,('81', '/images/smiles/wizslady.gif', 'ura')
	,('82', '/images/smiles/wiztree.gif', 'vinsent')
	,('83', '/images/smiles/wizval.gif', 'vkusna')
	,('84', '/images/smiles/joke.gif', 'xmas');

CREATE TABLE `spam` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) DEFAULT 0,
  `id_msg` int(11) DEFAULT 0,
  `time` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
;


CREATE TABLE `subject` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(225) NOT NULL,
  `translate` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `images` varchar(255) NOT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `health` int(11) NOT NULL DEFAULT 0,
  `power` int(11) NOT NULL DEFAULT 0,
  `block` int(11) NOT NULL DEFAULT 0,
  `what` set('clothing','resource') NOT NULL DEFAULT 'clothing',
  `clothing_type` set('head','body','gloves','weapon','shield','boots') NOT NULL,
  `clothing_mark` set('1','2','3','4','5') NOT NULL,
  `price` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8;
;

INSERT INTO `subject` (`id`, `name`, `translate`, `description`, `images`, `level`, `health`, `power`, `block`, `what`, `clothing_type`, `clothing_mark`, `price`) VALUES 
	('31', 'Шлем Рыцаря', 'shlem-ryitsarya', '', '/images/subject/head/1.png', '1', '15', '20', '15', 'clothing', 'head', '1', '10')
	,('32', 'Шлем Защитника', 'shlem-zaschitnika', '', '/images/subject/head/2.png', '1', '15', '20', '15', 'clothing', 'head', '1', '10')
	,('33', 'Шлем Ассасина', 'shlem-assasina', '', '/images/subject/head/3.png', '1', '15', '20', '15', 'clothing', 'head', '1', '10')
	,('34', 'Шлем Убийцы ', 'shlem-ryitsarya', '', '/images/subject/head/4.png', '5', '45', '45', '40', 'clothing', 'head', '2', '10')
	,('35', 'Шлем Разрушителя ', 'shlem-zaschitnika', '', '/images/subject/head/6.png', '5', '45', '45', '40', 'clothing', 'head', '2', '10')
	,('36', 'Шлем Варвара', 'shlem-assasina', '', '/images/subject/head/7.png', '5', '45', '45', '40', 'clothing', 'head', '2', '10')
	,('38', 'Шлем Ополченца ', 'shlem-zaschitnika', '', '/images/subject/head/8.png', '10', '95', '95', '85', 'clothing', 'head', '3', '175')
	,('39', 'Шлем Тьмы ', 'shlem-assasina', '', '/images/subject/head/9.png', '10', '95', '95', '85', 'clothing', 'head', '3', '175')
	,('40', 'Корона Короля', 'shlem-ryitsarya', '', '/images/subject/head/10.png', '10', '95', '95', '85', 'clothing', 'head', '3', '175')
	,('41', 'Шлем Хранителя ', 'shlem-zaschitnika', '', '/images/subject/head/11.png', '15', '160', '160', '150', 'clothing', 'head', '4', '1120')
	,('42', 'Шлем Правителя ', 'shlem-assasina', '', '/images/subject/head/12.png', '15', '160', '160', '150', 'clothing', 'head', '4', '1120')
	,('43', 'Шлем Тёмного рыцаря', 'shlem-assasina', '', '/images/subject/head/13.png', '15', '160', '160', '150', 'clothing', 'head', '4', '1120')
	,('44', 'Доспех Рыцаря', 'shlem-ryitsarya', '', '/images/subject/body/1.png', '1', '15', '20', '15', 'clothing', 'body', '1', '10')
	,('45', 'Доспех Защитника', 'shlem-zaschitnika', '', '/images/subject/body/2.png', '1', '15', '20', '15', 'clothing', 'body', '1', '10')
	,('46', 'Доспех Ассасина', 'shlem-assasina', '', '/images/subject/body/3.png', '1', '15', '20', '15', 'clothing', 'body', '1', '10')
	,('47', 'Доспех Убийцы', 'shlem-zaschitnika', '', '/images/subject/body/4.png', '5', '45', '45', '40', 'clothing', 'body', '2', '31')
	,('48', 'Доспех Разрушителя ', 'shlem-zaschitnika', '', '/images/subject/body/6.png', '5', '45', '45', '40', 'clothing', 'body', '2', '31')
	,('49', 'Доспех Варвара', 'shlem-assasina', '', '/images/subject/body/7.png', '5', '45', '45', '40', 'clothing', 'body', '2', '31')
	,('50', 'Доспех Ополченца ', 'shlem-zaschitnika', '', '/images/subject/body/8.png', '10', '95', '95', '85', 'clothing', 'body', '3', '175')
	,('51', 'Доспех Тьмы ', 'shlem-assasina', '', '/images/subject/body/9.png', '10', '95', '95', '85', 'clothing', 'body', '3', '175')
	,('52', 'Доспех Короля', 'shlem-ryitsarya', '', '/images/subject/body/10.png', '10', '95', '95', '85', 'clothing', 'body', '3', '175')
	,('53', 'Доспех Хранителя ', 'shlem-zaschitnika', '', '/images/subject/body/11.png', '15', '160', '160', '150', 'clothing', 'body', '4', '1120')
	,('54', 'Доспех Правителя ', 'shlem-assasina', '', '/images/subject/body/12.png', '15', '160', '160', '150', 'clothing', 'body', '4', '1120')
	,('55', 'Доспех Тёмного рыцаря', 'shlem-assasina', '', '/images/subject/body/13.png', '15', '160', '160', '150', 'clothing', 'body', '4', '1120')
	,('56', 'Перчатки Рыцаря', 'perchatki-ryitsarya', '', '/images/subject/gloves/1.png', '1', '15', '20', '15', 'clothing', 'gloves', '1', '10')
	,('57', 'Перчатки Защитника', 'perchatki-zaschitnika', '', '/images/subject/gloves/2.png', '1', '15', '20', '15', 'clothing', 'gloves', '1', '10')
	,('58', 'Перчатки Ассасина', 'perchatki-assasina', '', '/images/subject/gloves/3.png', '1', '15', '20', '15', 'clothing', 'gloves', '1', '10')
	,('59', 'Перчатки Разрушителя', 'perchatki-razrushitelya', '', '/images/subject/gloves/4.png', '5', '45', '45', '40', 'clothing', 'gloves', '2', '31')
	,('60', 'Перчатки Убийцы', 'perchatki-ubiytsyi', '', '/images/subject/gloves/6.png', '5', '45', '45', '40', 'clothing', 'gloves', '2', '31')
	,('61', 'Перчатки Варвара', 'perchatki-varvara', '', '/images/subject/gloves/7.png', '5', '45', '45', '40', 'clothing', 'gloves', '2', '31')
	,('62', 'Перчатки Ополченца', 'perchatki-opolchentsa', '', '/images/subject/gloves/8.png', '10', '95', '95', '85', 'clothing', 'gloves', '3', '175')
	,('63', 'Перчатки Тьмы', 'perchatki-tmi', '', '/images/subject/gloves/9.png', '10', '95', '95', '85', 'clothing', 'gloves', '3', '175')
	,('64', 'Перчатки Короля', 'perchatki-korolya', '', '/images/subject/gloves/10.png', '10', '95', '95', '85', 'clothing', 'gloves', '3', '175')
	,('65', 'Перчатки Хранителя', 'perchatki-hranitelya', '', '/images/subject/gloves/11.png', '15', '160', '160', '160', 'clothing', 'gloves', '4', '1120')
	,('66', 'Перчатки Правителя', 'perchatki-pravitelya', '', '/images/subject/gloves/12.png', '15', '160', '160', '150', 'clothing', 'gloves', '4', '1120')
	,('67', 'Перчатки Темного рыцаря', 'perchatki-temnogo-ryitsarya', '', '/images/subject/gloves/13.png', '15', '160', '160', '150', 'clothing', 'gloves', '4', '1120')
	,('68', 'Оружие Рыцаря', 'orujie-ryitsarya', '', '/images/subject/weapon/1.png', '1', '15', '20', '15', 'clothing', 'weapon', '1', '10')
	,('69', 'Оружие Защитника', 'orujie-zaschitnika', '', '/images/subject/weapon/2.png', '1', '15', '20', '15', 'clothing', 'weapon', '1', '10')
	,('70', 'Оружие Ассасина', 'orujie-assasina', '', '/images/subject/weapon/3.png', '1', '15', '20', '15', 'clothing', 'weapon', '1', '10')
	,('71', 'Оружие Убийцы', 'orujie-ubiytsyi', '', '/images/subject/weapon/4.png', '5', '45', '45', '40', 'clothing', 'weapon', '2', '31')
	,('72', 'Оружие Разрушителя', 'orujie-razrushitelya', '', '/images/subject/weapon/6.png', '5', '45', '45', '40', 'clothing', 'weapon', '2', '31')
	,('73', 'Оружие Варвара', 'orujie-varvara', '', '/images/subject/weapon/7.png', '5', '45', '45', '40', 'clothing', 'weapon', '2', '31')
	,('74', 'Оружие Ополченца', 'orujie-opolchentsa', '', '/images/subject/weapon/8.png', '10', '95', '95', '85', 'clothing', 'weapon', '3', '175')
	,('75', 'Оружие Тьмы', 'orujie-tmi', '', '/images/subject/weapon/9.png', '10', '95', '95', '85', 'clothing', 'weapon', '3', '175')
	,('76', 'Оружие Короля', 'orujie-korolya', '', '/images/subject/weapon/10.png', '10', '95', '95', '85', 'clothing', 'weapon', '3', '175')
	,('77', 'Оружие Хранителя', 'orujie-hranitelya', '', '/images/subject/weapon/11.png', '15', '160', '160', '150', 'clothing', 'weapon', '4', '1120')
	,('78', 'Оружие Правителя', 'orujie-pravitelya', '', '/images/subject/weapon/12.png', '15', '160', '160', '150', 'clothing', 'weapon', '4', '1120')
	,('79', 'Оружие Темного рыцаря', 'orujie-temnogo-ryitsarya', '', '/images/subject/weapon/13.png', '15', '160', '160', '150', 'clothing', 'weapon', '4', '1120')
	,('80', 'Щит Рыцаря', 'schit-ryitsarya', '', '/images/subject/shield/1.png', '1', '15', '20', '15', 'clothing', 'shield', '1', '10')
	,('81', 'Щит Защитника', 'schit-zaschitnika', '', '/images/subject/shield/2.png', '1', '15', '20', '15', 'clothing', 'shield', '1', '10')
	,('82', 'Щит Ассасина', 'schit-assasina', '', '/images/subject/shield/3.png', '1', '15', '20', '15', 'clothing', 'shield', '1', '10')
	,('83', 'Щит Убийцы', 'schit-ubiytsyi', '', '/images/subject/shield/4.png', '5', '45', '45', '40', 'clothing', 'shield', '2', '31')
	,('84', 'Щит Разрушителя', 'schit-razrushitelya', '', '/images/subject/shield/6.png', '5', '45', '45', '40', 'clothing', 'shield', '2', '31')
	,('85', 'Щит Варвара', 'schit-varvara', '', '/images/subject/shield/7.png', '5', '45', '45', '40', 'clothing', 'shield', '2', '31')
	,('86', 'Щит Ополченца', 'schit-opolchentsa', '', '/images/subject/shield/8.png', '10', '95', '95', '85', 'clothing', 'shield', '3', '175')
	,('87', 'Щит Тьмы', 'schit-tmi', '', '/images/subject/shield/9.png', '10', '95', '95', '85', 'clothing', 'shield', '3', '175')
	,('88', 'Щит Короля', 'schit-korolya', '', '/images/subject/shield/10.png', '10', '95', '95', '85', 'clothing', 'shield', '3', '175')
	,('89', 'Щит Хранителя', 'schit-hranitelya', '', '/images/subject/shield/11.png', '15', '160', '160', '150', 'clothing', 'shield', '4', '1120')
	,('90', 'Щит Правителя', 'schit-pravitelya', '', '/images/subject/shield/12.png', '15', '160', '160', '150', 'clothing', 'shield', '4', '1120')
	,('91', 'Щит Темного рыцаря', 'schit-temnogo-ryitsarya', '', '/images/subject/shield/13.png', '15', '160', '160', '150', 'clothing', 'shield', '4', '1120')
	,('92', 'Сапоги Рыцаря', 'sapogi-ryitsarya', '', '/images/subject/boots/1.png', '1', '15', '20', '15', 'clothing', 'boots', '1', '10')
	,('93', 'Сапоги Защитника', 'sapogi-zaschitnika', '', '/images/subject/boots/2.png', '1', '15', '20', '15', 'clothing', 'boots', '1', '10')
	,('94', 'Сапоги Ассасина', 'sapogi-assasina', '', '/images/subject/boots/3.png', '1', '15', '20', '15', 'clothing', 'boots', '1', '10')
	,('95', 'Сапоги Убийцы', 'sapogi-ubiytsyi', '', '/images/subject/boots/4.png', '5', '45', '45', '40', 'clothing', 'boots', '2', '31')
	,('96', 'Сапоги Разрушителя', 'sapogi-razrushitelya', '', '/images/subject/boots/6.png', '5', '45', '45', '40', 'clothing', 'boots', '2', '31')
	,('97', 'Сапоги Варвара', 'sapogi-varvara', '', '/images/subject/boots/7.png', '5', '45', '45', '40', 'clothing', 'boots', '2', '31')
	,('98', 'Сапоги Ополченца', 'sapogi-opolchentsa', '', '/images/subject/boots/8.png', '10', '95', '95', '85', 'clothing', 'boots', '3', '175')
	,('99', 'Сапоги Тьмы', 'sapogi-tmi', '', '/images/subject/boots/9.png', '10', '95', '95', '85', 'clothing', 'boots', '3', '175')
	,('100', 'Сапоги Короля', 'sapogi-korolya', '', '/images/subject/boots/10.png', '10', '95', '95', '85', 'clothing', 'boots', '3', '175')
	,('103', 'Сапоги Правителя', 'sapogi-pravitelya', '', '/images/subject/boots/11.png', '15', '160', '160', '150', 'clothing', 'boots', '4', '1120')
	,('104', 'Сапоги Хранителя', '', '', '/images/subject/boots/12.png', '15', '160', '160', '150', 'clothing', 'boots', '4', '1120')
	,('105', 'Сапоги Тьмы', 'sapogi-tmyi', '', '/images/subject/boots/13.png', '15', '160', '160', '150', 'clothing', 'boots', '4', '1120')
	,('106', 'Шлем Стражника ', 'shlem-strajnika-', '', '/images/subject/head/14.png', '25', '200', '200', '200', 'clothing', 'head', '5', '1750')
	,('107', 'Доспех  Стражника', 'dospeh--strajnika', '', '/images/subject/body/14.png', '25', '220', '200', '220', 'clothing', 'body', '5', '1750')
	,('108', 'Перчатки Стражника', 'perchatki-strajnika', '', '/images/subject/gloves/14.png', '25', '200', '220', '220', 'clothing', 'gloves', '5', '1750')
	,('109', 'Щит Стражника', 'schit-strajnika', '', '/images/subject/shield/14.png', '25', '220', '200', '225', 'clothing', 'shield', '5', '1750')
	,('110', 'Молот Стражника', 'kope-strajnika', '', '/images/subject/weapon/14.png', '25', '200', '230', '210', 'clothing', 'weapon', '5', '1750')
	,('111', 'Сапоги Стражника', 'sapogi-strajnika', '', '/images/subject/boots/14.png', '25', '200', '200', '200', 'clothing', 'boots', '5', '1750')
	,('112', 'Шлем Великого воина', '', '', '/images/subject/head/15.png', '30', '320', '320', '320', 'clothing', 'head', '5', '2520')
	,('113', 'Доспех Великого воина', '', '', '/images/subject/body/15.png', '30', '320', '320', '320', 'clothing', 'body', '5', '2520')
	,('114', 'Перчатки Великого воина', '', '', '/images/subject/gloves/15.png', '30', '320', '320', '320', 'clothing', 'gloves', '5', '2520')
	,('115', 'Щит Великого воина', '', '', '/images/subject/shield/15.png', '30', '320', '320', '320', 'clothing', 'shield', '5', '2520')
	,('116', 'Топор Великого воина', '', '', '/images/subject/weapon/15.png', '30', '320', '320', '320', 'clothing', 'weapon', '5', '2520')
	,('117', 'Сапоги Великого воина', '', '', '/images/subject/boots/15.png', '30', '320', '320', '320', 'clothing', 'boots', '5', '2520')
	,('118', 'Шлем Гладиатора', '', '', '/images/subject/head/16.png', '35', '480', '480', '480', 'clothing', 'head', '5', '3430')
	,('119', 'Доспех Гладиатора', '', '', '/images/subject/body/16.png', '35', '480', '480', '480', 'clothing', 'body', '5', '3430')
	,('120', 'Перчатки Гладиатора', '', '', '/images/subject/gloves/16.png\n', '35', '480', '480', '480', 'clothing', 'gloves', '5', '3430')
	,('121', 'Щит Гладиатора', '', '', '/images/subject/shield/16.png\n', '35', '480', '480', '480', 'clothing', 'shield', '5', '3430')
	,('122', 'Меч Гладиатора', '', '', '/images/subject/weapon/16.png', '35', '480', '480', '480', 'clothing', 'weapon', '5', '3430')
	,('123', 'Сапоги Гладиатора', '', '', '/images/subject/boots/16.png', '35', '480', '480', '480', 'clothing', 'boots', '5', '3430')
	,('124', 'Шлем Главнокомандующего', '', '', '/images/subject/head/17.png', '35', '690', '690', '690', 'clothing', 'head', '5', '4480')
	,('125', 'Доспех Главнокомандующего', '', '', '/images/subject/body/17.png', '35', '690', '690', '690', 'clothing', 'body', '5', '4480')
	,('126', 'Перчатки Главнокомандующего', '', '', '/images/subject/gloves/17.png', '35', '690', '690', '690', 'clothing', 'gloves', '5', '4480')
	,('127', 'Щит Главнокомандующего', '', '', '/images/subject/shield/17.png', '35', '690', '690', '690', 'clothing', 'shield', '5', '4480')
	,('128', 'Меч Главнокомандующего', '', '', '/images/subject/weapon/17.png', '35', '690', '690', '690', 'clothing', 'weapon', '5', '4480')
	,('129', 'Сапоги Главнокомандующего', '', '', '/images/subject/boots/17.png', '35', '690', '690', '690', 'clothing', 'boots', '5', '4480')
	,('130', 'Шлем Избранного воина', '', '', '/images/subject/head/36.png', '35', '3200', '3200', '3200', 'clothing', 'head', '5', '16450')
	,('131', 'Доспех Избранного воина', '', '', '/images/subject/body/21.png', '35', '3200', '3200', '3200', 'clothing', 'body', '5', '16450')
	,('132', 'Перчатки Избранного воина', '', '', '/images/subject/gloves/33.png', '35', '3200', '3200', '3200', 'clothing', 'gloves', '5', '16450')
	,('133', 'Щит Избранного воина', '', '', '/images/subject/shield/29.png', '35', '3200', '3200', '3200', 'clothing', 'shield', '5', '16450')
	,('134', 'Меч Избранного воина', '', '', '/images/subject/weapon/27.png', '35', '3200', '3200', '3200', 'clothing', 'weapon', '5', '16450')
	,('135', 'Сапоги Избранного воина', '', '', '/images/subject/boots/29.png', '35', '3200', '3200', '3200', 'clothing', 'boots', '5', '16450')
	,('136', 'Шлем дракона', '', '', '/images/subject/body/50.png', '45', '4000', '4000', '4000', 'clothing', 'head', '5', '22500')
	,('137', 'Доспех дракона', '', '', '/images/subject/head/50.png', '45', '4000', '4000', '4000', 'clothing', 'body', '5', '22500')
	,('138', 'Перчатки Дракона', '', '', '/images/subject/gloves/51.png', '45', '4000', '4000', '4000', 'clothing', 'gloves', '5', '22500')
	,('139', 'Щит Дракона', '', '', '/images/subject/shield/50.png', '45', '4000', '4000', '4000', 'clothing', 'shield', '5', '22500')
	,('140', 'Оружие Дракона', '', '', '/images/subject/weapon/50.png', '45', '4000', '4000', '4000', 'clothing', 'weapon', '5', '22500')
	,('141', 'Сапоги Дракона', '', '', '/images/subject/boots/50.png', '45', '4000', '4000', '4000', 'clothing', 'boots', '5', '22500');

CREATE TABLE `support` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  `ticket_type` set('0','1','2') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `upd` int(11) NOT NULL,
  `closed` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
;

CREATE TABLE `support_answer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ticket` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `answer` set('0','1','2','3') NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

CREATE TABLE `task` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `reward_one` int(11) NOT NULL,
  `reward_one_type` enum('gold','exp','silver') NOT NULL,
  `reward_two` int(11) NOT NULL,
  `reward_two_type` enum('gold','exp','silver') NOT NULL,
  `need_implement` int(11) NOT NULL,
  `location` enum('camp','boss','ramp','pay','task','inv') NOT NULL,
  `action` enum('fight','win','kill','buy','complete','sell') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;
;

INSERT INTO `task` (`id`, `name`, `reward_one`, `reward_one_type`, `reward_two`, `reward_two_type`, `need_implement`, `location`, `action`) VALUES 
	('1', 'Убить на карте 15 врагов', '15', 'gold', '3000', 'silver', '15', 'camp', 'fight')
	,('2', 'Сразиться с личным босом 5 раз', '20', 'gold', '300', 'silver', '5', 'boss', 'fight')
	,('3', 'Убить 10 врагов в походе', '20', 'gold', '3000', 'silver', '10', 'ramp', 'kill')
	,('4', 'Купи 1100 золота', '100', 'gold', '5000', 'silver', '1100', 'pay', 'buy')
	,('5', 'Выполнить 4  любых заданий', '10', 'gold', '2500', 'silver', '4', 'task', 'complete')
	,('6', 'Разберите 5 любых вещей', '5', 'gold', '1500', 'silver', '5', 'inv', 'sell');

CREATE TABLE `task_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `progress` int(11) NOT NULL,
  `need_implement` int(11) NOT NULL,
  `id_task` int(11) NOT NULL,
  `action` enum('fight','win','kill','buy','complete','sell') NOT NULL,
  `location` enum('camp','boss','ramp','pay','task','inv') NOT NULL,
  `status` enum('performence','complete') NOT NULL,
  `reward_one_type` enum('gold','exp','silver') NOT NULL,
  `reward_one` int(11) NOT NULL,
  `reward_two_type` enum('gold','exp','silver') NOT NULL,
  `reward_two` int(11) NOT NULL,
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2629 DEFAULT CHARSET=utf8;
;

CREATE TABLE `tournament` (
  `id` int(11) NOT NULL AUTO_INCREMENT COMMENT 'ID',
  `id_user` int(11) NOT NULL COMMENT 'ID USER',
  `numKill` int(11) NOT NULL COMMENT 'HOW MUCH KILL',
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `user_notification` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` varchar(500) NOT NULL,
  `time` int(16) NOT NULL,
  `date` varchar(32) NOT NULL,
  `read` enum('no','yes') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3702 DEFAULT CHARSET=utf8;
;

CREATE TABLE `user_train` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(16) NOT NULL,
  `type_train` enum('power','health','block') NOT NULL,
  `level` smallint(5) NOT NULL DEFAULT 1,
  `time_wait_train` int(11) NOT NULL,
  `amountStat` int(11) NOT NULL,
  `status` enum('default','train','end') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=145 DEFAULT CHARSET=utf8;
;

CREATE TABLE `users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `login` varchar(32) NOT NULL,
  `password` varchar(32) NOT NULL,
  `email` varchar(255) NOT NULL,
  `date_registr` int(11) NOT NULL,
  `date_online` int(11) NOT NULL,
  `sex` set('male','female') NOT NULL,
  `admin` set('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  `gold` int(11) NOT NULL DEFAULT 0,
  `level` int(11) NOT NULL DEFAULT 1,
  `exp` int(11) NOT NULL DEFAULT 0,
  `health` int(11) NOT NULL DEFAULT 25,
  `max_health` int(11) NOT NULL DEFAULT 25,
  `power` int(11) NOT NULL DEFAULT 10,
  `block` int(11) NOT NULL DEFAULT 5,
  `save` int(16) NOT NULL DEFAULT 0,
  `IP` varchar(225) NOT NULL,
  `last_attack` int(11) NOT NULL,
  `last_update` int(11) NOT NULL,
  `koll` int(11) NOT NULL,
  `ruby` int(11) NOT NULL,
  `almaz` int(11) NOT NULL,
  `rock` int(11) NOT NULL,
  `kindom` int(11) NOT NULL,
  `sapphire` int(11) NOT NULL COMMENT 'Сапфир',
  `emeralds` int(11) NOT NULL COMMENT 'Изумруды',
  `avatar` text NOT NULL,
  `fatigue` int(11) NOT NULL COMMENT 'Усталость',
  `chat_read` enum('no','yes') NOT NULL,
  `silver` int(11) NOT NULL,
  `id_castle` int(11) NOT NULL,
  `hash` varchar(32) NOT NULL,
  `timeSendLastChat` int(11) NOT NULL COMMENT 'Последная отправка в чате',
  `timeSendLastMail` int(11) NOT NULL COMMENT 'Последная отправка в ПОЧТЕ',
  `numFightBoss` int(11) NOT NULL,
  `numFightRobbery` int(11) NOT NULL,
  `activation_code` varchar(32) NOT NULL,
  `activation` int(16) NOT NULL,
  `news_read` enum('','no','yes') NOT NULL,
  `id_referal` int(16) NOT NULL,
  `snowflake` int(16) NOT NULL,
  `heart` smallint(6) NOT NULL,
  `tournamentKill` int(16) DEFAULT NULL,
  `pointGlory` int(11) NOT NULL COMMENT 'Очки славы ',
  `maxTrophies` smallint(6) DEFAULT NULL,
  `r` int(11) NOT NULL DEFAULT 0,
  `calls` int(11) NOT NULL DEFAULT 1,
  `timers` int(11) NOT NULL,
  `rew` int(11) NOT NULL,
  `sett_mail` int(11) DEFAULT 0,
  `present_day` smallint(2) unsigned NOT NULL DEFAULT 1,
  `_day` tinyint(2) unsigned NOT NULL DEFAULT 1,
  `day` int(11) NOT NULL,
  `datep` varchar(32) DEFAULT NULL,
  `recovery_code` varchar(125) NOT NULL DEFAULT '',
  `awed` int(11) DEFAULT 0,
  `isTrup` int(11) DEFAULT 0,
  `timeTrup` varchar(20) DEFAULT '0',
  `ubilTrup` int(11) DEFAULT 0,
  `avka` tinytext DEFAULT NULL,
  `avkaIs` int(11) DEFAULT 0,
  `gradient1` varchar(32) NOT NULL,
  `gradient2` varchar(32) NOT NULL,
  `lotolvl` int(11) DEFAULT 1,
  `id_mir` int(11) DEFAULT 1,
  `x_mir` int(11) DEFAULT 0,
  `y_mir` int(11) DEFAULT 0,
  `sapfir1` int(11) NOT NULL,
  `sapfir2` int(11) NOT NULL,
  `wolfkill` int(11) NOT NULL,
  `wolfkill1` int(11) NOT NULL,
  `timewolf` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=132 DEFAULT CHARSET=utf8;
;

CREATE TABLE `users_amulet` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `level` int(11) NOT NULL DEFAULT 1,
  `bonus` int(11) NOT NULL DEFAULT 10,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=127 DEFAULT CHARSET=utf8;
;


CREATE TABLE `users_inv` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_subject` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `name` varchar(255) NOT NULL,
  `translate` varchar(255) NOT NULL,
  `description` text NOT NULL,
  `images` text NOT NULL,
  `equip` set('yes','no','','') NOT NULL,
  `what` set('clothing','resource') NOT NULL DEFAULT 'resource',
  `clothing_type` set('head','body','gloves','weapon','shield','boots') NOT NULL,
  `clothing_mark` set('1','2','3','4','5') NOT NULL,
  `amount` int(11) NOT NULL,
  `health` int(11) NOT NULL,
  `block` int(11) NOT NULL,
  `power` int(11) NOT NULL,
  `rank` int(11) NOT NULL,
  `rank_percent` int(11) NOT NULL,
  `amount_rank` int(11) NOT NULL,
  `enchant_id` smallint(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=842 DEFAULT CHARSET=utf8;
;

CREATE TABLE `users_log_sell_item` (
  `id_user` int(11) NOT NULL,
  `text` text NOT NULL,
  `time` varchar(30) NOT NULL,
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=545 DEFAULT CHARSET=utf8;
;

CREATE TABLE `users_sunduk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `timeSunduk1` int(11) NOT NULL,
  `timeSunduk2` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;
;


CREATE TABLE `users_sunduk_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `text` varchar(200) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=579 DEFAULT CHARSET=utf8;
;


CREATE TABLE `vip_user` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_user` int(16) NOT NULL,
  `levelVip` smallint(6) NOT NULL DEFAULT 1,
  `activeTime` int(16) DEFAULT NULL,
  `stats` smallint(6) NOT NULL DEFAULT 100,
  `bonus` smallint(6) NOT NULL DEFAULT 50,
  `status` enum('off','on') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8;
;


CREATE TABLE `wapkassa_log` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `time` varchar(64) NOT NULL,
  `status` enum('','error','success') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;
CREATE TABLE `warboss` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `health` int(16) NOT NULL,
  `max_health` int(16) NOT NULL,
  `status` enum('default','fight','dead','') NOT NULL,
  `power` int(11) NOT NULL,
  `block` int(11) NOT NULL,
  `time` int(16) NOT NULL,
  `id_kill` int(11) NOT NULL,
  `last_attack` int(11) NOT NULL,
  `boss` smallint(6) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
;

CREATE TABLE `warboss_log` (
  `id` int(16) NOT NULL AUTO_INCREMENT,
  `id_user` int(16) NOT NULL,
  `text` text NOT NULL,
  `boss` smallint(3) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3651 DEFAULT CHARSET=utf8;
;

CREATE TABLE `warboss_members` (
  `id` int(14) NOT NULL AUTO_INCREMENT,
  `id_user` int(15) NOT NULL,
  `allDamage` int(16) NOT NULL,
  `statusReward` enum('notReceived','got') NOT NULL,
  `statusFight` enum('default','fights') NOT NULL,
  `timeFine` int(11) NOT NULL,
  `health` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;
;


CREATE TABLE `xsolla_billing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `invoice` int(11) NOT NULL,
  `v1` int(11) NOT NULL,
  `currency` varchar(200) NOT NULL,
  `date` varchar(200) NOT NULL,
  `canceled` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `xsolla_payment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `transaction_id` bigint(20) DEFAULT 0,
  `payment_date` varchar(64) DEFAULT NULL,
  `payment_currency` varchar(5) DEFAULT NULL,
  `payment_amount` decimal(11,2) DEFAULT 0.00,
  `id_user` int(11) DEFAULT 0,
  `currency_name` varchar(32) DEFAULT NULL,
  `currency_count` int(11) DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `xsolla_shop` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_shop` int(11) NOT NULL,
  `v1` int(11) NOT NULL,
  `sum` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
