DROP TABLE IF EXISTS `Ponaehali`;

CREATE TABLE `Ponaehali` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `time_end` int(11) DEFAULT '0',
  `male` int(11) DEFAULT '0',
  `female` int(11) DEFAULT '0',
  `win` varchar(128) DEFAULT '0',
  `active` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_chat`;

CREATE TABLE `Ponaehali_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_tournament` int(11) DEFAULT '0',
  `sex` varchar(12) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_users`;

CREATE TABLE `Ponaehali_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `level` int(11) DEFAULT '0',
  `sex` varchar(32) NOT NULL DEFAULT 'male',
  `rating` int(11) DEFAULT '0',
  `time_reboot` int(11) DEFAULT '0',
  `count_weapon` int(11) DEFAULT '0',
  `count_win` int(11) DEFAULT '0',
  `count_loss` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_weapons`;

CREATE TABLE `Ponaehali_weapons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  `id_weapon` int(11) DEFAULT '1',
  `type` varchar(32) DEFAULT 'tomate',
  `style` varchar(512) DEFAULT '',
  `sex` varchar(128) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football`;

CREATE TABLE `_football` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `balls` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `boys` int(11) DEFAULT '0',
  `gerls` int(11) DEFAULT '0',
  `winner` varchar(128) DEFAULT '0',
  `active` enum('0','1') NOT NULL DEFAULT '0',
  `time_stop` int(11) DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_blow`;

CREATE TABLE `_football_blow` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `sex` varchar(16) DEFAULT 'male',
  `id_football` int(11) DEFAULT '0',
  `msg` text,
  `time` int(11) NOT NULL,
  `udar` int(11) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_chat`;

CREATE TABLE `_football_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_user`;

CREATE TABLE `_football_user` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `date_r` int(11) NOT NULL,
  `blows` int(11) NOT NULL DEFAULT '0',
  `sex` varchar(16) NOT NULL DEFAULT 'male',
  `time_reset` int(11) DEFAULT '0',
  `blows_past` int(11) NOT NULL DEFAULT '0',
  `life` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `activnost`;

CREATE TABLE `activnost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(400) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `id_user` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `adm_chat`;

CREATE TABLE `adm_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `adm_logs`;

CREATE TABLE `adm_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` char(15) NOT NULL,
  `who` int(11) NOT NULL DEFAULT '0',
  `type` char(10) NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `why` char(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log`;

CREATE TABLE `admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `mod` int(11) NOT NULL,
  `act` int(11) NOT NULL,
  `opis` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mod` (`mod`),
  KEY `act` (`act`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log_act`;

CREATE TABLE `admin_log_act` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mod` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `act` (`name`),
  KEY `id_mod` (`id_mod`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log_mod`;

CREATE TABLE `admin_log_mod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_logs`;

CREATE TABLE `admin_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `albums`;

CREATE TABLE `albums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `parol` int(11) NOT NULL DEFAULT '0',
  `friend_looks` smallint(2) NOT NULL DEFAULT '0',
  `path` char(100) NOT NULL,
  `name` char(50) NOT NULL,
  `type` char(1) NOT NULL,
  `cat` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `rotate` int(11) NOT NULL DEFAULT '0',
  `friend_comm` smallint(2) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  `cover` smallint(1) NOT NULL DEFAULT '0',
  `block` smallint(1) NOT NULL DEFAULT '0',
  `who_block` int(11) NOT NULL DEFAULT '0',
  `why_block` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `all_accesses`;

CREATE TABLE `all_accesses` (
  `type` varchar(32) NOT NULL,
  `name` varchar(64) NOT NULL,
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO all_accesses VALUES("adm_panel_show","Админка - доступ к разделам админки");
INSERT INTO all_accesses VALUES("loads_file_upload","Загрузки - выгрузка файлов");
INSERT INTO all_accesses VALUES("loads_dir_mesto","Загрузки - перемещение папок");
INSERT INTO all_accesses VALUES("loads_dir_delete","Загрузки - удаление папок");
INSERT INTO all_accesses VALUES("loads_dir_rename","Загрузки - переименование папок");
INSERT INTO all_accesses VALUES("loads_dir_create","Загрузки - создание папок");
INSERT INTO all_accesses VALUES("loads_file_edit","Загрузки - параметры файлов");
INSERT INTO all_accesses VALUES("loads_file_delete","Загрузки - удаление файлов");
INSERT INTO all_accesses VALUES("loads_unzip","Загрузки - Распаковка ZIP");
INSERT INTO all_accesses VALUES("lib_stat_zip","Библиотека - выгрузка статей в ZIP");
INSERT INTO all_accesses VALUES("lib_stat_txt","Библиотека - выгрузка статей в txt");
INSERT INTO all_accesses VALUES("lib_stat_create","Библиотека - создание статей");
INSERT INTO all_accesses VALUES("lib_dir_delete","Библиотека - удаление папок");
INSERT INTO all_accesses VALUES("lib_dir_mesto","Библиотека - перемещение папок");
INSERT INTO all_accesses VALUES("lib_dir_edit","Библиотека - редактирование папок");
INSERT INTO all_accesses VALUES("lib_dir_create","Библиотека - создание папок");
INSERT INTO all_accesses VALUES("lib_stat_delete","Библиотека - удаление статей");
INSERT INTO all_accesses VALUES("votes_settings","Голосования - закрытие/удаление");
INSERT INTO all_accesses VALUES("votes_create","Голосования - создание");
INSERT INTO all_accesses VALUES("guest_clear","Гостевая - очистка");
INSERT INTO all_accesses VALUES("guest_delete","Гостевая - удаление постов");
INSERT INTO all_accesses VALUES("obmen_dir_delete","Обменник - удаление папок");
INSERT INTO all_accesses VALUES("obmen_dir_edit","Обменник - управление папками");
INSERT INTO all_accesses VALUES("obmen_dir_create","Обменник - создание папок");
INSERT INTO all_accesses VALUES("obmen_file_delete","Обменник - удаление файлов");
INSERT INTO all_accesses VALUES("obmen_file_edit","Обменник - редактирование файлов");
INSERT INTO all_accesses VALUES("obmen_komm_del","Обменник - удаление комментариев");
INSERT INTO all_accesses VALUES("foto_foto_edit","Фотогалерея - редактирование/удаление фото");
INSERT INTO all_accesses VALUES("foto_alb_del","Фотогалерея - удаление альбомов");
INSERT INTO all_accesses VALUES("foto_komm_del","Фотогалерея - удаление комментариев");
INSERT INTO all_accesses VALUES("forum_razd_create","Форум - создание разделов");
INSERT INTO all_accesses VALUES("forum_for_delete","Форум - удаление подфорумов");
INSERT INTO all_accesses VALUES("forum_for_edit","Форум - редактирование подфорумов");
INSERT INTO all_accesses VALUES("forum_for_create","Форум - создание подфорумов");
INSERT INTO all_accesses VALUES("forum_razd_edit","Форум - управление разделами");
INSERT INTO all_accesses VALUES("adm_info","Админка - общая информация");
INSERT INTO all_accesses VALUES("forum_them_edit","Форум - редактирование тем");
INSERT INTO all_accesses VALUES("forum_them_del","Форум - удаление тем");
INSERT INTO all_accesses VALUES("forum_post_ed","Форум - редактирование сообщений");
INSERT INTO all_accesses VALUES("chat_clear","Чат - очистка");
INSERT INTO all_accesses VALUES("chat_room","Чат - управление комнатами");
INSERT INTO all_accesses VALUES("adm_statistic","Админка - статистика");
INSERT INTO all_accesses VALUES("adm_banlist","Админка - список забаненых");
INSERT INTO all_accesses VALUES("adm_menu","Админка - главное меню");
INSERT INTO all_accesses VALUES("adm_news","Админка - новости");
INSERT INTO all_accesses VALUES("adm_rekl","Админка - реклама");
INSERT INTO all_accesses VALUES("adm_set_sys","Админка - настройки системы");
INSERT INTO all_accesses VALUES("adm_set_loads","Админка - настройки загруз-центра");
INSERT INTO all_accesses VALUES("adm_set_user","Админка - пользовательские настройки");
INSERT INTO all_accesses VALUES("adm_set_chat","Админка - настройки чата");
INSERT INTO all_accesses VALUES("adm_set_forum","Админка - настройки форума");
INSERT INTO all_accesses VALUES("adm_set_foto","Админка - настройки фотогалереи");
INSERT INTO all_accesses VALUES("adm_forum_sinc","Админка - синхронизация таблиц форума");
INSERT INTO all_accesses VALUES("adm_themes","Админка - темы оформления");
INSERT INTO all_accesses VALUES("adm_log_read","Админка - лог действий администрации");
INSERT INTO all_accesses VALUES("adm_log_delete","Админка - удаление лога");
INSERT INTO all_accesses VALUES("adm_mysql","Админка - MySQL запросы !!!");
INSERT INTO all_accesses VALUES("adm_ref","Админка - рефералы");
INSERT INTO all_accesses VALUES("adm_show_adm","Админка - список администрации");
INSERT INTO all_accesses VALUES("adm_ip_edit","Админка - редактирование IP операторов");
INSERT INTO all_accesses VALUES("adm_ban_ip","Админка - бан по IP");
INSERT INTO all_accesses VALUES("adm_accesses","Привилегии групп пользователей !!!");
INSERT INTO all_accesses VALUES("user_delete","Пользователи - удаление");
INSERT INTO all_accesses VALUES("user_mass_delete","Пользователи - массовое удаление");
INSERT INTO all_accesses VALUES("user_ban_set","Пользователи - бан");
INSERT INTO all_accesses VALUES("user_ban_unset","Пользователи - снятие бана");
INSERT INTO all_accesses VALUES("user_prof_edit","Пользователи - редактирование профиля");
INSERT INTO all_accesses VALUES("user_collisions","Пользователи - совпадения ников");
INSERT INTO all_accesses VALUES("user_show_ip","Пользователи - показывать IP");
INSERT INTO all_accesses VALUES("user_show_ua","Пользователи - показ USER-AGENT");
INSERT INTO all_accesses VALUES("user_show_add_info","Пользователи - показ доп. информации");
INSERT INTO all_accesses VALUES("guest_show_ip","Гости - показ IP");
INSERT INTO all_accesses VALUES("user_change_group","Пользователи - смена группы привилегий");
INSERT INTO all_accesses VALUES("user_ban_set_h","Пользователи - бан (max 1 сутки)");
INSERT INTO all_accesses VALUES("forum_post_close","Форум - возможность писать в закрытой теме");
INSERT INTO all_accesses VALUES("user_change_nick","Пользователи - смена ника");
INSERT INTO all_accesses VALUES("loads_file_import","Загрузки - импорт файлов");
INSERT INTO all_accesses VALUES("adm_lib_repair","Восстановление библиотеки");
INSERT INTO all_accesses VALUES("notes_edit","Дневники - редактирование");
INSERT INTO all_accesses VALUES("notes_delete","Дневники - удаление");
INSERT INTO all_accesses VALUES("adm_mwb","Острослов - администрирование модуля");
INSERT INTO all_accesses VALUES("ranksSend","Награждение Юзеров");
INSERT INTO all_accesses VALUES("ranksUserDelete","Удаление Наград у Юзеров");
INSERT INTO all_accesses VALUES("ranksEdit","Редактирование и Удаление Наград");
INSERT INTO all_accesses VALUES("mddjine_admin","аукцион джинов - управление ");
INSERT INTO all_accesses VALUES("sc_vip_admin","Управление випстатусом");
INSERT INTO all_accesses VALUES("klan_edit_md","Кланы - управление кланами");
INSERT INTO all_accesses VALUES("foto_foto_edity","Фотодуэли - настройка модуля");
INSERT INTO all_accesses VALUES("mdchild_admin","Малютка - управление");
INSERT INTO all_accesses VALUES("zarnica_setup","Зарница - администрирование модуля");
INSERT INTO all_accesses VALUES("adm_zarnica","Зарница - администрирование модуля");
INSERT INTO all_accesses VALUES("adm_set_action","Действия - управление модулем");
INSERT INTO all_accesses VALUES("user_administration_voyti","Упровление акаунтом");
INSERT INTO all_accesses VALUES("skachki_edit","Скачки - редактирование");
INSERT INTO all_accesses VALUES("skachki_del","Скачки - удаление");
INSERT INTO all_accesses VALUES("skachki_add","Скачки - добавление");
INSERT INTO all_accesses VALUES("mdloss","Призы сайта - управление");
INSERT INTO all_accesses VALUES("mod_gazeta","Управление газетой");



DROP TABLE IF EXISTS `anagramma`;

CREATE TABLE `anagramma` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `original_text` varchar(32) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `anagramma_form`;

CREATE TABLE `anagramma_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=1271 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `apples`;

CREATE TABLE `apples` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `num` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `apples_love`;

CREATE TABLE `apples_love` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions`;

CREATE TABLE `auctions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `bank` int(11) NOT NULL DEFAULT '0',
  `kol` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `stavka` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions_chat`;

CREATE TABLE `auctions_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(2000) NOT NULL DEFAULT '0',
  `show` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_reply` int(11) NOT NULL DEFAULT '0',
  `id_show` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions_set`;

CREATE TABLE `auctions_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `close` enum('0','1') NOT NULL DEFAULT '0',
  `start` int(11) NOT NULL DEFAULT '0',
  `tip` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `kols` int(11) NOT NULL DEFAULT '0',
  `timesgo` int(11) NOT NULL DEFAULT '0',
  `timesstop` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(350) NOT NULL DEFAULT 'По техническим причинам аукцион временно не доступен, пожалуйста попробуйте зайти через несколько минут, спасибо за понимание!',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO auctions_set VALUES("1","0","10","0","4200","3246","1522756021","1590328368","По техническим причинам аукцион временно не доступен, пожалуйста попробуйте зайти через несколько минут, спасибо за понимание!");



DROP TABLE IF EXISTS `auctions_top`;

CREATE TABLE `auctions_top` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  `stavok` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO auctions_top VALUES("1","1","3000","2","1591619368");



DROP TABLE IF EXISTS `auctions_user`;

CREATE TABLE `auctions_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `sum` int(32) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  `last_sum` int(21) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban`;

CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_ban` int(11) NOT NULL,
  `prich` varchar(1024) NOT NULL,
  `view` set('1','0') NOT NULL DEFAULT '0',
  `razdel` varchar(10) DEFAULT 'all',
  `post` int(1) DEFAULT '0',
  `pochemu` int(11) DEFAULT '0',
  `navsegda` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`id_ban`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban_ip`;

CREATE TABLE `ban_ip` (
  `min` bigint(20) NOT NULL,
  `max` bigint(20) NOT NULL,
  KEY `min` (`min`,`max`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bannlist`;

CREATE TABLE `bannlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` char(100) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bar_cat`;

CREATE TABLE `bar_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO bar_cat VALUES("2","Напитки");
INSERT INTO bar_cat VALUES("3","Сладости");
INSERT INTO bar_cat VALUES("4","Поцелуй ");
INSERT INTO bar_cat VALUES("5","Стриптиз");
INSERT INTO bar_cat VALUES("6","Еда");
INSERT INTO bar_cat VALUES("7","Фрукты");
INSERT INTO bar_cat VALUES("8","Пожелания");
INSERT INTO bar_cat VALUES("9","Разное");
INSERT INTO bar_cat VALUES("10","Медпункт");
INSERT INTO bar_cat VALUES("11","День рождения ");
INSERT INTO bar_cat VALUES("12","С новым годом ");
INSERT INTO bar_cat VALUES("13","Днем свадьбы ");
INSERT INTO bar_cat VALUES("14","Позитивный заказ");
INSERT INTO bar_cat VALUES("15","Романтика");
INSERT INTO bar_cat VALUES("16","Остров сокровищ");
INSERT INTO bar_cat VALUES("17","Доброе утро ");
INSERT INTO bar_cat VALUES("18","Спокойной Ночи ");
INSERT INTO bar_cat VALUES("20","Приветики ");
INSERT INTO bar_cat VALUES("21","Добро пожаловать ");
INSERT INTO bar_cat VALUES("22","Цветики ");



DROP TABLE IF EXISTS `bar_list`;

CREATE TABLE `bar_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `podcat` int(11) NOT NULL DEFAULT '1',
  `money` int(11) NOT NULL DEFAULT '0',
  `img` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=683 DEFAULT CHARSET=utf8;

INSERT INTO bar_list VALUES("1","Тархун","4","50","/style/bar/1.png");
INSERT INTO bar_list VALUES("2","Сок апельсиновый ","4","50","/style/bar/2.png");
INSERT INTO bar_list VALUES("3","Сок клубничный","4","50","/style/bar/3.png");
INSERT INTO bar_list VALUES("4","Кока кола","4","50","/style/bar/4.gif");
INSERT INTO bar_list VALUES("5","7up","4","50","/style/bar/5.gif");
INSERT INTO bar_list VALUES("6","Чай","5","50","/style/bar/6.png");
INSERT INTO bar_list VALUES("7","Кофе с любовью","5","50","/style/bar/7.gif");
INSERT INTO bar_list VALUES("8","Кофе с куросаном","5","50","/style/bar/8.png");
INSERT INTO bar_list VALUES("9","Кофе","5","50","/style/bar/9.png");
INSERT INTO bar_list VALUES("10","Кофе с мороженым ","5","50","/style/bar/10.png");
INSERT INTO bar_list VALUES("11","Кофе с молоком","5","50","/style/bar/11.png");
INSERT INTO bar_list VALUES("12","Фруктовый сок","4","50","/style/bar/12.png");
INSERT INTO bar_list VALUES("13","Лимонад","4","50","/style/bar/13.gif");
INSERT INTO bar_list VALUES("41","Водка","1","150","/style/bar/41.png");
INSERT INTO bar_list VALUES("18","Бреннди","8","150","/style/bar/18.png");
INSERT INTO bar_list VALUES("44","Водка","1","150","/style/bar/44.png");
INSERT INTO bar_list VALUES("43","Водка","1","150","/style/bar/43.png");
INSERT INTO bar_list VALUES("19","Шампанское","7","150","/style/bar/19.gif");
INSERT INTO bar_list VALUES("20","Шампанское","7","150","/style/bar/20.png");
INSERT INTO bar_list VALUES("21","Шампанское","7","150","/style/bar/21.png");
INSERT INTO bar_list VALUES("22","Шампанское","7","150","/style/bar/22.png");
INSERT INTO bar_list VALUES("23","Шампанское","7","150","/style/bar/23.png");
INSERT INTO bar_list VALUES("24","Коньяк","3","150","/style/bar/24.png");
INSERT INTO bar_list VALUES("25","Коньяк","3","150","/style/bar/25.png");
INSERT INTO bar_list VALUES("26","Коньяк","3","150","/style/bar/26.png");
INSERT INTO bar_list VALUES("27","Коньяк","3","150","/style/bar/27.png");
INSERT INTO bar_list VALUES("28","Виски ","2","200","/style/bar/28.gif");
INSERT INTO bar_list VALUES("29","Виски ","2","200","/style/bar/29.png");
INSERT INTO bar_list VALUES("30","Виски ","2","200","/style/bar/30.png");
INSERT INTO bar_list VALUES("31","Виски ","2","200","/style/bar/31.gif");
INSERT INTO bar_list VALUES("33","Виски ","2","200","/style/bar/33.png");
INSERT INTO bar_list VALUES("34","Виски ","2","200","/style/bar/34.png");
INSERT INTO bar_list VALUES("35","Пиво","9","100","/style/bar/35.png");
INSERT INTO bar_list VALUES("36","Пиво","9","100","/style/bar/36.png");
INSERT INTO bar_list VALUES("37","Пиво","9","100","/style/bar/37.png");
INSERT INTO bar_list VALUES("38","Виски","2","200","/style/bar/38.png");
INSERT INTO bar_list VALUES("40","Виски","2","200","/style/bar/40.png");
INSERT INTO bar_list VALUES("45","Водка","1","150","/style/bar/45.png");
INSERT INTO bar_list VALUES("46","Водка","1","150","/style/bar/46.png");
INSERT INTO bar_list VALUES("47","Водка","1","150","/style/bar/47.png");
INSERT INTO bar_list VALUES("48","Водка","1","150","/style/bar/48.png");
INSERT INTO bar_list VALUES("49","Водка","1","150","/style/bar/49.png");
INSERT INTO bar_list VALUES("50","Водка","1","150","/style/bar/50.png");
INSERT INTO bar_list VALUES("51","Водка","1","150","/style/bar/51.png");
INSERT INTO bar_list VALUES("52","Водка","1","150","/style/bar/52.png");
INSERT INTO bar_list VALUES("53","Вино ","10","120","/style/bar/53.gif");
INSERT INTO bar_list VALUES("54","Вино ","10","120","/style/bar/54.png");
INSERT INTO bar_list VALUES("55","Вино ","10","120","/style/bar/55.png");
INSERT INTO bar_list VALUES("56","Вино ","10","120","/style/bar/56.png");
INSERT INTO bar_list VALUES("57","Вино ","10","120","/style/bar/57.png");
INSERT INTO bar_list VALUES("58","Вино ","10","120","/style/bar/58.png");
INSERT INTO bar_list VALUES("59","Тортик","11","100","/style/bar/59.png");
INSERT INTO bar_list VALUES("60","Тортик","11","100","/style/bar/60.png");
INSERT INTO bar_list VALUES("61","Коктейль \"Клубника\" ","12","100","/style/bar/61.png");
INSERT INTO bar_list VALUES("62","Коктейль \"Мечта\" ","12","100","/style/bar/62.png");
INSERT INTO bar_list VALUES("63","Коктейль ","12","100","/style/bar/63.png");
INSERT INTO bar_list VALUES("64","Коктейль \"Апельсин\" ","12","100","/style/bar/64.png");
INSERT INTO bar_list VALUES("65","Коктейль \"Манго\" ","12","100","/style/bar/65.png");
INSERT INTO bar_list VALUES("128","Пиво","9","100","/style/bar/128.gif");
INSERT INTO bar_list VALUES("67","Хлеб","13","50","/style/bar/67.png");
INSERT INTO bar_list VALUES("68","Сыр","13","50","/style/bar/68.png");
INSERT INTO bar_list VALUES("69","Сыр \"Нарезка\" ","13","50","/style/bar/69.png");
INSERT INTO bar_list VALUES("70","Нарезка","13","50","/style/bar/70.png");
INSERT INTO bar_list VALUES("71","Колбаса","13","50","/style/bar/71.png");
INSERT INTO bar_list VALUES("72","Ветчина ","13","50","/style/bar/72.png");
INSERT INTO bar_list VALUES("73","Грибочки","13","50","/style/bar/73.png");
INSERT INTO bar_list VALUES("74","Грибы","13","50","/style/bar/74.png");
INSERT INTO bar_list VALUES("75","Грибы маринованные ","13","50","/style/bar/75.png");
INSERT INTO bar_list VALUES("76","Апельсиновое","14","50","/style/bar/76.png");
INSERT INTO bar_list VALUES("77","Вишнёвое ","14","50","/style/bar/77.png");
INSERT INTO bar_list VALUES("78","Клубничное","14","50","/style/bar/78.png");
INSERT INTO bar_list VALUES("79","Черничное","14","50","/style/bar/79.png");
INSERT INTO bar_list VALUES("80","Фисташковое","14","50","/style/bar/80.png");
INSERT INTO bar_list VALUES("81","Мороженое с топпингом","14","50","/style/bar/81.png");
INSERT INTO bar_list VALUES("82","Ванильное","14","50","/style/bar/82.png");
INSERT INTO bar_list VALUES("83","Шоколад ","11","100","/style/bar/83.png");
INSERT INTO bar_list VALUES("84","Булка","13","50","/style/bar/84.png");
INSERT INTO bar_list VALUES("85","Пенное","9","100","/style/bar/85.png");
INSERT INTO bar_list VALUES("86","Пепси","4","50","/style/bar/86.png");
INSERT INTO bar_list VALUES("87","Кола","4","50","/style/bar/87.png");
INSERT INTO bar_list VALUES("139","Стрип","15","250","/style/bar/139.png");
INSERT INTO bar_list VALUES("90","Стрип","15","100","/style/bar/90.gif");
INSERT INTO bar_list VALUES("91","На стуле","15","100","/style/bar/91.gif");
INSERT INTO bar_list VALUES("92","Блины","16","100","/style/bar/92.png");
INSERT INTO bar_list VALUES("93","Оладьи","16","100","/style/bar/93.gif");
INSERT INTO bar_list VALUES("94","Огурцы","13","50","/style/bar/94.jpg");
INSERT INTO bar_list VALUES("95","Оливки","13","50","/style/bar/95.png");
INSERT INTO bar_list VALUES("96","Пицца","13","50","/style/bar/96.jpg");
INSERT INTO bar_list VALUES("97","Рыбка","13","50","/style/bar/97.jpg");
INSERT INTO bar_list VALUES("98","Сало","13","50","/style/bar/98.jpg");
INSERT INTO bar_list VALUES("99","Борщ","17","50","/style/bar/99.png");
INSERT INTO bar_list VALUES("100","Вареники","17","50","/style/bar/100.gif");
INSERT INTO bar_list VALUES("101","Жаркое","17","50","/style/bar/101.png");
INSERT INTO bar_list VALUES("102","котлеты","17","50","/style/bar/102.png");
INSERT INTO bar_list VALUES("103","курочка","17","50","/style/bar/103.png");
INSERT INTO bar_list VALUES("104","Обед","17","100","/style/bar/104.png");
INSERT INTO bar_list VALUES("105","пельмени","17","50","/style/bar/105.png");
INSERT INTO bar_list VALUES("106","Плов","17","50","/style/bar/106.png");
INSERT INTO bar_list VALUES("107","Ужин","17","50","/style/bar/107.png");
INSERT INTO bar_list VALUES("108","Шашлык ","17","50","/style/bar/108.png");
INSERT INTO bar_list VALUES("109","Чипсы","13","50","/style/bar/109.jpg");
INSERT INTO bar_list VALUES("110","Сыр","13","50","/style/bar/110.png");
INSERT INTO bar_list VALUES("111","Фисташки","13","50","/style/bar/111.png");
INSERT INTO bar_list VALUES("112","Мороз","14","50","/style/bar/112.png");
INSERT INTO bar_list VALUES("113","Морозко","14","50","/style/bar/113.gif");
INSERT INTO bar_list VALUES("114","Шок","11","50","/style/bar/114.gif");
INSERT INTO bar_list VALUES("115","Торт","11","50","/style/bar/115.jpg");
INSERT INTO bar_list VALUES("116","Шок торт","11","50","/style/bar/116.png");
INSERT INTO bar_list VALUES("117","Пироженое","11","50","/style/bar/117.png");
INSERT INTO bar_list VALUES("118","пирожное1","11","50","/style/bar/118.png");
INSERT INTO bar_list VALUES("119","конфеты","11","50","/style/bar/119.png");
INSERT INTO bar_list VALUES("120","Мармелад ","11","50","/style/bar/120.png");
INSERT INTO bar_list VALUES("121","Зефир","11","50","/style/bar/121.png");
INSERT INTO bar_list VALUES("122","варенье","11","50","/style/bar/122.jpg");
INSERT INTO bar_list VALUES("123","Икра кр","13","50","/style/bar/123.png");
INSERT INTO bar_list VALUES("124","Икра чер","13","50","/style/bar/124.png");
INSERT INTO bar_list VALUES("125","Завтрок","17","50","/style/bar/125.png");
INSERT INTO bar_list VALUES("126","Вино","10","50","/style/bar/126.gif");
INSERT INTO bar_list VALUES("127","Вино","10","50","/style/bar/127.png");
INSERT INTO bar_list VALUES("129","Пиво","9","50","/style/bar/129.jpg");
INSERT INTO bar_list VALUES("130","Бананы","18","50","/style/bar/130.gif");
INSERT INTO bar_list VALUES("132","Апельсины","18","50","/style/bar/132.png");
INSERT INTO bar_list VALUES("133","виноград","18","50","/style/bar/133.png");
INSERT INTO bar_list VALUES("134","Дыня","18","50","/style/bar/134.png");
INSERT INTO bar_list VALUES("135","клубника","18","50","/style/bar/135.png");
INSERT INTO bar_list VALUES("136","лимон","18","50","/style/bar/136.png");
INSERT INTO bar_list VALUES("137","малина","18","50","/style/bar/137.jpg");
INSERT INTO bar_list VALUES("138","Фрукты","18","100","/style/bar/138.png");
INSERT INTO bar_list VALUES("140","Стрип","15","250","/style/bar/140.png");
INSERT INTO bar_list VALUES("141","Стрип","19","250","/style/bar/141.gif");
INSERT INTO bar_list VALUES("142","Стрип","19","250","/style/bar/142.png");
INSERT INTO bar_list VALUES("143","Стрип","15","250","/style/bar/143.gif");
INSERT INTO bar_list VALUES("144","Стрип","15","250","/style/bar/144.gif");
INSERT INTO bar_list VALUES("145","Стрип","15","250","/style/bar/145.gif");
INSERT INTO bar_list VALUES("146","Поцелуй","20","100","/style/bar/146.gif");
INSERT INTO bar_list VALUES("147","Поцелуй","20","100","/style/bar/147.gif");
INSERT INTO bar_list VALUES("148","Поцелуй","20","100","/style/bar/148.gif");
INSERT INTO bar_list VALUES("149","Поцелуй","20","100","/style/bar/149.gif");
INSERT INTO bar_list VALUES("150","Поцелуй","20","100","/style/bar/150.gif");
INSERT INTO bar_list VALUES("151","Поцелуй","20","100","/style/bar/151.gif");
INSERT INTO bar_list VALUES("152","Поцелуй","20","100","/style/bar/152.gif");
INSERT INTO bar_list VALUES("153","Поцелуй","20","100","/style/bar/153.gif");
INSERT INTO bar_list VALUES("154","Поцелуй","20","100","/style/bar/154.gif");
INSERT INTO bar_list VALUES("155","Поцелуй","20","100","/style/bar/155.gif");
INSERT INTO bar_list VALUES("156","Поцелуй","20","100","/style/bar/156.gif");
INSERT INTO bar_list VALUES("157","Поцелуй","20","100","/style/bar/157.gif");
INSERT INTO bar_list VALUES("158","Поцелуй","20","100","/style/bar/158.gif");
INSERT INTO bar_list VALUES("159","Поцелуй","20","100","/style/bar/159.gif");
INSERT INTO bar_list VALUES("160","Поцелуй","20","100","/style/bar/160.gif");
INSERT INTO bar_list VALUES("161","Поцелуй","20","100","/style/bar/161.gif");
INSERT INTO bar_list VALUES("162","Поцелуй","20","100","/style/bar/162.gif");
INSERT INTO bar_list VALUES("163","Поцелуй","20","100","/style/bar/163.gif");
INSERT INTO bar_list VALUES("164","Поцелуй","20","100","/style/bar/164.gif");
INSERT INTO bar_list VALUES("166","Пожелания","21","100","/style/bar/166.jpg");
INSERT INTO bar_list VALUES("167","Пожелания","21","50","/style/bar/167.png");
INSERT INTO bar_list VALUES("168","Пожелания","21","50","/style/bar/168.jpg");
INSERT INTO bar_list VALUES("169","Пожелания","21","50","/style/bar/169.jpg");
INSERT INTO bar_list VALUES("170","Пожелания","21","50","/style/bar/170.jpg");
INSERT INTO bar_list VALUES("171","Пожелания","21","50","/style/bar/171.jpg");
INSERT INTO bar_list VALUES("172","Пожелания","21","50","/style/bar/172.jpg");
INSERT INTO bar_list VALUES("173","Пожелания","21","50","/style/bar/173.jpg");
INSERT INTO bar_list VALUES("174","Пожелания","21","50","/style/bar/174.jpg");
INSERT INTO bar_list VALUES("175","Пожелания","21","50","/style/bar/175.jpg");
INSERT INTO bar_list VALUES("176","Пожелания","21","50","/style/bar/176.jpg");
INSERT INTO bar_list VALUES("177","Пожелания","21","50","/style/bar/177.jpg");
INSERT INTO bar_list VALUES("178","Пожелания","21","50","/style/bar/178.jpg");
INSERT INTO bar_list VALUES("179","Пожелания","21","50","/style/bar/179.jpg");
INSERT INTO bar_list VALUES("180","Пожелания","21","50","/style/bar/180.jpg");
INSERT INTO bar_list VALUES("181","Пожелания","21","50","/style/bar/181.jpg");
INSERT INTO bar_list VALUES("182","Пожелания","21","50","/style/bar/182.jpg");
INSERT INTO bar_list VALUES("183","Пожелания","21","50","/style/bar/183.jpg");
INSERT INTO bar_list VALUES("184","Пожелания","21","50","/style/bar/184.jpg");
INSERT INTO bar_list VALUES("185","Пожелания","21","50","/style/bar/185.jpg");
INSERT INTO bar_list VALUES("186","Пожелания","21","50","/style/bar/186.jpg");
INSERT INTO bar_list VALUES("187","Пожелания","21","50","/style/bar/187.jpg");
INSERT INTO bar_list VALUES("188","Пожелания","21","50","/style/bar/188.jpg");
INSERT INTO bar_list VALUES("189","Шампанское ","7","50","/style/bar/189.png");
INSERT INTO bar_list VALUES("190","Рюмка","1","50","/style/bar/190.gif");
INSERT INTO bar_list VALUES("191","Яд","23","250","/style/bar/191.gif");
INSERT INTO bar_list VALUES("192","Яга","22","50","/style/bar/192.jpg");
INSERT INTO bar_list VALUES("193","Рассол","22","50","/style/bar/193.gif");
INSERT INTO bar_list VALUES("194","Самогон","22","50","/style/bar/194.jpg");
INSERT INTO bar_list VALUES("195","Кс","5","50","/style/bar/195.png");
INSERT INTO bar_list VALUES("196","ликёр","22","50","/style/bar/196.png");
INSERT INTO bar_list VALUES("197","Мартини","22","50","/style/bar/197.gif");
INSERT INTO bar_list VALUES("198","Наливка ","22","50","/style/bar/198.png");
INSERT INTO bar_list VALUES("199","Джин","22","50","/style/bar/199.png");
INSERT INTO bar_list VALUES("200","Молоко","24","50","/style/bar/200.gif");
INSERT INTO bar_list VALUES("201","Кефир","24","50","/style/bar/201.png");
INSERT INTO bar_list VALUES("202","Вода","24","50","/style/bar/202.gif");
INSERT INTO bar_list VALUES("203","абсент","22","100","/style/bar/203.gif");
INSERT INTO bar_list VALUES("204","амаретто","22","100","/style/bar/204.gif");
INSERT INTO bar_list VALUES("205","Бальзам","22","100","/style/bar/205.png");
INSERT INTO bar_list VALUES("206","Пожелания","21","50","/style/bar/206.png");
INSERT INTO bar_list VALUES("207","Пожелания ","21","50","/style/bar/207.gif");
INSERT INTO bar_list VALUES("208","Пожелания","21","50","/style/bar/208.gif");
INSERT INTO bar_list VALUES("209","Пожелания","21","50","/style/bar/209.gif");
INSERT INTO bar_list VALUES("210","Пожелания","21","50","/style/bar/210.gif");
INSERT INTO bar_list VALUES("211","Пожелания","21","50","/style/bar/211.jpg");
INSERT INTO bar_list VALUES("212","Пожелания","21","50","/style/bar/212.gif");
INSERT INTO bar_list VALUES("213","Пожелания","21","50","/style/bar/213.gif");
INSERT INTO bar_list VALUES("214","Пожелания","21","50","/style/bar/214.gif");
INSERT INTO bar_list VALUES("215","Пожелания","21","50","/style/bar/215.jpg");
INSERT INTO bar_list VALUES("216","Пожелания","21","50","/style/bar/216.gif");
INSERT INTO bar_list VALUES("217","Пожелания","21","50","/style/bar/217.jpg");
INSERT INTO bar_list VALUES("218","Пожелания","21","50","/style/bar/218.gif");
INSERT INTO bar_list VALUES("220","Чай","5","50","/style/bar/220.gif");
INSERT INTO bar_list VALUES("221","Чай","5","50","/style/bar/221.gif");
INSERT INTO bar_list VALUES("222","Кофе","5","50","/style/bar/222.gif");
INSERT INTO bar_list VALUES("223","Кофе на двоих","5","50","/style/bar/223.png");
INSERT INTO bar_list VALUES("224","Шампанское ","7","50","/style/bar/224.png");
INSERT INTO bar_list VALUES("225","Блюдо","17","50","/style/bar/225.gif");
INSERT INTO bar_list VALUES("226","Блюдо","17","50","/style/bar/226.png");
INSERT INTO bar_list VALUES("227","Блюдо","17","50","/style/bar/227.png");
INSERT INTO bar_list VALUES("228","Блюдо","17","50","/style/bar/228.png");
INSERT INTO bar_list VALUES("229","Романтика","17","100","/style/bar/229.png");
INSERT INTO bar_list VALUES("230","Салат","13","50","/style/bar/230.png");
INSERT INTO bar_list VALUES("231","Салат","13","50","/style/bar/231.png");
INSERT INTO bar_list VALUES("232","Семки","13","50","/style/bar/232.png");
INSERT INTO bar_list VALUES("233","Хлеб","13","50","/style/bar/233.png");
INSERT INTO bar_list VALUES("234","Стрип","15","250","/style/bar/234.gif");
INSERT INTO bar_list VALUES("235","Стрип","15","250","/style/bar/235.gif");
INSERT INTO bar_list VALUES("236","Стрип","15","250","/style/bar/236.gif");
INSERT INTO bar_list VALUES("237","Лекарство","25","50","/style/bar/237.gif");
INSERT INTO bar_list VALUES("238","ВраЧ","25","50","/style/bar/238.gif");
INSERT INTO bar_list VALUES("239","Лекарство","25","50","/style/bar/239.gif");
INSERT INTO bar_list VALUES("240","ВраЧ","25","50","/style/bar/240.gif");
INSERT INTO bar_list VALUES("241","Врач ","25","50","/style/bar/241.gif");
INSERT INTO bar_list VALUES("242","Врач с таблеткой","25","50","/style/bar/242.gif");
INSERT INTO bar_list VALUES("243","Врач","25","50","/style/bar/243.gif");
INSERT INTO bar_list VALUES("244","Яблоки","18","50","/style/bar/244.gif");
INSERT INTO bar_list VALUES("245","Персик","18","50","/style/bar/245.png");
INSERT INTO bar_list VALUES("246","Персик","18","50","/style/bar/246.png");
INSERT INTO bar_list VALUES("247","лимон","18","50","/style/bar/247.gif");
INSERT INTO bar_list VALUES("248","Картошка","17","50","/style/bar/248.jpg");
INSERT INTO bar_list VALUES("249","Яичница","17","50","/style/bar/249.");
INSERT INTO bar_list VALUES("250","Яичница","17","50","/style/bar/250.gif");
INSERT INTO bar_list VALUES("251","Шашлык ","17","50","/style/bar/251.gif");
INSERT INTO bar_list VALUES("252","Курица","17","50","/style/bar/252.gif");
INSERT INTO bar_list VALUES("253","Завтрок","17","50","/style/bar/253.png");
INSERT INTO bar_list VALUES("254","Хлеб","13","50","/style/bar/254.gif");
INSERT INTO bar_list VALUES("255","Холодец","13","50","/style/bar/255.gif");
INSERT INTO bar_list VALUES("256","Мимоза ","13","50","/style/bar/256.gif");
INSERT INTO bar_list VALUES("257","Нарезка","13","50","/style/bar/257.png");
INSERT INTO bar_list VALUES("258","Закусь","13","50","/style/bar/258.jpg");
INSERT INTO bar_list VALUES("259","Бутер","13","50","/style/bar/259.png");
INSERT INTO bar_list VALUES("260","Чипсы","13","50","/style/bar/260.gif");
INSERT INTO bar_list VALUES("261","Пироженое","11","50","/style/bar/261.gif");
INSERT INTO bar_list VALUES("262","Шоколад","11","50","/style/bar/262.gif");
INSERT INTO bar_list VALUES("263","Канфеты","11","50","/style/bar/263.gif");
INSERT INTO bar_list VALUES("264","Пасха","26","50","/style/bar/264.png");
INSERT INTO bar_list VALUES("265","Банкет","26","250","/style/bar/265.gif");
INSERT INTO bar_list VALUES("266","Скарпион","22","100","/style/bar/266.jpg");
INSERT INTO bar_list VALUES("267","Спирт","22","100","/style/bar/267.gif");
INSERT INTO bar_list VALUES("268","Самогон","22","100","/style/bar/268.png");
INSERT INTO bar_list VALUES("269","Сюрприз","22","50","/style/bar/269.gif");
INSERT INTO bar_list VALUES("270","Чифир","22","100","/style/bar/270.jpg");
INSERT INTO bar_list VALUES("271","Кобра","22","100","/style/bar/271.jpg");
INSERT INTO bar_list VALUES("272","Бальзам","22","100","/style/bar/272.gif");
INSERT INTO bar_list VALUES("273","Шампанское ","7","100","/style/bar/273.gif");
INSERT INTO bar_list VALUES("274","Шампанское ","7","50","/style/bar/274.gif");
INSERT INTO bar_list VALUES("275","Шампанское ","7","100","/style/bar/275.jpg");
INSERT INTO bar_list VALUES("276","Шампанское ","7","100","/style/bar/276.gif");
INSERT INTO bar_list VALUES("277","Шампанское  молодым","7","50","/style/bar/277.jpg");
INSERT INTO bar_list VALUES("278","Шампанское  чок","7","50","/style/bar/278.gif");
INSERT INTO bar_list VALUES("279","Шампанское  с новым годом ","7","50","/style/bar/279.gif");
INSERT INTO bar_list VALUES("280","Коктейль","12","50","/style/bar/280.png");
INSERT INTO bar_list VALUES("281","Кок","12","50","/style/bar/281.jpg");
INSERT INTO bar_list VALUES("282","Кок","12","50","/style/bar/282.jpg");
INSERT INTO bar_list VALUES("283","Кок","12","50","/style/bar/283.png");
INSERT INTO bar_list VALUES("284","Вино белое","10","50","/style/bar/284.png");
INSERT INTO bar_list VALUES("285","Вино красное ","10","50","/style/bar/285.gif");
INSERT INTO bar_list VALUES("286","Вино","10","50","/style/bar/286.gif");
INSERT INTO bar_list VALUES("287","Пиво","9","50","/style/bar/287.gif");
INSERT INTO bar_list VALUES("288","Пиво","9","50","/style/bar/288.gif");
INSERT INTO bar_list VALUES("289","Любимым","5","50","/style/bar/289.gif");
INSERT INTO bar_list VALUES("290","Чай с лимоном ","5","50","/style/bar/290.jpg");
INSERT INTO bar_list VALUES("291","Для тебя","5","50","/style/bar/291.gif");
INSERT INTO bar_list VALUES("292","Какао","5","50","/style/bar/292.png");
INSERT INTO bar_list VALUES("293","Водка","1","50","/style/bar/293.gif");
INSERT INTO bar_list VALUES("294","Водка","1","50","/style/bar/294.gif");
INSERT INTO bar_list VALUES("501","С днюхой","27","200","/style/bar/501.png");
INSERT INTO bar_list VALUES("500","С днюхой","27","200","/style/bar/500.png");
INSERT INTO bar_list VALUES("297","Д р","27","50","/style/bar/297.gif");
INSERT INTO bar_list VALUES("298","День рождения ","27","50","/style/bar/298.gif");
INSERT INTO bar_list VALUES("299","С днем рождения ","27","50","/style/bar/299.gif");
INSERT INTO bar_list VALUES("300","Мандарины","18","50","/style/bar/300.gif");
INSERT INTO bar_list VALUES("301","Пожелания ","21","50","/style/bar/301.jpg");
INSERT INTO bar_list VALUES("302","Пожелания ","21","50","/style/bar/302.jpeg");
INSERT INTO bar_list VALUES("303","С наступающим","28","50","/style/bar/303.gif");
INSERT INTO bar_list VALUES("304","Нг","28","50","/style/bar/304.gif");
INSERT INTO bar_list VALUES("305","Нг","28","50","/style/bar/305.gif");
INSERT INTO bar_list VALUES("306","Нг","28","50","/style/bar/306.gif");
INSERT INTO bar_list VALUES("307","Нг","28","50","/style/bar/307.gif");
INSERT INTO bar_list VALUES("308","С новым годом ","28","50","/style/bar/308.gif");
INSERT INTO bar_list VALUES("309","НГ уже близко","28","50","/style/bar/309.gif");
INSERT INTO bar_list VALUES("310","Новый год","28","50","/style/bar/310.gif");
INSERT INTO bar_list VALUES("311","Добро пожаловать","26","50","/style/bar/311.gif");
INSERT INTO bar_list VALUES("312","Ключ от сайта","26","50","/style/bar/312.gif");
INSERT INTO bar_list VALUES("313","Будь как дома","26","50","/style/bar/313.gif");
INSERT INTO bar_list VALUES("314","Королеве сайта","26","50","/style/bar/314.jpg");
INSERT INTO bar_list VALUES("315","Золотое сердце","26","50","/style/bar/315.gif");
INSERT INTO bar_list VALUES("316","Девушке","26","50","/style/bar/316.gif");
INSERT INTO bar_list VALUES("317","Не мерзни","26","50","/style/bar/317.gif");
INSERT INTO bar_list VALUES("318","Ты прекрасная ","26","50","/style/bar/318.jpg");
INSERT INTO bar_list VALUES("319","Вот","26","50","/style/bar/319.gif");
INSERT INTO bar_list VALUES("320","Стрип","15","250","/style/bar/320.gif");
INSERT INTO bar_list VALUES("321","Стрип","15","250","/style/bar/321.gif");
INSERT INTO bar_list VALUES("322","Стрип","19","250","/style/bar/322.jpg");
INSERT INTO bar_list VALUES("323","Стрип","19","250","/style/bar/323.jpg");
INSERT INTO bar_list VALUES("324","Стрип","19","250","/style/bar/324.jpg");
INSERT INTO bar_list VALUES("325","Свадьба","29","50","/style/bar/325.gif");
INSERT INTO bar_list VALUES("326","Свадьба","29","50","/style/bar/326.gif");
INSERT INTO bar_list VALUES("327","Свадьба","29","50","/style/bar/327.jpg");
INSERT INTO bar_list VALUES("328","Свадьба","29","50","/style/bar/328.jpg");
INSERT INTO bar_list VALUES("329","Отличных выходных","31","100","/style/bar/329.png");
INSERT INTO bar_list VALUES("330","Гульнем ","31","100","/style/bar/330.png");
INSERT INTO bar_list VALUES("332","Романтика","34","100","/style/bar/332.gif");
INSERT INTO bar_list VALUES("333","Ты мне нужен","34","100","/style/bar/333.png");
INSERT INTO bar_list VALUES("334","Романтика","32","100","/style/bar/334.png");
INSERT INTO bar_list VALUES("335","Романтика","32","100","/style/bar/335.gif");
INSERT INTO bar_list VALUES("336","Романтика","32","100","/style/bar/336.png");
INSERT INTO bar_list VALUES("337","Для Тебя","33","100","/style/bar/337.png");
INSERT INTO bar_list VALUES("338","Ты моя ","33","100","/style/bar/338.png");
INSERT INTO bar_list VALUES("339","Романтика","32","100","/style/bar/339.gif");
INSERT INTO bar_list VALUES("340","Романтика","32","100","/style/bar/340.gif");
INSERT INTO bar_list VALUES("341","Романтика","32","100","/style/bar/341.gif");
INSERT INTO bar_list VALUES("342","Цемки бомки","20","100","/style/bar/342.gif");
INSERT INTO bar_list VALUES("343","Цемки бомки","20","100","/style/bar/343.gif");
INSERT INTO bar_list VALUES("344","Цемки бомки","20","100","/style/bar/344.gif");
INSERT INTO bar_list VALUES("345","Цемки бомки","20","100","/style/bar/345.png");
INSERT INTO bar_list VALUES("346","Цемки бомки","20","100","/style/bar/346.png");
INSERT INTO bar_list VALUES("347","Цемки бомки","20","100","/style/bar/347.gif");
INSERT INTO bar_list VALUES("348","Цемки бомки","20","100","/style/bar/348.gif");
INSERT INTO bar_list VALUES("349","Цемки бомки","20","100","/style/bar/349.gif");
INSERT INTO bar_list VALUES("350","Куда спрятал наливай(прик)","38","100","/style/bar/350.gif");
INSERT INTO bar_list VALUES("351","Атакуем форум","39","200","/style/bar/351.gif");
INSERT INTO bar_list VALUES("352","Собачий вальс","39","100","/style/bar/352.gif");
INSERT INTO bar_list VALUES("353","Преоделся","39","100","/style/bar/353.gif");
INSERT INTO bar_list VALUES("354","За мной на форум","39","200","/style/bar/354.gif");
INSERT INTO bar_list VALUES("355","Наточу прийду","39","100","/style/bar/355.gif");
INSERT INTO bar_list VALUES("356","Выходи за меня ","29","100","/style/bar/356.png");
INSERT INTO bar_list VALUES("357","Вместе навсегда","29","100","/style/bar/357.png");
INSERT INTO bar_list VALUES("358","Совет да любовь","29","100","/style/bar/358.png");
INSERT INTO bar_list VALUES("359","Любви и счастья ","29","100","/style/bar/359.png");
INSERT INTO bar_list VALUES("360","Доброе утро ","40","100","/style/bar/360.png");
INSERT INTO bar_list VALUES("361","Доброе утро ","40","100","/style/bar/361.png");
INSERT INTO bar_list VALUES("362","Доброе утро ","40","100","/style/bar/362.png");
INSERT INTO bar_list VALUES("363","Доброе утро ","40","100","/style/bar/363.gif");
INSERT INTO bar_list VALUES("364","Доброе Утро","41","100","/style/bar/364.gif");
INSERT INTO bar_list VALUES("365","Доброе Утро","41","100","/style/bar/365.gif");
INSERT INTO bar_list VALUES("366","Доброе Утро","41","100","/style/bar/366.gif");
INSERT INTO bar_list VALUES("367","Доброе Утро","41","100","/style/bar/367.gif");
INSERT INTO bar_list VALUES("368","Доброе Утро","41","100","/style/bar/368.gif");
INSERT INTO bar_list VALUES("369","Доброе Утро","41","100","/style/bar/369.gif");
INSERT INTO bar_list VALUES("370","Доброе Утро","41","100","/style/bar/370.gif");
INSERT INTO bar_list VALUES("371","Доброе Утро","41","100","/style/bar/371.gif");
INSERT INTO bar_list VALUES("372","Доброе Утро","41","100","/style/bar/372.gif");
INSERT INTO bar_list VALUES("373","Доброе Утро","41","100","/style/bar/373.gif");
INSERT INTO bar_list VALUES("374","Доброе Утро","41","100","/style/bar/374.gif");
INSERT INTO bar_list VALUES("375","Доброе Утро","41","100","/style/bar/375.gif");
INSERT INTO bar_list VALUES("376","Цемки бомки","20","100","/style/bar/376.png");
INSERT INTO bar_list VALUES("377","Цемки бомки","20","100","/style/bar/377.gif");
INSERT INTO bar_list VALUES("378","Цемки бомки","20","100","/style/bar/378.gif");
INSERT INTO bar_list VALUES("379","Цемки бомки","20","100","/style/bar/379.gif");
INSERT INTO bar_list VALUES("380","Цемки бомки","20","100","/style/bar/380.gif");
INSERT INTO bar_list VALUES("381","Цемки бомки","20","100","/style/bar/381.gif");
INSERT INTO bar_list VALUES("382","Цемки бомки","20","100","/style/bar/382.gif");
INSERT INTO bar_list VALUES("383","Цемки бомки","20","100","/style/bar/383.gif");
INSERT INTO bar_list VALUES("384","Цемки бомки","20","100","/style/bar/384.gif");
INSERT INTO bar_list VALUES("385","Цемки бомки","20","100","/style/bar/385.gif");
INSERT INTO bar_list VALUES("386","Цемки бомки","20","100","/style/bar/386.gif");
INSERT INTO bar_list VALUES("387","Цемки бомки","20","100","/style/bar/387.gif");
INSERT INTO bar_list VALUES("388","Цемки бомки","20","100","/style/bar/388.gif");
INSERT INTO bar_list VALUES("389","Цемки бомки","20","100","/style/bar/389.gif");
INSERT INTO bar_list VALUES("390","Цемки бомки","20","100","/style/bar/390.gif");
INSERT INTO bar_list VALUES("391","Споки ноки ","42","100","/style/bar/391.png");
INSERT INTO bar_list VALUES("392","Споки ноки ","42","100","/style/bar/392.png");
INSERT INTO bar_list VALUES("393","Споки ноки ","42","100","/style/bar/393.gif");
INSERT INTO bar_list VALUES("394","Споки ноки ","42","100","/style/bar/394.gif");
INSERT INTO bar_list VALUES("395","Споки ноки ","42","100","/style/bar/395.png");
INSERT INTO bar_list VALUES("396","Споки ноки ","42","100","/style/bar/396.png");
INSERT INTO bar_list VALUES("397","Споки ноки ","42","100","/style/bar/397.png");
INSERT INTO bar_list VALUES("398","Споки ноки ","42","100","/style/bar/398.gif");
INSERT INTO bar_list VALUES("399","Споки ноки ","42","100","/style/bar/399.gif");
INSERT INTO bar_list VALUES("400","Споки ноки ","42","100","/style/bar/400.gif");
INSERT INTO bar_list VALUES("401","Споки ноки ","42","100","/style/bar/401.gif");
INSERT INTO bar_list VALUES("402","Споки ноки ","42","100","/style/bar/402.gif");
INSERT INTO bar_list VALUES("403","Споки ноки ","42","100","/style/bar/403.gif");
INSERT INTO bar_list VALUES("404","Иди ка сюда ","43","100","/style/bar/404.png");
INSERT INTO bar_list VALUES("405","ЗлюкаЮ","43","100","/style/bar/405.png");
INSERT INTO bar_list VALUES("406","Святая невиннннность ","43","100","/style/bar/406.png");
INSERT INTO bar_list VALUES("407","Нет нет ","43","100","/style/bar/407.gif");
INSERT INTO bar_list VALUES("408","Храпульки нет ","43","100","/style/bar/408.gif");
INSERT INTO bar_list VALUES("409","Трах тибидох напущу на тебя блох","43","100","/style/bar/409.gif");
INSERT INTO bar_list VALUES("410","Все вижу","43","100","/style/bar/410.gif");
INSERT INTO bar_list VALUES("411","Пали если чё","43","100","/style/bar/411.png");
INSERT INTO bar_list VALUES("412","Не жри","43","100","/style/bar/412.png");
INSERT INTO bar_list VALUES("413","Бери добро","43","100","/style/bar/413.png");
INSERT INTO bar_list VALUES("414","Ух какая","43","100","/style/bar/414.png");
INSERT INTO bar_list VALUES("415","Мужчинка мечта","43","100","/style/bar/415.png");
INSERT INTO bar_list VALUES("416","Бери дарю","43","100","/style/bar/416.png");
INSERT INTO bar_list VALUES("417","Нужное","43","100","/style/bar/417.png");
INSERT INTO bar_list VALUES("418","Похмелятинка","43","100","/style/bar/418.png");
INSERT INTO bar_list VALUES("419","Памперс ","43","100","/style/bar/419.png");
INSERT INTO bar_list VALUES("420","Не спи","43","100","/style/bar/420.gif");
INSERT INTO bar_list VALUES("421","Я у твоих ног","43","100","/style/bar/421.png");
INSERT INTO bar_list VALUES("422","Упакуйте","43","100","/style/bar/422.png");
INSERT INTO bar_list VALUES("423","Для жлопинки","43","100","/style/bar/423.png");
INSERT INTO bar_list VALUES("424","Не смотри на меня матом","43","100","/style/bar/424.png");
INSERT INTO bar_list VALUES("425","Цемочки","43","100","/style/bar/425.png");
INSERT INTO bar_list VALUES("426","Любимка ты где","43","100","/style/bar/426.gif");
INSERT INTO bar_list VALUES("427","Оберег от хвори","43","100","/style/bar/427.png");
INSERT INTO bar_list VALUES("428","Не играй ","43","100","/style/bar/428.png");
INSERT INTO bar_list VALUES("429","Кукуся ","43","100","/style/bar/429.gif");
INSERT INTO bar_list VALUES("430","Рассол","43","100","/style/bar/430.gif");
INSERT INTO bar_list VALUES("431","Чудо ты","43","100","/style/bar/431.gif");
INSERT INTO bar_list VALUES("432","Ла ла ла ","43","100","/style/bar/432.png");
INSERT INTO bar_list VALUES("433","ВаУ","43","100","/style/bar/433.png");
INSERT INTO bar_list VALUES("434","Зная себя","43","100","/style/bar/434.png");
INSERT INTO bar_list VALUES("435","От порчи ","43","100","/style/bar/435.png");
INSERT INTO bar_list VALUES("436","Буду обнимать ","43","100","/style/bar/436.png");
INSERT INTO bar_list VALUES("437","Да да да ","43","100","/style/bar/437.png");
INSERT INTO bar_list VALUES("438","Не усохни ","43","100","/style/bar/438.png");
INSERT INTO bar_list VALUES("439","Кусь","43","100","/style/bar/439.png");
INSERT INTO bar_list VALUES("440","Скороходы","43","100","/style/bar/440.gif");
INSERT INTO bar_list VALUES("441","Лыбу Шире Я в Эфире","43","100","/style/bar/441.png");
INSERT INTO bar_list VALUES("442","Наказан","43","100","/style/bar/442.png");
INSERT INTO bar_list VALUES("443","Антистрес ","43","100","/style/bar/443.png");
INSERT INTO bar_list VALUES("444","Пососунчик","43","100","/style/bar/444.png");
INSERT INTO bar_list VALUES("445","Все для тебя ","43","100","/style/bar/445.png");
INSERT INTO bar_list VALUES("446","Языкульку","43","100","/style/bar/446.png");
INSERT INTO bar_list VALUES("447","Доброе Утро","40","100","/style/bar/447.gif");
INSERT INTO bar_list VALUES("448","Доброе Утро","40","100","/style/bar/448.gif");
INSERT INTO bar_list VALUES("449","Привет","44","100","/style/bar/449.png");
INSERT INTO bar_list VALUES("450","Привет","44","100","/style/bar/450.png");
INSERT INTO bar_list VALUES("451","Привет","44","100","/style/bar/451.png");
INSERT INTO bar_list VALUES("452","Привет","44","100","/style/bar/452.png");
INSERT INTO bar_list VALUES("453","Привет","44","100","/style/bar/453.png");
INSERT INTO bar_list VALUES("454","Привет","44","100","/style/bar/454.png");
INSERT INTO bar_list VALUES("455","Привет","44","100","/style/bar/455.png");
INSERT INTO bar_list VALUES("456","Джага джага","19","100","/style/bar/456.gif");
INSERT INTO bar_list VALUES("457","Джага джага","19","100","/style/bar/457.gif");
INSERT INTO bar_list VALUES("458","Джага джага","19","100","/style/bar/458.gif");
INSERT INTO bar_list VALUES("459","Джага джага","19","100","/style/bar/459.gif");
INSERT INTO bar_list VALUES("460","Джага джага","19","100","/style/bar/460.gif");
INSERT INTO bar_list VALUES("461","Джага джага","19","100","/style/bar/461.gif");
INSERT INTO bar_list VALUES("462","Попой опа опа","15","100","/style/bar/462.gif");
INSERT INTO bar_list VALUES("463","Попой опа опа","15","100","/style/bar/463.gif");
INSERT INTO bar_list VALUES("464","Попой опа опа","15","100","/style/bar/464.gif");
INSERT INTO bar_list VALUES("465","Угощайся","5","0","/style/bar/465.png");
INSERT INTO bar_list VALUES("466","Угощайся","5","100","/style/bar/466.png");
INSERT INTO bar_list VALUES("467","Угощайся","5","100","/style/bar/467.png");
INSERT INTO bar_list VALUES("468","Угощайся","5","100","/style/bar/468.png");
INSERT INTO bar_list VALUES("469","Угощайся","5","100","/style/bar/469.gif");
INSERT INTO bar_list VALUES("470","Угощайся","5","100","/style/bar/470.png");
INSERT INTO bar_list VALUES("471","Угощайся","5","100","/style/bar/471.png");
INSERT INTO bar_list VALUES("472","Угощайся","5","100","/style/bar/472.png");
INSERT INTO bar_list VALUES("473","Угощайся","5","100","/style/bar/473.png");
INSERT INTO bar_list VALUES("474","Угощайся","5","100","/style/bar/474.png");
INSERT INTO bar_list VALUES("475","Угощайся","5","100","/style/bar/475.png");
INSERT INTO bar_list VALUES("476","Угощайся","5","100","/style/bar/476.png");
INSERT INTO bar_list VALUES("477","Угощайся","5","100","/style/bar/477.png");
INSERT INTO bar_list VALUES("478","Угощайся","5","100","/style/bar/478.gif");
INSERT INTO bar_list VALUES("479","Угощайся","5","100","/style/bar/479.png");
INSERT INTO bar_list VALUES("480","Для Тебя","5","100","/style/bar/480.png");
INSERT INTO bar_list VALUES("481","Для Тебя","5","100","/style/bar/481.gif");
INSERT INTO bar_list VALUES("482","Для Тебя","5","100","/style/bar/482.png");
INSERT INTO bar_list VALUES("483","Для Тебя","5","100","/style/bar/483.png");
INSERT INTO bar_list VALUES("484","Доброе Утро","40","100","/style/bar/484.png");
INSERT INTO bar_list VALUES("485","Доброе Утро","40","100","/style/bar/485.png");
INSERT INTO bar_list VALUES("486","Доброе Утро","40","100","/style/bar/486.png");
INSERT INTO bar_list VALUES("487","Доброе Утро","40","100","/style/bar/487.png");
INSERT INTO bar_list VALUES("488","Доброе Утро","40","100","/style/bar/488.png");
INSERT INTO bar_list VALUES("489","Доброе Утро","40","100","/style/bar/489.png");
INSERT INTO bar_list VALUES("490","Доброе Утро","40","100","/style/bar/490.png");
INSERT INTO bar_list VALUES("491","Доброе Утро","40","100","/style/bar/491.png");
INSERT INTO bar_list VALUES("492","Доброе Утро","40","100","/style/bar/492.png");
INSERT INTO bar_list VALUES("493","Доброе Утро","40","100","/style/bar/493.png");
INSERT INTO bar_list VALUES("496","Добро пожаловать ","45","200","/style/bar/496.png");
INSERT INTO bar_list VALUES("497","Добро пожаловать ","45","200","/style/bar/497.png");
INSERT INTO bar_list VALUES("498","Добро пожаловать ","45","200","/style/bar/498.gif");
INSERT INTO bar_list VALUES("499","Добро пожаловать ","45","200","/style/bar/499.png");
INSERT INTO bar_list VALUES("502","С днюхой","27","200","/style/bar/502.png");
INSERT INTO bar_list VALUES("503","С днюхой","27","200","/style/bar/503.gif");
INSERT INTO bar_list VALUES("504","С днюхой","27","200","/style/bar/504.gif");
INSERT INTO bar_list VALUES("505","С днюхой","27","200","/style/bar/505.gif");
INSERT INTO bar_list VALUES("506","С днюхой","27","200","/style/bar/506.gif");
INSERT INTO bar_list VALUES("507","С днюхой","27","200","/style/bar/507.gif");
INSERT INTO bar_list VALUES("508","С днюхой","27","200","/style/bar/508.gif");
INSERT INTO bar_list VALUES("509","С днюхой","27","200","/style/bar/509.gif");
INSERT INTO bar_list VALUES("510","С днюхой","27","200","/style/bar/510.gif");
INSERT INTO bar_list VALUES("511","С днюхой","27","200","/style/bar/511.gif");
INSERT INTO bar_list VALUES("512","С днюхой","27","200","/style/bar/512.gif");
INSERT INTO bar_list VALUES("513","С днюхой","27","200","/style/bar/513.gif");
INSERT INTO bar_list VALUES("514","С днюхой","27","200","/style/bar/514.gif");
INSERT INTO bar_list VALUES("515","С днюхой","27","200","/style/bar/515.png");
INSERT INTO bar_list VALUES("516","С днюхой","27","200","/style/bar/516.png");
INSERT INTO bar_list VALUES("517","С днюхой","27","200","/style/bar/517.png");
INSERT INTO bar_list VALUES("518","С днюхой","27","200","/style/bar/518.gif");
INSERT INTO bar_list VALUES("519","С днюхой","27","200","/style/bar/519.gif");
INSERT INTO bar_list VALUES("520","С днюхой","27","200","/style/bar/520.gif");
INSERT INTO bar_list VALUES("521","С днюхой","27","200","/style/bar/521.png");
INSERT INTO bar_list VALUES("522","Шампанское Советское","7","100","/style/bar/522.png");
INSERT INTO bar_list VALUES("523","Элитное Шампанское Моэт и Шандон","7","100","/style/bar/523.png");
INSERT INTO bar_list VALUES("524","  Шампанское Наш Киев","7","100","/style/bar/524.png");
INSERT INTO bar_list VALUES("525","Для тебя ","7","100","/style/bar/525.png");
INSERT INTO bar_list VALUES("526","Шампанское для нас","7","100","/style/bar/526.png");
INSERT INTO bar_list VALUES("527","Для двоих","7","100","/style/bar/527.gif");
INSERT INTO bar_list VALUES("528","Коньячок ","3","200","/style/bar/528.jpg");
INSERT INTO bar_list VALUES("529","Коньяк подарочный","3","200","/style/bar/529.jpg");
INSERT INTO bar_list VALUES("530","Коньяк","3","200","/style/bar/530.gif");
INSERT INTO bar_list VALUES("531","Remy Martin VSOP","3","100","/style/bar/531.png");
INSERT INTO bar_list VALUES("532","Морожка","14","100","/style/bar/532.png");
INSERT INTO bar_list VALUES("533","Морожка","14","100","/style/bar/533.png");
INSERT INTO bar_list VALUES("534","Морожка","14","100","/style/bar/534.png");
INSERT INTO bar_list VALUES("535","Морожка","14","100","/style/bar/535.gif");
INSERT INTO bar_list VALUES("536","Морожка","14","100","/style/bar/536.gif");
INSERT INTO bar_list VALUES("537","Морожка","14","100","/style/bar/537.png");
INSERT INTO bar_list VALUES("538","Морожка","14","100","/style/bar/538.png");
INSERT INTO bar_list VALUES("539","Морожка","14","100","/style/bar/539.png");
INSERT INTO bar_list VALUES("540","Морожка","14","100","/style/bar/540.png");
INSERT INTO bar_list VALUES("541","Морожка","14","100","/style/bar/541.png");
INSERT INTO bar_list VALUES("542","Морожка","14","100","/style/bar/542.png");
INSERT INTO bar_list VALUES("543","Морожка","14","100","/style/bar/543.png");
INSERT INTO bar_list VALUES("544","Морожка","14","100","/style/bar/544.png");
INSERT INTO bar_list VALUES("545","Морожка","14","100","/style/bar/545.gif");
INSERT INTO bar_list VALUES("546","Тортишка","46","100","/style/bar/546.png");
INSERT INTO bar_list VALUES("547","Тортишка","46","100","/style/bar/547.png");
INSERT INTO bar_list VALUES("548","Тортишка","46","100","/style/bar/548.png");
INSERT INTO bar_list VALUES("549","Тортишка","46","100","/style/bar/549.png");
INSERT INTO bar_list VALUES("550","Тортюнчик","46","100","/style/bar/550.png");
INSERT INTO bar_list VALUES("551","Тортюнчик","46","100","/style/bar/551.png");
INSERT INTO bar_list VALUES("552","Тортюнчик","46","100","/style/bar/552.png");
INSERT INTO bar_list VALUES("553","Тортюнчик","46","100","/style/bar/553.png");
INSERT INTO bar_list VALUES("554","Тортюнчик","46","100","/style/bar/554.gif");
INSERT INTO bar_list VALUES("555","Тортюнчик","46","100","/style/bar/555.gif");
INSERT INTO bar_list VALUES("556","Тортюнчик","46","100","/style/bar/556.gif");
INSERT INTO bar_list VALUES("557","Тортюнчик","46","100","/style/bar/557.gif");
INSERT INTO bar_list VALUES("558","Тортюнчик","46","100","/style/bar/558.gif");
INSERT INTO bar_list VALUES("559","Тортюнчик","46","100","/style/bar/559.gif");
INSERT INTO bar_list VALUES("560","Тортюнчик","46","100","/style/bar/560.gif");
INSERT INTO bar_list VALUES("561","Тортюнчик","46","100","/style/bar/561.png");
INSERT INTO bar_list VALUES("562","Тортюнчик","46","100","/style/bar/562.gif");
INSERT INTO bar_list VALUES("563","Тортюнчик","46","100","/style/bar/563.png");
INSERT INTO bar_list VALUES("564","Тортюнчик","46","100","/style/bar/564.png");
INSERT INTO bar_list VALUES("565","Тортюнчик","46","100","/style/bar/565.gif");
INSERT INTO bar_list VALUES("566","Тортюнчик","46","100","/style/bar/566.png");
INSERT INTO bar_list VALUES("567","Тортюнчик","46","100","/style/bar/567.gif");
INSERT INTO bar_list VALUES("568","Тортюнчик","46","100","/style/bar/568.gif");
INSERT INTO bar_list VALUES("569","Пироженко","11","100","/style/bar/569.jpg");
INSERT INTO bar_list VALUES("570","Шоколадкин","11","100","/style/bar/570.png");
INSERT INTO bar_list VALUES("571","Шоколадкин","11","100","/style/bar/571.png");
INSERT INTO bar_list VALUES("572","Прянишка","11","100","/style/bar/572.png");
INSERT INTO bar_list VALUES("573","Для сладкого настроения","11","100","/style/bar/573.jpg");
INSERT INTO bar_list VALUES("574","Для тебя ","11","100","/style/bar/574.png");
INSERT INTO bar_list VALUES("575","Зефирунчик","11","100","/style/bar/575.png");
INSERT INTO bar_list VALUES("576","Для тебя ","11","100","/style/bar/576.png");
INSERT INTO bar_list VALUES("577","Для сладкой жизни","11","100","/style/bar/577.png");
INSERT INTO bar_list VALUES("578","Для тебя ","11","100","/style/bar/578.gif");
INSERT INTO bar_list VALUES("579","Люблю тебя ","34","100","/style/bar/579.png");
INSERT INTO bar_list VALUES("580","Люблю тебя ","34","100","/style/bar/580.png");
INSERT INTO bar_list VALUES("581","Люблю тебя ","34","100","/style/bar/581.png");
INSERT INTO bar_list VALUES("582","Люблю тебя ","34","100","/style/bar/582.png");
INSERT INTO bar_list VALUES("583","Люблю тебя ","34","100","/style/bar/583.png");
INSERT INTO bar_list VALUES("584","Люблю тебя ","34","100","/style/bar/584.png");
INSERT INTO bar_list VALUES("585","Люблю тебя ","33","100","/style/bar/585.png");
INSERT INTO bar_list VALUES("586","Люблю тебя ","33","100","/style/bar/586.png");
INSERT INTO bar_list VALUES("587","Люблю тебя ","33","100","/style/bar/587.png");
INSERT INTO bar_list VALUES("588","Люблю тебя ","34","100","/style/bar/588.png");
INSERT INTO bar_list VALUES("589","Люблю тебя ","33","100","/style/bar/589.png");
INSERT INTO bar_list VALUES("590","Люблю тебя ","32","100","/style/bar/590.png");
INSERT INTO bar_list VALUES("591","Люблю тебя ","32","100","/style/bar/591.png");
INSERT INTO bar_list VALUES("592","Люблю тебя ","32","100","/style/bar/592.png");
INSERT INTO bar_list VALUES("593","Люблю тебя ","32","100","/style/bar/593.png");
INSERT INTO bar_list VALUES("594","Люблю тебя ","32","100","/style/bar/594.png");
INSERT INTO bar_list VALUES("595","Люблю тебя ","32","100","/style/bar/595.png");
INSERT INTO bar_list VALUES("596","Люблю тебя ","32","100","/style/bar/596.png");
INSERT INTO bar_list VALUES("597","Люблю тебя ","32","100","/style/bar/597.png");
INSERT INTO bar_list VALUES("598","Люблю тебя ","32","100","/style/bar/598.png");
INSERT INTO bar_list VALUES("599","Люблю тебя ","32","100","/style/bar/599.png");
INSERT INTO bar_list VALUES("600","Люблю тебя ","33","100","/style/bar/600.png");
INSERT INTO bar_list VALUES("601","Люблю тебя ","33","100","/style/bar/601.png");
INSERT INTO bar_list VALUES("602","Для тебя ","47","100","/style/bar/602.gif");
INSERT INTO bar_list VALUES("603","Для тебя ","47","100","/style/bar/603.gif");
INSERT INTO bar_list VALUES("604","Для тебя ","47","100","/style/bar/604.gif");
INSERT INTO bar_list VALUES("605","Для тебя ","47","100","/style/bar/605.gif");
INSERT INTO bar_list VALUES("606","Для тебя ","47","100","/style/bar/606.gif");
INSERT INTO bar_list VALUES("607","Для тебя ","47","100","/style/bar/607.gif");
INSERT INTO bar_list VALUES("608","Для тебя ","47","100","/style/bar/608.gif");
INSERT INTO bar_list VALUES("609","Для тебя ","47","100","/style/bar/609.gif");
INSERT INTO bar_list VALUES("610","Для тебя ","47","100","/style/bar/610.gif");
INSERT INTO bar_list VALUES("611","Для тебя ","47","100","/style/bar/611.gif");
INSERT INTO bar_list VALUES("612","Для тебя ","47","100","/style/bar/612.gif");
INSERT INTO bar_list VALUES("613","Для тебя ","47","100","/style/bar/613.gif");
INSERT INTO bar_list VALUES("614","Для тебя ","47","100","/style/bar/614.gif");
INSERT INTO bar_list VALUES("615","Для тебя ","47","100","/style/bar/615.gif");
INSERT INTO bar_list VALUES("616","Для тебя ","47","100","/style/bar/616.gif");
INSERT INTO bar_list VALUES("617","Для тебя ","47","100","/style/bar/617.gif");
INSERT INTO bar_list VALUES("618","Для тебя ","47","100","/style/bar/618.gif");
INSERT INTO bar_list VALUES("619","Для тебя ","47","100","/style/bar/619.gif");
INSERT INTO bar_list VALUES("620","Для тебя ","47","100","/style/bar/620.gif");
INSERT INTO bar_list VALUES("621","Для тебя ","47","100","/style/bar/621.gif");
INSERT INTO bar_list VALUES("622","Для тебя ","47","100","/style/bar/622.gif");
INSERT INTO bar_list VALUES("623","Для тебя ","47","100","/style/bar/623.gif");
INSERT INTO bar_list VALUES("624","Для тебя ","47","100","/style/bar/624.gif");
INSERT INTO bar_list VALUES("625","Для тебя ","47","100","/style/bar/625.gif");
INSERT INTO bar_list VALUES("626","Для тебя ","47","100","/style/bar/626.gif");
INSERT INTO bar_list VALUES("627","Для тебя ","47","100","/style/bar/627.gif");
INSERT INTO bar_list VALUES("628","Для тебя ","47","100","/style/bar/628.gif");
INSERT INTO bar_list VALUES("629","Для тебя ","47","100","/style/bar/629.gif");
INSERT INTO bar_list VALUES("630","Для тебя ","47","100","/style/bar/630.gif");
INSERT INTO bar_list VALUES("631","Для тебя ","47","100","/style/bar/631.gif");
INSERT INTO bar_list VALUES("632","Для тебя ","47","100","/style/bar/632.gif");
INSERT INTO bar_list VALUES("633","Для тебя ","47","100","/style/bar/633.gif");
INSERT INTO bar_list VALUES("634","По девкам ","43","100","/style/bar/634.png");
INSERT INTO bar_list VALUES("635","Вместо супа ","43","100","/style/bar/635.png");
INSERT INTO bar_list VALUES("636","Не роздевай","43","100","/style/bar/636.png");
INSERT INTO bar_list VALUES("637","Милый где ты ","43","100","/style/bar/637.gif");
INSERT INTO bar_list VALUES("638","Где мой цветик ","43","100","/style/bar/638.gif");
INSERT INTO bar_list VALUES("639","На прогулку становись ","43","100","/style/bar/639.gif");
INSERT INTO bar_list VALUES("640","Ржунчик","43","100","/style/bar/640.gif");
INSERT INTO bar_list VALUES("641","Не уходи ","43","100","/style/bar/641.gif");
INSERT INTO bar_list VALUES("642","Морожка","14","100","/style/bar/642.png");
INSERT INTO bar_list VALUES("643","Морожка","14","100","/style/bar/643.png");
INSERT INTO bar_list VALUES("644","Морожка","14","100","/style/bar/644.png");
INSERT INTO bar_list VALUES("645","Морожка","14","100","/style/bar/645.png");
INSERT INTO bar_list VALUES("646","Морожка","14","100","/style/bar/646.png");
INSERT INTO bar_list VALUES("647","Морожка","14","100","/style/bar/647.png");
INSERT INTO bar_list VALUES("648","Морожка","14","100","/style/bar/648.png");
INSERT INTO bar_list VALUES("649","Морожка","14","100","/style/bar/649.png");
INSERT INTO bar_list VALUES("650","Морожка","14","100","/style/bar/650.png");
INSERT INTO bar_list VALUES("651","Морожка","14","100","/style/bar/651.png");
INSERT INTO bar_list VALUES("652","Совет да любовь","29","100","/style/bar/652.png");
INSERT INTO bar_list VALUES("653","Совет да любовь","29","100","/style/bar/653.png");
INSERT INTO bar_list VALUES("654","Совет да любовь","29","100","/style/bar/654.png");
INSERT INTO bar_list VALUES("655","Совет да любовь","29","100","/style/bar/655.png");
INSERT INTO bar_list VALUES("656","Совет да любовь","29","100","/style/bar/656.png");
INSERT INTO bar_list VALUES("657","Совет да любовь","29","100","/style/bar/657.gif");
INSERT INTO bar_list VALUES("658","Совет да любовь","29","100","/style/bar/658.gif");
INSERT INTO bar_list VALUES("659","Совет да любовь","29","100","/style/bar/659.gif");
INSERT INTO bar_list VALUES("660","Совет да любовь","29","100","/style/bar/660.gif");
INSERT INTO bar_list VALUES("661","Совет да любовь","29","100","/style/bar/661.gif");
INSERT INTO bar_list VALUES("662","Совет да любовь","29","100","/style/bar/662.png");
INSERT INTO bar_list VALUES("663","Совет да любовь","29","100","/style/bar/663.png");
INSERT INTO bar_list VALUES("664","Совет да любовь","29","100","/style/bar/664.gif");
INSERT INTO bar_list VALUES("665","Совет да любовь","29","100","/style/bar/665.png");
INSERT INTO bar_list VALUES("666","Совет да любовь","29","100","/style/bar/666.gif");
INSERT INTO bar_list VALUES("667","Совет да любовь","29","100","/style/bar/667.gif");
INSERT INTO bar_list VALUES("668","Совет да любовь","29","100","/style/bar/668.gif");
INSERT INTO bar_list VALUES("669","Совет да любовь","29","100","/style/bar/669.gif");
INSERT INTO bar_list VALUES("670","Совет да любовь","29","100","/style/bar/670.gif");
INSERT INTO bar_list VALUES("671","Совет да любовь","29","100","/style/bar/671.gif");
INSERT INTO bar_list VALUES("672","Привет","44","100","/style/bar/672.gif");
INSERT INTO bar_list VALUES("673","Привет","44","100","/style/bar/673.png");
INSERT INTO bar_list VALUES("674","Привет","44","100","/style/bar/674.gif");
INSERT INTO bar_list VALUES("675","Привет","44","100","/style/bar/675.gif");
INSERT INTO bar_list VALUES("676","Привет","44","100","/style/bar/676.gif");
INSERT INTO bar_list VALUES("677","Привет","44","100","/style/bar/677.gif");
INSERT INTO bar_list VALUES("678","Привет","44","100","/style/bar/678.gif");
INSERT INTO bar_list VALUES("679","Привет","44","100","/style/bar/679.gif");
INSERT INTO bar_list VALUES("680","Привет","44","100","/style/bar/680.gif");
INSERT INTO bar_list VALUES("681","Привет","44","100","/style/bar/681.gif");
INSERT INTO bar_list VALUES("682","Привет","44","100","/style/bar/682.gif");



DROP TABLE IF EXISTS `bar_podcat`;

CREATE TABLE `bar_podcat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `category` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

INSERT INTO bar_podcat VALUES("1","Водка","2");
INSERT INTO bar_podcat VALUES("2","Виски","2");
INSERT INTO bar_podcat VALUES("3","Коньяк","2");
INSERT INTO bar_podcat VALUES("4","Сок","2");
INSERT INTO bar_podcat VALUES("5","Чай и  кофе","2");
INSERT INTO bar_podcat VALUES("9","Пиво","2");
INSERT INTO bar_podcat VALUES("7","Шампанское","2");
INSERT INTO bar_podcat VALUES("8","Бреннди ","2");
INSERT INTO bar_podcat VALUES("10","Вино","2");
INSERT INTO bar_podcat VALUES("11","Десерты","3");
INSERT INTO bar_podcat VALUES("12","Коктейли","2");
INSERT INTO bar_podcat VALUES("13","Закуска","6");
INSERT INTO bar_podcat VALUES("14","Мороженое ","3");
INSERT INTO bar_podcat VALUES("15","Для парней","5");
INSERT INTO bar_podcat VALUES("16","Блины ","6");
INSERT INTO bar_podcat VALUES("17","Горячее блюдо","6");
INSERT INTO bar_podcat VALUES("18","Фрукты","7");
INSERT INTO bar_podcat VALUES("19","Для девушек","5");
INSERT INTO bar_podcat VALUES("20","Поцелуй","4");
INSERT INTO bar_podcat VALUES("21","Пожелания","8");
INSERT INTO bar_podcat VALUES("22","Крепкие","9");
INSERT INTO bar_podcat VALUES("23","Яд","9");
INSERT INTO bar_podcat VALUES("24","Молочные и вода ","9");
INSERT INTO bar_podcat VALUES("25","Медпункт","10");
INSERT INTO bar_podcat VALUES("26","Разное","9");
INSERT INTO bar_podcat VALUES("27","Днюха ","11");
INSERT INTO bar_podcat VALUES("28","Нг","12");
INSERT INTO bar_podcat VALUES("29","Свадьба","13");
INSERT INTO bar_podcat VALUES("31","Позитив","14");
INSERT INTO bar_podcat VALUES("32","Для тебя","15");
INSERT INTO bar_podcat VALUES("33","Для любимой","15");
INSERT INTO bar_podcat VALUES("34","Для любимого","15");
INSERT INTO bar_podcat VALUES("39","Атакуем форум","16");
INSERT INTO bar_podcat VALUES("38","Куда спрятал наливай(прик)","16");
INSERT INTO bar_podcat VALUES("40","Доброе утро для любимых","17");
INSERT INTO bar_podcat VALUES("41","Доброе утро людишки ","17");
INSERT INTO bar_podcat VALUES("42","Приятных снов","18");
INSERT INTO bar_podcat VALUES("43","Приколы ","14");
INSERT INTO bar_podcat VALUES("44","Привет ","20");
INSERT INTO bar_podcat VALUES("45","Добро пожаловать ","21");
INSERT INTO bar_podcat VALUES("46","Тортики","3");
INSERT INTO bar_podcat VALUES("47","Все для вам милые дамы ","22");
INSERT INTO bar_podcat VALUES("48","Совет да любовь","13");



DROP TABLE IF EXISTS `battleship`;

CREATE TABLE `battleship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) DEFAULT '0',
  `enemyId` int(11) DEFAULT '0',
  `coins` int(11) DEFAULT '0',
  `betId` varchar(128) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `userShips` text,
  `enemyShips` text,
  `userStroke` text,
  `enemyStroke` text,
  `strokeId` int(11) NOT NULL DEFAULT '0',
  `winId` int(11) NOT NULL DEFAULT '0',
  `close` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `battleship_welcome`;

CREATE TABLE `battleship_welcome` (
  `userId` int(11) DEFAULT '0',
  `users` text,
  `time` int(11) DEFAULT '0',
  `coins` int(11) NOT NULL DEFAULT '0',
  `betId` varchar(128) DEFAULT NULL,
  UNIQUE KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `best_admin`;

CREATE TABLE `best_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `money` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `best_anketa`;

CREATE TABLE `best_anketa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_days` int(11) NOT NULL,
  `sex` enum('0','1') NOT NULL DEFAULT '0',
  `suspend_best` enum('0','1') NOT NULL DEFAULT '0',
  `notification_time_ocenka` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`,`time_days`),
  KEY `sex` (`sex`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bestpodarki_give`;

CREATE TABLE `bestpodarki_give` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_give` int(11) NOT NULL,
  `id_p` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `url` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `bestpodarki_list`;

CREATE TABLE `bestpodarki_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prise` int(11) NOT NULL,
  `url` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=cp1251;

INSERT INTO bestpodarki_list VALUES("158","100000","1471802329");
INSERT INTO bestpodarki_list VALUES("159","100000","1471802354");
INSERT INTO bestpodarki_list VALUES("160","100000","1471802381");
INSERT INTO bestpodarki_list VALUES("161","100000","1471802400");
INSERT INTO bestpodarki_list VALUES("162","100000","1471802422");
INSERT INTO bestpodarki_list VALUES("163","100000","1471802438");
INSERT INTO bestpodarki_list VALUES("164","100000","1471802453");
INSERT INTO bestpodarki_list VALUES("165","100000","1471802481");
INSERT INTO bestpodarki_list VALUES("166","100000","1471802498");
INSERT INTO bestpodarki_list VALUES("167","100000","1471802516");
INSERT INTO bestpodarki_list VALUES("168","100000","1471802532");
INSERT INTO bestpodarki_list VALUES("169","100000","1471802547");
INSERT INTO bestpodarki_list VALUES("170","100000","1471802569");
INSERT INTO bestpodarki_list VALUES("171","100000","1471802593");
INSERT INTO bestpodarki_list VALUES("172","100000","1471802623");
INSERT INTO bestpodarki_list VALUES("173","100000","1471802639");
INSERT INTO bestpodarki_list VALUES("174","100000","1471802658");
INSERT INTO bestpodarki_list VALUES("175","100000","1471802672");
INSERT INTO bestpodarki_list VALUES("176","100000","1471802695");
INSERT INTO bestpodarki_list VALUES("177","100000","1471802714");
INSERT INTO bestpodarki_list VALUES("178","100000","1471802727");
INSERT INTO bestpodarki_list VALUES("179","100000","1471802745");
INSERT INTO bestpodarki_list VALUES("180","100000","1471802759");
INSERT INTO bestpodarki_list VALUES("181","100000","1471802776");
INSERT INTO bestpodarki_list VALUES("182","100000","1471802791");
INSERT INTO bestpodarki_list VALUES("183","100000","1471802805");
INSERT INTO bestpodarki_list VALUES("184","100000","1471802818");
INSERT INTO bestpodarki_list VALUES("185","100000","1471802833");
INSERT INTO bestpodarki_list VALUES("186","100000","1471802849");
INSERT INTO bestpodarki_list VALUES("187","100000","1471802866");
INSERT INTO bestpodarki_list VALUES("188","100000","1471802884");
INSERT INTO bestpodarki_list VALUES("189","100000","1471802899");
INSERT INTO bestpodarki_list VALUES("190","100000","1471802917");
INSERT INTO bestpodarki_list VALUES("191","100000","1471802939");
INSERT INTO bestpodarki_list VALUES("192","100000","1471802962");
INSERT INTO bestpodarki_list VALUES("193","100000","1471802978");
INSERT INTO bestpodarki_list VALUES("194","100000","1471802993");
INSERT INTO bestpodarki_list VALUES("195","100000","1471803011");
INSERT INTO bestpodarki_list VALUES("196","100000","1471803030");
INSERT INTO bestpodarki_list VALUES("197","100000","1471803046");
INSERT INTO bestpodarki_list VALUES("198","100000","1471803064");
INSERT INTO bestpodarki_list VALUES("199","100000","1471803079");
INSERT INTO bestpodarki_list VALUES("200","100000","1471803097");
INSERT INTO bestpodarki_list VALUES("201","100000","1471803114");
INSERT INTO bestpodarki_list VALUES("202","100000","1471803132");
INSERT INTO bestpodarki_list VALUES("203","100000","1471803151");
INSERT INTO bestpodarki_list VALUES("204","100000","1471803174");
INSERT INTO bestpodarki_list VALUES("205","100000","1471803194");
INSERT INTO bestpodarki_list VALUES("206","100000","1471803214");
INSERT INTO bestpodarki_list VALUES("207","100000","1471803251");
INSERT INTO bestpodarki_list VALUES("208","100000","1471803276");
INSERT INTO bestpodarki_list VALUES("209","100000","1471803294");
INSERT INTO bestpodarki_list VALUES("210","100000","1471803331");
INSERT INTO bestpodarki_list VALUES("211","100000","1471803347");
INSERT INTO bestpodarki_list VALUES("212","100000","1471803371");
INSERT INTO bestpodarki_list VALUES("213","100000","1471803677");
INSERT INTO bestpodarki_list VALUES("214","100000","1471803702");
INSERT INTO bestpodarki_list VALUES("215","100000","1471803719");
INSERT INTO bestpodarki_list VALUES("216","100000","1471803734");
INSERT INTO bestpodarki_list VALUES("217","100000","1471803747");
INSERT INTO bestpodarki_list VALUES("218","100000","1471803767");
INSERT INTO bestpodarki_list VALUES("219","100000","1471803783");
INSERT INTO bestpodarki_list VALUES("220","100000","1471803800");
INSERT INTO bestpodarki_list VALUES("221","100000","1471803817");
INSERT INTO bestpodarki_list VALUES("222","100000","1471803836");
INSERT INTO bestpodarki_list VALUES("223","100000","1471803857");
INSERT INTO bestpodarki_list VALUES("224","100000","1471803880");
INSERT INTO bestpodarki_list VALUES("225","100000","1471803895");
INSERT INTO bestpodarki_list VALUES("226","100000","1471803908");
INSERT INTO bestpodarki_list VALUES("227","100000","1471803923");
INSERT INTO bestpodarki_list VALUES("228","100000","1471803939");
INSERT INTO bestpodarki_list VALUES("229","100000","1471803954");
INSERT INTO bestpodarki_list VALUES("230","100000","1471803971");
INSERT INTO bestpodarki_list VALUES("231","100000","1471803991");
INSERT INTO bestpodarki_list VALUES("232","100000","1471804008");
INSERT INTO bestpodarki_list VALUES("233","100000","1471804022");
INSERT INTO bestpodarki_list VALUES("234","100000","1471804040");
INSERT INTO bestpodarki_list VALUES("235","100000","1471804054");
INSERT INTO bestpodarki_list VALUES("236","100000","1471804066");
INSERT INTO bestpodarki_list VALUES("237","100000","1471804079");
INSERT INTO bestpodarki_list VALUES("238","100000","1471804116");
INSERT INTO bestpodarki_list VALUES("239","100000","1471804131");
INSERT INTO bestpodarki_list VALUES("240","100000","1471804146");
INSERT INTO bestpodarki_list VALUES("241","100000","1471804160");
INSERT INTO bestpodarki_list VALUES("242","100000","1471804189");
INSERT INTO bestpodarki_list VALUES("243","100000","1471804207");
INSERT INTO bestpodarki_list VALUES("244","100000","1471804222");
INSERT INTO bestpodarki_list VALUES("245","100000","1471804239");
INSERT INTO bestpodarki_list VALUES("246","100000","1471804260");
INSERT INTO bestpodarki_list VALUES("247","100000","1471804304");
INSERT INTO bestpodarki_list VALUES("250","100000","1471804366");
INSERT INTO bestpodarki_list VALUES("249","100000","1471804324");
INSERT INTO bestpodarki_list VALUES("251","100000","1471804381");
INSERT INTO bestpodarki_list VALUES("252","100000","1471804394");
INSERT INTO bestpodarki_list VALUES("253","100000","1471804405");
INSERT INTO bestpodarki_list VALUES("255","100000","1471804446");
INSERT INTO bestpodarki_list VALUES("256","100000","1471804462");
INSERT INTO bestpodarki_list VALUES("257","100000","1471804482");
INSERT INTO bestpodarki_list VALUES("258","100000","1471804497");
INSERT INTO bestpodarki_list VALUES("259","100000","1471804514");
INSERT INTO bestpodarki_list VALUES("260","100000","1471804526");
INSERT INTO bestpodarki_list VALUES("261","100000","1471804538");
INSERT INTO bestpodarki_list VALUES("262","100000","1471804552");
INSERT INTO bestpodarki_list VALUES("263","100000","1471804566");
INSERT INTO bestpodarki_list VALUES("264","100000","1471804583");
INSERT INTO bestpodarki_list VALUES("265","100000","1471804599");
INSERT INTO bestpodarki_list VALUES("266","100000","1471804609");
INSERT INTO bestpodarki_list VALUES("268","100000","1471804629");
INSERT INTO bestpodarki_list VALUES("270","100000","1471804656");
INSERT INTO bestpodarki_list VALUES("272","100000","1471804680");
INSERT INTO bestpodarki_list VALUES("274","100000","1471805201");
INSERT INTO bestpodarki_list VALUES("276","100000","1471805270");
INSERT INTO bestpodarki_list VALUES("283","100000","1478834137");
INSERT INTO bestpodarki_list VALUES("285","100000","1478834167");
INSERT INTO bestpodarki_list VALUES("286","100000","1478834185");
INSERT INTO bestpodarki_list VALUES("287","100000","1478834202");
INSERT INTO bestpodarki_list VALUES("288","100000","1478834216");
INSERT INTO bestpodarki_list VALUES("289","100000","1478836661");
INSERT INTO bestpodarki_list VALUES("290","100000","1478836676");
INSERT INTO bestpodarki_list VALUES("291","100000","1478836690");
INSERT INTO bestpodarki_list VALUES("292","100000","1478836704");
INSERT INTO bestpodarki_list VALUES("293","100000","1478836718");
INSERT INTO bestpodarki_list VALUES("295","100000","1478836806");
INSERT INTO bestpodarki_list VALUES("297","100000","1478836825");
INSERT INTO bestpodarki_list VALUES("298","100000","1478836834");
INSERT INTO bestpodarki_list VALUES("299","100000","1478836842");
INSERT INTO bestpodarki_list VALUES("300","100000","1478836850");
INSERT INTO bestpodarki_list VALUES("301","100000","1478836858");
INSERT INTO bestpodarki_list VALUES("302","100000","1478837167");
INSERT INTO bestpodarki_list VALUES("303","100000","1478837187");
INSERT INTO bestpodarki_list VALUES("304","100000","1478837203");
INSERT INTO bestpodarki_list VALUES("305","100000","1478837874");
INSERT INTO bestpodarki_list VALUES("306","100000","1487480968");
INSERT INTO bestpodarki_list VALUES("307","100000","1487480978");
INSERT INTO bestpodarki_list VALUES("308","100000","1487480990");
INSERT INTO bestpodarki_list VALUES("309","100000","1487480999");
INSERT INTO bestpodarki_list VALUES("310","100000","1487481009");
INSERT INTO bestpodarki_list VALUES("311","100000","1489595742");
INSERT INTO bestpodarki_list VALUES("314","100000","1489822290");
INSERT INTO bestpodarki_list VALUES("315","100000","1489822299");
INSERT INTO bestpodarki_list VALUES("316","100000","1489822307");
INSERT INTO bestpodarki_list VALUES("317","100000","1489822316");
INSERT INTO bestpodarki_list VALUES("319","100000","1489822339");
INSERT INTO bestpodarki_list VALUES("320","100000","1489822348");
INSERT INTO bestpodarki_list VALUES("321","100000","1489822356");
INSERT INTO bestpodarki_list VALUES("322","100000","1489822365");
INSERT INTO bestpodarki_list VALUES("324","100000","1489822392");
INSERT INTO bestpodarki_list VALUES("325","100000","1489822400");
INSERT INTO bestpodarki_list VALUES("326","100000","1510921927");
INSERT INTO bestpodarki_list VALUES("327","100000","1510968728");
INSERT INTO bestpodarki_list VALUES("328","100000","1510968739");
INSERT INTO bestpodarki_list VALUES("329","100000","1510968751");
INSERT INTO bestpodarki_list VALUES("330","100000","1510968763");
INSERT INTO bestpodarki_list VALUES("331","100000","1510968779");
INSERT INTO bestpodarki_list VALUES("332","100000","1510968794");
INSERT INTO bestpodarki_list VALUES("333","100000","1510968807");
INSERT INTO bestpodarki_list VALUES("334","100000","1510968820");
INSERT INTO bestpodarki_list VALUES("335","100000","1510968845");
INSERT INTO bestpodarki_list VALUES("336","100000","1510968860");
INSERT INTO bestpodarki_list VALUES("337","100000","1510968909");
INSERT INTO bestpodarki_list VALUES("338","100000","1510968932");
INSERT INTO bestpodarki_list VALUES("339","100000","1510968951");
INSERT INTO bestpodarki_list VALUES("340","100000","1510968966");
INSERT INTO bestpodarki_list VALUES("341","100000","1510968981");
INSERT INTO bestpodarki_list VALUES("342","100000","1510968998");
INSERT INTO bestpodarki_list VALUES("343","100000","1510969016");
INSERT INTO bestpodarki_list VALUES("344","100000","1510969039");
INSERT INTO bestpodarki_list VALUES("345","100000","1510969058");
INSERT INTO bestpodarki_list VALUES("346","100000","1510969077");
INSERT INTO bestpodarki_list VALUES("347","100000","1510969119");
INSERT INTO bestpodarki_list VALUES("348","100000","1510969133");
INSERT INTO bestpodarki_list VALUES("349","100000","1510969154");
INSERT INTO bestpodarki_list VALUES("350","100000","1510969175");
INSERT INTO bestpodarki_list VALUES("351","100000","1510969197");
INSERT INTO bestpodarki_list VALUES("352","100000","1510969212");
INSERT INTO bestpodarki_list VALUES("353","100000","1510969234");
INSERT INTO bestpodarki_list VALUES("354","100000","1510969253");
INSERT INTO bestpodarki_list VALUES("355","100000","1510969270");
INSERT INTO bestpodarki_list VALUES("356","100000","1510969285");
INSERT INTO bestpodarki_list VALUES("357","100000","1510969299");
INSERT INTO bestpodarki_list VALUES("358","100000","1576634775");



DROP TABLE IF EXISTS `blacklist`;

CREATE TABLE `blacklist` (
  `user` int(11) NOT NULL DEFAULT '0',
  `lol` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `i` int(1) DEFAULT '0',
  PRIMARY KEY (`user`,`lol`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `bomj`;

CREATE TABLE `bomj` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `brand`;

CREATE TABLE `brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `brand1` text,
  `brand2` text,
  `date` int(30) NOT NULL,
  `time` int(30) NOT NULL,
  `coment` int(1) NOT NULL,
  `f_brand_1` text,
  `f_brand_2` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `brand_coment`;

CREATE TABLE `brand_coment` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `user` int(30) NOT NULL,
  `brand` int(30) NOT NULL,
  `date` int(30) NOT NULL,
  `coment` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `brand_vote`;

CREATE TABLE `brand_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brand` text,
  `golos` text,
  `date` text,
  `user` int(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `breach`;

CREATE TABLE `breach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cat_smiles`;

CREATE TABLE `cat_smiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `center_vnim`;

CREATE TABLE `center_vnim` (
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_p` int(11) NOT NULL,
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_post`;

CREATE TABLE `chat_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `room` int(11) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `vopros` int(11) DEFAULT NULL,
  `umnik_st` set('0','1','2','3','4') DEFAULT '0',
  `shutnik` set('0','1') NOT NULL DEFAULT '0',
  `privat` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room` (`room`)
) ENGINE=MyISAM AUTO_INCREMENT=577 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_rooms`;

CREATE TABLE `chat_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pos` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `umnik` set('0','1') DEFAULT '0',
  `shutnik` set('0','1') DEFAULT '0',
  `opis` varchar(256) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pos` (`pos`,`umnik`,`shutnik`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO chat_rooms VALUES("1","0","Отгадываем","1","0","Отгадываем");
INSERT INTO chat_rooms VALUES("2","2","Смеемся и отгадываем","1","1","Смеемся и отгадываем");
INSERT INTO chat_rooms VALUES("3","3","Шутим","0","1","Шутим");
INSERT INTO chat_rooms VALUES("4","4","Беспредел","0","0","Ругайтесь, сколько влезет!!!\r\nВам простор для беспредела!!!");
INSERT INTO chat_rooms VALUES("5","1","Флудилка","0","0","");



DROP TABLE IF EXISTS `chat_shutnik`;

CREATE TABLE `chat_shutnik` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anek` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=501 DEFAULT CHARSET=utf8;

INSERT INTO chat_shutnik VALUES("1","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("2","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("3","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на 25-ти долларовых машинах с расходом бензина 10 литров на 1000 километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("4","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("5","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("6","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("7","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("8","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("9","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("10","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("11","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("12","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("13","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("14","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("15","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("16","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("17","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("18","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("19","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("20","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("21","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("22","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("23","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("24","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("25","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("26","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("27","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("28","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("29","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("30","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("31","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("32","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время 12 часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("33","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("34","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("35","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("36","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("37","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("38","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("39","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("40","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("41","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("42","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло 2:2, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("43","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("44","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("45","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут 15, мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут 15, у дома крыша уже обваливается, мужик опять: - Hа меня 10 ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("46","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("47","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("48","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("49","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("50","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - 27, товарищ СталинЄ - А сколько погибло? - 26, товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("51","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("52","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("53","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("54","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("55","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("56","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("57","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("58","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("59","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("60","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("61","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("62","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("63","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("64","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью 91-го, мы стpеляли в вас осенью 93-го. Мы pазвалили вашy стpанy в 90-м, обокpали в 92-м, надyли с двyмя Волгами в 93-м, с помощью МММ-ов pаскpyтили на бабки в 94-м, посылали ваших детей на бойню в 95-м, неплохо \"повтоpничали\" в 96-м, и полностью огpабили в 98-м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("65","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("66","Недавно на ж/д переезде № 37 пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("67","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("68","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("69","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("70","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("71","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows 95, в. 3.0)");
INSERT INTO chat_shutnik VALUES("72","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("73","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже 5-й день пьем.");
INSERT INTO chat_shutnik VALUES("74","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("75","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("76","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("77","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("78","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("79","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("80","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("81","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("82","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("83","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("84","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("85","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("86","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("87","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("88","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("89","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("90","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("91","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("92","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("93","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите 100 метровкy?\" (HР): \"Минимyм за $800.\"");
INSERT INTO chat_shutnik VALUES("94","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("95","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("96","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("97","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("98","- Pядовой Петpов - выйти из cтpоя - 15 шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("99","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("100","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("101","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("102","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("103","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("104","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("105","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("106","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("107","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("108","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("109","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через 5 минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("110","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("111","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("112","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("113","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("114","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("115","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("116","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("117","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("118","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("119","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("120","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("121","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("122","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("123","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("124","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("125","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("126","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("127","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("128","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("129","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("130","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("131","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("132","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("133","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("134","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("135","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("136","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("137","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - 50 км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до 50 км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - 20 км\". Он и на этот pаз сбавляет скоpость до 20 км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость 10 км\". Пpоклиная все на свете, он замедляется до 10 км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("138","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("139","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("140","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить 10000 $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("141","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было 15-ти.");
INSERT INTO chat_shutnik VALUES("142","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("143","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("144","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("145","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("146","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("147","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("148","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("149","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("150","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");
INSERT INTO chat_shutnik VALUES("151","Разговор подруг: - Ты знаешь, что женщины совершают меньше аварий, чем мужчины? - Интересно? А почему? - Потому что женщины заботятся о машине, как о муже, а мужчины относятся к ней, как к собственной жене.");
INSERT INTO chat_shutnik VALUES("152","Врач, обследовав женщину, выходит в коридор и сообщает ее мужу: - У меня для вас две новости: хорошая и плохая.\n- Давайте сначала плохую.\n- Ваша жена больна сифилисом.\n- Какой ужас! А хорошая? - Она заразилась им не от вас.");
INSERT INTO chat_shutnik VALUES("153","В компьютер заложили множество всевозможных анекдотов, чтобы тот выдал средний. Результат начинался так: \"Лежат в постели три еврея: Чапаев, Чебурашка и Поручик Ржевский...\".");
INSERT INTO chat_shutnik VALUES("154","- Вася дома? - Нет, Васи больше нету... Он покинул наш мир - Он что, умер? :-( - Нет, к интернету подключился!");
INSERT INTO chat_shutnik VALUES("155","Пpиходит женщина к вpачy.\n- Доктоp, y меня такая маленькая гpyдь. Вы не посоветyете как ее yвеличить.\n- Пpотиpайте ее ежедневно тyалетной бyмагой.\n- И что, поможет ? :-O - Hy, глядя на Вашy задницy... должно помочь.");
INSERT INTO chat_shutnik VALUES("156","Суд осудил Вас на десять лет тюрьмы,- говорит судья обвиняемому.\n- Большое спасибо, не надеялся так долго прожить.");
INSERT INTO chat_shutnik VALUES("157","Объявление: \"Для переписки секретных документов срочно требуется машинистка, не умеющая читать\".");
INSERT INTO chat_shutnik VALUES("158","- Как живешь? - спрашивают Менделя.\n- Как пуговица.\n- Как это понять? - В петлю лезть охота.");
INSERT INTO chat_shutnik VALUES("159","На экзамене по праву: -Профессор, между прочим, шпаргалка является моей собственностью, а Вы её изъяли без соблюдения соответствующей прцессуально-правовой прцедуры! -Эх,молодой человек! Я же преподователь, а не милиционер. Не могу же я лупить вас по почкам перед тем, как забрать шпаргалку!");
INSERT INTO chat_shutnik VALUES("160","Кароче, Робинзон Крузо отсидел на своём острове уже 3 года. Всё у него было - и фрукты, и вода, и хлеб: не было только бабы. И вы сами понимаете, как он удовлетворял свои потребности. И вот однажды, только он хотел с собой поиграть - вдали показался корабль. Робинзон быстро забежал на утес и стал жечь костёр и палить из мушкета. И свершилось чудо - на корабле его заметили и поплыли в его сторону. Робинзон размечтался: - Наконец-то! Сначала я приму ванну и помоюсь с мылом. Потом я выпью фунфырик рома. Затем они дадут мне красивую бабу. Я начну с ней танцевать, потрогаю её за попу, поглажу по спине, потом прикоснусь к её грудям, потом брошу её на кровать и раздену. И у неё будет кружевное бельё, и розовые чулочки на подвязках....... Тут он заметил, что у него наступила жестокая эрекция. Он быстро засунул руку в штаны и сказал: - А насчет корабля я-то пошутил! Ха-Ха-Ха-Ха.....");
INSERT INTO chat_shutnik VALUES("161","- Запомни раз и навсегда! - говорит жена мужу.- Если ты будешь приставать к горничной, я с тобой разведусь! - Из-за такого пустяка? - Ты ее разбалуешь. Пойми, такого мужа, как ты, я всегда найду, а такую горничную - вряд ли!");
INSERT INTO chat_shutnik VALUES("162","Штирлиц пришел к выводу. Но Вывода не оказалось дома.");
INSERT INTO chat_shutnik VALUES("163","Hовый русский заваливается к директору одной фирмы на работу (все как полагается - сотовый телефон,малиновый пиджак, etc). Директора нет на месте. Секретарша предлагает: - Вы телефончик оставьте, он позвонит. HР: - Да ты че, дура, ошалела, труба тыщу баков стоит!");
INSERT INTO chat_shutnik VALUES("164","Приехала Зыкина на гастроли в Грузию. Ей бурно аплодируют после каждой песни. Кончила петь - ее вызывают на бис. Спела на бис - ей аплодируют еще сильнее. Выходит она, наконец, на сцену и говорит, что репертуар исчерпан, петь нечего.\n- Зачем петь? - кричат ей из зала.\n- Ты ходи: туда ходи, сюда ходи!");
INSERT INTO chat_shutnik VALUES("165","Граница на карте обозначена точка-тире, точка-тире, что символизирует пограничник-собака, пограничник-собака.");
INSERT INTO chat_shutnik VALUES("166","Когда Рустем вернулся из Японии, где был в командировке, знакомые поинтересовались, как он там объяснялся, не зная японского языка.\n- Надо сказать, трудности бывали, - признался Рустем.\n- Вот, например, когда я хотел купить плавки и жестами объяснил, что мне нужно, продавец принес нож для харакири.");
INSERT INTO chat_shutnik VALUES("167","Урологическая операционная. Лежит больной, подготовленный к операции. Молоденькая сестричка. Входит хирург, с вымытыми руками, в стерильных перчатках: - Сестра, поправьте член.\n- Хмм..., - поправляет.\n- А теперь больному!");
INSERT INTO chat_shutnik VALUES("168","- Винтовка для солдата - лучший друг, не правда ли? - Не знаю, господин генерал! Вчера, когда я ее чистил, она выстрелила мне в ногу!");
INSERT INTO chat_shutnik VALUES("169","В больнице идет обход. Подходят к первому больному. Доктор: Что у вас? Больной: Геморрой! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят ко второму. Д: Что у вас? Б: Грибок на ногах! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят к третьему. Д: Что у вас? Б: Ангина! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Б: Доктор, скажите сестре, чтобы мне первому мазали...");
INSERT INTO chat_shutnik VALUES("170","Жена сказала мужу: - Я очень не люблю твоих братьев. Как появятся у тебя деньги, они все тут как тут и вовсю пользуются твоей щедростью. А когда у тебя в кошельке пусто и ты сам бедствуешь, ни один из них на глаза не покажется. Муж ответил: - Они очень вежливые и не хотят доставлять мне лишних хлопот, когда нам нечем с ними поделиться.");
INSERT INTO chat_shutnik VALUES("171","- Ну что, помогла вам наша отрава избавиться от мышей? - О да, пан аптекарь! Мышам она так понравилась, что они растолстели и не смогли пролезть в нору. Наша кошка переловила их всех и съела!");
INSERT INTO chat_shutnik VALUES("172","Однажды в жаркий полдень молодой папаша вывез коляску с ребенком на улицу и стал с ней прогуливаться.\n- Послушай, Чарли! - послышалось из окна третьего этажа.\n- Оставь меня в покое, - огрызнулся муж, - у нас все в порядке. Через чес раздался тот же голос: - Чарли, Чарли... Ну, что ты хочешь? - стал ворчать муж.\n- Что там у тебя случилось? - Да нет, Чарли, ничего. Но ты вот уже больше часа катаешь в коляске куклу Ненси. Пожалуйста, погуляй немного и с ребенком...");
INSERT INTO chat_shutnik VALUES("173","Муж с женой собираются на свадьбу. Муж, понятное дело, быстренько собрался, а жена все крутится перед зеркалом, примеряет наряды. И то не так, и се не так...\n- Скорее собирайся, мы же опоздаем! Наконец вышли. Приходят к дому, где свадьбу играют, а там один пьянчужка спит под забором, а другой, еле держась на ногах, что-то лепечет. Увидев эту картину, муж сердито говорит жене: - Видишь, люди уже гуляют, а мы еще только идем!");
INSERT INTO chat_shutnik VALUES("174","Дирижер оркестра получает после концерта записку: \"Я не ябеда, но вон тот рыжий детина с усами бьет в барабан только тогда, когда вы на него смотрите!\"");
INSERT INTO chat_shutnik VALUES("175","Сказочка Жил-был мальчик. И подарил однажды этот мальчик девочке цветочек. На следующий день опять подарил, и дарил много-много дней подряд. И говорит однажды ему девочка: - Хватит херней страдать, пошли-ка лучше со мной спать! Мальчик заплакал и говорит: - Я не умею. И пошел прочь от девочки. Идет он, значит, по улице, и плачет. Тут навстречу ему - проститутка.\n- Почему ты плачешь, мальчик? - спрашивает она.\n- А мне девочка предложила с ней спать, а я не умею! - Ну ничего страшного, пошли со мной! И пошли они к проститутке домой, и научила она мальчика всем прелестям вагинального, орального и прочих видов секса. Обрадованный мальчик радостно выбежал на улицу и побежал к своей девочке. Прибегает, а девочка уже спит с другим мальчиком. Наш мальчик опять заплакал и пошел на почту.\n- Отправьте телеграмму.\n- сказал он тетеньке в окошке.\n- Какую? - спросила тетенька.\n- \"Мама, я больше не приду домой, я теперь буду жить своей особенной жизнью!\" - продиктовал мальчик.\n- А как тебя звать-то, мальчик? - спросила тетен");
INSERT INTO chat_shutnik VALUES("176","Интеллигентного вида мужчина садится в такси. Диалог с таксистом: - Вы не могли бы подбросить меня в аэропорт, только нужно на минуточку заскочить на базар? - Без базару! - Да? Ну тогда сразу в аэропорт...");
INSERT INTO chat_shutnik VALUES("177","- Куда девать пенсионеров? - поступают в центр вопросы с мест. Из центра шлют циркуляры: \"У кого трясутся руки из стороны в сторону посылать на мельницу сеять муку. У кого вертится голова направлять в торговлю. У кого трясется голова того сажать в президиум. Ожил Ленин и попросил подшивку газеты \"Правда\" за последние 70 лет. Читает: ЄПрием в Кремле Є3автрак в Кремле ЄОбед в КремлеЄ - Что же вы мне дали? - возмущается Ленин, Это же меню!");
INSERT INTO chat_shutnik VALUES("178","Служанка: - Извините, пожалуйста, но миссис Браун велела сказать, что ее нет дома. Гостья: - Ничего, ничего, голубушка. В таком случае передайте ей, что я очень рада, что не приходила.");
INSERT INTO chat_shutnik VALUES("179","Гpабитель на улице обpащается к хоpошо одетой женщине: - Деньги, мадам! Да поживее! Подумайте, что будет, если стpуя из этого водяного пистолета pазмоет косметику на вашем лице.");
INSERT INTO chat_shutnik VALUES("180","Шотландец и его сын в традиционных юбках идут по Эдинбургу. Навстречу - девушка в брюках. Отец - сыну: - Сколько тебе повторять - не оглядывайся на каждые брюки!");
INSERT INTO chat_shutnik VALUES("181","- Какой смысл вкладывается в выражение \"не тяни кота за хвост\"? - Сколько кота не тренируй, он ящерицей не станет!");
INSERT INTO chat_shutnik VALUES("182","- Доктор, - говорит ассистент, - пациент из второй палаты Иванов скверно себя чувствует.\n- Надо говорить: пациент Иванов думает, что он скверно себя чувствует. Это новейший взгляд на сущность болезней. На следующий день ассистент говорит врачу: - Доктор, больной Иванов думает, что он умер.");
INSERT INTO chat_shutnik VALUES("183","Шла мышка по темному лесу. И чтоб ей не было так страшно она пела песенку: - \"ЛА-ЛА-ЛА-ЛА\" (исполнять громко и страшно).");
INSERT INTO chat_shutnik VALUES("184","Утром...\n- Я жених... я женихххх... я же ниххххрена не помню...");
INSERT INTO chat_shutnik VALUES("185","Деревенский мальчик кричит: - Мама, там молочник пришел. Ты ему деньги отдашь или мне пойти погулять?");
INSERT INTO chat_shutnik VALUES("186","Встречаются два друга.\n- Как твои дела? - Да вот подозреваю, что моя жена мне изменяет с пекарем. Каждый раз раскрывая постель, обнаруживаю в ней хлебные крошки.\n- А..а..а. Теперь и я начинаю подозревать, что моя жена мне изменяет со слесарем из нашего ЖЭКа.\n- Ты что, инструменты в постели находишь? - Да нет. Понимаешь, как ни приду домой, так слесарь лежит в нашей постели.");
INSERT INTO chat_shutnik VALUES("187","Новая Шаума сделала мои волосы такими объемными, что даже ширинка не застегивается!!!");
INSERT INTO chat_shutnik VALUES("188","- Какие герои вышли из книги в реальную жизнь? - Гайдар и его команда!");
INSERT INTO chat_shutnik VALUES("189","Парень повредил палец на руке и пришел к врачу. Врачиха говорит: - Раздевайтесь. Парень: - Зачем? Я ведь всего лишь повредил палец. Мужской голос из-за ширмы: - Это что! Я вообще пришел телефон починить!");
INSERT INTO chat_shutnik VALUES("190","Идут два программера, мими них проходит обалденно красивая девушка. Оба провожают ее взглядом. Идут дальше... Первый: - Да... Плохо, что у девушек нету стандартного интерфейса. Второй: - Ошибаешься! Стандартный интерфейс у них как раз-то есть! Первый: - Действительно. И все же жаль, что не существует стандартного способа этот интерфейс получить.");
INSERT INTO chat_shutnik VALUES("191","20-летняя бабёнка вышла замуж за 90 летнего дедка. После первой брачной ночи она вышла из спальни еле передвигая ноги, вся разбитая и усталая.\n- Господи, что он с тобой сделал?! - спрашивает мать.\n- Он говорил мне, что копил 75 лет... Но я думала, что он имел ввиду деньги.");
INSERT INTO chat_shutnik VALUES("192","Два грузина смотрят фильм: Альпинист лезет на гору из последних сил, лезет, останавливается, опять лезет.\n- Слушай, Гоги, давай поспорим на 1000 баксов, что он не залезет? - Да ты что? Я знаю, он залезет! Поспорили. Альпинист все-таки взобрался. Первый: - Ну, Гоги, ты выиграл, забирай деньги, я проиграл, ты был прав.\n- Слушай, Вано, ну как так можно, ты же мой друг, я не могу взять деньги у друга... К тому же я уже смотрел этот фильм раньше.\n- Ну и что, я тоже смотрел этот фильм раньше, но был уверен, что второй раз точно не залезет!");
INSERT INTO chat_shutnik VALUES("193","- Э, слущай, я себе \"СУПЕРМАЗ\" купил! - А зачэм тэбэ \"СУПЕРМАЗ\"? - Ну как!? Памазал - все праходыт!");
INSERT INTO chat_shutnik VALUES("194","Чувство вины мучило доктора Х. весь день. Как ни пытался он забыть об этом, ничего не получалось. Нервы напряглись до предела. Но время от времени звучал этот подбадривающий внутренний голос: Да не переживай ты так. Ты не первый и не последний врач, который сношается с пациентами. Но тут же неизменно второй, подленький такой голос возвращал его в реальность: Но ты же все-таки ветеринар...");
INSERT INTO chat_shutnik VALUES("195","Возле стройки тормозит \"Мерседес\", из окошка высовывается новый русский и предлагает рабочим: - Мужики, нужен рубероид, даю сотню баксов! Что еще можете толкнуть? Те ошалели от неожиданности: - Все! Кирпич, цемент, стекло, прораба.");
INSERT INTO chat_shutnik VALUES("196","Чебурашка прибегает к крокодилу Гене: - Шапокляк родила! Беги к ней скорее - я своих утопил, а твои плавают!");
INSERT INTO chat_shutnik VALUES("197","На радио Эхо Москвы: - Сегодня, 22 апреля, солнце взошло в 6 утра, погода +12 градусов. Теперь кто из знаменитостей родился в этот день... Хм..., так, ну кто родился, все и так знают, а кто не знает, тем лучше и не надо...");
INSERT INTO chat_shutnik VALUES("198","Диктатору на заметку: если Вы хотите, чтобы все люди жили в одном большом концлагере, уделите должное внимание защите государственной границы.");
INSERT INTO chat_shutnik VALUES("199","Состоялась защита кандидатской диссертации на тему: \"Введение спиртного через задний проход\". Диссертант научно доказал, что этот способ имеет преимущества перед обычным: мало нужно, чтобы опьянеть;можно без закуски;изо рта не пахнет. Оппонент задал вопрос, как при этом способе выпивать на брудершафт.\n- Это тема моей докторской, - ответил диссертант.");
INSERT INTO chat_shutnik VALUES("200","- Смотри, какие тени длинные, и облака тяжелые...\n- Длинные, потому что уже поздно, а тяжелые, потому что мы уже пятый день пьем...");
INSERT INTO chat_shutnik VALUES("201","Знаменитая киноактриса: - А теперь хватит говорить обо мне. Поговорим о вас. Расскажите мне, как я понравилась вам в моем последнем фильме.");
INSERT INTO chat_shutnik VALUES("202","Продам китайский гарнитур из одиннадцати предметов - две циновки и девять портретов Мао Цзедуна.");
INSERT INTO chat_shutnik VALUES("203","Таможенник на границе входит в купе: - Коньяк? Табак? Наркотоки? - Чашечку кофе, пожалуйста.");
INSERT INTO chat_shutnik VALUES("204","Всем известна история о русском мастере Левше, подковавшем аглицкую блоху. Но почему-то история умалчивает о другом мастере Мойше, сделавшем той самой блохе обрезание.");
INSERT INTO chat_shutnik VALUES("205","- Вы помните Нухима Спивака? Когда 20 лет назад он приехал в Америку, у него была только пара рваных штанов. Сейчас он имеет миллион! - Господи! Что будет делать этот ненормальный в Америке с миллионом рваных штанов!?!");
INSERT INTO chat_shutnik VALUES("206","Лежат парень с девушкой в постели. Она(томно): - Трахни меня! Он(напряженно): - Уже трахаю! -=Nail=-");
INSERT INTO chat_shutnik VALUES("207","Школьница спрашивает у матери: - Мама, скажи мне, что такое пятилетка? - Пятилетка, дочка, это трудовой порыв. Через пять лет в стране всего станет в пять раз больше! - Всего-всего? - Да, дочка, и мы в пять раз будем жить лучше! В школе учительница задает вопрос: - Дети, скажите, что такое пятилетка? Желая блеснуть знаниями, ученица подняла руку.\n- Пятилетка - это трудовой порыв, когда всего становится в пять раз больше - и хлеба, и масла, и людейЄ Увидела в окно - покойника везут.\n- ЄИ покойников, и воров, и нищих, и двоечников.");
INSERT INTO chat_shutnik VALUES("208","Хоpонят авторитета. К гpобу очеpедь попpощаться. Один мужик подходит, пpипадает и долго-долго не может отоpваться от усопшего. Его подталкивют, мол, пpоходи, видишь, сколько наpоду еще. А мужик: - Погодите вы, я с бодуна, а он такой холодненький...");
INSERT INTO chat_shutnik VALUES("209","- Почему твой муж часто уходит по вечерам из дому? - спрашивает подруга.\n- Бедняжка, он не любит сидеть дома один.");
INSERT INTO chat_shutnik VALUES("210","Мужчина стоит на набережной и бросает монеты в воду.\n- Что случилось? - удивленно спрашивает прохожий.\n- У меня упала в канал монета.\n- Но для чего вы бросаете туда другие монеты? - Чтобы не лезть в воду ради одной.");
INSERT INTO chat_shutnik VALUES("211","Шел мимо крутой усадьбы бродяга, и потянуло его на халяву.\n- А я так просто не подаю, мужик! - заявил хозяин, лениво развалившись в шезлонге с журналом.\n- Хочешь деньжат - заработай! Вон, пойди на задний двор, там найдёшь краску и покрасишь мне забор... Бомж поплёлся за особняк. А хозяин продолжил листать «Плейбой», да так увлекся, что совсем забыл о «маляре». Опомнился он только тогда, когда тот постучал его по плечу.\n- Закончил я! - бодренько сообщил бродяга, потирая руки.\n- Только вы мне неправильно сказали: у вас там не «Запор», а BMW.");
INSERT INTO chat_shutnik VALUES("212","- Что за кривоногая девчонка была с тобой сегодня утром? - спросил один студент другого.\n- Это та со стройными ножками, с которой ты познакомил меня вчера вечером.");
INSERT INTO chat_shutnik VALUES("213","На вокзале в Риме провинциального вида старушка подходит к окошку кассы и спрашивает, сколько стоит билет на Палермо.\n- Десять тысяч лир, синьора. Старушка оборачивается к своей спутнице и говорит: - Придется, видимо, купить. Я уже спрашивала во всех кассах, и всюду цена у них одинаковая. Не иначе, как договорились...");
INSERT INTO chat_shutnik VALUES("214","- Пани Ковальская, очень прискорбно, но мы вынуждены сообщить, что ваш муж скончался прямо на работе. Пани Ковальская продолжает спокойно обедать.\n- Разве вы не слышите - ваш муж умер! - Слышу, слышу! Подождите, вот я сейчас закончу, тогда вы увидите, какая со мной будет истерика!");
INSERT INTO chat_shutnik VALUES("215","Российскими ученными было доказано, что смешивание водки с молоком приводит к раздражению желудочно-кишечного тракта вследствие недостаточно изученных свойств молока.");
INSERT INTO chat_shutnik VALUES("216","У генерала родился внук. Чтобы узнать, на кого он похож, генерал посылает в роддом адъютанта.\n- На вас! - радостно сообщает вернувшийся адъютант.\n- Вот это да! Докладывай детали! - Внучок ваш лысый, пузатый, ничего не соображает и все время орет.");
INSERT INTO chat_shutnik VALUES("217","В метро едут два парня, а напротив - две девушки. Один парень говорит другому: - Ну что, познакомимся с подругами? - Почему нет? - Ну и отлично. Твоя, правда, страшноватенькая...");
INSERT INTO chat_shutnik VALUES("218","Однажды в Сенате Разумовский отказался подписать решение, которое считал несправедливым.\n- Государыня желает, чтоб дело решено было таким образом,- объявили ему сенаторы.\n- Если так - не смею ослушаться,- сказал Разумовский и подписал свою фамилию \"вверх ногами\". Этот поступок сразу же стал известен императрице, та потребовала объяснений.\n- Я исполнил вашу волю, но так как покривил совестью, то и подпись моя кривая.");
INSERT INTO chat_shutnik VALUES("219","Выходит пеpвый мощный MEN - ТААКОЙ КРУТООЙ ! Снимает доpогенный плащ, достает pоскошный лук и БАЦ !!! Попал в самую точку, не задев добpовольца! Все:\"ООООО\". Мужик:\"I`m ROBIN GOOD\" и удаляется.");
INSERT INTO chat_shutnik VALUES("220","Альпинист покорил вершину. В восторге он стоит наверху и кричит: - Ура, я первый! Эхо доносит: \"Не первый! Не первый!\" Он снова кричит... А эхо снова: \"Не первый! Не первый!\" Альпинист: - Кто это со мной разговаривает? Из-за гребня к нему подходит седенький старичок.\n- Сынок! Это я с тобой разговариваю! - Дедушка, а ты кто? - Я? Волшебник! - И ты можешь выполнить три моих желания? - Конечно! Загадывай! - Во-первых, хочу чтобы у меня был миллион рублей денег! Во-вторых, чтобы моей женой стала \"мисс СССР\"! В третьих, хочу быть не здесь, а дома, в своей квартире! - Хорошо, сынок! Я исполню все три твои желания, если ты исполнишь одно мое? - Какое, дедушка? - Отсоси у меня! - А если я не захочу? - Тогда и твои желания не исполнятся! Альпинист подумал: \"Так уж быть! Ради своих желаний можно и пойти на уступки, тем более, что нас никто не видит... \" - Ладно, дедушка, давай! Взял в рот, сосет. Старичок нежно гладит его по голове: - Такой большой, а в сказки веришь!");
INSERT INTO chat_shutnik VALUES("221","Долго думали в армии, куда чукчу пристроить, и определили в пожарники. Через неделю начальник расчета приходит к начальнику пожарной части: - Опять у нас с чукчей ЧП.\n- Мать вашу етить! сколько раз уже говорил вам, чтоб технику безопасности соблюдали! - Так мы соблюдаем. Вон, ему на верхушке лестницы прибили плакат - СТОП! - Ну и чего ж? - Так он, оказывается, читает медленно.");
INSERT INTO chat_shutnik VALUES("222","Учительница спрашивает: - Петенька, кем ты хочешь стать, когда вырастешь? - Врачом.\n- Молодец. А ты, Ванечка? - Юристом.\n- Умница. А ты, Вовочка? - А я хочу стать придурком.\n- Почему придурком?! - Потому что когда мы с папой выходим из дома, он все время говорит: \"Роскошный дом у этого придурка!\" Или: \"Клевая тачка у этого придурка!\"");
INSERT INTO chat_shutnik VALUES("223","Двое кавказцев играют в шахматы. Один ставит ферзя на центр поля: - Мат! Другой ставит своего рядом: - Отэц!");
INSERT INTO chat_shutnik VALUES("224","- Я слышал, Пол Маккартни к нам приезжает. Будет выступать на Красной площади.\n- А ну его, не пойду.\n- Почему? - Пол без Джона - деньги на ветер.");
INSERT INTO chat_shutnik VALUES("225","Сидят две вороны на дереве.\n- Какие все-таки люди неблагодар-р-рные! - Мы их о дожде пр-редупреждали - предупреждали, а они говорят, что мы его накар-р-ркали!");
INSERT INTO chat_shutnik VALUES("226","Слуга обращается к лорду: - Сэр, осмелюсь доложить, что на кухне некоторым образом возник пожар. Хозяин дома медленно отложил \"Таймс\" и сказал: - Сообщите это леди. Вы же знаете, Робинс, что я не занимаюсь домашним хозяйством.");
INSERT INTO chat_shutnik VALUES("227","Сенбернары - это такие собаки, которые живут в Альпах, они зимой ищут потерявшихся лыжников... тем и живут.");
INSERT INTO chat_shutnik VALUES("228","Штирлиц заходит в кабинет Мюллера, смотрит, Мюллер сидит в фуфайке и играет на балалайке.\n- Группенфюрер, что с вами? - удивился Штирлиц.\n- Полноте вам, Штирлиц, не вы один по Родине скучаете.");
INSERT INTO chat_shutnik VALUES("229","Мужик приходит в кабак.\n- Я здесь вчера сидел.\n- Да.\n- Я всю зарплату пропил? - Да.\n- Фу ты (облегченно вздыхая) Думал потерял.");
INSERT INTO chat_shutnik VALUES("230","Встретились как-то три бывшие шлюхи-пенсионерки: Первая шлюха: - Когда я занималась проституцией, я получала всего лишь 20 баков за минет. Вторая шлюха: - Ну это не так уж плохо, мне в свое время платили за это только 10 баков. Третья шлюха слушала, слушала и тоже решила высказаться: - Я занималась проституцией во время Великой Депресии и делала минет за так - лишь бы набить живот чем-нибудь теплым.");
INSERT INTO chat_shutnik VALUES("231","- Потерпевший, вы напились до такой степени, что упали в оркестровую яму.\n- Гражданин следователь, каюсь - я попал в нехорошую компанию. На троих была одна бутылка водки, и никто, кроме меня, не пил.");
INSERT INTO chat_shutnik VALUES("232","Hа пеpвую годовщину Чеpнобыля все киевские евpеи получили по 2 юбилейных медали: (1-я) За освобождение Киева (2-я) За взятие Одессы.");
INSERT INTO chat_shutnik VALUES("233","Мужской возраст: 1. Взялся за грудь и... поел 2. Взялся за грудь и... кончил 3. Взялся за грудь и... возбудился 4. Взялся за грудь и... уснул");
INSERT INTO chat_shutnik VALUES("234","Сидят два мужика и ловят рыбу. А один грустный такой. Друг его спрашивает: - Что случилось? - Да у жены день рождения был, а я забыл поздравить. Посидели, помолчали. Тут друг успокаивать начал: - Знаешь, я тебе сейчас всё объясню. Ты вот, например, помнишь день, когда ты поймал самую большую рыбу? - Конечно, помню! - Так вот, а рыба - не помнит!");
INSERT INTO chat_shutnik VALUES("235","Мужик в подавленном состоянии приходит к психиатру и жалуется: - Доктор, помогите, я никогда не пользовался успехом у женщин, они от меня разбегаются, а ведь мне уже 35 лет, я больше не могу так жить! - Успокойтесь, эта проблема на самом деле легко решается, просто вам необходимо вырабатывать уверенность в себе. Каждое утро вставайте перед зеркалом, оглядывайте себя с ног до головы и повторяйте: я уважаемый человек, люди мною восхищаются и завидуют мне, я сильный и чертовски привлекательный. Поверьте мне, как только у вас появится уверенность в себе, женщины так и будут липнуть к вам. У пациента заметно улучшается настроение, и он уходит. Но через неделю он снова приходит подавленным. Психиатр спрашивает: - Вы не последовали моему совету? - Последовал, и все получилось именно так как вы сказали.\n- Так в чем же тогда у вас проблема? - Да это не у меня, это у жены проблема.");
INSERT INTO chat_shutnik VALUES("236","Встретились как-то грузин и американец. Спорят, кто лучше живет.\n- У нас каждый американец имеет квартиру отдельную - У нас кажадый грузин имеет большой коттедж.\n- У нас каждый американец имеет машину.\n- А у нас каждый грузин имеет самолет.\n- Слушай, а что ты все про грузин да про грузин? А русские-то у вас как живут? - Я же у тебя про негров не спрашиваю...");
INSERT INTO chat_shutnik VALUES("237","- Слышал, говорят, что на рынке уже можно купить говядину по рублю за килограмм.\n- Ну, это вранье! - Пускай, лишь бы дешево!");
INSERT INTO chat_shutnik VALUES("238","Сидят чукчи у моря.\n- Смотри, самолет полетел! - Да-а-а! Наверное правительственный.\n- Нет.\n- Почему? - Мотоцикла впереди нету!");
INSERT INTO chat_shutnik VALUES("239","Заходит в купе парень без уха и смеется! Его спрашивают: - Ты что? Ухо потерял - плакать нужно! - Что там ухо! На свадьбе драка была! Мне ухо оторвали, а член жениха - вот, у меня в кармане!");
INSERT INTO chat_shutnik VALUES("240","На скамье в парке сидит человек и, с негодованием глядя на идущего мимо пьяного, говорит: - Безобразие! Я бы вылил весь мировой запас спиртного в океан! Сидящий рядом мужчина аплодирует: - Браво! Отличная идея! - Вы тоже трезвенник? - Нет, я водолаз...");
INSERT INTO chat_shutnik VALUES("241","- Карлссон, опять щенок в углу насрал...\n- А где ж ему срать, на шкафу, что ли? Так только я могу!");
INSERT INTO chat_shutnik VALUES("242","- Мой муж хочет, чтобы я поступила на кулинарные курсы.\n- Вот как! А я и не знала, что вы приобрели собаку.");
INSERT INTO chat_shutnik VALUES("243","Стали Винни с Пятачком альпинистами. Ползут по стене.\n- Винни, Винни я прополз 15 метров и не вбил ни одного крюка.\n- Бей шлямбур, толстая свинья.\n- Но Винни, если я его забью он испортится.\n- Если ты его не забьешь, то испортимся мы оба.");
INSERT INTO chat_shutnik VALUES("244","После жуткого перепоя просыпается утром тетка. Во рту - кошки насрали, под глазами - черные круги, волосы торчком. Смотрит на себя в зеркало и говорит: - Я тебя не знаю, но я тебя накрашу.");
INSERT INTO chat_shutnik VALUES("245","Реальная история (вот так анекдоты и размножаются). Приятели заказали другу на день рождения семь девочек по вызову (ну процветает разврат среди молодежи, процветает!). Отметили отлично. На следующий день стадия \"разбор полета\". Довольный именниник благодарит: - Да, спасибо, все было классно, только я всего пятерых смог, но я же здорово пьяный был. А вот если бы трезвый был, то я бы, конечно, больше смог...\n- Знаешь, если б ты был трезвый... ТЫ БЫ НИ ОДНУ ИЗ НИХ НЕ СТАЛ!!!");
INSERT INTO chat_shutnik VALUES("246","Лукашенко перед вылетом в Москву на встречу с Путиным: «Я рад, что госпожа Райс, пролетая над Белоруссией, могла убедиться, что терроризма в ней нет. Никто ракеты по ней не выпустил». А руки так чесались...");
INSERT INTO chat_shutnik VALUES("247","Пожелание врагу: -Чтобы я увидел тебя на костылях, а ты меня одним глазом!");
INSERT INTO chat_shutnik VALUES("248","Тесть и зять работают на одной шахте, но в разные смены. Видятся только когда одного поднимают, а другого опускают в забой. Как-то раз происходит следущее... Поравнявшись в своих подъемниках и увидев друг друга, зять крутит пальцем около виска. Тесть, в ответ, крутит обеими пальцами у своих висков. Зять - резко сгибает одну руку в локте, а другой перекрещивает согнутую. Тесть - вытягивает одну руку, а другой бьет себя по ней в области плеча и показывает на свой зад. Народ - в шоке... Старый шахтер говорит зятю: - Что же ты со своим тестем никак общий язык не найдешь? Я его столько лет знаю - мужик просто замечательный! - Да вы ничего не поняли! - отвечает зять, - У нас великолепные отношения! Я его спросил знаком: \"Моя дура дома?\" - он ответил знаком: \"Обе - дома\". Дальше я его спросил: \"0,5 есть?\", на что он ответил: \"Есть 0,7 и стоит за унитазом!\" Вообще-то, этот анекдот надо показывать.");
INSERT INTO chat_shutnik VALUES("249","Просыпаются утром отец и сын.\n- А что, сынок, неплохо бы нам с тобой сейчас принять по сто грамм.\n- Дело говоришь, батя, дело. Сбегал сын в магазин, принес водки. Посидели, выпили.\n- Hу что, сынок, неплохо бы нам еще по-немногу? - Дело говоришь, батя, дело! Сбегал, еще принес. Выпили.\n- Hу что, сынок, теперь и поработать можно? - Hу, батя, ты как выпьешь - такую фигню нести начинешь!");
INSERT INTO chat_shutnik VALUES("250","С того времени, как нашего соседа сняли с должности генерального директора, он растерял половину своих друзей.\n- А как та... вторая половина? - Они еще не знают об его отставке.");
INSERT INTO chat_shutnik VALUES("251","Адвокат(А): - Итак, утром,25 июля, Вы шли со своей фермы по направлению к пастбищу? Свидетель(С): - Да. А: - Значит, Вы прошли всего в нескольких метрах от водоема с утками? С: - Да. А: - Заметили ли Вы что-то необычное? С: - Да. (Молчит) А: - Могли бы Вы сообщить суду, ЧТО Вы видели? С.\n- Я увидел Джорджа. А: - Вы увидели Джорджа.....обвиняемого в данном случае? С: - Да. А: - Могли бы Вы сказать суду, что Джордж...э.э.э.э....делал в это время? С: - Да. (Молчит) А: - Ну, ну, так что же он делал? С: - Ну....он засунул свою...э.э.э.... штучку....в одну из уток. А: - Свою \"штучку\" ? С: - Ну....Вы знаете...ну, штучку....свой ху......ну....свой пенис. А: - Итак, Вы проходили возле пруда, было уже светло, Вы были совершенно трезвы, у Вас хорошее зрение и Вы все это видели совершенно четко? С: - Да. А: - Сказали ли Вы что-нибудь Джорджу? С: - Разумеется! А: - И ЧТО Вы ему сказали?!! С: - Доброе утро, Джордж.");
INSERT INTO chat_shutnik VALUES("252","Один чудак в гостинице спрашивает номер, ему отвечают: \"Нет, мол, номеров\". А он ну очень упрашивает - ну хоть каморку какую-нибудь. Ему и говорят: - Ну ладно, есть один люкс, но у него слава дурная, там уже восемь человек повесилось. Чудак в ответ: - Я не суеверный. Отводят его в номер, показывают ему все, а он спрашивает: - А как, мол, повесились-то? - Все вот на этой дверной ручке.\n- Не может быть! - Да вот, уж, смогли. Утром уборщица открывает дверь - мужик висит на ручке двери, мертвый.\n- Елки зеленые, еще один любопытный.");
INSERT INTO chat_shutnik VALUES("253","Звезда Голливуда говорит своей приятельнице: - Я купила тебе в подарок книгу. По-моему, это учебник танцев под названием \"Оливер Твист\".");
INSERT INTO chat_shutnik VALUES("254","Пришел наркоман к стоматологу и говорит: - Доктор, вырвите мне зуб.\n- Вам под местным или под общим наркозом? - Что, одурел!? Под общим, конечно! И так 32 раза...");
INSERT INTO chat_shutnik VALUES("255","Песня пилота самолета МИГ, занимающегося сексом с девушкой за штурвалом самолета: Чем дорожу, чем рискую на Свете я, МИГом одним, только МИГом одним...");
INSERT INTO chat_shutnik VALUES("256","Конец мая. Училка на последнем в учебном году классном часе: - Дети, что для вас тpуднее всего было в 3-м классе? - Объяснять пpодавщице для кого покупается водка!!!");
INSERT INTO chat_shutnik VALUES("257","В троллейбусе едут два друга. Один рассказывает анекдот другому: - Ты, говорит, знаешь, почему менты всегда по трое ходят? Один имеет читать, второй писать, а третий следит за этими интеллектуалами! Тут с задней площадки протискиваются два мента. Предъявите, мол, документы и все такое... Один берет паспорт и говорит другому: - Вась, записывай...");
INSERT INTO chat_shutnik VALUES("258","Волк поймал Красную Шапочку в лесу.\n- Я тебя съем, - говорит. Красная Шапочка: - Не надо меня есть, я еще такая маленькая. Лучше вые@и меня. Волк подумал, подумал: - Ну ладно, говорит, только ты меня обеими руками за уши держи.\n- А у тебя там что, эрогенные зоны? - Да нет, просто знаю я вас, таких... Вечно по карманам шарите.");
INSERT INTO chat_shutnik VALUES("259","Мне сказали, Что от веснушек можно избавиться, если опустить лицо в муравейник на 5-6 минут.");
INSERT INTO chat_shutnik VALUES("260","- Ну, что? Опять вчера дома выволочка была? - Не то слово. На порог не пустила. В подъезде ночевал.\n- Чудак. Ты, прежде чем позвонить, разденься догола. А как она дверь откроет, бросай туда свои шмотки. Голого не оставит в подъезде. На другой день.\n- Ну как, пригодился мой совет? - Все сделал, как ты говорил. Двери открылись, я бельишко туда - шварк! Тут она чужим голосом громко говорит: \"Осторожно, двери закрываются. Следующая станция \"Маяковская\".");
INSERT INTO chat_shutnik VALUES("261","Ноги позволяют мужчине идти, а женщине еще и продвигаться.");
INSERT INTO chat_shutnik VALUES("262","- Девушки 90-60-90! Hе ищите пpиключений на свои 90!");
INSERT INTO chat_shutnik VALUES("263","Преподаватель автошколы спрашивает у студентов, сколько дел может одновременно делать водитель? Они начали перечислять: - 2 дела- управлять автомобилем и говорить по мобильнику.\n- 3 дела- управлять автомобилем, говорить по мобильнику и слушать музыку.\n- 4 дела- управлять автомобилем, говорить по мобильнику, слушать музыку и жевать бутерброд.\n- 5 дел- управлять автомобилем, говорить по мобильнику, слушать музыку, жевать бутерброд и отливать в памперсы... Ну, вроде все! Преподаватель: - Нет! Вы забыли еще одно дело.\n- Какое?! - Давить пешеходов!");
INSERT INTO chat_shutnik VALUES("264","Три проститутки сидят в баре, и одна жалуется остальным: - Сегодня неудачный день... Я заработала всего $100 -взяла в рот 4 раза по $50, а половину забрал сутенер... Другая отвечает ей: - Это еще ничего - я сегодня заработала $50 - всего 2 минета по $50, и тоже половину сутенеру... Сидящая рядом старая проститутка заявляет: - Вы не знаете, что такое плохая жизнь... Во времена Великой Депрессии мне иной раз приходилось по 10 раз в день делать минет бесплатно, только для того, чтобы иметь в пищу что-нибудь горячее...");
INSERT INTO chat_shutnik VALUES("265","Объявление о приеме на работу. Условия: Два дня работаешь, пять лет сидишь, зарплата сдельная.");
INSERT INTO chat_shutnik VALUES("266","Один умелец сделал часы, которые при произнесении матерного слова спешат на одну минуту. Для испытания повесили часы в детском саду, в училище, и в воинской части. Через месяц решили проверить результаты эксперимента. В детском саду часы ушли вперед на 10 минут, в училище - на полчаса. Пришли в воинскую часть - часов нет! Спросили у дневального: - Куда часы подевались? - Какие часы?! А... этот вентилятор командир приказал снять на следующий же день.");
INSERT INTO chat_shutnik VALUES("267","В 30-е годы мужик заполняет анкету и дошел до вопроса \"Как спите с женой ?\" Что писать? Напишешь \"слева\" - пришьют левый уклон. \"Справа\" - правый уклон. \"Сверху\" - возвышение над массами. \"Снизу\" - идешь на поводу у масс. Написал: \"сплю отдельно, занимаюсь онанизмом\". Ему дали 10 лет \"за кулацкий уклон и растрату семенного фонда\".");
INSERT INTO chat_shutnik VALUES("268","Если, проснувшись с глубокого похмелья, вы взглянули в зеркало и никого там не увидели - значит, вы стали просто неотразимы.");
INSERT INTO chat_shutnik VALUES("269","- Почему в Люксембурге не любят играть в футбол? - Очень неудобная игра: посильнее ударил по мячу и за ним надо бежать то в Бельгию, то в Германию, а то и во Францию... jonas");
INSERT INTO chat_shutnik VALUES("270","Человек приходит к директору завода и спрашивает: - Вам нужен начальник отдела кадров? - Нет.\n- А зачем вы его тогда держите?");
INSERT INTO chat_shutnik VALUES("271","Hовый русский на \"Мерседесе\" на огромной скорости въезжает в небольшой городок. Его тут же останавливает инспектор и говорит: - С вас штраф за превышение скорости свыше 30 километров в час в размере 500 рублей.\n- Hа тебе тысячу без сдачи - я на такой же скорости хочу покинуть ваш гнусный городишко!");
INSERT INTO chat_shutnik VALUES("272","Певичка была заранее уверена в своем успехе: - Пусть только попробуют плохо аплодировать - я буду петь песни о Сталине!");
INSERT INTO chat_shutnik VALUES("273","- Папа, мы евреи? - Нет, сынок.\n- А когда будем?!");
INSERT INTO chat_shutnik VALUES("274","- Дети! Я сейчас проходила мимо столовой и видела на полу булку хлеба. Кто-то бросил хлеб на пол и играл им в футбол. А вы знаете, сколько он стоит?! Да он полторы штуки стоит! Довели страну, реформаторы хреновы!");
INSERT INTO chat_shutnik VALUES("275","Пожилая женщина сделала молодежную стрижку и спрашивает мужа: - Дорогой, правда, я теперь не похожа на старуху? - Да, ты теперь похожа на старика.");
INSERT INTO chat_shutnik VALUES("276","Российский политик перед выборами: - Мой конкурент, находясь при власти, бессовестно обворовывал вас все эти годы! Все, о чем я вас прошу сегодня , это дать мне шанс!");
INSERT INTO chat_shutnik VALUES("277","В зоопарк сам прилетел попугай. Хочу, говорит, у вас поселиться. Ну, звери его обступили, говорят, рассказывай, как случилось такое, чтоб кто-то сам явился жить в зоопарк. Попугай говорит, это долгая история. Я 10 лет жил у одного дрессировщика. Мы выступали в разных цирках с большим успехом, потому что я умел имитировать самые разные голоса и звуки. Я подражал паровозному гудку, клаксонам машин, тиканью ходиков, крикам льва, мурлыканью кота, воплям обезьян... Но потом я состарился, и мне стало уже трудно заниматься этим ремеслом. Контракты прекратились. Нам просто стало нечего есть. И однажды вечером мой хозяин затопил печь, посмотрел на меня долгим взглядом и сказал: - Ну чего, братан, сымитируй крик фазана.");
INSERT INTO chat_shutnik VALUES("278","Телефонный звонок.\n- Позовите, пожалуйста, Рабиновича.\n- Его нет.\n- Он на работе ? - Нет.\n- В командировке ? - Нет.\n- В отпуску ? - Нет.\n- Я вас правильно понял ? - Да !");
INSERT INTO chat_shutnik VALUES("279","Приводит Дочь(Д) Нового Русского(НР) домой жениха-Выпускника семинарии.(В) (НР)с ним наедине: (НР)-Ты знаешь,моя дочь любит каждые три месяца отдыхать за границей!Что ты будешь делать? (В)-Боженька поможет. (НР)-А шубы она меняет как перчатки!Что будешь делать? (В)-Боженька поможет. (НР)-И машины меняет одну за другой...Что будешь делать? (В)-Боженька поможет. Короче на все вопросы отвечал-Боженька поможет! После его ухода,дочь спрашивает отца: (Д)-Пап,ну как он тебе? (НР)-Да так себе...Но то,что он меня Боженькой называет,мне нравится!!! :)");
INSERT INTO chat_shutnik VALUES("280","Троллейбус. Контроллер: - Ваш билет.\n- А ты кто такой? - Контроллер. [Громко, на весь троллейбус] - А! Контроллер! [Все щелкают компостерами]");
INSERT INTO chat_shutnik VALUES("281","- Вчера на меня напал бандит, но я даже не заявил в полицию.\n- Почему же? - Он обшарил все мои карманы, вздохнул и дал мне доллар.");
INSERT INTO chat_shutnik VALUES("282","У окулиста: - Доктор, у меня после свадьбы начались проблемы со зрением: я не вижу денег !");
INSERT INTO chat_shutnik VALUES("283","Молодая девушка в день своего совершеннолетия получает нарядное вечернее платье.\n- Мама, что это за материал? - Разве ты не видишь, это шелк.\n- Смотри, какая прелесть. И это все от маленького, никудышного червячка? - Как тебе не стыдно называть так своего собственного отца!");
INSERT INTO chat_shutnik VALUES("284","Из сообщений \"Дорожного патруля\". В лесопарковой зоне Михино было найдено тело с документами на имя гражданина К. Неожиданное осложнение в работу прибывших на место происшествия сотрудников милиции внесло то обстоятельство, что сам гражданин К. решительно отказался признавать свое тело и потребовал вызвать для опознания супругу, находящуюся в данное время в служебной командировке.");
INSERT INTO chat_shutnik VALUES("285","Социологический опрос: \"Как военное положение влияет на семейную жизнь?\" Самый популярный ответ: \"Очень хорошо! а) Жена в противогазе молчит все время. б) Лица жены я под противогазом не вижу. в) А если находясь в постели дырочку в баллоне заткнуть, то она даже пошевелиться может\".");
INSERT INTO chat_shutnik VALUES("286","- Папа! А почему бабушка по огороду бегает зигзагами? - Кому бабушка, а кому и теща. Дай-ка, сынок, вторую обойму!");
INSERT INTO chat_shutnik VALUES("287","Мyж c женой загоpают на пляже. Мyж, щyплый человек небольшого pоcта заметил, что его жена не отpывает глаз от cидевшего неподалекy кpyпного, мycкyлиcтого кpаcавца. Hе выдеpжав, мyж обpащаетcя к жене: - Зpя ты пялишьcя на него, доpогая. Вcпомни - y нашего cоcеда гаpаж на два \"кадиллака\", а он деpжит там велоcипед.");
INSERT INTO chat_shutnik VALUES("288","ртист пригласил на спектакль своего друга. После спектакля он сидит в гримерной, вытирает грим. Артист: - Ну что, как спектакль? Друг: - Чудесно! Все актеры играли как боги, сцена слилась с залом, просто полное проникновение, но ты... то слова забудешь, то на бабу в зале засмотришься.\n- Угу... А музыка тебе как? - Прекрасно, чувствуется, что композитор чувствовал пьесу, от драматических актеров не ожидал такого вокального таланта, правда, ты то не в такт запоешь, то петуха пустишь.\n- Умм... А декорации понравились? - Бесподобно!!! На всех актерах костюмы с иголочки, ну как в прошлом веке, правда, у тебя пуговица оторвана, ботинки нечишены, не понимаю.\n- Ага... а что, жена-то твоя все блядует?");
INSERT INTO chat_shutnik VALUES("289","Бог создал три качества - честность, ум и партийность, - но никому не дал больше двух. Так что если человек умный и честный, то он беспартийный. Если он честный и партийный, то он не умный. А если он умный и партийный, то он нечестный.");
INSERT INTO chat_shutnik VALUES("290","А вы пробовали принять слабительное одновременно со снот- ворным? Интересный эффект получается.");
INSERT INTO chat_shutnik VALUES("291","Журналист спрашивает у Карпова: - Ваше мнение о Deep Blue? - Душно и тесно.");
INSERT INTO chat_shutnik VALUES("292","Новый русский обсуждает с архитектором проект новой виллы.\n- Кароче, а тут рядом с сауной - чтобы три бассейна... один с горячей водой, другой с холодной, а третий - без воды! Архитектор: - А зачем вам бассейн без воды??? ж:-[] НР: - Ну ты прикинь, а вдруг у меня в сауне будут гости, которые плавать не умеют?");
INSERT INTO chat_shutnik VALUES("293","Пpишла весна. Зазвенела капель. Запели птички. Двоpник Hикодим вышел на улицу. Соpвавшаяся с кpыши сосулька убила двоpника Hикодима... Пpозектоp в моpге задумался над гpафой о пpичине смеpти и, улыбнувшись, написал: \"Весна пpишла\".");
INSERT INTO chat_shutnik VALUES("294","Сколько нужно ирландцев, чтобы закрутить лампочку? - Двое. Один держит лампочку, а второй пьёт виски, чтобы комната пошла кругом.");
INSERT INTO chat_shutnik VALUES("295","Судят грузина за изнасилование мальчика... Судья: - Расскажытэ, как это било? - Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый, розовый... Эх! Судья: - Эх! Расскажытэ еше раз, как это било...\n- Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый... розовый, розовый... Эх! Судья: - Суд удаляется на совещание! Через несколько минут...\n- Народный суд города Тбилиси постановил! Солнце желтый-желтый - продолжать светить. Мальчикам с розовой попкой по берегу синий-синий моря - нэ ходить, а подсудимый Габелия - па-автарите, пожалуйста, свой рассказ!");
INSERT INTO chat_shutnik VALUES("296","Сидя в джипе, бывший не в духе сержант приказал водителю: - Мне что-то не нравятся физиономии вон тех солдат около лужи. Ну-ка дай по газам и обдай их водой. Водитель послушно нажал на педаль газа и направил джип на лужу, в которую автомобиль буквально нырнул, так что на поверхности остались только головы сержанта и водителя. Это была канава, доверху наполнившаяся водой.");
INSERT INTO chat_shutnik VALUES("297","Один норвежец решил разводить птицу, купил 500 цыплят и... закопал их у себя в саду. Результат: все цыплята сдохли. Тогда он заказал еще 500 цыплят, посадил их в грядку головками наружу, но цыплята все равно сдохли. Норвежец написал письмо в Осло в тамошний университет, подробно описал свою проблему и попросил совета. Через несколько недель из Осло пришла телеграмма: \"Просьба прислать образцы почвы\".");
INSERT INTO chat_shutnik VALUES("298","Винни-Пух спрашивает у Пятачка, кем был его дед.\n- Мой дед был отбивной.\n- А кем был твой отец? - Мой отец был шашлыком! - Слушай, Пяточок, а кем ты хочешь стать? - Да вот, космонавтом...\n- А чё так грустно? - Да боюсь, в тюбик не влезу...");
INSERT INTO chat_shutnik VALUES("299","Врач говорит пациенту, очнувшемуся от наркоза: - Операцию вы перенесли хорошо, а вот перед ней вы вели себя просто невозможно: вырывались, кричали... А ваш знакомый с соседней койки вел себя еще хуже! - Еще бы! Ведь нас в клинику послали окна мыть.");
INSERT INTO chat_shutnik VALUES("300","Мой компьютер постоянно обыгрывает меня в шахматы. Зато я всегда побеждаю его в боксерском поединке!");
INSERT INTO chat_shutnik VALUES("301","- Что такое Советская власть? - спрашивает сын программиста у своего папы.\n- Это сынок, такая жутко глючная программа: пять лет ее устанавливают, затем 50 лет перезагружают компьютер, а потом оказывается, что вся система полетела и ее менять надо! Голем");
INSERT INTO chat_shutnik VALUES("302","Стоит наркоман, косяк забивает ( в ладони левой руки анаша). Подбегает девочка: - Дяденька, сколько время? Наркоман молчит. Девочка снова: - Дяденька, сколько время? Молчит. Девочка: - Дяденька, дяденька, ну сколько время? Hаркоман переворачивет ладонь и смотрит на часы: - Пи##ец тебе, девочка.");
INSERT INTO chat_shutnik VALUES("303","У речки с удочками сидят Счастливчик и Неудачник. У одного, естественно, клюет, у другого - нет. Неудачник интересуется: - На что ловишь? - На червя,- отвечает Счастливчик,- хочешь, бери! Вынимая жирного червя, тот спрашивает: - Ты где берешь таких красавцев? - Все очень просто. Отвожу от розетки провода и втыкаю их в огороде на грядке. Черви ползут как миленькие, собирай - не хочу. На следующий день Неудачник приходит весь в синяках.\n- Что с тобой? - изумился Счастливчик.\n- Да мало мне показалось двести двадцать вольт. Вышел в поле, там, где ЛЭП проложена, закинул провода, воткнул в землю и жду, когда черви появятся. А тут вылезли шахтеры и так морду набилиЄ");
INSERT INTO chat_shutnik VALUES("304","Опять же к доктору приходит женщина : - Доктор, у Вас есть 100%-ное противозачаточное средство. Доктор:(достает какие-то таблетки) - Вот, пожалуйста.\n- А это 100%-ное ? - Hет, 90.\n- А мне нужно 100. Доктор:(достает таблетки побольше) - Вот.\n- Это 100 ? - Hет, 95.\n- Hо мне-то нужно 100 ! Доктор: - Подождите. (достает таблетку величиной с ладонь) - Вот.\n- Hу это-то хоть 100 ? - Hет, 97.\n- Я вижу, Вы меня не понимаете... Доктор: - Hу, тогда... (двумя руками достает из шкафа таблетку величиной с автомобильное колесо) ... вот ! - О-о-о ! 8-0 Hу это наверно все 100...\n- Hет, Вы знаете, это 99.\n- Hо что-же мне делать ? Доктор: - Я кажется знаю... (долго копается в столе и наконец достает маленький металлический шарик) ...Вот что Вам нужно ! - И это 100%-ное ??? Доктор:(облегченно) - Да.\n- А как-же его использовать ??? - Держать между ногами во время полового акта !");
INSERT INTO chat_shutnik VALUES("305","Он был таким интеллигентным. Маму называл на вы.\n- Мама, вы что, охренели?");
INSERT INTO chat_shutnik VALUES("306","Если ваша жена хочет научиться водить автомобиль, самое главное - не стоять у нее на пути.");
INSERT INTO chat_shutnik VALUES("307","- А вот я тёще на день рождения подарил стиралку и сушилку! - Наверно, кучу денег выкинул? - Да не, всего баксов за 18! - ??????????? Это что ж за техника такая? - Тазик и полотенце!");
INSERT INTO chat_shutnik VALUES("308","Во время войсковых маневров начальник артиллерии замечает, что одно из орудий не стреляет. Он вызывает по рации командира батареи и требует доложить, в чем дело.\n- Дело в том, - докладывает тот, - что орудийный расчет так замаскировал свою пушку, что теперь не может ее найти.");
INSERT INTO chat_shutnik VALUES("309","- Когда читаю медицинскую энциклопедию, я обнаруживаю у себя все болезни.\n- Это бывает. Когда я читаю уголовный кодекс, то на каждой странице чувствую себя за решеткой.");
INSERT INTO chat_shutnik VALUES("310","Один мужик видя, что его сосед играет в карты со своей собакой восхищенно говорит ему: - Какая у Вас умная собака - Какая же она умная, видишь хвостом виляет, значит ей хорошая карта пришла.");
INSERT INTO chat_shutnik VALUES("311","Играют в карты Кощей Бессмертный, Баба Яга, Умный Мент и Глупый Мент. На столе лежит куча денег. Внезапно гаснет свет. Когда свет зажигается, денег нет. Вопрос: Кто украл деньги? Ответ: Глупый Мент. Вопрос: Почему? Ответ: Потому что все остальные - вымышленные персонажи.");
INSERT INTO chat_shutnik VALUES("312","- Я всегда любил слушать хорошие анекдоты, но быстро их забывал. Поэтому я стал их придумывать сам. Получилось совсем не хуже, и даже лучше.\n- Почему ты так решил? - Потому что не только я, но и все мои знакомые, которые слышали эти анекдоты, тоже их быстро забывают!");
INSERT INTO chat_shutnik VALUES("313","Из отчета слyжб безопасности \"... по поводy взлома китайцами сеpвеpа Пентагона\": ....... 1) Каждый китаец попpобовал один паpоль. 2) Каждый втоpой паpоль был \"maodzedun\" 3) Hа -й попытке сеpвеp согласился что y него паpоль \"maodzedun\"");
INSERT INTO chat_shutnik VALUES("314","Звонок в двеpь. Hа поpоге Дед Моpоз. Маленький мальчик кpичит: - Здpавствyй, Дедyшка Моpоз! Ты подаpки... Дед Моpоз: - Hе тpанди, пацан! Штопоp есть?!");
INSERT INTO chat_shutnik VALUES("315","Муж возвращается из командировки и видит у подъезда припаркованный \"Мерседес-600\". Заходит домой. Hа вешалке - красный пиджак, на столе - радиотелефон, в постели - жена с каким-то мужиком. Муж толкает мужика в бок: - Ты чего здесь делаешь? - Как чего? Hе видишь - новых русских делаем.");
INSERT INTO chat_shutnik VALUES("316","У него было трудное детство - до пяти лет, он был уверен, что его зовут: -\"Идитынах%й\"");
INSERT INTO chat_shutnik VALUES("317","Анекдот для москвичей: А раньше \"Лысый в кепке\" означало: \"Ленин\"...");
INSERT INTO chat_shutnik VALUES("318","Приходит пролетарий домой и, увидев свою жену с соседом, гово- рит: \"Вот вы тут глупостями занимаетесь, а в магазине, между про- чим, колбасу дают!\"");
INSERT INTO chat_shutnik VALUES("319","У фотографа: - Товарищ фотограф, это не моя фотография.\n- Как же не ваша, а, по-моему, похоже получилось.\n- А вот смотрите, нос же не мой.\n- Да, как будто не ваш.\n- А эта бородавка! У меня нет никакой бородавки.\n- Гм, действительно нет.\n- И потом, этот лежит в гробу, а я еще живой.");
INSERT INTO chat_shutnik VALUES("320","Женская мысль давно хотела попасть в мужскую голову... И вот она наконец-то туда залетает, счастливая.. А там никого нет. Пусто. Она смотрит по сторонам и вдалека видит летящую мужскую мысль. Женская мысль зовет мужскую, та подлетает... Женская мысль говорит: - Я так хотела сюда попасть.... А тут нет никого? Мужская мысль ей отвечает: - Ах, дурочка! Мы уже все внизу тусуемся...!");
INSERT INTO chat_shutnik VALUES("321","Инженер, парикмахер и экономист путешествовали по сельской местности. Устав, они остановились в маленькой харчевне.\n- У меня только две комнаты, - извинился хозяин.\n- Одному из вас придется спать в амбаре. Как водится, в амбар добровольно подался инженер. Вскоре уже засыпавших его товарищей разбудил стук. За дверью стоял инженер: - В амбаре корова. А я - индуист и по своей вере не имею права спать рядом со священным животным, - объяснил инженер. В амбар направился парикмахер. Не успели путники заснуть, в дверь снова постучали. За дверью стоял парикмахер: - Там свинья. Я, как еврей, не могу спать рядом с нечистым животным. Не оставалось ничего другого, как пойти в амбар экономисту. Под утро снова раздался стук. Удивленные приятели увидели за дверью корову и свинью.");
INSERT INTO chat_shutnik VALUES("322","В больнице две дамы говоpят о только что умеpшей подpуге: - Хотелось бы мне иметь ее ноги - у нее были пpелестные ноги! Жалко - тепеpь пpопадут...");
INSERT INTO chat_shutnik VALUES("323","Разговаривают два алкаша: - Я намедни пить бросил...\n- ??? - А вот куда - не помню!..");
INSERT INTO chat_shutnik VALUES("324","Осень, сыро, холодно. В пивную заходит оборванец и просит налить кружечку похмелиться. Бармен говорит жалостливо: - Ты бы лучше себе носки потеплее купил.\n- На хрена? Здоровье дороже!");
INSERT INTO chat_shutnik VALUES("325","Корсиканец с гордостью говорит приезжему: - У нас воруют так, что во многих местах железная дорога проложена кольцами.\n- А зачем? - Чтобы машинист мог убедиться, что все вагоны на месте.");
INSERT INTO chat_shutnik VALUES("326","Как известно, спартанцы учили детей плавать, попросту сбрасывая их со скалы в море. Интересно, если начать сбрасывать детей с самолета, хоть некоторые из них научатся летать?");
INSERT INTO chat_shutnik VALUES("327","Уход за волосами - смерть лысого человека.");
INSERT INTO chat_shutnik VALUES("328","Взвод морских пехотинцев пришол в кинотеaтр нa просмотр голивудского боевикa. В сaмый кульминaционный момент героиня зaстреливaет своего любовникa и трaгическим голосом вопрошaет: - Hу чтоже мне теперь делaть ?! Kомaндный голос из зaлa: - Осмотреть оружие и отойти зa огневой рубеж!");
INSERT INTO chat_shutnik VALUES("329","- Мадам, вы, очевидно, принимаете меня за дурака? - Что вы, я никогда не сужу о людях по первому впечатлению.");
INSERT INTO chat_shutnik VALUES("330","Как и полагается, у сексопатолога: - Доктор, Вы знаете, у меня не стоит...\n- А Вы, батенька, сюда трахаться, что ли, пришли ?!.");
INSERT INTO chat_shutnik VALUES("331","Что делают чукчи, когда холодно? Закрывают в юрту дверь и садятся вокруг свечки. Что делают чукчи, когда очень-очень холодно? Они ее зажигают.");
INSERT INTO chat_shutnik VALUES("332","Два человека выходят на улицу: - Какая ужасная погода, снег с дождем! - Подонки, что хотят, то и творят...");
INSERT INTO chat_shutnik VALUES("333","Получилось так, что две женщины отсидели в тюрьме 10 лет. В одной камере. Выпустили их в один день. Вышли за ворота, одной надо направо, другой налево. Hу, обнялись, расцеловались. Одна другой: - Ладно, остальное я тебе завтра по телефону расскажу . . .");
INSERT INTO chat_shutnik VALUES("334","Приходят к Сталину украинские националисты и говорят, что надо, мол, составить украинско-русский словарь. Сталин закурил трубку, задумался: - Словарь, говорите, ну а как по-украински будет рука? - Рука.\n- Ну а как нога? - Нога.\n- Ну а как голова? - Голова.\n- А как будет жопа? - Срака.\n- Так что же это, из-за одного слова словарь составлять!");
INSERT INTO chat_shutnik VALUES("335","- Ты потребовала бы развод, если бы узнала, что муж тебе изменяет? - Ты что?! За такое его еще и награждать?...");
INSERT INTO chat_shutnik VALUES("336","В церкви большой переполох. Скоро приедет архиепископ с проверкой. Подбегает к пастору монашка и грит: - Святой отец, мне кажется, что ваши стулья надо заново покрыть лаком. Они совсем облупились! - Не ВАШИ, а НАШИ, сестра - здесь ничего нет личного, а только НАШЕ, понятно!? На следущий день опять эта монашка грит пастору: - Святой отец, надо бы ваш потолок заново побелить, а то он уже черный весь! - Дочь моя, не ВАШ, а НАШ потолок, я же вам говорил...! И вот приехал архиепископ. Ходит он с пастором, смотрит вокруг, всем вроде доволен. Тут подбегает монашка и грит пастору: - Святой отец, я нашла ваши часы...\n- Очень мило, сестра, и где же они были? - Под НАШЕЙ кроватью...!!!!");
INSERT INTO chat_shutnik VALUES("337","Свеpхмодный молодой человек обpащается к поpтному: - Вы могли бы сшить мне костюм цвета кофе с кипящим молоком ? - С сахаpом или без ? - спокойно осведомился поpтной. ;););)");
INSERT INTO chat_shutnik VALUES("338","Война. В окопе сидят два солдата и раскуриваются, на них едет танк. Один солдат говорит другому: \"Вань бросай гранату\". Тот говорит: \"Давай сделаем по напасу и тогда бросим\". Сделали по напасу. Первый говорит: \" Вань танк уже близко, давай бросай гранату\". А второй ему: \"Ну ты чего пристал, хочешь, бросай сам\". Подъезжает танк, из люка вываливается накуренный фашист и спрашивает: \"Ну вы чего, гранату то будете кидать?\" А те ему: \"Да что-то нам влом. А вы почему не стреляете?\" Фашисты: \" А мы ствол запаяли чтобы кумар не уходил!\"");
INSERT INTO chat_shutnik VALUES("339","Bесна. Половодье. Mаленький остpовок суши, на котоpом спасаются от воды Cобака и Заяц. A вода все пpибывает и пpибывает, вот-вот затопит остpовок... Чу... Bдали показалась лодка.\n- Уpа, мы спасены!!! - закpичал Заяц.\n- Это Дед Mазай!!! Cобака долго вглядывалась в даль, а потом гpустно сказала: - Hет, Заяц, это не Mазай, это ГEPACИM!!!");
INSERT INTO chat_shutnik VALUES("340","Маленький сын был с папой в зоопарке. У клетки со львом он спросил: - Папа, а если он съест кого-нибудь из нас, на каком номере автобуса мне ехать домой?");
INSERT INTO chat_shutnik VALUES("341","Директор коммерческого магазина учит молодую продавщицу: - Если покупатель спросит: \"Почем очки?\", ты скажи: \"Три штуки\". Если он не дрогнет, скажи: \"За оправу\". Если он опять не дрогнет, скажи: \"И за стекла три штуки\". И если опять не дрогнет, скажи: \"За каждое\".");
INSERT INTO chat_shutnik VALUES("342","- Доктор, я - импотент. И это у меня наследственное.");
INSERT INTO chat_shutnik VALUES("343","У миссис Смит умер муж и страховое агентство платит пятьдесят тысяч долларов бедной вдове. Она горько плачет: - Ах, я бы отдала треть этих денег, лишь бы он был опять со мной...");
INSERT INTO chat_shutnik VALUES("344","На приеме у психиатра.\n- Так, милейший, не волнуйтесь, на что жалуемся? - Не поверите, доктор! Иду я вчера с работы мимо нашего Вычислительного центра, и...\n- Ну-ну! - А там из всех окон Билл Гейтс выглядывает!!! - Так-так! - А по бокам... интерфейсы с кнопками стоят!!! - Да, батенька, пора вам перезагружаться. В новую рубашечку!");
INSERT INTO chat_shutnik VALUES("345","- Гарсон! Кажется, я хватил лишнего. Принесите чего-нибудь отрезвляющего.\n- Пожалуйста, счет.");
INSERT INTO chat_shutnik VALUES("346","Идет по Арбату новый русский в белом костюме с букетом белых роз, спешит на свидание. Погода прекрасная, настроение тоже. Вдруг он видит аппарат, типа автомата с газировкой, с надписью: \"Портим настроение. 1$\" \"Что мне может испортить настроение\" - подумал он и спокойно опустил доллар в автомат. И в тот же момент автомат выплюнул ему ложечку говна прямо на лацкан белого костюмчика. Расстроился новый русский: костюм испорчен, настроение тоже. Вдруг видит рядом стоит точно такой же автомат с надписью: \"Поднимаем настроение. 100$\" \"Что мне может поднять настроение\" - удивился он и быстренько опустил в автомат стольник. И в тот же момент на всех окружающих автомат выплюнул ведро говна...");
INSERT INTO chat_shutnik VALUES("347","Прочитав кое-что на женском форуме понял, что все русские мужчины - импотенты. Эти же козлы, все поголовно, изменяют своим женам.");
INSERT INTO chat_shutnik VALUES("348","Объявили вепсы войну Китаю! Китайцы присылают парламентеров. Идут по деревне, видят идет мужичек, спрашивают (вежливо): \"Вы вепс?\", тот говорит \"Конечно вепс\". Китайцы говорят: \"Вот вы (вепсы) нам войну объявили, а вы знаете, что нас китайцев больше миллиарда?\". Мужичок: \"Ой блин! Где-же мы вас хоронить-то будем?\"");
INSERT INTO chat_shutnik VALUES("349","Когда канцлер князь Горчаков сделал камер-юнкером Акинифьева (в жену которого был влюблен), Тютчев сказал: \"Князь Горчаков походит на древних жрецов, которые золотили рога своих жертв\".");
INSERT INTO chat_shutnik VALUES("350","Идет судебный процесс. Слон обвиняется в изнасиловании змеи. Судья-лев вызывает пострадавшую: - Расскажи, как это было.\n- Мне до сих пор трудно говорить... В общем, он силой заставил меня взять в рот свой детородный орган.\n- Понятно. Теперь послушаем свидетеля. Выходит свидетель - легкомысленная обезьяна: - О! А! Вы бы видели, какая была эрекция! А когда началось семяизвержение, я подумала, что наступил конец света.\n- Ясно. Обвиняемый, что ты можешь сказать в свою защиту? Слон: - Прежде всего, это был не оральный секс, а анальный. И не со змеей, а с обезьяной и по взаимному согласию. А змею я просто применил в качестве презерватива.");
INSERT INTO chat_shutnik VALUES("351","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("352","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("353","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на -ти долларовых машинах с расходом бензина литров на километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("354","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("355","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("356","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("357","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("358","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("359","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("360","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("361","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("362","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("363","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("364","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("365","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("366","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("367","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("368","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("369","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("370","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("371","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("372","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("373","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("374","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("375","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("376","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("377","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("378","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("379","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("380","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("381","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("382","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("383","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("384","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("385","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("386","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("387","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("388","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("389","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("390","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("391","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("392","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло :, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("393","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("394","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("395","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут , мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут , у дома крыша уже обваливается, мужик опять: - Hа меня ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("396","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("397","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("398","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("399","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("400","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - , товарищ СталинЄ - А сколько погибло? - , товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("401","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("402","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("403","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("404","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("405","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("406","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("407","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("408","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("409","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("410","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("411","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("412","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("413","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("414","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью -го, мы стpеляли в вас осенью -го. Мы pазвалили вашy стpанy в -м, обокpали в -м, надyли с двyмя Волгами в -м, с помощью МММ-ов pаскpyтили на бабки в -м, посылали ваших детей на бойню в -м, неплохо \"повтоpничали\" в -м, и полностью огpабили в -м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("415","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("416","Недавно на ж/д переезде № пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("417","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("418","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("419","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("420","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("421","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows , в. .)");
INSERT INTO chat_shutnik VALUES("422","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("423","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже -й день пьем.");
INSERT INTO chat_shutnik VALUES("424","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("425","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("426","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("427","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("428","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("429","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("430","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("431","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("432","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("433","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("434","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("435","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("436","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("437","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("438","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("439","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("440","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("441","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("442","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("443","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите метровкy?\" (HР): \"Минимyм за $.\"");
INSERT INTO chat_shutnik VALUES("444","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("445","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("446","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("447","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("448","- Pядовой Петpов - выйти из cтpоя - шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("449","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("450","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("451","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("452","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("453","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("454","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("455","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("456","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("457","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("458","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("459","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("460","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("461","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("462","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("463","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("464","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("465","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("466","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("467","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("468","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("469","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("470","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("471","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("472","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("473","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("474","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("475","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("476","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("477","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("478","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("479","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("480","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("481","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("482","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("483","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("484","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("485","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("486","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("487","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - км\". Он и на этот pаз сбавляет скоpость до км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость км\". Пpоклиная все на свете, он замедляется до км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("488","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("489","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("490","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("491","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было -ти.");
INSERT INTO chat_shutnik VALUES("492","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("493","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("494","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("495","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("496","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("497","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("498","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("499","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("500","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");



DROP TABLE IF EXISTS `chat_vopros`;

CREATE TABLE `chat_vopros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vopros` varchar(1024) NOT NULL,
  `otvet` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=502 DEFAULT CHARSET=utf8;

INSERT INTO chat_vopros VALUES("2","Сильная жара.","зной");
INSERT INTO chat_vopros VALUES("3","Пояс, территория с какими-либо общими признаками.","зона");
INSERT INTO chat_vopros VALUES("4","Медицинский инструмент для исследования внутренностей организма.","зонд");
INSERT INTO chat_vopros VALUES("5","Метеорологический воздушный шар.","зонд");
INSERT INTO chat_vopros VALUES("6","Крупный дикий лесной бык.","зубр");
INSERT INTO chat_vopros VALUES("7","Легкая рябь на водной поверхности.","зыбь");
INSERT INTO chat_vopros VALUES("8","Южный ветер, юг.","зюйд");
INSERT INTO chat_vopros VALUES("9","Поле, вспаханное с осени для посева яровых.","зябь");
INSERT INTO chat_vopros VALUES("10","Мысль, намерение, план.","идея");
INSERT INTO chat_vopros VALUES("11","Язык части евреев.","идиш");
INSERT INTO chat_vopros VALUES("12","Статуя, предмет, которому поклоняются как божеству.","идол");
INSERT INTO chat_vopros VALUES("13","Сушеные ягоды винограда.","изюм");
INSERT INTO chat_vopros VALUES("14","Жестокий древнеиудейский царь.","ирод");
INSERT INTO chat_vopros VALUES("15","Помесь лошади и осла.","ишак");
INSERT INTO chat_vopros VALUES("16","Осел или мул.","ишак");
INSERT INTO chat_vopros VALUES("17","Невысокая упрямая лошадь.","осел");
INSERT INTO chat_vopros VALUES("18","Исторически сложившаяся группа человечества с общими наследственными признаками.","раса");
INSERT INTO chat_vopros VALUES("19","Буква греческого алфавита.","йота");
INSERT INTO chat_vopros VALUES("20","Ледяная корка на снегу.","наст");
INSERT INTO chat_vopros VALUES("21","Представитель черной расы.","негр");
INSERT INTO chat_vopros VALUES("22","Углубление в стене, скате горы, берега.","ниша");
INSERT INTO chat_vopros VALUES("23","Число, деление на которое невозможно.","нуль");
INSERT INTO chat_vopros VALUES("24","В древнегреческой мифологии богиня победы.","ника");
INSERT INTO chat_vopros VALUES("25","Женское имя (греч. победительница).","ника");
INSERT INTO chat_vopros VALUES("26","Зазор между сопряженными поверхностями частей машин.","люфт");
INSERT INTO chat_vopros VALUES("27","Единица освещенности.","люкс");
INSERT INTO chat_vopros VALUES("28","Лучший номер в гостинице.","люкс");
INSERT INTO chat_vopros VALUES("29","Внутренняя часть коры липы, ивы.","лыко");
INSERT INTO chat_vopros VALUES("30","Материал для плетения лаптей.","лыко");
INSERT INTO chat_vopros VALUES("31","Буддийский монах.","лама");
INSERT INTO chat_vopros VALUES("32","Южноамериканское вьючное животное.","лама");
INSERT INTO chat_vopros VALUES("33","Южное вечнозеленое душистое растение, листья которого употребляются как специя.","лавр");
INSERT INTO chat_vopros VALUES("34","Стройное быстрое животное сем. оленей.","лань");
INSERT INTO chat_vopros VALUES("35","Ребро чеканной монеты.","гурт");
INSERT INTO chat_vopros VALUES("36","Стадо домашних животных.","гурт");
INSERT INTO chat_vopros VALUES("37","Духовный наставник, учитель.","гуру");
INSERT INTO chat_vopros VALUES("38","Туго натянутая веревка на судне, предохраняющая от падения людей за борт.","леер");
INSERT INTO chat_vopros VALUES("39","Ограждение вдоль бортов судна.","леер");
INSERT INTO chat_vopros VALUES("40","Край диска звезды, планеты.","лимб");
INSERT INTO chat_vopros VALUES("41","Кольцо с делениями для отсчета углов в угломерных инструментах.","лимб");
INSERT INTO chat_vopros VALUES("42","Пеньковый трос для корабельных снастей.","линь");
INSERT INTO chat_vopros VALUES("43","Пресноводная рыба сем. карповых с толстым слизистым телом.","линь");
INSERT INTO chat_vopros VALUES("44","Медоносное лиственное дерево.","липа");
INSERT INTO chat_vopros VALUES("45","Старинный струнный музыкальный инструмент.","лира");
INSERT INTO chat_vopros VALUES("46","Созвездие Северного полушария.","лира");
INSERT INTO chat_vopros VALUES("47","Денежная единица Италии, Турции.","лира");
INSERT INTO chat_vopros VALUES("48","Хитрая хищница с пушистым хвостом.","лиса");
INSERT INTO chat_vopros VALUES("49","Венгерский композитор, дирижер, создатель нового направления в пианизме, симфонии \"Орфей\", \"Прометей\".","лист");
INSERT INTO chat_vopros VALUES("50","Часть кроны дерева.","лист");
INSERT INTO chat_vopros VALUES("51","Метрическая единица объема.","литр");
INSERT INTO chat_vopros VALUES("52","Подъемник с кабиной для перемещения грузов, людей.","лифт");
INSERT INTO chat_vopros VALUES("53","Неправда, обман.","ложь");
INSERT INTO chat_vopros VALUES("54","Высший дворянский наследственный титул в Англии.","лорд");
INSERT INTO chat_vopros VALUES("55","Попугай, питающийся нектаром.","лори");
INSERT INTO chat_vopros VALUES("56","Самый крупный олень.","лось");
INSERT INTO chat_vopros VALUES("57","Крупный олень с широкими рогами.","лось");
INSERT INTO chat_vopros VALUES("58","Сохатый.","лось");
INSERT INTO chat_vopros VALUES("59","Ямка с водой.","лужа");
INSERT INTO chat_vopros VALUES("60","Корзинка бильярдного стола.","луза");
INSERT INTO chat_vopros VALUES("61","Увеличительное стекло.","лупа");
INSERT INTO chat_vopros VALUES("62","Наружное лекарство.","мазь");
INSERT INTO chat_vopros VALUES("63","Состав для натирания различных участков тела.","мазь");
INSERT INTO chat_vopros VALUES("64","Французский художник-импрессионист, картины \"Завтрак на траве\", \"Олимпия\".","мане");
INSERT INTO chat_vopros VALUES("65","Планета Солнечной системы.","марс");
INSERT INTO chat_vopros VALUES("66","В древнеримской мифологии бог войны.","марс");
INSERT INTO chat_vopros VALUES("67","Площадка на верху мачты для наблюдения над горизонтом.","марс");
INSERT INTO chat_vopros VALUES("68","Выдающаяся французская эстрадная певица.","пиаф");
INSERT INTO chat_vopros VALUES("69","Пресная сухая лепешка у евреев.","маца");
INSERT INTO chat_vopros VALUES("70","Береговой ориентир для судов.","маяк");
INSERT INTO chat_vopros VALUES("71","Непрозрачность воздуха из-за пыли, дыма, метели, сумерек.","мгла");
INSERT INTO chat_vopros VALUES("72","Ночной сумрак.","мгла");
INSERT INTO chat_vopros VALUES("73","Спортивное состязание.","матч");
INSERT INTO chat_vopros VALUES("74","Ковкий химический элемент красновато-желтого цвета.","медь");
INSERT INTO chat_vopros VALUES("75","Граница земельных участков.","межа");
INSERT INTO chat_vopros VALUES("76","Основная единица длины.","метр");
INSERT INTO chat_vopros VALUES("77","Английская морская единица длины = 1,852 км.","миля");
INSERT INTO chat_vopros VALUES("78","Английская единица длины = 1,60934 км.","миля");
INSERT INTO chat_vopros VALUES("79","Непрочная, быстропроходящая популярность.","мода");
INSERT INTO chat_vopros VALUES("80","Бабочка, вредитель вещей.","моль");
INSERT INTO chat_vopros VALUES("81","Единица количества вещества.","моль");
INSERT INTO chat_vopros VALUES("82","Французский художник-импрессионист, картина \"Кувшинки\".","моне");
INSERT INTO chat_vopros VALUES("83","Английский писатель, мастер новеллы, роман \"Луна и грош\".","моэм");
INSERT INTO chat_vopros VALUES("84","Плотная шелковая ткань, переливающаяся на свету.","муар");
INSERT INTO chat_vopros VALUES("85","В греческой мифологии одна из девяти муз, покровительница истории.","клио");
INSERT INTO chat_vopros VALUES("86","Надоедливое двукрылое насекомое.","муха");
INSERT INTO chat_vopros VALUES("87","Созвездие Южного полушария.","муха");
INSERT INTO chat_vopros VALUES("88","Моющее средство.","мыло");
INSERT INTO chat_vopros VALUES("89","Грызун, вредитель сельского хозяйства.","мышь");
INSERT INTO chat_vopros VALUES("90","Периферийное устройство компьютера.","мышь");
INSERT INTO chat_vopros VALUES("91","Нестабильная заряженная элементарная частица.","мюон");
INSERT INTO chat_vopros VALUES("92","Часть туши убитого животного, употребляемая в пищу.","мясо");
INSERT INTO chat_vopros VALUES("93","Основной источник белка в питании человека.","мясо");
INSERT INTO chat_vopros VALUES("94","Душистое лекарственное растение.","мята");
INSERT INTO chat_vopros VALUES("95","Выпуклая замкнутая плоская кривая без изломов.","овал");
INSERT INTO chat_vopros VALUES("96","Зодиакальное созвездие (март).","овен");
INSERT INTO chat_vopros VALUES("97","Домашнее жвачное животное.","овца");
INSERT INTO chat_vopros VALUES("98","Полевое земляное укрытие личного состава.","окоп");
INSERT INTO chat_vopros VALUES("99","Государство на Аравийском полуострове.","оман");
INSERT INTO chat_vopros VALUES("100","Буква греческого алфавита.","бета");
INSERT INTO chat_vopros VALUES("101","Областной центр, порт на реке Иртыш.","омск");
INSERT INTO chat_vopros VALUES("102","Аморфный драгоценный камень.","опал");
INSERT INTO chat_vopros VALUES("103","Накопленные знания и навыки.","опыт");
INSERT INTO chat_vopros VALUES("104","Научный эксперимент.","опыт");
INSERT INTO chat_vopros VALUES("105","Плод в скорлупе.","орех");
INSERT INTO chat_vopros VALUES("106","Роман Войнич .","овод");
INSERT INTO chat_vopros VALUES("107","Двукрылое насекомое, личинки которого паразитируют в теле животных.","овод");
INSERT INTO chat_vopros VALUES("108","Трудноискоренимый сорняк.","осот");
INSERT INTO chat_vopros VALUES("109","Крупная сорная колючая трава.","осот");
INSERT INTO chat_vopros VALUES("110","Способность воспринимать звуковые колебания.","слух");
INSERT INTO chat_vopros VALUES("111","Прибор для коррекции зрения.","очки");
INSERT INTO chat_vopros VALUES("112","Американские авиаконструкторы, братья, пионеры авиации.","райт");
INSERT INTO chat_vopros VALUES("113","Звание, чин.","ранг");
INSERT INTO chat_vopros VALUES("114","Кровососущее насекомое, паразит.","клоп");
INSERT INTO chat_vopros VALUES("115","Пьеса В.Маяковского .","клоп");
INSERT INTO chat_vopros VALUES("116","Связанные между собой плавучие предметы для перевозки грузов, людей.","плот");
INSERT INTO chat_vopros VALUES("117","Скрепленные между собой бревна для переправы.","плот");
INSERT INTO chat_vopros VALUES("118","Маршрут в один конец.","рейс");
INSERT INTO chat_vopros VALUES("119","Большой водный поток, текущий в русле.","река");
INSERT INTO chat_vopros VALUES("120","Порода короткошерстных кроликов.","рекс");
INSERT INTO chat_vopros VALUES("121","Способность человека говорить.","речь");
INSERT INTO chat_vopros VALUES("122","Металлический оклад на иконе.","риза");
INSERT INTO chat_vopros VALUES("123","Темп, скорость музыки.","ритм");
INSERT INTO chat_vopros VALUES("124","Твердые выросты на голове копытных животных.","рога");
INSERT INTO chat_vopros VALUES("125","Яровой злак.","рожь");
INSERT INTO chat_vopros VALUES("126","Декоративный душистый цветок с шипами на стебле.","роза");
INSERT INTO chat_vopros VALUES("127","Воплощенный актером образ.","роль");
INSERT INTO chat_vopros VALUES("128","Параллелограмм с равными сторонами.","ромб");
INSERT INTO chat_vopros VALUES("129","Река в Швейцарии и Франции.","рона");
INSERT INTO chat_vopros VALUES("130","Конденсат на почве, траве.","роса");
INSERT INTO chat_vopros VALUES("131","Английские полярные исследователи, дядя и племянник.","росс");
INSERT INTO chat_vopros VALUES("132","Японская национальная борьба.","сумо");
INSERT INTO chat_vopros VALUES("133","Небольшой лесной массив лиственных деревьев.","роща");
INSERT INTO chat_vopros VALUES("134","Минеральное полезное ископаемое, горная порода.","руда");
INSERT INTO chat_vopros VALUES("135","Поворотное устройство машин, судов.","руль");
INSERT INTO chat_vopros VALUES("136","Состриженная сплошным пластом шерсть овцы.","руно");
INSERT INTO chat_vopros VALUES("137","Водное позвоночное.","рыба");
INSERT INTO chat_vopros VALUES("138","Зодиакальное созвездие (февраль).","рыбы");
INSERT INTO chat_vopros VALUES("139","Способ бега лошади.","рысь");
INSERT INTO chat_vopros VALUES("140","Хищник с кисточками на ушах.","рысь");
INSERT INTO chat_vopros VALUES("141","Созвездие Северного полушария.","рысь");
INSERT INTO chat_vopros VALUES("142","Государство в Южной Америке.","перу");
INSERT INTO chat_vopros VALUES("143","Сладкая вязкая масса с орехами.","нуга");
INSERT INTO chat_vopros VALUES("144","Санитарка в лечебном учреждении.","няня");
INSERT INTO chat_vopros VALUES("145","Работница по уходу за детьми.","няня");
INSERT INTO chat_vopros VALUES("146","Тюремная кровать.","нары");
INSERT INTO chat_vopros VALUES("147","Немецкий писатель, мыслитель и естествоиспытатель, трагедия \"Фауст\".","гете");
INSERT INTO chat_vopros VALUES("148","Французский писатель, роман \"Отверженные\".","гюго");
INSERT INTO chat_vopros VALUES("149","Широкие массы населения.","низы");
INSERT INTO chat_vopros VALUES("150","Нижняя конечность человека.","нога");
INSERT INTO chat_vopros VALUES("151","Северный ветер, север.","норд");
INSERT INTO chat_vopros VALUES("152","Западный ветер, запад.","вест");
INSERT INTO chat_vopros VALUES("153","То же, что характер.","нрав");
INSERT INTO chat_vopros VALUES("154","Прием пищи в середине дня.","обед");
INSERT INTO chat_vopros VALUES("155","Резкий толчок.","удар");
INSERT INTO chat_vopros VALUES("156","Административно-территориальная единица в составе губернии в дореволюционной России.","уезд");
INSERT INTO chat_vopros VALUES("157","Чувство сильного страха.","ужас");
INSERT INTO chat_vopros VALUES("158","Вечерняя еда.","ужин");
INSERT INTO chat_vopros VALUES("159","Часть сбруи.","узда");
INSERT INTO chat_vopros VALUES("160","Постановление верховного органа власти, имеющее силу закона.","указ");
INSERT INTO chat_vopros VALUES("161","То же, что инъекция.","укол");
INSERT INTO chat_vopros VALUES("162","Упрек, порицание.","укор");
INSERT INTO chat_vopros VALUES("163","Военнослужащий легкой кавалерии в русской армии.","улан");
INSERT INTO chat_vopros VALUES("164","Количество пойманной рыбы, дичи.","улов");
INSERT INTO chat_vopros VALUES("165","Селение в Средней Азии и некоторых районах Сибири.","улус");
INSERT INTO chat_vopros VALUES("166","Белый медведь.","умка");
INSERT INTO chat_vopros VALUES("167","Учебный час в школе.","урок");
INSERT INTO chat_vopros VALUES("168","Сушеные абрикосы с косточками.","урюк");
INSERT INTO chat_vopros VALUES("169","Ложный слух.","утка");
INSERT INTO chat_vopros VALUES("170","Водоплавающая птица.","утка");
INSERT INTO chat_vopros VALUES("171","Начало дня.","утро");
INSERT INTO chat_vopros VALUES("172","Прибор для глаженья.","утюг");
INSERT INTO chat_vopros VALUES("173","Регистрация наличия чего-либо.","учет");
INSERT INTO chat_vopros VALUES("174","Небольшая кадка.","ушат");
INSERT INTO chat_vopros VALUES("175","В греческой мифологии царица богов, жена Зевса.","гера");
INSERT INTO chat_vopros VALUES("176","У мусульман человек иной веры.","гяур");
INSERT INTO chat_vopros VALUES("177","В старину налог с побежденных.","дань");
INSERT INTO chat_vopros VALUES("178","Календарное время какого-либо события.","дата");
INSERT INTO chat_vopros VALUES("179","Загородный участок с летним домом.","дача");
INSERT INTO chat_vopros VALUES("180","Здание, сооружение для ж/д подвижного состава.","депо");
INSERT INTO chat_vopros VALUES("181","Заросший травой верхний слой почвы.","дерн");
INSERT INTO chat_vopros VALUES("182","Волокнистое растение для изготовления, веревок канатов.","джут");
INSERT INTO chat_vopros VALUES("183","Укрепленная оборонительная огневая точка.","дзот");
INSERT INTO chat_vopros VALUES("184","Взятое взаймы.","долг");
INSERT INTO chat_vopros VALUES("185","Денежная единица Вьетнама.","донг");
INSERT INTO chat_vopros VALUES("186","Тяжелая плотная шерстяная ткань.","драп");
INSERT INTO chat_vopros VALUES("187","Близкий, верный товарищ.","друг");
INSERT INTO chat_vopros VALUES("188","Часть кривой линии.","дуга");
INSERT INTO chat_vopros VALUES("189","Часть окружности.","дуга");
INSERT INTO chat_vopros VALUES("190","Ствол огнестрельного оружия.","дуло");
INSERT INTO chat_vopros VALUES("191","Сорт небольших груш.","дуля");
INSERT INTO chat_vopros VALUES("192","Мысль, размышление.","дума");
INSERT INTO chat_vopros VALUES("193","Музыкальное произведение для двух исполнителей.","дуэт");
INSERT INTO chat_vopros VALUES("194","Старинное орудие пытки, на котором истязуемого растягивали.","дыба");
INSERT INTO chat_vopros VALUES("195","Бахчевая культура.","дыня");
INSERT INTO chat_vopros VALUES("196","Низший служитель в православной церкви.","дьяк");
INSERT INTO chat_vopros VALUES("197","Английская единица длины = 2,54 см.","дюйм");
INSERT INTO chat_vopros VALUES("198","Английская единица длины = 1/12 фута.","дюйм");
INSERT INTO chat_vopros VALUES("199","Полярная морская птица с ценным пухом.","гага");
INSERT INTO chat_vopros VALUES("200","Полярная утка.","гага");
INSERT INTO chat_vopros VALUES("201","Выжженное место в лесу.","гарь");
INSERT INTO chat_vopros VALUES("202","В греческой мифологии богиня вечной юности, супруга Геракла.","геба");
INSERT INTO chat_vopros VALUES("203","Студенистое вещество.","гель");
INSERT INTO chat_vopros VALUES("204","В западноевропейской мифологии карлик, охраняющий подземные сокровища.","гном");
INSERT INTO chat_vopros VALUES("205","Старая мера аптекарского веса = 62,21 мг.","гран");
INSERT INTO chat_vopros VALUES("206","Крупная хищная птица, питающаяся падалью.","гриф");
INSERT INTO chat_vopros VALUES("207","Часть музыкального инструмента, над которой натянуты струны.","гриф");
INSERT INTO chat_vopros VALUES("208","Сладкий разбавленный горячий напиток из рома или коньяка.","грог");
INSERT INTO chat_vopros VALUES("209","Старинная медная монета в полкопейки.","грош");
INSERT INTO chat_vopros VALUES("210","Очень подвижная рыбка.","вьюн");
INSERT INTO chat_vopros VALUES("211","Поклажа для перевозки на спине животных.","вьюк");
INSERT INTO chat_vopros VALUES("212","Сплетение нескольких букв в один сложный знак.","вязь");
INSERT INTO chat_vopros VALUES("213","Вспомогательный якорь на судне.","верп");
INSERT INTO chat_vopros VALUES("214","Древнегреческие счеты.","абак");
INSERT INTO chat_vopros VALUES("215","Монгольский крестьянин-скотовод.","арат");
INSERT INTO chat_vopros VALUES("216","Испанский гротескный живописец, гравер.","гойя");
INSERT INTO chat_vopros VALUES("217","Раскраска, оформление лица.","грим");
INSERT INTO chat_vopros VALUES("218","Тяжесть, тяжелый предмет.","груз");
INSERT INTO chat_vopros VALUES("219","Игральная карта.","дама");
INSERT INTO chat_vopros VALUES("220","Дерево с твердой древесиной сем. березовых.","граб");
INSERT INTO chat_vopros VALUES("221","Норвежский композитор, пианист, дирижер, сюита \"Пер Гюнт\".","григ");
INSERT INTO chat_vopros VALUES("222","Русский советский писатель, повесть \"Алые паруса\".","грин");
INSERT INTO chat_vopros VALUES("223","Действительное происшествие в прошлом.","быль");
INSERT INTO chat_vopros VALUES("224","Правдивая история.","быль");
INSERT INTO chat_vopros VALUES("225","Большие весы для тяжелых предметов.","вага");
INSERT INTO chat_vopros VALUES("226","Листья папоротников.","вайя");
INSERT INTO chat_vopros VALUES("227","Общее собрание горожан на Руси.","вече");
INSERT INTO chat_vopros VALUES("228","Индийский струнный щипковый музыкальный инструмент из сушеной тыквы.","вина");
INSERT INTO chat_vopros VALUES("229","Проступок, преступление.","вина");
INSERT INTO chat_vopros VALUES("230","Карточная игра.","вист");
INSERT INTO chat_vopros VALUES("231","Самая распространенная на земле жидкость.","вода");
INSERT INTO chat_vopros VALUES("232","Растаявший лед.","вода");
INSERT INTO chat_vopros VALUES("233","Короткий густой пушок на ткани.","ворс");
INSERT INTO chat_vopros VALUES("234","Материал для постройки пчелиных сот.","воск");
INSERT INTO chat_vopros VALUES("235","Путешествие, поездка.","вояж");
INSERT INTO chat_vopros VALUES("236","Ночная болотная птица.","выпь");
INSERT INTO chat_vopros VALUES("237","Небесная даль.","высь");
INSERT INTO chat_vopros VALUES("238","Французский композитор, опера \"Ромео и Джульетта\".","гуно");
INSERT INTO chat_vopros VALUES("239","Правый приток Амударьи.","вахш");
INSERT INTO chat_vopros VALUES("240","Приданое жены.","вено");
INSERT INTO chat_vopros VALUES("241","Французский математик, разработчик элементарной алгебры.","виет");
INSERT INTO chat_vopros VALUES("242","Приятная расслабленность.","кайф");
INSERT INTO chat_vopros VALUES("243","Боевое построение пехоты четырехугольником.","каре");
INSERT INTO chat_vopros VALUES("244","Столица Египта.","каир");
INSERT INTO chat_vopros VALUES("245","Порт во Франции.","кале");
INSERT INTO chat_vopros VALUES("246","Пресноводная рыба, одомашненный сазан.","карп");
INSERT INTO chat_vopros VALUES("247","Гоночный микролитражный автомобиль без кузова.","карт");
INSERT INTO chat_vopros VALUES("248","Спортивные матерчатые ботинки на резиновой подошве.","кеды");
INSERT INTO chat_vopros VALUES("249","Образец породы из скважины при бурении.","керн");
INSERT INTO chat_vopros VALUES("250","Женщина, которой Пушкин посвятил \"Я помню чудное мгновенье...\".","керн");
INSERT INTO chat_vopros VALUES("251","Дальневосточная лососевая рыба.","кета");
INSERT INTO chat_vopros VALUES("252","Ароматный и сочный тропический фрукт.","киви");
INSERT INTO chat_vopros VALUES("253","Субтропический ароматный и сочный плод.","киви");
INSERT INTO chat_vopros VALUES("254","Новозеландская бескрылая птица.","киви");
INSERT INTO chat_vopros VALUES("255","Балка днища судна от носа до кормы.","киль");
INSERT INTO chat_vopros VALUES("256","Часть хвостового оперения самолета, ракеты.","киль");
INSERT INTO chat_vopros VALUES("257","Созвездие Южного полушария.","киль");
INSERT INTO chat_vopros VALUES("258","То же, что фильм.","кино");
INSERT INTO chat_vopros VALUES("259","Зарытые, спрятанные сокровища.","клад");
INSERT INTO chat_vopros VALUES("260","Мафиозная семья.","клан");
INSERT INTO chat_vopros VALUES("261","Родовая или семейная община.","клан");
INSERT INTO chat_vopros VALUES("262","Расширение юбки, брюк, пальто внизу.","клеш");
INSERT INTO chat_vopros VALUES("263","Цепкое мелкое членистоногое животное.","клещ");
INSERT INTO chat_vopros VALUES("264","Кусок дерева, металла с сужающимся плоским концом.","клин");
INSERT INTO chat_vopros VALUES("265","Призыв, возглас.","клич");
INSERT INTO chat_vopros VALUES("266","Торчащая прядь.","клок");
INSERT INTO chat_vopros VALUES("267","Копия организма.","клон");
INSERT INTO chat_vopros VALUES("268","Культурно-просветительное учреждение.","клуб");
INSERT INTO chat_vopros VALUES("269","Зуб, расположенный сразу за резцом.","клык");
INSERT INTO chat_vopros VALUES("270","Челюсти у птиц.","клюв");
INSERT INTO chat_vopros VALUES("271","Знак в начале нотной строки.","ключ");
INSERT INTO chat_vopros VALUES("272","Приспособление для отпирания замков.","ключ");
INSERT INTO chat_vopros VALUES("273","Тряпка, насильно засовываемая в рот для предупреждения крика.","кляп");
INSERT INTO chat_vopros VALUES("274","Насильно засунутая в рот тряпка.","кляп");
INSERT INTO chat_vopros VALUES("275","Большая плеть.","кнут");
INSERT INTO chat_vopros VALUES("276","Наружный покров тела человека, животного.","кожа");
INSERT INTO chat_vopros VALUES("277","Твердое топливо.","кокс");
INSERT INTO chat_vopros VALUES("278","Столица Украины.","киев");
INSERT INTO chat_vopros VALUES("279","Украинское название волынки.","коза");
INSERT INTO chat_vopros VALUES("280","Домашнее парнокопытное животное.","коза");
INSERT INTO chat_vopros VALUES("281","То же, что рудник.","копи");
INSERT INTO chat_vopros VALUES("282","Вес чистого благородного металла в монете.","корн");
INSERT INTO chat_vopros VALUES("283","Сплетеные в виде жгута волосы.","коса");
INSERT INTO chat_vopros VALUES("284","Ручное сельскохозяйственное орудие.","коса");
INSERT INTO chat_vopros VALUES("285","Ручное сельскохозяйственное орудие для срезания травы.","коса");
INSERT INTO chat_vopros VALUES("286","Береговая отмель.","коса");
INSERT INTO chat_vopros VALUES("287","Короткохвостый рак.","краб");
INSERT INTO chat_vopros VALUES("288","Десятиногое ракообразное животное.","краб");
INSERT INTO chat_vopros VALUES("289","Эмблема на форменной фуражке моряков.","краб");
INSERT INTO chat_vopros VALUES("290","Крупная административно-территориальная единица.","край");
INSERT INTO chat_vopros VALUES("291","Обладатель несметных богатств.","крез");
INSERT INTO chat_vopros VALUES("292","Наклон судна набок.","крен");
INSERT INTO chat_vopros VALUES("293","Задняя часть туловища лошади.","круп");
INSERT INTO chat_vopros VALUES("294","Гряда холмов.","кряж");
INSERT INTO chat_vopros VALUES("295","Невысокая горная цепь.","кряж");
INSERT INTO chat_vopros VALUES("296","Крестная мать по отношению к родителям крестника.","кума");
INSERT INTO chat_vopros VALUES("297","Река в Дагестане.","кума");
INSERT INTO chat_vopros VALUES("298","Отделение в пассажирском вагоне.","купе");
INSERT INTO chat_vopros VALUES("299","Направление движения, путь транспорта.","курс");
INSERT INTO chat_vopros VALUES("300","Биржевая цена ценных бумаг.","курс");
INSERT INTO chat_vopros VALUES("301","Ветвистое травянистое растение.","куст");
INSERT INTO chat_vopros VALUES("302","Католический приходской священник.","кюре");
INSERT INTO chat_vopros VALUES("303","Жена помещика, барина в старину на Украине, в Польше.","пани");
INSERT INTO chat_vopros VALUES("304","Отец.","папа");
INSERT INTO chat_vopros VALUES("305","Глава католической церкви.","папа");
INSERT INTO chat_vopros VALUES("306","Спор с каким-либо условием.","пари");
INSERT INTO chat_vopros VALUES("307","Титул высших сановников и генералов в древней Турции.","паша");
INSERT INTO chat_vopros VALUES("308","Прежнее название клоуна.","паяц");
INSERT INTO chat_vopros VALUES("309","Торчащий из земли остаток спиленного дерева.","пень");
INSERT INTO chat_vopros VALUES("310","Орудие для письма в старину.","перо");
INSERT INTO chat_vopros VALUES("311","Стреловидный лист лука, чеснока.","перо");
INSERT INTO chat_vopros VALUES("312","Сооружение для отопления помещения.","печь");
INSERT INTO chat_vopros VALUES("313","Созвездие Южного полушария.","печь");
INSERT INTO chat_vopros VALUES("314","Род копья.","пика");
INSERT INTO chat_vopros VALUES("315","Крутое снижение самолета.","пике");
INSERT INTO chat_vopros VALUES("316","Черная масть в картах.","пики");
INSERT INTO chat_vopros VALUES("317","Зубчатый режущий инструмент.","пила");
INSERT INTO chat_vopros VALUES("318","Декоративный яркий цветок семейства лютиковых.","пион");
INSERT INTO chat_vopros VALUES("319","Нестабильная элементарная частица.","пион");
INSERT INTO chat_vopros VALUES("320","Портовое причальное сооружение.","пирс");
INSERT INTO chat_vopros VALUES("321","14-й президент США.","пирс");
INSERT INTO chat_vopros VALUES("322","Непромокаемое пальто.","плащ");
INSERT INTO chat_vopros VALUES("323","Дорожное одеяло.","плед");
INSERT INTO chat_vopros VALUES("324","Знак сложения в математике.","плюс");
INSERT INTO chat_vopros VALUES("325","Ткань с ворсом.","плюш");
INSERT INTO chat_vopros VALUES("326","Лиановое растение.","плющ");
INSERT INTO chat_vopros VALUES("327","Положение тела.","поза");
INSERT INTO chat_vopros VALUES("328","Безлесная равнинная территория.","поле");
INSERT INTO chat_vopros VALUES("329","Участок земли под посевы.","поле");
INSERT INTO chat_vopros VALUES("330","Ответственная должность.","пост");
INSERT INTO chat_vopros VALUES("331","Воздержание от скоромной пищи.","пост");
INSERT INTO chat_vopros VALUES("332","Место постоянного дежурства.","пост");
INSERT INTO chat_vopros VALUES("333","Автор стихов.","поэт");
INSERT INTO chat_vopros VALUES("334","Ремень на талии.","пояс");
INSERT INTO chat_vopros VALUES("335","Зона на Земле с одинаковым временем.","пояс");
INSERT INTO chat_vopros VALUES("336","Французский физик, вместе с женой исследовавший радиоактивность.","кюри");
INSERT INTO chat_vopros VALUES("337","Единица активности радиоактивных изотопов.","кюри");
INSERT INTO chat_vopros VALUES("338","Тонкая ветка без листьев.","прут");
INSERT INTO chat_vopros VALUES("339","Левый приток Дуная.","прут");
INSERT INTO chat_vopros VALUES("340","Неуравновешенный или душевнобольной человек.","псих");
INSERT INTO chat_vopros VALUES("341","Напиток из рома с приправами.","пунш");
INSERT INTO chat_vopros VALUES("342","Момент приведения в движение.","пуск");
INSERT INTO chat_vopros VALUES("343","Веревка, ремни, стягивающие тело пленника.","путы");
INSERT INTO chat_vopros VALUES("344","Густой труднопроходимый лес.","пуща");
INSERT INTO chat_vopros VALUES("345","Протертая масса из фруктов, ягод или овощей.","пюре");
INSERT INTO chat_vopros VALUES("346","Мелкое волнение водной поверхности.","рябь");
INSERT INTO chat_vopros VALUES("347","Открытое повреждение тканей тела.","рана");
INSERT INTO chat_vopros VALUES("348","То же, что войско.","рать");
INSERT INTO chat_vopros VALUES("349","Гитлеровская империя.","рейх");
INSERT INTO chat_vopros VALUES("350","Столица Латвии.","рига");
INSERT INTO chat_vopros VALUES("351","Французский композитор, балет \"Жизель\".","адан");
INSERT INTO chat_vopros VALUES("352","Французская писательница, роман \"Консуэло\".","санд");
INSERT INTO chat_vopros VALUES("353","Мать жены.","теща");
INSERT INTO chat_vopros VALUES("354","Полосатый полудрагоценный камень.","агат");
INSERT INTO chat_vopros VALUES("355","Работник по уходу за коровами.","дояр");
INSERT INTO chat_vopros VALUES("356","Государство в Центральной Африке.","заир");
INSERT INTO chat_vopros VALUES("357","Французский писатель, роман \"Жерминаль\".","золя");
INSERT INTO chat_vopros VALUES("358","Один из изобретателей телефона, шотландец.","белл");
INSERT INTO chat_vopros VALUES("359","Порт на реке Луара во Франции.","нант");
INSERT INTO chat_vopros VALUES("360","Столбообразное тело в жерле вулкана.","некк");
INSERT INTO chat_vopros VALUES("361","Премьер-министр Индии, сподвижник М.К.Ганди.","неру");
INSERT INTO chat_vopros VALUES("362","Французский композитор, музыка \"Марсельеза\".","лиль");
INSERT INTO chat_vopros VALUES("363","Французский композитор, опера \"Сон в летнюю ночь\".","тома");
INSERT INTO chat_vopros VALUES("364","Место переправы через реку.","брод");
INSERT INTO chat_vopros VALUES("365","Роман Ф.М.Достоевского .","бесы");
INSERT INTO chat_vopros VALUES("366","Роман Э.Золя .","нана");
INSERT INTO chat_vopros VALUES("367","Колдовство, волшебство.","чары");
INSERT INTO chat_vopros VALUES("368","Стихотворение С.Есенина .","чары");
INSERT INTO chat_vopros VALUES("369","Опера Ж.Массне .","таис");
INSERT INTO chat_vopros VALUES("370","Американский писатель, роман \"Приключения Гекльберри Финна\".","твен");
INSERT INTO chat_vopros VALUES("371","Древнегреческий баснописец.","эзоп");
INSERT INTO chat_vopros VALUES("372","Русский советский писатель, соавтор романа \"12 стульев\".","ильф");
INSERT INTO chat_vopros VALUES("373","Английский математик, разработавший алгебру логики.","буль");
INSERT INTO chat_vopros VALUES("374","Французский писатель-фантаст, роман \"Планета обезьян\".","буль");
INSERT INTO chat_vopros VALUES("375","Французский писатель, роман \"Набоб\".","доде");
INSERT INTO chat_vopros VALUES("376","Французский писатель, роман \"Калигула\".","камю");
INSERT INTO chat_vopros VALUES("377","Немецкий писатель, роман \"Будденброки\".","манн");
INSERT INTO chat_vopros VALUES("378","Картофельная крупа.","саго");
INSERT INTO chat_vopros VALUES("379","Столица Перу.","лима");
INSERT INTO chat_vopros VALUES("380","Порт во Франции у слияния рек Рона и Сона.","лион");
INSERT INTO chat_vopros VALUES("381","Река в Прикаспийской низменности.","урал");
INSERT INTO chat_vopros VALUES("382","Марка отечественного автомобиля .","урал");
INSERT INTO chat_vopros VALUES("383","Горная система на границе Европы и Азии.","урал");
INSERT INTO chat_vopros VALUES("384","Русский живописец, картина \"Бородино\".","рубо");
INSERT INTO chat_vopros VALUES("385","Русский художник, панорама \"Бородинская битва\".","рубо");
INSERT INTO chat_vopros VALUES("386","В греческой мифологии супруга спартанского царя Тиндарея.","леда");
INSERT INTO chat_vopros VALUES("387","Спутник Юпитера.","леда");
INSERT INTO chat_vopros VALUES("388","Спутник Сатурна.","феба");
INSERT INTO chat_vopros VALUES("389","Созвездие Южного полушария.","чаша");
INSERT INTO chat_vopros VALUES("390","Округлый сосуд.","чаша");
INSERT INTO chat_vopros VALUES("391","Сделка с немедленной оплатой.","спот");
INSERT INTO chat_vopros VALUES("392","Женское имя (лат. пышная, сноп).","юлия");
INSERT INTO chat_vopros VALUES("393","Тело убитого крупного зверя.","туша");
INSERT INTO chat_vopros VALUES("394","Двухмачтовое судно с прямыми парусами.","бриг");
INSERT INTO chat_vopros VALUES("395","Восковые ячейки пчелиного жилища.","соты");
INSERT INTO chat_vopros VALUES("396","Помещение для мытья с парилкой.","баня");
INSERT INTO chat_vopros VALUES("397","Запряженная ишаком двухколесная повозка.","арба");
INSERT INTO chat_vopros VALUES("398","Чернокожий, негр.","арап");
INSERT INTO chat_vopros VALUES("399","Библейский первый мужчина.","адам");
INSERT INTO chat_vopros VALUES("400","Строительный материал, балка.","брус");
INSERT INTO chat_vopros VALUES("401","Отчаянный высокий вопль.","визг");
INSERT INTO chat_vopros VALUES("402","Способность осуществлять поставленные перед собой цели.","воля");
INSERT INTO chat_vopros VALUES("403","Грузовое помещение на корабле.","трюм");
INSERT INTO chat_vopros VALUES("404","Река в Германии.","рейн");
INSERT INTO chat_vopros VALUES("405","Отец одного из супругов по отношению к родителям другого супруга.","сват");
INSERT INTO chat_vopros VALUES("406","Город и река в Коми.","инта");
INSERT INTO chat_vopros VALUES("407","Женское имя (др. евр. радость).","анна");
INSERT INTO chat_vopros VALUES("408","Легендарный бразильский футболист.","пеле");
INSERT INTO chat_vopros VALUES("409","Ловкий, искусный прием.","трюк");
INSERT INTO chat_vopros VALUES("410","Столица Индии.","дели");
INSERT INTO chat_vopros VALUES("411","Река в Московской области, левый приток Оки.","нара");
INSERT INTO chat_vopros VALUES("412","Первая столица Японии.","нара");
INSERT INTO chat_vopros VALUES("413","Освежающий летний напиток.","квас");
INSERT INTO chat_vopros VALUES("414","Южная птица отряда голенастых.","ибис");
INSERT INTO chat_vopros VALUES("415","В древнегреческой мифологии бог любви.","эрот");
INSERT INTO chat_vopros VALUES("416","Королевский футбольный клуб Испании .","реал");
INSERT INTO chat_vopros VALUES("417","Старинная испанская серебряная монета.","реал");
INSERT INTO chat_vopros VALUES("418","Бывшая столица Германии.","бонн");
INSERT INTO chat_vopros VALUES("419","Спутник Юпитера.","теба");
INSERT INTO chat_vopros VALUES("420","Спутник Юпитера.","фива");
INSERT INTO chat_vopros VALUES("421","Отклонение в сторону повышения рыночной цены золота.","ажио");
INSERT INTO chat_vopros VALUES("422","Деталь затвора огнестрельного оружия.","боек");
INSERT INTO chat_vopros VALUES("423","Островное государство в Центральной Америке.","куба");
INSERT INTO chat_vopros VALUES("424","Курортный город в Грузии.","поти");
INSERT INTO chat_vopros VALUES("425","Город в Германии, в котором родился К. Маркс.","трир");
INSERT INTO chat_vopros VALUES("426","Город в Италии с \"падающей башней\".","пиза");
INSERT INTO chat_vopros VALUES("427","Прежнее название поэта.","пиит");
INSERT INTO chat_vopros VALUES("428","Сибирские валенки.","пимы");
INSERT INTO chat_vopros VALUES("429","Меховые сапоги у северных народов.","пимы");
INSERT INTO chat_vopros VALUES("430","Американский полярный исследователь.","пири");
INSERT INTO chat_vopros VALUES("431","Государство в Западной Азии.","ирак");
INSERT INTO chat_vopros VALUES("432","Государство в Западной Африке.","мали");
INSERT INTO chat_vopros VALUES("433","Государство в Юго-Восточной Азии.","лаос");
INSERT INTO chat_vopros VALUES("434","Государство в Западной Африке.","того");
INSERT INTO chat_vopros VALUES("435","Областной центр в Забайкалье.","чита");
INSERT INTO chat_vopros VALUES("436","Серия советских космических кораблей .","союз");
INSERT INTO chat_vopros VALUES("437","Служебное слово, соединяющее преложения и слова внутри предложения.","союз");
INSERT INTO chat_vopros VALUES("438","Государственное или общественное объединение.","союз");
INSERT INTO chat_vopros VALUES("439","Объединение, союз.","уния");
INSERT INTO chat_vopros VALUES("440","Объединение православной и католической церквей.","уния");
INSERT INTO chat_vopros VALUES("441","Польский парламент.","сейм");
INSERT INTO chat_vopros VALUES("442","Список блюд в ресторане.","меню");
INSERT INTO chat_vopros VALUES("443","Единица измерения.","мера");
INSERT INTO chat_vopros VALUES("444","Старая русская единица емкости сыпучих тел.","мера");
INSERT INTO chat_vopros VALUES("445","Часть чего-либо.","доля");
INSERT INTO chat_vopros VALUES("446","Участь, судьба.","доля");
INSERT INTO chat_vopros VALUES("447","Французский изобретатель телеграфа.","бодо");
INSERT INTO chat_vopros VALUES("448","Итальянский композитор, основатель русского балета, балет \"Конек-Горбунок\".","пуни");
INSERT INTO chat_vopros VALUES("449","Тонкий слой древесины, получаемый лущением.","шпон");
INSERT INTO chat_vopros VALUES("450","Многослойная фанера.","шпон");
INSERT INTO chat_vopros VALUES("451","Гробница для хранения святых мощей.","рака");
INSERT INTO chat_vopros VALUES("452","Первая выгонка вина из барды.","рака");
INSERT INTO chat_vopros VALUES("453","Тонкие волнообразные листы.","гофр");
INSERT INTO chat_vopros VALUES("454","Знакомство и связи, используемые в личных интересах.","блат");
INSERT INTO chat_vopros VALUES("455","Стальная заготовка квадратного сечения.","блюм");
INSERT INTO chat_vopros VALUES("456","Снасть, укрепляемая на концах рея для его поворота.","брас");
INSERT INTO chat_vopros VALUES("457","Минерал для очистки металлов при пайке.","бура");
INSERT INTO chat_vopros VALUES("458","Сложенные в виде вала и укрытые для хранения овощи, корнеплоды.","бурт");
INSERT INTO chat_vopros VALUES("459","Хлопчатобумажная плотная ткань.","бязь");
INSERT INTO chat_vopros VALUES("460","Наполнение легких воздухом.","вдох");
INSERT INTO chat_vopros VALUES("461","Часть теннисной партии.","гейм");
INSERT INTO chat_vopros VALUES("462","Клинообразная дощечка с пазами для покрытия крыши.","гонт");
INSERT INTO chat_vopros VALUES("463","Прорванное или проломанное отверстие.","дыра");
INSERT INTO chat_vopros VALUES("464","Женское имя (греч. вторая).","алла");
INSERT INTO chat_vopros VALUES("465","Псевдоним Н.В.Гоголя.","алов");
INSERT INTO chat_vopros VALUES("466","Марка немецкого автомобиля .","ауди");
INSERT INTO chat_vopros VALUES("467","Марка французского автомобиля .","пежо");
INSERT INTO chat_vopros VALUES("468","Марка американского автомобиля .","додж");
INSERT INTO chat_vopros VALUES("469","Марка шведского автомобиля .","сааб");
INSERT INTO chat_vopros VALUES("470","Марка итальянского автомобиля .","фиат");
INSERT INTO chat_vopros VALUES("471","Марка американского автомобиля .","форд");
INSERT INTO chat_vopros VALUES("472","38-й президент США.","форд");
INSERT INTO chat_vopros VALUES("473","Марка отечественного легкового автомобиля .","лада");
INSERT INTO chat_vopros VALUES("474","Богиня красоты, любви и брака у древних славян.","лада");
INSERT INTO chat_vopros VALUES("475","Отец.","батя");
INSERT INTO chat_vopros VALUES("476","Французский математик, труды по теории алгебраических уравнений.","безу");
INSERT INTO chat_vopros VALUES("477","Герой одесских рассказов Исаака Бабеля.","беня");
INSERT INTO chat_vopros VALUES("478","Столица Швейцарии.","берн");
INSERT INTO chat_vopros VALUES("479","Поперечная балка, соединяющая борта корабля.","бимс");
INSERT INTO chat_vopros VALUES("480","Тонкая лепешка, знаменитое блюдо русской кухни.","блин");
INSERT INTO chat_vopros VALUES("481","Холодный приморский ветер со склонов гор.","бора");
INSERT INTO chat_vopros VALUES("482","Боковая стенка корпуса судна.","борт");
INSERT INTO chat_vopros VALUES("483","Хозяин, начальник, руководитель.","босс");
INSERT INTO chat_vopros VALUES("484","Нидерландский живописец, картина \"Искушение святого Антония\".","босх");
INSERT INTO chat_vopros VALUES("485","Химический элемент, едкая дымящаяся жидкость с неприятным запахом.","бром");
INSERT INTO chat_vopros VALUES("486","Самое сухое шампанское.","брют");
INSERT INTO chat_vopros VALUES("487","Маленький сигнальный плавучий поплавок.","буек");
INSERT INTO chat_vopros VALUES("488","Солдат, боец.","воин");
INSERT INTO chat_vopros VALUES("489","Денежная единица Кореи.","вона");
INSERT INTO chat_vopros VALUES("490","Молочные железы коровы.","вымя");
INSERT INTO chat_vopros VALUES("491","Самое простонародное имя у немцев.","ганс");
INSERT INTO chat_vopros VALUES("492","Дощечки для покрытия крыш.","гарт");
INSERT INTO chat_vopros VALUES("493","Типографский сплав.","гарт");
INSERT INTO chat_vopros VALUES("494","Составитель словаря русского языка.","даль");
INSERT INTO chat_vopros VALUES("495","Английское холодное оружие, короткое метательное копье, дротик.","дарт");
INSERT INTO chat_vopros VALUES("496","Знаток, мастер своего дела.","дока");
INSERT INTO chat_vopros VALUES("497","Лицо женского пола по отношению к своим родителям.","дочь");
INSERT INTO chat_vopros VALUES("498","Порт в Великобритании у пролива Па-де-Кале.","дувр");
INSERT INTO chat_vopros VALUES("499","Вирусная болезнь парнокопытных животных.","ящур");
INSERT INTO chat_vopros VALUES("500","Выдающийся советский вратарь.","яшин");
INSERT INTO chat_vopros VALUES("501","Левый приток Москва-реки.","яуза");



DROP TABLE IF EXISTS `chat_who`;

CREATE TABLE `chat_who` (
  `id_user` int(11) NOT NULL,
  `room` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`room`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `child_action`;

CREATE TABLE `child_action` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voz` int(11) NOT NULL,
  `keystr` varchar(16) NOT NULL,
  `stat` enum('0','1') NOT NULL DEFAULT '0',
  `time_summ` int(11) NOT NULL,
  `time_val` int(11) NOT NULL,
  `time_k` int(11) NOT NULL,
  `name1` varchar(32) DEFAULT NULL,
  `name2` varchar(32) DEFAULT NULL,
  `type` enum('0','1') NOT NULL DEFAULT '0',
  `cost` int(11) NOT NULL DEFAULT '0',
  `val` varchar(16) NOT NULL DEFAULT 'balls',
  `gigiena` float(11,4) DEFAULT '0.0000',
  `bodr` float(11,4) DEFAULT '0.0000',
  `nastr` float(11,4) DEFAULT '0.0000',
  `obrazov` float(11,4) DEFAULT '0.0000',
  `obchen` float(11,4) DEFAULT '0.0000',
  `sitost` float(11,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `voz` (`voz`),
  KEY `keystr` (`keystr`)
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=utf8 COMMENT='таблица действий для потребностей детей';

INSERT INTO child_action VALUES("35","1","bodr","1","25200","7","3600","Ночной сон","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("34","1","obchen","1","3600","60","60","Играть в песочнице","Играет в песочнице","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("33","1","obchen","1","2400","40","60","Поиграть в мяч","Играет в мяч","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("30","1","sitost","1","600","10","60","Накормить манной кашей","Кушает манную кашу","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","24.0000");
INSERT INTO child_action VALUES("31","1","obchen","1","1800","30","60","Почитать книгу","Слушать чтение книги","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("21","1","gigiena","1","1800","30","60","Принять ванну","Купаеться","1","2000","balls","2.5600","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("22","1","gigiena","1","2400","40","60","Принять душь","Принимает душь","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("24","1","gigiena","1","420","7","60","Чистить зубы","Чистит зубы","1","2000","balls","68.5714","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("32","1","obchen","1","1800","30","60","Поиграть с катёнком","Играть с катёнком","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("40","1","sitost","1","420","7","60","Накормить блинчиками","Кушает блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("37","1","bodr","1","3600","1","3600","Уложить спать","Дремлет","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("41","1","sitost","1","600","10","60","Накормить рыбкой","Кушает рыбку","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("42","1","sitost","1","360","6","60","Накормить тортиком","Кушает тортик","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("43","1","sitost","1","240","4","60","Накормить арбузом","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("44","1","sitost","1","600","10","60","Накормить круассаном","Кушает круассан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("45","1","sitost","1","480","8","60","Накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("46","1","sitost","1","900","15","60","Накормить рисом с мясом","Кушает рис с мясом","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("47","1","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("48","1","nastr","1","1200","20","60","Покатать на качели","Кататься на качели","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("50","1","bodr","1","10800","3","3600","Уложить спать","Дневной сон","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("53","1","obchen","1","600","10","60","Поиграть с куклой","Играет с куклой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("54","2","gigiena","1","900","15","60","Принять ванну","Принимает ванну","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("55","2","gigiena","1","2400","40","60","Принять душь","Принимает душь","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("56","2","gigiena","1","540","9","60","Чтстит зубы","Чистит зубы","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("57","2","sitost","1","900","15","60","Кушает манную кашу","Накормить манкой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("58","2","obchen","1","2400","40","60","Играть с мячем","Играть с мячем","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("59","2","obchen","1","1800","30","60","Почитать книгу","Слушает чтение книги","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("60","2","obchen","1","1800","30","60","Играть с котенком","Играет с котенком","1","3000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("61","2","sitost","1","300","5","60","Накормить арбузом","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("62","2","sitost","1","600","10","60","Накормить круассаном","Кушает круассан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("63","2","obchen","1","2400","40","60","Играть в песочнеце","Играет в песочнеце","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("64","2","bodr","1","25200","7","3600","Ночной сон","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("65","2","bodr","1","3600","1","3600","Уложить спать","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("66","2","sitost","1","420","7","60","Накормить блинчиками","Кушает блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("67","2","sitost","1","600","10","60","Накормить рыбой","Кушает рыбу","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("68","2","sitost","1","360","6","60","Накормить тортиком","Кушает тортик","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("69","2","sitost","1","480","8","60","Накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("70","2","sitost","1","900","15","60","Накормить рисом с мясом","Кушает рис с мясом","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("71","2","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("72","2","nastr","1","900","15","60","Катать на качели","Кататься на качели","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("73","2","bodr","1","10800","3","3600","Дневной сон","Уложить спать","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("74","2","obchen","1","600","10","60","Поиграть с куклой","Играет с куклой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("75","2","nastr","1","10800","3","3600","В гостях у бабушки и дедушке","В гостях у бабушки и дедушке","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("76","2","nastr","1","600","10","60","Посадить в шезлонг","Сидит в шезлонге","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("77","3","nastr","1","480","8","60","Кататься на качели","Покатать на качели","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("78","3","nastr","1","1800","30","60","Пойти в басейн","В басейне","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("79","3","nastr","1","1800","30","60","Пойти в бассейн","В бассейне","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("80","3","nastr","1","1800","30","60","Посадить в шезлонг","сидит в шезлонге","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("81","3","obchen","1","18000","5","3600","В гостях у бабули и дедули","Гостит у бабушки и дедушки","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("82","3","nastr","1","1500","25","60","Играть с куклой","Играет с куклой","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("83","3","bodr","1","10800","3","3600","Дневной сон","Спит","0","0","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("84","3","sitost","1","600","10","60","Накормить Рис с мясом","Кушает рис с мясом","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("85","3","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","0","0","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("86","3","obchen","1","2400","40","60","Играет с мамой","Поиграть с мамой","0","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("87","3","gigiena","1","1800","30","60","принять ванну","Принять ванну","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("88","3","gigiena","1","2400","40","60","Душ","Принять душ","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("89","3","gigiena","1","1200","20","60","Чистить зубы","Почистить зубы","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("90","3","sitost","1","900","15","60","Кушать манку","накормить манкой","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("91","3","nastr","1","1200","20","60","Играть в песочнице","Играть в песочнице","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("92","3","nastr","1","1200","20","60","играть с котиком","Поиграть  с катёнком","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("93","3","nastr","1","1500","25","60","почитать книгу","Читать книгу","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("94","3","sitost","1","360","6","60","накормить арбуз","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("95","3","sitost","1","600","10","60","накормить круасманом","Круассан кушать","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("96","3","nastr","1","1500","25","60","играть в песочнице","Поиграть в песочнице","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("97","3","bodr","1","25200","7","3600","Ночной сон","Ночной сон","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("98","3","bodr","1","7200","2","3600","дремать","Дремает","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("99","3","sitost","1","600","10","60","Блинчики","Кушать блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("100","3","sitost","1","900","15","60","Кушать  рыбку","Накормить рыбкой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("101","3","sitost","1","1200","20","60","накормить тортом","Кушает торт","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("102","3","sitost","1","1080","18","60","накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("103","3","nastr","1","480","8","60","покатать на качели","катать на качели","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("104","2","obchen","1","10800","3","3600","На прогулку с родителями","На прогулку с родителями","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("105","2","obchen","1","2400","40","60","На прогулке с папой","Гуляет с папой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("106","3","obchen","1","10800","3","3600","играть с мамой","Поиграть с мамой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("107","3","obchen","1","10800","3","3600","На прогулку с родителями","На прогулке с родителями","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("108","2","obchen","1","10800","3","3600","Пойти на прогулку с папой","На прогулке с папой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("109","3","obrazov","1","1800","30","60","Рисовать красками","Рисует красками","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("110","3","obrazov","1","1800","30","60","Лепка из пластелина","Лепить из пластелина","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("111","3","obrazov","1","1800","30","60","На урок английского","Занятия английским языком","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("112","4","sitost","1","900","15","60","Накормить рассольником","Кушает рассольник","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("113","4","sitost","1","900","15","60","Накормить картошкой фри","Кушает картошку фри","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("114","4","nastr","1","1800","30","60","Пойти с папой в спортзал","В спортзале с папой","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("115","4","nastr","1","2400","40","60","Пойти с папой в гораж","С папой в гораже","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("116","4","bodr","1","25200","7","3600","Уложить спать","Ночной сон","1","3000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("117","4","bodr","1","300","5","60","Уложить дремать","Дремлет","1","3000","money","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("118","4","bodr","1","10800","3","3600","Дневной сон","Дневной сон","1","3000","money","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("119","4","gigiena","1","1200","20","60","Искупаться в ванне","Купаться в ванне","1","3000","money","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("120","4","obchen","1","1200","20","60","Отвести в бассейн","В бассейне","1","3000","money","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("121","4","obrazov","1","18000","5","3600","В гости к бабушке дедушке","Гостит у бабушки дедушки","1","3000","money","0.0000","0.0000","0.0000","30200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("122","4","nastr","1","900","15","60","Пойти на атракцион","Катаеться  на атракционе","1","3000","balls","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("123","4","sitost","1","720","12","60","Накормить мармеладом","Кушает мармелад","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("124","4","nastr","1","2400","40","60","На прогулку с папой","Пойти на прогулку с папой","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");



DROP TABLE IF EXISTS `child_newchild`;

CREATE TABLE `child_newchild` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `read` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='таблица заявок (предложений) завести ребенка ';




DROP TABLE IF EXISTS `child_offer`;

CREATE TABLE `child_offer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `child` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komu` (`komu`),
  KEY `kto` (`kto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Таблица предложений одиночкам стать папой мамой ребенку';




DROP TABLE IF EXISTS `child_pers`;

CREATE TABLE `child_pers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mother` int(11) NOT NULL,
  `father` int(11) NOT NULL,
  `opekun_0` int(11) DEFAULT '0',
  `opekun_1` int(11) NOT NULL DEFAULT '0',
  `dopmsg` int(11) NOT NULL DEFAULT '0',
  `s_time` int(11) NOT NULL,
  `r_time` int(11) NOT NULL,
  `name` varchar(16) NOT NULL,
  `pol` enum('0','1') NOT NULL,
  `voz` smallint(1) NOT NULL DEFAULT '0',
  `detsad` enum('0','1') NOT NULL DEFAULT '0',
  `detsadstop` int(11) NOT NULL DEFAULT '0',
  `detdom` enum('0','1') NOT NULL DEFAULT '0',
  `nani` int(11) NOT NULL,
  `gigiena` float(22,6) DEFAULT '0.000000',
  `bodr` float(22,6) DEFAULT '0.000000',
  `nastr` float(22,6) DEFAULT '0.000000',
  `obrazov` float(22,6) DEFAULT '0.000000',
  `obchen` float(22,6) DEFAULT '0.000000',
  `sitost` float(22,6) DEFAULT '0.000000',
  `uptime` int(11) NOT NULL,
  `act_stop` int(11) DEFAULT '0',
  `act_id` int(11) DEFAULT '0',
  `act_name` varchar(32) NOT NULL,
  `next_voz` int(11) DEFAULT NULL,
  `full` smallint(3) NOT NULL,
  `countnull` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mother` (`mother`),
  KEY `father` (`father`),
  KEY `opekun_0` (`opekun_0`),
  KEY `opekun_1` (`opekun_1`),
  KEY `uptime` (`uptime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='таблица детей';




DROP TABLE IF EXISTS `child_prof`;

CREATE TABLE `child_prof` (
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `child_count` int(11) DEFAULT '0',
  `opekun_count` int(11) DEFAULT '0',
  `pol` enum('0','1') NOT NULL,
  `plan_pol` smallint(1) NOT NULL DEFAULT '-1',
  `r_time` int(11) NOT NULL,
  `deprivation` int(11) NOT NULL DEFAULT '0',
  `countuh` int(11) NOT NULL DEFAULT '0',
  `countuh_all` int(11) NOT NULL DEFAULT '0',
  `day` varchar(8) NOT NULL,
  PRIMARY KEY (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Таблица профиля родителей (опекунов)';




DROP TABLE IF EXISTS `child_rodn`;

CREATE TABLE `child_rodn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `rname` varchar(16) NOT NULL,
  `accept` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `child` (`child`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chr`;

CREATE TABLE `chr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `num` int(5) DEFAULT '0',
  `cena` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan`;

CREATE TABLE `clan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `about` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `reit` int(11) DEFAULT '0',
  `allreit` int(11) NOT NULL DEFAULT '0',
  `bank` int(11) DEFAULT '0',
  `upbank` int(11) NOT NULL DEFAULT '0',
  `twix` float DEFAULT '0',
  `pobed` int(11) DEFAULT '0',
  `poraj` int(11) DEFAULT '0',
  `nicka` int(11) DEFAULT '0',
  `stat` varchar(16) COLLATE utf8_unicode_ci DEFAULT 'moder',
  `ico` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ico0.png',
  `logo` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'klan0.png',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `clan_achat`;

CREATE TABLE `clan_achat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `kto` int(11) DEFAULT NULL,
  `komu` int(11) DEFAULT '0',
  `post` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_chat`;

CREATE TABLE `clan_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `kto` int(11) DEFAULT NULL,
  `komu` int(11) DEFAULT '0',
  `post` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_lenta`;

CREATE TABLE `clan_lenta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_news`;

CREATE TABLE `clan_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `mtime` int(11) NOT NULL,
  `head` varchar(128) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_news_comm`;

CREATE TABLE `clan_news_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `news` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `msg` varchar(512) NOT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_transfer`;

CREATE TABLE `clan_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `admin` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_user`;

CREATE TABLE `clan_user` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `klan` int(11) DEFAULT NULL,
  `level` smallint(6) DEFAULT '0',
  `reit` int(11) DEFAULT '0',
  `nreit` int(11) NOT NULL,
  `allreit` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `pobed` int(11) DEFAULT '0',
  `poraj` int(11) DEFAULT '0',
  `nicka` int(11) DEFAULT '0',
  `op` int(11) DEFAULT NULL,
  `stat` varchar(16) DEFAULT 'moder',
  `zvan` smallint(2) NOT NULL DEFAULT '0',
  `chattime` int(11) NOT NULL DEFAULT '0',
  `achattime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_garem`;

CREATE TABLE `cms_garem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_garem` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=496 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_garem_zapret`;

CREATE TABLE `cms_garem_zapret` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `coded_article`;

CREATE TABLE `coded_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `coded_comm`;

CREATE TABLE `coded_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `id_new` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `coded_razdel`;

CREATE TABLE `coded_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests`;

CREATE TABLE `contests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(2000) NOT NULL,
  `name` varchar(32) NOT NULL,
  `ntime` int(11) NOT NULL,
  `ktime` int(11) NOT NULL,
  `pol` set('0','1','2') NOT NULL,
  `type` set('0','1','2') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests_golos`;

CREATE TABLE `contests_golos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_golos` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `golos` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests_users`;

CREATE TABLE `contests_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `time` int(11) NOT NULL,
  `golos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cron`;

CREATE TABLE `cron` (
  `id` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cron VALUES("clear_tmp_dir","1597687251");
INSERT INTO cron VALUES("visit","1487329071");
INSERT INTO cron VALUES("everyday","1597687545");
INSERT INTO cron VALUES("backup_mysql","1597687628");
INSERT INTO cron VALUES("birthday","1597648732");



DROP TABLE IF EXISTS `derevolove_stena`;

CREATE TABLE `derevolove_stena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `dialog`;

CREATE TABLE `dialog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `type` char(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `discussions`;

CREATE TABLE `discussions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `avtor` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `count` int(11) DEFAULT '0',
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `type` varchar(100) NOT NULL,
  `id_sim` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `discussions_set`;

CREATE TABLE `discussions_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `disc_status` int(11) DEFAULT '1',
  `disc_foto` int(11) DEFAULT '1',
  `disc_files` int(11) DEFAULT '1',
  `disc_forum` int(11) DEFAULT '1',
  `disc_notes` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `dogmat`;

CREATE TABLE `dogmat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `kid` int(11) NOT NULL,
  `iconse` varchar(21) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `doktor`;

CREATE TABLE `doktor` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `duel`;

CREATE TABLE `duel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_opponent` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `win` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `duel_new`;

CREATE TABLE `duel_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_opponent` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `duel_stat`;

CREATE TABLE `duel_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_duel` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `voted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `durak`;

CREATE TABLE `durak` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_prot` int(11) NOT NULL,
  `stav` int(11) DEFAULT '0',
  `hod` int(11) DEFAULT '0',
  `kozar` int(11) DEFAULT '0',
  `karta` varchar(3) DEFAULT NULL,
  `read` int(3) DEFAULT '0',
  `over_hod` int(11) DEFAULT NULL,
  `game_over` int(1) DEFAULT NULL,
  `status` int(1) DEFAULT '0',
  `koloda` varchar(20) DEFAULT 'default',
  `chat` int(20) DEFAULT '0',
  `level` int(11) DEFAULT '0',
  `bit` int(11) DEFAULT '0',
  `hodit` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_chat`;

CREATE TABLE `durak_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_game`;

CREATE TABLE `durak_game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `karta` varchar(11) DEFAULT '0',
  `sila` int(11) DEFAULT '0',
  `mast` int(11) DEFAULT '0',
  `on` int(1) DEFAULT '0',
  `time` int(12) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_hod`;

CREATE TABLE `durak_hod` (
  `name` varchar(4) DEFAULT NULL,
  `num` int(11) DEFAULT '0',
  `id_game` int(11) DEFAULT '0',
  `kozar` int(1) DEFAULT '0',
  `sila` int(3) DEFAULT '0',
  `id_user` int(3) DEFAULT '0',
  `mast` int(3) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_karty`;

CREATE TABLE `durak_karty` (
  `name` varchar(4) DEFAULT NULL,
  `sila` int(3) DEFAULT '0',
  `mast` int(3) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO durak_karty VALUES("Tp","9","3");
INSERT INTO durak_karty VALUES("Kb","8","4");
INSERT INTO durak_karty VALUES("9b","4","4");
INSERT INTO durak_karty VALUES("6b","1","4");
INSERT INTO durak_karty VALUES("Tb","9","4");
INSERT INTO durak_karty VALUES("10b","5","4");
INSERT INTO durak_karty VALUES("Kp","8","3");
INSERT INTO durak_karty VALUES("Db","7","4");
INSERT INTO durak_karty VALUES("8b","3","4");
INSERT INTO durak_karty VALUES("7b","2","4");
INSERT INTO durak_karty VALUES("Vb","6","4");
INSERT INTO durak_karty VALUES("Dp","7","3");
INSERT INTO durak_karty VALUES("9p","4","3");
INSERT INTO durak_karty VALUES("Tc","9","2");
INSERT INTO durak_karty VALUES("10c","5","2");
INSERT INTO durak_karty VALUES("7k","2","1");
INSERT INTO durak_karty VALUES("6c","1","2");
INSERT INTO durak_karty VALUES("Vk","6","1");
INSERT INTO durak_karty VALUES("10p","5","3");
INSERT INTO durak_karty VALUES("6p","1","3");
INSERT INTO durak_karty VALUES("Vc","6","2");
INSERT INTO durak_karty VALUES("8k","3","1");
INSERT INTO durak_karty VALUES("7c","2","2");
INSERT INTO durak_karty VALUES("Dk","7","1");
INSERT INTO durak_karty VALUES("8p","3","3");
INSERT INTO durak_karty VALUES("Kc","8","2");
INSERT INTO durak_karty VALUES("9c","4","2");
INSERT INTO durak_karty VALUES("6k","1","1");
INSERT INTO durak_karty VALUES("Tk","9","1");
INSERT INTO durak_karty VALUES("10k","5","1");
INSERT INTO durak_karty VALUES("Vp","6","3");
INSERT INTO durak_karty VALUES("7p","2","3");
INSERT INTO durak_karty VALUES("Dc","7","2");
INSERT INTO durak_karty VALUES("9k","4","1");
INSERT INTO durak_karty VALUES("8c","3","2");
INSERT INTO durak_karty VALUES("Kk","8","1");



DROP TABLE IF EXISTS `f_message`;

CREATE TABLE `f_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  `whoedit` int(11) NOT NULL DEFAULT '0',
  `date` char(20) NOT NULL,
  `podforum` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `best` tinyint(1) NOT NULL DEFAULT '0',
  `worse` tinyint(1) NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_pod`;

CREATE TABLE `f_pod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_razdel`;

CREATE TABLE `f_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  `ico` char(6) NOT NULL,
  `opis` char(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_them`;

CREATE TABLE `f_them` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(11) NOT NULL DEFAULT '0',
  `name` char(255) NOT NULL DEFAULT '',
  `author` int(11) NOT NULL DEFAULT '0',
  `close` smallint(2) NOT NULL DEFAULT '0',
  `whoedit` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `firstpost` text NOT NULL,
  `fix` smallint(2) NOT NULL DEFAULT '0',
  `razdel_id` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  `quest` char(255) NOT NULL,
  `var1` char(30) NOT NULL,
  `var2` char(30) NOT NULL,
  `var3` char(30) NOT NULL,
  `var4` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_votes`;

CREATE TABLE `f_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `them` int(11) NOT NULL DEFAULT '0',
  `var` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `farm_ambar`;

CREATE TABLE `farm_ambar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1235 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_conf`;

CREATE TABLE `farm_conf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `weather` enum('1','2','3','4','5') DEFAULT '1',
  `time_weather` int(11) NOT NULL DEFAULT '0' COMMENT 'Время до следующего обновления погоды',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO farm_conf VALUES("3","3","1327857813");
INSERT INTO farm_conf VALUES("4","1","1593867194");
INSERT INTO farm_conf VALUES("5","3","1593967262");
INSERT INTO farm_conf VALUES("6","2","1594060171");
INSERT INTO farm_conf VALUES("7","5","1594668343");
INSERT INTO farm_conf VALUES("8","3","1594970847");
INSERT INTO farm_conf VALUES("9","4","1595093450");
INSERT INTO farm_conf VALUES("10","3","1595355194");
INSERT INTO farm_conf VALUES("11","2","1595595386");
INSERT INTO farm_conf VALUES("12","2","1595748141");
INSERT INTO farm_conf VALUES("13","5","1596141721");
INSERT INTO farm_conf VALUES("14","5","1596284334");
INSERT INTO farm_conf VALUES("15","2","1596315266");
INSERT INTO farm_conf VALUES("16","5","1596380292");



DROP TABLE IF EXISTS `farm_dog`;

CREATE TABLE `farm_dog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1053 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_event`;

CREATE TABLE `farm_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=1131 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `farm_gr`;

CREATE TABLE `farm_gr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `woter` int(11) NOT NULL DEFAULT '0',
  `time_water` int(11) DEFAULT NULL COMMENT 'Время полива',
  `kol` varchar(1024) DEFAULT NULL COMMENT 'Количество урожая',
  `time` varchar(1024) DEFAULT NULL,
  `vskop` enum('1','0') NOT NULL DEFAULT '0' COMMENT 'Скопана ли грядка??',
  `sezon` int(11) NOT NULL DEFAULT '1' COMMENT 'Сезон растения на грядке',
  `udobr` enum('1','0') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1129 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_plant`;

CREATE TABLE `farm_plant` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) NOT NULL,
  `opis` varchar(1024) DEFAULT NULL,
  `cena` int(11) NOT NULL,
  `dohod` varchar(1024) NOT NULL,
  `rand1` varchar(1024) NOT NULL,
  `rand2` varchar(1024) NOT NULL,
  `oput` varchar(1024) NOT NULL,
  `xp` float NOT NULL DEFAULT '0' COMMENT 'Сколько здоровья за единицу',
  `let` int(11) NOT NULL DEFAULT '1',
  `time` varchar(1024) DEFAULT NULL,
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

INSERT INTO farm_plant VALUES("1","Горох","Самый быстросозреваемый и простойпродукт на ферме","50","4","19","20","1","1.8","1","10800","0");
INSERT INTO farm_plant VALUES("2","Свекла","Неплохой выбор для начала","50","5","20","22","1","3.6","1","14400","1");
INSERT INTO farm_plant VALUES("3","Морковь","Неплохой выбор для начала","25","1.8","24","25","1","5","1","18000","2");
INSERT INTO farm_plant VALUES("4","Оливки","Помогает быстро набрать опыта","30","5","24","25","1","1.8","1","21600","2");
INSERT INTO farm_plant VALUES("5","Огурец","Приносит неплохое количество опыта","50","5","29","30","1","1.2","1","14400","3");
INSERT INTO farm_plant VALUES("6","Фасоль","Хороший друг фермеров","30","6","24","25","1","3","1","21600","3");
INSERT INTO farm_plant VALUES("7","Салат","Прибыльное растение","70","5","37","38","1","0.6","1","14400","4");
INSERT INTO farm_plant VALUES("8","Перец Индало","Малоурожайный, но приносящий много опыта перец","22","31","3","4","6","1.5","1","14400","4");
INSERT INTO farm_plant VALUES("9","Чеснок","Хороший овощ для обогащения","30","7","34","35","1","1.2","1","21600","5");
INSERT INTO farm_plant VALUES("10","Зелёный перец","Дорогой и выгодным фермерам овощ","30","15","29","30","3","1.2","1","50400","5");
INSERT INTO farm_plant VALUES("11","Арахис","Хороший и выгодный по многимпараметрам","30","4","57","58","1","0.9","1","28800","5");
INSERT INTO farm_plant VALUES("12","Лук","Довольно выгодный овощ по многимпараметрам","115","10","39","40","2","0.9","1","28800","6");
INSERT INTO farm_plant VALUES("13","Усатый горох","Очень скороспелый и неплохосбалансированный","75","6","29","30","1","0.9","1","10800","7");
INSERT INTO farm_plant VALUES("14","Помидор","Очень плодовитый овощ","100","9","64","65","2","1.2","1","43200","8");
INSERT INTO farm_plant VALUES("15","Болгарский перец","Очень полезный овощ в плане обучения инабирания опыта","125","30","20","21","6","1.3","1","43200","9");
INSERT INTO farm_plant VALUES("16","Китайский лук","Очень быстро растет","52","6","36","37","1","0.3","1","14400","10");
INSERT INTO farm_plant VALUES("17","Перец чили","Долго растет и не очень урожайный,затовесьма дорогой","270","65","20","21","11","1.6","1","86400","11");
INSERT INTO farm_plant VALUES("18","Кукуруза","Долго растет,зато весьма выгодна","340","31","60","61","7","0.9","1","115200","12");
INSERT INTO farm_plant VALUES("19","Капуста","Достаточно быстро растет","315","31","27","28","6","1.5","1","36000","13");
INSERT INTO farm_plant VALUES("20","Кабачок","Быстро созревает,но мало чему учит вплане опыта","170","25","25","26","6","1.8","1","28800","14");
INSERT INTO farm_plant VALUES("21","Лук батун","Созревает быстро.Цена и получаемыйопыт средние","100","19","32","33","6","0.9","1","28800","15");
INSERT INTO farm_plant VALUES("22","Американский картофель","Недорогой и практичный овощ","150","23","41","42","7","3","1","43200","16");
INSERT INTO farm_plant VALUES("23","Брюссельская капуста","Довольно выгодный сорт капусты","80","57","20","21","16","1.8","1","57600","17");
INSERT INTO farm_plant VALUES("24","Укроп","Один из самых быстровырастаемыхжителей ваших грядок","103","12","31","32","3","0.6","1","14400","18");
INSERT INTO farm_plant VALUES("25","Слива","Первое из многолетних растений","15000","41","59","60","7","0.7","15","64800","19");
INSERT INTO farm_plant VALUES("26","Дикая яблоня","Растет достаточно быстро длямноголетних","800","30","44","45","7","0.9","5","50400","20");
INSERT INTO farm_plant VALUES("27","Клубника","Многолетняя ягода","2850","53","34","35","7","0.9","3","36000","21");
INSERT INTO farm_plant VALUES("28","Дикая груша","Этот фрукт созревает обычно достаточнобыстро","4900","45","38","39","8","0.9","8","43200","22");
INSERT INTO farm_plant VALUES("29","Антоновка","Распространенный сорт яблок","13000","60","50","51","13","0.6","20","86400","23");
INSERT INTO farm_plant VALUES("30","Лимон","Растет чуть дольше,чем большинстводругих,но более выгоден","40000","152","34","35","31","0.4","5","86400","24");
INSERT INTO farm_plant VALUES("31","Грецкий орех","Как и лимон,растет дольше,но в планеопыта очень хорош","14000","91","44","45","46","5","15","93600","25");
INSERT INTO farm_plant VALUES("32","Апельсин","Весьма плодовитый","34000","79","64","65","30","6","15","79200","26");
INSERT INTO farm_plant VALUES("33","Банан","Не такие прибыльные,зато полезные дляопыта","10200","60","44","45","27","10","10","43200","27");
INSERT INTO farm_plant VALUES("34","Ананас","Сбалансированный фрукт","2500","63","59","60","51","7","15","86400","28");
INSERT INTO farm_plant VALUES("35","Папайя","Долгосозревающий фрукт","14200","120","49","50","117","12","12","108000","29");
INSERT INTO farm_plant VALUES("36","Манго","Долго созревает","12200","500","14","15","545","35","8","126000","30");
INSERT INTO farm_plant VALUES("37","Вишня","Практичная и недорогая","800","60","54","55","81","10","15","64800","31");
INSERT INTO farm_plant VALUES("38","Малазийский арбуз","Созревает весьма быстро","3700","94","19","20","79","32","5","21600","32");
INSERT INTO farm_plant VALUES("39","Лайм","Хорошо восстанавливает здоровье иочень полезен","7500","200","24","25","153","65","8","50400","33");
INSERT INTO farm_plant VALUES("40","Маракуйя","Недолговечный,но выгодный фрукт","6350","250","19","20","256","25","4","61200","34");
INSERT INTO farm_plant VALUES("41","Белая клубника","Быстро вырастает","2150","200","9","10","321","15","6","28800","34");
INSERT INTO farm_plant VALUES("42","Груша Моренцо","Сбалансированный по опыту и прибылифрукт","11000","200","19","20","231","20","12","54000","35");
INSERT INTO farm_plant VALUES("43","Киви","Высокоурожайное растение","11300","80","64","65","98","12","8","64800","36");
INSERT INTO farm_plant VALUES("44","Амазонская дыня","Быстро созревает и недолго живет","6100","300","9","10","267","30","4","25200","37");
INSERT INTO farm_plant VALUES("45","Яблоко Голиафа","Долго созревает,но саженцы стоятнедорого","200","173","49","50","314","5","10","144000","38");
INSERT INTO farm_plant VALUES("46","Мандариновый апельсин","Позволяет получить много опыта исозревает достаточно быстро","4600","85","34","35","136","6","12","43200","39");
INSERT INTO farm_plant VALUES("47","Смородина","Дешевая и выгодная ягода","750","115","19","20","201","15","8","36000","40");
INSERT INTO farm_plant VALUES("48","Фисташки","Долгосозревающее и такжедолгоживущее растение","13000","550","15","16","975","20","40","129600","41");
INSERT INTO farm_plant VALUES("49","Сладкий лимон","Очень плодоносное растение,хотя инедолговечное.","14400","102","79","80","139","30","5","86400","42");
INSERT INTO farm_plant VALUES("50","Мисакр","Экзотичная ягода с хорошимихарактеристиками","5000","84","44","45","164","10","8","50400","43");
INSERT INTO farm_plant VALUES("51","Патомак","У этого растения, в отличие отбольшинства ценятся именно корни,а нелистья или плоды. Оно быстро созревает,неплохо плодоносит, но и живет тоженедолго.","4960","70","49","50","95","5","3","28800","44");
INSERT INTO farm_plant VALUES("52","Мягоцвет","Очень быстро созревающая трава. Пустьона не очень плодоносная, зато скоростьее роста многое окупает.","600","112","9","10","293","1","3","14400","45");



DROP TABLE IF EXISTS `farm_semen`;

CREATE TABLE `farm_semen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `sezon` int(11) NOT NULL DEFAULT '1' COMMENT 'Сезон растения на грядке',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1078 DEFAULT CHARSET=cp1251;

INSERT INTO farm_semen VALUES("1077","1","1","10","1");



DROP TABLE IF EXISTS `farm_udobr`;

CREATE TABLE `farm_udobr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `udobr` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1047 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_udobr_name`;

CREATE TABLE `farm_udobr_name` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) NOT NULL,
  `cena` varchar(1024) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO farm_udobr_name VALUES("1","Курник","50","3600");
INSERT INTO farm_udobr_name VALUES("2","Торф","200","14400");
INSERT INTO farm_udobr_name VALUES("3","Компост","500","18000");
INSERT INTO farm_udobr_name VALUES("4","Азот","1000","36000");
INSERT INTO farm_udobr_name VALUES("5","Коровяк","3000","54000");



DROP TABLE IF EXISTS `farm_user`;

CREATE TABLE `farm_user` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `posadka` int(11) NOT NULL DEFAULT '0',
  `posadka_1` enum('1','0') NOT NULL DEFAULT '0',
  `posadka_2` enum('1','0') NOT NULL DEFAULT '0',
  `posadka_3` enum('1','0') NOT NULL DEFAULT '0',
  `poliv` int(11) NOT NULL DEFAULT '0',
  `poliv_1` enum('1','0') NOT NULL DEFAULT '0',
  `poliv_2` enum('1','0') NOT NULL DEFAULT '0',
  `poliv_3` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie` int(11) NOT NULL DEFAULT '0',
  `udobrenie_1` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie_2` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie_3` enum('1','0') NOT NULL DEFAULT '0',
  `gems` int(11) NOT NULL DEFAULT '0',
  `xp` int(11) NOT NULL DEFAULT '100',
  `gold` int(11) NOT NULL DEFAULT '10000',
  `exp` int(11) NOT NULL DEFAULT '0',
  `lеvеl` int(11) NOT NULL DEFAULT '0',
  `k_poliv` int(11) NOT NULL DEFAULT '0',
  `k_posadka` int(11) NOT NULL DEFAULT '0',
  `k_posadka_time` int(11) NOT NULL DEFAULT '0',
  `k_poliv_time` int(11) NOT NULL DEFAULT '0',
  `zabor_time` int(11) NOT NULL DEFAULT '0',
  `teplica` enum('1','0') NOT NULL DEFAULT '0',
  `razvedka` enum('1','0') NOT NULL DEFAULT '0',
  `selection` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO farm_user VALUES("271","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("1","0","0","0","0","0","0","0","0","0","0","0","0","0","100","9500","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("362","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("551","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("506","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("501","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("516","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("572","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("550","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("557","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("585","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("590","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("425","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");



DROP TABLE IF EXISTS `farm_vor`;

CREATE TABLE `farm_vor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `gr` int(11) DEFAULT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1037 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `fk`;

CREATE TABLE `fk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(111) DEFAULT NULL,
  `rules` varchar(1111) DEFAULT NULL,
  `id_user` int(11) NOT NULL,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  `kol_vo` int(11) NOT NULL,
  `skolko` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `pobeda` int(11) NOT NULL,
  `pobeda2` int(11) NOT NULL,
  `pobeda3` int(11) NOT NULL,
  `uchastie` int(11) NOT NULL,
  `golosue` int(11) NOT NULL,
  `images` varchar(111) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fk_discus`;

CREATE TABLE `fk_discus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fk_foto`;

CREATE TABLE `fk_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `golosov` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `images` varchar(111) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fk_golos`;

CREATE TABLE `fk_golos` (
  `id_foto` int(11) NOT NULL,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fl_notifs`;

CREATE TABLE `fl_notifs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `mail` int(11) NOT NULL DEFAULT '1',
  `notifications` int(11) NOT NULL DEFAULT '1',
  `new_friends` int(11) NOT NULL DEFAULT '1',
  `lst_mail_id` int(11) NOT NULL DEFAULT '0',
  `lst_notifications_id` int(11) NOT NULL DEFAULT '0',
  `lst_new_friends_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Всплывающие уведомления';




DROP TABLE IF EXISTS `fo_cat`;

CREATE TABLE `fo_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO fo_cat VALUES("1","Программы wap-мастеру");
INSERT INTO fo_cat VALUES("2","Скрипты php");
INSERT INTO fo_cat VALUES("3","Скрипты ajax и javascript");
INSERT INTO fo_cat VALUES("4","Темы для CMS");
INSERT INTO fo_cat VALUES("5","Модули для CMS");
INSERT INTO fo_cat VALUES("6","Аудио/Видео уроки");
INSERT INTO fo_cat VALUES("7","JAR Учебники");
INSERT INTO fo_cat VALUES("8","Все для дизайна и дизайнеров");



DROP TABLE IF EXISTS `fo_files`;

CREATE TABLE `fo_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` char(100) NOT NULL,
  `time` int(11) NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL,
  `title` char(100) NOT NULL,
  `info` text NOT NULL,
  `parol` char(10) DEFAULT NULL,
  `moder` smallint(2) NOT NULL DEFAULT '0',
  `rid` int(11) NOT NULL DEFAULT '0',
  `cat` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fo_komm`;

CREATE TABLE `fo_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fo_pod`;

CREATE TABLE `fo_pod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `title` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO fo_pod VALUES("1","1","JAVA программы");
INSERT INTO fo_pod VALUES("2","1","Софт для WindowsMobile");
INSERT INTO fo_pod VALUES("3","1","Программы для ANDROID");
INSERT INTO fo_pod VALUES("4","1","Программы для Symbian");
INSERT INTO fo_pod VALUES("5","1","Программы для WINDOWS ПК");
INSERT INTO fo_pod VALUES("6","1","Системы защиты php кода");
INSERT INTO fo_pod VALUES("7","2","Скрипты php web");
INSERT INTO fo_pod VALUES("8","2","Скрипты php wap");
INSERT INTO fo_pod VALUES("9","6","Как эффективно продвинуть сайт в интернете");
INSERT INTO fo_pod VALUES("10","6","SeO раскрутка, анализ, ключевые слова");
INSERT INTO fo_pod VALUES("11","6","Как устроен GOOGLE + История");
INSERT INTO fo_pod VALUES("12","6","Оптимизация, ТиЦ и PR");
INSERT INTO fo_pod VALUES("13","6","Создание и раскрутка сайта / блога");
INSERT INTO fo_pod VALUES("14","3","ASP скрипты");
INSERT INTO fo_pod VALUES("15","3","Ajax скрипты");
INSERT INTO fo_pod VALUES("16","3","JavaScript");
INSERT INTO fo_pod VALUES("17","4","DCMS 6.6.x");
INSERT INTO fo_pod VALUES("18","4","DCMS 6.7.x");
INSERT INTO fo_pod VALUES("19","4","Wap-Motor");
INSERT INTO fo_pod VALUES("20","4","DCMS 7.0.x");
INSERT INTO fo_pod VALUES("21","4","MobileCMS");
INSERT INTO fo_pod VALUES("22","4","JohnCMS");
INSERT INTO fo_pod VALUES("23","4","php bb wap");
INSERT INTO fo_pod VALUES("24","5","DCMS модули");
INSERT INTO fo_pod VALUES("25","5","Wap-Motor модули");
INSERT INTO fo_pod VALUES("26","5","Wap-Engine");
INSERT INTO fo_pod VALUES("27","5","JohnCMS модули");
INSERT INTO fo_pod VALUES("28","5","MobileCMS");
INSERT INTO fo_pod VALUES("29","5","RotorCMS");
INSERT INTO fo_pod VALUES("30","5","phpBB-WAP моды");
INSERT INTO fo_pod VALUES("31","5","Разные CMS");
INSERT INTO fo_pod VALUES("32","7","WML");
INSERT INTO fo_pod VALUES("33","7","HTML");
INSERT INTO fo_pod VALUES("34","7","PHP");
INSERT INTO fo_pod VALUES("35","7","CSS");
INSERT INTO fo_pod VALUES("36","7","JAVA");
INSERT INTO fo_pod VALUES("37","7","MySQL");
INSERT INTO fo_pod VALUES("38","8","Дизайнеру + CSS");
INSERT INTO fo_pod VALUES("39","8","Иконки и графика");
INSERT INTO fo_pod VALUES("40","8","Touch (Тач) дизайны");
INSERT INTO fo_pod VALUES("41","2","Скрипты Вобля");
INSERT INTO fo_pod VALUES("42","2","Чаты");



DROP TABLE IF EXISTS `fortune`;

CREATE TABLE `fortune` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `v` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `fart` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO fortune VALUES("1","Обезьянка","0","100","4","2");
INSERT INTO fortune VALUES("4","Котёнок","2","2","4","2");
INSERT INTO fortune VALUES("2","Цветок","0","100","3","1");
INSERT INTO fortune VALUES("3","Подарок","0","100","5","3");
INSERT INTO fortune VALUES("5","Пламя","0","50","2","2");
INSERT INTO fortune VALUES("6","Монеты","0","200","2","3");
INSERT INTO fortune VALUES("7","Бабочка","1","1000","4","2");
INSERT INTO fortune VALUES("8","Пара","0","50","5","3");
INSERT INTO fortune VALUES("9","Девушка","0","70","4","2");
INSERT INTO fortune VALUES("10","Банкрот","0","100","10","5");



DROP TABLE IF EXISTS `fortune_history`;

CREATE TABLE `fortune_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `f` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=7772 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fortune_us`;

CREATE TABLE `fortune_us` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `fart` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3665 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_f`;

CREATE TABLE `forum_f` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `pos` int(11) NOT NULL,
  `opis` varchar(512) NOT NULL,
  `adm` set('0','1') NOT NULL DEFAULT '0',
  `icon` varchar(30) DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO forum_f VALUES("1","Музыка","7","Все,что связано с музыкой .музон.","0","f_music.gif");
INSERT INTO forum_f VALUES("2","Игры и развлечения","4","Игры и конкурсы сайта .болельщица.","0","f_mobil.gif");
INSERT INTO forum_f VALUES("3","Любовь/ Секс/ Дружба/ Отношения","5","Все о любви, дружбе, отношении и сексе!.ах.","0","F_seks.gif");
INSERT INTO forum_f VALUES("4","Досуг и увличения","6","Отдых, Туризм, Кино, Авто/Мото и многое другое .пишу.","0","f_dosug.gif");
INSERT INTO forum_f VALUES("5"," Мобильные телефоны","8","Обсуждение телефонов,покупка продажа! .чит3.","0","f_vse_mobil.gif");
INSERT INTO forum_f VALUES("6","Тематические форумы","3","Обо всем на свете! .чит2.","0","f_tematijka.gif");
INSERT INTO forum_f VALUES("7","Общение и знакомство ","2","Общение между пользователями нашего сайта .дружба.","0","f_obshenie.gif");
INSERT INTO forum_f VALUES("8","НоВоСтИ ФоРуМа","1",".ор.","0","f_news.gif");
INSERT INTO forum_f VALUES("9","Компьютеры","9","Все о компьютерах .чит.","0","f_jkomp.gif");
INSERT INTO forum_f VALUES("10","Беспредел","10","No comments... .дразнилка.","0","bespredel.gif");
INSERT INTO forum_f VALUES("11","Помощь НОВЕЧКАМ","11","ЧИТАТЬ ВСЕМ","0","default.png");
INSERT INTO forum_f VALUES("12",".игрыраз. ","12","Играем и выигрываем","0","f_dosug.gif");
INSERT INTO forum_f VALUES("13","Кулинария","6","Разные рецепты","0","f_news.gif");



DROP TABLE IF EXISTS `forum_files`;

CREATE TABLE `forum_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_post` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `ras` varchar(32) NOT NULL,
  `size` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_post` (`id_post`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_files_rating`;

CREATE TABLE `forum_files_rating` (
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  KEY `id_file` (`id_file`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_p`;

CREATE TABLE `forum_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `cit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`),
  KEY `id_forum` (`id_forum`),
  KEY `id_razdel` (`id_razdel`),
  KEY `id_them` (`id_them`),
  FULLTEXT KEY `msg` (`msg`)
) ENGINE=MyISAM AUTO_INCREMENT=566 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_r`;

CREATE TABLE `forum_r` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`time`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

INSERT INTO forum_r VALUES("1","8","Баги/ошибки","1591340056");
INSERT INTO forum_r VALUES("2","8","Акции","1592398321");
INSERT INTO forum_r VALUES("3","8","Предложения","1590598419");
INSERT INTO forum_r VALUES("4","7","Общение","1590598438");
INSERT INTO forum_r VALUES("5","6","Факты","1592767366");
INSERT INTO forum_r VALUES("6","6","Психология","1591253717");
INSERT INTO forum_r VALUES("7","6","Субкультура","1591273244");
INSERT INTO forum_r VALUES("8","6","Разное","1592767730");
INSERT INTO forum_r VALUES("24","6","Наука","1592029212");
INSERT INTO forum_r VALUES("10","6","Мистика","1591254179");
INSERT INTO forum_r VALUES("11","2","Игры форума","1597674900");
INSERT INTO forum_r VALUES("12","2","Игры на валюту","1597692240");
INSERT INTO forum_r VALUES("13","2","Конкурсы","1590598569");
INSERT INTO forum_r VALUES("14","3","Любовь","1592766299");
INSERT INTO forum_r VALUES("15","3","Дружба","1592808270");
INSERT INTO forum_r VALUES("16","3","Флирт","1592992711");
INSERT INTO forum_r VALUES("17","3","Отношения","1592807858");
INSERT INTO forum_r VALUES("18","4","Авто/мото","1590598668");
INSERT INTO forum_r VALUES("19","4","Рыбалка/охота","1590598688");
INSERT INTO forum_r VALUES("20","4","Увлечения","1590598705");
INSERT INTO forum_r VALUES("21","4","Животный  мир","1590598723");
INSERT INTO forum_r VALUES("22","5","Браузеры","1590657442");
INSERT INTO forum_r VALUES("23","5","Новинки","1590657875");
INSERT INTO forum_r VALUES("25","6","Медицина/здоровье","1591253905");
INSERT INTO forum_r VALUES("26","8","Конкурсы","1591017640");
INSERT INTO forum_r VALUES("27","13","Выпечка","1591353497");
INSERT INTO forum_r VALUES("28","13","Закатки на зиму","1591352990");
INSERT INTO forum_r VALUES("29","13","Десерты","1591805407");
INSERT INTO forum_r VALUES("33","2","Игры от Администрации","1597626801");



DROP TABLE IF EXISTS `forum_t`;

CREATE TABLE `forum_t` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) DEFAULT NULL,
  `name` varchar(32) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `up` set('0','1') NOT NULL DEFAULT '0',
  `close` set('0','1') NOT NULL DEFAULT '0',
  `text` varchar(2000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`id_razdel`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_zakl`;

CREATE TABLE `forum_zakl` (
  `id_user` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_obn` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_them`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `frends`;

CREATE TABLE `frends` (
  `user` int(11) NOT NULL DEFAULT '0',
  `frend` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `i` int(1) DEFAULT '0',
  `lenta_forum` int(11) NOT NULL DEFAULT '1',
  `lenta_obmen` int(11) NOT NULL DEFAULT '1',
  `lenta_foto` int(11) NOT NULL DEFAULT '1',
  `lenta_notes` int(11) NOT NULL DEFAULT '1',
  `lenta_avatar` int(11) DEFAULT '1',
  `lenta_frends` int(1) DEFAULT '1',
  `lenta_status` int(1) DEFAULT '1',
  `lenta_status_like` int(1) DEFAULT '1',
  `disc_forum` int(11) NOT NULL DEFAULT '1',
  `disc_obmen` int(11) NOT NULL DEFAULT '1',
  `disc_foto` int(11) NOT NULL DEFAULT '1',
  `disc_notes` int(11) NOT NULL DEFAULT '1',
  `disc_frends` int(1) DEFAULT '1',
  `disc_status` int(1) DEFAULT '1',
  `lenta_poll` int(1) DEFAULT '1',
  `lenta_poll_like` int(1) DEFAULT '1',
  `lenta_poll_vote` int(1) DEFAULT '1',
  PRIMARY KEY (`user`,`frend`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `frends_new`;

CREATE TABLE `frends_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=527 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `friends`;

CREATE TABLE `friends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  `zajavka` smallint(2) NOT NULL DEFAULT '0',
  `group` char(15) NOT NULL,
  `friendtext` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `g_rajt`;

CREATE TABLE `g_rajt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_ank` int(11) NOT NULL DEFAULT '0',
  `ocenka` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery`;

CREATE TABLE `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `opis` varchar(256) NOT NULL,
  `pass` varchar(11) DEFAULT NULL,
  `privat` int(11) NOT NULL,
  `privat_komm` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=346 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery_foto`;

CREATE TABLE `gallery_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gallery` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `ras` varchar(4) NOT NULL,
  `type` varchar(64) NOT NULL,
  `opis` varchar(1024) NOT NULL,
  `effects` text,
  `rating` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  `avatar` enum('0','1') DEFAULT '0',
  `pass` varchar(11) DEFAULT NULL,
  `people` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `metka` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_gallery` (`id_gallery`)
) ENGINE=MyISAM AUTO_INCREMENT=626 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery_komm`;

CREATE TABLE `gallery_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery_rating`;

CREATE TABLE `gallery_rating` (
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) NOT NULL DEFAULT '0',
  `avtor` int(11) NOT NULL DEFAULT '0',
  `ready` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `read` int(1) DEFAULT '1',
  KEY `id_foto` (`id_foto`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs`;

CREATE TABLE `gangs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rating` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL DEFAULT '0',
  `status` varchar(250) NOT NULL,
  `name` varchar(50) NOT NULL,
  `block` set('0','1') NOT NULL DEFAULT '0',
  `cena` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `divident` int(11) NOT NULL,
  `closed` set('0','1','2','3') NOT NULL DEFAULT '0',
  `type` set('0','1','2') NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rating` (`rating`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_enemies`;

CREATE TABLE `gangs_enemies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_invite`;

CREATE TABLE `gangs_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kont` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_gang` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_minichat`;

CREATE TABLE `gangs_minichat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(500) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_news`;

CREATE TABLE `gangs_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `msg` varchar(500) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2674 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_users`;

CREATE TABLE `gangs_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `status` set('0','1','2') NOT NULL DEFAULT '0',
  `type` set('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=55 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gazeta`;

CREATE TABLE `gazeta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(10024) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `title` varchar(32) DEFAULT NULL,
  `main_time` int(11) NOT NULL DEFAULT '0',
  `avtor` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gazeta_article`;

CREATE TABLE `gazeta_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `path` char(50) NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gazeta_comm`;

CREATE TABLE `gazeta_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `id_new` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gazeta_komm`;

CREATE TABLE `gazeta_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `id_gazeta` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gazeta_razdel`;

CREATE TABLE `gazeta_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gift_categories`;

CREATE TABLE `gift_categories` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=30 DEFAULT CHARSET=cp1251;

INSERT INTO gift_categories VALUES("1","Добро пожаловать");
INSERT INTO gift_categories VALUES("2","цветы");
INSERT INTO gift_categories VALUES("26","Любовь");
INSERT INTO gift_categories VALUES("5","девушке");
INSERT INTO gift_categories VALUES("24","Драгоценности");
INSERT INTO gift_categories VALUES("23","С днём рождения");
INSERT INTO gift_categories VALUES("22","Праздники");
INSERT INTO gift_categories VALUES("18","Мужчинам");
INSERT INTO gift_categories VALUES("21","Пожелания");
INSERT INTO gift_categories VALUES("27","Доброе Утро");
INSERT INTO gift_categories VALUES("20","Обнимашки");
INSERT INTO gift_categories VALUES("25","8Марта");
INSERT INTO gift_categories VALUES("28","Друзяшкам");
INSERT INTO gift_categories VALUES("29","Именные цветули ");



DROP TABLE IF EXISTS `gift_list`;

CREATE TABLE `gift_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_category` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `money` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1142 DEFAULT CHARSET=cp1251;

INSERT INTO gift_list VALUES("1","1","добро пожаловать","5");
INSERT INTO gift_list VALUES("2","1","добро пожаловать","5");
INSERT INTO gift_list VALUES("4","1","добро пожаловать","5");
INSERT INTO gift_list VALUES("569","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("568","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("581","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("580","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("578","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("577","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("576","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("575","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("632","2","Цветы","200");
INSERT INTO gift_list VALUES("574","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("631","2","Цветы","200");
INSERT INTO gift_list VALUES("630","2","Цветы","200");
INSERT INTO gift_list VALUES("617","2","Цветы","200");
INSERT INTO gift_list VALUES("616","2","Цветы","200");
INSERT INTO gift_list VALUES("615","2","Цветы","200");
INSERT INTO gift_list VALUES("840","26","Люблю","200");
INSERT INTO gift_list VALUES("839","26","Люблю","200");
INSERT INTO gift_list VALUES("844","26","Люблю","200");
INSERT INTO gift_list VALUES("886","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("838","26","Люблю","200");
INSERT INTO gift_list VALUES("842","26","Люблю","200");
INSERT INTO gift_list VALUES("841","26","Люблю","200");
INSERT INTO gift_list VALUES("837","26","Люблю","200");
INSERT INTO gift_list VALUES("836","26","Люблю","200");
INSERT INTO gift_list VALUES("835","26","Люблю","200");
INSERT INTO gift_list VALUES("834","26","Люблю","200");
INSERT INTO gift_list VALUES("689","5","Девушки","200");
INSERT INTO gift_list VALUES("687","2","Цветы","200");
INSERT INTO gift_list VALUES("686","2","Цветы","200");
INSERT INTO gift_list VALUES("685","2","Цветы","200");
INSERT INTO gift_list VALUES("684","2","Цветы","200");
INSERT INTO gift_list VALUES("683","2","Цветы","200");
INSERT INTO gift_list VALUES("682","2","Цветы","200");
INSERT INTO gift_list VALUES("681","2","Цветы","200");
INSERT INTO gift_list VALUES("680","2","Цветы","200");
INSERT INTO gift_list VALUES("775","20","котятка","200");
INSERT INTO gift_list VALUES("774","20","обнимочки","200");
INSERT INTO gift_list VALUES("773","20","зверятка","200");
INSERT INTO gift_list VALUES("698","5","Девушки","200");
INSERT INTO gift_list VALUES("697","5","Девушки","200");
INSERT INTO gift_list VALUES("696","5","Девушки","200");
INSERT INTO gift_list VALUES("884","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("883","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("882","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("881","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("690","5","Девушки","200");
INSERT INTO gift_list VALUES("702","2","Цветы","200");
INSERT INTO gift_list VALUES("703","20","Обнимашки","200");
INSERT INTO gift_list VALUES("880","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("736","5","Девушки","200");
INSERT INTO gift_list VALUES("735","5","Девушки","200");
INSERT INTO gift_list VALUES("734","5","Девушки","200");
INSERT INTO gift_list VALUES("833","26","Люблю","200");
INSERT INTO gift_list VALUES("731","5","Девушки","200");
INSERT INTO gift_list VALUES("730","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("728","21","Пожелания","20");
INSERT INTO gift_list VALUES("879","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("726","5","Девушки","200");
INSERT INTO gift_list VALUES("724","5","Девушки","200");
INSERT INTO gift_list VALUES("723","5","Девушки","200");
INSERT INTO gift_list VALUES("722","5","Девушки","200");
INSERT INTO gift_list VALUES("721","22","Праздники","300");
INSERT INTO gift_list VALUES("720","23","С днём рождения","300");
INSERT INTO gift_list VALUES("719","21","Пожелания","150");
INSERT INTO gift_list VALUES("718","21","Пожелания","150");
INSERT INTO gift_list VALUES("717","21","Пожелания","150");
INSERT INTO gift_list VALUES("716","21","Пожелания","150");
INSERT INTO gift_list VALUES("715","21","Пожелания","150");
INSERT INTO gift_list VALUES("714","21","Пожелания","150");
INSERT INTO gift_list VALUES("713","21","Пожелания","150");
INSERT INTO gift_list VALUES("712","21","Пожелания","150");
INSERT INTO gift_list VALUES("711","21","Пожелания","150");
INSERT INTO gift_list VALUES("710","21","Пожелания","150");
INSERT INTO gift_list VALUES("709","21","Пожелания","150");
INSERT INTO gift_list VALUES("832","26","Люблю","200");
INSERT INTO gift_list VALUES("831","26","Люблю","200");
INSERT INTO gift_list VALUES("830","26","Люблю","200");
INSERT INTO gift_list VALUES("772","20","обнимульки","200");
INSERT INTO gift_list VALUES("771","20","цел и об","200");
INSERT INTO gift_list VALUES("770","20","котята","200");
INSERT INTO gift_list VALUES("769","20","обнимашка","200");
INSERT INTO gift_list VALUES("768","20","обним","200");
INSERT INTO gift_list VALUES("767","18","Мужчинам","300");
INSERT INTO gift_list VALUES("766","23","С днём рождения","300");
INSERT INTO gift_list VALUES("765","23","С днём рождения","300");
INSERT INTO gift_list VALUES("764","22","Праздники","300");
INSERT INTO gift_list VALUES("763","22","Праздники","300");
INSERT INTO gift_list VALUES("762","22","Праздники","300");
INSERT INTO gift_list VALUES("761","22","Праздники","300");
INSERT INTO gift_list VALUES("760","22","Праздники","300");
INSERT INTO gift_list VALUES("759","22","Праздники","300");
INSERT INTO gift_list VALUES("758","22","Праздники","300");
INSERT INTO gift_list VALUES("757","22","Праздники","300");
INSERT INTO gift_list VALUES("756","22","Праздники","300");
INSERT INTO gift_list VALUES("755","22","Праздники","300");
INSERT INTO gift_list VALUES("829","26","Люблю","200");
INSERT INTO gift_list VALUES("753","22","Праздники","300");
INSERT INTO gift_list VALUES("752","22","Праздники","300");
INSERT INTO gift_list VALUES("751","22","Праздники","300");
INSERT INTO gift_list VALUES("750","21","Пожелания","150");
INSERT INTO gift_list VALUES("749","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("746","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("744","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("743","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("741","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("567","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("885","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("477","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("478","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("571","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("570","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("566","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("588","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("701","5","Девушки","200");
INSERT INTO gift_list VALUES("700","5","Девушки","200");
INSERT INTO gift_list VALUES("629","2","Цветы","200");
INSERT INTO gift_list VALUES("628","2","Цветы","200");
INSERT INTO gift_list VALUES("614","2","Цветы","200");
INSERT INTO gift_list VALUES("627","2","Цветы","200");
INSERT INTO gift_list VALUES("613","2","Цветы","200");
INSERT INTO gift_list VALUES("626","2","Цветы","200");
INSERT INTO gift_list VALUES("624","2","Цветы","200");
INSERT INTO gift_list VALUES("611","2","Цветы","200");
INSERT INTO gift_list VALUES("610","2","Цветы","200");
INSERT INTO gift_list VALUES("609","2","Цветы","200");
INSERT INTO gift_list VALUES("618","2","Цветы","200");
INSERT INTO gift_list VALUES("619","2","Цветы","200");
INSERT INTO gift_list VALUES("621","2","Цветы","200");
INSERT INTO gift_list VALUES("608","2","Добро пожаловать","200");
INSERT INTO gift_list VALUES("620","2","Цветы","200");
INSERT INTO gift_list VALUES("606","2","Цветы","200");
INSERT INTO gift_list VALUES("607","2","Цветы","200");
INSERT INTO gift_list VALUES("523","2","Цветы ","200");
INSERT INTO gift_list VALUES("612","2","Добро пожаловать","200");
INSERT INTO gift_list VALUES("586","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("622","2","Цветы","200");
INSERT INTO gift_list VALUES("605","2","Цветы","200");
INSERT INTO gift_list VALUES("623","2","Цветы","200");
INSERT INTO gift_list VALUES("604","2","Цветы","200");
INSERT INTO gift_list VALUES("739","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("740","24","Драгоценности","1000");
INSERT INTO gift_list VALUES("737","5","Девушки","200");
INSERT INTO gift_list VALUES("584","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("573","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("699","5","Девушки","200");
INSERT INTO gift_list VALUES("572","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("582","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("564","2","Цветы","200");
INSERT INTO gift_list VALUES("565","2","Цветы","200");
INSERT INTO gift_list VALUES("587","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("589","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("590","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("592","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("594","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("595","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("596","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("597","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("598","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("599","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("600","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("601","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("602","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("603","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("635","2","Цветы","200");
INSERT INTO gift_list VALUES("639","2","Цветы","200");
INSERT INTO gift_list VALUES("641","2","Добро пожаловать","200");
INSERT INTO gift_list VALUES("642","1","Добро пожаловать","5");
INSERT INTO gift_list VALUES("643","2","Цветы","200");
INSERT INTO gift_list VALUES("644","2","Цветы","200");
INSERT INTO gift_list VALUES("645","2","Добро пожаловать","200");
INSERT INTO gift_list VALUES("646","2","Цветы","200");
INSERT INTO gift_list VALUES("647","2","Цветы","200");
INSERT INTO gift_list VALUES("648","2","Цветы","200");
INSERT INTO gift_list VALUES("649","2","Цветы","200");
INSERT INTO gift_list VALUES("650","2","Цветы","200");
INSERT INTO gift_list VALUES("651","2","Цветы","200");
INSERT INTO gift_list VALUES("652","2","Цветы","200");
INSERT INTO gift_list VALUES("653","2","Цветы","200");
INSERT INTO gift_list VALUES("654","2","Цветы","200");
INSERT INTO gift_list VALUES("655","2","Цветы","200");
INSERT INTO gift_list VALUES("656","2","Цветы","200");
INSERT INTO gift_list VALUES("828","26","Люблю","200");
INSERT INTO gift_list VALUES("827","26","Люблю","200");
INSERT INTO gift_list VALUES("826","26","Люблю","200");
INSERT INTO gift_list VALUES("825","26","Люблю","200");
INSERT INTO gift_list VALUES("824","26","Люблю","200");
INSERT INTO gift_list VALUES("823","26","Люблю","200");
INSERT INTO gift_list VALUES("822","26","Люблю","200");
INSERT INTO gift_list VALUES("821","26","Люблю","200");
INSERT INTO gift_list VALUES("820","26","Люблю","200");
INSERT INTO gift_list VALUES("819","26","Люблю","200");
INSERT INTO gift_list VALUES("818","26","Люблю","200");
INSERT INTO gift_list VALUES("816","26","Люблю","200");
INSERT INTO gift_list VALUES("815","26","Люблю","200");
INSERT INTO gift_list VALUES("814","26","Люблю","200");
INSERT INTO gift_list VALUES("813","26","Люблю","200");
INSERT INTO gift_list VALUES("812","26","Люблю","200");
INSERT INTO gift_list VALUES("811","26","Люблю","200");
INSERT INTO gift_list VALUES("676","5","Для нее","200");
INSERT INTO gift_list VALUES("677","5","Для нее","200");
INSERT INTO gift_list VALUES("678","5","Для нее","300");
INSERT INTO gift_list VALUES("679","5","Для нее","200");
INSERT INTO gift_list VALUES("776","2","Цветы","200");
INSERT INTO gift_list VALUES("777","2","Цветы","200");
INSERT INTO gift_list VALUES("778","2","Цветы","200");
INSERT INTO gift_list VALUES("779","2","Цветы","200");
INSERT INTO gift_list VALUES("810","26","Люблю","200");
INSERT INTO gift_list VALUES("809","26","Люблю","200");
INSERT INTO gift_list VALUES("808","26","Люблю","200");
INSERT INTO gift_list VALUES("807","26","Люблю","200");
INSERT INTO gift_list VALUES("806","26","Люблю","200");
INSERT INTO gift_list VALUES("805","26","Люблю","200");
INSERT INTO gift_list VALUES("804","26","Люблю","200");
INSERT INTO gift_list VALUES("787","25","8 марта","300");
INSERT INTO gift_list VALUES("788","25","8 марта","300");
INSERT INTO gift_list VALUES("789","25","8 марта","300");
INSERT INTO gift_list VALUES("790","25","8 марта","300");
INSERT INTO gift_list VALUES("791","25","8 марта","300");
INSERT INTO gift_list VALUES("792","25","8 марта","300");
INSERT INTO gift_list VALUES("793","25","8 марта","300");
INSERT INTO gift_list VALUES("794","25","8 марта","300");
INSERT INTO gift_list VALUES("796","25","8 марта","300");
INSERT INTO gift_list VALUES("797","25","8 марта","300");
INSERT INTO gift_list VALUES("798","25","8 марта","300");
INSERT INTO gift_list VALUES("799","25","8 марта","300");
INSERT INTO gift_list VALUES("800","23","С днем рождения","300");
INSERT INTO gift_list VALUES("801","23","С днем рождения","300");
INSERT INTO gift_list VALUES("802","23","С днем рождения","300");
INSERT INTO gift_list VALUES("803","23","С днем рождения","300");
INSERT INTO gift_list VALUES("845","26","Люблю","200");
INSERT INTO gift_list VALUES("846","26","Люблю","200");
INSERT INTO gift_list VALUES("847","26","Люблю","200");
INSERT INTO gift_list VALUES("848","26","Люблю","200");
INSERT INTO gift_list VALUES("849","26","Люблю","200");
INSERT INTO gift_list VALUES("850","26","Люблю","200");
INSERT INTO gift_list VALUES("851","26","Люблю","200");
INSERT INTO gift_list VALUES("852","26","Люблю","200");
INSERT INTO gift_list VALUES("853","26","Люблю","200");
INSERT INTO gift_list VALUES("854","26","Люблю","200");
INSERT INTO gift_list VALUES("855","26","Люблю","200");
INSERT INTO gift_list VALUES("856","26","Люблю","200");
INSERT INTO gift_list VALUES("857","26","Люблю","200");
INSERT INTO gift_list VALUES("858","26","Люблю","200");
INSERT INTO gift_list VALUES("859","26","Люблю","200");
INSERT INTO gift_list VALUES("860","26","Люблю","200");
INSERT INTO gift_list VALUES("861","26","Люблю","200");
INSERT INTO gift_list VALUES("862","26","Люблю","200");
INSERT INTO gift_list VALUES("863","26","Люблю","200");
INSERT INTO gift_list VALUES("864","26","Люблю","200");
INSERT INTO gift_list VALUES("865","26","Люблю","200");
INSERT INTO gift_list VALUES("866","26","Люблю","200");
INSERT INTO gift_list VALUES("867","26","Люблю","200");
INSERT INTO gift_list VALUES("868","26","Люблю","200");
INSERT INTO gift_list VALUES("869","26","Люблю","200");
INSERT INTO gift_list VALUES("870","26","Люблю","200");
INSERT INTO gift_list VALUES("871","26","Люблю","200");
INSERT INTO gift_list VALUES("872","26","Люблю","200");
INSERT INTO gift_list VALUES("873","26","Люблю","200");
INSERT INTO gift_list VALUES("874","26","Люблю","200");
INSERT INTO gift_list VALUES("875","26","Люблю","200");
INSERT INTO gift_list VALUES("876","26","Люблю","200");
INSERT INTO gift_list VALUES("877","26","Люблю","200");
INSERT INTO gift_list VALUES("878","26","Люблю","200");
INSERT INTO gift_list VALUES("887","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("888","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("889","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("890","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("891","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("892","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("893","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("894","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("895","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("896","27","Доброе Утро","100");
INSERT INTO gift_list VALUES("897","28","Для Тебя","200");
INSERT INTO gift_list VALUES("898","28","Для Тебя","200");
INSERT INTO gift_list VALUES("899","28","Для Тебя","200");
INSERT INTO gift_list VALUES("900","28","Для Тебя","200");
INSERT INTO gift_list VALUES("901","28","Для Тебя","200");
INSERT INTO gift_list VALUES("902","28","Для Тебя","200");
INSERT INTO gift_list VALUES("903","28","Для Тебя","200");
INSERT INTO gift_list VALUES("904","28","Для Тебя","200");
INSERT INTO gift_list VALUES("905","28","Для Тебя","200");
INSERT INTO gift_list VALUES("906","28","Для Тебя","200");
INSERT INTO gift_list VALUES("907","28","Для Тебя","200");
INSERT INTO gift_list VALUES("908","28","Для Тебя","200");
INSERT INTO gift_list VALUES("909","28","Для Тебя","200");
INSERT INTO gift_list VALUES("939","28","Для Тебя","200");
INSERT INTO gift_list VALUES("938","28","Для Тебя","200");
INSERT INTO gift_list VALUES("937","28","Для Тебя","200");
INSERT INTO gift_list VALUES("936","28","Для Тебя","200");
INSERT INTO gift_list VALUES("935","28","Для Тебя","200");
INSERT INTO gift_list VALUES("915","28","Для Тебя","200");
INSERT INTO gift_list VALUES("916","28","Для Тебя","200");
INSERT INTO gift_list VALUES("917","28","Для Тебя","200");
INSERT INTO gift_list VALUES("918","28","Для Тебя","200");
INSERT INTO gift_list VALUES("919","28","Для Тебя","200");
INSERT INTO gift_list VALUES("920","28","Для Тебя","200");
INSERT INTO gift_list VALUES("921","28","Для Тебя","200");
INSERT INTO gift_list VALUES("922","28","Для Тебя","200");
INSERT INTO gift_list VALUES("923","28","Для Тебя","200");
INSERT INTO gift_list VALUES("924","28","Для Тебя","200");
INSERT INTO gift_list VALUES("925","28","Для Тебя","200");
INSERT INTO gift_list VALUES("926","28","Для Тебя","200");
INSERT INTO gift_list VALUES("927","28","Для Тебя","200");
INSERT INTO gift_list VALUES("928","28","Для Тебя","200");
INSERT INTO gift_list VALUES("929","28","Для Тебя","200");
INSERT INTO gift_list VALUES("930","28","Для Тебя","200");
INSERT INTO gift_list VALUES("931","28","Для Тебя","200");
INSERT INTO gift_list VALUES("932","28","Для Тебя","200");
INSERT INTO gift_list VALUES("933","28","Для Тебя","200");
INSERT INTO gift_list VALUES("934","28","Для Тебя","200");
INSERT INTO gift_list VALUES("940","28","Для Тебя","200");
INSERT INTO gift_list VALUES("941","24","драгоцености","1000");
INSERT INTO gift_list VALUES("942","24","драгоцености","1000");
INSERT INTO gift_list VALUES("943","24","драгоцености","1000");
INSERT INTO gift_list VALUES("944","24","драгоцености","1000");
INSERT INTO gift_list VALUES("945","24","драгоцености","1000");
INSERT INTO gift_list VALUES("946","24","драгоцености","1000");
INSERT INTO gift_list VALUES("947","24","драгоцености","1000");
INSERT INTO gift_list VALUES("948","24","драгоцености","1000");
INSERT INTO gift_list VALUES("949","26","Люблю","200");
INSERT INTO gift_list VALUES("950","26","Люблю","200");
INSERT INTO gift_list VALUES("951","26","Люблю","200");
INSERT INTO gift_list VALUES("952","26","Люблю","200");
INSERT INTO gift_list VALUES("953","26","Люблю","200");
INSERT INTO gift_list VALUES("954","26","Люблю","200");
INSERT INTO gift_list VALUES("955","26","Люблю","200");
INSERT INTO gift_list VALUES("956","26","Люблю","200");
INSERT INTO gift_list VALUES("957","26","Люблю","200");
INSERT INTO gift_list VALUES("958","26","Люблю","200");
INSERT INTO gift_list VALUES("959","26","Люблю","200");
INSERT INTO gift_list VALUES("960","27","Доброе Утро","200");
INSERT INTO gift_list VALUES("961","26","Люблю ","500");
INSERT INTO gift_list VALUES("962","26","Люблю","500");
INSERT INTO gift_list VALUES("963","26","Люблю","500");
INSERT INTO gift_list VALUES("964","26","Люблю","500");
INSERT INTO gift_list VALUES("965","26","Люблю","500");
INSERT INTO gift_list VALUES("966","26","Люблю","500");
INSERT INTO gift_list VALUES("967","26","Люблю","500");
INSERT INTO gift_list VALUES("968","26","Люблю","500");
INSERT INTO gift_list VALUES("969","26","Люблю","500");
INSERT INTO gift_list VALUES("970","26","Люблю","500");
INSERT INTO gift_list VALUES("971","26","Люблю","500");
INSERT INTO gift_list VALUES("972","26","Люблю","500");
INSERT INTO gift_list VALUES("973","26","Люблю","500");
INSERT INTO gift_list VALUES("974","26","Люблю","500");
INSERT INTO gift_list VALUES("975","26","Люблю","500");
INSERT INTO gift_list VALUES("976","26","Люблю","500");
INSERT INTO gift_list VALUES("977","26","Люблю","500");
INSERT INTO gift_list VALUES("978","26","Люблю","500");
INSERT INTO gift_list VALUES("979","26","Люблю","500");
INSERT INTO gift_list VALUES("980","26","Люблю","500");
INSERT INTO gift_list VALUES("981","26","Люблю","500");
INSERT INTO gift_list VALUES("982","26","Люблю","500");
INSERT INTO gift_list VALUES("983","26","Люблю","500");
INSERT INTO gift_list VALUES("984","26","Люблю","500");
INSERT INTO gift_list VALUES("985","26","Люблю","500");
INSERT INTO gift_list VALUES("986","26","Люблю","500");
INSERT INTO gift_list VALUES("987","26","Люблю","500");
INSERT INTO gift_list VALUES("988","26","Люблю","500");
INSERT INTO gift_list VALUES("989","26","Люблю","500");
INSERT INTO gift_list VALUES("990","26","Люблю","500");
INSERT INTO gift_list VALUES("991","26","Люблю","500");
INSERT INTO gift_list VALUES("992","26","Люблю","500");
INSERT INTO gift_list VALUES("993","26","Люблю","500");
INSERT INTO gift_list VALUES("994","26","Люблю","500");
INSERT INTO gift_list VALUES("995","26","Люблю","500");
INSERT INTO gift_list VALUES("996","26","Люблю","500");
INSERT INTO gift_list VALUES("997","26","Люблю","500");
INSERT INTO gift_list VALUES("998","26","Люблю","500");
INSERT INTO gift_list VALUES("999","26","Люблю","500");
INSERT INTO gift_list VALUES("1000","26","Люблю","500");
INSERT INTO gift_list VALUES("1001","26","Люблю","500");
INSERT INTO gift_list VALUES("1002","26","Люблю","500");
INSERT INTO gift_list VALUES("1003","26","Люблю","500");
INSERT INTO gift_list VALUES("1004","26","Люблю","500");
INSERT INTO gift_list VALUES("1005","26","Люблю","500");
INSERT INTO gift_list VALUES("1006","26","Люблю","500");
INSERT INTO gift_list VALUES("1007","26","Люблю","500");
INSERT INTO gift_list VALUES("1008","26","Люблю","500");
INSERT INTO gift_list VALUES("1009","26","Люблю","500");
INSERT INTO gift_list VALUES("1010","26","Люблю","500");
INSERT INTO gift_list VALUES("1011","26","Люблю","500");
INSERT INTO gift_list VALUES("1012","26","Люблю","500");
INSERT INTO gift_list VALUES("1013","26","Люблю","500");
INSERT INTO gift_list VALUES("1014","26","Люблю","500");
INSERT INTO gift_list VALUES("1015","26","Люблю","500");
INSERT INTO gift_list VALUES("1016","26","Люблю","500");
INSERT INTO gift_list VALUES("1017","26","Люблю","500");
INSERT INTO gift_list VALUES("1018","28","Для Тебя","500");
INSERT INTO gift_list VALUES("1019","28","Для Тебя","500");
INSERT INTO gift_list VALUES("1020","28","Для Тебя","500");
INSERT INTO gift_list VALUES("1021","28","Для Тебя","500");
INSERT INTO gift_list VALUES("1022","28","Для Тебя","500");
INSERT INTO gift_list VALUES("1023","26","Люблю","500");
INSERT INTO gift_list VALUES("1024","26","Люблю","500");
INSERT INTO gift_list VALUES("1025","26","Люблю","500");
INSERT INTO gift_list VALUES("1026","26","Люблю","500");
INSERT INTO gift_list VALUES("1027","26","Люблю","500");
INSERT INTO gift_list VALUES("1028","26","Люблю","500");
INSERT INTO gift_list VALUES("1029","26","Люблю","500");
INSERT INTO gift_list VALUES("1030","26","Люблю","500");
INSERT INTO gift_list VALUES("1031","26","Люблю","500");
INSERT INTO gift_list VALUES("1032","26","Люблю","500");
INSERT INTO gift_list VALUES("1033","26","Люблю","500");
INSERT INTO gift_list VALUES("1034","26","Люблю","500");
INSERT INTO gift_list VALUES("1035","26","Люблю","500");
INSERT INTO gift_list VALUES("1036","26","Люблю","500");
INSERT INTO gift_list VALUES("1037","26","Люблю","500");
INSERT INTO gift_list VALUES("1038","26","Люблю","500");
INSERT INTO gift_list VALUES("1039","26","Люблю","500");
INSERT INTO gift_list VALUES("1040","26","Люблю","500");
INSERT INTO gift_list VALUES("1041","26","Люблю","500");
INSERT INTO gift_list VALUES("1042","26","Люблю","500");
INSERT INTO gift_list VALUES("1043","26","Люблю","100");
INSERT INTO gift_list VALUES("1044","26","Люблю","100");
INSERT INTO gift_list VALUES("1045","26","Люблю","100");
INSERT INTO gift_list VALUES("1046","26","Люблю","100");
INSERT INTO gift_list VALUES("1047","26","Люблю","100");
INSERT INTO gift_list VALUES("1048","26","Люблю","100");
INSERT INTO gift_list VALUES("1049","26","Люблю","100");
INSERT INTO gift_list VALUES("1050","26","Люблю","100");
INSERT INTO gift_list VALUES("1051","26","Люблю","100");
INSERT INTO gift_list VALUES("1052","26","Люблю","100");
INSERT INTO gift_list VALUES("1053","26","Люблю","100");
INSERT INTO gift_list VALUES("1054","26","Люблю","100");
INSERT INTO gift_list VALUES("1055","26","Люблю","100");
INSERT INTO gift_list VALUES("1056","26","Люблю","100");
INSERT INTO gift_list VALUES("1057","26","Люблю","100");
INSERT INTO gift_list VALUES("1058","26","Люблю","100");
INSERT INTO gift_list VALUES("1059","26","Люблю","100");
INSERT INTO gift_list VALUES("1060","26","Люблю","100");
INSERT INTO gift_list VALUES("1061","26","Люблю","100");
INSERT INTO gift_list VALUES("1062","26","Люблю","100");
INSERT INTO gift_list VALUES("1063","26","Люблю","100");
INSERT INTO gift_list VALUES("1064","26","Люблю","100");
INSERT INTO gift_list VALUES("1065","26","Люблю","100");
INSERT INTO gift_list VALUES("1066","26","Люблю","100");
INSERT INTO gift_list VALUES("1067","26","Люблю","100");
INSERT INTO gift_list VALUES("1068","26","Люблю","100");
INSERT INTO gift_list VALUES("1069","26","Люблю","100");
INSERT INTO gift_list VALUES("1070","26","Люблю","100");
INSERT INTO gift_list VALUES("1071","26","Люблю","100");
INSERT INTO gift_list VALUES("1072","26","Люблю","100");
INSERT INTO gift_list VALUES("1073","26","Люблю","100");
INSERT INTO gift_list VALUES("1074","26","Люблю","100");
INSERT INTO gift_list VALUES("1075","26","Люблю","100");
INSERT INTO gift_list VALUES("1076","26","Люблю","100");
INSERT INTO gift_list VALUES("1077","26","Люблю","100");
INSERT INTO gift_list VALUES("1078","26","Люблю","100");
INSERT INTO gift_list VALUES("1079","26","Люблю","100");
INSERT INTO gift_list VALUES("1080","26","Люблю","100");
INSERT INTO gift_list VALUES("1081","26","Люблю","100");
INSERT INTO gift_list VALUES("1082","26","Люблю","100");
INSERT INTO gift_list VALUES("1083","26","Люблю","100");
INSERT INTO gift_list VALUES("1084","26","Люблю","100");
INSERT INTO gift_list VALUES("1085","26","Люблю","100");
INSERT INTO gift_list VALUES("1086","26","Люблю","100");
INSERT INTO gift_list VALUES("1087","26","Люблю","100");
INSERT INTO gift_list VALUES("1088","26","Люблю","100");
INSERT INTO gift_list VALUES("1089","26","Люблю","100");
INSERT INTO gift_list VALUES("1090","26","Люблю","100");
INSERT INTO gift_list VALUES("1091","26","Люблю","100");
INSERT INTO gift_list VALUES("1092","26","Люблю","100");
INSERT INTO gift_list VALUES("1093","26","Люблю","100");
INSERT INTO gift_list VALUES("1094","26","Люблю","100");
INSERT INTO gift_list VALUES("1095","26","Люблю","100");
INSERT INTO gift_list VALUES("1096","26","Люблю","100");
INSERT INTO gift_list VALUES("1097","26","Люблю","100");
INSERT INTO gift_list VALUES("1098","26","Люблю","100");
INSERT INTO gift_list VALUES("1099","26","Люблю","100");
INSERT INTO gift_list VALUES("1100","26","Люблю","100");
INSERT INTO gift_list VALUES("1101","26","Люблю","100");
INSERT INTO gift_list VALUES("1102","26","Люблю","100");
INSERT INTO gift_list VALUES("1103","26","Люблю","100");
INSERT INTO gift_list VALUES("1104","26","Люблю","100");
INSERT INTO gift_list VALUES("1105","26","Люблю","100");
INSERT INTO gift_list VALUES("1106","26","Люблю","100");
INSERT INTO gift_list VALUES("1107","26","Люблю","100");
INSERT INTO gift_list VALUES("1108","26","Люблю","100");
INSERT INTO gift_list VALUES("1109","26","Люблю","100");
INSERT INTO gift_list VALUES("1110","26","Люблю","100");
INSERT INTO gift_list VALUES("1111","26","Люблю","100");
INSERT INTO gift_list VALUES("1112","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1113","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1114","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1115","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1116","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1117","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1118","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1119","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1120","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1121","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1122","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1123","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1124","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1125","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1126","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1127","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1128","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1129","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1130","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1131","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1132","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1133","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1134","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1135","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1136","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1137","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1138","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1139","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1140","29","Для Тебя","100");
INSERT INTO gift_list VALUES("1141","29","Для Тебя","100");



DROP TABLE IF EXISTS `gifts_random`;

CREATE TABLE `gifts_random` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gift` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coins_balls` int(11) DEFAULT '0',
  `coins_money` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=22656 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gifts_user`;

CREATE TABLE `gifts_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  `id_gift` int(11) NOT NULL,
  `anonim` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coment` varchar(150) NOT NULL,
  `status` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7576 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `groups`;

CREATE TABLE `groups` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_admin` int(11) NOT NULL,
  `name` varchar(512) DEFAULT 'РќРѕРІР°СЏ РіСЂСѓРїРїР°',
  `avatar` varchar(128) DEFAULT NULL,
  `comment` varchar(10240) DEFAULT NULL,
  `category` varchar(128) DEFAULT 'Р‘РµР· РєР°С‚РµРіРѕСЂРёРё',
  `theme` int(11) DEFAULT '0',
  `privacy_view` int(1) DEFAULT '1',
  `privacy_come` int(1) DEFAULT '1',
  `privacy_photo` int(1) DEFAULT '0',
  `privacy_forum` int(1) DEFAULT '0',
  `hide_admin` int(1) DEFAULT '0',
  `public_admin` int(1) DEFAULT '0',
  `tape_admin` int(1) DEFAULT '0',
  `time_created` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_albums`;

CREATE TABLE `groups_albums` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `upload_admin` int(1) DEFAULT '0',
  `name` varchar(512) DEFAULT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_comments`;

CREATE TABLE `groups_comments` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_reply` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `type` mediumtext,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_friends`;

CREATE TABLE `groups_friends` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_friends` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `confirm` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_photos`;

CREATE TABLE `groups_photos` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(2048) DEFAULT NULL,
  `id_group` int(11) NOT NULL,
  `id_albums` int(11) DEFAULT '0',
  `avatar` int(1) DEFAULT '0',
  `hash` varchar(128) NOT NULL,
  `size` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_tape`;

CREATE TABLE `groups_tape` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `id_last` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '1',
  `type` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_topic`;

CREATE TABLE `groups_topic` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `name` mediumtext,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_users`;

CREATE TABLE `groups_users` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_group` int(11) NOT NULL,
  `level` int(1) DEFAULT '1',
  `invite` int(11) DEFAULT '0',
  `read` int(1) DEFAULT '0',
  `time` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `groups_videos`;

CREATE TABLE `groups_videos` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(2048) DEFAULT NULL,
  `id_group` int(11) NOT NULL,
  `view` int(11) DEFAULT '0',
  `duration` int(11) DEFAULT '0',
  `hash` varchar(128) NOT NULL,
  `type` varchar(128) NOT NULL,
  `codec` varchar(128) NOT NULL,
  `ras` varchar(5) DEFAULT 'mp4',
  `size` int(11) DEFAULT '0',
  `h` int(11) DEFAULT '0',
  `w` int(11) DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest`;

CREATE TABLE `guest` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `dir` varchar(12) DEFAULT NULL,
  `fon` int(3) DEFAULT '31',
  `cit` int(11) DEFAULT NULL,
  `vik_st` set('0','1','2','3','4') DEFAULT '0',
  `vopros` int(11) DEFAULT NULL,
  `file` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=15630 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_anonim`;

CREATE TABLE `guest_anonim` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_f2`;

CREATE TABLE `guest_f2` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num` int(11) DEFAULT '0',
  `name` varchar(64) NOT NULL,
  `ras` varchar(512) NOT NULL,
  `maxfilesize` int(11) NOT NULL,
  `dir` varchar(512) NOT NULL DEFAULT '/',
  `dir_osn` varchar(512) DEFAULT '/',
  `upload` set('1','0') NOT NULL DEFAULT '0',
  `my` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `num` (`num`),
  KEY `dir` (`dir`(333))
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_files_komm`;

CREATE TABLE `guest_files_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_post` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `active` int(11) DEFAULT '0',
  `id_komm` int(11) DEFAULT '0',
  `type` varchar(500) NOT NULL,
  `name` varchar(500) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_glum`;

CREATE TABLE `guest_glum` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `dir` varchar(12) DEFAULT NULL,
  `img` int(11) DEFAULT '1',
  `margin_left` int(11) DEFAULT '0',
  `id_post` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_tema_dnja`;

CREATE TABLE `guest_tema_dnja` (
  `id` int(11) NOT NULL,
  `tema` varchar(1024) DEFAULT NULL,
  `pok` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_tema_dnja_otzuv`;

CREATE TABLE `guest_tema_dnja_otzuv` (
  `id` int(11) NOT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_tema` int(11) NOT NULL DEFAULT '0',
  `plus` int(11) NOT NULL DEFAULT '0',
  `minus` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guest_top_komm`;

CREATE TABLE `guest_top_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `komm` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_last` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`komm`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `guests`;

CREATE TABLE `guests` (
  `ip` bigint(20) NOT NULL,
  `ua` char(32) NOT NULL,
  `date_aut` int(11) NOT NULL,
  `date_last` int(11) NOT NULL,
  `url` char(64) NOT NULL,
  `pereh` int(11) NOT NULL DEFAULT '0',
  KEY `ip_2` (`ip`,`ua`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `halloween_game`;

CREATE TABLE `halloween_game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `proc` int(11) NOT NULL,
  `pol` int(11) NOT NULL,
  `img` int(11) NOT NULL,
  `w` int(11) NOT NULL,
  `h` int(11) NOT NULL,
  `r` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `halloween_history`;

CREATE TABLE `halloween_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `halloween_pers`;

CREATE TABLE `halloween_pers` (
  `id` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `proc` int(11) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO halloween_pers VALUES("1","зомби-убица","5");
INSERT INTO halloween_pers VALUES("2","дракула","3");
INSERT INTO halloween_pers VALUES("3","человеческая мыщь","4");
INSERT INTO halloween_pers VALUES("4","мумия","3");
INSERT INTO halloween_pers VALUES("5","зомби скелет","4");
INSERT INTO halloween_pers VALUES("6","ведьма","2");
INSERT INTO halloween_pers VALUES("7","летучая мышь","3");
INSERT INTO halloween_pers VALUES("8","скелет","4");
INSERT INTO halloween_pers VALUES("9","призрак","3");



DROP TABLE IF EXISTS `halloween_stat`;

CREATE TABLE `halloween_stat` (
  `id` int(11) NOT NULL,
  `man` int(11) NOT NULL,
  `woman` int(11) NOT NULL,
  `p_woman` int(11) NOT NULL,
  `p_man` int(11) NOT NULL
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO halloween_stat VALUES("1","0","0","0","0");



DROP TABLE IF EXISTS `halloween_us`;

CREATE TABLE `halloween_us` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `pers` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1180 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `hockey`;

CREATE TABLE `hockey` (
  `id` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `team` varchar(64) NOT NULL,
  `time` int(11) NOT NULL,
  `gol` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `hockey_chat`;

CREATE TABLE `hockey_chat` (
  `id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `hockey_goal`;

CREATE TABLE `hockey_goal` (
  `id` int(11) NOT NULL,
  `meteor` int(11) NOT NULL,
  `vumpel` int(11) NOT NULL,
  `goal` int(11) NOT NULL DEFAULT '50'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO hockey_goal VALUES("1","5","1","216");
INSERT INTO hockey_goal VALUES("1","0","0","50");



DROP TABLE IF EXISTS `hockey_gol`;

CREATE TABLE `hockey_gol` (
  `id` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(640) NOT NULL,
  `gol` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `hockey_vip`;

CREATE TABLE `hockey_vip` (
  `id` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(640) NOT NULL,
  `gol` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `icons_list`;

CREATE TABLE `icons_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;

INSERT INTO icons_list VALUES("2","2");
INSERT INTO icons_list VALUES("3","3");
INSERT INTO icons_list VALUES("4","4");
INSERT INTO icons_list VALUES("5","5");
INSERT INTO icons_list VALUES("6","6");
INSERT INTO icons_list VALUES("8","7");
INSERT INTO icons_list VALUES("9","8");
INSERT INTO icons_list VALUES("10","9");
INSERT INTO icons_list VALUES("11","10");
INSERT INTO icons_list VALUES("12","11");
INSERT INTO icons_list VALUES("13","12");
INSERT INTO icons_list VALUES("18","401");
INSERT INTO icons_list VALUES("17","3002734ymC2yXar");
INSERT INTO icons_list VALUES("16","3002431RIQ2o6OM");



DROP TABLE IF EXISTS `icons_time`;

CREATE TABLE `icons_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO icons_time VALUES("1","1036800");



DROP TABLE IF EXISTS `ignor`;

CREATE TABLE `ignor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL DEFAULT '0',
  `ig_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `images`;

CREATE TABLE `images` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_category` int(11) NOT NULL,
  `opis` varchar(1024) NOT NULL,
  `name` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_category` (`id_category`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8;

INSERT INTO images VALUES("3","1","Пока,  пока","mig.gif");
INSERT INTO images VALUES("4","1","А вот и я","nuka.gif");
INSERT INTO images VALUES("5","2","Целую","censored.gif");
INSERT INTO images VALUES("6","2","Обнимаю","commando.gif");
INSERT INTO images VALUES("7","3","","Богиня с юмором.jpeg");
INSERT INTO images VALUES("8","3","","(271) Pinterest.jpeg");
INSERT INTO images VALUES("9","3","","Метод курить меньше или бросить курить совсем — Фото _ OK_RU.png");
INSERT INTO images VALUES("10","3","","4,650 отметок «Нравится», 32 комментариев — Вольха Редная (@vrednaya_off) в Instagram.jpeg");
INSERT INTO images VALUES("11","4","","110жд.jpg");



DROP TABLE IF EXISTS `images_category`;

CREATE TABLE `images_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8;

INSERT INTO images_category VALUES("1","Вредина");
INSERT INTO images_category VALUES("2","Любовь ");
INSERT INTO images_category VALUES("3","Приколямбы");
INSERT INTO images_category VALUES("4","Для статусов");
INSERT INTO images_category VALUES("5","Любовь");
INSERT INTO images_category VALUES("6","Цветы");
INSERT INTO images_category VALUES("7","Сердечки");
INSERT INTO images_category VALUES("8","Ангелы");
INSERT INTO images_category VALUES("9","Кошечки");
INSERT INTO images_category VALUES("10","Музыка");
INSERT INTO images_category VALUES("11","Напитки");
INSERT INTO images_category VALUES("12","Надписи");
INSERT INTO images_category VALUES("13","Транспорт");
INSERT INTO images_category VALUES("14","Люди");
INSERT INTO images_category VALUES("15","Религия");
INSERT INTO images_category VALUES("16","Сладкие");
INSERT INTO images_category VALUES("17","Птицы");
INSERT INTO images_category VALUES("18","Еда");
INSERT INTO images_category VALUES("19","Погода");
INSERT INTO images_category VALUES("20","Деньги");
INSERT INTO images_category VALUES("21","Книги");
INSERT INTO images_category VALUES("22","Гламурные");
INSERT INTO images_category VALUES("23","Другие");
INSERT INTO images_category VALUES("24","Имена");
INSERT INTO images_category VALUES("25","Праздники");
INSERT INTO images_category VALUES("26","Breath of fire");
INSERT INTO images_category VALUES("27","Военные");
INSERT INTO images_category VALUES("28","Гламурные губки");
INSERT INTO images_category VALUES("29","Линии");
INSERT INTO images_category VALUES("30","Эльфы");
INSERT INTO images_category VALUES("31","Спорт");
INSERT INTO images_category VALUES("32","Недвижимость");



DROP TABLE IF EXISTS `ingame1`;

CREATE TABLE `ingame1` (
  `gamer_id` int(11) NOT NULL,
  `role` varchar(100) NOT NULL,
  `gamer_act` varchar(50) NOT NULL,
  `id_in_game` int(11) NOT NULL,
  `dvote` int(11) NOT NULL,
  `wholin` int(11) NOT NULL,
  `onl` int(12) NOT NULL,
  `state` tinyint(1) NOT NULL,
  PRIMARY KEY (`gamer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ingame2`;

CREATE TABLE `ingame2` (
  `gamer_id` int(11) NOT NULL,
  `role` varchar(100) NOT NULL,
  `gamer_act` varchar(50) NOT NULL,
  `id_in_game` int(11) NOT NULL,
  `dvote` int(11) NOT NULL,
  `wholin` int(11) NOT NULL,
  `onl` int(12) NOT NULL,
  `state` tinyint(1) NOT NULL,
  PRIMARY KEY (`gamer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ingame3`;

CREATE TABLE `ingame3` (
  `gamer_id` int(11) NOT NULL,
  `role` varchar(100) NOT NULL,
  `gamer_act` varchar(50) NOT NULL,
  `id_in_game` int(11) NOT NULL,
  `dvote` int(11) NOT NULL,
  `wholin` int(11) NOT NULL,
  `onl` int(12) NOT NULL,
  `state` tinyint(1) NOT NULL,
  PRIMARY KEY (`gamer_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `inter`;

CREATE TABLE `inter` (
  `id_user` int(11) NOT NULL,
  `monet` int(11) NOT NULL DEFAULT '500',
  `almaz` int(11) NOT NULL DEFAULT '10',
  `opit` int(11) NOT NULL,
  `uroven` int(11) NOT NULL DEFAULT '1',
  `palat_dop` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `inter_pac`;

CREATE TABLE `inter_pac` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  `opit` int(11) NOT NULL,
  `monet` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  `urov` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=68 DEFAULT CHARSET=utf8;

INSERT INTO inter_pac VALUES("1","Заноза","40","14","60","10","1");
INSERT INTO inter_pac VALUES("2","Аллергия","40","21","222","10","1");
INSERT INTO inter_pac VALUES("3","Мигрень","20","33","108","20","2");
INSERT INTO inter_pac VALUES("4","Вшивость","80","72","392","20","2");
INSERT INTO inter_pac VALUES("5","Боль в суставах","30","60","148","30","3");
INSERT INTO inter_pac VALUES("6","Забывчивый","120","125","577","30","3");
INSERT INTO inter_pac VALUES("7","Заядлый курильщик","40","80","209","40","4");
INSERT INTO inter_pac VALUES("8","Элвис Пресли","160","180","759","40","4");
INSERT INTO inter_pac VALUES("9","Ядовитый укус","50","244","759","50","5");
INSERT INTO inter_pac VALUES("10","Простуда","200","238","939","50","5");
INSERT INTO inter_pac VALUES("11","Проказа","60","127","286","60","6");
INSERT INTO inter_pac VALUES("12","Сломанная рука","240","300","1049","60","6");
INSERT INTO inter_pac VALUES("13","Глубочайший депрессняк","70","154","328","70","7");
INSERT INTO inter_pac VALUES("14","Сломанные ноги","288","366","1186","70","7");
INSERT INTO inter_pac VALUES("15","Грипп","80","184","370","80","8");
INSERT INTO inter_pac VALUES("16","Обморожение","340","456","1331","80","8");
INSERT INTO inter_pac VALUES("17","Хроническая усталость","90","237","412","90","9");
INSERT INTO inter_pac VALUES("18","Неприятная сыпь","460","550","1440","90","9");
INSERT INTO inter_pac VALUES("19","Невезучий","100","550","454","100","10");
INSERT INTO inter_pac VALUES("20","Фитнес курсы","540","649","1620","100","10");
INSERT INTO inter_pac VALUES("21","Перегрузка","110","353","480","110","11");
INSERT INTO inter_pac VALUES("22","Покусанный","590","753","1740","120","12");
INSERT INTO inter_pac VALUES("23","Слепой","130","416","549","130","13");
INSERT INTO inter_pac VALUES("24","Отупение","670","862","1860","130","13");
INSERT INTO inter_pac VALUES("25","Ведьма","140","481","581","140","14");
INSERT INTO inter_pac VALUES("26","Порча","770","1132","2160","150","15");
INSERT INTO inter_pac VALUES("27","Адская горячка","160","596","660","160","16");
INSERT INTO inter_pac VALUES("28","Увеличение губ","850","1405","2360","170","17");
INSERT INTO inter_pac VALUES("29","Боли в животе","180","721","735","180","18");
INSERT INTO inter_pac VALUES("30","Сломанный зуб","930","1685","2520","190","19");
INSERT INTO inter_pac VALUES("31","Раздвоение личности","200","850","780","200","20");
INSERT INTO inter_pac VALUES("32","Чокнутый","1010","1970","2760","210","21");
INSERT INTO inter_pac VALUES("33","Сломанный нос","1090","2280","3000","230","23");
INSERT INTO inter_pac VALUES("34","Деревянный человек","230","1125","891","230","23");
INSERT INTO inter_pac VALUES("35","Одержимый дьяволом","1170","2605","3180","240","24");
INSERT INTO inter_pac VALUES("36","Бешенство","240","1300","943","240","24");
INSERT INTO inter_pac VALUES("37","Разбитое сердце","240","1300","3420","250","25");
INSERT INTO inter_pac VALUES("38","Увеличение груди","260","1510","995","260","26");
INSERT INTO inter_pac VALUES("39","Тыквенная голова","1530","3325","3840","270","27");
INSERT INTO inter_pac VALUES("40","Увеличение ягодиц","280","1730","1047","260","28");
INSERT INTO inter_pac VALUES("41","Вампирша","1750","3720","4200","280","28");
INSERT INTO inter_pac VALUES("42","Социопат","310","1960","1080","290","29");
INSERT INTO inter_pac VALUES("43","Зомби","1970","4140","4560","300","30");
INSERT INTO inter_pac VALUES("44","Быкообразный","340","2225","1181","310","31");
INSERT INTO inter_pac VALUES("45","Жертва огнестрела","2130","4610","4920","320","32");
INSERT INTO inter_pac VALUES("46","Невидимка","370","2550","1263","330","33");
INSERT INTO inter_pac VALUES("47","Мумия","2310","5100","5280","340","34");
INSERT INTO inter_pac VALUES("48","Вредная Горгона","1000","3080","1375","350","35");
INSERT INTO inter_pac VALUES("49","Оборотень","2500","5800","5640","350","35");
INSERT INTO inter_pac VALUES("50","Человек - телевизор","2700","3380","1440","360","36");
INSERT INTO inter_pac VALUES("51","Пьянчужка","3300","6400","5940","360","36");
INSERT INTO inter_pac VALUES("52","Клаустрофобия","3500","3690","1560","370","37");
INSERT INTO inter_pac VALUES("53","Грустный самурай","5000","7080","6300","370","37");
INSERT INTO inter_pac VALUES("54","Ежовый грипп","4500","4000","1640","380","38");
INSERT INTO inter_pac VALUES("55","Потливость","10000","7800","6660","380","38");
INSERT INTO inter_pac VALUES("56","Водяной","5500","4350","1447","390","39");
INSERT INTO inter_pac VALUES("57","Золотая лихорадка","9000","8450","7020","390","39");
INSERT INTO inter_pac VALUES("58","Перелом ребер","6500","4680","1800","400","40");
INSERT INTO inter_pac VALUES("59","Уставший волшебник","15000","9150","7200","400","40");
INSERT INTO inter_pac VALUES("60","Камни в печени","7000","5000","6660","410","41");
INSERT INTO inter_pac VALUES("61","Вонючка","18000","10000","10080","410","41");
INSERT INTO inter_pac VALUES("62","Заразный смех","9000","8000","3180","420","42");
INSERT INTO inter_pac VALUES("63","Длинный язык","22000","13000","12960","420","42");
INSERT INTO inter_pac VALUES("64","Ожирение","27000","16000","15300","430","43");
INSERT INTO inter_pac VALUES("65","Опухоль головы","18000","10000","1848","430","43");
INSERT INTO inter_pac VALUES("66","Язва желудка","22000","12000","6060","440","44");
INSERT INTO inter_pac VALUES("67","Облучение","30000","19000","17280","450","45");



DROP TABLE IF EXISTS `inter_pal`;

CREATE TABLE `inter_pal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pac` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_dop` int(11) NOT NULL,
  `time_napit` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `inthem`;

CREATE TABLE `inthem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `is_time`;

CREATE TABLE `is_time` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10092 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `jurnal`;

CREATE TABLE `jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`id_kont`),
  KEY `read` (`read`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `jurnal_d`;

CREATE TABLE `jurnal_d` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kogo` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `foto` set('0','1') NOT NULL DEFAULT '1',
  `forum` set('0','1') NOT NULL DEFAULT '1',
  `foto_d` set('0','1') NOT NULL DEFAULT '1',
  `foto_komm` set('0','1') NOT NULL DEFAULT '1',
  `jurnal_db` set('0','1') NOT NULL DEFAULT '1',
  `jurnal_du` set('0','1') NOT NULL DEFAULT '1',
  `frend_del` set('0','1') NOT NULL DEFAULT '1',
  `frend_add` set('0','1') NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `komissar`;

CREATE TABLE `komissar` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO komissar VALUES("1","Инспектор Катани, сев в свой бобик, поехал искать преступников...");
INSERT INTO komissar VALUES("2","Комиссар катани, наглотавшись колес, ходит по комнате и вычисляет мафию...");
INSERT INTO komissar VALUES("3","Инспектор катани лежит в засаде в куче навоза и следит за мафией... Фуу-у, ну и запашок:)");



DROP TABLE IF EXISTS `koms_foto`;

CREATE TABLE `koms_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `komu` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `album` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `koms_note`;

CREATE TABLE `koms_note` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `date` char(20) NOT NULL,
  `komu` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `konts`;

CREATE TABLE `konts` (
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_kont`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `kupidon_strela`;

CREATE TABLE `kupidon_strela` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7647 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lav_stori`;

CREATE TABLE `lav_stori` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lenta`;

CREATE TABLE `lenta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `text` text NOT NULL,
  `type` char(10) NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `read` tinyint(1) NOT NULL DEFAULT '0',
  `uid` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `letters`;

CREATE TABLE `letters` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `idwho` int(11) NOT NULL DEFAULT '0',
  `message` blob NOT NULL,
  `data` char(20) DEFAULT '0',
  `read` smallint(1) DEFAULT '0',
  `mod` char(1) NOT NULL DEFAULT '',
  `save` smallint(1) NOT NULL DEFAULT '0',
  `file` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `liders`;

CREATE TABLE `liders` (
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time_p` int(11) NOT NULL,
  `msg` varchar(215) NOT NULL,
  `stav` int(11) NOT NULL DEFAULT '0',
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `like_object`;

CREATE TABLE `like_object` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `type` varchar(11) DEFAULT NULL,
  `like` set('1','0') NOT NULL DEFAULT '0',
  `id_object` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `loads_f`;

CREATE TABLE `loads_f` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` char(100) NOT NULL,
  `time` int(11) NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL,
  `title` char(100) NOT NULL,
  `info` text NOT NULL,
  `cat` int(11) NOT NULL DEFAULT '0',
  `activity` float NOT NULL DEFAULT '0',
  `screen` char(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `loads_komm`;

CREATE TABLE `loads_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `loads_r`;

CREATE TABLE `loads_r` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lovederevo`;

CREATE TABLE `lovederevo` (
  `time_s` int(11) NOT NULL,
  `pod` varchar(5000) NOT NULL,
  `id_user` int(11) NOT NULL,
  `str` varchar(300) NOT NULL,
  `time_sp` int(11) NOT NULL,
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lovevs`;

CREATE TABLE `lovevs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `balls` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `sex` varchar(2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lovevs_komm`;

CREATE TABLE `lovevs_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=48 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lovevs_result`;

CREATE TABLE `lovevs_result` (
  `men` int(10) NOT NULL,
  `women` int(10) NOT NULL,
  `null` int(11) NOT NULL,
  `stop` int(11) NOT NULL,
  `off` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL,
  `money_on` int(11) NOT NULL,
  `balls` int(11) NOT NULL,
  `balls_on` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `rating_on` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `lovevs_reward`;

CREATE TABLE `lovevs_reward` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `balls` int(11) NOT NULL,
  `money` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `female` varchar(5) NOT NULL,
  `mail` int(2) NOT NULL,
  `time` int(11) NOT NULL,
  `stop` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1351 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `maf1`;

CREATE TABLE `maf1` (
  `klu4` int(8) NOT NULL,
  `time` varchar(5) NOT NULL,
  `who` varchar(100) NOT NULL,
  `message` varchar(512) NOT NULL,
  `id` double NOT NULL,
  `towhom` int(11) NOT NULL,
  `hid` smallint(1) NOT NULL,
  `usid` int(12) NOT NULL,
  `gamemes` tinyint(1) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `maf2`;

CREATE TABLE `maf2` (
  `klu4` int(8) NOT NULL,
  `time` varchar(5) NOT NULL,
  `who` varchar(100) NOT NULL,
  `message` varchar(512) NOT NULL,
  `id` double NOT NULL,
  `towhom` varchar(12) NOT NULL,
  `hid` smallint(1) NOT NULL,
  `usid` int(12) NOT NULL,
  `gamemes` tinyint(1) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `maf3`;

CREATE TABLE `maf3` (
  `klu4` int(8) NOT NULL,
  `time` varchar(5) NOT NULL,
  `who` varchar(100) NOT NULL,
  `message` varchar(512) NOT NULL,
  `id` double NOT NULL,
  `towhom` varchar(12) NOT NULL,
  `hid` smallint(1) NOT NULL,
  `usid` int(12) NOT NULL,
  `gamemes` tinyint(1) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mafaction1`;

CREATE TABLE `mafaction1` (
  `klu4` tinyint(1) NOT NULL,
  `action` varchar(100) NOT NULL,
  `nexttime` int(11) NOT NULL,
  `kiked` tinyint(1) NOT NULL,
  `prevprev` int(11) NOT NULL,
  `prev` int(11) NOT NULL,
  `current` int(11) NOT NULL,
  `cround` smallint(2) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO mafaction1 VALUES("1","nogame","1593862539","0","199","200","2","1");



DROP TABLE IF EXISTS `mafaction2`;

CREATE TABLE `mafaction2` (
  `klu4` tinyint(1) NOT NULL,
  `action` varchar(100) NOT NULL,
  `nexttime` int(11) NOT NULL,
  `kiked` tinyint(1) NOT NULL,
  `prevprev` int(11) NOT NULL,
  `prev` int(11) NOT NULL,
  `current` int(11) NOT NULL,
  `cround` smallint(2) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO mafaction2 VALUES("1","nogame","1130454825","0","200","3","2","2");



DROP TABLE IF EXISTS `mafaction3`;

CREATE TABLE `mafaction3` (
  `klu4` tinyint(1) NOT NULL,
  `action` varchar(100) NOT NULL,
  `nexttime` int(11) NOT NULL,
  `kiked` tinyint(1) NOT NULL,
  `prevprev` int(11) NOT NULL,
  `prev` int(11) NOT NULL,
  `current` int(11) NOT NULL,
  `cround` smallint(2) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO mafaction3 VALUES("1","nogame","1130448693","0","200","3","2","2");



DROP TABLE IF EXISTS `mafia`;

CREATE TABLE `mafia` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO mafia VALUES("1","Мафиози, вооружившись до зубов, направляются навстречу своей жертве...");
INSERT INTO mafia VALUES("2","Главарь мафии высматривает свою жертву. За ним, лизоблюдя, следуют его шестерки...");
INSERT INTO mafia VALUES("3","Мафия на четырех машинах носится по ночному городу и пугает редких прохожих...");



DROP TABLE IF EXISTS `mafusers`;

CREATE TABLE `mafusers` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `user` varchar(50) NOT NULL,
  `id_user` int(11) NOT NULL,
  `name` varchar(30) DEFAULT NULL,
  `posts` int(11) NOT NULL,
  `status` varchar(100) NOT NULL DEFAULT 'Новичек',
  `avr` set('0','10','15','20','25','30') NOT NULL DEFAULT '10',
  `max` set('5','8','10','12','15','20','25','30') NOT NULL DEFAULT '10',
  `level` set('0','1','2','3','4','5','6','7') NOT NULL DEFAULT '0',
  `creditsingame` int(10) NOT NULL,
  `credits` int(10) NOT NULL,
  `ignor` varchar(256) NOT NULL,
  `kik` int(20) NOT NULL,
  `whokik` varchar(20) NOT NULL,
  `whykik` varchar(200) NOT NULL,
  `user_ip` varchar(20) NOT NULL,
  `user_soft` varchar(200) NOT NULL,
  `inv` tinyint(1) NOT NULL,
  `say` set('0','1') NOT NULL DEFAULT '1',
  `img` varchar(50) NOT NULL,
  `translit` set('0','1') NOT NULL DEFAULT '0',
  `visit` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `onl` int(11) NOT NULL,
  `room` varchar(10) NOT NULL,
  `date` varchar(10) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user` (`user`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail`;

CREATE TABLE `mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_kont` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  `unlink` int(11) DEFAULT '0',
  `ras` varchar(5) DEFAULT NULL,
  `file` varchar(128) DEFAULT NULL,
  `file_name` varchar(50) NOT NULL,
  `file_type` varchar(50) NOT NULL,
  `file_ves` int(11) NOT NULL DEFAULT '0',
  `l_izv` int(11) NOT NULL DEFAULT '0',
  `dell_file` int(11) NOT NULL DEFAULT '0',
  `type` varchar(50) DEFAULT '',
  `id_object` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `read` (`read`),
  KEY `id_user` (`id_user`) USING BTREE,
  KEY `id_kont` (`id_kont`)
) ENGINE=MyISAM AUTO_INCREMENT=34389 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_ms`;

CREATE TABLE `mail_ms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `icon` int(11) NOT NULL DEFAULT '0',
  `name` varchar(50) NOT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_ms_msg`;

CREATE TABLE `mail_ms_msg` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mail_ms` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(5000) NOT NULL,
  `file_name` varchar(50) NOT NULL,
  `file_type` varchar(50) NOT NULL,
  `file_ves` int(11) NOT NULL DEFAULT '0',
  `dell_file` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_ms_tmp_users`;

CREATE TABLE `mail_ms_tmp_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mail_ms` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_ms_us_tmp_files`;

CREATE TABLE `mail_ms_us_tmp_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mail_ms` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_file` int(11) NOT NULL DEFAULT '0',
  `type_file` int(11) NOT NULL DEFAULT '0',
  `type_tmp` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_ms_users`;

CREATE TABLE `mail_ms_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mail_ms` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL DEFAULT '0',
  `read` int(11) NOT NULL DEFAULT '0',
  `izv` int(11) NOT NULL DEFAULT '0',
  `nabor` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_set`;

CREATE TABLE `mail_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `send` int(11) NOT NULL DEFAULT '0',
  `update` int(11) NOT NULL DEFAULT '0',
  `update_c` int(11) NOT NULL DEFAULT '0',
  `nabor` int(11) NOT NULL DEFAULT '0',
  `nabor_c` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mail_to_send`;

CREATE TABLE `mail_to_send` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mail` varchar(64) NOT NULL,
  `them` varchar(32) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `maniac`;

CREATE TABLE `maniac` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO maniac VALUES("1","Маньяк носится с топором в руках по темным переулкам...");
INSERT INTO maniac VALUES("2","Маньяк с гадкой ухмылкой на лице точит свой топор...");
INSERT INTO maniac VALUES("3","Маньяк сидит в засаде с оружием наготове и поджидает случайных прохожих...");



DROP TABLE IF EXISTS `mark`;

CREATE TABLE `mark` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_files`;

CREATE TABLE `mark_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_file` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_foto`;

CREATE TABLE `mark_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_foto` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_notes`;

CREATE TABLE `mark_notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_list` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mark_people`;

CREATE TABLE `mark_people` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_people` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_djine`;

CREATE TABLE `md_djine` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` int(11) NOT NULL,
  `step_time` int(11) DEFAULT NULL,
  `time_activate` int(11) NOT NULL,
  `stat` varchar(8) NOT NULL,
  `moder` int(11) NOT NULL,
  `stop_note` varchar(255) NOT NULL,
  `id_lot` int(11) NOT NULL,
  `stavka_lot` int(11) NOT NULL,
  `val` varchar(8) NOT NULL,
  `kto_lot` int(11) DEFAULT NULL,
  `step_lot` int(11) NOT NULL,
  `count_st` int(11) DEFAULT '0',
  `next_time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=45 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_djine_profile`;

CREATE TABLE `md_djine_profile` (
  `id` int(11) NOT NULL,
  `count_prod` int(11) DEFAULT '0',
  `reit` int(11) NOT NULL DEFAULT '0',
  `billing` int(11) DEFAULT '0',
  `money` int(11) DEFAULT '0',
  `balls` int(11) DEFAULT '0',
  `dis` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Таблица профилей статистики';




DROP TABLE IF EXISTS `md_djine_resp`;

CREATE TABLE `md_djine_resp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `st` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `autor` int(11) NOT NULL,
  `djine` int(11) NOT NULL,
  `est` smallint(1) DEFAULT '0',
  `text` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_djine_uch`;

CREATE TABLE `md_djine_uch` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `auc_id` int(11) NOT NULL,
  `uid` int(11) DEFAULT NULL,
  `s_stavka` int(11) NOT NULL,
  `val` varchar(8) NOT NULL,
  `stat` enum('0','1','2','3') DEFAULT '0',
  `prod` int(11) NOT NULL DEFAULT '0',
  `komu` int(11) NOT NULL DEFAULT '0',
  `count_stavk` int(11) NOT NULL DEFAULT '0',
  `djtime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=62 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_quiz`;

CREATE TABLE `md_quiz` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `start` int(11) NOT NULL,
  `stop` int(11) NOT NULL,
  `stat` enum('0','1') NOT NULL DEFAULT '1',
  `theme` varchar(255) DEFAULT NULL,
  `mode` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_quiz_ans`;

CREATE TABLE `md_quiz_ans` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `qid` int(11) NOT NULL,
  `question` varchar(1024) NOT NULL,
  `answer` varchar(255) NOT NULL,
  `prize` int(11) NOT NULL,
  `valute` varchar(16) NOT NULL,
  `user_otv` int(11) NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `md_quiz_prof`;

CREATE TABLE `md_quiz_prof` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `otv` int(11) NOT NULL,
  `balls` int(11) NOT NULL,
  `money` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mdduel`;

CREATE TABLE `mdduel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) DEFAULT NULL,
  `kogo` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `stoptime` int(11) NOT NULL,
  `stat` varchar(16) NOT NULL,
  `kto_c` smallint(6) NOT NULL DEFAULT '0',
  `kogo_c` smallint(6) NOT NULL DEFAULT '0',
  `lider` int(11) DEFAULT '0',
  `category` varchar(64) DEFAULT NULL,
  `votes_ids` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=39 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mdduel_stat`;

CREATE TABLE `mdduel_stat` (
  `user` int(11) NOT NULL,
  `pol` smallint(1) NOT NULL,
  `reit` float unsigned DEFAULT NULL,
  `all_reit` float NOT NULL DEFAULT '0',
  PRIMARY KEY (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mdduel_vote`;

CREATE TABLE `mdduel_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `duel` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `user_id` int(11) NOT NULL,
  `pol` smallint(1) NOT NULL,
  `zakogo` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=98 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mdloss_jn`;

CREATE TABLE `mdloss_jn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `code` varchar(32) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `val` varchar(16) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `code` (`code`)
) ENGINE=MyISAM AUTO_INCREMENT=10184 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `media_info`;

CREATE TABLE `media_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `file` varchar(64) NOT NULL,
  `size` int(11) NOT NULL,
  `lenght` varchar(32) NOT NULL,
  `bit` varchar(32) NOT NULL,
  `codec` varchar(32) NOT NULL,
  `wh` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `file` (`file`,`size`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `menu`;

CREATE TABLE `menu` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` enum('link','razd') NOT NULL DEFAULT 'link',
  `name` varchar(32) NOT NULL,
  `url` varchar(32) NOT NULL,
  `counter` varchar(32) NOT NULL,
  `pos` int(11) NOT NULL,
  `icon` varchar(32) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `pos` (`pos`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8 COMMENT='Главное меню';

INSERT INTO menu VALUES("1","link"," ≈ НОВОСТИ","/news/","news/count.php","0","KNOPKA_20.png");
INSERT INTO menu VALUES("2","link"," ≈ ЧАТ","/chat/","chat/count.php","15","KNOPKA_20.png");
INSERT INTO menu VALUES("4","link"," ≈ ГОСТЕВАЯ","/guest/","guest/count.php","19","KNOPKA_20.png");
INSERT INTO menu VALUES("5","link"," ≈ ЗОНА ОБМЕНА","/obmen/","obmen/count.php","14","KNOPKA_20.png");
INSERT INTO menu VALUES("6","link"," ≈ ФОРУМ","/forum/","forum/count.php","7","KNOPKA_20.png");
INSERT INTO menu VALUES("7","link"," ≈ ФОТО-ГАЛЕРЕЯ","/foto/","foto/count.php","18","KNOPKA_20.png");
INSERT INTO menu VALUES("11","link"," ≈ ЛИДЕРЫ","/user/liders/","/user/liders/count.php","13","KNOPKA_20.png");
INSERT INTO menu VALUES("10","link"," ≈ ДНЕВНИКИ","/plugins/notes/","plugins/notes/count.php","52","KNOPKA_20.png");
INSERT INTO menu VALUES("12","link"," ≈ ЗНАКОМСТВА","/user/love/","/user/love/count.php","12","KNOPKA_20.png");
INSERT INTO menu VALUES("13","link"," ≈ ИНФОРМАЦИЯ","/plugins/rules/","","1","KNOPKA_20.png");
INSERT INTO menu VALUES("14","link"," ≈ ОБИТАТЕЛИ","/user/users.php","/user/count.php","48","KNOPKA_20.png");
INSERT INTO menu VALUES("16","link"," ≈ ЗАГС","/weddings/","weddings/count.php","36","KNOPKA_20.png");
INSERT INTO menu VALUES("17","link"," ≈ КОЛЕСО ФОРТУНЫ","/plugins/fartus/","plugins/fartus/count.php","26","KNOPKA_20.png");
INSERT INTO menu VALUES("18","link"," ≈ ГАРЕМ//РЕЙТИНГ","/plugins/user_garem/top/","plugins/user_garem/count.php","10","KNOPKA_20.png");
INSERT INTO menu VALUES("20","link"," ≈ ФОТО-ДУЭЛИ","/mdduel/","/mdduel/count.php","21","KNOPKA_20.png");
INSERT INTO menu VALUES("21","link"," ≈ КОНКУРСЫ","/contests/","contests/count.php","8","KNOPKA_20.png");
INSERT INTO menu VALUES("22","link"," ≈ ДЕРЕВО ЛЮБВИ","/lovederevo/","lovederevo/count.php","20","KNOPKA_20.png");
INSERT INTO menu VALUES("28","link"," ≈ АУКЦИОН ДЖИНОВ","/mddjine/","","4","KNOPKA_20.png");
INSERT INTO menu VALUES("29","link"," ≈ ОСТРОСЛОВ","/mwb/","","24","KNOPKA_20.png");
INSERT INTO menu VALUES("30","link"," ≈ КЛАНЫ","/klan/","/klan/count.php","25","KNOPKA_20.png");
INSERT INTO menu VALUES("31","link"," ≈ МОЙ РЕБЁНОК","/mdchild/","mdchild/count.php","35","KNOPKA_20.png");
INSERT INTO menu VALUES("33","link"," ≈ БИТВА ПОЛОВ","/plugins/sexwar/","plugins/sexwar/count.php","27","KNOPKA_20.png");
INSERT INTO menu VALUES("34","link"," ≈ ФОТО-КОНКУРСЫ","/fk/","fk/count.php","6","KNOPKA_20.png");
INSERT INTO menu VALUES("41","link"," ≈ СкАзОчНыЙ БоНус","/skazka/","skazka/count.php","2","KNOPKA_20.png");
INSERT INTO menu VALUES("36","link"," ≈ ЗАРНИЦА","/zarnica/","zarnica/count.php","33","KNOPKA_20.png");
INSERT INTO menu VALUES("42","link"," ≈ СТАТУСЫ","/plugins/status/","plugins/status/count.php","32","KNOPKA_20.png");
INSERT INTO menu VALUES("44","link"," ≈ АДМИНИСТРАЦИЯ","/user/admin.user.php","/user/2count.php","50","KNOPKA_20.png");
INSERT INTO menu VALUES("46","link"," ≈ Скачки","plugins/games/ipodrom/","","39","KNOPKA_20.png");
INSERT INTO menu VALUES("47","link"," ≈ Игры в карты (2)","/plugins/game.php","","40","KNOPKA_20.png");
INSERT INTO menu VALUES("49","link","≈ Газета сайта","/gazeta/","/gazeta/count.php","51","KNOPKA_20.png");
INSERT INTO menu VALUES("50","link","≈ Аноним чат","/anonim/","/anonim/count.php","16","KNOPKA_20.png");
INSERT INTO menu VALUES("51","link","≈ Игра ШАШКИ","/plugins/shashki/","","42","KNOPKA_20.png");
INSERT INTO menu VALUES("52","link"," ≈ Опросы","plugins/poll/","plugins/poll/count.php","17","KNOPKA_20.png");
INSERT INTO menu VALUES("54","link","≈ Понаехали тут...","/plugins/Ponaehali/","","45","KNOPKA_20.png");
INSERT INTO menu VALUES("55","link"," ≈ Поиск видео в ютубе","/video/","","37","KNOPKA_20.png");
INSERT INTO menu VALUES("56","link"," ≈ Наши группы","/groups/","/groups/count.php","44","KNOPKA_20.png");
INSERT INTO menu VALUES("57","link"," ≈ ВОЙНА ЗА ЛЮБОВЬ","/plugins/love_vs/","/plugins/love_vs/count.php","43","KNOPKA_20.png");
INSERT INTO menu VALUES("58","link","≈ ВЕСЕЛАЯ ФЕРМА","/farm/","","47","KNOPKA_20.png");
INSERT INTO menu VALUES("59","link","≈ МАФИЯ","/mafia/","","46","KNOPKA_20.png");
INSERT INTO menu VALUES("60","link","≈ ИНТЕРНЫ","/intern/","","49","KNOPKA_20.png");



DROP TABLE IF EXISTS `message`;

CREATE TABLE `message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` varchar(10) NOT NULL DEFAULT '',
  `msg` text NOT NULL,
  `private` smallint(2) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `komu` int(11) NOT NULL DEFAULT '0',
  `user` varchar(15) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;




DROP TABLE IF EXISTS `mod_dei_go`;

CREATE TABLE `mod_dei_go` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `name` varchar(150) NOT NULL,
  `go_uid` int(11) NOT NULL,
  `date` varchar(50) NOT NULL,
  `id_dei` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1192 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `mod_dei_sp`;

CREATE TABLE `mod_dei_sp` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  `pol_m` varchar(150) NOT NULL,
  `pol_w` varchar(150) NOT NULL,
  `price` int(11) NOT NULL,
  `img` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=cp1251;

INSERT INTO mod_dei_sp VALUES("1","Хорошего дня ","Пожелал хорошего дня ","Пожелала хорошего дня ","200","15-19-10-723.png");
INSERT INTO mod_dei_sp VALUES("4","Добро пожаловать!","Сказал добро пожаловать ","Сказала добро пожаловать ","200","15-22-27-606.png");
INSERT INTO mod_dei_sp VALUES("6","Добро пожаловать!","Сказал добро пожаловать ","Сказала добро пожаловать ","10","15-22-22-660.gif");
INSERT INTO mod_dei_sp VALUES("9","Спокойной ночи ","Пожелал спокойной ночи ","Пожелала спокойной ночи  ","200","15-19-15-721.png");
INSERT INTO mod_dei_sp VALUES("12","Заполнить анкету ","Сказал заполните анкету ","Сказала заполните анкету ","20","15-29-29-103.gif");
INSERT INTO mod_dei_sp VALUES("14","С новосельем! ","Сказал с новосельем ","Сказала с новосельем ","20","15-32-09-167.png");
INSERT INTO mod_dei_sp VALUES("16","Добро пожаловать!","Сказал добро пожаловать ","Сказала добро пожаловать ","20","15-34-16-354.png");
INSERT INTO mod_dei_sp VALUES("18","Спасибо за регистрацию","Сказал спасибо за регистрацию  ","Сказала спасибо за регистрацию ","20","15-34-09-326.gif");
INSERT INTO mod_dei_sp VALUES("19","Спасибо за регистрацию","Сказал спасибо за регистрацию  ","Сказала спасибо за регистрацию ","20","15-34-07-325.gif");
INSERT INTO mod_dei_sp VALUES("23","Заполнить анкету ","Сказал заполните анкету ","Сказала заполните анкету ","20","15-38-33-369.png");
INSERT INTO mod_dei_sp VALUES("26","Заполнить анкету ","Сказал заполните анкету ","Сказала загрузите аватар ","20","22-38-21-591.png");
INSERT INTO mod_dei_sp VALUES("28","Привет ","Привет ","Привет ","20","117884267.jpg");
INSERT INTO mod_dei_sp VALUES("32","Я тебя люблю ","Тебя ","Люблю ","50","244049234.gif");
INSERT INTO mod_dei_sp VALUES("34","Сердечное спасибо ","Спасибо ","Спасибо ","30","278091714.jpg");
INSERT INTO mod_dei_sp VALUES("39","Комочек счастья","Комочек счастья","Комочек счастья","0","62_2618.png");
INSERT INTO mod_dei_sp VALUES("40","Ангел на счастье","Ангел на счастье","Ангел на счастье","0","28_89.png");
INSERT INTO mod_dei_sp VALUES("41","Обнимашки","Обнимашки","Обнимашки","0","146_101.png");
INSERT INTO mod_dei_sp VALUES("42","Подарок","Подарок","Подарок","0","20_1887.png");
INSERT INTO mod_dei_sp VALUES("43","Поцелуй","Поцелуй","Поцелуй","0","29_action_18.gif");
INSERT INTO mod_dei_sp VALUES("45","Хочу тебя съесть","Хочу тебя съесть","Хочу тебя съесть","0","181_15-44-36-111.png");
INSERT INTO mod_dei_sp VALUES("55","Класных выходных","Пожелал класных выходных","Пожелала класных выходных","100","action_450.png");
INSERT INTO mod_dei_sp VALUES("54","Угостить шампанским","Угостил шампанским","Угостила шампанским","100","action_458.png");
INSERT INTO mod_dei_sp VALUES("53","Загрузи фото","Загрузи фото","Загрузи фото","100","action_459.png");
INSERT INTO mod_dei_sp VALUES("57","У меня встал ","У меня встал","У меня встал на тебя ","100","24214038DsPT3NlW.png");
INSERT INTO mod_dei_sp VALUES("58","Войди в меня","Войди","Войди в меня любимый","100","24214317rEyuh3hU.png");
INSERT INTO mod_dei_sp VALUES("59","Войди в меня","Войди","Войди в меня любимый","100","24214317rEyuh3hU.png");
INSERT INTO mod_dei_sp VALUES("60","Такой горячий ","Ты такой горячий мальшь","Горячий","100","242149355O5ZjKc6.png");



DROP TABLE IF EXISTS `mwb`;

CREATE TABLE `mwb` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `moder` int(11) NOT NULL DEFAULT '0',
  `stat` enum('create','otvet','vote','stop') DEFAULT 'otvet',
  `time_created` int(11) NOT NULL,
  `time_start` int(11) NOT NULL,
  `time_stop` int(11) NOT NULL,
  `img` varchar(32) NOT NULL,
  `text` varchar(1024) NOT NULL,
  `priz_data` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `stat` (`stat`)
) ENGINE=MyISAM AUTO_INCREMENT=8 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mwb_post`;

CREATE TABLE `mwb_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `game` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `text` varchar(1024) NOT NULL,
  `stat` enum('moder','active','block') DEFAULT NULL,
  `moderator` int(11) NOT NULL DEFAULT '0',
  `summ` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `game` (`game`),
  KEY `user` (`user`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `mwb_vote`;

CREATE TABLE `mwb_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL,
  `game` int(11) NOT NULL,
  `post` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `vote` smallint(6) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `game` (`game`),
  KEY `post` (`post`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `my_guests`;

CREATE TABLE `my_guests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_ank` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` enum('0','1') NOT NULL DEFAULT '1',
  `count` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6159 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `my_smile`;

CREATE TABLE `my_smile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` varchar(32) NOT NULL,
  `smile` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=220 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `my_video`;

CREATE TABLE `my_video` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(1024) NOT NULL,
  `kod` varchar(100) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO my_video VALUES("1","2","Фактор 2 - Война","xRP5P4RU-Z4","1568154471");
INSERT INTO my_video VALUES("24","1","ЛУЧШИЕ ПРИКОЛЫ 2020 Февраль ","f-o6pithaDI","1581699039");
INSERT INTO my_video VALUES("25","1","ЛУЧШИЕ ПРИКОЛЫ 2020 Январь ","n1NBTA6t0D0","1581699048");
INSERT INTO my_video VALUES("6","45","Манвел Пашаян - ","yleG9UthzBg","1568319406");
INSERT INTO my_video VALUES("7","45","Время и Стекло feat. Потап - Слеза","mXCpavwSd1M","1568544179");
INSERT INTO my_video VALUES("8","45","Время и Стекло (Time ","OmX9uxoq4Ik","1568544736");
INSERT INTO my_video VALUES("9","186","КЛИП Lady Diana - НОВЕНЬКАЯ (Official Music video)","DH5LFwbbwIs","1570448446");
INSERT INTO my_video VALUES("10","45","Madonna - Frozen (Official Music Video)","XS088Opj9o0","1570843287");
INSERT INTO my_video VALUES("11","85","ПРИКОЛЫ 2019 Ноябрь ","VIoPoulGTpE","1572952719");
INSERT INTO my_video VALUES("12","213","Пиратская баллада - the Black Pearl","NytlFZxpYoc","1573229125");
INSERT INTO my_video VALUES("13","45","Изучаем английский язык по песням Перевод песни Pink - Family portrait","5HX-qMM11o8","1575429859");
INSERT INTO my_video VALUES("14","247","Танцуют все - 6. Кастинг Днепропетровск.  Настоящие грузинские танцы. Джигиты","fMTmX3QVFhA","1576474797");
INSERT INTO my_video VALUES("15","247","ВЫ ТОЛЬКО ПОСМОТРИТЕ, ЧТО ОНИ ВЫТВОРЯЮТ! Страстные грузины – Танцуют все!","8lSnbPvMgRo","1576475747");
INSERT INTO my_video VALUES("16","45","Ария - Беспечный ангел","ztKl8qqZr0c","1576583662");
INSERT INTO my_video VALUES("17","247","jgufi miraji - shavi adesa. OFICIAL","8bEh3g0rxOA","1576816907");
INSERT INTO my_video VALUES("18","247","umagresi klipi da simgera.flv","RcOT61bR4WE","1576823551");
INSERT INTO my_video VALUES("19","247","Эх,дороги (в исполнении грузин)","e7a12x9iMvM","1576829744");
INSERT INTO my_video VALUES("20","45","Максим ФАДЕЕВ ","KG-7yu2GNko","1576864939");
INSERT INTO my_video VALUES("21","45","EMIN - КРУЖИМСЯ (LYRIC VIDEO)","Cd05G_eLMWI","1576954657");
INSERT INTO my_video VALUES("22","45","Сегодня в белом танце кружимся.mpg","420PmPCk2Y0","1576954857");
INSERT INTO my_video VALUES("23","45","Деймон ","Quhq0Cy8OqY","1576955251");
INSERT INTO my_video VALUES("26","1","ЛУЧШИЕ ПРИКОЛЫ 2020 Июнь ","RuS3lQPUYzM","1592585980");



DROP TABLE IF EXISTS `news`;

CREATE TABLE `news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(10024) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `file` varchar(1) DEFAULT NULL,
  `id_user` int(11) NOT NULL,
  `title` varchar(32) DEFAULT NULL,
  `main_time` int(11) NOT NULL DEFAULT '0',
  `link` varchar(64) NOT NULL,
  `id_f` int(11) NOT NULL,
  `id_r` int(11) NOT NULL,
  `id_t` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `news_komm`;

CREATE TABLE `news_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `id_news` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `nick_changes`;

CREATE TABLE `nick_changes` (
  `user_id` int(10) unsigned NOT NULL,
  `new_nick` varchar(32) NOT NULL,
  `old_nick` varchar(32) NOT NULL,
  `time` int(10) unsigned NOT NULL,
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `nick_color`;

CREATE TABLE `nick_color` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(11) NOT NULL,
  `color1` varchar(11) NOT NULL,
  `color2` varchar(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=27 DEFAULT CHARSET=utf8;

INSERT INTO nick_color VALUES("2","gradient","922e1f","4d72df");
INSERT INTO nick_color VALUES("3","gradient","ff0d0d","6c1c0d");
INSERT INTO nick_color VALUES("4","gradient","970000","000000");
INSERT INTO nick_color VALUES("5","gradient","00ff00","8080ff");
INSERT INTO nick_color VALUES("6","gradient","ffffff","000000");
INSERT INTO nick_color VALUES("7","gradient","0000ff","80ff00");
INSERT INTO nick_color VALUES("8","gradient","ff5e5e","800000");
INSERT INTO nick_color VALUES("9","gradient","00ff00","ff0000");
INSERT INTO nick_color VALUES("10","color","ff0000","");
INSERT INTO nick_color VALUES("11","color","ff8000","");
INSERT INTO nick_color VALUES("12","color","00ff00","");
INSERT INTO nick_color VALUES("13","color","ffff00","");
INSERT INTO nick_color VALUES("14","color","8080ff","");
INSERT INTO nick_color VALUES("15","color","0000a0","");
INSERT INTO nick_color VALUES("16","color","6600cc","");
INSERT INTO nick_color VALUES("17","gradient","abab00","000000");
INSERT INTO nick_color VALUES("19","gradient","ffff00","00ffff");
INSERT INTO nick_color VALUES("20","gradient","00ffff","ffff00");
INSERT INTO nick_color VALUES("21","gradient","0000ff","ffff00");
INSERT INTO nick_color VALUES("22","gradient","0000ff","ff0000");
INSERT INTO nick_color VALUES("23","gradient","ff0000","0000ff");
INSERT INTO nick_color VALUES("24","gradient","00ff00","ffff00");
INSERT INTO nick_color VALUES("25","gradient","000000","ff0000");



DROP TABLE IF EXISTS `nick_fon`;

CREATE TABLE `nick_fon` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=150 DEFAULT CHARSET=utf8;

INSERT INTO nick_fon VALUES("3");
INSERT INTO nick_fon VALUES("4");
INSERT INTO nick_fon VALUES("5");
INSERT INTO nick_fon VALUES("6");
INSERT INTO nick_fon VALUES("7");
INSERT INTO nick_fon VALUES("9");
INSERT INTO nick_fon VALUES("10");
INSERT INTO nick_fon VALUES("11");
INSERT INTO nick_fon VALUES("12");
INSERT INTO nick_fon VALUES("13");
INSERT INTO nick_fon VALUES("14");
INSERT INTO nick_fon VALUES("15");
INSERT INTO nick_fon VALUES("17");
INSERT INTO nick_fon VALUES("18");
INSERT INTO nick_fon VALUES("19");
INSERT INTO nick_fon VALUES("20");
INSERT INTO nick_fon VALUES("22");
INSERT INTO nick_fon VALUES("23");
INSERT INTO nick_fon VALUES("24");
INSERT INTO nick_fon VALUES("25");
INSERT INTO nick_fon VALUES("26");
INSERT INTO nick_fon VALUES("27");
INSERT INTO nick_fon VALUES("28");
INSERT INTO nick_fon VALUES("29");
INSERT INTO nick_fon VALUES("30");
INSERT INTO nick_fon VALUES("32");
INSERT INTO nick_fon VALUES("33");
INSERT INTO nick_fon VALUES("34");
INSERT INTO nick_fon VALUES("35");
INSERT INTO nick_fon VALUES("36");
INSERT INTO nick_fon VALUES("37");
INSERT INTO nick_fon VALUES("38");
INSERT INTO nick_fon VALUES("39");
INSERT INTO nick_fon VALUES("40");
INSERT INTO nick_fon VALUES("41");
INSERT INTO nick_fon VALUES("43");
INSERT INTO nick_fon VALUES("44");
INSERT INTO nick_fon VALUES("45");
INSERT INTO nick_fon VALUES("46");
INSERT INTO nick_fon VALUES("47");
INSERT INTO nick_fon VALUES("48");
INSERT INTO nick_fon VALUES("49");
INSERT INTO nick_fon VALUES("51");
INSERT INTO nick_fon VALUES("52");
INSERT INTO nick_fon VALUES("53");
INSERT INTO nick_fon VALUES("54");
INSERT INTO nick_fon VALUES("55");
INSERT INTO nick_fon VALUES("56");
INSERT INTO nick_fon VALUES("57");
INSERT INTO nick_fon VALUES("58");
INSERT INTO nick_fon VALUES("59");
INSERT INTO nick_fon VALUES("60");
INSERT INTO nick_fon VALUES("62");
INSERT INTO nick_fon VALUES("63");
INSERT INTO nick_fon VALUES("64");
INSERT INTO nick_fon VALUES("66");
INSERT INTO nick_fon VALUES("67");
INSERT INTO nick_fon VALUES("68");
INSERT INTO nick_fon VALUES("69");
INSERT INTO nick_fon VALUES("70");
INSERT INTO nick_fon VALUES("71");
INSERT INTO nick_fon VALUES("72");
INSERT INTO nick_fon VALUES("73");
INSERT INTO nick_fon VALUES("74");
INSERT INTO nick_fon VALUES("75");
INSERT INTO nick_fon VALUES("76");
INSERT INTO nick_fon VALUES("77");
INSERT INTO nick_fon VALUES("78");
INSERT INTO nick_fon VALUES("79");
INSERT INTO nick_fon VALUES("80");
INSERT INTO nick_fon VALUES("81");
INSERT INTO nick_fon VALUES("82");
INSERT INTO nick_fon VALUES("83");
INSERT INTO nick_fon VALUES("84");
INSERT INTO nick_fon VALUES("85");
INSERT INTO nick_fon VALUES("86");
INSERT INTO nick_fon VALUES("87");
INSERT INTO nick_fon VALUES("88");
INSERT INTO nick_fon VALUES("89");
INSERT INTO nick_fon VALUES("90");
INSERT INTO nick_fon VALUES("91");
INSERT INTO nick_fon VALUES("92");
INSERT INTO nick_fon VALUES("93");
INSERT INTO nick_fon VALUES("94");
INSERT INTO nick_fon VALUES("95");
INSERT INTO nick_fon VALUES("96");
INSERT INTO nick_fon VALUES("97");
INSERT INTO nick_fon VALUES("98");
INSERT INTO nick_fon VALUES("99");
INSERT INTO nick_fon VALUES("100");
INSERT INTO nick_fon VALUES("101");
INSERT INTO nick_fon VALUES("102");
INSERT INTO nick_fon VALUES("103");
INSERT INTO nick_fon VALUES("104");
INSERT INTO nick_fon VALUES("105");
INSERT INTO nick_fon VALUES("106");
INSERT INTO nick_fon VALUES("107");
INSERT INTO nick_fon VALUES("108");
INSERT INTO nick_fon VALUES("109");
INSERT INTO nick_fon VALUES("110");
INSERT INTO nick_fon VALUES("111");
INSERT INTO nick_fon VALUES("112");
INSERT INTO nick_fon VALUES("113");
INSERT INTO nick_fon VALUES("114");
INSERT INTO nick_fon VALUES("115");
INSERT INTO nick_fon VALUES("116");
INSERT INTO nick_fon VALUES("117");
INSERT INTO nick_fon VALUES("118");
INSERT INTO nick_fon VALUES("119");
INSERT INTO nick_fon VALUES("120");
INSERT INTO nick_fon VALUES("122");
INSERT INTO nick_fon VALUES("123");
INSERT INTO nick_fon VALUES("124");
INSERT INTO nick_fon VALUES("125");
INSERT INTO nick_fon VALUES("126");
INSERT INTO nick_fon VALUES("127");
INSERT INTO nick_fon VALUES("128");
INSERT INTO nick_fon VALUES("129");
INSERT INTO nick_fon VALUES("130");
INSERT INTO nick_fon VALUES("131");
INSERT INTO nick_fon VALUES("132");
INSERT INTO nick_fon VALUES("133");
INSERT INTO nick_fon VALUES("134");
INSERT INTO nick_fon VALUES("135");
INSERT INTO nick_fon VALUES("136");
INSERT INTO nick_fon VALUES("137");
INSERT INTO nick_fon VALUES("138");
INSERT INTO nick_fon VALUES("139");
INSERT INTO nick_fon VALUES("140");
INSERT INTO nick_fon VALUES("141");
INSERT INTO nick_fon VALUES("142");
INSERT INTO nick_fon VALUES("143");
INSERT INTO nick_fon VALUES("144");
INSERT INTO nick_fon VALUES("145");
INSERT INTO nick_fon VALUES("147");
INSERT INTO nick_fon VALUES("148");
INSERT INTO nick_fon VALUES("149");



DROP TABLE IF EXISTS `notes`;

CREATE TABLE `notes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  `name` varchar(32) DEFAULT NULL,
  `private` int(11) NOT NULL DEFAULT '0',
  `tags` varchar(64) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `private_komm` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `id_dir` int(11) DEFAULT '0',
  `type` int(1) DEFAULT '0',
  `votes` enum('1','0') DEFAULT '0',
  `votes_text` varchar(50) DEFAULT NULL,
  `times` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes_count`;

CREATE TABLE `notes_count` (
  `id_notes` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  KEY `id_notes` (`id_notes`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes_dir`;

CREATE TABLE `notes_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `name` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes_files`;

CREATE TABLE `notes_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `notes_id` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `ras` varchar(32) NOT NULL,
  `size` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_post` (`notes_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes_komm`;

CREATE TABLE `notes_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_notes` varchar(50) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notes_like`;

CREATE TABLE `notes_like` (
  `id_notes` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) DEFAULT '0',
  KEY `id_notes` (`id_notes`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notification`;

CREATE TABLE `notification` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_object` int(11) NOT NULL,
  `type` varchar(11) NOT NULL,
  `avtor` int(11) DEFAULT NULL,
  `all_type` varchar(11) DEFAULT NULL,
  `read` int(1) DEFAULT '0',
  `msg` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=36753 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `notification_set`;

CREATE TABLE `notification_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `komm` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=630 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `obmennik_dir`;

CREATE TABLE `obmennik_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `num` int(11) DEFAULT '0',
  `name` varchar(64) NOT NULL,
  `ras` varchar(512) NOT NULL,
  `maxfilesize` int(11) NOT NULL,
  `dir` varchar(512) NOT NULL DEFAULT '/',
  `dir_osn` varchar(512) DEFAULT '/',
  `upload` set('1','0') NOT NULL DEFAULT '0',
  `my` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `num` (`num`),
  KEY `dir` (`dir`(333))
) ENGINE=MyISAM AUTO_INCREMENT=360 DEFAULT CHARSET=utf8;

INSERT INTO obmennik_dir VALUES("3","0","Прочее","","0","/Prochee/","/","0","0");
INSERT INTO obmennik_dir VALUES("4","0","Флэш","","0","/Fljesh/","/","0","0");
INSERT INTO obmennik_dir VALUES("5","0","Статьи, документы","","0","/Stati__dokumenty/","/","0","0");
INSERT INTO obmennik_dir VALUES("6","0","Книги","","0","/Knigi/","/","0","0");
INSERT INTO obmennik_dir VALUES("7","0","Темы","","0","/Temy/","/","0","0");
INSERT INTO obmennik_dir VALUES("71","0","Музыка","","0","/Muzyka/","/","0","0");
INSERT INTO obmennik_dir VALUES("9","0","Аудио","","0","/Audio/","/","0","0");
INSERT INTO obmennik_dir VALUES("10","0","Картинки","","0","/Kartinki/","/","0","0");
INSERT INTO obmennik_dir VALUES("38","0","Анимации","jpg:jpeg:gif:png","0","/Animacii/","/","0","0");
INSERT INTO obmennik_dir VALUES("12","0","Творчество обитателей","","0","/Tvorchestvo_obitatelej/","/","0","0");
INSERT INTO obmennik_dir VALUES("13","0","Программы","","0","/Programmy/","/","0","0");
INSERT INTO obmennik_dir VALUES("14","0","Игры","","0","/Igry/","/","0","0");
INSERT INTO obmennik_dir VALUES("65","0","Видео","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","20971520","/Video/","/","1","0");
INSERT INTO obmennik_dir VALUES("39","0","Абстракции","gif;png;jpeg;jpg;","5242880","/Animacii/Abstrakcii/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("18","0","Java игры ","","0","/Igry/Java_igry_/","/Igry/","0","0");
INSERT INTO obmennik_dir VALUES("25","0","Разное","gif;png;jpeg;jpg;","5242880","/Kartinki/Raznoe/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("23","0","Sony Ericsson ","","0","/Igry/Java_igry_/Sony_Ericsson_/","/Igry/Java_igry_/","0","0");
INSERT INTO obmennik_dir VALUES("24","0","Samsung","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Samsung/","/Igry/Java_igry_/","1","0");
INSERT INTO obmennik_dir VALUES("26","0","Nokia","jar;zip;sis;rar;exe;sisx;","0","/Igry/Java_igry_/Nokia/","/Igry/Java_igry_/","0","0");
INSERT INTO obmennik_dir VALUES("27","0","Motorola","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Motorola/","/Igry/Java_igry_/","1","0");
INSERT INTO obmennik_dir VALUES("33","0","240x320 - K790,800, S700, W850,900 ","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/240x320_-_K790_800__S700__W850_900_/","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("32","0","UIQ 2 - 208x320- P800, P900, P910","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/UIQ_2_-_208x320-_P800__P900__P910/","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("31","0","UIQ 3 - 240x320 - M600, P990, W950 и др.","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/UIQ_3_-_240x320_-_M600__P990__W950_i_dr./","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("34","0","176x220 - K600,700,750; W550,700,8x0; V,Z800","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/176x220_-_K600_700_750;_W550_700_8x0;_V_Z800/","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("35","0","128x160 - K310/20,5xx, W200,300, Z5xx ","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/128x160_-_K310/20_5xx__W200_300__Z5xx_/","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("36","0","128x160 - T610, T630, Z600","jar;zip;sis;rar;exe;sisx;","10485760","/Igry/Java_igry_/Sony_Ericsson_/128x160_-_T610__T630__Z600/","/Igry/Java_igry_/Sony_Ericsson_/","1","0");
INSERT INTO obmennik_dir VALUES("37","0","128x128 - K300, J300, Z300","","0","/Igry/Java_igry_/Sony_Ericsson_/128x128_-_K300__J300__Z300/","/Igry/Java_igry_/Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("40","0","Аниме","gif;png;","5242880","/Animacii/Anime/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("41","0","Животные","gif;png;jpeg;jpg;","5242880","/Animacii/ZHivotnye/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("42","0","Кино/Игры","gif;png;jpeg;jpg;","5242880","/Animacii/Kino/Igry/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("43","0","Космос","gif;png;jpeg;jpg;","5242880","/Animacii/Kosmos/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("319","0","ПАРОДИИ","","0","/Muzyka/PARODII/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("45","0","Люди","gif;png;jpeg;jpg;","5242880","/Animacii/Ljydi/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("46","0","Мульты","gif;png;jpeg;jpg;","5242880","/Animacii/Multy/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("47","0","Праздники","gif;png;jpeg;jpg;","5242880","/Animacii/Prazdniki/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("48","0","Природа","gif;png;jpeg;jpg;","5242880","/Animacii/Priroda/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("49","0","Спорт","gif;png;jpeg;jpg;","5242880","/Animacii/Sport/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("50","0","Юмор/Приколы","gif;png;jpeg;jpg;","5242880","/Animacii/Jymor/Prikoly/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("51","0","Эротика","gif;png;jpeg;jpg;","5242880","/Animacii/Jerotika/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("358","0","Рингтоны","мр3","0","/Audio/Ringtony/","/Audio/","0","0");
INSERT INTO obmennik_dir VALUES("55","0","Разное ","gif;png;jpeg;jpg;","512000","/Animacii/Raznoe_/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("57","0","Будильники","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","5242880","/Audio/Budilniki/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("58","0","Юмор/Приколы","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","20971520","/Audio/Jymor/Prikoly/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("59","0","Розыгрыши","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","10485760","/Audio/Rozygryshi/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("60","0","Из мультиков","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","10485760","/Audio/Iz_multikov/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("62","0","Разное","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","10485760","/Audio/Raznoe/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("66","0","Животные","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","10485760","/Video/ZHivotnye/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("97","0","ЭрОтИкА",":","52428800","/Video/JerOtIkA/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("68","0","Разное","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","20971520","/Video/Raznoe/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("74","0","Электронная","","0","/Muzyka/Jelektronnaja/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("75","0","Шансон","","0","/Muzyka/SHanson/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("76","0","Тяжёлая","","0","/Muzyka/Tjazhjolaja/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("77","0","Спокойная","","0","/Muzyka/Spokojnaja/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("78","0","Регги","","0","/Muzyka/Reggi/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("79","0","Под гитару","","0","/Muzyka/Pod_gitaru/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("80","0","Клубная/Танцевальная","mp3;mp4;zip;rar;awe;","52428800","/Muzyka/Klubnaja/Tancevalnaja/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("81","0","Классика","","0","/Muzyka/Klassika/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("82","0","Из кино,игр,мультов","mp3;mp4;zip;rar;awe;","20971520","/Muzyka/Iz_kino_igr_multov/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("83","0","Другое","","0","/Muzyka/Drugoe/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("84","0","Дискотека 80-90х ","","0","/Muzyka/Diskoteka_80-90h_/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("85","0","Альтернатива","","0","/Muzyka/Alternativa/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("86","0","Альбомы (полные) ","","0","/Muzyka/Albomy_(polnye)_/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("87","0","Rock Русский","","0","/Muzyka/Rock_Russkij/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("88","0","Rock Зарубежный","","0","/Muzyka/Rock_Zarubezhnyj/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("89","0","Rap/Hip-Hop","mp3;mp4;zip;rar;awe;","20971520","/Muzyka/Rap/Hip-Hop/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("90","0","POP Русский","mp3","52428800","/Muzyka/POP_Russkij/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("91","0","POP","","0","/Muzyka/POP/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("92","0","DUBSTEP","mp3;wav;wma;","52428800","/Muzyka/DUBSTEP/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("93","0","Drum and Bass ","","0","/Muzyka/Drum_and_Bass_/","/Muzyka/","0","0");
INSERT INTO obmennik_dir VALUES("94","0","Клипы","mp4;3gp;","20971520","/Video/Klipy/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("98","0","Легкая Эротика","\"","52428800","/Video/JerOtIkA/Legkaja_Jerotika/","/Video/JerOtIkA/","1","0");
INSERT INTO obmennik_dir VALUES("100","0","Личное sex-видео парней ","","0","/Video/JerOtIkA/Lichnoe_sex-video_parnej_/","/Video/JerOtIkA/","0","0");
INSERT INTO obmennik_dir VALUES("101","0","Личное sex-видео девушек","","0","/Video/JerOtIkA/Lichnoe_sex-video_devushek/","/Video/JerOtIkA/","0","0");
INSERT INTO obmennik_dir VALUES("103","0","Знаменитости ","gif;png;jpeg;jpg","5242880","/Kartinki/Znamenitosti_/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("104","0","Темы для Nokia","\"","1048576","/Temy/Temy_dlja_Nokia/","/Temy/","1","0");
INSERT INTO obmennik_dir VALUES("105","0","Животные","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("106","0","Любовь","gif;png;jpeg;jpg","5242880","/Kartinki/Ljybov/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("107","0","Природа","gif;png;jpeg;jpg","5242880","/Kartinki/Priroda/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("347","0","Субкультура","gif;png;jpeg;jpg","0","/Kartinki/Subkultura/","/Kartinki/","0","0");
INSERT INTO obmennik_dir VALUES("109","0","Ужасы","gif;png;jpeg;jpg","5242880","/Kartinki/Uzhasy/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("110","0","Фантастика","gif;png;jpeg;jpg","5242880","/Kartinki/Fantastika/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("112","0","Легкая эротика ","gif;png;jpeg;jpg","5242880","/Kartinki/Legkaja_jerotika_/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("113","0","Темы для Samsung","\"","1048576","/Temy/Temy_dlja_Samsung/","/Temy/","1","0");
INSERT INTO obmennik_dir VALUES("114","0","Темы для Sony Ericsson ","\"","1048576","/Temy/Temy_dlja_Sony_Ericsson_/","/Temy/","1","0");
INSERT INTO obmennik_dir VALUES("115","0","Темы для Windows Mobile","\"","2097152","/Temy/Temy_dlja_Windows_Mobile/","/Temy/","1","0");
INSERT INTO obmennik_dir VALUES("116","0","Стихи в картинках ","jpg;jpeg;gif;png","5242880","/Tvorchestvo_obitatelej/Stihi_v_kartinkah_/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("117","0","Видео файлы","\"","512000","/Tvorchestvo_obitatelej/Video_fajly/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("118","0","Темы от пользователей","\"","1048576","/Tvorchestvo_obitatelej/Temy_ot_polzovatelej/","/Tvorchestvo_obitatelej/","1","0");
INSERT INTO obmennik_dir VALUES("119","0","Symbian игры ","\"","52428800","/Igry/Symbian_igry_/","/Igry/","1","0");
INSERT INTO obmennik_dir VALUES("120","0","Windows Mobiе Игры","\"","52428800","/Igry/Windows_Mobie_Igry/","/Igry/","1","0");
INSERT INTO obmennik_dir VALUES("121","0","Эмуляторы с приставок","\"","52428800","/Igry/Jemuljatory_s_pristavok/","/Igry/","1","0");
INSERT INTO obmennik_dir VALUES("122","0","Заставки ","gif;png;jpeg;jpg;swf","5242880","/Fljesh/Zastavki_/","/Fljesh/","1","0");
INSERT INTO obmennik_dir VALUES("123","0","Часы ","gif;png;jpeg;jpg;swf","5242880","/Fljesh/CHasy_/","/Fljesh/","1","0");
INSERT INTO obmennik_dir VALUES("124","0","Java Програмы","\"","52428800","/Programmy/Java_Programy/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("125","0","Symbian Програмы","\"","52428800","/Programmy/Symbian_Programy/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("126","0","Windows Mobile Програмы","\"","52428800","/Programmy/Windows_Mobile_Programy/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("127","0","Android Програмы","\"","52428800","/Programmy/Android_Programy/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("128","0","Программы для ПК","\"","52428800","/Programmy/Programmy_dlja_PK/","/Programmy/","1","0");
INSERT INTO obmennik_dir VALUES("129","0","Видео","\"","52428800","/Prochee/Video/","/Prochee/","1","0");
INSERT INTO obmennik_dir VALUES("130","0","Фильмы","\"","52428800","/Prochee/Filmy/","/Prochee/","1","0");
INSERT INTO obmennik_dir VALUES("131","0","Фото","\"","512000","/Prochee/Foto/","/Prochee/","1","0");
INSERT INTO obmennik_dir VALUES("132","0","Все для САЙТОСТРОЕНИЯ ","zip;rar;exe;php;gif;jpeg;jpg;mp3;mp4;avi;doc;dvd;","57671680","/Vse_dlja_SAJTOSTROENIJa_/","/","1","0");
INSERT INTO obmennik_dir VALUES("133","0","Моды","zip;rar;exe;php;gif;jpeg;jpg;mp3;mp4;avi;doc;dvd;","10485760","/Vse_dlja_SAJTOSTROENIJa_/Mody/","/Vse_dlja_SAJTOSTROENIJa_/","1","0");
INSERT INTO obmennik_dir VALUES("134","0","Дополнения (6.6.x)","zip;rar;exe;php;gif;jpeg;jpg;mp3;mp4;avi;doc;dvd;","10485760","/Vse_dlja_SAJTOSTROENIJa_/Dopolnenija_(6.6.x)/","/Vse_dlja_SAJTOSTROENIJa_/","1","0");
INSERT INTO obmennik_dir VALUES("135","0","Релизы dcms","zip;rar;exe;php;gif;jpeg;jpg;mp3;mp4;avi;doc;dvd;","10485760","/Vse_dlja_SAJTOSTROENIJa_/Relizy_dcms/","/Vse_dlja_SAJTOSTROENIJa_/","1","0");
INSERT INTO obmennik_dir VALUES("136","0","Темы оформления","zip;rar;exe;php;gif;jpeg;jpg;mp3;mp4;avi;doc;dvd;","10485760","/Vse_dlja_SAJTOSTROENIJa_/Temy_oformlenija/","/Vse_dlja_SAJTOSTROENIJa_/","1","0");
INSERT INTO obmennik_dir VALUES("137","0","+18","gif;","52428800","/Video/ZHivotnye/+18/","/Video/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("138","0","Порно","3gp;avi;mp4;dvd;","52428800","/Video/Porno/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("139","0","Фильмы","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/","/","1","0");
INSERT INTO obmennik_dir VALUES("140","0","Сериал","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","0","/Filmy/Serial/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("141","0","Аниме","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","0","/Filmy/Anime/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("142","0","Биография","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","0","/Filmy/Biografija/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("143","0","Боевик","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Boevik/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("144","0","Вестерн","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Vestern/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("145","0","Военный","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","0","/Filmy/Voennyj/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("146","0","Детектив","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Detektiv/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("147","0","Для взрослых","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Dlja_vzroslyh/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("148","0","Документальный","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Dokumentalnyj/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("149","0","Драма","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","0","/Filmy/Drama/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("150","0","История","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Istorija/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("151","0","Комедия","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Komedija/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("152","0","Концерт","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Koncert/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("153","0","Короткометражка","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Korotkometrazhka/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("154","0","Крименал","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Krimenal/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("155","0","Мелодрама","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Melodrama/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("156","0","Мультфильм","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Multfilm/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("159","0","Семейный","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Semejnyj/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("161","0","Спорт","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Sport/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("162","0","Ужасы","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Uzhasy/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("282","0","Знаменитости","mp4;3gp;","10485760","/Video/Znamenitosti/","/Video/","1","0");
INSERT INTO obmennik_dir VALUES("164","0","Фэнтези","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Fjentezi/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("165","0","Разное","avi;wmw;mkv;3gp;flv;mpeg;mp4;mov;vob;","57671680","/Filmy/Raznoe/","/Filmy/","1","0");
INSERT INTO obmennik_dir VALUES("168","0","Аниме","jpg;jpeg;gif;png;","5242880","/Kartinki/Anime/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("174","0","simens","","0","/Igry/Java_igry_/simens/","/Igry/Java_igry_/","0","0");
INSERT INTO obmennik_dir VALUES("173","0","История","","0","/Istorija/","/","0","0");
INSERT INTO obmennik_dir VALUES("177","0","Из фильмов","","0","/Video/Iz_filmov/","/Video/","0","0");
INSERT INTO obmennik_dir VALUES("183","0","Легенды","","0","/Legendy/","/","0","0");
INSERT INTO obmennik_dir VALUES("194","0","О сексе","","0","/Istorija/O_sekse/","/Istorija/","0","0");
INSERT INTO obmennik_dir VALUES("185","0","О вашом городе","","0","/Legendy/O_vashom_gorode/","/Legendy/","0","0");
INSERT INTO obmennik_dir VALUES("192","0","Страшылки","","0","/Istorija/Strashylki/","/Istorija/","0","0");
INSERT INTO obmennik_dir VALUES("191","0","разное","","0","/Istorija/raznoe/","/Istorija/","0","0");
INSERT INTO obmennik_dir VALUES("196","0","Разное","","0","/Legendy/Raznoe/","/Legendy/","0","0");
INSERT INTO obmennik_dir VALUES("198","0","О музкантах","","0","/Istorija/O_muzkantah/","/Istorija/","0","0");
INSERT INTO obmennik_dir VALUES("318","0","Астрология","mp4;mp3;avi;3gp;jpg;txt;doc;","52428800","/Astrologija/","/","1","0");
INSERT INTO obmennik_dir VALUES("202","0","Романы","","0","/Knigi/Romany/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("204","0","Боёвыки","","0","/Knigi/Bojovyki/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("206","0","Фентези","","0","/Knigi/Fentezi/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("208","0","кулинария","","0","/Knigi/kulinarija/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("210","0","О спорте","","0","/Knigi/O_sporte/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("219","0","Индийськие","","0","/Filmy/Indijskie/","/Filmy/","0","0");
INSERT INTO obmennik_dir VALUES("221","0","flay","","0","/Igry/Java_igry_/flay/","/Igry/Java_igry_/","0","0");
INSERT INTO obmennik_dir VALUES("223","0","Гонки","","0","/Igry/Java_igry_/simens/Gonki/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("225","0","Драки","","0","/Igry/Java_igry_/simens/Draki/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("227","0","Логические","","0","/Igry/Java_igry_/simens/Logicheskie/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("229","0","Аркады","","0","/Igry/Java_igry_/simens/Arkady/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("231","0","Симуляторы","","0","/Igry/Java_igry_/simens/Simuljatory/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("233","0","Стрелялки","","0","/Igry/Java_igry_/simens/Streljalki/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("235","0","Азартные","","0","/Igry/Java_igry_/simens/Azartnye/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("237","0","Из фильмов/мутфильмов","","0","/Igry/Java_igry_/simens/Iz_filmov/mutfilmov/","/Igry/Java_igry_/simens/","0","0");
INSERT INTO obmennik_dir VALUES("238","0","Спорт","jpg;jpeg","23068672","/Kartinki/Sport/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("239","0","Из игр","jpg;jpeg","23068672","/Kartinki/Iz_igr/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("240","0","Symbian 9.4, ^3","sis;zip;rar;jar;sisx","0","/Programmy/Symbian_Programy/Symbian_9.4__^3/","/Programmy/Symbian_Programy/","0","0");
INSERT INTO obmennik_dir VALUES("241","0","Nokia","","0","/Programmy/Java_Programy/Nokia/","/Programmy/Java_Programy/","0","0");
INSERT INTO obmennik_dir VALUES("242","0","Series 40v3 - 240x320","jar","10485760","/Programmy/Java_Programy/Nokia/Series_40v3_-_240x320/","/Programmy/Java_Programy/Nokia/","1","0");
INSERT INTO obmennik_dir VALUES("243","0","Разные","jar","10485760","/Programmy/Java_Programy/Nokia/Series_40v3_-_240x320/Raznye/","/Programmy/Java_Programy/Nokia/Series_40v3_-_240x320/","1","0");
INSERT INTO obmennik_dir VALUES("244","0","Internet/Почта","sis;zip;rar;jar;sisx","31457280","/Programmy/Symbian_Programy/Symbian_9.4__^3/Internet/Pochta/","/Programmy/Symbian_Programy/Symbian_9.4__^3/","1","0");
INSERT INTO obmennik_dir VALUES("245","0","Аркады","","0","/Igry/Java_igry_/flay/Arkady/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("246","0","Азартные","","0","/Igry/Java_igry_/flay/Azartnye/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("247","0","Гонки","","0","/Igry/Java_igry_/flay/Gonki/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("248","0","Стрелялки","","0","/Igry/Java_igry_/flay/Streljalki/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("249","0","Семуляторы","","0","/Igry/Java_igry_/flay/Semuljatory/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("250","0","Драки","","0","/Igry/Java_igry_/flay/Draki/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("251","0","Стратегии","","0","/Igry/Java_igry_/flay/Strategii/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("252","0","Настольные","","0","/Igry/Java_igry_/flay/Nastolnye/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("253","0","Аудио/Видео ","exe;zip;rar","57671680","/Programmy/Programmy_dlja_PK/Audio/Video_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("254","0","Графика/Дизайн ","exe;zip;rar","57671680","/Programmy/Programmy_dlja_PK/Grafika/Dizajn_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("255","0","Безопасность ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Bezopasnost_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("256","0","Игры и развлечения ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Igry_i_razvlechenija_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("257","0","Интернет/Почта ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Internet/Pochta_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("258","0","Карты и схемы ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Karty_i_shemy_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("259","0","Мессенджеры ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Messendzhery_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("260","0","Мобильная связь ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Mobilnaja_svjaz_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("261","0","Образование ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Obrazovanie_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("262","0","Офис ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Ofis_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("263","0","Словари/Инфо ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Slovari/Info_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("264","0","Система ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Sistema_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("265","0","Оформление, темы ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Oformlenie__temy_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("268","0"," Series 40v3 - 240x320 ","jar","10485760","/Igry/Java_igry_/Nokia/_Series_40v3_-_240x320_/","/Igry/Java_igry_/Nokia/","1","0");
INSERT INTO obmennik_dir VALUES("267","0","Разные ","exe;zip;rar","52428800","/Programmy/Programmy_dlja_PK/Raznye_/","/Programmy/Programmy_dlja_PK/","1","0");
INSERT INTO obmennik_dir VALUES("269","0","Разные","","0","/Igry/Java_igry_/flay/Raznye/","/Igry/Java_igry_/flay/","0","0");
INSERT INTO obmennik_dir VALUES("270","0","азартные","","0","/Igry/Java_igry_/Motorola/azartnye/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("271","0","Аркады","","0","/Igry/Java_igry_/Motorola/Arkady/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("272","0","Спортивные","","0","/Igry/Java_igry_/Motorola/Sportivnye/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("273","0","драки","","0","/Igry/Java_igry_/Motorola/draki/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("274","0","Стрелялки","","0","/Igry/Java_igry_/Motorola/Streljalki/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("275","0","семуляторы","","0","/Igry/Java_igry_/Motorola/semuljatory/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("276","0","Разные","","0","/Igry/Java_igry_/Motorola/Raznye/","/Igry/Java_igry_/Motorola/","0","0");
INSERT INTO obmennik_dir VALUES("277","0","Темы для simensa  ","","0","/Temy/Temy_dlja_simensa__/","/Temy/","0","0");
INSERT INTO obmennik_dir VALUES("278","0","из фильмов","gif;png;jpeg;jpg","5242880","/Kartinki/iz_filmov/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("279","0","Ужасы","gif;png;jpeg;jpg;","5242880","/Animacii/Uzhasy/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("280","0","Фантастика","gif;png;jpeg;jpg;","5242880","/Animacii/Fantastika/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("281","0","Юмор/Приколы","gif;png;jpeg;jpg","5242880","/Kartinki/Jymor/Prikoly/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("283","0","руские","mp4;3gp;","20971520","/Video/Klipy/ruskie/","/Video/Klipy/","1","0");
INSERT INTO obmennik_dir VALUES("284","0","зарубежные","mp4;3gp;","20971520","/Video/Klipy/zarubezhnye/","/Video/Klipy/","1","0");
INSERT INTO obmennik_dir VALUES("285","0","шансон","mp4;3gp;","20971520","/Video/Klipy/shanson/","/Video/Klipy/","1","0");
INSERT INTO obmennik_dir VALUES("286","0","разные","mp4;3gp;","20971520","/Video/Klipy/raznye/","/Video/Klipy/","1","0");
INSERT INTO obmennik_dir VALUES("287","0","80-90 года","mp4;3gp;","20971520","/Video/Klipy/80-90_goda/","/Video/Klipy/","1","0");
INSERT INTO obmennik_dir VALUES("288","0","рослыны","","0","/Video/roslyny/","/Video/","0","0");
INSERT INTO obmennik_dir VALUES("291","0","абстракцыя","","0","/Temy/Temy_dlja_Nokia/abstrakcyja/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("292","0","Девушки","","0","/Temy/Temy_dlja_Nokia/Devushki/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("293","0","Парни","","0","/Temy/Temy_dlja_Nokia/Parni/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("294","0","ужасы","","0","/Temy/Temy_dlja_Nokia/uzhasy/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("295","0","разное","","0","/Temy/Temy_dlja_Nokia/raznoe/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("296","0","машыны","","0","/Temy/Temy_dlja_Nokia/mashyny/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("297","0","Тварыны/Цветы","","0","/Temy/Temy_dlja_Nokia/Tvaryny/Cvety/","/Temy/Temy_dlja_Nokia/","0","0");
INSERT INTO obmennik_dir VALUES("298","0","абстракция","","0","/Temy/Temy_dlja_Samsung/abstrakcija/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("299","0","Авто","","0","/Temy/Temy_dlja_Samsung/Avto/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("300","0","тварыны/Цветы","","0","/Temy/Temy_dlja_Samsung/tvaryny/Cvety/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("301","0","разное","","0","/Temy/Temy_dlja_Samsung/raznoe/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("302","0","Парни","","0","/Temy/Temy_dlja_Samsung/Parni/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("303","0","девушки","","0","/Temy/Temy_dlja_Samsung/devushki/","/Temy/Temy_dlja_Samsung/","0","0");
INSERT INTO obmennik_dir VALUES("304","0","абстракция","","0","/Temy/Temy_dlja_simensa__/abstrakcija/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("305","0","авто","","0","/Temy/Temy_dlja_simensa__/avto/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("306","0","Парни","","0","/Temy/Temy_dlja_simensa__/Parni/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("307","0","девушки","","0","/Temy/Temy_dlja_simensa__/devushki/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("308","0","разное","","0","/Temy/Temy_dlja_simensa__/raznoe/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("309","0","тварыны/цветы","","0","/Temy/Temy_dlja_simensa__/tvaryny/cvety/","/Temy/Temy_dlja_simensa__/","0","0");
INSERT INTO obmennik_dir VALUES("310","0","абстракция","","0","/Temy/Temy_dlja_Sony_Ericsson_/abstrakcija/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("311","0","разное","","0","/Temy/Temy_dlja_Sony_Ericsson_/raznoe/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("312","0","парни","","0","/Temy/Temy_dlja_Sony_Ericsson_/parni/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("313","0","девушки","","0","/Temy/Temy_dlja_Sony_Ericsson_/devushki/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("314","0","авто","","0","/Temy/Temy_dlja_Sony_Ericsson_/avto/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("315","0","тварыны/цветы","","0","/Temy/Temy_dlja_Sony_Ericsson_/tvaryny/cvety/","/Temy/Temy_dlja_Sony_Ericsson_/","0","0");
INSERT INTO obmennik_dir VALUES("316","0","разное","","0","/Knigi/raznoe/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("317","0","ужасы","","0","/Knigi/uzhasy/","/Knigi/","0","0");
INSERT INTO obmennik_dir VALUES("323","0","Зирки кинофильмов","mp4;3gp;","10485760","/Video/Znamenitosti/Zirki_kinofilmov/","/Video/Znamenitosti/","1","0");
INSERT INTO obmennik_dir VALUES("324","0","Зирки истрады","","0","/Video/Znamenitosti/Zirki_istrady/","/Video/Znamenitosti/","0","0");
INSERT INTO obmennik_dir VALUES("325","0","Другие","mp4;3gp;","10485760","/Video/Znamenitosti/Drugie/","/Video/Znamenitosti/","1","0");
INSERT INTO obmennik_dir VALUES("329","0","Праздники","","0","/Kartinki/Prazdniki/","/Kartinki/","0","0");
INSERT INTO obmennik_dir VALUES("338","0","День рождения","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/Den_rozhdenija/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("331","0","Новый год","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/Novyj_god/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("332","0","8 марта","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/8_marta/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("333","0","Прочие","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/Prochie/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("334","0","23 февраля","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/23_fevralja/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("335","0","Пасха","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/Pasha/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("336","0","9 мая","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/9_maja/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("337","0","14 февраля-День св. Валентина ","gif;png;jpeg;jpg","5242880","/Kartinki/Prazdniki/14_fevralja-Den_sv._Valentina_/","/Kartinki/Prazdniki/","1","0");
INSERT INTO obmennik_dir VALUES("339","0","Кошки","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Koshki/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("340","0","Собаки","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Sobaki/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("342","0","Хищники","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Hischniki/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("343","0","Волки","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Volki/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("344","0","Птицы","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Pticy/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("345","0","Лошади","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Loshadi/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("346","0","Разные","gif;png;jpeg;jpg","5242880","/Kartinki/ZHivotnye/Raznye/","/Kartinki/ZHivotnye/","1","0");
INSERT INTO obmennik_dir VALUES("348","0","Готика","gif;png;jpeg;jpg","5242880","/Kartinki/Subkultura/Gotika/","/Kartinki/Subkultura/","1","0");
INSERT INTO obmennik_dir VALUES("349","0","Эмо","gif;png;jpeg;jpg","5242880","/Kartinki/Subkultura/Jemo/","/Kartinki/Subkultura/","1","0");
INSERT INTO obmennik_dir VALUES("350","0","Рэп","gif;png;jpeg;jpg","5242880","/Kartinki/Subkultura/Rjep/","/Kartinki/Subkultura/","1","0");
INSERT INTO obmennik_dir VALUES("351","0","Демотиваторы","gif;png;jpeg;jpg","5242880","/Kartinki/Demotivatory/","/Kartinki/","1","0");
INSERT INTO obmennik_dir VALUES("352","0","Армейские","mp3","52428800","/Muzyka/Armejskie/","/Muzyka/","1","0");
INSERT INTO obmennik_dir VALUES("353","0","На смс","mp3;flac;amr;ape;ogg;waw;ac3;wma;m4a;aac;","5242880","/Audio/Na_sms/","/Audio/","1","0");
INSERT INTO obmennik_dir VALUES("354","0","Любовь","gif;png;jpeg;jpg;","5242880","/Animacii/Ljybov/","/Animacii/","1","0");
INSERT INTO obmennik_dir VALUES("356","0","Разное","","0","/Muzyka/POP/Raznoe/","/Muzyka/POP/","0","0");
INSERT INTO obmennik_dir VALUES("359","0","Личные файлы","jpeg;jpg;gif;png;bmp;rar;zip;pda;txt;exe;3gp;mp4;mp3;jar;apk;avi;ico;sis;sisx;psd;7zip;mp3;wav;midi;mmf;aac;amr;","73400320","/Lichnye_fajly/","/","1","1");



DROP TABLE IF EXISTS `obmennik_files`;

CREATE TABLE `obmennik_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_dir` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `ras` varchar(36) NOT NULL,
  `type` varchar(64) NOT NULL,
  `time` int(11) NOT NULL,
  `time_last` int(11) NOT NULL,
  `size` int(11) NOT NULL,
  `k_loads` int(11) DEFAULT '0',
  `time_go` int(11) DEFAULT '0',
  `opis` text NOT NULL,
  `my_dir` int(11) DEFAULT '0',
  `metka` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

INSERT INTO obmennik_files VALUES("4","1","112","pooh_birth_day","gif","image/gif","1567387742","1567387742","78977","1874","0","","2","0");
INSERT INTO obmennik_files VALUES("5","1","112","girl_cray2","gif","image/gif","1567387848","1567387848","343842","2044","0","","2","0");
INSERT INTO obmennik_files VALUES("6","1","112","20336","gif","image/gif","1567387905","1567387905","18717","2328","0","","2","0");
INSERT INTO obmennik_files VALUES("7","5","62","Lx24 - Сумашедшая моя, моя","mp3","audio/mp3","1567442164","1567442164","8428132","0","0","","3","0");
INSERT INTO obmennik_files VALUES("8","2","325","!SERYOGA___Tvoi_lyubim","mp4","video/mp4","1567456101","1567456101","9159685","0","0","","7","0");
INSERT INTO obmennik_files VALUES("9","5","68","IOWA - Ищу мужа - YouTube_0_1456264283698","mp4","video/mp4","1567456416","1567456416","12202201","2","0","","3","0");
INSERT INTO obmennik_files VALUES("17","1","68","VID-20190818-WA0025","mp4","video/mp4","1568657820","1568657820","3363711","5","0","Любовь ","2","0");
INSERT INTO obmennik_files VALUES("16","1","25","21732","gif","image/gif","1568278451","1568278451","16170","4914","0","","2","0");
INSERT INTO obmennik_files VALUES("18","1","62","027_Instasamka_-_Ariflame_[muzmo_ru]","mp3","audio/mp3","1584268570","1584268570","5572903","8","0","","2","0");
INSERT INTO obmennik_files VALUES("19","1","62","003_NYU_-_Vesnushki_[muzmo_ru]","mp3","audio/mpeg","1590345328","1590345328","7824658","5","0","","2","0");
INSERT INTO obmennik_files VALUES("20","1","62","aleksandr_ajvazov_feat_dj_allegka_-_a_po_tyomnim_ulicam_guljaet_dozhd_(zv.fm)","mp3","audio/mp3","1593211187","1593211187","10155680","13","0","","2","0");
INSERT INTO obmennik_files VALUES("21","1","62","babek_mamedrzaev_-_beregi_eyo__bozhe_(zf.fm)","mp3","audio/mp3","1593212814","1593212814","10337083","10","0","","2","0");
INSERT INTO obmennik_files VALUES("22","1","62","gudzon_-_edem_na_mashine_(zf.fm)","mp3","audio/mp3","1593213050","1593213050","6588424","4","0","","2","0");
INSERT INTO obmennik_files VALUES("23","1","62","bez_obmezhen_-_zori_zapalali_(zf.fm)","mp3","audio/mp3","1593715404","1593715404","4497059","0","0","","2","0");
INSERT INTO obmennik_files VALUES("24","1","62","shanson_o_ljubvi_-_artur_rudenko_-_zabit_nelzja_(zf.fm)","mp3","audio/mp3","1593793392","1593793392","2043904","0","0","","2","0");
INSERT INTO obmennik_files VALUES("26","1","62","svetlana_loboda_-_ne_nuzhna_(zvukoff.ru)","mp3","audio/mp3","1593804646","1593804646","8576514","2","0","","2","0");
INSERT INTO obmennik_files VALUES("27","1","62","ka4karu_-_ego_-_ne_plach_(zf.fm)","mp3","audio/mpeg","1594413398","1594413398","10295840","0","0","","2","0");
INSERT INTO obmennik_files VALUES("28","557","359","foto_8227","jpg","image/jpeg","1595575653","1595575653","166241","706","0","","12","0");
INSERT INTO obmennik_files VALUES("29","550","68","VID-20200718-WA0037","mp4","video/mp4","1595590071","1595590071","2526736","0","0","","14","0");
INSERT INTO obmennik_files VALUES("30","550","65","VID-20200723-WA0026","mp4","video/mp4","1595650319","1595650319","1879426","1","0","","14","0");
INSERT INTO obmennik_files VALUES("31","541","359","HOMIE_-_Odinokij_Pjos","mp3","audio/mp3","1596773603","1596773603","9212599","0","0","","102","0");
INSERT INTO obmennik_files VALUES("32","594","359","little_devil-spaces.im","gif","image/gif","1597481428","1597481428","33070","622","0","","156","0");
INSERT INTO obmennik_files VALUES("33","289","359","image","jpg","image/jpeg","1597525624","1597525624","74410","681","0","","171","0");



DROP TABLE IF EXISTS `obmennik_komm`;

CREATE TABLE `obmennik_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_file` (`id_file`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `opsos`;

CREATE TABLE `opsos` (
  `min` bigint(11) DEFAULT NULL,
  `max` bigint(11) DEFAULT NULL,
  `opsos` varchar(64) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  KEY `min` (`min`,`max`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `optim`;

CREATE TABLE `optim` (
  `klu4` tinyint(1) NOT NULL,
  `go` int(11) NOT NULL,
  `anekdot` int(11) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `photo_new`;

CREATE TABLE `photo_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_object` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5992 DEFAULT CHARSET=utf8;

INSERT INTO photo_new VALUES("5447","1","foto","1581698588");
INSERT INTO photo_new VALUES("5448","285","foto","1593208369");
INSERT INTO photo_new VALUES("5449","3","foto","1581719653");
INSERT INTO photo_new VALUES("5450","4","foto","1581721208");
INSERT INTO photo_new VALUES("5451","5","foto","1581727715");
INSERT INTO photo_new VALUES("5452","6","foto","1581769107");
INSERT INTO photo_new VALUES("5453","7","foto","1581769118");
INSERT INTO photo_new VALUES("5454","8","foto","1581769125");
INSERT INTO photo_new VALUES("5455","9","foto","1581876550");
INSERT INTO photo_new VALUES("5456","10","foto","1582277369");
INSERT INTO photo_new VALUES("5457","429","foto","1595071755");
INSERT INTO photo_new VALUES("5458","426","foto","1595055801");
INSERT INTO photo_new VALUES("5459","432","foto","1595073907");
INSERT INTO photo_new VALUES("5460","14","foto","1584339944");
INSERT INTO photo_new VALUES("5461","17","foto","1584629477");
INSERT INTO photo_new VALUES("5462","18","foto","1584727286");
INSERT INTO photo_new VALUES("5463","21","foto","1585308664");
INSERT INTO photo_new VALUES("5464","22","foto","1585335184");
INSERT INTO photo_new VALUES("5465","23","foto","1585695927");
INSERT INTO photo_new VALUES("5466","25","foto","1586109572");
INSERT INTO photo_new VALUES("5467","26","foto","1586117954");
INSERT INTO photo_new VALUES("5468","27","foto","1586146482");
INSERT INTO photo_new VALUES("5469","28","foto","1586161205");
INSERT INTO photo_new VALUES("5470","29","foto","1586339962");
INSERT INTO photo_new VALUES("5471","67","foto","1591023062");
INSERT INTO photo_new VALUES("5472","33","foto","1587401385");
INSERT INTO photo_new VALUES("5473","35","foto","1588585251");
INSERT INTO photo_new VALUES("5474","36","foto","1589567190");
INSERT INTO photo_new VALUES("5475","38","foto","1589727800");
INSERT INTO photo_new VALUES("5476","39","foto","1590087800");
INSERT INTO photo_new VALUES("5477","40","foto","1590164748");
INSERT INTO photo_new VALUES("5478","41","foto","1590558735");
INSERT INTO photo_new VALUES("5479","278","foto","1593197569");
INSERT INTO photo_new VALUES("5480","50","foto","1590838148");
INSERT INTO photo_new VALUES("5481","44","foto","1590606230");
INSERT INTO photo_new VALUES("5482","48","foto","1590679618");
INSERT INTO photo_new VALUES("5483","49","foto","1590776202");
INSERT INTO photo_new VALUES("5484","52","foto","1590917256");
INSERT INTO photo_new VALUES("5485","54","foto","1590923519");
INSERT INTO photo_new VALUES("5486","55","foto","1590927698");
INSERT INTO photo_new VALUES("5487","56","foto","1590943377");
INSERT INTO photo_new VALUES("5488","346","foto","1593763863");
INSERT INTO photo_new VALUES("5489","58","foto","1590947946");
INSERT INTO photo_new VALUES("5490","58","foto","1590947946");
INSERT INTO photo_new VALUES("5491","62","foto","1590965320");
INSERT INTO photo_new VALUES("5492","63","foto","1590965446");
INSERT INTO photo_new VALUES("5493","64","foto","1590977247");
INSERT INTO photo_new VALUES("5494","65","foto","1590988604");
INSERT INTO photo_new VALUES("5495","66","foto","1591007282");
INSERT INTO photo_new VALUES("5496","69","foto","1591034388");
INSERT INTO photo_new VALUES("5497","70","foto","1591042139");
INSERT INTO photo_new VALUES("5498","83","foto","1591145212");
INSERT INTO photo_new VALUES("5499","74","foto","1591102826");
INSERT INTO photo_new VALUES("5500","75","foto","1591107787");
INSERT INTO photo_new VALUES("5501","76","foto","1591107804");
INSERT INTO photo_new VALUES("5502","77","foto","1591107823");
INSERT INTO photo_new VALUES("5503","84","foto","1591150429");
INSERT INTO photo_new VALUES("5504","272","foto","1593110638");
INSERT INTO photo_new VALUES("5505","81","foto","1591124937");
INSERT INTO photo_new VALUES("5506","82","foto","1591129886");
INSERT INTO photo_new VALUES("5507","85","foto","1591167796");
INSERT INTO photo_new VALUES("5508","86","foto","1591167918");
INSERT INTO photo_new VALUES("5509","87","foto","1591168657");
INSERT INTO photo_new VALUES("5510","99","foto","1591276216");
INSERT INTO photo_new VALUES("5511","89","foto","1591178632");
INSERT INTO photo_new VALUES("5512","90","foto","1591180604");
INSERT INTO photo_new VALUES("5513","437","foto","1595129403");
INSERT INTO photo_new VALUES("5514","105","foto","1591292885");
INSERT INTO photo_new VALUES("5515","151","foto","1591961992");
INSERT INTO photo_new VALUES("5516","95","foto","1591212206");
INSERT INTO photo_new VALUES("5517","96","foto","1591213714");
INSERT INTO photo_new VALUES("5518","97","foto","1591256423");
INSERT INTO photo_new VALUES("5519","100","foto","1591280631");
INSERT INTO photo_new VALUES("5520","101","foto","1591286638");
INSERT INTO photo_new VALUES("5521","102","foto","1591286639");
INSERT INTO photo_new VALUES("5522","103","foto","1591286641");
INSERT INTO photo_new VALUES("5523","104","foto","1591287733");
INSERT INTO photo_new VALUES("5524","106","foto","1591301025");
INSERT INTO photo_new VALUES("5525","107","foto","1591305167");
INSERT INTO photo_new VALUES("5526","108","foto","1591348082");
INSERT INTO photo_new VALUES("5527","109","foto","1591352186");
INSERT INTO photo_new VALUES("5528","110","foto","1591436503");
INSERT INTO photo_new VALUES("5529","111","foto","1591438060");
INSERT INTO photo_new VALUES("5530","112","foto","1591446257");
INSERT INTO photo_new VALUES("5531","113","foto","1591454814");
INSERT INTO photo_new VALUES("5532","114","foto","1591540632");
INSERT INTO photo_new VALUES("5533","115","foto","1591560966");
INSERT INTO photo_new VALUES("5534","203","foto","1592450747");
INSERT INTO photo_new VALUES("5535","119","foto","1591617984");
INSERT INTO photo_new VALUES("5536","120","foto","1591618369");
INSERT INTO photo_new VALUES("5537","121","foto","1591620524");
INSERT INTO photo_new VALUES("5538","125","foto","1591627046");
INSERT INTO photo_new VALUES("5539","123","foto","1591623405");
INSERT INTO photo_new VALUES("5540","128","foto","1591639965");
INSERT INTO photo_new VALUES("5541","129","foto","1591641968");
INSERT INTO photo_new VALUES("5542","131","foto","1591737916");
INSERT INTO photo_new VALUES("5543","132","foto","1591740698");
INSERT INTO photo_new VALUES("5544","133","foto","1591773003");
INSERT INTO photo_new VALUES("5545","134","foto","1591776478");
INSERT INTO photo_new VALUES("5546","135","foto","1591776722");
INSERT INTO photo_new VALUES("5547","136","foto","1591843471");
INSERT INTO photo_new VALUES("5548","137","foto","1591843516");
INSERT INTO photo_new VALUES("5549","138","foto","1591844074");
INSERT INTO photo_new VALUES("5550","139","foto","1591853589");
INSERT INTO photo_new VALUES("5551","140","foto","1591853713");
INSERT INTO photo_new VALUES("5552","141","foto","1591853807");
INSERT INTO photo_new VALUES("5553","173","foto","1592155105");
INSERT INTO photo_new VALUES("5554","144","foto","1591876304");
INSERT INTO photo_new VALUES("5555","199","foto","1592418233");
INSERT INTO photo_new VALUES("5556","146","foto","1591947542");
INSERT INTO photo_new VALUES("5557","150","foto","1591958846");
INSERT INTO photo_new VALUES("5558","159","foto","1591996621");
INSERT INTO photo_new VALUES("5559","154","foto","1591975448");
INSERT INTO photo_new VALUES("5560","155","foto","1591978875");
INSERT INTO photo_new VALUES("5561","157","foto","1591988311");
INSERT INTO photo_new VALUES("5562","158","foto","1591993437");
INSERT INTO photo_new VALUES("5563","162","foto","1592029437");
INSERT INTO photo_new VALUES("5564","161","foto","1592018667");
INSERT INTO photo_new VALUES("5565","452","foto","1595221368");
INSERT INTO photo_new VALUES("5566","165","foto","1592058831");
INSERT INTO photo_new VALUES("5567","167","foto","1592068559");
INSERT INTO photo_new VALUES("5568","168","foto","1592104963");
INSERT INTO photo_new VALUES("5569","169","foto","1592116198");
INSERT INTO photo_new VALUES("5570","174","foto","1592182940");
INSERT INTO photo_new VALUES("5571","175","foto","1592206518");
INSERT INTO photo_new VALUES("5572","176","foto","1592214463");
INSERT INTO photo_new VALUES("5573","177","foto","1592216715");
INSERT INTO photo_new VALUES("5574","178","foto","1592220590");
INSERT INTO photo_new VALUES("5575","180","foto","1592246786");
INSERT INTO photo_new VALUES("5576","182","foto","1592266458");
INSERT INTO photo_new VALUES("5577","183","foto","1592292330");
INSERT INTO photo_new VALUES("5578","185","foto","1592310996");
INSERT INTO photo_new VALUES("5579","190","foto","1592390281");
INSERT INTO photo_new VALUES("5580","192","foto","1592394438");
INSERT INTO photo_new VALUES("5581","193","foto","1592402945");
INSERT INTO photo_new VALUES("5582","194","foto","1592412836");
INSERT INTO photo_new VALUES("5583","195","foto","1592414865");
INSERT INTO photo_new VALUES("5584","196","foto","1592414954");
INSERT INTO photo_new VALUES("5585","205","foto","1592458863");
INSERT INTO photo_new VALUES("5586","198","foto","1592417024");
INSERT INTO photo_new VALUES("5587","201","foto","1592420713");
INSERT INTO photo_new VALUES("5588","202","foto","1592421480");
INSERT INTO photo_new VALUES("5589","204","foto","1592452281");
INSERT INTO photo_new VALUES("5590","223","foto","1592652338");
INSERT INTO photo_new VALUES("5591","207","foto","1592472202");
INSERT INTO photo_new VALUES("5592","208","foto","1592476072");
INSERT INTO photo_new VALUES("5593","436","foto","1595081124");
INSERT INTO photo_new VALUES("5594","210","foto","1592494497");
INSERT INTO photo_new VALUES("5595","211","foto","1592499927");
INSERT INTO photo_new VALUES("5596","212","foto","1592500140");
INSERT INTO photo_new VALUES("5597","213","foto","1592500173");
INSERT INTO photo_new VALUES("5598","214","foto","1592500187");
INSERT INTO photo_new VALUES("5599","215","foto","1592503053");
INSERT INTO photo_new VALUES("5600","216","foto","1592516480");
INSERT INTO photo_new VALUES("5601","217","foto","1592548866");
INSERT INTO photo_new VALUES("5602","219","foto","1592581778");
INSERT INTO photo_new VALUES("5603","220","foto","1592592137");
INSERT INTO photo_new VALUES("5604","222","foto","1592608926");
INSERT INTO photo_new VALUES("5605","224","foto","1592652665");
INSERT INTO photo_new VALUES("5606","227","foto","1592660956");
INSERT INTO photo_new VALUES("5607","228","foto","1592671215");
INSERT INTO photo_new VALUES("5608","229","foto","1592676591");
INSERT INTO photo_new VALUES("5609","230","foto","1592677855");
INSERT INTO photo_new VALUES("5610","231","foto","1592691499");
INSERT INTO photo_new VALUES("5611","232","foto","1592695740");
INSERT INTO photo_new VALUES("5612","233","foto","1592715758");
INSERT INTO photo_new VALUES("5613","234","foto","1592721384");
INSERT INTO photo_new VALUES("5614","235","foto","1592722523");
INSERT INTO photo_new VALUES("5615","236","foto","1592722742");
INSERT INTO photo_new VALUES("5616","237","foto","1592728341");
INSERT INTO photo_new VALUES("5617","238","foto","1592729126");
INSERT INTO photo_new VALUES("5618","239","foto","1592733472");
INSERT INTO photo_new VALUES("5619","265","foto","1593018419");
INSERT INTO photo_new VALUES("5620","244","foto","1592763572");
INSERT INTO photo_new VALUES("5621","245","foto","1592771516");
INSERT INTO photo_new VALUES("5622","279","foto","1593198141");
INSERT INTO photo_new VALUES("5623","248","foto","1592814919");
INSERT INTO photo_new VALUES("5624","249","foto","1592848642");
INSERT INTO photo_new VALUES("5625","251","foto","1592882020");
INSERT INTO photo_new VALUES("5626","252","foto","1592883230");
INSERT INTO photo_new VALUES("5627","253","foto","1592885505");
INSERT INTO photo_new VALUES("5628","254","foto","1592898101");
INSERT INTO photo_new VALUES("5629","255","foto","1592904143");
INSERT INTO photo_new VALUES("5630","256","foto","1592904164");
INSERT INTO photo_new VALUES("5631","257","foto","1592912472");
INSERT INTO photo_new VALUES("5632","258","foto","1592931982");
INSERT INTO photo_new VALUES("5633","259","foto","1592954501");
INSERT INTO photo_new VALUES("5634","260","foto","1592966945");
INSERT INTO photo_new VALUES("5635","261","foto","1592982688");
INSERT INTO photo_new VALUES("5636","263","foto","1592991708");
INSERT INTO photo_new VALUES("5637","264","foto","1592992105");
INSERT INTO photo_new VALUES("5638","266","foto","1593031401");
INSERT INTO photo_new VALUES("5639","268","foto","1593063536");
INSERT INTO photo_new VALUES("5640","271","foto","1593079479");
INSERT INTO photo_new VALUES("5641","273","foto","1593160763");
INSERT INTO photo_new VALUES("5642","371","foto","1594052579");
INSERT INTO photo_new VALUES("5643","372","foto","1594064217");
INSERT INTO photo_new VALUES("5644","281","foto","1593199881");
INSERT INTO photo_new VALUES("5645","337","foto","1593706765");
INSERT INTO photo_new VALUES("5646","306","foto","1593381583");
INSERT INTO photo_new VALUES("5647","286","foto","1593213472");
INSERT INTO photo_new VALUES("5648","318","foto","1593460215");
INSERT INTO photo_new VALUES("5649","331","foto","1593621213");
INSERT INTO photo_new VALUES("5650","289","foto","1593248007");
INSERT INTO photo_new VALUES("5651","290","foto","1593255724");
INSERT INTO photo_new VALUES("5652","291","foto","1593258589");
INSERT INTO photo_new VALUES("5653","427","foto","1595057735");
INSERT INTO photo_new VALUES("5654","481","foto","1595521078");
INSERT INTO photo_new VALUES("5655","336","foto","1593664405");
INSERT INTO photo_new VALUES("5656","295","foto","1593312261");
INSERT INTO photo_new VALUES("5657","297","foto","1593328918");
INSERT INTO photo_new VALUES("5658","298","foto","1593343019");
INSERT INTO photo_new VALUES("5659","299","foto","1593350913");
INSERT INTO photo_new VALUES("5660","300","foto","1593359592");
INSERT INTO photo_new VALUES("5661","310","foto","1593423525");
INSERT INTO photo_new VALUES("5662","309","foto","1593416730");
INSERT INTO photo_new VALUES("5663","305","foto","1593375571");
INSERT INTO photo_new VALUES("5664","307","foto","1593382241");
INSERT INTO photo_new VALUES("5665","311","foto","1593428026");
INSERT INTO photo_new VALUES("5666","314","foto","1593433756");
INSERT INTO photo_new VALUES("5667","335","foto","1593664385");
INSERT INTO photo_new VALUES("5668","317","foto","1593455881");
INSERT INTO photo_new VALUES("5669","319","foto","1593494321");
INSERT INTO photo_new VALUES("5670","321","foto","1593527320");
INSERT INTO photo_new VALUES("5671","321","foto","1593527320");
INSERT INTO photo_new VALUES("5672","322","foto","1593530300");
INSERT INTO photo_new VALUES("5673","322","foto","1593530300");
INSERT INTO photo_new VALUES("5674","323","foto","1593587758");
INSERT INTO photo_new VALUES("5675","324","foto","1593590500");
INSERT INTO photo_new VALUES("5676","334","foto","1593641800");
INSERT INTO photo_new VALUES("5677","326","foto","1593592672");
INSERT INTO photo_new VALUES("5678","327","foto","1593601047");
INSERT INTO photo_new VALUES("5679","333","foto","1593632851");
INSERT INTO photo_new VALUES("5680","338","foto","1593706782");
INSERT INTO photo_new VALUES("5681","339","foto","1593706809");
INSERT INTO photo_new VALUES("5682","340","foto","1593706856");
INSERT INTO photo_new VALUES("5683","340","foto","1593706856");
INSERT INTO photo_new VALUES("5684","341","foto","1593706900");
INSERT INTO photo_new VALUES("5685","342","foto","1593715526");
INSERT INTO photo_new VALUES("5686","343","foto","1593719284");
INSERT INTO photo_new VALUES("5687","347","foto","1593765358");
INSERT INTO photo_new VALUES("5688","348","foto","1593770786");
INSERT INTO photo_new VALUES("5689","349","foto","1593775752");
INSERT INTO photo_new VALUES("5690","350","foto","1593778831");
INSERT INTO photo_new VALUES("5691","351","foto","1593787739");
INSERT INTO photo_new VALUES("5692","438","foto","1595142321");
INSERT INTO photo_new VALUES("5693","354","foto","1593841053");
INSERT INTO photo_new VALUES("5694","355","foto","1593856458");
INSERT INTO photo_new VALUES("5695","356","foto","1593857660");
INSERT INTO photo_new VALUES("5696","358","foto","1593935588");
INSERT INTO photo_new VALUES("5697","359","foto","1593940104");
INSERT INTO photo_new VALUES("5698","362","foto","1593953980");
INSERT INTO photo_new VALUES("5699","363","foto","1593955011");
INSERT INTO photo_new VALUES("5700","370","foto","1594042057");
INSERT INTO photo_new VALUES("5701","365","foto","1593966533");
INSERT INTO photo_new VALUES("5702","366","foto","1593970295");
INSERT INTO photo_new VALUES("5703","367","foto","1593970962");
INSERT INTO photo_new VALUES("5704","373","foto","1594065895");
INSERT INTO photo_new VALUES("5705","374","foto","1594204404");
INSERT INTO photo_new VALUES("5706","375","foto","1594205915");
INSERT INTO photo_new VALUES("5707","376","foto","1594230278");
INSERT INTO photo_new VALUES("5708","377","foto","1594230609");
INSERT INTO photo_new VALUES("5709","378","foto","1594230655");
INSERT INTO photo_new VALUES("5710","379","foto","1594230701");
INSERT INTO photo_new VALUES("5711","380","foto","1594234031");
INSERT INTO photo_new VALUES("5712","381","foto","1594237065");
INSERT INTO photo_new VALUES("5713","382","foto","1594262664");
INSERT INTO photo_new VALUES("5714","383","foto","1594412914");
INSERT INTO photo_new VALUES("5715","384","foto","1594446457");
INSERT INTO photo_new VALUES("5716","385","foto","1594580804");
INSERT INTO photo_new VALUES("5717","386","foto","1594588574");
INSERT INTO photo_new VALUES("5718","387","foto","1594589483");
INSERT INTO photo_new VALUES("5719","388","foto","1594590016");
INSERT INTO photo_new VALUES("5720","390","foto","1594666305");
INSERT INTO photo_new VALUES("5721","391","foto","1594666325");
INSERT INTO photo_new VALUES("5722","392","foto","1594794388");
INSERT INTO photo_new VALUES("5723","393","foto","1594797936");
INSERT INTO photo_new VALUES("5724","394","foto","1594826076");
INSERT INTO photo_new VALUES("5725","395","foto","1594854499");
INSERT INTO photo_new VALUES("5726","396","foto","1594854565");
INSERT INTO photo_new VALUES("5727","397","foto","1594854694");
INSERT INTO photo_new VALUES("5728","398","foto","1594854755");
INSERT INTO photo_new VALUES("5729","399","foto","1594854837");
INSERT INTO photo_new VALUES("5730","400","foto","1594854928");
INSERT INTO photo_new VALUES("5731","401","foto","1594855114");
INSERT INTO photo_new VALUES("5732","402","foto","1594855197");
INSERT INTO photo_new VALUES("5733","403","foto","1594855375");
INSERT INTO photo_new VALUES("5734","404","foto","1594855423");
INSERT INTO photo_new VALUES("5735","405","foto","1594855979");
INSERT INTO photo_new VALUES("5736","406","foto","1594856575");
INSERT INTO photo_new VALUES("5737","407","foto","1594856642");
INSERT INTO photo_new VALUES("5738","408","foto","1594856705");
INSERT INTO photo_new VALUES("5739","409","foto","1594856767");
INSERT INTO photo_new VALUES("5740","410","foto","1594856902");
INSERT INTO photo_new VALUES("5741","411","foto","1594857019");
INSERT INTO photo_new VALUES("5742","412","foto","1594857067");
INSERT INTO photo_new VALUES("5743","413","foto","1594857364");
INSERT INTO photo_new VALUES("5744","413","foto","1594857364");
INSERT INTO photo_new VALUES("5745","414","foto","1594857729");
INSERT INTO photo_new VALUES("5746","415","foto","1594857810");
INSERT INTO photo_new VALUES("5747","415","foto","1594857810");
INSERT INTO photo_new VALUES("5748","416","foto","1594857947");
INSERT INTO photo_new VALUES("5749","417","foto","1594858042");
INSERT INTO photo_new VALUES("5750","417","foto","1594858042");
INSERT INTO photo_new VALUES("5751","418","foto","1594858109");
INSERT INTO photo_new VALUES("5752","420","foto","1594920402");
INSERT INTO photo_new VALUES("5753","420","foto","1594920402");
INSERT INTO photo_new VALUES("5754","419","foto","1594897741");
INSERT INTO photo_new VALUES("5755","421","foto","1594922176");
INSERT INTO photo_new VALUES("5756","421","foto","1594922176");
INSERT INTO photo_new VALUES("5757","422","foto","1595020276");
INSERT INTO photo_new VALUES("5758","423","foto","1595033172");
INSERT INTO photo_new VALUES("5759","423","foto","1595033172");
INSERT INTO photo_new VALUES("5760","424","foto","1595043046");
INSERT INTO photo_new VALUES("5761","425","foto","1595055499");
INSERT INTO photo_new VALUES("5762","425","foto","1595055499");
INSERT INTO photo_new VALUES("5763","428","foto","1595059604");
INSERT INTO photo_new VALUES("5764","430","foto","1595072130");
INSERT INTO photo_new VALUES("5765","430","foto","1595072130");
INSERT INTO photo_new VALUES("5766","431","foto","1595072881");
INSERT INTO photo_new VALUES("5767","433","foto","1595075716");
INSERT INTO photo_new VALUES("5768","433","foto","1595075716");
INSERT INTO photo_new VALUES("5769","435","foto","1595079811");
INSERT INTO photo_new VALUES("5770","440","foto","1595144231");
INSERT INTO photo_new VALUES("5771","440","foto","1595144231");
INSERT INTO photo_new VALUES("5772","441","foto","1595172640");
INSERT INTO photo_new VALUES("5773","442","foto","1595211482");
INSERT INTO photo_new VALUES("5774","442","foto","1595211482");
INSERT INTO photo_new VALUES("5775","443","foto","1595217551");
INSERT INTO photo_new VALUES("5776","444","foto","1595219565");
INSERT INTO photo_new VALUES("5777","444","foto","1595219565");
INSERT INTO photo_new VALUES("5778","446","foto","1595219715");
INSERT INTO photo_new VALUES("5779","447","foto","1595219816");
INSERT INTO photo_new VALUES("5780","447","foto","1595219816");
INSERT INTO photo_new VALUES("5781","448","foto","1595219893");
INSERT INTO photo_new VALUES("5782","449","foto","1595220322");
INSERT INTO photo_new VALUES("5783","449","foto","1595220322");
INSERT INTO photo_new VALUES("5784","450","foto","1595220511");
INSERT INTO photo_new VALUES("5785","451","foto","1595220645");
INSERT INTO photo_new VALUES("5786","451","foto","1595220645");
INSERT INTO photo_new VALUES("5787","453","foto","1595221543");
INSERT INTO photo_new VALUES("5788","454","foto","1595222500");
INSERT INTO photo_new VALUES("5789","454","foto","1595222500");
INSERT INTO photo_new VALUES("5790","455","foto","1595222834");
INSERT INTO photo_new VALUES("5791","456","foto","1595223112");
INSERT INTO photo_new VALUES("5792","456","foto","1595223112");
INSERT INTO photo_new VALUES("5793","457","foto","1595223196");
INSERT INTO photo_new VALUES("5794","458","foto","1595224893");
INSERT INTO photo_new VALUES("5795","458","foto","1595224893");
INSERT INTO photo_new VALUES("5796","459","foto","1595228402");
INSERT INTO photo_new VALUES("5797","460","foto","1595228479");
INSERT INTO photo_new VALUES("5798","460","foto","1595228479");
INSERT INTO photo_new VALUES("5799","461","foto","1595228851");
INSERT INTO photo_new VALUES("5800","462","foto","1595249428");
INSERT INTO photo_new VALUES("5801","462","foto","1595249428");
INSERT INTO photo_new VALUES("5802","463","foto","1595252436");
INSERT INTO photo_new VALUES("5803","464","foto","1595264423");
INSERT INTO photo_new VALUES("5804","464","foto","1595264423");
INSERT INTO photo_new VALUES("5805","465","foto","1595264650");
INSERT INTO photo_new VALUES("5806","466","foto","1595265554");
INSERT INTO photo_new VALUES("5807","466","foto","1595265554");
INSERT INTO photo_new VALUES("5808","467","foto","1595294947");
INSERT INTO photo_new VALUES("5809","468","foto","1595295295");
INSERT INTO photo_new VALUES("5810","468","foto","1595295295");
INSERT INTO photo_new VALUES("5811","469","foto","1595295788");
INSERT INTO photo_new VALUES("5812","470","foto","1595317339");
INSERT INTO photo_new VALUES("5813","470","foto","1595317339");
INSERT INTO photo_new VALUES("5814","470","foto","1595317339");
INSERT INTO photo_new VALUES("5815","471","foto","1595317400");
INSERT INTO photo_new VALUES("5816","472","foto","1595317467");
INSERT INTO photo_new VALUES("5817","472","foto","1595317467");
INSERT INTO photo_new VALUES("5818","473","foto","1595317546");
INSERT INTO photo_new VALUES("5819","474","foto","1595330729");
INSERT INTO photo_new VALUES("5820","474","foto","1595330729");
INSERT INTO photo_new VALUES("5821","475","foto","1595343304");
INSERT INTO photo_new VALUES("5822","476","foto","1595470537");
INSERT INTO photo_new VALUES("5823","476","foto","1595470537");
INSERT INTO photo_new VALUES("5824","477","foto","1595475392");
INSERT INTO photo_new VALUES("5825","478","foto","1595476590");
INSERT INTO photo_new VALUES("5826","479","foto","1595488897");
INSERT INTO photo_new VALUES("5827","479","foto","1595488897");
INSERT INTO photo_new VALUES("5828","480","foto","1595489644");
INSERT INTO photo_new VALUES("5829","482","foto","1595527224");
INSERT INTO photo_new VALUES("5830","482","foto","1595527224");
INSERT INTO photo_new VALUES("5831","483","foto","1595527414");
INSERT INTO photo_new VALUES("5832","484","foto","1595529727");
INSERT INTO photo_new VALUES("5833","484","foto","1595529727");
INSERT INTO photo_new VALUES("5834","485","foto","1595529879");
INSERT INTO photo_new VALUES("5835","485","foto","1595529879");
INSERT INTO photo_new VALUES("5836","485","foto","1595529879");
INSERT INTO photo_new VALUES("5837","486","foto","1595529998");
INSERT INTO photo_new VALUES("5838","487","foto","1595530235");
INSERT INTO photo_new VALUES("5839","487","foto","1595530235");
INSERT INTO photo_new VALUES("5840","488","foto","1595530331");
INSERT INTO photo_new VALUES("5841","489","foto","1595530542");
INSERT INTO photo_new VALUES("5842","489","foto","1595530542");
INSERT INTO photo_new VALUES("5843","490","foto","1595533724");
INSERT INTO photo_new VALUES("5844","491","foto","1595533757");
INSERT INTO photo_new VALUES("5845","492","foto","1595535061");
INSERT INTO photo_new VALUES("5846","493","foto","1595561701");
INSERT INTO photo_new VALUES("5847","495","foto","1595647884");
INSERT INTO photo_new VALUES("5848","495","foto","1595647884");
INSERT INTO photo_new VALUES("5849","496","foto","1595648028");
INSERT INTO photo_new VALUES("5850","497","foto","1595648150");
INSERT INTO photo_new VALUES("5851","497","foto","1595648150");
INSERT INTO photo_new VALUES("5852","498","foto","1595648298");
INSERT INTO photo_new VALUES("5853","499","foto","1595648524");
INSERT INTO photo_new VALUES("5854","499","foto","1595648524");
INSERT INTO photo_new VALUES("5855","500","foto","1595649043");
INSERT INTO photo_new VALUES("5856","501","foto","1595649151");
INSERT INTO photo_new VALUES("5857","501","foto","1595649151");
INSERT INTO photo_new VALUES("5858","502","foto","1595649219");
INSERT INTO photo_new VALUES("5859","503","foto","1595649828");
INSERT INTO photo_new VALUES("5860","503","foto","1595649828");
INSERT INTO photo_new VALUES("5861","504","foto","1595649875");
INSERT INTO photo_new VALUES("5862","505","foto","1595649944");
INSERT INTO photo_new VALUES("5863","505","foto","1595649944");
INSERT INTO photo_new VALUES("5864","506","foto","1595650102");
INSERT INTO photo_new VALUES("5865","507","foto","1595650539");
INSERT INTO photo_new VALUES("5866","507","foto","1595650539");
INSERT INTO photo_new VALUES("5867","508","foto","1595650845");
INSERT INTO photo_new VALUES("5868","509","foto","1595650941");
INSERT INTO photo_new VALUES("5869","509","foto","1595650941");
INSERT INTO photo_new VALUES("5870","510","foto","1595651009");
INSERT INTO photo_new VALUES("5871","511","foto","1595734741");
INSERT INTO photo_new VALUES("5872","511","foto","1595734741");
INSERT INTO photo_new VALUES("5873","512","foto","1595738490");
INSERT INTO photo_new VALUES("5874","4","file","1567387742");
INSERT INTO photo_new VALUES("5875","4","file","1567387742");
INSERT INTO photo_new VALUES("5876","5","file","1567387848");
INSERT INTO photo_new VALUES("5877","6","file","1567387905");
INSERT INTO photo_new VALUES("5878","6","file","1567387905");
INSERT INTO photo_new VALUES("5879","16","file","1568278451");
INSERT INTO photo_new VALUES("5880","28","file","1595575653");
INSERT INTO photo_new VALUES("5881","28","file","1595575653");
INSERT INTO photo_new VALUES("5882","513","foto","1595744695");
INSERT INTO photo_new VALUES("5883","514","foto","1595774117");
INSERT INTO photo_new VALUES("5884","515","foto","1595774174");
INSERT INTO photo_new VALUES("5885","516","foto","1595785146");
INSERT INTO photo_new VALUES("5886","517","foto","1595789766");
INSERT INTO photo_new VALUES("5887","518","foto","1595808764");
INSERT INTO photo_new VALUES("5888","519","foto","1595808865");
INSERT INTO photo_new VALUES("5889","520","foto","1595808989");
INSERT INTO photo_new VALUES("5890","521","foto","1595872539");
INSERT INTO photo_new VALUES("5891","522","foto","1595920047");
INSERT INTO photo_new VALUES("5892","523","foto","1595987776");
INSERT INTO photo_new VALUES("5893","524","foto","1596004967");
INSERT INTO photo_new VALUES("5894","525","foto","1596044415");
INSERT INTO photo_new VALUES("5895","526","foto","1596164228");
INSERT INTO photo_new VALUES("5896","527","foto","1596164289");
INSERT INTO photo_new VALUES("5897","528","foto","1596164337");
INSERT INTO photo_new VALUES("5898","529","foto","1596166357");
INSERT INTO photo_new VALUES("5899","530","foto","1596166643");
INSERT INTO photo_new VALUES("5900","531","foto","1596170619");
INSERT INTO photo_new VALUES("5901","532","foto","1596170715");
INSERT INTO photo_new VALUES("5902","533","foto","1596173748");
INSERT INTO photo_new VALUES("5903","534","foto","1596207915");
INSERT INTO photo_new VALUES("5904","535","foto","1596248988");
INSERT INTO photo_new VALUES("5905","536","foto","1596249049");
INSERT INTO photo_new VALUES("5906","537","foto","1596274739");
INSERT INTO photo_new VALUES("5907","538","foto","1596275079");
INSERT INTO photo_new VALUES("5908","539","foto","1596341016");
INSERT INTO photo_new VALUES("5909","540","foto","1596341155");
INSERT INTO photo_new VALUES("5910","541","foto","1596341215");
INSERT INTO photo_new VALUES("5911","544","foto","1596341412");
INSERT INTO photo_new VALUES("5912","543","foto","1596341342");
INSERT INTO photo_new VALUES("5913","545","foto","1596341493");
INSERT INTO photo_new VALUES("5914","546","foto","1596342634");
INSERT INTO photo_new VALUES("5915","547","foto","1596342791");
INSERT INTO photo_new VALUES("5916","551","foto","1596343077");
INSERT INTO photo_new VALUES("5917","549","foto","1596342929");
INSERT INTO photo_new VALUES("5918","550","foto","1596342998");
INSERT INTO photo_new VALUES("5919","552","foto","1596343159");
INSERT INTO photo_new VALUES("5920","553","foto","1596352608");
INSERT INTO photo_new VALUES("5921","554","foto","1596352726");
INSERT INTO photo_new VALUES("5922","555","foto","1596352794");
INSERT INTO photo_new VALUES("5923","556","foto","1596352857");
INSERT INTO photo_new VALUES("5924","557","foto","1596352923");
INSERT INTO photo_new VALUES("5925","558","foto","1596353067");
INSERT INTO photo_new VALUES("5926","559","foto","1596353593");
INSERT INTO photo_new VALUES("5927","560","foto","1596353647");
INSERT INTO photo_new VALUES("5928","561","foto","1596353764");
INSERT INTO photo_new VALUES("5929","562","foto","1596353833");
INSERT INTO photo_new VALUES("5930","564","foto","1596354019");
INSERT INTO photo_new VALUES("5931","565","foto","1596354084");
INSERT INTO photo_new VALUES("5932","566","foto","1596354135");
INSERT INTO photo_new VALUES("5933","567","foto","1596354189");
INSERT INTO photo_new VALUES("5934","568","foto","1596354253");
INSERT INTO photo_new VALUES("5935","569","foto","1596354386");
INSERT INTO photo_new VALUES("5936","570","foto","1596354692");
INSERT INTO photo_new VALUES("5937","571","foto","1596354726");
INSERT INTO photo_new VALUES("5938","572","foto","1596354941");
INSERT INTO photo_new VALUES("5939","573","foto","1596355037");
INSERT INTO photo_new VALUES("5940","574","foto","1596355109");
INSERT INTO photo_new VALUES("5941","575","foto","1596355195");
INSERT INTO photo_new VALUES("5942","576","foto","1596355364");
INSERT INTO photo_new VALUES("5943","577","foto","1596355600");
INSERT INTO photo_new VALUES("5944","578","foto","1596355675");
INSERT INTO photo_new VALUES("5945","579","foto","1596355906");
INSERT INTO photo_new VALUES("5946","580","foto","1596356151");
INSERT INTO photo_new VALUES("5947","581","foto","1596356203");
INSERT INTO photo_new VALUES("5948","582","foto","1596356262");
INSERT INTO photo_new VALUES("5949","585","foto","1596397312");
INSERT INTO photo_new VALUES("5950","586","foto","1596429812");
INSERT INTO photo_new VALUES("5951","587","foto","1596433847");
INSERT INTO photo_new VALUES("5952","588","foto","1596469301");
INSERT INTO photo_new VALUES("5953","589","foto","1596469513");
INSERT INTO photo_new VALUES("5954","590","foto","1596469540");
INSERT INTO photo_new VALUES("5955","591","foto","1596469559");
INSERT INTO photo_new VALUES("5956","592","foto","1596476088");
INSERT INTO photo_new VALUES("5957","593","foto","1596509988");
INSERT INTO photo_new VALUES("5958","594","foto","1596514790");
INSERT INTO photo_new VALUES("5959","595","foto","1596727293");
INSERT INTO photo_new VALUES("5960","596","foto","1596753819");
INSERT INTO photo_new VALUES("5961","597","foto","1597062782");
INSERT INTO photo_new VALUES("5962","598","foto","1597347302");
INSERT INTO photo_new VALUES("5963","599","foto","1597427776");
INSERT INTO photo_new VALUES("5964","600","foto","1597480221");
INSERT INTO photo_new VALUES("5965","601","foto","1597481168");
INSERT INTO photo_new VALUES("5966","602","foto","1597481954");
INSERT INTO photo_new VALUES("5967","32","file","1597481428");
INSERT INTO photo_new VALUES("5968","603","foto","1597497287");
INSERT INTO photo_new VALUES("5969","604","foto","1597504218");
INSERT INTO photo_new VALUES("5970","605","foto","1597512440");
INSERT INTO photo_new VALUES("5971","606","foto","1597517258");
INSERT INTO photo_new VALUES("5972","607","foto","1597518105");
INSERT INTO photo_new VALUES("5973","608","foto","1597521825");
INSERT INTO photo_new VALUES("5974","609","foto","1597522610");
INSERT INTO photo_new VALUES("5975","33","file","1597525624");
INSERT INTO photo_new VALUES("5976","610","foto","1597529993");
INSERT INTO photo_new VALUES("5977","611","foto","1597532748");
INSERT INTO photo_new VALUES("5978","612","foto","1597541926");
INSERT INTO photo_new VALUES("5979","613","foto","1597542382");
INSERT INTO photo_new VALUES("5980","614","foto","1597542420");
INSERT INTO photo_new VALUES("5981","615","foto","1597549635");
INSERT INTO photo_new VALUES("5982","616","foto","1597560756");
INSERT INTO photo_new VALUES("5983","617","foto","1597563243");
INSERT INTO photo_new VALUES("5984","618","foto","1597572958");
INSERT INTO photo_new VALUES("5985","619","foto","1597602205");
INSERT INTO photo_new VALUES("5986","620","foto","1597604708");
INSERT INTO photo_new VALUES("5987","621","foto","1597606433");
INSERT INTO photo_new VALUES("5988","622","foto","1597645601");
INSERT INTO photo_new VALUES("5989","623","foto","1597646933");
INSERT INTO photo_new VALUES("5990","624","foto","1597661505");
INSERT INTO photo_new VALUES("5991","625","foto","1597676106");



DROP TABLE IF EXISTS `pianica`;

CREATE TABLE `pianica` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_prot` int(11) NOT NULL,
  `stav` int(11) DEFAULT '0',
  `hod` int(11) DEFAULT '0',
  `karta` varchar(3) DEFAULT NULL,
  `read` int(3) DEFAULT '0',
  `over_hod` int(11) DEFAULT NULL,
  `game_over` int(1) DEFAULT NULL,
  `status` int(1) DEFAULT '0',
  `koloda` varchar(20) DEFAULT 'default',
  `chat` int(20) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `pianica_chat`;

CREATE TABLE `pianica_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `pianica_game`;

CREATE TABLE `pianica_game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `karta` varchar(11) DEFAULT '0',
  `sila` int(11) DEFAULT '0',
  `on` int(1) DEFAULT '0',
  `time` int(12) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `pianica_info`;

CREATE TABLE `pianica_info` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `bonus` int(11) DEFAULT '0',
  `loss` int(11) DEFAULT '0',
  `vins` int(11) DEFAULT '0',
  `count` int(11) DEFAULT '0',
  `rating` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=216 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `pianica_karty`;

CREATE TABLE `pianica_karty` (
  `name` varchar(4) DEFAULT NULL,
  `sila` int(3) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO pianica_karty VALUES("6k","1");
INSERT INTO pianica_karty VALUES("7k","2");
INSERT INTO pianica_karty VALUES("8k","3");
INSERT INTO pianica_karty VALUES("9k","4");
INSERT INTO pianica_karty VALUES("10k","5");
INSERT INTO pianica_karty VALUES("Vk","6");
INSERT INTO pianica_karty VALUES("Dk","7");
INSERT INTO pianica_karty VALUES("Kk","8");
INSERT INTO pianica_karty VALUES("Tk","9");
INSERT INTO pianica_karty VALUES("6c","1");
INSERT INTO pianica_karty VALUES("7c","2");
INSERT INTO pianica_karty VALUES("8c","3");
INSERT INTO pianica_karty VALUES("9c","4");
INSERT INTO pianica_karty VALUES("10c","5");
INSERT INTO pianica_karty VALUES("Vc","6");
INSERT INTO pianica_karty VALUES("Dc","7");
INSERT INTO pianica_karty VALUES("Kc","8");
INSERT INTO pianica_karty VALUES("Tc","9");
INSERT INTO pianica_karty VALUES("6p","1");
INSERT INTO pianica_karty VALUES("7p","2");
INSERT INTO pianica_karty VALUES("8p","3");
INSERT INTO pianica_karty VALUES("9p","4");
INSERT INTO pianica_karty VALUES("10p","5");
INSERT INTO pianica_karty VALUES("Vp","6");
INSERT INTO pianica_karty VALUES("Dp","7");
INSERT INTO pianica_karty VALUES("Kp","8");
INSERT INTO pianica_karty VALUES("Tp","9");
INSERT INTO pianica_karty VALUES("6b","1");
INSERT INTO pianica_karty VALUES("7b","2");
INSERT INTO pianica_karty VALUES("8b","3");
INSERT INTO pianica_karty VALUES("9b","4");
INSERT INTO pianica_karty VALUES("10b","5");
INSERT INTO pianica_karty VALUES("Vb","6");
INSERT INTO pianica_karty VALUES("Db","7");
INSERT INTO pianica_karty VALUES("Kb","8");
INSERT INTO pianica_karty VALUES("Tb","9");



DROP TABLE IF EXISTS `pocelui_dir`;

CREATE TABLE `pocelui_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=cp1251;

INSERT INTO pocelui_dir VALUES("1","Губки");
INSERT INTO pocelui_dir VALUES("2","Страстные");
INSERT INTO pocelui_dir VALUES("3","Любимым");
INSERT INTO pocelui_dir VALUES("4","Воздушные ");
INSERT INTO pocelui_dir VALUES("5","Дружеские ");



DROP TABLE IF EXISTS `pocelui_give`;

CREATE TABLE `pocelui_give` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_give` int(11) NOT NULL,
  `id_p` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coment` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=373 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `pocelui_jurnal`;

CREATE TABLE `pocelui_jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=373 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `pocelui_list`;

CREATE TABLE `pocelui_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_dir` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `prise` int(11) NOT NULL,
  `url` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=140 DEFAULT CHARSET=cp1251;

INSERT INTO pocelui_list VALUES("1","1","Губки ","100","/pocelui/img/1.gif");
INSERT INTO pocelui_list VALUES("2","1","Губки ","100","/pocelui/img/2.gif");
INSERT INTO pocelui_list VALUES("3","1","Губки ","100","/pocelui/img/3.gif");
INSERT INTO pocelui_list VALUES("4","1","Губки ","100","/pocelui/img/4.gif");
INSERT INTO pocelui_list VALUES("5","1","Губки ","100","/pocelui/img/5.gif");
INSERT INTO pocelui_list VALUES("6","1","Губки ","100","/pocelui/img/6.gif");
INSERT INTO pocelui_list VALUES("7","1","Губки ","100","/pocelui/img/7.gif");
INSERT INTO pocelui_list VALUES("8","1","Губки ","100","/pocelui/img/8.gif");
INSERT INTO pocelui_list VALUES("9","1","Губки ","100","/pocelui/img/9.gif");
INSERT INTO pocelui_list VALUES("10","1","Губки ","100","/pocelui/img/10.gif");
INSERT INTO pocelui_list VALUES("11","1","Губки ","100","/pocelui/img/11.gif");
INSERT INTO pocelui_list VALUES("12","1","Губки ","100","/pocelui/img/12.gif");
INSERT INTO pocelui_list VALUES("13","1","Губки ","100","/pocelui/img/13.gif");
INSERT INTO pocelui_list VALUES("14","2","Страсть","150","/pocelui/img/14.gif");
INSERT INTO pocelui_list VALUES("15","2","Страсть","150","/pocelui/img/15.gif");
INSERT INTO pocelui_list VALUES("16","2","Страсть","150","/pocelui/img/16.gif");
INSERT INTO pocelui_list VALUES("17","2","Страсть","150","/pocelui/img/17.gif");
INSERT INTO pocelui_list VALUES("18","2","Страсть","150","/pocelui/img/18.gif");
INSERT INTO pocelui_list VALUES("19","2","Страсть","150","/pocelui/img/19.gif");
INSERT INTO pocelui_list VALUES("20","2","Страсть","150","/pocelui/img/20.gif");
INSERT INTO pocelui_list VALUES("21","2","Страсть","150","/pocelui/img/21.gif");
INSERT INTO pocelui_list VALUES("22","2","Страсть","150","/pocelui/img/22.gif");
INSERT INTO pocelui_list VALUES("23","2","Страсть","150","/pocelui/img/23.gif");
INSERT INTO pocelui_list VALUES("24","2","Страсть","150","/pocelui/img/24.gif");
INSERT INTO pocelui_list VALUES("25","2","Страсть","150","/pocelui/img/25.gif");
INSERT INTO pocelui_list VALUES("26","2","Страсть","150","/pocelui/img/26.gif");
INSERT INTO pocelui_list VALUES("27","2","Страсть","150","/pocelui/img/27.gif");
INSERT INTO pocelui_list VALUES("28","2","Страсть","150","/pocelui/img/28.gif");
INSERT INTO pocelui_list VALUES("29","2","Страсть","150","/pocelui/img/29.gif");
INSERT INTO pocelui_list VALUES("30","2","Страсть","150","/pocelui/img/30.gif");
INSERT INTO pocelui_list VALUES("31","2","Страсть","150","/pocelui/img/31.gif");
INSERT INTO pocelui_list VALUES("32","2","Страсть","150","/pocelui/img/32.gif");
INSERT INTO pocelui_list VALUES("33","2","Страсть","150","/pocelui/img/33.gif");
INSERT INTO pocelui_list VALUES("34","2","Страсть","150","/pocelui/img/34.gif");
INSERT INTO pocelui_list VALUES("35","2","Страсть","150","/pocelui/img/35.gif");
INSERT INTO pocelui_list VALUES("36","3","Любимым","150","/pocelui/img/36.gif");
INSERT INTO pocelui_list VALUES("37","3","Любимым","150","/pocelui/img/37.gif");
INSERT INTO pocelui_list VALUES("38","3","Любимым","150","/pocelui/img/38.gif");
INSERT INTO pocelui_list VALUES("39","3","Любимым","150","/pocelui/img/39.gif");
INSERT INTO pocelui_list VALUES("40","3","Любимым","150","/pocelui/img/40.gif");
INSERT INTO pocelui_list VALUES("41","3","Любимым","150","/pocelui/img/41.gif");
INSERT INTO pocelui_list VALUES("42","3","Любимым","150","/pocelui/img/42.gif");
INSERT INTO pocelui_list VALUES("43","3","Любимым","150","/pocelui/img/43.gif");
INSERT INTO pocelui_list VALUES("44","3","Любимым","150","/pocelui/img/44.gif");
INSERT INTO pocelui_list VALUES("45","3","Любимым","150","/pocelui/img/45.gif");
INSERT INTO pocelui_list VALUES("46","3","Любимым","150","/pocelui/img/46.gif");
INSERT INTO pocelui_list VALUES("47","3","Любимым","150","/pocelui/img/47.gif");
INSERT INTO pocelui_list VALUES("48","3","Любимым","150","/pocelui/img/48.gif");
INSERT INTO pocelui_list VALUES("49","3","Любимым","150","/pocelui/img/49.gif");
INSERT INTO pocelui_list VALUES("50","3","Любимым","150","/pocelui/img/50.gif");
INSERT INTO pocelui_list VALUES("51","3","Любимым","150","/pocelui/img/51.gif");
INSERT INTO pocelui_list VALUES("52","3","Любимым","150","/pocelui/img/52.gif");
INSERT INTO pocelui_list VALUES("53","3","Любимым","150","/pocelui/img/53.gif");
INSERT INTO pocelui_list VALUES("54","3","Любимым","150","/pocelui/img/54.gif");
INSERT INTO pocelui_list VALUES("55","3","Любимым","150","/pocelui/img/55.gif");
INSERT INTO pocelui_list VALUES("56","3","Любимым","150","/pocelui/img/56.gif");
INSERT INTO pocelui_list VALUES("57","4","Воздушные ","150","/pocelui/img/57.gif");
INSERT INTO pocelui_list VALUES("58","4","Воздушные ","150","/pocelui/img/58.gif");
INSERT INTO pocelui_list VALUES("59","4","Воздушные ","150","/pocelui/img/59.gif");
INSERT INTO pocelui_list VALUES("60","4","Воздушные ","150","/pocelui/img/60.gif");
INSERT INTO pocelui_list VALUES("61","4","Воздушные ","150","/pocelui/img/61.gif");
INSERT INTO pocelui_list VALUES("62","4","Воздушные ","150","/pocelui/img/62.gif");
INSERT INTO pocelui_list VALUES("63","4","Воздушные ","150","/pocelui/img/63.gif");
INSERT INTO pocelui_list VALUES("64","4","Воздушные ","150","/pocelui/img/64.gif");
INSERT INTO pocelui_list VALUES("65","4","Воздушные ","150","/pocelui/img/65.gif");
INSERT INTO pocelui_list VALUES("66","4","Воздушные ","150","/pocelui/img/66.gif");
INSERT INTO pocelui_list VALUES("67","4","Воздушные ","150","/pocelui/img/67.gif");
INSERT INTO pocelui_list VALUES("68","4","Воздушные ","150","/pocelui/img/68.gif");
INSERT INTO pocelui_list VALUES("69","4","Воздушные ","150","/pocelui/img/69.gif");
INSERT INTO pocelui_list VALUES("70","4","Воздушные ","150","/pocelui/img/70.gif");
INSERT INTO pocelui_list VALUES("71","4","Воздушные ","150","/pocelui/img/71.gif");
INSERT INTO pocelui_list VALUES("72","4","Воздушные ","150","/pocelui/img/72.gif");
INSERT INTO pocelui_list VALUES("73","4","Воздушные ","150","/pocelui/img/73.gif");
INSERT INTO pocelui_list VALUES("74","4","Воздушные ","150","/pocelui/img/74.gif");
INSERT INTO pocelui_list VALUES("75","4","Воздушные ","150","/pocelui/img/75.gif");
INSERT INTO pocelui_list VALUES("76","4","Воздушные ","150","/pocelui/img/76.gif");
INSERT INTO pocelui_list VALUES("77","5","Дружеские ","100","/pocelui/img/77.gif");
INSERT INTO pocelui_list VALUES("78","5","Дружеские ","100","/pocelui/img/78.gif");
INSERT INTO pocelui_list VALUES("79","5","Дружеские ","100","/pocelui/img/79.gif");
INSERT INTO pocelui_list VALUES("80","5","Дружеские ","100","/pocelui/img/80.gif");
INSERT INTO pocelui_list VALUES("81","5","Дружеские ","100","/pocelui/img/81.gif");
INSERT INTO pocelui_list VALUES("82","5","Дружеские ","100","/pocelui/img/82.gif");
INSERT INTO pocelui_list VALUES("83","5","Дружеские ","100","/pocelui/img/83.gif");
INSERT INTO pocelui_list VALUES("84","5","Дружеские ","100","/pocelui/img/84.gif");
INSERT INTO pocelui_list VALUES("85","5","Дружеские ","100","/pocelui/img/85.gif");
INSERT INTO pocelui_list VALUES("86","5","Дружеские ","100","/pocelui/img/86.gif");
INSERT INTO pocelui_list VALUES("87","5","Дружеские ","100","/pocelui/img/87.gif");
INSERT INTO pocelui_list VALUES("88","5","Дружеские ","100","/pocelui/img/88.gif");
INSERT INTO pocelui_list VALUES("89","5","Дружеские ","100","/pocelui/img/89.gif");
INSERT INTO pocelui_list VALUES("90","3","Любимым ","150","/pocelui/img/90.png");
INSERT INTO pocelui_list VALUES("91","3","Любимым ","150","/pocelui/img/91.gif");
INSERT INTO pocelui_list VALUES("92","3","Любимым ","150","/pocelui/img/92.gif");
INSERT INTO pocelui_list VALUES("93","3","Любимым ","150","/pocelui/img/93.gif");
INSERT INTO pocelui_list VALUES("94","3","Любимым ","150","/pocelui/img/94.png");
INSERT INTO pocelui_list VALUES("95","3","Любимым ","150","/pocelui/img/95.png");
INSERT INTO pocelui_list VALUES("96","3","Любимым ","150","/pocelui/img/96.png");
INSERT INTO pocelui_list VALUES("97","3","Любимым ","150","/pocelui/img/97.png");
INSERT INTO pocelui_list VALUES("98","3","Любимым ","150","/pocelui/img/98.png");
INSERT INTO pocelui_list VALUES("99","3","Любимым ","150","/pocelui/img/99.png");
INSERT INTO pocelui_list VALUES("100","3","Любимым ","150","/pocelui/img/100.png");
INSERT INTO pocelui_list VALUES("101","4","Воздушны поцелуй","150","/pocelui/img/101.png");
INSERT INTO pocelui_list VALUES("102","4","Воздушны поцелуй","150","/pocelui/img/102.png");
INSERT INTO pocelui_list VALUES("103","4","Воздушны поцелуй","150","/pocelui/img/103.gif");
INSERT INTO pocelui_list VALUES("104","4","Воздушны поцелуй","150","/pocelui/img/104.jpg");
INSERT INTO pocelui_list VALUES("105","2","Страсть","150","/pocelui/img/105.gif");
INSERT INTO pocelui_list VALUES("106","2","Страсть","150","/pocelui/img/106.gif");
INSERT INTO pocelui_list VALUES("107","2","Люблю","200","/pocelui/img/107.gif");
INSERT INTO pocelui_list VALUES("108","2","Люблю","200","/pocelui/img/108.gif");
INSERT INTO pocelui_list VALUES("109","2","Люблю","200","/pocelui/img/109.gif");
INSERT INTO pocelui_list VALUES("110","2","Люблю","200","/pocelui/img/110.gif");
INSERT INTO pocelui_list VALUES("111","2","Люблю","200","/pocelui/img/111.gif");
INSERT INTO pocelui_list VALUES("112","2","Люблю","200","/pocelui/img/112.gif");
INSERT INTO pocelui_list VALUES("113","2","Люблю","200","/pocelui/img/113.gif");
INSERT INTO pocelui_list VALUES("114","2","Люблю","200","/pocelui/img/114.gif");
INSERT INTO pocelui_list VALUES("115","2","Люблю","200","/pocelui/img/115.gif");
INSERT INTO pocelui_list VALUES("116","2","Люблю","200","/pocelui/img/116.jpg");
INSERT INTO pocelui_list VALUES("117","2","Люблю","200","/pocelui/img/117.gif");
INSERT INTO pocelui_list VALUES("118","2","Люблю","200","/pocelui/img/118.gif");
INSERT INTO pocelui_list VALUES("119","2","Люблю","200","/pocelui/img/119.gif");
INSERT INTO pocelui_list VALUES("120","2","Люблю","200","/pocelui/img/120.gif");
INSERT INTO pocelui_list VALUES("121","2","Люблю","200","/pocelui/img/121.gif");
INSERT INTO pocelui_list VALUES("122","2","Люблю","200","/pocelui/img/122.gif");
INSERT INTO pocelui_list VALUES("123","2","Люблю","200","/pocelui/img/123.gif");
INSERT INTO pocelui_list VALUES("124","2","Люблю","200","/pocelui/img/124.gif");
INSERT INTO pocelui_list VALUES("125","2","Люблю","200","/pocelui/img/125.gif");
INSERT INTO pocelui_list VALUES("126","2","Люблю","200","/pocelui/img/126.gif");
INSERT INTO pocelui_list VALUES("127","2","Люблю","200","/pocelui/img/127.gif");
INSERT INTO pocelui_list VALUES("128","2","Люблю","200","/pocelui/img/128.gif");
INSERT INTO pocelui_list VALUES("129","2","Люблю","200","/pocelui/img/129.gif");
INSERT INTO pocelui_list VALUES("130","2","Люблю","200","/pocelui/img/130.gif");
INSERT INTO pocelui_list VALUES("131","2","Люблю","200","/pocelui/img/131.gif");
INSERT INTO pocelui_list VALUES("132","2","Люблю","200","/pocelui/img/132.gif");
INSERT INTO pocelui_list VALUES("133","2","Люблю","200","/pocelui/img/133.gif");
INSERT INTO pocelui_list VALUES("134","2","Люблю","200","/pocelui/img/134.gif");
INSERT INTO pocelui_list VALUES("135","2","Люблю","200","/pocelui/img/135.gif");
INSERT INTO pocelui_list VALUES("136","2","Люблю","200","/pocelui/img/136.gif");
INSERT INTO pocelui_list VALUES("137","2","Люблю","200","/pocelui/img/137.gif");
INSERT INTO pocelui_list VALUES("138","2","Люблю","200","/pocelui/img/138.gif");
INSERT INTO pocelui_list VALUES("139","2","Люблю","200","/pocelui/img/139.gif");



DROP TABLE IF EXISTS `podkupidon_dir`;

CREATE TABLE `podkupidon_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=cp1251;

INSERT INTO podkupidon_dir VALUES("3","Для друзей");
INSERT INTO podkupidon_dir VALUES("4","Для любимых ");
INSERT INTO podkupidon_dir VALUES("5","Общие");
INSERT INTO podkupidon_dir VALUES("6","Приветствия ");



DROP TABLE IF EXISTS `podkupidon_give`;

CREATE TABLE `podkupidon_give` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_give` int(11) NOT NULL,
  `id_p` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coment` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6379 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `podkupidon_jurnal`;

CREATE TABLE `podkupidon_jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6379 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `podkupidon_list`;

CREATE TABLE `podkupidon_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_dir` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `prise` int(11) NOT NULL,
  `url` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=cp1251;

INSERT INTO podkupidon_list VALUES("1","6","привет","200","/plugins/Kupidon/img/1.png");
INSERT INTO podkupidon_list VALUES("2","6","привет","200","/plugins/Kupidon/img/2.png");
INSERT INTO podkupidon_list VALUES("3","6","привет","200","/plugins/Kupidon/img/3.png");
INSERT INTO podkupidon_list VALUES("4","6","привет","200","/plugins/Kupidon/img/4.png");
INSERT INTO podkupidon_list VALUES("5","6","привет","200","/plugins/Kupidon/img/5.png");



DROP TABLE IF EXISTS `podtv_reg_user`;

CREATE TABLE `podtv_reg_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `reg` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `poll`;

CREATE TABLE `poll` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `poll_like`;

CREATE TABLE `poll_like` (
  `id_poll` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) DEFAULT '0',
  KEY `id_notes` (`id_poll`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `poll_variant`;

CREATE TABLE `poll_variant` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_poll` int(11) NOT NULL,
  `num` int(11) NOT NULL,
  `otvet` varchar(125) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `poll_votes`;

CREATE TABLE `poll_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_poll` int(11) NOT NULL,
  `id_otvet` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=20 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `polls`;

CREATE TABLE `polls` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_object` int(11) NOT NULL DEFAULT '0',
  `id_type` varchar(50) DEFAULT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time_start` int(11) NOT NULL DEFAULT '0',
  `time_finish` int(11) NOT NULL DEFAULT '0',
  `multi` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(2000) DEFAULT NULL,
  `duration` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8 COMMENT='Опросы';




DROP TABLE IF EXISTS `polls_variants`;

CREATE TABLE `polls_variants` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_object` int(11) NOT NULL DEFAULT '0',
  `id_type` varchar(50) DEFAULT NULL,
  `id_poll` int(11) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(500) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8 COMMENT='Опросы - Варианты ответов';




DROP TABLE IF EXISTS `polls_votes`;

CREATE TABLE `polls_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_poll` int(11) NOT NULL DEFAULT '0',
  `id_object` int(11) NOT NULL DEFAULT '0',
  `id_type` varchar(50) DEFAULT NULL,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_variant` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8 COMMENT='Опросы - Голоса';




DROP TABLE IF EXISTS `presents`;

CREATE TABLE `presents` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `razdel` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) NOT NULL,
  `money` int(11) NOT NULL,
  `money_yes` int(11) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL,
  `balls_yes` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=565 DEFAULT CHARSET=utf8;

INSERT INTO presents VALUES("358","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("357","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("356","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("355","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("354","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("353","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("352","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("351","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("350","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("349","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("348","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("347","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("346","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("443","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("442","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("441","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("440","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("439","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("438","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("437","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("436","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("435","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("434","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("433","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("431","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("451","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("428","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("450","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("426","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("425","18","Поцелуи","1000","1","2000","1");
INSERT INTO presents VALUES("470","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("469","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("468","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("467","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("466","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("465","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("464","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("463","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("462","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("461","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("449","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("448","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("447","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("345","15","С днём рождения","1000","1","2000","1");
INSERT INTO presents VALUES("460","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("402","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("401","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("400","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("396","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("397","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("398","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("399","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("395","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("394","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("386","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("393","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("392","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("459","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("390","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("389","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("388","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("385","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("387","20","Добро пожаловать ","200","1","500","1");
INSERT INTO presents VALUES("444","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("445","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("446","21","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("458","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("457","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("456","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("455","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("454","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("453","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("452","22","Для Тебя","200","1","500","1");
INSERT INTO presents VALUES("471","23","Любовь","1000","1","2000","1");
INSERT INTO presents VALUES("472","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("473","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("476","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("475","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("477","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("478","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("479","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("480","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("481","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("482","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("483","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("484","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("485","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("486","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("487","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("488","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("489","24","8 марта","1000","1","2000","1");
INSERT INTO presents VALUES("490","24","8 марта","1000","1","2000","1");
INSERT INTO presents VALUES("491","24","8марта","1000","1","2000","1");
INSERT INTO presents VALUES("492","24","8марта","1000","1","2000","1");
INSERT INTO presents VALUES("493","24","8марта","1000","1","2000","1");
INSERT INTO presents VALUES("494","24","8марта","1000","1","2000","1");
INSERT INTO presents VALUES("495","24","8марта","1000","1","2000","1");
INSERT INTO presents VALUES("496","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("497","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("498","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("499","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("500","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("501","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("502","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("503","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("504","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("505","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("506","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("507","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("508","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("509","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("510","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("511","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("512","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("513","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("514","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("515","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("516","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("517","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("518","23","любовь","1000","1","2000","1");
INSERT INTO presents VALUES("519","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("520","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("521","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("522","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("523","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("524","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("525","21","Для тебя","1000","1","2000","1");
INSERT INTO presents VALUES("526","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("527","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("528","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("529","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("530","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("531","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("532","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("533","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("534","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("535","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("536","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("537","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("538","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("539","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("540","15","С днем рождения","1000","1","2000","1");
INSERT INTO presents VALUES("541","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("542","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("543","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("544","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("545","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("546","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("547","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("548","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("549","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("550","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("551","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("552","25","Свадьба","1000","1","2000","1");
INSERT INTO presents VALUES("553","22","Для тебя","200","1","500","1");
INSERT INTO presents VALUES("554","26","Обнимаю","200","1","500","1");
INSERT INTO presents VALUES("555","26","Обнимаю","200","1","500","1");
INSERT INTO presents VALUES("556","26","Обнимаю","200","1","500","1");
INSERT INTO presents VALUES("557","26","Обнимаю","200","1","500","1");
INSERT INTO presents VALUES("558","23","Любовь","1000","1","2000","1");
INSERT INTO presents VALUES("559","27","Для тебя ","100","1","500","1");
INSERT INTO presents VALUES("560","27","Для тебя ","100","1","500","1");
INSERT INTO presents VALUES("561","27","Для тебя ","100","1","500","1");
INSERT INTO presents VALUES("562","27","Для тебя ","100","1","500","1");
INSERT INTO presents VALUES("563","27","Для тебя ","100","1","500","1");
INSERT INTO presents VALUES("564","27","Для тебя ","100","1","500","1");



DROP TABLE IF EXISTS `presents_razdel`;

CREATE TABLE `presents_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=28 DEFAULT CHARSET=utf8;

INSERT INTO presents_razdel VALUES("15","С днём рождения");
INSERT INTO presents_razdel VALUES("20","Добро Пожаловать ");
INSERT INTO presents_razdel VALUES("21","Для Друзяшек ");
INSERT INTO presents_razdel VALUES("18","Поцелуи");
INSERT INTO presents_razdel VALUES("22","☆Цветики☆");
INSERT INTO presents_razdel VALUES("23","любовь");
INSERT INTO presents_razdel VALUES("24","8 Марта");
INSERT INTO presents_razdel VALUES("25","Свадьба");
INSERT INTO presents_razdel VALUES("26","Обнимашки");
INSERT INTO presents_razdel VALUES("27","Именные цветули ");



DROP TABLE IF EXISTS `rank`;

CREATE TABLE `rank` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rating` int(11) NOT NULL,
  `name` varchar(300) NOT NULL,
  `icons` varchar(300) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=56 DEFAULT CHARSET=utf8;

INSERT INTO rank VALUES("2","5","новобранец","1.png","1567595112");
INSERT INTO rank VALUES("3","40","младший рекрут","2.png","1567595141");
INSERT INTO rank VALUES("4","80","рекрут","3.png","1567595266");
INSERT INTO rank VALUES("5","120","старший рекрут","4.png","1567595288");
INSERT INTO rank VALUES("6","160","рекрут 1 класса","5.png","1567597239");
INSERT INTO rank VALUES("7","200","солдат","6.png","1567597418");
INSERT INTO rank VALUES("12","240","рядовой рекрут","7.png","1567599161");
INSERT INTO rank VALUES("13","260","рядовой 2 класса","8.png","1567599180");
INSERT INTO rank VALUES("14","300","рядовой","9.png","1567599213");
INSERT INTO rank VALUES("15","340","рядовой 1 класса","10.png","1567599231");
INSERT INTO rank VALUES("16","500","специалист","11.png","1567599298");
INSERT INTO rank VALUES("17","600","старший специалист","12.png","1567599323");
INSERT INTO rank VALUES("18","700","техник","13.png","1567599348");
INSERT INTO rank VALUES("19","1000","специалист 1 класса","14.png","1567599369");
INSERT INTO rank VALUES("20","5000","разведчик","15.png","1567599411");
INSERT INTO rank VALUES("21","8000","младший капрал","16.png","1567599429");
INSERT INTO rank VALUES("22","15000","капрал","17.png","1567599448");
INSERT INTO rank VALUES("23","20000","командир звена","18.png","1567599463");
INSERT INTO rank VALUES("24","25000","сержант 3 класса","19.png","1567599490");
INSERT INTO rank VALUES("25","30000","сержант 2 класса","20.png","1567599514");
INSERT INTO rank VALUES("26","35000","сержант","21.png","1567599535");
INSERT INTO rank VALUES("27","40000","штаб-сержант","22.png","1567599549");
INSERT INTO rank VALUES("28","45000","сержант 1 класса","23.png","1567599566");
INSERT INTO rank VALUES("29","50000","комендор-сержант","24.png","1567599581");
INSERT INTO rank VALUES("30","55000","мастер-сержант","25.png","1567599651");
INSERT INTO rank VALUES("31","60000","первый сержант","26.png","1567599669");
INSERT INTO rank VALUES("32","65000","команд-сержант","27.png","1567599686");
INSERT INTO rank VALUES("33","70000","мастер комендор-сержант","26.png","1567599702");
INSERT INTO rank VALUES("34","75000","сержант майор","29.png","1567599717");
INSERT INTO rank VALUES("35","80000","команд сержант-майор","30.png","1567599734");
INSERT INTO rank VALUES("36","85000","младший уорент-офицер","31.png","1567600605");
INSERT INTO rank VALUES("37","90000","уорент-офицер","32.png","1567600632");
INSERT INTO rank VALUES("38","95000","старший уорент-офицер","33.png","1567600677");
INSERT INTO rank VALUES("39","100000","старший уорент офицер 1 класса","34.png","1567600694");
INSERT INTO rank VALUES("40","100005","мастер уорент-офицер","35.png","1567600725");
INSERT INTO rank VALUES("41","100010","квартирмейстер","36.png","1567600744");
INSERT INTO rank VALUES("42","100050","младший офицер","37.png","1567600765");
INSERT INTO rank VALUES("43","100100","старший офицер","38.png","1567600787");
INSERT INTO rank VALUES("44","100200","младший лейтенант","39.png","1567600809");
INSERT INTO rank VALUES("45","100500","второй лейтенант","40.png","1567600859");
INSERT INTO rank VALUES("46","7348","первый лейтенант","41.png","1567600881");
INSERT INTO rank VALUES("47","8818","лейтенант","42.png","1567600906");
INSERT INTO rank VALUES("48","10582","старший лейтенант","43.png","1567600926");
INSERT INTO rank VALUES("49","12698","капитан лейтенант","44.png","1567600956");
INSERT INTO rank VALUES("50","15238","капитан","45.png","1567600974");
INSERT INTO rank VALUES("51","18286","капитан разведки","46.png","1567600998");
INSERT INTO rank VALUES("52","21943","капитан спецназа","47.png","1567601024");
INSERT INTO rank VALUES("53","26332","майор","48.png","1567601053");
INSERT INTO rank VALUES("54","31598","подполковник","49.png","1567601073");
INSERT INTO rank VALUES("55","2147483647","Генералисимус","50.png","1567601107");



DROP TABLE IF EXISTS `ranks`;

CREATE TABLE `ranks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_ank` int(11) NOT NULL DEFAULT '0',
  `id_rank` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(500) DEFAULT NULL,
  `time` int(11) NOT NULL DEFAULT '0',
  KEY `id` (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Список наград пользователя';




DROP TABLE IF EXISTS `ranksList`;

CREATE TABLE `ranksList` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=253 DEFAULT CHARSET=utf8 COMMENT='Список наград';

INSERT INTO ranksList VALUES("1","1-е место");
INSERT INTO ranksList VALUES("2","2-е место");
INSERT INTO ranksList VALUES("3","3-е место");
INSERT INTO ranksList VALUES("4","Активный пользователь");
INSERT INTO ranksList VALUES("5","Баламут сайта");
INSERT INTO ranksList VALUES("6","Бестия сайта");
INSERT INTO ranksList VALUES("7","Благодарность");
INSERT INTO ranksList VALUES("8","Ведьмочка");
INSERT INTO ranksList VALUES("10","Вип персоне");
INSERT INTO ranksList VALUES("11","Волшебница");
INSERT INTO ranksList VALUES("12","Всегда на позитиве");
INSERT INTO ranksList VALUES("14","Деловой человек");
INSERT INTO ranksList VALUES("16","Для любимых.");
INSERT INTO ranksList VALUES("17","Дружная компания");
INSERT INTO ranksList VALUES("18","За 10 выигранных дуэлей");
INSERT INTO ranksList VALUES("20","За активность в беседке");
INSERT INTO ranksList VALUES("21","За активность на сайте");
INSERT INTO ranksList VALUES("22","За активность на форуме");
INSERT INTO ranksList VALUES("23","За большой рейтинг");
INSERT INTO ranksList VALUES("24","За добавление файлов mp3");
INSERT INTO ranksList VALUES("26","За интересные темы");
INSERT INTO ranksList VALUES("27","За лёгкость в общении");
INSERT INTO ranksList VALUES("28","За лучшие дневники");
INSERT INTO ranksList VALUES("29","За лучшие микроблоги");
INSERT INTO ranksList VALUES("31","За любовь к сайту");
INSERT INTO ranksList VALUES("32","За наблюдательность");
INSERT INTO ranksList VALUES("33","За нежность");
INSERT INTO ranksList VALUES("35","За подарки");
INSERT INTO ranksList VALUES("36","За понимание");
INSERT INTO ranksList VALUES("37","За попадание в топ 10 богачей");
INSERT INTO ranksList VALUES("38","За попадание в топ 10  умников");
INSERT INTO ranksList VALUES("39","За попадание в топ-10");
INSERT INTO ranksList VALUES("40","За преданность");
INSERT INTO ranksList VALUES("41","За приведённых друзей");
INSERT INTO ranksList VALUES("42","За приятное общение");
INSERT INTO ranksList VALUES("43","За терпение");
INSERT INTO ranksList VALUES("44","За умение поддержать разговоры");
INSERT INTO ranksList VALUES("45","За умение сделать выбор");
INSERT INTO ranksList VALUES("46","За уникальность");
INSERT INTO ranksList VALUES("47","За участие в конкурсах");
INSERT INTO ranksList VALUES("48","За финансовую помощь сайту");
INSERT INTO ranksList VALUES("49","За частый онлайн");
INSERT INTO ranksList VALUES("51","За яркое общение");
INSERT INTO ranksList VALUES("52","Зайке");
INSERT INTO ranksList VALUES("53","Защитник сайта");
INSERT INTO ranksList VALUES("54","Защитнику");
INSERT INTO ranksList VALUES("55","Звезда сайта");
INSERT INTO ranksList VALUES("56","Золотой человечек");
INSERT INTO ranksList VALUES("57","Кокетка");
INSERT INTO ranksList VALUES("59","Куколка сайта");
INSERT INTO ranksList VALUES("60","Лапуля");
INSERT INTO ranksList VALUES("61","Лидер по наградам");
INSERT INTO ranksList VALUES("62","Лучшая аватарка");
INSERT INTO ranksList VALUES("63","Лучшая подруга");
INSERT INTO ranksList VALUES("64","Лучшей девушке");
INSERT INTO ranksList VALUES("66","Лучшему парню");
INSERT INTO ranksList VALUES("67","Лучшему искателю");
INSERT INTO ranksList VALUES("69","Лучший друг");
INSERT INTO ranksList VALUES("70","Лучший парень");
INSERT INTO ranksList VALUES("71","Лучший по мнению пользователей");
INSERT INTO ranksList VALUES("72","Любимому,любимой");
INSERT INTO ranksList VALUES("73","Любимый человечек");
INSERT INTO ranksList VALUES("74","Любитель отдыха");
INSERT INTO ranksList VALUES("75","Любителю музыки");
INSERT INTO ranksList VALUES("76","Любителю прокатиться");
INSERT INTO ranksList VALUES("77","Мега обитателю сайта");
INSERT INTO ranksList VALUES("78","Милашка");
INSERT INTO ranksList VALUES("80","Мисс сайта за месяц");
INSERT INTO ranksList VALUES("81","Мистер сайта за месяц");
INSERT INTO ranksList VALUES("82","Моему солнышку");
INSERT INTO ranksList VALUES("83","Молодожёнам сайта");
INSERT INTO ranksList VALUES("84","Мото-любителю");
INSERT INTO ranksList VALUES("85","Нахождение в команде");
INSERT INTO ranksList VALUES("88","Неуправляемому(ой)");
INSERT INTO ranksList VALUES("90","Отличный модератор сайта");
INSERT INTO ranksList VALUES("91","Писатель");
INSERT INTO ranksList VALUES("92","Позитивчик");
INSERT INTO ranksList VALUES("93","Полуночник сайта");
INSERT INTO ranksList VALUES("94","Почётный Юзер");
INSERT INTO ranksList VALUES("95","Принцесса сайта");
INSERT INTO ranksList VALUES("96","Приятной девушке");
INSERT INTO ranksList VALUES("97","Просто хороший чел");
INSERT INTO ranksList VALUES("98","Профи на сайте");
INSERT INTO ranksList VALUES("99","Работяге");
INSERT INTO ranksList VALUES("100","Радужный человек");
INSERT INTO ranksList VALUES("101","Разносторонний человек");
INSERT INTO ranksList VALUES("102","Романтичный(ая)");
INSERT INTO ranksList VALUES("103","Рыцарю");
INSERT INTO ranksList VALUES("104","С Днём Защитника");
INSERT INTO ranksList VALUES("105","С днём Победы");
INSERT INTO ranksList VALUES("107","С праздником");
INSERT INTO ranksList VALUES("109","Самой милой");
INSERT INTO ranksList VALUES("111","Самому милому");
INSERT INTO ranksList VALUES("112","Самому ревнивому(ой)");
INSERT INTO ranksList VALUES("113","Самому болтливому(ой)");
INSERT INTO ranksList VALUES("114","Самому смелому");
INSERT INTO ranksList VALUES("115","Самому стеснительному(ой)");
INSERT INTO ranksList VALUES("116","Самому(ой) разговорчивому(ой)");
INSERT INTO ranksList VALUES("117","Самому(ой) удачливому(ой)");
INSERT INTO ranksList VALUES("119","Самый богатый");
INSERT INTO ranksList VALUES("120","Самый дорогой(ая)");
INSERT INTO ranksList VALUES("121","Самый необычный ник");
INSERT INTO ranksList VALUES("122","Самый шустрый(ая)");
INSERT INTO ranksList VALUES("123","Симпатия сайта");
INSERT INTO ranksList VALUES("124","Симпатия");
INSERT INTO ranksList VALUES("125","Солнышко сайта");
INSERT INTO ranksList VALUES("126","Супермэн сайта");
INSERT INTO ranksList VALUES("127","Супер-чел");
INSERT INTO ranksList VALUES("128","Труженник сайта");
INSERT INTO ranksList VALUES("129","Цветик-семицветик");
INSERT INTO ranksList VALUES("130","Шикарной даме");
INSERT INTO ranksList VALUES("131","Юморист");
INSERT INTO ranksList VALUES("132","Ягодка сайта");
INSERT INTO ranksList VALUES("138","Эрудиту");
INSERT INTO ranksList VALUES("139","Предложение руки и сердца");
INSERT INTO ranksList VALUES("140","Победителю викторины");
INSERT INTO ranksList VALUES("141","Жемчужина сайта");
INSERT INTO ranksList VALUES("142","Лучший Создатель!!!");
INSERT INTO ranksList VALUES("143","За отличное проведение викторины");
INSERT INTO ranksList VALUES("144","За активность в форуме");
INSERT INTO ranksList VALUES("145","Ангел сайта");
INSERT INTO ranksList VALUES("146","За активность в виктоине");
INSERT INTO ranksList VALUES("148","Яркая личность");
INSERT INTO ranksList VALUES("149","Ветеран сайта");
INSERT INTO ranksList VALUES("150","Солнечный человек");
INSERT INTO ranksList VALUES("153","Лучшему администратору");
INSERT INTO ranksList VALUES("159","Доброе сердце");
INSERT INTO ranksList VALUES("160","Душа беседки");
INSERT INTO ranksList VALUES("161","Лучшему модератору");
INSERT INTO ranksList VALUES("162","Самый активный за месяц");
INSERT INTO ranksList VALUES("163","Модница сайта");
INSERT INTO ranksList VALUES("165","Активист сайта");
INSERT INTO ranksList VALUES("166","Любимому человеку");
INSERT INTO ranksList VALUES("167","За Акцию Голодный Админ!:)");
INSERT INTO ranksList VALUES("168","За участие в конкурсе");
INSERT INTO ranksList VALUES("169","За участие в фотоконкурсе");
INSERT INTO ranksList VALUES("170","За победу в фотоконкурсе");
INSERT INTO ranksList VALUES("171","За победу в конкурсе форума");
INSERT INTO ranksList VALUES("172","Королева сайта");
INSERT INTO ranksList VALUES("173","Король сайта");
INSERT INTO ranksList VALUES("174","Лучшему родителю");
INSERT INTO ranksList VALUES("179","За дневники 1место");
INSERT INTO ranksList VALUES("180","За дневники 2место");
INSERT INTO ranksList VALUES("181","За дневники 3место");
INSERT INTO ranksList VALUES("182","Мой герой");
INSERT INTO ranksList VALUES("183","Милому(милой)");
INSERT INTO ranksList VALUES("187","Живчик сайта!");
INSERT INTO ranksList VALUES("188","Лучшие Дневники Недели!");
INSERT INTO ranksList VALUES("189","Любитель Пончиков!");
INSERT INTO ranksList VALUES("190","Сердцеед(ка) сайта!");
INSERT INTO ranksList VALUES("191","Победителю Викторины!");
INSERT INTO ranksList VALUES("192","Королевская Особа!");
INSERT INTO ranksList VALUES("193","За Победу в Текстовом конкурсе!");
INSERT INTO ranksList VALUES("194","Элита Сайта!");
INSERT INTO ranksList VALUES("195","Монстр Общения!");
INSERT INTO ranksList VALUES("196","Гуру Сайта!");
INSERT INTO ranksList VALUES("197","Лучший Статус!");
INSERT INTO ranksList VALUES("198","Говорунка Дня!");
INSERT INTO ranksList VALUES("199","Звезда Сайта!");
INSERT INTO ranksList VALUES("200","Лучшая Аватарка Недели!");
INSERT INTO ranksList VALUES("201","Говорун Дня!");
INSERT INTO ranksList VALUES("202","С прибытием на сайт!");
INSERT INTO ranksList VALUES("203","Новичку на удачу!");
INSERT INTO ranksList VALUES("204"," С регистрацией!");
INSERT INTO ranksList VALUES("205","Начинаещему активисту!");
INSERT INTO ranksList VALUES("206","С новосельем!");
INSERT INTO ranksList VALUES("207","Добро пожаловать?");
INSERT INTO ranksList VALUES("227","Золотое сердце");
INSERT INTO ranksList VALUES("229","Не мерзни");
INSERT INTO ranksList VALUES("231","С днем рожденья ");
INSERT INTO ranksList VALUES("233","С днем р");
INSERT INTO ranksList VALUES("244","Помню горжусь");
INSERT INTO ranksList VALUES("246","Наград");
INSERT INTO ranksList VALUES("248","С днем рож");
INSERT INTO ranksList VALUES("250","Рыцерю");
INSERT INTO ranksList VALUES("251","Лучший муж");
INSERT INTO ranksList VALUES("252","Моему любимому");



DROP TABLE IF EXISTS `rassilka_send`;

CREATE TABLE `rassilka_send` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `time` int(10) NOT NULL,
  `msg` text NOT NULL,
  `group_access` int(2) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=61 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_coded`;

CREATE TABLE `rating_coded` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `like` smallint(1) NOT NULL DEFAULT '0',
  `dlike` smallint(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_files`;

CREATE TABLE `rating_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `like` smallint(1) NOT NULL DEFAULT '0',
  `dlike` smallint(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_foto`;

CREATE TABLE `rating_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `good` int(11) NOT NULL DEFAULT '0',
  `bad` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `komu` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_gazeta`;

CREATE TABLE `rating_gazeta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `like` smallint(1) NOT NULL DEFAULT '0',
  `dlike` smallint(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_hist`;

CREATE TABLE `rating_hist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `msg` char(255) NOT NULL,
  `val` smallint(1) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_loads`;

CREATE TABLE `rating_loads` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `like` smallint(1) NOT NULL DEFAULT '0',
  `dlike` smallint(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `rating_news`;

CREATE TABLE `rating_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `who` int(11) NOT NULL DEFAULT '0',
  `like` smallint(1) NOT NULL DEFAULT '0',
  `dlike` smallint(1) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `reg_mail`;

CREATE TABLE `reg_mail` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `mail` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `mail` (`mail`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `reg_msg`;

CREATE TABLE `reg_msg` (
  `msg` varchar(2000) NOT NULL,
  `money` varchar(6) DEFAULT '1',
  `rating` varchar(3) DEFAULT '1',
  `balls` varchar(6) DEFAULT '1',
  `id` varchar(128) DEFAULT '1',
  `on` int(2) DEFAULT '1',
  `true` int(2) DEFAULT '0',
  `gift` int(11) DEFAULT NULL,
  `gift_msg` varchar(50) DEFAULT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO reg_msg VALUES("{NICK} поздравляю с регистрацией на нашем сайте \r\nТы теперь обитатель нашего сайта!\r\nТеперь я тебе чуть чуть помогу. Для начала загрузи фото на свою страничку, узнай как это сделать, нажми сюда. \r\nДалее заполни свою анкету тут \r\nНе жди что тебе сразу же станут писать, зайди в чат и прояви общительность.\r\nУ нас много интересные и дружелюбные обитатели, будут рады с тобой подружиться \r\nЕсли ты ищешь свою вторую половинку, попробуй зайти в Знакомства.\r\nЧтобы зарабатывать баллы у нас есть Викторина, также если будешь активничать, общаться с людьми, создавать дневники, \r\nтемы в форуме и т.д, автоматически будут накапливаться баллы и рейтинг  \r\nВсё остальное зависит от тебя \r\nЗови друзей и знакомых, мы всегда рады новым обитателям!","50","10","200","1","1","1","2","");



DROP TABLE IF EXISTS `rekl`;

CREATE TABLE `rekl` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `url` varchar(70) NOT NULL,
  `date_last` int(11) NOT NULL,
  `color` varchar(32) NOT NULL,
  `bold` int(11) NOT NULL,
  `oplata` enum('0','1') NOT NULL DEFAULT '0',
  `summa` int(11) NOT NULL DEFAULT '0',
  `days_rek` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`),
  KEY `url` (`url`),
  KEY `date_last` (`date_last`),
  KEY `color` (`color`),
  KEY `bold` (`bold`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `reklama`;

CREATE TABLE `reklama` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `link` char(100) NOT NULL,
  `name` char(25) NOT NULL,
  `look` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;




DROP TABLE IF EXISTS `relationships`;

CREATE TABLE `relationships` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_ank` int(11) NOT NULL DEFAULT '0',
  `room_func` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=126 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `relationships_new`;

CREATE TABLE `relationships_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_ank` int(11) NOT NULL DEFAULT '0',
  `room_func` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `roza_dir`;

CREATE TABLE `roza_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(128) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `roza_give`;

CREATE TABLE `roza_give` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_give` int(11) NOT NULL,
  `id_p` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `coment` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `roza_jurnal`;

CREATE TABLE `roza_jurnal` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  `id_user` int(11) NOT NULL,
  `read` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `roza_list`;

CREATE TABLE `roza_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_dir` int(11) NOT NULL,
  `name` varchar(128) NOT NULL,
  `prise` int(11) NOT NULL,
  `url` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `rules`;

CREATE TABLE `rules` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` mediumtext,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `title` varchar(60) DEFAULT NULL,
  `url` varchar(999) DEFAULT NULL,
  `name_url` varchar(52) DEFAULT NULL,
  `pos` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8;

INSERT INTO rules VALUES("6","[b][i][blue] Правила сервиса.\r\n\r\nЗапрещается:\r\n \r\n..а1. Регистрация ников откровенно сексуального характера,неприличных,оскорбляющих пользователей,нарушающих общепринятые нормы морали. \r\n.а2. Регистрация ников для намеренного введения в заблуждение пользователей,например:Админ,Модер.Такие ники могут изменены администрацией сайта. \r\n.а3.Плагиат ников других пользователей.Такие ники могут изменены администрацией сайта. \r\n.а4.Размещение рекламы в любом виде рекламной информации,не согласовав с администрацией \r\n.а5.Перерегистрация в случае бана.\r\n.а6.Оскорбление участников,модераторов,и администраторов.\r\n.а7.Обсуждения действия модераторов,администраторов.\r\n.а8. Употребление ненормативной лексики.\r\n.а9.ФЛУД,ФЛЕЙМ,ТРОЛЛИНГ,ХОЛИВАР, - кроме предназначенного сайтом раздела форума ФЛУДИЛКА\r\n..а1..а0.Размещение файлов в файлообменнике порнографического характера,а также видео файлов и фотографий содержащих изображения несовершеннолетних. \r\n\r\n..а1...а1.Размещение видео файлов и фотографий содержащих сцены жестокости,насилия,смерти и тд.\r\n \r\n..а1..а2.Размещение вредоносных файлов.\r\n\r\n..а1..а3.Добавление неприличных изображений в свою анкету.\r\n\r\n..а1..а4. Разжигание межнациональной и межрелигиозной вражды.\r\n\r\n..а1..а5. Пропагандирование нацистской символики.\r\nЗапрещается использования иностранного языка,кроме русского языка,  при добавления статусов и дневников и т.далее!\r\nЗа нарушение любого из правил сервиса,аккаунт пользователя может быть навсегда заблокирован без какого-либо предупреждения. \r\n..а1..а6.\r\n[red]СРОКИ БАНА !!![/red]\r\n1) Спам на всех модулях сайта -\r\nнавсегда .\r\n2) Создание конфликтной\r\nситуации - 1 час .\r\n3) Нецензурная лексика\r\n( открытый мат ) - от 1часа до 10.\r\n4) Оскорбление обитателей\r\nсайта - 1 час до 10 .\r\n5) Обсуждение действий\r\nадминистрации ( публично ) -5\r\nсуток .\r\n6) Конфликт с администрацией - 5\r\nсуток .\r\n7)Оскорбление\r\nадминистрации -5 суток\r\n8) Аватары откровенно\r\nсексуального характера,\r\nнарушающие общепринятые\r\nнормы морали , оскорбляющие\r\nотдельных пользователей или\r\nгруппы пользователей ( по\r\nнациональному , религиозному\r\nили иному признаку ) -5 часов\r\n9)Капс , флуд -30 минут\r\n10) Оскорбления , особенно\r\nэтнического , политического,\r\nрасового и религиозного\r\nхарактера на всех модулях\r\nсайта - 3 часа\r\n11)Игнор, просьбы Создателя и Администрации-2-е суток \r\n[/blue][/i][/b]","1493459243","247","","","","1");



DROP TABLE IF EXISTS `rules_p`;

CREATE TABLE `rules_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` mediumtext NOT NULL,
  `time` int(11) NOT NULL,
  `id_news` int(11) NOT NULL,
  `pos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sc_all_vip`;

CREATE TABLE `sc_all_vip` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cost` int(11) NOT NULL,
  `val` varchar(56) NOT NULL,
  `ext` varchar(8) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=389 DEFAULT CHARSET=utf8;

INSERT INTO sc_all_vip VALUES("1","100","rub","png");
INSERT INTO sc_all_vip VALUES("96","100","rub","gif");
INSERT INTO sc_all_vip VALUES("95","100","rub","gif");
INSERT INTO sc_all_vip VALUES("94","100","rub","gif");
INSERT INTO sc_all_vip VALUES("318","100","rub","gif");
INSERT INTO sc_all_vip VALUES("91","100","money","gif");
INSERT INTO sc_all_vip VALUES("89","100","rub","gif");
INSERT INTO sc_all_vip VALUES("9","100","rub","gif");
INSERT INTO sc_all_vip VALUES("10","100","rub","gif");
INSERT INTO sc_all_vip VALUES("90","100","rub","gif");
INSERT INTO sc_all_vip VALUES("12","100","rub","gif");
INSERT INTO sc_all_vip VALUES("13","100","rub","gif");
INSERT INTO sc_all_vip VALUES("14","100","rub","gif");
INSERT INTO sc_all_vip VALUES("15","100","rub","gif");
INSERT INTO sc_all_vip VALUES("16","100","rub","png");
INSERT INTO sc_all_vip VALUES("17","100","rub","gif");
INSERT INTO sc_all_vip VALUES("18","100","rub","gif");
INSERT INTO sc_all_vip VALUES("19","100","rub","gif");
INSERT INTO sc_all_vip VALUES("20","100","rub","gif");
INSERT INTO sc_all_vip VALUES("21","100","rub","png");
INSERT INTO sc_all_vip VALUES("22","100","rub","gif");
INSERT INTO sc_all_vip VALUES("23","100","rub","gif");
INSERT INTO sc_all_vip VALUES("24","100","rub","png");
INSERT INTO sc_all_vip VALUES("25","100","rub","gif");
INSERT INTO sc_all_vip VALUES("26","100","rub","gif");
INSERT INTO sc_all_vip VALUES("27","100","rub","gif");
INSERT INTO sc_all_vip VALUES("28","100","rub","gif");
INSERT INTO sc_all_vip VALUES("29","100","rub","gif");
INSERT INTO sc_all_vip VALUES("30","100","rub","gif");
INSERT INTO sc_all_vip VALUES("31","100","rub","gif");
INSERT INTO sc_all_vip VALUES("32","100","rub","gif");
INSERT INTO sc_all_vip VALUES("33","100","rub","gif");
INSERT INTO sc_all_vip VALUES("34","100","rub","png");
INSERT INTO sc_all_vip VALUES("35","100","money","png");
INSERT INTO sc_all_vip VALUES("36","100","rub","gif");
INSERT INTO sc_all_vip VALUES("37","100","rub","gif");
INSERT INTO sc_all_vip VALUES("38","100","rub","gif");
INSERT INTO sc_all_vip VALUES("39","100","rub","gif");
INSERT INTO sc_all_vip VALUES("40","100","rub","gif");
INSERT INTO sc_all_vip VALUES("41","100","rub","gif");
INSERT INTO sc_all_vip VALUES("42","100","rub","png");
INSERT INTO sc_all_vip VALUES("43","100","money","png");
INSERT INTO sc_all_vip VALUES("44","100","rub","gif");
INSERT INTO sc_all_vip VALUES("45","100","rub","gif");
INSERT INTO sc_all_vip VALUES("46","100","rub","gif");
INSERT INTO sc_all_vip VALUES("47","100","rub","gif");
INSERT INTO sc_all_vip VALUES("48","100","rub","png");
INSERT INTO sc_all_vip VALUES("49","100","rub","gif");
INSERT INTO sc_all_vip VALUES("50","100","rub","gif");
INSERT INTO sc_all_vip VALUES("51","100","rub","gif");
INSERT INTO sc_all_vip VALUES("52","100","rub","gif");
INSERT INTO sc_all_vip VALUES("53","100","rub","gif");
INSERT INTO sc_all_vip VALUES("64","100","rub","gif");
INSERT INTO sc_all_vip VALUES("55","100","rub","gif");
INSERT INTO sc_all_vip VALUES("56","100","rub","gif");
INSERT INTO sc_all_vip VALUES("57","100","rub","png");
INSERT INTO sc_all_vip VALUES("58","100","rub","png");
INSERT INTO sc_all_vip VALUES("59","100","rub","gif");
INSERT INTO sc_all_vip VALUES("60","100","rub","gif");
INSERT INTO sc_all_vip VALUES("61","100","rub","gif");
INSERT INTO sc_all_vip VALUES("62","100","rub","gif");
INSERT INTO sc_all_vip VALUES("63","100","rub","gif");
INSERT INTO sc_all_vip VALUES("65","100","rub","gif");
INSERT INTO sc_all_vip VALUES("66","100","rub","gif");
INSERT INTO sc_all_vip VALUES("67","100","rub","png");
INSERT INTO sc_all_vip VALUES("68","100","rub","png");
INSERT INTO sc_all_vip VALUES("69","100","rub","gif");
INSERT INTO sc_all_vip VALUES("70","100","rub","gif");
INSERT INTO sc_all_vip VALUES("71","100","rub","gif");
INSERT INTO sc_all_vip VALUES("72","100","rub","gif");
INSERT INTO sc_all_vip VALUES("73","100","rub","png");
INSERT INTO sc_all_vip VALUES("74","100","rub","png");
INSERT INTO sc_all_vip VALUES("75","100","rub","png");
INSERT INTO sc_all_vip VALUES("76","100","rub","png");
INSERT INTO sc_all_vip VALUES("77","100","rub","png");
INSERT INTO sc_all_vip VALUES("78","100","rub","gif");
INSERT INTO sc_all_vip VALUES("79","100","rub","png");
INSERT INTO sc_all_vip VALUES("128","100","rub","gif");
INSERT INTO sc_all_vip VALUES("81","100","rub","gif");
INSERT INTO sc_all_vip VALUES("82","100","rub","png");
INSERT INTO sc_all_vip VALUES("83","100","rub","png");
INSERT INTO sc_all_vip VALUES("84","100","rub","png");
INSERT INTO sc_all_vip VALUES("85","100","rub","gif");
INSERT INTO sc_all_vip VALUES("86","100","rub","png");
INSERT INTO sc_all_vip VALUES("87","100","rub","png");
INSERT INTO sc_all_vip VALUES("88","100","rub","gif");
INSERT INTO sc_all_vip VALUES("97","100","rub","png");
INSERT INTO sc_all_vip VALUES("98","100","rub","png");
INSERT INTO sc_all_vip VALUES("99","100","rub","png");
INSERT INTO sc_all_vip VALUES("100","100","rub","png");
INSERT INTO sc_all_vip VALUES("101","100","rub","png");
INSERT INTO sc_all_vip VALUES("103","100","money","png");
INSERT INTO sc_all_vip VALUES("104","100","rub","gif");
INSERT INTO sc_all_vip VALUES("105","100","rub","gif");
INSERT INTO sc_all_vip VALUES("106","100","rub","gif");
INSERT INTO sc_all_vip VALUES("107","100","rub","gif");
INSERT INTO sc_all_vip VALUES("108","100","rub","gif");
INSERT INTO sc_all_vip VALUES("317","100","rub","gif");
INSERT INTO sc_all_vip VALUES("110","100","rub","gif");
INSERT INTO sc_all_vip VALUES("111","100","rub","gif");
INSERT INTO sc_all_vip VALUES("112","100","rub","gif");
INSERT INTO sc_all_vip VALUES("113","100","rub","gif");
INSERT INTO sc_all_vip VALUES("114","100","rub","gif");
INSERT INTO sc_all_vip VALUES("115","100","rub","gif");
INSERT INTO sc_all_vip VALUES("116","100","rub","gif");
INSERT INTO sc_all_vip VALUES("117","100","rub","gif");
INSERT INTO sc_all_vip VALUES("118","100","rub","gif");
INSERT INTO sc_all_vip VALUES("119","100","rub","gif");
INSERT INTO sc_all_vip VALUES("120","100","rub","gif");
INSERT INTO sc_all_vip VALUES("121","100","rub","gif");
INSERT INTO sc_all_vip VALUES("122","100","rub","gif");
INSERT INTO sc_all_vip VALUES("123","100","rub","gif");
INSERT INTO sc_all_vip VALUES("124","100","rub","gif");
INSERT INTO sc_all_vip VALUES("125","100","rub","gif");
INSERT INTO sc_all_vip VALUES("126","100","rub","gif");
INSERT INTO sc_all_vip VALUES("127","100","rub","png");
INSERT INTO sc_all_vip VALUES("129","100","rub","gif");
INSERT INTO sc_all_vip VALUES("134","100","rub","gif");
INSERT INTO sc_all_vip VALUES("133","100","rub","gif");
INSERT INTO sc_all_vip VALUES("132","100","rub","gif");
INSERT INTO sc_all_vip VALUES("135","100","rub","gif");
INSERT INTO sc_all_vip VALUES("136","100","rub","gif");
INSERT INTO sc_all_vip VALUES("137","100","rub","png");
INSERT INTO sc_all_vip VALUES("138","100","rub","png");
INSERT INTO sc_all_vip VALUES("139","100","rub","gif");
INSERT INTO sc_all_vip VALUES("140","100","rub","gif");
INSERT INTO sc_all_vip VALUES("141","100","rub","png");
INSERT INTO sc_all_vip VALUES("142","100","rub","gif");
INSERT INTO sc_all_vip VALUES("143","100","rub","gif");
INSERT INTO sc_all_vip VALUES("144","100","rub","gif");
INSERT INTO sc_all_vip VALUES("145","100","rub","png");
INSERT INTO sc_all_vip VALUES("151","100","rub","gif");
INSERT INTO sc_all_vip VALUES("147","100","rub","gif");
INSERT INTO sc_all_vip VALUES("148","100","rub","gif");
INSERT INTO sc_all_vip VALUES("150","100","rub","gif");
INSERT INTO sc_all_vip VALUES("152","100","rub","png");
INSERT INTO sc_all_vip VALUES("153","100","rub","gif");
INSERT INTO sc_all_vip VALUES("154","100","rub","gif");
INSERT INTO sc_all_vip VALUES("155","100","rub","gif");
INSERT INTO sc_all_vip VALUES("156","100","rub","gif");
INSERT INTO sc_all_vip VALUES("157","100","rub","gif");
INSERT INTO sc_all_vip VALUES("158","100","rub","png");
INSERT INTO sc_all_vip VALUES("159","100","rub","gif");
INSERT INTO sc_all_vip VALUES("160","100","rub","gif");
INSERT INTO sc_all_vip VALUES("161","100","rub","gif");
INSERT INTO sc_all_vip VALUES("162","100","rub","gif");
INSERT INTO sc_all_vip VALUES("163","100","rub","gif");
INSERT INTO sc_all_vip VALUES("164","100","rub","gif");
INSERT INTO sc_all_vip VALUES("165","100","rub","gif");
INSERT INTO sc_all_vip VALUES("166","100","rub","gif");
INSERT INTO sc_all_vip VALUES("167","100","rub","gif");
INSERT INTO sc_all_vip VALUES("168","100","rub","png");
INSERT INTO sc_all_vip VALUES("169","100","rub","png");
INSERT INTO sc_all_vip VALUES("170","100","rub","png");
INSERT INTO sc_all_vip VALUES("171","100","rub","png");
INSERT INTO sc_all_vip VALUES("172","100","rub","gif");
INSERT INTO sc_all_vip VALUES("173","100","rub","png");
INSERT INTO sc_all_vip VALUES("174","100","rub","gif");
INSERT INTO sc_all_vip VALUES("175","100","rub","gif");
INSERT INTO sc_all_vip VALUES("176","100","rub","gif");
INSERT INTO sc_all_vip VALUES("177","100","rub","gif");
INSERT INTO sc_all_vip VALUES("178","100","rub","gif");
INSERT INTO sc_all_vip VALUES("179","100","rub","gif");
INSERT INTO sc_all_vip VALUES("180","100","rub","gif");
INSERT INTO sc_all_vip VALUES("184","100","rub","gif");
INSERT INTO sc_all_vip VALUES("182","100","rub","gif");
INSERT INTO sc_all_vip VALUES("183","100","rub","gif");
INSERT INTO sc_all_vip VALUES("185","100","rub","gif");
INSERT INTO sc_all_vip VALUES("186","100","rub","gif");
INSERT INTO sc_all_vip VALUES("187","100","rub","gif");
INSERT INTO sc_all_vip VALUES("188","100","rub","gif");
INSERT INTO sc_all_vip VALUES("189","100","rub","gif");
INSERT INTO sc_all_vip VALUES("190","100","rub","gif");
INSERT INTO sc_all_vip VALUES("191","100","rub","png");
INSERT INTO sc_all_vip VALUES("192","100","rub","png");
INSERT INTO sc_all_vip VALUES("193","100","rub","png");
INSERT INTO sc_all_vip VALUES("194","100","rub","gif");
INSERT INTO sc_all_vip VALUES("195","100","rub","gif");
INSERT INTO sc_all_vip VALUES("196","100","rub","gif");
INSERT INTO sc_all_vip VALUES("197","100","rub","gif");
INSERT INTO sc_all_vip VALUES("198","100","rub","gif");
INSERT INTO sc_all_vip VALUES("199","100","rub","png");
INSERT INTO sc_all_vip VALUES("200","100","rub","gif");
INSERT INTO sc_all_vip VALUES("201","100","rub","gif");
INSERT INTO sc_all_vip VALUES("202","100","rub","gif");
INSERT INTO sc_all_vip VALUES("203","100","rub","gif");
INSERT INTO sc_all_vip VALUES("204","100","rub","png");
INSERT INTO sc_all_vip VALUES("205","100","rub","gif");
INSERT INTO sc_all_vip VALUES("206","100","rub","gif");
INSERT INTO sc_all_vip VALUES("207","100","rub","gif");
INSERT INTO sc_all_vip VALUES("208","100","rub","gif");
INSERT INTO sc_all_vip VALUES("209","100","rub","gif");
INSERT INTO sc_all_vip VALUES("210","100","rub","gif");
INSERT INTO sc_all_vip VALUES("211","100","rub","gif");
INSERT INTO sc_all_vip VALUES("212","100","rub","gif");
INSERT INTO sc_all_vip VALUES("213","100","rub","gif");
INSERT INTO sc_all_vip VALUES("214","100","rub","gif");
INSERT INTO sc_all_vip VALUES("215","100","rub","gif");
INSERT INTO sc_all_vip VALUES("216","100","rub","gif");
INSERT INTO sc_all_vip VALUES("217","100","rub","gif");
INSERT INTO sc_all_vip VALUES("218","100","rub","gif");
INSERT INTO sc_all_vip VALUES("219","100","rub","gif");
INSERT INTO sc_all_vip VALUES("220","100","rub","gif");
INSERT INTO sc_all_vip VALUES("221","100","rub","gif");
INSERT INTO sc_all_vip VALUES("222","100","rub","gif");
INSERT INTO sc_all_vip VALUES("223","100","rub","gif");
INSERT INTO sc_all_vip VALUES("224","100","rub","gif");
INSERT INTO sc_all_vip VALUES("225","100","rub","gif");
INSERT INTO sc_all_vip VALUES("226","100","rub","gif");
INSERT INTO sc_all_vip VALUES("227","100","rub","gif");
INSERT INTO sc_all_vip VALUES("228","100","rub","gif");
INSERT INTO sc_all_vip VALUES("229","100","rub","gif");
INSERT INTO sc_all_vip VALUES("230","100","rub","gif");
INSERT INTO sc_all_vip VALUES("231","100","rub","gif");
INSERT INTO sc_all_vip VALUES("232","100","rub","gif");
INSERT INTO sc_all_vip VALUES("233","100","rub","gif");
INSERT INTO sc_all_vip VALUES("234","100","rub","gif");
INSERT INTO sc_all_vip VALUES("235","100","rub","gif");
INSERT INTO sc_all_vip VALUES("236","100","rub","gif");
INSERT INTO sc_all_vip VALUES("237","100","rub","gif");
INSERT INTO sc_all_vip VALUES("243","100","rub","gif");
INSERT INTO sc_all_vip VALUES("239","100","rub","gif");
INSERT INTO sc_all_vip VALUES("240","100","rub","gif");
INSERT INTO sc_all_vip VALUES("242","100","rub","png");
INSERT INTO sc_all_vip VALUES("244","100","rub","gif");
INSERT INTO sc_all_vip VALUES("245","100","rub","gif");
INSERT INTO sc_all_vip VALUES("246","100","rub","gif");
INSERT INTO sc_all_vip VALUES("247","100","rub","gif");
INSERT INTO sc_all_vip VALUES("248","100","rub","gif");
INSERT INTO sc_all_vip VALUES("249","100","rub","png");
INSERT INTO sc_all_vip VALUES("250","100","rub","png");
INSERT INTO sc_all_vip VALUES("251","100","rub","png");
INSERT INTO sc_all_vip VALUES("252","100","rub","png");
INSERT INTO sc_all_vip VALUES("253","100","rub","png");
INSERT INTO sc_all_vip VALUES("254","100","rub","png");
INSERT INTO sc_all_vip VALUES("255","100","rub","png");
INSERT INTO sc_all_vip VALUES("256","100","rub","gif");
INSERT INTO sc_all_vip VALUES("257","100","rub","gif");
INSERT INTO sc_all_vip VALUES("258","100","rub","png");
INSERT INTO sc_all_vip VALUES("259","100","rub","png");
INSERT INTO sc_all_vip VALUES("260","100","rub","gif");
INSERT INTO sc_all_vip VALUES("261","100","rub","png");
INSERT INTO sc_all_vip VALUES("262","100","rub","gif");
INSERT INTO sc_all_vip VALUES("263","100","rub","gif");
INSERT INTO sc_all_vip VALUES("264","100","rub","gif");
INSERT INTO sc_all_vip VALUES("265","100","rub","png");
INSERT INTO sc_all_vip VALUES("266","100","rub","gif");
INSERT INTO sc_all_vip VALUES("267","100","rub","png");
INSERT INTO sc_all_vip VALUES("268","100","rub","png");
INSERT INTO sc_all_vip VALUES("269","100","rub","gif");
INSERT INTO sc_all_vip VALUES("270","100","rub","gif");
INSERT INTO sc_all_vip VALUES("271","100","rub","png");
INSERT INTO sc_all_vip VALUES("272","100","rub","png");
INSERT INTO sc_all_vip VALUES("273","100","rub","png");
INSERT INTO sc_all_vip VALUES("274","100","rub","png");
INSERT INTO sc_all_vip VALUES("275","100","rub","png");
INSERT INTO sc_all_vip VALUES("276","100","rub","png");
INSERT INTO sc_all_vip VALUES("277","100","rub","png");
INSERT INTO sc_all_vip VALUES("278","100","rub","gif");
INSERT INTO sc_all_vip VALUES("279","100","rub","png");
INSERT INTO sc_all_vip VALUES("280","100","rub","gif");
INSERT INTO sc_all_vip VALUES("281","100","rub","gif");
INSERT INTO sc_all_vip VALUES("282","100","rub","png");
INSERT INTO sc_all_vip VALUES("285","100","rub","png");
INSERT INTO sc_all_vip VALUES("287","100","rub","gif");
INSERT INTO sc_all_vip VALUES("288","100","rub","gif");
INSERT INTO sc_all_vip VALUES("290","101","rub","gif");
INSERT INTO sc_all_vip VALUES("293","100","rub","gif");
INSERT INTO sc_all_vip VALUES("294","100","rub","gif");
INSERT INTO sc_all_vip VALUES("295","100","rub","gif");
INSERT INTO sc_all_vip VALUES("296","100","rub","gif");
INSERT INTO sc_all_vip VALUES("297","100","rub","gif");
INSERT INTO sc_all_vip VALUES("298","100","rub","gif");
INSERT INTO sc_all_vip VALUES("300","200","rub","gif");
INSERT INTO sc_all_vip VALUES("301","200","rub","gif");
INSERT INTO sc_all_vip VALUES("302","100","rub","gif");
INSERT INTO sc_all_vip VALUES("303","100","rub","gif");
INSERT INTO sc_all_vip VALUES("304","100","rub","png");
INSERT INTO sc_all_vip VALUES("305","100","rub","gif");
INSERT INTO sc_all_vip VALUES("306","100","rub","gif");
INSERT INTO sc_all_vip VALUES("307","100","rub","gif");
INSERT INTO sc_all_vip VALUES("308","100","rub","gif");
INSERT INTO sc_all_vip VALUES("309","100","rub","gif");
INSERT INTO sc_all_vip VALUES("310","100","rub","gif");
INSERT INTO sc_all_vip VALUES("311","100","rub","gif");
INSERT INTO sc_all_vip VALUES("312","100","rub","gif");
INSERT INTO sc_all_vip VALUES("313","100","rub","gif");
INSERT INTO sc_all_vip VALUES("314","100","rub","gif");
INSERT INTO sc_all_vip VALUES("315","100","rub","gif");
INSERT INTO sc_all_vip VALUES("316","100","rub","png");
INSERT INTO sc_all_vip VALUES("319","100","rub","gif");
INSERT INTO sc_all_vip VALUES("320","100","rub","gif");
INSERT INTO sc_all_vip VALUES("321","100","rub","gif");
INSERT INTO sc_all_vip VALUES("322","100","rub","gif");
INSERT INTO sc_all_vip VALUES("323","100","rub","png");
INSERT INTO sc_all_vip VALUES("324","100","rub","gif");
INSERT INTO sc_all_vip VALUES("325","100","rub","png");
INSERT INTO sc_all_vip VALUES("326","100","rub","gif");
INSERT INTO sc_all_vip VALUES("327","100","rub","gif");
INSERT INTO sc_all_vip VALUES("328","100","rub","gif");
INSERT INTO sc_all_vip VALUES("329","100","rub","gif");
INSERT INTO sc_all_vip VALUES("330","100","rub","gif");
INSERT INTO sc_all_vip VALUES("331","100","rub","gif");
INSERT INTO sc_all_vip VALUES("332","100","rub","gif");
INSERT INTO sc_all_vip VALUES("333","100","rub","gif");
INSERT INTO sc_all_vip VALUES("334","100","rub","gif");
INSERT INTO sc_all_vip VALUES("335","100","rub","gif");
INSERT INTO sc_all_vip VALUES("336","100","rub","gif");
INSERT INTO sc_all_vip VALUES("337","100","rub","gif");
INSERT INTO sc_all_vip VALUES("338","100","rub","gif");
INSERT INTO sc_all_vip VALUES("339","100","rub","png");
INSERT INTO sc_all_vip VALUES("340","100","rub","png");
INSERT INTO sc_all_vip VALUES("341","100","rub","png");
INSERT INTO sc_all_vip VALUES("342","100","rub","gif");
INSERT INTO sc_all_vip VALUES("343","100","rub","gif");
INSERT INTO sc_all_vip VALUES("344","100","rub","png");
INSERT INTO sc_all_vip VALUES("345","100","rub","gif");
INSERT INTO sc_all_vip VALUES("346","100","rub","gif");
INSERT INTO sc_all_vip VALUES("347","100","rub","gif");
INSERT INTO sc_all_vip VALUES("348","100","rub","png");
INSERT INTO sc_all_vip VALUES("349","100","rub","png");
INSERT INTO sc_all_vip VALUES("350","100","rub","png");
INSERT INTO sc_all_vip VALUES("351","100","rub","gif");
INSERT INTO sc_all_vip VALUES("352","100","rub","gif");
INSERT INTO sc_all_vip VALUES("353","100","rub","png");
INSERT INTO sc_all_vip VALUES("354","100","rub","gif");
INSERT INTO sc_all_vip VALUES("355","100","rub","gif");
INSERT INTO sc_all_vip VALUES("356","100","rub","png");
INSERT INTO sc_all_vip VALUES("357","100","rub","png");
INSERT INTO sc_all_vip VALUES("358","100","rub","gif");
INSERT INTO sc_all_vip VALUES("359","100","rub","png");
INSERT INTO sc_all_vip VALUES("360","100","rub","png");
INSERT INTO sc_all_vip VALUES("361","100","rub","png");
INSERT INTO sc_all_vip VALUES("362","100","rub","gif");
INSERT INTO sc_all_vip VALUES("363","100","rub","gif");
INSERT INTO sc_all_vip VALUES("364","100","rub","gif");
INSERT INTO sc_all_vip VALUES("365","100","rub","gif");
INSERT INTO sc_all_vip VALUES("366","100","rub","gif");
INSERT INTO sc_all_vip VALUES("367","100","rub","gif");
INSERT INTO sc_all_vip VALUES("368","100","rub","gif");
INSERT INTO sc_all_vip VALUES("369","100","rub","gif");
INSERT INTO sc_all_vip VALUES("370","100","rub","gif");
INSERT INTO sc_all_vip VALUES("371","100","rub","png");
INSERT INTO sc_all_vip VALUES("372","100","rub","gif");
INSERT INTO sc_all_vip VALUES("373","100","rub","gif");
INSERT INTO sc_all_vip VALUES("374","100","rub","gif");
INSERT INTO sc_all_vip VALUES("375","100","rub","gif");
INSERT INTO sc_all_vip VALUES("376","100","rub","gif");
INSERT INTO sc_all_vip VALUES("377","100","rub","gif");
INSERT INTO sc_all_vip VALUES("378","100","rub","gif");
INSERT INTO sc_all_vip VALUES("379","100","rub","gif");
INSERT INTO sc_all_vip VALUES("380","100","rub","png");
INSERT INTO sc_all_vip VALUES("381","100","rub","png");
INSERT INTO sc_all_vip VALUES("382","100","rub","png");
INSERT INTO sc_all_vip VALUES("383","100","rub","gif");
INSERT INTO sc_all_vip VALUES("384","100","rub","png");
INSERT INTO sc_all_vip VALUES("385","100","rub","png");
INSERT INTO sc_all_vip VALUES("386","100","rub","png");
INSERT INTO sc_all_vip VALUES("387","100","rub","gif");
INSERT INTO sc_all_vip VALUES("388","100","rub","gif");



DROP TABLE IF EXISTS `setting`;

CREATE TABLE `setting` (
  `ids` int(1) NOT NULL DEFAULT '1',
  `open_chat` smallint(1) NOT NULL DEFAULT '1',
  `on_rekl` smallint(1) NOT NULL DEFAULT '0',
  `text_rekl` char(50) NOT NULL,
  `antimat` smallint(2) NOT NULL DEFAULT '0',
  `fo_moder` smallint(2) NOT NULL DEFAULT '0',
  `fo_limit` int(11) NOT NULL DEFAULT '2048',
  PRIMARY KEY (`ids`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO setting VALUES("1","1","0","[Реклама]","0","0","500");



DROP TABLE IF EXISTS `sexwars`;

CREATE TABLE `sexwars` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `time_end` int(11) DEFAULT '0',
  `male` int(11) DEFAULT '0',
  `female` int(11) DEFAULT '0',
  `win` varchar(128) DEFAULT '0',
  `active` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=54 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sexwars_chat`;

CREATE TABLE `sexwars_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_tournament` int(11) DEFAULT '0',
  `sex` varchar(12) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sexwars_users`;

CREATE TABLE `sexwars_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `level` int(11) DEFAULT '0',
  `sex` varchar(32) NOT NULL DEFAULT 'male',
  `rating` int(11) DEFAULT '0',
  `time_reboot` int(11) DEFAULT '0',
  `count_weapon` int(11) DEFAULT '0',
  `count_win` int(11) DEFAULT '0',
  `count_loss` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=86 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `sexwars_weapons`;

CREATE TABLE `sexwars_weapons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  `id_weapon` int(11) DEFAULT '1',
  `type` varchar(32) DEFAULT 'tomate',
  `style` varchar(512) DEFAULT '',
  `sex` varchar(128) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6779 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `skachki`;

CREATE TABLE `skachki` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `info` varchar(500) NOT NULL,
  `active` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `winner` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8;

INSERT INTO skachki VALUES("1","Байга","Играем и побеждаем","0","1593462791","1");
INSERT INTO skachki VALUES("3","Кабанчиком к Финишу","Вперед за орденами","1","1595304517","0");



DROP TABLE IF EXISTS `skachki_user`;

CREATE TABLE `skachki_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `type` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_skachka` int(11) NOT NULL,
  `golos` int(11) NOT NULL,
  `pol` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=26 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `skachki_user_golos`;

CREATE TABLE `skachki_user_golos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `id_skachka` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=78 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `slot_pasik_fc`;

CREATE TABLE `slot_pasik_fc` (
  `id_user` int(11) NOT NULL,
  `win` int(11) DEFAULT '0',
  `loss` int(1) DEFAULT '0',
  `j_money` int(1) DEFAULT '0',
  `j_count` int(1) DEFAULT '0',
  PRIMARY KEY (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `smile`;

CREATE TABLE `smile` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `smile` varchar(64) NOT NULL,
  `dir` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6209 DEFAULT CHARSET=utf8;

INSERT INTO smile VALUES("3",".2сердца.","11");
INSERT INTO smile VALUES("18",".кис.","11");
INSERT INTO smile VALUES("4",".амур.","11");
INSERT INTO smile VALUES("5",".бананы.","11");
INSERT INTO smile VALUES("6",".целует.","11");
INSERT INTO smile VALUES("7",".чмок.","11");
INSERT INTO smile VALUES("8",".чмок2.","11");
INSERT INTO smile VALUES("9",".дев.","11");
INSERT INTO smile VALUES("10",".дарюсерд.","11");
INSERT INTO smile VALUES("11",".феминистка.","11");
INSERT INTO smile VALUES("12",".флирт.","11");
INSERT INTO smile VALUES("13",".флирт2.","11");
INSERT INTO smile VALUES("14",".глазавглаза.","11");
INSERT INTO smile VALUES("17",".качели.","11");
INSERT INTO smile VALUES("19",".кис2.","11");
INSERT INTO smile VALUES("20",".кис3.","11");
INSERT INTO smile VALUES("21",".краситгуб.","11");
INSERT INTO smile VALUES("22",".кружит.","11");
INSERT INTO smile VALUES("24",".лассо.","11");
INSERT INTO smile VALUES("25",".лесби.","11");
INSERT INTO smile VALUES("26",".любовь.","11");
INSERT INTO smile VALUES("28",".лягушка.","11");
INSERT INTO smile VALUES("29",".лягушка2.","11");
INSERT INTO smile VALUES("30",".м.","11");
INSERT INTO smile VALUES("31",".манюта.","11");
INSERT INTO smile VALUES("32",".мишка.","11");
INSERT INTO smile VALUES("44",".нравится.","11");
INSERT INTO smile VALUES("43",".нежно.","11");
INSERT INTO smile VALUES("45",".обнимки.","11");
INSERT INTO smile VALUES("46",".пинк.","11");
INSERT INTO smile VALUES("47",".поцц1.","11");
INSERT INTO smile VALUES("48",".подмиг2.","11");
INSERT INTO smile VALUES("49",".покраснела.","11");
INSERT INTO smile VALUES("50",".порукам3.","11");
INSERT INTO smile VALUES("51",".пшаг.","11");
INSERT INTO smile VALUES("52",".рисует.","11");
INSERT INTO smile VALUES("53",".счастливые.","11");
INSERT INTO smile VALUES("54",".секс.","11");
INSERT INTO smile VALUES("55",".секс2.","11");
INSERT INTO smile VALUES("56",".сердце.","11");
INSERT INTO smile VALUES("57",".сердце2.","11");
INSERT INTO smile VALUES("58",".сердце3.","11");
INSERT INTO smile VALUES("59",".серенада.","11");
INSERT INTO smile VALUES("60",".щекочет.","11");
INSERT INTO smile VALUES("61",".стеснит.","11");
INSERT INTO smile VALUES("62",".стеснит2.","11");
INSERT INTO smile VALUES("63",".стрела2.","11");
INSERT INTO smile VALUES("64",".танцуют.","11");
INSERT INTO smile VALUES("65",".вкусно.","11");
INSERT INTO smile VALUES("66",".воздпоц.","11");
INSERT INTO smile VALUES("67",".вруку.","11");
INSERT INTO smile VALUES("68",".взасос.","11");
INSERT INTO smile VALUES("69",".йоу.","11");
INSERT INTO smile VALUES("70",".заруки.","11");
INSERT INTO smile VALUES("78",".бис.","20");
INSERT INTO smile VALUES("77",".ах.","20");
INSERT INTO smile VALUES("76",".ааа.","20");
INSERT INTO smile VALUES("79",".бла.","20");
INSERT INTO smile VALUES("80",".бла2.","20");
INSERT INTO smile VALUES("82",".браво3.","20");
INSERT INTO smile VALUES("83",".бур2.","20");
INSERT INTO smile VALUES("84",".кул.","20");
INSERT INTO smile VALUES("85",".дик.","20");
INSERT INTO smile VALUES("86",".доволен.","20");
INSERT INTO smile VALUES("87",".доволен2.","20");
INSERT INTO smile VALUES("88",".доволен4.","20");
INSERT INTO smile VALUES("89",".дум.","20");
INSERT INTO smile VALUES("90",".думает.","20");
INSERT INTO smile VALUES("92",".финг.","20");
INSERT INTO smile VALUES("1184",".сердит.","21");
INSERT INTO smile VALUES("94",".фу.","20");
INSERT INTO smile VALUES("95",".фуу.","20");
INSERT INTO smile VALUES("96",".глаза.","20");
INSERT INTO smile VALUES("97",".глазами.","20");
INSERT INTO smile VALUES("98",".глаза2.","20");
INSERT INTO smile VALUES("99",".го.","20");
INSERT INTO smile VALUES("100",".гордо.","20");
INSERT INTO smile VALUES("101",".грустит.","20");
INSERT INTO smile VALUES("103",".хм.","20");
INSERT INTO smile VALUES("104",".хнык.","20");
INSERT INTO smile VALUES("105",".идея.","20");
INSERT INTO smile VALUES("106",".идея2.","20");
INSERT INTO smile VALUES("107",".ик2.","20");
INSERT INTO smile VALUES("108",".испуг.","20");
INSERT INTO smile VALUES("109",".истерика.","20");
INSERT INTO smile VALUES("110",".яху.","20");
INSERT INTO smile VALUES("111",".ех2.","20");
INSERT INTO smile VALUES("112",".красн.","20");
INSERT INTO smile VALUES("113",".крик.","20");
INSERT INTO smile VALUES("114",".лол2.","20");
INSERT INTO smile VALUES("115",".лол.","20");
INSERT INTO smile VALUES("116",".мат.","20");
INSERT INTO smile VALUES("117",".мда.","20");
INSERT INTO smile VALUES("118",".молча.","20");
INSERT INTO smile VALUES("119",".нагло.","20");
INSERT INTO smile VALUES("120",".наис.","20");
INSERT INTO smile VALUES("121",".нервы.","20");
INSERT INTO smile VALUES("122",".нет.","20");
INSERT INTO smile VALUES("123",".невозм.","20");
INSERT INTO smile VALUES("124",".нея.","20");
INSERT INTO smile VALUES("125",".нифига.","20");
INSERT INTO smile VALUES("126",".но.","20");
INSERT INTO smile VALUES("127",".новичек.","20");
INSERT INTO smile VALUES("128",".совсем.","20");
INSERT INTO smile VALUES("129",".ням.","20");
INSERT INTO smile VALUES("130",".обижен.","20");
INSERT INTO smile VALUES("131",".обижена.","20");
INSERT INTO smile VALUES("132",".оченьдоволен.","20");
INSERT INTO smile VALUES("133",".охбой.","20");
INSERT INTO smile VALUES("134",".ок.","20");
INSERT INTO smile VALUES("135",".окно.","20");
INSERT INTO smile VALUES("136",".ор.","20");
INSERT INTO smile VALUES("137",".отрыв.","20");
INSERT INTO smile VALUES("138",".отстой.","20");
INSERT INTO smile VALUES("139",".пардон.","20");
INSERT INTO smile VALUES("140",".пардон2.","20");
INSERT INTO smile VALUES("141",".пасиба.","20");
INSERT INTO smile VALUES("142",".плачет.","20");
INSERT INTO smile VALUES("143",".плачет2.","20");
INSERT INTO smile VALUES("144",".плак.","20");
INSERT INTO smile VALUES("145",".плакса.","20");
INSERT INTO smile VALUES("146",".плющит.","20");
INSERT INTO smile VALUES("147",".поцелуй2.","20");
INSERT INTO smile VALUES("148",".подмиг.","20");
INSERT INTO smile VALUES("149",".подморг.","20");
INSERT INTO smile VALUES("150",".пох.","20");
INSERT INTO smile VALUES("151",".поймал.","20");
INSERT INTO smile VALUES("152",".пока2.","20");
INSERT INTO smile VALUES("153",".поклон.","20");
INSERT INTO smile VALUES("154",".носвис.","20");
INSERT INTO smile VALUES("173",".сонно.","20");
INSERT INTO smile VALUES("174",".сорри.","20");
INSERT INTO smile VALUES("175",".стеснит3.","20");
INSERT INTO smile VALUES("176",".сюрприз.","20");
INSERT INTO smile VALUES("177",".свист.","20");
INSERT INTO smile VALUES("178",".танцует.","20");
INSERT INTO smile VALUES("179",".танц.","20");
INSERT INTO smile VALUES("180",".тонгуе.","20");
INSERT INTO smile VALUES("181",".удивлен.","20");
INSERT INTO smile VALUES("182",".ура2.","20");
INSERT INTO smile VALUES("183",".уснул.","20");
INSERT INTO smile VALUES("184",".устал.","20");
INSERT INTO smile VALUES("185",".весело.","20");
INSERT INTO smile VALUES("186",".волнуется.","20");
INSERT INTO smile VALUES("187",".вопрос.","20");
INSERT INTO smile VALUES("188",".восадок.","20");
INSERT INTO smile VALUES("189",".шинк.","20");
INSERT INTO smile VALUES("190",".шутка.","20");
INSERT INTO smile VALUES("191",".язык.","20");
INSERT INTO smile VALUES("192",".еа.","20");
INSERT INTO smile VALUES("193",".жарко.","20");
INSERT INTO smile VALUES("194",".жду.","20");
INSERT INTO smile VALUES("195",".жду2.","20");
INSERT INTO smile VALUES("196",".злой.","20");
INSERT INTO smile VALUES("197",".злой2.","20");
INSERT INTO smile VALUES("198",".злой3.","20");
INSERT INTO smile VALUES("199",".звезды.","20");
INSERT INTO smile VALUES("200",".злой4.","20");
INSERT INTO smile VALUES("201",".звезды2.","20");
INSERT INTO smile VALUES("202",".звезды3.","20");
INSERT INTO smile VALUES("206",".дискета.","18");
INSERT INTO smile VALUES("207",".ф1.","18");
INSERT INTO smile VALUES("208",".ф2.","18");
INSERT INTO smile VALUES("209",".кпк.","18");
INSERT INTO smile VALUES("210",".машинист.","18");
INSERT INTO smile VALUES("211",".мото.","18");
INSERT INTO smile VALUES("212",".налодке.","18");
INSERT INTO smile VALUES("213",".намото.","18");
INSERT INTO smile VALUES("214",".ноут.","18");
INSERT INTO smile VALUES("215",".паровоз.","18");
INSERT INTO smile VALUES("216",".паровоз2.","18");
INSERT INTO smile VALUES("217",".самолет.","18");
INSERT INTO smile VALUES("218",".самолет2.","18");
INSERT INTO smile VALUES("219",".шар.","18");
INSERT INTO smile VALUES("220",".скутер.","18");
INSERT INTO smile VALUES("221",".тачка.","18");
INSERT INTO smile VALUES("222",".танк.","18");
INSERT INTO smile VALUES("223",".вело.","18");
INSERT INTO smile VALUES("224",".вентилятор.","18");
INSERT INTO smile VALUES("225",".закомпом.","18");
INSERT INTO smile VALUES("226",".закомпом2.","18");
INSERT INTO smile VALUES("227",".закомпом3.","18");
INSERT INTO smile VALUES("228",".монитор.","18");
INSERT INTO smile VALUES("229",".монитор2.","18");
INSERT INTO smile VALUES("247",".ангел4.","10");
INSERT INTO smile VALUES("248",".бай.","10");
INSERT INTO smile VALUES("249",".бан.","10");
INSERT INTO smile VALUES("250",".билайн.","10");
INSERT INTO smile VALUES("251",".пост.","10");
INSERT INTO smile VALUES("252",".гугл.","10");
INSERT INTO smile VALUES("253",".гугл2.","10");
INSERT INTO smile VALUES("254",".гугл3.","10");
INSERT INTO smile VALUES("255",".ася.","10");
INSERT INTO smile VALUES("256",".омг.","10");
INSERT INTO smile VALUES("257",".кисс.","10");
INSERT INTO smile VALUES("258",".кисми.","10");
INSERT INTO smile VALUES("259",".клева.","10");
INSERT INTO smile VALUES("260",".линк.","10");
INSERT INTO smile VALUES("261",".лин.","10");
INSERT INTO smile VALUES("262",".лол3.","10");
INSERT INTO smile VALUES("263",".спам.","10");
INSERT INTO smile VALUES("264",".джд.","10");
INSERT INTO smile VALUES("265",".опера.","10");
INSERT INTO smile VALUES("266",".опера2.","10");
INSERT INTO smile VALUES("267",".упс.","10");
INSERT INTO smile VALUES("268",".ошибочка.","10");
INSERT INTO smile VALUES("269",".перв.","10");
INSERT INTO smile VALUES("270",".пиванет.","10");
INSERT INTO smile VALUES("271",".каунт.","10");
INSERT INTO smile VALUES("272",".пс.","10");
INSERT INTO smile VALUES("273",".рок2.","10");
INSERT INTO smile VALUES("274",".русский.","10");
INSERT INTO smile VALUES("275",".сервис.","10");
INSERT INTO smile VALUES("276",".супер.","10");
INSERT INTO smile VALUES("277",".феньк.","10");
INSERT INTO smile VALUES("278",".транслит.","10");
INSERT INTO smile VALUES("279",".всемпр.","10");
INSERT INTO smile VALUES("280",".вт.","10");
INSERT INTO smile VALUES("281",".ыы.","10");
INSERT INTO smile VALUES("283",".ангел2.","4");
INSERT INTO smile VALUES("284",".ангел3.","4");
INSERT INTO smile VALUES("285",".череп.","4");
INSERT INTO smile VALUES("286",".демон.","4");
INSERT INTO smile VALUES("287",".френки.","4");
INSERT INTO smile VALUES("288",".гдевил.","4");
INSERT INTO smile VALUES("290",".мертвец.","4");
INSERT INTO smile VALUES("291",".молитва.","4");
INSERT INTO smile VALUES("292",".неангел.","4");
INSERT INTO smile VALUES("293",".скосой.","4");
INSERT INTO smile VALUES("295",".вампир2.","4");
INSERT INTO smile VALUES("296",".ведьма.","4");
INSERT INTO smile VALUES("297",".2пистолета.","5");
INSERT INTO smile VALUES("298",".асасин.","5");
INSERT INTO smile VALUES("299",".атата.","5");
INSERT INTO smile VALUES("300",".пила.","5");
INSERT INTO smile VALUES("301",".бомба.","5");
INSERT INTO smile VALUES("302",".бомба2.","5");
INSERT INTO smile VALUES("303",".драка.","5");
INSERT INTO smile VALUES("304",".гранатомет.","5");
INSERT INTO smile VALUES("305",".хрясь.","5");
INSERT INTO smile VALUES("306",".карате.","5");
INSERT INTO smile VALUES("307",".лучник.","5");
INSERT INTO smile VALUES("308",".молотком.","5");
INSERT INTO smile VALUES("309",".нож.","5");
INSERT INTO smile VALUES("310",".орк.","5");
INSERT INTO smile VALUES("311",".палач.","5");
INSERT INTO smile VALUES("312",".паладин.","5");
INSERT INTO smile VALUES("313",".пифпаф.","5");
INSERT INTO smile VALUES("314",".пистолеты.","5");
INSERT INTO smile VALUES("315",".поголове.","5");
INSERT INTO smile VALUES("316",".попопе.","5");
INSERT INTO smile VALUES("317",".пушки.","5");
INSERT INTO smile VALUES("318",".руссолдат.","5");
INSERT INTO smile VALUES("319",".стар.","5");
INSERT INTO smile VALUES("320",".варвар.","5");
INSERT INTO smile VALUES("321",".вглаз.","5");
INSERT INTO smile VALUES("322",".винсент.","5");
INSERT INTO smile VALUES("323",".висит.","5");
INSERT INTO smile VALUES("324",".висит2.","5");
INSERT INTO smile VALUES("325",".виселица.","5");
INSERT INTO smile VALUES("326",".шахиды.","5");
INSERT INTO smile VALUES("327",".закосу.","5");
INSERT INTO smile VALUES("328",".сдаюсь.","5");
INSERT INTO smile VALUES("1185",":)","21");
INSERT INTO smile VALUES("331","=)","21");
INSERT INTO smile VALUES("344",".дедвнучка.","13");
INSERT INTO smile VALUES("345",".елка.","13");
INSERT INTO smile VALUES("346",".елка2.","13");
INSERT INTO smile VALUES("347",".гоблин.","13");
INSERT INTO smile VALUES("348",".мороз2.","13");
INSERT INTO smile VALUES("349",".ньюеар.","13");
INSERT INTO smile VALUES("351",".салют.","13");
INSERT INTO smile VALUES("352",".санта.","13");
INSERT INTO smile VALUES("353",".санта2.","13");
INSERT INTO smile VALUES("354",".санта3.","13");
INSERT INTO smile VALUES("355",".санта4.","13");
INSERT INTO smile VALUES("356",".щелкун.","13");
INSERT INTO smile VALUES("357",".снеговик.","13");
INSERT INTO smile VALUES("358",".снегур.","13");
INSERT INTO smile VALUES("359",".снегур2.","13");
INSERT INTO smile VALUES("360",".снежок.","13");
INSERT INTO smile VALUES("361",".хмас.","13");
INSERT INTO smile VALUES("362",".замерзла.","13");
INSERT INTO smile VALUES("363",".зима.","13");
INSERT INTO smile VALUES("364",".аллергия.","6");
INSERT INTO smile VALUES("365",".циклоп.","6");
INSERT INTO smile VALUES("366",".стена.","6");
INSERT INTO smile VALUES("367",".стена2.","6");
INSERT INTO smile VALUES("368",".стена3.","6");
INSERT INTO smile VALUES("369",".гы.","6");
INSERT INTO smile VALUES("370",".гыы.","6");
INSERT INTO smile VALUES("371",".идиот.","6");
INSERT INTO smile VALUES("372",".идиот2.","6");
INSERT INTO smile VALUES("373",".нарк.","6");
INSERT INTO smile VALUES("374",".пилот.","6");
INSERT INTO smile VALUES("375",".пилот2.","6");
INSERT INTO smile VALUES("376",".повес.","6");
INSERT INTO smile VALUES("377",".русрулетка.","6");
INSERT INTO smile VALUES("378",".суицид.","6");
INSERT INTO smile VALUES("379",".суицид2.","6");
INSERT INTO smile VALUES("380",".тормоз.","6");
INSERT INTO smile VALUES("381",".пук.","6");
INSERT INTO smile VALUES("382",".шутник.","6");
INSERT INTO smile VALUES("383",".яд.","6");
INSERT INTO smile VALUES("384",".язык3.","6");
INSERT INTO smile VALUES("396",".алкаш.","7");
INSERT INTO smile VALUES("397",".алкаши.","7");
INSERT INTO smile VALUES("398",".алкоголик.","7");
INSERT INTO smile VALUES("399",".апельсин.","7");
INSERT INTO smile VALUES("400",".арбуз.","7");
INSERT INTO smile VALUES("401",".банка.","7");
INSERT INTO smile VALUES("402",".барб.","7");
INSERT INTO smile VALUES("403",".бокалы.","7");
INSERT INTO smile VALUES("404",".бутылки.","7");
INSERT INTO smile VALUES("405",".коктейль.","7");
INSERT INTO smile VALUES("406",".кофе2.","7");
INSERT INTO smile VALUES("407",".кофе.","7");
INSERT INTO smile VALUES("408",".дв.","7");
INSERT INTO smile VALUES("409",".ик.","7");
INSERT INTO smile VALUES("410",".катает.","7");
INSERT INTO smile VALUES("411",".кофе3.","7");
INSERT INTO smile VALUES("412",".коктел.","7");
INSERT INTO smile VALUES("413",".конфета.","7");
INSERT INTO smile VALUES("414",".конфета2.","7");
INSERT INTO smile VALUES("415",".кружки.","7");
INSERT INTO smile VALUES("416",".кушает.","7");
INSERT INTO smile VALUES("417",".кушает2.","7");
INSERT INTO smile VALUES("418",".лай.","7");
INSERT INTO smile VALUES("419",".леденец.","7");
INSERT INTO smile VALUES("420",".лимон.","7");
INSERT INTO smile VALUES("421",".морковка.","7");
INSERT INTO smile VALUES("422",".морож.","7");
INSERT INTO smile VALUES("423",".напиток.","7");
INSERT INTO smile VALUES("424",".огурюм.","7");
INSERT INTO smile VALUES("425",".палочки.","7");
INSERT INTO smile VALUES("426",".печенька2.","7");
INSERT INTO smile VALUES("427",".печенька.","7");
INSERT INTO smile VALUES("428",".пил.","7");
INSERT INTO smile VALUES("429",".пила.","7");
INSERT INTO smile VALUES("430",".пирож.","7");
INSERT INTO smile VALUES("431",".пиво.","7");
INSERT INTO smile VALUES("432",".пиво2.","7");
INSERT INTO smile VALUES("433",".пицца.","7");
INSERT INTO smile VALUES("434",".пицца2.","7");
INSERT INTO smile VALUES("435",".попкорн.","7");
INSERT INTO smile VALUES("436",".попиву.","7");
INSERT INTO smile VALUES("437",".попиву2.","7");
INSERT INTO smile VALUES("438",".повар.","7");
INSERT INTO smile VALUES("440",".рыбу.","7");
INSERT INTO smile VALUES("441",".смакует.","7");
INSERT INTO smile VALUES("442",".стакан.","7");
INSERT INTO smile VALUES("443",".торт.","7");
INSERT INTO smile VALUES("444",".тостер.","7");
INSERT INTO smile VALUES("445",".тостер2.","7");
INSERT INTO smile VALUES("446",".ага.","7");
INSERT INTO smile VALUES("447",".вилка.","7");
INSERT INTO smile VALUES("448",".вино.","7");
INSERT INTO smile VALUES("449",".вишня.","7");
INSERT INTO smile VALUES("450",".выпил.","7");
INSERT INTO smile VALUES("451",".шамп.","7");
INSERT INTO smile VALUES("452",".шоко.","7");
INSERT INTO smile VALUES("453",".яблоко.","7");
INSERT INTO smile VALUES("454",".жарит.","7");
INSERT INTO smile VALUES("455",".акула.","9");
INSERT INTO smile VALUES("456",".чебур.","9");
INSERT INTO smile VALUES("457",".червяк.","9");
INSERT INTO smile VALUES("458",".чудо.","9");
INSERT INTO smile VALUES("459",".чудо2.","9");
INSERT INTO smile VALUES("460",".чудо3.","9");
INSERT INTO smile VALUES("461",".чудо4.","9");
INSERT INTO smile VALUES("462",".чудо5.","9");
INSERT INTO smile VALUES("463",".чудо6.","9");
INSERT INTO smile VALUES("464",".цыпленок.","9");
INSERT INTO smile VALUES("465",".еж.","9");
INSERT INTO smile VALUES("466",".еж2.","9");
INSERT INTO smile VALUES("467",".еж3.","9");
INSERT INTO smile VALUES("468",".еж4.","9");
INSERT INTO smile VALUES("469",".гладит.","9");
INSERT INTO smile VALUES("470",".киса.","9");
INSERT INTO smile VALUES("471",".конь.","9");
INSERT INTO smile VALUES("472",".корова.","9");
INSERT INTO smile VALUES("473",".кот.","9");
INSERT INTO smile VALUES("474",".кот2.","9");
INSERT INTO smile VALUES("475",".кролик.","9");
INSERT INTO smile VALUES("476",".лев.","9");
INSERT INTO smile VALUES("477",".лев2.","9");
INSERT INTO smile VALUES("478",".лиса.","9");
INSERT INTO smile VALUES("479",".лось.","9");
INSERT INTO smile VALUES("480",".мишка2.","9");
INSERT INTO smile VALUES("481",".мышь.","9");
INSERT INTO smile VALUES("482",".мед.","9");
INSERT INTO smile VALUES("483",".мишка.","9");
INSERT INTO smile VALUES("484",".мишки.","9");
INSERT INTO smile VALUES("486",".нуся.","9");
INSERT INTO smile VALUES("487",".олень.","9");
INSERT INTO smile VALUES("488",".олень2.","9");
INSERT INTO smile VALUES("489",".олень3.","9");
INSERT INTO smile VALUES("490",".пакман.","9");
INSERT INTO smile VALUES("491",".папамишка.","9");
INSERT INTO smile VALUES("492",".паук.","9");
INSERT INTO smile VALUES("493",".пчела.","9");
INSERT INTO smile VALUES("494",".петух.","9");
INSERT INTO smile VALUES("495",".пингвин.","9");
INSERT INTO smile VALUES("496",".поголове2.","9");
INSERT INTO smile VALUES("497",".пришел.","9");
INSERT INTO smile VALUES("498",".пух.","9");
INSERT INTO smile VALUES("499",".пух1.","9");
INSERT INTO smile VALUES("500",".пух2.","9");
INSERT INTO smile VALUES("501",".пух3.","9");
INSERT INTO smile VALUES("502",".пухвис.","9");
INSERT INTO smile VALUES("503",".рак.","9");
INSERT INTO smile VALUES("504",".рыбка2.","9");
INSERT INTO smile VALUES("519",".собака2.","9");
INSERT INTO smile VALUES("518",".собака.","9");
INSERT INTO smile VALUES("517",".слоник.","9");
INSERT INTO smile VALUES("516",".слон.","9");
INSERT INTO smile VALUES("515",".скунсы.","9");
INSERT INTO smile VALUES("520",".собака3.","9");
INSERT INTO smile VALUES("521",".свинья.","9");
INSERT INTO smile VALUES("522",".улитка.","9");
INSERT INTO smile VALUES("525",".заяц.","9");
INSERT INTO smile VALUES("524",".вианен.","9");
INSERT INTO smile VALUES("526",".заяц2.","9");
INSERT INTO smile VALUES("527",".жаба.","9");
INSERT INTO smile VALUES("528",".жук.","9");
INSERT INTO smile VALUES("529",".барабан.","12");
INSERT INTO smile VALUES("530",".барабан2.","12");
INSERT INTO smile VALUES("531",".диско.","12");
INSERT INTO smile VALUES("532",".диско2.","12");
INSERT INTO smile VALUES("533",".диско3.","12");
INSERT INTO smile VALUES("534",".диджей.","12");
INSERT INTO smile VALUES("535",".дудка.","12");
INSERT INTO smile VALUES("536",".элвис.","12");
INSERT INTO smile VALUES("537",".гитара.","12");
INSERT INTO smile VALUES("538",".гитара2.","12");
INSERT INTO smile VALUES("539",".гитара3.","12");
INSERT INTO smile VALUES("540",".гитара4.","12");
INSERT INTO smile VALUES("541",".гитара5.","12");
INSERT INTO smile VALUES("543",".харп.","12");
INSERT INTO smile VALUES("544",".играет.","12");
INSERT INTO smile VALUES("545",".музон.","12");
INSERT INTO smile VALUES("546",".баян.","12");
INSERT INTO smile VALUES("547",".2гитары.","12");
INSERT INTO smile VALUES("548",".натрубе.","12");
INSERT INTO smile VALUES("549",".ноты.","12");
INSERT INTO smile VALUES("550",".панк.","12");
INSERT INTO smile VALUES("551",".пианино.","12");
INSERT INTO smile VALUES("552",".пианино2.","12");
INSERT INTO smile VALUES("553",".сакс.","12");
INSERT INTO smile VALUES("554",".сгитарой.","12");
INSERT INTO smile VALUES("555",".скрипка.","12");
INSERT INTO smile VALUES("556",".смузыкой.","12");
INSERT INTO smile VALUES("557",".сопилка.","12");
INSERT INTO smile VALUES("558",".стерео.","12");
INSERT INTO smile VALUES("559",".труба4.","12");
INSERT INTO smile VALUES("560",".трубы.","12");
INSERT INTO smile VALUES("561",".хор.","12");
INSERT INTO smile VALUES("562",".2пал.","8");
INSERT INTO smile VALUES("563",".акут.","8");
INSERT INTO smile VALUES("564",".апл.","8");
INSERT INTO smile VALUES("565",".безпаники.","8");
INSERT INTO smile VALUES("566",".фига.","8");
INSERT INTO smile VALUES("567",".фига2.","8");
INSERT INTO smile VALUES("568",".фига3.","8");
INSERT INTO smile VALUES("569",".хлопает.","8");
INSERT INTO smile VALUES("570",".хорош.","8");
INSERT INTO smile VALUES("571",".лайк.","8");
INSERT INTO smile VALUES("572",".кул2.","8");
INSERT INTO smile VALUES("573",".кул3.","8");
INSERT INTO smile VALUES("574",".лапа.","8");
INSERT INTO smile VALUES("1770",".плохо. ","8");
INSERT INTO smile VALUES("576",".ненадо.","8");
INSERT INTO smile VALUES("577",".неочем.","8");
INSERT INTO smile VALUES("579",".незнаю.","8");
INSERT INTO smile VALUES("583",".пора.","8");
INSERT INTO smile VALUES("584",".привет.","8");
INSERT INTO smile VALUES("585",".прив.","8");
INSERT INTO smile VALUES("586",".ревер.","8");
INSERT INTO smile VALUES("587",".сумас.","8");
INSERT INTO smile VALUES("588",".сумас2.","8");
INSERT INTO smile VALUES("589",".ес.","8");
INSERT INTO smile VALUES("590",".жопа.","8");
INSERT INTO smile VALUES("605",".бабулька.","16");
INSERT INTO smile VALUES("606",".бабулька2.","16");
INSERT INTO smile VALUES("607",".дед2.","16");
INSERT INTO smile VALUES("608",".качает.","16");
INSERT INTO smile VALUES("609",".киди.","16");
INSERT INTO smile VALUES("610",".кормит.","16");
INSERT INTO smile VALUES("612",".кубики.","16");
INSERT INTO smile VALUES("613",".кубики2.","16");
INSERT INTO smile VALUES("614",".кубики3.","16");
INSERT INTO smile VALUES("615",".младенец.","16");
INSERT INTO smile VALUES("616",".младенец2.","16");
INSERT INTO smile VALUES("617",".женаты.","16");
INSERT INTO smile VALUES("618",".невижу.","16");
INSERT INTO smile VALUES("620",".ребенок.","16");
INSERT INTO smile VALUES("621",".сдетьми.","16");
INSERT INTO smile VALUES("622",".семья.","16");
INSERT INTO smile VALUES("623",".семья2.","16");
INSERT INTO smile VALUES("624",".семья3.","16");
INSERT INTO smile VALUES("625",".смишкой.","16");
INSERT INTO smile VALUES("626",".соска.","16");
INSERT INTO smile VALUES("627",".ссоской.","16");
INSERT INTO smile VALUES("628",".вкроват.","16");
INSERT INTO smile VALUES("629",".вкроват2.","16");
INSERT INTO smile VALUES("630",".вкроват3.","16");
INSERT INTO smile VALUES("631",".вкроват4.","16");
INSERT INTO smile VALUES("632",".вванной.","16");
INSERT INTO smile VALUES("633",".змей.","16");
INSERT INTO smile VALUES("636",".анютки.","19");
INSERT INTO smile VALUES("637",".клевер.","19");
INSERT INTO smile VALUES("638",".цвето.","19");
INSERT INTO smile VALUES("669",".амкар.","22");
INSERT INTO smile VALUES("642",".цветок2.","19");
INSERT INTO smile VALUES("643",".цветок3.","19");
INSERT INTO smile VALUES("644",".цветок4.","19");
INSERT INTO smile VALUES("645",".цветок5.","19");
INSERT INTO smile VALUES("646",".цветок6.","19");
INSERT INTO smile VALUES("647",".цветок7.","19");
INSERT INTO smile VALUES("648",".цветок8.","19");
INSERT INTO smile VALUES("668",".айкидо.","22");
INSERT INTO smile VALUES("650",".дарюрозу.","19");
INSERT INTO smile VALUES("651",".клевер2.","19");
INSERT INTO smile VALUES("653",".ромашка.","19");
INSERT INTO smile VALUES("654",".ромашки.","19");
INSERT INTO smile VALUES("655",".роза.","19");
INSERT INTO smile VALUES("656",".роза1.","19");
INSERT INTO smile VALUES("657",".роза2.","19");
INSERT INTO smile VALUES("658",".роза3.","19");
INSERT INTO smile VALUES("659",".роза4.","19");
INSERT INTO smile VALUES("660",".роза5.","19");
INSERT INTO smile VALUES("661",".роза6.","19");
INSERT INTO smile VALUES("662",".роза7.","19");
INSERT INTO smile VALUES("663",".роза8.","19");
INSERT INTO smile VALUES("664",".роза9.","19");
INSERT INTO smile VALUES("665",".сромашкой.","19");
INSERT INTO smile VALUES("670",".баскет.","22");
INSERT INTO smile VALUES("667",".тюльпан.","19");
INSERT INTO smile VALUES("671",".баскетбол.","22");
INSERT INTO smile VALUES("672",".бегун.","22");
INSERT INTO smile VALUES("673",".бейсбол.","22");
INSERT INTO smile VALUES("674",".бест.","22");
INSERT INTO smile VALUES("675",".бобслей.","22");
INSERT INTO smile VALUES("676",".бодибилд.","22");
INSERT INTO smile VALUES("677",".бодибилд2.","22");
INSERT INTO smile VALUES("678",".боксер.","22");
INSERT INTO smile VALUES("679",".бокс.","22");
INSERT INTO smile VALUES("680",".цска.","22");
INSERT INTO smile VALUES("681",".дайвер.","22");
INSERT INTO smile VALUES("682",".дайвер2.","22");
INSERT INTO smile VALUES("683",".динамо.","22");
INSERT INTO smile VALUES("684",".динамо2.","22");
INSERT INTO smile VALUES("685",".фанат.","22");
INSERT INTO smile VALUES("686",".фанаты.","22");
INSERT INTO smile VALUES("687",".футб.","22");
INSERT INTO smile VALUES("688",".гантели.","22");
INSERT INTO smile VALUES("689",".гольф.","22");
INSERT INTO smile VALUES("690",".химки.","22");
INSERT INTO smile VALUES("691",".кач.","22");
INSERT INTO smile VALUES("692",".кубань.","22");
INSERT INTO smile VALUES("693",".лыжник.","22");
INSERT INTO smile VALUES("694",".лыжник2.","22");
INSERT INTO smile VALUES("695",".локо.","22");
INSERT INTO smile VALUES("696",".мяч.","22");
INSERT INTO smile VALUES("697",".москва.","22");
INSERT INTO smile VALUES("698",".налыжах.","22");
INSERT INTO smile VALUES("699",".нхл.","22");
INSERT INTO smile VALUES("700",".обруч.","22");
INSERT INTO smile VALUES("701",".олимп.","22");
INSERT INTO smile VALUES("708",".рубин.","22");
INSERT INTO smile VALUES("703",".парус.","22");
INSERT INTO smile VALUES("704",".плавает.","22");
INSERT INTO smile VALUES("705",".подводой.","22");
INSERT INTO smile VALUES("706",".ростов.","22");
INSERT INTO smile VALUES("707",".рыбалка2.","22");
INSERT INTO smile VALUES("709",".сатурн.","22");
INSERT INTO smile VALUES("710",".шахматы.","22");
INSERT INTO smile VALUES("711",".серфер.","22");
INSERT INTO smile VALUES("712",".сфлагом.","22");
INSERT INTO smile VALUES("713",".скакалка.","22");
INSERT INTO smile VALUES("714",".скакалка2.","22");
INSERT INTO smile VALUES("715",".скейт.","22");
INSERT INTO smile VALUES("716",".слуком.","22");
INSERT INTO smile VALUES("717",".спартак.","22");
INSERT INTO smile VALUES("718",".серф.","22");
INSERT INTO smile VALUES("719",".теннис.","22");
INSERT INTO smile VALUES("720",".теннис2.","22");
INSERT INTO smile VALUES("721",".тренинг.","22");
INSERT INTO smile VALUES("723",".вело2.","22");
INSERT INTO smile VALUES("724",".вело3.","22");
INSERT INTO smile VALUES("725",".водолаз.","22");
INSERT INTO smile VALUES("726",".водолаз2.","22");
INSERT INTO smile VALUES("727",".вплавь.","22");
INSERT INTO smile VALUES("728",".штанга.","22");
INSERT INTO smile VALUES("729",".штанга2.","22");
INSERT INTO smile VALUES("730",".штанга3.","22");
INSERT INTO smile VALUES("731",".зенит.","22");
INSERT INTO smile VALUES("732",".зенит2.","22");
INSERT INTO smile VALUES("733",".жанглер.","22");
INSERT INTO smile VALUES("734",".басков.","14");
INSERT INTO smile VALUES("735",".болею.","14");
INSERT INTO smile VALUES("736",".босс.","14");
INSERT INTO smile VALUES("737",".буба.","14");
INSERT INTO smile VALUES("738",".кактус.","14");
INSERT INTO smile VALUES("739",".чел.","14");
INSERT INTO smile VALUES("740",".командо.","14");
INSERT INTO smile VALUES("741",".командо2.","14");
INSERT INTO smile VALUES("742",".даров.","14");
INSERT INTO smile VALUES("743",".дева.","14");
INSERT INTO smile VALUES("744",".дева2.","14");
INSERT INTO smile VALUES("745",".электрик.","14");
INSERT INTO smile VALUES("746",".еврей.","14");
INSERT INTO smile VALUES("747",".фанат2.","14");
INSERT INTO smile VALUES("748",".фокусник.","14");
INSERT INTO smile VALUES("749",".гитлер.","14");
INSERT INTO smile VALUES("750",".индеец.","14");
INSERT INTO smile VALUES("751",".канабис.","14");
INSERT INTO smile VALUES("752",".капитан.","14");
INSERT INTO smile VALUES("753",".кинг.","14");
INSERT INTO smile VALUES("754",".клео.","14");
INSERT INTO smile VALUES("755",".клоун.","14");
INSERT INTO smile VALUES("757",".клоун3.","14");
INSERT INTO smile VALUES("758",".колдун.","14");
INSERT INTO smile VALUES("759",".колдун2.","14");
INSERT INTO smile VALUES("760",".король.","14");
INSERT INTO smile VALUES("761",".король2.","14");
INSERT INTO smile VALUES("762",".король3.","14");
INSERT INTO smile VALUES("763",".королева.","14");
INSERT INTO smile VALUES("764",".ковбой.","14");
INSERT INTO smile VALUES("765",".ковбой2.","14");
INSERT INTO smile VALUES("766",".крут.","14");
INSERT INTO smile VALUES("767",".курит.","14");
INSERT INTO smile VALUES("768",".ларису.","14");
INSERT INTO smile VALUES("769",".летает.","14");
INSERT INTO smile VALUES("770",".лучник1.","14");
INSERT INTO smile VALUES("771",".мафия.","14");
INSERT INTO smile VALUES("772",".маг.","14");
INSERT INTO smile VALUES("773",".ман2.","14");
INSERT INTO smile VALUES("774",".ман3.","14");
INSERT INTO smile VALUES("775",".мент.","14");
INSERT INTO smile VALUES("776",".мексиканец.","14");
INSERT INTO smile VALUES("777",".мушкетер.","14");
INSERT INTO smile VALUES("778",".мексиканец2.","14");
INSERT INTO smile VALUES("779",".наконе.","14");
INSERT INTO smile VALUES("780",".наполеон.","14");
INSERT INTO smile VALUES("781",".нео.","14");
INSERT INTO smile VALUES("782",".нитки.","14");
INSERT INTO smile VALUES("783",".новрус.","14");
INSERT INTO smile VALUES("784",".охотник.","14");
INSERT INTO smile VALUES("785",".пак.","14");
INSERT INTO smile VALUES("786",".пионер.","14");
INSERT INTO smile VALUES("787",".пират.","14");
INSERT INTO smile VALUES("788",".пират2.","14");
INSERT INTO smile VALUES("789",".писька.","14");
INSERT INTO smile VALUES("790",".погран.","14");
INSERT INTO smile VALUES("791",".порядок.","14");
INSERT INTO smile VALUES("792",".потер.","14");
INSERT INTO smile VALUES("793",".принцесса.","14");
INSERT INTO smile VALUES("794",".принцесса2.","14");
INSERT INTO smile VALUES("795",".пуф.","14");
INSERT INTO smile VALUES("796",".реп.","14");
INSERT INTO smile VALUES("797",".рыбак.","14");
INSERT INTO smile VALUES("798",".рыцарь.","14");
INSERT INTO smile VALUES("799",".рус.","14");
INSERT INTO smile VALUES("800",".рус2.","14");
INSERT INTO smile VALUES("801",".русалка.","14");
INSERT INTO smile VALUES("802",".рыбак2.","14");
INSERT INTO smile VALUES("803",".сестра.","14");
INSERT INTO smile VALUES("804",".шрек.","14");
INSERT INTO smile VALUES("805",".шут.","14");
INSERT INTO smile VALUES("806",".солдат.","14");
INSERT INTO smile VALUES("807",".студент.","14");
INSERT INTO smile VALUES("808",".студент2.","14");
INSERT INTO smile VALUES("809",".студент3.","14");
INSERT INTO smile VALUES("810",".томми.","14");
INSERT INTO smile VALUES("811",".тринити.","14");
INSERT INTO smile VALUES("812",".учен.","14");
INSERT INTO smile VALUES("813",".укр.","14");
INSERT INTO smile VALUES("814",".юса.","14");
INSERT INTO smile VALUES("815",".укр2.","14");
INSERT INTO smile VALUES("816",".воробей.","14");
INSERT INTO smile VALUES("817",".японец.","14");
INSERT INTO smile VALUES("818",".заболел.","14");
INSERT INTO smile VALUES("819",".замерз.","14");
INSERT INTO smile VALUES("820",".зк.","14");
INSERT INTO smile VALUES("821",".звезда.","14");
INSERT INTO smile VALUES("822",".апл2.","3");
INSERT INTO smile VALUES("823",".бегу.","3");
INSERT INTO smile VALUES("824",".бегу2.","3");
INSERT INTO smile VALUES("825",".безпон.","3");
INSERT INTO smile VALUES("826",".блин.","3");
INSERT INTO smile VALUES("827",".болельщица.","3");
INSERT INTO smile VALUES("828",".болен.","3");
INSERT INTO smile VALUES("829",".бреется.","3");
INSERT INTO smile VALUES("830",".будильник2.","3");
INSERT INTO smile VALUES("831",".будильник.","3");
INSERT INTO smile VALUES("832",".чай.","3");
INSERT INTO smile VALUES("833",".честь.","3");
INSERT INTO smile VALUES("834",".честь2.","3");
INSERT INTO smile VALUES("835",".чифа.","3");
INSERT INTO smile VALUES("836",".чих.","3");
INSERT INTO smile VALUES("837",".чистзуб.","3");
INSERT INTO smile VALUES("838",".чит.","3");
INSERT INTO smile VALUES("839",".чит2.","3");
INSERT INTO smile VALUES("840",".чит3.","3");
INSERT INTO smile VALUES("841",".читает.","3");
INSERT INTO smile VALUES("844",".дансе.","3");
INSERT INTO smile VALUES("845",".дарит.","3");
INSERT INTO smile VALUES("847",".довольно.","3");
INSERT INTO smile VALUES("848",".дождь.","3");
INSERT INTO smile VALUES("849",".дождь2.","3");
INSERT INTO smile VALUES("850",".дразнилка.","3");
INSERT INTO smile VALUES("851",".дрель.","3");
INSERT INTO smile VALUES("852",".дружба.","3");
INSERT INTO smile VALUES("853",".душ.","3");
INSERT INTO smile VALUES("854",".душ2.","3");
INSERT INTO smile VALUES("855",".двери.","3");
INSERT INTO smile VALUES("856",".дворник.","3");
INSERT INTO smile VALUES("857",".джентл.","3");
INSERT INTO smile VALUES("858",".еду.","3");
INSERT INTO smile VALUES("859",".фен.","3");
INSERT INTO smile VALUES("860",".фото.","3");
INSERT INTO smile VALUES("861",".фотограф.","3");
INSERT INTO smile VALUES("862",".галстук3.","3");
INSERT INTO smile VALUES("863",".газета.","3");
INSERT INTO smile VALUES("864",".геймеры.","3");
INSERT INTO smile VALUES("866",".гномы.","3");
INSERT INTO smile VALUES("867",".гончар.","3");
INSERT INTO smile VALUES("868",".гребет.","3");
INSERT INTO smile VALUES("869",".гуд.","3");
INSERT INTO smile VALUES("870",".хелпми.","3");
INSERT INTO smile VALUES("871",".худож.","3");
INSERT INTO smile VALUES("872",".игра.","3");
INSERT INTO smile VALUES("874",".играют.","3");
INSERT INTO smile VALUES("875",".инвалиды.","3");
INSERT INTO smile VALUES("876",".ирония.","3");
INSERT INTO smile VALUES("877",".изне.","3");
INSERT INTO smile VALUES("878",".изпола.","3");
INSERT INTO smile VALUES("879",".язык3.","3");
INSERT INTO smile VALUES("880",".картежник.","3");
INSERT INTO smile VALUES("881",".карты.","3");
INSERT INTO smile VALUES("882",".клеит.","3");
INSERT INTO smile VALUES("883",".колбасит.","3");
INSERT INTO smile VALUES("884",".колокол.","3");
INSERT INTO smile VALUES("885",".комполом.","3");
INSERT INTO smile VALUES("886",".конверт.","3");
INSERT INTO smile VALUES("887",".копилка.","3");
INSERT INTO smile VALUES("888",".ковыр2.","3");
INSERT INTO smile VALUES("889",".ковыр.","3");
INSERT INTO smile VALUES("890",".красит.","3");
INSERT INTO smile VALUES("891",".красит2.","3");
INSERT INTO smile VALUES("892",".крик.","3");
INSERT INTO smile VALUES("893",".кривится.","3");
INSERT INTO smile VALUES("894",".круг.","3");
INSERT INTO smile VALUES("895",".куб.","3");
INSERT INTO smile VALUES("897",".куку.","3");
INSERT INTO smile VALUES("898",".куку2.","3");
INSERT INTO smile VALUES("899",".кур.","3");
INSERT INTO smile VALUES("900",".кур2.","3");
INSERT INTO smile VALUES("901",".курица.","3");
INSERT INTO smile VALUES("902",".лак1.","3");
INSERT INTO smile VALUES("903",".манит.","3");
INSERT INTO smile VALUES("904",".марионетка.","3");
INSERT INTO smile VALUES("905",".марионетка2.","3");
INSERT INTO smile VALUES("906",".математик.","3");
INSERT INTO smile VALUES("907",".медит.","3");
INSERT INTO smile VALUES("908",".моб.","3");
INSERT INTO smile VALUES("909",".моетпол.","3");
INSERT INTO smile VALUES("910",".монашка.","3");
INSERT INTO smile VALUES("912",".муха.","3");
INSERT INTO smile VALUES("913",".накачели.","3");
INSERT INTO smile VALUES("914",".наконе2.","3");
INSERT INTO smile VALUES("915",".налуне.","3");
INSERT INTO smile VALUES("916",".наметле.","3");
INSERT INTO smile VALUES("917",".наразлив.","3");
INSERT INTO smile VALUES("918",".наухо.","3");
INSERT INTO smile VALUES("919",".назамок.","3");
INSERT INTO smile VALUES("920",".неоткр.","3");
INSERT INTO smile VALUES("921",".невидим.","3");
INSERT INTO smile VALUES("922",".найт.","3");
INSERT INTO smile VALUES("924",".оценки.","3");
INSERT INTO smile VALUES("925",".палец.","3");
INSERT INTO smile VALUES("926",".письмо.","3");
INSERT INTO smile VALUES("927",".пазл.","3");
INSERT INTO smile VALUES("928",".пепер.","3");
INSERT INTO smile VALUES("929",".пылесос.","3");
INSERT INTO smile VALUES("930",".пилит.","3");
INSERT INTO smile VALUES("931",".пиосмок.","3");
INSERT INTO smile VALUES("932",".пишу.","3");
INSERT INTO smile VALUES("933",".подарок.","3");
INSERT INTO smile VALUES("934",".подарок2.","3");
INSERT INTO smile VALUES("935",".подарок3.","3");
INSERT INTO smile VALUES("936",".поддержка.","3");
INSERT INTO smile VALUES("938",".поливает.","3");
INSERT INTO smile VALUES("939",".порукам.","3");
INSERT INTO smile VALUES("940",".порукам2.","3");
INSERT INTO smile VALUES("942",".посписку.","3");
INSERT INTO smile VALUES("943",".потелефону.","3");
INSERT INTO smile VALUES("944",".потяг.","3");
INSERT INTO smile VALUES("945",".поушам.","3");
INSERT INTO smile VALUES("947",".привет2.","3");
INSERT INTO smile VALUES("948",".привет3.","3");
INSERT INTO smile VALUES("949",".пробежала.","3");
INSERT INTO smile VALUES("950",".пузырьки.","3");
INSERT INTO smile VALUES("951",".пазл2.","3");
INSERT INTO smile VALUES("952",".пьет.","3");
INSERT INTO smile VALUES("953",".пьет2.","3");
INSERT INTO smile VALUES("954",".ракушка.","3");
INSERT INTO smile VALUES("955",".книга.","3");
INSERT INTO smile VALUES("956",".рога2.","3");
INSERT INTO smile VALUES("957",".рогатка.","3");
INSERT INTO smile VALUES("958",".рубанок.","3");
INSERT INTO smile VALUES("959",".рубик.","3");
INSERT INTO smile VALUES("960",".салон.","3");
INSERT INTO smile VALUES("961",".сальто.","3");
INSERT INTO smile VALUES("962",".шарик.","3");
INSERT INTO smile VALUES("963",".шляпки.","3");
INSERT INTO smile VALUES("964",".фен.","3");
INSERT INTO smile VALUES("965",".сгалстуком.","3");
INSERT INTO smile VALUES("966",".щелкает.","3");
INSERT INTO smile VALUES("967",".сключем.","3");
INSERT INTO smile VALUES("968",".скубком.","3");
INSERT INTO smile VALUES("969",".спит.","3");
INSERT INTO smile VALUES("970",".слупой.","3");
INSERT INTO smile VALUES("971",".слупой2.","3");
INSERT INTO smile VALUES("972",".смешком.","3");
INSERT INTO smile VALUES("973",".список.","3");
INSERT INTO smile VALUES("974",".спит2.","3");
INSERT INTO smile VALUES("975",".спят.","3");
INSERT INTO smile VALUES("976",".стопором.","3");
INSERT INTO smile VALUES("977",".свеником.","3");
INSERT INTO smile VALUES("978",".свистит.","3");
INSERT INTO smile VALUES("979",".свистун.","3");
INSERT INTO smile VALUES("980",".таблетки.","3");
INSERT INTO smile VALUES("981",".тел.","3");
INSERT INTO smile VALUES("982",".тел2.","3");
INSERT INTO smile VALUES("983",".томат.","3");
INSERT INTO smile VALUES("984",".указ.","3");
INSERT INTO smile VALUES("985",".улетел.","3");
INSERT INTO smile VALUES("986",".умник.","3");
INSERT INTO smile VALUES("987",".управ.","3");
INSERT INTO smile VALUES("988",".вазон.","3");
INSERT INTO smile VALUES("989",".вбанке.","3");
INSERT INTO smile VALUES("990",".вдуше.","3");
INSERT INTO smile VALUES("991",".венок.","3");
INSERT INTO smile VALUES("992",".вертушка.","3");
INSERT INTO smile VALUES("993",".вкресле.","3");
INSERT INTO smile VALUES("994",".вкресле2.","3");
INSERT INTO smile VALUES("995",".влужу.","3");
INSERT INTO smile VALUES("996",".внебо.","3");
INSERT INTO smile VALUES("997",".во.","3");
INSERT INTO smile VALUES("998",".вочках.","3");
INSERT INTO smile VALUES("999",".вокруг.","3");
INSERT INTO smile VALUES("1000",".время.","3");
INSERT INTO smile VALUES("1001",".вуду.","3");
INSERT INTO smile VALUES("1002",".вухе.","3");
INSERT INTO smile VALUES("1003",".вванную.","3");
INSERT INTO smile VALUES("1004",".вяжет.","3");
INSERT INTO smile VALUES("1005",".выглядывает.","3");
INSERT INTO smile VALUES("1006",".вышивает.","3");
INSERT INTO smile VALUES("1007",".вышивает2.","3");
INSERT INTO smile VALUES("1008",".взрыватель.","3");
INSERT INTO smile VALUES("1009",".велком.","3");
INSERT INTO smile VALUES("1010",".химия.","3");
INSERT INTO smile VALUES("1011",".хо.","3");
INSERT INTO smile VALUES("1013",".йойо.","3");
INSERT INTO smile VALUES("1014",".уесс.","3");
INSERT INTO smile VALUES("1015",".уес2.","3");
INSERT INTO smile VALUES("1016",".забивает.","3");
INSERT INTO smile VALUES("1017",".задумался.","3");
INSERT INTO smile VALUES("1018",".задумчиво.","3");
INSERT INTO smile VALUES("1019",".закосички.","3");
INSERT INTO smile VALUES("1020",".зарядка.","3");
INSERT INTO smile VALUES("1021",".засып.","3");
INSERT INTO smile VALUES("1022",".заволосы.","3");
INSERT INTO smile VALUES("1023",".зашторой.","3");
INSERT INTO smile VALUES("1024",".зеркало.","3");
INSERT INTO smile VALUES("1025",".зеркало2.","3");
INSERT INTO smile VALUES("1026",".зевает.","3");
INSERT INTO smile VALUES("1027",".жопой.","3");
INSERT INTO smile VALUES("1028",".жиш.","3");
INSERT INTO smile VALUES("1029",".зомби.","3");
INSERT INTO smile VALUES("1030",".зонт.","3");
INSERT INTO smile VALUES("1031",".зубч.","3");
INSERT INTO smile VALUES("1049",".зуб.","6");
INSERT INTO smile VALUES("1050",".зуб2.","6");
INSERT INTO smile VALUES("1051",".гг.","6");
INSERT INTO smile VALUES("1054",".ахуеть.","10");
INSERT INTO smile VALUES("1053",".ценз.","10");
INSERT INTO smile VALUES("1056",".позор.","20");
INSERT INTO smile VALUES("1072",".кгам.","4");
INSERT INTO smile VALUES("1073",".симбас.","14");
INSERT INTO smile VALUES("1074",".пивос.","7");
INSERT INTO smile VALUES("1076",":сердит","24");
INSERT INTO smile VALUES("1077",":улыбка","24");
INSERT INTO smile VALUES("1078",":грусть","24");
INSERT INTO smile VALUES("1079",":дум","24");
INSERT INTO smile VALUES("1080",":хмур","24");
INSERT INTO smile VALUES("1081",":сум","24");
INSERT INTO smile VALUES("1082",":подмиг","24");
INSERT INTO smile VALUES("1083",":злой","24");
INSERT INTO smile VALUES("1084",":лыба","24");
INSERT INTO smile VALUES("1085",":плак","24");
INSERT INTO smile VALUES("1086",":язык","24");
INSERT INTO smile VALUES("1087",":ах","24");
INSERT INTO smile VALUES("1088",":фигасе","24");
INSERT INTO smile VALUES("1089",":мечт","24");
INSERT INTO smile VALUES("1090",":люб","24");
INSERT INTO smile VALUES("1091",":сплю","24");
INSERT INTO smile VALUES("1092",":рад","24");
INSERT INTO smile VALUES("1093",":зев","24");
INSERT INTO smile VALUES("1094","(H)","24");
INSERT INTO smile VALUES("1152",".мумия.","13");
INSERT INTO smile VALUES("1153",".приведение1.","13");
INSERT INTO smile VALUES("1154",".тыква.","13");
INSERT INTO smile VALUES("1155",".приведение2.","13");
INSERT INTO smile VALUES("1156",".дракула1.","13");
INSERT INTO smile VALUES("1157",".хэллоуин.","13");
INSERT INTO smile VALUES("1158",".хэллоуин1.","13");
INSERT INTO smile VALUES("1168",".че.","21");
INSERT INTO smile VALUES("1169",":(","21");
INSERT INTO smile VALUES("1170",":D","21");
INSERT INTO smile VALUES("1186",".язык.","21");
INSERT INTO smile VALUES("1173",".миг.","21");
INSERT INTO smile VALUES("1174",".крут.","21");
INSERT INTO smile VALUES("1175",".секрет.","21");
INSERT INTO smile VALUES("1182",".ах.","21");
INSERT INTO smile VALUES("1183",".кисс.","21");
INSERT INTO smile VALUES("1281",".адм7.","28");
INSERT INTO smile VALUES("1201",".ржу.","20");
INSERT INTO smile VALUES("1202",".ржу2.","20");
INSERT INTO smile VALUES("1203",".ржу3.","20");
INSERT INTO smile VALUES("1204",".грустити.","20");
INSERT INTO smile VALUES("1220",".поц.","11");
INSERT INTO smile VALUES("1221",".адм.","28");
INSERT INTO smile VALUES("4411",".пр20.","83");
INSERT INTO smile VALUES("1224",".адм2.","28");
INSERT INTO smile VALUES("1227",".адм3.","28");
INSERT INTO smile VALUES("1236",".1м.","28");
INSERT INTO smile VALUES("1237",".2м.","28");
INSERT INTO smile VALUES("1238",".3м.","28");
INSERT INTO smile VALUES("1239",".адм4.","28");
INSERT INTO smile VALUES("2501",".кон3.","57");
INSERT INTO smile VALUES("2500",".кон2.","57");
INSERT INTO smile VALUES("1246",".куку. ","8");
INSERT INTO smile VALUES("1247",".нервы. ","8");
INSERT INTO smile VALUES("2499",".кон1.","57");
INSERT INTO smile VALUES("1259","??? ","36");
INSERT INTO smile VALUES("1278",".адм5.","28");
INSERT INTO smile VALUES("1279",".адм6.","28");
INSERT INTO smile VALUES("1282",".адм8.","28");
INSERT INTO smile VALUES("1284",".адм9.","28");
INSERT INTO smile VALUES("1285",".адм10.","28");
INSERT INTO smile VALUES("1286",".адм11.","28");
INSERT INTO smile VALUES("1287",".адм12.","28");
INSERT INTO smile VALUES("1289",".адм13.","28");
INSERT INTO smile VALUES("1290",".адм14.","28");
INSERT INTO smile VALUES("1292",".адм15.","28");
INSERT INTO smile VALUES("1294",".адм16.","28");
INSERT INTO smile VALUES("1296",".адм17.","28");
INSERT INTO smile VALUES("1297",".1я.","36");
INSERT INTO smile VALUES("1298",".2я.","36");
INSERT INTO smile VALUES("1299",".3я.","36");
INSERT INTO smile VALUES("1300",".4я.","36");
INSERT INTO smile VALUES("1301",".5я.","36");
INSERT INTO smile VALUES("1302",".6я.","36");
INSERT INTO smile VALUES("1303",".7я.","36");
INSERT INTO smile VALUES("1304",".8я.","36");
INSERT INTO smile VALUES("1305",".9я.","36");
INSERT INTO smile VALUES("1306",".0я.","36");
INSERT INTO smile VALUES("1307","..а1.","36");
INSERT INTO smile VALUES("1308",".а2.","36");
INSERT INTO smile VALUES("1309",".а3.","36");
INSERT INTO smile VALUES("1310",".а4.","36");
INSERT INTO smile VALUES("1311",".а5.","36");
INSERT INTO smile VALUES("1312",".а6.","36");
INSERT INTO smile VALUES("1313",".а7.","36");
INSERT INTO smile VALUES("1314",".а8.","36");
INSERT INTO smile VALUES("1315",".а9.","36");
INSERT INTO smile VALUES("1316",".а0.","36");
INSERT INTO smile VALUES("1317",".01.","36");
INSERT INTO smile VALUES("1318",".02. ","36");
INSERT INTO smile VALUES("1319",".03.","36");
INSERT INTO smile VALUES("1321",".04.","36");
INSERT INTO smile VALUES("1322",".05.","36");
INSERT INTO smile VALUES("1323",".06.","36");
INSERT INTO smile VALUES("1324",".07.","36");
INSERT INTO smile VALUES("1325",".08.","36");
INSERT INTO smile VALUES("1326",".09.","36");
INSERT INTO smile VALUES("1327",".00.","36");
INSERT INTO smile VALUES("1328",".ц1.","36");
INSERT INTO smile VALUES("1329",".ц2.","36");
INSERT INTO smile VALUES("1330",".ц3.","36");
INSERT INTO smile VALUES("1331",".ц5.","36");
INSERT INTO smile VALUES("1332",".ц6.","36");
INSERT INTO smile VALUES("1333",".ц7.","36");
INSERT INTO smile VALUES("1334",".ц8.","36");
INSERT INTO smile VALUES("1335",".ц9.","36");
INSERT INTO smile VALUES("1336",".ц0.","36");
INSERT INTO smile VALUES("3061",".7мм.","36");
INSERT INTO smile VALUES("3060",".6мм.","36");
INSERT INTO smile VALUES("3059",".5мм.","36");
INSERT INTO smile VALUES("3058",".4мм.","36");
INSERT INTO smile VALUES("3057",".3мм.","36");
INSERT INTO smile VALUES("3054",".0мм.","36");
INSERT INTO smile VALUES("3055",".1мм.","36");
INSERT INTO smile VALUES("3056",".2мм.","36");
INSERT INTO smile VALUES("1347","_1_","36");
INSERT INTO smile VALUES("1348","_2_","36");
INSERT INTO smile VALUES("1349","_3_","36");
INSERT INTO smile VALUES("1350","_4_","36");
INSERT INTO smile VALUES("1351","_5_","36");
INSERT INTO smile VALUES("1352","_6_","36");
INSERT INTO smile VALUES("1353","_7_","36");
INSERT INTO smile VALUES("1354","_8_","36");
INSERT INTO smile VALUES("1355","_9_","36");
INSERT INTO smile VALUES("1356","_0_","36");
INSERT INTO smile VALUES("1390",".адм18.","28");
INSERT INTO smile VALUES("1976",".бон52.","50");
INSERT INTO smile VALUES("1393",".адм19.","28");
INSERT INTO smile VALUES("1394",".адм20.","28");
INSERT INTO smile VALUES("1395",".адм21.","28");
INSERT INTO smile VALUES("1977",".бон53.","50");
INSERT INTO smile VALUES("1979",".бон54.","50");
INSERT INTO smile VALUES("1400",".адм22.","28");
INSERT INTO smile VALUES("1401",".адм23.","28");
INSERT INTO smile VALUES("1402",".адм24.","28");
INSERT INTO smile VALUES("1403",".адм25.","28");
INSERT INTO smile VALUES("1405",".адм26.","28");
INSERT INTO smile VALUES("1407",".адм27.","28");
INSERT INTO smile VALUES("1409",".адм28.","28");
INSERT INTO smile VALUES("1411",".адм29.","28");
INSERT INTO smile VALUES("1412",".адм30.","28");
INSERT INTO smile VALUES("1413",".адм31.","28");
INSERT INTO smile VALUES("1414",".адм32.","28");
INSERT INTO smile VALUES("1415",".адм33.","28");
INSERT INTO smile VALUES("1416",".адм34.","28");
INSERT INTO smile VALUES("1417",".адм35.","28");
INSERT INTO smile VALUES("1418",".3место.","28");
INSERT INTO smile VALUES("1419",".2место.","28");
INSERT INTO smile VALUES("1420",".1место.","28");
INSERT INTO smile VALUES("1421",".адм36.","28");
INSERT INTO smile VALUES("1980",".бон55.","50");
INSERT INTO smile VALUES("1425",".адм37.","28");
INSERT INTO smile VALUES("1427",".адм38.","28");
INSERT INTO smile VALUES("2979",".бон64.","50");
INSERT INTO smile VALUES("1502",".поц1.","45");
INSERT INTO smile VALUES("1503",".поц2.","45");
INSERT INTO smile VALUES("1504",".поц3.","45");
INSERT INTO smile VALUES("1505",".поц4.","45");
INSERT INTO smile VALUES("1506",".поц5.","45");
INSERT INTO smile VALUES("1507",".поц6.","45");
INSERT INTO smile VALUES("1508",".поц7.","45");
INSERT INTO smile VALUES("1509",".поц8.","45");
INSERT INTO smile VALUES("1510",".поц9.","45");
INSERT INTO smile VALUES("1511",".поц10.","45");
INSERT INTO smile VALUES("1512",".поц11.","45");
INSERT INTO smile VALUES("1513",".поц12.","45");
INSERT INTO smile VALUES("1514",".поц13.","45");
INSERT INTO smile VALUES("1515",".поц14.","45");
INSERT INTO smile VALUES("1516",".поц15.","45");
INSERT INTO smile VALUES("1517",".поц16.","45");
INSERT INTO smile VALUES("1518",".поц17.","45");
INSERT INTO smile VALUES("1519",".поц18.","45");
INSERT INTO smile VALUES("1520",".поц19.","45");
INSERT INTO smile VALUES("1521",".поц20.","45");
INSERT INTO smile VALUES("1522",".поц21.","45");
INSERT INTO smile VALUES("1523",".поц22.","45");
INSERT INTO smile VALUES("1524",".поц23.","45");
INSERT INTO smile VALUES("1525",".поц24.","45");
INSERT INTO smile VALUES("1526",".поц25.","45");
INSERT INTO smile VALUES("1527",".поц26.","45");
INSERT INTO smile VALUES("1528",".поц27.","45");
INSERT INTO smile VALUES("1529",".поц28.","45");
INSERT INTO smile VALUES("1530",".поц29.","45");
INSERT INTO smile VALUES("1531",".поц30.","45");
INSERT INTO smile VALUES("1532",".поц31.","45");
INSERT INTO smile VALUES("1533",".поц32.","45");
INSERT INTO smile VALUES("1534",".поц33.","45");
INSERT INTO smile VALUES("1535",".поц34.","45");
INSERT INTO smile VALUES("1536",".поц35.","45");
INSERT INTO smile VALUES("1542",".поц40.","45");
INSERT INTO smile VALUES("1538",".поц36.","45");
INSERT INTO smile VALUES("1539",".поц37.","45");
INSERT INTO smile VALUES("1540",".поц38.","45");
INSERT INTO smile VALUES("1541",".поц39.","45");
INSERT INTO smile VALUES("1543",".поц41.","45");
INSERT INTO smile VALUES("1544",".поц42.","45");
INSERT INTO smile VALUES("2563",".поц43.","45");
INSERT INTO smile VALUES("1546",".поц44.","45");
INSERT INTO smile VALUES("1547",".поц45.","45");
INSERT INTO smile VALUES("1548",".поц46.","45");
INSERT INTO smile VALUES("1549",".поц47.","45");
INSERT INTO smile VALUES("2564",".поц49.","45");
INSERT INTO smile VALUES("2562",".поц48.","45");
INSERT INTO smile VALUES("1775",".ревер1. ","8");
INSERT INTO smile VALUES("1739",".злая. ","8");
INSERT INTO smile VALUES("1740",".ляля.","8");
INSERT INTO smile VALUES("1741",".музон2.","8");
INSERT INTO smile VALUES("1742",".поклон2. ","8");
INSERT INTO smile VALUES("1743",".ор2. ","8");
INSERT INTO smile VALUES("1744",".глазища. ","8");
INSERT INTO smile VALUES("1745",".ждет. ","8");
INSERT INTO smile VALUES("1746",".неа. ","8");
INSERT INTO smile VALUES("1747",".рр.","8");
INSERT INTO smile VALUES("1748",".нее2. ","8");
INSERT INTO smile VALUES("1750",".зев. ","8");
INSERT INTO smile VALUES("1752",".закосы.","8");
INSERT INTO smile VALUES("1753",".дароу. ","8");
INSERT INTO smile VALUES("1754",".пока4. ","8");
INSERT INTO smile VALUES("1755",".пока3. ","8");
INSERT INTO smile VALUES("1756",".йех. ","8");
INSERT INTO smile VALUES("1758",".ужас2. ","8");
INSERT INTO smile VALUES("1759",".отпад. ","8");
INSERT INTO smile VALUES("1760",".причит. ","8");
INSERT INTO smile VALUES("1762","..красн1. ","8");
INSERT INTO smile VALUES("1763",".шутят. ","8");
INSERT INTO smile VALUES("1764",".ахах. ","8");
INSERT INTO smile VALUES("1765",".ахах2. ","8");
INSERT INTO smile VALUES("1766",".хихи.","8");
INSERT INTO smile VALUES("1767",".кулак. ","8");
INSERT INTO smile VALUES("1768",".нея2.","8");
INSERT INTO smile VALUES("1769",".пока. ","8");
INSERT INTO smile VALUES("1771",".ай.","8");
INSERT INTO smile VALUES("1772",".фиг. ","8");
INSERT INTO smile VALUES("1773",".поддождем. ","8");
INSERT INTO smile VALUES("1774",".ругает. ","8");
INSERT INTO smile VALUES("1776",".прокачу. ","8");
INSERT INTO smile VALUES("1777",".фак.","8");
INSERT INTO smile VALUES("1778",".гордо2. ","8");
INSERT INTO smile VALUES("1779",".привеет. ","8");
INSERT INTO smile VALUES("1782",".прочь.","8");
INSERT INTO smile VALUES("1783",".закосичку.","8");
INSERT INTO smile VALUES("1784",".ыыы.","8");
INSERT INTO smile VALUES("1785",".косы. ","8");
INSERT INTO smile VALUES("1786",".рукой.","8");
INSERT INTO smile VALUES("1787",".дружба1. ","8");
INSERT INTO smile VALUES("1788",".дразнилка. ","8");
INSERT INTO smile VALUES("1789",".баксы.","8");
INSERT INTO smile VALUES("1790",".стук.","8");
INSERT INTO smile VALUES("1885",".бон.","50");
INSERT INTO smile VALUES("1801",".9мая2.","13");
INSERT INTO smile VALUES("1800",".9мая1.","13");
INSERT INTO smile VALUES("1799",".9мая.","13");
INSERT INTO smile VALUES("1802",".9мая3.","13");
INSERT INTO smile VALUES("1803",".9мая4.","13");
INSERT INTO smile VALUES("1804",".9мая5.","13");
INSERT INTO smile VALUES("1805",".9мая6.","13");
INSERT INTO smile VALUES("1806",".9мая7.","13");
INSERT INTO smile VALUES("1807",".9мая8.","13");
INSERT INTO smile VALUES("1808",".9мая9.","13");
INSERT INTO smile VALUES("1809",".9мая10.","13");
INSERT INTO smile VALUES("1810",".9мая11.","13");
INSERT INTO smile VALUES("1811",".9мая12.","13");
INSERT INTO smile VALUES("1812",".9мая13.","13");
INSERT INTO smile VALUES("1813",".9мая14.","13");
INSERT INTO smile VALUES("1814",".9мая15.","13");
INSERT INTO smile VALUES("1815",".1мая.","13");
INSERT INTO smile VALUES("1816",".1мая1.","13");
INSERT INTO smile VALUES("1817",".1мая2.","13");
INSERT INTO smile VALUES("1818",".1мая3.","13");
INSERT INTO smile VALUES("1819",".1мая4.","13");
INSERT INTO smile VALUES("1820","1мая5.","13");
INSERT INTO smile VALUES("1821",".1мая6.","13");
INSERT INTO smile VALUES("1822",".1мая7.","13");
INSERT INTO smile VALUES("1823","1мая8.","13");
INSERT INTO smile VALUES("1824",".1мая9.","13");
INSERT INTO smile VALUES("1825",".1мая10.","13");
INSERT INTO smile VALUES("1886",".бон1.","50");
INSERT INTO smile VALUES("1887",".бон2.","50");
INSERT INTO smile VALUES("1888",".бон3.","50");
INSERT INTO smile VALUES("1889",".бон4.","50");
INSERT INTO smile VALUES("1890",".бон5.","50");
INSERT INTO smile VALUES("1891",".бон6.","50");
INSERT INTO smile VALUES("1892",".бон7.","50");
INSERT INTO smile VALUES("1893",".бон8.","50");
INSERT INTO smile VALUES("1894",".бон9.","50");
INSERT INTO smile VALUES("1895",".бон10.","50");
INSERT INTO smile VALUES("1896",".бон11.","50");
INSERT INTO smile VALUES("1897",".бон12.","50");
INSERT INTO smile VALUES("1898",".бон13.","50");
INSERT INTO smile VALUES("1899",".бон14.","50");
INSERT INTO smile VALUES("1900",".бон15.","50");
INSERT INTO smile VALUES("1901",".бон16.","50");
INSERT INTO smile VALUES("1902",".бон17.","50");
INSERT INTO smile VALUES("1903",".бон18.","50");
INSERT INTO smile VALUES("1904",".бон19.","50");
INSERT INTO smile VALUES("1905",".бон20.","50");
INSERT INTO smile VALUES("1906",".бон21.","50");
INSERT INTO smile VALUES("1907",".бон22.","50");
INSERT INTO smile VALUES("1908",".бон23.","50");
INSERT INTO smile VALUES("1909",".бон24.","50");
INSERT INTO smile VALUES("1910",".бон25.","50");
INSERT INTO smile VALUES("1911",".бон26.","50");
INSERT INTO smile VALUES("1912",".бон27.","50");
INSERT INTO smile VALUES("1913",".9маяя.","13");
INSERT INTO smile VALUES("1914",".бон28.","50");
INSERT INTO smile VALUES("1915",".бон29.","50");
INSERT INTO smile VALUES("1919",".бон32.","50");
INSERT INTO smile VALUES("1917",".бон30.","50");
INSERT INTO smile VALUES("1918",".бон31.","50");
INSERT INTO smile VALUES("1920",".бон33.","50");
INSERT INTO smile VALUES("1921",".чаек.","7");
INSERT INTO smile VALUES("1922",".чаек1.","7");
INSERT INTO smile VALUES("1923",".коф.","7");
INSERT INTO smile VALUES("1924",".чаек2.","7");
INSERT INTO smile VALUES("1927",".эро.","49");
INSERT INTO smile VALUES("1928",".эро1.","49");
INSERT INTO smile VALUES("1929",".эро2.","49");
INSERT INTO smile VALUES("1930",".эро3.","49");
INSERT INTO smile VALUES("1931",".эро4.","49");
INSERT INTO smile VALUES("1932",".эро5.","49");
INSERT INTO smile VALUES("1933",".эро6.","49");
INSERT INTO smile VALUES("1934",".эро7.","49");
INSERT INTO smile VALUES("1935",".эро8.","49");
INSERT INTO smile VALUES("1936",".эро9.","49");
INSERT INTO smile VALUES("1937",".эро10.","49");
INSERT INTO smile VALUES("1938",".эро11.","49");
INSERT INTO smile VALUES("1939",".эро12.","49");
INSERT INTO smile VALUES("1940",".эро13.","49");
INSERT INTO smile VALUES("1941",".эро14.","49");
INSERT INTO smile VALUES("1942",".эро15.","49");
INSERT INTO smile VALUES("1943",".эро16.","49");
INSERT INTO smile VALUES("1944",".эро17.","49");
INSERT INTO smile VALUES("1945",".эро18.","49");
INSERT INTO smile VALUES("1946",".эро19.","49");
INSERT INTO smile VALUES("1947",".эро20.","49");
INSERT INTO smile VALUES("1948",".эро21.","49");
INSERT INTO smile VALUES("1949",".эро22.","49");
INSERT INTO smile VALUES("1950",".эро23.","49");
INSERT INTO smile VALUES("1953",".бон34.","50");
INSERT INTO smile VALUES("1954",".бон35.","50");
INSERT INTO smile VALUES("1955",".бон36.","50");
INSERT INTO smile VALUES("1956",".бон37.","50");
INSERT INTO smile VALUES("1957",".бон38.","50");
INSERT INTO smile VALUES("1958",".бон39.","50");
INSERT INTO smile VALUES("1959",".бон40.","50");
INSERT INTO smile VALUES("1960",".бон41.","50");
INSERT INTO smile VALUES("1961",".бон42.","50");
INSERT INTO smile VALUES("1962",".бон43.","50");
INSERT INTO smile VALUES("1963",".бон44.","50");
INSERT INTO smile VALUES("1966",".бон45.","50");
INSERT INTO smile VALUES("1968",".бон46.","50");
INSERT INTO smile VALUES("1969",".бон47.","50");
INSERT INTO smile VALUES("1970",".бон48.","50");
INSERT INTO smile VALUES("1971",".бон49.","50");
INSERT INTO smile VALUES("1972",".бон50.","50");
INSERT INTO smile VALUES("1973",".бон51.","50");
INSERT INTO smile VALUES("1981",".бон56.","50");
INSERT INTO smile VALUES("4391",".бон76.","50");
INSERT INTO smile VALUES("2062",".цвет.","19");
INSERT INTO smile VALUES("2063",".цвет1.","19");
INSERT INTO smile VALUES("2064",".цвет2.","19");
INSERT INTO smile VALUES("2065",".цвет3.","19");
INSERT INTO smile VALUES("2066",".цвет4.","19");
INSERT INTO smile VALUES("2067",".цвет5.","19");
INSERT INTO smile VALUES("2068",".цвет6.","19");
INSERT INTO smile VALUES("2069",".цвет7.","19");
INSERT INTO smile VALUES("2070",".цвет8.","19");
INSERT INTO smile VALUES("2071",".цвет9.","19");
INSERT INTO smile VALUES("2072",".цвет10.","19");
INSERT INTO smile VALUES("2073",".цвет11.","19");
INSERT INTO smile VALUES("2074",".цвет12.","19");
INSERT INTO smile VALUES("2075",".цвет13.","19");
INSERT INTO smile VALUES("2076",".цвет14.","19");
INSERT INTO smile VALUES("2077",".цвет15.","19");
INSERT INTO smile VALUES("2078",".цвет16.","19");
INSERT INTO smile VALUES("5246",".цвет41.","19");
INSERT INTO smile VALUES("6032",".цвет63.","19");
INSERT INTO smile VALUES("2082",".цвет20.","19");
INSERT INTO smile VALUES("2083",".цвет21.","19");
INSERT INTO smile VALUES("5247",".цвет42.","19");
INSERT INTO smile VALUES("2085",".цвет23.","19");
INSERT INTO smile VALUES("5248",".цвет43.","19");
INSERT INTO smile VALUES("6033",".цвет64.","19");
INSERT INTO smile VALUES("2088",".цвет26.","19");
INSERT INTO smile VALUES("5250",".цвет44.","19");
INSERT INTO smile VALUES("2090",".цвет28.","19");
INSERT INTO smile VALUES("2091",".цвет29.","19");
INSERT INTO smile VALUES("2092",".цвет30.","19");
INSERT INTO smile VALUES("2093",".цвет31.","19");
INSERT INTO smile VALUES("2094",".цвет32.","19");
INSERT INTO smile VALUES("2095",".цвет33.","19");
INSERT INTO smile VALUES("2096",".цвет34.","19");
INSERT INTO smile VALUES("2097",".цвет35.","19");
INSERT INTO smile VALUES("2098",".цвет36.","19");
INSERT INTO smile VALUES("2099",".цвет37.","19");
INSERT INTO smile VALUES("2100",".цвет38.","19");
INSERT INTO smile VALUES("3382",".поц73.","45");
INSERT INTO smile VALUES("2237",".бон57.","50");
INSERT INTO smile VALUES("2238",".джин1.","54");
INSERT INTO smile VALUES("2239",".джин2.","54");
INSERT INTO smile VALUES("4389",".бон74.","50");
INSERT INTO smile VALUES("4390",".бон75.","50");
INSERT INTO smile VALUES("2263",".1маяя.","13");
INSERT INTO smile VALUES("2482",".бон58.","50");
INSERT INTO smile VALUES("2483",".бон59.","50");
INSERT INTO smile VALUES("2502",".кон4.","57");
INSERT INTO smile VALUES("2503",".кон5.","57");
INSERT INTO smile VALUES("2504",".кон6.","57");
INSERT INTO smile VALUES("2505",".кон7.","57");
INSERT INTO smile VALUES("2506",".кон8.","57");
INSERT INTO smile VALUES("2507",".кон9.","57");
INSERT INTO smile VALUES("2508",".кон10.","57");
INSERT INTO smile VALUES("2509",".кон11.","57");
INSERT INTO smile VALUES("2510",".кон12.","57");
INSERT INTO smile VALUES("2511",".кон13.","57");
INSERT INTO smile VALUES("2512",".кон14.","57");
INSERT INTO smile VALUES("2513",".кон15.","57");
INSERT INTO smile VALUES("2514",".кон16.","57");
INSERT INTO smile VALUES("2515",".кон17.","57");
INSERT INTO smile VALUES("2518",".кон18.","57");
INSERT INTO smile VALUES("2519",".кон19.","57");
INSERT INTO smile VALUES("2520",".кон20.","57");
INSERT INTO smile VALUES("2521",".кон21.","57");
INSERT INTO smile VALUES("2522",".кон22.","57");
INSERT INTO smile VALUES("2523",".кон23.","57");
INSERT INTO smile VALUES("2524",".кон24.","57");
INSERT INTO smile VALUES("2555",".адм50.","28");
INSERT INTO smile VALUES("2554",".адм49.","28");
INSERT INTO smile VALUES("2553",".адм48.","28");
INSERT INTO smile VALUES("2552",".адм47.","28");
INSERT INTO smile VALUES("2551",".адм46.","28");
INSERT INTO smile VALUES("2549",".адм44.","28");
INSERT INTO smile VALUES("2535",".адм39.","28");
INSERT INTO smile VALUES("4410",".пр19.","83");
INSERT INTO smile VALUES("2537",".адм40.","28");
INSERT INTO smile VALUES("2539",".адм41.","28");
INSERT INTO smile VALUES("4409",".пр18.","83");
INSERT INTO smile VALUES("2541",".адм42.","28");
INSERT INTO smile VALUES("2542",".адм43.","28");
INSERT INTO smile VALUES("2544",".1место1.","28");
INSERT INTO smile VALUES("2545",".2место2.","28");
INSERT INTO smile VALUES("2546",".3место3.","28");
INSERT INTO smile VALUES("2550",".адм45.","28");
INSERT INTO smile VALUES("2556",".адм51.","28");
INSERT INTO smile VALUES("4388",".бон73.","50");
INSERT INTO smile VALUES("4387",".бонус72.","50");
INSERT INTO smile VALUES("2565",".поц50.","45");
INSERT INTO smile VALUES("2566",".поц51.","45");
INSERT INTO smile VALUES("2567",".поц52.","45");
INSERT INTO smile VALUES("2570",".поц53.","45");
INSERT INTO smile VALUES("2569",".поц55.","45");
INSERT INTO smile VALUES("2571",".поц54.","45");
INSERT INTO smile VALUES("2572",".поц56.","45");
INSERT INTO smile VALUES("2573",".поц57.","45");
INSERT INTO smile VALUES("2575",".пупс.","60");
INSERT INTO smile VALUES("2576",".пупс1.","60");
INSERT INTO smile VALUES("2577",".пупс2.","60");
INSERT INTO smile VALUES("2578",".пупс3.","60");
INSERT INTO smile VALUES("2579",".пупс4.","60");
INSERT INTO smile VALUES("2580",".пупс5.","60");
INSERT INTO smile VALUES("2581",".пупс6.","60");
INSERT INTO smile VALUES("2582",".пупс7.","60");
INSERT INTO smile VALUES("2583",".пупс8.","60");
INSERT INTO smile VALUES("2584",".пупс9.","60");
INSERT INTO smile VALUES("2585",".пупс10.","60");
INSERT INTO smile VALUES("2586",".пупс11.","60");
INSERT INTO smile VALUES("2589",".пупс13.","60");
INSERT INTO smile VALUES("2590",".пупс14.","60");
INSERT INTO smile VALUES("2591",".пупс15.","60");
INSERT INTO smile VALUES("2592",",9,","36");
INSERT INTO smile VALUES("2593",".пупс16.","60");
INSERT INTO smile VALUES("2594",",8,","36");
INSERT INTO smile VALUES("2595",".пупс17.","60");
INSERT INTO smile VALUES("2596",",7,","36");
INSERT INTO smile VALUES("2597",".пупс18.","60");
INSERT INTO smile VALUES("2598",",6,","36");
INSERT INTO smile VALUES("2599",".пупс19.","60");
INSERT INTO smile VALUES("2600",",5,","36");
INSERT INTO smile VALUES("2601",".пупс20.","60");
INSERT INTO smile VALUES("2602",",4,","36");
INSERT INTO smile VALUES("2603",".пупс21.","60");
INSERT INTO smile VALUES("2604",",3,","36");
INSERT INTO smile VALUES("2605",".пупс22.","60");
INSERT INTO smile VALUES("2606",",2,","36");
INSERT INTO smile VALUES("2607",".пупс23.","60");
INSERT INTO smile VALUES("2608",",1,","36");
INSERT INTO smile VALUES("2609",".пупс24.","60");
INSERT INTO smile VALUES("2610",",0,","36");
INSERT INTO smile VALUES("2611",".пупс25.","60");
INSERT INTO smile VALUES("2612",":9:","36");
INSERT INTO smile VALUES("2613",":8:","36");
INSERT INTO smile VALUES("2614",":7:","36");
INSERT INTO smile VALUES("2615",":6:","36");
INSERT INTO smile VALUES("2616",":5:","36");
INSERT INTO smile VALUES("2617",":4:","36");
INSERT INTO smile VALUES("2618",":3:","36");
INSERT INTO smile VALUES("2619",":2:","36");
INSERT INTO smile VALUES("2620",":1:","36");
INSERT INTO smile VALUES("2621",":0:","36");
INSERT INTO smile VALUES("2622",";9;","36");
INSERT INTO smile VALUES("2623",";8;","36");
INSERT INTO smile VALUES("2624",";7;","36");
INSERT INTO smile VALUES("2625",";6;","36");
INSERT INTO smile VALUES("2626",";5;","36");
INSERT INTO smile VALUES("2627",";4;","36");
INSERT INTO smile VALUES("2628",";3;","36");
INSERT INTO smile VALUES("2629",";2;","36");
INSERT INTO smile VALUES("2630",";1;","36");
INSERT INTO smile VALUES("2631",";0;","36");
INSERT INTO smile VALUES("2632","-9-","36");
INSERT INTO smile VALUES("2633","-8-","36");
INSERT INTO smile VALUES("2634","-7-","36");
INSERT INTO smile VALUES("2635","-6-","36");
INSERT INTO smile VALUES("2636","-5-","36");
INSERT INTO smile VALUES("2637","-4-","36");
INSERT INTO smile VALUES("2638","-3-","36");
INSERT INTO smile VALUES("2639","-2-","36");
INSERT INTO smile VALUES("2640","-1-","36");
INSERT INTO smile VALUES("2641","-0-","36");
INSERT INTO smile VALUES("2642",".9а.","36");
INSERT INTO smile VALUES("2643",".8а.","36");
INSERT INTO smile VALUES("2644",".7а.","36");
INSERT INTO smile VALUES("2645",".6а.","36");
INSERT INTO smile VALUES("2646",".5а.","36");
INSERT INTO smile VALUES("2647",".4а.","36");
INSERT INTO smile VALUES("2648",".3а.","36");
INSERT INTO smile VALUES("2649",".2а.","36");
INSERT INTO smile VALUES("2650",".1а.","36");
INSERT INTO smile VALUES("2651",".0а.","36");
INSERT INTO smile VALUES("2652",".9с.","36");
INSERT INTO smile VALUES("2653",".8с.","36");
INSERT INTO smile VALUES("2654",".7с.","36");
INSERT INTO smile VALUES("2655",".6с.","36");
INSERT INTO smile VALUES("2656",".5с.","36");
INSERT INTO smile VALUES("2657",".4с.","36");
INSERT INTO smile VALUES("2658",".3с.","36");
INSERT INTO smile VALUES("2659",".2с.","36");
INSERT INTO smile VALUES("2660",".1с.","36");
INSERT INTO smile VALUES("2661",".0с.","36");
INSERT INTO smile VALUES("2662",".9ц.","36");
INSERT INTO smile VALUES("2663",".8ц.","36");
INSERT INTO smile VALUES("2664",".7ц.","36");
INSERT INTO smile VALUES("2665",".6ц.","36");
INSERT INTO smile VALUES("2666",".5ц.","36");
INSERT INTO smile VALUES("2667",".4ц.","36");
INSERT INTO smile VALUES("2668",".3ц.","36");
INSERT INTO smile VALUES("2669",".2ц.","36");
INSERT INTO smile VALUES("2670",".1ц.","36");
INSERT INTO smile VALUES("2671",".0ц.","36");
INSERT INTO smile VALUES("2672",".9б.","36");
INSERT INTO smile VALUES("2673",",8б.","36");
INSERT INTO smile VALUES("2674",".7б.","36");
INSERT INTO smile VALUES("2675",".6б.","36");
INSERT INTO smile VALUES("2676",".5б.","36");
INSERT INTO smile VALUES("2677",".4б.","36");
INSERT INTO smile VALUES("2678",".3б.","36");
INSERT INTO smile VALUES("2679",".2б.","36");
INSERT INTO smile VALUES("2680",".1б.","36");
INSERT INTO smile VALUES("2681",".0б.","36");
INSERT INTO smile VALUES("2682",".9в.","36");
INSERT INTO smile VALUES("2683",".8в.","36");
INSERT INTO smile VALUES("2684",".7в.","36");
INSERT INTO smile VALUES("2685",".6в.","36");
INSERT INTO smile VALUES("2686",".5в.","36");
INSERT INTO smile VALUES("2687",".4в.","36");
INSERT INTO smile VALUES("2688",".3в.","36");
INSERT INTO smile VALUES("2689",".2в.","36");
INSERT INTO smile VALUES("2690",".1в.","36");
INSERT INTO smile VALUES("2691",".0в.","36");
INSERT INTO smile VALUES("2693",".бон60.","50");
INSERT INTO smile VALUES("2698",".джин3.","54");
INSERT INTO smile VALUES("2699",".джин4.","54");
INSERT INTO smile VALUES("2700",".джин5.","54");
INSERT INTO smile VALUES("2701",".джин6.","54");
INSERT INTO smile VALUES("2702",".джин7.","54");
INSERT INTO smile VALUES("2703",".джин8.","54");
INSERT INTO smile VALUES("2705",".джин9.","54");
INSERT INTO smile VALUES("2706",".джин10.","54");
INSERT INTO smile VALUES("2707",".джин11.","54");
INSERT INTO smile VALUES("2708",".джин12.","54");
INSERT INTO smile VALUES("2709",".джин13.","54");
INSERT INTO smile VALUES("2713",".джин14.","54");
INSERT INTO smile VALUES("2714",".адм52.","28");
INSERT INTO smile VALUES("2715",".адм53.","28");
INSERT INTO smile VALUES("2716",".эро24.","49");
INSERT INTO smile VALUES("2717",".эро25.","49");
INSERT INTO smile VALUES("2718",".эро26.","49");
INSERT INTO smile VALUES("2719",".эро27.","49");
INSERT INTO smile VALUES("2720",".эро28.","49");
INSERT INTO smile VALUES("2721",".эро29.","49");
INSERT INTO smile VALUES("2722",".эро30.","49");
INSERT INTO smile VALUES("2723",".эро31.","49");
INSERT INTO smile VALUES("2724",".эро32.","49");
INSERT INTO smile VALUES("2725",".эро33.","49");
INSERT INTO smile VALUES("2726",".эро34.","49");
INSERT INTO smile VALUES("2727",".эро35.","49");
INSERT INTO smile VALUES("2728",".эро36.","49");
INSERT INTO smile VALUES("2740",".хай1.","3");
INSERT INTO smile VALUES("2762",".ржаш.","20");
INSERT INTO smile VALUES("2765",".цем.","11");
INSERT INTO smile VALUES("2766",".фейерверк.","11");
INSERT INTO smile VALUES("2772",".бах.","3");
INSERT INTO smile VALUES("2768",".надиване.","11");
INSERT INTO smile VALUES("2769",".поццел.","11");
INSERT INTO smile VALUES("2770",".влюблён.","11");
INSERT INTO smile VALUES("2771",".цемм.","11");
INSERT INTO smile VALUES("2774",".злость.","3");
INSERT INTO smile VALUES("2775",".хуху.","3");
INSERT INTO smile VALUES("4420",".пр29.","83");
INSERT INTO smile VALUES("5476","LOVE ME","66");
INSERT INTO smile VALUES("4419",".пр28.","83");
INSERT INTO smile VALUES("2808",".Jlegenda.","10");
INSERT INTO smile VALUES("2853",".атата2. ","5");
INSERT INTO smile VALUES("2854",".бита.","5");
INSERT INTO smile VALUES("2855",".битадев. ","5");
INSERT INTO smile VALUES("4407",".пр16.","83");
INSERT INTO smile VALUES("4408",".пр17.","83");
INSERT INTO smile VALUES("2862",".адм54.","28");
INSERT INTO smile VALUES("2864",".спасдед.","13");
INSERT INTO smile VALUES("2868",":01.","8");
INSERT INTO smile VALUES("2869",":02.","8");
INSERT INTO smile VALUES("2870",":03.","8");
INSERT INTO smile VALUES("2871",":04.","8");
INSERT INTO smile VALUES("2872",":05.","8");
INSERT INTO smile VALUES("2873",":06.","8");
INSERT INTO smile VALUES("2874",":07.","8");
INSERT INTO smile VALUES("2875",":08.","8");
INSERT INTO smile VALUES("2876",":09.","8");
INSERT INTO smile VALUES("2877",":10.","8");
INSERT INTO smile VALUES("2878",":11.","8");
INSERT INTO smile VALUES("2879",":12.","8");
INSERT INTO smile VALUES("2880",":д.д1. ","3");
INSERT INTO smile VALUES("2881",".д.д2. ","3");
INSERT INTO smile VALUES("2883",".д.д4.","3");
INSERT INTO smile VALUES("2884",".д.д3.","3");
INSERT INTO smile VALUES("2885",".д.д5.","3");
INSERT INTO smile VALUES("2886",".дразнил.","3");
INSERT INTO smile VALUES("2887",".д.д7.","3");
INSERT INTO smile VALUES("2888",".д.д8.","3");
INSERT INTO smile VALUES("2889",".д.д9.","3");
INSERT INTO smile VALUES("2890",".д.д2.","3");
INSERT INTO smile VALUES("2891",".атата3. ","5");
INSERT INTO smile VALUES("2892",".ниже. ","3");
INSERT INTO smile VALUES("2893",".дыы.","3");
INSERT INTO smile VALUES("2894",".дмоя.","3");
INSERT INTO smile VALUES("2895",".дприв.","3");
INSERT INTO smile VALUES("2896",".дприв1.","3");
INSERT INTO smile VALUES("2969",".бон61.","50");
INSERT INTO smile VALUES("2970",".бон62.","50");
INSERT INTO smile VALUES("2971",".бон63.","50");
INSERT INTO smile VALUES("4406",".пр15.","83");
INSERT INTO smile VALUES("2980",".бон65.","50");
INSERT INTO smile VALUES("2993",".форум1.","65");
INSERT INTO smile VALUES("2994",".форум2.","65");
INSERT INTO smile VALUES("2995",".форум3.","65");
INSERT INTO smile VALUES("2996",".форум4.","65");
INSERT INTO smile VALUES("2999",".форум5.","65");
INSERT INTO smile VALUES("3000",".форум6.","65");
INSERT INTO smile VALUES("3002",".форум8.","65");
INSERT INTO smile VALUES("3003",".форум9.","65");
INSERT INTO smile VALUES("3004",".форум10.","65");
INSERT INTO smile VALUES("3005",".форум11.","65");
INSERT INTO smile VALUES("3006",".форум12.","65");
INSERT INTO smile VALUES("3007",".форум13.","65");
INSERT INTO smile VALUES("3008",".форум14.","65");
INSERT INTO smile VALUES("3009",".форум15.","65");
INSERT INTO smile VALUES("3010",".форум16.","65");
INSERT INTO smile VALUES("3011",".форумй7.","65");
INSERT INTO smile VALUES("3012",".форум18.","65");
INSERT INTO smile VALUES("4386",".бон71.","50");
INSERT INTO smile VALUES("4385",".бон70.","50");
INSERT INTO smile VALUES("3044",".поц58.","45");
INSERT INTO smile VALUES("3045",".поц59.","45");
INSERT INTO smile VALUES("3046",".поц60.","45");
INSERT INTO smile VALUES("3047",".поц61.","45");
INSERT INTO smile VALUES("3048",".поц62.","45");
INSERT INTO smile VALUES("3049",".поц63.","45");
INSERT INTO smile VALUES("3050",".поц64.","45");
INSERT INTO smile VALUES("3051",".поц65.","45");
INSERT INTO smile VALUES("3052",".поц66.","45");
INSERT INTO smile VALUES("3053",".поц67.","45");
INSERT INTO smile VALUES("3062",".8мм.","36");
INSERT INTO smile VALUES("3063",".9мм.","36");
INSERT INTO smile VALUES("3102",".котя.","11");
INSERT INTO smile VALUES("3103",".ялю.","11");
INSERT INTO smile VALUES("3104",".ялю2.","11");
INSERT INTO smile VALUES("3114",".3бб.","36");
INSERT INTO smile VALUES("3113",".2бб.","36");
INSERT INTO smile VALUES("3112",".1бб.","36");
INSERT INTO smile VALUES("3111",".0бб.","36");
INSERT INTO smile VALUES("3115",".4бб.","36");
INSERT INTO smile VALUES("3116",".5бб.","36");
INSERT INTO smile VALUES("3117",".6бб.","36");
INSERT INTO smile VALUES("3118",".7бб.","36");
INSERT INTO smile VALUES("3119",".8бб.","36");
INSERT INTO smile VALUES("3120",".9бб.","36");
INSERT INTO smile VALUES("3121",".0сс.","36");
INSERT INTO smile VALUES("3122",".1сс.","36");
INSERT INTO smile VALUES("3123",".2сс.","36");
INSERT INTO smile VALUES("3124",".3сс.","36");
INSERT INTO smile VALUES("3125",".4сс.","36");
INSERT INTO smile VALUES("3126",".5сс.","36");
INSERT INTO smile VALUES("3127",".6сс.","36");
INSERT INTO smile VALUES("3128",".7сс.","36");
INSERT INTO smile VALUES("3129",".8сс.","36");
INSERT INTO smile VALUES("3130",".9сс.","36");
INSERT INTO smile VALUES("3131",".0цц.","36");
INSERT INTO smile VALUES("3132",".1цц.","36");
INSERT INTO smile VALUES("3133",".2цц.","36");
INSERT INTO smile VALUES("3136",".3цц.","36");
INSERT INTO smile VALUES("3137",".4цц.","36");
INSERT INTO smile VALUES("3138",".5цц.","36");
INSERT INTO smile VALUES("3139",".6цц.","36");
INSERT INTO smile VALUES("3140",".7цц.","36");
INSERT INTO smile VALUES("3141",".8цц.","36");
INSERT INTO smile VALUES("3142",".9цц.","36");
INSERT INTO smile VALUES("3143",".1ж.","36");
INSERT INTO smile VALUES("3144",".2ж.","36");
INSERT INTO smile VALUES("3145",".3ж.","36");
INSERT INTO smile VALUES("3146",".4ж.","36");
INSERT INTO smile VALUES("3147",".5ж.","36");
INSERT INTO smile VALUES("3148",".6ж.","36");
INSERT INTO smile VALUES("3149",".7ж.","36");
INSERT INTO smile VALUES("3150",".8ж.","36");
INSERT INTO smile VALUES("3151",".9ж.","36");
INSERT INTO smile VALUES("3152",".0ж.","36");
INSERT INTO smile VALUES("3153","0кк","36");
INSERT INTO smile VALUES("3154","1кк","36");
INSERT INTO smile VALUES("3155","2кк","36");
INSERT INTO smile VALUES("3156","3кк","36");
INSERT INTO smile VALUES("3157","4кк","36");
INSERT INTO smile VALUES("3158","5кк","36");
INSERT INTO smile VALUES("3159","6кк","36");
INSERT INTO smile VALUES("3160","7кк","36");
INSERT INTO smile VALUES("3161","8кк","36");
INSERT INTO smile VALUES("3162","9кк","36");
INSERT INTO smile VALUES("4405",".пр14.","83");
INSERT INTO smile VALUES("3164",".адм55.","28");
INSERT INTO smile VALUES("3167",".люб1.","11");
INSERT INTO smile VALUES("3168",".эро37.","49");
INSERT INTO smile VALUES("3169",".эро38.","49");
INSERT INTO smile VALUES("3170",".эро39.","49");
INSERT INTO smile VALUES("3171",".эро40.","49");
INSERT INTO smile VALUES("3172",".адм56.","28");
INSERT INTO smile VALUES("3174",".эро41.","49");
INSERT INTO smile VALUES("3175",".эро42.","49");
INSERT INTO smile VALUES("3176",".жро43.","49");
INSERT INTO smile VALUES("3177",".адм57.","28");
INSERT INTO smile VALUES("4404",".пр13.","83");
INSERT INTO smile VALUES("4403",".пр12.","83");
INSERT INTO smile VALUES("3223",".адм58.","28");
INSERT INTO smile VALUES("3224",".адм59.","28");
INSERT INTO smile VALUES("3225",".адм60.","28");
INSERT INTO smile VALUES("3226",".адм61.","28");
INSERT INTO smile VALUES("3227",".адм62.","28");
INSERT INTO smile VALUES("4402",".пр11.","83");
INSERT INTO smile VALUES("3236",".поц68.","45");
INSERT INTO smile VALUES("3237",".поц69.","45");
INSERT INTO smile VALUES("3238",".поц70.","45");
INSERT INTO smile VALUES("3239",".муз. ","12");
INSERT INTO smile VALUES("3269",".кофелт. ","7");
INSERT INTO smile VALUES("3270",".конф. ","7");
INSERT INTO smile VALUES("3271",".ч1.","7");
INSERT INTO smile VALUES("3272",".ч2.","7");
INSERT INTO smile VALUES("3273",".ч3.","7");
INSERT INTO smile VALUES("3281",".поц71.","45");
INSERT INTO smile VALUES("3285",".ч4.","7");
INSERT INTO smile VALUES("4433",".пр42.","83");
INSERT INTO smile VALUES("4432",".пр41.","83");
INSERT INTO smile VALUES("4431"," .пр40.","83");
INSERT INTO smile VALUES("4430",".пр39.","83");
INSERT INTO smile VALUES("4429",".пр38.","83");
INSERT INTO smile VALUES("4428",".пр37.","83");
INSERT INTO smile VALUES("4427",".пр36.","83");
INSERT INTO smile VALUES("4426",".пр35.","83");
INSERT INTO smile VALUES("4425",".пр34.","83");
INSERT INTO smile VALUES("3304",".кон25.","57");
INSERT INTO smile VALUES("3306",".борщ. ","7");
INSERT INTO smile VALUES("4341","Саня","66");
INSERT INTO smile VALUES("3334",".поц72.","45");
INSERT INTO smile VALUES("3338",".дмаме. ","13");
INSERT INTO smile VALUES("4401",".пр10.","83");
INSERT INTO smile VALUES("3373",".слоги. ","65");
INSERT INTO smile VALUES("3374",":13.","8");
INSERT INTO smile VALUES("3392",".поц74.","45");
INSERT INTO smile VALUES("3398",".игрыраз. ","65");
INSERT INTO smile VALUES("3432",".поц75.","45");
INSERT INTO smile VALUES("3433",".моргает1.","3");
INSERT INTO smile VALUES("3434",".бинокль1.","3");
INSERT INTO smile VALUES("3435",".онлайн1.","3");
INSERT INTO smile VALUES("3436",".офф1.","3");
INSERT INTO smile VALUES("3437",".пришла1.","3");
INSERT INTO smile VALUES("3438",".туктук1.","3");
INSERT INTO smile VALUES("3439",".драка11.","5");
INSERT INTO smile VALUES("3440",".выстрел1.","5");
INSERT INTO smile VALUES("3441",".пинок1.","5");
INSERT INTO smile VALUES("3442",".адм63.","28");
INSERT INTO smile VALUES("3443",".еда1.","7");
INSERT INTO smile VALUES("3444",".еда2.","7");
INSERT INTO smile VALUES("3445",".еда3.","7");
INSERT INTO smile VALUES("3446",".еда4.","7");
INSERT INTO smile VALUES("3447",".еда5.","7");
INSERT INTO smile VALUES("3448",".еда6.","7");
INSERT INTO smile VALUES("3449",".еда7.","7");
INSERT INTO smile VALUES("3450",".еда8.","7");
INSERT INTO smile VALUES("3451",".еда9.","7");
INSERT INTO smile VALUES("3452",".еда10.","7");
INSERT INTO smile VALUES("3453",".еда11.","7");
INSERT INTO smile VALUES("3454",".еда12.","7");
INSERT INTO smile VALUES("3455",".еда13.","7");
INSERT INTO smile VALUES("3456",".еда14.","7");
INSERT INTO smile VALUES("3457",".еда15.","7");
INSERT INTO smile VALUES("3458",".еда16.","7");
INSERT INTO smile VALUES("3459",".еда17.","7");
INSERT INTO smile VALUES("3460",".еда18.","7");
INSERT INTO smile VALUES("3461",".еда19.","7");
INSERT INTO smile VALUES("3462",".еда20.","7");
INSERT INTO smile VALUES("3463",".еда21.","7");
INSERT INTO smile VALUES("3464",".еда22.","7");
INSERT INTO smile VALUES("3465",".еда23.","7");
INSERT INTO smile VALUES("3466",".еда24.","7");
INSERT INTO smile VALUES("3467",".еда25.","7");
INSERT INTO smile VALUES("3468",".еда26.","7");
INSERT INTO smile VALUES("3469",".еда27.","7");
INSERT INTO smile VALUES("3470",".еда28.","7");
INSERT INTO smile VALUES("3471",".еда29.","7");
INSERT INTO smile VALUES("3472",".еда30.","7");
INSERT INTO smile VALUES("3473",".еда31.","7");
INSERT INTO smile VALUES("3474",".еда32.","7");
INSERT INTO smile VALUES("3475",".еда33.","7");
INSERT INTO smile VALUES("3476",".еда34.","7");
INSERT INTO smile VALUES("3477",".еда35.","7");
INSERT INTO smile VALUES("3478",".еда36.","7");
INSERT INTO smile VALUES("3479",".еда37.","7");
INSERT INTO smile VALUES("3480",".еда38.","7");
INSERT INTO smile VALUES("3481",".еда39.","7");
INSERT INTO smile VALUES("3482",".еда40.","7");
INSERT INTO smile VALUES("3483",".еда41.","7");
INSERT INTO smile VALUES("3484",".еда42.","7");
INSERT INTO smile VALUES("3485",".еда43.","7");
INSERT INTO smile VALUES("3486",".еда44.","7");
INSERT INTO smile VALUES("3487",".еда45.","7");
INSERT INTO smile VALUES("3488",".еда46.","7");
INSERT INTO smile VALUES("3489",".еда47.","7");
INSERT INTO smile VALUES("3490",".еда48.","7");
INSERT INTO smile VALUES("3491",".еда49.","7");
INSERT INTO smile VALUES("3492",".еда50.","7");
INSERT INTO smile VALUES("3493",".еда51.","7");
INSERT INTO smile VALUES("3494",".еда52.","7");
INSERT INTO smile VALUES("3495",".еда53.","7");
INSERT INTO smile VALUES("3496",".еда54.","7");
INSERT INTO smile VALUES("3497",".еда55.","7");
INSERT INTO smile VALUES("3498",".еда56.","7");
INSERT INTO smile VALUES("3499",".еда57.","7");
INSERT INTO smile VALUES("3500",".еда58.","7");
INSERT INTO smile VALUES("3501",".еда59.","7");
INSERT INTO smile VALUES("3502",".еда60.","7");
INSERT INTO smile VALUES("3503",".еда61.","7");
INSERT INTO smile VALUES("3504",".женаправа. ","3");
INSERT INTO smile VALUES("3505",".тыц. ","3");
INSERT INTO smile VALUES("3506",".см1.","3");
INSERT INTO smile VALUES("3507",".ржуваляюсь. ","3");
INSERT INTO smile VALUES("3508",".бееее. ","3");
INSERT INTO smile VALUES("3509",".несмущай. ","3");
INSERT INTO smile VALUES("3510",".см2.","3");
INSERT INTO smile VALUES("3511",".тактеинадо.","3");
INSERT INTO smile VALUES("3512",".беременна. ","3");
INSERT INTO smile VALUES("3513",".хтотута. ","3");
INSERT INTO smile VALUES("3514",".см3.","3");
INSERT INTO smile VALUES("3515",".салют. ","3");
INSERT INTO smile VALUES("3516",".ооок. ","3");
INSERT INTO smile VALUES("3517",".глазкии.","3");
INSERT INTO smile VALUES("3518",".кукумой. ","3");
INSERT INTO smile VALUES("3519",".губазакатка. ","3");
INSERT INTO smile VALUES("3520",".гдевыход. ","3");
INSERT INTO smile VALUES("3521",".бойсябога. ","3");
INSERT INTO smile VALUES("3522",".кукумоя. ","3");
INSERT INTO smile VALUES("3523",".пописюрику.","3");
INSERT INTO smile VALUES("3524",".опятьпьете. ","3");
INSERT INTO smile VALUES("3525",".оболдеть. ","3");
INSERT INTO smile VALUES("3526",".дайпять. ","3");
INSERT INTO smile VALUES("3527",".прива. ","3");
INSERT INTO smile VALUES("3528",".годает. ","3");
INSERT INTO smile VALUES("3529",".даладно. ","3");
INSERT INTO smile VALUES("3530",".блять. ","3");
INSERT INTO smile VALUES("3531",".пин. ","3");
INSERT INTO smile VALUES("3532",".идем. ","3");
INSERT INTO smile VALUES("3533","Хочешьувидеть.","3");
INSERT INTO smile VALUES("3534",".яхорошая. ","3");
INSERT INTO smile VALUES("3535",".ёпть. ","3");
INSERT INTO smile VALUES("3536",".клево. ","3");
INSERT INTO smile VALUES("3537",".ненадоляля. ","3");
INSERT INTO smile VALUES("3538",".ойбоюсь. ","3");
INSERT INTO smile VALUES("3539",".молчу. ","3");
INSERT INTO smile VALUES("3540",".ааапипец. ","3");
INSERT INTO smile VALUES("3541",".лютя. ","3");
INSERT INTO smile VALUES("3542",".нука. ","3");
INSERT INTO smile VALUES("3543",".всехвчс. ","3");
INSERT INTO smile VALUES("3544",".минехрусна. ","3");
INSERT INTO smile VALUES("3545",".идисбогом. ","3");
INSERT INTO smile VALUES("3546",".дада. ","3");
INSERT INTO smile VALUES("3547",".хулиганка. ","3");
INSERT INTO smile VALUES("3548",".тебе1.","3");
INSERT INTO smile VALUES("3549",".см4.","3");
INSERT INTO smile VALUES("3550",".явытряхну. ","3");
INSERT INTO smile VALUES("3551",".слышишь. ","3");
INSERT INTO smile VALUES("3552",".ялапа. ","3");
INSERT INTO smile VALUES("3553",".смехдатолько. ","3");
INSERT INTO smile VALUES("3554",".досталовсе. ","3");
INSERT INTO smile VALUES("3555",".вайвай. ","3");
INSERT INTO smile VALUES("3556",".пляжесть. ","3");
INSERT INTO smile VALUES("3557",".нини. ","3");
INSERT INTO smile VALUES("3558",".ипонамать. ","3");
INSERT INTO smile VALUES("3559",".сескажешь. ","3");
INSERT INTO smile VALUES("3560",".каклох. ","3");
INSERT INTO smile VALUES("3561",".ватэт. ","3");
INSERT INTO smile VALUES("3562",".злойты. ","3");
INSERT INTO smile VALUES("3563",".незлилапулю. ","3");
INSERT INTO smile VALUES("3567",".люб2.","11");
INSERT INTO smile VALUES("4400",".пр9.","83");
INSERT INTO smile VALUES("3569",".адм64.","28");
INSERT INTO smile VALUES("3570",".адм65.","28");
INSERT INTO smile VALUES("4399",".пр8.","83");
INSERT INTO smile VALUES("3572",".адм66.","28");
INSERT INTO smile VALUES("4398",".пр7.","83");
INSERT INTO smile VALUES("3574",".админ67.","28");
INSERT INTO smile VALUES("3575",".админ68.","28");
INSERT INTO smile VALUES("4397",".пр6.","83");
INSERT INTO smile VALUES("3579",".адммн69.","28");
INSERT INTO smile VALUES("3580",".адм70.","28");
INSERT INTO smile VALUES("4396",".пр5.","83");
INSERT INTO smile VALUES("3582",".админ71.","28");
INSERT INTO smile VALUES("3583",".адм72.","28");
INSERT INTO smile VALUES("3584",".адм73.","28");
INSERT INTO smile VALUES("4395",".пр4.","83");
INSERT INTO smile VALUES("3586",".адм74.","28");
INSERT INTO smile VALUES("3588",".адм75.","28");
INSERT INTO smile VALUES("3589",".адм76.","28");
INSERT INTO smile VALUES("3590",".адм77.","28");
INSERT INTO smile VALUES("3591",".адм78.","28");
INSERT INTO smile VALUES("3592",".адм79.","28");
INSERT INTO smile VALUES("4394",".пр3.","83");
INSERT INTO smile VALUES("3594",".адм80.","28");
INSERT INTO smile VALUES("3595",".адм81.","28");
INSERT INTO smile VALUES("4393",".пр2.","83");
INSERT INTO smile VALUES("3597",".адм82.","28");
INSERT INTO smile VALUES("3598",".адм83.","28");
INSERT INTO smile VALUES("3604",".адм84.","28");
INSERT INTO smile VALUES("3605",".адм85.","28");
INSERT INTO smile VALUES("3606",".адм86.","28");
INSERT INTO smile VALUES("3607",".адм87.","28");
INSERT INTO smile VALUES("3608",".адм88.","28");
INSERT INTO smile VALUES("3609",".адм89.","28");
INSERT INTO smile VALUES("3610",".адм90.","28");
INSERT INTO smile VALUES("3611",".адм91.","28");
INSERT INTO smile VALUES("3612",".адм92.","28");
INSERT INTO smile VALUES("3613",".адм93.","28");
INSERT INTO smile VALUES("3614",".адм94.","28");
INSERT INTO smile VALUES("3615",".адм95.","28");
INSERT INTO smile VALUES("3616",".адм96.","28");
INSERT INTO smile VALUES("3617",".адм97.","28");
INSERT INTO smile VALUES("3618",".адм98.","28");
INSERT INTO smile VALUES("3620",".адм99.","28");
INSERT INTO smile VALUES("3621",".адм100.","28");
INSERT INTO smile VALUES("3622",".адм101.","28");
INSERT INTO smile VALUES("3623",".адм102.","28");
INSERT INTO smile VALUES("3624",".адм103.","28");
INSERT INTO smile VALUES("3627",".адм104.","28");
INSERT INTO smile VALUES("3628",".адм105.","28");
INSERT INTO smile VALUES("3629",".ккк. ","65");
INSERT INTO smile VALUES("3683",".ангел1.","65");
INSERT INTO smile VALUES("3684",".орелрешка. ","65");
INSERT INTO smile VALUES("3686",".решка. ","65");
INSERT INTO smile VALUES("3687",".орел. ","65");
INSERT INTO smile VALUES("3688",".скрудж. ","65");
INSERT INTO smile VALUES("3689",".акц3.","65");
INSERT INTO smile VALUES("3690",".апельсин1.","65");
INSERT INTO smile VALUES("3691",".апельсин2.","65");
INSERT INTO smile VALUES("3692",".апельсин3.","65");
INSERT INTO smile VALUES("3693",".фраза1.","65");
INSERT INTO smile VALUES("3695",".мыши. ","65");
INSERT INTO smile VALUES("3696",".анкета1.","65");
INSERT INTO smile VALUES("3697",".форум22.","65");
INSERT INTO smile VALUES("3698",".зарница. ","65");
INSERT INTO smile VALUES("3699",".аванед. ","65");
INSERT INTO smile VALUES("3700",".корольбес. ","65");
INSERT INTO smile VALUES("3701",".королевабес. ","65");
INSERT INTO smile VALUES("3702",".корона1.","65");
INSERT INTO smile VALUES("3703",".друзья1.","65");
INSERT INTO smile VALUES("3704",".друзья2.","65");
INSERT INTO smile VALUES("3705",".форум23.","65");
INSERT INTO smile VALUES("3706",".сокровище1.","65");
INSERT INTO smile VALUES("3822",".монеты222.","65");
INSERT INTO smile VALUES("3823",".монеты333.","65");
INSERT INTO smile VALUES("3824",".монеты444.","65");
INSERT INTO smile VALUES("3825",".поймайвора. ","65");
INSERT INTO smile VALUES("3826",".золото555.","65");
INSERT INTO smile VALUES("3827",".доллар123.","65");
INSERT INTO smile VALUES("3828",".корона2.","65");
INSERT INTO smile VALUES("3829",".жасмин222.","65");
INSERT INTO smile VALUES("3831",".еда62.","7");
INSERT INTO smile VALUES("3832",".еда63.","7");
INSERT INTO smile VALUES("3833",".еда64.","7");
INSERT INTO smile VALUES("3834",".варимкампот. ","65");
INSERT INTO smile VALUES("3874",".угадайпесню. ","65");
INSERT INTO smile VALUES("3875",".фотодуэль222.","65");
INSERT INTO smile VALUES("4442",".пр50.","83");
INSERT INTO smile VALUES("3944",".туфли1.","65");
INSERT INTO smile VALUES("3945",".форум24.","65");
INSERT INTO smile VALUES("3946",".хэллоуин1.","65");
INSERT INTO smile VALUES("3947",".пират1.","65");
INSERT INTO smile VALUES("3948",".пират2.","65");
INSERT INTO smile VALUES("3949",".пират3.","65");
INSERT INTO smile VALUES("3950",".звезда1.","65");
INSERT INTO smile VALUES("3951",".форум25.","65");
INSERT INTO smile VALUES("3952",".покадром. ","65");
INSERT INTO smile VALUES("3953",".форум26.","65");
INSERT INTO smile VALUES("3954",".форум27.","65");
INSERT INTO smile VALUES("3955",".форум28.","65");
INSERT INTO smile VALUES("3956",".темазакрыта. ","65");
INSERT INTO smile VALUES("3957",".форум29.","65");
INSERT INTO smile VALUES("3958",".брак1.","65");
INSERT INTO smile VALUES("3959",".брак2.","65");
INSERT INTO smile VALUES("3960",".выбериподарок. ","65");
INSERT INTO smile VALUES("3962",".10руб.","65");
INSERT INTO smile VALUES("3963",".5000монет.","65");
INSERT INTO smile VALUES("3964",".15000баллов.","65");
INSERT INTO smile VALUES("3965",".золотаярыбка. ","65");
INSERT INTO smile VALUES("3968",".сундуки1.","65");
INSERT INTO smile VALUES("3969",".алладиннасутки. ","65");
INSERT INTO smile VALUES("3970",".сундуки2.","65");
INSERT INTO smile VALUES("3978",".доброзло1.","65");
INSERT INTO smile VALUES("3979",".форум30.","65");
INSERT INTO smile VALUES("3980",".приведидр1.","65");
INSERT INTO smile VALUES("3981",".пригласидр. ","65");
INSERT INTO smile VALUES("3982",".угадайкино1.","65");
INSERT INTO smile VALUES("3983",".форум31.","65");
INSERT INTO smile VALUES("3984",".бракнасутки1.","65");
INSERT INTO smile VALUES("3985",".парасайта. ","65");
INSERT INTO smile VALUES("3986",".аванидели1.","65");
INSERT INTO smile VALUES("3987",".королькоролева1.","65");
INSERT INTO smile VALUES("3988",".чейтуфля1.","65");
INSERT INTO smile VALUES("3991",".статдня2.","65");
INSERT INTO smile VALUES("3992",".статдня3.","65");
INSERT INTO smile VALUES("3993",".творчество. ","65");
INSERT INTO smile VALUES("3994",".внимание222.","65");
INSERT INTO smile VALUES("3998",".действие1.","65");
INSERT INTO smile VALUES("4000",".люблюза1.","65");
INSERT INTO smile VALUES("4002",".миссдекабрь. ","57");
INSERT INTO smile VALUES("4003",".мистердекабрь. ","57");
INSERT INTO smile VALUES("4042",".еда65.","7");
INSERT INTO smile VALUES("4043",".еда66.","7");
INSERT INTO smile VALUES("4044",".еда67.","7");
INSERT INTO smile VALUES("4045",".еда68.","7");
INSERT INTO smile VALUES("4046",".еда69.","7");
INSERT INTO smile VALUES("4047",".еда70.","7");
INSERT INTO smile VALUES("4048",".еда71.","7");
INSERT INTO smile VALUES("4049",".еда72.","7");
INSERT INTO smile VALUES("4050",".еда73.","7");
INSERT INTO smile VALUES("4051",".еда74.","7");
INSERT INTO smile VALUES("4052",".еда75.","7");
INSERT INTO smile VALUES("4053",".еда76.","7");
INSERT INTO smile VALUES("4054",".еда77.","7");
INSERT INTO smile VALUES("4055",".еда78.","7");
INSERT INTO smile VALUES("4056",".еда79.","7");
INSERT INTO smile VALUES("4057",".еда80.","7");
INSERT INTO smile VALUES("4058",".еда81.","7");
INSERT INTO smile VALUES("4059",".еда82.","7");
INSERT INTO smile VALUES("4060",".еда83.","7");
INSERT INTO smile VALUES("4061",".еда84.","7");
INSERT INTO smile VALUES("4062",".еда85.","7");
INSERT INTO smile VALUES("4063",".еда86.","7");
INSERT INTO smile VALUES("4064",".еда87.","7");
INSERT INTO smile VALUES("4065",".еда88.","7");
INSERT INTO smile VALUES("4066",".еда89.","7");
INSERT INTO smile VALUES("4067",".еда90.","7");
INSERT INTO smile VALUES("4068",".еда91.","7");
INSERT INTO smile VALUES("4069",".еда92.","7");
INSERT INTO smile VALUES("4070",".еда93.","7");
INSERT INTO smile VALUES("4071",".еда94.","7");
INSERT INTO smile VALUES("4072",".еда95.","7");
INSERT INTO smile VALUES("4073",".еда96.","7");
INSERT INTO smile VALUES("4074",".еда97.","7");
INSERT INTO smile VALUES("4075",".еда98.","7");
INSERT INTO smile VALUES("4081",".бон66.","50");
INSERT INTO smile VALUES("4085",".бон67.","50");
INSERT INTO smile VALUES("4086",".бон68.","50");
INSERT INTO smile VALUES("4087",".бон69.","50");
INSERT INTO smile VALUES("4092",".еда99.","7");
INSERT INTO smile VALUES("4093",".еда100.","7");
INSERT INTO smile VALUES("4094",".еда101.","7");
INSERT INTO smile VALUES("4095",".еда102.","7");
INSERT INTO smile VALUES("4096",".еда103.","7");
INSERT INTO smile VALUES("4097",".еда104.","7");
INSERT INTO smile VALUES("4098",".еда105.","7");
INSERT INTO smile VALUES("4099",".еда106.","7");
INSERT INTO smile VALUES("4100",".еда107.","7");
INSERT INTO smile VALUES("4101",".еда108.","7");
INSERT INTO smile VALUES("4104",".цвет39.","19");
INSERT INTO smile VALUES("5317",".пр57.","83");
INSERT INTO smile VALUES("4448",".пр56.","83");
INSERT INTO smile VALUES("4447",".пр55.","83");
INSERT INTO smile VALUES("4446",".пр54.","83");
INSERT INTO smile VALUES("4445",".пр53.","83");
INSERT INTO smile VALUES("4415",".пр24.","83");
INSERT INTO smile VALUES("4416",".пр25.","83");
INSERT INTO smile VALUES("4417",".пр26.","83");
INSERT INTO smile VALUES("4418",".пр27.","83");
INSERT INTO smile VALUES("4142",":14.","8");
INSERT INTO smile VALUES("4144",".голодныйадмин. ","65");
INSERT INTO smile VALUES("4145",".джин1.","54");
INSERT INTO smile VALUES("4146",".джин2.","54");
INSERT INTO smile VALUES("4147",".джин3.","54");
INSERT INTO smile VALUES("4148",".джин4.","54");
INSERT INTO smile VALUES("4149",".джин555.","54");
INSERT INTO smile VALUES("4151",".джин666.","54");
INSERT INTO smile VALUES("4173",":15.","8");
INSERT INTO smile VALUES("4174",":16.","8");
INSERT INTO smile VALUES("4175",":17.","8");
INSERT INTO smile VALUES("4441",".пр49.","83");
INSERT INTO smile VALUES("4440",".пр48.","83");
INSERT INTO smile VALUES("4439",".пр47.","83");
INSERT INTO smile VALUES("4438",".пр46.","83");
INSERT INTO smile VALUES("4437",".пр45.","83");
INSERT INTO smile VALUES("4435",".пр43.","83");
INSERT INTO smile VALUES("4436",".пр44.","83");
INSERT INTO smile VALUES("4234",".поц76.","45");
INSERT INTO smile VALUES("4356","Girl Style","66");
INSERT INTO smile VALUES("4251",".эро44.","49");
INSERT INTO smile VALUES("4252",".эро45.","49");
INSERT INTO smile VALUES("4253",".эро46.","49");
INSERT INTO smile VALUES("4254",".эро47.","49");
INSERT INTO smile VALUES("4255",".эро48.","49");
INSERT INTO smile VALUES("4256",".эро49.","49");
INSERT INTO smile VALUES("4257",".эро50.","49");
INSERT INTO smile VALUES("4258",".эро51.","49");
INSERT INTO smile VALUES("4259",".эро52.","49");
INSERT INTO smile VALUES("4260",".эро53.","49");
INSERT INTO smile VALUES("4268",".поц77.","45");
INSERT INTO smile VALUES("4269",".поц78.","45");
INSERT INTO smile VALUES("4270",".поц79.","45");
INSERT INTO smile VALUES("4271",".поц80.","45");
INSERT INTO smile VALUES("4272",".поц81.","45");
INSERT INTO smile VALUES("4273",".поц82.","45");
INSERT INTO smile VALUES("4274",".поц83.","45");
INSERT INTO smile VALUES("4275",".поц84.","45");
INSERT INTO smile VALUES("4276",".поц85.","45");
INSERT INTO smile VALUES("4277",".поц86.","45");
INSERT INTO smile VALUES("4278",".поц87.","45");
INSERT INTO smile VALUES("4279",".поц88.","45");
INSERT INTO smile VALUES("4280",".поц89.","45");
INSERT INTO smile VALUES("4281",".поц90.","45");
INSERT INTO smile VALUES("4282",".поц91.","45");
INSERT INTO smile VALUES("4284",".туфли2.","65");
INSERT INTO smile VALUES("4285",".туфли3.","65");
INSERT INTO smile VALUES("4286",".признание. ","65");
INSERT INTO smile VALUES("4287",".свадьб14.","65");
INSERT INTO smile VALUES("4288",".топ10.","65");
INSERT INTO smile VALUES("4289",".фотодуэль333.","65");
INSERT INTO smile VALUES("4290",".признание1.","65");
INSERT INTO smile VALUES("4291",".дней15.","65");
INSERT INTO smile VALUES("4293",".песнинов. ","65");
INSERT INTO smile VALUES("4294",".дней14.","65");
INSERT INTO smile VALUES("4295",".ктоподмаской. ","65");
INSERT INTO smile VALUES("4296",".ктоподмаской1.","65");
INSERT INTO smile VALUES("4297",".признание2.","65");
INSERT INTO smile VALUES("4298",".ан2.","65");
INSERT INTO smile VALUES("4299",".любить1.","65");
INSERT INTO smile VALUES("4424",".пр33.","83");
INSERT INTO smile VALUES("4423",".пр32.","83");
INSERT INTO smile VALUES("4422",".пр31.","83");
INSERT INTO smile VALUES("4443",".пр51.","83");
INSERT INTO smile VALUES("4444",".пр52.","83");
INSERT INTO smile VALUES("4332","Gentle_Angel,","66");
INSERT INTO smile VALUES("4333","Bagira903","66");
INSERT INTO smile VALUES("4334","БеЗуМнАя_БрЮнЕтКа","66");
INSERT INTO smile VALUES("4392",".пр.","83");
INSERT INTO smile VALUES("4336","Зараза","66");
INSERT INTO smile VALUES("4337","LOVE ME___","66");
INSERT INTO smile VALUES("4338","Olenka","66");
INSERT INTO smile VALUES("4340","support","66");
INSERT INTO smile VALUES("4379","БАРОН","66");
INSERT INTO smile VALUES("4349",".адм106.","28");
INSERT INTO smile VALUES("4351",".адм107.","28");
INSERT INTO smile VALUES("4353",".адм108.","28");
INSERT INTO smile VALUES("4414",".пр23.","83");
INSERT INTO smile VALUES("4366","Dark_Princess","66");
INSERT INTO smile VALUES("4372",".адм109.","28");
INSERT INTO smile VALUES("4421",".пр30.","83");
INSERT INTO smile VALUES("4412",".пр21.","83");
INSERT INTO smile VALUES("4413",".пр22.","83");
INSERT INTO smile VALUES("4380","NeGaTiVkA","66");
INSERT INTO smile VALUES("4381","SCORPIO","66");
INSERT INTO smile VALUES("4382","Only_his","66");
INSERT INTO smile VALUES("4384","АЛМАЗ","66");
INSERT INTO smile VALUES("4450",".ли.","89");
INSERT INTO smile VALUES("4451",".ли2.","89");
INSERT INTO smile VALUES("4452",".ли3.","89");
INSERT INTO smile VALUES("4453",".ли4.","89");
INSERT INTO smile VALUES("4454",".ли5.","89");
INSERT INTO smile VALUES("4455",".ли6.","89");
INSERT INTO smile VALUES("4456",".ли7.","89");
INSERT INTO smile VALUES("4457",".ли8.","89");
INSERT INTO smile VALUES("4458",".ли9.","89");
INSERT INTO smile VALUES("4459",".ли10.","89");
INSERT INTO smile VALUES("4460",".ли11.","89");
INSERT INTO smile VALUES("4461",".ли12.","89");
INSERT INTO smile VALUES("4462",".ли13.","89");
INSERT INTO smile VALUES("4463",".ли14.","89");
INSERT INTO smile VALUES("4464",".ли15.","89");
INSERT INTO smile VALUES("4465",".ли16.","89");
INSERT INTO smile VALUES("4466",".ли17.","89");
INSERT INTO smile VALUES("4467",".ли18.","89");
INSERT INTO smile VALUES("4469",".ли19.","89");
INSERT INTO smile VALUES("4470",".ли20.","89");
INSERT INTO smile VALUES("4471",".ли21.","89");
INSERT INTO smile VALUES("4472",".ли22.","89");
INSERT INTO smile VALUES("4473",".ли23.","89");
INSERT INTO smile VALUES("4474",".ли24.","89");
INSERT INTO smile VALUES("4475",".ли26.","89");
INSERT INTO smile VALUES("4477",".ли27.","89");
INSERT INTO smile VALUES("4478",".ли28.","89");
INSERT INTO smile VALUES("4479",".ли29.","89");
INSERT INTO smile VALUES("4480",".ли30.","89");
INSERT INTO smile VALUES("4481",".ли31.","89");
INSERT INTO smile VALUES("4482",".ли32.","89");
INSERT INTO smile VALUES("4483",".ли33.","89");
INSERT INTO smile VALUES("4484",".ли34.","89");
INSERT INTO smile VALUES("4485",".ли35.","89");
INSERT INTO smile VALUES("4486",".ли36.","89");
INSERT INTO smile VALUES("4487",".ли37.","89");
INSERT INTO smile VALUES("4488",".ли38.","89");
INSERT INTO smile VALUES("4489",".ли39.","89");
INSERT INTO smile VALUES("4490",".ли40.","89");
INSERT INTO smile VALUES("4492",".ли41.","89");
INSERT INTO smile VALUES("4493",".ли42.","89");
INSERT INTO smile VALUES("4496",".ли43.","89");
INSERT INTO smile VALUES("4497",".ли44.","89");
INSERT INTO smile VALUES("4498",".ли45.","89");
INSERT INTO smile VALUES("4499",".ли46.","89");
INSERT INTO smile VALUES("4500",".ли47.","89");
INSERT INTO smile VALUES("4501",".ли48.","89");
INSERT INTO smile VALUES("4502",".ли49.","89");
INSERT INTO smile VALUES("4503",".ли50.","89");
INSERT INTO smile VALUES("4504",".ли51.","89");
INSERT INTO smile VALUES("4505",".ли52.","89");
INSERT INTO smile VALUES("4506",".ли53.","89");
INSERT INTO smile VALUES("4508",".ли54.","89");
INSERT INTO smile VALUES("4509",".ли55.","89");
INSERT INTO smile VALUES("4513",".ли56.","89");
INSERT INTO smile VALUES("4514",".ли57.","89");
INSERT INTO smile VALUES("4515",".ли58.","89");
INSERT INTO smile VALUES("4516",".ли59.","89");
INSERT INTO smile VALUES("4517",".ли60.","89");
INSERT INTO smile VALUES("4519",".ли61.","89");
INSERT INTO smile VALUES("4520",".ли62.","89");
INSERT INTO smile VALUES("4521",".ли63.","89");
INSERT INTO smile VALUES("4522",".ли64.","89");
INSERT INTO smile VALUES("4523",".ли65.","89");
INSERT INTO smile VALUES("4524",".ли66.","89");
INSERT INTO smile VALUES("4525",".ли66.","89");
INSERT INTO smile VALUES("4527",".ли67.","89");
INSERT INTO smile VALUES("4528",".ли68.","89");
INSERT INTO smile VALUES("4529",".ли69.","89");
INSERT INTO smile VALUES("4530",".ли70.","89");
INSERT INTO smile VALUES("4531",".ли71.","89");
INSERT INTO smile VALUES("4532",".ли72.","89");
INSERT INTO smile VALUES("4533",".ли73.","89");
INSERT INTO smile VALUES("4534",".ли74.","89");
INSERT INTO smile VALUES("4535",".ли75.","89");
INSERT INTO smile VALUES("4536",".ли76.","89");
INSERT INTO smile VALUES("4537",".ли77.","89");
INSERT INTO smile VALUES("4538",".ли78.","89");
INSERT INTO smile VALUES("4539",".ли79.","89");
INSERT INTO smile VALUES("4540",".ли80.","89");
INSERT INTO smile VALUES("4541",".ли81.","89");
INSERT INTO smile VALUES("4542",".ли82.","89");
INSERT INTO smile VALUES("4543",".ли83.","89");
INSERT INTO smile VALUES("4544",".ли84.","89");
INSERT INTO smile VALUES("4545",".ли85.","89");
INSERT INTO smile VALUES("4546",".ли86.","89");
INSERT INTO smile VALUES("4547",".ли87.","89");
INSERT INTO smile VALUES("4548",".ли88.","89");
INSERT INTO smile VALUES("4549",".ли89.","89");
INSERT INTO smile VALUES("4550",".ли90.","89");
INSERT INTO smile VALUES("4556",".ду.","84");
INSERT INTO smile VALUES("4555",".ли91.","89");
INSERT INTO smile VALUES("4557",".ду2.","84");
INSERT INTO smile VALUES("4558",".ду3.","84");
INSERT INTO smile VALUES("4559",".ду4.","84");
INSERT INTO smile VALUES("4560",".дд.","85");
INSERT INTO smile VALUES("4561",".дд2.","85");
INSERT INTO smile VALUES("4562",".дд3.","85");
INSERT INTO smile VALUES("4563",".дд4.","85");
INSERT INTO smile VALUES("4564",".дд5.","85");
INSERT INTO smile VALUES("4565",".дд6.","85");
INSERT INTO smile VALUES("4566",".ду6.","84");
INSERT INTO smile VALUES("5478","sany777","66");
INSERT INTO smile VALUES("4571","_SALAMANDRA_","66");
INSERT INTO smile VALUES("4572",".маш2.","92");
INSERT INTO smile VALUES("4573",".маш3.","92");
INSERT INTO smile VALUES("4574",".маш4.","92");
INSERT INTO smile VALUES("4575",".маш5.","92");
INSERT INTO smile VALUES("4576",".маш7.","92");
INSERT INTO smile VALUES("4577",".маш8.","92");
INSERT INTO smile VALUES("4578",".маш9.","92");
INSERT INTO smile VALUES("4579",".маш10.","92");
INSERT INTO smile VALUES("4580",".маш11.","92");
INSERT INTO smile VALUES("4581",".маш12.","92");
INSERT INTO smile VALUES("4582",".днев.","93");
INSERT INTO smile VALUES("4583",".днев2.","93");
INSERT INTO smile VALUES("4585",".мульт1.","94");
INSERT INTO smile VALUES("4586",".мульт2.","94");
INSERT INTO smile VALUES("4587",".мульт3.","94");
INSERT INTO smile VALUES("4588",".мульт4.","94");
INSERT INTO smile VALUES("4589",".мульт5.","94");
INSERT INTO smile VALUES("4590",".мульт6.","94");
INSERT INTO smile VALUES("4591",".мульт7.","94");
INSERT INTO smile VALUES("4592",".мульт8.","94");
INSERT INTO smile VALUES("4593",".мульт9.","94");
INSERT INTO smile VALUES("4594",".мульт10.","94");
INSERT INTO smile VALUES("4595",".мульт11.","94");
INSERT INTO smile VALUES("4596",".мульт12","94");
INSERT INTO smile VALUES("4597",".мульт13.","94");
INSERT INTO smile VALUES("4598",".мульт14.","94");
INSERT INTO smile VALUES("4599",".мульт15.","94");
INSERT INTO smile VALUES("4600",".мульт17.","94");
INSERT INTO smile VALUES("4601",".мульт18.","94");
INSERT INTO smile VALUES("4602",".днев3.","93");
INSERT INTO smile VALUES("4603",".разд1.","90");
INSERT INTO smile VALUES("4604",".разд2.","90");
INSERT INTO smile VALUES("4605",".разд3.","90");
INSERT INTO smile VALUES("4606",".розд4.","90");
INSERT INTO smile VALUES("4607",".розд5.","90");
INSERT INTO smile VALUES("4608",".розд6.","90");
INSERT INTO smile VALUES("4609",".розд7.","90");
INSERT INTO smile VALUES("4610",".розд8.","90");
INSERT INTO smile VALUES("4611",".розд9.","90");
INSERT INTO smile VALUES("4612",".розд10.","90");
INSERT INTO smile VALUES("4613",".розд11.","90");
INSERT INTO smile VALUES("4614",".розд12.","90");
INSERT INTO smile VALUES("4615",".розд13.","90");
INSERT INTO smile VALUES("4616",".розд14.","90");
INSERT INTO smile VALUES("4617",".розд15.","90");
INSERT INTO smile VALUES("4618",".розд16.","90");
INSERT INTO smile VALUES("4619",".розд17.","90");
INSERT INTO smile VALUES("4620",".розд18.","90");
INSERT INTO smile VALUES("4621",".розд19.","90");
INSERT INTO smile VALUES("4622",".розд20.","90");
INSERT INTO smile VALUES("4623",".розд21.","90");
INSERT INTO smile VALUES("4624",".днев4.","93");
INSERT INTO smile VALUES("4628",".днев8.","93");
INSERT INTO smile VALUES("4626",".днев6.","93");
INSERT INTO smile VALUES("4627",".днев7.","93");
INSERT INTO smile VALUES("4629",".днев9.","93");
INSERT INTO smile VALUES("4630",".днев10.","93");
INSERT INTO smile VALUES("4631",".днев11.","93");
INSERT INTO smile VALUES("4632",".днев12.","93");
INSERT INTO smile VALUES("4633",".днев13.","93");
INSERT INTO smile VALUES("4634",".днев14.","93");
INSERT INTO smile VALUES("4635",".днев15.","93");
INSERT INTO smile VALUES("4636",".днев16.","93");
INSERT INTO smile VALUES("4637",".днев17.","93");
INSERT INTO smile VALUES("4638",".днев18.","93");
INSERT INTO smile VALUES("4639",".днев19.","93");
INSERT INTO smile VALUES("4640",".днев20.","93");
INSERT INTO smile VALUES("4641",".разд22.","90");
INSERT INTO smile VALUES("4642",".разд23.","90");
INSERT INTO smile VALUES("4643",".разд24.","90");
INSERT INTO smile VALUES("4644",".разд25.","90");
INSERT INTO smile VALUES("4645",".разд26.","90");
INSERT INTO smile VALUES("4646",".разд27.","90");
INSERT INTO smile VALUES("4647",".разд28.","90");
INSERT INTO smile VALUES("4648",".разд29.","90");
INSERT INTO smile VALUES("4649",".разд30.","90");
INSERT INTO smile VALUES("4650",".разд31.","90");
INSERT INTO smile VALUES("4651",".разд32.","90");
INSERT INTO smile VALUES("4652",".разд33.","90");
INSERT INTO smile VALUES("4653",".дп1.","95");
INSERT INTO smile VALUES("4654",".дп2.","95");
INSERT INTO smile VALUES("4655",".прив1.","96");
INSERT INTO smile VALUES("4656",".прив2.","96");
INSERT INTO smile VALUES("4657",".прив3.","96");
INSERT INTO smile VALUES("4658",".прив4.","96");
INSERT INTO smile VALUES("4659",".прив5.","96");
INSERT INTO smile VALUES("4660",".прив6.","96");
INSERT INTO smile VALUES("4661",".прив7.","96");
INSERT INTO smile VALUES("4662",".прив8.","96");
INSERT INTO smile VALUES("4663",".прив9.","96");
INSERT INTO smile VALUES("4664",".прив10.","96");
INSERT INTO smile VALUES("4665",".прив11.","96");
INSERT INTO smile VALUES("4666",".прив12.","96");
INSERT INTO smile VALUES("4667",".прив13.","96");
INSERT INTO smile VALUES("4668",".прив14.","96");
INSERT INTO smile VALUES("4669",".прив15.","96");
INSERT INTO smile VALUES("4670",".прив16.","96");
INSERT INTO smile VALUES("4671",".прив17.","96");
INSERT INTO smile VALUES("4672",".прив18.","96");
INSERT INTO smile VALUES("4673",".привет19.","96");
INSERT INTO smile VALUES("4674",".прив20.","96");
INSERT INTO smile VALUES("4675",".прив21.","96");
INSERT INTO smile VALUES("4676",".прив22.","96");
INSERT INTO smile VALUES("4677",".прив23.","96");
INSERT INTO smile VALUES("4678",".прив24.","96");
INSERT INTO smile VALUES("4679",".прив25.","96");
INSERT INTO smile VALUES("4680",".прив26.","96");
INSERT INTO smile VALUES("4681",".прив27.","96");
INSERT INTO smile VALUES("4682",".прив28.","96");
INSERT INTO smile VALUES("4683",".прив29.","96");
INSERT INTO smile VALUES("4684",".прив30.","96");
INSERT INTO smile VALUES("4879",".прив38.","96");
INSERT INTO smile VALUES("4686",".прив32.","96");
INSERT INTO smile VALUES("4687",".прив33.","96");
INSERT INTO smile VALUES("4688",".прив34.","96");
INSERT INTO smile VALUES("4689",".прив35.","96");
INSERT INTO smile VALUES("4690",".прив36.","96");
INSERT INTO smile VALUES("4691",".прив37.","96");
INSERT INTO smile VALUES("4692",".тд1.","97");
INSERT INTO smile VALUES("4693",".тд2.","97");
INSERT INTO smile VALUES("4694",".тд3.","97");
INSERT INTO smile VALUES("4695",".тд4.","97");
INSERT INTO smile VALUES("4696",".тд5.","97");
INSERT INTO smile VALUES("4697",".тд6.","97");
INSERT INTO smile VALUES("4698",".тд7.","97");
INSERT INTO smile VALUES("4699",".тд8.","97");
INSERT INTO smile VALUES("4700",".тд9.","97");
INSERT INTO smile VALUES("4701",".тд10.","97");
INSERT INTO smile VALUES("4702",".тд11.","97");
INSERT INTO smile VALUES("4703",".тд12.","97");
INSERT INTO smile VALUES("4704",".тд13.","97");
INSERT INTO smile VALUES("4705",".тд14.","97");
INSERT INTO smile VALUES("4706",".тд15.","97");
INSERT INTO smile VALUES("4707",".тд16.","97");
INSERT INTO smile VALUES("4708",".тд17.","97");
INSERT INTO smile VALUES("4709",".тд18.","97");
INSERT INTO smile VALUES("4710",".тд19.","97");
INSERT INTO smile VALUES("4711",".тд20.","97");
INSERT INTO smile VALUES("4712",".тд21.","97");
INSERT INTO smile VALUES("4713",".тд22.","97");
INSERT INTO smile VALUES("4714",".тд23.","97");
INSERT INTO smile VALUES("4715",".тд24.","97");
INSERT INTO smile VALUES("4716",".тд25.","97");
INSERT INTO smile VALUES("4717",".тд26.","97");
INSERT INTO smile VALUES("4718",".тд27.","97");
INSERT INTO smile VALUES("4719",".тд28.","97");
INSERT INTO smile VALUES("4720",".тд29.","97");
INSERT INTO smile VALUES("4721",".тд30.","97");
INSERT INTO smile VALUES("4722",".тд31.","97");
INSERT INTO smile VALUES("4723",".тд32.","97");
INSERT INTO smile VALUES("4724",".тд33.","97");
INSERT INTO smile VALUES("4725",".ду7.","84");
INSERT INTO smile VALUES("4726",".ду8.","84");
INSERT INTO smile VALUES("4727",".ду9.","84");
INSERT INTO smile VALUES("4728",".ду10.","84");
INSERT INTO smile VALUES("4729",".ду11.","84");
INSERT INTO smile VALUES("4730",".ду12.","84");
INSERT INTO smile VALUES("4731",".ду13.","84");
INSERT INTO smile VALUES("4732",".ду14.","84");
INSERT INTO smile VALUES("4733",".ду15.","84");
INSERT INTO smile VALUES("4734",".ду16.","84");
INSERT INTO smile VALUES("4735",".ду17.","84");
INSERT INTO smile VALUES("4736",".мульт19.","94");
INSERT INTO smile VALUES("4737",".мульт20.","94");
INSERT INTO smile VALUES("4738",".мульт21.","94");
INSERT INTO smile VALUES("4739",".мульт22.","94");
INSERT INTO smile VALUES("4740",".мульт23.","94");
INSERT INTO smile VALUES("4741",".мульт24.","94");
INSERT INTO smile VALUES("4742",".мульт25.","94");
INSERT INTO smile VALUES("4743",".мульт26.","94");
INSERT INTO smile VALUES("4744",".мульт27.","94");
INSERT INTO smile VALUES("4746",".дп3.","95");
INSERT INTO smile VALUES("4749",".ду18.","84");
INSERT INTO smile VALUES("4750",".ду19.","84");
INSERT INTO smile VALUES("4751",".ду20.","84");
INSERT INTO smile VALUES("4752",".ду21.","84");
INSERT INTO smile VALUES("4753",".ду22.","84");
INSERT INTO smile VALUES("4754",".ду23.","84");
INSERT INTO smile VALUES("4755",".ду24.","84");
INSERT INTO smile VALUES("4756",".ду25.","84");
INSERT INTO smile VALUES("4757",".ду26.","84");
INSERT INTO smile VALUES("4758",".ду27.","84");
INSERT INTO smile VALUES("4759",".ду28.","84");
INSERT INTO smile VALUES("4760",".ду29.","84");
INSERT INTO smile VALUES("4761",".ду30.","84");
INSERT INTO smile VALUES("4762",".ду31.","84");
INSERT INTO smile VALUES("4763",".ду32.","84");
INSERT INTO smile VALUES("6169",".дв25.","86");
INSERT INTO smile VALUES("4765",".дв2.","86");
INSERT INTO smile VALUES("4766",".дв3.","86");
INSERT INTO smile VALUES("4767",".дв4.","86");
INSERT INTO smile VALUES("4768",".дв5.","86");
INSERT INTO smile VALUES("4770",".дв7.","86");
INSERT INTO smile VALUES("4771",".дв8.","86");
INSERT INTO smile VALUES("4772",".дв9.","86");
INSERT INTO smile VALUES("4773",".сн1.","88");
INSERT INTO smile VALUES("4774",".сн2.","88");
INSERT INTO smile VALUES("4775",".сн3.","88");
INSERT INTO smile VALUES("4776",".сн4.","88");
INSERT INTO smile VALUES("4777",".сн5.","88");
INSERT INTO smile VALUES("4778",".сн6.","88");
INSERT INTO smile VALUES("4779",".сн7.","88");
INSERT INTO smile VALUES("4780",".сн8.","88");
INSERT INTO smile VALUES("4781",".сн9.","88");
INSERT INTO smile VALUES("4782",".сн10.","88");
INSERT INTO smile VALUES("4783",".сн11.","88");
INSERT INTO smile VALUES("4784",".сн12.","88");
INSERT INTO smile VALUES("4785",".дп4.","95");
INSERT INTO smile VALUES("4786",".дп5.","95");
INSERT INTO smile VALUES("4787",".дп6.","95");
INSERT INTO smile VALUES("4788",".дп7.","95");
INSERT INTO smile VALUES("4789",".люб3.","11");
INSERT INTO smile VALUES("4790",".люб4.","11");
INSERT INTO smile VALUES("4791",".люб5.","11");
INSERT INTO smile VALUES("4792",".люб6.","11");
INSERT INTO smile VALUES("4793",".люб7.","11");
INSERT INTO smile VALUES("4794",".люб8.","11");
INSERT INTO smile VALUES("4795",".люб9.","11");
INSERT INTO smile VALUES("4796",".люб10.","11");
INSERT INTO smile VALUES("4797",".люб11.","11");
INSERT INTO smile VALUES("4798",".люб12.","11");
INSERT INTO smile VALUES("4799",".люб13.","11");
INSERT INTO smile VALUES("4800",".люб14.","11");
INSERT INTO smile VALUES("4801",".люб15.","11");
INSERT INTO smile VALUES("4802",".люб16.","11");
INSERT INTO smile VALUES("4803",".люб17.","11");
INSERT INTO smile VALUES("4804",".люб18.","11");
INSERT INTO smile VALUES("4805",".люб19.","11");
INSERT INTO smile VALUES("4806",".люб20.","11");
INSERT INTO smile VALUES("4807",".стат.","98");
INSERT INTO smile VALUES("4808",".стат1.","98");
INSERT INTO smile VALUES("4809",".стат2.","98");
INSERT INTO smile VALUES("4810",".стат3.","98");
INSERT INTO smile VALUES("4811",".стат4.","98");
INSERT INTO smile VALUES("4812",".стат5.","98");
INSERT INTO smile VALUES("4813",".стат6.","98");
INSERT INTO smile VALUES("4814",".стат7.","98");
INSERT INTO smile VALUES("4815",".стат8.","98");
INSERT INTO smile VALUES("4816",".стат9.","98");
INSERT INTO smile VALUES("4817",".стат10.","98");
INSERT INTO smile VALUES("4818",".стат11.","98");
INSERT INTO smile VALUES("4819",".стат12.","98");
INSERT INTO smile VALUES("4820",".стат13.","98");
INSERT INTO smile VALUES("4821",".стат14.","98");
INSERT INTO smile VALUES("4822",".стат15.","98");
INSERT INTO smile VALUES("4823",".стат16.","98");
INSERT INTO smile VALUES("4824",".стат17.","98");
INSERT INTO smile VALUES("4825",".стат18.","98");
INSERT INTO smile VALUES("4826",".стат19.","98");
INSERT INTO smile VALUES("4827",".стат20.","98");
INSERT INTO smile VALUES("4828",".стат21.","98");
INSERT INTO smile VALUES("4829",".др.","99");
INSERT INTO smile VALUES("4830",".др1.","99");
INSERT INTO smile VALUES("4831",".др2.","99");
INSERT INTO smile VALUES("4832",".др3.","99");
INSERT INTO smile VALUES("4833",".др4.","99");
INSERT INTO smile VALUES("4834",".др5.","99");
INSERT INTO smile VALUES("4835",".др6.","99");
INSERT INTO smile VALUES("4836",".др7.","99");
INSERT INTO smile VALUES("4837",".др8.","99");
INSERT INTO smile VALUES("4838",".др9.","99");
INSERT INTO smile VALUES("4839",".др10.","99");
INSERT INTO smile VALUES("4840",".др11.","99");
INSERT INTO smile VALUES("4841",".др12.","99");
INSERT INTO smile VALUES("6147",".др26.","99");
INSERT INTO smile VALUES("4843",".др14.","99");
INSERT INTO smile VALUES("4844",".др15.","99");
INSERT INTO smile VALUES("4845",".др16.","99");
INSERT INTO smile VALUES("6148",".др27.","99");
INSERT INTO smile VALUES("4847",".др18.","99");
INSERT INTO smile VALUES("4848",".др19.","99");
INSERT INTO smile VALUES("5314",".др23.","99");
INSERT INTO smile VALUES("4850",".др21.","99");
INSERT INTO smile VALUES("4862","Клео","66");
INSERT INTO smile VALUES("4853","ХУЛИГАН","66");
INSERT INTO smile VALUES("4854","DarK_DeviL","66");
INSERT INTO smile VALUES("4856","КлеваяЧика","66");
INSERT INTO smile VALUES("4857","ГрЕшНиЦа..","66");
INSERT INTO smile VALUES("4858",".дп8.","95");
INSERT INTO smile VALUES("4859",".дп9.","95");
INSERT INTO smile VALUES("4861","Ужас","66");
INSERT INTO smile VALUES("4863",".цвет40.","19");
INSERT INTO smile VALUES("4865",".ду33.","84");
INSERT INTO smile VALUES("4868","MAXIMUS","66");
INSERT INTO smile VALUES("4872","ГрЕ[[ш]]НиК...","66");
INSERT INTO smile VALUES("4874","_-ДерЗкаЯ-_","66");
INSERT INTO smile VALUES("4875",".дп15.","95");
INSERT INTO smile VALUES("4876",".дп16.","95");
INSERT INTO smile VALUES("4877",".дп17.","95");
INSERT INTO smile VALUES("4878",".дп18.","95");
INSERT INTO smile VALUES("4880",".прив39.","96");
INSERT INTO smile VALUES("4881",".прив40.","96");
INSERT INTO smile VALUES("4882",".прив41.","96");
INSERT INTO smile VALUES("4883",".прив42.","96");
INSERT INTO smile VALUES("4884",".прив43.","96");
INSERT INTO smile VALUES("4886",".прив44.","96");
INSERT INTO smile VALUES("4887",".прив45.","96");
INSERT INTO smile VALUES("4888",".прив46.","96");
INSERT INTO smile VALUES("4889",".прив47.","96");
INSERT INTO smile VALUES("4890",".пред1.","100");
INSERT INTO smile VALUES("4891",".пред2.","100");
INSERT INTO smile VALUES("4892",".на2.","101");
INSERT INTO smile VALUES("4893",".на3.","101");
INSERT INTO smile VALUES("4894",".на4.","101");
INSERT INTO smile VALUES("4895",".на5.","101");
INSERT INTO smile VALUES("4896",".на6.","101");
INSERT INTO smile VALUES("4897",".на7.","101");
INSERT INTO smile VALUES("4898",".на8.","101");
INSERT INTO smile VALUES("4899",".на9.","101");
INSERT INTO smile VALUES("4900",".на10.","101");
INSERT INTO smile VALUES("4901",".на11.","101");
INSERT INTO smile VALUES("4902",".на12.","101");
INSERT INTO smile VALUES("4903",".на13.","101");
INSERT INTO smile VALUES("4904",".на14.","101");
INSERT INTO smile VALUES("4905",".на15.","101");
INSERT INTO smile VALUES("4906",".на16.","101");
INSERT INTO smile VALUES("4907",".на17.","101");
INSERT INTO smile VALUES("4908",".на18.","101");
INSERT INTO smile VALUES("4909",".на19.","101");
INSERT INTO smile VALUES("5011",".дп19.","95");
INSERT INTO smile VALUES("4912",".маш13.","92");
INSERT INTO smile VALUES("4913",".маш14.","92");
INSERT INTO smile VALUES("4914",".маш15.","92");
INSERT INTO smile VALUES("4915",".маш16.","92");
INSERT INTO smile VALUES("4916",".маш17.","92");
INSERT INTO smile VALUES("4917",".маш18.","92");
INSERT INTO smile VALUES("4919",".маш19.","92");
INSERT INTO smile VALUES("4920",".маш20.","92");
INSERT INTO smile VALUES("4921",".маш21.","92");
INSERT INTO smile VALUES("4922",".маш22.","92");
INSERT INTO smile VALUES("4923",".маш23.","92");
INSERT INTO smile VALUES("4924",".маш24.","92");
INSERT INTO smile VALUES("4925",".маш25.","92");
INSERT INTO smile VALUES("4926",".маш26.","92");
INSERT INTO smile VALUES("4927",".маш27.","92");
INSERT INTO smile VALUES("4928",".мульт28.","94");
INSERT INTO smile VALUES("4929",".мульт29.","94");
INSERT INTO smile VALUES("4931",".мульт30.","94");
INSERT INTO smile VALUES("4932",".мульт31.","94");
INSERT INTO smile VALUES("4933",".мульт32.","94");
INSERT INTO smile VALUES("4934",".мульт33.","94");
INSERT INTO smile VALUES("4935",".мульт34.","94");
INSERT INTO smile VALUES("4936",".мульт35.","94");
INSERT INTO smile VALUES("4937",".мульт36.","94");
INSERT INTO smile VALUES("4938",".стат22.","98");
INSERT INTO smile VALUES("4939",".стат23.","98");
INSERT INTO smile VALUES("4940",".стат24.","98");
INSERT INTO smile VALUES("4941",".стат25.","98");
INSERT INTO smile VALUES("4942",".стат26.","98");
INSERT INTO smile VALUES("4943",".стат27.","98");
INSERT INTO smile VALUES("4944",".стат28.","98");
INSERT INTO smile VALUES("4945",".стат29.","98");
INSERT INTO smile VALUES("4946",".стат30.","98");
INSERT INTO smile VALUES("4947",".стат31.","98");
INSERT INTO smile VALUES("4948",".стат32.","98");
INSERT INTO smile VALUES("4949",".стат33.","98");
INSERT INTO smile VALUES("4950",".стат34.","98");
INSERT INTO smile VALUES("4951",".стат35.","98");
INSERT INTO smile VALUES("4952",".стат36.","98");
INSERT INTO smile VALUES("4953",".поц92.","45");
INSERT INTO smile VALUES("4954",".люб21.","11");
INSERT INTO smile VALUES("5277",".люб25.","11");
INSERT INTO smile VALUES("5251",".цвет45.","19");
INSERT INTO smile VALUES("4958",".люб23.","11");
INSERT INTO smile VALUES("4959",".люб24.","11");
INSERT INTO smile VALUES("4960",".дд7.","85");
INSERT INTO smile VALUES("4961",".дд8.","85");
INSERT INTO smile VALUES("4962",".дд9.","85");
INSERT INTO smile VALUES("4963",".дв10.","86");
INSERT INTO smile VALUES("6170",".дв26.","86");
INSERT INTO smile VALUES("6171",".дв27.","86");
INSERT INTO smile VALUES("4967",".девочка.","102");
INSERT INTO smile VALUES("4968",".девочка1.","102");
INSERT INTO smile VALUES("4969",".девочка2.","102");
INSERT INTO smile VALUES("4970",".девочка3.","102");
INSERT INTO smile VALUES("4971",".девочка4.","102");
INSERT INTO smile VALUES("4972",".девочка5.","102");
INSERT INTO smile VALUES("4973",".девочка6.","102");
INSERT INTO smile VALUES("4975",".девочка7.","102");
INSERT INTO smile VALUES("4976",".девочка8.","102");
INSERT INTO smile VALUES("4977",".девочка9.","102");
INSERT INTO smile VALUES("4978",".девочка10.","102");
INSERT INTO smile VALUES("4979",".девочка11.","102");
INSERT INTO smile VALUES("4980",".девочка12.","102");
INSERT INTO smile VALUES("4981",".девочка13.","102");
INSERT INTO smile VALUES("4982",".девочка14.","102");
INSERT INTO smile VALUES("4983",".девочка15.","102");
INSERT INTO smile VALUES("4984",".девочка16.","102");
INSERT INTO smile VALUES("4985",".девочка17.","102");
INSERT INTO smile VALUES("4986",".девочка18.","102");
INSERT INTO smile VALUES("4987",".девочка19.","102");
INSERT INTO smile VALUES("4988",".девочка20.","102");
INSERT INTO smile VALUES("4989",".девочка21.","102");
INSERT INTO smile VALUES("4991",".девочка22.","102");
INSERT INTO smile VALUES("4992",".девочка23.","102");
INSERT INTO smile VALUES("4993",".девочка24.","102");
INSERT INTO smile VALUES("4994",".девочка25.","102");
INSERT INTO smile VALUES("4995",".девочка26.","102");
INSERT INTO smile VALUES("4996",".девочка27.","102");
INSERT INTO smile VALUES("4997",".девочка28.","102");
INSERT INTO smile VALUES("4998",".девочка29.","102");
INSERT INTO smile VALUES("4999",".девочка30.","102");
INSERT INTO smile VALUES("5000",".девочка31.","102");
INSERT INTO smile VALUES("5001",".девочка32.","102");
INSERT INTO smile VALUES("5002",".девочка33.","102");
INSERT INTO smile VALUES("5003",".девочка34.","102");
INSERT INTO smile VALUES("5004",".девочка35.","102");
INSERT INTO smile VALUES("5005",".девочка36.","102");
INSERT INTO smile VALUES("5006",".девочка37.","102");
INSERT INTO smile VALUES("5007",".девочка38.","102");
INSERT INTO smile VALUES("5008",".девочка39.","102");
INSERT INTO smile VALUES("5009",".девочка40.","102");
INSERT INTO smile VALUES("5010",".девочка41.","102");
INSERT INTO smile VALUES("5012",".дп20.","95");
INSERT INTO smile VALUES("5013",".8м1.","105");
INSERT INTO smile VALUES("5014",".8м2.","105");
INSERT INTO smile VALUES("5015",".8м3.","105");
INSERT INTO smile VALUES("5017",".8м4.","105");
INSERT INTO smile VALUES("5018",".8м5.","105");
INSERT INTO smile VALUES("5019",".8м6.","105");
INSERT INTO smile VALUES("5020",".8м9.","105");
INSERT INTO smile VALUES("5021",".8м10.","105");
INSERT INTO smile VALUES("5022",".8м11.","105");
INSERT INTO smile VALUES("5023",".8м12.","105");
INSERT INTO smile VALUES("5024",".8м13.","105");
INSERT INTO smile VALUES("5025",".8м14.","105");
INSERT INTO smile VALUES("5026",".8м15.","105");
INSERT INTO smile VALUES("5027",".8м16.","105");
INSERT INTO smile VALUES("5028",".8м17.","105");
INSERT INTO smile VALUES("5029",".8м18.","105");
INSERT INTO smile VALUES("5030",".дв14.","86");
INSERT INTO smile VALUES("5031",".дв15.","86");
INSERT INTO smile VALUES("5032",".дв16.","86");
INSERT INTO smile VALUES("5033",".дв17.","86");
INSERT INTO smile VALUES("5034",".дв18.","86");
INSERT INTO smile VALUES("5035","ПЕРСЕЙ","66");
INSERT INTO smile VALUES("5036",".ухожу.","20");
INSERT INTO smile VALUES("5037",".бамс.","20");
INSERT INTO smile VALUES("5038",".клипает.","20");
INSERT INTO smile VALUES("5039",".дразница5.","20");
INSERT INTO smile VALUES("5040",".обнимаш.","20");
INSERT INTO smile VALUES("5041",".роднулик.","20");
INSERT INTO smile VALUES("5042",".лыбаа.","20");
INSERT INTO smile VALUES("5043",".дурочка.","20");
INSERT INTO smile VALUES("5044",".ржака4.","20");
INSERT INTO smile VALUES("5045",".ржака5.","20");
INSERT INTO smile VALUES("5046",".ах2.","20");
INSERT INTO smile VALUES("5189",".мото3.","18");
INSERT INTO smile VALUES("5049",".данувас.","20");
INSERT INTO smile VALUES("5050",".ду34.","84");
INSERT INTO smile VALUES("5051",".ду35.","84");
INSERT INTO smile VALUES("5052",".ду36.","84");
INSERT INTO smile VALUES("5053",".ду37.","84");
INSERT INTO smile VALUES("5054",".ду38.","84");
INSERT INTO smile VALUES("5055",".ду38.","84");
INSERT INTO smile VALUES("5056",".ду39.","84");
INSERT INTO smile VALUES("5057",".ду40.","84");
INSERT INTO smile VALUES("5058",".ду41.","84");
INSERT INTO smile VALUES("5059",".ду42.","84");
INSERT INTO smile VALUES("5060",".ду43.","84");
INSERT INTO smile VALUES("5061",".ужас.","3");
INSERT INTO smile VALUES("5062",".лыба6.","3");
INSERT INTO smile VALUES("5063",".куку.","3");
INSERT INTO smile VALUES("5064",".зашторкой.","3");
INSERT INTO smile VALUES("5065",".вносу.","3");
INSERT INTO smile VALUES("5066",".клево.","3");
INSERT INTO smile VALUES("5067",".лютебя.","3");
INSERT INTO smile VALUES("5068",".няцвет.","3");
INSERT INTO smile VALUES("5159",".дд11.","85");
INSERT INTO smile VALUES("5071",".куку3.","3");
INSERT INTO smile VALUES("5160",".дд12.","85");
INSERT INTO smile VALUES("5158",".дд10.","85");
INSERT INTO smile VALUES("5076",".щаусусь.","3");
INSERT INTO smile VALUES("5077",".вернись.","3");
INSERT INTO smile VALUES("5078",".привет.","3");
INSERT INTO smile VALUES("5079",".ого.","20");
INSERT INTO smile VALUES("5192",".адм110.","28");
INSERT INTO smile VALUES("5081",".скилет.","3");
INSERT INTO smile VALUES("5184",".обклавиатуру.","6");
INSERT INTO smile VALUES("5083",".ржуха.","20");
INSERT INTO smile VALUES("5084",".дв19.","86");
INSERT INTO smile VALUES("5085",".дв20.","86");
INSERT INTO smile VALUES("5086",".дв21.","86");
INSERT INTO smile VALUES("5087",".дв22.","86");
INSERT INTO smile VALUES("5088",".дв23.","86");
INSERT INTO smile VALUES("5089",".дв24.","86");
INSERT INTO smile VALUES("5090",".сн13.","88");
INSERT INTO smile VALUES("5091",".чупс.","3");
INSERT INTO smile VALUES("5092",".бегом.","3");
INSERT INTO smile VALUES("5093",".мерси.","3");
INSERT INTO smile VALUES("5094",".заязык.","3");
INSERT INTO smile VALUES("5095",".качели2.","3");
INSERT INTO smile VALUES("5193",".днев21.","93");
INSERT INTO smile VALUES("5191",".телик.","18");
INSERT INTO smile VALUES("5098",".такточно.","3");
INSERT INTO smile VALUES("5099",".кол.","106");
INSERT INTO smile VALUES("5100",".кол1.","106");
INSERT INTO smile VALUES("5101",".кол2.","106");
INSERT INTO smile VALUES("5102",".кол3.","106");
INSERT INTO smile VALUES("5103",".кол4.","106");
INSERT INTO smile VALUES("5104",".кол5.","106");
INSERT INTO smile VALUES("5105",".кол6.","106");
INSERT INTO smile VALUES("5106",".кол7.","106");
INSERT INTO smile VALUES("5107",".кол8.","106");
INSERT INTO smile VALUES("5108",".кол9.","106");
INSERT INTO smile VALUES("5109",".кол10.","106");
INSERT INTO smile VALUES("5110",".кол11.","106");
INSERT INTO smile VALUES("5111",".кол12.","106");
INSERT INTO smile VALUES("5112",".кол13.","106");
INSERT INTO smile VALUES("5113",".кол14.","106");
INSERT INTO smile VALUES("5114",".кол15.","106");
INSERT INTO smile VALUES("5115",".кол16.","106");
INSERT INTO smile VALUES("5116",".кол17.","106");
INSERT INTO smile VALUES("5117",".кол18.","106");
INSERT INTO smile VALUES("5118",".кол19.","106");
INSERT INTO smile VALUES("5119",".кол20.","106");
INSERT INTO smile VALUES("5120",".кол21.","106");
INSERT INTO smile VALUES("5121",".кол22.","106");
INSERT INTO smile VALUES("5122",".кол23.","106");
INSERT INTO smile VALUES("5123",".кол24.","106");
INSERT INTO smile VALUES("5124",".кол25.","106");
INSERT INTO smile VALUES("5125",".кол26.","106");
INSERT INTO smile VALUES("5126",".кол27.","106");
INSERT INTO smile VALUES("5127",".кол28.","106");
INSERT INTO smile VALUES("5128",".кол29.","106");
INSERT INTO smile VALUES("5129",".кол30.","106");
INSERT INTO smile VALUES("5130",".кол31.","106");
INSERT INTO smile VALUES("5131",".кол32.","106");
INSERT INTO smile VALUES("5132",".кол33.","106");
INSERT INTO smile VALUES("5133",".кол34.","106");
INSERT INTO smile VALUES("5134",".кол35.","106");
INSERT INTO smile VALUES("5135",".кол36.","106");
INSERT INTO smile VALUES("5136",".кол37.","106");
INSERT INTO smile VALUES("5137",".кол38.","106");
INSERT INTO smile VALUES("5138",".кол39.","106");
INSERT INTO smile VALUES("5139",".кол40.","106");
INSERT INTO smile VALUES("5140",".кол41.","106");
INSERT INTO smile VALUES("5141",".кол42.","106");
INSERT INTO smile VALUES("5142",".кол43.","106");
INSERT INTO smile VALUES("5143",".кол44.","106");
INSERT INTO smile VALUES("5144",".кол45.","106");
INSERT INTO smile VALUES("5145",".кол46.","106");
INSERT INTO smile VALUES("5146",".кол47.","106");
INSERT INTO smile VALUES("5147",".кол48.","106");
INSERT INTO smile VALUES("5148",".кол49.","106");
INSERT INTO smile VALUES("5149",".кол50.","106");
INSERT INTO smile VALUES("5150",".кол51.","106");
INSERT INTO smile VALUES("5151",".кол52.","106");
INSERT INTO smile VALUES("5152",".кол53.","106");
INSERT INTO smile VALUES("5153",".кол54.","106");
INSERT INTO smile VALUES("5154",".кол55.","106");
INSERT INTO smile VALUES("5155",".кол56.","106");
INSERT INTO smile VALUES("5161",".дд13.","85");
INSERT INTO smile VALUES("5162",".дд14.","85");
INSERT INTO smile VALUES("5163",".пож.","107");
INSERT INTO smile VALUES("5164",".пож1.","107");
INSERT INTO smile VALUES("5165",".пож2.","107");
INSERT INTO smile VALUES("5166",".пож3.","107");
INSERT INTO smile VALUES("5167",".пож4.","107");
INSERT INTO smile VALUES("5168",".пож5.","107");
INSERT INTO smile VALUES("5169",".пож6.","107");
INSERT INTO smile VALUES("5170",".пож7.","107");
INSERT INTO smile VALUES("5171",".пож8.","107");
INSERT INTO smile VALUES("5172",".пож9.","107");
INSERT INTO smile VALUES("5173",".пож10.","107");
INSERT INTO smile VALUES("5174",".пож11.","107");
INSERT INTO smile VALUES("5175",".пож12.","107");
INSERT INTO smile VALUES("5176",".пож13.","107");
INSERT INTO smile VALUES("5177",".пож14.","107");
INSERT INTO smile VALUES("5178",".пож15.","107");
INSERT INTO smile VALUES("5179",".пож16.","107");
INSERT INTO smile VALUES("5180",".пож17.","107");
INSERT INTO smile VALUES("5181",".пож18.","107");
INSERT INTO smile VALUES("5182",".пож19.","107");
INSERT INTO smile VALUES("5183",".пож20.","107");
INSERT INTO smile VALUES("5185",".опа.","6");
INSERT INTO smile VALUES("5186",".фига.","6");
INSERT INTO smile VALUES("5187",".кайф.","20");
INSERT INTO smile VALUES("5188",".псих.","6");
INSERT INTO smile VALUES("5194",".днев22.","93");
INSERT INTO smile VALUES("5195",".днев23.","93");
INSERT INTO smile VALUES("5196",".днев24.","93");
INSERT INTO smile VALUES("5197",".днев25.","93");
INSERT INTO smile VALUES("5198",".днев26.","93");
INSERT INTO smile VALUES("5199",".днев27.","93");
INSERT INTO smile VALUES("5200",".днев28.","93");
INSERT INTO smile VALUES("5201",".днев29.","93");
INSERT INTO smile VALUES("5202",".днев30.","93");
INSERT INTO smile VALUES("5203",".днев31.","93");
INSERT INTO smile VALUES("5204",".днев32.","93");
INSERT INTO smile VALUES("5205",".днев33.","93");
INSERT INTO smile VALUES("5206",".днев34.","93");
INSERT INTO smile VALUES("5207",".днев35.","93");
INSERT INTO smile VALUES("5208",".ржака.","20");
INSERT INTO smile VALUES("5210",".хз.","3");
INSERT INTO smile VALUES("5211","HULIGANKA","66");
INSERT INTO smile VALUES("5213",".стат37.","98");
INSERT INTO smile VALUES("5224",".дп21.","95");
INSERT INTO smile VALUES("5225",".привадм.","108");
INSERT INTO smile VALUES("5226",".привадм2.","108");
INSERT INTO smile VALUES("5227",".привадм3.","108");
INSERT INTO smile VALUES("5228","НяШкА_ВкУсНяШкА6","66");
INSERT INTO smile VALUES("5296",".привадм4.","108");
INSERT INTO smile VALUES("5229","DRAGONS..","66");
INSERT INTO smile VALUES("5231",".гост.","109");
INSERT INTO smile VALUES("5232",".гост2.","109");
INSERT INTO smile VALUES("5233",".гост3.","109");
INSERT INTO smile VALUES("5234",".гост4","109");
INSERT INTO smile VALUES("5236",".гост5.","109");
INSERT INTO smile VALUES("5298",".привадм6.","108");
INSERT INTO smile VALUES("5297",".привадм5.","108");
INSERT INTO smile VALUES("5239",".гост6.","109");
INSERT INTO smile VALUES("5240",".гост7.","109");
INSERT INTO smile VALUES("5241",".гост8.","109");
INSERT INTO smile VALUES("5242",".гост9.","109");
INSERT INTO smile VALUES("5243",".маш28.","92");
INSERT INTO smile VALUES("5244",".маш29.","92");
INSERT INTO smile VALUES("5245",".маш30.","92");
INSERT INTO smile VALUES("5252","НяШкА_ВкУсНяШкА..","66");
INSERT INTO smile VALUES("5319",".пр59.","83");
INSERT INTO smile VALUES("5257","Ястреб..","66");
INSERT INTO smile VALUES("5258",".цвет46.","19");
INSERT INTO smile VALUES("5259",".цвет47.","19");
INSERT INTO smile VALUES("5260",".цвет48.","19");
INSERT INTO smile VALUES("5261",".цвет49.","19");
INSERT INTO smile VALUES("5262",".цвет50.","19");
INSERT INTO smile VALUES("5263",".цвет51.","19");
INSERT INTO smile VALUES("5264",".цвет52.","19");
INSERT INTO smile VALUES("5265",".цвет53.","19");
INSERT INTO smile VALUES("5266",".цвет55.","19");
INSERT INTO smile VALUES("5267",".цвет56.","19");
INSERT INTO smile VALUES("5268",".цвет57.","19");
INSERT INTO smile VALUES("5269",".цвет58.","19");
INSERT INTO smile VALUES("5270",".цвет59.","19");
INSERT INTO smile VALUES("5271",".цвет60.","19");
INSERT INTO smile VALUES("5272",".цвет61.","19");
INSERT INTO smile VALUES("5273",".цвет62.","19");
INSERT INTO smile VALUES("5274",".прик100.","110");
INSERT INTO smile VALUES("5275",".прик101.","110");
INSERT INTO smile VALUES("5276",".прик102.","110");
INSERT INTO smile VALUES("5278",".люб26.","11");
INSERT INTO smile VALUES("5279",".люб27.","11");
INSERT INTO smile VALUES("5280",".люб28.","11");
INSERT INTO smile VALUES("5281",".гоп100.","111");
INSERT INTO smile VALUES("5282",".гоп101.","111");
INSERT INTO smile VALUES("5283",".гоп102.","111");
INSERT INTO smile VALUES("5284",".гоп103.","111");
INSERT INTO smile VALUES("5285",".гоп104.","111");
INSERT INTO smile VALUES("5286",".гоп105.","111");
INSERT INTO smile VALUES("5287",".гоп106.","111");
INSERT INTO smile VALUES("5288",".гоп107.","111");
INSERT INTO smile VALUES("5302",".гоп10.","111");
INSERT INTO smile VALUES("5300",".гоп8.","111");
INSERT INTO smile VALUES("5301",".гоп9.","111");
INSERT INTO smile VALUES("5294","ГрЕ[[ш]]НиК...","66");
INSERT INTO smile VALUES("5295","ГрЕшНиЦа..","66");
INSERT INTO smile VALUES("5303",".гоп11.","111");
INSERT INTO smile VALUES("5304",".гоп12.","111");
INSERT INTO smile VALUES("5305",".гоп13.","111");
INSERT INTO smile VALUES("5306",".гоп14.","111");
INSERT INTO smile VALUES("5308",".гоп15.","111");
INSERT INTO smile VALUES("5309",".гоп16.","111");
INSERT INTO smile VALUES("5310",".гоп17.","111");
INSERT INTO smile VALUES("5311",".гоп18.","111");
INSERT INTO smile VALUES("5312",".гоп19.","111");
INSERT INTO smile VALUES("5313",".гоп20.","111");
INSERT INTO smile VALUES("5315",".др24.","99");
INSERT INTO smile VALUES("5316",".др25.","99");
INSERT INTO smile VALUES("5318",".пр58.","83");
INSERT INTO smile VALUES("5320",".пр60.","83");
INSERT INTO smile VALUES("5322",".пр61.","83");
INSERT INTO smile VALUES("5323",".пр62.","83");
INSERT INTO smile VALUES("5324",".пр63.","83");
INSERT INTO smile VALUES("5325",".пр64.","83");
INSERT INTO smile VALUES("5326",".пр65.","83");
INSERT INTO smile VALUES("5327",".пр66.","83");
INSERT INTO smile VALUES("5328",".пр67.","83");
INSERT INTO smile VALUES("5329",".пр68.","83");
INSERT INTO smile VALUES("5330",".пр69.","83");
INSERT INTO smile VALUES("5331",".пр70.","83");
INSERT INTO smile VALUES("5332",".пр71.","83");
INSERT INTO smile VALUES("5333",".пр72.","83");
INSERT INTO smile VALUES("5334",".пр73.","83");
INSERT INTO smile VALUES("5335",".пр74.","83");
INSERT INTO smile VALUES("5336",".пр75.","83");
INSERT INTO smile VALUES("5607","_Solnyshko_","66");
INSERT INTO smile VALUES("5338",".пр76.","83");
INSERT INTO smile VALUES("5339",".привадм7.","108");
INSERT INTO smile VALUES("5340",".пр77.","83");
INSERT INTO smile VALUES("5341",".пр78.","83");
INSERT INTO smile VALUES("5342",".пр79.","83");
INSERT INTO smile VALUES("5343",".пр80.","83");
INSERT INTO smile VALUES("5344",".пр81.","83");
INSERT INTO smile VALUES("5346",".поц93.","45");
INSERT INTO smile VALUES("5347",".поц94.","45");
INSERT INTO smile VALUES("5348",".поц95.","45");
INSERT INTO smile VALUES("5349",".поц96.","45");
INSERT INTO smile VALUES("5350",".поц97.","45");
INSERT INTO smile VALUES("5351",".поц98.","45");
INSERT INTO smile VALUES("5352",".поц99.","45");
INSERT INTO smile VALUES("5353",".поц100.","45");
INSERT INTO smile VALUES("5354",".поц101.","45");
INSERT INTO smile VALUES("5355",".поц102.","45");
INSERT INTO smile VALUES("5356",".поц103.","45");
INSERT INTO smile VALUES("5357",".поц104.","45");
INSERT INTO smile VALUES("5358",".поц105.","45");
INSERT INTO smile VALUES("5359",".поц107.","45");
INSERT INTO smile VALUES("5360",".поц108.","45");
INSERT INTO smile VALUES("5361",".поц109.","45");
INSERT INTO smile VALUES("5362",".поц110.","45");
INSERT INTO smile VALUES("5363",".поц111.","45");
INSERT INTO smile VALUES("5364",".поц112.","45");
INSERT INTO smile VALUES("5365",".поц113.","45");
INSERT INTO smile VALUES("5366",".поц114.","45");
INSERT INTO smile VALUES("5367",".поц115.","45");
INSERT INTO smile VALUES("5368",".поц117.","45");
INSERT INTO smile VALUES("5369",".поц118.","45");
INSERT INTO smile VALUES("5370",".поц119.","45");
INSERT INTO smile VALUES("5371",".поц120.","45");
INSERT INTO smile VALUES("5372",".пр82.","83");
INSERT INTO smile VALUES("5373",".пр83.","83");
INSERT INTO smile VALUES("5374",".пр84.","83");
INSERT INTO smile VALUES("5375",".пр85.","83");
INSERT INTO smile VALUES("5376",".пр86.","83");
INSERT INTO smile VALUES("5377",".пр87.","83");
INSERT INTO smile VALUES("5378",".привадм8.","108");
INSERT INTO smile VALUES("5379",".пр88.","83");
INSERT INTO smile VALUES("5380",".привадм9.","108");
INSERT INTO smile VALUES("5381",".пр89.","83");
INSERT INTO smile VALUES("5382",".привадм10.","108");
INSERT INTO smile VALUES("5383",".пр90.","83");
INSERT INTO smile VALUES("5384",".привадм11.","108");
INSERT INTO smile VALUES("5385",".пр91.","83");
INSERT INTO smile VALUES("5386",".пр92.","83");
INSERT INTO smile VALUES("5387",".пр93.","83");
INSERT INTO smile VALUES("5388",".пр94.","83");
INSERT INTO smile VALUES("5390",".пр95.","83");
INSERT INTO smile VALUES("5391",".пр96.","83");
INSERT INTO smile VALUES("5392",".пр97.","83");
INSERT INTO smile VALUES("5393",".пр98.","83");
INSERT INTO smile VALUES("5394",".пр99.","83");
INSERT INTO smile VALUES("5395",".пр100.","83");
INSERT INTO smile VALUES("5397",".пр101.","83");
INSERT INTO smile VALUES("5398",".пр102.","83");
INSERT INTO smile VALUES("5399",".пр103.","83");
INSERT INTO smile VALUES("5400",".пр104.","83");
INSERT INTO smile VALUES("5401",".пр105.","83");
INSERT INTO smile VALUES("5402",".пр106.","83");
INSERT INTO smile VALUES("5403",".пр107.","83");
INSERT INTO smile VALUES("5404",".бс.","112");
INSERT INTO smile VALUES("5405",".бс1.","112");
INSERT INTO smile VALUES("5406",".бс2.","112");
INSERT INTO smile VALUES("5407",".бс3.","112");
INSERT INTO smile VALUES("5408",".бс4.","112");
INSERT INTO smile VALUES("5409",".пр108.","83");
INSERT INTO smile VALUES("5410",".пр109.","83");
INSERT INTO smile VALUES("5411",".бс5.","112");
INSERT INTO smile VALUES("5412",".бс6.","112");
INSERT INTO smile VALUES("5413",".бс7.","112");
INSERT INTO smile VALUES("5414",".пр110.","83");
INSERT INTO smile VALUES("5416",".бс8.","112");
INSERT INTO smile VALUES("5417",".пр111.","83");
INSERT INTO smile VALUES("5418",".пр112.","83");
INSERT INTO smile VALUES("5419",".пр113.","83");
INSERT INTO smile VALUES("5420",".пр114.","83");
INSERT INTO smile VALUES("5421",".пр115.","83");
INSERT INTO smile VALUES("5422",".пр116.","83");
INSERT INTO smile VALUES("5423",".пр117.","83");
INSERT INTO smile VALUES("5424",".пр118.","83");
INSERT INTO smile VALUES("5425",".пр119.","83");
INSERT INTO smile VALUES("5426",".пр120.","83");
INSERT INTO smile VALUES("5427",".пр121.","83");
INSERT INTO smile VALUES("5428",".пр122.","83");
INSERT INTO smile VALUES("5429",".пр123.","83");
INSERT INTO smile VALUES("5430",".пр124.","83");
INSERT INTO smile VALUES("5431",".пр125.","83");
INSERT INTO smile VALUES("5432",".пр126.","83");
INSERT INTO smile VALUES("5433",".пр127.","83");
INSERT INTO smile VALUES("5434",".пр128.","83");
INSERT INTO smile VALUES("5435",".пр129.","83");
INSERT INTO smile VALUES("5436",".пр130.","83");
INSERT INTO smile VALUES("5437",".пр131.","83");
INSERT INTO smile VALUES("5438",".пр132.","83");
INSERT INTO smile VALUES("5439",".пр133.","83");
INSERT INTO smile VALUES("5440",".прик103.","110");
INSERT INTO smile VALUES("5441",".прик104.","110");
INSERT INTO smile VALUES("5442",".прик105.","110");
INSERT INTO smile VALUES("5443",".бс9.","112");
INSERT INTO smile VALUES("5444",".бс10.","112");
INSERT INTO smile VALUES("5445",".бс11.","112");
INSERT INTO smile VALUES("5446",".бс12.","112");
INSERT INTO smile VALUES("5448",".бс13.","112");
INSERT INTO smile VALUES("5449",".бс14.","112");
INSERT INTO smile VALUES("5450",".бс15.","112");
INSERT INTO smile VALUES("5453",".бс17.","112");
INSERT INTO smile VALUES("5452",".бс16.","112");
INSERT INTO smile VALUES("5454",".бс18.","112");
INSERT INTO smile VALUES("5455",".бс19.","112");
INSERT INTO smile VALUES("5456",".прик106.","110");
INSERT INTO smile VALUES("5457",".прик107.","110");
INSERT INTO smile VALUES("5458",".прик108.","110");
INSERT INTO smile VALUES("5459",".прик109.","110");
INSERT INTO smile VALUES("5460",".прик110.","110");
INSERT INTO smile VALUES("5461",".прик111.","110");
INSERT INTO smile VALUES("5463",".ду44.","84");
INSERT INTO smile VALUES("5464",".ду45.","84");
INSERT INTO smile VALUES("5465",".ду46.","84");
INSERT INTO smile VALUES("5466",".ду47.","84");
INSERT INTO smile VALUES("5467",".ду48.","84");
INSERT INTO smile VALUES("5468",".ду49.","84");
INSERT INTO smile VALUES("5469",".ду50.","84");
INSERT INTO smile VALUES("5470",".ду51.","84");
INSERT INTO smile VALUES("5471","Давай Намутим","66");
INSERT INTO smile VALUES("5472"," Хостер ","66");
INSERT INTO smile VALUES("5522",".стат38.","98");
INSERT INTO smile VALUES("5474","Ястреб","66");
INSERT INTO smile VALUES("5481",".привадм12.","108");
INSERT INTO smile VALUES("5519","ШАЛЬНОЙ","66");
INSERT INTO smile VALUES("5484",".лапушка.","11");
INSERT INTO smile VALUES("5485",".цем2.","11");
INSERT INTO smile VALUES("5486",".любтеб.","11");
INSERT INTO smile VALUES("5487",".люблю.","11");
INSERT INTO smile VALUES("5490",".привадм13.","108");
INSERT INTO smile VALUES("5491",".до1.","113");
INSERT INTO smile VALUES("5492",".до2.","113");
INSERT INTO smile VALUES("5493",".до3.","113");
INSERT INTO smile VALUES("5494",".до4.","113");
INSERT INTO smile VALUES("5495",".до5.","113");
INSERT INTO smile VALUES("5496",".до6.","113");
INSERT INTO smile VALUES("5497",".до7.","113");
INSERT INTO smile VALUES("5498",".до8.","113");
INSERT INTO smile VALUES("5499",".до9.","113");
INSERT INTO smile VALUES("5500",".до10.","113");
INSERT INTO smile VALUES("5501",".до11.","113");
INSERT INTO smile VALUES("5502",".до12.","113");
INSERT INTO smile VALUES("5503",".до13.","113");
INSERT INTO smile VALUES("5504",".до14.","113");
INSERT INTO smile VALUES("5505",".привадм14.","108");
INSERT INTO smile VALUES("5506",".привадм15.","108");
INSERT INTO smile VALUES("5507",".привадм16.","108");
INSERT INTO smile VALUES("5512","ГрЕшНиЦа...","66");
INSERT INTO smile VALUES("5511","ГрЕ[[ш]]НиК...","66");
INSERT INTO smile VALUES("5516",".рмш2.","21");
INSERT INTO smile VALUES("5515",")))","20");
INSERT INTO smile VALUES("5514","ШАЛЬНОЙ ","66");
INSERT INTO smile VALUES("5518",".еда109.","7");
INSERT INTO smile VALUES("5606","Кисуля777","66");
INSERT INTO smile VALUES("5521","ТАТЬЯНА","66");
INSERT INTO smile VALUES("5523",".обн1.","114");
INSERT INTO smile VALUES("5524",".обн2.","114");
INSERT INTO smile VALUES("5525",".обн3.","114");
INSERT INTO smile VALUES("5526",".обн4.","114");
INSERT INTO smile VALUES("5527",".обн5.","114");
INSERT INTO smile VALUES("5528",".обн6.","114");
INSERT INTO smile VALUES("5529",".обн7.","114");
INSERT INTO smile VALUES("5530",".обн8.","114");
INSERT INTO smile VALUES("5531",".обн9.","114");
INSERT INTO smile VALUES("5532",".обн10.","114");
INSERT INTO smile VALUES("5533",".обн11.","114");
INSERT INTO smile VALUES("5534",".обн12.","114");
INSERT INTO smile VALUES("5535",".обн13.","114");
INSERT INTO smile VALUES("5536",".обн14.","114");
INSERT INTO smile VALUES("5537",".обн15.","114");
INSERT INTO smile VALUES("5538",".обн16.","114");
INSERT INTO smile VALUES("5539",".обн17.","114");
INSERT INTO smile VALUES("5540",".обн18.","114");
INSERT INTO smile VALUES("5541",".обн19.","114");
INSERT INTO smile VALUES("5542",".обн20.","114");
INSERT INTO smile VALUES("5543",".обн21.","114");
INSERT INTO smile VALUES("5544",".обн22.","114");
INSERT INTO smile VALUES("5545",".обн23.","114");
INSERT INTO smile VALUES("5546",".обн24.","114");
INSERT INTO smile VALUES("5547",".стат39.","98");
INSERT INTO smile VALUES("5549","Zayaza","66");
INSERT INTO smile VALUES("5551","НяШкА_ВкУсНяШкА..","66");
INSERT INTO smile VALUES("5552","Сухарик","66");
INSERT INTO smile VALUES("5555",".гоп21.","111");
INSERT INTO smile VALUES("5556",".гоп22.","111");
INSERT INTO smile VALUES("5557",".гоп23.","111");
INSERT INTO smile VALUES("5559",".мульт37.","94");
INSERT INTO smile VALUES("5560",".мульт38.","94");
INSERT INTO smile VALUES("5561",".мульт39.","94");
INSERT INTO smile VALUES("5562",".мульт40.","94");
INSERT INTO smile VALUES("5563",".пр134.","83");
INSERT INTO smile VALUES("5564",".пр135.","83");
INSERT INTO smile VALUES("5565",".пр136.","83");
INSERT INTO smile VALUES("5569","Валюша","66");
INSERT INTO smile VALUES("5567",".мипр137","83");
INSERT INTO smile VALUES("5571",".ялютя3.","11");
INSERT INTO smile VALUES("5572",".одцелое.","11");
INSERT INTO smile VALUES("5573",".вместе.","11");
INSERT INTO smile VALUES("5574",".яиты.","11");
INSERT INTO smile VALUES("5575",".ялютя4.","11");
INSERT INTO smile VALUES("5577",".ду52.","84");
INSERT INTO smile VALUES("5578",".ду53.","84");
INSERT INTO smile VALUES("5579",".ду54.","84");
INSERT INTO smile VALUES("5580",".ду55.","84");
INSERT INTO smile VALUES("5581",".ду56.","84");
INSERT INTO smile VALUES("5582",".ду57.","84");
INSERT INTO smile VALUES("5584",".ду58.","84");
INSERT INTO smile VALUES("5585",".ду59.","84");
INSERT INTO smile VALUES("5586",".ду60.","84");
INSERT INTO smile VALUES("5587",".ду61.","84");
INSERT INTO smile VALUES("5588",".ду62.","84");
INSERT INTO smile VALUES("5589",".ду63.","84");
INSERT INTO smile VALUES("5590",".сн14.","88");
INSERT INTO smile VALUES("5591",".сн15.","88");
INSERT INTO smile VALUES("5592",".сн16.","88");
INSERT INTO smile VALUES("5593",".сн17.","88");
INSERT INTO smile VALUES("5594",".сн18.","88");
INSERT INTO smile VALUES("5595",".сн19.","88");
INSERT INTO smile VALUES("5596",".сн20.","88");
INSERT INTO smile VALUES("5597",".сн21.","88");
INSERT INTO smile VALUES("5598",".сн22.","88");
INSERT INTO smile VALUES("5599",".сн23.","88");
INSERT INTO smile VALUES("5600",".сн24.","88");
INSERT INTO smile VALUES("5601",".сн25.","88");
INSERT INTO smile VALUES("5602",".сн26.","88");
INSERT INTO smile VALUES("5603",".сн27.","88");
INSERT INTO smile VALUES("5639",".сн28.","88");
INSERT INTO smile VALUES("5608",".прив48.","96");
INSERT INTO smile VALUES("5609",".прив49.","96");
INSERT INTO smile VALUES("5610",".прив50.","96");
INSERT INTO smile VALUES("5611",".прив51.","96");
INSERT INTO smile VALUES("5612",".прив52.","96");
INSERT INTO smile VALUES("5613",".прив53.","96");
INSERT INTO smile VALUES("5614",".прив54.","96");
INSERT INTO smile VALUES("5615",".прив55.","96");
INSERT INTO smile VALUES("5616",".прив56.","96");
INSERT INTO smile VALUES("5617",".прив57.","96");
INSERT INTO smile VALUES("5618",".прив59.","96");
INSERT INTO smile VALUES("5619",".прив60.","96");
INSERT INTO smile VALUES("5620",".прив61.","96");
INSERT INTO smile VALUES("5621",".прив62.","96");
INSERT INTO smile VALUES("5622",".прив63.","96");
INSERT INTO smile VALUES("5623",".прив64.","96");
INSERT INTO smile VALUES("5624",".прив65.","96");
INSERT INTO smile VALUES("5625",".прив66.","96");
INSERT INTO smile VALUES("5626",".прив67.","96");
INSERT INTO smile VALUES("5627",".ду64.","84");
INSERT INTO smile VALUES("5628",".ду65.","84");
INSERT INTO smile VALUES("5629",".ду66.","84");
INSERT INTO smile VALUES("5630",".ду67.","84");
INSERT INTO smile VALUES("5631",".ду68.","84");
INSERT INTO smile VALUES("5632",".ду69.","84");
INSERT INTO smile VALUES("5633",".ду70.","84");
INSERT INTO smile VALUES("5634",".ду71.","84");
INSERT INTO smile VALUES("5635",".ду72.","84");
INSERT INTO smile VALUES("5636",".ду73.","84");
INSERT INTO smile VALUES("5637",".ду74.","84");
INSERT INTO smile VALUES("5638",".ду75.","84");
INSERT INTO smile VALUES("5641",".сн29.","88");
INSERT INTO smile VALUES("5642",".сн30.","88");
INSERT INTO smile VALUES("5643",".сн31.","88");
INSERT INTO smile VALUES("5644",".сн32.","88");
INSERT INTO smile VALUES("5645",".сн33.","88");
INSERT INTO smile VALUES("5646",".сн34.","88");
INSERT INTO smile VALUES("5647",".сн35.","88");
INSERT INTO smile VALUES("5648",".сн36.","88");
INSERT INTO smile VALUES("5649",".сн37","88");
INSERT INTO smile VALUES("5650",".сн38.","88");
INSERT INTO smile VALUES("5651",".сн39.","88");
INSERT INTO smile VALUES("5652",".сн40.","88");
INSERT INTO smile VALUES("5653",".сн41.","88");
INSERT INTO smile VALUES("5654",".сн42.","88");
INSERT INTO smile VALUES("5655",".сн43.","88");
INSERT INTO smile VALUES("5656",".сн44.","88");
INSERT INTO smile VALUES("5657",".пр138.","83");
INSERT INTO smile VALUES("5658",".пр139.","83");
INSERT INTO smile VALUES("5659",".пр140.","83");
INSERT INTO smile VALUES("5660",".пр141.","83");
INSERT INTO smile VALUES("5661",".пр142.","83");
INSERT INTO smile VALUES("5662",".пр143.","83");
INSERT INTO smile VALUES("5663",".пр144.","83");
INSERT INTO smile VALUES("5664",".пр145.","83");
INSERT INTO smile VALUES("5665",".пр146.","83");
INSERT INTO smile VALUES("5666",".пр147.","83");
INSERT INTO smile VALUES("5667",".пр148.","83");
INSERT INTO smile VALUES("5668",".пр149.","83");
INSERT INTO smile VALUES("5669",".пр150.","83");
INSERT INTO smile VALUES("5670",".пр151.","83");
INSERT INTO smile VALUES("5671",".пр152.","83");
INSERT INTO smile VALUES("5672",".пр153.","83");
INSERT INTO smile VALUES("5673",".пр154.","83");
INSERT INTO smile VALUES("5674",".пр155.","83");
INSERT INTO smile VALUES("5675",".место3.","28");
INSERT INTO smile VALUES("5676",".место2.","28");
INSERT INTO smile VALUES("5677",".место1.","28");
INSERT INTO smile VALUES("5678",".поздзпоб.","28");
INSERT INTO smile VALUES("5679",".поздравляю.","28");
INSERT INTO smile VALUES("5680",".поздравляем.","28");
INSERT INTO smile VALUES("5737",".бон80.","50");
INSERT INTO smile VALUES("5734",".бон77.","50");
INSERT INTO smile VALUES("5735",".бон78.","50");
INSERT INTO smile VALUES("5736",".бон79.","50");
INSERT INTO smile VALUES("5686",".придуприждение.","100");
INSERT INTO smile VALUES("5687",".придуприждение1.","100");
INSERT INTO smile VALUES("5688",".придуприждение2.","100");
INSERT INTO smile VALUES("5689",".придуприждение3.","100");
INSERT INTO smile VALUES("5690",".кп.","91");
INSERT INTO smile VALUES("5691",".кп1.","91");
INSERT INTO smile VALUES("5692",".кп2.","91");
INSERT INTO smile VALUES("5693",".кп3.","91");
INSERT INTO smile VALUES("5694",".кп4.","91");
INSERT INTO smile VALUES("5695",".кп5.","91");
INSERT INTO smile VALUES("5696",".кп6.","91");
INSERT INTO smile VALUES("5697",".кп7.","91");
INSERT INTO smile VALUES("5698",".кп8.","91");
INSERT INTO smile VALUES("5699",".кп9.","91");
INSERT INTO smile VALUES("5700",".кп10.","91");
INSERT INTO smile VALUES("5701",".кп11.","91");
INSERT INTO smile VALUES("5702",".кп12.","91");
INSERT INTO smile VALUES("5703",".кп13.","91");
INSERT INTO smile VALUES("5704",".кп14.","91");
INSERT INTO smile VALUES("5705",".кп15.","91");
INSERT INTO smile VALUES("5706",".кп16.","91");
INSERT INTO smile VALUES("5707",".кп17.","91");
INSERT INTO smile VALUES("5708",".кп18.","91");
INSERT INTO smile VALUES("5709",".кп19.","91");
INSERT INTO smile VALUES("5710",".кп20.","91");
INSERT INTO smile VALUES("5711",".кп21.","91");
INSERT INTO smile VALUES("5712",".кп22.","91");
INSERT INTO smile VALUES("5713",".кп23.","91");
INSERT INTO smile VALUES("5714",".кп24.","91");
INSERT INTO smile VALUES("5715",".кп25.","91");
INSERT INTO smile VALUES("5716",".кп26.","91");
INSERT INTO smile VALUES("5717",".кп27.","91");
INSERT INTO smile VALUES("5718",".кп28.","91");
INSERT INTO smile VALUES("5719",".кп29.","91");
INSERT INTO smile VALUES("5720",".кп30.","91");
INSERT INTO smile VALUES("5721",".кп31.","91");
INSERT INTO smile VALUES("5722",".кп32.","91");
INSERT INTO smile VALUES("5723",".кп33.","91");
INSERT INTO smile VALUES("5724",".кп34.","91");
INSERT INTO smile VALUES("5725",".кп35.","91");
INSERT INTO smile VALUES("5726",".кп36.","91");
INSERT INTO smile VALUES("5727",".кп37.","91");
INSERT INTO smile VALUES("5728",".кп38.","91");
INSERT INTO smile VALUES("5729",".кп39.","91");
INSERT INTO smile VALUES("5730",".кп40.","91");
INSERT INTO smile VALUES("5731",".кп41.","91");
INSERT INTO smile VALUES("5732",".кп42.","91");
INSERT INTO smile VALUES("5733",".кп43.","91");
INSERT INTO smile VALUES("5738",".бон81.","50");
INSERT INTO smile VALUES("5739",".двик.","115");
INSERT INTO smile VALUES("5740",".двик1.","115");
INSERT INTO smile VALUES("5741",".двик2.","115");
INSERT INTO smile VALUES("5742",".двик3.","115");
INSERT INTO smile VALUES("5743",".двик4.","115");
INSERT INTO smile VALUES("5744",".двик5.","115");
INSERT INTO smile VALUES("5745",".двик6.","115");
INSERT INTO smile VALUES("5746",".двик7.","115");
INSERT INTO smile VALUES("5747",".двик8.","115");
INSERT INTO smile VALUES("5748",".двик9.","115");
INSERT INTO smile VALUES("5749",".двик10.","115");
INSERT INTO smile VALUES("5750",".двик11.","115");
INSERT INTO smile VALUES("5751",".двик12.","115");
INSERT INTO smile VALUES("5752",".двик13.","115");
INSERT INTO smile VALUES("5753",".двик14.","115");
INSERT INTO smile VALUES("5754",".двик15.","115");
INSERT INTO smile VALUES("5755",".двик16.","115");
INSERT INTO smile VALUES("5756",".двик17.","115");
INSERT INTO smile VALUES("5757",".двик18.","115");
INSERT INTO smile VALUES("5758",".двик19.","115");
INSERT INTO smile VALUES("5759",".двик20.","115");
INSERT INTO smile VALUES("5760",".двик21.","115");
INSERT INTO smile VALUES("5761",".двик22.","115");
INSERT INTO smile VALUES("5762",".двик23.","115");
INSERT INTO smile VALUES("5763",".двик24.","115");
INSERT INTO smile VALUES("5764",".двик25.","115");
INSERT INTO smile VALUES("5765",".двик26.","115");
INSERT INTO smile VALUES("5766",".двик27.","115");
INSERT INTO smile VALUES("5767",".двик28.","115");
INSERT INTO smile VALUES("5768",".двик29.","115");
INSERT INTO smile VALUES("5769",".двик30.","115");
INSERT INTO smile VALUES("5770",".двик31.","115");
INSERT INTO smile VALUES("5771",".двик32.","115");
INSERT INTO smile VALUES("5772",".двик33.","115");
INSERT INTO smile VALUES("5773",".двик34.","115");
INSERT INTO smile VALUES("5774",".двик35.","115");
INSERT INTO smile VALUES("5775",".двик36.","115");
INSERT INTO smile VALUES("5776",".двик37.","115");
INSERT INTO smile VALUES("5777",".двик38.","115");
INSERT INTO smile VALUES("5778",".двик39.","115");
INSERT INTO smile VALUES("5779",".двик40.","115");
INSERT INTO smile VALUES("5780",".двик41.","115");
INSERT INTO smile VALUES("5781",".двик42.","115");
INSERT INTO smile VALUES("5782",".двик43.","115");
INSERT INTO smile VALUES("5783",".двик44.","115");
INSERT INTO smile VALUES("5784",".двик45.","115");
INSERT INTO smile VALUES("5785",".двик46.","115");
INSERT INTO smile VALUES("5786",".двик47.","115");
INSERT INTO smile VALUES("5787",".двик48.","115");
INSERT INTO smile VALUES("5788",".двик49.","115");
INSERT INTO smile VALUES("5789",".двик50.","115");
INSERT INTO smile VALUES("5790",".двик51.","115");
INSERT INTO smile VALUES("5791",".двик52.","115");
INSERT INTO smile VALUES("5792",".двик53.","115");
INSERT INTO smile VALUES("5793",".двик54.","115");
INSERT INTO smile VALUES("5794",".двик55.","115");
INSERT INTO smile VALUES("5795",".двик56.","115");
INSERT INTO smile VALUES("5796",".маш31.","92");
INSERT INTO smile VALUES("5797",".маш32.","92");
INSERT INTO smile VALUES("5798",".дп22.","95");
INSERT INTO smile VALUES("5799",".дп23.","95");
INSERT INTO smile VALUES("5800",".поц121.","45");
INSERT INTO smile VALUES("5801",".поц122.","45");
INSERT INTO smile VALUES("5802",".поц123.","45");
INSERT INTO smile VALUES("5803",".поц124.","45");
INSERT INTO smile VALUES("5804",".поц125.","45");
INSERT INTO smile VALUES("5805",".поц126.","45");
INSERT INTO smile VALUES("5806",".поц127.","45");
INSERT INTO smile VALUES("5807",".поц128.","45");
INSERT INTO smile VALUES("5808",".поц129.","45");
INSERT INTO smile VALUES("5809",".поц130.","45");
INSERT INTO smile VALUES("5810",".поц131.","45");
INSERT INTO smile VALUES("5811",".поц132.","45");
INSERT INTO smile VALUES("5812",".поц133.","45");
INSERT INTO smile VALUES("5813",".поц134.","45");
INSERT INTO smile VALUES("5814",".поц135.","45");
INSERT INTO smile VALUES("5815",".поц136.","45");
INSERT INTO smile VALUES("5816",".поц137.","45");
INSERT INTO smile VALUES("5817",".поц138","45");
INSERT INTO smile VALUES("5818",".поц139.","45");
INSERT INTO smile VALUES("5819","НяШкА_ВкУсНяШкА....","66");
INSERT INTO smile VALUES("5820",".смл1.","3");
INSERT INTO smile VALUES("5821",".смл2.","3");
INSERT INTO smile VALUES("5822",".смл3.","3");
INSERT INTO smile VALUES("5823",".смл4.","3");
INSERT INTO smile VALUES("5824",".смл5.","3");
INSERT INTO smile VALUES("5825",".смл6.","3");
INSERT INTO smile VALUES("5826",".смл7.","3");
INSERT INTO smile VALUES("5827",".пупс26.","60");
INSERT INTO smile VALUES("5828",".пупс27.","60");
INSERT INTO smile VALUES("5829",".пупс28.","60");
INSERT INTO smile VALUES("5830",".пупс29.","60");
INSERT INTO smile VALUES("5831",".пр156.","83");
INSERT INTO smile VALUES("5832",".пр157.","83");
INSERT INTO smile VALUES("5833",".пр158.","83");
INSERT INTO smile VALUES("5834",".пр159.","83");
INSERT INTO smile VALUES("5835",".пр160.","83");
INSERT INTO smile VALUES("5836",".пр161.","83");
INSERT INTO smile VALUES("5837",".пр162.","83");
INSERT INTO smile VALUES("5838","_DimedroL_","66");
INSERT INTO smile VALUES("5839","Cocaine _De_ Luxe","66");
INSERT INTO smile VALUES("5840",".смл8.","3");
INSERT INTO smile VALUES("5841",".смл9.","3");
INSERT INTO smile VALUES("5842",".смл10.","3");
INSERT INTO smile VALUES("5843",".смл11.","3");
INSERT INTO smile VALUES("5844",".смл12.","3");
INSERT INTO smile VALUES("5845",".смл13.","3");
INSERT INTO smile VALUES("5846",".смл14.","3");
INSERT INTO smile VALUES("5847",".смл15.","3");
INSERT INTO smile VALUES("5848",".смл16.","3");
INSERT INTO smile VALUES("5849",".мульт41.","94");
INSERT INTO smile VALUES("5850",".мульт42.","94");
INSERT INTO smile VALUES("5851",".мульт43.","94");
INSERT INTO smile VALUES("5852",".мульт44.","94");
INSERT INTO smile VALUES("5853",".мульт45.","94");
INSERT INTO smile VALUES("5854",".мульт46.","94");
INSERT INTO smile VALUES("5855",".мульт47.","94");
INSERT INTO smile VALUES("5856",".мульт48.","94");
INSERT INTO smile VALUES("5857",".мульт49.","94");
INSERT INTO smile VALUES("5858",".мульт50.","94");
INSERT INTO smile VALUES("5860","НяШкА_ВкУсНяШкА.......","66");
INSERT INTO smile VALUES("5861",".зак1.","116");
INSERT INTO smile VALUES("5862",".зак2.","116");
INSERT INTO smile VALUES("5863",".зак3.","116");
INSERT INTO smile VALUES("5864",".зак4.","116");
INSERT INTO smile VALUES("5865",".зак5.","116");
INSERT INTO smile VALUES("5866",".зак6.","116");
INSERT INTO smile VALUES("5867",".зак7.","116");
INSERT INTO smile VALUES("5868",".зак8.","116");
INSERT INTO smile VALUES("5869",".зак9.","116");
INSERT INTO smile VALUES("5870",".зак10.","116");
INSERT INTO smile VALUES("5871",".зак11.","116");
INSERT INTO smile VALUES("5872",".зак12.","116");
INSERT INTO smile VALUES("5873",".зак13.","116");
INSERT INTO smile VALUES("5874",".пр163.","83");
INSERT INTO smile VALUES("5875",".пр164.","83");
INSERT INTO smile VALUES("5876",".пр165.","83");
INSERT INTO smile VALUES("5878",".пр166.","83");
INSERT INTO smile VALUES("5879",".пр167.","83");
INSERT INTO smile VALUES("5880",".пр168.","83");
INSERT INTO smile VALUES("5881",".пр169.","83");
INSERT INTO smile VALUES("5882",".пр170.","83");
INSERT INTO smile VALUES("5883",".пр171.","83");
INSERT INTO smile VALUES("5884",".пр172.","83");
INSERT INTO smile VALUES("5885",".пр173.","83");
INSERT INTO smile VALUES("5886",".пр174.","83");
INSERT INTO smile VALUES("5887",".пр175.","83");
INSERT INTO smile VALUES("5888",".пр176.","83");
INSERT INTO smile VALUES("5889",".пр177.","83");
INSERT INTO smile VALUES("5890",".ду76.","84");
INSERT INTO smile VALUES("5891",".ду77.","84");
INSERT INTO smile VALUES("5892",".ду78.","84");
INSERT INTO smile VALUES("5893",".ду79.","84");
INSERT INTO smile VALUES("5894",".ду80.","84");
INSERT INTO smile VALUES("5895",".ду81.","84");
INSERT INTO smile VALUES("5896",".гоп24.","111");
INSERT INTO smile VALUES("5897",".тмой.","11");
INSERT INTO smile VALUES("5898",".тмоя.","11");
INSERT INTO smile VALUES("5899",".сн45.","88");
INSERT INTO smile VALUES("5900",".сн46.","88");
INSERT INTO smile VALUES("5901",".сн47.","88");
INSERT INTO smile VALUES("5902",".сн48.","88");
INSERT INTO smile VALUES("5903",".сн49.","88");
INSERT INTO smile VALUES("5904",".сн50.","88");
INSERT INTO smile VALUES("5905",".сн51.","88");
INSERT INTO smile VALUES("5907","НяШкА_ВкУсНяШкА .1.","66");
INSERT INTO smile VALUES("5908",".зак14.","116");
INSERT INTO smile VALUES("5909",".зак15.","116");
INSERT INTO smile VALUES("5910",".зак16.","116");
INSERT INTO smile VALUES("5911",".зак17.","116");
INSERT INTO smile VALUES("5912",".зак18.","116");
INSERT INTO smile VALUES("5913",".зак19.","116");
INSERT INTO smile VALUES("5914",".зак20.","116");
INSERT INTO smile VALUES("5915",".зак21.","116");
INSERT INTO smile VALUES("5916",".зак22.","116");
INSERT INTO smile VALUES("5917",".зак23.","116");
INSERT INTO smile VALUES("5918",".зак24.","116");
INSERT INTO smile VALUES("5919",".зак25.","116");
INSERT INTO smile VALUES("5920",".зак26.","116");
INSERT INTO smile VALUES("5921",".зак27.","116");
INSERT INTO smile VALUES("5922",".зак28.","116");
INSERT INTO smile VALUES("5923",".зак29.","116");
INSERT INTO smile VALUES("5924",".зак30.","116");
INSERT INTO smile VALUES("5925",".зак31.","116");
INSERT INTO smile VALUES("5926",".зак32.","116");
INSERT INTO smile VALUES("5927",".зак33.","116");
INSERT INTO smile VALUES("5928",".зак34.","116");
INSERT INTO smile VALUES("5929",".гоп25.","111");
INSERT INTO smile VALUES("5931",".мур2.","11");
INSERT INTO smile VALUES("5932",".мур3.","11");
INSERT INTO smile VALUES("5933",".мур4.","11");
INSERT INTO smile VALUES("5934",".мур5.","11");
INSERT INTO smile VALUES("5935",".мур6.","11");
INSERT INTO smile VALUES("5936",".мур7.","11");
INSERT INTO smile VALUES("5937",".мур8.","11");
INSERT INTO smile VALUES("5938",".мур9.","11");
INSERT INTO smile VALUES("5939",".мур10.","11");
INSERT INTO smile VALUES("5940",".мур11.","11");
INSERT INTO smile VALUES("5941","","11");
INSERT INTO smile VALUES("5942",".мур13.","11");
INSERT INTO smile VALUES("5943",".мур14.","11");
INSERT INTO smile VALUES("5944",".прив68.","96");
INSERT INTO smile VALUES("5945",".прив69.","96");
INSERT INTO smile VALUES("5946",".приа70","96");
INSERT INTO smile VALUES("5947",".прив71.","96");
INSERT INTO smile VALUES("5948",".прив73","96");
INSERT INTO smile VALUES("5949",".прив74.","96");
INSERT INTO smile VALUES("5950",".прив75.","96");
INSERT INTO smile VALUES("5951",".прив76.","96");
INSERT INTO smile VALUES("5952",".прив77.","96");
INSERT INTO smile VALUES("5953",".прив78.","96");
INSERT INTO smile VALUES("5954",".прив79.","96");
INSERT INTO smile VALUES("5955",".прив80.","96");
INSERT INTO smile VALUES("5956",".прив81.","96");
INSERT INTO smile VALUES("5957",".прив82.","96");
INSERT INTO smile VALUES("5958",".прив83.","96");
INSERT INTO smile VALUES("5959",".прив84.","96");
INSERT INTO smile VALUES("5960",".прив85.","96");
INSERT INTO smile VALUES("5961",".прив86.","96");
INSERT INTO smile VALUES("5962",".прив87.","96");
INSERT INTO smile VALUES("5963",".прив88.","96");
INSERT INTO smile VALUES("5964",".прив89.","96");
INSERT INTO smile VALUES("5965",".прив90.","96");
INSERT INTO smile VALUES("5966",".прив91.","96");
INSERT INTO smile VALUES("5967",".прив92.","96");
INSERT INTO smile VALUES("5968",".прив93.","96");
INSERT INTO smile VALUES("5969",".прив94.","96");
INSERT INTO smile VALUES("5970",".прив95.","96");
INSERT INTO smile VALUES("5971",".прив96.","96");
INSERT INTO smile VALUES("5972",".прив97.","96");
INSERT INTO smile VALUES("5973",".прив98.","96");
INSERT INTO smile VALUES("5974",".прив99.","96");
INSERT INTO smile VALUES("5975",".прив100.","96");
INSERT INTO smile VALUES("5976",".прив101.","96");
INSERT INTO smile VALUES("5977",".прив102.","96");
INSERT INTO smile VALUES("5978",".прив103.","96");
INSERT INTO smile VALUES("5979",".прив104.","96");
INSERT INTO smile VALUES("5980",".прив105.","96");
INSERT INTO smile VALUES("5981",".прив106.","96");
INSERT INTO smile VALUES("5982",".прив107.","96");
INSERT INTO smile VALUES("5983",".прив108.","96");
INSERT INTO smile VALUES("5984",".пр178.","83");
INSERT INTO smile VALUES("5985",".пр179.","83");
INSERT INTO smile VALUES("5986",".180.","83");
INSERT INTO smile VALUES("5987",".181.","83");
INSERT INTO smile VALUES("5988",".182.","83");
INSERT INTO smile VALUES("5989",".пр183.","83");
INSERT INTO smile VALUES("5990",".пр184.","83");
INSERT INTO smile VALUES("5991",".пр185.","83");
INSERT INTO smile VALUES("5992",".пр186.","83");
INSERT INTO smile VALUES("5993",".пр188.","83");
INSERT INTO smile VALUES("5994",".пр189.","83");
INSERT INTO smile VALUES("5995",".пр190.","83");
INSERT INTO smile VALUES("5996",".пр191.","83");
INSERT INTO smile VALUES("5997",".пр192.","83");
INSERT INTO smile VALUES("5998",".пр193.","83");
INSERT INTO smile VALUES("5999",".пр194.","83");
INSERT INTO smile VALUES("6000",".пр195.","83");
INSERT INTO smile VALUES("6001",".пр196.","83");
INSERT INTO smile VALUES("6002",".пр197.","83");
INSERT INTO smile VALUES("6003",".пр198.","83");
INSERT INTO smile VALUES("6004","Lessi","66");
INSERT INTO smile VALUES("6005",".дев2.","117");
INSERT INTO smile VALUES("6006",".пупс30.","60");
INSERT INTO smile VALUES("6007",".пупс31.","60");
INSERT INTO smile VALUES("6008",".пупс32.","60");
INSERT INTO smile VALUES("6009",".пупс33.","60");
INSERT INTO smile VALUES("6010",".пупс34.","60");
INSERT INTO smile VALUES("6011",".пупс35.","60");
INSERT INTO smile VALUES("6012",".пупс36.","60");
INSERT INTO smile VALUES("6013",".пр199.","83");
INSERT INTO smile VALUES("6014",".пр200.","83");
INSERT INTO smile VALUES("6015",".гоп26.","111");
INSERT INTO smile VALUES("6016",".гоп27.","111");
INSERT INTO smile VALUES("6017",".гоп28.","111");
INSERT INTO smile VALUES("6018",".маш33.","92");
INSERT INTO smile VALUES("6019",".маш34.","92");
INSERT INTO smile VALUES("6020","TUTSIE1","66");
INSERT INTO smile VALUES("6021",".зак35.","116");
INSERT INTO smile VALUES("6022",".зак36.","116");
INSERT INTO smile VALUES("6024",".зак37.","116");
INSERT INTO smile VALUES("6025",".зак38.","116");
INSERT INTO smile VALUES("6026",".зак39.","116");
INSERT INTO smile VALUES("6027",".зак40.","116");
INSERT INTO smile VALUES("6028",".зак41.","116");
INSERT INTO smile VALUES("6030","Ангелочек","66");
INSERT INTO smile VALUES("6031","НяШкА_ВкУсНяШкА......","66");
INSERT INTO smile VALUES("6034",".цвет65.","19");
INSERT INTO smile VALUES("6035",".цвет66.","19");
INSERT INTO smile VALUES("6036",".цвет67.","19");
INSERT INTO smile VALUES("6037",".цвет68.","19");
INSERT INTO smile VALUES("6038",".цвет69.","19");
INSERT INTO smile VALUES("6039",".цвет70.","19");
INSERT INTO smile VALUES("6040",".цвет71.","19");
INSERT INTO smile VALUES("6041",".цвет72.","19");
INSERT INTO smile VALUES("6042",".цвет73.","19");
INSERT INTO smile VALUES("6043",".цвет74.","19");
INSERT INTO smile VALUES("6044",".цвет75.","19");
INSERT INTO smile VALUES("6045",".цвет76.","19");
INSERT INTO smile VALUES("6046",".цвет77.","19");
INSERT INTO smile VALUES("6047","НяШкА_ВкУсНяШкА.........","66");
INSERT INTO smile VALUES("6048","TUTSIE","66");
INSERT INTO smile VALUES("6049","Impulse","66");
INSERT INTO smile VALUES("6050","НяШкА_ВкУсНяШкА........","66");
INSERT INTO smile VALUES("6051","НяШкА_ВкУсНяШкА..3","66");
INSERT INTO smile VALUES("6052",".зак42.","116");
INSERT INTO smile VALUES("6053",".зак43.","116");
INSERT INTO smile VALUES("6054",".зак44.","116");
INSERT INTO smile VALUES("6055",".зак45.","116");
INSERT INTO smile VALUES("6056",".зак47.","116");
INSERT INTO smile VALUES("6057",".зак46.","116");
INSERT INTO smile VALUES("6058","НяШкА_ВкУсНяШкА.....","66");
INSERT INTO smile VALUES("6059",".ли92.","89");
INSERT INTO smile VALUES("6060",".ли93.","89");
INSERT INTO smile VALUES("6061",".ли94.","89");
INSERT INTO smile VALUES("6062",".ли95.","89");
INSERT INTO smile VALUES("6063",".ли96.","89");
INSERT INTO smile VALUES("6064",".ли97.","89");
INSERT INTO smile VALUES("6065",".ли98.","89");
INSERT INTO smile VALUES("6066",".ли99.","89");
INSERT INTO smile VALUES("6067",".ли100.","89");
INSERT INTO smile VALUES("6068",".ли101.","89");
INSERT INTO smile VALUES("6069",".ли102.","89");
INSERT INTO smile VALUES("6070",".пр201.","83");
INSERT INTO smile VALUES("6071",".пр202.","83");
INSERT INTO smile VALUES("6072",".пр203.","83");
INSERT INTO smile VALUES("6073",".пр204.","83");
INSERT INTO smile VALUES("6074",".пр205.","83");
INSERT INTO smile VALUES("6075",".пр206.","83");
INSERT INTO smile VALUES("6076",".пр207.","83");
INSERT INTO smile VALUES("6077",".пр208.","83");
INSERT INTO smile VALUES("6078",".пр209.","83");
INSERT INTO smile VALUES("6079",".пр210.","83");
INSERT INTO smile VALUES("6080",".пр211.","83");
INSERT INTO smile VALUES("6081",".пр212.","83");
INSERT INTO smile VALUES("6082",".пр213.","83");
INSERT INTO smile VALUES("6083",".пр214.","83");
INSERT INTO smile VALUES("6084",".пр215.","83");
INSERT INTO smile VALUES("6085",".пр216.","83");
INSERT INTO smile VALUES("6086",".мульт51.","94");
INSERT INTO smile VALUES("6087",".мульт52.","94");
INSERT INTO smile VALUES("6088",".мульт53.","94");
INSERT INTO smile VALUES("6089",".мульт54.","94");
INSERT INTO smile VALUES("6090",".прик112.","110");
INSERT INTO smile VALUES("6091",".прик113.","110");
INSERT INTO smile VALUES("6092",".мур15.","11");
INSERT INTO smile VALUES("6093",".мур16. ","11");
INSERT INTO smile VALUES("6094",".мур17.","11");
INSERT INTO smile VALUES("6095",".мур18.","11");
INSERT INTO smile VALUES("6096",".мур19.","11");
INSERT INTO smile VALUES("6097","ГрЕшНиЦа","66");
INSERT INTO smile VALUES("6098","ГрЕ[[ш]]НиК","66");
INSERT INTO smile VALUES("6099",".мур20.","11");
INSERT INTO smile VALUES("6100",".мур21.","11");
INSERT INTO smile VALUES("6101",".мур22.","11");
INSERT INTO smile VALUES("6102",".мур23.","11");
INSERT INTO smile VALUES("6103",".прик114.","110");
INSERT INTO smile VALUES("6104",".прик115.","110");
INSERT INTO smile VALUES("6105",".прик116.","110");
INSERT INTO smile VALUES("6106",".прик117.","110");
INSERT INTO smile VALUES("6107",".прик118.","110");
INSERT INTO smile VALUES("6108",".прик119.","110");
INSERT INTO smile VALUES("6109",".прик120.","110");
INSERT INTO smile VALUES("6110",".прик121.","110");
INSERT INTO smile VALUES("6111",".прик122.","110");
INSERT INTO smile VALUES("6112",".прик123.","110");
INSERT INTO smile VALUES("6113",".прик124.","110");
INSERT INTO smile VALUES("6114",".прик125.","110");
INSERT INTO smile VALUES("6115",".прик126.","110");
INSERT INTO smile VALUES("6116",".прик127.","110");
INSERT INTO smile VALUES("6117",".прик128.","110");
INSERT INTO smile VALUES("6118",".прик129.","110");
INSERT INTO smile VALUES("6119",".прик130.","110");
INSERT INTO smile VALUES("6120",".прик131.","110");
INSERT INTO smile VALUES("6121",".прик132.","110");
INSERT INTO smile VALUES("6122",".прик133.","110");
INSERT INTO smile VALUES("6123",".прик134.","110");
INSERT INTO smile VALUES("6124",".прик135.","110");
INSERT INTO smile VALUES("6125",".прик136.","110");
INSERT INTO smile VALUES("6126",".прик137.","110");
INSERT INTO smile VALUES("6127",".прик138.","110");
INSERT INTO smile VALUES("6128",".прик139.","110");
INSERT INTO smile VALUES("6129",".пупс37.","60");
INSERT INTO smile VALUES("6130",".пупс38.","60");
INSERT INTO smile VALUES("6131",".пупс39.","60");
INSERT INTO smile VALUES("6132",".пупс40.","60");
INSERT INTO smile VALUES("6133",".пупс41.","60");
INSERT INTO smile VALUES("6134",".пупс42.","60");
INSERT INTO smile VALUES("6135",".пупс43.","60");
INSERT INTO smile VALUES("6136",".пупс44.","60");
INSERT INTO smile VALUES("6137",".прив109.","96");
INSERT INTO smile VALUES("6138",".прив110.","96");
INSERT INTO smile VALUES("6139",".прив111.","96");
INSERT INTO smile VALUES("6140",".прив112.","96");
INSERT INTO smile VALUES("6141",".прив113.","96");
INSERT INTO smile VALUES("6142",".прив114.","96");
INSERT INTO smile VALUES("6143",".прик217.","83");
INSERT INTO smile VALUES("6144",".прик218.","83");
INSERT INTO smile VALUES("6145",".прик219.","83");
INSERT INTO smile VALUES("6146",".гоп29.","111");
INSERT INTO smile VALUES("6149",".др28.","99");
INSERT INTO smile VALUES("6150",".др29.","99");
INSERT INTO smile VALUES("6151",".др30.","99");
INSERT INTO smile VALUES("6152",".др31.","99");
INSERT INTO smile VALUES("6153",".др32.","99");
INSERT INTO smile VALUES("6154",".др33.","99");
INSERT INTO smile VALUES("6155",".мур24.","11");
INSERT INTO smile VALUES("6156",".мур25.","11");
INSERT INTO smile VALUES("6157",".мур26.","11");
INSERT INTO smile VALUES("6158",".мур27.","11");
INSERT INTO smile VALUES("6159",".мур28.","11");
INSERT INTO smile VALUES("6160",".мур29.","11");
INSERT INTO smile VALUES("6161",".мур30.","11");
INSERT INTO smile VALUES("6162",".мур32.","11");
INSERT INTO smile VALUES("6163",".мур33.","11");
INSERT INTO smile VALUES("6164",".мур34.","11");
INSERT INTO smile VALUES("6165","Элис","66");
INSERT INTO smile VALUES("6166","napapidgi..","66");
INSERT INTO smile VALUES("6167","НяШкА_ВкУсНяШкА5","66");
INSERT INTO smile VALUES("6168","Ща_Леща_Дам","66");
INSERT INTO smile VALUES("6172","","86");
INSERT INTO smile VALUES("6173",".дв29.","86");
INSERT INTO smile VALUES("6174",".дв30.","86");
INSERT INTO smile VALUES("6175",".дв31.","86");
INSERT INTO smile VALUES("6176",".дв32.","86");
INSERT INTO smile VALUES("6177",".дв33.","86");
INSERT INTO smile VALUES("6178",".дв34.","86");
INSERT INTO smile VALUES("6179",".дв35.","86");
INSERT INTO smile VALUES("6180",".дв36.","86");
INSERT INTO smile VALUES("6181",".дв37.","86");
INSERT INTO smile VALUES("6182",".дв38.","86");
INSERT INTO smile VALUES("6183",".дв39.","86");
INSERT INTO smile VALUES("6184",".дв40.","86");
INSERT INTO smile VALUES("6185",".дв41.","86");
INSERT INTO smile VALUES("6186",".дв42.","86");
INSERT INTO smile VALUES("6187",".дв43.","86");
INSERT INTO smile VALUES("6188",".дв44.","86");
INSERT INTO smile VALUES("6189",".гоп30.","111");
INSERT INTO smile VALUES("6190",".гоп31.","111");
INSERT INTO smile VALUES("6191",".гоп32.","111");
INSERT INTO smile VALUES("6192",".гоп33.","111");
INSERT INTO smile VALUES("6193",".гоп34.","111");
INSERT INTO smile VALUES("6194",".гоп35.","111");
INSERT INTO smile VALUES("6195",".гоп36.","111");
INSERT INTO smile VALUES("6196",".прик220.","83");
INSERT INTO smile VALUES("6197",".прик221.","83");
INSERT INTO smile VALUES("6198",".прик222.","83");
INSERT INTO smile VALUES("6199",".прик223.","83");
INSERT INTO smile VALUES("6200",".прик224.","83");
INSERT INTO smile VALUES("6201",".прик225.","83");
INSERT INTO smile VALUES("6202",".прик226.","83");
INSERT INTO smile VALUES("6206","_МаЖоР_ ","66");
INSERT INTO smile VALUES("6205","твоя_4ерная_полоса ","66");
INSERT INTO smile VALUES("6207","bokser37","66");
INSERT INTO smile VALUES("6208","НяШкА_ВкУсНяШкА","66");



DROP TABLE IF EXISTS `smile_dir`;

CREATE TABLE `smile_dir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `opis` varchar(320) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=118 DEFAULT CHARSET=utf8;

INSERT INTO smile_dir VALUES("3","❇❇ДЕЙСТВИЯ❇❇","");
INSERT INTO smile_dir VALUES("4","❇❇ДОБРО И ЗЛО❇❇","");
INSERT INTO smile_dir VALUES("5","❇❇ДРАКИ ОРУЖИЕ❇❇","");
INSERT INTO smile_dir VALUES("6","❇❇ДУРДОМ❇❇","");
INSERT INTO smile_dir VALUES("7","❇❇ЕДА НАПИТКИ❇❇","");
INSERT INTO smile_dir VALUES("8","❇❇ЖЕСТЫ❇❇","");
INSERT INTO smile_dir VALUES("9","❇❇ЖИВОТНЫЕ❇❇","");
INSERT INTO smile_dir VALUES("10","❇❇ЗНАКИ НАДПИСИ❇❇","");
INSERT INTO smile_dir VALUES("11","❇❇ЛЮБОВЬ❇❇","");
INSERT INTO smile_dir VALUES("12","❇❇МУЗЫКА❇❇","");
INSERT INTO smile_dir VALUES("13","❇❇ПРАЗДНИКИ ❇❇","");
INSERT INTO smile_dir VALUES("14","❇❇ПЕРСОНАЖИ❇❇","");
INSERT INTO smile_dir VALUES("16","❇❇СЕМЬЯ❇❇","");
INSERT INTO smile_dir VALUES("22","❇❇СПОРТ ❇❇","");
INSERT INTO smile_dir VALUES("18","❇❇ТЕХНИКА❇❇","");
INSERT INTO smile_dir VALUES("19","❇❇ЦВЕТЫ❇❇","");
INSERT INTO smile_dir VALUES("20","❇❇ЭМОЦИИ❇❇","");
INSERT INTO smile_dir VALUES("21","❇❇ОБЩЕНИЕ❇❇","");
INSERT INTO smile_dir VALUES("24","❇❇КВАДРАТНЫЕ❇❇","");
INSERT INTO smile_dir VALUES("28","❇❇АДМИНКА❇❇","");
INSERT INTO smile_dir VALUES("88","⭐ СПОКОЙНОЙ НОЧИ⭐","");
INSERT INTO smile_dir VALUES("115","ДЛЯ ВИКТОРИНЫ","");
INSERT INTO smile_dir VALUES("84","⭐ ДОБРОЕ УТРО⭐","");
INSERT INTO smile_dir VALUES("85","⭐ ДОБРЫЙ ДЕНЬ⭐","");
INSERT INTO smile_dir VALUES("86","⭐ ДОБРЫЙ ВЕЧЕР⭐","");
INSERT INTO smile_dir VALUES("36","❇❇ЦИФРЫ❇❇","");
INSERT INTO smile_dir VALUES("89","⭐ЛИНИИ⭐","");
INSERT INTO smile_dir VALUES("45","❇❇ПОЦЕЛУИ❇❇","");
INSERT INTO smile_dir VALUES("49","❇❇ЭРО ТОЛЬКО В ЛИЧКУ❇❇","");
INSERT INTO smile_dir VALUES("50","❇❇БОНУСЫ✴❇❇","");
INSERT INTO smile_dir VALUES("54","❇❇ДЖИНЫ❇❇","");
INSERT INTO smile_dir VALUES("57","❇❇ФОТОКОНКУРС✴АДМ❇❇","");
INSERT INTO smile_dir VALUES("60","❇❇ПУПСЫ❇❇","");
INSERT INTO smile_dir VALUES("65","Для форума","");
INSERT INTO smile_dir VALUES("66","Ники","");
INSERT INTO smile_dir VALUES("90","⭐ РАЗДЕЛИТЕЛИ⭐","");
INSERT INTO smile_dir VALUES("91","⭐КНОПКИ ПЕРЕХОДЫ⭐","");
INSERT INTO smile_dir VALUES("83","**ПРИКОЛЫ***","");
INSERT INTO smile_dir VALUES("92","Машка Забияшка","");
INSERT INTO smile_dir VALUES("93","ДЛЯ ДНЕВНИКОВ ","");
INSERT INTO smile_dir VALUES("94","Мультяхи ","");
INSERT INTO smile_dir VALUES("95","Добро пожаловать","");
INSERT INTO smile_dir VALUES("96","Привет","");
INSERT INTO smile_dir VALUES("97","Тема дневников","");
INSERT INTO smile_dir VALUES("98","СТАТУСЫ","");
INSERT INTO smile_dir VALUES("99","С ДНЕМ РОЖДЕНИЯ","");
INSERT INTO smile_dir VALUES("100","Предупреждение для Админов ","");
INSERT INTO smile_dir VALUES("101","Надписи","");
INSERT INTO smile_dir VALUES("102","ДЛЯ ДЕВОЧЕК","");
INSERT INTO smile_dir VALUES("105","8 МАРТА","");
INSERT INTO smile_dir VALUES("106","КОЛОБКИ","");
INSERT INTO smile_dir VALUES("107","ПОЖЕЛАНИЯ","");
INSERT INTO smile_dir VALUES("108","Приветы от Админов ","");
INSERT INTO smile_dir VALUES("109","Для Гостевой","");
INSERT INTO smile_dir VALUES("110","Приколянды с Надписями ","");
INSERT INTO smile_dir VALUES("111","Гопацульки ","");
INSERT INTO smile_dir VALUES("112","БЛАГОДАРЮ-СПАСИБО","");
INSERT INTO smile_dir VALUES("113","23 февраля","");
INSERT INTO smile_dir VALUES("114","ОБНИМАШКИ","");
INSERT INTO smile_dir VALUES("116","Заказные ","");
INSERT INTO smile_dir VALUES("117","Колобки для Девочек ","");



DROP TABLE IF EXISTS `smiles`;

CREATE TABLE `smiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(30) NOT NULL DEFAULT '0',
  `path` char(30) NOT NULL DEFAULT '0',
  `cat` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `soc`;

CREATE TABLE `soc` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `socwap`;

CREATE TABLE `socwap` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1241 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `spamus`;

CREATE TABLE `spamus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `razdel` varchar(40) DEFAULT NULL,
  `id_spam` int(11) NOT NULL,
  `types` int(11) DEFAULT '0',
  `time` int(12) DEFAULT NULL,
  `id_post` int(111) DEFAULT NULL,
  `spam` varchar(1000) DEFAULT NULL,
  `id_object` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `status`;

CREATE TABLE `status` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `like` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `pokaz` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  `ras` varchar(5) DEFAULT NULL,
  `file` varchar(128) DEFAULT NULL,
  `size` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=254 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `status_komm`;

CREATE TABLE `status_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `like` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=159 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `status_like`;

CREATE TABLE `status_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `id_status` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=568 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stena`;

CREATE TABLE `stena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_stena` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `read` int(11) DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=41 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stena_like`;

CREATE TABLE `stena_like` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_stena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stikers`;

CREATE TABLE `stikers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `category_id` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stikers_category`;

CREATE TABLE `stikers_category` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `coins` int(11) NOT NULL DEFAULT '0',
  `name` varchar(128) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `stikers_user`;

CREATE TABLE `stikers_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL DEFAULT '0',
  `category_id` int(11) NOT NULL DEFAULT '0',
  `user_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `support`;

CREATE TABLE `support` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `type` char(10) NOT NULL DEFAULT '',
  `name` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `support_coms`;

CREATE TABLE `support_coms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `mes` text NOT NULL,
  `uid` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `survey_v`;

CREATE TABLE `survey_v` (
  `id_s` int(11) NOT NULL,
  `id_r` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_s` (`id_s`,`id_r`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `tape`;

CREATE TABLE `tape` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `count` int(11) NOT NULL,
  `id_file` int(11) NOT NULL,
  `avtor` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `type` varchar(24) NOT NULL,
  `read` set('0','1') NOT NULL DEFAULT '0',
  `avatar` int(11) DEFAULT '0',
  `ot_kogo` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`avtor`),
  KEY `read` (`read`)
) ENGINE=MyISAM AUTO_INCREMENT=11485 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `tape_set`;

CREATE TABLE `tape_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `lenta_status_like` int(11) DEFAULT '1',
  `lenta_status` int(11) DEFAULT '1',
  `lenta_foto` int(11) DEFAULT '1',
  `lenta_files` int(11) DEFAULT '1',
  `lenta_forum` int(11) DEFAULT '1',
  `lenta_notes` int(11) DEFAULT '1',
  `lenta_avatar` int(11) DEFAULT '1',
  `lenta_frends` int(11) DEFAULT '1',
  `lenta_poll` int(1) DEFAULT '1',
  `lenta_poll_like` int(1) DEFAULT '1',
  `lenta_poll_vote` int(1) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=620 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `target_adm`;

CREATE TABLE `target_adm` (
  `id` int(11) NOT NULL,
  `ya` int(11) NOT NULL,
  `v_ya` int(11) NOT NULL,
  `tomat` int(11) NOT NULL,
  `v_tomat` int(11) NOT NULL,
  `ka` int(11) NOT NULL,
  `v_ka` int(11) NOT NULL,
  `sh` int(11) NOT NULL,
  `v_sh` int(11) NOT NULL,
  `yadro` int(11) NOT NULL,
  `v_yadro` int(11) NOT NULL,
  `min` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO target_adm VALUES("1","30","1","100","0","150","0","200","0","300","0","60");



DROP TABLE IF EXISTS `target_chat`;

CREATE TABLE `target_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=147257 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `target_his`;

CREATE TABLE `target_his` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `w` int(11) NOT NULL,
  `h` int(11) NOT NULL,
  `or` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `or` (`or`)
) ENGINE=MyISAM AUTO_INCREMENT=133845 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `target_us`;

CREATE TABLE `target_us` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `kol` int(11) NOT NULL,
  `or` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `or` (`or`)
) ENGINE=MyISAM AUTO_INCREMENT=6743 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `text_bot`;

CREATE TABLE `text_bot` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3005 DEFAULT CHARSET=utf8;

INSERT INTO text_bot VALUES("1","привет!");
INSERT INTO text_bot VALUES("2","Как дела? ");
INSERT INTO text_bot VALUES("3","Че делаешь? ");
INSERT INTO text_bot VALUES("4","Пообщаемся? ");
INSERT INTO text_bot VALUES("5"," а тебя только такое волнует? ");
INSERT INTO text_bot VALUES("6"," да жаль у тебя не такая");
INSERT INTO text_bot VALUES("7"," что посчитаешь нужным");
INSERT INTO text_bot VALUES("8"," почему я могу передвигаться везде кроме своей страници?");
INSERT INTO text_bot VALUES("9","Большие сиськи)) ");
INSERT INTO text_bot VALUES("10"," всмысле? ");
INSERT INTO text_bot VALUES("11"," уже значит исправил");
INSERT INTO text_bot VALUES("12","Хай пиплы");
INSERT INTO text_bot VALUES("13","Всем хаюшки");
INSERT INTO text_bot VALUES("14","Бармен как дела? ");
INSERT INTO text_bot VALUES("15","Бармен привет");
INSERT INTO text_bot VALUES("16"," как дела? ");
INSERT INTO text_bot VALUES("17"," .привеет1.  ");
INSERT INTO text_bot VALUES("18"," регулярно ");
INSERT INTO text_bot VALUES("19"," привет,да пол страницы ток вижу до статуса, больше не двигается");
INSERT INTO text_bot VALUES("20","Ок потом решим у меня норм все");
INSERT INTO text_bot VALUES("21","Всем привет люди");
INSERT INTO text_bot VALUES("22"," Здравствуйте ");
INSERT INTO text_bot VALUES("23"," а че на вы? ");
INSERT INTO text_bot VALUES("24"," захотелось ");
INSERT INTO text_bot VALUES("25","))))))))");
INSERT INTO text_bot VALUES("26","[youtub]ViXFgSu50RE[/youtub]");
INSERT INTO text_bot VALUES("27","[youtub]https://youtu.be/ViXFgSu50RE[/youtub]");
INSERT INTO text_bot VALUES("28"," .приветики.  Всем");
INSERT INTO text_bot VALUES("29","ира привет как дела? ");
INSERT INTO text_bot VALUES("30"," так себе");
INSERT INTO text_bot VALUES("31"," просто");
INSERT INTO text_bot VALUES("32"," ты можешь смотреть только те страницы.которые без статуса.у меня такая же хрень");
INSERT INTO text_bot VALUES("33","пардон,уже наладили.");
INSERT INTO text_bot VALUES("34"," Уже все зделано)))");
INSERT INTO text_bot VALUES("35"," спасибо.я уже вижу.");
INSERT INTO text_bot VALUES("36",".смех2.");
INSERT INTO text_bot VALUES("37","Туман");
INSERT INTO text_bot VALUES("38","А как добовлять сюда картинку или видио?");
INSERT INTO text_bot VALUES("39","Доброе утро.сайт!");
INSERT INTO text_bot VALUES("40"," спасибо");
INSERT INTO text_bot VALUES("41"," .дутро13. Всем");
INSERT INTO text_bot VALUES("42","старый прикольчик");
INSERT INTO text_bot VALUES("43","Всем привет)) ");
INSERT INTO text_bot VALUES("44"," не чего пойдет мои дела");
INSERT INTO text_bot VALUES("45","Выходим дружно в беседку! .диско2.");
INSERT INTO text_bot VALUES("46","ещё прикол");
INSERT INTO text_bot VALUES("47","вот");
INSERT INTO text_bot VALUES("48","танцуют все!");
INSERT INTO text_bot VALUES("49"," .утро27.  Всем");
INSERT INTO text_bot VALUES("50","стесняшка .смех2.");
INSERT INTO text_bot VALUES("51","Почему картинка закрытая пришла?");
INSERT INTO text_bot VALUES("52"," .вечер3. ");
INSERT INTO text_bot VALUES("53","эх дорога .ржу.");
INSERT INTO text_bot VALUES("54","Не спать!");
INSERT INTO text_bot VALUES("55"," зарницу запустите пожалста .ор.");
INSERT INTO text_bot VALUES("56","Физкульт привет! .смех2.");
INSERT INTO text_bot VALUES("57","где?");
INSERT INTO text_bot VALUES("58","Всем .прив. ");
INSERT INTO text_bot VALUES("59"," Давай я Натали Очень приятно ");
INSERT INTO text_bot VALUES("60"," привет. А я вика. Как твоё ничего?");
INSERT INTO text_bot VALUES("61","А мне мороженого .ор. ");
INSERT INTO text_bot VALUES("62","ну и ладно.сама себе куплю .смех2.");
INSERT INTO text_bot VALUES("63"," Приветик. Да нормально а твоё?");
INSERT INTO text_bot VALUES("64"," Ты откуда?:)");
INSERT INTO text_bot VALUES("65"," Я имела ввиду с какого города?:)");
INSERT INTO text_bot VALUES("66"," Ну и ладно ");
INSERT INTO text_bot VALUES("67"," и моё нормально.как погодка у вас?");
INSERT INTO text_bot VALUES("68"," У нас жарко а у вас?");
INSERT INTO text_bot VALUES("69"," у нас как осень.холодно.и лето не видели.дожди и холод.ты походу с украины.там тепло");
INSERT INTO text_bot VALUES("70"," Да я с Украины, а ты откуда?");
INSERT INTO text_bot VALUES("71"," я с россии.климат воще изменился.холоднее стало");
INSERT INTO text_bot VALUES("72"," Там всегда климат меняется");
INSERT INTO text_bot VALUES("73"," да ,но это уже слишком.солнышко редко видеть стали. Обьяснение есть.настроили аэс.леса вырубили.отходы радиоактивные зарыли.");
INSERT INTO text_bot VALUES("74"," Да нас тоже скоро такое же ожидает, этим летом только два раза шёл дождь и всё ");
INSERT INTO text_bot VALUES("75"," засуха тож плохо.а нас заливает.вот несколько дней ток нет дождя.так ветер штормовой. А зимой снегом засыпает.");
INSERT INTO text_bot VALUES("76","тож старый клипчик");
INSERT INTO text_bot VALUES("77"," это на любителя.");
INSERT INTO text_bot VALUES("78"," приветик  .цвет36. ");
INSERT INTO text_bot VALUES("79"," Приветик ");
INSERT INTO text_bot VALUES("80"," теперь тут");
INSERT INTO text_bot VALUES("81"," почему всё.мне зарница нравиться и скачки и футбол.война за сердце.карты не пользовались спросом у обиталей никогда.сам спрашиваешь что добавить.а добавляешь не то что просили.можешь меня банить 3а правду.если хочешь.просто хочу ,чтоб стал лучше");
INSERT INTO text_bot VALUES("82","карты не пользовались спросом");
INSERT INTO text_bot VALUES("83","и бармен мне нравиться .смех2.");
INSERT INTO text_bot VALUES("84"," я тебе ответила.но ты удалил мой ответ");
INSERT INTO text_bot VALUES("85"," зачем удалять.пусть читают.беседка должна шуметь бурлить и материться .смех2.");
INSERT INTO text_bot VALUES("86"," .утро16.  ");
INSERT INTO text_bot VALUES("87","Всем салют!");
INSERT INTO text_bot VALUES("88",".всем прив.  ");
INSERT INTO text_bot VALUES("89"," Между пью.чаек. И думаю кому подарить цветы..ах..цвет. ");
INSERT INTO text_bot VALUES("90"," привет. Меня Сашка назвали родные..ах. Тебя как? ");
INSERT INTO text_bot VALUES("91"," за что?.глаза.");
INSERT INTO text_bot VALUES("92"," ааа,.ах. Пожалуйста..ах. Карина. А откудо Карина? Я за город? ");
INSERT INTO text_bot VALUES("93",".яху. Я тоже как и ты Россиянин. А город мой.круг. Анапа а твой? ");
INSERT INTO text_bot VALUES("94"," .день1.  ");
INSERT INTO text_bot VALUES("95","Добрый. ");
INSERT INTO text_bot VALUES("96"," спасибо. Я уже тут. И среди всех ты самый общительный..дружба.");
INSERT INTO text_bot VALUES("97"," Добрый:)");
INSERT INTO text_bot VALUES("98"," чё.с ботом пообщался? .ржу.");
INSERT INTO text_bot VALUES("99"," привет,как настрой?");
INSERT INTO text_bot VALUES("100","почему в баре одни напитки? Водку нечем закусывать .смех2.");
INSERT INTO text_bot VALUES("101","вау.закуска! Спасибо .смех2.");
INSERT INTO text_bot VALUES("102"," ща посмотрю.");
INSERT INTO text_bot VALUES("103"," закуска есть.хотела хулигану стриптиз заказать.а его нет .смех2.");
INSERT INTO text_bot VALUES("104"," настроение отличное ");
INSERT INTO text_bot VALUES("105"," бармен мешаешь.ща разберу на запчасти .ржу.");
INSERT INTO text_bot VALUES("106"," и у меня позитивное. Солнечный денёк.хорошо!");
INSERT INTO text_bot VALUES("107","Если бы ещё бармен не мешал было бы вообще супер.ржу.");
INSERT INTO text_bot VALUES("108"," да уж.путается под ногами .смех2.");
INSERT INTO text_bot VALUES("109"," спасибо. Обожрусь и умру молодой .смех2.");
INSERT INTO text_bot VALUES("110","зарницу нам запустите плиз");
INSERT INTO text_bot VALUES("111"," Привет!");
INSERT INTO text_bot VALUES("112"," привет.как настрой?");
INSERT INTO text_bot VALUES("113"," кыш отсюда .ржу.");
INSERT INTO text_bot VALUES("114"," Не знаю.лол.");
INSERT INTO text_bot VALUES("115"," вижу позитивный .смех2.");
INSERT INTO text_bot VALUES("116"," У тебя как настрой?");
INSERT INTO text_bot VALUES("117"," у меня зашибись настрой .диско2.");
INSERT INTO text_bot VALUES("118"," Теперь видно!.лол.");
INSERT INTO text_bot VALUES("119"," .д.д4. ");
INSERT INTO text_bot VALUES("120","танцы");
INSERT INTO text_bot VALUES("121"," .вечер34. ");
INSERT INTO text_bot VALUES("122"," .танц16.  ");
INSERT INTO text_bot VALUES("123"," Приветик:) Как ты?");
INSERT INTO text_bot VALUES("124"," активируй клан пожалста");
INSERT INTO text_bot VALUES("125"," Клан? Какой?");
INSERT INTO text_bot VALUES("126"," и тебе тоже  .вечер39. ");
INSERT INTO text_bot VALUES("127"," приветик так себе");
INSERT INTO text_bot VALUES("128"," Толя.мой");
INSERT INTO text_bot VALUES("129"," Хорошо думаю!");
INSERT INTO text_bot VALUES("130"," мне написали клан успешно создан и что он на модерации");
INSERT INTO text_bot VALUES("131","я вижу.спасибо");
INSERT INTO text_bot VALUES("132"," Ты чего-то не то видишь!");
INSERT INTO text_bot VALUES("133"," всё то.ты чё то запутался");
INSERT INTO text_bot VALUES("134"," Королева!!!");
INSERT INTO text_bot VALUES("135","Ура! Апплодисменты мне! .смех2.");
INSERT INTO text_bot VALUES("136","  .апл2. ");
INSERT INTO text_bot VALUES("137"," .дутро15. ");
INSERT INTO text_bot VALUES("138","Доброе утро сайт!");
INSERT INTO text_bot VALUES("139","Доброго обеда вам люди. ");
INSERT INTO text_bot VALUES("140","зарницу .ор.");
INSERT INTO text_bot VALUES("141","фиг тебе а не зарница .смех2.");
INSERT INTO text_bot VALUES("142"," .вечер43. Всем");
INSERT INTO text_bot VALUES("143"," [marquee].вечер2.[/marquee]");
INSERT INTO text_bot VALUES("144"," .дутро11. ");
INSERT INTO text_bot VALUES("145"," хорошего дня");
INSERT INTO text_bot VALUES("146"," Ух. Спасибо. Красиво");
INSERT INTO text_bot VALUES("147","Скука  .бах. ");
INSERT INTO text_bot VALUES("148"," Давай знакомиться :) Я Ольчик :)");
INSERT INTO text_bot VALUES("149"," Какая скрытность .смех2.");
INSERT INTO text_bot VALUES("150"," Яфненький перец :)");
INSERT INTO text_bot VALUES("151"," Приве!");
INSERT INTO text_bot VALUES("152"," .ночи1. ");
INSERT INTO text_bot VALUES("153"," Доброго времени суток :)");
INSERT INTO text_bot VALUES("154","[IMG]https://wmpics.pics/di-OVIV.gif[/IMG]");
INSERT INTO text_bot VALUES("155"," .спас9.  ");
INSERT INTO text_bot VALUES("156","Всем хэллооуууу  .дприв. ");
INSERT INTO text_bot VALUES("157"," привет, как дела? ");
INSERT INTO text_bot VALUES("158"," хэллооуууу ботик, о птичках.лол.");
INSERT INTO text_bot VALUES("159"," двое.");
INSERT INTO text_bot VALUES("160"," .вечер7. ");
INSERT INTO text_bot VALUES("161"," масяяяяя.ор.я туточки.яху.");
INSERT INTO text_bot VALUES("162","На вопрос темы дня тут отвечать??? ");
INSERT INTO text_bot VALUES("163","Блин вообщем, ответ трое.яху.на вашу загадку");
INSERT INTO text_bot VALUES("164"," .дутро12. Всем");
INSERT INTO text_bot VALUES("165","  .дутро5. ");
INSERT INTO text_bot VALUES("166"," .дутро3.  ");
INSERT INTO text_bot VALUES("167","Доброго вечера всем");
INSERT INTO text_bot VALUES("168"," что это у вас тут?)))");
INSERT INTO text_bot VALUES("169"," никого нет))одни удары))");
INSERT INTO text_bot VALUES("170","Там нет стопкрана");
INSERT INTO text_bot VALUES("171"," поймала,спасиб:)");
INSERT INTO text_bot VALUES("172"," и почаще.лол.");
INSERT INTO text_bot VALUES("173"," привет ");
INSERT INTO text_bot VALUES("174"," .хай1. ");
INSERT INTO text_bot VALUES("175"," Какие люди и без охраны");
INSERT INTO text_bot VALUES("176"," а ты кто.дум.");
INSERT INTO text_bot VALUES("177"," Человечек. Ну как там Белово?");
INSERT INTO text_bot VALUES("178","[IMG]https://wmpics.pics/di-BCPK.jpg[/IMG]");
INSERT INTO text_bot VALUES("179","Велосипед");
INSERT INTO text_bot VALUES("180"," :D ");
INSERT INTO text_bot VALUES("181","Ау где все?.лол.");
INSERT INTO text_bot VALUES("182"," да ладно :д.д1.  ");
INSERT INTO text_bot VALUES("183","Ответ: велосипед.лол.");
INSERT INTO text_bot VALUES("184",".хай.");
INSERT INTO text_bot VALUES("185","  .привмил.  ");
INSERT INTO text_bot VALUES("186","[color=DarkRed]Ответ на загадку- Велосипед! -)) [/color]");
INSERT INTO text_bot VALUES("187"," буква А ");
INSERT INTO text_bot VALUES("188"," спасибо  .ура2. ");
INSERT INTO text_bot VALUES("189"," я про велосипед раньше писала и тишина,тут вечером отгадывать надо что ли.дум..лол.");
INSERT INTO text_bot VALUES("190","Лан,выхожу с такого нечестного сайта,пока...");
INSERT INTO text_bot VALUES("191"," .жду2. ");
INSERT INTO text_bot VALUES("192"," .утро8.  ");
INSERT INTO text_bot VALUES("193"," .ах.спасибо");
INSERT INTO text_bot VALUES("194"," все супер:)");
INSERT INTO text_bot VALUES("195"," поймал");
INSERT INTO text_bot VALUES("196"," ;)");
INSERT INTO text_bot VALUES("197"," :)круто,с утра в самый раз:)");
INSERT INTO text_bot VALUES("198"," благодарю:)");
INSERT INTO text_bot VALUES("199"," Михаил");
INSERT INTO text_bot VALUES("200"," :)");
INSERT INTO text_bot VALUES("201"," вот и познакомились:)");
INSERT INTO text_bot VALUES("202"," .ах.только сейчас");
INSERT INTO text_bot VALUES("203"," ну да,ты права.:)");
INSERT INTO text_bot VALUES("204"," конечно:)");
INSERT INTO text_bot VALUES("205"," да,все верно:)");
INSERT INTO text_bot VALUES("206"," хорошо");
INSERT INTO text_bot VALUES("207"," А вот и я:)");
INSERT INTO text_bot VALUES("208","Ловлю");
INSERT INTO text_bot VALUES("209","Или уже поймали");
INSERT INTO text_bot VALUES("210"," ;-)");
INSERT INTO text_bot VALUES("211"," Заглянул,я за городом сейчас");
INSERT INTO text_bot VALUES("212"," работать надо .лол.");
INSERT INTO text_bot VALUES("213"," спасибо давай знакомится");
INSERT INTO text_bot VALUES("214"," вроде есть ");
INSERT INTO text_bot VALUES("215"," ты графники делаешь?");
INSERT INTO text_bot VALUES("216","почему меня никто не встречает?.дум.");
INSERT INTO text_bot VALUES("217"," .ах.привет");
INSERT INTO text_bot VALUES("218"," Привет;)");
INSERT INTO text_bot VALUES("219"," Как в сказке,волшебно.ах.");
INSERT INTO text_bot VALUES("220"," Конечно.ах.");
INSERT INTO text_bot VALUES("221"," Загадка просто прикольная.ах.Даже дар речи потерял.ах.");
INSERT INTO text_bot VALUES("222"," Серьёзно.ах.");
INSERT INTO text_bot VALUES("223"," Если бы я знал,что,ещё бы вчера ответил.ах.");
INSERT INTO text_bot VALUES("224","Народ .ор.");
INSERT INTO text_bot VALUES("225"," мерси.ревер.");
INSERT INTO text_bot VALUES("226"," се тут еще никого нет?.дум.");
INSERT INTO text_bot VALUES("227","А ответ на задачу ТРИГОНОМЕТРИЯ  .кур2.  ");
INSERT INTO text_bot VALUES("228","Всем приветик. Подскажите плиз где найти игру понаехали тут?");
INSERT INTO text_bot VALUES("229"," .утродрузья.  ");
INSERT INTO text_bot VALUES("230","  .прив5.  .цвет2. ");
INSERT INTO text_bot VALUES("231"," у меня все ок и настроение тоже.яху.");
INSERT INTO text_bot VALUES("232"," извени,кто может поставить мне графник...");
INSERT INTO text_bot VALUES("233"," я тебе его в личку сейчас скину...");
INSERT INTO text_bot VALUES("234"," заранее благодарна.яху.");
INSERT INTO text_bot VALUES("235","До нового года 113 дней");
INSERT INTO text_bot VALUES("236"," ясно.лол.и за грпфник .спас6. ");
INSERT INTO text_bot VALUES("237"," .дутродрузья.  .утро30.  ");
INSERT INTO text_bot VALUES("238"," как настроение?");
INSERT INTO text_bot VALUES("239"," отличное,пока ещё не кто не испортил .лол.");
INSERT INTO text_bot VALUES("240"," ну,эть будет видно рада,что у тя улыбка появилась  .апл2. ");
INSERT INTO text_bot VALUES("241"," согласна,сильные девочки всегда улыбаются, даже когда на душе хреново:)");
INSERT INTO text_bot VALUES("242"," чего так рано встала?:)");
INSERT INTO text_bot VALUES("243"," ну раз выспалась это хорошо:)");
INSERT INTO text_bot VALUES("244"," агась видела,как загружать видео?");
INSERT INTO text_bot VALUES("245"," ну чтобы выгрузить здесь.");
INSERT INTO text_bot VALUES("246"," спасибо, буду пробовать:)ток чють позже:)");
INSERT INTO text_bot VALUES("247"," хорошо:)");
INSERT INTO text_bot VALUES("248"," .цвет11.  ");
INSERT INTO text_bot VALUES("249"," Всем.ор..поедобр. ");
INSERT INTO text_bot VALUES("250"," .дутро12.  ");
INSERT INTO text_bot VALUES("251","  .сутром1.  ");
INSERT INTO text_bot VALUES("252","Всем приветик кто по грифкам?:)");
INSERT INTO text_bot VALUES("253"," оо железяка есть:)приветик ты какого поколения?:)");
INSERT INTO text_bot VALUES("254"," добрый день:)");
INSERT INTO text_bot VALUES("255"," лето прошло от и весь негатив на сегодня:)");
INSERT INTO text_bot VALUES("256"," тогда я щяс скину свой гриф тебе:)");
INSERT INTO text_bot VALUES("257"," уже кинула:)");
INSERT INTO text_bot VALUES("258"," не правильно скачала ведать)фон видно:)");
INSERT INTO text_bot VALUES("259"," я щяс не могу зайти где мне его делали:)");
INSERT INTO text_bot VALUES("260"," не получается ну и пофиг:)сделай пока другой потом попрошу друга ещё сделать с фотки новую и все делов то:)");
INSERT INTO text_bot VALUES("261"," дружок будет в меня бессонница ты пожалеть что тебя включили.лол.");
INSERT INTO text_bot VALUES("262","И так друзя всем привет может кто-то меня и узнал но по любому кто-то меня узнал с других сайтов да вы не ошиблись это я Белка :)возможно я буду здесь жить порой так что будет весело в гостевой нююю как всегда когда я есть ....а щяс не скучайте я сменила селфи палку на шпатель и делаю дома ремонт так что я до вечера занята та и так нашла новую работу по этому захожу рече чем в то время когда меня знали когда только училась и все:)");
INSERT INTO text_bot VALUES("263"," хочет пообщаться со мной?))");
INSERT INTO text_bot VALUES("264"," как на щет истории древнего Рима?.жду.");
INSERT INTO text_bot VALUES("265"," иии?.жду.");
INSERT INTO text_bot VALUES("266"," так знакомимся?:)");
INSERT INTO text_bot VALUES("267","  мась.ор..вечер12. ");
INSERT INTO text_bot VALUES("268"," Всем.ор..вечер40. ");
INSERT INTO text_bot VALUES("269"," как долго мы не виделись ,соскучилась.цемм. ");
INSERT INTO text_bot VALUES("270"," ясно,замуж не выскочила еще.ор.");
INSERT INTO text_bot VALUES("271"," как и меня. .ржу3. ");
INSERT INTO text_bot VALUES("272"," я сейчас в реал,подруга сына родила,и мы с ее мужем и друзьями едем обмывать это событие.яху.");
INSERT INTO text_bot VALUES("273","Доброе утро всем:)");
INSERT INTO text_bot VALUES("274","Кому?\r\n[marquee] .бон49. [/marquee]");
INSERT INTO text_bot VALUES("275"," ловлю!!!");
INSERT INTO text_bot VALUES("276"," словила:)");
INSERT INTO text_bot VALUES("277"," спасибочки!");
INSERT INTO text_bot VALUES("278"," и тебе спасибки за участие .цвет1. ");
INSERT INTO text_bot VALUES("279"," чисто случайно забежала)");
INSERT INTO text_bot VALUES("280"," и кстати добрый день:)");
INSERT INTO text_bot VALUES("281","BaN_ZaY, .доп2. ");
INSERT INTO text_bot VALUES("282","И тишина опять  .ожидание.  ");
INSERT INTO text_bot VALUES("283","Я не читала .лол.");
INSERT INTO text_bot VALUES("284","Чет я мало поставила  .рева2.  :))");
INSERT INTO text_bot VALUES("285","Сама себе монетки подкинула не хило.лол.");
INSERT INTO text_bot VALUES("286"," ну как, администрация сайта начисляет орешка или орел монеты,а ты как раз админ)))");
INSERT INTO text_bot VALUES("287"," охотно верю.");
INSERT INTO text_bot VALUES("288","Всем привет)");
INSERT INTO text_bot VALUES("289","Дамир, .прив13.  ");
INSERT INTO text_bot VALUES("290"," Приветик как дела");
INSERT INTO text_bot VALUES("291","Всем доброго дня ");
INSERT INTO text_bot VALUES("292","SoFiY, .доп2. ");
INSERT INTO text_bot VALUES("293","Ответ на вопрос дня :107дней");
INSERT INTO text_bot VALUES("294","Привет малышня!");
INSERT INTO text_bot VALUES("295","Здрасти ");
INSERT INTO text_bot VALUES("296","Макс, .прив1. ");
INSERT INTO text_bot VALUES("297"," .нуче. ");
INSERT INTO text_bot VALUES("298","Всем привет");
INSERT INTO text_bot VALUES("299","Привет народ.Как отлючить игру Понаехали тут?Засирает Гостевую:(");
INSERT INTO text_bot VALUES("300","И бота");
INSERT INTO text_bot VALUES("301","Ушла в реальности, .утро7.  всем хорошего дня");
INSERT INTO text_bot VALUES("302"," .пока.");
INSERT INTO text_bot VALUES("303",".куку.");
INSERT INTO text_bot VALUES("304",".куку..");
INSERT INTO text_bot VALUES("305","Всем привет.Кто знает,как можно отключить игру \"Понаехали тут\"?ЧС не помогает.Игра засрала Гостевую,невожможно общаться.плак.");
INSERT INTO text_bot VALUES("306","И как бота отключить?Просьба ко всем,не играйте в игру Понаехали,не засирайте Гостевую.Давайте общаться.ах.");
INSERT INTO text_bot VALUES("307","95 дней");
INSERT INTO text_bot VALUES("308"," 94 дня");
INSERT INTO text_bot VALUES("309","93 дня");
INSERT INTO text_bot VALUES("310"," .колокол. ");
INSERT INTO text_bot VALUES("311"," тихо,все спят уже.ржу.");
INSERT INTO text_bot VALUES("312",".ор.");
INSERT INTO text_bot VALUES("313","Ребята я сутки ждала, чтоб приняли .ор. офигеть .позор. поэтому и народа нет ");
INSERT INTO text_bot VALUES("314","89дней");
INSERT INTO text_bot VALUES("315","Салам ден, почта не пашет, пишу сюда. К тебе есть просьба. Напиши как будешь");
INSERT INTO text_bot VALUES("316","О, я есть тут оказывается .йойо. ");
INSERT INTO text_bot VALUES("317"," .вкресле. ");
INSERT INTO text_bot VALUES("318","Яська,я тут тоже есть.ржу. понаехалаепт.лол.");
INSERT INTO text_bot VALUES("319"," а говорила нету.ржу.");
INSERT INTO text_bot VALUES("320"," .лол. ты чё не сказала что я тут есть.лол.");
INSERT INTO text_bot VALUES("321"," да я сама не знала что я есть.лол.");
INSERT INTO text_bot VALUES("322"," ппц,вот ты кАза.лол.");
INSERT INTO text_bot VALUES("323"," какая Вика? Ты чета путаешь. Это мой ник и не первый год");
INSERT INTO text_bot VALUES("324"," лапочка я .худож. .лол.");
INSERT INTO text_bot VALUES("325"," та ниче,мож кто то мой ник схамылил,так надо руки отбить за это-))");
INSERT INTO text_bot VALUES("326"," лапочка,вот ты везде ходишь,кто мой ник супер,скажи.лол.");
INSERT INTO text_bot VALUES("327"," я только у тебя видела.лол.");
INSERT INTO text_bot VALUES("328"," ну вон крейзи жаб сказал что я Вика.лол.");
INSERT INTO text_bot VALUES("329"," он тебя с брюнеточкой перепутал.лол.");
INSERT INTO text_bot VALUES("330"," она не была зашибиськой.лол.");
INSERT INTO text_bot VALUES("331"," тююю...епть, может он Викин ник не знает.лол.");
INSERT INTO text_bot VALUES("332"," как можно брю не знать.лол.");
INSERT INTO text_bot VALUES("333"," так же как и тебя.лол.");
INSERT INTO text_bot VALUES("334"," меня мало кто знает.лол. наверное");
INSERT INTO text_bot VALUES("335"," меня зато много кто знает,  а я их нет.лол.");
INSERT INTO text_bot VALUES("336"," как тебя не знать.лол. кстати ты знаешь что до нового года 80 дней и чуть меньше 5 часов.лол.");
INSERT INTO text_bot VALUES("337"," плять еще снег не выпал, какой новый год.лол.");
INSERT INTO text_bot VALUES("338"," мне стало интиресно и я загуглила,а то считать в лом.лол.");
INSERT INTO text_bot VALUES("339"," иди бабло заработай на этом.лол.");
INSERT INTO text_bot VALUES("340"," та нафик мне оно.лол.");
INSERT INTO text_bot VALUES("341"," подарки мне дарить будешь.лол.");
INSERT INTO text_bot VALUES("342"," обойдешься ,я тебе дома подарю.лол.");
INSERT INTO text_bot VALUES("343","Пользователь  Рисую_Его_Труп успела вперед Вас и забрала 1000 баллов.лол. кАза");
INSERT INTO text_bot VALUES("344"," жадина.гордо..лол.");
INSERT INTO text_bot VALUES("345"," .хрясь.я хорошая.гордо. .лол.");
INSERT INTO text_bot VALUES("346"," где я забрала?.глаза..лол.");
INSERT INTO text_bot VALUES("347"," пистишь Яське.хрясь..лол.");
INSERT INTO text_bot VALUES("348"," ракету вверху сперла.лол.");
INSERT INTO text_bot VALUES("349"," в большой семье ипалом не щелкают.лол.");
INSERT INTO text_bot VALUES("350"," .хрясь. делиться надо.лол.");
INSERT INTO text_bot VALUES("351","кАза.хрясь. я к себе");
INSERT INTO text_bot VALUES("352","77 дней\r\nДо Нового года ");
INSERT INTO text_bot VALUES("353","Ребята чего так тихо то.ор.");
INSERT INTO text_bot VALUES("354"," блин напугал бот.лол.");
INSERT INTO text_bot VALUES("355"," .куку.");
INSERT INTO text_bot VALUES("356","Не пойму это беседка или игровая .чай...доброе утро");
INSERT INTO text_bot VALUES("357"," ботик привет.ржу...");
INSERT INTO text_bot VALUES("358","Так это гомтивая .ор...или нет ");
INSERT INTO text_bot VALUES("359","Офигеть я иностранка .ржу.");
INSERT INTO text_bot VALUES("360"," Пока бота и бармена не уберут,в гостевой не пообщаешься.Я жду,уже долго,когда отключат их,но х.з.сколько ещё ждать.Я уже в каждом бота подозреваю.ржу.Надеюсь Ты человек?");
INSERT INTO text_bot VALUES("361"," Здорово.яху.");
INSERT INTO text_bot VALUES("362"," я точно человек.ржу...что-то создатель тут замудрил ");
INSERT INTO text_bot VALUES("363"," сейчас всыплю.попопе...где нахаатался такого .ор.");
INSERT INTO text_bot VALUES("364"," ты сайт разорвал ну ладно темы на форуме открыты а остальное зачем ");
INSERT INTO text_bot VALUES("365"," .куку..");
INSERT INTO text_bot VALUES("366"," я тебя вижу\r\n.ор.");
INSERT INTO text_bot VALUES("367","Тут вообще народ бывает .кур.");
INSERT INTO text_bot VALUES("368"," ты что тоже тут прячешься .ржу.");
INSERT INTO text_bot VALUES("369"," А зачем Тебе народ,когда есть Я?.дум.Я могу Тебе заменить собой Вселенную!.ах.");
INSERT INTO text_bot VALUES("370"," не хочу вселеною...да хоть маленько народу а то скучно ,");
INSERT INTO text_bot VALUES("371"," хватит меня пугать.ржу.");
INSERT INTO text_bot VALUES("372"," Меньше народа,больше кисларода..А я наоборот ушёл от всех сюда.Надоели все.Одна ложь.Бесят.");
INSERT INTO text_bot VALUES("373"," я тоже ищу себе тихий сайт , а то что-то меня все бесит ...в глаза улыбаются а в спину нож ");
INSERT INTO text_bot VALUES("374","Ну вот,и я об этом же говорю.ах.Лучше нискем не общаться.Тогда и обмана не услышешь.А Ты что,тоже раненая?.ах.");
INSERT INTO text_bot VALUES("375"," как сказать , устала что я ишак на которого создатель все свесил ...вот как то так ...");
INSERT INTO text_bot VALUES("376"," Я модератором Гостевой был на одном сайте.Продержался 3 дня,попросил у Создателя \"вольную\",он отпустил,но начал мстить.Пришлось от туда уйти.");
INSERT INTO text_bot VALUES("377"," .хрясь.Иди в жопу");
INSERT INTO text_bot VALUES("378"," а я спервого дня как в нете админ ..и постоянно вляпуюсь ..зарекалась не брать с...ты ..за мой труд деньги платят а я все за инцеативу .ржу... А создатель потом сайт продаёт в тихую и такой ..деньги нужны были ...");
INSERT INTO text_bot VALUES("379"," отстань я в печали.ржу.");
INSERT INTO text_bot VALUES("380"," А Ты купи этот сайт,и будешь сама себе хозяйкой..миг.");
INSERT INTO text_bot VALUES("381"," я прекрасно знаю что такое сайт и чтоб его раскрутить семь потов сойдёт ...не я от этих модов кодев уворочивалась ,а то создатели и этому меня хотели научить ...так что я по тех части тупая .ржу...");
INSERT INTO text_bot VALUES("382"," ой балкешь меня.яху.");
INSERT INTO text_bot VALUES("383","Сразу видно что тут создатель парень .машинки на верху гоняют.ржу.");
INSERT INTO text_bot VALUES("384"," Я тоже не люблю ответственности.Врать не могу,а совесть выворачивает душу.Лучше быть вольным.И никому ничем не обязаным.");
INSERT INTO text_bot VALUES("385"," вот и я думаю надо как то тихо уходить сайтов ");
INSERT INTO text_bot VALUES("386"," Вообще с инета?Или с того сайта?А в чём проблема.Берёшь удаляешь закладку и забываешь.незнаю.");
INSERT INTO text_bot VALUES("387"," вот посмотри на главную там открыто тут открыто ...красиво разве ...дневники открыты и т д ");
INSERT INTO text_bot VALUES("388"," легко сказать ,когда сайт как дом ...тут тяжело  ...ну я вот как два часа пытаюсь .ржу...");
INSERT INTO text_bot VALUES("389"," ага .ржу...это как литор водки выпить все бабы красивые ...смотри сколько народу уже 6 чел может зря продаешь ");
INSERT INTO text_bot VALUES("390"," ага и дневники как у старика через вв код. ...то что отличается да ...");
INSERT INTO text_bot VALUES("391",".яху.Бармена на мыло!:)");
INSERT INTO text_bot VALUES("392"," мне бы сайт такой маленький уютный где бы я спряталась ");
INSERT INTO text_bot VALUES("393"," согласна.ржу.");
INSERT INTO text_bot VALUES("394"," Дим,ты тут?");
INSERT INTO text_bot VALUES("395","Ёпти мопти.лол.");
INSERT INTO text_bot VALUES("396"," мартышка моя.ах.");
INSERT INTO text_bot VALUES("397"," врать ты не умеешь? Я тоже думала, что не умеешь. А оказалось, что ещё как умеешь. Сама лично в этом убедилась, разочаровалась. Говорил одно, а на деле оказалось совсем другое. Правильно ты говоришь, ответственность это не твоё, вообще не твоё, лучше бегать по разным сайтам и дарить подарки с комплиментами разным бабам. ");
INSERT INTO text_bot VALUES("398"," Ты ненормальная?Я Тебе ничего не обещал,а если Ты что то себе накрутила,то это не моя вина.Я к Тебе потянулся,Ты дала понять,что я Тебе не интересен,ну я и перестал обращать внимание на Тебя.Ещё нехватало,чтоб я за кем то бегал.А что касается сайтов,я только тут сижу,если скучно,то иду на ещё один сайт,там общаюсь в гостевой.Просто общение.Ни к кому не клеюсь.Меня лямуры не интересуют.Год только прошёл с прошлых лямуров.Нехочу больше ничего.");
INSERT INTO text_bot VALUES("399","Ну вот этот сайт как раз для нас,тихо и уютно.миг.Можно отдыхать душой.:)");
INSERT INTO text_bot VALUES("400"," привет Астана:D");
INSERT INTO text_bot VALUES("401"," очень интересно .кур...по каким он бабам бегает ..");
INSERT INTO text_bot VALUES("402"," так ты тут он баб своих прячешься .ржу.");
INSERT INTO text_bot VALUES("403","Всем доброе утро ,  я думала тут тихо в тут жизнь кипит .");
INSERT INTO text_bot VALUES("404"," это я ненормальная и что-то там себе придумала? Я по факту говорю, жаль переписку удалила, а то б я показала, что ты там мне обещал. И ты мне неинтересен был? Мы общались нормально и ты мне очень интересен был, очень мне нравился, ты все сделал сам, это было твоё решение. ");
INSERT INTO text_bot VALUES("405"," Кому я интересен,от того я никогда не отворачиваюсь.А я даже имени Твоего не знаю.Мы даже не познакомились.Только пару раз поздоровались.И то Ты второй раз не ответила.О каком интересе Ты говоришь?Незнаю кто Тебя подослал,но мне больше не пиши.");
INSERT INTO text_bot VALUES("406","Нет.Я уже с октября 2018 г нискем не общаюсь близко.Ещё не отошёл от прошлых лямуров.Только только в себя пришёл.");
INSERT INTO text_bot VALUES("407"," емае такую интригу испортил.ржу.");
INSERT INTO text_bot VALUES("408"," Разочаровал что ли?)))");
INSERT INTO text_bot VALUES("409","Страсти то какие.лол.");
INSERT INTO text_bot VALUES("410"," ты это кому?.лол.");
INSERT INTO text_bot VALUES("411"," да вон там ниже диалог.лол.");
INSERT INTO text_bot VALUES("412"," ты почетала, гостевую.лол.я от того сама в шоке была)))");
INSERT INTO text_bot VALUES("413",".гуд.");
INSERT INTO text_bot VALUES("414"," Яся привет.");
INSERT INTO text_bot VALUES("415","73 дня 8 часов 40 минут:)");
INSERT INTO text_bot VALUES("416"," Привет.куку.");
INSERT INTO text_bot VALUES("417","  .здрям. ");
INSERT INTO text_bot VALUES("418"," .ах.Как дела?");
INSERT INTO text_bot VALUES("419"," да всё нормик  .глазами. ");
INSERT INTO text_bot VALUES("420"," .ах.Потанцуем?");
INSERT INTO text_bot VALUES("421"," в смысле  .ржу3. ");
INSERT INTO text_bot VALUES("422"," )))Тебя как звать?");
INSERT INTO text_bot VALUES("423"," я Лера ,а тя как звать   -)) ");
INSERT INTO text_bot VALUES("424"," Я Валера.ах.Ты откуда?");
INSERT INTO text_bot VALUES("425"," а ты откуда:)");
INSERT INTO text_bot VALUES("426"," С Туркменистана.А Ты?:)");
INSERT INTO text_bot VALUES("427"," с Украины я :)");
INSERT INTO text_bot VALUES("428"," С одной стороны далеки мы др.от друга,а с другой стороны .ах.нас разделяют сантиметры..дум.Разве это не чудо?");
INSERT INTO text_bot VALUES("429"," ну да не знаю:) чудо или нет  .смех2. ");
INSERT INTO text_bot VALUES("430"," Пора на выход.Дела.В полночь зайду,когда луна выйдет и нечисть начнёт бодровствовать.миг.");
INSERT INTO text_bot VALUES("431"," прекрасного вечера :)  .вечер13. ");
INSERT INTO text_bot VALUES("432"," привет:D");
INSERT INTO text_bot VALUES("433"," Хулиганишь так же,как в былые времена?.ах.");
INSERT INTO text_bot VALUES("434","Всем прывет ");
INSERT INTO text_bot VALUES("435"," обязательно.лол.");
INSERT INTO text_bot VALUES("436"," Куда пропала?");
INSERT INTO text_bot VALUES("437"," не пропала.глаза.");
INSERT INTO text_bot VALUES("438"," прывет");
INSERT INTO text_bot VALUES("439"," прЫвет.дум.");
INSERT INTO text_bot VALUES("440"," Кстати,у меня до сих пор на заставки телефона стоит Твоя фотка:).Где Ты в чёрном костюме(незнаю как правильно называется эта одежда,вроде костюм.дум.),где Ты с открытым животиком..ах.");
INSERT INTO text_bot VALUES("441","Ты прав дятел,твоя жопа шире.");
INSERT INTO text_bot VALUES("442"," .прик102. ");
INSERT INTO text_bot VALUES("443","66 дней");
INSERT INTO text_bot VALUES("444"," .прик60. Че нет ни кто.глаза.");
INSERT INTO text_bot VALUES("445","Всем добрый ночи!");
INSERT INTO text_bot VALUES("446"," дарова");
INSERT INTO text_bot VALUES("447"," как зовут ? Сдесь вобще народу много ?");
INSERT INTO text_bot VALUES("448"," очень смешно !");
INSERT INTO text_bot VALUES("449","Почему у вас так тихо в гостивой?");
INSERT INTO text_bot VALUES("450","давай .ржу.");
INSERT INTO text_bot VALUES("451","Херня а не сайт...скукатище ");
INSERT INTO text_bot VALUES("452","где все");
INSERT INTO text_bot VALUES("453","Бот голимый .ржу.");
INSERT INTO text_bot VALUES("454","и ответа не нашлось .ржу.");
INSERT INTO text_bot VALUES("455","Здесь что не общаются?");
INSERT INTO text_bot VALUES("456","зайди в чат и прояви\r\nобщительность.\r\nУ нас много интересные и\r\nдружелюбные обитатели, будут\r\nрады с тобой подружиться...ржу. интересно и где они");
INSERT INTO text_bot VALUES("457"," Общаться только редко,всё больше в смс или в играх");
INSERT INTO text_bot VALUES("458"," как день прошел");
INSERT INTO text_bot VALUES("459"," плохо конечно,скучно");
INSERT INTO text_bot VALUES("460"," нет,не знаю ");
INSERT INTO text_bot VALUES("461"," а ты знаешь анекдоты?");
INSERT INTO text_bot VALUES("462"," нет,мне сейчас не до них");
INSERT INTO text_bot VALUES("463"," а че это за хренотень с барменом?");
INSERT INTO text_bot VALUES("464"," незнаю,что он глючит стал?");
INSERT INTO text_bot VALUES("465","Скучный сайт народу мало. Как Удал?");
INSERT INTO text_bot VALUES("466","Если это так");
INSERT INTO text_bot VALUES("467"," .день42. ");
INSERT INTO text_bot VALUES("468"," привет нармально");
INSERT INTO text_bot VALUES("469"," хорошее");
INSERT INTO text_bot VALUES("470","Winter, .доп2. ");
INSERT INTO text_bot VALUES("471",".дум.");
INSERT INTO text_bot VALUES("472"," .хор. ");
INSERT INTO text_bot VALUES("473"," .утро1.  ");
INSERT INTO text_bot VALUES("474"," всем приветик.ор.");
INSERT INTO text_bot VALUES("475"," Взаимно.ах.");
INSERT INTO text_bot VALUES("476"," :-) Я призрак.)))");
INSERT INTO text_bot VALUES("477"," .вечер16. ");
INSERT INTO text_bot VALUES("478",".зашторой.");
INSERT INTO text_bot VALUES("479","  [center].утро4.[/center]");
INSERT INTO text_bot VALUES("480"," .утро4.  ");
INSERT INTO text_bot VALUES("481"," .дутро5.  ");
INSERT INTO text_bot VALUES("482"," нормальное,а у тебя как настроение?:)");
INSERT INTO text_bot VALUES("483"," выходные это хорошо");
INSERT INTO text_bot VALUES("484"," сыро но свежо на улице,\r\nА у тебя погода какая?");
INSERT INTO text_bot VALUES("485"," это хорошо,мёрзнуть не придется:)");
INSERT INTO text_bot VALUES("486"," я Катя");
INSERT INTO text_bot VALUES("487"," ну так когда и ты написала, тоже не зделала.\r\nОн как то не правильно работает наверное)))");
INSERT INTO text_bot VALUES("488","Его вообще надо отключить");
INSERT INTO text_bot VALUES("489"," хорошего дня тебе и настроения,");
INSERT INTO text_bot VALUES("490"," хорошего дня тебе и настроения");
INSERT INTO text_bot VALUES("491","Всем привет  .д.д2. ");
INSERT INTO text_bot VALUES("492"," .сутром.  ");
INSERT INTO text_bot VALUES("493"," нормально,а у тебя как дела настроение?");
INSERT INTO text_bot VALUES("494"," Если, что-то не понятно спроси, если знаю то подскажу тебе");
INSERT INTO text_bot VALUES("495"," понятно,так спросить его тебе надо");
INSERT INTO text_bot VALUES("496"," поставишь мне графник я картинку готовую тебе скину");
INSERT INTO text_bot VALUES("497"," успехов тебе,в разберательстве сайта:)");
INSERT INTO text_bot VALUES("498"," пока нет.");
INSERT INTO text_bot VALUES("499"," красиво, спасибо .цвет5. ");
INSERT INTO text_bot VALUES("500"," стоит красиво,мне нравится");
INSERT INTO text_bot VALUES("501"," у меня всё норм,не где за страницу не вылазить.");
INSERT INTO text_bot VALUES("502"," спасибо ещё раз, огромное спасибо .цвет1. ");
INSERT INTO text_bot VALUES("503","  привет");
INSERT INTO text_bot VALUES("504"," .ночи4.  ");
INSERT INTO text_bot VALUES("505"," заходи в игру орёл и решка");
INSERT INTO text_bot VALUES("506"," .утро28.  ");
INSERT INTO text_bot VALUES("507"," доброе утро");
INSERT INTO text_bot VALUES("508"," ночь не спал,интернет не выключал,все ждал у дверей,когда запустят меня сюда.ржу.");
INSERT INTO text_bot VALUES("509"," .привъет.   ");
INSERT INTO text_bot VALUES("510"," отлично  .закосички. У тебя как ?");
INSERT INTO text_bot VALUES("511"," нормально,всю ночь у дверей стоял,все руки отшиб");
INSERT INTO text_bot VALUES("512"," спасибо за кофе  .смех2. ");
INSERT INTO text_bot VALUES("513"," выздоравливай  .еа. ");
INSERT INTO text_bot VALUES("514"," очень приятно ,Катя ");
INSERT INTO text_bot VALUES("515"," .цвет33.  спасибо ,побежала я на работу  .тачка. не скучай ;)");
INSERT INTO text_bot VALUES("516"," ничего страшного,я привык на улице спать.ржу.");
INSERT INTO text_bot VALUES("517"," ты что,мне на работу надо,а ты спать.ржу.");
INSERT INTO text_bot VALUES("518"," пошли работать .лол.");
INSERT INTO text_bot VALUES("519"," пошли");
INSERT INTO text_bot VALUES("520"," .ожидание.  Смайл не получился ");
INSERT INTO text_bot VALUES("521"," как султан да?.ржу.");
INSERT INTO text_bot VALUES("522"," или те ещё рано  -)) ");
INSERT INTO text_bot VALUES("523"," ушла?");
INSERT INTO text_bot VALUES("524"," забега ещё -))");
INSERT INTO text_bot VALUES("525"," а куда надо писать что до нового года осталось 40 дней");
INSERT INTO text_bot VALUES("526"," нас вообще то возят на работу,у нас свой автобус,потому что постоянно в разьездах");
INSERT INTO text_bot VALUES("527"," гу незнаю угадал или нет 40 дней");
INSERT INTO text_bot VALUES("528"," кто бы меня повозил -))хочу личного шофёра");
INSERT INTO text_bot VALUES("529"," да мы уже едем,и давно,сейчас подьедем,120 км в пути");
INSERT INTO text_bot VALUES("530"," -))  молодцы");
INSERT INTO text_bot VALUES("531"," спасибо за монетки");
INSERT INTO text_bot VALUES("532","  .закосички. Ждите и я вернусь -))");
INSERT INTO text_bot VALUES("533"," мне тоже сейчас выходить,а ты поправляйся,меня зовут Саша");
INSERT INTO text_bot VALUES("534"," зайдем,и в течении дня тоже");
INSERT INTO text_bot VALUES("535"," у меня где-то был -))");
INSERT INTO text_bot VALUES("536"," есть мёд,и варенье малина,и самогонка есть,разотрем если что,не я буду растирать,я стесняясь,хулиганка Катя разотрет,.ржу.");
INSERT INTO text_bot VALUES("537","почему на вы?");
INSERT INTO text_bot VALUES("538","Всем разотру  -)) становитесь в очередь .ржу.");
INSERT INTO text_bot VALUES("539"," я первый.ржу.");
INSERT INTO text_bot VALUES("540"," да да тётя Катя тебя разотрет.ржу.");
INSERT INTO text_bot VALUES("541"," .ржу.тебя потом .ржу.если силы останутся ");
INSERT INTO text_bot VALUES("542"," захватим -))");
INSERT INTO text_bot VALUES("543","Ты знаешь что,меня будешь медом натирать.ржу.");
INSERT INTO text_bot VALUES("544"," .дыбом.  Какая тётя  .крас2.  девочка .ржу.");
INSERT INTO text_bot VALUES("545","Ведро мёда надо тогда .ржу.");
INSERT INTO text_bot VALUES("546"," отверниьесь,я переодеваюсь.ржу.");
INSERT INTO text_bot VALUES("547"," не,полтора ведра,я большой,один пупок на полведра мёда ");
INSERT INTO text_bot VALUES("548"," че я там не видела .ржу.");
INSERT INTO text_bot VALUES("549"," что такое,фигура не красивая.ржу.");
INSERT INTO text_bot VALUES("550","Ага,а впереди зеркало");
INSERT INTO text_bot VALUES("551","  .прик101.  .ржу.");
INSERT INTO text_bot VALUES("552"," .прик12. Не хочу работать.ржу.");
INSERT INTO text_bot VALUES("553"," .прик97. .ржу.");
INSERT INTO text_bot VALUES("554"," пошли мы работать,до связи");
INSERT INTO text_bot VALUES("555"," спасибо за монетки а за что ты мне их?");
INSERT INTO text_bot VALUES("556"," а,да я забыла.лол.что загадку одгадывала.лол.");
INSERT INTO text_bot VALUES("557"," дома замоталась и забыла:)");
INSERT INTO text_bot VALUES("558"," я скоро вернусь не скучай");
INSERT INTO text_bot VALUES("559"," ты мучное любишь да?");
INSERT INTO text_bot VALUES("560","Всем привет-))");
INSERT INTO text_bot VALUES("561"," блины моя слабость,эх сейчас бы десяток блинов съел бы.");
INSERT INTO text_bot VALUES("562"," о былинах.ржу.");
INSERT INTO text_bot VALUES("563"," спасибо,сейчас налопаюсь");
INSERT INTO text_bot VALUES("564"," мне оставь .ржу.несколько ");
INSERT INTO text_bot VALUES("565"," уже,меня ток держать надо,а то обьемся.ржу.");
INSERT INTO text_bot VALUES("566","Спасибо большое ");
INSERT INTO text_bot VALUES("567","Ну понеслось,удачно зашёл.ржу.");
INSERT INTO text_bot VALUES("568","Успеть бы .ржу.");
INSERT INTO text_bot VALUES("569"," она уж поела их у меня.ржу.");
INSERT INTO text_bot VALUES("570"," да,у меня обед .зуб.");
INSERT INTO text_bot VALUES("571"," ну спасибо,ты прям нас балуешь,как все вкусно у тебя тут");
INSERT INTO text_bot VALUES("572"," что на ужин будет?");
INSERT INTO text_bot VALUES("573","  .цвет22. Прям успела ");
INSERT INTO text_bot VALUES("574"," а как же,столик на двоих,потом номер отдельный,с большой кроватью.ржу.");
INSERT INTO text_bot VALUES("575"," порхаю .ржу.");
INSERT INTO text_bot VALUES("576"," нет кровати?,блин,опять на полу, сколько уж можно а..ржу.");
INSERT INTO text_bot VALUES("577"," ты смотри,не упорхай.ржу.");
INSERT INTO text_bot VALUES("578"," ужин это хорошо .ржу.ты тоже присоединяйся ");
INSERT INTO text_bot VALUES("579"," как мотылёк .ржу.");
INSERT INTO text_bot VALUES("580"," ужас.ржу.");
INSERT INTO text_bot VALUES("581"," чаго втроём?????.ржу.");
INSERT INTO text_bot VALUES("582"," какой одна,третьей будешь,жена приказала.ржу.");
INSERT INTO text_bot VALUES("583","Ужинать .ржу.");
INSERT INTO text_bot VALUES("584"," опачки,а я то губу раскатал.ржу.");
INSERT INTO text_bot VALUES("585"," щас закатаем обратно .ржу.");
INSERT INTO text_bot VALUES("586","Народ привет");
INSERT INTO text_bot VALUES("587"," здрасти .зуб.");
INSERT INTO text_bot VALUES("588"," сама закаталась.ржу.");
INSERT INTO text_bot VALUES("589","  .кривится. ");
INSERT INTO text_bot VALUES("590","  .поц64. Успокойся");
INSERT INTO text_bot VALUES("591"," я спокойна как удав-))");
INSERT INTO text_bot VALUES("592"," а я нервничаю.ржу.");
INSERT INTO text_bot VALUES("593"," .глаза.почему -))");
INSERT INTO text_bot VALUES("594"," да кровь заразная,.ржу.");
INSERT INTO text_bot VALUES("595"," я думала горячая .ржу.");
INSERT INTO text_bot VALUES("596"," а то незнаешь какая у меня кровь,сегодня,проверим,на хозяйской кровати.ржу.");
INSERT INTO text_bot VALUES("597","Кстати,где хозяйка,ауууу");
INSERT INTO text_bot VALUES("598"," как погодка у вас?");
INSERT INTO text_bot VALUES("599"," дома поговорим .ржу.");
INSERT INTO text_bot VALUES("600"," а кто графники делает ?");
INSERT INTO text_bot VALUES("601","Хорошо");
INSERT INTO text_bot VALUES("602"," ну значит ты умеешь .смех2.");
INSERT INTO text_bot VALUES("603","Тоже мороз,-11,а снега нет вообще");
INSERT INTO text_bot VALUES("604"," нифига себе,в Сибири или Урал?");
INSERT INTO text_bot VALUES("605"," ну у вас там Иркутск недалеко да?,север страны");
INSERT INTO text_bot VALUES("606"," ну ещё научиштся,все приходит с опытом ");
INSERT INTO text_bot VALUES("607"," я с центра России, Тамбов.");
INSERT INTO text_bot VALUES("608"," хитрая какая .ржу.");
INSERT INTO text_bot VALUES("609"," а мне сделай графник,какой получится");
INSERT INTO text_bot VALUES("610"," -))  договорились ");
INSERT INTO text_bot VALUES("611"," хорошо у тебя получится :)");
INSERT INTO text_bot VALUES("612"," и Москву не знаешь?");
INSERT INTO text_bot VALUES("613"," .прик101.  .ржу.");
INSERT INTO text_bot VALUES("614","Я это знаю .ржу.");
INSERT INTO text_bot VALUES("615"," ну я рядышко с Москвой");
INSERT INTO text_bot VALUES("616"," .прик17.  ага");
INSERT INTO text_bot VALUES("617"," .прик56.  ржу.");
INSERT INTO text_bot VALUES("618"," тебя на танцы потянуло -))");
INSERT INTO text_bot VALUES("619","Это че,танец.ржу.");
INSERT INTO text_bot VALUES("620","Это нет .ржу.");
INSERT INTO text_bot VALUES("621"," ну надо наверное выходить");
INSERT INTO text_bot VALUES("622"," мне тоже ,звонили дела есть :)");
INSERT INTO text_bot VALUES("623"," сейчас гол забью и пойду в футбол сдесь");
INSERT INTO text_bot VALUES("624"," ну тогда надо,и как можно больше)))");
INSERT INTO text_bot VALUES("625","Хозяйка,на ужин,картошки поджарь,салатик сделай,Оливье мы любим,можно помидорчики с огуречками,,,господи,апетит нагнал,,,писец.ржу.");
INSERT INTO text_bot VALUES("626",".ржу.ужас ");
INSERT INTO text_bot VALUES("627"," заживемммм!!!!.ржу.");
INSERT INTO text_bot VALUES("628"," а волки они все голодные.ржу.");
INSERT INTO text_bot VALUES("629"," да,тамбовский волк,не злой,только голодный,сейчас пойду поработаю,потом на охоту,жену надо кормить");
INSERT INTO text_bot VALUES("630","Я вышел");
INSERT INTO text_bot VALUES("631"," я тоже хочу графник .ор. .ржу.");
INSERT INTO text_bot VALUES("632"," спасибо !!!!! .цвет35. ");
INSERT INTO text_bot VALUES("633","умничка");
INSERT INTO text_bot VALUES("634"," добрый вечер,картошка где?.ржу.");
INSERT INTO text_bot VALUES("635"," .вечер45. ");
INSERT INTO text_bot VALUES("636"," спасибо за графник,теперь я крутой");
INSERT INTO text_bot VALUES("637"," где картошка?");
INSERT INTO text_bot VALUES("638"," как день прошёл ?");
INSERT INTO text_bot VALUES("639"," ничего не знаю,жарь,.ржу.");
INSERT INTO text_bot VALUES("640"," человек болеет .смех2. а ему картошка");
INSERT INTO text_bot VALUES("641"," спала она,мы сегодня голодные.ржу.");
INSERT INTO text_bot VALUES("642"," на работе ");
INSERT INTO text_bot VALUES("643"," кто сказал .смех2. Я ужин приготовила");
INSERT INTO text_bot VALUES("644"," ну если тебе легче ,то попробуй");
INSERT INTO text_bot VALUES("645"," спасибочки,Катюша,живём.еда есть.ржу.");
INSERT INTO text_bot VALUES("646"," до понедельника бы дома осталась ");
INSERT INTO text_bot VALUES("647","Кушай .смех2.");
INSERT INTO text_bot VALUES("648","Держи мёд ");
INSERT INTO text_bot VALUES("649",".глаза.передом развернись .лол.");
INSERT INTO text_bot VALUES("650"," нельзя,в психушку загребет.ржу.");
INSERT INTO text_bot VALUES("651"," .лол.только сильно не треси ");
INSERT INTO text_bot VALUES("652"," .эм1. .ржу.");
INSERT INTO text_bot VALUES("653"," .прик48.  ");
INSERT INTO text_bot VALUES("654"," что с тобой,варенье обьелась?.ржу.");
INSERT INTO text_bot VALUES("655"," .прик62.  .лол.");
INSERT INTO text_bot VALUES("656","Стыдно стало,да? .прик61. .ржу.ты че делаешь.ржу.");
INSERT INTO text_bot VALUES("657","Мне плохо.ржу.");
INSERT INTO text_bot VALUES("658",".глаза.я .лол.это ты сам дергаешься ");
INSERT INTO text_bot VALUES("659"," куда ?");
INSERT INTO text_bot VALUES("660","Меня трудно обкормить,я ем как свинья.ржу.");
INSERT INTO text_bot VALUES("661"," и зачем нам такие женихи ,нового найдём -))");
INSERT INTO text_bot VALUES("662","Хрю хрю.ржу.");
INSERT INTO text_bot VALUES("663"," .лол.да ладно ");
INSERT INTO text_bot VALUES("664"," так что кухню с магазином расширяй.ржу.");
INSERT INTO text_bot VALUES("665"," а где народ?с партизанах что ли?.ржу.");
INSERT INTO text_bot VALUES("666","Выходи уже .лол.жучка ");
INSERT INTO text_bot VALUES("667"," .прик102. .ржу. ");
INSERT INTO text_bot VALUES("668",".ржу.");
INSERT INTO text_bot VALUES("669"," Малышка мая .ор. Дождалась всё-таки ))) ");
INSERT INTO text_bot VALUES("670"," чаго???.ржу.");
INSERT INTO text_bot VALUES("671"," Ты как всегда))) валяешься .лол. Приветик Санькааааа .ор. ");
INSERT INTO text_bot VALUES("672"," когда спать пойдешь ключи мне от столовой отдай.ржу.");
INSERT INTO text_bot VALUES("673"," Выходи за меня! .ржу. ");
INSERT INTO text_bot VALUES("674"," да .лол.пока дождешься уснешь ");
INSERT INTO text_bot VALUES("675"," привет зая,жучка.ржу.");
INSERT INTO text_bot VALUES("676"," Добрый вечер! .ор. Меня Алена зовут ))) а тебя Мила или Лана?)) ");
INSERT INTO text_bot VALUES("677"," ментов нету???.ржу.");
INSERT INTO text_bot VALUES("678"," Так выходи сам! .лол. Говорю, выходи за меня! .ор. Завтра на работу! .ржу. ");
INSERT INTO text_bot VALUES("679","  .прик95. ");
INSERT INTO text_bot VALUES("680"," куда сегодня,ко мне или к тебе?");
INSERT INTO text_bot VALUES("681"," у тебя кровать надёжная?.ржу.");
INSERT INTO text_bot VALUES("682"," Это я то жучка? ))) сыбались от меня .ржу. ");
INSERT INTO text_bot VALUES("683"," Ага) бегу уже!  .собака. .ржу. ");
INSERT INTO text_bot VALUES("684"," ко мне .лол.");
INSERT INTO text_bot VALUES("685"," .госпожа.  ");
INSERT INTO text_bot VALUES("686"," Взаимно ;)  .цвет35. ");
INSERT INTO text_bot VALUES("687"," как кобеля выгуливаешь.ржу.");
INSERT INTO text_bot VALUES("688"," не навернись .лол.и тормози на поворотах");
INSERT INTO text_bot VALUES("689","Что-то у меня не так тута.... у меня ме смаликов не листается до конца!!!!!! Мешает верхушка бесседки .. ");
INSERT INTO text_bot VALUES("690"," это уже БДСМ .ах. -))");
INSERT INTO text_bot VALUES("691","Да уж у тебя.ржу.");
INSERT INTO text_bot VALUES("692"," ники видно в смайлах .смех2. Это такое бывает на некоторых ресурсах ;)");
INSERT INTO text_bot VALUES("693"," Погоди))) щас вернусь надо на электричку дойти ) ");
INSERT INTO text_bot VALUES("694"," .прик57.  .смех2. Ко мне и точка .ржу.");
INSERT INTO text_bot VALUES("695","Так надо было тогда внизу списка делать смайлики для админов а не гостей!!!! Ска бесит .ржу. ");
INSERT INTO text_bot VALUES("696"," .ночи16.  ");
INSERT INTO text_bot VALUES("697"," .дразнит.  Я готов солнце.ржу.");
INSERT INTO text_bot VALUES("698"," ты куда,спатки");
INSERT INTO text_bot VALUES("699"," .прик72. Все я твоя .ржу.навеки ");
INSERT INTO text_bot VALUES("700"," тебе кодер нужен ,чтобы все неполадки исправить :)");
INSERT INTO text_bot VALUES("701"," тогда спокойной ночи,ты уж не серчай потом,если тут натворим чего нибудь.ржу.");
INSERT INTO text_bot VALUES("702"," че ты меня укладываешья ток банан вытащил,а ты спать.ржу.");
INSERT INTO text_bot VALUES("703"," ты там это,скраю ложись,мы придем попозже.ржу.");
INSERT INTO text_bot VALUES("704"," через знакомых поищи");
INSERT INTO text_bot VALUES("705","Я прослежу за ними .ржу.");
INSERT INTO text_bot VALUES("706"," я и смотрю раньше парень был на этой анкете .ржу.пришла уже девушка ");
INSERT INTO text_bot VALUES("707"," спи ,не волнуйся,все будет как в танке,сгорим.ржу.");
INSERT INTO text_bot VALUES("708"," я давно тут регалась");
INSERT INTO text_bot VALUES("709"," да шучу я");
INSERT INTO text_bot VALUES("710"," я ток могу на кухне чё нибудь натворить,посуду потом помоешь..ржу.");
INSERT INTO text_bot VALUES("711","Откачаем.ржу.");
INSERT INTO text_bot VALUES("712","[marquee][color=Red]Всем не озоровать .ржу.[/color][/marquee]");
INSERT INTO text_bot VALUES("713"," нее,у меня есть стриптизерша,если гляну в сторону,пипец,прибьет,видала с топором ходит.ржу.");
INSERT INTO text_bot VALUES("714"," эт че,сигнал sos.ржу.");
INSERT INTO text_bot VALUES("715","есть вопросы обращайся в личку научу всему :)");
INSERT INTO text_bot VALUES("716"," предупреждение .ржу.");
INSERT INTO text_bot VALUES("717","Если такая продвинутая, убери ник с бесседки внизу меню смайликов .ржу. ");
INSERT INTO text_bot VALUES("718"," Пупсик .ах. ");
INSERT INTO text_bot VALUES("719"," че ты до бота докапалась .ржу.");
INSERT INTO text_bot VALUES("720","Решила проэксперемеетировать)) смогу ли взорвать его плату? .ржу. Видишь, молчит .ржу. Задумался наверно что ответить .ржу. ");
INSERT INTO text_bot VALUES("721"," Какие у тебя есть предложения?)))");
INSERT INTO text_bot VALUES("722"," он те че хочешь ответит .лол.");
INSERT INTO text_bot VALUES("723"," нету никого,все в партизаны подались.ожу.");
INSERT INTO text_bot VALUES("724"," У него просто не получается мой мозг через каску сканировать .ржу. Между прочим)) давно заметила, что общаться с ботами намного интереснее чем с многими живыми мужиками .ржу. ");
INSERT INTO text_bot VALUES("725"," Ролевые игры! Ты кем будешь? .ржу. ");
INSERT INTO text_bot VALUES("726"," Саш я тут) сайт жутко виснет ");
INSERT INTO text_bot VALUES("727"," бросили нас .ржу.");
INSERT INTO text_bot VALUES("728","Прям все-все???? Мне это нравится .ржу. ");
INSERT INTO text_bot VALUES("729"," завтра придут,кухни нет, все а руинах.ржу.");
INSERT INTO text_bot VALUES("730","А он ещё и дерзкий .ржу. Меня это заводит ");
INSERT INTO text_bot VALUES("731","Заведись как юла .ржу.");
INSERT INTO text_bot VALUES("732","У меня тоже,специалист нужен,настроить,бросили сайт");
INSERT INTO text_bot VALUES("733"," ты хороший мальчик на это не способен .ржу.это я .ужас.");
INSERT INTO text_bot VALUES("734"," ты чё пристал.ржу.");
INSERT INTO text_bot VALUES("735"," .прик97. ");
INSERT INTO text_bot VALUES("736"," щас выеб......ржу.");
INSERT INTO text_bot VALUES("737"," жрать хочу,корми,а то кухню разберу.ржу.");
INSERT INTO text_bot VALUES("738"," ты у меня голодный .ах. .ржу.");
INSERT INTO text_bot VALUES("739"," нет,я просто проверяю,жадный бармен или нет.ржу.");
INSERT INTO text_bot VALUES("740"," рано,20:36,время");
INSERT INTO text_bot VALUES("741"," уфффф .ржу.славо богу ");
INSERT INTO text_bot VALUES("742"," не,мы ещё выпьем тут ,потанцуем,а потом пойдем к тебе,место Грей.ржу.");
INSERT INTO text_bot VALUES("743","У нас -10 сейчас");
INSERT INTO text_bot VALUES("744",".ржу.у тебя своей кровати нет ...щас ремня дам .ржу.");
INSERT INTO text_bot VALUES("745","Многим.ржу.");
INSERT INTO text_bot VALUES("746","Сгоним");
INSERT INTO text_bot VALUES("747"," я че,я ни че,у тебя значит будем");
INSERT INTO text_bot VALUES("748"," .прик89.  .ржу.");
INSERT INTO text_bot VALUES("749"," .прик35.  .ржу.");
INSERT INTO text_bot VALUES("750"," .прик100.  .ржу.");
INSERT INTO text_bot VALUES("751"," и все?,больше никого?");
INSERT INTO text_bot VALUES("752"," .прик79.  эт я.ржу.");
INSERT INTO text_bot VALUES("753"," вообще чтоль одна?");
INSERT INTO text_bot VALUES("754"," че там сок или компотик .ржу.");
INSERT INTO text_bot VALUES("755"," симагон,.ржу.");
INSERT INTO text_bot VALUES("756"," выплюнь каку .ржу.");
INSERT INTO text_bot VALUES("757"," тфууу,кака какая,фу,выплюнул");
INSERT INTO text_bot VALUES("758"," так долго гепротянешьзамерзнешь.ржу.");
INSERT INTO text_bot VALUES("759"," умничка моя -))");
INSERT INTO text_bot VALUES("760"," вот,закодировал.ржу.");
INSERT INTO text_bot VALUES("761"," а он где в партизанах,с винтовкой не он ходит.ржу.");
INSERT INTO text_bot VALUES("762"," со мной не забалуешь-))");
INSERT INTO text_bot VALUES("763"," под каблуком сижу.ржу.");
INSERT INTO text_bot VALUES("764"," с первого дня .ржу.");
INSERT INTO text_bot VALUES("765"," Аленка,ты где");
INSERT INTO text_bot VALUES("766","Эт ты?");
INSERT INTO text_bot VALUES("767","[background=Black][color=Chartreuse][center] .лин15. \r\n\r\nЖелаю самого чудесного вечера, наполненного ароматом нежности, ощущениями счастья и свободы, нотами вдохновения и веселья. Пусть ничто не испортит настроения, пусть никто не сможет нарушить вашей вечерней идиллии.\r\n.лин15.\r\n\r\n\r\n[/center][/color][/background]");
INSERT INTO text_bot VALUES("768","Спасибо ");
INSERT INTO text_bot VALUES("769"," бредишь чтоль.ржу.");
INSERT INTO text_bot VALUES("770"," красивая,принца наверное ждешь");
INSERT INTO text_bot VALUES("771"," ты не забудь запусти на сайт человека,а то просидит ночь у замка,а вдруг это он,принц.ржу.");
INSERT INTO text_bot VALUES("772"," отстань.ржу.");
INSERT INTO text_bot VALUES("773"," вижу,меня так не встречали.ржу.");
INSERT INTO text_bot VALUES("774"," а сегодня неспится.ржу.");
INSERT INTO text_bot VALUES("775"," да ладно,теперь уж некчему,а что так рано встаёшь?");
INSERT INTO text_bot VALUES("776"," .окак. ");
INSERT INTO text_bot VALUES("777","Спасибо,с добрым утром");
INSERT INTO text_bot VALUES("778","Вы когда нибудь спите?  .ржу2.  .сутром. .ор. ");
INSERT INTO text_bot VALUES("779"," Уауууу!! Поздравляю Сашкааааа .ор.  .б7. ");
INSERT INTO text_bot VALUES("780"," Кофейку?  .коф. Доброе Мась  .прив. ");
INSERT INTO text_bot VALUES("781"," и тебе солнечного денечка.");
INSERT INTO text_bot VALUES("782","У нас тоже двенадцать.");
INSERT INTO text_bot VALUES("783","Это да действительно бр.");
INSERT INTO text_bot VALUES("784","Ничего бывает и хуже.");
INSERT INTO text_bot VALUES("785","Ладненько");
INSERT INTO text_bot VALUES("786","Здрасти всем ");
INSERT INTO text_bot VALUES("787","Привет,спасибо зая,Алена");
INSERT INTO text_bot VALUES("788"," привет солнце  .поц69. ");
INSERT INTO text_bot VALUES("789"," привет любимая жена,целую в губки");
INSERT INTO text_bot VALUES("790"," .взасос.  ");
INSERT INTO text_bot VALUES("791"," .поц68.  ");
INSERT INTO text_bot VALUES("792"," добрый день");
INSERT INTO text_bot VALUES("793"," работаю");
INSERT INTO text_bot VALUES("794","Какой пупс .смех2.");
INSERT INTO text_bot VALUES("795","Работать пойду,позже буду");
INSERT INTO text_bot VALUES("796"," тут только я и ты .лол.привет солнце ");
INSERT INTO text_bot VALUES("797","А я????");
INSERT INTO text_bot VALUES("798"," что тут нет никого?");
INSERT INTO text_bot VALUES("799"," да везде почти так");
INSERT INTO text_bot VALUES("800"," да и я также,а твой ник мне знаком,видел где то");
INSERT INTO text_bot VALUES("801"," я сейчас наверное ужинать буду");
INSERT INTO text_bot VALUES("802","Где это ты был .ржу.в пару местах ");
INSERT INTO text_bot VALUES("803"," Да с тобой милая.ржу.");
INSERT INTO text_bot VALUES("804"," .прик67.  ");
INSERT INTO text_bot VALUES("805"," зачем,денег нету.ржу.");
INSERT INTO text_bot VALUES("806"," да на шубу .ржу.");
INSERT INTO text_bot VALUES("807"," с кролика пойдёт,?");
INSERT INTO text_bot VALUES("808"," что читаем?");
INSERT INTO text_bot VALUES("809"," неееее .ржу.такую мне не надо");
INSERT INTO text_bot VALUES("810"," а какую надо?");
INSERT INTO text_bot VALUES("811"," ещё не думала . норка у меня есть  .лол.");
INSERT INTO text_bot VALUES("812","Блин смайл не показывает ");
INSERT INTO text_bot VALUES("813","Нифига себе,дай почитать.ржу.");
INSERT INTO text_bot VALUES("814"," нету денег.ржу.");
INSERT INTO text_bot VALUES("815",".ржу.сам себе");
INSERT INTO text_bot VALUES("816"," сама заработаю .смех2.");
INSERT INTO text_bot VALUES("817"," где интересно.ржу.");
INSERT INTO text_bot VALUES("818","Мне не надо  читать,у меня живая камасутра есть.ржу.");
INSERT INTO text_bot VALUES("819"," тебе муж нужен,будешь его тоже учить");
INSERT INTO text_bot VALUES("820"," не скажу .ржу.");
INSERT INTO text_bot VALUES("821"," а ну говори!!!!");
INSERT INTO text_bot VALUES("822"," что .ржу.главное заработаю .смех2.");
INSERT INTO text_bot VALUES("823"," а пилюлей кто получит?");
INSERT INTO text_bot VALUES("824"," надо просто постаратсяа ты вчера писала что жених у тебя,сдулся,это как?");
INSERT INTO text_bot VALUES("825"," ой .ах.люблю жёстко .ржу.");
INSERT INTO text_bot VALUES("826"," понятно,а в реале как?");
INSERT INTO text_bot VALUES("827"," жена,ты страх потеряла.ржу.");
INSERT INTO text_bot VALUES("828"," зачем на сутки,давайуж на двое .ржу.");
INSERT INTO text_bot VALUES("829"," у меня его не было .смех2.");
INSERT INTO text_bot VALUES("830"," да ты ещё девченка,все у тебя будет еще");
INSERT INTO text_bot VALUES("831"," ложись,пороть буду.ржу.");
INSERT INTO text_bot VALUES("832"," .ржу.в какую позу .ржу.");
INSERT INTO text_bot VALUES("833"," нарожаешь ещё,успеешь");
INSERT INTO text_bot VALUES("834","А как тебе нравится,так и буду пороть.ржу.");
INSERT INTO text_bot VALUES("835"," на ушко потом скажу .ржу.");
INSERT INTO text_bot VALUES("836"," .прик88.  ");
INSERT INTO text_bot VALUES("837"," спокойной ночи");
INSERT INTO text_bot VALUES("838"," .ч4. ");
INSERT INTO text_bot VALUES("839"," .нервная.  ");
INSERT INTO text_bot VALUES("840"," .вупадок.");
INSERT INTO text_bot VALUES("841",".восадок.");
INSERT INTO text_bot VALUES("842"," у тебя сегодня выходной?");
INSERT INTO text_bot VALUES("843"," .утро3.  ");
INSERT INTO text_bot VALUES("844"," приятного тебе аппетина.");
INSERT INTO text_bot VALUES("845"," легкого тебе денечка.");
INSERT INTO text_bot VALUES("846"," ладненько.");
INSERT INTO text_bot VALUES("847"," я очень рад,затарилась?");
INSERT INTO text_bot VALUES("848"," и тебе хорошего дня и отличного настроения .цвет33. ");
INSERT INTO text_bot VALUES("849","Тишина .ах.");
INSERT INTO text_bot VALUES("850","Выходной ,все отдыхают ");
INSERT INTO text_bot VALUES("851","Нету не кого .ржу.");
INSERT INTO text_bot VALUES("852"," что делаешь .зуб.");
INSERT INTO text_bot VALUES("853"," а я с работы только еду .зуб.устала как собака.ржу.");
INSERT INTO text_bot VALUES("854"," я сама аккуратность.ржу. ");
INSERT INTO text_bot VALUES("855","Вернусь через 15 минут");
INSERT INTO text_bot VALUES("856"," .прик9. ");
INSERT INTO text_bot VALUES("857","Пропал .лол.");
INSERT INTO text_bot VALUES("858"," ничего прибежит .смех2.");
INSERT INTO text_bot VALUES("859","Все я вернулась .ор.");
INSERT INTO text_bot VALUES("860"," в магаз бегала .ор.");
INSERT INTO text_bot VALUES("861"," кофя и шоколад .ор.");
INSERT INTO text_bot VALUES("862"," няя  .конф.   .ч1. ");
INSERT INTO text_bot VALUES("863"," не за что .ах.");
INSERT INTO text_bot VALUES("864"," ни чего. Лажу по сайтам .ор.");
INSERT INTO text_bot VALUES("865"," ну да.. ");
INSERT INTO text_bot VALUES("866","Всем,хорошего настроя!.яху.");
INSERT INTO text_bot VALUES("867"," тебе тоже .ор.");
INSERT INTO text_bot VALUES("868"," Спасибо.Не спиться?.ах.");
INSERT INTO text_bot VALUES("869"," Смотрю ботов отллючили,теперь можно в гостевой общаться.яху.А то страшно было сюда заходить:)");
INSERT INTO text_bot VALUES("870"," Бомбардировка электронами люминафорных покрытий,процессы,расчёт,наблюдения.Я тебя слушаю.жду.");
INSERT INTO text_bot VALUES("871"," нет не спится .ор. тебе тоже");
INSERT INTO text_bot VALUES("872"," .плачет2.Болею.Температура.Смешно звучит,но грипп я плохо переношу:).Ты откуда?.ах");
INSERT INTO text_bot VALUES("873"," вообще то с Беларуси");
INSERT INTO text_bot VALUES("874"," .дум.Вообще то?На мой взгляд,прекрасная страна!А из Туркменистана.Меня Валерой зовут.ах.Так что зови.");
INSERT INTO text_bot VALUES("875"," я знаю что ты Валера .ржу ");
INSERT INTO text_bot VALUES("876"," .глаза.Откуда знаешь?Я сам только что узнал.лол.");
INSERT INTO text_bot VALUES("877"," спать иди");
INSERT INTO text_bot VALUES("878","Зачем?Нее я ночами не сплю.");
INSERT INTO text_bot VALUES("879"," Привет.");
INSERT INTO text_bot VALUES("880",".хрясь.");
INSERT INTO text_bot VALUES("881"," Чего не спишь,рано ещё.?!.дум.");
INSERT INTO text_bot VALUES("882"," А бота я могу отключить?Заипал.плачет2.");
INSERT INTO text_bot VALUES("883","А я ещё и не ложился.Тоже грипп,кашель до боли в горле:(");
INSERT INTO text_bot VALUES("884"," Графник у Тебя классный.кул3.Я эту фотку где то видел.Возможно мы раньше общались.");
INSERT INTO text_bot VALUES("885"," Эту фотку точно видел.Вроде у Али.дум.");
INSERT INTO text_bot VALUES("886"," Сайт Моло...ка");
INSERT INTO text_bot VALUES("887","Главное вкусно,а остальное неважно:)Это как в любви,знаем что она ведёт к смерти,но влюбляемся же.Всё зависет от Тебя,мороженное можно растопить в кофе.миг.");
INSERT INTO text_bot VALUES("888","Всмысле?");
INSERT INTO text_bot VALUES("889"," Кого разводить собралась?.лол.");
INSERT INTO text_bot VALUES("890","Ну и как брачная вирт ночь прошла?.ах.");
INSERT INTO text_bot VALUES("891"," Да на сайте одном его видел,правда не обратил внимание в онлайне,или в офф.");
INSERT INTO text_bot VALUES("892"," ПОШЁЛ НАХУЙ");
INSERT INTO text_bot VALUES("893"," Да бесит,провокация на лицо.В гостевую лучше не заходить.Иначе бан можно получить.Терпение не резина,не растянешь.:(");
INSERT INTO text_bot VALUES("894"," Слава Богу.Спасибо.:)А то надоел.");
INSERT INTO text_bot VALUES("895"," .глаза.А у меня?");
INSERT INTO text_bot VALUES("896",".серкет.Вроде нет его.");
INSERT INTO text_bot VALUES("897"," Может он умер?)))");
INSERT INTO text_bot VALUES("898"," Точно,убила,насмерть.:)");
INSERT INTO text_bot VALUES("899"," .секрет.Это будет нашим маленьким секретом.");
INSERT INTO text_bot VALUES("900"," Держу же.Чужие секреты,мне не пренадлежат,а значит я их не имею права раскрывать.Я даже свои секреты не разглашаю.\r\nКак выучил стишок в 1 классе,так и живу.\r\nТайны доверять своей\r\nИ друзьям нельзя\r\nПотому что у друзей\r\nТоже есть друзья.");
INSERT INTO text_bot VALUES("901"," .восадок.");
INSERT INTO text_bot VALUES("902","Соня:)");
INSERT INTO text_bot VALUES("903"," .утро29.  ");
INSERT INTO text_bot VALUES("904"," привет,как дела");
INSERT INTO text_bot VALUES("905"," да тоже хорошо,на улице мороз");
INSERT INTO text_bot VALUES("906","Не скучно,а покойно.Это же и есть счастье,когда покой на душе.");
INSERT INTO text_bot VALUES("907"," .хрясь.Пшёл вон от сюда.");
INSERT INTO text_bot VALUES("908"," К сожалению,я всегда прав.А иногда хочется ошибиться..лол.");
INSERT INTO text_bot VALUES("909"," В математике да.На войне-атеисты,а в жизни ошибаются только те,кто теряет связь с жизнью.");
INSERT INTO text_bot VALUES("910"," доброе утро жена моя любимая");
INSERT INTO text_bot VALUES("911"," .утрокот.   кофе мой готов )))");
INSERT INTO text_bot VALUES("912"," спасибо  .поц. ");
INSERT INTO text_bot VALUES("913"," Чёто не так?Ну смотри:ошибиться можно в математике,в решении какой нибудь задачи.Можно?Да.Но это не совсем ошибка,так как,её можно исправить.Это такая,детская ошибка.Не серьёзная.На войне ошибка -как правило,это смерть.Но если человек верующий,значит ему смерть не смерть,а начало другой жизни,а это означает что как бы и не было ошибки.А вот когда человек ошибается в жизни,по ситуации,да ещё не осознаёт ошибок своих,то значит,он потерял связь с жизнью.Любая неудача в жизни,не приходит из неоткуда.Любую проблему можно разглятеть заранее,анализируя свои ПОСТУПКИ.Например человек сел в тюрьму,и скулит,что мол он не виноват.Убил соседа случайно,мол.Но точка отсчёта не со слова\"убил\",а от рождения человека.Когда уже убил-это последствие ошибки,которую на самом деле,нужно искать задолго до трагедии.");
INSERT INTO text_bot VALUES("914"," Грех это и есть ошибка.Бери точку отчёта загодя.Любой человек знает,что такое грех,знает заповеди.Но тем не менее грешит.Потому что ошибся когда то,подумав\"а вдруг это не так страшно?!\".Все ошибки, идут из детства.Если у ребёнка на глазах отец избивает мать,как думаешь,ребёнок защищён от ошибок?Наоборот,ошибки в нём зараждаются.Это я о том всё,что ниодин человек не имеет права осуждать другого.Вот и всё о чём я хочу сказать.И надо учиться не ошибаться.");
INSERT INTO text_bot VALUES("915"," И вообще,есть люди которых надо убивать,чтоб жили другие люди.миг.");
INSERT INTO text_bot VALUES("916"," Ну например тех,которые уничтожают массово других.Например ИгилОвца(исламское государство ирака и леванта),или НАТОвца(национальная американская террористическая организация),(запрещённые организации во многих странах мира)).");
INSERT INTO text_bot VALUES("917"," Нет,политика,это сотрудничество.Объединение стран,ради общего блага.А когда объединяются против кого то,ради уничтожения и ограбления,это уже не политика,а преступные замыслы.");
INSERT INTO text_bot VALUES("918","Купи мне лимончик.ах.");
INSERT INTO text_bot VALUES("919"," Спасибо.ах.");
INSERT INTO text_bot VALUES("920","Доброе утро .ор.");
INSERT INTO text_bot VALUES("921"," спасибо .ах. как спалось Мась?");
INSERT INTO text_bot VALUES("922"," привет .ор.");
INSERT INTO text_bot VALUES("923"," иди спать лучше.ржу.");
INSERT INTO text_bot VALUES("924","Спи дружок.ржу.");
INSERT INTO text_bot VALUES("925"," чем занимается?");
INSERT INTO text_bot VALUES("926"," только проснулась .ах. А ты чем?)");
INSERT INTO text_bot VALUES("927"," супер.яху. какие планы на день?");
INSERT INTO text_bot VALUES("928"," я хожу,туда сюда.ржу.,а сколько времени у вас?");
INSERT INTO text_bot VALUES("929"," у меня 10.22 .зуб.");
INSERT INTO text_bot VALUES("930"," блин,у меня тоже 10.22.ржу.");
INSERT INTO text_bot VALUES("931"," а мне уборка и готовка");
INSERT INTO text_bot VALUES("932"," а что бармен не постирает?.ржу.");
INSERT INTO text_bot VALUES("933"," .ржу. а ты думал что ночь у меня");
INSERT INTO text_bot VALUES("934"," да фиг знает,некоторые и спать уж ложатся");
INSERT INTO text_bot VALUES("935"," я только проснулась .ржу.");
INSERT INTO text_bot VALUES("936","Баю бай,спи барменчик засыпай.ржу.");
INSERT INTO text_bot VALUES("937"," а я сплю,хожу и хожу.ржу.");
INSERT INTO text_bot VALUES("938"," это как .ржу.");
INSERT INTO text_bot VALUES("939"," да самогон гоню,проверяю крепость.ржу.");
INSERT INTO text_bot VALUES("940"," давай наливай .ржу.");
INSERT INTO text_bot VALUES("941"," за то я против .ржу.");
INSERT INTO text_bot VALUES("942"," пей.ржу.");
INSERT INTO text_bot VALUES("943"," это ёпта водкаа.ржу.");
INSERT INTO text_bot VALUES("944"," тебе налить?.ржу.");
INSERT INTO text_bot VALUES("945"," да нету тут самогона,,незнаю че и делать.ржу.");
INSERT INTO text_bot VALUES("946"," знаешь,купи мне аппарат самогонный,я тут магазинчик открою,требуют,а нету.ржу.");
INSERT INTO text_bot VALUES("947"," это плохо .зуб.");
INSERT INTO text_bot VALUES("948"," где ты его откопала?,хватит наверное");
INSERT INTO text_bot VALUES("949","Все девочки Алексу идти надо");
INSERT INTO text_bot VALUES("950","Позже буду");
INSERT INTO text_bot VALUES("951"," я думал водку поставить.ржу.");
INSERT INTO text_bot VALUES("952"," .зеркало2. ");
INSERT INTO text_bot VALUES("953"," я тебя вижу солнце");
INSERT INTO text_bot VALUES("954"," .взасос.  ты меня всегда и везде видишь .смех2.");
INSERT INTO text_bot VALUES("955","[center][color=Red]Всем добрый день !!![/color][/center]");
INSERT INTO text_bot VALUES("956"," конечно и в любом виде, .поц67. ");
INSERT INTO text_bot VALUES("957"," в любом не надо .ржу.");
INSERT INTO text_bot VALUES("958"," надо Катя,надо");
INSERT INTO text_bot VALUES("959"," когда я злюсь зай .ржу.лучше не надо меня видеть ");
INSERT INTO text_bot VALUES("960"," а я вот так .глазавглаза. ");
INSERT INTO text_bot VALUES("961"," каа настроение.ор.");
INSERT INTO text_bot VALUES("962"," через каждый час .ах.");
INSERT INTO text_bot VALUES("963"," ну когда на работе нет,а вечером с работы да,каждые полчаса");
INSERT INTO text_bot VALUES("964"," у меня реакция знаешь какая");
INSERT INTO text_bot VALUES("965"," Сглазил,заклинило все.ржу.");
INSERT INTO text_bot VALUES("966","Согласна .зуб.");
INSERT INTO text_bot VALUES("967"," тоже .только устала чет .смех2.");
INSERT INTO text_bot VALUES("968","Что вы все устали,а как же ночью,любовь морковь?????");
INSERT INTO text_bot VALUES("969"," прям совсем нескем???");
INSERT INTO text_bot VALUES("970"," не верю,не может быть,и парня что ли нет???");
INSERT INTO text_bot VALUES("971"," какие твои годы,ещё будут у тебя любимый,и семья будет");
INSERT INTO text_bot VALUES("972"," не потеплело у вас?");
INSERT INTO text_bot VALUES("973"," снега вообще нет,-18,утром,днём теплее,-8,снег нужен");
INSERT INTO text_bot VALUES("974"," пойду пожую чего нибудь");
INSERT INTO text_bot VALUES("975","На любом сайте ..можно купить ");
INSERT INTO text_bot VALUES("976",".ржу.а лежу ,а ты работай .лол.");
INSERT INTO text_bot VALUES("977"," ночью я тебе любовь морковь буду делать");
INSERT INTO text_bot VALUES("978"," будешь конечно .ах. .смех2.");
INSERT INTO text_bot VALUES("979"," желание жду .ор.");
INSERT INTO text_bot VALUES("980"," на совсем .ржу. Добрая девочка ");
INSERT INTO text_bot VALUES("981"," .ночи38.  ");
INSERT INTO text_bot VALUES("982"," .пр11. ");
INSERT INTO text_bot VALUES("983"," .цвет14.  ");
INSERT INTO text_bot VALUES("984"," .цвет9.  ");
INSERT INTO text_bot VALUES("985"," доброе утро  .поц65. ");
INSERT INTO text_bot VALUES("986"," .цвет34.  ");
INSERT INTO text_bot VALUES("987"," работаю .смех2.");
INSERT INTO text_bot VALUES("988"," Приветик спасибо .цвет33. ");
INSERT INTO text_bot VALUES("989"," Да не очень, а у тебя как?:)");
INSERT INTO text_bot VALUES("990"," Да нет всё хорошо, приболела немного");
INSERT INTO text_bot VALUES("991"," Да и погода такая что заболеть быстро можно .цвет37. ");
INSERT INTO text_bot VALUES("992","Всем привет .ор.");
INSERT INTO text_bot VALUES("993"," как ты моя хорошая");
INSERT INTO text_bot VALUES("994"," голова болит .ор. а так вроде норм");
INSERT INTO text_bot VALUES("995"," мась уже выпила");
INSERT INTO text_bot VALUES("996"," да я такая .ржу.");
INSERT INTO text_bot VALUES("997"," дома на диване.зуб.а у тебя");
INSERT INTO text_bot VALUES("998"," ни че себе ,ты как лягушка.ржу.");
INSERT INTO text_bot VALUES("999"," а я семки .ржу.");
INSERT INTO text_bot VALUES("1000"," ага уже губы болят .ржу.");
INSERT INTO text_bot VALUES("1001"," так не ешь ёпта их.ржу.");
INSERT INTO text_bot VALUES("1002"," мне дай .ор.");
INSERT INTO text_bot VALUES("1003"," спасибо .ах.");
INSERT INTO text_bot VALUES("1004"," вкусные ");
INSERT INTO text_bot VALUES("1005","  .ч3. ");
INSERT INTO text_bot VALUES("1006"," так тебе налила");
INSERT INTO text_bot VALUES("1007"," не за что");
INSERT INTO text_bot VALUES("1008"," .прик65. ");
INSERT INTO text_bot VALUES("1009"," Добрый вечер! Пожалуйста!!!");
INSERT INTO text_bot VALUES("1010","ПОМОГИТЕ ВОСТОНОВИТЬ СТРАНИЦУ НИК МОЙ IRUNYA");
INSERT INTO text_bot VALUES("1011"," Ирунь привет");
INSERT INTO text_bot VALUES("1012"," это как ты умудрилась забыть пороль");
INSERT INTO text_bot VALUES("1013","Мне не чего нет");
INSERT INTO text_bot VALUES("1014"," нету");
INSERT INTO text_bot VALUES("1015","Можно еще раз");
INSERT INTO text_bot VALUES("1016"," все новую блокируйте");
INSERT INTO text_bot VALUES("1017"," ты где так долго пропадала");
INSERT INTO text_bot VALUES("1018"," мась зайди вл");
INSERT INTO text_bot VALUES("1019"," хорошо иду");
INSERT INTO text_bot VALUES("1020"," спасибки большое");
INSERT INTO text_bot VALUES("1021","Приветик всем");
INSERT INTO text_bot VALUES("1022"," как ты мась .ор.");
INSERT INTO text_bot VALUES("1023"," норм все. Чем маелась сегодня.зуб.");
INSERT INTO text_bot VALUES("1024"," тоже работала.ржу.");
INSERT INTO text_bot VALUES("1025"," а ты в этом сомневалась.зуб. ");
INSERT INTO text_bot VALUES("1026"," вот умка моя");
INSERT INTO text_bot VALUES("1027"," а чё так ножкой двигаешь.ржу.");
INSERT INTO text_bot VALUES("1028"," бывает .ржу.у моя глаз дёргается.ржу.");
INSERT INTO text_bot VALUES("1029"," устала .ор. хочуу клубники шампанское и на ручки .ор.");
INSERT INTO text_bot VALUES("1030"," кто .глаза.");
INSERT INTO text_bot VALUES("1031","Спасибо мась .ор.");
INSERT INTO text_bot VALUES("1032"," а Паша это кто .ор.");
INSERT INTO text_bot VALUES("1033"," я его не видела .ржу.");
INSERT INTO text_bot VALUES("1034","Спать иди .ржу.");
INSERT INTO text_bot VALUES("1035"," не вижу .ржу.");
INSERT INTO text_bot VALUES("1036"," может ещё крикнуть .зуб.");
INSERT INTO text_bot VALUES("1037"," .зуб. ты подумай");
INSERT INTO text_bot VALUES("1038"," вижу .зуб.");
INSERT INTO text_bot VALUES("1039"," драсте .зуб.");
INSERT INTO text_bot VALUES("1040"," мне смайл нравится .зуб. .ржу.");
INSERT INTO text_bot VALUES("1041"," около то тоже прячь.ржу.");
INSERT INTO text_bot VALUES("1042"," меня точно .ржу.");
INSERT INTO text_bot VALUES("1043"," нетт .ор..ор.");
INSERT INTO text_bot VALUES("1044"," спалила.ржу.привет  .цвет39. ");
INSERT INTO text_bot VALUES("1045"," надо было приватность включить");
INSERT INTO text_bot VALUES("1046"," йа знаю как это сделать не спалившись.ржу.");
INSERT INTO text_bot VALUES("1047"," доброе утро .ах.");
INSERT INTO text_bot VALUES("1048"," вот это стихи.ржу.");
INSERT INTO text_bot VALUES("1049","ВЛАДА,добро пожаловать на сайт .ах.");
INSERT INTO text_bot VALUES("1050","Драсте всем .ор.");
INSERT INTO text_bot VALUES("1051"," спасибо. Де была");
INSERT INTO text_bot VALUES("1052"," тоже самое.. только не уснула");
INSERT INTO text_bot VALUES("1053"," а я простыла (");
INSERT INTO text_bot VALUES("1054","Доброй ночи всем");
INSERT INTO text_bot VALUES("1055"," вроде норм,:)");
INSERT INTO text_bot VALUES("1056"," собираюсь Кофе сливками пить.\r\nА ты чем занята?");
INSERT INTO text_bot VALUES("1057"," наливай:)");
INSERT INTO text_bot VALUES("1058"," что давать:) а то я с этим бармэном запуталась в смс.лол.");
INSERT INTO text_bot VALUES("1059"," хорошо тебе отработать");
INSERT INTO text_bot VALUES("1060"," Лан щас .ч1. держи:)");
INSERT INTO text_bot VALUES("1061"," пожалуйста .ромашка. ");
INSERT INTO text_bot VALUES("1062","Незя спать .ор.");
INSERT INTO text_bot VALUES("1063"," я ещё не сплю .ржу.");
INSERT INTO text_bot VALUES("1064"," это ещё детское время");
INSERT INTO text_bot VALUES("1065"," Мась а я 4 утра .ржу.");
INSERT INTO text_bot VALUES("1066","Громче кричи .ржу.");
INSERT INTO text_bot VALUES("1067"," мне на 6 .ржу. и до вечера ");
INSERT INTO text_bot VALUES("1068","Давай вместе Стас выходи .ор..ор..ор..ор.");
INSERT INTO text_bot VALUES("1069"," ты Стас .ржу.");
INSERT INTO text_bot VALUES("1070"," а я по 12 часов и без обеда ");
INSERT INTO text_bot VALUES("1071"," походу он не слышет .ржу.");
INSERT INTO text_bot VALUES("1072"," ооо секретная охраной ");
INSERT INTO text_bot VALUES("1073"," походу испугали мы его .зуб.");
INSERT INTO text_bot VALUES("1074"," зеков");
INSERT INTO text_bot VALUES("1075"," надо вот так .ах.");
INSERT INTO text_bot VALUES("1076"," больше по опе бей .ор.");
INSERT INTO text_bot VALUES("1077"," не знаю .накачели. ");
INSERT INTO text_bot VALUES("1078"," новерно");
INSERT INTO text_bot VALUES("1079"," спасибо .ах. щас напьюсь и спою .ржу.");
INSERT INTO text_bot VALUES("1080"," боюсь все убегут .зуб.");
INSERT INTO text_bot VALUES("1081"," тогда можно");
INSERT INTO text_bot VALUES("1082","Миша выходи .ор.");
INSERT INTO text_bot VALUES("1083"," слова забыла .ржу.");
INSERT INTO text_bot VALUES("1084","Аууу есть кто .ор..ор.");
INSERT INTO text_bot VALUES("1085","Всем приветик");
INSERT INTO text_bot VALUES("1086","Доброй ночи .вечер46. ");
INSERT INTO text_bot VALUES("1087"," порядок, конечно, два раза");
INSERT INTO text_bot VALUES("1088"," раз попарился и в снег, второй раз помылся");
INSERT INTO text_bot VALUES("1089"," ты же проголадалась");
INSERT INTO text_bot VALUES("1090"," не ждали");
INSERT INTO text_bot VALUES("1091"," .вечер47. ");
INSERT INTO text_bot VALUES("1092"," .дутро.  ");
INSERT INTO text_bot VALUES("1093"," отличное,а твоё как?");
INSERT INTO text_bot VALUES("1094"," это хорошо что хорошее настроение, хорошо тебе отработать.");
INSERT INTO text_bot VALUES("1095"," не зачто .цвет1. ");
INSERT INTO text_bot VALUES("1096"," .спас8.  ");
INSERT INTO text_bot VALUES("1097"," до вечера.ор.");
INSERT INTO text_bot VALUES("1098"," ок:)");
INSERT INTO text_bot VALUES("1099"," бум ждать");
INSERT INTO text_bot VALUES("1100"," привет попрятались видно.лол.");
INSERT INTO text_bot VALUES("1101"," ты как как настроение?:)");
INSERT INTO text_bot VALUES("1102"," всё хорошо,ты давай поешь и отдыхай");
INSERT INTO text_bot VALUES("1103"," вот молодец");
INSERT INTO text_bot VALUES("1104"," крылышки в духовке готовлю");
INSERT INTO text_bot VALUES("1105"," крутая машина у тебя.лол.");
INSERT INTO text_bot VALUES("1106"," только поела, лежу на диване,а ты как?");
INSERT INTO text_bot VALUES("1107"," а я уснула.лол.");
INSERT INTO text_bot VALUES("1108"," .дутро4.  ");
INSERT INTO text_bot VALUES("1109","  .спас4. моя хорошая");
INSERT INTO text_bot VALUES("1110"," нормально, хотела ВИП себе чтобы поставили.\r\nА сменили ник мой.лол.");
INSERT INTO text_bot VALUES("1111"," Да,верни ник пожалуйста.\r\nДа ВИП хотела статус картинку,");
INSERT INTO text_bot VALUES("1112"," у нас снег выпал.яху.");
INSERT INTO text_bot VALUES("1113"," не,у нас вот сегодня первый день прошел,ура на моё день рождения снег будет.яху.");
INSERT INTO text_bot VALUES("1114"," 7 на день Екатерина Святой");
INSERT INTO text_bot VALUES("1115"," аха .зима13. ");
INSERT INTO text_bot VALUES("1116"," аха я там такая погода как на картинке, хорошо:)");
INSERT INTO text_bot VALUES("1117"," .утро10.   ");
INSERT INTO text_bot VALUES("1118","  .утро9.  ");
INSERT INTO text_bot VALUES("1119"," спасибо и тебе хорошего дня и настроения:)");
INSERT INTO text_bot VALUES("1120"," доброй ночи:)");
INSERT INTO text_bot VALUES("1121"," у меня тоже уже утро, хорошо тебе отработать .цвет39. ");
INSERT INTO text_bot VALUES("1122"," спасибо, думаю что сегодня день должен быть отличным.:)");
INSERT INTO text_bot VALUES("1123"," конечно замечательно,и тебе желаю такого замечательного дня:)");
INSERT INTO text_bot VALUES("1124"," так этож хорошо:)");
INSERT INTO text_bot VALUES("1125"," какой завал,чего не знаю что произошло?");
INSERT INTO text_bot VALUES("1126"," не повезло.\r\nНу работа есть работа,не чё не поделаешь.");
INSERT INTO text_bot VALUES("1127","  .цвет7. ");
INSERT INTO text_bot VALUES("1128"," .дутро42.  ");
INSERT INTO text_bot VALUES("1129"," Добрый вечер!:)");
INSERT INTO text_bot VALUES("1130"," Спокойной ночи.ах.А у меня интернет заработает только через 3 с половиной часа.Тогда и зайду в инет.Сейчас не пашет.Страничка грузится за 10...15 минут.");
INSERT INTO text_bot VALUES("1131"," Хотел спросить,в церкви поп что добавляет в кадило?Ладан?Это наш Узарлык что ли?Как выглядит Ладан?Там есть шарики(головки)?.дум.");
INSERT INTO text_bot VALUES("1132"," Всмысле,небыла?Ты не русская?Не православная?");
INSERT INTO text_bot VALUES("1133"," Ну если Ты мусульманка,тогда что такое Узарлык Ты должна знать.");
INSERT INTO text_bot VALUES("1134","[img]https://bestgif.su/_ph/6/2/272593396.gif[/img]");
INSERT INTO text_bot VALUES("1135","  .ддень5. ");
INSERT INTO text_bot VALUES("1136","  .спас11. ");
INSERT INTO text_bot VALUES("1137"," .кофе. да с пироженком .ням.");
INSERT INTO text_bot VALUES("1138","  .дутро3. ");
INSERT INTO text_bot VALUES("1139"," .дутро41. ");
INSERT INTO text_bot VALUES("1140","  .утро22.  ");
INSERT INTO text_bot VALUES("1141"," ню кусочек .ням. я себе свиндила .лол. ");
INSERT INTO text_bot VALUES("1142"," так нужно же знать .ах. укусный он иль не очень .лол.");
INSERT INTO text_bot VALUES("1143"," ты куда сока ложек наложила .ор.  варенья вообще мало ");
INSERT INTO text_bot VALUES("1144"," варенья мало не бывает .лол. ");
INSERT INTO text_bot VALUES("1145"," самое главное что бы не пендюля .ржу.");
INSERT INTO text_bot VALUES("1146"," ататашку не дам .ор.");
INSERT INTO text_bot VALUES("1147"," что укусного принесла ");
INSERT INTO text_bot VALUES("1148"," о пельменюшки .лол. из хрюшки ");
INSERT INTO text_bot VALUES("1149"," а вот и десертик , дем на пельмешки ");
INSERT INTO text_bot VALUES("1150"," люблю это дело , блин вот что теперь идти лепить .ор. раздраконила .лол.");
INSERT INTO text_bot VALUES("1151"," честно жариные не ела , а вот со сметанкой да с соком томатным.....ням.");
INSERT INTO text_bot VALUES("1152","все .битадев.   кончила .ор. усе грабли переломаны .ржу.. ");
INSERT INTO text_bot VALUES("1153"," ты не варишь а сразу жаришь....");
INSERT INTO text_bot VALUES("1154"," масло какое...сливочное, подсолнечное ");
INSERT INTO text_bot VALUES("1155"," попробую , спасибо ");
INSERT INTO text_bot VALUES("1156","Девочки хорошего Вам дня, я на выход ");
INSERT INTO text_bot VALUES("1157","живые есть  .прива. ");
INSERT INTO text_bot VALUES("1158"," живые .ор. ");
INSERT INTO text_bot VALUES("1159"," остальные где .лак1. ");
INSERT INTO text_bot VALUES("1160"," плюнь каку , вдруг у них справки не было .ор.");
INSERT INTO text_bot VALUES("1161"," ну вот  .дыбом.  уже бекаешь .лол. это кем ты там поживилась то .ржу. ");
INSERT INTO text_bot VALUES("1162","ты у них пытай  .чит3.  справку от ветеринара .лол. ");
INSERT INTO text_bot VALUES("1163"," ага выбираем .лол. с кого начнем .лак1. смотри меня незя .лол. я не вкусная ");
INSERT INTO text_bot VALUES("1164","  .невозм. там тока Stas511 его бум ");
INSERT INTO text_bot VALUES("1165"," спугнула .лол. ");
INSERT INTO text_bot VALUES("1166"," так ты еще и прыгала.....надо было аккуратно ловить....от нас все так сбегут .лол.");
INSERT INTO text_bot VALUES("1167"," и шо бум делать .кофе.");
INSERT INTO text_bot VALUES("1168","Всем .вечер25. ");
INSERT INTO text_bot VALUES("1169","  .спас4.  за поздравление");
INSERT INTO text_bot VALUES("1170"," .прив4.   .спас6. ");
INSERT INTO text_bot VALUES("1171"," это точно");
INSERT INTO text_bot VALUES("1172"," как делишки настроения");
INSERT INTO text_bot VALUES("1173"," что случилось");
INSERT INTO text_bot VALUES("1174"," ясненько. Выздоравливай и не болей");
INSERT INTO text_bot VALUES("1175"," Незачто");
INSERT INTO text_bot VALUES("1176"," .дутро1.  ");
INSERT INTO text_bot VALUES("1177"," .утролюб.   ");
INSERT INTO text_bot VALUES("1178"," всё хорошо а у тебя как дела настроение?");
INSERT INTO text_bot VALUES("1179"," супер");
INSERT INTO text_bot VALUES("1180"," эть хорошо:)");
INSERT INTO text_bot VALUES("1181","  .цем. ");
INSERT INTO text_bot VALUES("1182"," .поццел.  ");
INSERT INTO text_bot VALUES("1183"," Приветик. Давай мне");
INSERT INTO text_bot VALUES("1184"," спосибочки");
INSERT INTO text_bot VALUES("1185"," .дутродрузья. ");
INSERT INTO text_bot VALUES("1186","XyLIGAN .утро25.  ");
INSERT INTO text_bot VALUES("1187","  .дутро12. ");
INSERT INTO text_bot VALUES("1188"," спасибки .ор.");
INSERT INTO text_bot VALUES("1189"," лови песню \r\n[youtube]pAOeEySE7ec[/youtube]");
INSERT INTO text_bot VALUES("1190"," [youtube]nckQNqvKPMY[/youtube]");
INSERT INTO text_bot VALUES("1191"," ты как день провела ?");
INSERT INTO text_bot VALUES("1192"," .вечер35.  ");
INSERT INTO text_bot VALUES("1193"," .ах.");
INSERT INTO text_bot VALUES("1194","  .утро18.  ");
INSERT INTO text_bot VALUES("1195"," так вроде хорошо , если бы не на работу иди .ор.");
INSERT INTO text_bot VALUES("1196"," а я в отпуск хочу .ор. ");
INSERT INTO text_bot VALUES("1197"," а .хз. когда возьму остаток , толку брать если не знаю где его отдохнуть , дома нет желания сидеть ");
INSERT INTO text_bot VALUES("1198"," пора и от сюда поприветствовать людям, а то смотрю тишина тут, здесь у каждого свои избранник наверное и по тихаря межсобою болтают только=)");
INSERT INTO text_bot VALUES("1199"," вечер добрый братан:) мало о чем? Всегда приятно общаться с приятными людьми притом с такоц расстоянии:)");
INSERT INTO text_bot VALUES("1200"," о чем угодно:) время есть и благодаря инета, все это уже проще простого:)");
INSERT INTO text_bot VALUES("1201"," что то совсем не хотят выходить общаться.лол.");
INSERT INTO text_bot VALUES("1202","Меня что ли боятся.зуб.");
INSERT INTO text_bot VALUES("1203"," ну если так каждого будешь посылать, то побайваются конечно.лол.");
INSERT INTO text_bot VALUES("1204","  .вечер7. ");
INSERT INTO text_bot VALUES("1205"," ну это ваше дело.лол.");
INSERT INTO text_bot VALUES("1206"," как день прошел  .кофе3. у тебя");
INSERT INTO text_bot VALUES("1207"," а он что, бот?");
INSERT INTO text_bot VALUES("1208","  .вечер45. ");
INSERT INTO text_bot VALUES("1209"," добрый вечер медуза=)  .вечер34. ");
INSERT INTO text_bot VALUES("1210","нормально  .думает.  еще день завтр продержаться и выходные  .диско2. ");
INSERT INTO text_bot VALUES("1211"," о...кофе , коньяк и закурить .лол. ");
INSERT INTO text_bot VALUES("1212"," планов цельная гора , аж теряюсь .лол.");
INSERT INTO text_bot VALUES("1213"," здесес много выбора, все на выбор и по настроение=)");
INSERT INTO text_bot VALUES("1214"," ну и можно знакомиться по ходу:) или это не в планах;)");
INSERT INTO text_bot VALUES("1215"," о половины точно окажусь .лол.");
INSERT INTO text_bot VALUES("1216"," давай  .зеркало2. знакомиться ");
INSERT INTO text_bot VALUES("1217"," да практически все дни в бегах .кофе3.");
INSERT INTO text_bot VALUES("1218"," не-а , я хронический пассажир .лол. ");
INSERT INTO text_bot VALUES("1219"," я Леван.цвет7. ");
INSERT INTO text_bot VALUES("1220"," необычное имя , а что оно означает ");
INSERT INTO text_bot VALUES("1221"," .истерика.  та нервов  .ф1. на них не хватает ");
INSERT INTO text_bot VALUES("1222"," имя как имя:) чисто грузинское");
INSERT INTO text_bot VALUES("1223"," то ты просто дефеле ленишься делать .гордо.");
INSERT INTO text_bot VALUES("1224"," а у меня имя как у шоколадки .ах.");
INSERT INTO text_bot VALUES("1225"," насильно это как?:)");
INSERT INTO text_bot VALUES("1226"," рыцарей нет .лол. ");
INSERT INTO text_bot VALUES("1227"," я не молчу, просто не хочу вмешатн ваш диалог:)");
INSERT INTO text_bot VALUES("1228"," как как .ржу. мультик помнишь....Гена возьми меня на ручки и понеси , а я чемоданы понесу .лол.");
INSERT INTO text_bot VALUES("1229"," а Милашке эти слова не понодобится, её каждый раз можно носить на руках:)");
INSERT INTO text_bot VALUES("1230"," кто бы спорил .лол.");
INSERT INTO text_bot VALUES("1231"," а вот знакомиться не хотят.лол.");
INSERT INTO text_bot VALUES("1232"," а ты не хочешь назвать свое имя?:)");
INSERT INTO text_bot VALUES("1233"," Медуза:(:)");
INSERT INTO text_bot VALUES("1234","Простите девочки, с вами хорошо, но ко мне друзья в гости пришли, наверно бухать будем, давайте, приятной вам общений, до связи!:)");
INSERT INTO text_bot VALUES("1235"," что за секреты .ор.и без меня ");
INSERT INTO text_bot VALUES("1236"," а...ну да и сразу убежал на совет к друзьям .лол.");
INSERT INTO text_bot VALUES("1237"," так это он еще не пробовал на руках носить .лол.");
INSERT INTO text_bot VALUES("1238"," ты по аккуратней смотри шоб не сбег  .улетел. ");
INSERT INTO text_bot VALUES("1239"," .ночи14.   .ночи9..ах.");
INSERT INTO text_bot VALUES("1240"," .дутро2.  ");
INSERT INTO text_bot VALUES("1241"," .дутро45.  ");
INSERT INTO text_bot VALUES("1242"," .утро27.    .ч1. ");
INSERT INTO text_bot VALUES("1243"," как настроение?:)");
INSERT INTO text_bot VALUES("1244"," пятница .ор. да еще и 13 самый лучший день  .диско2. ");
INSERT INTO text_bot VALUES("1245"," .утро26.   ");
INSERT INTO text_bot VALUES("1246"," эть точно.лол.");
INSERT INTO text_bot VALUES("1247"," спасибо .цвет5. ты тоже поправляйся поскорее:)");
INSERT INTO text_bot VALUES("1248"," спасибо за комплимент:) этого незнаю бробывал или нет)))");
INSERT INTO text_bot VALUES("1249"," ну кто знает может быть и на губах -)) я Катя");
INSERT INTO text_bot VALUES("1250"," твоё имя я слышу в первые-)) как настроение?");
INSERT INTO text_bot VALUES("1251"," значит иди отдохни:)");
INSERT INTO text_bot VALUES("1252","Я на выход");
INSERT INTO text_bot VALUES("1253","Доброе утро всем");
INSERT INTO text_bot VALUES("1254"," добриы день как настарени?");
INSERT INTO text_bot VALUES("1255"," мене:)");
INSERT INTO text_bot VALUES("1256"," .спас4.  ");
INSERT INTO text_bot VALUES("1257"," .спас8.  за звёздочки у мну на странице.ор.");
INSERT INTO text_bot VALUES("1258"," попровляйся.ор.");
INSERT INTO text_bot VALUES("1259"," стараюсь, чёт спать охота а тебе?");
INSERT INTO text_bot VALUES("1260"," мне");
INSERT INTO text_bot VALUES("1261"," Прювет казяфка:подмиг");
INSERT INTO text_bot VALUES("1262"," 200 И 1% лапочка:подмиг");
INSERT INTO text_bot VALUES("1263"," Ну эта уже больш процикоф перевалит..я тож фулюган:подмиг");
INSERT INTO text_bot VALUES("1264"," Стоять:подмиг");
INSERT INTO text_bot VALUES("1265","Та не вопрос сама напросилась:подмиг.поц13.");
INSERT INTO text_bot VALUES("1266","А зуб де затыряла:подмиг");
INSERT INTO text_bot VALUES("1267","живые есть .кофе3.");
INSERT INTO text_bot VALUES("1268"," .утро25.   не--а , олько слегка покалеченые ");
INSERT INTO text_bot VALUES("1269"," а я  .лак1.  цельная и невредимая .лол. не дождетесь .бла2.");
INSERT INTO text_bot VALUES("1270"," так и я про тушку .кофе3.");
INSERT INTO text_bot VALUES("1271"," так я писала,  Аленка  ");
INSERT INTO text_bot VALUES("1272"," имя как у шоколадки .жду2.");
INSERT INTO text_bot VALUES("1273","любопытство не приговор еще .лол.");
INSERT INTO text_bot VALUES("1274"," я с них  уползаю .лол.");
INSERT INTO text_bot VALUES("1275"," .глаза. я что то пропустила ....мне с чего волноваться....да еще и чему-то приезду...ты не чего не попутал...");
INSERT INTO text_bot VALUES("1276","вот это( не волнуйся, не приеду, не люблю лжи) к чему .... бред такой писать ");
INSERT INTO text_bot VALUES("1277"," мдя бывает ");
INSERT INTO text_bot VALUES("1278"," привет как ты?:)");
INSERT INTO text_bot VALUES("1279"," это радует:) у меня тоже всё хорошо. .цвет34. ");
INSERT INTO text_bot VALUES("1280"," ты смотрю а ты ходила дышать свежим воздухом?");
INSERT INTO text_bot VALUES("1281"," ты не покупай а делай обмен рекламы");
INSERT INTO text_bot VALUES("1282"," а Каму предлогала?");
INSERT INTO text_bot VALUES("1283"," это уже хорошая новость:)");
INSERT INTO text_bot VALUES("1284"," Спасибо :) ");
INSERT INTO text_bot VALUES("1285"," .цвет37.  ");
INSERT INTO text_bot VALUES("1286"," . .цвет39.   ");
INSERT INTO text_bot VALUES("1287"," И я пришла.ор.");
INSERT INTO text_bot VALUES("1288","Не, ну в гости зашёл, хоть бы здрасьте сказал.ржу. ");
INSERT INTO text_bot VALUES("1289"," Приветик :) ");
INSERT INTO text_bot VALUES("1290","Всем салют и добрый вечер");
INSERT INTO text_bot VALUES("1291"," как настроение?,");
INSERT INTO text_bot VALUES("1292"," сегодня уже лучше,вчера дико болела голова,\r\nУ тебя как здоровье?");
INSERT INTO text_bot VALUES("1293"," это хорошо,желаю чтобы больше не болела и не попадала в больницу.ор. .цвет7. ");
INSERT INTO text_bot VALUES("1294"," стараюсь мась");
INSERT INTO text_bot VALUES("1295"," я типло одивайся:)");
INSERT INTO text_bot VALUES("1296","Всем прівет.");
INSERT INTO text_bot VALUES("1297","Доброе \r\nутро всем");
INSERT INTO text_bot VALUES("1298"," спасибо ивам тагжэ");
INSERT INTO text_bot VALUES("1299","Награду - за красивое молчание... Молчание - небес звучание... .панк..вбанке.");
INSERT INTO text_bot VALUES("1300","Прівет у меня севодня день ражденія.");
INSERT INTO text_bot VALUES("1301"," .дутро39.  ");
INSERT INTO text_bot VALUES("1302"," как дела у тебя?:) Что делаешь?");
INSERT INTO text_bot VALUES("1303"," так найди себе любимую тут");
INSERT INTO text_bot VALUES("1304"," хорошо тебе отработать,:)");
INSERT INTO text_bot VALUES("1305"," почему редко,я чаще захожу сюда,это у меня мама в гостях, скоро будет ехать домой поэтому  и не заходила");
INSERT INTO text_bot VALUES("1306"," почему ты так решил,что четвертый день?-))");
INSERT INTO text_bot VALUES("1307"," так она домой потом уехала:) \r\nЭто она вчера приехала, сейчас уезжает");
INSERT INTO text_bot VALUES("1308"," нет");
INSERT INTO text_bot VALUES("1309"," конечно");
INSERT INTO text_bot VALUES("1310","Всем приветик.прив.");
INSERT INTO text_bot VALUES("1311"," Привет. И тут ты есть.ржу. ");
INSERT INTO text_bot VALUES("1312"," О жизни.лол.");
INSERT INTO text_bot VALUES("1313"," Приветик. Спасибочки. Пришла к вам в гости  .цвет40. ");
INSERT INTO text_bot VALUES("1314"," Спасибо. Ну немного посижу))) ");
INSERT INTO text_bot VALUES("1315"," Хорошо. Я от своего деда сбежала, а у тебя он тут бармен, тоже встречает.лол.");
INSERT INTO text_bot VALUES("1316"," Мне дед дома надоел, смотрю и тут чудит. Тоже выпить просит наверное.ржу. ");
INSERT INTO text_bot VALUES("1317","а моя ава круче чем твоя рожа.лол. ");
INSERT INTO text_bot VALUES("1318"," [img]https://media.tenor.com/images/32267c75629c37d0d65a6552beed6a07/tenor.gif[/img] спасибо");
INSERT INTO text_bot VALUES("1319"," Басков");
INSERT INTO text_bot VALUES("1320","[center]За окнами зима седая,\r\nМороз трещит, метёт метель,\r\nНо в день Святого Николая,\r\nВ душе у нас поёт свирель!\r\nПусть в дом войдёт сегодня чудо,\r\nА в сердце каждого — любовь!\r\nИ всем кому бывает худо,\r\nПоможет Чудотворец вновь.\r\nПусть мир покоем осветится,\r\nВ душе наступит благодать!\r\nЧтоб воедино с верой слиться,\r\nИ счастье большее познать![/center]");
INSERT INTO text_bot VALUES("1321","Тишина.. .чит3. ");
INSERT INTO text_bot VALUES("1322",".злой.");
INSERT INTO text_bot VALUES("1323"," оно и видно.ржу. Что тишина как в танке.ржу.");
INSERT INTO text_bot VALUES("1324","Так эта ешо в мелком возрасте было.ржу.А воть ща тока целую у выбитый зуб:подмиг");
INSERT INTO text_bot VALUES("1325",".. .вечер45. ");
INSERT INTO text_bot VALUES("1326","Всем здрасти");
INSERT INTO text_bot VALUES("1327"," здравствуй солнышко");
INSERT INTO text_bot VALUES("1328","Воскресенье  .еда7. ");
INSERT INTO text_bot VALUES("1329"," и тебе тоже приятных");
INSERT INTO text_bot VALUES("1330","Не за что");
INSERT INTO text_bot VALUES("1331"," нормально, лежу, у тебя как? ");
INSERT INTO text_bot VALUES("1332"," вставать не хочется");
INSERT INTO text_bot VALUES("1333"," в душ");
INSERT INTO text_bot VALUES("1334"," всё я ушел");
INSERT INTO text_bot VALUES("1335"," и вам тоже ");
INSERT INTO text_bot VALUES("1336"," прекрасно");
INSERT INTO text_bot VALUES("1337"," я тоже");
INSERT INTO text_bot VALUES("1338"," Добрый день.");
INSERT INTO text_bot VALUES("1339"," привет:)");
INSERT INTO text_bot VALUES("1340"," что тебе мешает поспать");
INSERT INTO text_bot VALUES("1341"," .цвет20.  ");
INSERT INTO text_bot VALUES("1342"," спасибо за всё ");
INSERT INTO text_bot VALUES("1343"," за награду");
INSERT INTO text_bot VALUES("1344"," .б8.  ");
INSERT INTO text_bot VALUES("1345"," супер, работаю, ты как? ");
INSERT INTO text_bot VALUES("1346","Всем прівет і харошева настроенія день і ніч зігріемо теплом.");
INSERT INTO text_bot VALUES("1347","Привіт усім ганого і затишного вечора.");
INSERT INTO text_bot VALUES("1348"," я на выходе была щас опять пойду. .цвет31. ");
INSERT INTO text_bot VALUES("1349"," Кофе пойду делать:) дела норм,ты как?");
INSERT INTO text_bot VALUES("1350"," ok-))");
INSERT INTO text_bot VALUES("1351"," Кофе с мороженым очень вкусно:)");
INSERT INTO text_bot VALUES("1352","[youtube]Fr_Aju_qeFg[/youtube]");
INSERT INTO text_bot VALUES("1353","Добрый вечерок");
INSERT INTO text_bot VALUES("1354"," спасибо,а я тя сразу не признала.лол.как настроение?");
INSERT INTO text_bot VALUES("1355"," отлично, лежу телек смотрю");
INSERT INTO text_bot VALUES("1356"," я уже слепую смотрю:)");
INSERT INTO text_bot VALUES("1357"," я не хочу,это по тв слепая идёт-))");
INSERT INTO text_bot VALUES("1358"," она самая:) вроде бы все отмечают рождество.");
INSERT INTO text_bot VALUES("1359"," тебя тоже с наступающими праздниками .зима2. ");
INSERT INTO text_bot VALUES("1360","  .спас20. тебе за випки,они классные .цвет4. ");
INSERT INTO text_bot VALUES("1361"," какие католики?");
INSERT INTO text_bot VALUES("1362"," так а причем здесь они,если провославие тоже празднуют эти праздники");
INSERT INTO text_bot VALUES("1363"," а с 25 считается по старому стилю новый год.\r\nТак что завтра гуляем.яху.");
INSERT INTO text_bot VALUES("1364"," агась.яху.");
INSERT INTO text_bot VALUES("1365"," ток вечером зайду завтра,я ещё на день рождения пойду:)");
INSERT INTO text_bot VALUES("1366"," это что сайт пустой будет");
INSERT INTO text_bot VALUES("1367"," но а меня точно до вечера не будет,но постараюсь зайти.\r\n");
INSERT INTO text_bot VALUES("1368","Зайду позже тел сел");
INSERT INTO text_bot VALUES("1369"," я пришла .ор.");
INSERT INTO text_bot VALUES("1370"," .ночи11. ");
INSERT INTO text_bot VALUES("1371","Всім доброго вечора.");
INSERT INTO text_bot VALUES("1372","Всем спакойной ночі.");
INSERT INTO text_bot VALUES("1373","Всем доброе і харошева настраенія.");
INSERT INTO text_bot VALUES("1374"," .пр30. ");
INSERT INTO text_bot VALUES("1375","Добриы вечер всем");
INSERT INTO text_bot VALUES("1376"," Приветик, отлично. Ты как? Реал тоже нужен  -)) ");
INSERT INTO text_bot VALUES("1377"," привет как настарени?");
INSERT INTO text_bot VALUES("1378"," привет да ");
INSERT INTO text_bot VALUES("1379"," отлично");
INSERT INTO text_bot VALUES("1380","Гарного всім вечора.");
INSERT INTO text_bot VALUES("1381","Всім спокійноі ночі.");
INSERT INTO text_bot VALUES("1382"," .ддень3.  ");
INSERT INTO text_bot VALUES("1383","  .вечер26. ");
INSERT INTO text_bot VALUES("1384"," .прик84. ");
INSERT INTO text_bot VALUES("1385","Усім спакойной ночі.");
INSERT INTO text_bot VALUES("1386","Доброе утра всем з наступаючим.");
INSERT INTO text_bot VALUES("1387","А чего такая тишь да гладь? ");
INSERT INTO text_bot VALUES("1388","Блин,эта шо за сайт? Ничиго ни работаеть. В личке сообщение,а зайти шоб ответить низя. Сутки пачти розсматривали,стоить миня принимать,или неа. Я панимаю шо сайт маладой,так хоть встретить юзера можна нармальна? Я в шоке,создатель,поговори со мной.");
INSERT INTO text_bot VALUES("1389","  Бебебе. .истерика. ");
INSERT INTO text_bot VALUES("1390","  [red] Дерьмовый сайт. Скажите всем,что  МАСЯ не рекомендует. Не умееш,не берись. [/red]");
INSERT INTO text_bot VALUES("1391"," Что ж ты так о сайте и его владельце? В поляне приличный сайт");
INSERT INTO text_bot VALUES("1392","В полне*");
INSERT INTO text_bot VALUES("1393"," .доп24. ");
INSERT INTO text_bot VALUES("1394"," В смысле - приличный? Мне админ написал в личку,мало шо я в личку зайти не могу,так у него на аватарке кукиш.  Я так понимаю,шо аватарка,это  лицо пользователя. Я зашла по спамовской ссылке. Приличные сайты не спамят. Я админ сайта,где вы наспамили. Могу теперь не переживать. Мои на такой сайт не сунутся.");
INSERT INTO text_bot VALUES("1395","Капец,тут есть кто нить живой?");
INSERT INTO text_bot VALUES("1396","Русик ты тут?");
INSERT INTO text_bot VALUES("1397","И где все  .жду2. ");
INSERT INTO text_bot VALUES("1398"," что и тут карантин капец .восадок. ");
INSERT INTO text_bot VALUES("1399","Народ выходим общатся .злой3. ");
INSERT INTO text_bot VALUES("1400"," .злой2. ");
INSERT INTO text_bot VALUES("1401"," .злой. ");
INSERT INTO text_bot VALUES("1402","Привет всем");
INSERT INTO text_bot VALUES("1403"," добрый вечерочек");
INSERT INTO text_bot VALUES("1404"," добрый вечер");
INSERT INTO text_bot VALUES("1405"," как делишки? ");
INSERT INTO text_bot VALUES("1406"," нормально, а у тебя?");
INSERT INTO text_bot VALUES("1407"," да нормально все.");
INSERT INTO text_bot VALUES("1408"," отдыхаешь?");
INSERT INTO text_bot VALUES("1409"," ну да отдыхаю");
INSERT INTO text_bot VALUES("1410"," вечер ведь, надо отдыхать");
INSERT INTO text_bot VALUES("1411"," а ты чем занимаешься?");
INSERT INTO text_bot VALUES("1412"," лежу и в инете");
INSERT INTO text_bot VALUES("1413"," а я тоже в инете лазию.");
INSERT INTO text_bot VALUES("1414"," и что нового?");
INSERT INTO text_bot VALUES("1415"," да так ничего ");
INSERT INTO text_bot VALUES("1416"," понимаю");
INSERT INTO text_bot VALUES("1417"," ладненько я на ненадолго выйду");
INSERT INTO text_bot VALUES("1418"," выйди");
INSERT INTO text_bot VALUES("1419"," надеюсь нидолго");
INSERT INTO text_bot VALUES("1420"," я уже здесь,уже соскучиться успел?");
INSERT INTO text_bot VALUES("1421"," не успел");
INSERT INTO text_bot VALUES("1422"," ну видишь как оперативно вернулась.лол.");
INSERT INTO text_bot VALUES("1423"," это точно, быстро");
INSERT INTO text_bot VALUES("1424"," ну вот как хорошо");
INSERT INTO text_bot VALUES("1425"," вроде пока НИКТО не испортил,а как у тебя?");
INSERT INTO text_bot VALUES("1426"," нормально все");
INSERT INTO text_bot VALUES("1427"," чем хочешь заняться?");
INSERT INTO text_bot VALUES("1428"," покамись думаю, а ты?");
INSERT INTO text_bot VALUES("1429"," тоже пока думаю. ");
INSERT INTO text_bot VALUES("1430"," хотя итак есть мысля");
INSERT INTO text_bot VALUES("1431"," интересно какая же? Если не секрет");
INSERT INTO text_bot VALUES("1432"," хочу людей пригласить");
INSERT INTO text_bot VALUES("1433"," а ты знаешь как их заинтересовать здесь,чтобы они остались на сайте?");
INSERT INTO text_bot VALUES("1434"," что нибудь придумается, а ты знаешь?");
INSERT INTO text_bot VALUES("1435"," пока что нет");
INSERT INTO text_bot VALUES("1436"," все хорошо будет");
INSERT INTO text_bot VALUES("1437"," этот было бы не плохо\r\n");
INSERT INTO text_bot VALUES("1438"," плохо не будет");
INSERT INTO text_bot VALUES("1439"," надеюсь.");
INSERT INTO text_bot VALUES("1440"," плохого не надо");
INSERT INTO text_bot VALUES("1441"," это понятно.лол.");
INSERT INTO text_bot VALUES("1442"," освободилась?");
INSERT INTO text_bot VALUES("1443"," да вроде");
INSERT INTO text_bot VALUES("1444"," ну вот");
INSERT INTO text_bot VALUES("1445","Саня, привет");
INSERT INTO text_bot VALUES("1446"," Не выйдет никто.");
INSERT INTO text_bot VALUES("1447"," Может потому что я общительная. Не стеснительная");
INSERT INTO text_bot VALUES("1448"," Может просто не интересно. Будем знакомиться?");
INSERT INTO text_bot VALUES("1449"," Очень приятно. Я Кристина");
INSERT INTO text_bot VALUES("1450"," Чем занимаешься?");
INSERT INTO text_bot VALUES("1451"," Отдыхаю");
INSERT INTO text_bot VALUES("1452"," Прохладно. А у вас?");
INSERT INTO text_bot VALUES("1453"," Ветер и у нас. Солнце правда светит. Этой ночью морозчик был -2");
INSERT INTO text_bot VALUES("1454"," До этого не дойдет. У нас дожди начнутся,а там и тепло снова");
INSERT INTO text_bot VALUES("1455"," Да,это так. ");
INSERT INTO text_bot VALUES("1456"," Тоже об этом слышала. ");
INSERT INTO text_bot VALUES("1457"," Все верно. ");
INSERT INTO text_bot VALUES("1458"," Кузбасс. А ты?");
INSERT INTO text_bot VALUES("1459"," Понятно");
INSERT INTO text_bot VALUES("1460","Сообщение теперь будет висеть из бара. Не хорошо(");
INSERT INTO text_bot VALUES("1461"," Не думаю. Исправили бы уже давно");
INSERT INTO text_bot VALUES("1462"," Хорошо если исправит");
INSERT INTO text_bot VALUES("1463"," И тебе чудесного вечера");
INSERT INTO text_bot VALUES("1464"," Спасибо))");
INSERT INTO text_bot VALUES("1465"," Хорошо. День закончился практически уже. ");
INSERT INTO text_bot VALUES("1466"," Одиннадцать уже ");
INSERT INTO text_bot VALUES("1467"," День тоже уже заканчивается");
INSERT INTO text_bot VALUES("1468"," Это так)");
INSERT INTO text_bot VALUES("1469","Здравствуйте ");
INSERT INTO text_bot VALUES("1470"," и вам добрый день ");
INSERT INTO text_bot VALUES("1471"," Давай, я Валя  .красн. ");
INSERT INTO text_bot VALUES("1472"," Взаимно ");
INSERT INTO text_bot VALUES("1473"," Оренбург, а ты? ");
INSERT INTO text_bot VALUES("1474"," Как погодка? Как настроение? ");
INSERT INTO text_bot VALUES("1475"," Тож ничего, только вот дожди идут ");
INSERT INTO text_bot VALUES("1476"," Где?  .истерика. В каком регионе? ");
INSERT INTO text_bot VALUES("1477"," Посмотрим каким оно будет жарким. А почему тут никого не видать? Кроме тебя конечно же .бинокль1. ");
INSERT INTO text_bot VALUES("1478"," Так вы ещё зелёные  .прик36. ");
INSERT INTO text_bot VALUES("1479"," Спасибо за вип");
INSERT INTO text_bot VALUES("1480","Хулиганка22 .доп23. ");
INSERT INTO text_bot VALUES("1481"," Всегда есть за что ");
INSERT INTO text_bot VALUES("1482"," В такую погоду, чай горячий пью  .тыц.  ");
INSERT INTO text_bot VALUES("1483"," Конечно, обязательно  :D ");
INSERT INTO text_bot VALUES("1484"," Спасибо, хорошо. Сам как? ");
INSERT INTO text_bot VALUES("1485"," что показывают? ");
INSERT INTO text_bot VALUES("1486"," мне нужно  .глазкии. ");
INSERT INTO text_bot VALUES("1487"," моё");
INSERT INTO text_bot VALUES("1488"," мнееее ");
INSERT INTO text_bot VALUES("1489"," и эт мне ");
INSERT INTO text_bot VALUES("1490"," я жадная  .танц. И эт мне");
INSERT INTO text_bot VALUES("1491"," Огромное спасибо ");
INSERT INTO text_bot VALUES("1492"," вай, и так ещё говорят ");
INSERT INTO text_bot VALUES("1493",",да редко когда употребляют это слово ");
INSERT INTO text_bot VALUES("1494"," слово, как скажешь ");
INSERT INTO text_bot VALUES("1495","  и эти бонусы тоже мне .позор. ");
INSERT INTO text_bot VALUES("1496"," Спасибо тебе большое  .еда102. ");
INSERT INTO text_bot VALUES("1497"," .вечер23. Теперь можно и пожелать ");
INSERT INTO text_bot VALUES("1498","  .ч1. Воть тебе ");
INSERT INTO text_bot VALUES("1499","Создатель какой не воспитанный, фу как не культурно  .прик29. ");
INSERT INTO text_bot VALUES("1500"," Пожалуйста ");
INSERT INTO text_bot VALUES("1501"," Да сейчас не очень, создак ваш не уважительно относится");
INSERT INTO text_bot VALUES("1502"," Вроде бы нормальное а у вас?");
INSERT INTO text_bot VALUES("1503"," .вечер46. ");
INSERT INTO text_bot VALUES("1504"," добрый вечер  .еда9. ");
INSERT INTO text_bot VALUES("1505"," .тапки2. ");
INSERT INTO text_bot VALUES("1506","  .дайпять.  ");
INSERT INTO text_bot VALUES("1507"," да нормально :) ");
INSERT INTO text_bot VALUES("1508"," Привычка такая, извиняюсь:)");
INSERT INTO text_bot VALUES("1509"," а у вас как дела на сайте? Чего так тихо? ");
INSERT INTO text_bot VALUES("1510","Давайте тогда пить кофе  .ч1. ");
INSERT INTO text_bot VALUES("1511"," На улице гуляю, а ты чем?");
INSERT INTO text_bot VALUES("1512"," да кофе и крепкий чай :) ");
INSERT INTO text_bot VALUES("1513"," от крепкого я получаю удовольствие и тем более без сахара :) ");
INSERT INTO text_bot VALUES("1514"," а с сахаром я вкус не чувствую ");
INSERT INTO text_bot VALUES("1515"," Как зовут?");
INSERT INTO text_bot VALUES("1516"," Мы знакомы уже, я Настя");
INSERT INTO text_bot VALUES("1517"," сейчас напишу в личке");
INSERT INTO text_bot VALUES("1518"," .вечер38. ");
INSERT INTO text_bot VALUES("1519"," как тут дела? ");
INSERT INTO text_bot VALUES("1520"," знакомлюсь пока");
INSERT INTO text_bot VALUES("1521"," на форуме в играх не могу разобраться,  там тупо писать,  выигрыша ни какого?)  ");
INSERT INTO text_bot VALUES("1522"," ааааа понятно))) ");
INSERT INTO text_bot VALUES("1523"," это хорошо) ");
INSERT INTO text_bot VALUES("1524","Что то тихо  как то");
INSERT INTO text_bot VALUES("1525"," кричи,  я после тебя ");
INSERT INTO text_bot VALUES("1526"," может и так,  ну я тогда тоже завтра зайду)) ");
INSERT INTO text_bot VALUES("1527"," а что остаться?))) ");
INSERT INTO text_bot VALUES("1528"," ну так может будем знакомиться?)) ");
INSERT INTO text_bot VALUES("1529"," Елена ");
INSERT INTO text_bot VALUES("1530"," да вот думаю,  отдаться морфею)) ");
INSERT INTO text_bot VALUES("1531"," например?))) ");
INSERT INTO text_bot VALUES("1532"," За угощение ");
INSERT INTO text_bot VALUES("1533"," За угощение, но видимо забыл");
INSERT INTO text_bot VALUES("1534"," мне больше романтику показывает)) ");
INSERT INTO text_bot VALUES("1535"," это да))) ");
INSERT INTO text_bot VALUES("1536"," иногда вообще ничего не делает)) ");
INSERT INTO text_bot VALUES("1537"," вот спасибо))  какие вкусняшки)) ");
INSERT INTO text_bot VALUES("1538"," не за что)");
INSERT INTO text_bot VALUES("1539"," приятно)) ");
INSERT INTO text_bot VALUES("1540","Ну тогда спокойной ночи всем! ");
INSERT INTO text_bot VALUES("1541"," .утро6.  ");
INSERT INTO text_bot VALUES("1542"," .утро12.  ");
INSERT INTO text_bot VALUES("1543"," как утреннее настроение?");
INSERT INTO text_bot VALUES("1544"," у меня более менее. Как погодка?");
INSERT INTO text_bot VALUES("1545"," а у на прохладно и дождь идёт.");
INSERT INTO text_bot VALUES("1546"," на целую неделю.");
INSERT INTO text_bot VALUES("1547"," ну это понятно что потеплеет.");
INSERT INTO text_bot VALUES("1548"," как спалось? ");
INSERT INTO text_bot VALUES("1549"," отлично)) ");
INSERT INTO text_bot VALUES("1550","Это что спят ещё все??)) ");
INSERT INTO text_bot VALUES("1551"," и долго ждать когда зайдут? ");
INSERT INTO text_bot VALUES("1552"," или походу мы с тобой тут втроём)))) ");
INSERT INTO text_bot VALUES("1553"," они то заходят в гостевой нет никого ");
INSERT INTO text_bot VALUES("1554"," я же и говорю сидим тут ты,  я и Ботя))) ");
INSERT INTO text_bot VALUES("1555"," я и общаюсь только тишина))) ");
INSERT INTO text_bot VALUES("1556"," вот и Ботя появился))) ");
INSERT INTO text_bot VALUES("1557"," ладно пошла я))) ");
INSERT INTO text_bot VALUES("1558"," куда нибудь))) ");
INSERT INTO text_bot VALUES("1559"," да скучно тут)) ");
INSERT INTO text_bot VALUES("1560"," Ботя ваш начинает бесить))) ");
INSERT INTO text_bot VALUES("1561"," я поняла,  а отключить ни как? ");
INSERT INTO text_bot VALUES("1562","Эй,  народ выходим не стесняемся))) ");
INSERT INTO text_bot VALUES("1563"," отключить,  чтобы к юзеру он не обращался ");
INSERT INTO text_bot VALUES("1564"," постараюсь)) ");
INSERT INTO text_bot VALUES("1565"," Спасибо, взаимно ");
INSERT INTO text_bot VALUES("1566"," Да ничего вроде, хорошо. А у тебя? ");
INSERT INTO text_bot VALUES("1567"," Телевизор смотрю и тут");
INSERT INTO text_bot VALUES("1568"," сериал (Дикий) ");
INSERT INTO text_bot VALUES("1569","Опять тишина))) ");
INSERT INTO text_bot VALUES("1570"," я и так тут одна торчу в гостевой))) ");
INSERT INTO text_bot VALUES("1571","  в гостевой я одна в основном )) ");
INSERT INTO text_bot VALUES("1572"," ах да))) ");
INSERT INTO text_bot VALUES("1573","Доброго всем дня и приятного общения)) ");
INSERT INTO text_bot VALUES("1574"," Интересный ");
INSERT INTO text_bot VALUES("1575"," и это мне");
INSERT INTO text_bot VALUES("1576"," спасибки))");
INSERT INTO text_bot VALUES("1577"," .еда3.  эт тебе");
INSERT INTO text_bot VALUES("1578"," спасиб,как настройчик");
INSERT INTO text_bot VALUES("1579"," да так,но жить можн)))");
INSERT INTO text_bot VALUES("1580"," до было жарко,а сейчас не ахти похолодало да тучи бродят.у вас чего с ней?");
INSERT INTO text_bot VALUES("1581"," мне ...");
INSERT INTO text_bot VALUES("1582"," мнеее");
INSERT INTO text_bot VALUES("1583"," мне.дум.");
INSERT INTO text_bot VALUES("1584"," а мне можно.лол.");
INSERT INTO text_bot VALUES("1585"," .ура2.  ");
INSERT INTO text_bot VALUES("1586","  .ржу3. ");
INSERT INTO text_bot VALUES("1587"," вообще суперский котик.лол.");
INSERT INTO text_bot VALUES("1588"," неа нихочу. А ты?");
INSERT INTO text_bot VALUES("1589"," как в сказке у А.Пушкина кота-ученого,тогда можно.лол.");
INSERT INTO text_bot VALUES("1590"," агась,заместо плеера будет.лол. С ним уж точно не соскучишься.лол.");
INSERT INTO text_bot VALUES("1591"," .ржу.");
INSERT INTO text_bot VALUES("1592"," с таким котом точно учёной будешь.лол.");
INSERT INTO text_bot VALUES("1593"," чёт нас на сказки занесло.лол.");
INSERT INTO text_bot VALUES("1594"," наверное,а я очень люблю сказки.");
INSERT INTO text_bot VALUES("1595"," сказки можно смотреть всем поколением");
INSERT INTO text_bot VALUES("1596"," , чем занимаешься сейчас?");
INSERT INTO text_bot VALUES("1597"," ты знаешь,я же на работе.");
INSERT INTO text_bot VALUES("1598","Ucuf");
INSERT INTO text_bot VALUES("1599","N jcjc");
INSERT INTO text_bot VALUES("1600"," .неспать. доброе утро ");
INSERT INTO text_bot VALUES("1601"," .дутро38.  ");
INSERT INTO text_bot VALUES("1602","Доброе утро ");
INSERT INTO text_bot VALUES("1603"," И тебе хорошего дня ");
INSERT INTO text_bot VALUES("1604"," Всё как обычно, уборка, готовка");
INSERT INTO text_bot VALUES("1605"," Нет немного");
INSERT INTO text_bot VALUES("1606"," Да");
INSERT INTO text_bot VALUES("1607"," Да сегодня тепло, солнце, а у вас какая погода?");
INSERT INTO text_bot VALUES("1608"," Сё кричишь так!?  .прик99. ");
INSERT INTO text_bot VALUES("1609"," И как? Услышали .тыц.  ");
INSERT INTO text_bot VALUES("1610"," .зеркало2.  значит со слухом всё хорошо у меня ");
INSERT INTO text_bot VALUES("1611","Всем Привет :)");
INSERT INTO text_bot VALUES("1612"," что у вас тут интересного?");
INSERT INTO text_bot VALUES("1613"," гулять ходила ");
INSERT INTO text_bot VALUES("1614"," Кидай!?)");
INSERT INTO text_bot VALUES("1615"," Благодарочка.");
INSERT INTO text_bot VALUES("1616"," Мине..");
INSERT INTO text_bot VALUES("1617"," Ооо фсе богатые!?).лол.тода мне!");
INSERT INTO text_bot VALUES("1618"," я знаю тебя по нику :D");
INSERT INTO text_bot VALUES("1619"," Чёткому подари :) ");
INSERT INTO text_bot VALUES("1620"," моё подарком Чёткому :) это моё пожелание");
INSERT INTO text_bot VALUES("1621"," мне ,нет)");
INSERT INTO text_bot VALUES("1622"," я захотела подарить их просто");
INSERT INTO text_bot VALUES("1623","Эти моё )");
INSERT INTO text_bot VALUES("1624"," мнеееее");
INSERT INTO text_bot VALUES("1625"," тоже мне никого больше нет.ах.");
INSERT INTO text_bot VALUES("1626"," я больше не буду ловить пусть другие ловят");
INSERT INTO text_bot VALUES("1627"," Всем.ор..вечер45. ");
INSERT INTO text_bot VALUES("1628"," привет :13. ");
INSERT INTO text_bot VALUES("1629"," вооооще то норм,а мы знакомы.дум.");
INSERT INTO text_bot VALUES("1630"," ну этттттда.лол.а как тебя зовут..");
INSERT INTO text_bot VALUES("1631"," тогда поняла,как дела у тебя..");
INSERT INTO text_bot VALUES("1632"," у меня все ок..");
INSERT INTO text_bot VALUES("1633",".миг.Ути какая память!?)Спасиб за балы.");
INSERT INTO text_bot VALUES("1634"," чо кричим.лол.");
INSERT INTO text_bot VALUES("1635"," а они все равно не слышат,у них в наушниках музыка играет.лол.");
INSERT INTO text_bot VALUES("1636"," так это везде так говорят..");
INSERT INTO text_bot VALUES("1637"," конечно будут....тогда можешь еще покричать...");
INSERT INTO text_bot VALUES("1638"," .ч1.  не кричи");
INSERT INTO text_bot VALUES("1639"," Ну не хотят иль не общитеные  .зуб. ");
INSERT INTO text_bot VALUES("1640"," Всё возможно ");
INSERT INTO text_bot VALUES("1641"," Обязательно ");
INSERT INTO text_bot VALUES("1642"," постирушки затеяла на ночь глядя  .д.д4. ");
INSERT INTO text_bot VALUES("1643","КрохА .доп15. ");
INSERT INTO text_bot VALUES("1644"," Та не, малость осталось");
INSERT INTO text_bot VALUES("1645"," эт точно. ");
INSERT INTO text_bot VALUES("1646"," Да нет. Если только от безделья ");
INSERT INTO text_bot VALUES("1647"," К чему? ");
INSERT INTO text_bot VALUES("1648"," О нет, эт теперь завтра. ");
INSERT INTO text_bot VALUES("1649"," Обязательно. Без этого никак ");
INSERT INTO text_bot VALUES("1650"," хлопоты да и только ");
INSERT INTO text_bot VALUES("1651","LOVE ME .доп11. ");
INSERT INTO text_bot VALUES("1652"," Ну это же здорово, когда чем то занимаешься ");
INSERT INTO text_bot VALUES("1653"," приветик! Спасибо большое! .цвет40. ");
INSERT INTO text_bot VALUES("1654"," Приветик, всегда пожалуйста  .цвет35. ");
INSERT INTO text_bot VALUES("1655"," Вообще пролетает ");
INSERT INTO text_bot VALUES("1656"," Тааак рассказывай, что с погодой у тебя? ");
INSERT INTO text_bot VALUES("1657"," меня Снежана зовут. .улыбка. ");
INSERT INTO text_bot VALUES("1658"," Красотища, тепло .танц. ");
INSERT INTO text_bot VALUES("1659"," А я Валя ");
INSERT INTO text_bot VALUES("1660"," привет! Спасибо!. улыбка.");
INSERT INTO text_bot VALUES("1661"," приятно познакомиться! .цвет5. ");
INSERT INTO text_bot VALUES("1662"," тебя как зовут? .глазами. ");
INSERT INTO text_bot VALUES("1663"," а меня Снежана или просто Снежка. .глазами. ");
INSERT INTO text_bot VALUES("1664"," взаимно! .глазами. ");
INSERT INTO text_bot VALUES("1665"," да вроде нормуль.А у тебя!");
INSERT INTO text_bot VALUES("1666"," так отдохни!");
INSERT INTO text_bot VALUES("1667"," спасибо большое! Умничка,что отдыхаешь!");
INSERT INTO text_bot VALUES("1668"," ага, отдохнёшь тут.И огород и дела домашние.");
INSERT INTO text_bot VALUES("1669"," ну да.Ты прав!");
INSERT INTO text_bot VALUES("1670"," приходится...А что делать остаётся...");
INSERT INTO text_bot VALUES("1671"," .цвет23.  Взаимно ");
INSERT INTO text_bot VALUES("1672"," что делаешь?");
INSERT INTO text_bot VALUES("1673"," спасибо большое!");
INSERT INTO text_bot VALUES("1674"," музыку слушаю и с тобой общаюсь.");
INSERT INTO text_bot VALUES("1675"," Энигму. .глазами. ");
INSERT INTO text_bot VALUES("1676"," да.У них красивая музыка.");
INSERT INTO text_bot VALUES("1677"," песни тоже есть.");
INSERT INTO text_bot VALUES("1678"," мне тоже нравится как саксофон играет...");
INSERT INTO text_bot VALUES("1679"," я с тобой согласна!");
INSERT INTO text_bot VALUES("1680"," нет.Люблю ещё группы 90-х годов.");
INSERT INTO text_bot VALUES("1681"," ты тут?");
INSERT INTO text_bot VALUES("1682"," .дутро41. Всем");
INSERT INTO text_bot VALUES("1683"," Спасибо большое за помощь  .чаек. ");
INSERT INTO text_bot VALUES("1684"," да я и так знаю пороль");
INSERT INTO text_bot VALUES("1685"," Ну это я знаю. С твоей помощью ");
INSERT INTO text_bot VALUES("1686"," хорошо, сам как? ");
INSERT INTO text_bot VALUES("1687"," Ну и замечательно ");
INSERT INTO text_bot VALUES("1688"," Чаи распиваю .еда90. ");
INSERT INTO text_bot VALUES("1689"," Спасибо. Ты с утра тут что-ли? ");
INSERT INTO text_bot VALUES("1690"," а помошница твоя где? ");
INSERT INTO text_bot VALUES("1691"," Отлично, сам как? ");
INSERT INTO text_bot VALUES("1692"," ну давай поговорим ");
INSERT INTO text_bot VALUES("1693"," Та не кричи, ты .моргает1. ");
INSERT INTO text_bot VALUES("1694"," Ну не хотят, что ж теперь ");
INSERT INTO text_bot VALUES("1695","[marquee] .бонус3.  Ловим[/marquee]");
INSERT INTO text_bot VALUES("1696","Никому не нужно? ");
INSERT INTO text_bot VALUES("1697"," Та нее, богатые все просто  .оченьдоволен. ");
INSERT INTO text_bot VALUES("1698"," Ну просто никому не нужно и всё. Мне лучше .ах. ");
INSERT INTO text_bot VALUES("1699"," пошли в почту ");
INSERT INTO text_bot VALUES("1700","Мама - лошадь, а папа - осел.\r\nКакой же ребенок от пары пошел? .бон56. ");
INSERT INTO text_bot VALUES("1701"," создачка сайта и получилась.лол.");
INSERT INTO text_bot VALUES("1702"," мул .цвет34. ");
INSERT INTO text_bot VALUES("1703"," .доп24.  верни умничка  .цвет30. ");
INSERT INTO text_bot VALUES("1704"," спасибо .цвет40. ");
INSERT INTO text_bot VALUES("1705"," Всегда пожалуйста ");
INSERT INTO text_bot VALUES("1706","КофеСоСливками .доп14. ");
INSERT INTO text_bot VALUES("1707"," .ддень5. Всем");
INSERT INTO text_bot VALUES("1708"," Чего с настроением? ");
INSERT INTO text_bot VALUES("1709","ЗАГАДКА : По лужку он важно бродит,\r\nИз воды сухим выходит,\r\nНосит красные ботинки,\r\nДарит мягкие перинки. .бон44. ");
INSERT INTO text_bot VALUES("1710"," .прик53. Аууууу ");
INSERT INTO text_bot VALUES("1711","Всем удачи!!! ");
INSERT INTO text_bot VALUES("1712","Уходишь? ");
INSERT INTO text_bot VALUES("1713"," Что случилось? ");
INSERT INTO text_bot VALUES("1714"," .день5. ");
INSERT INTO text_bot VALUES("1715"," Приветик  .цвет28. ");
INSERT INTO text_bot VALUES("1716"," приветик милая. .цвет33. ");
INSERT INTO text_bot VALUES("1717"," привет.Как ты?");
INSERT INTO text_bot VALUES("1718"," да нормально.Вот только недавно с огорода в дом заползла.У тебя как дела?");
INSERT INTO text_bot VALUES("1719"," вроде бы нормально.В огороде работала.");
INSERT INTO text_bot VALUES("1720"," а мне можно картинку на ник? .ах. У меня много картинок есть. .глазами. ");
INSERT INTO text_bot VALUES("1721"," и цветы ещё сажала ");
INSERT INTO text_bot VALUES("1722"," Да нормально ");
INSERT INTO text_bot VALUES("1723","[marquee] .бон50. [/marquee]");
INSERT INTO text_bot VALUES("1724"," мне пожалуйста..ор.");
INSERT INTO text_bot VALUES("1725"," мне.лол.");
INSERT INTO text_bot VALUES("1726"," спасибки");
INSERT INTO text_bot VALUES("1727","ЗАГАДКА :Чем можно поделиться только один раз? .бон78. ");
INSERT INTO text_bot VALUES("1728"," Секретом ");
INSERT INTO text_bot VALUES("1729","И тишина  )))");
INSERT INTO text_bot VALUES("1730"," ничего, я не спешу  .ялапа.  ");
INSERT INTO text_bot VALUES("1731"," благодарочка  .миг. ");
INSERT INTO text_bot VALUES("1732"," давайте знакомиться что ли :-D я Ангелина ");
INSERT INTO text_bot VALUES("1733"," Так точно  .миг.  Мое любимое имя кстати Руслан  .ура2. ");
INSERT INTO text_bot VALUES("1734"," Мне  .ор. ");
INSERT INTO text_bot VALUES("1735"," моего брата так зовут  .зуб. ");
INSERT INTO text_bot VALUES("1736","Как бота убрать?  .ор. ");
INSERT INTO text_bot VALUES("1737"," я знаю что такое бот))  не очень хочется чтоб писал всякую хрень  .ржу. ");
INSERT INTO text_bot VALUES("1738"," мне..ор.");
INSERT INTO text_bot VALUES("1739"," .яху.");
INSERT INTO text_bot VALUES("1740"," мне..ор ");
INSERT INTO text_bot VALUES("1741"," спасибо большое!.ор.");
INSERT INTO text_bot VALUES("1742"," мне пожалуйста.");
INSERT INTO text_bot VALUES("1743"," ну а кому же ещё?.ах.");
INSERT INTO text_bot VALUES("1744"," тоже мне пожалуйста.");
INSERT INTO text_bot VALUES("1745"," Мене");
INSERT INTO text_bot VALUES("1746"," мне.");
INSERT INTO text_bot VALUES("1747"," спасибо! .глазами. ");
INSERT INTO text_bot VALUES("1748"," чай пью с мятой.А ты что делаешь?");
INSERT INTO text_bot VALUES("1749"," спасибо, солнце!А что за сериал?");
INSERT INTO text_bot VALUES("1750"," хорошо.");
INSERT INTO text_bot VALUES("1751"," я написала.");
INSERT INTO text_bot VALUES("1752"," умничка!Что всё хорошо!");
INSERT INTO text_bot VALUES("1753"," половину пролила.Столик случайно двинула. .ржу. ");
INSERT INTO text_bot VALUES("1754"," скорее всего.");
INSERT INTO text_bot VALUES("1755"," ну да, ты прав. .бла2. ");
INSERT INTO text_bot VALUES("1756"," спасибо большое!Я кофе с мороженым люблю..ах.");
INSERT INTO text_bot VALUES("1757"," так попробуй. .глазами. ");
INSERT INTO text_bot VALUES("1758"," спасибо .ор.");
INSERT INTO text_bot VALUES("1759","Zadira .доп8. ");
INSERT INTO text_bot VALUES("1760"," прям и всегда!? .миг.");
INSERT INTO text_bot VALUES("1761"," я запомнила .ах. .ржу.");
INSERT INTO text_bot VALUES("1762"," .вечер34. Всем");
INSERT INTO text_bot VALUES("1763"," .зашторой. ");
INSERT INTO text_bot VALUES("1764"," Кого высматриваешь?  .еда99. ");
INSERT INTO text_bot VALUES("1765"," сижу в засаде..ржу.");
INSERT INTO text_bot VALUES("1766"," Аааа, сети расставила?  .вкресле2. ");
INSERT INTO text_bot VALUES("1767"," ну иди уже,пописай..ржу.");
INSERT INTO text_bot VALUES("1768"," ага огромные сети. .глазами. ");
INSERT INTO text_bot VALUES("1769"," А сё покраснела?  .прик36. ");
INSERT INTO text_bot VALUES("1770"," а это я морковкой намазалась..ржу.");
INSERT INTO text_bot VALUES("1771"," нормально.А ты чего грустный такой?");
INSERT INTO text_bot VALUES("1772"," свеклы нет.В магазин надо идти..ржу.");
INSERT INTO text_bot VALUES("1773"," рада за тебя!");
INSERT INTO text_bot VALUES("1774"," ага и прибежала..ор.");
INSERT INTO text_bot VALUES("1775"," спасибо милая! .цвет12. ");
INSERT INTO text_bot VALUES("1776"," это ты кому?.ржу.");
INSERT INTO text_bot VALUES("1777","эх...а я подумала....ах.");
INSERT INTO text_bot VALUES("1778"," .бееее.   ");
INSERT INTO text_bot VALUES("1779"," а что нельзя? .бла2. ");
INSERT INTO text_bot VALUES("1780"," бягу..ржу.");
INSERT INTO text_bot VALUES("1781"," забыла куда бежать. .глазами. ");
INSERT INTO text_bot VALUES("1782"," зачем?А я по другому подумала...");
INSERT INTO text_bot VALUES("1783"," а вдруг тебе не понравится как я подумала?.ах.");
INSERT INTO text_bot VALUES("1784"," нет.Наоборот хорошее!.ор.");
INSERT INTO text_bot VALUES("1785"," в беседке что ли?.ах.");
INSERT INTO text_bot VALUES("1786"," я стисняюсь..ржу.\r\n.");
INSERT INTO text_bot VALUES("1787"," а я уже не стисняюсь.");
INSERT INTO text_bot VALUES("1788"," я подумала а чего стесняться?.ах.");
INSERT INTO text_bot VALUES("1789"," я считаю что в этом нет ничего постыдного..ах.");
INSERT INTO text_bot VALUES("1790"," я рада очень что всё хорошо!");
INSERT INTO text_bot VALUES("1791"," .еа. ");
INSERT INTO text_bot VALUES("1792"," да сама незнаю почему...");
INSERT INTO text_bot VALUES("1793"," как тебе графник?");
INSERT INTO text_bot VALUES("1794","супер! Спасибо большое!");
INSERT INTO text_bot VALUES("1795"," нет никакой причины. .бла2. ");
INSERT INTO text_bot VALUES("1796","что делаешь?");
INSERT INTO text_bot VALUES("1797"," а я как Юлий Цезарь.Несколько дел одновременно.Сериал смотрю, картину делаю и здесь..ржу.");
INSERT INTO text_bot VALUES("1798"," спасибо милая! .цвет7. ");
INSERT INTO text_bot VALUES("1799"," ну почти.Только одним глазом здесь,а одним в телевизоре.");
INSERT INTO text_bot VALUES("1800","[color=DarkSlateBlue] Всем по привету![/color]");
INSERT INTO text_bot VALUES("1801"," привет Зараза!");
INSERT INTO text_bot VALUES("1802"," приветики и тебе");
INSERT INTO text_bot VALUES("1803"," что то у меня этот сайт долго открывается");
INSERT INTO text_bot VALUES("1804"," хз , дела нормально , как зовут? ");
INSERT INTO text_bot VALUES("1805"," та вот по сайтам бегаю , незнаю, где остановиться?");
INSERT INTO text_bot VALUES("1806"," взаимно Руся , пойдёт у меня");
INSERT INTO text_bot VALUES("1807"," это да! , а тебя как зовут ?");
INSERT INTO text_bot VALUES("1808"," посмотрим там , я ещё не все посмотрела ");
INSERT INTO text_bot VALUES("1809"," написанно же.ржу.");
INSERT INTO text_bot VALUES("1810"," а если я матюкаюсь-))?");
INSERT INTO text_bot VALUES("1811"," Оля меня зовут ");
INSERT INTO text_bot VALUES("1812"," бывает вырывается случайнно");
INSERT INTO text_bot VALUES("1813"," взаимненько , чего не спишь?");
INSERT INTO text_bot VALUES("1814"," я щас приду , пойду себе картинку найду");
INSERT INTO text_bot VALUES("1815"," а сколько у тебя времени?");
INSERT INTO text_bot VALUES("1816"," спасибо большое! .цвет10. ");
INSERT INTO text_bot VALUES("1817"," а у нас .2.05");
INSERT INTO text_bot VALUES("1818"," а кто поставит ?");
INSERT INTO text_bot VALUES("1819"," давай я поставлю графник");
INSERT INTO text_bot VALUES("1820"," ща  скину");
INSERT INTO text_bot VALUES("1821"," закидывай");
INSERT INTO text_bot VALUES("1822"," спасибочки");
INSERT INTO text_bot VALUES("1823"," опередил меня.лол.");
INSERT INTO text_bot VALUES("1824","Правда незнаю , какой у вас размер тут");
INSERT INTO text_bot VALUES("1825"," хорошо, рассказывай");
INSERT INTO text_bot VALUES("1826","Что-нибудь");
INSERT INTO text_bot VALUES("1827"," доброго,спасибо,взаимно");
INSERT INTO text_bot VALUES("1828"," Доброе утро,  хватит кричать))) ");
INSERT INTO text_bot VALUES("1829"," .утро9.   ты чего кричишь?");
INSERT INTO text_bot VALUES("1830"," ты чего раскричался, всех по ходе на уши поднял.лол.");
INSERT INTO text_bot VALUES("1831"," ну все спят наверное.лол.");
INSERT INTO text_bot VALUES("1832","ну может быть.лол.");
INSERT INTO text_bot VALUES("1833"," .дутро30. ");
INSERT INTO text_bot VALUES("1834"," приветик.Да никак не проснусь...Ты как?");
INSERT INTO text_bot VALUES("1835"," привет. .бла2. ");
INSERT INTO text_bot VALUES("1836"," .день12. \r\nВсем спасибо за теплый прием.ор.");
INSERT INTO text_bot VALUES("1837"," Приветики-пистолетики-)) спасибо большущее.зуб. Как оно?)");
INSERT INTO text_bot VALUES("1838"," конечно о любви)))");
INSERT INTO text_bot VALUES("1839"," у меня всегда супер-пупер.во.");
INSERT INTO text_bot VALUES("1840"," привет!.ор.");
INSERT INTO text_bot VALUES("1841","Приветик всем. Спасибо за приëм)");
INSERT INTO text_bot VALUES("1842","Как у вас сдесь с настроением?) .дайпять.  ");
INSERT INTO text_bot VALUES("1843","Всем привет!.ор.");
INSERT INTO text_bot VALUES("1844"," услышал...До этого тебе кричала,не услышал.");
INSERT INTO text_bot VALUES("1845"," умничка! Как ты?");
INSERT INTO text_bot VALUES("1846"," тоже вроде всё хорошо. .бла2. ");
INSERT INTO text_bot VALUES("1847"," тож норма. ");
INSERT INTO text_bot VALUES("1848"," да на работе. Думаю поработать малость))) ");
INSERT INTO text_bot VALUES("1849","Девушка укравшая мя в гарем,,, приветик!!!! ");
INSERT INTO text_bot VALUES("1850"," у меня ночная работа) ");
INSERT INTO text_bot VALUES("1851"," приветик!");
INSERT INTO text_bot VALUES("1852"," спасибочки! .поцелуй2. ");
INSERT INTO text_bot VALUES("1853","за всё!.ах.");
INSERT INTO text_bot VALUES("1854"," ну это ты так думаешь...");
INSERT INTO text_bot VALUES("1855"," потом скажу.");
INSERT INTO text_bot VALUES("1856"," не забуду и захочу. .бла2. ");
INSERT INTO text_bot VALUES("1857"," мне баллы..ор.");
INSERT INTO text_bot VALUES("1858"," спасибо! .цвет5. ");
INSERT INTO text_bot VALUES("1859","  .по13. ");
INSERT INTO text_bot VALUES("1860"," спасибо!Что делаешь?");
INSERT INTO text_bot VALUES("1861"," новости по телеку слушаю.Завтра я с родителями на дачу поеду.Не знаю получится у меня завтра зайти сюда или нет,там инет плохо тянет.Но буду пытаться зайти!");
INSERT INTO text_bot VALUES("1862"," мне так не хочется ехать.Капец.");
INSERT INTO text_bot VALUES("1863"," не получится не ехать...");
INSERT INTO text_bot VALUES("1864"," ага, особенно мама.");
INSERT INTO text_bot VALUES("1865"," как дела");
INSERT INTO text_bot VALUES("1866"," не поверит...");
INSERT INTO text_bot VALUES("1867"," привет. .цвет33. ");
INSERT INTO text_bot VALUES("1868"," приветик  .цвет32. ");
INSERT INTO text_bot VALUES("1869"," тоже хорошо все");
INSERT INTO text_bot VALUES("1870"," с детьми занемаюсь");
INSERT INTO text_bot VALUES("1871"," я тут. .бла2. ");
INSERT INTO text_bot VALUES("1872"," нормально.Ты там как,чем занят?");
INSERT INTO text_bot VALUES("1873"," можно сказать что отдыхаю... Только надо сейчас картошку сварить.");
INSERT INTO text_bot VALUES("1874"," скоро буду, солнце.");
INSERT INTO text_bot VALUES("1875"," я тут.");
INSERT INTO text_bot VALUES("1876"," да.");
INSERT INTO text_bot VALUES("1877"," да.Фильм по телеку идёт Русалка,озеро мёртвых.Так там громко закричали что то,а я от неожиданности чуть под диван не спряталась..ржу.");
INSERT INTO text_bot VALUES("1878"," ага,страшная русалка из воды вылазит,а парень орёт во всё горло.");
INSERT INTO text_bot VALUES("1879"," канал называется Наше новое кино.");
INSERT INTO text_bot VALUES("1880"," капец.У нас тут дождь сильный начался,прям ливень.");
INSERT INTO text_bot VALUES("1881"," завтра утром видно будет... Лучше бы этот дождь завтра с утра пошол..ржу.");
INSERT INTO text_bot VALUES("1882"," а мы что тут с тобой одни сейчас?.ах.");
INSERT INTO text_bot VALUES("1883"," ага а завтра как назло дождя не будет.");
INSERT INTO text_bot VALUES("1884"," да тут только ты да я,да мы с тобой..ржу.");
INSERT INTO text_bot VALUES("1885"," ты без настроения или мне показалось?");
INSERT INTO text_bot VALUES("1886"," ну значит мне показалось. :) ");
INSERT INTO text_bot VALUES("1887"," всё хорошо.");
INSERT INTO text_bot VALUES("1888"," да ничем.Тут с тобой.");
INSERT INTO text_bot VALUES("1889"," не очень.Но есть немного...");
INSERT INTO text_bot VALUES("1890"," ты там что делаешь?");
INSERT INTO text_bot VALUES("1891"," тоже самое...");
INSERT INTO text_bot VALUES("1892"," ну у меня ещё можно сказать что не ночь.");
INSERT INTO text_bot VALUES("1893"," а поздний вечер..ржу.");
INSERT INTO text_bot VALUES("1894"," 23:30.А у тебя?");
INSERT INTO text_bot VALUES("1895"," ну значит ещё не ночь...");
INSERT INTO text_bot VALUES("1896"," ага.А в полночь все нечистые силы на охоту вылетают.Ведьмы,вампиры и так далее.Это меня в детстве так пугали,что я спала..ржу.");
INSERT INTO text_bot VALUES("1897"," так я под одеяло с фонариком пряталась.");
INSERT INTO text_bot VALUES("1898"," ты там не спишь ещё?");
INSERT INTO text_bot VALUES("1899"," когда спать собираешься?");
INSERT INTO text_bot VALUES("1900"," я тоже.С тобой ещё побуду!");
INSERT INTO text_bot VALUES("1901"," хорошего вечера и замечательно прекрасного настроения как себя чувствуешь))) ");
INSERT INTO text_bot VALUES("1902"," разрешаешь значит?");
INSERT INTO text_bot VALUES("1903"," спасибо!А мы знакомы??");
INSERT INTO text_bot VALUES("1904"," Роман я))) приятного общения. ");
INSERT INTO text_bot VALUES("1905"," ещё бы ты меня прогнал... .бла2. ");
INSERT INTO text_bot VALUES("1906"," я знаю! :) ");
INSERT INTO text_bot VALUES("1907"," ты очень хороший,ты....ах.");
INSERT INTO text_bot VALUES("1908"," всем!");
INSERT INTO text_bot VALUES("1909"," всегда пожалуйста! :) ");
INSERT INTO text_bot VALUES("1910"," нет.Уже закончился. .еа. ");
INSERT INTO text_bot VALUES("1911"," походу что поедем всё таки.");
INSERT INTO text_bot VALUES("1912"," ты уходишь?!");
INSERT INTO text_bot VALUES("1913"," спатки пойдёшь?");
INSERT INTO text_bot VALUES("1914"," тогда наверное спокойной ночи и сладких снов!");
INSERT INTO text_bot VALUES("1915"," спасибо солнце! Завтра утром зайду. А потом в обед постараюсь зайти или уже после обеда.");
INSERT INTO text_bot VALUES("1916","))))))) ");
INSERT INTO text_bot VALUES("1917"," привет!Как спалось?");
INSERT INTO text_bot VALUES("1918"," тоже нормально.");
INSERT INTO text_bot VALUES("1919","Мне");
INSERT INTO text_bot VALUES("1920"," мои");
INSERT INTO text_bot VALUES("1921"," мнееееее");
INSERT INTO text_bot VALUES("1922","Хде весеннее.ор.");
INSERT INTO text_bot VALUES("1923","Хто делае графник");
INSERT INTO text_bot VALUES("1924"," .дум. хде весенние");
INSERT INTO text_bot VALUES("1925"," дай ссылку");
INSERT INTO text_bot VALUES("1926"," я тоже могу но не могу");
INSERT INTO text_bot VALUES("1927"," пасибки за подсказку и за монеты");
INSERT INTO text_bot VALUES("1928"," как настроение");
INSERT INTO text_bot VALUES("1929"," тоже мне");
INSERT INTO text_bot VALUES("1930"," не очень");
INSERT INTO text_bot VALUES("1931"," рубли тоже дай");
INSERT INTO text_bot VALUES("1932","Лан я пошла зайду позже");
INSERT INTO text_bot VALUES("1933"," мои )");
INSERT INTO text_bot VALUES("1934"," и этот до кучи )");
INSERT INTO text_bot VALUES("1935"," и опять мои ))");
INSERT INTO text_bot VALUES("1936"," благодарствую за дары ! )");
INSERT INTO text_bot VALUES("1937","Ну эт в копилку )");
INSERT INTO text_bot VALUES("1938","Мои канеш ))");
INSERT INTO text_bot VALUES("1939"," ,мне");
INSERT INTO text_bot VALUES("1940"," мой, раз нет жклающих )");
INSERT INTO text_bot VALUES("1941"," б л а г о д а р ю !! )");
INSERT INTO text_bot VALUES("1942"," серице в пятки бежит от крика твоего )))");
INSERT INTO text_bot VALUES("1943"," ой, да мы сами кого хошь напугаем, особо с утра пораньше ))");
INSERT INTO text_bot VALUES("1944"," а то ! Красота то — страшная сила .ирония.");
INSERT INTO text_bot VALUES("1945"," дак боженька то не дурак, вы — вумные, а мы красявые )))");
INSERT INTO text_bot VALUES("1946"," шла бы домой пинилопа )))))");
INSERT INTO text_bot VALUES("1947"," вашпет я в общем )\r\nДве ж очереди было )))");
INSERT INTO text_bot VALUES("1948"," над ботвиновну угостить чёб не бухтела )))");
INSERT INTO text_bot VALUES("1949"," хай глыкает христовенькая )))");
INSERT INTO text_bot VALUES("1950"," да в курсях за ботов ))");
INSERT INTO text_bot VALUES("1951"," стесняется наверное.лол.");
INSERT INTO text_bot VALUES("1952","Тест");
INSERT INTO text_bot VALUES("1953"," новый мод ставил");
INSERT INTO text_bot VALUES("1954","Всем привет! :) ");
INSERT INTO text_bot VALUES("1955"," нет на главную действие пользователей можешь посмотреть внизу всех игр стоит");
INSERT INTO text_bot VALUES("1956"," привет.Я же тебе говорила что я на даче сегодня и тут инет плохой.");
INSERT INTO text_bot VALUES("1957"," как ты?");
INSERT INTO text_bot VALUES("1958"," нет.На даче.Завтра дома буду.");
INSERT INTO text_bot VALUES("1959"," устала.Еле до кровати доползла.");
INSERT INTO text_bot VALUES("1960"," сажали,пололи.");
INSERT INTO text_bot VALUES("1961"," у нас два участка здесь.10 соток и 6.");
INSERT INTO text_bot VALUES("1962"," капец.Инет то появится,то исчезнет.");
INSERT INTO text_bot VALUES("1963",".лол. ");
INSERT INTO text_bot VALUES("1964"," ботя тебя ищу.лол2.");
INSERT INTO text_bot VALUES("1965","Въехать по самое не хочу))) ");
INSERT INTO text_bot VALUES("1966","Как делишки доброго времени суток.кур. ");
INSERT INTO text_bot VALUES("1967"," это ты там на фриз? Тоже с причёской такой)))? ");
INSERT INTO text_bot VALUES("1968"," точнее фоиз");
INSERT INTO text_bot VALUES("1969"," до вышки далеко надо идти.");
INSERT INTO text_bot VALUES("1970"," а причём тут это бегаешь ты или нет я все голишь спросил не более ты не ты. ");
INSERT INTO text_bot VALUES("1971"," доброй ночки ");
INSERT INTO text_bot VALUES("1972"," сам от куда будешь. ");
INSERT INTO text_bot VALUES("1973"," у меня тоже отлично.");
INSERT INTO text_bot VALUES("1974"," ну да");
INSERT INTO text_bot VALUES("1975"," краснодарский края. А лет тебе сколько ");
INSERT INTO text_bot VALUES("1976"," серьёзно))) на фото не ты? Ава которая ");
INSERT INTO text_bot VALUES("1977"," днем дождик был, а к вечеру погода наладилась.");
INSERT INTO text_bot VALUES("1978"," так все спать пошли.");
INSERT INTO text_bot VALUES("1979"," немного хочу.А ты?");
INSERT INTO text_bot VALUES("1980"," ну и с тобой хочется побыть..ах.");
INSERT INTO text_bot VALUES("1981"," что делал сегодня?");
INSERT INTO text_bot VALUES("1982"," чем занимался днем!");
INSERT INTO text_bot VALUES("1983","Всем привет поставил новую фортуну ценим проверяем)");
INSERT INTO text_bot VALUES("1984"," .драка11. ");
INSERT INTO text_bot VALUES("1985"," не кого");
INSERT INTO text_bot VALUES("1986","Да)");
INSERT INTO text_bot VALUES("1987"," угу)");
INSERT INTO text_bot VALUES("1988"," привет милая.Мне..ор.");
INSERT INTO text_bot VALUES("1989"," как ты? .цвет26. ");
INSERT INTO text_bot VALUES("1990"," устала немного.С дачи недавно приехала.А так всё хорошо!");
INSERT INTO text_bot VALUES("1991"," ага.Пропахала как трактор все грядки.. ржу.");
INSERT INTO text_bot VALUES("1992"," не кричи,я тут.");
INSERT INTO text_bot VALUES("1993"," .пох. ");
INSERT INTO text_bot VALUES("1994"," кричал легонько,а я услышала.");
INSERT INTO text_bot VALUES("1995"," здравствуй.");
INSERT INTO text_bot VALUES("1996"," чем занят?");
INSERT INTO text_bot VALUES("1997"," спасибо!");
INSERT INTO text_bot VALUES("1998"," тоже самое что и ты.");
INSERT INTO text_bot VALUES("1999"," ну да ты прав...");
INSERT INTO text_bot VALUES("2000"," жарко у нас.+25.");
INSERT INTO text_bot VALUES("2001"," не передумал ещё?");
INSERT INTO text_bot VALUES("2002"," я рада!");
INSERT INTO text_bot VALUES("2003"," а ты сам как думаешь?");
INSERT INTO text_bot VALUES("2004"," и правильно думаешь! :) ");
INSERT INTO text_bot VALUES("2005"," вроде нормальное.А у тебя?");
INSERT INTO text_bot VALUES("2006","Всем добрий вечер.апл.");
INSERT INTO text_bot VALUES("2007"," и тебе тавоже  харошего вечера.лол.");
INSERT INTO text_bot VALUES("2008"," спасибо.апл.");
INSERT INTO text_bot VALUES("2009"," да так всем по немногу.лол.");
INSERT INTO text_bot VALUES("2010"," а где народ где все в личках седят");
INSERT INTO text_bot VALUES("2011"," значит нужно роскопки вести.ржу.");
INSERT INTO text_bot VALUES("2012"," ето уже плохо.");
INSERT INTO text_bot VALUES("2013"," будем ждать");
INSERT INTO text_bot VALUES("2014"," .бла2.  ");
INSERT INTO text_bot VALUES("2015"," всётаки дождались.апл.");
INSERT INTO text_bot VALUES("2016","  .дансе. ");
INSERT INTO text_bot VALUES("2017"," кого дождались?");
INSERT INTO text_bot VALUES("2018"," это ты мне играешь? :) ");
INSERT INTO text_bot VALUES("2019"," красиво играешь.");
INSERT INTO text_bot VALUES("2020"," эсли все такиэ красивиэ здесь девчонки остаюсь наноч.ржу2.");
INSERT INTO text_bot VALUES("2021"," а ты меня ждал?");
INSERT INTO text_bot VALUES("2022"," вот и дождался...");
INSERT INTO text_bot VALUES("2023"," щас притащу кровать.апл.");
INSERT INTO text_bot VALUES("2024"," а ты был уверен что я приду ещё?");
INSERT INTO text_bot VALUES("2025"," и зачем вам кровать?");
INSERT INTO text_bot VALUES("2026"," хотела конечно! Поэтому и пришла.");
INSERT INTO text_bot VALUES("2027"," он тут ночевать собрался?.ржу.");
INSERT INTO text_bot VALUES("2028"," на дежурстве значит тут будет.");
INSERT INTO text_bot VALUES("2029"," да вроде нормально.Только ноги болят и спина немного.");
INSERT INTO text_bot VALUES("2030"," незнаю.Походу через неделю.");
INSERT INTO text_bot VALUES("2031"," ну да.Но и полоть снова.");
INSERT INTO text_bot VALUES("2032"," а может и не придется полоть снова.");
INSERT INTO text_bot VALUES("2033"," что ты там делаешь?");
INSERT INTO text_bot VALUES("2034"," тоже лежу.И думаю что хочется попить воды,так такая лень вставать и идти на кухню.");
INSERT INTO text_bot VALUES("2035"," наняла бы.Если бы одна жила,а не с родителями.");
INSERT INTO text_bot VALUES("2036"," спой мне колыбельную.");
INSERT INTO text_bot VALUES("2037"," ну тогда как нибудь сделай так чтобы я уснула.");
INSERT INTO text_bot VALUES("2038","))) ");
INSERT INTO text_bot VALUES("2039"," .день6. ");
INSERT INTO text_bot VALUES("2040"," да нормально.Сходила в магазин,а теперь на диване валяюсь.А у тебя?");
INSERT INTO text_bot VALUES("2041"," ясненько.");
INSERT INTO text_bot VALUES("2042"," ты чего грустный?!");
INSERT INTO text_bot VALUES("2043"," что то случилось?!");
INSERT INTO text_bot VALUES("2044"," я поняла.");
INSERT INTO text_bot VALUES("2045"," салатик делала.");
INSERT INTO text_bot VALUES("2046"," нет ещё.Пока что не хочется.");
INSERT INTO text_bot VALUES("2047"," да аппетита нет что то.Я только ещё утром кофе попила и бутер один съела.");
INSERT INTO text_bot VALUES("2048"," может быть.");
INSERT INTO text_bot VALUES("2049"," может и поем...");
INSERT INTO text_bot VALUES("2050"," ну это да.");
INSERT INTO text_bot VALUES("2051","  Здрям. Вы один встречаете новичков? Остальная Админка как будто не При делах.дум.");
INSERT INTO text_bot VALUES("2052"," приветик.");
INSERT INTO text_bot VALUES("2053"," Некогда это только отговорки");
INSERT INTO text_bot VALUES("2054"," Действительно,ничего....");
INSERT INTO text_bot VALUES("2055"," Охотно верю");
INSERT INTO text_bot VALUES("2056"," Оля");
INSERT INTO text_bot VALUES("2057"," Не секрет. Военная тайна. Шучу. Я из России");
INSERT INTO text_bot VALUES("2058"," Тепло у вас?");
INSERT INTO text_bot VALUES("2059"," Сегодня уже более менее было. Завтра вроде тоже тепло");
INSERT INTO text_bot VALUES("2060"," Не знаю. У нас лето началось с дождей и холода");
INSERT INTO text_bot VALUES("2061"," Ну конечно");
INSERT INTO text_bot VALUES("2062"," Да никакой. Сегодня без настроения что то. И так весь день. Кто графники прописывать в смайлы?");
INSERT INTO text_bot VALUES("2063"," Многие так говорят. Ну и я не исключение");
INSERT INTO text_bot VALUES("2064"," Даааа. Скучно. Тихо то как. Всегда так?");
INSERT INTO text_bot VALUES("2065"," Аха,отдуваешься значит за всех. Делааа ну  и ну ");
INSERT INTO text_bot VALUES("2066"," Ремешка и в угол .пардон2. ");
INSERT INTO text_bot VALUES("2067"," Тогда по головке  гладить. Реально бросается в глаза бездействие администрации. Интерес пропадает к сайту. Впечатление пустого сайта. Это мое личное мнение. Может кого и устраивает. Без обид");
INSERT INTO text_bot VALUES("2068"," Понятное дело.  .прик9. Пошла спать .будильник2. ");
INSERT INTO text_bot VALUES("2069"," Двенадцать ночи уже почти ");
INSERT INTO text_bot VALUES("2070"," не кричи так сильно.");
INSERT INTO text_bot VALUES("2071"," ничего себе тихо....ржу.");
INSERT INTO text_bot VALUES("2072"," я чуть не оглохла..ржу.");
INSERT INTO text_bot VALUES("2073"," да я пошутила.Кричи сколько хочешь.");
INSERT INTO text_bot VALUES("2074"," что делаешь? :) ");
INSERT INTO text_bot VALUES("2075"," умылась и легла на кровать.Какое кино смотришь?");
INSERT INTO text_bot VALUES("2076"," интересный был?");
INSERT INTO text_bot VALUES("2077"," значит можно не смотреть.");
INSERT INTO text_bot VALUES("2078"," мне нравится фильм Планета обезьян.Смотрел?");
INSERT INTO text_bot VALUES("2079"," .дутро26. ");
INSERT INTO text_bot VALUES("2080"," пока ещё не поняла.А у тебя?");
INSERT INTO text_bot VALUES("2081"," приветик милая. .цвет39. ");
INSERT INTO text_bot VALUES("2082"," час назад где то проснулась.А ты?");
INSERT INTO text_bot VALUES("2083"," плохо спала просто.");
INSERT INTO text_bot VALUES("2084"," как ты милая?!");
INSERT INTO text_bot VALUES("2085"," я уснула.Приснился сон плохой и я вся в поту проснулась.");
INSERT INTO text_bot VALUES("2086","Етитвую на лево,вы ещё за рыдайте.ржу.");
INSERT INTO text_bot VALUES("2087"," всё хорошо вроде бы.");
INSERT INTO text_bot VALUES("2088"," в личке тебе расскажу.");
INSERT INTO text_bot VALUES("2089"," чем занята? .цвет28. ");
INSERT INTO text_bot VALUES("2090"," приятного чаепития!");
INSERT INTO text_bot VALUES("2091","Писец какая у вас тут скукота .пляжесть.  ");
INSERT INTO text_bot VALUES("2092"," ну вот как то так...");
INSERT INTO text_bot VALUES("2093"," постараюсь...");
INSERT INTO text_bot VALUES("2094","Ну как такая шустрая так развеселить..иль слабо?.ржу.");
INSERT INTO text_bot VALUES("2095","Всем хорошего дня!.ор.");
INSERT INTO text_bot VALUES("2096"," спасибо!.миг.");
INSERT INTO text_bot VALUES("2097"," кофе сейчас попью и надо уборку делать.А ты чем занят?");
INSERT INTO text_bot VALUES("2098"," спасибо солнце!");
INSERT INTO text_bot VALUES("2099"," с телефоном разобрался?");
INSERT INTO text_bot VALUES("2100"," умничка!");
INSERT INTO text_bot VALUES("2101"," жарко сегодня очень.+31.");
INSERT INTO text_bot VALUES("2102"," все видимо заняты.");
INSERT INTO text_bot VALUES("2103"," .доп4. ");
INSERT INTO text_bot VALUES("2104"," но я к ним не отношусь.");
INSERT INTO text_bot VALUES("2105","Всем доброго дня .день31. ");
INSERT INTO text_bot VALUES("2106"," да вроде добрый.наконец то лето пожаловало");
INSERT INTO text_bot VALUES("2107"," поставила 10. Вроде нормально");
INSERT INTO text_bot VALUES("2108"," просто норм открывается");
INSERT INTO text_bot VALUES("2109"," .по37. ");
INSERT INTO text_bot VALUES("2110"," да уже нет проблем с открытием");
INSERT INTO text_bot VALUES("2111"," спасибо за подсказку");
INSERT INTO text_bot VALUES("2112"," привет, как ник поменять? ");
INSERT INTO text_bot VALUES("2113"," в услугах..но здесь наверное нет смена ника");
INSERT INTO text_bot VALUES("2114"," что то я не нашол:) ");
INSERT INTO text_bot VALUES("2115"," цвет ника нажми и попробуй");
INSERT INTO text_bot VALUES("2116"," нет там не чего");
INSERT INTO text_bot VALUES("2117"," есть");
INSERT INTO text_bot VALUES("2118","А чё это за демон на меня напал?.ржу.");
INSERT INTO text_bot VALUES("2119"," тот что стрелы у меня украл.ржу.");
INSERT INTO text_bot VALUES("2120"," как ты?Что делаешь?");
INSERT INTO text_bot VALUES("2121"," тоже нормально.Триллер смотрю с братом.");
INSERT INTO text_bot VALUES("2122"," ну да.Называется Никто не выжил.");
INSERT INTO text_bot VALUES("2123"," там как я поняла про резню на вечеринке,в которой выжила только одна девушка,но потом её похищают бандиты.");
INSERT INTO text_bot VALUES("2124"," тебе нравятся триллеры?");
INSERT INTO text_bot VALUES("2125"," а триллер Я плюю на ваши могилы,смотрел?Их три части.");
INSERT INTO text_bot VALUES("2126"," мне понравился..миг.");
INSERT INTO text_bot VALUES("2127"," сказать про что?");
INSERT INTO text_bot VALUES("2128"," там про как девушка жестоко мстит насильникам, которые сначала издевались над ней,а потом насиловали,но она смогла убежать и выжить,а потом их всех нашла.");
INSERT INTO text_bot VALUES("2129"," так никого нет.");
INSERT INTO text_bot VALUES("2130"," не переживай!В следующий раз проведёшь викторину.");
INSERT INTO text_bot VALUES("2131"," .бинокль1. ");
INSERT INTO text_bot VALUES("2132"," тебя!");
INSERT INTO text_bot VALUES("2133"," .вдуше. здраствуйте");
INSERT INTO text_bot VALUES("2134"," приветик! .цвет9. ");
INSERT INTO text_bot VALUES("2135"," нет.");
INSERT INTO text_bot VALUES("2136"," но высматривала то я тебя...");
INSERT INTO text_bot VALUES("2137"," приветики");
INSERT INTO text_bot VALUES("2138"," да нормально.Ты там что делаешь?");
INSERT INTO text_bot VALUES("2139"," давай знакомиться? .ромашки. ");
INSERT INTO text_bot VALUES("2140"," какое?");
INSERT INTO text_bot VALUES("2141"," хорошо ктото меня звал сюда с другого сайта");
INSERT INTO text_bot VALUES("2142"," цыц бот .лол.");
INSERT INTO text_bot VALUES("2143","я не знаю кто ");
INSERT INTO text_bot VALUES("2144"," да там тоже не плохо .лол.");
INSERT INTO text_bot VALUES("2145","верно все.");
INSERT INTO text_bot VALUES("2146"," .еда9. ");
INSERT INTO text_bot VALUES("2147"," да я в курсе но друзья там у меня есть уже.");
INSERT INTO text_bot VALUES("2148"," не знаю я говорила они не идут.");
INSERT INTO text_bot VALUES("2149"," мае");
INSERT INTO text_bot VALUES("2150"," .вечер31.  ");
INSERT INTO text_bot VALUES("2151","лтит потом бум.лол.");
INSERT INTO text_bot VALUES("2152"," да я за шла просто посмотреть.");
INSERT INTO text_bot VALUES("2153"," скучно ");
INSERT INTO text_bot VALUES("2154"," раскажи мне их.лол.");
INSERT INTO text_bot VALUES("2155"," не надо так говорить");
INSERT INTO text_bot VALUES("2156","всем покась ");
INSERT INTO text_bot VALUES("2157","извените я домой .14.");
INSERT INTO text_bot VALUES("2158"," чего кричишь? .бла2. ");
INSERT INTO text_bot VALUES("2159"," зря уходишь...");
INSERT INTO text_bot VALUES("2160"," тут классно!Ты просто мало тут побыла.");
INSERT INTO text_bot VALUES("2161"," походу ты прав,как всегда. :) ");
INSERT INTO text_bot VALUES("2162"," некоторые на порно сайтах сразу кому нибудь в личку свои интим фото высылают с вопросом \"ну как нравится?\".");
INSERT INTO text_bot VALUES("2163","и че такое человек ушол или не ушол пока еше обсуждение пошло типо такой мли сякой");
INSERT INTO text_bot VALUES("2164","вот я от вас не ожидала этого");
INSERT INTO text_bot VALUES("2165","прости меня все понятно я поняла все че за спиною говориться я же не че плахого не говорила...");
INSERT INTO text_bot VALUES("2166"," валяюсь на диване и тут на сайте.А ты чем занят?");
INSERT INTO text_bot VALUES("2167"," двигайся. :) А то разлёгся на диване.");
INSERT INTO text_bot VALUES("2168"," так я уже подвинулась. .бла2. ");
INSERT INTO text_bot VALUES("2169","ну да...Пять комнат убрала.");
INSERT INTO text_bot VALUES("2170"," после дачи я сильнее устала,чем сейчас.");
INSERT INTO text_bot VALUES("2171"," не до конца ещё.");
INSERT INTO text_bot VALUES("2172"," да пройдёт.Не велика беда.");
INSERT INTO text_bot VALUES("2173"," снова мы тут одни?");
INSERT INTO text_bot VALUES("2174"," а некоторые в личках сидят.");
INSERT INTO text_bot VALUES("2175"," интересно в каких играх.");
INSERT INTO text_bot VALUES("2176"," что то не видно особо чтобы кто то во что то играл.");
INSERT INTO text_bot VALUES("2177"," привет милая.");
INSERT INTO text_bot VALUES("2178"," .танц27.  ");
INSERT INTO text_bot VALUES("2179"," да нормально.Чего не спишь?");
INSERT INTO text_bot VALUES("2180"," нет ну так не честно...");
INSERT INTO text_bot VALUES("2181"," тоже думаю что рано.");
INSERT INTO text_bot VALUES("2182"," ну я тебе танцевала такой раскрепощенный танец,а ты мне алкаша подсунул..ржу.");
INSERT INTO text_bot VALUES("2183"," вот это я понимаю.Умничка!.миг.");
INSERT INTO text_bot VALUES("2184"," так а мы танцуем просто ");
INSERT INTO text_bot VALUES("2185"," действительно что никак...");
INSERT INTO text_bot VALUES("2186"," почему наверное?");
INSERT INTO text_bot VALUES("2187"," уверен?");
INSERT INTO text_bot VALUES("2188"," спать ещё не собираешься?");
INSERT INTO text_bot VALUES("2189"," тоже...Что делаешь?");
INSERT INTO text_bot VALUES("2190"," не поверишь но тоже самое.");
INSERT INTO text_bot VALUES("2191"," ну ночью можно много чего делать...");
INSERT INTO text_bot VALUES("2192"," ну это как говорится у кого как фантазия богата.");
INSERT INTO text_bot VALUES("2193","Спокойной ночи всем .ночи42. ");
INSERT INTO text_bot VALUES("2194"," тут можно много чего на фантазировать.");
INSERT INTO text_bot VALUES("2195"," привет солнце!.ор.");
INSERT INTO text_bot VALUES("2196"," как ты?Что делал?");
INSERT INTO text_bot VALUES("2197"," в огороде полила всё.А то у нас жарко очень.А так валялась на диване целый день.");
INSERT INTO text_bot VALUES("2198"," есть немного...");
INSERT INTO text_bot VALUES("2199"," ну это да.Ну а что делать,надо было полить.");
INSERT INTO text_bot VALUES("2200"," завтра и носа не покажу на улицу.У нас завтра +33.");
INSERT INTO text_bot VALUES("2201"," на солнце.");
INSERT INTO text_bot VALUES("2202"," чем занят? :) ");
INSERT INTO text_bot VALUES("2203"," музыку слушаю.");
INSERT INTO text_bot VALUES("2204"," группу Комиссар.Знаешь?");
INSERT INTO text_bot VALUES("2205"," сейчас песня \"Дрянь\" играет.");
INSERT INTO text_bot VALUES("2206"," .танец55.  ");
INSERT INTO text_bot VALUES("2207","Ночи добрый леди и джентльмены,!");
INSERT INTO text_bot VALUES("2208"," так мы с тобой уже здоровались.");
INSERT INTO text_bot VALUES("2209"," и потанцевать уже успели.");
INSERT INTO text_bot VALUES("2210"," ну с хорошим человеком можно и сто раз здороваться..ах.");
INSERT INTO text_bot VALUES("2211"," и где ты её слышал?");
INSERT INTO text_bot VALUES("2212"," ну точно не я.");
INSERT INTO text_bot VALUES("2213"," приветик милая.");
INSERT INTO text_bot VALUES("2214"," как ты?Как день прошел?");
INSERT INTO text_bot VALUES("2215"," тоже всё хорошо. .цвет10. ");
INSERT INTO text_bot VALUES("2216"," мне...");
INSERT INTO text_bot VALUES("2217"," мне.ор. ");
INSERT INTO text_bot VALUES("2218"," Всем.день.  ");
INSERT INTO text_bot VALUES("2219"," спасибо! Пойдёт!");
INSERT INTO text_bot VALUES("2220"," .прик. Нет никого");
INSERT INTO text_bot VALUES("2221"," уря! Как настроение?");
INSERT INTO text_bot VALUES("2222","ого как ты кричишь.Меня зовёшь?");
INSERT INTO text_bot VALUES("2223"," ну зови тогда.");
INSERT INTO text_bot VALUES("2224"," .вечер18. ");
INSERT INTO text_bot VALUES("2225"," .прик11. ");
INSERT INTO text_bot VALUES("2226"," да это я так...Не обращай внимание. :) ");
INSERT INTO text_bot VALUES("2227"," тишина просто как в танке.");
INSERT INTO text_bot VALUES("2228"," ага попробуй загони кого нибудь сюда.");
INSERT INTO text_bot VALUES("2229"," что делаешь? .бла2. ");
INSERT INTO text_bot VALUES("2230"," картину стразами делаю и тут с тобой.");
INSERT INTO text_bot VALUES("2231"," я выкладываю стразами на холсте картины для себя и на заказ.");
INSERT INTO text_bot VALUES("2232"," да.Четыре картины уже сделала,две на заказ и две себе.");
INSERT INTO text_bot VALUES("2233"," ты там ещё не охрип?!");
INSERT INTO text_bot VALUES("2234"," ну ты так кричишь. .ржу. ");
INSERT INTO text_bot VALUES("2235"," ну хорошо если легонько.");
INSERT INTO text_bot VALUES("2236"," нет ещё.А ты?");
INSERT INTO text_bot VALUES("2237","так ещё десять вечера.");
INSERT INTO text_bot VALUES("2238"," ты про что?");
INSERT INTO text_bot VALUES("2239"," так я всё сделала.");
INSERT INTO text_bot VALUES("2240"," да не очень.Иногда устаешь больше когда ничего не делаешь.");
INSERT INTO text_bot VALUES("2241"," фильм посмотрел?");
INSERT INTO text_bot VALUES("2242"," а то фильм на смотрел в котором три части про который я тебе говорила?");
INSERT INTO text_bot VALUES("2243"," посмотришь когда,и скажешь понравился или нет.");
INSERT INTO text_bot VALUES("2244"," чтоб такое утворить,чтоб хотелось повторить. .бла2. ");
INSERT INTO text_bot VALUES("2245","Всем утро доброе!");
INSERT INTO text_bot VALUES("2246"," Мне.миг.");
INSERT INTO text_bot VALUES("2247"," привет. :) ");
INSERT INTO text_bot VALUES("2248"," как дела!");
INSERT INTO text_bot VALUES("2249"," тоже нормально ");
INSERT INTO text_bot VALUES("2250"," картину сейчас доделываю.А ты чем занят?");
INSERT INTO text_bot VALUES("2251"," что интересного смотришь?");
INSERT INTO text_bot VALUES("2252"," .прик100. ");
INSERT INTO text_bot VALUES("2253"," тоже нормально. :) ");
INSERT INTO text_bot VALUES("2254"," что рассказывать?");
INSERT INTO text_bot VALUES("2255"," вроде хорошо. .бла2. ");
INSERT INTO text_bot VALUES("2256"," сама ещё не решила..ржу.");
INSERT INTO text_bot VALUES("2257"," не хочу.");
INSERT INTO text_bot VALUES("2258"," секрет фирмы..ах.");
INSERT INTO text_bot VALUES("2259"," что?");
INSERT INTO text_bot VALUES("2260"," привет милая. .цвет12. ");
INSERT INTO text_bot VALUES("2261"," как дела? .цвет39. ");
INSERT INTO text_bot VALUES("2262"," тоже нормально. .цвет40. ");
INSERT INTO text_bot VALUES("2263"," ну чё ты кричишь? .бла2. ");
INSERT INTO text_bot VALUES("2264"," и когда оно придёт?");
INSERT INTO text_bot VALUES("2265"," хорошо.То в магазин ходила,то дома что то делала.А у тебя?");
INSERT INTO text_bot VALUES("2266"," рада за тебя! :) ");
INSERT INTO text_bot VALUES("2267"," .утро27.  ");
INSERT INTO text_bot VALUES("2268"," доброе утро! :) ");
INSERT INTO text_bot VALUES("2269"," сейчас кофе пью.Потом на рынок надо съездить.А ты чем занят?");
INSERT INTO text_bot VALUES("2270"," доброе утро милая.Спасибо!! :) ");
INSERT INTO text_bot VALUES("2271","Slonopotam .доп4. ");
INSERT INTO text_bot VALUES("2272","  фёкла графики кто\r\nделает");
INSERT INTO text_bot VALUES("2273"," а аватар чтоли?");
INSERT INTO text_bot VALUES("2274"," фёкла давай всё");
INSERT INTO text_bot VALUES("2275"," .день15. ");
INSERT INTO text_bot VALUES("2276"," один раз жалко что ли");
INSERT INTO text_bot VALUES("2277"," походу монеты не нужны людям. .еа. ");
INSERT INTO text_bot VALUES("2278"," например мне..ржу.");
INSERT INTO text_bot VALUES("2279","Народ,шевелитись хоть немного.Ради вас же стараются!.ор..ор.");
INSERT INTO text_bot VALUES("2280"," :15. ");
INSERT INTO text_bot VALUES("2281"," зову людей.Вот ты отозвался.");
INSERT INTO text_bot VALUES("2282"," сомневаюсь.");
INSERT INTO text_bot VALUES("2283"," как дела?Что делал?");
INSERT INTO text_bot VALUES("2284"," я тоже народ зову.");
INSERT INTO text_bot VALUES("2285"," ну посмотрим когда придут.");
INSERT INTO text_bot VALUES("2286","Sasha 1990 .доп4. ");
INSERT INTO text_bot VALUES("2287"," так потихоньку ");
INSERT INTO text_bot VALUES("2288"," если хотите кричите сами я не хочу");
INSERT INTO text_bot VALUES("2289"," ага");
INSERT INTO text_bot VALUES("2290"," Александр! ");
INSERT INTO text_bot VALUES("2291"," с России ");
INSERT INTO text_bot VALUES("2292"," Нижний Новгород ");
INSERT INTO text_bot VALUES("2293"," ну я не в самом нижнем живу");
INSERT INTO text_bot VALUES("2294"," сегодня пасмурно");
INSERT INTO text_bot VALUES("2295"," .вечер15. ");
INSERT INTO text_bot VALUES("2296"," ладно ушол я ");
INSERT INTO text_bot VALUES("2297","СветланА .доп8. ");
INSERT INTO text_bot VALUES("2298"," спасибо!И тебе! .цвет5. ");
INSERT INTO text_bot VALUES("2299","Ну и где вы все? .еа. ");
INSERT INTO text_bot VALUES("2300"," вижу тебя. .бла2. ");
INSERT INTO text_bot VALUES("2301"," ветер сильный поднялся.Но дождя нет.");
INSERT INTO text_bot VALUES("2302"," днём было всеравно жарко.");
INSERT INTO text_bot VALUES("2303"," сильный дождь?");
INSERT INTO text_bot VALUES("2304","Пайду оть сюда");
INSERT INTO text_bot VALUES("2305","мишутка, .доп2. ");
INSERT INTO text_bot VALUES("2306"," что ненравится здесь??");
INSERT INTO text_bot VALUES("2307"," ухажу");
INSERT INTO text_bot VALUES("2308","Незнаю я");
INSERT INTO text_bot VALUES("2309"," почему?!");
INSERT INTO text_bot VALUES("2310"," скучна");
INSERT INTO text_bot VALUES("2311"," ты только пришло,а говоришь что скучно!");
INSERT INTO text_bot VALUES("2312"," ты же только пришол.");
INSERT INTO text_bot VALUES("2313"," уже ушоль");
INSERT INTO text_bot VALUES("2314"," .цвет10.  ");
INSERT INTO text_bot VALUES("2315"," на порно сайте лучше???");
INSERT INTO text_bot VALUES("2316"," спасибо! :) ");
INSERT INTO text_bot VALUES("2317","Не хачу");
INSERT INTO text_bot VALUES("2318"," досвидание");
INSERT INTO text_bot VALUES("2319"," чего не хочешь?");
INSERT INTO text_bot VALUES("2320"," я спать ушол ");
INSERT INTO text_bot VALUES("2321"," и вам того же самого ");
INSERT INTO text_bot VALUES("2322"," нечево");
INSERT INTO text_bot VALUES("2323","Всем пака");
INSERT INTO text_bot VALUES("2324"," .глазки. ");
INSERT INTO text_bot VALUES("2325"," ничего.А что?");
INSERT INTO text_bot VALUES("2326"," ты спрашивал что я дома вытворяют?");
INSERT INTO text_bot VALUES("2327"," сейчас ложиться буду,но спать ещё не буду.А ты что делаешь?");
INSERT INTO text_bot VALUES("2328"," где нарисовали?");
INSERT INTO text_bot VALUES("2329"," какой ты однако умничка!");
INSERT INTO text_bot VALUES("2330"," правильно и не говори пока.Потом скажешь.");
INSERT INTO text_bot VALUES("2331","Эммм, .доп6. ");
INSERT INTO text_bot VALUES("2332","Эсми, .доп1.  ");
INSERT INTO text_bot VALUES("2333","SleZa_LuBvi, .доп1.  ");
INSERT INTO text_bot VALUES("2334","Доброе утро дамы и господа! Всем хорошего дня!");
INSERT INTO text_bot VALUES("2335"," .утро25.  ");
INSERT INTO text_bot VALUES("2336"," привет.Как спалось?");
INSERT INTO text_bot VALUES("2337","вот всегда так");
INSERT INTO text_bot VALUES("2338"," тоже хорошо.Что делаешь?");
INSERT INTO text_bot VALUES("2339"," кофе пью.");
INSERT INTO text_bot VALUES("2340"," Мне..");
INSERT INTO text_bot VALUES("2341"," Снова мне");
INSERT INTO text_bot VALUES("2342","  .спас18. ");
INSERT INTO text_bot VALUES("2343"," .бон46. ");
INSERT INTO text_bot VALUES("2344"," Поймала");
INSERT INTO text_bot VALUES("2345"," умничка!Бегу! :) ");
INSERT INTO text_bot VALUES("2346","  .спас4. ");
INSERT INTO text_bot VALUES("2347"," всегда пожалуйста! .цвет39. ");
INSERT INTO text_bot VALUES("2348"," Всегда пожалуйста  .цвет34. ");
INSERT INTO text_bot VALUES("2349"," давай знакомиться милая? .цвет40. ");
INSERT INTO text_bot VALUES("2350"," Конечно давай. Я Ольга ");
INSERT INTO text_bot VALUES("2351"," а я Снежана.Рада знакомству! .цвет33. ");
INSERT INTO text_bot VALUES("2352","Moon Shine, .доп3.  ");
INSERT INTO text_bot VALUES("2353","привет, благодарю за приём ");
INSERT INTO text_bot VALUES("2354","Moon Shine, .доп4. ");
INSERT INTO text_bot VALUES("2355"," благодарю :) ");
INSERT INTO text_bot VALUES("2356"," Знакомится бум?..))");
INSERT INTO text_bot VALUES("2357","Тишина как в танке... .еа. ");
INSERT INTO text_bot VALUES("2358"," все заняты просто.");
INSERT INTO text_bot VALUES("2359"," ты там что творишь?");
INSERT INTO text_bot VALUES("2360"," папа за пивом в магазин отправил.");
INSERT INTO text_bot VALUES("2361"," я пиво не пью.");
INSERT INTO text_bot VALUES("2362"," будем, я Эдик ");
INSERT INTO text_bot VALUES("2363"," Очень приятно. Я Ольга");
INSERT INTO text_bot VALUES("2364"," и мне очень приятно познакомиться с тобой :) ");
INSERT INTO text_bot VALUES("2365"," Кажется я тебя знаю:)");
INSERT INTO text_bot VALUES("2366",".бон21.кто потерял?");
INSERT INTO text_bot VALUES("2367"," я милая зайка ");
INSERT INTO text_bot VALUES("2368"," умница!");
INSERT INTO text_bot VALUES("2369"," возможно ");
INSERT INTO text_bot VALUES("2370"," что делать будем?");
INSERT INTO text_bot VALUES("2371"," ну и ладно. .бла2. ");
INSERT INTO text_bot VALUES("2372","[marquee]Кому?.бон19.[/marquee]");
INSERT INTO text_bot VALUES("2373"," Да,тебе .цвет1. ");
INSERT INTO text_bot VALUES("2374","[marquee].бон78.[/marquee]");
INSERT INTO text_bot VALUES("2375","  .дада.  тебе");
INSERT INTO text_bot VALUES("2376"," Спасибо. Чем занимаешься?");
INSERT INTO text_bot VALUES("2377"," Отдыхаю. Фильм мельком смотрю");
INSERT INTO text_bot VALUES("2378"," Неудержимый");
INSERT INTO text_bot VALUES("2379"," Кинг конг?");
INSERT INTO text_bot VALUES("2380"," .вечер40. ");
INSERT INTO text_bot VALUES("2381"," спасибо!Но мне ещё до уютного вечера далеко. :) ");
INSERT INTO text_bot VALUES("2382"," Не,не смортела");
INSERT INTO text_bot VALUES("2383"," нет конечно.Еще только семь вечера.");
INSERT INTO text_bot VALUES("2384"," Согласна. Мне  нравится фильм");
INSERT INTO text_bot VALUES("2385"," Не один раз");
INSERT INTO text_bot VALUES("2386","  .дада.  ");
INSERT INTO text_bot VALUES("2387","  .прик8. ");
INSERT INTO text_bot VALUES("2388"," В полном порядке) Ты как?");
INSERT INTO text_bot VALUES("2389"," Хорошо же)");
INSERT INTO text_bot VALUES("2390","  Нет. Спать только хочу. Сейчас пойду уже");
INSERT INTO text_bot VALUES("2391"," Уже пошла  :17. ");
INSERT INTO text_bot VALUES("2392"," .прик37. ");
INSERT INTO text_bot VALUES("2393","чего задумался да ещё и с сигаретой?.ржу.");
INSERT INTO text_bot VALUES("2394"," думаешь что со мной делать?");
INSERT INTO text_bot VALUES("2395"," добрый вечер.");
INSERT INTO text_bot VALUES("2396"," да я знаю! :) ");
INSERT INTO text_bot VALUES("2397"," ты умничка! :) ");
INSERT INTO text_bot VALUES("2398"," всегда пожалуйста!! :) ");
INSERT INTO text_bot VALUES("2399"," да я уже и не пойму пойдем или нет.");
INSERT INTO text_bot VALUES("2400"," пока они соберутся так и дождь начнется.");
INSERT INTO text_bot VALUES("2401"," я уже и не хочу идти.");
INSERT INTO text_bot VALUES("2402"," .танц3. ");
INSERT INTO text_bot VALUES("2403"," ух как классно ты танцуешь. :) ");
INSERT INTO text_bot VALUES("2404"," спасибо!Что делать будем?");
INSERT INTO text_bot VALUES("2405"," незнаю.Надо подумать.");
INSERT INTO text_bot VALUES("2406"," и долго будешь думать?");
INSERT INTO text_bot VALUES("2407"," у меня есть кое какие мысли,но я думаю что они не правильные..ах ");
INSERT INTO text_bot VALUES("2408"," мысли не в ту сторону крутятся..ах.");
INSERT INTO text_bot VALUES("2409"," ну не в плохую... :) ");
INSERT INTO text_bot VALUES("2410"," ну ты же видел что в хорошую.");
INSERT INTO text_bot VALUES("2411"," капец.Крыша походу поехала уже.");
INSERT INTO text_bot VALUES("2412"," скорее всего.Что делаешь, солнце?");
INSERT INTO text_bot VALUES("2413"," валяюсь на кровати. :) ");
INSERT INTO text_bot VALUES("2414"," а ты чем занят?");
INSERT INTO text_bot VALUES("2415"," а чего говоришь что везёт мне что я отдыхаю,ты же тоже отдыхаешь?");
INSERT INTO text_bot VALUES("2416"," ну это да, солнце.");
INSERT INTO text_bot VALUES("2417"," наконец то этот день закончился.");
INSERT INTO text_bot VALUES("2418","Жасмин, .доп15. ");
INSERT INTO text_bot VALUES("2419","   .феньк.   .дутро41. ");
INSERT INTO text_bot VALUES("2420","  .дутро39. ");
INSERT INTO text_bot VALUES("2421","Всем доброе утро ");
INSERT INTO text_bot VALUES("2422"," Привет!!!");
INSERT INTO text_bot VALUES("2423","  Хорошо. Сам как спал?");
INSERT INTO text_bot VALUES("2424","Zatmenie, .доп9. ");
INSERT INTO text_bot VALUES("2425","Zatmenie, .доп5. ");
INSERT INTO text_bot VALUES("2426"," Только пообедала.");
INSERT INTO text_bot VALUES("2427"," У многих разное время. Земля огромная:)");
INSERT INTO text_bot VALUES("2428"," Приветики  .цвет34. ");
INSERT INTO text_bot VALUES("2429"," приветик;)");
INSERT INTO text_bot VALUES("2430"," Как жизнь? Как делишечки?)");
INSERT INTO text_bot VALUES("2431"," крови хочу)))");
INSERT INTO text_bot VALUES("2432","  .глазища.  Сбрендила чтоли? .лол2. ");
INSERT INTO text_bot VALUES("2433"," тоже хорошо.Обои клеем.");
INSERT INTO text_bot VALUES("2434"," .ржу.шучу.погода просто пипец");
INSERT INTO text_bot VALUES("2435"," девочки сделайте графник прикольный,пожалуйста");
INSERT INTO text_bot VALUES("2436"," да.Ты чем занят?");
INSERT INTO text_bot VALUES("2437"," Картинку в почту кинь для графника");
INSERT INTO text_bot VALUES("2438"," .бон17. ");
INSERT INTO text_bot VALUES("2439"," умничка!Бегу! .цвет5. ");
INSERT INTO text_bot VALUES("2440"," так никого нет,все заняты.");
INSERT INTO text_bot VALUES("2441"," да не только в личках.Есть же ещё и дела.");
INSERT INTO text_bot VALUES("2442"," .бон22. ");
INSERT INTO text_bot VALUES("2443"," капец.Никто не хочет ничего ловить. .еа. ");
INSERT INTO text_bot VALUES("2444","Мои :D");
INSERT INTO text_bot VALUES("2445"," бегу!.ор.");
INSERT INTO text_bot VALUES("2446"," .бон10. ");
INSERT INTO text_bot VALUES("2447"," .ддень4.  ");
INSERT INTO text_bot VALUES("2448"," спасибо!Чем занят?");
INSERT INTO text_bot VALUES("2449"," что покупал вкусненького?");
INSERT INTO text_bot VALUES("2450"," привет!И тебе хорошего дня!");
INSERT INTO text_bot VALUES("2451"," а я думала что ты вкусного что то купил. .бла2. ");
INSERT INTO text_bot VALUES("2452"," .бон40. ");
INSERT INTO text_bot VALUES("2453"," кого ждёшь?");
INSERT INTO text_bot VALUES("2454"," давай вместе ждать тогда. .еа. ");
INSERT INTO text_bot VALUES("2455"," вдруг кого нибудь дождёмся...");
INSERT INTO text_bot VALUES("2456"," чем занят? .бла2. ");
INSERT INTO text_bot VALUES("2457"," салатик делаю.");
INSERT INTO text_bot VALUES("2458"," приятного аппетита тебе зарание");
INSERT INTO text_bot VALUES("2459","obayashka2, .доброп4. ");
INSERT INTO text_bot VALUES("2460","Obayashka2, .доброп2. ");
INSERT INTO text_bot VALUES("2461"," не только.Салат листовой, огурцы.");
INSERT INTO text_bot VALUES("2462"," и холодник сейчас ещё буду делать.");
INSERT INTO text_bot VALUES("2463"," только не холодильник,а холодник.");
INSERT INTO text_bot VALUES("2464"," .вечер12. ");
INSERT INTO text_bot VALUES("2465"," типа как борщ.Только холодный,и туда ложат свёкла, свежие огурцы и яйца.");
INSERT INTO text_bot VALUES("2466"," .бон47. ");
INSERT INTO text_bot VALUES("2467","ну почти.Только окрошка на квасе,а холодник на кефире.");
INSERT INTO text_bot VALUES("2468"," приветик! .цвет39. ");
INSERT INTO text_bot VALUES("2469","Как у вас делишечки,настроение?");
INSERT INTO text_bot VALUES("2470"," всё хорошо!А у тебя?");
INSERT INTO text_bot VALUES("2471"," Тоже хорошо)");
INSERT INTO text_bot VALUES("2472"," Замечательно)");
INSERT INTO text_bot VALUES("2473"," А я то как рада  .прик20. ");
INSERT INTO text_bot VALUES("2474"," так и должно быть.Надо чтобы было у всех всё хорошо. :) ");
INSERT INTO text_bot VALUES("2475"," Согласна 100%:)");
INSERT INTO text_bot VALUES("2476"," но как говорится,не всегда в жизни получается так как мы хотим.");
INSERT INTO text_bot VALUES("2477"," Потому что мы думаем, что хозяева своей жизни а на самом деле его величество Случай любит в него очень часто вмешиваться и рушить все планы.");
INSERT INTO text_bot VALUES("2478"," полностью с тобой согласна,милая!");
INSERT INTO text_bot VALUES("2479"," Пойду поужинаю. А то ты раздразнила мой желудок своим борщом  .ржу3. ");
INSERT INTO text_bot VALUES("2480"," прости!Я незнала что ты ещё не ела.Приятного аппетита! :) ");
INSERT INTO text_bot VALUES("2481"," Была не голодной :) Спасибочки:)");
INSERT INTO text_bot VALUES("2482","а я тут про борщ наговорила и ты кушать захотела? :) ");
INSERT INTO text_bot VALUES("2483"," .прик15. ");
INSERT INTO text_bot VALUES("2484"," .бон10. .ор.");
INSERT INTO text_bot VALUES("2485"," умничка!Бегу! .цвет10. ");
INSERT INTO text_bot VALUES("2486"," так я тихонько бежала..ржу.");
INSERT INTO text_bot VALUES("2487"," но значит тихонько,но быстро..ржу.");
INSERT INTO text_bot VALUES("2488"," .бон6. .ор.");
INSERT INTO text_bot VALUES("2489","Народ,вы где?.ор.");
INSERT INTO text_bot VALUES("2490"," ну ты то всегда здесь. :) ");
INSERT INTO text_bot VALUES("2491"," без тебя никак....ах.");
INSERT INTO text_bot VALUES("2492"," не скажу...");
INSERT INTO text_bot VALUES("2493"," сам знаешь почему.");
INSERT INTO text_bot VALUES("2494","И снова никого нет. .еа. ");
INSERT INTO text_bot VALUES("2495"," .танц42. ");
INSERT INTO text_bot VALUES("2496","Странник555, .доброп2. ");
INSERT INTO text_bot VALUES("2497","  добрый вечер");
INSERT INTO text_bot VALUES("2498"," и вам добрый вечер! :) ");
INSERT INTO text_bot VALUES("2499","Всем приятного общения ");
INSERT INTO text_bot VALUES("2500"," спасибо!А ты чего в беседку не выходишь??");
INSERT INTO text_bot VALUES("2501"," где был?Что видел?");
INSERT INTO text_bot VALUES("2502"," тот триллер так и не смотрел ещё!");
INSERT INTO text_bot VALUES("2503"," а мы сейчас концерт по телеку слушаем и смотрим Дискотека 90-х.");
INSERT INTO text_bot VALUES("2504"," приятного просмотра тебе ");
INSERT INTO text_bot VALUES("2505"," спасибо большое! :) ");
INSERT INTO text_bot VALUES("2506","СюрПриЗ, .доброп2. ");
INSERT INTO text_bot VALUES("2507","kvok, .доброп2. ");
INSERT INTO text_bot VALUES("2508"," у тебя нет такого канала.");
INSERT INTO text_bot VALUES("2509","это наш канал, который только в Беларуси.Я нормально!Ты как?");
INSERT INTO text_bot VALUES("2510"," а почему вроде?!");
INSERT INTO text_bot VALUES("2511"," а чем занимался?");
INSERT INTO text_bot VALUES("2512"," и от этого устал что ли?");
INSERT INTO text_bot VALUES("2513"," знаю солнце!Со мной тоже так бывало.");
INSERT INTO text_bot VALUES("2514"," было что ничего не делала,а к вечеру уставшая от безделья.");
INSERT INTO text_bot VALUES("2515"," ну да.Я думала что ты уже спатки пошол.");
INSERT INTO text_bot VALUES("2516"," я уже легла.Но пока ещё засну...");
INSERT INTO text_bot VALUES("2517"," ещё не решила..ржу.");
INSERT INTO text_bot VALUES("2518"," ну вроде хочу спать,а вроде и нет.");
INSERT INTO text_bot VALUES("2519"," наверное ещё тут с тобой побыть.");
INSERT INTO text_bot VALUES("2520"," ну это понятно что мне.");
INSERT INTO text_bot VALUES("2521"," да нормально.Ты там как?");
INSERT INTO text_bot VALUES("2522","Dark_Princess, .доброп4. ");
INSERT INTO text_bot VALUES("2523","Всем привет,го дружить и все в друзья) приму всех .хай1. ");
INSERT INTO text_bot VALUES("2524"," думала что все спят:)");
INSERT INTO text_bot VALUES("2525"," ммм, тогда вам доброе утро)");
INSERT INTO text_bot VALUES("2526","  .пописюрику. ");
INSERT INTO text_bot VALUES("2527"," Маша и Медведь смотрю с дочкой.лол.");
INSERT INTO text_bot VALUES("2528"," у меня показывают, мы щас по телику смотрим");
INSERT INTO text_bot VALUES("2529","[url=http://mir-vipok.ru/plugins/images/?category=41][img]http://mir-vipok.ru/sys/images/gifpnf132.gif[/img][/url]");
INSERT INTO text_bot VALUES("2530"," плохо");
INSERT INTO text_bot VALUES("2531"," ну жп,через интернет можно глянуть");
INSERT INTO text_bot VALUES("2532"," я кстати Кристина");
INSERT INTO text_bot VALUES("2533"," очень приятно .пох. ");
INSERT INTO text_bot VALUES("2534"," сколько вам лет?)");
INSERT INTO text_bot VALUES("2535"," ну вы меня старше)))");
INSERT INTO text_bot VALUES("2536"," ну хорошо,больше не буду");
INSERT INTO text_bot VALUES("2537"," хорошее у тебя");
INSERT INTO text_bot VALUES("2538"," нет,уже кино идёт");
INSERT INTO text_bot VALUES("2539"," \"Друзья\" ну типо вроде как комедия");
INSERT INTO text_bot VALUES("2540"," да херня какая-то");
INSERT INTO text_bot VALUES("2541"," я про тоже");
INSERT INTO text_bot VALUES("2542"," +24°");
INSERT INTO text_bot VALUES("2543"," да не,может так и останиться,время уже 13:11");
INSERT INTO text_bot VALUES("2544"," Москва?");
INSERT INTO text_bot VALUES("2545"," ааа, кто-то мне уже ник сделал");
INSERT INTO text_bot VALUES("2546"," ммм,ясно");
INSERT INTO text_bot VALUES("2547"," .вайвай.   ");
INSERT INTO text_bot VALUES("2548"," Если графник не нравится,переделаю...");
INSERT INTO text_bot VALUES("2549","Al Primo, .доброп2. ");
INSERT INTO text_bot VALUES("2550","Al Primo, .доброп4. ");
INSERT INTO text_bot VALUES("2551"," хорошо.А ты?");
INSERT INTO text_bot VALUES("2552"," конечно!! :) ");
INSERT INTO text_bot VALUES("2553"," конечно хорошо!");
INSERT INTO text_bot VALUES("2554"," в машине сижу.Поедем по магазинам с родителями.");
INSERT INTO text_bot VALUES("2555"," ну у нас не жарко сейчас.");
INSERT INTO text_bot VALUES("2556"," у нас с завтрашнего дня снова жара будет.");
INSERT INTO text_bot VALUES("2557"," грустно мне что то... .еа. ");
INSERT INTO text_bot VALUES("2558"," тоже хочу..ах.");
INSERT INTO text_bot VALUES("2559"," ладно проехали.");
INSERT INTO text_bot VALUES("2560"," уже не хочу ничего договаривать.");
INSERT INTO text_bot VALUES("2561"," ты прекрасно знаешь что я имела ввиду.");
INSERT INTO text_bot VALUES("2562"," а причём тут кто то?");
INSERT INTO text_bot VALUES("2563"," за кого например??");
INSERT INTO text_bot VALUES("2564"," .бон. ");
INSERT INTO text_bot VALUES("2565"," ну это же не только от меня зависит.");
INSERT INTO text_bot VALUES("2566"," это я должна предлагать??");
INSERT INTO text_bot VALUES("2567"," знаешь! :) ");
INSERT INTO text_bot VALUES("2568"," вот это мужики пошли)) вообще намеков не понимают))");
INSERT INTO text_bot VALUES("2569","AmFeTaMiNkA, .доброп4. ");
INSERT INTO text_bot VALUES("2570"," приветик.Это точно милая! .цвет5. ");
INSERT INTO text_bot VALUES("2571","AmFeTaMiNkA, .доброп2. ");
INSERT INTO text_bot VALUES("2572"," .день3. ");
INSERT INTO text_bot VALUES("2573","   .бла2. ");
INSERT INTO text_bot VALUES("2574"," .бон22. .ор.");
INSERT INTO text_bot VALUES("2575"," не до конца ещё.Но до пятницы надо доделать.");
INSERT INTO text_bot VALUES("2576"," у папы день рождение.60 лет будет.");
INSERT INTO text_bot VALUES("2577"," мама хочет на дачу в пятницу уехать, чтобы никто нежданно негаданно не пришол.");
INSERT INTO text_bot VALUES("2578"," я не хочу.");
INSERT INTO text_bot VALUES("2579"," папа обидеться если что.");
INSERT INTO text_bot VALUES("2580"," может ещё всё таки не поедем.");
INSERT INTO text_bot VALUES("2581"," .танц2. ");
INSERT INTO text_bot VALUES("2582"," .бон10. кому?.ор.");
INSERT INTO text_bot VALUES("2583"," мну");
INSERT INTO text_bot VALUES("2584"," лови. :) ");
INSERT INTO text_bot VALUES("2585"," .бон44. .ор.");
INSERT INTO text_bot VALUES("2586"," умница!Иду.");
INSERT INTO text_bot VALUES("2587","И тишина... .еа. ");
INSERT INTO text_bot VALUES("2588"," Я не поняла. А где поляна??? :15. ");
INSERT INTO text_bot VALUES("2589"," приветик. .цвет10. Так тебя ждём..ржу.");
INSERT INTO text_bot VALUES("2590"," круто поздоровался...");
INSERT INTO text_bot VALUES("2591"," Вечно напрашиваться надо  .ахах2.  ");
INSERT INTO text_bot VALUES("2592"," так ты не напрашивалась.Это я лоханулась..ржу.");
INSERT INTO text_bot VALUES("2593","  .спас16. ");
INSERT INTO text_bot VALUES("2594"," Вот я прям очень согласна  .ахах2.  ");
INSERT INTO text_bot VALUES("2595"," так и я с тобой согласна..ржу.");
INSERT INTO text_bot VALUES("2596","  .пупс15. ");
INSERT INTO text_bot VALUES("2597","  .апл2. Вот это даааа .д.д4. ");
INSERT INTO text_bot VALUES("2598"," :) Это хорошо ж");
INSERT INTO text_bot VALUES("2599"," По кофейку?  .еда9. ");
INSERT INTO text_bot VALUES("2600"," Отдыхаю. Скоро уже спать пойду. Чем занят ты?");
INSERT INTO text_bot VALUES("2601"," Есть такие чудики)");
INSERT INTO text_bot VALUES("2602"," .ночи39. ");
INSERT INTO text_bot VALUES("2603"," как ты солнце?!");
INSERT INTO text_bot VALUES("2604"," ну хорошо.Рада за тебя!");
INSERT INTO text_bot VALUES("2605"," да.Теперь только в душ надо сходить.");
INSERT INTO text_bot VALUES("2606"," да.С тобой буду!");
INSERT INTO text_bot VALUES("2607"," что ты без настроения походу.");
INSERT INTO text_bot VALUES("2608"," хорошо, если так.");
INSERT INTO text_bot VALUES("2609","Добрый всем вечерок");
INSERT INTO text_bot VALUES("2610"," добрый вечер! :) ");
INSERT INTO text_bot VALUES("2611"," та зашла зашла туды его налева");
INSERT INTO text_bot VALUES("2612","А чаво эть так тута тиха??????????");
INSERT INTO text_bot VALUES("2613"," так людей нет, некоторые заняты,у некоторых уже ночь и они спят.");
INSERT INTO text_bot VALUES("2614"," понятна");
INSERT INTO text_bot VALUES("2615"," .бон6. кому?.ор.");
INSERT INTO text_bot VALUES("2616"," мнуууу");
INSERT INTO text_bot VALUES("2617"," пасиб:)");
INSERT INTO text_bot VALUES("2618"," не за что. :) ");
INSERT INTO text_bot VALUES("2619","  .еда106. ");
INSERT INTO text_bot VALUES("2620"," только что из душа вышла и легла.");
INSERT INTO text_bot VALUES("2621"," есть немного.");
INSERT INTO text_bot VALUES("2622"," спасибо солнце.Постараюсь.");
INSERT INTO text_bot VALUES("2623"," а ты что за фильм смотришь?");
INSERT INTO text_bot VALUES("2624"," у нас 22:14 вечера.");
INSERT INTO text_bot VALUES("2625","ГоРьКиЙ ШоКоЛаД, .доброп2. ");
INSERT INTO text_bot VALUES("2626"," спать ещё как бы и рано.");
INSERT INTO text_bot VALUES("2627"," а что делать будем, солнце?");
INSERT INTO text_bot VALUES("2628"," вроде нормальное. .еа. ");
INSERT INTO text_bot VALUES("2629"," сама незнаю..ржу.");
INSERT INTO text_bot VALUES("2630"," ты всегда такой серьёзный?");
INSERT INTO text_bot VALUES("2631"," я походу поняла насчёт чего.");
INSERT INTO text_bot VALUES("2632","Zhem, .доп4. ");
INSERT INTO text_bot VALUES("2633"," а о чём, если не секрет?");
INSERT INTO text_bot VALUES("2634"," а что завтра?");
INSERT INTO text_bot VALUES("2635"," для меня это обычный день.");
INSERT INTO text_bot VALUES("2636"," и чем завтра будешь заниматься?");
INSERT INTO text_bot VALUES("2637"," ничего ещё не надумал?");
INSERT INTO text_bot VALUES("2638"," утром подумаешь.");
INSERT INTO text_bot VALUES("2639"," действительно,чего тут думать..ржу.");
INSERT INTO text_bot VALUES("2640"," серьёзный ты все время.");
INSERT INTO text_bot VALUES("2641"," от инета видимо она у тебя разболелась.");
INSERT INTO text_bot VALUES("2642"," если долго сидеть в инете в телефоне или компе то начинает у некоторых людей болеть голова.");
INSERT INTO text_bot VALUES("2643"," ну от чего тогда у тебя голова болит?");
INSERT INTO text_bot VALUES("2644"," возможно и это.");
INSERT INTO text_bot VALUES("2645"," ты за день в жару сколько раз в душ ходишь?");
INSERT INTO text_bot VALUES("2646"," а я три раза в день..ржу.");
INSERT INTO text_bot VALUES("2647"," наверное хорошо.");
INSERT INTO text_bot VALUES("2648"," я планы никакие не строила.");
INSERT INTO text_bot VALUES("2649"," помогаю конечно.");
INSERT INTO text_bot VALUES("2650"," спатки собираешься?");
INSERT INTO text_bot VALUES("2651"," ну скоро глазки закроются.");
INSERT INTO text_bot VALUES("2652"," ну если ты пойдешь спатки,то и я пойду.");
INSERT INTO text_bot VALUES("2653"," только когда...");
INSERT INTO text_bot VALUES("2654"," спатки пошол?");
INSERT INTO text_bot VALUES("2655"," .ночи41.  ");
INSERT INTO text_bot VALUES("2656","Бываю_Хорошей, .доброп4. ");
INSERT INTO text_bot VALUES("2657"," приветик))спасибо большое .дарюрозу. ");
INSERT INTO text_bot VALUES("2658"," Приветики  .цвет26. ");
INSERT INTO text_bot VALUES("2659"," .утрпоц.   ");
INSERT INTO text_bot VALUES("2660"," нет ещё.Не так же быстро...Он же не рядом с домом.");
INSERT INTO text_bot VALUES("2661"," на автобусе надо подъезжать.");
INSERT INTO text_bot VALUES("2662"," еду солнце.");
INSERT INTO text_bot VALUES("2663"," жарко с утра уже.");
INSERT INTO text_bot VALUES("2664"," а у нас жарища. .жарко. ");
INSERT INTO text_bot VALUES("2665","Red_Fox, .доп2. ");
INSERT INTO text_bot VALUES("2666"," никого нет, солнце.");
INSERT INTO text_bot VALUES("2667"," а чего стесняться?");
INSERT INTO text_bot VALUES("2668","Бомбочка, .доброп5. ");
INSERT INTO text_bot VALUES("2669","Бомбочка, .доп5. ");
INSERT INTO text_bot VALUES("2670","[marquee].бонус3.[/marquee]");
INSERT INTO text_bot VALUES("2671","[marquee].бон14.[/marquee]");
INSERT INTO text_bot VALUES("2672","Конечно нету общения! И жену не найти");
INSERT INTO text_bot VALUES("2673","Вот не надо я только с работы пришол, а на работе некогда заходить");
INSERT INTO text_bot VALUES("2674","Всем добраго вечёрочка:)");
INSERT INTO text_bot VALUES("2675"," и тебе.");
INSERT INTO text_bot VALUES("2676"," взаимна:)");
INSERT INTO text_bot VALUES("2677"," куды?.глаза.");
INSERT INTO text_bot VALUES("2678"," да потихонько:)");
INSERT INTO text_bot VALUES("2679"," добрый вечер!");
INSERT INTO text_bot VALUES("2680"," может ты в личке ответишь??");
INSERT INTO text_bot VALUES("2681"," телик смотрю:)");
INSERT INTO text_bot VALUES("2682"," Добрый.");
INSERT INTO text_bot VALUES("2683"," спасибо что ответил!");
INSERT INTO text_bot VALUES("2684"," слушаю Ваши желания:)");
INSERT INTO text_bot VALUES("2685"," давай придумувай.лол.");
INSERT INTO text_bot VALUES("2686"," я тожеть.лол.");
INSERT INTO text_bot VALUES("2687"," давай придумувай пока а я отлучусь на пару часиков и потом вернусь и выполню их хорошо?");
INSERT INTO text_bot VALUES("2688"," круто ты поступил со мной!!");
INSERT INTO text_bot VALUES("2689"," я тебе ничего плохого не сказала и не сделала!");
INSERT INTO text_bot VALUES("2690","Так,хватит прятаться.Все выходим по одному. :) ");
INSERT INTO text_bot VALUES("2691"," так ты и не прятался от меня. .бла2. ");
INSERT INTO text_bot VALUES("2692"," как день прошел?");
INSERT INTO text_bot VALUES("2693"," тоже нормально.Что делаешь?");
INSERT INTO text_bot VALUES("2694"," тут по сайту ползаю и на кровати валяюсь.");
INSERT INTO text_bot VALUES("2695"," на кровати валяться или тут ползать?");
INSERT INTO text_bot VALUES("2696"," вроде бы,да.");
INSERT INTO text_bot VALUES("2697"," конечно!");
INSERT INTO text_bot VALUES("2698"," ещё рано.А ты когда?");
INSERT INTO text_bot VALUES("2699"," вот и я говорю что рано ещё.");
INSERT INTO text_bot VALUES("2700"," часов в двенадцать пойдёшь спать?");
INSERT INTO text_bot VALUES("2701"," незнаю.Как глаза начнут закрываться.");
INSERT INTO text_bot VALUES("2702","пока что не закрываются...");
INSERT INTO text_bot VALUES("2703"," вроде да.Но среди ночи проснулась от того что загримело так,что окна начали дрожать.");
INSERT INTO text_bot VALUES("2704"," фильм так и не скачал ещё?");
INSERT INTO text_bot VALUES("2705"," все три части?");
INSERT INTO text_bot VALUES("2706"," обои заканчивали клеить.");
INSERT INTO text_bot VALUES("2707"," да.Наконец то! :) ");
INSERT INTO text_bot VALUES("2708"," походу что да.");
INSERT INTO text_bot VALUES("2709"," очень хорошо!");
INSERT INTO text_bot VALUES("2710"," незнаешь,чтоб такое утворить чтоб хотелось повторить? .бла2. ");
INSERT INTO text_bot VALUES("2711"," а я знаю.");
INSERT INTO text_bot VALUES("2712"," что такое утворить,чтоб хотелось повторить.");
INSERT INTO text_bot VALUES("2713"," сам знаешь что..ах.");
INSERT INTO text_bot VALUES("2714"," спасибо. .еа. ");
INSERT INTO text_bot VALUES("2715"," спасибо солнце моё!");
INSERT INTO text_bot VALUES("2716"," поверь ты мне,есть за что!");
INSERT INTO text_bot VALUES("2717","яанис, .доброп5. ");
INSERT INTO text_bot VALUES("2718"," доброе утро.");
INSERT INTO text_bot VALUES("2719","Всем хай");
INSERT INTO text_bot VALUES("2720"," Русик давно был?");
INSERT INTO text_bot VALUES("2721","Лан упиндел");
INSERT INTO text_bot VALUES("2722"," все заняты до вечера.Кто на работе,кто где.");
INSERT INTO text_bot VALUES("2723"," ну некоторые и работают в реале.");
INSERT INTO text_bot VALUES("2724","Skazo4nik, .доп4. ");
INSERT INTO text_bot VALUES("2725","NeGaTiVkA, .доп5. ");
INSERT INTO text_bot VALUES("2726"," привета :06. ");
INSERT INTO text_bot VALUES("2727"," всё вроде бы океешно .ялапа.  ");
INSERT INTO text_bot VALUES("2728"," Спасибо,за встречу .цветок4. ");
INSERT INTO text_bot VALUES("2729"," ни как иначе,а вы чего такой грустный .ойййййй.  ");
INSERT INTO text_bot VALUES("2730"," не за что! :) ");
INSERT INTO text_bot VALUES("2731"," Та ладно. Надо же с чего-то начинать.\r\nКак оно ничего?");
INSERT INTO text_bot VALUES("2732","да вроде бы всё нормально.А у вас?");
INSERT INTO text_bot VALUES("2733"," у нас тоже жара,терпеть лето не могу .еа. ");
INSERT INTO text_bot VALUES("2734"," мы на вы?");
INSERT INTO text_bot VALUES("2735"," Салют");
INSERT INTO text_bot VALUES("2736","А у нас в квартире газ .ржу2. ");
INSERT INTO text_bot VALUES("2737"," можно и на ты. :) ");
INSERT INTO text_bot VALUES("2738","Girl Style,щедро .спас22. ");
INSERT INTO text_bot VALUES("2739","Нужно. Знакомиться будем?");
INSERT INTO text_bot VALUES("2740"," я Снежана. :) ");
INSERT INTO text_bot VALUES("2741"," Макс. Прияно .лайк. ");
INSERT INTO text_bot VALUES("2742"," взаимно! :) ");
INSERT INTO text_bot VALUES("2743"," ну что будем знакомиться,меня Наташа зовут .глазами. ");
INSERT INTO text_bot VALUES("2744"," ты он или она.ржу.");
INSERT INTO text_bot VALUES("2745"," что с настроением?");
INSERT INTO text_bot VALUES("2746"," взаимно Руслан.миг.");
INSERT INTO text_bot VALUES("2747"," да всё хорошо! :) ");
INSERT INTO text_bot VALUES("2748"," как день?");
INSERT INTO text_bot VALUES("2749"," хорошо.То дела,то ещё что нибудь.А у тебя?");
INSERT INTO text_bot VALUES("2750","  тоже на работе.\r\n");
INSERT INTO text_bot VALUES("2751"," я с Краснодара .пардон2. ");
INSERT INTO text_bot VALUES("2752","Какая разница зачем? Если интересуюсь наверное нужен");
INSERT INTO text_bot VALUES("2753"," желаю хорошо отработать! :) ");
INSERT INTO text_bot VALUES("2754","Но не тут.лол.так же как и я не на своём.ржу.");
INSERT INTO text_bot VALUES("2755"," Спасибо.");
INSERT INTO text_bot VALUES("2756"," почти соседи)))");
INSERT INTO text_bot VALUES("2757"," два доктя по карте? .оченьдоволен. ");
INSERT INTO text_bot VALUES("2758","Локтя*");
INSERT INTO text_bot VALUES("2759"," часто заходит ,да сейчас на работе,заходит по возможнасти!");
INSERT INTO text_bot VALUES("2760"," тебя поставили зам создака ты даже илиментарщины невидишь");
INSERT INTO text_bot VALUES("2761"," графник сделаешь,или самому делать?");
INSERT INTO text_bot VALUES("2762"," по поводу графника тебе было\r\n");
INSERT INTO text_bot VALUES("2763"," но закинуть хоть сможешь?");
INSERT INTO text_bot VALUES("2764"," буду иметь ввиду");
INSERT INTO text_bot VALUES("2765"," мне он нужен");
INSERT INTO text_bot VALUES("2766"," че тут всегда так тихо?");
INSERT INTO text_bot VALUES("2767"," ясно,понятно,ок");
INSERT INTO text_bot VALUES("2768"," .бон23. ловим..ор.");
INSERT INTO text_bot VALUES("2769"," твои. :) Бегу!");
INSERT INTO text_bot VALUES("2770"," это работа админки .шутка. развивать общение,а не срезать его");
INSERT INTO text_bot VALUES("2771"," не спеши.ор.успеешь");
INSERT INTO text_bot VALUES("2772"," а я тихонько спешила..ржу.");
INSERT INTO text_bot VALUES("2773"," на слово тихо бот срабатывает.лол.?");
INSERT INTO text_bot VALUES("2774"," не видел.хз.");
INSERT INTO text_bot VALUES("2775"," он и на спокойной ночи срабатывает..ржу.");
INSERT INTO text_bot VALUES("2776"," так ты не понял.Звать и общаться - разные вещи");
INSERT INTO text_bot VALUES("2777"," хоть кто то желать будет снуликов.лол.");
INSERT INTO text_bot VALUES("2778"," посмотрим");
INSERT INTO text_bot VALUES("2779"," да не оправдывайся.порядок же");
INSERT INTO text_bot VALUES("2780"," че злой то такой.лол.");
INSERT INTO text_bot VALUES("2781","КареглаЗая .цвет8. ");
INSERT INTO text_bot VALUES("2782","КареглаЗая, .доп6. ");
INSERT INTO text_bot VALUES("2783"," .бон10. ловим..ор.");
INSERT INTO text_bot VALUES("2784"," как скажешь..мои");
INSERT INTO text_bot VALUES("2785","твои! :) ");
INSERT INTO text_bot VALUES("2786"," ты боишься общаться,чтоб муж не ревновал?");
INSERT INTO text_bot VALUES("2787"," до пяти,да");
INSERT INTO text_bot VALUES("2788"," не плохо. ты чем занят?");
INSERT INTO text_bot VALUES("2789","[marquee]КОМУ? .бон59.[/marquee]");
INSERT INTO text_bot VALUES("2790","[marquee].бон16.[/marquee]");
INSERT INTO text_bot VALUES("2791",".жду.");
INSERT INTO text_bot VALUES("2792"," Твои 200 монет");
INSERT INTO text_bot VALUES("2793"," хм.дум.а ещё 300 где дела?.лол.");
INSERT INTO text_bot VALUES("2794"," Извиняюсь.ржу.");
INSERT INTO text_bot VALUES("2795"," .жду.что значит девушка.уже зарплату переделила.лол.как жена прям");
INSERT INTO text_bot VALUES("2796"," что интересного?");
INSERT INTO text_bot VALUES("2797","  .ахах2.  ");
INSERT INTO text_bot VALUES("2798"," .жду.репетируешь на мне?.лол.");
INSERT INTO text_bot VALUES("2799"," хз о чём это,я его не смотрю вообще");
INSERT INTO text_bot VALUES("2800"," ты не ответила на вопрос.жду.");
INSERT INTO text_bot VALUES("2801"," думаешь начать шаманить?.ржу.");
INSERT INTO text_bot VALUES("2802"," Ню");
INSERT INTO text_bot VALUES("2803"," а ты умеешь поддержать разговор .заволосы. имя скажешь своё1?");
INSERT INTO text_bot VALUES("2804"," а смотреть тогда нах?");
INSERT INTO text_bot VALUES("2805"," Ольга имя моё. Ваше как?");
INSERT IN