DROP TABLE IF EXISTS `Ponaehali`;

CREATE TABLE `Ponaehali` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `time_end` int(11) DEFAULT '0',
  `male` int(11) DEFAULT '0',
  `female` int(11) DEFAULT '0',
  `win` varchar(128) DEFAULT '0',
  `active` int(1) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_chat`;

CREATE TABLE `Ponaehali_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_tournament` int(11) DEFAULT '0',
  `sex` varchar(12) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_users`;

CREATE TABLE `Ponaehali_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `level` int(11) DEFAULT '0',
  `sex` varchar(32) NOT NULL DEFAULT 'male',
  `rating` int(11) DEFAULT '0',
  `time_reboot` int(11) DEFAULT '0',
  `count_weapon` int(11) DEFAULT '0',
  `count_win` int(11) DEFAULT '0',
  `count_loss` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `Ponaehali_weapons`;

CREATE TABLE `Ponaehali_weapons` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) DEFAULT '0',
  `id_tournament` int(11) DEFAULT '0',
  `id_weapon` int(11) DEFAULT '1',
  `type` varchar(32) DEFAULT 'tomate',
  `style` varchar(512) DEFAULT '',
  `sex` varchar(128) DEFAULT 'male',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football`;

CREATE TABLE `_football` (
  `sid` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `balls` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  `boys` int(11) DEFAULT '0',
  `gerls` int(11) DEFAULT '0',
  `winner` varchar(128) DEFAULT '0',
  `active` enum('0','1') NOT NULL DEFAULT '0',
  `time_stop` int(11) DEFAULT '0',
  PRIMARY KEY (`sid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_blow`;

CREATE TABLE `_football_blow` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `sex` varchar(16) DEFAULT 'male',
  `id_football` int(11) DEFAULT '0',
  `msg` text,
  `time` int(11) NOT NULL,
  `udar` int(11) DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_chat`;

CREATE TABLE `_football_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `_football_user`;

CREATE TABLE `_football_user` (
  `aid` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `date_r` int(11) NOT NULL,
  `blows` int(11) NOT NULL DEFAULT '0',
  `sex` varchar(16) NOT NULL DEFAULT 'male',
  `time_reset` int(11) DEFAULT '0',
  `blows_past` int(11) NOT NULL DEFAULT '0',
  `life` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`aid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `activnost`;

CREATE TABLE `activnost` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `msg` varchar(400) DEFAULT NULL,
  `time` int(11) DEFAULT NULL,
  `id_user` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `adm_chat`;

CREATE TABLE `adm_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `adm_logs`;

CREATE TABLE `adm_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` char(15) NOT NULL,
  `who` int(11) NOT NULL DEFAULT '0',
  `type` char(10) NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `why` char(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log`;

CREATE TABLE `admin_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `id_user` int(10) unsigned NOT NULL,
  `time` int(10) unsigned NOT NULL,
  `mod` int(11) NOT NULL,
  `act` int(11) NOT NULL,
  `opis` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `mod` (`mod`),
  KEY `act` (`act`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log_act`;

CREATE TABLE `admin_log_act` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_mod` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `act` (`name`),
  KEY `id_mod` (`id_mod`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_log_mod`;

CREATE TABLE `admin_log_mod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `name` (`name`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `admin_logs`;

CREATE TABLE `admin_logs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `albums`;

CREATE TABLE `albums` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `parol` int(11) NOT NULL DEFAULT '0',
  `friend_looks` smallint(2) NOT NULL DEFAULT '0',
  `path` char(100) NOT NULL,
  `name` char(50) NOT NULL,
  `type` char(1) NOT NULL,
  `cat` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `rotate` int(11) NOT NULL DEFAULT '0',
  `friend_comm` smallint(2) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  `cover` smallint(1) NOT NULL DEFAULT '0',
  `block` smallint(1) NOT NULL DEFAULT '0',
  `who_block` int(11) NOT NULL DEFAULT '0',
  `why_block` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `all_accesses`;

CREATE TABLE `all_accesses` (
  `type` varchar(32) NOT NULL,
  `name` varchar(64) NOT NULL,
  KEY `type` (`type`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO all_accesses VALUES("adm_panel_show","Админка - доступ к разделам админки");
INSERT INTO all_accesses VALUES("loads_file_upload","Загрузки - выгрузка файлов");
INSERT INTO all_accesses VALUES("loads_dir_mesto","Загрузки - перемещение папок");
INSERT INTO all_accesses VALUES("loads_dir_delete","Загрузки - удаление папок");
INSERT INTO all_accesses VALUES("loads_dir_rename","Загрузки - переименование папок");
INSERT INTO all_accesses VALUES("loads_dir_create","Загрузки - создание папок");
INSERT INTO all_accesses VALUES("loads_file_edit","Загрузки - параметры файлов");
INSERT INTO all_accesses VALUES("loads_file_delete","Загрузки - удаление файлов");
INSERT INTO all_accesses VALUES("loads_unzip","Загрузки - Распаковка ZIP");
INSERT INTO all_accesses VALUES("lib_stat_zip","Библиотека - выгрузка статей в ZIP");
INSERT INTO all_accesses VALUES("lib_stat_txt","Библиотека - выгрузка статей в txt");
INSERT INTO all_accesses VALUES("lib_stat_create","Библиотека - создание статей");
INSERT INTO all_accesses VALUES("lib_dir_delete","Библиотека - удаление папок");
INSERT INTO all_accesses VALUES("lib_dir_mesto","Библиотека - перемещение папок");
INSERT INTO all_accesses VALUES("lib_dir_edit","Библиотека - редактирование папок");
INSERT INTO all_accesses VALUES("lib_dir_create","Библиотека - создание папок");
INSERT INTO all_accesses VALUES("lib_stat_delete","Библиотека - удаление статей");
INSERT INTO all_accesses VALUES("votes_settings","Голосования - закрытие/удаление");
INSERT INTO all_accesses VALUES("votes_create","Голосования - создание");
INSERT INTO all_accesses VALUES("guest_clear","Гостевая - очистка");
INSERT INTO all_accesses VALUES("guest_delete","Гостевая - удаление постов");
INSERT INTO all_accesses VALUES("obmen_dir_delete","Обменник - удаление папок");
INSERT INTO all_accesses VALUES("obmen_dir_edit","Обменник - управление папками");
INSERT INTO all_accesses VALUES("obmen_dir_create","Обменник - создание папок");
INSERT INTO all_accesses VALUES("obmen_file_delete","Обменник - удаление файлов");
INSERT INTO all_accesses VALUES("obmen_file_edit","Обменник - редактирование файлов");
INSERT INTO all_accesses VALUES("obmen_komm_del","Обменник - удаление комментариев");
INSERT INTO all_accesses VALUES("foto_foto_edit","Фотогалерея - редактирование/удаление фото");
INSERT INTO all_accesses VALUES("foto_alb_del","Фотогалерея - удаление альбомов");
INSERT INTO all_accesses VALUES("foto_komm_del","Фотогалерея - удаление комментариев");
INSERT INTO all_accesses VALUES("forum_razd_create","Форум - создание разделов");
INSERT INTO all_accesses VALUES("forum_for_delete","Форум - удаление подфорумов");
INSERT INTO all_accesses VALUES("forum_for_edit","Форум - редактирование подфорумов");
INSERT INTO all_accesses VALUES("forum_for_create","Форум - создание подфорумов");
INSERT INTO all_accesses VALUES("forum_razd_edit","Форум - управление разделами");
INSERT INTO all_accesses VALUES("adm_info","Админка - общая информация");
INSERT INTO all_accesses VALUES("forum_them_edit","Форум - редактирование тем");
INSERT INTO all_accesses VALUES("forum_them_del","Форум - удаление тем");
INSERT INTO all_accesses VALUES("forum_post_ed","Форум - редактирование сообщений");
INSERT INTO all_accesses VALUES("chat_clear","Чат - очистка");
INSERT INTO all_accesses VALUES("chat_room","Чат - управление комнатами");
INSERT INTO all_accesses VALUES("adm_statistic","Админка - статистика");
INSERT INTO all_accesses VALUES("adm_banlist","Админка - список забаненых");
INSERT INTO all_accesses VALUES("adm_menu","Админка - главное меню");
INSERT INTO all_accesses VALUES("adm_news","Админка - новости");
INSERT INTO all_accesses VALUES("adm_rekl","Админка - реклама");
INSERT INTO all_accesses VALUES("adm_set_sys","Админка - настройки системы");
INSERT INTO all_accesses VALUES("adm_set_loads","Админка - настройки загруз-центра");
INSERT INTO all_accesses VALUES("adm_set_user","Админка - пользовательские настройки");
INSERT INTO all_accesses VALUES("adm_set_chat","Админка - настройки чата");
INSERT INTO all_accesses VALUES("adm_set_forum","Админка - настройки форума");
INSERT INTO all_accesses VALUES("adm_set_foto","Админка - настройки фотогалереи");
INSERT INTO all_accesses VALUES("adm_forum_sinc","Админка - синхронизация таблиц форума");
INSERT INTO all_accesses VALUES("adm_themes","Админка - темы оформления");
INSERT INTO all_accesses VALUES("adm_log_read","Админка - лог действий администрации");
INSERT INTO all_accesses VALUES("adm_log_delete","Админка - удаление лога");
INSERT INTO all_accesses VALUES("adm_mysql","Админка - MySQL запросы !!!");
INSERT INTO all_accesses VALUES("adm_ref","Админка - рефералы");
INSERT INTO all_accesses VALUES("adm_show_adm","Админка - список администрации");
INSERT INTO all_accesses VALUES("adm_ip_edit","Админка - редактирование IP операторов");
INSERT INTO all_accesses VALUES("adm_ban_ip","Админка - бан по IP");
INSERT INTO all_accesses VALUES("adm_accesses","Привилегии групп пользователей !!!");
INSERT INTO all_accesses VALUES("user_delete","Пользователи - удаление");
INSERT INTO all_accesses VALUES("user_mass_delete","Пользователи - массовое удаление");
INSERT INTO all_accesses VALUES("user_ban_set","Пользователи - бан");
INSERT INTO all_accesses VALUES("user_ban_unset","Пользователи - снятие бана");
INSERT INTO all_accesses VALUES("user_prof_edit","Пользователи - редактирование профиля");
INSERT INTO all_accesses VALUES("user_collisions","Пользователи - совпадения ников");
INSERT INTO all_accesses VALUES("user_show_ip","Пользователи - показывать IP");
INSERT INTO all_accesses VALUES("user_show_ua","Пользователи - показ USER-AGENT");
INSERT INTO all_accesses VALUES("user_show_add_info","Пользователи - показ доп. информации");
INSERT INTO all_accesses VALUES("guest_show_ip","Гости - показ IP");
INSERT INTO all_accesses VALUES("user_change_group","Пользователи - смена группы привилегий");
INSERT INTO all_accesses VALUES("user_ban_set_h","Пользователи - бан (max 1 сутки)");
INSERT INTO all_accesses VALUES("forum_post_close","Форум - возможность писать в закрытой теме");
INSERT INTO all_accesses VALUES("user_change_nick","Пользователи - смена ника");
INSERT INTO all_accesses VALUES("loads_file_import","Загрузки - импорт файлов");
INSERT INTO all_accesses VALUES("adm_lib_repair","Восстановление библиотеки");
INSERT INTO all_accesses VALUES("notes_edit","Дневники - редактирование");
INSERT INTO all_accesses VALUES("notes_delete","Дневники - удаление");
INSERT INTO all_accesses VALUES("adm_mwb","Острослов - администрирование модуля");
INSERT INTO all_accesses VALUES("ranksSend","Награждение Юзеров");
INSERT INTO all_accesses VALUES("ranksUserDelete","Удаление Наград у Юзеров");
INSERT INTO all_accesses VALUES("ranksEdit","Редактирование и Удаление Наград");
INSERT INTO all_accesses VALUES("mddjine_admin","аукцион джинов - управление ");
INSERT INTO all_accesses VALUES("sc_vip_admin","Управление випстатусом");
INSERT INTO all_accesses VALUES("klan_edit_md","Кланы - управление кланами");
INSERT INTO all_accesses VALUES("foto_foto_edity","Фотодуэли - настройка модуля");
INSERT INTO all_accesses VALUES("mdchild_admin","Малютка - управление");
INSERT INTO all_accesses VALUES("zarnica_setup","Зарница - администрирование модуля");
INSERT INTO all_accesses VALUES("adm_zarnica","Зарница - администрирование модуля");
INSERT INTO all_accesses VALUES("adm_set_action","Действия - управление модулем");
INSERT INTO all_accesses VALUES("user_administration_voyti","Упровление акаунтом");
INSERT INTO all_accesses VALUES("skachki_edit","Скачки - редактирование");
INSERT INTO all_accesses VALUES("skachki_del","Скачки - удаление");
INSERT INTO all_accesses VALUES("skachki_add","Скачки - добавление");
INSERT INTO all_accesses VALUES("mdloss","Призы сайта - управление");
INSERT INTO all_accesses VALUES("mod_gazeta","Управление газетой");



DROP TABLE IF EXISTS `anagramma`;

CREATE TABLE `anagramma` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `original_text` varchar(32) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `anagramma_form`;

CREATE TABLE `anagramma_form` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=1271 DEFAULT CHARSET=utf8;

INSERT INTO anagramma_form VALUES("4","0","1591035230","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("5","1","1591036329","Небо");
INSERT INTO anagramma_form VALUES("6","0","1591036329","support получает 4 балла! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("7","1","1591036592","Блины");
INSERT INTO anagramma_form VALUES("8","0","1591036592","support получает 5 баллов! Правильное слово: блины");
INSERT INTO anagramma_form VALUES("9","1","1591037339","Ворона");
INSERT INTO anagramma_form VALUES("10","0","1591037339","support получает 6 баллов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("11","1","1591037778","Шоколад");
INSERT INTO anagramma_form VALUES("12","0","1591037778","support получает 7 баллов! Правильное слово: шоколад");
INSERT INTO anagramma_form VALUES("14","0","1591038270","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("15","0","1591039108","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("16","0","1591039122","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("17","1","1591039134","Пульт");
INSERT INTO anagramma_form VALUES("18","0","1591039134","support получает 5 баллов! Правильное слово: пульт");
INSERT INTO anagramma_form VALUES("19","0","1591039269","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("20","1","1591039284","Роль");
INSERT INTO anagramma_form VALUES("21","0","1591039284","support получает 4 балла! Правильное слово: роль");
INSERT INTO anagramma_form VALUES("26","0","1591039676","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("25","0","1591039309","support получает 3 балла! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("27","0","1591039851","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("28","0","1591039996","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("29","0","1591040126","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("30","324","1591040161","Туалет");
INSERT INTO anagramma_form VALUES("31","0","1591040161","ФЕНИКС получает 6 баллов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("32","0","1591040190","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("33","1","1591040199","Сайт");
INSERT INTO anagramma_form VALUES("34","0","1591040199","support получает 4 баллов! Правильное слово: сайт");
INSERT INTO anagramma_form VALUES("35","0","1591040236","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("36","1","1591040401","Лорь");
INSERT INTO anagramma_form VALUES("37","1","1591040411","Роль");
INSERT INTO anagramma_form VALUES("38","0","1591040411","support получает 4 баллов! Правильное слово: роль");
INSERT INTO anagramma_form VALUES("39","1","1591040438","Дорог");
INSERT INTO anagramma_form VALUES("40","1","1591040451","Город");
INSERT INTO anagramma_form VALUES("41","0","1591040451","support получает 5 баллов! Правильное слово: город");
INSERT INTO anagramma_form VALUES("42","0","1591046942","Саня в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("43","0","1591046976","Саня в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("44","0","1591047006","Саня в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("45","0","1591071469","Bagira903 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("46","0","1591080916","ЧиКа_НуТаЯ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("47","344","1591080930","Сахар");
INSERT INTO anagramma_form VALUES("48","0","1591080930","ЧиКа_НуТаЯ получает 5 баллов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("49","344","1591080962","Рука");
INSERT INTO anagramma_form VALUES("50","0","1591080962","ЧиКа_НуТаЯ получает 4 баллов! Правильное слово: рука");
INSERT INTO anagramma_form VALUES("51","344","1591080975","Птица");
INSERT INTO anagramma_form VALUES("52","0","1591080975","ЧиКа_НуТаЯ получает 5 баллов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("53","344","1591080997","Друг");
INSERT INTO anagramma_form VALUES("54","0","1591080997","ЧиКа_НуТаЯ получает 4 баллов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("55","344","1591081010","Шапка");
INSERT INTO anagramma_form VALUES("56","0","1591081010","ЧиКа_НуТаЯ получает 5 баллов! Правильное слово: шапка");
INSERT INTO anagramma_form VALUES("57","0","1591123675","Unbearable в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("58","339","1591123694","Кузнец ");
INSERT INTO anagramma_form VALUES("59","0","1591204420","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("60","0","1591205176","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("61","0","1591205489","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("62","0","1591206446","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("63","324","1591206466","Стройка");
INSERT INTO anagramma_form VALUES("64","0","1591279918","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("65","0","1591297603","LOVE ME в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("66","362","1591297613","Ток");
INSERT INTO anagramma_form VALUES("67","0","1591297613","LOVE ME получает 3 баллов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("68","0","1591375104","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("69","1","1591375120","Бомж");
INSERT INTO anagramma_form VALUES("70","0","1591375120","support получает 4 баллов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("71","1","1591386710","Ydhdududu");
INSERT INTO anagramma_form VALUES("72","0","1591433290","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("73","1","1591433313","Обезьяна");
INSERT INTO anagramma_form VALUES("74","0","1591433313","support получает 8 баллов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("79","1","1591435807","Арбуз");
INSERT INTO anagramma_form VALUES("80","0","1591435807","support получает 5 баллов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("81","0","1591435963","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("82","1","1591435983","Gggg");
INSERT INTO anagramma_form VALUES("83","0","1591438630","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("84","1","1591438642","Банк");
INSERT INTO anagramma_form VALUES("85","0","1591438642","support получает 4 баллов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("86","0","1591439415","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("91","0","1591635908","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("92","0","1591637128","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("93","1","1591637150","Небо");
INSERT INTO anagramma_form VALUES("94","0","1591637150","support получает 4 баллов! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("95","1","1591637503","Сахар");
INSERT INTO anagramma_form VALUES("96","0","1591637503","support получает 5 баллов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("97","1","1591637879","Туалет");
INSERT INTO anagramma_form VALUES("98","0","1591637879","support получает рубинов ! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("99","1","1591638149","Банк");
INSERT INTO anagramma_form VALUES("100","0","1591638149","support получает рубинов рубинов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("101","1","1591638207","Зажим");
INSERT INTO anagramma_form VALUES("102","0","1591638207","support получает рубинов ! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("103","1","1591638247","Болото");
INSERT INTO anagramma_form VALUES("104","0","1591638247","support получает рубинов ! Правильное слово: болото");
INSERT INTO anagramma_form VALUES("105","0","1591638273","Kivi_Swoy в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("106","1","1591638280","Кот");
INSERT INTO anagramma_form VALUES("107","1","1591638292","Ток");
INSERT INTO anagramma_form VALUES("108","0","1591638292","support получает рубинов Array! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("112","1","1591638436","Гордо");
INSERT INTO anagramma_form VALUES("111","0","1591638370","support получает рубин Array! Правильное слово: часы");
INSERT INTO anagramma_form VALUES("113","1","1591638453","Дорог");
INSERT INTO anagramma_form VALUES("114","1","1591638470","Город");
INSERT INTO anagramma_form VALUES("115","0","1591638470","support получает рубин Array! Правильное слово: город");
INSERT INTO anagramma_form VALUES("116","1","1591638474","Город");
INSERT INTO anagramma_form VALUES("117","0","1591638474","support получает рубин Array! Правильное слово: город");
INSERT INTO anagramma_form VALUES("118","1","1591639119","Течение");
INSERT INTO anagramma_form VALUES("119","0","1591639119","support получает рубинов рубинов! Правильное слово: течение");
INSERT INTO anagramma_form VALUES("120","0","1591639182","Kivi_Swoy в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("121","401","1591639226","грук");
INSERT INTO anagramma_form VALUES("122","401","1591639249","круг");
INSERT INTO anagramma_form VALUES("123","0","1591639249","Kivi_Swoy получает рубинов рубинов! Правильное слово: круг");
INSERT INTO anagramma_form VALUES("124","401","1591639297","и нече нет ");
INSERT INTO anagramma_form VALUES("125","401","1591639312","и нече нет обман.лол.");
INSERT INTO anagramma_form VALUES("126","401","1591639338","и нече нет обман.лол.");
INSERT INTO anagramma_form VALUES("129","1","1591639464","Игра в разработке перевожу с балов на рубины");
INSERT INTO anagramma_form VALUES("128","401","1591639321","и нече нет обман.лол.");
INSERT INTO anagramma_form VALUES("130","1","1591639593","Хоккей");
INSERT INTO anagramma_form VALUES("131","0","1591639593","support получает рубинов рубинов! Правильное слово: хоккей");
INSERT INTO anagramma_form VALUES("132","401","1591639675","сахар");
INSERT INTO anagramma_form VALUES("133","0","1591639675","Kivi_Swoy получает рубинов рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("134","1","1591639781","Лошадь");
INSERT INTO anagramma_form VALUES("135","0","1591639781","support получает рубинов рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("136","1","1591639848","Арбуз");
INSERT INTO anagramma_form VALUES("137","0","1591639848","support получает рубинов рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("139","1","1591640406","Друг");
INSERT INTO anagramma_form VALUES("140","0","1591640406","support получает 4 баллов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("141","1","1591640601","Дом");
INSERT INTO anagramma_form VALUES("142","0","1591640601","support получает  рубин! Правильное слово: дом");
INSERT INTO anagramma_form VALUES("143","1","1591640750","Песня");
INSERT INTO anagramma_form VALUES("144","0","1591640750","support получает  рубин! Правильное слово: песня");
INSERT INTO anagramma_form VALUES("145","1","1591640872","Заяц");
INSERT INTO anagramma_form VALUES("146","0","1591640872","support получает  ! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("147","1","1591641121","Деньги");
INSERT INTO anagramma_form VALUES("148","0","1591641121","support получает  баллов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("149","1","1591641612","Гонар");
INSERT INTO anagramma_form VALUES("150","1","1591641625","Нагор");
INSERT INTO anagramma_form VALUES("151","1","1591641645","Онгар");
INSERT INTO anagramma_form VALUES("152","1","1591641668","Гарон");
INSERT INTO anagramma_form VALUES("153","1","1591641698","Рагон");
INSERT INTO anagramma_form VALUES("154","1","1591641717","Ангор");
INSERT INTO anagramma_form VALUES("155","1","1591641736","Огран");
INSERT INTO anagramma_form VALUES("156","1","1591641788","Данил");
INSERT INTO anagramma_form VALUES("157","1","1591641801","Дилан");
INSERT INTO anagramma_form VALUES("158","1","1591641815","Длина");
INSERT INTO anagramma_form VALUES("159","0","1591641815","support получает  ! Правильное слово: длина");
INSERT INTO anagramma_form VALUES("160","1","1591645318","Зажим");
INSERT INTO anagramma_form VALUES("161","0","1591645318","support получает 5 баллов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("162","1","1591645499","Работа");
INSERT INTO anagramma_form VALUES("163","0","1591645499","support получает 6 баллов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("164","0","1591645751","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("165","1","1591645766","Очки");
INSERT INTO anagramma_form VALUES("166","0","1591645766","support получает 4 рубинов! Правильное слово: очки");
INSERT INTO anagramma_form VALUES("167","1","1591645847","Катастрофа");
INSERT INTO anagramma_form VALUES("168","0","1591645847","support получает 10 рубинов! Правильное слово: катастрофа");
INSERT INTO anagramma_form VALUES("169","0","1591645894","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("170","0","1591645948","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("171","1","1591646088","Бегемот");
INSERT INTO anagramma_form VALUES("172","0","1591646088","support получает 7 рубинов! Правильное слово: бегемот");
INSERT INTO anagramma_form VALUES("173","402","1591646145","Шапка");
INSERT INTO anagramma_form VALUES("174","0","1591646145","KaterinkA получает 5 рубинов! Правильное слово: шапка");
INSERT INTO anagramma_form VALUES("175","402","1591646181","Заруб");
INSERT INTO anagramma_form VALUES("176","402","1591646225","Арбуз");
INSERT INTO anagramma_form VALUES("177","0","1591646225","KaterinkA получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("178","402","1591646245","Арбуз");
INSERT INTO anagramma_form VALUES("179","0","1591646245","KaterinkA получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("180","402","1591646317","Венерица");
INSERT INTO anagramma_form VALUES("181","1","1591646335","Перекресток");
INSERT INTO anagramma_form VALUES("182","402","1591646350","Царевне");
INSERT INTO anagramma_form VALUES("183","1","1591646389","Перекрёсток");
INSERT INTO anagramma_form VALUES("184","0","1591646389","support получает 11 рубинов! Правильное слово: перекрёсток");
INSERT INTO anagramma_form VALUES("185","1","1591646432","Город");
INSERT INTO anagramma_form VALUES("186","0","1591646432","support получает 5 рубинов! Правильное слово: город");
INSERT INTO anagramma_form VALUES("187","402","1591646475","Зажим");
INSERT INTO anagramma_form VALUES("188","0","1591646475","KaterinkA получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("189","402","1591646494","Деньги");
INSERT INTO anagramma_form VALUES("190","0","1591646494","KaterinkA получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("191","0","1591646886","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("192","1","1591646898","Муббота");
INSERT INTO anagramma_form VALUES("195","0","1591647215","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("194","0","1591646906","support получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("196","402","1591647236","Обезьяна");
INSERT INTO anagramma_form VALUES("197","0","1591647236","KaterinkA получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("198","402","1591647267","Зажим");
INSERT INTO anagramma_form VALUES("199","0","1591647267","KaterinkA получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("200","0","1591734254","ФЕНИКС в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("201","324","1591734293","Речной");
INSERT INTO anagramma_form VALUES("202","0","1591734293","ФЕНИКС получает 6 рубинов! Правильное слово: речной");
INSERT INTO anagramma_form VALUES("203","0","1591760319","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("204","402","1591760341","Ввод");
INSERT INTO anagramma_form VALUES("205","0","1591760341","KaterinkA получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("206","402","1591760357","Фальш");
INSERT INTO anagramma_form VALUES("207","0","1591760357","KaterinkA получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("208","402","1591760384","Лошадь");
INSERT INTO anagramma_form VALUES("209","0","1591760384","KaterinkA получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("210","402","1591760400","Плюс");
INSERT INTO anagramma_form VALUES("211","402","1591760448","Сплю");
INSERT INTO anagramma_form VALUES("212","0","1591760448","KaterinkA получает 4 рубинов! Правильное слово: сплю");
INSERT INTO anagramma_form VALUES("213","402","1591760460","Небесный");
INSERT INTO anagramma_form VALUES("214","0","1591760460","KaterinkA получает 8 рубинов! Правильное слово: небесный");
INSERT INTO anagramma_form VALUES("215","402","1591760687","Варона");
INSERT INTO anagramma_form VALUES("216","402","1591760702","Ворона");
INSERT INTO anagramma_form VALUES("217","0","1591760702","KaterinkA получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("218","402","1591760712","Плуть");
INSERT INTO anagramma_form VALUES("219","402","1591760740","Птуль");
INSERT INTO anagramma_form VALUES("220","402","1591760903","Блины");
INSERT INTO anagramma_form VALUES("221","0","1591760903","KaterinkA получает 5 рубинов! Правильное слово: блины");
INSERT INTO anagramma_form VALUES("222","402","1591760919","Салют");
INSERT INTO anagramma_form VALUES("223","0","1591760919","KaterinkA получает 5 рубинов! Правильное слово: салют");
INSERT INTO anagramma_form VALUES("224","402","1591760928","Футбол");
INSERT INTO anagramma_form VALUES("225","0","1591760928","KaterinkA получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("226","402","1591760980","Венерица");
INSERT INTO anagramma_form VALUES("227","402","1591761122","Обезьяна");
INSERT INTO anagramma_form VALUES("228","0","1591761122","KaterinkA получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("229","0","1591761500","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("230","402","1591761511","Имя");
INSERT INTO anagramma_form VALUES("231","0","1591761511","KaterinkA получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("232","402","1591761526","Сырость");
INSERT INTO anagramma_form VALUES("233","0","1591761526","KaterinkA получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("234","402","1591761537","Приют");
INSERT INTO anagramma_form VALUES("235","0","1591761537","KaterinkA получает 5 рубинов! Правильное слово: приют");
INSERT INTO anagramma_form VALUES("236","402","1591761618","Перебор");
INSERT INTO anagramma_form VALUES("237","0","1591761618","KaterinkA получает 7 рубинов! Правильное слово: перебор");
INSERT INTO anagramma_form VALUES("238","402","1591761629","Былины");
INSERT INTO anagramma_form VALUES("239","402","1591761638","Блины");
INSERT INTO anagramma_form VALUES("240","0","1591761638","KaterinkA получает 5 рубинов! Правильное слово: блины");
INSERT INTO anagramma_form VALUES("241","402","1591761646","Руки");
INSERT INTO anagramma_form VALUES("242","0","1591761646","KaterinkA получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("243","0","1591784724","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("244","0","1591802017","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("245","0","1591886988","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("246","402","1591887007","Кровавый");
INSERT INTO anagramma_form VALUES("247","0","1591887007","KaterinkA получает 8 рубинов! Правильное слово: кровавый");
INSERT INTO anagramma_form VALUES("248","402","1591887016","Ведро");
INSERT INTO anagramma_form VALUES("249","402","1591887035","Дерево");
INSERT INTO anagramma_form VALUES("250","0","1591887035","KaterinkA получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("251","402","1591887057","Суббота");
INSERT INTO anagramma_form VALUES("252","0","1591887057","KaterinkA получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("253","402","1591887069","Онгар");
INSERT INTO anagramma_form VALUES("254","402","1591887096","Аргон");
INSERT INTO anagramma_form VALUES("255","0","1591898462","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("256","402","1591898475","Атлас");
INSERT INTO anagramma_form VALUES("257","402","1591898562","Салат");
INSERT INTO anagramma_form VALUES("258","0","1591898562","KaterinkA получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("259","402","1591898573","Калибр");
INSERT INTO anagramma_form VALUES("260","0","1591898573","KaterinkA получает 6 рубинов! Правильное слово: калибр");
INSERT INTO anagramma_form VALUES("261","402","1591898584","Небо");
INSERT INTO anagramma_form VALUES("262","0","1591898584","KaterinkA получает 4 рубинов! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("263","402","1591898603","Ввод");
INSERT INTO anagramma_form VALUES("264","0","1591898603","KaterinkA получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("265","402","1591898627","Клавиатура");
INSERT INTO anagramma_form VALUES("266","0","1591898627","KaterinkA получает 10 рубинов! Правильное слово: клавиатура");
INSERT INTO anagramma_form VALUES("267","0","1591898733","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("268","402","1591898748","Суббота");
INSERT INTO anagramma_form VALUES("269","0","1591898748","KaterinkA получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("270","402","1591898754","Дом");
INSERT INTO anagramma_form VALUES("271","0","1591898754","KaterinkA получает 3 рубинов! Правильное слово: дом");
INSERT INTO anagramma_form VALUES("272","402","1591898772","Приют");
INSERT INTO anagramma_form VALUES("273","0","1591898772","KaterinkA получает 5 рубинов! Правильное слово: приют");
INSERT INTO anagramma_form VALUES("274","402","1591898807","Замкнуты");
INSERT INTO anagramma_form VALUES("275","402","1591898847","Музыканты");
INSERT INTO anagramma_form VALUES("276","402","1591898860","Музыкант");
INSERT INTO anagramma_form VALUES("277","0","1591898860","KaterinkA получает 8 рубинов! Правильное слово: музыкант");
INSERT INTO anagramma_form VALUES("278","402","1591898889","Сырость");
INSERT INTO anagramma_form VALUES("279","0","1591898889","KaterinkA получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("280","402","1591899100","Полата");
INSERT INTO anagramma_form VALUES("281","402","1591899145","Лопата");
INSERT INTO anagramma_form VALUES("282","0","1591899145","KaterinkA получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("283","402","1591899162","Балда");
INSERT INTO anagramma_form VALUES("284","0","1591899162","KaterinkA получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("285","0","1591903162","LOVE ME в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("286","0","1591932381","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("287","402","1591932396","Обезьяна");
INSERT INTO anagramma_form VALUES("288","0","1591932396","KaterinkA получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("289","402","1591932429","Деньги");
INSERT INTO anagramma_form VALUES("290","0","1591932429","KaterinkA получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("291","402","1591932444","Лошадь");
INSERT INTO anagramma_form VALUES("292","0","1591932444","KaterinkA получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("293","402","1591932452","Дети");
INSERT INTO anagramma_form VALUES("294","0","1591932452","KaterinkA получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("295","402","1591932477","Нокиа");
INSERT INTO anagramma_form VALUES("296","402","1591932559","Икона");
INSERT INTO anagramma_form VALUES("297","0","1591932559","KaterinkA получает 5 рубинов! Правильное слово: икона");
INSERT INTO anagramma_form VALUES("298","402","1591932593","Небесный");
INSERT INTO anagramma_form VALUES("299","0","1591932593","KaterinkA получает 8 рубинов! Правильное слово: небесный");
INSERT INTO anagramma_form VALUES("300","402","1591932605","Провод");
INSERT INTO anagramma_form VALUES("301","0","1591932605","KaterinkA получает 6 рубинов! Правильное слово: провод");
INSERT INTO anagramma_form VALUES("302","0","1591946230","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("303","402","1591946340","Веерница");
INSERT INTO anagramma_form VALUES("304","402","1591946363","Вереница");
INSERT INTO anagramma_form VALUES("305","0","1591946363","KaterinkA получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("306","0","1591946467","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("307","402","1591946553","Сайт");
INSERT INTO anagramma_form VALUES("308","0","1591946553","KaterinkA получает 4 рубинов! Правильное слово: сайт");
INSERT INTO anagramma_form VALUES("309","402","1591946572","Ведро");
INSERT INTO anagramma_form VALUES("310","402","1591946587","Древь");
INSERT INTO anagramma_form VALUES("311","402","1591946660","Дверь");
INSERT INTO anagramma_form VALUES("312","0","1591946660","KaterinkA получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("313","402","1591946672","Лось");
INSERT INTO anagramma_form VALUES("314","402","1591946679","Соль");
INSERT INTO anagramma_form VALUES("315","0","1591946679","KaterinkA получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("316","402","1591946730","Перекрёсток");
INSERT INTO anagramma_form VALUES("317","0","1591946730","KaterinkA получает 11 рубинов! Правильное слово: перекрёсток");
INSERT INTO anagramma_form VALUES("318","402","1591946743","Калибр");
INSERT INTO anagramma_form VALUES("319","0","1591946743","KaterinkA получает 6 рубинов! Правильное слово: калибр");
INSERT INTO anagramma_form VALUES("320","402","1591946754","Вентилятор");
INSERT INTO anagramma_form VALUES("321","0","1591946754","KaterinkA получает 10 рубинов! Правильное слово: вентилятор");
INSERT INTO anagramma_form VALUES("322","402","1591946768","Солнце");
INSERT INTO anagramma_form VALUES("323","0","1591946768","KaterinkA получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("324","402","1591946779","Друг");
INSERT INTO anagramma_form VALUES("325","0","1591946779","KaterinkA получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("326","402","1591946785","Сайт");
INSERT INTO anagramma_form VALUES("327","0","1591946785","KaterinkA получает 4 рубинов! Правильное слово: сайт");
INSERT INTO anagramma_form VALUES("328","402","1591946824","Вентилятор");
INSERT INTO anagramma_form VALUES("329","0","1591946824","KaterinkA получает 10 рубинов! Правильное слово: вентилятор");
INSERT INTO anagramma_form VALUES("330","402","1591946867","Ворона");
INSERT INTO anagramma_form VALUES("331","0","1591946867","KaterinkA получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("332","402","1591946877","Бутылка");
INSERT INTO anagramma_form VALUES("333","0","1591946877","KaterinkA получает 7 рубинов! Правильное слово: бутылка");
INSERT INTO anagramma_form VALUES("334","402","1591946891","Едит");
INSERT INTO anagramma_form VALUES("335","402","1591946902","Идёт");
INSERT INTO anagramma_form VALUES("336","402","1591946910","Идет");
INSERT INTO anagramma_form VALUES("337","402","1591946979","Дите");
INSERT INTO anagramma_form VALUES("338","402","1591947639","Длина");
INSERT INTO anagramma_form VALUES("339","0","1591947639","KaterinkA получает 5 рубинов! Правильное слово: длина");
INSERT INTO anagramma_form VALUES("340","402","1591947702","Катастрофа");
INSERT INTO anagramma_form VALUES("341","0","1591947702","KaterinkA получает 10 рубинов! Правильное слово: катастрофа");
INSERT INTO anagramma_form VALUES("342","0","1591964649","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("343","402","1591964665","Течение");
INSERT INTO anagramma_form VALUES("344","0","1591964665","KaterinkA получает 7 рубинов! Правильное слово: течение");
INSERT INTO anagramma_form VALUES("345","402","1591964674","Бомж");
INSERT INTO anagramma_form VALUES("346","0","1591964674","KaterinkA получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("347","0","1592031191","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("348","402","1592031201","Корм");
INSERT INTO anagramma_form VALUES("349","0","1592031201","KaterinkA получает 4 рубинов! Правильное слово: корм");
INSERT INTO anagramma_form VALUES("350","402","1592031209","Зажим");
INSERT INTO anagramma_form VALUES("351","0","1592031209","KaterinkA получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("352","402","1592031220","Суббота");
INSERT INTO anagramma_form VALUES("353","0","1592031220","KaterinkA получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("354","402","1592031234","Свадьба");
INSERT INTO anagramma_form VALUES("355","0","1592031234","KaterinkA получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("356","402","1592031445","Караван");
INSERT INTO anagramma_form VALUES("357","0","1592031445","KaterinkA получает 7 рубинов! Правильное слово: караван");
INSERT INTO anagramma_form VALUES("358","402","1592031469","Кровавый");
INSERT INTO anagramma_form VALUES("359","0","1592031469","KaterinkA получает 8 рубинов! Правильное слово: кровавый");
INSERT INTO anagramma_form VALUES("360","402","1592031481","Фальш");
INSERT INTO anagramma_form VALUES("361","0","1592031481","KaterinkA получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("362","0","1592032246","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("363","391","1592032265","Лестница");
INSERT INTO anagramma_form VALUES("364","0","1592032265","Girl Style получает 8 рубинов! Правильное слово: лестница");
INSERT INTO anagramma_form VALUES("365","391","1592032277","Туалет");
INSERT INTO anagramma_form VALUES("366","0","1592032277","Girl Style получает 6 рубинов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("367","391","1592032289","Дверь");
INSERT INTO anagramma_form VALUES("368","0","1592032289","Girl Style получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("369","391","1592032300","Салют");
INSERT INTO anagramma_form VALUES("370","0","1592032300","Girl Style получает 5 рубинов! Правильное слово: салют");
INSERT INTO anagramma_form VALUES("371","391","1592032323","Компьютер");
INSERT INTO anagramma_form VALUES("372","0","1592032323","Girl Style получает 9 рубинов! Правильное слово: компьютер");
INSERT INTO anagramma_form VALUES("373","0","1592044753","support в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("374","0","1592050846","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("375","402","1592050863","Вереница");
INSERT INTO anagramma_form VALUES("376","0","1592050863","KaterinkA получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("377","402","1592050887","Длина");
INSERT INTO anagramma_form VALUES("378","0","1592050887","KaterinkA получает 5 рубинов! Правильное слово: длина");
INSERT INTO anagramma_form VALUES("379","402","1592050922","Небо");
INSERT INTO anagramma_form VALUES("380","0","1592050922","KaterinkA получает 4 рубинов! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("381","0","1592051166","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("382","0","1592051200","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("383","402","1592051235","Хоккей");
INSERT INTO anagramma_form VALUES("384","0","1592051235","KaterinkA получает 6 рубинов! Правильное слово: хоккей");
INSERT INTO anagramma_form VALUES("385","402","1592051262","Кузнец");
INSERT INTO anagramma_form VALUES("386","0","1592051262","KaterinkA получает 6 рубинов! Правильное слово: кузнец");
INSERT INTO anagramma_form VALUES("387","0","1592062093","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("388","391","1592062106","Кот");
INSERT INTO anagramma_form VALUES("389","391","1592062117","Ток");
INSERT INTO anagramma_form VALUES("390","0","1592062117","Girl Style получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("391","391","1592062128","Лошадь");
INSERT INTO anagramma_form VALUES("392","0","1592062128","Girl Style получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("393","391","1592062143","Лестница");
INSERT INTO anagramma_form VALUES("394","0","1592062143","Girl Style получает 8 рубинов! Правильное слово: лестница");
INSERT INTO anagramma_form VALUES("395","391","1592062155","Футбол");
INSERT INTO anagramma_form VALUES("396","0","1592062155","Girl Style получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("397","391","1592062171","Семена");
INSERT INTO anagramma_form VALUES("398","0","1592062171","Girl Style получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("399","391","1592062185","Ввод");
INSERT INTO anagramma_form VALUES("400","0","1592062185","Girl Style получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("401","391","1592062200","Бедный ");
INSERT INTO anagramma_form VALUES("402","0","1592081595","LOVE ME в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("403","362","1592081612","Балда");
INSERT INTO anagramma_form VALUES("404","0","1592081612","LOVE ME получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("405","362","1592081646","Иммунитет");
INSERT INTO anagramma_form VALUES("406","0","1592081646","LOVE ME получает 9 рубинов! Правильное слово: иммунитет");
INSERT INTO anagramma_form VALUES("407","362","1592081664","Салат");
INSERT INTO anagramma_form VALUES("408","0","1592081664","LOVE ME получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("409","362","1592081677","Друг");
INSERT INTO anagramma_form VALUES("410","0","1592081677","LOVE ME получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("411","362","1592081699","Перекрёсток");
INSERT INTO anagramma_form VALUES("412","0","1592081699","LOVE ME получает 11 рубинов! Правильное слово: перекрёсток");
INSERT INTO anagramma_form VALUES("413","0","1592112593","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("414","402","1592112606","Рука");
INSERT INTO anagramma_form VALUES("415","0","1592112606","KaterinkA получает 4 рубинов! Правильное слово: рука");
INSERT INTO anagramma_form VALUES("416","402","1592112623","Деньги");
INSERT INTO anagramma_form VALUES("417","0","1592112623","KaterinkA получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("418","402","1592112642","Друг");
INSERT INTO anagramma_form VALUES("419","0","1592112642","KaterinkA получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("420","402","1592112652","Имя");
INSERT INTO anagramma_form VALUES("421","0","1592112652","KaterinkA получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("422","402","1592112679","Глина");
INSERT INTO anagramma_form VALUES("423","0","1592112679","KaterinkA получает 5 рубинов! Правильное слово: глина");
INSERT INTO anagramma_form VALUES("424","402","1592112698","Телевизор");
INSERT INTO anagramma_form VALUES("425","0","1592112698","KaterinkA получает 9 рубинов! Правильное слово: телевизор");
INSERT INTO anagramma_form VALUES("426","402","1592112714","Сахар");
INSERT INTO anagramma_form VALUES("427","0","1592112714","KaterinkA получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("428","402","1592112771","Рука");
INSERT INTO anagramma_form VALUES("429","0","1592112771","KaterinkA получает 4 рубинов! Правильное слово: рука");
INSERT INTO anagramma_form VALUES("430","402","1592112790","Часы");
INSERT INTO anagramma_form VALUES("431","0","1592112790","KaterinkA получает 4 рубинов! Правильное слово: часы");
INSERT INTO anagramma_form VALUES("432","0","1592117194","Zatmenie в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("433","430","1592117215","Ворона");
INSERT INTO anagramma_form VALUES("434","0","1592117215","Zatmenie получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("435","0","1592117229","Zatmenie в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("436","0","1592124770","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("437","391","1592124781","Бомба");
INSERT INTO anagramma_form VALUES("438","0","1592124781","Girl Style получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("439","391","1592124791","Работа");
INSERT INTO anagramma_form VALUES("440","0","1592124791","Girl Style получает 6 рубинов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("441","391","1592124799","Футбол");
INSERT INTO anagramma_form VALUES("442","0","1592124799","Girl Style получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("443","391","1592124809","Лось");
INSERT INTO anagramma_form VALUES("444","391","1592124817","Соль");
INSERT INTO anagramma_form VALUES("445","0","1592124817","Girl Style получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("446","391","1592124827","Бассейн");
INSERT INTO anagramma_form VALUES("447","391","1592124858","Небесный");
INSERT INTO anagramma_form VALUES("448","0","1592124858","Girl Style получает 8 рубинов! Правильное слово: небесный");
INSERT INTO anagramma_form VALUES("449","391","1592124870","Выход");
INSERT INTO anagramma_form VALUES("450","0","1592124870","Girl Style получает 5 рубинов! Правильное слово: выход");
INSERT INTO anagramma_form VALUES("451","391","1592124880","Дети");
INSERT INTO anagramma_form VALUES("452","0","1592124880","Girl Style получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("453","391","1592124889","Банк");
INSERT INTO anagramma_form VALUES("454","0","1592124889","Girl Style получает 4 рубинов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("455","391","1592124899","Фальш");
INSERT INTO anagramma_form VALUES("456","0","1592124899","Girl Style получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("457","391","1592124915","Приют ");
INSERT INTO anagramma_form VALUES("458","391","1592124945","приют");
INSERT INTO anagramma_form VALUES("459","0","1592124945","Girl Style получает 5 рубинов! Правильное слово: приют");
INSERT INTO anagramma_form VALUES("460","391","1592124967","Вереница");
INSERT INTO anagramma_form VALUES("461","0","1592124967","Girl Style получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("462","391","1592124979","Система");
INSERT INTO anagramma_form VALUES("463","0","1592124979","Girl Style получает 7 рубинов! Правильное слово: система");
INSERT INTO anagramma_form VALUES("464","391","1592124990","Птица");
INSERT INTO anagramma_form VALUES("465","0","1592124990","Girl Style получает 5 рубинов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("466","391","1592125002","Друг");
INSERT INTO anagramma_form VALUES("467","0","1592125002","Girl Style получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("468","391","1592125013","Деньги");
INSERT INTO anagramma_form VALUES("469","0","1592125013","Girl Style получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("470","0","1592193381","Dark_Princess в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("471","435","1592193412","Сырость");
INSERT INTO anagramma_form VALUES("472","0","1592193412","Dark_Princess получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("473","435","1592193433","Город");
INSERT INTO anagramma_form VALUES("474","0","1592193433","Dark_Princess получает 5 рубинов! Правильное слово: город");
INSERT INTO anagramma_form VALUES("475","435","1592193443","Кот");
INSERT INTO anagramma_form VALUES("476","0","1592193443","Dark_Princess получает 3 рубинов! Правильное слово: кот");
INSERT INTO anagramma_form VALUES("477","0","1592279901","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("479","0","1592280012","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("480","0","1592280076","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("481","391","1592280096","Арбуз");
INSERT INTO anagramma_form VALUES("482","0","1592280096","Girl Style получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("483","391","1592280109","Ввод");
INSERT INTO anagramma_form VALUES("484","0","1592280109","Girl Style получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("485","391","1592280122","Круг");
INSERT INTO anagramma_form VALUES("486","0","1592280122","Girl Style получает 4 рубинов! Правильное слово: круг");
INSERT INTO anagramma_form VALUES("487","391","1592280132","Сахар");
INSERT INTO anagramma_form VALUES("488","0","1592280132","Girl Style получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("489","391","1592280146","Фалш");
INSERT INTO anagramma_form VALUES("490","391","1592280156","Фальш ");
INSERT INTO anagramma_form VALUES("491","391","1592280165","Фальш ");
INSERT INTO anagramma_form VALUES("492","391","1592280191","фальш");
INSERT INTO anagramma_form VALUES("493","0","1592280191","Girl Style получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("494","391","1592280216","нокиа");
INSERT INTO anagramma_form VALUES("495","0","1592360275","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("496","391","1592360288","Салат");
INSERT INTO anagramma_form VALUES("497","0","1592360288","Girl Style получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("498","391","1592360301","Салат");
INSERT INTO anagramma_form VALUES("499","0","1592360301","Girl Style получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("500","391","1592360314","Обезьяна");
INSERT INTO anagramma_form VALUES("501","0","1592360314","Girl Style получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("502","391","1592360324","Имя");
INSERT INTO anagramma_form VALUES("503","0","1592360324","Girl Style получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("504","391","1592360337","Бегемот");
INSERT INTO anagramma_form VALUES("505","0","1592360337","Girl Style получает 7 рубинов! Правильное слово: бегемот");
INSERT INTO anagramma_form VALUES("506","391","1592360348","Хоккей");
INSERT INTO anagramma_form VALUES("507","0","1592360348","Girl Style получает 6 рубинов! Правильное слово: хоккей");
INSERT INTO anagramma_form VALUES("508","0","1592361610","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("509","391","1592361622","Длина");
INSERT INTO anagramma_form VALUES("510","0","1592361622","Girl Style получает 5 рубинов! Правильное слово: длина");
INSERT INTO anagramma_form VALUES("511","391","1592361633","Салют ");
INSERT INTO anagramma_form VALUES("512","391","1592361645","Салют");
INSERT INTO anagramma_form VALUES("513","0","1592361645","Girl Style получает 5 рубинов! Правильное слово: салют");
INSERT INTO anagramma_form VALUES("514","391","1592361659","Ввод");
INSERT INTO anagramma_form VALUES("515","0","1592361659","Girl Style получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("516","391","1592361671","Птица");
INSERT INTO anagramma_form VALUES("517","0","1592361671","Girl Style получает 5 рубинов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("518","391","1592361679","Ток");
INSERT INTO anagramma_form VALUES("519","391","1592361688","Кот");
INSERT INTO anagramma_form VALUES("520","0","1592361688","Girl Style получает 3 рубинов! Правильное слово: кот");
INSERT INTO anagramma_form VALUES("521","391","1592361703","Солнце");
INSERT INTO anagramma_form VALUES("522","0","1592361703","Girl Style получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("523","391","1592361712","Небо");
INSERT INTO anagramma_form VALUES("524","0","1592361712","Girl Style получает 4 рубинов! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("525","391","1592361724","Свадьба");
INSERT INTO anagramma_form VALUES("526","0","1592361724","Girl Style получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("527","391","1592361734","Сайт");
INSERT INTO anagramma_form VALUES("528","0","1592361734","Girl Style получает 4 рубинов! Правильное слово: сайт");
INSERT INTO anagramma_form VALUES("529","391","1592361748","Вереница");
INSERT INTO anagramma_form VALUES("530","0","1592361748","Girl Style получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("531","391","1592361757","Арбуз");
INSERT INTO anagramma_form VALUES("532","0","1592361757","Girl Style получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("533","391","1592361769","Система");
INSERT INTO anagramma_form VALUES("534","0","1592361769","Girl Style получает 7 рубинов! Правильное слово: система");
INSERT INTO anagramma_form VALUES("535","391","1592361782","Ворона");
INSERT INTO anagramma_form VALUES("536","0","1592361782","Girl Style получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("537","391","1592361793","Стол");
INSERT INTO anagramma_form VALUES("538","0","1592361793","Girl Style получает 4 рубинов! Правильное слово: стол");
INSERT INTO anagramma_form VALUES("539","391","1592361793","Стол");
INSERT INTO anagramma_form VALUES("540","391","1592361804","Обезяна");
INSERT INTO anagramma_form VALUES("541","391","1592361826","Обезьяна");
INSERT INTO anagramma_form VALUES("542","0","1592361826","Girl Style получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("543","391","1592361836","Друг");
INSERT INTO anagramma_form VALUES("544","0","1592361836","Girl Style получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("545","391","1592361849","Иммунитет");
INSERT INTO anagramma_form VALUES("546","0","1592361849","Girl Style получает 9 рубинов! Правильное слово: иммунитет");
INSERT INTO anagramma_form VALUES("547","391","1592361861","Кузнец");
INSERT INTO anagramma_form VALUES("548","0","1592361861","Girl Style получает 6 рубинов! Правильное слово: кузнец");
INSERT INTO anagramma_form VALUES("549","391","1592361873","Фальш");
INSERT INTO anagramma_form VALUES("550","0","1592361873","Girl Style получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("551","391","1592361882","Салют");
INSERT INTO anagramma_form VALUES("552","0","1592361882","Girl Style получает 5 рубинов! Правильное слово: салют");
INSERT INTO anagramma_form VALUES("553","391","1592361898","Бегемот");
INSERT INTO anagramma_form VALUES("554","0","1592361898","Girl Style получает 7 рубинов! Правильное слово: бегемот");
INSERT INTO anagramma_form VALUES("555","0","1592362603","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("556","391","1592362618","Классы");
INSERT INTO anagramma_form VALUES("557","0","1592363445","Girl Style в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("558","391","1592363458","Суббота");
INSERT INTO anagramma_form VALUES("559","0","1592363458","Girl Style получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("560","0","1592409800","Бессонница в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("561","0","1592451890","SCORPIO в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("562","444","1592451910","Сахар");
INSERT INTO anagramma_form VALUES("563","0","1592451910","SCORPIO получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("564","0","1592459938","SCORPIO в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("565","444","1592459950","выход");
INSERT INTO anagramma_form VALUES("566","0","1592459950","SCORPIO получает 5 рубинов! Правильное слово: выход");
INSERT INTO anagramma_form VALUES("567","444","1592459963","солнце");
INSERT INTO anagramma_form VALUES("568","0","1592459963","SCORPIO получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("569","444","1592459974","свадьба");
INSERT INTO anagramma_form VALUES("570","0","1592459974","SCORPIO получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("571","444","1592459997","течение");
INSERT INTO anagramma_form VALUES("572","0","1592459997","SCORPIO получает 7 рубинов! Правильное слово: течение");
INSERT INTO anagramma_form VALUES("573","444","1592460022","роль");
INSERT INTO anagramma_form VALUES("574","0","1592460022","SCORPIO получает 4 рубинов! Правильное слово: роль");
INSERT INTO anagramma_form VALUES("575","444","1592460044","семена");
INSERT INTO anagramma_form VALUES("576","0","1592460044","SCORPIO получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("577","444","1592460071","слаксы");
INSERT INTO anagramma_form VALUES("578","444","1592460080","классы");
INSERT INTO anagramma_form VALUES("579","444","1592460093","ссылка");
INSERT INTO anagramma_form VALUES("580","0","1592460093","SCORPIO получает 6 рубинов! Правильное слово: ссылка");
INSERT INTO anagramma_form VALUES("581","444","1592460106","банк");
INSERT INTO anagramma_form VALUES("582","0","1592460106","SCORPIO получает 4 рубинов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("583","444","1592460125","катастрофа");
INSERT INTO anagramma_form VALUES("584","0","1592460125","SCORPIO получает 10 рубинов! Правильное слово: катастрофа");
INSERT INTO anagramma_form VALUES("585","444","1592460149","вентилятор");
INSERT INTO anagramma_form VALUES("586","0","1592460149","SCORPIO получает 10 рубинов! Правильное слово: вентилятор");
INSERT INTO anagramma_form VALUES("587","444","1592460171","течение");
INSERT INTO anagramma_form VALUES("588","0","1592460171","SCORPIO получает 7 рубинов! Правильное слово: течение");
INSERT INTO anagramma_form VALUES("589","444","1592460191","речной");
INSERT INTO anagramma_form VALUES("590","0","1592460191","SCORPIO получает 6 рубинов! Правильное слово: речной");
INSERT INTO anagramma_form VALUES("591","444","1592460211","дитя");
INSERT INTO anagramma_form VALUES("592","0","1592460211","SCORPIO получает 4 рубинов! Правильное слово: дитя");
INSERT INTO anagramma_form VALUES("593","444","1592460234","вереница");
INSERT INTO anagramma_form VALUES("594","0","1592460234","SCORPIO получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("595","444","1592460250","руки");
INSERT INTO anagramma_form VALUES("596","0","1592460250","SCORPIO получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("597","444","1592460275","кровавый");
INSERT INTO anagramma_form VALUES("598","0","1592460275","SCORPIO получает 8 рубинов! Правильное слово: кровавый");
INSERT INTO anagramma_form VALUES("599","444","1592460294","зажим");
INSERT INTO anagramma_form VALUES("600","0","1592460294","SCORPIO получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("601","444","1592460317","бомба");
INSERT INTO anagramma_form VALUES("602","0","1592460317","SCORPIO получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("603","444","1592460339","шоколад");
INSERT INTO anagramma_form VALUES("604","0","1592460339","SCORPIO получает 7 рубинов! Правильное слово: шоколад");
INSERT INTO anagramma_form VALUES("605","444","1592460377","ввод");
INSERT INTO anagramma_form VALUES("606","0","1592460377","SCORPIO получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("607","444","1592460404","дверь");
INSERT INTO anagramma_form VALUES("608","0","1592460404","SCORPIO получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("609","444","1592460414","кот");
INSERT INTO anagramma_form VALUES("610","444","1592460421","ток");
INSERT INTO anagramma_form VALUES("611","0","1592460421","SCORPIO получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("612","444","1592460444","музыкант");
INSERT INTO anagramma_form VALUES("613","0","1592460444","SCORPIO получает 8 рубинов! Правильное слово: музыкант");
INSERT INTO anagramma_form VALUES("614","444","1592460468","фестиваль");
INSERT INTO anagramma_form VALUES("615","0","1592460468","SCORPIO получает 9 рубинов! Правильное слово: фестиваль");
INSERT INTO anagramma_form VALUES("616","444","1592460478","лось");
INSERT INTO anagramma_form VALUES("617","444","1592460488","соль");
INSERT INTO anagramma_form VALUES("618","0","1592460488","SCORPIO получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("619","444","1592460519","вереница");
INSERT INTO anagramma_form VALUES("620","0","1592460519","SCORPIO получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("621","0","1592504013","PoFFigiSTkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("622","465","1592504029","Кресло");
INSERT INTO anagramma_form VALUES("623","0","1592504029","PoFFigiSTkA получает 6 рубинов! Правильное слово: кресло");
INSERT INTO anagramma_form VALUES("624","465","1592504050","Футбол");
INSERT INTO anagramma_form VALUES("625","0","1592504050","PoFFigiSTkA получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("626","0","1592509920","PoFFigiSTkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("627","0","1592514532","LOVE ME в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("628","362","1592514544","Круг");
INSERT INTO anagramma_form VALUES("629","0","1592514544","LOVE ME получает 4 рубинов! Правильное слово: круг");
INSERT INTO anagramma_form VALUES("630","0","1592655342","NeGaTiVkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("631","445","1592655506","Деньги");
INSERT INTO anagramma_form VALUES("632","0","1592655506","NeGaTiVkA получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("633","445","1592655568","Дверь");
INSERT INTO anagramma_form VALUES("634","0","1592655568","NeGaTiVkA получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("635","445","1592655584","Опять");
INSERT INTO anagramma_form VALUES("636","0","1592655584","NeGaTiVkA получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("637","0","1592655708","NeGaTiVkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("638","445","1592655754","Вареница");
INSERT INTO anagramma_form VALUES("639","445","1592655780","Веерница");
INSERT INTO anagramma_form VALUES("640","445","1592655842","Судьба");
INSERT INTO anagramma_form VALUES("641","0","1592655842","NeGaTiVkA получает 6 рубинов! Правильное слово: судьба");
INSERT INTO anagramma_form VALUES("642","445","1592655851","Имя");
INSERT INTO anagramma_form VALUES("643","0","1592655851","NeGaTiVkA получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("644","445","1592656106","Зажим");
INSERT INTO anagramma_form VALUES("645","0","1592656106","NeGaTiVkA получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("646","445","1592656121","Корм");
INSERT INTO anagramma_form VALUES("647","0","1592656121","NeGaTiVkA получает 4 рубинов! Правильное слово: корм");
INSERT INTO anagramma_form VALUES("648","0","1592657108","NeGaTiVkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("649","0","1592671773","Dark_Princess в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("650","435","1592671836","Обезьяна");
INSERT INTO anagramma_form VALUES("651","0","1592671836","Dark_Princess получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("652","435","1592671851","Стол");
INSERT INTO anagramma_form VALUES("653","0","1592671851","Dark_Princess получает 4 рубинов! Правильное слово: стол");
INSERT INTO anagramma_form VALUES("654","435","1592671867","Птица");
INSERT INTO anagramma_form VALUES("655","0","1592671867","Dark_Princess получает 5 рубинов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("656","0","1592672092","Dark_Princess в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("657","435","1592672123","Капуста");
INSERT INTO anagramma_form VALUES("658","0","1592672123","Dark_Princess получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("659","435","1592672133","Кот");
INSERT INTO anagramma_form VALUES("660","435","1592672144","Ток");
INSERT INTO anagramma_form VALUES("661","0","1592672144","Dark_Princess получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("662","0","1592692418","КареглаЗая в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("663","0","1592717340","Dark_Princess в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("664","435","1592717401","Поять");
INSERT INTO anagramma_form VALUES("665","0","1592729104","NeGaTiVkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("666","0","1592740031","NeGaTiVkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("667","445","1592740144","Бутылка");
INSERT INTO anagramma_form VALUES("668","0","1592740144","NeGaTiVkA получает 7 рубинов! Правильное слово: бутылка");
INSERT INTO anagramma_form VALUES("669","445","1592740216","Кресло");
INSERT INTO anagramma_form VALUES("670","0","1592740216","NeGaTiVkA получает 6 рубинов! Правильное слово: кресло");
INSERT INTO anagramma_form VALUES("671","445","1592740229","Руки");
INSERT INTO anagramma_form VALUES("672","0","1592740229","NeGaTiVkA получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("673","445","1592740240","Небо");
INSERT INTO anagramma_form VALUES("674","0","1592740240","NeGaTiVkA получает 4 рубинов! Правильное слово: небо");
INSERT INTO anagramma_form VALUES("675","445","1592740252","Ворона");
INSERT INTO anagramma_form VALUES("676","0","1592740252","NeGaTiVkA получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("677","0","1592745837","ЯТоЛьКоТвОя в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("678","454","1592745847","Плюс");
INSERT INTO anagramma_form VALUES("679","454","1592745858","Сплю");
INSERT INTO anagramma_form VALUES("680","0","1592745858","ЯТоЛьКоТвОя получает 4 рубинов! Правильное слово: сплю");
INSERT INTO anagramma_form VALUES("681","454","1592745872","Блины");
INSERT INTO anagramma_form VALUES("682","0","1592745872","ЯТоЛьКоТвОя получает 5 рубинов! Правильное слово: блины");
INSERT INTO anagramma_form VALUES("683","454","1592745883","Песня");
INSERT INTO anagramma_form VALUES("684","0","1592745883","ЯТоЛьКоТвОя получает 5 рубинов! Правильное слово: песня");
INSERT INTO anagramma_form VALUES("685","454","1592745894","Руки");
INSERT INTO anagramma_form VALUES("686","0","1592745894","ЯТоЛьКоТвОя получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("687","454","1592745910","Катастрофа");
INSERT INTO anagramma_form VALUES("688","0","1592745910","ЯТоЛьКоТвОя получает 10 рубинов! Правильное слово: катастрофа");
INSERT INTO anagramma_form VALUES("689","0","1593170856","Gerrda в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("690","0","1593192201","АЛМАЗ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("691","324","1593192212","Дети");
INSERT INTO anagramma_form VALUES("692","0","1593192212","АЛМАЗ получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("693","0","1593192224","АЛМАЗ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("694","324","1593192242","Свадьба");
INSERT INTO anagramma_form VALUES("695","0","1593192242","АЛМАЗ получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("696","0","1593346750","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("697","512","1593346774","Туалет");
INSERT INTO anagramma_form VALUES("698","0","1593346774","_Solnyshko_ получает 6 рубинов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("699","512","1593346806","Ангор");
INSERT INTO anagramma_form VALUES("700","512","1593346828","Орган");
INSERT INTO anagramma_form VALUES("701","0","1593346828","_Solnyshko_ получает 5 рубинов! Правильное слово: орган");
INSERT INTO anagramma_form VALUES("702","512","1593346886","Разгром");
INSERT INTO anagramma_form VALUES("703","0","1593346886","_Solnyshko_ получает 7 рубинов! Правильное слово: разгром");
INSERT INTO anagramma_form VALUES("704","512","1593346915","Провод");
INSERT INTO anagramma_form VALUES("705","0","1593346915","_Solnyshko_ получает 6 рубинов! Правильное слово: провод");
INSERT INTO anagramma_form VALUES("706","512","1593346925","Капуста");
INSERT INTO anagramma_form VALUES("707","0","1593346925","_Solnyshko_ получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("708","0","1593352290","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("709","512","1593352314","Балда");
INSERT INTO anagramma_form VALUES("710","0","1593352314","_Solnyshko_ получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("711","512","1593352325","Стулья");
INSERT INTO anagramma_form VALUES("712","512","1593352341","Утолять ");
INSERT INTO anagramma_form VALUES("713","0","1593352843","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("714","512","1593352856","Капуста");
INSERT INTO anagramma_form VALUES("715","0","1593352856","_Solnyshko_ получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("716","512","1593352868","Дерево");
INSERT INTO anagramma_form VALUES("717","0","1593352868","_Solnyshko_ получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("718","512","1593352896","Реализация");
INSERT INTO anagramma_form VALUES("719","0","1593352896","_Solnyshko_ получает 10 рубинов! Правильное слово: реализация");
INSERT INTO anagramma_form VALUES("720","0","1593352963","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("721","0","1593352981","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("722","512","1593353171","Вентилятор");
INSERT INTO anagramma_form VALUES("723","0","1593353171","_Solnyshko_ получает 10 рубинов! Правильное слово: вентилятор");
INSERT INTO anagramma_form VALUES("724","512","1593353182","Пульт");
INSERT INTO anagramma_form VALUES("725","0","1593353182","_Solnyshko_ получает 5 рубинов! Правильное слово: пульт");
INSERT INTO anagramma_form VALUES("726","512","1593353193","Балда");
INSERT INTO anagramma_form VALUES("727","0","1593353193","_Solnyshko_ получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("728","512","1593353200","Соль");
INSERT INTO anagramma_form VALUES("729","0","1593353200","_Solnyshko_ получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("730","512","1593353259","Работа");
INSERT INTO anagramma_form VALUES("731","0","1593353259","_Solnyshko_ получает 6 рубинов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("732","0","1593371926","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("733","512","1593371936","Солнце");
INSERT INTO anagramma_form VALUES("734","0","1593371936","_Solnyshko_ получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("735","512","1593371950","Работа");
INSERT INTO anagramma_form VALUES("736","0","1593371950","_Solnyshko_ получает 6 рубинов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("737","512","1593371963","Ввод");
INSERT INTO anagramma_form VALUES("738","0","1593371963","_Solnyshko_ получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("739","512","1593372039","Компьютер");
INSERT INTO anagramma_form VALUES("740","0","1593372039","_Solnyshko_ получает 9 рубинов! Правильное слово: компьютер");
INSERT INTO anagramma_form VALUES("741","512","1593372060","Арбуз");
INSERT INTO anagramma_form VALUES("742","0","1593372060","_Solnyshko_ получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("743","512","1593372069","Дом");
INSERT INTO anagramma_form VALUES("744","0","1593372069","_Solnyshko_ получает 3 рубинов! Правильное слово: дом");
INSERT INTO anagramma_form VALUES("745","512","1593372079","Дверь");
INSERT INTO anagramma_form VALUES("746","0","1593372079","_Solnyshko_ получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("747","512","1593372088","Дети");
INSERT INTO anagramma_form VALUES("748","0","1593372088","_Solnyshko_ получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("749","0","1593438564","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("750","512","1593438578","Караван");
INSERT INTO anagramma_form VALUES("751","0","1593438578","_Solnyshko_ получает 7 рубинов! Правильное слово: караван");
INSERT INTO anagramma_form VALUES("752","512","1593438601","Вереница");
INSERT INTO anagramma_form VALUES("753","0","1593438601","_Solnyshko_ получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("754","512","1593438613","Глина");
INSERT INTO anagramma_form VALUES("755","0","1593438613","_Solnyshko_ получает 5 рубинов! Правильное слово: глина");
INSERT INTO anagramma_form VALUES("756","512","1593438622","Солнце");
INSERT INTO anagramma_form VALUES("757","0","1593438622","_Solnyshko_ получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("758","512","1593438647","Орган");
INSERT INTO anagramma_form VALUES("759","0","1593438647","_Solnyshko_ получает 5 рубинов! Правильное слово: орган");
INSERT INTO anagramma_form VALUES("760","512","1593438656","Солнце");
INSERT INTO anagramma_form VALUES("761","0","1593438656","_Solnyshko_ получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("762","512","1593438669","Фальш");
INSERT INTO anagramma_form VALUES("763","0","1593438669","_Solnyshko_ получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("764","512","1593438680","Роль");
INSERT INTO anagramma_form VALUES("765","0","1593438680","_Solnyshko_ получает 4 рубинов! Правильное слово: роль");
INSERT INTO anagramma_form VALUES("766","0","1593458131","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("767","512","1593458144","Вереница");
INSERT INTO anagramma_form VALUES("768","0","1593458144","_Solnyshko_ получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("769","512","1593458156","Часы");
INSERT INTO anagramma_form VALUES("770","0","1593458156","_Solnyshko_ получает 4 рубинов! Правильное слово: часы");
INSERT INTO anagramma_form VALUES("771","512","1593458167","Капуста");
INSERT INTO anagramma_form VALUES("772","0","1593458167","_Solnyshko_ получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("773","512","1593458177","Иммунитет");
INSERT INTO anagramma_form VALUES("774","0","1593458177","_Solnyshko_ получает 9 рубинов! Правильное слово: иммунитет");
INSERT INTO anagramma_form VALUES("775","512","1593458190","Работа");
INSERT INTO anagramma_form VALUES("776","0","1593458190","_Solnyshko_ получает 6 рубинов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("777","512","1593458199","Салат");
INSERT INTO anagramma_form VALUES("778","0","1593458199","_Solnyshko_ получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("779","512","1593458207","Футбол");
INSERT INTO anagramma_form VALUES("780","0","1593458207","_Solnyshko_ получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("781","512","1593458218","Судьба");
INSERT INTO anagramma_form VALUES("782","0","1593458218","_Solnyshko_ получает 6 рубинов! Правильное слово: судьба");
INSERT INTO anagramma_form VALUES("783","512","1593458231","Речной");
INSERT INTO anagramma_form VALUES("784","0","1593458231","_Solnyshko_ получает 6 рубинов! Правильное слово: речной");
INSERT INTO anagramma_form VALUES("785","512","1593458241","Капуста");
INSERT INTO anagramma_form VALUES("786","0","1593458241","_Solnyshko_ получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("787","512","1593458251","Заяц");
INSERT INTO anagramma_form VALUES("788","0","1593458251","_Solnyshko_ получает 4 рубинов! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("789","512","1593458268","Сырость");
INSERT INTO anagramma_form VALUES("790","0","1593458268","_Solnyshko_ получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("791","512","1593458278","Хоккей");
INSERT INTO anagramma_form VALUES("792","0","1593458278","_Solnyshko_ получает 6 рубинов! Правильное слово: хоккей");
INSERT INTO anagramma_form VALUES("793","512","1593458288","Руки");
INSERT INTO anagramma_form VALUES("794","0","1593458288","_Solnyshko_ получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("795","512","1593458297","Салат");
INSERT INTO anagramma_form VALUES("796","0","1593458297","_Solnyshko_ получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("797","512","1593458308","Кузнец");
INSERT INTO anagramma_form VALUES("798","0","1593458308","_Solnyshko_ получает 6 рубинов! Правильное слово: кузнец");
INSERT INTO anagramma_form VALUES("799","512","1593458316","Кот");
INSERT INTO anagramma_form VALUES("800","512","1593458324","Ток");
INSERT INTO anagramma_form VALUES("801","0","1593458324","_Solnyshko_ получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("802","512","1593458338","Бедный");
INSERT INTO anagramma_form VALUES("803","0","1593458338","_Solnyshko_ получает 6 рубинов! Правильное слово: бедный");
INSERT INTO anagramma_form VALUES("804","512","1593458348","Салат");
INSERT INTO anagramma_form VALUES("805","0","1593458348","_Solnyshko_ получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("806","512","1593458358","Болото");
INSERT INTO anagramma_form VALUES("807","0","1593458358","_Solnyshko_ получает 6 рубинов! Правильное слово: болото");
INSERT INTO anagramma_form VALUES("808","512","1593458369","Глина");
INSERT INTO anagramma_form VALUES("809","0","1593458369","_Solnyshko_ получает 5 рубинов! Правильное слово: глина");
INSERT INTO anagramma_form VALUES("810","512","1593458379","Блины");
INSERT INTO anagramma_form VALUES("811","0","1593458379","_Solnyshko_ получает 5 рубинов! Правильное слово: блины");
INSERT INTO anagramma_form VALUES("812","512","1593458389","Бомж");
INSERT INTO anagramma_form VALUES("813","0","1593458389","_Solnyshko_ получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("814","512","1593458397","Банк");
INSERT INTO anagramma_form VALUES("815","0","1593458397","_Solnyshko_ получает 4 рубинов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("816","0","1593520064","sany777 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("817","505","1593520088","дерево");
INSERT INTO anagramma_form VALUES("818","0","1593520088","sany777 получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("819","505","1593520112","песня");
INSERT INTO anagramma_form VALUES("820","0","1593520112","sany777 получает 5 рубинов! Правильное слово: песня");
INSERT INTO anagramma_form VALUES("821","505","1593520168","опять");
INSERT INTO anagramma_form VALUES("822","0","1593520168","sany777 получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("823","505","1593520323",".дум.");
INSERT INTO anagramma_form VALUES("824","505","1593520401","идет, едит");
INSERT INTO anagramma_form VALUES("825","505","1593520428","дите");
INSERT INTO anagramma_form VALUES("826","505","1593520448","дети");
INSERT INTO anagramma_form VALUES("827","0","1593520448","sany777 получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("828","505","1593520470","щажим");
INSERT INTO anagramma_form VALUES("829","505","1593520499","зажим");
INSERT INTO anagramma_form VALUES("830","0","1593520499","sany777 получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("831","505","1593520523","балда");
INSERT INTO anagramma_form VALUES("832","0","1593520523","sany777 получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("833","505","1593520620","фестиваль");
INSERT INTO anagramma_form VALUES("834","0","1593520620","sany777 получает 9 рубинов! Правильное слово: фестиваль");
INSERT INTO anagramma_form VALUES("835","505","1593520669","фестиваль");
INSERT INTO anagramma_form VALUES("836","0","1593520669","sany777 получает 9 рубинов! Правильное слово: фестиваль");
INSERT INTO anagramma_form VALUES("837","505","1593520713","лошадь");
INSERT INTO anagramma_form VALUES("838","0","1593520713","sany777 получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("839","505","1593520751","имя");
INSERT INTO anagramma_form VALUES("840","0","1593520751","sany777 получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("841","505","1593520818","иммунитет");
INSERT INTO anagramma_form VALUES("842","0","1593520818","sany777 получает 9 рубинов! Правильное слово: иммунитет");
INSERT INTO anagramma_form VALUES("843","505","1593520887","бегемот");
INSERT INTO anagramma_form VALUES("844","0","1593520887","sany777 получает 7 рубинов! Правильное слово: бегемот");
INSERT INTO anagramma_form VALUES("845","505","1593520906","дерево");
INSERT INTO anagramma_form VALUES("846","0","1593520906","sany777 получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("847","505","1593520927","ввод");
INSERT INTO anagramma_form VALUES("848","0","1593520927","sany777 получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("849","505","1593520947","птица");
INSERT INTO anagramma_form VALUES("850","0","1593520947","sany777 получает 5 рубинов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("851","505","1593521003","привет");
INSERT INTO anagramma_form VALUES("852","0","1593521003","sany777 получает 6 рубинов! Правильное слово: привет");
INSERT INTO anagramma_form VALUES("853","505","1593521019","кот");
INSERT INTO anagramma_form VALUES("854","505","1593521043","ток");
INSERT INTO anagramma_form VALUES("855","0","1593521043","sany777 получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("856","0","1593542341","Кисуля777 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("857","506","1593542376","фальш");
INSERT INTO anagramma_form VALUES("858","0","1593542376","Кисуля777 получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("859","506","1593542418","балда");
INSERT INTO anagramma_form VALUES("860","0","1593542418","Кисуля777 получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("861","506","1593542442","туалет");
INSERT INTO anagramma_form VALUES("862","0","1593542442","Кисуля777 получает 6 рубинов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("863","506","1593542459","кот");
INSERT INTO anagramma_form VALUES("864","0","1593542459","Кисуля777 получает 3 рубинов! Правильное слово: кот");
INSERT INTO anagramma_form VALUES("865","506","1593542486","виртуалка");
INSERT INTO anagramma_form VALUES("866","0","1593591301","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("867","512","1593591369","Сайт ");
INSERT INTO anagramma_form VALUES("868","512","1593591401","Айст");
INSERT INTO anagramma_form VALUES("869","0","1593593179","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("870","512","1593593193","Свадьба");
INSERT INTO anagramma_form VALUES("871","0","1593593193","_Solnyshko_ получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("872","512","1593593235","Зажим");
INSERT INTO anagramma_form VALUES("873","0","1593593235","_Solnyshko_ получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("874","512","1593593244","Заяц");
INSERT INTO anagramma_form VALUES("875","0","1593593244","_Solnyshko_ получает 4 рубинов! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("876","512","1593593263","Солнце");
INSERT INTO anagramma_form VALUES("877","0","1593593263","_Solnyshko_ получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("878","512","1593593274","Атлас");
INSERT INTO anagramma_form VALUES("879","512","1593593288","Салат");
INSERT INTO anagramma_form VALUES("880","0","1593593288","_Solnyshko_ получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("881","512","1593593321","Клавиатура");
INSERT INTO anagramma_form VALUES("882","0","1593593321","_Solnyshko_ получает 10 рубинов! Правильное слово: клавиатура");
INSERT INTO anagramma_form VALUES("883","512","1593593355","Сырость");
INSERT INTO anagramma_form VALUES("884","0","1593593355","_Solnyshko_ получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("885","0","1593593384","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("886","512","1593593416","Вентилятор");
INSERT INTO anagramma_form VALUES("887","0","1593593416","_Solnyshko_ получает 10 рубинов! Правильное слово: вентилятор");
INSERT INTO anagramma_form VALUES("888","512","1593593425","Солнце");
INSERT INTO anagramma_form VALUES("889","0","1593593425","_Solnyshko_ получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("890","512","1593593462","Кулинар");
INSERT INTO anagramma_form VALUES("891","0","1593593462","_Solnyshko_ получает 7 рубинов! Правильное слово: кулинар");
INSERT INTO anagramma_form VALUES("892","512","1593593471","Заяц");
INSERT INTO anagramma_form VALUES("893","0","1593593471","_Solnyshko_ получает 4 рубинов! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("894","512","1593593487","Ворона");
INSERT INTO anagramma_form VALUES("895","0","1593593487","_Solnyshko_ получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("896","512","1593593500","Дерево");
INSERT INTO anagramma_form VALUES("897","0","1593593500","_Solnyshko_ получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("898","512","1593593515","Приют");
INSERT INTO anagramma_form VALUES("899","0","1593593515","_Solnyshko_ получает 5 рубинов! Правильное слово: приют");
INSERT INTO anagramma_form VALUES("900","512","1593593532","Тракторист ");
INSERT INTO anagramma_form VALUES("901","512","1593593592","Тракторист");
INSERT INTO anagramma_form VALUES("902","0","1593593592","_Solnyshko_ получает 10 рубинов! Правильное слово: тракторист");
INSERT INTO anagramma_form VALUES("903","512","1593593605","Сахар");
INSERT INTO anagramma_form VALUES("904","0","1593593605","_Solnyshko_ получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("905","512","1593593616","Сырость");
INSERT INTO anagramma_form VALUES("906","0","1593593616","_Solnyshko_ получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("907","512","1593593635","Арбуз");
INSERT INTO anagramma_form VALUES("908","0","1593593635","_Solnyshko_ получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("909","512","1593593651","Катастрофа");
INSERT INTO anagramma_form VALUES("910","0","1593593651","_Solnyshko_ получает 10 рубинов! Правильное слово: катастрофа");
INSERT INTO anagramma_form VALUES("911","512","1593593692","Семена");
INSERT INTO anagramma_form VALUES("912","0","1593593692","_Solnyshko_ получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("913","512","1593593705","Шоколад");
INSERT INTO anagramma_form VALUES("914","0","1593593705","_Solnyshko_ получает 7 рубинов! Правильное слово: шоколад");
INSERT INTO anagramma_form VALUES("915","0","1593604789","_Небо_на_ладони_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("916","534","1593604836","кустик");
INSERT INTO anagramma_form VALUES("917","0","1593790503","Странник555 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("918","432","1593790558","Фальш");
INSERT INTO anagramma_form VALUES("919","0","1593790558","Странник555 получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("920","432","1593790576","Соль");
INSERT INTO anagramma_form VALUES("921","0","1593790576","Странник555 получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("922","432","1593790642","Клавиатура");
INSERT INTO anagramma_form VALUES("923","0","1593790642","Странник555 получает 10 рубинов! Правильное слово: клавиатура");
INSERT INTO anagramma_form VALUES("924","432","1593790660","Ток");
INSERT INTO anagramma_form VALUES("925","432","1593790685","Кот");
INSERT INTO anagramma_form VALUES("926","0","1593790685","Странник555 получает 3 рубинов! Правильное слово: кот");
INSERT INTO anagramma_form VALUES("927","432","1593790707","Бомж");
INSERT INTO anagramma_form VALUES("928","0","1593790707","Странник555 получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("929","432","1593790736","Руки");
INSERT INTO anagramma_form VALUES("930","0","1593790736","Странник555 получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("931","432","1593790768","Бегемот");
INSERT INTO anagramma_form VALUES("932","0","1593790768","Странник555 получает 7 рубинов! Правильное слово: бегемот");
INSERT INTO anagramma_form VALUES("933","432","1593790808","Вереница");
INSERT INTO anagramma_form VALUES("934","0","1593790808","Странник555 получает 8 рубинов! Правильное слово: вереница");
INSERT INTO anagramma_form VALUES("935","0","1593873068","Странник555 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("936","432","1593873091","Бомж");
INSERT INTO anagramma_form VALUES("937","0","1593873091","Странник555 получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("938","432","1593873124","Оплата");
INSERT INTO anagramma_form VALUES("939","0","1593873958","Странник555 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("940","432","1593874040","Свадьба");
INSERT INTO anagramma_form VALUES("941","0","1593874040","Странник555 получает 7 рубинов! Правильное слово: свадьба");
INSERT INTO anagramma_form VALUES("942","432","1593874061","Капуста");
INSERT INTO anagramma_form VALUES("943","0","1593874061","Странник555 получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("944","432","1593874157","Сырость");
INSERT INTO anagramma_form VALUES("945","0","1593874157","Странник555 получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("946","0","1593874371","Странник555 в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("947","432","1593874387","Лопата");
INSERT INTO anagramma_form VALUES("948","0","1593874387","Странник555 получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("949","432","1593874442","Винтелятор");
INSERT INTO anagramma_form VALUES("950","0","1594149408","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("951","512","1594149418","Соль");
INSERT INTO anagramma_form VALUES("952","0","1594149418","_Solnyshko_ получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("953","0","1594266129","Zayaza в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("954","0","1594268525","Zayaza в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("955","0","1594453374","napapidgi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("956","554","1594453440","Провод");
INSERT INTO anagramma_form VALUES("957","0","1594453440","napapidgi получает 6 рубинов! Правильное слово: провод");
INSERT INTO anagramma_form VALUES("958","0","1594667247","napapidgi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("959","554","1594667280","Бедный");
INSERT INTO anagramma_form VALUES("960","0","1594667280","napapidgi получает 6 рубинов! Правильное слово: бедный");
INSERT INTO anagramma_form VALUES("961","554","1594667311","Ворона");
INSERT INTO anagramma_form VALUES("962","0","1594667311","napapidgi получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("963","0","1594667411","napapidgi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("964","554","1594667435","Бедный");
INSERT INTO anagramma_form VALUES("965","0","1594667435","napapidgi получает 6 рубинов! Правильное слово: бедный");
INSERT INTO anagramma_form VALUES("966","554","1594667475","Лошадь");
INSERT INTO anagramma_form VALUES("967","0","1594667475","napapidgi получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("968","0","1594709570","_Solnyshko_ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("969","512","1594709578","Деньги");
INSERT INTO anagramma_form VALUES("970","0","1594709578","_Solnyshko_ получает 6 рубинов! Правильное слово: деньги");
INSERT INTO anagramma_form VALUES("971","512","1594709588","Бомж");
INSERT INTO anagramma_form VALUES("972","0","1594709588","_Solnyshko_ получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("973","512","1594709600","Утолять");
INSERT INTO anagramma_form VALUES("974","0","1594709600","_Solnyshko_ получает 7 рубинов! Правильное слово: утолять");
INSERT INTO anagramma_form VALUES("975","512","1594709609","Плюс");
INSERT INTO anagramma_form VALUES("976","512","1594709766","Плюс ");
INSERT INTO anagramma_form VALUES("977","0","1594923332","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("978","402","1594923401","Черной ");
INSERT INTO anagramma_form VALUES("979","402","1594923419","Чреной");
INSERT INTO anagramma_form VALUES("980","402","1594923455","Речной");
INSERT INTO anagramma_form VALUES("981","0","1594923455","KaterinkA получает 6 рубинов! Правильное слово: речной");
INSERT INTO anagramma_form VALUES("982","402","1594923464","Дитя");
INSERT INTO anagramma_form VALUES("983","0","1594923464","KaterinkA получает 4 рубинов! Правильное слово: дитя");
INSERT INTO anagramma_form VALUES("984","402","1594923474","Привет ");
INSERT INTO anagramma_form VALUES("985","0","1594923584","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("986","402","1594923599","привет ");
INSERT INTO anagramma_form VALUES("987","402","1594923702","Бутылка");
INSERT INTO anagramma_form VALUES("988","0","1594923702","KaterinkA получает 7 рубинов! Правильное слово: бутылка");
INSERT INTO anagramma_form VALUES("989","402","1594923727","Пульт ");
INSERT INTO anagramma_form VALUES("990","402","1594923867","Плуть");
INSERT INTO anagramma_form VALUES("991","402","1594923897","Свадьба ");
INSERT INTO anagramma_form VALUES("992","402","1594923917","свадьба ");
INSERT INTO anagramma_form VALUES("993","0","1594924511","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("994","402","1594924546","Работа ");
INSERT INTO anagramma_form VALUES("995","402","1594924562","работа ");
INSERT INTO anagramma_form VALUES("996","0","1594924842","Валюша в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("997","363","1594925066","Мия");
INSERT INTO anagramma_form VALUES("998","0","1594925219","Валюша в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("999","0","1594982329","KaterinkA в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1000","402","1594982521","Птица");
INSERT INTO anagramma_form VALUES("1001","0","1594982521","KaterinkA получает 5 рубинов! Правильное слово: птица");
INSERT INTO anagramma_form VALUES("1002","402","1594982550","Телевизор ");
INSERT INTO anagramma_form VALUES("1003","402","1594982640","телевизор");
INSERT INTO anagramma_form VALUES("1004","0","1594982640","KaterinkA получает 9 рубинов! Правильное слово: телевизор");
INSERT INTO anagramma_form VALUES("1005","402","1594982646","Дом");
INSERT INTO anagramma_form VALUES("1006","0","1594982646","KaterinkA получает 3 рубинов! Правильное слово: дом");
INSERT INTO anagramma_form VALUES("1007","0","1595100007","]]ВАНИЛЬНАЯ[[ в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1008","0","1595706529","napapidgi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1009","554","1595706550","Бомж");
INSERT INTO anagramma_form VALUES("1010","0","1595706550","napapidgi получает 4 рубинов! Правильное слово: бомж");
INSERT INTO anagramma_form VALUES("1011","554","1595706567","Соль");
INSERT INTO anagramma_form VALUES("1012","0","1595706567","napapidgi получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("1013","0","1595956070","НяШкА_ВкУсНяШкА в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1014","1","1595956084","Кузнец");
INSERT INTO anagramma_form VALUES("1015","0","1595956084","НяШкА_ВкУсНяШкА получает 6 рубинов! Правильное слово: кузнец");
INSERT INTO anagramma_form VALUES("1016","1","1595956106","Фальш");
INSERT INTO anagramma_form VALUES("1017","0","1595956106","НяШкА_ВкУсНяШкА получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("1018","0","1596135721","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1019","585","1596135753","Зажим");
INSERT INTO anagramma_form VALUES("1020","0","1596135753","Lessi получает 5 рубинов! Правильное слово: зажим");
INSERT INTO anagramma_form VALUES("1021","585","1596135765","Друг");
INSERT INTO anagramma_form VALUES("1022","0","1596135765","Lessi получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("1023","585","1596135776","Роль");
INSERT INTO anagramma_form VALUES("1024","0","1596135776","Lessi получает 4 рубинов! Правильное слово: роль");
INSERT INTO anagramma_form VALUES("1025","585","1596135785","Лось");
INSERT INTO anagramma_form VALUES("1026","585","1596135797","Соль");
INSERT INTO anagramma_form VALUES("1027","0","1596135797","Lessi получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("1028","585","1596135819","Лошадь");
INSERT INTO anagramma_form VALUES("1029","0","1596135819","Lessi получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("1030","585","1596135851","Семена");
INSERT INTO anagramma_form VALUES("1031","0","1596135851","Lessi получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("1032","585","1596135865","Лопата");
INSERT INTO anagramma_form VALUES("1033","0","1596135865","Lessi получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("1034","585","1596135883","Бедный");
INSERT INTO anagramma_form VALUES("1035","0","1596135883","Lessi получает 6 рубинов! Правильное слово: бедный");
INSERT INTO anagramma_form VALUES("1036","0","1596136045","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1037","0","1596136832","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1038","585","1596136845","Дверь");
INSERT INTO anagramma_form VALUES("1039","0","1596136845","Lessi получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("1040","585","1596136858","Часы");
INSERT INTO anagramma_form VALUES("1041","0","1596136858","Lessi получает 4 рубинов! Правильное слово: часы");
INSERT INTO anagramma_form VALUES("1042","585","1596136954","Телевизор");
INSERT INTO anagramma_form VALUES("1043","0","1596136954","Lessi получает 9 рубинов! Правильное слово: телевизор");
INSERT INTO anagramma_form VALUES("1044","585","1596136972","Соль");
INSERT INTO anagramma_form VALUES("1045","0","1596136972","Lessi получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("1046","585","1596137031","Работа");
INSERT INTO anagramma_form VALUES("1047","0","1596137031","Lessi получает 6 рубинов! Правильное слово: работа");
INSERT INTO anagramma_form VALUES("1048","585","1596137050","Семена");
INSERT INTO anagramma_form VALUES("1049","0","1596137050","Lessi получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("1050","585","1596137067","Солнце");
INSERT INTO anagramma_form VALUES("1051","0","1596137067","Lessi получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("1052","585","1596137144","Лодошка");
INSERT INTO anagramma_form VALUES("1053","585","1596137183","Шоколад");
INSERT INTO anagramma_form VALUES("1054","0","1596137183","Lessi получает 7 рубинов! Правильное слово: шоколад");
INSERT INTO anagramma_form VALUES("1055","585","1596137247","Кресло");
INSERT INTO anagramma_form VALUES("1056","0","1596137247","Lessi получает 6 рубинов! Правильное слово: кресло");
INSERT INTO anagramma_form VALUES("1057","585","1596137275","Лопата");
INSERT INTO anagramma_form VALUES("1058","0","1596137275","Lessi получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("1059","0","1596138880","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1060","585","1596138892","Арбуз");
INSERT INTO anagramma_form VALUES("1061","0","1596138892","Lessi получает 5 рубинов! Правильное слово: арбуз");
INSERT INTO anagramma_form VALUES("1062","585","1596138906","Бомба");
INSERT INTO anagramma_form VALUES("1063","0","1596138906","Lessi получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("1064","585","1596138933","Бомба");
INSERT INTO anagramma_form VALUES("1065","0","1596138933","Lessi получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("1066","585","1596138944","Имя");
INSERT INTO anagramma_form VALUES("1067","0","1596138944","Lessi получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("1068","585","1596138964","Привет");
INSERT INTO anagramma_form VALUES("1069","0","1596138964","Lessi получает 6 рубинов! Правильное слово: привет");
INSERT INTO anagramma_form VALUES("1070","0","1596139320","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1071","585","1596139345","Ссылка");
INSERT INTO anagramma_form VALUES("1072","0","1596139345","Lessi получает 6 рубинов! Правильное слово: ссылка");
INSERT INTO anagramma_form VALUES("1073","585","1596139358","Атлас");
INSERT INTO anagramma_form VALUES("1074","585","1596139376","Ласта");
INSERT INTO anagramma_form VALUES("1075","585","1596139397","Салат");
INSERT INTO anagramma_form VALUES("1076","0","1596139397","Lessi получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("1077","585","1596139419","Фальш");
INSERT INTO anagramma_form VALUES("1078","0","1596139419","Lessi получает 5 рубинов! Правильное слово: фальш");
INSERT INTO anagramma_form VALUES("1079","585","1596139436","Водопад");
INSERT INTO anagramma_form VALUES("1080","0","1596139436","Lessi получает 7 рубинов! Правильное слово: водопад");
INSERT INTO anagramma_form VALUES("1081","585","1596139452","Хоккей");
INSERT INTO anagramma_form VALUES("1082","0","1596139452","Lessi получает 6 рубинов! Правильное слово: хоккей");
INSERT INTO anagramma_form VALUES("1083","585","1596139466","Дерево");
INSERT INTO anagramma_form VALUES("1084","0","1596139466","Lessi получает 6 рубинов! Правильное слово: дерево");
INSERT INTO anagramma_form VALUES("1085","585","1596139480","Дверь");
INSERT INTO anagramma_form VALUES("1086","0","1596139480","Lessi получает 5 рубинов! Правильное слово: дверь");
INSERT INTO anagramma_form VALUES("1087","0","1596139702","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1088","0","1596140017","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1089","585","1596140037","Караван");
INSERT INTO anagramma_form VALUES("1090","0","1596140037","Lessi получает 7 рубинов! Правильное слово: караван");
INSERT INTO anagramma_form VALUES("1091","585","1596140083","Футбол");
INSERT INTO anagramma_form VALUES("1092","0","1596140083","Lessi получает 6 рубинов! Правильное слово: футбол");
INSERT INTO anagramma_form VALUES("1093","0","1596141349","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1094","585","1596141369","Плюс");
INSERT INTO anagramma_form VALUES("1095","0","1596141742","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1096","0","1596142227","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1097","585","1596142250","Орган");
INSERT INTO anagramma_form VALUES("1098","0","1596142250","Lessi получает 5 рубинов! Правильное слово: орган");
INSERT INTO anagramma_form VALUES("1099","585","1596142264","Город");
INSERT INTO anagramma_form VALUES("1100","0","1596142264","Lessi получает 5 рубинов! Правильное слово: город");
INSERT INTO anagramma_form VALUES("1101","585","1596142277","Руки");
INSERT INTO anagramma_form VALUES("1102","0","1596142277","Lessi получает 4 рубинов! Правильное слово: руки");
INSERT INTO anagramma_form VALUES("1103","585","1596142321","Улыбка");
INSERT INTO anagramma_form VALUES("1104","585","1596142337","Бутылка");
INSERT INTO anagramma_form VALUES("1105","0","1596142337","Lessi получает 7 рубинов! Правильное слово: бутылка");
INSERT INTO anagramma_form VALUES("1106","0","1596142573","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1107","585","1596142587","Сахар");
INSERT INTO anagramma_form VALUES("1108","0","1596142587","Lessi получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("1109","585","1596142602","Балда");
INSERT INTO anagramma_form VALUES("1110","0","1596142602","Lessi получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("1111","0","1596142707","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1112","0","1596144368","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1113","585","1596144398","Туалет");
INSERT INTO anagramma_form VALUES("1114","0","1596144398","Lessi получает 6 рубинов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("1115","585","1596144631","Солнце");
INSERT INTO anagramma_form VALUES("1116","0","1596144631","Lessi получает 6 рубинов! Правильное слово: солнце");
INSERT INTO anagramma_form VALUES("1117","585","1596144647","Икона");
INSERT INTO anagramma_form VALUES("1118","0","1596144647","Lessi получает 5 рубинов! Правильное слово: икона");
INSERT INTO anagramma_form VALUES("1119","585","1596144661","Бомба");
INSERT INTO anagramma_form VALUES("1120","0","1596144661","Lessi получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("1121","0","1596144894","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1122","585","1596144910","Круг");
INSERT INTO anagramma_form VALUES("1123","0","1596144910","Lessi получает 4 рубинов! Правильное слово: круг");
INSERT INTO anagramma_form VALUES("1124","585","1596144929","Ввод");
INSERT INTO anagramma_form VALUES("1125","0","1596144929","Lessi получает 4 рубинов! Правильное слово: ввод");
INSERT INTO anagramma_form VALUES("1126","585","1596144945","Дитя");
INSERT INTO anagramma_form VALUES("1127","0","1596144945","Lessi получает 4 рубинов! Правильное слово: дитя");
INSERT INTO anagramma_form VALUES("1128","585","1596144965","Туалет");
INSERT INTO anagramma_form VALUES("1129","0","1596144965","Lessi получает 6 рубинов! Правильное слово: туалет");
INSERT INTO anagramma_form VALUES("1130","0","1596145088","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1131","0","1596145200","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1132","0","1596145710","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1133","0","1596146007","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1134","585","1596146018","Круг");
INSERT INTO anagramma_form VALUES("1135","0","1596146018","Lessi получает 4 рубинов! Правильное слово: круг");
INSERT INTO anagramma_form VALUES("1136","585","1596146031","Ток");
INSERT INTO anagramma_form VALUES("1137","0","1596146031","Lessi получает 3 рубинов! Правильное слово: ток");
INSERT INTO anagramma_form VALUES("1138","585","1596146055","Лопата");
INSERT INTO anagramma_form VALUES("1139","0","1596146055","Lessi получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("1140","585","1596146093","Шапка");
INSERT INTO anagramma_form VALUES("1141","0","1596146093","Lessi получает 5 рубинов! Правильное слово: шапка");
INSERT INTO anagramma_form VALUES("1142","585","1596146108","Дом");
INSERT INTO anagramma_form VALUES("1143","0","1596146108","Lessi получает 3 рубинов! Правильное слово: дом");
INSERT INTO anagramma_form VALUES("1144","585","1596146121","Сахар");
INSERT INTO anagramma_form VALUES("1145","0","1596146121","Lessi получает 5 рубинов! Правильное слово: сахар");
INSERT INTO anagramma_form VALUES("1146","585","1596146146","Выдох");
INSERT INTO anagramma_form VALUES("1147","585","1596146157","Выход");
INSERT INTO anagramma_form VALUES("1148","0","1596146157","Lessi получает 5 рубинов! Правильное слово: выход");
INSERT INTO anagramma_form VALUES("1149","585","1596146172","Лопата");
INSERT INTO anagramma_form VALUES("1150","0","1596146172","Lessi получает 6 рубинов! Правильное слово: лопата");
INSERT INTO anagramma_form VALUES("1151","585","1596146185","Часы");
INSERT INTO anagramma_form VALUES("1152","0","1596146185","Lessi получает 4 рубинов! Правильное слово: часы");
INSERT INTO anagramma_form VALUES("1153","585","1596146233","Ворона");
INSERT INTO anagramma_form VALUES("1154","0","1596146233","Lessi получает 6 рубинов! Правильное слово: ворона");
INSERT INTO anagramma_form VALUES("1155","0","1596146270","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1156","0","1596146399","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1157","585","1596146445","Ток");
INSERT INTO anagramma_form VALUES("1158","585","1596146455","Кот");
INSERT INTO anagramma_form VALUES("1159","0","1596146455","Lessi получает 3 рубинов! Правильное слово: кот");
INSERT INTO anagramma_form VALUES("1160","585","1596146484","Клавиатура");
INSERT INTO anagramma_form VALUES("1161","0","1596146484","Lessi получает 10 рубинов! Правильное слово: клавиатура");
INSERT INTO anagramma_form VALUES("1162","0","1596146515","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1163","585","1596146530","Очки");
INSERT INTO anagramma_form VALUES("1164","0","1596146530","Lessi получает 4 рубинов! Правильное слово: очки");
INSERT INTO anagramma_form VALUES("1165","585","1596146543","Заяц");
INSERT INTO anagramma_form VALUES("1166","0","1596146543","Lessi получает 4 рубинов! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("1167","0","1596267708","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1168","0","1596267824","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1169","585","1596267843","Опять");
INSERT INTO anagramma_form VALUES("1170","0","1596267843","Lessi получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("1171","585","1596267875","Суббота");
INSERT INTO anagramma_form VALUES("1172","0","1596267875","Lessi получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("1173","585","1596267900","Ссылка");
INSERT INTO anagramma_form VALUES("1174","0","1596267900","Lessi получает 6 рубинов! Правильное слово: ссылка");
INSERT INTO anagramma_form VALUES("1175","0","1596268709","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1176","585","1596268736","Калибр");
INSERT INTO anagramma_form VALUES("1177","0","1596268736","Lessi получает 6 рубинов! Правильное слово: калибр");
INSERT INTO anagramma_form VALUES("1178","585","1596268822","Капуста");
INSERT INTO anagramma_form VALUES("1179","0","1596268822","Lessi получает 7 рубинов! Правильное слово: капуста");
INSERT INTO anagramma_form VALUES("1180","585","1596268849","Плюс");
INSERT INTO anagramma_form VALUES("1181","0","1596286306","Элис в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1182","425","1596286323","Ладошка");
INSERT INTO anagramma_form VALUES("1183","0","1596305139","Элис в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1184","425","1596305338","Система, корм");
INSERT INTO anagramma_form VALUES("1185","425","1596305361","Рука");
INSERT INTO anagramma_form VALUES("1186","0","1596305361","Элис получает 4 рубинов! Правильное слово: рука");
INSERT INTO anagramma_form VALUES("1187","425","1596305424","Обезьяна");
INSERT INTO anagramma_form VALUES("1188","0","1596305424","Элис получает 8 рубинов! Правильное слово: обезьяна");
INSERT INTO anagramma_form VALUES("1189","425","1596305620","Атлас");
INSERT INTO anagramma_form VALUES("1190","425","1596305659","ласта");
INSERT INTO anagramma_form VALUES("1191","425","1596305680","Салат");
INSERT INTO anagramma_form VALUES("1192","0","1596305680","Элис получает 5 рубинов! Правильное слово: салат");
INSERT INTO anagramma_form VALUES("1193","425","1596305750","Сырость");
INSERT INTO anagramma_form VALUES("1194","0","1596305750","Элис получает 7 рубинов! Правильное слово: сырость");
INSERT INTO anagramma_form VALUES("1195","425","1596305769","Шапка");
INSERT INTO anagramma_form VALUES("1196","0","1596305769","Элис получает 5 рубинов! Правильное слово: шапка");
INSERT INTO anagramma_form VALUES("1197","425","1596305788","Банк");
INSERT INTO anagramma_form VALUES("1198","0","1596305788","Элис получает 4 рубинов! Правильное слово: банк");
INSERT INTO anagramma_form VALUES("1199","425","1596305855","Капитон");
INSERT INTO anagramma_form VALUES("1200","425","1596305984","Имя");
INSERT INTO anagramma_form VALUES("1201","0","1596305984","Элис получает 3 рубинов! Правильное слово: имя");
INSERT INTO anagramma_form VALUES("1202","425","1596306010","Лошадь");
INSERT INTO anagramma_form VALUES("1203","0","1596306010","Элис получает 6 рубинов! Правильное слово: лошадь");
INSERT INTO anagramma_form VALUES("1204","425","1596306021","Лось");
INSERT INTO anagramma_form VALUES("1205","425","1596306029","Саль");
INSERT INTO anagramma_form VALUES("1206","425","1596306036","Соль");
INSERT INTO anagramma_form VALUES("1207","0","1596306036","Элис получает 4 рубинов! Правильное слово: соль");
INSERT INTO anagramma_form VALUES("1208","425","1596306048","Шапка");
INSERT INTO anagramma_form VALUES("1209","0","1596306048","Элис получает 5 рубинов! Правильное слово: шапка");
INSERT INTO anagramma_form VALUES("1210","425","1596306067","Опять");
INSERT INTO anagramma_form VALUES("1211","0","1596306067","Элис получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("1212","425","1596306106","Накурил");
INSERT INTO anagramma_form VALUES("1213","425","1596306260","Балда");
INSERT INTO anagramma_form VALUES("1214","0","1596306260","Элис получает 5 рубинов! Правильное слово: балда");
INSERT INTO anagramma_form VALUES("1215","425","1596306335","Судьба");
INSERT INTO anagramma_form VALUES("1216","0","1596306335","Элис получает 6 рубинов! Правильное слово: судьба");
INSERT INTO anagramma_form VALUES("1217","425","1596306358","Кузнец");
INSERT INTO anagramma_form VALUES("1218","0","1596306358","Элис получает 6 рубинов! Правильное слово: кузнец");
INSERT INTO anagramma_form VALUES("1219","0","1596306499","Элис в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1220","425","1596306613","Слаксы");
INSERT INTO anagramma_form VALUES("1221","425","1596306763","Заяц");
INSERT INTO anagramma_form VALUES("1222","0","1596306763","Элис получает 4 рубинов! Правильное слово: заяц");
INSERT INTO anagramma_form VALUES("1223","425","1596306852","Дитя");
INSERT INTO anagramma_form VALUES("1224","0","1596306852","Элис получает 4 рубинов! Правильное слово: дитя");
INSERT INTO anagramma_form VALUES("1225","425","1596307046","Система");
INSERT INTO anagramma_form VALUES("1226","0","1596307046","Элис получает 7 рубинов! Правильное слово: система");
INSERT INTO anagramma_form VALUES("1227","425","1596307083","Боязень");
INSERT INTO anagramma_form VALUES("1228","425","1596307096","Болезнь");
INSERT INTO anagramma_form VALUES("1229","0","1596308264","Элис в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1230","425","1596308277","Семена");
INSERT INTO anagramma_form VALUES("1231","0","1596308277","Элис получает 6 рубинов! Правильное слово: семена");
INSERT INTO anagramma_form VALUES("1232","425","1596308304","Перебор");
INSERT INTO anagramma_form VALUES("1233","0","1596308304","Элис получает 7 рубинов! Правильное слово: перебор");
INSERT INTO anagramma_form VALUES("1234","425","1596308334","Тетечие");
INSERT INTO anagramma_form VALUES("1235","0","1596308337","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1236","425","1596308413","Чтение");
INSERT INTO anagramma_form VALUES("1237","425","1596308526","Бомба");
INSERT INTO anagramma_form VALUES("1238","0","1596308526","Элис получает 5 рубинов! Правильное слово: бомба");
INSERT INTO anagramma_form VALUES("1239","425","1596308544","Болото");
INSERT INTO anagramma_form VALUES("1240","0","1596308544","Элис получает 6 рубинов! Правильное слово: болото");
INSERT INTO anagramma_form VALUES("1241","585","1596308562","Дите");
INSERT INTO anagramma_form VALUES("1242","425","1596308572","Опять");
INSERT INTO anagramma_form VALUES("1243","0","1596308572","Элис получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("1244","585","1596308599","Дети");
INSERT INTO anagramma_form VALUES("1245","0","1596308599","Lessi получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("1246","585","1596308616","Друг");
INSERT INTO anagramma_form VALUES("1247","0","1596308616","Lessi получает 4 рубинов! Правильное слово: друг");
INSERT INTO anagramma_form VALUES("1248","0","1596308740","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1249","0","1596309166","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1250","0","1596310164","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1251","585","1596310177","Дети");
INSERT INTO anagramma_form VALUES("1252","0","1596310177","Lessi получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("1253","585","1596310322","Террорист");
INSERT INTO anagramma_form VALUES("1254","0","1596310322","Lessi получает 9 рубинов! Правильное слово: террорист");
INSERT INTO anagramma_form VALUES("1255","585","1596310339","Плюс");
INSERT INTO anagramma_form VALUES("1256","0","1596310490","Lessi в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1257","585","1596310531","Сплю");
INSERT INTO anagramma_form VALUES("1258","0","1596310531","Lessi получает 4 рубинов! Правильное слово: сплю");
INSERT INTO anagramma_form VALUES("1259","585","1596310547","Дети");
INSERT INTO anagramma_form VALUES("1260","0","1596310547","Lessi получает 4 рубинов! Правильное слово: дети");
INSERT INTO anagramma_form VALUES("1261","585","1596310572","Суббота");
INSERT INTO anagramma_form VALUES("1262","0","1596310572","Lessi получает 7 рубинов! Правильное слово: суббота");
INSERT INTO anagramma_form VALUES("1263","0","1596386784","Элис в игре! Поприветствуем!");
INSERT INTO anagramma_form VALUES("1264","425","1596386803","Стол");
INSERT INTO anagramma_form VALUES("1265","0","1596386803","Элис получает 4 рубинов! Правильное слово: стол");
INSERT INTO anagramma_form VALUES("1266","425","1596386825","Течение");
INSERT INTO anagramma_form VALUES("1267","0","1596386825","Элис получает 7 рубинов! Правильное слово: течение");
INSERT INTO anagramma_form VALUES("1268","425","1596386864","Опять");
INSERT INTO anagramma_form VALUES("1269","0","1596386864","Элис получает 5 рубинов! Правильное слово: опять");
INSERT INTO anagramma_form VALUES("1270","0","1597514563","Чумазая в игре! Поприветствуем!");



DROP TABLE IF EXISTS `apples`;

CREATE TABLE `apples` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `num` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `apples_love`;

CREATE TABLE `apples_love` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions`;

CREATE TABLE `auctions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `bank` int(11) NOT NULL DEFAULT '0',
  `kol` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `stavka` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions_chat`;

CREATE TABLE `auctions_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(2000) NOT NULL DEFAULT '0',
  `show` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `id_reply` int(11) NOT NULL DEFAULT '0',
  `id_show` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `auctions_set`;

CREATE TABLE `auctions_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `close` enum('0','1') NOT NULL DEFAULT '0',
  `start` int(11) NOT NULL DEFAULT '0',
  `tip` enum('0','1') NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `kols` int(11) NOT NULL DEFAULT '0',
  `timesgo` int(11) NOT NULL DEFAULT '0',
  `timesstop` int(11) NOT NULL DEFAULT '0',
  `msg` varchar(350) NOT NULL DEFAULT 'По техническим причинам аукцион временно не доступен, пожалуйста попробуйте зайти через несколько минут, спасибо за понимание!',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO auctions_set VALUES("1","0","10","0","4200","3246","1522756021","1590328368","По техническим причинам аукцион временно не доступен, пожалуйста попробуйте зайти через несколько минут, спасибо за понимание!");



DROP TABLE IF EXISTS `auctions_top`;

CREATE TABLE `auctions_top` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `sum` int(11) NOT NULL DEFAULT '0',
  `stavok` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO auctions_top VALUES("1","1","3000","2","1591619368");



DROP TABLE IF EXISTS `auctions_user`;

CREATE TABLE `auctions_user` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `sum` int(32) NOT NULL DEFAULT '0',
  `num` int(11) NOT NULL DEFAULT '0',
  `last_sum` int(21) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban`;

CREATE TABLE `ban` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `time` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_ban` int(11) NOT NULL,
  `prich` varchar(1024) NOT NULL,
  `view` set('1','0') NOT NULL DEFAULT '0',
  `razdel` varchar(10) DEFAULT 'all',
  `post` int(1) DEFAULT '0',
  `pochemu` int(11) DEFAULT '0',
  `navsegda` int(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`,`id_ban`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `ban_ip`;

CREATE TABLE `ban_ip` (
  `min` bigint(20) NOT NULL,
  `max` bigint(20) NOT NULL,
  KEY `min` (`min`,`max`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bannlist`;

CREATE TABLE `bannlist` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `ip` char(100) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bar_cat`;

CREATE TABLE `bar_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;

INSERT INTO bar_cat VALUES("2","Напитки");
INSERT INTO bar_cat VALUES("3","Сладости");
INSERT INTO bar_cat VALUES("4","Поцелуй ");
INSERT INTO bar_cat VALUES("5","Стриптиз");
INSERT INTO bar_cat VALUES("6","Еда");
INSERT INTO bar_cat VALUES("7","Фрукты");
INSERT INTO bar_cat VALUES("8","Пожелания");
INSERT INTO bar_cat VALUES("9","Разное");
INSERT INTO bar_cat VALUES("10","Медпункт");
INSERT INTO bar_cat VALUES("11","День рождения ");
INSERT INTO bar_cat VALUES("12","С новым годом ");
INSERT INTO bar_cat VALUES("13","Днем свадьбы ");
INSERT INTO bar_cat VALUES("14","Позитивный заказ");
INSERT INTO bar_cat VALUES("15","Романтика");
INSERT INTO bar_cat VALUES("16","Остров сокровищ");
INSERT INTO bar_cat VALUES("17","Доброе утро ");
INSERT INTO bar_cat VALUES("18","Спокойной Ночи ");
INSERT INTO bar_cat VALUES("20","Приветики ");
INSERT INTO bar_cat VALUES("21","Добро пожаловать ");
INSERT INTO bar_cat VALUES("22","Цветики ");



DROP TABLE IF EXISTS `bar_list`;

CREATE TABLE `bar_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `podcat` int(11) NOT NULL DEFAULT '1',
  `money` int(11) NOT NULL DEFAULT '0',
  `img` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=683 DEFAULT CHARSET=utf8;

INSERT INTO bar_list VALUES("1","Тархун","4","50","/style/bar/1.png");
INSERT INTO bar_list VALUES("2","Сок апельсиновый ","4","50","/style/bar/2.png");
INSERT INTO bar_list VALUES("3","Сок клубничный","4","50","/style/bar/3.png");
INSERT INTO bar_list VALUES("4","Кока кола","4","50","/style/bar/4.gif");
INSERT INTO bar_list VALUES("5","7up","4","50","/style/bar/5.gif");
INSERT INTO bar_list VALUES("6","Чай","5","50","/style/bar/6.png");
INSERT INTO bar_list VALUES("7","Кофе с любовью","5","50","/style/bar/7.gif");
INSERT INTO bar_list VALUES("8","Кофе с куросаном","5","50","/style/bar/8.png");
INSERT INTO bar_list VALUES("9","Кофе","5","50","/style/bar/9.png");
INSERT INTO bar_list VALUES("10","Кофе с мороженым ","5","50","/style/bar/10.png");
INSERT INTO bar_list VALUES("11","Кофе с молоком","5","50","/style/bar/11.png");
INSERT INTO bar_list VALUES("12","Фруктовый сок","4","50","/style/bar/12.png");
INSERT INTO bar_list VALUES("13","Лимонад","4","50","/style/bar/13.gif");
INSERT INTO bar_list VALUES("41","Водка","1","150","/style/bar/41.png");
INSERT INTO bar_list VALUES("18","Бреннди","8","150","/style/bar/18.png");
INSERT INTO bar_list VALUES("44","Водка","1","150","/style/bar/44.png");
INSERT INTO bar_list VALUES("43","Водка","1","150","/style/bar/43.png");
INSERT INTO bar_list VALUES("19","Шампанское","7","150","/style/bar/19.gif");
INSERT INTO bar_list VALUES("20","Шампанское","7","150","/style/bar/20.png");
INSERT INTO bar_list VALUES("21","Шампанское","7","150","/style/bar/21.png");
INSERT INTO bar_list VALUES("22","Шампанское","7","150","/style/bar/22.png");
INSERT INTO bar_list VALUES("23","Шампанское","7","150","/style/bar/23.png");
INSERT INTO bar_list VALUES("24","Коньяк","3","150","/style/bar/24.png");
INSERT INTO bar_list VALUES("25","Коньяк","3","150","/style/bar/25.png");
INSERT INTO bar_list VALUES("26","Коньяк","3","150","/style/bar/26.png");
INSERT INTO bar_list VALUES("27","Коньяк","3","150","/style/bar/27.png");
INSERT INTO bar_list VALUES("28","Виски ","2","200","/style/bar/28.gif");
INSERT INTO bar_list VALUES("29","Виски ","2","200","/style/bar/29.png");
INSERT INTO bar_list VALUES("30","Виски ","2","200","/style/bar/30.png");
INSERT INTO bar_list VALUES("31","Виски ","2","200","/style/bar/31.gif");
INSERT INTO bar_list VALUES("33","Виски ","2","200","/style/bar/33.png");
INSERT INTO bar_list VALUES("34","Виски ","2","200","/style/bar/34.png");
INSERT INTO bar_list VALUES("35","Пиво","9","100","/style/bar/35.png");
INSERT INTO bar_list VALUES("36","Пиво","9","100","/style/bar/36.png");
INSERT INTO bar_list VALUES("37","Пиво","9","100","/style/bar/37.png");
INSERT INTO bar_list VALUES("38","Виски","2","200","/style/bar/38.png");
INSERT INTO bar_list VALUES("40","Виски","2","200","/style/bar/40.png");
INSERT INTO bar_list VALUES("45","Водка","1","150","/style/bar/45.png");
INSERT INTO bar_list VALUES("46","Водка","1","150","/style/bar/46.png");
INSERT INTO bar_list VALUES("47","Водка","1","150","/style/bar/47.png");
INSERT INTO bar_list VALUES("48","Водка","1","150","/style/bar/48.png");
INSERT INTO bar_list VALUES("49","Водка","1","150","/style/bar/49.png");
INSERT INTO bar_list VALUES("50","Водка","1","150","/style/bar/50.png");
INSERT INTO bar_list VALUES("51","Водка","1","150","/style/bar/51.png");
INSERT INTO bar_list VALUES("52","Водка","1","150","/style/bar/52.png");
INSERT INTO bar_list VALUES("53","Вино ","10","120","/style/bar/53.gif");
INSERT INTO bar_list VALUES("54","Вино ","10","120","/style/bar/54.png");
INSERT INTO bar_list VALUES("55","Вино ","10","120","/style/bar/55.png");
INSERT INTO bar_list VALUES("56","Вино ","10","120","/style/bar/56.png");
INSERT INTO bar_list VALUES("57","Вино ","10","120","/style/bar/57.png");
INSERT INTO bar_list VALUES("58","Вино ","10","120","/style/bar/58.png");
INSERT INTO bar_list VALUES("59","Тортик","11","100","/style/bar/59.png");
INSERT INTO bar_list VALUES("60","Тортик","11","100","/style/bar/60.png");
INSERT INTO bar_list VALUES("61","Коктейль \"Клубника\" ","12","100","/style/bar/61.png");
INSERT INTO bar_list VALUES("62","Коктейль \"Мечта\" ","12","100","/style/bar/62.png");
INSERT INTO bar_list VALUES("63","Коктейль ","12","100","/style/bar/63.png");
INSERT INTO bar_list VALUES("64","Коктейль \"Апельсин\" ","12","100","/style/bar/64.png");
INSERT INTO bar_list VALUES("65","Коктейль \"Манго\" ","12","100","/style/bar/65.png");
INSERT INTO bar_list VALUES("128","Пиво","9","100","/style/bar/128.gif");
INSERT INTO bar_list VALUES("67","Хлеб","13","50","/style/bar/67.png");
INSERT INTO bar_list VALUES("68","Сыр","13","50","/style/bar/68.png");
INSERT INTO bar_list VALUES("69","Сыр \"Нарезка\" ","13","50","/style/bar/69.png");
INSERT INTO bar_list VALUES("70","Нарезка","13","50","/style/bar/70.png");
INSERT INTO bar_list VALUES("71","Колбаса","13","50","/style/bar/71.png");
INSERT INTO bar_list VALUES("72","Ветчина ","13","50","/style/bar/72.png");
INSERT INTO bar_list VALUES("73","Грибочки","13","50","/style/bar/73.png");
INSERT INTO bar_list VALUES("74","Грибы","13","50","/style/bar/74.png");
INSERT INTO bar_list VALUES("75","Грибы маринованные ","13","50","/style/bar/75.png");
INSERT INTO bar_list VALUES("76","Апельсиновое","14","50","/style/bar/76.png");
INSERT INTO bar_list VALUES("77","Вишнёвое ","14","50","/style/bar/77.png");
INSERT INTO bar_list VALUES("78","Клубничное","14","50","/style/bar/78.png");
INSERT INTO bar_list VALUES("79","Черничное","14","50","/style/bar/79.png");
INSERT INTO bar_list VALUES("80","Фисташковое","14","50","/style/bar/80.png");
INSERT INTO bar_list VALUES("81","Мороженое с топпингом","14","50","/style/bar/81.png");
INSERT INTO bar_list VALUES("82","Ванильное","14","50","/style/bar/82.png");
INSERT INTO bar_list VALUES("83","Шоколад ","11","100","/style/bar/83.png");
INSERT INTO bar_list VALUES("84","Булка","13","50","/style/bar/84.png");
INSERT INTO bar_list VALUES("85","Пенное","9","100","/style/bar/85.png");
INSERT INTO bar_list VALUES("86","Пепси","4","50","/style/bar/86.png");
INSERT INTO bar_list VALUES("87","Кола","4","50","/style/bar/87.png");
INSERT INTO bar_list VALUES("139","Стрип","15","250","/style/bar/139.png");
INSERT INTO bar_list VALUES("90","Стрип","15","100","/style/bar/90.gif");
INSERT INTO bar_list VALUES("91","На стуле","15","100","/style/bar/91.gif");
INSERT INTO bar_list VALUES("92","Блины","16","100","/style/bar/92.png");
INSERT INTO bar_list VALUES("93","Оладьи","16","100","/style/bar/93.gif");
INSERT INTO bar_list VALUES("94","Огурцы","13","50","/style/bar/94.jpg");
INSERT INTO bar_list VALUES("95","Оливки","13","50","/style/bar/95.png");
INSERT INTO bar_list VALUES("96","Пицца","13","50","/style/bar/96.jpg");
INSERT INTO bar_list VALUES("97","Рыбка","13","50","/style/bar/97.jpg");
INSERT INTO bar_list VALUES("98","Сало","13","50","/style/bar/98.jpg");
INSERT INTO bar_list VALUES("99","Борщ","17","50","/style/bar/99.png");
INSERT INTO bar_list VALUES("100","Вареники","17","50","/style/bar/100.gif");
INSERT INTO bar_list VALUES("101","Жаркое","17","50","/style/bar/101.png");
INSERT INTO bar_list VALUES("102","котлеты","17","50","/style/bar/102.png");
INSERT INTO bar_list VALUES("103","курочка","17","50","/style/bar/103.png");
INSERT INTO bar_list VALUES("104","Обед","17","100","/style/bar/104.png");
INSERT INTO bar_list VALUES("105","пельмени","17","50","/style/bar/105.png");
INSERT INTO bar_list VALUES("106","Плов","17","50","/style/bar/106.png");
INSERT INTO bar_list VALUES("107","Ужин","17","50","/style/bar/107.png");
INSERT INTO bar_list VALUES("108","Шашлык ","17","50","/style/bar/108.png");
INSERT INTO bar_list VALUES("109","Чипсы","13","50","/style/bar/109.jpg");
INSERT INTO bar_list VALUES("110","Сыр","13","50","/style/bar/110.png");
INSERT INTO bar_list VALUES("111","Фисташки","13","50","/style/bar/111.png");
INSERT INTO bar_list VALUES("112","Мороз","14","50","/style/bar/112.png");
INSERT INTO bar_list VALUES("113","Морозко","14","50","/style/bar/113.gif");
INSERT INTO bar_list VALUES("114","Шок","11","50","/style/bar/114.gif");
INSERT INTO bar_list VALUES("115","Торт","11","50","/style/bar/115.jpg");
INSERT INTO bar_list VALUES("116","Шок торт","11","50","/style/bar/116.png");
INSERT INTO bar_list VALUES("117","Пироженое","11","50","/style/bar/117.png");
INSERT INTO bar_list VALUES("118","пирожное1","11","50","/style/bar/118.png");
INSERT INTO bar_list VALUES("119","конфеты","11","50","/style/bar/119.png");
INSERT INTO bar_list VALUES("120","Мармелад ","11","50","/style/bar/120.png");
INSERT INTO bar_list VALUES("121","Зефир","11","50","/style/bar/121.png");
INSERT INTO bar_list VALUES("122","варенье","11","50","/style/bar/122.jpg");
INSERT INTO bar_list VALUES("123","Икра кр","13","50","/style/bar/123.png");
INSERT INTO bar_list VALUES("124","Икра чер","13","50","/style/bar/124.png");
INSERT INTO bar_list VALUES("125","Завтрок","17","50","/style/bar/125.png");
INSERT INTO bar_list VALUES("126","Вино","10","50","/style/bar/126.gif");
INSERT INTO bar_list VALUES("127","Вино","10","50","/style/bar/127.png");
INSERT INTO bar_list VALUES("129","Пиво","9","50","/style/bar/129.jpg");
INSERT INTO bar_list VALUES("130","Бананы","18","50","/style/bar/130.gif");
INSERT INTO bar_list VALUES("132","Апельсины","18","50","/style/bar/132.png");
INSERT INTO bar_list VALUES("133","виноград","18","50","/style/bar/133.png");
INSERT INTO bar_list VALUES("134","Дыня","18","50","/style/bar/134.png");
INSERT INTO bar_list VALUES("135","клубника","18","50","/style/bar/135.png");
INSERT INTO bar_list VALUES("136","лимон","18","50","/style/bar/136.png");
INSERT INTO bar_list VALUES("137","малина","18","50","/style/bar/137.jpg");
INSERT INTO bar_list VALUES("138","Фрукты","18","100","/style/bar/138.png");
INSERT INTO bar_list VALUES("140","Стрип","15","250","/style/bar/140.png");
INSERT INTO bar_list VALUES("141","Стрип","19","250","/style/bar/141.gif");
INSERT INTO bar_list VALUES("142","Стрип","19","250","/style/bar/142.png");
INSERT INTO bar_list VALUES("143","Стрип","15","250","/style/bar/143.gif");
INSERT INTO bar_list VALUES("144","Стрип","15","250","/style/bar/144.gif");
INSERT INTO bar_list VALUES("145","Стрип","15","250","/style/bar/145.gif");
INSERT INTO bar_list VALUES("146","Поцелуй","20","100","/style/bar/146.gif");
INSERT INTO bar_list VALUES("147","Поцелуй","20","100","/style/bar/147.gif");
INSERT INTO bar_list VALUES("148","Поцелуй","20","100","/style/bar/148.gif");
INSERT INTO bar_list VALUES("149","Поцелуй","20","100","/style/bar/149.gif");
INSERT INTO bar_list VALUES("150","Поцелуй","20","100","/style/bar/150.gif");
INSERT INTO bar_list VALUES("151","Поцелуй","20","100","/style/bar/151.gif");
INSERT INTO bar_list VALUES("152","Поцелуй","20","100","/style/bar/152.gif");
INSERT INTO bar_list VALUES("153","Поцелуй","20","100","/style/bar/153.gif");
INSERT INTO bar_list VALUES("154","Поцелуй","20","100","/style/bar/154.gif");
INSERT INTO bar_list VALUES("155","Поцелуй","20","100","/style/bar/155.gif");
INSERT INTO bar_list VALUES("156","Поцелуй","20","100","/style/bar/156.gif");
INSERT INTO bar_list VALUES("157","Поцелуй","20","100","/style/bar/157.gif");
INSERT INTO bar_list VALUES("158","Поцелуй","20","100","/style/bar/158.gif");
INSERT INTO bar_list VALUES("159","Поцелуй","20","100","/style/bar/159.gif");
INSERT INTO bar_list VALUES("160","Поцелуй","20","100","/style/bar/160.gif");
INSERT INTO bar_list VALUES("161","Поцелуй","20","100","/style/bar/161.gif");
INSERT INTO bar_list VALUES("162","Поцелуй","20","100","/style/bar/162.gif");
INSERT INTO bar_list VALUES("163","Поцелуй","20","100","/style/bar/163.gif");
INSERT INTO bar_list VALUES("164","Поцелуй","20","100","/style/bar/164.gif");
INSERT INTO bar_list VALUES("166","Пожелания","21","100","/style/bar/166.jpg");
INSERT INTO bar_list VALUES("167","Пожелания","21","50","/style/bar/167.png");
INSERT INTO bar_list VALUES("168","Пожелания","21","50","/style/bar/168.jpg");
INSERT INTO bar_list VALUES("169","Пожелания","21","50","/style/bar/169.jpg");
INSERT INTO bar_list VALUES("170","Пожелания","21","50","/style/bar/170.jpg");
INSERT INTO bar_list VALUES("171","Пожелания","21","50","/style/bar/171.jpg");
INSERT INTO bar_list VALUES("172","Пожелания","21","50","/style/bar/172.jpg");
INSERT INTO bar_list VALUES("173","Пожелания","21","50","/style/bar/173.jpg");
INSERT INTO bar_list VALUES("174","Пожелания","21","50","/style/bar/174.jpg");
INSERT INTO bar_list VALUES("175","Пожелания","21","50","/style/bar/175.jpg");
INSERT INTO bar_list VALUES("176","Пожелания","21","50","/style/bar/176.jpg");
INSERT INTO bar_list VALUES("177","Пожелания","21","50","/style/bar/177.jpg");
INSERT INTO bar_list VALUES("178","Пожелания","21","50","/style/bar/178.jpg");
INSERT INTO bar_list VALUES("179","Пожелания","21","50","/style/bar/179.jpg");
INSERT INTO bar_list VALUES("180","Пожелания","21","50","/style/bar/180.jpg");
INSERT INTO bar_list VALUES("181","Пожелания","21","50","/style/bar/181.jpg");
INSERT INTO bar_list VALUES("182","Пожелания","21","50","/style/bar/182.jpg");
INSERT INTO bar_list VALUES("183","Пожелания","21","50","/style/bar/183.jpg");
INSERT INTO bar_list VALUES("184","Пожелания","21","50","/style/bar/184.jpg");
INSERT INTO bar_list VALUES("185","Пожелания","21","50","/style/bar/185.jpg");
INSERT INTO bar_list VALUES("186","Пожелания","21","50","/style/bar/186.jpg");
INSERT INTO bar_list VALUES("187","Пожелания","21","50","/style/bar/187.jpg");
INSERT INTO bar_list VALUES("188","Пожелания","21","50","/style/bar/188.jpg");
INSERT INTO bar_list VALUES("189","Шампанское ","7","50","/style/bar/189.png");
INSERT INTO bar_list VALUES("190","Рюмка","1","50","/style/bar/190.gif");
INSERT INTO bar_list VALUES("191","Яд","23","250","/style/bar/191.gif");
INSERT INTO bar_list VALUES("192","Яга","22","50","/style/bar/192.jpg");
INSERT INTO bar_list VALUES("193","Рассол","22","50","/style/bar/193.gif");
INSERT INTO bar_list VALUES("194","Самогон","22","50","/style/bar/194.jpg");
INSERT INTO bar_list VALUES("195","Кс","5","50","/style/bar/195.png");
INSERT INTO bar_list VALUES("196","ликёр","22","50","/style/bar/196.png");
INSERT INTO bar_list VALUES("197","Мартини","22","50","/style/bar/197.gif");
INSERT INTO bar_list VALUES("198","Наливка ","22","50","/style/bar/198.png");
INSERT INTO bar_list VALUES("199","Джин","22","50","/style/bar/199.png");
INSERT INTO bar_list VALUES("200","Молоко","24","50","/style/bar/200.gif");
INSERT INTO bar_list VALUES("201","Кефир","24","50","/style/bar/201.png");
INSERT INTO bar_list VALUES("202","Вода","24","50","/style/bar/202.gif");
INSERT INTO bar_list VALUES("203","абсент","22","100","/style/bar/203.gif");
INSERT INTO bar_list VALUES("204","амаретто","22","100","/style/bar/204.gif");
INSERT INTO bar_list VALUES("205","Бальзам","22","100","/style/bar/205.png");
INSERT INTO bar_list VALUES("206","Пожелания","21","50","/style/bar/206.png");
INSERT INTO bar_list VALUES("207","Пожелания ","21","50","/style/bar/207.gif");
INSERT INTO bar_list VALUES("208","Пожелания","21","50","/style/bar/208.gif");
INSERT INTO bar_list VALUES("209","Пожелания","21","50","/style/bar/209.gif");
INSERT INTO bar_list VALUES("210","Пожелания","21","50","/style/bar/210.gif");
INSERT INTO bar_list VALUES("211","Пожелания","21","50","/style/bar/211.jpg");
INSERT INTO bar_list VALUES("212","Пожелания","21","50","/style/bar/212.gif");
INSERT INTO bar_list VALUES("213","Пожелания","21","50","/style/bar/213.gif");
INSERT INTO bar_list VALUES("214","Пожелания","21","50","/style/bar/214.gif");
INSERT INTO bar_list VALUES("215","Пожелания","21","50","/style/bar/215.jpg");
INSERT INTO bar_list VALUES("216","Пожелания","21","50","/style/bar/216.gif");
INSERT INTO bar_list VALUES("217","Пожелания","21","50","/style/bar/217.jpg");
INSERT INTO bar_list VALUES("218","Пожелания","21","50","/style/bar/218.gif");
INSERT INTO bar_list VALUES("220","Чай","5","50","/style/bar/220.gif");
INSERT INTO bar_list VALUES("221","Чай","5","50","/style/bar/221.gif");
INSERT INTO bar_list VALUES("222","Кофе","5","50","/style/bar/222.gif");
INSERT INTO bar_list VALUES("223","Кофе на двоих","5","50","/style/bar/223.png");
INSERT INTO bar_list VALUES("224","Шампанское ","7","50","/style/bar/224.png");
INSERT INTO bar_list VALUES("225","Блюдо","17","50","/style/bar/225.gif");
INSERT INTO bar_list VALUES("226","Блюдо","17","50","/style/bar/226.png");
INSERT INTO bar_list VALUES("227","Блюдо","17","50","/style/bar/227.png");
INSERT INTO bar_list VALUES("228","Блюдо","17","50","/style/bar/228.png");
INSERT INTO bar_list VALUES("229","Романтика","17","100","/style/bar/229.png");
INSERT INTO bar_list VALUES("230","Салат","13","50","/style/bar/230.png");
INSERT INTO bar_list VALUES("231","Салат","13","50","/style/bar/231.png");
INSERT INTO bar_list VALUES("232","Семки","13","50","/style/bar/232.png");
INSERT INTO bar_list VALUES("233","Хлеб","13","50","/style/bar/233.png");
INSERT INTO bar_list VALUES("234","Стрип","15","250","/style/bar/234.gif");
INSERT INTO bar_list VALUES("235","Стрип","15","250","/style/bar/235.gif");
INSERT INTO bar_list VALUES("236","Стрип","15","250","/style/bar/236.gif");
INSERT INTO bar_list VALUES("237","Лекарство","25","50","/style/bar/237.gif");
INSERT INTO bar_list VALUES("238","ВраЧ","25","50","/style/bar/238.gif");
INSERT INTO bar_list VALUES("239","Лекарство","25","50","/style/bar/239.gif");
INSERT INTO bar_list VALUES("240","ВраЧ","25","50","/style/bar/240.gif");
INSERT INTO bar_list VALUES("241","Врач ","25","50","/style/bar/241.gif");
INSERT INTO bar_list VALUES("242","Врач с таблеткой","25","50","/style/bar/242.gif");
INSERT INTO bar_list VALUES("243","Врач","25","50","/style/bar/243.gif");
INSERT INTO bar_list VALUES("244","Яблоки","18","50","/style/bar/244.gif");
INSERT INTO bar_list VALUES("245","Персик","18","50","/style/bar/245.png");
INSERT INTO bar_list VALUES("246","Персик","18","50","/style/bar/246.png");
INSERT INTO bar_list VALUES("247","лимон","18","50","/style/bar/247.gif");
INSERT INTO bar_list VALUES("248","Картошка","17","50","/style/bar/248.jpg");
INSERT INTO bar_list VALUES("249","Яичница","17","50","/style/bar/249.");
INSERT INTO bar_list VALUES("250","Яичница","17","50","/style/bar/250.gif");
INSERT INTO bar_list VALUES("251","Шашлык ","17","50","/style/bar/251.gif");
INSERT INTO bar_list VALUES("252","Курица","17","50","/style/bar/252.gif");
INSERT INTO bar_list VALUES("253","Завтрок","17","50","/style/bar/253.png");
INSERT INTO bar_list VALUES("254","Хлеб","13","50","/style/bar/254.gif");
INSERT INTO bar_list VALUES("255","Холодец","13","50","/style/bar/255.gif");
INSERT INTO bar_list VALUES("256","Мимоза ","13","50","/style/bar/256.gif");
INSERT INTO bar_list VALUES("257","Нарезка","13","50","/style/bar/257.png");
INSERT INTO bar_list VALUES("258","Закусь","13","50","/style/bar/258.jpg");
INSERT INTO bar_list VALUES("259","Бутер","13","50","/style/bar/259.png");
INSERT INTO bar_list VALUES("260","Чипсы","13","50","/style/bar/260.gif");
INSERT INTO bar_list VALUES("261","Пироженое","11","50","/style/bar/261.gif");
INSERT INTO bar_list VALUES("262","Шоколад","11","50","/style/bar/262.gif");
INSERT INTO bar_list VALUES("263","Канфеты","11","50","/style/bar/263.gif");
INSERT INTO bar_list VALUES("264","Пасха","26","50","/style/bar/264.png");
INSERT INTO bar_list VALUES("265","Банкет","26","250","/style/bar/265.gif");
INSERT INTO bar_list VALUES("266","Скарпион","22","100","/style/bar/266.jpg");
INSERT INTO bar_list VALUES("267","Спирт","22","100","/style/bar/267.gif");
INSERT INTO bar_list VALUES("268","Самогон","22","100","/style/bar/268.png");
INSERT INTO bar_list VALUES("269","Сюрприз","22","50","/style/bar/269.gif");
INSERT INTO bar_list VALUES("270","Чифир","22","100","/style/bar/270.jpg");
INSERT INTO bar_list VALUES("271","Кобра","22","100","/style/bar/271.jpg");
INSERT INTO bar_list VALUES("272","Бальзам","22","100","/style/bar/272.gif");
INSERT INTO bar_list VALUES("273","Шампанское ","7","100","/style/bar/273.gif");
INSERT INTO bar_list VALUES("274","Шампанское ","7","50","/style/bar/274.gif");
INSERT INTO bar_list VALUES("275","Шампанское ","7","100","/style/bar/275.jpg");
INSERT INTO bar_list VALUES("276","Шампанское ","7","100","/style/bar/276.gif");
INSERT INTO bar_list VALUES("277","Шампанское  молодым","7","50","/style/bar/277.jpg");
INSERT INTO bar_list VALUES("278","Шампанское  чок","7","50","/style/bar/278.gif");
INSERT INTO bar_list VALUES("279","Шампанское  с новым годом ","7","50","/style/bar/279.gif");
INSERT INTO bar_list VALUES("280","Коктейль","12","50","/style/bar/280.png");
INSERT INTO bar_list VALUES("281","Кок","12","50","/style/bar/281.jpg");
INSERT INTO bar_list VALUES("282","Кок","12","50","/style/bar/282.jpg");
INSERT INTO bar_list VALUES("283","Кок","12","50","/style/bar/283.png");
INSERT INTO bar_list VALUES("284","Вино белое","10","50","/style/bar/284.png");
INSERT INTO bar_list VALUES("285","Вино красное ","10","50","/style/bar/285.gif");
INSERT INTO bar_list VALUES("286","Вино","10","50","/style/bar/286.gif");
INSERT INTO bar_list VALUES("287","Пиво","9","50","/style/bar/287.gif");
INSERT INTO bar_list VALUES("288","Пиво","9","50","/style/bar/288.gif");
INSERT INTO bar_list VALUES("289","Любимым","5","50","/style/bar/289.gif");
INSERT INTO bar_list VALUES("290","Чай с лимоном ","5","50","/style/bar/290.jpg");
INSERT INTO bar_list VALUES("291","Для тебя","5","50","/style/bar/291.gif");
INSERT INTO bar_list VALUES("292","Какао","5","50","/style/bar/292.png");
INSERT INTO bar_list VALUES("293","Водка","1","50","/style/bar/293.gif");
INSERT INTO bar_list VALUES("294","Водка","1","50","/style/bar/294.gif");
INSERT INTO bar_list VALUES("501","С днюхой","27","200","/style/bar/501.png");
INSERT INTO bar_list VALUES("500","С днюхой","27","200","/style/bar/500.png");
INSERT INTO bar_list VALUES("297","Д р","27","50","/style/bar/297.gif");
INSERT INTO bar_list VALUES("298","День рождения ","27","50","/style/bar/298.gif");
INSERT INTO bar_list VALUES("299","С днем рождения ","27","50","/style/bar/299.gif");
INSERT INTO bar_list VALUES("300","Мандарины","18","50","/style/bar/300.gif");
INSERT INTO bar_list VALUES("301","Пожелания ","21","50","/style/bar/301.jpg");
INSERT INTO bar_list VALUES("302","Пожелания ","21","50","/style/bar/302.jpeg");
INSERT INTO bar_list VALUES("303","С наступающим","28","50","/style/bar/303.gif");
INSERT INTO bar_list VALUES("304","Нг","28","50","/style/bar/304.gif");
INSERT INTO bar_list VALUES("305","Нг","28","50","/style/bar/305.gif");
INSERT INTO bar_list VALUES("306","Нг","28","50","/style/bar/306.gif");
INSERT INTO bar_list VALUES("307","Нг","28","50","/style/bar/307.gif");
INSERT INTO bar_list VALUES("308","С новым годом ","28","50","/style/bar/308.gif");
INSERT INTO bar_list VALUES("309","НГ уже близко","28","50","/style/bar/309.gif");
INSERT INTO bar_list VALUES("310","Новый год","28","50","/style/bar/310.gif");
INSERT INTO bar_list VALUES("311","Добро пожаловать","26","50","/style/bar/311.gif");
INSERT INTO bar_list VALUES("312","Ключ от сайта","26","50","/style/bar/312.gif");
INSERT INTO bar_list VALUES("313","Будь как дома","26","50","/style/bar/313.gif");
INSERT INTO bar_list VALUES("314","Королеве сайта","26","50","/style/bar/314.jpg");
INSERT INTO bar_list VALUES("315","Золотое сердце","26","50","/style/bar/315.gif");
INSERT INTO bar_list VALUES("316","Девушке","26","50","/style/bar/316.gif");
INSERT INTO bar_list VALUES("317","Не мерзни","26","50","/style/bar/317.gif");
INSERT INTO bar_list VALUES("318","Ты прекрасная ","26","50","/style/bar/318.jpg");
INSERT INTO bar_list VALUES("319","Вот","26","50","/style/bar/319.gif");
INSERT INTO bar_list VALUES("320","Стрип","15","250","/style/bar/320.gif");
INSERT INTO bar_list VALUES("321","Стрип","15","250","/style/bar/321.gif");
INSERT INTO bar_list VALUES("322","Стрип","19","250","/style/bar/322.jpg");
INSERT INTO bar_list VALUES("323","Стрип","19","250","/style/bar/323.jpg");
INSERT INTO bar_list VALUES("324","Стрип","19","250","/style/bar/324.jpg");
INSERT INTO bar_list VALUES("325","Свадьба","29","50","/style/bar/325.gif");
INSERT INTO bar_list VALUES("326","Свадьба","29","50","/style/bar/326.gif");
INSERT INTO bar_list VALUES("327","Свадьба","29","50","/style/bar/327.jpg");
INSERT INTO bar_list VALUES("328","Свадьба","29","50","/style/bar/328.jpg");
INSERT INTO bar_list VALUES("329","Отличных выходных","31","100","/style/bar/329.png");
INSERT INTO bar_list VALUES("330","Гульнем ","31","100","/style/bar/330.png");
INSERT INTO bar_list VALUES("332","Романтика","34","100","/style/bar/332.gif");
INSERT INTO bar_list VALUES("333","Ты мне нужен","34","100","/style/bar/333.png");
INSERT INTO bar_list VALUES("334","Романтика","32","100","/style/bar/334.png");
INSERT INTO bar_list VALUES("335","Романтика","32","100","/style/bar/335.gif");
INSERT INTO bar_list VALUES("336","Романтика","32","100","/style/bar/336.png");
INSERT INTO bar_list VALUES("337","Для Тебя","33","100","/style/bar/337.png");
INSERT INTO bar_list VALUES("338","Ты моя ","33","100","/style/bar/338.png");
INSERT INTO bar_list VALUES("339","Романтика","32","100","/style/bar/339.gif");
INSERT INTO bar_list VALUES("340","Романтика","32","100","/style/bar/340.gif");
INSERT INTO bar_list VALUES("341","Романтика","32","100","/style/bar/341.gif");
INSERT INTO bar_list VALUES("342","Цемки бомки","20","100","/style/bar/342.gif");
INSERT INTO bar_list VALUES("343","Цемки бомки","20","100","/style/bar/343.gif");
INSERT INTO bar_list VALUES("344","Цемки бомки","20","100","/style/bar/344.gif");
INSERT INTO bar_list VALUES("345","Цемки бомки","20","100","/style/bar/345.png");
INSERT INTO bar_list VALUES("346","Цемки бомки","20","100","/style/bar/346.png");
INSERT INTO bar_list VALUES("347","Цемки бомки","20","100","/style/bar/347.gif");
INSERT INTO bar_list VALUES("348","Цемки бомки","20","100","/style/bar/348.gif");
INSERT INTO bar_list VALUES("349","Цемки бомки","20","100","/style/bar/349.gif");
INSERT INTO bar_list VALUES("350","Куда спрятал наливай(прик)","38","100","/style/bar/350.gif");
INSERT INTO bar_list VALUES("351","Атакуем форум","39","200","/style/bar/351.gif");
INSERT INTO bar_list VALUES("352","Собачий вальс","39","100","/style/bar/352.gif");
INSERT INTO bar_list VALUES("353","Преоделся","39","100","/style/bar/353.gif");
INSERT INTO bar_list VALUES("354","За мной на форум","39","200","/style/bar/354.gif");
INSERT INTO bar_list VALUES("355","Наточу прийду","39","100","/style/bar/355.gif");
INSERT INTO bar_list VALUES("356","Выходи за меня ","29","100","/style/bar/356.png");
INSERT INTO bar_list VALUES("357","Вместе навсегда","29","100","/style/bar/357.png");
INSERT INTO bar_list VALUES("358","Совет да любовь","29","100","/style/bar/358.png");
INSERT INTO bar_list VALUES("359","Любви и счастья ","29","100","/style/bar/359.png");
INSERT INTO bar_list VALUES("360","Доброе утро ","40","100","/style/bar/360.png");
INSERT INTO bar_list VALUES("361","Доброе утро ","40","100","/style/bar/361.png");
INSERT INTO bar_list VALUES("362","Доброе утро ","40","100","/style/bar/362.png");
INSERT INTO bar_list VALUES("363","Доброе утро ","40","100","/style/bar/363.gif");
INSERT INTO bar_list VALUES("364","Доброе Утро","41","100","/style/bar/364.gif");
INSERT INTO bar_list VALUES("365","Доброе Утро","41","100","/style/bar/365.gif");
INSERT INTO bar_list VALUES("366","Доброе Утро","41","100","/style/bar/366.gif");
INSERT INTO bar_list VALUES("367","Доброе Утро","41","100","/style/bar/367.gif");
INSERT INTO bar_list VALUES("368","Доброе Утро","41","100","/style/bar/368.gif");
INSERT INTO bar_list VALUES("369","Доброе Утро","41","100","/style/bar/369.gif");
INSERT INTO bar_list VALUES("370","Доброе Утро","41","100","/style/bar/370.gif");
INSERT INTO bar_list VALUES("371","Доброе Утро","41","100","/style/bar/371.gif");
INSERT INTO bar_list VALUES("372","Доброе Утро","41","100","/style/bar/372.gif");
INSERT INTO bar_list VALUES("373","Доброе Утро","41","100","/style/bar/373.gif");
INSERT INTO bar_list VALUES("374","Доброе Утро","41","100","/style/bar/374.gif");
INSERT INTO bar_list VALUES("375","Доброе Утро","41","100","/style/bar/375.gif");
INSERT INTO bar_list VALUES("376","Цемки бомки","20","100","/style/bar/376.png");
INSERT INTO bar_list VALUES("377","Цемки бомки","20","100","/style/bar/377.gif");
INSERT INTO bar_list VALUES("378","Цемки бомки","20","100","/style/bar/378.gif");
INSERT INTO bar_list VALUES("379","Цемки бомки","20","100","/style/bar/379.gif");
INSERT INTO bar_list VALUES("380","Цемки бомки","20","100","/style/bar/380.gif");
INSERT INTO bar_list VALUES("381","Цемки бомки","20","100","/style/bar/381.gif");
INSERT INTO bar_list VALUES("382","Цемки бомки","20","100","/style/bar/382.gif");
INSERT INTO bar_list VALUES("383","Цемки бомки","20","100","/style/bar/383.gif");
INSERT INTO bar_list VALUES("384","Цемки бомки","20","100","/style/bar/384.gif");
INSERT INTO bar_list VALUES("385","Цемки бомки","20","100","/style/bar/385.gif");
INSERT INTO bar_list VALUES("386","Цемки бомки","20","100","/style/bar/386.gif");
INSERT INTO bar_list VALUES("387","Цемки бомки","20","100","/style/bar/387.gif");
INSERT INTO bar_list VALUES("388","Цемки бомки","20","100","/style/bar/388.gif");
INSERT INTO bar_list VALUES("389","Цемки бомки","20","100","/style/bar/389.gif");
INSERT INTO bar_list VALUES("390","Цемки бомки","20","100","/style/bar/390.gif");
INSERT INTO bar_list VALUES("391","Споки ноки ","42","100","/style/bar/391.png");
INSERT INTO bar_list VALUES("392","Споки ноки ","42","100","/style/bar/392.png");
INSERT INTO bar_list VALUES("393","Споки ноки ","42","100","/style/bar/393.gif");
INSERT INTO bar_list VALUES("394","Споки ноки ","42","100","/style/bar/394.gif");
INSERT INTO bar_list VALUES("395","Споки ноки ","42","100","/style/bar/395.png");
INSERT INTO bar_list VALUES("396","Споки ноки ","42","100","/style/bar/396.png");
INSERT INTO bar_list VALUES("397","Споки ноки ","42","100","/style/bar/397.png");
INSERT INTO bar_list VALUES("398","Споки ноки ","42","100","/style/bar/398.gif");
INSERT INTO bar_list VALUES("399","Споки ноки ","42","100","/style/bar/399.gif");
INSERT INTO bar_list VALUES("400","Споки ноки ","42","100","/style/bar/400.gif");
INSERT INTO bar_list VALUES("401","Споки ноки ","42","100","/style/bar/401.gif");
INSERT INTO bar_list VALUES("402","Споки ноки ","42","100","/style/bar/402.gif");
INSERT INTO bar_list VALUES("403","Споки ноки ","42","100","/style/bar/403.gif");
INSERT INTO bar_list VALUES("404","Иди ка сюда ","43","100","/style/bar/404.png");
INSERT INTO bar_list VALUES("405","ЗлюкаЮ","43","100","/style/bar/405.png");
INSERT INTO bar_list VALUES("406","Святая невиннннность ","43","100","/style/bar/406.png");
INSERT INTO bar_list VALUES("407","Нет нет ","43","100","/style/bar/407.gif");
INSERT INTO bar_list VALUES("408","Храпульки нет ","43","100","/style/bar/408.gif");
INSERT INTO bar_list VALUES("409","Трах тибидох напущу на тебя блох","43","100","/style/bar/409.gif");
INSERT INTO bar_list VALUES("410","Все вижу","43","100","/style/bar/410.gif");
INSERT INTO bar_list VALUES("411","Пали если чё","43","100","/style/bar/411.png");
INSERT INTO bar_list VALUES("412","Не жри","43","100","/style/bar/412.png");
INSERT INTO bar_list VALUES("413","Бери добро","43","100","/style/bar/413.png");
INSERT INTO bar_list VALUES("414","Ух какая","43","100","/style/bar/414.png");
INSERT INTO bar_list VALUES("415","Мужчинка мечта","43","100","/style/bar/415.png");
INSERT INTO bar_list VALUES("416","Бери дарю","43","100","/style/bar/416.png");
INSERT INTO bar_list VALUES("417","Нужное","43","100","/style/bar/417.png");
INSERT INTO bar_list VALUES("418","Похмелятинка","43","100","/style/bar/418.png");
INSERT INTO bar_list VALUES("419","Памперс ","43","100","/style/bar/419.png");
INSERT INTO bar_list VALUES("420","Не спи","43","100","/style/bar/420.gif");
INSERT INTO bar_list VALUES("421","Я у твоих ног","43","100","/style/bar/421.png");
INSERT INTO bar_list VALUES("422","Упакуйте","43","100","/style/bar/422.png");
INSERT INTO bar_list VALUES("423","Для жлопинки","43","100","/style/bar/423.png");
INSERT INTO bar_list VALUES("424","Не смотри на меня матом","43","100","/style/bar/424.png");
INSERT INTO bar_list VALUES("425","Цемочки","43","100","/style/bar/425.png");
INSERT INTO bar_list VALUES("426","Любимка ты где","43","100","/style/bar/426.gif");
INSERT INTO bar_list VALUES("427","Оберег от хвори","43","100","/style/bar/427.png");
INSERT INTO bar_list VALUES("428","Не играй ","43","100","/style/bar/428.png");
INSERT INTO bar_list VALUES("429","Кукуся ","43","100","/style/bar/429.gif");
INSERT INTO bar_list VALUES("430","Рассол","43","100","/style/bar/430.gif");
INSERT INTO bar_list VALUES("431","Чудо ты","43","100","/style/bar/431.gif");
INSERT INTO bar_list VALUES("432","Ла ла ла ","43","100","/style/bar/432.png");
INSERT INTO bar_list VALUES("433","ВаУ","43","100","/style/bar/433.png");
INSERT INTO bar_list VALUES("434","Зная себя","43","100","/style/bar/434.png");
INSERT INTO bar_list VALUES("435","От порчи ","43","100","/style/bar/435.png");
INSERT INTO bar_list VALUES("436","Буду обнимать ","43","100","/style/bar/436.png");
INSERT INTO bar_list VALUES("437","Да да да ","43","100","/style/bar/437.png");
INSERT INTO bar_list VALUES("438","Не усохни ","43","100","/style/bar/438.png");
INSERT INTO bar_list VALUES("439","Кусь","43","100","/style/bar/439.png");
INSERT INTO bar_list VALUES("440","Скороходы","43","100","/style/bar/440.gif");
INSERT INTO bar_list VALUES("441","Лыбу Шире Я в Эфире","43","100","/style/bar/441.png");
INSERT INTO bar_list VALUES("442","Наказан","43","100","/style/bar/442.png");
INSERT INTO bar_list VALUES("443","Антистрес ","43","100","/style/bar/443.png");
INSERT INTO bar_list VALUES("444","Пососунчик","43","100","/style/bar/444.png");
INSERT INTO bar_list VALUES("445","Все для тебя ","43","100","/style/bar/445.png");
INSERT INTO bar_list VALUES("446","Языкульку","43","100","/style/bar/446.png");
INSERT INTO bar_list VALUES("447","Доброе Утро","40","100","/style/bar/447.gif");
INSERT INTO bar_list VALUES("448","Доброе Утро","40","100","/style/bar/448.gif");
INSERT INTO bar_list VALUES("449","Привет","44","100","/style/bar/449.png");
INSERT INTO bar_list VALUES("450","Привет","44","100","/style/bar/450.png");
INSERT INTO bar_list VALUES("451","Привет","44","100","/style/bar/451.png");
INSERT INTO bar_list VALUES("452","Привет","44","100","/style/bar/452.png");
INSERT INTO bar_list VALUES("453","Привет","44","100","/style/bar/453.png");
INSERT INTO bar_list VALUES("454","Привет","44","100","/style/bar/454.png");
INSERT INTO bar_list VALUES("455","Привет","44","100","/style/bar/455.png");
INSERT INTO bar_list VALUES("456","Джага джага","19","100","/style/bar/456.gif");
INSERT INTO bar_list VALUES("457","Джага джага","19","100","/style/bar/457.gif");
INSERT INTO bar_list VALUES("458","Джага джага","19","100","/style/bar/458.gif");
INSERT INTO bar_list VALUES("459","Джага джага","19","100","/style/bar/459.gif");
INSERT INTO bar_list VALUES("460","Джага джага","19","100","/style/bar/460.gif");
INSERT INTO bar_list VALUES("461","Джага джага","19","100","/style/bar/461.gif");
INSERT INTO bar_list VALUES("462","Попой опа опа","15","100","/style/bar/462.gif");
INSERT INTO bar_list VALUES("463","Попой опа опа","15","100","/style/bar/463.gif");
INSERT INTO bar_list VALUES("464","Попой опа опа","15","100","/style/bar/464.gif");
INSERT INTO bar_list VALUES("465","Угощайся","5","0","/style/bar/465.png");
INSERT INTO bar_list VALUES("466","Угощайся","5","100","/style/bar/466.png");
INSERT INTO bar_list VALUES("467","Угощайся","5","100","/style/bar/467.png");
INSERT INTO bar_list VALUES("468","Угощайся","5","100","/style/bar/468.png");
INSERT INTO bar_list VALUES("469","Угощайся","5","100","/style/bar/469.gif");
INSERT INTO bar_list VALUES("470","Угощайся","5","100","/style/bar/470.png");
INSERT INTO bar_list VALUES("471","Угощайся","5","100","/style/bar/471.png");
INSERT INTO bar_list VALUES("472","Угощайся","5","100","/style/bar/472.png");
INSERT INTO bar_list VALUES("473","Угощайся","5","100","/style/bar/473.png");
INSERT INTO bar_list VALUES("474","Угощайся","5","100","/style/bar/474.png");
INSERT INTO bar_list VALUES("475","Угощайся","5","100","/style/bar/475.png");
INSERT INTO bar_list VALUES("476","Угощайся","5","100","/style/bar/476.png");
INSERT INTO bar_list VALUES("477","Угощайся","5","100","/style/bar/477.png");
INSERT INTO bar_list VALUES("478","Угощайся","5","100","/style/bar/478.gif");
INSERT INTO bar_list VALUES("479","Угощайся","5","100","/style/bar/479.png");
INSERT INTO bar_list VALUES("480","Для Тебя","5","100","/style/bar/480.png");
INSERT INTO bar_list VALUES("481","Для Тебя","5","100","/style/bar/481.gif");
INSERT INTO bar_list VALUES("482","Для Тебя","5","100","/style/bar/482.png");
INSERT INTO bar_list VALUES("483","Для Тебя","5","100","/style/bar/483.png");
INSERT INTO bar_list VALUES("484","Доброе Утро","40","100","/style/bar/484.png");
INSERT INTO bar_list VALUES("485","Доброе Утро","40","100","/style/bar/485.png");
INSERT INTO bar_list VALUES("486","Доброе Утро","40","100","/style/bar/486.png");
INSERT INTO bar_list VALUES("487","Доброе Утро","40","100","/style/bar/487.png");
INSERT INTO bar_list VALUES("488","Доброе Утро","40","100","/style/bar/488.png");
INSERT INTO bar_list VALUES("489","Доброе Утро","40","100","/style/bar/489.png");
INSERT INTO bar_list VALUES("490","Доброе Утро","40","100","/style/bar/490.png");
INSERT INTO bar_list VALUES("491","Доброе Утро","40","100","/style/bar/491.png");
INSERT INTO bar_list VALUES("492","Доброе Утро","40","100","/style/bar/492.png");
INSERT INTO bar_list VALUES("493","Доброе Утро","40","100","/style/bar/493.png");
INSERT INTO bar_list VALUES("496","Добро пожаловать ","45","200","/style/bar/496.png");
INSERT INTO bar_list VALUES("497","Добро пожаловать ","45","200","/style/bar/497.png");
INSERT INTO bar_list VALUES("498","Добро пожаловать ","45","200","/style/bar/498.gif");
INSERT INTO bar_list VALUES("499","Добро пожаловать ","45","200","/style/bar/499.png");
INSERT INTO bar_list VALUES("502","С днюхой","27","200","/style/bar/502.png");
INSERT INTO bar_list VALUES("503","С днюхой","27","200","/style/bar/503.gif");
INSERT INTO bar_list VALUES("504","С днюхой","27","200","/style/bar/504.gif");
INSERT INTO bar_list VALUES("505","С днюхой","27","200","/style/bar/505.gif");
INSERT INTO bar_list VALUES("506","С днюхой","27","200","/style/bar/506.gif");
INSERT INTO bar_list VALUES("507","С днюхой","27","200","/style/bar/507.gif");
INSERT INTO bar_list VALUES("508","С днюхой","27","200","/style/bar/508.gif");
INSERT INTO bar_list VALUES("509","С днюхой","27","200","/style/bar/509.gif");
INSERT INTO bar_list VALUES("510","С днюхой","27","200","/style/bar/510.gif");
INSERT INTO bar_list VALUES("511","С днюхой","27","200","/style/bar/511.gif");
INSERT INTO bar_list VALUES("512","С днюхой","27","200","/style/bar/512.gif");
INSERT INTO bar_list VALUES("513","С днюхой","27","200","/style/bar/513.gif");
INSERT INTO bar_list VALUES("514","С днюхой","27","200","/style/bar/514.gif");
INSERT INTO bar_list VALUES("515","С днюхой","27","200","/style/bar/515.png");
INSERT INTO bar_list VALUES("516","С днюхой","27","200","/style/bar/516.png");
INSERT INTO bar_list VALUES("517","С днюхой","27","200","/style/bar/517.png");
INSERT INTO bar_list VALUES("518","С днюхой","27","200","/style/bar/518.gif");
INSERT INTO bar_list VALUES("519","С днюхой","27","200","/style/bar/519.gif");
INSERT INTO bar_list VALUES("520","С днюхой","27","200","/style/bar/520.gif");
INSERT INTO bar_list VALUES("521","С днюхой","27","200","/style/bar/521.png");
INSERT INTO bar_list VALUES("522","Шампанское Советское","7","100","/style/bar/522.png");
INSERT INTO bar_list VALUES("523","Элитное Шампанское Моэт и Шандон","7","100","/style/bar/523.png");
INSERT INTO bar_list VALUES("524","  Шампанское Наш Киев","7","100","/style/bar/524.png");
INSERT INTO bar_list VALUES("525","Для тебя ","7","100","/style/bar/525.png");
INSERT INTO bar_list VALUES("526","Шампанское для нас","7","100","/style/bar/526.png");
INSERT INTO bar_list VALUES("527","Для двоих","7","100","/style/bar/527.gif");
INSERT INTO bar_list VALUES("528","Коньячок ","3","200","/style/bar/528.jpg");
INSERT INTO bar_list VALUES("529","Коньяк подарочный","3","200","/style/bar/529.jpg");
INSERT INTO bar_list VALUES("530","Коньяк","3","200","/style/bar/530.gif");
INSERT INTO bar_list VALUES("531","Remy Martin VSOP","3","100","/style/bar/531.png");
INSERT INTO bar_list VALUES("532","Морожка","14","100","/style/bar/532.png");
INSERT INTO bar_list VALUES("533","Морожка","14","100","/style/bar/533.png");
INSERT INTO bar_list VALUES("534","Морожка","14","100","/style/bar/534.png");
INSERT INTO bar_list VALUES("535","Морожка","14","100","/style/bar/535.gif");
INSERT INTO bar_list VALUES("536","Морожка","14","100","/style/bar/536.gif");
INSERT INTO bar_list VALUES("537","Морожка","14","100","/style/bar/537.png");
INSERT INTO bar_list VALUES("538","Морожка","14","100","/style/bar/538.png");
INSERT INTO bar_list VALUES("539","Морожка","14","100","/style/bar/539.png");
INSERT INTO bar_list VALUES("540","Морожка","14","100","/style/bar/540.png");
INSERT INTO bar_list VALUES("541","Морожка","14","100","/style/bar/541.png");
INSERT INTO bar_list VALUES("542","Морожка","14","100","/style/bar/542.png");
INSERT INTO bar_list VALUES("543","Морожка","14","100","/style/bar/543.png");
INSERT INTO bar_list VALUES("544","Морожка","14","100","/style/bar/544.png");
INSERT INTO bar_list VALUES("545","Морожка","14","100","/style/bar/545.gif");
INSERT INTO bar_list VALUES("546","Тортишка","46","100","/style/bar/546.png");
INSERT INTO bar_list VALUES("547","Тортишка","46","100","/style/bar/547.png");
INSERT INTO bar_list VALUES("548","Тортишка","46","100","/style/bar/548.png");
INSERT INTO bar_list VALUES("549","Тортишка","46","100","/style/bar/549.png");
INSERT INTO bar_list VALUES("550","Тортюнчик","46","100","/style/bar/550.png");
INSERT INTO bar_list VALUES("551","Тортюнчик","46","100","/style/bar/551.png");
INSERT INTO bar_list VALUES("552","Тортюнчик","46","100","/style/bar/552.png");
INSERT INTO bar_list VALUES("553","Тортюнчик","46","100","/style/bar/553.png");
INSERT INTO bar_list VALUES("554","Тортюнчик","46","100","/style/bar/554.gif");
INSERT INTO bar_list VALUES("555","Тортюнчик","46","100","/style/bar/555.gif");
INSERT INTO bar_list VALUES("556","Тортюнчик","46","100","/style/bar/556.gif");
INSERT INTO bar_list VALUES("557","Тортюнчик","46","100","/style/bar/557.gif");
INSERT INTO bar_list VALUES("558","Тортюнчик","46","100","/style/bar/558.gif");
INSERT INTO bar_list VALUES("559","Тортюнчик","46","100","/style/bar/559.gif");
INSERT INTO bar_list VALUES("560","Тортюнчик","46","100","/style/bar/560.gif");
INSERT INTO bar_list VALUES("561","Тортюнчик","46","100","/style/bar/561.png");
INSERT INTO bar_list VALUES("562","Тортюнчик","46","100","/style/bar/562.gif");
INSERT INTO bar_list VALUES("563","Тортюнчик","46","100","/style/bar/563.png");
INSERT INTO bar_list VALUES("564","Тортюнчик","46","100","/style/bar/564.png");
INSERT INTO bar_list VALUES("565","Тортюнчик","46","100","/style/bar/565.gif");
INSERT INTO bar_list VALUES("566","Тортюнчик","46","100","/style/bar/566.png");
INSERT INTO bar_list VALUES("567","Тортюнчик","46","100","/style/bar/567.gif");
INSERT INTO bar_list VALUES("568","Тортюнчик","46","100","/style/bar/568.gif");
INSERT INTO bar_list VALUES("569","Пироженко","11","100","/style/bar/569.jpg");
INSERT INTO bar_list VALUES("570","Шоколадкин","11","100","/style/bar/570.png");
INSERT INTO bar_list VALUES("571","Шоколадкин","11","100","/style/bar/571.png");
INSERT INTO bar_list VALUES("572","Прянишка","11","100","/style/bar/572.png");
INSERT INTO bar_list VALUES("573","Для сладкого настроения","11","100","/style/bar/573.jpg");
INSERT INTO bar_list VALUES("574","Для тебя ","11","100","/style/bar/574.png");
INSERT INTO bar_list VALUES("575","Зефирунчик","11","100","/style/bar/575.png");
INSERT INTO bar_list VALUES("576","Для тебя ","11","100","/style/bar/576.png");
INSERT INTO bar_list VALUES("577","Для сладкой жизни","11","100","/style/bar/577.png");
INSERT INTO bar_list VALUES("578","Для тебя ","11","100","/style/bar/578.gif");
INSERT INTO bar_list VALUES("579","Люблю тебя ","34","100","/style/bar/579.png");
INSERT INTO bar_list VALUES("580","Люблю тебя ","34","100","/style/bar/580.png");
INSERT INTO bar_list VALUES("581","Люблю тебя ","34","100","/style/bar/581.png");
INSERT INTO bar_list VALUES("582","Люблю тебя ","34","100","/style/bar/582.png");
INSERT INTO bar_list VALUES("583","Люблю тебя ","34","100","/style/bar/583.png");
INSERT INTO bar_list VALUES("584","Люблю тебя ","34","100","/style/bar/584.png");
INSERT INTO bar_list VALUES("585","Люблю тебя ","33","100","/style/bar/585.png");
INSERT INTO bar_list VALUES("586","Люблю тебя ","33","100","/style/bar/586.png");
INSERT INTO bar_list VALUES("587","Люблю тебя ","33","100","/style/bar/587.png");
INSERT INTO bar_list VALUES("588","Люблю тебя ","34","100","/style/bar/588.png");
INSERT INTO bar_list VALUES("589","Люблю тебя ","33","100","/style/bar/589.png");
INSERT INTO bar_list VALUES("590","Люблю тебя ","32","100","/style/bar/590.png");
INSERT INTO bar_list VALUES("591","Люблю тебя ","32","100","/style/bar/591.png");
INSERT INTO bar_list VALUES("592","Люблю тебя ","32","100","/style/bar/592.png");
INSERT INTO bar_list VALUES("593","Люблю тебя ","32","100","/style/bar/593.png");
INSERT INTO bar_list VALUES("594","Люблю тебя ","32","100","/style/bar/594.png");
INSERT INTO bar_list VALUES("595","Люблю тебя ","32","100","/style/bar/595.png");
INSERT INTO bar_list VALUES("596","Люблю тебя ","32","100","/style/bar/596.png");
INSERT INTO bar_list VALUES("597","Люблю тебя ","32","100","/style/bar/597.png");
INSERT INTO bar_list VALUES("598","Люблю тебя ","32","100","/style/bar/598.png");
INSERT INTO bar_list VALUES("599","Люблю тебя ","32","100","/style/bar/599.png");
INSERT INTO bar_list VALUES("600","Люблю тебя ","33","100","/style/bar/600.png");
INSERT INTO bar_list VALUES("601","Люблю тебя ","33","100","/style/bar/601.png");
INSERT INTO bar_list VALUES("602","Для тебя ","47","100","/style/bar/602.gif");
INSERT INTO bar_list VALUES("603","Для тебя ","47","100","/style/bar/603.gif");
INSERT INTO bar_list VALUES("604","Для тебя ","47","100","/style/bar/604.gif");
INSERT INTO bar_list VALUES("605","Для тебя ","47","100","/style/bar/605.gif");
INSERT INTO bar_list VALUES("606","Для тебя ","47","100","/style/bar/606.gif");
INSERT INTO bar_list VALUES("607","Для тебя ","47","100","/style/bar/607.gif");
INSERT INTO bar_list VALUES("608","Для тебя ","47","100","/style/bar/608.gif");
INSERT INTO bar_list VALUES("609","Для тебя ","47","100","/style/bar/609.gif");
INSERT INTO bar_list VALUES("610","Для тебя ","47","100","/style/bar/610.gif");
INSERT INTO bar_list VALUES("611","Для тебя ","47","100","/style/bar/611.gif");
INSERT INTO bar_list VALUES("612","Для тебя ","47","100","/style/bar/612.gif");
INSERT INTO bar_list VALUES("613","Для тебя ","47","100","/style/bar/613.gif");
INSERT INTO bar_list VALUES("614","Для тебя ","47","100","/style/bar/614.gif");
INSERT INTO bar_list VALUES("615","Для тебя ","47","100","/style/bar/615.gif");
INSERT INTO bar_list VALUES("616","Для тебя ","47","100","/style/bar/616.gif");
INSERT INTO bar_list VALUES("617","Для тебя ","47","100","/style/bar/617.gif");
INSERT INTO bar_list VALUES("618","Для тебя ","47","100","/style/bar/618.gif");
INSERT INTO bar_list VALUES("619","Для тебя ","47","100","/style/bar/619.gif");
INSERT INTO bar_list VALUES("620","Для тебя ","47","100","/style/bar/620.gif");
INSERT INTO bar_list VALUES("621","Для тебя ","47","100","/style/bar/621.gif");
INSERT INTO bar_list VALUES("622","Для тебя ","47","100","/style/bar/622.gif");
INSERT INTO bar_list VALUES("623","Для тебя ","47","100","/style/bar/623.gif");
INSERT INTO bar_list VALUES("624","Для тебя ","47","100","/style/bar/624.gif");
INSERT INTO bar_list VALUES("625","Для тебя ","47","100","/style/bar/625.gif");
INSERT INTO bar_list VALUES("626","Для тебя ","47","100","/style/bar/626.gif");
INSERT INTO bar_list VALUES("627","Для тебя ","47","100","/style/bar/627.gif");
INSERT INTO bar_list VALUES("628","Для тебя ","47","100","/style/bar/628.gif");
INSERT INTO bar_list VALUES("629","Для тебя ","47","100","/style/bar/629.gif");
INSERT INTO bar_list VALUES("630","Для тебя ","47","100","/style/bar/630.gif");
INSERT INTO bar_list VALUES("631","Для тебя ","47","100","/style/bar/631.gif");
INSERT INTO bar_list VALUES("632","Для тебя ","47","100","/style/bar/632.gif");
INSERT INTO bar_list VALUES("633","Для тебя ","47","100","/style/bar/633.gif");
INSERT INTO bar_list VALUES("634","По девкам ","43","100","/style/bar/634.png");
INSERT INTO bar_list VALUES("635","Вместо супа ","43","100","/style/bar/635.png");
INSERT INTO bar_list VALUES("636","Не роздевай","43","100","/style/bar/636.png");
INSERT INTO bar_list VALUES("637","Милый где ты ","43","100","/style/bar/637.gif");
INSERT INTO bar_list VALUES("638","Где мой цветик ","43","100","/style/bar/638.gif");
INSERT INTO bar_list VALUES("639","На прогулку становись ","43","100","/style/bar/639.gif");
INSERT INTO bar_list VALUES("640","Ржунчик","43","100","/style/bar/640.gif");
INSERT INTO bar_list VALUES("641","Не уходи ","43","100","/style/bar/641.gif");
INSERT INTO bar_list VALUES("642","Морожка","14","100","/style/bar/642.png");
INSERT INTO bar_list VALUES("643","Морожка","14","100","/style/bar/643.png");
INSERT INTO bar_list VALUES("644","Морожка","14","100","/style/bar/644.png");
INSERT INTO bar_list VALUES("645","Морожка","14","100","/style/bar/645.png");
INSERT INTO bar_list VALUES("646","Морожка","14","100","/style/bar/646.png");
INSERT INTO bar_list VALUES("647","Морожка","14","100","/style/bar/647.png");
INSERT INTO bar_list VALUES("648","Морожка","14","100","/style/bar/648.png");
INSERT INTO bar_list VALUES("649","Морожка","14","100","/style/bar/649.png");
INSERT INTO bar_list VALUES("650","Морожка","14","100","/style/bar/650.png");
INSERT INTO bar_list VALUES("651","Морожка","14","100","/style/bar/651.png");
INSERT INTO bar_list VALUES("652","Совет да любовь","29","100","/style/bar/652.png");
INSERT INTO bar_list VALUES("653","Совет да любовь","29","100","/style/bar/653.png");
INSERT INTO bar_list VALUES("654","Совет да любовь","29","100","/style/bar/654.png");
INSERT INTO bar_list VALUES("655","Совет да любовь","29","100","/style/bar/655.png");
INSERT INTO bar_list VALUES("656","Совет да любовь","29","100","/style/bar/656.png");
INSERT INTO bar_list VALUES("657","Совет да любовь","29","100","/style/bar/657.gif");
INSERT INTO bar_list VALUES("658","Совет да любовь","29","100","/style/bar/658.gif");
INSERT INTO bar_list VALUES("659","Совет да любовь","29","100","/style/bar/659.gif");
INSERT INTO bar_list VALUES("660","Совет да любовь","29","100","/style/bar/660.gif");
INSERT INTO bar_list VALUES("661","Совет да любовь","29","100","/style/bar/661.gif");
INSERT INTO bar_list VALUES("662","Совет да любовь","29","100","/style/bar/662.png");
INSERT INTO bar_list VALUES("663","Совет да любовь","29","100","/style/bar/663.png");
INSERT INTO bar_list VALUES("664","Совет да любовь","29","100","/style/bar/664.gif");
INSERT INTO bar_list VALUES("665","Совет да любовь","29","100","/style/bar/665.png");
INSERT INTO bar_list VALUES("666","Совет да любовь","29","100","/style/bar/666.gif");
INSERT INTO bar_list VALUES("667","Совет да любовь","29","100","/style/bar/667.gif");
INSERT INTO bar_list VALUES("668","Совет да любовь","29","100","/style/bar/668.gif");
INSERT INTO bar_list VALUES("669","Совет да любовь","29","100","/style/bar/669.gif");
INSERT INTO bar_list VALUES("670","Совет да любовь","29","100","/style/bar/670.gif");
INSERT INTO bar_list VALUES("671","Совет да любовь","29","100","/style/bar/671.gif");
INSERT INTO bar_list VALUES("672","Привет","44","100","/style/bar/672.gif");
INSERT INTO bar_list VALUES("673","Привет","44","100","/style/bar/673.png");
INSERT INTO bar_list VALUES("674","Привет","44","100","/style/bar/674.gif");
INSERT INTO bar_list VALUES("675","Привет","44","100","/style/bar/675.gif");
INSERT INTO bar_list VALUES("676","Привет","44","100","/style/bar/676.gif");
INSERT INTO bar_list VALUES("677","Привет","44","100","/style/bar/677.gif");
INSERT INTO bar_list VALUES("678","Привет","44","100","/style/bar/678.gif");
INSERT INTO bar_list VALUES("679","Привет","44","100","/style/bar/679.gif");
INSERT INTO bar_list VALUES("680","Привет","44","100","/style/bar/680.gif");
INSERT INTO bar_list VALUES("681","Привет","44","100","/style/bar/681.gif");
INSERT INTO bar_list VALUES("682","Привет","44","100","/style/bar/682.gif");



DROP TABLE IF EXISTS `bar_podcat`;

CREATE TABLE `bar_podcat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `category` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=49 DEFAULT CHARSET=utf8;

INSERT INTO bar_podcat VALUES("1","Водка","2");
INSERT INTO bar_podcat VALUES("2","Виски","2");
INSERT INTO bar_podcat VALUES("3","Коньяк","2");
INSERT INTO bar_podcat VALUES("4","Сок","2");
INSERT INTO bar_podcat VALUES("5","Чай и  кофе","2");
INSERT INTO bar_podcat VALUES("9","Пиво","2");
INSERT INTO bar_podcat VALUES("7","Шампанское","2");
INSERT INTO bar_podcat VALUES("8","Бреннди ","2");
INSERT INTO bar_podcat VALUES("10","Вино","2");
INSERT INTO bar_podcat VALUES("11","Десерты","3");
INSERT INTO bar_podcat VALUES("12","Коктейли","2");
INSERT INTO bar_podcat VALUES("13","Закуска","6");
INSERT INTO bar_podcat VALUES("14","Мороженое ","3");
INSERT INTO bar_podcat VALUES("15","Для парней","5");
INSERT INTO bar_podcat VALUES("16","Блины ","6");
INSERT INTO bar_podcat VALUES("17","Горячее блюдо","6");
INSERT INTO bar_podcat VALUES("18","Фрукты","7");
INSERT INTO bar_podcat VALUES("19","Для девушек","5");
INSERT INTO bar_podcat VALUES("20","Поцелуй","4");
INSERT INTO bar_podcat VALUES("21","Пожелания","8");
INSERT INTO bar_podcat VALUES("22","Крепкие","9");
INSERT INTO bar_podcat VALUES("23","Яд","9");
INSERT INTO bar_podcat VALUES("24","Молочные и вода ","9");
INSERT INTO bar_podcat VALUES("25","Медпункт","10");
INSERT INTO bar_podcat VALUES("26","Разное","9");
INSERT INTO bar_podcat VALUES("27","Днюха ","11");
INSERT INTO bar_podcat VALUES("28","Нг","12");
INSERT INTO bar_podcat VALUES("29","Свадьба","13");
INSERT INTO bar_podcat VALUES("31","Позитив","14");
INSERT INTO bar_podcat VALUES("32","Для тебя","15");
INSERT INTO bar_podcat VALUES("33","Для любимой","15");
INSERT INTO bar_podcat VALUES("34","Для любимого","15");
INSERT INTO bar_podcat VALUES("39","Атакуем форум","16");
INSERT INTO bar_podcat VALUES("38","Куда спрятал наливай(прик)","16");
INSERT INTO bar_podcat VALUES("40","Доброе утро для любимых","17");
INSERT INTO bar_podcat VALUES("41","Доброе утро людишки ","17");
INSERT INTO bar_podcat VALUES("42","Приятных снов","18");
INSERT INTO bar_podcat VALUES("43","Приколы ","14");
INSERT INTO bar_podcat VALUES("44","Привет ","20");
INSERT INTO bar_podcat VALUES("45","Добро пожаловать ","21");
INSERT INTO bar_podcat VALUES("46","Тортики","3");
INSERT INTO bar_podcat VALUES("47","Все для вам милые дамы ","22");
INSERT INTO bar_podcat VALUES("48","Совет да любовь","13");



DROP TABLE IF EXISTS `battleship`;

CREATE TABLE `battleship` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) DEFAULT '0',
  `enemyId` int(11) DEFAULT '0',
  `coins` int(11) DEFAULT '0',
  `betId` varchar(128) DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `userShips` text,
  `enemyShips` text,
  `userStroke` text,
  `enemyStroke` text,
  `strokeId` int(11) NOT NULL DEFAULT '0',
  `winId` int(11) NOT NULL DEFAULT '0',
  `close` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `battleship_welcome`;

CREATE TABLE `battleship_welcome` (
  `userId` int(11) DEFAULT '0',
  `users` text,
  `time` int(11) DEFAULT '0',
  `coins` int(11) NOT NULL DEFAULT '0',
  `betId` varchar(128) DEFAULT NULL,
  UNIQUE KEY `userId` (`userId`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `best_admin`;

CREATE TABLE `best_admin` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `money` int(11) NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `best_anketa`;

CREATE TABLE `best_anketa` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_days` int(11) NOT NULL,
  `sex` enum('0','1') NOT NULL DEFAULT '0',
  `suspend_best` enum('0','1') NOT NULL DEFAULT '0',
  `notification_time_ocenka` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`,`time_days`),
  KEY `sex` (`sex`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `bestpodarki_give`;

CREATE TABLE `bestpodarki_give` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_give` int(11) NOT NULL,
  `id_p` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `url` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `bestpodarki_list`;

CREATE TABLE `bestpodarki_list` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `prise` int(11) NOT NULL,
  `url` varchar(150) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=359 DEFAULT CHARSET=cp1251;

INSERT INTO bestpodarki_list VALUES("158","100000","1471802329");
INSERT INTO bestpodarki_list VALUES("159","100000","1471802354");
INSERT INTO bestpodarki_list VALUES("160","100000","1471802381");
INSERT INTO bestpodarki_list VALUES("161","100000","1471802400");
INSERT INTO bestpodarki_list VALUES("162","100000","1471802422");
INSERT INTO bestpodarki_list VALUES("163","100000","1471802438");
INSERT INTO bestpodarki_list VALUES("164","100000","1471802453");
INSERT INTO bestpodarki_list VALUES("165","100000","1471802481");
INSERT INTO bestpodarki_list VALUES("166","100000","1471802498");
INSERT INTO bestpodarki_list VALUES("167","100000","1471802516");
INSERT INTO bestpodarki_list VALUES("168","100000","1471802532");
INSERT INTO bestpodarki_list VALUES("169","100000","1471802547");
INSERT INTO bestpodarki_list VALUES("170","100000","1471802569");
INSERT INTO bestpodarki_list VALUES("171","100000","1471802593");
INSERT INTO bestpodarki_list VALUES("172","100000","1471802623");
INSERT INTO bestpodarki_list VALUES("173","100000","1471802639");
INSERT INTO bestpodarki_list VALUES("174","100000","1471802658");
INSERT INTO bestpodarki_list VALUES("175","100000","1471802672");
INSERT INTO bestpodarki_list VALUES("176","100000","1471802695");
INSERT INTO bestpodarki_list VALUES("177","100000","1471802714");
INSERT INTO bestpodarki_list VALUES("178","100000","1471802727");
INSERT INTO bestpodarki_list VALUES("179","100000","1471802745");
INSERT INTO bestpodarki_list VALUES("180","100000","1471802759");
INSERT INTO bestpodarki_list VALUES("181","100000","1471802776");
INSERT INTO bestpodarki_list VALUES("182","100000","1471802791");
INSERT INTO bestpodarki_list VALUES("183","100000","1471802805");
INSERT INTO bestpodarki_list VALUES("184","100000","1471802818");
INSERT INTO bestpodarki_list VALUES("185","100000","1471802833");
INSERT INTO bestpodarki_list VALUES("186","100000","1471802849");
INSERT INTO bestpodarki_list VALUES("187","100000","1471802866");
INSERT INTO bestpodarki_list VALUES("188","100000","1471802884");
INSERT INTO bestpodarki_list VALUES("189","100000","1471802899");
INSERT INTO bestpodarki_list VALUES("190","100000","1471802917");
INSERT INTO bestpodarki_list VALUES("191","100000","1471802939");
INSERT INTO bestpodarki_list VALUES("192","100000","1471802962");
INSERT INTO bestpodarki_list VALUES("193","100000","1471802978");
INSERT INTO bestpodarki_list VALUES("194","100000","1471802993");
INSERT INTO bestpodarki_list VALUES("195","100000","1471803011");
INSERT INTO bestpodarki_list VALUES("196","100000","1471803030");
INSERT INTO bestpodarki_list VALUES("197","100000","1471803046");
INSERT INTO bestpodarki_list VALUES("198","100000","1471803064");
INSERT INTO bestpodarki_list VALUES("199","100000","1471803079");
INSERT INTO bestpodarki_list VALUES("200","100000","1471803097");
INSERT INTO bestpodarki_list VALUES("201","100000","1471803114");
INSERT INTO bestpodarki_list VALUES("202","100000","1471803132");
INSERT INTO bestpodarki_list VALUES("203","100000","1471803151");
INSERT INTO bestpodarki_list VALUES("204","100000","1471803174");
INSERT INTO bestpodarki_list VALUES("205","100000","1471803194");
INSERT INTO bestpodarki_list VALUES("206","100000","1471803214");
INSERT INTO bestpodarki_list VALUES("207","100000","1471803251");
INSERT INTO bestpodarki_list VALUES("208","100000","1471803276");
INSERT INTO bestpodarki_list VALUES("209","100000","1471803294");
INSERT INTO bestpodarki_list VALUES("210","100000","1471803331");
INSERT INTO bestpodarki_list VALUES("211","100000","1471803347");
INSERT INTO bestpodarki_list VALUES("212","100000","1471803371");
INSERT INTO bestpodarki_list VALUES("213","100000","1471803677");
INSERT INTO bestpodarki_list VALUES("214","100000","1471803702");
INSERT INTO bestpodarki_list VALUES("215","100000","1471803719");
INSERT INTO bestpodarki_list VALUES("216","100000","1471803734");
INSERT INTO bestpodarki_list VALUES("217","100000","1471803747");
INSERT INTO bestpodarki_list VALUES("218","100000","1471803767");
INSERT INTO bestpodarki_list VALUES("219","100000","1471803783");
INSERT INTO bestpodarki_list VALUES("220","100000","1471803800");
INSERT INTO bestpodarki_list VALUES("221","100000","1471803817");
INSERT INTO bestpodarki_list VALUES("222","100000","1471803836");
INSERT INTO bestpodarki_list VALUES("223","100000","1471803857");
INSERT INTO bestpodarki_list VALUES("224","100000","1471803880");
INSERT INTO bestpodarki_list VALUES("225","100000","1471803895");
INSERT INTO bestpodarki_list VALUES("226","100000","1471803908");
INSERT INTO bestpodarki_list VALUES("227","100000","1471803923");
INSERT INTO bestpodarki_list VALUES("228","100000","1471803939");
INSERT INTO bestpodarki_list VALUES("229","100000","1471803954");
INSERT INTO bestpodarki_list VALUES("230","100000","1471803971");
INSERT INTO bestpodarki_list VALUES("231","100000","1471803991");
INSERT INTO bestpodarki_list VALUES("232","100000","1471804008");
INSERT INTO bestpodarki_list VALUES("233","100000","1471804022");
INSERT INTO bestpodarki_list VALUES("234","100000","1471804040");
INSERT INTO bestpodarki_list VALUES("235","100000","1471804054");
INSERT INTO bestpodarki_list VALUES("236","100000","1471804066");
INSERT INTO bestpodarki_list VALUES("237","100000","1471804079");
INSERT INTO bestpodarki_list VALUES("238","100000","1471804116");
INSERT INTO bestpodarki_list VALUES("239","100000","1471804131");
INSERT INTO bestpodarki_list VALUES("240","100000","1471804146");
INSERT INTO bestpodarki_list VALUES("241","100000","1471804160");
INSERT INTO bestpodarki_list VALUES("242","100000","1471804189");
INSERT INTO bestpodarki_list VALUES("243","100000","1471804207");
INSERT INTO bestpodarki_list VALUES("244","100000","1471804222");
INSERT INTO bestpodarki_list VALUES("245","100000","1471804239");
INSERT INTO bestpodarki_list VALUES("246","100000","1471804260");
INSERT INTO bestpodarki_list VALUES("247","100000","1471804304");
INSERT INTO bestpodarki_list VALUES("250","100000","1471804366");
INSERT INTO bestpodarki_list VALUES("249","100000","1471804324");
INSERT INTO bestpodarki_list VALUES("251","100000","1471804381");
INSERT INTO bestpodarki_list VALUES("252","100000","1471804394");
INSERT INTO bestpodarki_list VALUES("253","100000","1471804405");
INSERT INTO bestpodarki_list VALUES("255","100000","1471804446");
INSERT INTO bestpodarki_list VALUES("256","100000","1471804462");
INSERT INTO bestpodarki_list VALUES("257","100000","1471804482");
INSERT INTO bestpodarki_list VALUES("258","100000","1471804497");
INSERT INTO bestpodarki_list VALUES("259","100000","1471804514");
INSERT INTO bestpodarki_list VALUES("260","100000","1471804526");
INSERT INTO bestpodarki_list VALUES("261","100000","1471804538");
INSERT INTO bestpodarki_list VALUES("262","100000","1471804552");
INSERT INTO bestpodarki_list VALUES("263","100000","1471804566");
INSERT INTO bestpodarki_list VALUES("264","100000","1471804583");
INSERT INTO bestpodarki_list VALUES("265","100000","1471804599");
INSERT INTO bestpodarki_list VALUES("266","100000","1471804609");
INSERT INTO bestpodarki_list VALUES("268","100000","1471804629");
INSERT INTO bestpodarki_list VALUES("270","100000","1471804656");
INSERT INTO bestpodarki_list VALUES("272","100000","1471804680");
INSERT INTO bestpodarki_list VALUES("274","100000","1471805201");
INSERT INTO bestpodarki_list VALUES("276","100000","1471805270");
INSERT INTO bestpodarki_list VALUES("283","100000","1478834137");
INSERT INTO bestpodarki_list VALUES("285","100000","1478834167");
INSERT INTO bestpodarki_list VALUES("286","100000","1478834185");
INSERT INTO bestpodarki_list VALUES("287","100000","1478834202");
INSERT INTO bestpodarki_list VALUES("288","100000","1478834216");
INSERT INTO bestpodarki_list VALUES("289","100000","1478836661");
INSERT INTO bestpodarki_list VALUES("290","100000","1478836676");
INSERT INTO bestpodarki_list VALUES("291","100000","1478836690");
INSERT INTO bestpodarki_list VALUES("292","100000","1478836704");
INSERT INTO bestpodarki_list VALUES("293","100000","1478836718");
INSERT INTO bestpodarki_list VALUES("295","100000","1478836806");
INSERT INTO bestpodarki_list VALUES("297","100000","1478836825");
INSERT INTO bestpodarki_list VALUES("298","100000","1478836834");
INSERT INTO bestpodarki_list VALUES("299","100000","1478836842");
INSERT INTO bestpodarki_list VALUES("300","100000","1478836850");
INSERT INTO bestpodarki_list VALUES("301","100000","1478836858");
INSERT INTO bestpodarki_list VALUES("302","100000","1478837167");
INSERT INTO bestpodarki_list VALUES("303","100000","1478837187");
INSERT INTO bestpodarki_list VALUES("304","100000","1478837203");
INSERT INTO bestpodarki_list VALUES("305","100000","1478837874");
INSERT INTO bestpodarki_list VALUES("306","100000","1487480968");
INSERT INTO bestpodarki_list VALUES("307","100000","1487480978");
INSERT INTO bestpodarki_list VALUES("308","100000","1487480990");
INSERT INTO bestpodarki_list VALUES("309","100000","1487480999");
INSERT INTO bestpodarki_list VALUES("310","100000","1487481009");
INSERT INTO bestpodarki_list VALUES("311","100000","1489595742");
INSERT INTO bestpodarki_list VALUES("314","100000","1489822290");
INSERT INTO bestpodarki_list VALUES("315","100000","1489822299");
INSERT INTO bestpodarki_list VALUES("316","100000","1489822307");
INSERT INTO bestpodarki_list VALUES("317","100000","1489822316");
INSERT INTO bestpodarki_list VALUES("319","100000","1489822339");
INSERT INTO bestpodarki_list VALUES("320","100000","1489822348");
INSERT INTO bestpodarki_list VALUES("321","100000","1489822356");
INSERT INTO bestpodarki_list VALUES("322","100000","1489822365");
INSERT INTO bestpodarki_list VALUES("324","100000","1489822392");
INSERT INTO bestpodarki_list VALUES("325","100000","1489822400");
INSERT INTO bestpodarki_list VALUES("326","100000","1510921927");
INSERT INTO bestpodarki_list VALUES("327","100000","1510968728");
INSERT INTO bestpodarki_list VALUES("328","100000","1510968739");
INSERT INTO bestpodarki_list VALUES("329","100000","1510968751");
INSERT INTO bestpodarki_list VALUES("330","100000","1510968763");
INSERT INTO bestpodarki_list VALUES("331","100000","1510968779");
INSERT INTO bestpodarki_list VALUES("332","100000","1510968794");
INSERT INTO bestpodarki_list VALUES("333","100000","1510968807");
INSERT INTO bestpodarki_list VALUES("334","100000","1510968820");
INSERT INTO bestpodarki_list VALUES("335","100000","1510968845");
INSERT INTO bestpodarki_list VALUES("336","100000","1510968860");
INSERT INTO bestpodarki_list VALUES("337","100000","1510968909");
INSERT INTO bestpodarki_list VALUES("338","100000","1510968932");
INSERT INTO bestpodarki_list VALUES("339","100000","1510968951");
INSERT INTO bestpodarki_list VALUES("340","100000","1510968966");
INSERT INTO bestpodarki_list VALUES("341","100000","1510968981");
INSERT INTO bestpodarki_list VALUES("342","100000","1510968998");
INSERT INTO bestpodarki_list VALUES("343","100000","1510969016");
INSERT INTO bestpodarki_list VALUES("344","100000","1510969039");
INSERT INTO bestpodarki_list VALUES("345","100000","1510969058");
INSERT INTO bestpodarki_list VALUES("346","100000","1510969077");
INSERT INTO bestpodarki_list VALUES("347","100000","1510969119");
INSERT INTO bestpodarki_list VALUES("348","100000","1510969133");
INSERT INTO bestpodarki_list VALUES("349","100000","1510969154");
INSERT INTO bestpodarki_list VALUES("350","100000","1510969175");
INSERT INTO bestpodarki_list VALUES("351","100000","1510969197");
INSERT INTO bestpodarki_list VALUES("352","100000","1510969212");
INSERT INTO bestpodarki_list VALUES("353","100000","1510969234");
INSERT INTO bestpodarki_list VALUES("354","100000","1510969253");
INSERT INTO bestpodarki_list VALUES("355","100000","1510969270");
INSERT INTO bestpodarki_list VALUES("356","100000","1510969285");
INSERT INTO bestpodarki_list VALUES("357","100000","1510969299");
INSERT INTO bestpodarki_list VALUES("358","100000","1576634775");



DROP TABLE IF EXISTS `blacklist`;

CREATE TABLE `blacklist` (
  `user` int(11) NOT NULL DEFAULT '0',
  `lol` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `i` int(1) DEFAULT '0',
  PRIMARY KEY (`user`,`lol`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `bomj`;

CREATE TABLE `bomj` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) CHARACTER SET utf8 NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `brand`;

CREATE TABLE `brand` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` text,
  `brand1` text,
  `brand2` text,
  `date` int(30) NOT NULL,
  `time` int(30) NOT NULL,
  `coment` int(1) NOT NULL,
  `f_brand_1` text,
  `f_brand_2` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `brand_coment`;

CREATE TABLE `brand_coment` (
  `id` int(30) NOT NULL AUTO_INCREMENT,
  `user` int(30) NOT NULL,
  `brand` int(30) NOT NULL,
  `date` int(30) NOT NULL,
  `coment` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `brand_vote`;

CREATE TABLE `brand_vote` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `brand` text,
  `golos` text,
  `date` text,
  `user` int(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `breach`;

CREATE TABLE `breach` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text` text NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cat_smiles`;

CREATE TABLE `cat_smiles` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(20) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `center_vnim`;

CREATE TABLE `center_vnim` (
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_p` int(11) NOT NULL,
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_post`;

CREATE TABLE `chat_post` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `room` int(11) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) DEFAULT NULL,
  `vopros` int(11) DEFAULT NULL,
  `umnik_st` set('0','1','2','3','4') DEFAULT '0',
  `shutnik` set('0','1') NOT NULL DEFAULT '0',
  `privat` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `room` (`room`)
) ENGINE=MyISAM AUTO_INCREMENT=577 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chat_rooms`;

CREATE TABLE `chat_rooms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pos` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `umnik` set('0','1') DEFAULT '0',
  `shutnik` set('0','1') DEFAULT '0',
  `opis` varchar(256) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `pos` (`pos`,`umnik`,`shutnik`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO chat_rooms VALUES("1","0","Отгадываем","1","0","Отгадываем");
INSERT INTO chat_rooms VALUES("2","2","Смеемся и отгадываем","1","1","Смеемся и отгадываем");
INSERT INTO chat_rooms VALUES("3","3","Шутим","0","1","Шутим");
INSERT INTO chat_rooms VALUES("4","4","Беспредел","0","0","Ругайтесь, сколько влезет!!!\r\nВам простор для беспредела!!!");
INSERT INTO chat_rooms VALUES("5","1","Флудилка","0","0","");



DROP TABLE IF EXISTS `chat_shutnik`;

CREATE TABLE `chat_shutnik` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `anek` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=501 DEFAULT CHARSET=utf8;

INSERT INTO chat_shutnik VALUES("1","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("2","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("3","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на 25-ти долларовых машинах с расходом бензина 10 литров на 1000 километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("4","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("5","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("6","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("7","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("8","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("9","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("10","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("11","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("12","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("13","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("14","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("15","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("16","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("17","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("18","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("19","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("20","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("21","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("22","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("23","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("24","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("25","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("26","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("27","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("28","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("29","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("30","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("31","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("32","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время 12 часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("33","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("34","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("35","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("36","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("37","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("38","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("39","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("40","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("41","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("42","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло 2:2, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("43","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("44","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("45","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут 15, мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут 15, у дома крыша уже обваливается, мужик опять: - Hа меня 10 ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("46","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("47","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("48","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("49","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("50","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - 27, товарищ СталинЄ - А сколько погибло? - 26, товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("51","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("52","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("53","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("54","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("55","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("56","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("57","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("58","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("59","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("60","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("61","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("62","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("63","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("64","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью 91-го, мы стpеляли в вас осенью 93-го. Мы pазвалили вашy стpанy в 90-м, обокpали в 92-м, надyли с двyмя Волгами в 93-м, с помощью МММ-ов pаскpyтили на бабки в 94-м, посылали ваших детей на бойню в 95-м, неплохо \"повтоpничали\" в 96-м, и полностью огpабили в 98-м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("65","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("66","Недавно на ж/д переезде № 37 пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("67","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("68","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("69","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("70","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("71","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows 95, в. 3.0)");
INSERT INTO chat_shutnik VALUES("72","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("73","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже 5-й день пьем.");
INSERT INTO chat_shutnik VALUES("74","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("75","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("76","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("77","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("78","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("79","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("80","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("81","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("82","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("83","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("84","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("85","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("86","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("87","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("88","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("89","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("90","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("91","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("92","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("93","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите 100 метровкy?\" (HР): \"Минимyм за $800.\"");
INSERT INTO chat_shutnik VALUES("94","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("95","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("96","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("97","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("98","- Pядовой Петpов - выйти из cтpоя - 15 шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("99","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("100","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("101","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("102","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("103","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("104","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("105","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("106","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("107","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("108","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("109","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через 5 минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("110","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("111","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("112","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("113","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("114","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("115","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("116","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("117","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("118","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("119","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("120","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("121","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("122","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("123","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("124","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("125","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("126","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("127","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("128","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("129","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("130","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("131","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("132","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("133","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("134","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("135","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("136","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("137","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - 50 км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до 50 км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - 20 км\". Он и на этот pаз сбавляет скоpость до 20 км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость 10 км\". Пpоклиная все на свете, он замедляется до 10 км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("138","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("139","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("140","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить 10000 $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("141","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было 15-ти.");
INSERT INTO chat_shutnik VALUES("142","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("143","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("144","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("145","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("146","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("147","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("148","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("149","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("150","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");
INSERT INTO chat_shutnik VALUES("151","Разговор подруг: - Ты знаешь, что женщины совершают меньше аварий, чем мужчины? - Интересно? А почему? - Потому что женщины заботятся о машине, как о муже, а мужчины относятся к ней, как к собственной жене.");
INSERT INTO chat_shutnik VALUES("152","Врач, обследовав женщину, выходит в коридор и сообщает ее мужу: - У меня для вас две новости: хорошая и плохая.\n- Давайте сначала плохую.\n- Ваша жена больна сифилисом.\n- Какой ужас! А хорошая? - Она заразилась им не от вас.");
INSERT INTO chat_shutnik VALUES("153","В компьютер заложили множество всевозможных анекдотов, чтобы тот выдал средний. Результат начинался так: \"Лежат в постели три еврея: Чапаев, Чебурашка и Поручик Ржевский...\".");
INSERT INTO chat_shutnik VALUES("154","- Вася дома? - Нет, Васи больше нету... Он покинул наш мир - Он что, умер? :-( - Нет, к интернету подключился!");
INSERT INTO chat_shutnik VALUES("155","Пpиходит женщина к вpачy.\n- Доктоp, y меня такая маленькая гpyдь. Вы не посоветyете как ее yвеличить.\n- Пpотиpайте ее ежедневно тyалетной бyмагой.\n- И что, поможет ? :-O - Hy, глядя на Вашy задницy... должно помочь.");
INSERT INTO chat_shutnik VALUES("156","Суд осудил Вас на десять лет тюрьмы,- говорит судья обвиняемому.\n- Большое спасибо, не надеялся так долго прожить.");
INSERT INTO chat_shutnik VALUES("157","Объявление: \"Для переписки секретных документов срочно требуется машинистка, не умеющая читать\".");
INSERT INTO chat_shutnik VALUES("158","- Как живешь? - спрашивают Менделя.\n- Как пуговица.\n- Как это понять? - В петлю лезть охота.");
INSERT INTO chat_shutnik VALUES("159","На экзамене по праву: -Профессор, между прочим, шпаргалка является моей собственностью, а Вы её изъяли без соблюдения соответствующей прцессуально-правовой прцедуры! -Эх,молодой человек! Я же преподователь, а не милиционер. Не могу же я лупить вас по почкам перед тем, как забрать шпаргалку!");
INSERT INTO chat_shutnik VALUES("160","Кароче, Робинзон Крузо отсидел на своём острове уже 3 года. Всё у него было - и фрукты, и вода, и хлеб: не было только бабы. И вы сами понимаете, как он удовлетворял свои потребности. И вот однажды, только он хотел с собой поиграть - вдали показался корабль. Робинзон быстро забежал на утес и стал жечь костёр и палить из мушкета. И свершилось чудо - на корабле его заметили и поплыли в его сторону. Робинзон размечтался: - Наконец-то! Сначала я приму ванну и помоюсь с мылом. Потом я выпью фунфырик рома. Затем они дадут мне красивую бабу. Я начну с ней танцевать, потрогаю её за попу, поглажу по спине, потом прикоснусь к её грудям, потом брошу её на кровать и раздену. И у неё будет кружевное бельё, и розовые чулочки на подвязках....... Тут он заметил, что у него наступила жестокая эрекция. Он быстро засунул руку в штаны и сказал: - А насчет корабля я-то пошутил! Ха-Ха-Ха-Ха.....");
INSERT INTO chat_shutnik VALUES("161","- Запомни раз и навсегда! - говорит жена мужу.- Если ты будешь приставать к горничной, я с тобой разведусь! - Из-за такого пустяка? - Ты ее разбалуешь. Пойми, такого мужа, как ты, я всегда найду, а такую горничную - вряд ли!");
INSERT INTO chat_shutnik VALUES("162","Штирлиц пришел к выводу. Но Вывода не оказалось дома.");
INSERT INTO chat_shutnik VALUES("163","Hовый русский заваливается к директору одной фирмы на работу (все как полагается - сотовый телефон,малиновый пиджак, etc). Директора нет на месте. Секретарша предлагает: - Вы телефончик оставьте, он позвонит. HР: - Да ты че, дура, ошалела, труба тыщу баков стоит!");
INSERT INTO chat_shutnik VALUES("164","Приехала Зыкина на гастроли в Грузию. Ей бурно аплодируют после каждой песни. Кончила петь - ее вызывают на бис. Спела на бис - ей аплодируют еще сильнее. Выходит она, наконец, на сцену и говорит, что репертуар исчерпан, петь нечего.\n- Зачем петь? - кричат ей из зала.\n- Ты ходи: туда ходи, сюда ходи!");
INSERT INTO chat_shutnik VALUES("165","Граница на карте обозначена точка-тире, точка-тире, что символизирует пограничник-собака, пограничник-собака.");
INSERT INTO chat_shutnik VALUES("166","Когда Рустем вернулся из Японии, где был в командировке, знакомые поинтересовались, как он там объяснялся, не зная японского языка.\n- Надо сказать, трудности бывали, - признался Рустем.\n- Вот, например, когда я хотел купить плавки и жестами объяснил, что мне нужно, продавец принес нож для харакири.");
INSERT INTO chat_shutnik VALUES("167","Урологическая операционная. Лежит больной, подготовленный к операции. Молоденькая сестричка. Входит хирург, с вымытыми руками, в стерильных перчатках: - Сестра, поправьте член.\n- Хмм..., - поправляет.\n- А теперь больному!");
INSERT INTO chat_shutnik VALUES("168","- Винтовка для солдата - лучший друг, не правда ли? - Не знаю, господин генерал! Вчера, когда я ее чистил, она выстрелила мне в ногу!");
INSERT INTO chat_shutnik VALUES("169","В больнице идет обход. Подходят к первому больному. Доктор: Что у вас? Больной: Геморрой! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят ко второму. Д: Что у вас? Б: Грибок на ногах! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Подходят к третьему. Д: Что у вас? Б: Ангина! Д: Чем лечат? Б: Йодом мажут! Д: Продолжать! Б: Доктор, скажите сестре, чтобы мне первому мазали...");
INSERT INTO chat_shutnik VALUES("170","Жена сказала мужу: - Я очень не люблю твоих братьев. Как появятся у тебя деньги, они все тут как тут и вовсю пользуются твоей щедростью. А когда у тебя в кошельке пусто и ты сам бедствуешь, ни один из них на глаза не покажется. Муж ответил: - Они очень вежливые и не хотят доставлять мне лишних хлопот, когда нам нечем с ними поделиться.");
INSERT INTO chat_shutnik VALUES("171","- Ну что, помогла вам наша отрава избавиться от мышей? - О да, пан аптекарь! Мышам она так понравилась, что они растолстели и не смогли пролезть в нору. Наша кошка переловила их всех и съела!");
INSERT INTO chat_shutnik VALUES("172","Однажды в жаркий полдень молодой папаша вывез коляску с ребенком на улицу и стал с ней прогуливаться.\n- Послушай, Чарли! - послышалось из окна третьего этажа.\n- Оставь меня в покое, - огрызнулся муж, - у нас все в порядке. Через чес раздался тот же голос: - Чарли, Чарли... Ну, что ты хочешь? - стал ворчать муж.\n- Что там у тебя случилось? - Да нет, Чарли, ничего. Но ты вот уже больше часа катаешь в коляске куклу Ненси. Пожалуйста, погуляй немного и с ребенком...");
INSERT INTO chat_shutnik VALUES("173","Муж с женой собираются на свадьбу. Муж, понятное дело, быстренько собрался, а жена все крутится перед зеркалом, примеряет наряды. И то не так, и се не так...\n- Скорее собирайся, мы же опоздаем! Наконец вышли. Приходят к дому, где свадьбу играют, а там один пьянчужка спит под забором, а другой, еле держась на ногах, что-то лепечет. Увидев эту картину, муж сердито говорит жене: - Видишь, люди уже гуляют, а мы еще только идем!");
INSERT INTO chat_shutnik VALUES("174","Дирижер оркестра получает после концерта записку: \"Я не ябеда, но вон тот рыжий детина с усами бьет в барабан только тогда, когда вы на него смотрите!\"");
INSERT INTO chat_shutnik VALUES("175","Сказочка Жил-был мальчик. И подарил однажды этот мальчик девочке цветочек. На следующий день опять подарил, и дарил много-много дней подряд. И говорит однажды ему девочка: - Хватит херней страдать, пошли-ка лучше со мной спать! Мальчик заплакал и говорит: - Я не умею. И пошел прочь от девочки. Идет он, значит, по улице, и плачет. Тут навстречу ему - проститутка.\n- Почему ты плачешь, мальчик? - спрашивает она.\n- А мне девочка предложила с ней спать, а я не умею! - Ну ничего страшного, пошли со мной! И пошли они к проститутке домой, и научила она мальчика всем прелестям вагинального, орального и прочих видов секса. Обрадованный мальчик радостно выбежал на улицу и побежал к своей девочке. Прибегает, а девочка уже спит с другим мальчиком. Наш мальчик опять заплакал и пошел на почту.\n- Отправьте телеграмму.\n- сказал он тетеньке в окошке.\n- Какую? - спросила тетенька.\n- \"Мама, я больше не приду домой, я теперь буду жить своей особенной жизнью!\" - продиктовал мальчик.\n- А как тебя звать-то, мальчик? - спросила тетен");
INSERT INTO chat_shutnik VALUES("176","Интеллигентного вида мужчина садится в такси. Диалог с таксистом: - Вы не могли бы подбросить меня в аэропорт, только нужно на минуточку заскочить на базар? - Без базару! - Да? Ну тогда сразу в аэропорт...");
INSERT INTO chat_shutnik VALUES("177","- Куда девать пенсионеров? - поступают в центр вопросы с мест. Из центра шлют циркуляры: \"У кого трясутся руки из стороны в сторону посылать на мельницу сеять муку. У кого вертится голова направлять в торговлю. У кого трясется голова того сажать в президиум. Ожил Ленин и попросил подшивку газеты \"Правда\" за последние 70 лет. Читает: ЄПрием в Кремле Є3автрак в Кремле ЄОбед в КремлеЄ - Что же вы мне дали? - возмущается Ленин, Это же меню!");
INSERT INTO chat_shutnik VALUES("178","Служанка: - Извините, пожалуйста, но миссис Браун велела сказать, что ее нет дома. Гостья: - Ничего, ничего, голубушка. В таком случае передайте ей, что я очень рада, что не приходила.");
INSERT INTO chat_shutnik VALUES("179","Гpабитель на улице обpащается к хоpошо одетой женщине: - Деньги, мадам! Да поживее! Подумайте, что будет, если стpуя из этого водяного пистолета pазмоет косметику на вашем лице.");
INSERT INTO chat_shutnik VALUES("180","Шотландец и его сын в традиционных юбках идут по Эдинбургу. Навстречу - девушка в брюках. Отец - сыну: - Сколько тебе повторять - не оглядывайся на каждые брюки!");
INSERT INTO chat_shutnik VALUES("181","- Какой смысл вкладывается в выражение \"не тяни кота за хвост\"? - Сколько кота не тренируй, он ящерицей не станет!");
INSERT INTO chat_shutnik VALUES("182","- Доктор, - говорит ассистент, - пациент из второй палаты Иванов скверно себя чувствует.\n- Надо говорить: пациент Иванов думает, что он скверно себя чувствует. Это новейший взгляд на сущность болезней. На следующий день ассистент говорит врачу: - Доктор, больной Иванов думает, что он умер.");
INSERT INTO chat_shutnik VALUES("183","Шла мышка по темному лесу. И чтоб ей не было так страшно она пела песенку: - \"ЛА-ЛА-ЛА-ЛА\" (исполнять громко и страшно).");
INSERT INTO chat_shutnik VALUES("184","Утром...\n- Я жених... я женихххх... я же ниххххрена не помню...");
INSERT INTO chat_shutnik VALUES("185","Деревенский мальчик кричит: - Мама, там молочник пришел. Ты ему деньги отдашь или мне пойти погулять?");
INSERT INTO chat_shutnik VALUES("186","Встречаются два друга.\n- Как твои дела? - Да вот подозреваю, что моя жена мне изменяет с пекарем. Каждый раз раскрывая постель, обнаруживаю в ней хлебные крошки.\n- А..а..а. Теперь и я начинаю подозревать, что моя жена мне изменяет со слесарем из нашего ЖЭКа.\n- Ты что, инструменты в постели находишь? - Да нет. Понимаешь, как ни приду домой, так слесарь лежит в нашей постели.");
INSERT INTO chat_shutnik VALUES("187","Новая Шаума сделала мои волосы такими объемными, что даже ширинка не застегивается!!!");
INSERT INTO chat_shutnik VALUES("188","- Какие герои вышли из книги в реальную жизнь? - Гайдар и его команда!");
INSERT INTO chat_shutnik VALUES("189","Парень повредил палец на руке и пришел к врачу. Врачиха говорит: - Раздевайтесь. Парень: - Зачем? Я ведь всего лишь повредил палец. Мужской голос из-за ширмы: - Это что! Я вообще пришел телефон починить!");
INSERT INTO chat_shutnik VALUES("190","Идут два программера, мими них проходит обалденно красивая девушка. Оба провожают ее взглядом. Идут дальше... Первый: - Да... Плохо, что у девушек нету стандартного интерфейса. Второй: - Ошибаешься! Стандартный интерфейс у них как раз-то есть! Первый: - Действительно. И все же жаль, что не существует стандартного способа этот интерфейс получить.");
INSERT INTO chat_shutnik VALUES("191","20-летняя бабёнка вышла замуж за 90 летнего дедка. После первой брачной ночи она вышла из спальни еле передвигая ноги, вся разбитая и усталая.\n- Господи, что он с тобой сделал?! - спрашивает мать.\n- Он говорил мне, что копил 75 лет... Но я думала, что он имел ввиду деньги.");
INSERT INTO chat_shutnik VALUES("192","Два грузина смотрят фильм: Альпинист лезет на гору из последних сил, лезет, останавливается, опять лезет.\n- Слушай, Гоги, давай поспорим на 1000 баксов, что он не залезет? - Да ты что? Я знаю, он залезет! Поспорили. Альпинист все-таки взобрался. Первый: - Ну, Гоги, ты выиграл, забирай деньги, я проиграл, ты был прав.\n- Слушай, Вано, ну как так можно, ты же мой друг, я не могу взять деньги у друга... К тому же я уже смотрел этот фильм раньше.\n- Ну и что, я тоже смотрел этот фильм раньше, но был уверен, что второй раз точно не залезет!");
INSERT INTO chat_shutnik VALUES("193","- Э, слущай, я себе \"СУПЕРМАЗ\" купил! - А зачэм тэбэ \"СУПЕРМАЗ\"? - Ну как!? Памазал - все праходыт!");
INSERT INTO chat_shutnik VALUES("194","Чувство вины мучило доктора Х. весь день. Как ни пытался он забыть об этом, ничего не получалось. Нервы напряглись до предела. Но время от времени звучал этот подбадривающий внутренний голос: Да не переживай ты так. Ты не первый и не последний врач, который сношается с пациентами. Но тут же неизменно второй, подленький такой голос возвращал его в реальность: Но ты же все-таки ветеринар...");
INSERT INTO chat_shutnik VALUES("195","Возле стройки тормозит \"Мерседес\", из окошка высовывается новый русский и предлагает рабочим: - Мужики, нужен рубероид, даю сотню баксов! Что еще можете толкнуть? Те ошалели от неожиданности: - Все! Кирпич, цемент, стекло, прораба.");
INSERT INTO chat_shutnik VALUES("196","Чебурашка прибегает к крокодилу Гене: - Шапокляк родила! Беги к ней скорее - я своих утопил, а твои плавают!");
INSERT INTO chat_shutnik VALUES("197","На радио Эхо Москвы: - Сегодня, 22 апреля, солнце взошло в 6 утра, погода +12 градусов. Теперь кто из знаменитостей родился в этот день... Хм..., так, ну кто родился, все и так знают, а кто не знает, тем лучше и не надо...");
INSERT INTO chat_shutnik VALUES("198","Диктатору на заметку: если Вы хотите, чтобы все люди жили в одном большом концлагере, уделите должное внимание защите государственной границы.");
INSERT INTO chat_shutnik VALUES("199","Состоялась защита кандидатской диссертации на тему: \"Введение спиртного через задний проход\". Диссертант научно доказал, что этот способ имеет преимущества перед обычным: мало нужно, чтобы опьянеть;можно без закуски;изо рта не пахнет. Оппонент задал вопрос, как при этом способе выпивать на брудершафт.\n- Это тема моей докторской, - ответил диссертант.");
INSERT INTO chat_shutnik VALUES("200","- Смотри, какие тени длинные, и облака тяжелые...\n- Длинные, потому что уже поздно, а тяжелые, потому что мы уже пятый день пьем...");
INSERT INTO chat_shutnik VALUES("201","Знаменитая киноактриса: - А теперь хватит говорить обо мне. Поговорим о вас. Расскажите мне, как я понравилась вам в моем последнем фильме.");
INSERT INTO chat_shutnik VALUES("202","Продам китайский гарнитур из одиннадцати предметов - две циновки и девять портретов Мао Цзедуна.");
INSERT INTO chat_shutnik VALUES("203","Таможенник на границе входит в купе: - Коньяк? Табак? Наркотоки? - Чашечку кофе, пожалуйста.");
INSERT INTO chat_shutnik VALUES("204","Всем известна история о русском мастере Левше, подковавшем аглицкую блоху. Но почему-то история умалчивает о другом мастере Мойше, сделавшем той самой блохе обрезание.");
INSERT INTO chat_shutnik VALUES("205","- Вы помните Нухима Спивака? Когда 20 лет назад он приехал в Америку, у него была только пара рваных штанов. Сейчас он имеет миллион! - Господи! Что будет делать этот ненормальный в Америке с миллионом рваных штанов!?!");
INSERT INTO chat_shutnik VALUES("206","Лежат парень с девушкой в постели. Она(томно): - Трахни меня! Он(напряженно): - Уже трахаю! -=Nail=-");
INSERT INTO chat_shutnik VALUES("207","Школьница спрашивает у матери: - Мама, скажи мне, что такое пятилетка? - Пятилетка, дочка, это трудовой порыв. Через пять лет в стране всего станет в пять раз больше! - Всего-всего? - Да, дочка, и мы в пять раз будем жить лучше! В школе учительница задает вопрос: - Дети, скажите, что такое пятилетка? Желая блеснуть знаниями, ученица подняла руку.\n- Пятилетка - это трудовой порыв, когда всего становится в пять раз больше - и хлеба, и масла, и людейЄ Увидела в окно - покойника везут.\n- ЄИ покойников, и воров, и нищих, и двоечников.");
INSERT INTO chat_shutnik VALUES("208","Хоpонят авторитета. К гpобу очеpедь попpощаться. Один мужик подходит, пpипадает и долго-долго не может отоpваться от усопшего. Его подталкивют, мол, пpоходи, видишь, сколько наpоду еще. А мужик: - Погодите вы, я с бодуна, а он такой холодненький...");
INSERT INTO chat_shutnik VALUES("209","- Почему твой муж часто уходит по вечерам из дому? - спрашивает подруга.\n- Бедняжка, он не любит сидеть дома один.");
INSERT INTO chat_shutnik VALUES("210","Мужчина стоит на набережной и бросает монеты в воду.\n- Что случилось? - удивленно спрашивает прохожий.\n- У меня упала в канал монета.\n- Но для чего вы бросаете туда другие монеты? - Чтобы не лезть в воду ради одной.");
INSERT INTO chat_shutnik VALUES("211","Шел мимо крутой усадьбы бродяга, и потянуло его на халяву.\n- А я так просто не подаю, мужик! - заявил хозяин, лениво развалившись в шезлонге с журналом.\n- Хочешь деньжат - заработай! Вон, пойди на задний двор, там найдёшь краску и покрасишь мне забор... Бомж поплёлся за особняк. А хозяин продолжил листать «Плейбой», да так увлекся, что совсем забыл о «маляре». Опомнился он только тогда, когда тот постучал его по плечу.\n- Закончил я! - бодренько сообщил бродяга, потирая руки.\n- Только вы мне неправильно сказали: у вас там не «Запор», а BMW.");
INSERT INTO chat_shutnik VALUES("212","- Что за кривоногая девчонка была с тобой сегодня утром? - спросил один студент другого.\n- Это та со стройными ножками, с которой ты познакомил меня вчера вечером.");
INSERT INTO chat_shutnik VALUES("213","На вокзале в Риме провинциального вида старушка подходит к окошку кассы и спрашивает, сколько стоит билет на Палермо.\n- Десять тысяч лир, синьора. Старушка оборачивается к своей спутнице и говорит: - Придется, видимо, купить. Я уже спрашивала во всех кассах, и всюду цена у них одинаковая. Не иначе, как договорились...");
INSERT INTO chat_shutnik VALUES("214","- Пани Ковальская, очень прискорбно, но мы вынуждены сообщить, что ваш муж скончался прямо на работе. Пани Ковальская продолжает спокойно обедать.\n- Разве вы не слышите - ваш муж умер! - Слышу, слышу! Подождите, вот я сейчас закончу, тогда вы увидите, какая со мной будет истерика!");
INSERT INTO chat_shutnik VALUES("215","Российскими ученными было доказано, что смешивание водки с молоком приводит к раздражению желудочно-кишечного тракта вследствие недостаточно изученных свойств молока.");
INSERT INTO chat_shutnik VALUES("216","У генерала родился внук. Чтобы узнать, на кого он похож, генерал посылает в роддом адъютанта.\n- На вас! - радостно сообщает вернувшийся адъютант.\n- Вот это да! Докладывай детали! - Внучок ваш лысый, пузатый, ничего не соображает и все время орет.");
INSERT INTO chat_shutnik VALUES("217","В метро едут два парня, а напротив - две девушки. Один парень говорит другому: - Ну что, познакомимся с подругами? - Почему нет? - Ну и отлично. Твоя, правда, страшноватенькая...");
INSERT INTO chat_shutnik VALUES("218","Однажды в Сенате Разумовский отказался подписать решение, которое считал несправедливым.\n- Государыня желает, чтоб дело решено было таким образом,- объявили ему сенаторы.\n- Если так - не смею ослушаться,- сказал Разумовский и подписал свою фамилию \"вверх ногами\". Этот поступок сразу же стал известен императрице, та потребовала объяснений.\n- Я исполнил вашу волю, но так как покривил совестью, то и подпись моя кривая.");
INSERT INTO chat_shutnik VALUES("219","Выходит пеpвый мощный MEN - ТААКОЙ КРУТООЙ ! Снимает доpогенный плащ, достает pоскошный лук и БАЦ !!! Попал в самую точку, не задев добpовольца! Все:\"ООООО\". Мужик:\"I`m ROBIN GOOD\" и удаляется.");
INSERT INTO chat_shutnik VALUES("220","Альпинист покорил вершину. В восторге он стоит наверху и кричит: - Ура, я первый! Эхо доносит: \"Не первый! Не первый!\" Он снова кричит... А эхо снова: \"Не первый! Не первый!\" Альпинист: - Кто это со мной разговаривает? Из-за гребня к нему подходит седенький старичок.\n- Сынок! Это я с тобой разговариваю! - Дедушка, а ты кто? - Я? Волшебник! - И ты можешь выполнить три моих желания? - Конечно! Загадывай! - Во-первых, хочу чтобы у меня был миллион рублей денег! Во-вторых, чтобы моей женой стала \"мисс СССР\"! В третьих, хочу быть не здесь, а дома, в своей квартире! - Хорошо, сынок! Я исполню все три твои желания, если ты исполнишь одно мое? - Какое, дедушка? - Отсоси у меня! - А если я не захочу? - Тогда и твои желания не исполнятся! Альпинист подумал: \"Так уж быть! Ради своих желаний можно и пойти на уступки, тем более, что нас никто не видит... \" - Ладно, дедушка, давай! Взял в рот, сосет. Старичок нежно гладит его по голове: - Такой большой, а в сказки веришь!");
INSERT INTO chat_shutnik VALUES("221","Долго думали в армии, куда чукчу пристроить, и определили в пожарники. Через неделю начальник расчета приходит к начальнику пожарной части: - Опять у нас с чукчей ЧП.\n- Мать вашу етить! сколько раз уже говорил вам, чтоб технику безопасности соблюдали! - Так мы соблюдаем. Вон, ему на верхушке лестницы прибили плакат - СТОП! - Ну и чего ж? - Так он, оказывается, читает медленно.");
INSERT INTO chat_shutnik VALUES("222","Учительница спрашивает: - Петенька, кем ты хочешь стать, когда вырастешь? - Врачом.\n- Молодец. А ты, Ванечка? - Юристом.\n- Умница. А ты, Вовочка? - А я хочу стать придурком.\n- Почему придурком?! - Потому что когда мы с папой выходим из дома, он все время говорит: \"Роскошный дом у этого придурка!\" Или: \"Клевая тачка у этого придурка!\"");
INSERT INTO chat_shutnik VALUES("223","Двое кавказцев играют в шахматы. Один ставит ферзя на центр поля: - Мат! Другой ставит своего рядом: - Отэц!");
INSERT INTO chat_shutnik VALUES("224","- Я слышал, Пол Маккартни к нам приезжает. Будет выступать на Красной площади.\n- А ну его, не пойду.\n- Почему? - Пол без Джона - деньги на ветер.");
INSERT INTO chat_shutnik VALUES("225","Сидят две вороны на дереве.\n- Какие все-таки люди неблагодар-р-рные! - Мы их о дожде пр-редупреждали - предупреждали, а они говорят, что мы его накар-р-ркали!");
INSERT INTO chat_shutnik VALUES("226","Слуга обращается к лорду: - Сэр, осмелюсь доложить, что на кухне некоторым образом возник пожар. Хозяин дома медленно отложил \"Таймс\" и сказал: - Сообщите это леди. Вы же знаете, Робинс, что я не занимаюсь домашним хозяйством.");
INSERT INTO chat_shutnik VALUES("227","Сенбернары - это такие собаки, которые живут в Альпах, они зимой ищут потерявшихся лыжников... тем и живут.");
INSERT INTO chat_shutnik VALUES("228","Штирлиц заходит в кабинет Мюллера, смотрит, Мюллер сидит в фуфайке и играет на балалайке.\n- Группенфюрер, что с вами? - удивился Штирлиц.\n- Полноте вам, Штирлиц, не вы один по Родине скучаете.");
INSERT INTO chat_shutnik VALUES("229","Мужик приходит в кабак.\n- Я здесь вчера сидел.\n- Да.\n- Я всю зарплату пропил? - Да.\n- Фу ты (облегченно вздыхая) Думал потерял.");
INSERT INTO chat_shutnik VALUES("230","Встретились как-то три бывшие шлюхи-пенсионерки: Первая шлюха: - Когда я занималась проституцией, я получала всего лишь 20 баков за минет. Вторая шлюха: - Ну это не так уж плохо, мне в свое время платили за это только 10 баков. Третья шлюха слушала, слушала и тоже решила высказаться: - Я занималась проституцией во время Великой Депресии и делала минет за так - лишь бы набить живот чем-нибудь теплым.");
INSERT INTO chat_shutnik VALUES("231","- Потерпевший, вы напились до такой степени, что упали в оркестровую яму.\n- Гражданин следователь, каюсь - я попал в нехорошую компанию. На троих была одна бутылка водки, и никто, кроме меня, не пил.");
INSERT INTO chat_shutnik VALUES("232","Hа пеpвую годовщину Чеpнобыля все киевские евpеи получили по 2 юбилейных медали: (1-я) За освобождение Киева (2-я) За взятие Одессы.");
INSERT INTO chat_shutnik VALUES("233","Мужской возраст: 1. Взялся за грудь и... поел 2. Взялся за грудь и... кончил 3. Взялся за грудь и... возбудился 4. Взялся за грудь и... уснул");
INSERT INTO chat_shutnik VALUES("234","Сидят два мужика и ловят рыбу. А один грустный такой. Друг его спрашивает: - Что случилось? - Да у жены день рождения был, а я забыл поздравить. Посидели, помолчали. Тут друг успокаивать начал: - Знаешь, я тебе сейчас всё объясню. Ты вот, например, помнишь день, когда ты поймал самую большую рыбу? - Конечно, помню! - Так вот, а рыба - не помнит!");
INSERT INTO chat_shutnik VALUES("235","Мужик в подавленном состоянии приходит к психиатру и жалуется: - Доктор, помогите, я никогда не пользовался успехом у женщин, они от меня разбегаются, а ведь мне уже 35 лет, я больше не могу так жить! - Успокойтесь, эта проблема на самом деле легко решается, просто вам необходимо вырабатывать уверенность в себе. Каждое утро вставайте перед зеркалом, оглядывайте себя с ног до головы и повторяйте: я уважаемый человек, люди мною восхищаются и завидуют мне, я сильный и чертовски привлекательный. Поверьте мне, как только у вас появится уверенность в себе, женщины так и будут липнуть к вам. У пациента заметно улучшается настроение, и он уходит. Но через неделю он снова приходит подавленным. Психиатр спрашивает: - Вы не последовали моему совету? - Последовал, и все получилось именно так как вы сказали.\n- Так в чем же тогда у вас проблема? - Да это не у меня, это у жены проблема.");
INSERT INTO chat_shutnik VALUES("236","Встретились как-то грузин и американец. Спорят, кто лучше живет.\n- У нас каждый американец имеет квартиру отдельную - У нас кажадый грузин имеет большой коттедж.\n- У нас каждый американец имеет машину.\n- А у нас каждый грузин имеет самолет.\n- Слушай, а что ты все про грузин да про грузин? А русские-то у вас как живут? - Я же у тебя про негров не спрашиваю...");
INSERT INTO chat_shutnik VALUES("237","- Слышал, говорят, что на рынке уже можно купить говядину по рублю за килограмм.\n- Ну, это вранье! - Пускай, лишь бы дешево!");
INSERT INTO chat_shutnik VALUES("238","Сидят чукчи у моря.\n- Смотри, самолет полетел! - Да-а-а! Наверное правительственный.\n- Нет.\n- Почему? - Мотоцикла впереди нету!");
INSERT INTO chat_shutnik VALUES("239","Заходит в купе парень без уха и смеется! Его спрашивают: - Ты что? Ухо потерял - плакать нужно! - Что там ухо! На свадьбе драка была! Мне ухо оторвали, а член жениха - вот, у меня в кармане!");
INSERT INTO chat_shutnik VALUES("240","На скамье в парке сидит человек и, с негодованием глядя на идущего мимо пьяного, говорит: - Безобразие! Я бы вылил весь мировой запас спиртного в океан! Сидящий рядом мужчина аплодирует: - Браво! Отличная идея! - Вы тоже трезвенник? - Нет, я водолаз...");
INSERT INTO chat_shutnik VALUES("241","- Карлссон, опять щенок в углу насрал...\n- А где ж ему срать, на шкафу, что ли? Так только я могу!");
INSERT INTO chat_shutnik VALUES("242","- Мой муж хочет, чтобы я поступила на кулинарные курсы.\n- Вот как! А я и не знала, что вы приобрели собаку.");
INSERT INTO chat_shutnik VALUES("243","Стали Винни с Пятачком альпинистами. Ползут по стене.\n- Винни, Винни я прополз 15 метров и не вбил ни одного крюка.\n- Бей шлямбур, толстая свинья.\n- Но Винни, если я его забью он испортится.\n- Если ты его не забьешь, то испортимся мы оба.");
INSERT INTO chat_shutnik VALUES("244","После жуткого перепоя просыпается утром тетка. Во рту - кошки насрали, под глазами - черные круги, волосы торчком. Смотрит на себя в зеркало и говорит: - Я тебя не знаю, но я тебя накрашу.");
INSERT INTO chat_shutnik VALUES("245","Реальная история (вот так анекдоты и размножаются). Приятели заказали другу на день рождения семь девочек по вызову (ну процветает разврат среди молодежи, процветает!). Отметили отлично. На следующий день стадия \"разбор полета\". Довольный именниник благодарит: - Да, спасибо, все было классно, только я всего пятерых смог, но я же здорово пьяный был. А вот если бы трезвый был, то я бы, конечно, больше смог...\n- Знаешь, если б ты был трезвый... ТЫ БЫ НИ ОДНУ ИЗ НИХ НЕ СТАЛ!!!");
INSERT INTO chat_shutnik VALUES("246","Лукашенко перед вылетом в Москву на встречу с Путиным: «Я рад, что госпожа Райс, пролетая над Белоруссией, могла убедиться, что терроризма в ней нет. Никто ракеты по ней не выпустил». А руки так чесались...");
INSERT INTO chat_shutnik VALUES("247","Пожелание врагу: -Чтобы я увидел тебя на костылях, а ты меня одним глазом!");
INSERT INTO chat_shutnik VALUES("248","Тесть и зять работают на одной шахте, но в разные смены. Видятся только когда одного поднимают, а другого опускают в забой. Как-то раз происходит следущее... Поравнявшись в своих подъемниках и увидев друг друга, зять крутит пальцем около виска. Тесть, в ответ, крутит обеими пальцами у своих висков. Зять - резко сгибает одну руку в локте, а другой перекрещивает согнутую. Тесть - вытягивает одну руку, а другой бьет себя по ней в области плеча и показывает на свой зад. Народ - в шоке... Старый шахтер говорит зятю: - Что же ты со своим тестем никак общий язык не найдешь? Я его столько лет знаю - мужик просто замечательный! - Да вы ничего не поняли! - отвечает зять, - У нас великолепные отношения! Я его спросил знаком: \"Моя дура дома?\" - он ответил знаком: \"Обе - дома\". Дальше я его спросил: \"0,5 есть?\", на что он ответил: \"Есть 0,7 и стоит за унитазом!\" Вообще-то, этот анекдот надо показывать.");
INSERT INTO chat_shutnik VALUES("249","Просыпаются утром отец и сын.\n- А что, сынок, неплохо бы нам с тобой сейчас принять по сто грамм.\n- Дело говоришь, батя, дело. Сбегал сын в магазин, принес водки. Посидели, выпили.\n- Hу что, сынок, неплохо бы нам еще по-немногу? - Дело говоришь, батя, дело! Сбегал, еще принес. Выпили.\n- Hу что, сынок, теперь и поработать можно? - Hу, батя, ты как выпьешь - такую фигню нести начинешь!");
INSERT INTO chat_shutnik VALUES("250","С того времени, как нашего соседа сняли с должности генерального директора, он растерял половину своих друзей.\n- А как та... вторая половина? - Они еще не знают об его отставке.");
INSERT INTO chat_shutnik VALUES("251","Адвокат(А): - Итак, утром,25 июля, Вы шли со своей фермы по направлению к пастбищу? Свидетель(С): - Да. А: - Значит, Вы прошли всего в нескольких метрах от водоема с утками? С: - Да. А: - Заметили ли Вы что-то необычное? С: - Да. (Молчит) А: - Могли бы Вы сообщить суду, ЧТО Вы видели? С.\n- Я увидел Джорджа. А: - Вы увидели Джорджа.....обвиняемого в данном случае? С: - Да. А: - Могли бы Вы сказать суду, что Джордж...э.э.э.э....делал в это время? С: - Да. (Молчит) А: - Ну, ну, так что же он делал? С: - Ну....он засунул свою...э.э.э.... штучку....в одну из уток. А: - Свою \"штучку\" ? С: - Ну....Вы знаете...ну, штучку....свой ху......ну....свой пенис. А: - Итак, Вы проходили возле пруда, было уже светло, Вы были совершенно трезвы, у Вас хорошее зрение и Вы все это видели совершенно четко? С: - Да. А: - Сказали ли Вы что-нибудь Джорджу? С: - Разумеется! А: - И ЧТО Вы ему сказали?!! С: - Доброе утро, Джордж.");
INSERT INTO chat_shutnik VALUES("252","Один чудак в гостинице спрашивает номер, ему отвечают: \"Нет, мол, номеров\". А он ну очень упрашивает - ну хоть каморку какую-нибудь. Ему и говорят: - Ну ладно, есть один люкс, но у него слава дурная, там уже восемь человек повесилось. Чудак в ответ: - Я не суеверный. Отводят его в номер, показывают ему все, а он спрашивает: - А как, мол, повесились-то? - Все вот на этой дверной ручке.\n- Не может быть! - Да вот, уж, смогли. Утром уборщица открывает дверь - мужик висит на ручке двери, мертвый.\n- Елки зеленые, еще один любопытный.");
INSERT INTO chat_shutnik VALUES("253","Звезда Голливуда говорит своей приятельнице: - Я купила тебе в подарок книгу. По-моему, это учебник танцев под названием \"Оливер Твист\".");
INSERT INTO chat_shutnik VALUES("254","Пришел наркоман к стоматологу и говорит: - Доктор, вырвите мне зуб.\n- Вам под местным или под общим наркозом? - Что, одурел!? Под общим, конечно! И так 32 раза...");
INSERT INTO chat_shutnik VALUES("255","Песня пилота самолета МИГ, занимающегося сексом с девушкой за штурвалом самолета: Чем дорожу, чем рискую на Свете я, МИГом одним, только МИГом одним...");
INSERT INTO chat_shutnik VALUES("256","Конец мая. Училка на последнем в учебном году классном часе: - Дети, что для вас тpуднее всего было в 3-м классе? - Объяснять пpодавщице для кого покупается водка!!!");
INSERT INTO chat_shutnik VALUES("257","В троллейбусе едут два друга. Один рассказывает анекдот другому: - Ты, говорит, знаешь, почему менты всегда по трое ходят? Один имеет читать, второй писать, а третий следит за этими интеллектуалами! Тут с задней площадки протискиваются два мента. Предъявите, мол, документы и все такое... Один берет паспорт и говорит другому: - Вась, записывай...");
INSERT INTO chat_shutnik VALUES("258","Волк поймал Красную Шапочку в лесу.\n- Я тебя съем, - говорит. Красная Шапочка: - Не надо меня есть, я еще такая маленькая. Лучше вые@и меня. Волк подумал, подумал: - Ну ладно, говорит, только ты меня обеими руками за уши держи.\n- А у тебя там что, эрогенные зоны? - Да нет, просто знаю я вас, таких... Вечно по карманам шарите.");
INSERT INTO chat_shutnik VALUES("259","Мне сказали, Что от веснушек можно избавиться, если опустить лицо в муравейник на 5-6 минут.");
INSERT INTO chat_shutnik VALUES("260","- Ну, что? Опять вчера дома выволочка была? - Не то слово. На порог не пустила. В подъезде ночевал.\n- Чудак. Ты, прежде чем позвонить, разденься догола. А как она дверь откроет, бросай туда свои шмотки. Голого не оставит в подъезде. На другой день.\n- Ну как, пригодился мой совет? - Все сделал, как ты говорил. Двери открылись, я бельишко туда - шварк! Тут она чужим голосом громко говорит: \"Осторожно, двери закрываются. Следующая станция \"Маяковская\".");
INSERT INTO chat_shutnik VALUES("261","Ноги позволяют мужчине идти, а женщине еще и продвигаться.");
INSERT INTO chat_shutnik VALUES("262","- Девушки 90-60-90! Hе ищите пpиключений на свои 90!");
INSERT INTO chat_shutnik VALUES("263","Преподаватель автошколы спрашивает у студентов, сколько дел может одновременно делать водитель? Они начали перечислять: - 2 дела- управлять автомобилем и говорить по мобильнику.\n- 3 дела- управлять автомобилем, говорить по мобильнику и слушать музыку.\n- 4 дела- управлять автомобилем, говорить по мобильнику, слушать музыку и жевать бутерброд.\n- 5 дел- управлять автомобилем, говорить по мобильнику, слушать музыку, жевать бутерброд и отливать в памперсы... Ну, вроде все! Преподаватель: - Нет! Вы забыли еще одно дело.\n- Какое?! - Давить пешеходов!");
INSERT INTO chat_shutnik VALUES("264","Три проститутки сидят в баре, и одна жалуется остальным: - Сегодня неудачный день... Я заработала всего $100 -взяла в рот 4 раза по $50, а половину забрал сутенер... Другая отвечает ей: - Это еще ничего - я сегодня заработала $50 - всего 2 минета по $50, и тоже половину сутенеру... Сидящая рядом старая проститутка заявляет: - Вы не знаете, что такое плохая жизнь... Во времена Великой Депрессии мне иной раз приходилось по 10 раз в день делать минет бесплатно, только для того, чтобы иметь в пищу что-нибудь горячее...");
INSERT INTO chat_shutnik VALUES("265","Объявление о приеме на работу. Условия: Два дня работаешь, пять лет сидишь, зарплата сдельная.");
INSERT INTO chat_shutnik VALUES("266","Один умелец сделал часы, которые при произнесении матерного слова спешат на одну минуту. Для испытания повесили часы в детском саду, в училище, и в воинской части. Через месяц решили проверить результаты эксперимента. В детском саду часы ушли вперед на 10 минут, в училище - на полчаса. Пришли в воинскую часть - часов нет! Спросили у дневального: - Куда часы подевались? - Какие часы?! А... этот вентилятор командир приказал снять на следующий же день.");
INSERT INTO chat_shutnik VALUES("267","В 30-е годы мужик заполняет анкету и дошел до вопроса \"Как спите с женой ?\" Что писать? Напишешь \"слева\" - пришьют левый уклон. \"Справа\" - правый уклон. \"Сверху\" - возвышение над массами. \"Снизу\" - идешь на поводу у масс. Написал: \"сплю отдельно, занимаюсь онанизмом\". Ему дали 10 лет \"за кулацкий уклон и растрату семенного фонда\".");
INSERT INTO chat_shutnik VALUES("268","Если, проснувшись с глубокого похмелья, вы взглянули в зеркало и никого там не увидели - значит, вы стали просто неотразимы.");
INSERT INTO chat_shutnik VALUES("269","- Почему в Люксембурге не любят играть в футбол? - Очень неудобная игра: посильнее ударил по мячу и за ним надо бежать то в Бельгию, то в Германию, а то и во Францию... jonas");
INSERT INTO chat_shutnik VALUES("270","Человек приходит к директору завода и спрашивает: - Вам нужен начальник отдела кадров? - Нет.\n- А зачем вы его тогда держите?");
INSERT INTO chat_shutnik VALUES("271","Hовый русский на \"Мерседесе\" на огромной скорости въезжает в небольшой городок. Его тут же останавливает инспектор и говорит: - С вас штраф за превышение скорости свыше 30 километров в час в размере 500 рублей.\n- Hа тебе тысячу без сдачи - я на такой же скорости хочу покинуть ваш гнусный городишко!");
INSERT INTO chat_shutnik VALUES("272","Певичка была заранее уверена в своем успехе: - Пусть только попробуют плохо аплодировать - я буду петь песни о Сталине!");
INSERT INTO chat_shutnik VALUES("273","- Папа, мы евреи? - Нет, сынок.\n- А когда будем?!");
INSERT INTO chat_shutnik VALUES("274","- Дети! Я сейчас проходила мимо столовой и видела на полу булку хлеба. Кто-то бросил хлеб на пол и играл им в футбол. А вы знаете, сколько он стоит?! Да он полторы штуки стоит! Довели страну, реформаторы хреновы!");
INSERT INTO chat_shutnik VALUES("275","Пожилая женщина сделала молодежную стрижку и спрашивает мужа: - Дорогой, правда, я теперь не похожа на старуху? - Да, ты теперь похожа на старика.");
INSERT INTO chat_shutnik VALUES("276","Российский политик перед выборами: - Мой конкурент, находясь при власти, бессовестно обворовывал вас все эти годы! Все, о чем я вас прошу сегодня , это дать мне шанс!");
INSERT INTO chat_shutnik VALUES("277","В зоопарк сам прилетел попугай. Хочу, говорит, у вас поселиться. Ну, звери его обступили, говорят, рассказывай, как случилось такое, чтоб кто-то сам явился жить в зоопарк. Попугай говорит, это долгая история. Я 10 лет жил у одного дрессировщика. Мы выступали в разных цирках с большим успехом, потому что я умел имитировать самые разные голоса и звуки. Я подражал паровозному гудку, клаксонам машин, тиканью ходиков, крикам льва, мурлыканью кота, воплям обезьян... Но потом я состарился, и мне стало уже трудно заниматься этим ремеслом. Контракты прекратились. Нам просто стало нечего есть. И однажды вечером мой хозяин затопил печь, посмотрел на меня долгим взглядом и сказал: - Ну чего, братан, сымитируй крик фазана.");
INSERT INTO chat_shutnik VALUES("278","Телефонный звонок.\n- Позовите, пожалуйста, Рабиновича.\n- Его нет.\n- Он на работе ? - Нет.\n- В командировке ? - Нет.\n- В отпуску ? - Нет.\n- Я вас правильно понял ? - Да !");
INSERT INTO chat_shutnik VALUES("279","Приводит Дочь(Д) Нового Русского(НР) домой жениха-Выпускника семинарии.(В) (НР)с ним наедине: (НР)-Ты знаешь,моя дочь любит каждые три месяца отдыхать за границей!Что ты будешь делать? (В)-Боженька поможет. (НР)-А шубы она меняет как перчатки!Что будешь делать? (В)-Боженька поможет. (НР)-И машины меняет одну за другой...Что будешь делать? (В)-Боженька поможет. Короче на все вопросы отвечал-Боженька поможет! После его ухода,дочь спрашивает отца: (Д)-Пап,ну как он тебе? (НР)-Да так себе...Но то,что он меня Боженькой называет,мне нравится!!! :)");
INSERT INTO chat_shutnik VALUES("280","Троллейбус. Контроллер: - Ваш билет.\n- А ты кто такой? - Контроллер. [Громко, на весь троллейбус] - А! Контроллер! [Все щелкают компостерами]");
INSERT INTO chat_shutnik VALUES("281","- Вчера на меня напал бандит, но я даже не заявил в полицию.\n- Почему же? - Он обшарил все мои карманы, вздохнул и дал мне доллар.");
INSERT INTO chat_shutnik VALUES("282","У окулиста: - Доктор, у меня после свадьбы начались проблемы со зрением: я не вижу денег !");
INSERT INTO chat_shutnik VALUES("283","Молодая девушка в день своего совершеннолетия получает нарядное вечернее платье.\n- Мама, что это за материал? - Разве ты не видишь, это шелк.\n- Смотри, какая прелесть. И это все от маленького, никудышного червячка? - Как тебе не стыдно называть так своего собственного отца!");
INSERT INTO chat_shutnik VALUES("284","Из сообщений \"Дорожного патруля\". В лесопарковой зоне Михино было найдено тело с документами на имя гражданина К. Неожиданное осложнение в работу прибывших на место происшествия сотрудников милиции внесло то обстоятельство, что сам гражданин К. решительно отказался признавать свое тело и потребовал вызвать для опознания супругу, находящуюся в данное время в служебной командировке.");
INSERT INTO chat_shutnik VALUES("285","Социологический опрос: \"Как военное положение влияет на семейную жизнь?\" Самый популярный ответ: \"Очень хорошо! а) Жена в противогазе молчит все время. б) Лица жены я под противогазом не вижу. в) А если находясь в постели дырочку в баллоне заткнуть, то она даже пошевелиться может\".");
INSERT INTO chat_shutnik VALUES("286","- Папа! А почему бабушка по огороду бегает зигзагами? - Кому бабушка, а кому и теща. Дай-ка, сынок, вторую обойму!");
INSERT INTO chat_shutnik VALUES("287","Мyж c женой загоpают на пляже. Мyж, щyплый человек небольшого pоcта заметил, что его жена не отpывает глаз от cидевшего неподалекy кpyпного, мycкyлиcтого кpаcавца. Hе выдеpжав, мyж обpащаетcя к жене: - Зpя ты пялишьcя на него, доpогая. Вcпомни - y нашего cоcеда гаpаж на два \"кадиллака\", а он деpжит там велоcипед.");
INSERT INTO chat_shutnik VALUES("288","ртист пригласил на спектакль своего друга. После спектакля он сидит в гримерной, вытирает грим. Артист: - Ну что, как спектакль? Друг: - Чудесно! Все актеры играли как боги, сцена слилась с залом, просто полное проникновение, но ты... то слова забудешь, то на бабу в зале засмотришься.\n- Угу... А музыка тебе как? - Прекрасно, чувствуется, что композитор чувствовал пьесу, от драматических актеров не ожидал такого вокального таланта, правда, ты то не в такт запоешь, то петуха пустишь.\n- Умм... А декорации понравились? - Бесподобно!!! На всех актерах костюмы с иголочки, ну как в прошлом веке, правда, у тебя пуговица оторвана, ботинки нечишены, не понимаю.\n- Ага... а что, жена-то твоя все блядует?");
INSERT INTO chat_shutnik VALUES("289","Бог создал три качества - честность, ум и партийность, - но никому не дал больше двух. Так что если человек умный и честный, то он беспартийный. Если он честный и партийный, то он не умный. А если он умный и партийный, то он нечестный.");
INSERT INTO chat_shutnik VALUES("290","А вы пробовали принять слабительное одновременно со снот- ворным? Интересный эффект получается.");
INSERT INTO chat_shutnik VALUES("291","Журналист спрашивает у Карпова: - Ваше мнение о Deep Blue? - Душно и тесно.");
INSERT INTO chat_shutnik VALUES("292","Новый русский обсуждает с архитектором проект новой виллы.\n- Кароче, а тут рядом с сауной - чтобы три бассейна... один с горячей водой, другой с холодной, а третий - без воды! Архитектор: - А зачем вам бассейн без воды??? ж:-[] НР: - Ну ты прикинь, а вдруг у меня в сауне будут гости, которые плавать не умеют?");
INSERT INTO chat_shutnik VALUES("293","Пpишла весна. Зазвенела капель. Запели птички. Двоpник Hикодим вышел на улицу. Соpвавшаяся с кpыши сосулька убила двоpника Hикодима... Пpозектоp в моpге задумался над гpафой о пpичине смеpти и, улыбнувшись, написал: \"Весна пpишла\".");
INSERT INTO chat_shutnik VALUES("294","Сколько нужно ирландцев, чтобы закрутить лампочку? - Двое. Один держит лампочку, а второй пьёт виски, чтобы комната пошла кругом.");
INSERT INTO chat_shutnik VALUES("295","Судят грузина за изнасилование мальчика... Судья: - Расскажытэ, как это било? - Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый, розовый... Эх! Судья: - Эх! Расскажытэ еше раз, как это било...\n- Море - синий, синий; солнцэ - жолтый, жолтый; мальчык - попа розовый... розовый, розовый... Эх! Судья: - Суд удаляется на совещание! Через несколько минут...\n- Народный суд города Тбилиси постановил! Солнце желтый-желтый - продолжать светить. Мальчикам с розовой попкой по берегу синий-синий моря - нэ ходить, а подсудимый Габелия - па-автарите, пожалуйста, свой рассказ!");
INSERT INTO chat_shutnik VALUES("296","Сидя в джипе, бывший не в духе сержант приказал водителю: - Мне что-то не нравятся физиономии вон тех солдат около лужи. Ну-ка дай по газам и обдай их водой. Водитель послушно нажал на педаль газа и направил джип на лужу, в которую автомобиль буквально нырнул, так что на поверхности остались только головы сержанта и водителя. Это была канава, доверху наполнившаяся водой.");
INSERT INTO chat_shutnik VALUES("297","Один норвежец решил разводить птицу, купил 500 цыплят и... закопал их у себя в саду. Результат: все цыплята сдохли. Тогда он заказал еще 500 цыплят, посадил их в грядку головками наружу, но цыплята все равно сдохли. Норвежец написал письмо в Осло в тамошний университет, подробно описал свою проблему и попросил совета. Через несколько недель из Осло пришла телеграмма: \"Просьба прислать образцы почвы\".");
INSERT INTO chat_shutnik VALUES("298","Винни-Пух спрашивает у Пятачка, кем был его дед.\n- Мой дед был отбивной.\n- А кем был твой отец? - Мой отец был шашлыком! - Слушай, Пяточок, а кем ты хочешь стать? - Да вот, космонавтом...\n- А чё так грустно? - Да боюсь, в тюбик не влезу...");
INSERT INTO chat_shutnik VALUES("299","Врач говорит пациенту, очнувшемуся от наркоза: - Операцию вы перенесли хорошо, а вот перед ней вы вели себя просто невозможно: вырывались, кричали... А ваш знакомый с соседней койки вел себя еще хуже! - Еще бы! Ведь нас в клинику послали окна мыть.");
INSERT INTO chat_shutnik VALUES("300","Мой компьютер постоянно обыгрывает меня в шахматы. Зато я всегда побеждаю его в боксерском поединке!");
INSERT INTO chat_shutnik VALUES("301","- Что такое Советская власть? - спрашивает сын программиста у своего папы.\n- Это сынок, такая жутко глючная программа: пять лет ее устанавливают, затем 50 лет перезагружают компьютер, а потом оказывается, что вся система полетела и ее менять надо! Голем");
INSERT INTO chat_shutnik VALUES("302","Стоит наркоман, косяк забивает ( в ладони левой руки анаша). Подбегает девочка: - Дяденька, сколько время? Наркоман молчит. Девочка снова: - Дяденька, сколько время? Молчит. Девочка: - Дяденька, дяденька, ну сколько время? Hаркоман переворачивет ладонь и смотрит на часы: - Пи##ец тебе, девочка.");
INSERT INTO chat_shutnik VALUES("303","У речки с удочками сидят Счастливчик и Неудачник. У одного, естественно, клюет, у другого - нет. Неудачник интересуется: - На что ловишь? - На червя,- отвечает Счастливчик,- хочешь, бери! Вынимая жирного червя, тот спрашивает: - Ты где берешь таких красавцев? - Все очень просто. Отвожу от розетки провода и втыкаю их в огороде на грядке. Черви ползут как миленькие, собирай - не хочу. На следующий день Неудачник приходит весь в синяках.\n- Что с тобой? - изумился Счастливчик.\n- Да мало мне показалось двести двадцать вольт. Вышел в поле, там, где ЛЭП проложена, закинул провода, воткнул в землю и жду, когда черви появятся. А тут вылезли шахтеры и так морду набилиЄ");
INSERT INTO chat_shutnik VALUES("304","Опять же к доктору приходит женщина : - Доктор, у Вас есть 100%-ное противозачаточное средство. Доктор:(достает какие-то таблетки) - Вот, пожалуйста.\n- А это 100%-ное ? - Hет, 90.\n- А мне нужно 100. Доктор:(достает таблетки побольше) - Вот.\n- Это 100 ? - Hет, 95.\n- Hо мне-то нужно 100 ! Доктор: - Подождите. (достает таблетку величиной с ладонь) - Вот.\n- Hу это-то хоть 100 ? - Hет, 97.\n- Я вижу, Вы меня не понимаете... Доктор: - Hу, тогда... (двумя руками достает из шкафа таблетку величиной с автомобильное колесо) ... вот ! - О-о-о ! 8-0 Hу это наверно все 100...\n- Hет, Вы знаете, это 99.\n- Hо что-же мне делать ? Доктор: - Я кажется знаю... (долго копается в столе и наконец достает маленький металлический шарик) ...Вот что Вам нужно ! - И это 100%-ное ??? Доктор:(облегченно) - Да.\n- А как-же его использовать ??? - Держать между ногами во время полового акта !");
INSERT INTO chat_shutnik VALUES("305","Он был таким интеллигентным. Маму называл на вы.\n- Мама, вы что, охренели?");
INSERT INTO chat_shutnik VALUES("306","Если ваша жена хочет научиться водить автомобиль, самое главное - не стоять у нее на пути.");
INSERT INTO chat_shutnik VALUES("307","- А вот я тёще на день рождения подарил стиралку и сушилку! - Наверно, кучу денег выкинул? - Да не, всего баксов за 18! - ??????????? Это что ж за техника такая? - Тазик и полотенце!");
INSERT INTO chat_shutnik VALUES("308","Во время войсковых маневров начальник артиллерии замечает, что одно из орудий не стреляет. Он вызывает по рации командира батареи и требует доложить, в чем дело.\n- Дело в том, - докладывает тот, - что орудийный расчет так замаскировал свою пушку, что теперь не может ее найти.");
INSERT INTO chat_shutnik VALUES("309","- Когда читаю медицинскую энциклопедию, я обнаруживаю у себя все болезни.\n- Это бывает. Когда я читаю уголовный кодекс, то на каждой странице чувствую себя за решеткой.");
INSERT INTO chat_shutnik VALUES("310","Один мужик видя, что его сосед играет в карты со своей собакой восхищенно говорит ему: - Какая у Вас умная собака - Какая же она умная, видишь хвостом виляет, значит ей хорошая карта пришла.");
INSERT INTO chat_shutnik VALUES("311","Играют в карты Кощей Бессмертный, Баба Яга, Умный Мент и Глупый Мент. На столе лежит куча денег. Внезапно гаснет свет. Когда свет зажигается, денег нет. Вопрос: Кто украл деньги? Ответ: Глупый Мент. Вопрос: Почему? Ответ: Потому что все остальные - вымышленные персонажи.");
INSERT INTO chat_shutnik VALUES("312","- Я всегда любил слушать хорошие анекдоты, но быстро их забывал. Поэтому я стал их придумывать сам. Получилось совсем не хуже, и даже лучше.\n- Почему ты так решил? - Потому что не только я, но и все мои знакомые, которые слышали эти анекдоты, тоже их быстро забывают!");
INSERT INTO chat_shutnik VALUES("313","Из отчета слyжб безопасности \"... по поводy взлома китайцами сеpвеpа Пентагона\": ....... 1) Каждый китаец попpобовал один паpоль. 2) Каждый втоpой паpоль был \"maodzedun\" 3) Hа -й попытке сеpвеp согласился что y него паpоль \"maodzedun\"");
INSERT INTO chat_shutnik VALUES("314","Звонок в двеpь. Hа поpоге Дед Моpоз. Маленький мальчик кpичит: - Здpавствyй, Дедyшка Моpоз! Ты подаpки... Дед Моpоз: - Hе тpанди, пацан! Штопоp есть?!");
INSERT INTO chat_shutnik VALUES("315","Муж возвращается из командировки и видит у подъезда припаркованный \"Мерседес-600\". Заходит домой. Hа вешалке - красный пиджак, на столе - радиотелефон, в постели - жена с каким-то мужиком. Муж толкает мужика в бок: - Ты чего здесь делаешь? - Как чего? Hе видишь - новых русских делаем.");
INSERT INTO chat_shutnik VALUES("316","У него было трудное детство - до пяти лет, он был уверен, что его зовут: -\"Идитынах%й\"");
INSERT INTO chat_shutnik VALUES("317","Анекдот для москвичей: А раньше \"Лысый в кепке\" означало: \"Ленин\"...");
INSERT INTO chat_shutnik VALUES("318","Приходит пролетарий домой и, увидев свою жену с соседом, гово- рит: \"Вот вы тут глупостями занимаетесь, а в магазине, между про- чим, колбасу дают!\"");
INSERT INTO chat_shutnik VALUES("319","У фотографа: - Товарищ фотограф, это не моя фотография.\n- Как же не ваша, а, по-моему, похоже получилось.\n- А вот смотрите, нос же не мой.\n- Да, как будто не ваш.\n- А эта бородавка! У меня нет никакой бородавки.\n- Гм, действительно нет.\n- И потом, этот лежит в гробу, а я еще живой.");
INSERT INTO chat_shutnik VALUES("320","Женская мысль давно хотела попасть в мужскую голову... И вот она наконец-то туда залетает, счастливая.. А там никого нет. Пусто. Она смотрит по сторонам и вдалека видит летящую мужскую мысль. Женская мысль зовет мужскую, та подлетает... Женская мысль говорит: - Я так хотела сюда попасть.... А тут нет никого? Мужская мысль ей отвечает: - Ах, дурочка! Мы уже все внизу тусуемся...!");
INSERT INTO chat_shutnik VALUES("321","Инженер, парикмахер и экономист путешествовали по сельской местности. Устав, они остановились в маленькой харчевне.\n- У меня только две комнаты, - извинился хозяин.\n- Одному из вас придется спать в амбаре. Как водится, в амбар добровольно подался инженер. Вскоре уже засыпавших его товарищей разбудил стук. За дверью стоял инженер: - В амбаре корова. А я - индуист и по своей вере не имею права спать рядом со священным животным, - объяснил инженер. В амбар направился парикмахер. Не успели путники заснуть, в дверь снова постучали. За дверью стоял парикмахер: - Там свинья. Я, как еврей, не могу спать рядом с нечистым животным. Не оставалось ничего другого, как пойти в амбар экономисту. Под утро снова раздался стук. Удивленные приятели увидели за дверью корову и свинью.");
INSERT INTO chat_shutnik VALUES("322","В больнице две дамы говоpят о только что умеpшей подpуге: - Хотелось бы мне иметь ее ноги - у нее были пpелестные ноги! Жалко - тепеpь пpопадут...");
INSERT INTO chat_shutnik VALUES("323","Разговаривают два алкаша: - Я намедни пить бросил...\n- ??? - А вот куда - не помню!..");
INSERT INTO chat_shutnik VALUES("324","Осень, сыро, холодно. В пивную заходит оборванец и просит налить кружечку похмелиться. Бармен говорит жалостливо: - Ты бы лучше себе носки потеплее купил.\n- На хрена? Здоровье дороже!");
INSERT INTO chat_shutnik VALUES("325","Корсиканец с гордостью говорит приезжему: - У нас воруют так, что во многих местах железная дорога проложена кольцами.\n- А зачем? - Чтобы машинист мог убедиться, что все вагоны на месте.");
INSERT INTO chat_shutnik VALUES("326","Как известно, спартанцы учили детей плавать, попросту сбрасывая их со скалы в море. Интересно, если начать сбрасывать детей с самолета, хоть некоторые из них научатся летать?");
INSERT INTO chat_shutnik VALUES("327","Уход за волосами - смерть лысого человека.");
INSERT INTO chat_shutnik VALUES("328","Взвод морских пехотинцев пришол в кинотеaтр нa просмотр голивудского боевикa. В сaмый кульминaционный момент героиня зaстреливaет своего любовникa и трaгическим голосом вопрошaет: - Hу чтоже мне теперь делaть ?! Kомaндный голос из зaлa: - Осмотреть оружие и отойти зa огневой рубеж!");
INSERT INTO chat_shutnik VALUES("329","- Мадам, вы, очевидно, принимаете меня за дурака? - Что вы, я никогда не сужу о людях по первому впечатлению.");
INSERT INTO chat_shutnik VALUES("330","Как и полагается, у сексопатолога: - Доктор, Вы знаете, у меня не стоит...\n- А Вы, батенька, сюда трахаться, что ли, пришли ?!.");
INSERT INTO chat_shutnik VALUES("331","Что делают чукчи, когда холодно? Закрывают в юрту дверь и садятся вокруг свечки. Что делают чукчи, когда очень-очень холодно? Они ее зажигают.");
INSERT INTO chat_shutnik VALUES("332","Два человека выходят на улицу: - Какая ужасная погода, снег с дождем! - Подонки, что хотят, то и творят...");
INSERT INTO chat_shutnik VALUES("333","Получилось так, что две женщины отсидели в тюрьме 10 лет. В одной камере. Выпустили их в один день. Вышли за ворота, одной надо направо, другой налево. Hу, обнялись, расцеловались. Одна другой: - Ладно, остальное я тебе завтра по телефону расскажу . . .");
INSERT INTO chat_shutnik VALUES("334","Приходят к Сталину украинские националисты и говорят, что надо, мол, составить украинско-русский словарь. Сталин закурил трубку, задумался: - Словарь, говорите, ну а как по-украински будет рука? - Рука.\n- Ну а как нога? - Нога.\n- Ну а как голова? - Голова.\n- А как будет жопа? - Срака.\n- Так что же это, из-за одного слова словарь составлять!");
INSERT INTO chat_shutnik VALUES("335","- Ты потребовала бы развод, если бы узнала, что муж тебе изменяет? - Ты что?! За такое его еще и награждать?...");
INSERT INTO chat_shutnik VALUES("336","В церкви большой переполох. Скоро приедет архиепископ с проверкой. Подбегает к пастору монашка и грит: - Святой отец, мне кажется, что ваши стулья надо заново покрыть лаком. Они совсем облупились! - Не ВАШИ, а НАШИ, сестра - здесь ничего нет личного, а только НАШЕ, понятно!? На следущий день опять эта монашка грит пастору: - Святой отец, надо бы ваш потолок заново побелить, а то он уже черный весь! - Дочь моя, не ВАШ, а НАШ потолок, я же вам говорил...! И вот приехал архиепископ. Ходит он с пастором, смотрит вокруг, всем вроде доволен. Тут подбегает монашка и грит пастору: - Святой отец, я нашла ваши часы...\n- Очень мило, сестра, и где же они были? - Под НАШЕЙ кроватью...!!!!");
INSERT INTO chat_shutnik VALUES("337","Свеpхмодный молодой человек обpащается к поpтному: - Вы могли бы сшить мне костюм цвета кофе с кипящим молоком ? - С сахаpом или без ? - спокойно осведомился поpтной. ;););)");
INSERT INTO chat_shutnik VALUES("338","Война. В окопе сидят два солдата и раскуриваются, на них едет танк. Один солдат говорит другому: \"Вань бросай гранату\". Тот говорит: \"Давай сделаем по напасу и тогда бросим\". Сделали по напасу. Первый говорит: \" Вань танк уже близко, давай бросай гранату\". А второй ему: \"Ну ты чего пристал, хочешь, бросай сам\". Подъезжает танк, из люка вываливается накуренный фашист и спрашивает: \"Ну вы чего, гранату то будете кидать?\" А те ему: \"Да что-то нам влом. А вы почему не стреляете?\" Фашисты: \" А мы ствол запаяли чтобы кумар не уходил!\"");
INSERT INTO chat_shutnik VALUES("339","Bесна. Половодье. Mаленький остpовок суши, на котоpом спасаются от воды Cобака и Заяц. A вода все пpибывает и пpибывает, вот-вот затопит остpовок... Чу... Bдали показалась лодка.\n- Уpа, мы спасены!!! - закpичал Заяц.\n- Это Дед Mазай!!! Cобака долго вглядывалась в даль, а потом гpустно сказала: - Hет, Заяц, это не Mазай, это ГEPACИM!!!");
INSERT INTO chat_shutnik VALUES("340","Маленький сын был с папой в зоопарке. У клетки со львом он спросил: - Папа, а если он съест кого-нибудь из нас, на каком номере автобуса мне ехать домой?");
INSERT INTO chat_shutnik VALUES("341","Директор коммерческого магазина учит молодую продавщицу: - Если покупатель спросит: \"Почем очки?\", ты скажи: \"Три штуки\". Если он не дрогнет, скажи: \"За оправу\". Если он опять не дрогнет, скажи: \"И за стекла три штуки\". И если опять не дрогнет, скажи: \"За каждое\".");
INSERT INTO chat_shutnik VALUES("342","- Доктор, я - импотент. И это у меня наследственное.");
INSERT INTO chat_shutnik VALUES("343","У миссис Смит умер муж и страховое агентство платит пятьдесят тысяч долларов бедной вдове. Она горько плачет: - Ах, я бы отдала треть этих денег, лишь бы он был опять со мной...");
INSERT INTO chat_shutnik VALUES("344","На приеме у психиатра.\n- Так, милейший, не волнуйтесь, на что жалуемся? - Не поверите, доктор! Иду я вчера с работы мимо нашего Вычислительного центра, и...\n- Ну-ну! - А там из всех окон Билл Гейтс выглядывает!!! - Так-так! - А по бокам... интерфейсы с кнопками стоят!!! - Да, батенька, пора вам перезагружаться. В новую рубашечку!");
INSERT INTO chat_shutnik VALUES("345","- Гарсон! Кажется, я хватил лишнего. Принесите чего-нибудь отрезвляющего.\n- Пожалуйста, счет.");
INSERT INTO chat_shutnik VALUES("346","Идет по Арбату новый русский в белом костюме с букетом белых роз, спешит на свидание. Погода прекрасная, настроение тоже. Вдруг он видит аппарат, типа автомата с газировкой, с надписью: \"Портим настроение. 1$\" \"Что мне может испортить настроение\" - подумал он и спокойно опустил доллар в автомат. И в тот же момент автомат выплюнул ему ложечку говна прямо на лацкан белого костюмчика. Расстроился новый русский: костюм испорчен, настроение тоже. Вдруг видит рядом стоит точно такой же автомат с надписью: \"Поднимаем настроение. 100$\" \"Что мне может поднять настроение\" - удивился он и быстренько опустил в автомат стольник. И в тот же момент на всех окружающих автомат выплюнул ведро говна...");
INSERT INTO chat_shutnik VALUES("347","Прочитав кое-что на женском форуме понял, что все русские мужчины - импотенты. Эти же козлы, все поголовно, изменяют своим женам.");
INSERT INTO chat_shutnik VALUES("348","Объявили вепсы войну Китаю! Китайцы присылают парламентеров. Идут по деревне, видят идет мужичек, спрашивают (вежливо): \"Вы вепс?\", тот говорит \"Конечно вепс\". Китайцы говорят: \"Вот вы (вепсы) нам войну объявили, а вы знаете, что нас китайцев больше миллиарда?\". Мужичок: \"Ой блин! Где-же мы вас хоронить-то будем?\"");
INSERT INTO chat_shutnik VALUES("349","Когда канцлер князь Горчаков сделал камер-юнкером Акинифьева (в жену которого был влюблен), Тютчев сказал: \"Князь Горчаков походит на древних жрецов, которые золотили рога своих жертв\".");
INSERT INTO chat_shutnik VALUES("350","Идет судебный процесс. Слон обвиняется в изнасиловании змеи. Судья-лев вызывает пострадавшую: - Расскажи, как это было.\n- Мне до сих пор трудно говорить... В общем, он силой заставил меня взять в рот свой детородный орган.\n- Понятно. Теперь послушаем свидетеля. Выходит свидетель - легкомысленная обезьяна: - О! А! Вы бы видели, какая была эрекция! А когда началось семяизвержение, я подумала, что наступил конец света.\n- Ясно. Обвиняемый, что ты можешь сказать в свою защиту? Слон: - Прежде всего, это был не оральный секс, а анальный. И не со змеей, а с обезьяной и по взаимному согласию. А змею я просто применил в качестве презерватива.");
INSERT INTO chat_shutnik VALUES("351","По просьбе своих соплеменников поехал Чукча в Москву узнать, когда будет коммунизм. Приходит Чукча на прием к Горбачеву и спрашивает: - Когда будет коммунизм ? - Вот смотри: видишь, стоит моя \"Волга\", \"Волга\" Лукьянова, \"Волга\" Лигачева. Вот когда будет рядом стоять твоя \"Волга\", тогда, считай, и будет коммунизм. Вернулся Чукча в стойбище.\n- Узнал ? - Узнал. Вот видишь, стоят мои унты, твои унты и еще унты. Вот когда рядом будут стоять унты Горбачева, тогда, считай, и будет коммунизм.");
INSERT INTO chat_shutnik VALUES("352","Судья: - Вы должны попробовать стать другим человеком.\n- Я уже пытался, меня сразу посадили за подделку документов.");
INSERT INTO chat_shutnik VALUES("353","На недавней компютерной выставке (COMDEX) Билл Гейтс сравнил компьютерную промышленность с автомобильной и, в частности, сказал: - Если бы Дженерал Моторс осваивала достижения технологии с таким же эффектом, как это происходит в компьютерной промышленности, то мы все уже бы ездили на -ти долларовых машинах с расходом бензина литров на километров. На что Дженерал Моторс отреагировала: - Да, но хотели бы вы чинить ваш автомобиль дважды в день?...");
INSERT INTO chat_shutnik VALUES("354","- Скажи, вот если мужчина говорит, что у меня волосы хорошо пахнут, это домогательство или нет? - Да нет, это комплимент, по-моему.\n- А если он карлик ....????");
INSERT INTO chat_shutnik VALUES("355","- Когда я иду с женой в гости, то пью очень мало.\n- Тебе не разрешает жена? - Вовсе нет. Просто однажды я здорово перебрал, и мне показалось, что у меня две жены. Такого ужаса я никогда не испытывал!");
INSERT INTO chat_shutnik VALUES("356","Два наркомана, обкурившись, лежат на кровати. Звонок в дверь... Через полчаса один другому: \"Кажется, в дверь звонят...\" Через полчаса другой первому: \"Может, пойти, открыть дверь?..\" Через полчаса первый: \"Ну, сходи, открой...\" Через полчаса второй встает, медленно идет к двери, открывает... На пороге, облокотившись о дверной косяк, стоит третий наркоман: \"Ох-х! Не успел позвонить, уже дверь открывают!\"");
INSERT INTO chat_shutnik VALUES("357","Наташа Ростова вышла вечером подышать на веранду. Внизу в лопухах что-то темнело. НР: Поручик, это Вы? Ржевский: Я! НР: А что это Вы такой маленький? Ржевский: Я не маленький. Я сру.");
INSERT INTO chat_shutnik VALUES("358","- А я не встану под музыку нового гимна! - Ну и будешь смотреть в задницу поющему... Коклюшкин");
INSERT INTO chat_shutnik VALUES("359","Семь раз отмерь - один раз отрежь! (еврейская народная пословица)");
INSERT INTO chat_shutnik VALUES("360","К мужику на вокзале подбегает цыганка: - Драгоценный мой, дай руку, погадаю, все скажу, что будет, что было. Мужик пожимает плечами, протягивает руку: - Hу, погадай. Цыганка некоторое время смотрит на ладонь, потом в ужасе кричит: - Страшной смертью помрешь! Зарежут тебя, сдерут шкуру, четвертуют, зажарят и съедят! - Ах да, я ж перчатку не снял...");
INSERT INTO chat_shutnik VALUES("361","Мадам готовит завтрак, муж перелистывает газету. Вдруг раздается странный гортанный звук.\n- Что там с тобой? - кричит она мужу.\n- Я случайно проглотил пуговицу от воротничка! Мадам удовлетворенно: - Хоть теперь мы будем знать, где она находится!");
INSERT INTO chat_shutnik VALUES("362","Военный говорит жене: - Поздравь меня - мне дали майора.\n- Поздравляю. И что ты с ним сделал?..");
INSERT INTO chat_shutnik VALUES("363","- Что делать, профессор, все готово к операции, а пациента еще нет.\n- Это ничего, начнем без него.");
INSERT INTO chat_shutnik VALUES("364","- Доктор, что означают буквы \"ЧЗ\" в моем диагнозе? - \"Черт его знает\".");
INSERT INTO chat_shutnik VALUES("365","Купил искусственную электронную вагину. Вы даже не представляете, что сбой процессора может быть так приятен...");
INSERT INTO chat_shutnik VALUES("366","Люди, которые думают, что они знают все на свете, раздражают нас, людей, которые действительно все на свете знают.");
INSERT INTO chat_shutnik VALUES("367","- Вчера я видел, как ты выходил из пивной.\n- Что поделаешь, не могу же я там жить.");
INSERT INTO chat_shutnik VALUES("368","Мать с дочкой идут через густой лес. Вокруг никого. страшно. Дочь: - Мама, а вдруг нас изнасилуют?!! - Не с нашим счастьем, доченька....");
INSERT INTO chat_shutnik VALUES("369","ЗВОНОК ОТ ХИЛЛАРИ Хиллари пошла к гинекологу, чтобы провериться. Когда она закончила, она спросила его, все ли в порядке. Он ответил, что он очень рад ее состоянием, но...........она беременна! - Как это возможно? Этого не может быть! - Но это так! Вы беременны уже месяц! Она выбежала из оффиса и побежала к секретарю. Взяла телефон и позвонила в Белый Дом. Когда ответил оператор, она сказала, что это Хиллари и хочет говорить с Биллом срочно! Оператор соединил ее с Овальным оффисом и Билл ответил. Хиллари начала кричать: - Ты знаешь, что ты сделал, ты кретин! Ты сделал меня беременной!!! Никакого ответа не последовало. Хиллари опять повторила, крича: - Ты знаешь, что ты сделал, ты никому не нужный кретин! Ты сделал меня беременной!!!!!!!!!! Наконец, послышался ответ: - Кто это???................");
INSERT INTO chat_shutnik VALUES("370","Управляющий беседует с молодым человеком, который хочет устроиться на работу: - В нашей фирме, - говорит управляющий, - очень заботятся о чистоте. Вы вытерли ноги о коврик перед тем как войти? - О да, разумеется.\n- Во-вторых, - продолжает управляющий, - мы требуем от наших сотрудников правдивости. Никакого коврика там нет.");
INSERT INTO chat_shutnik VALUES("371","Если к поэту приходит муза, к поэтессе приходит музык.");
INSERT INTO chat_shutnik VALUES("372","- Не понимаю, почему ты развелась с мужем? - Мне вообще не повезло с замужеством. Сначала оно напоминало мираж в пустыне: дворцы, фонтаны, пальмы, яхты, путешествия на верблюдах по Африке...\n- А потом? - Потом дворцы, фонтаны исчезли, яхта пришла в негодность, осталась одна верблюжья работа.");
INSERT INTO chat_shutnik VALUES("373","Директор мебельной фабрики поехал в командировку в Париж. Возвращается - масса впечатлений. Рассказывает своим приятелям: - О, такой город! Такие улицы! Такие магазины! - Ну а женщины? - О-о! Это что-то невероятное! Мечта! Главное - любого мужика понимают с полуслова. Вот например: захожу я в маленький ресторанчик, сажусь за столик. Ко мне подсаживается умопомрачительная красотка. Ну сразу сообразила, что я по ихнему - ни слова. Рисует мне на салфетке рюмку. Я - наливаю ей шампанского. Рисует сигарету. Я - даю закурить. Рисует две танцующие фигурки. Я - приглашаю ее на танец.\n- Ну а потом? - Рисует кровать...\n- А ты? - Хмм... До сих пор не пойму - как она узнала, что я - директор мебельной фабрики...");
INSERT INTO chat_shutnik VALUES("374","Молодой офицер попадает служить на боевой корабль, который немедленно направляется в длительный поход. \"Товарищ капитан первого ранга, я и с девушкой-то не успел побыть, а тут такой длительный поход - жалуется он командиру. \"Ничего, лейтенант, у нас для этих целей кок есть.\" \"Как можно - возмущается лейтенант - ведь он мужчина.\" \"Ну не хотите, как хотите, но если что, посодействую.\" Проходит три месяца. Лейтенант подходит к командиру: \"Товарищ капитан первого ранга, Вы что-то насчет кока говорили...\" \"Мичман! - зовет тот - приведи кока в каюту лейтенанта и не забудь взять еще троих.\" \"Зачем троих? - смущается лейтенант - а нельзя ли нам с коком один на один?\" \"Ты один с ним не справишься, сынок. Его же сначала надо с ног сбить и к кровати прижать.\"");
INSERT INTO chat_shutnik VALUES("375","На балу к поручику подскочил корнет и решив блеснуть остроумием и поетическим даром сказал: \"Поручик-ключик-чайничек\" Ржевский ответил: \"Корнет-кларнет-тромбон-гандон- и вообще ты пидарас\"");
INSERT INTO chat_shutnik VALUES("376","Самое сложное для артиста пародирующего Баскова - также не попасть в ноты.");
INSERT INTO chat_shutnik VALUES("377","Анекдот из сериала \"Скорая помощь\". Врач дает указания практикантке: - В третьей смотровой пациент повредил прямую кишку большой морковью. Составьте анамнез и заполните его карточку. Практикантка изумленно: - Как он проглотил целую морковь?!!");
INSERT INTO chat_shutnik VALUES("378","Ночь была темной. Часовому хотелось курить.\n- Эй, Мак! - окликнул он, как ему показалось, своего товарища, проходившего недалеко от поста.\n- У тебя нет сигаретки? И тут он рассмотрел, что окликнул генерала.\n- Виноват, сэр! - гаркнул он и принял стойку \"смирно\".\n- Вольно, рядовой, - отдал команду генерал.\n- И считай, тебе повезло, что я не лейтенант!");
INSERT INTO chat_shutnik VALUES("379","В фотоателье мастер долго и пристально смотрит на клиента. Тот заерзал в кресле: - Что-то не так ? - Да Вы не волнуйтесь, все в порядке - просто если б не усы, Вы были бы вылитая моя теща.\n- Но у меня нет усов ! - А вот у нее есть.");
INSERT INTO chat_shutnik VALUES("380","- Как получить миллиард долларов? - Очень просто. Надо поймать Березовского и продать его Гусинскому.");
INSERT INTO chat_shutnik VALUES("381","Вернулся мужик из командировки. Приехал домой, открывает дверь и видит на вешалке чужое мужское пальто. Заходит в спальню. В постели жена лежит, всюду мужская одежда разбросана, а тут еще из ванной выходит голый мужчина. Муж только открывает рот, но его тут же перебивает жена: - Ну, конечно, всегда так ! Ты сейчас будешь верить своим бесстыжим глазам, а не любимой жене !");
INSERT INTO chat_shutnik VALUES("382","Молодой, талантливый пианист пришел записываться на радиостудию. Но вот непруха! Чем больше играет, тем хуже получается. И дальше - хуже... Время часов ночи. За стеклышком сидит оператор грустный... Кофе кончился, сигарет нет, жена три раза звонила, обещала из дому выгнать. Надоело ему это все. Включает он микрофон в студии и говорит: - \"Слушай, мужик! Ладно, все, хорош! Ну не получается. Но ты хоть гамму-то сыграть можешь?\" Тот ему: - Гамму! Нет проблем! - Сыграй, а я потом нарежу!");
INSERT INTO chat_shutnik VALUES("383","- Какая разница между женщиной без груди и брюками без карманов? - Никакой. Некуда руки девать.");
INSERT INTO chat_shutnik VALUES("384","Около ранчо остановилось стадо баранов и уставилось на ворота.\n- Чего они смотрят? - спросили у пастуха.\n- Ведь ворота старые? - Бараны новые, - ответил пастух.");
INSERT INTO chat_shutnik VALUES("385","Встречаются на том свете три старых седых мужика, узнают друг у друга, как и отчего приключилась смерть. Первый говорит: - Я всю жизнь работал и смерть меня настигла в процессе труда. А работа была нелегкой, и поседел я лет в шестьдесят. Второй говорит: - А я всю жизнь воровал потихоньку, в конце концов меня и убили из-за денег. И при этом лет в сорок поседел, понимая, чем кончится мой промысел. Третий говорит: - Ну, вы, мужики, круты, хоть чего-то в жизни добились, а вот я вообще не делал ни хрена, и, как услышал, что моя собственная жена хочет меня на пересадку органов пустить, сначала поседел, а потом - при операции - сердце не выдержало... Голем");
INSERT INTO chat_shutnik VALUES("386","Жили в одной избушке Медведь, Волк и Заяц. У Медведя была заначка водки. Как-то раз ушел он в лес, а Волк с Зайцем остались дома. Заяц подходит к Волку и говорит: - Давай выпьем! - Да ты что, Медведь нам потом головы оторвет.\n- Ничего, когда он станет про водку спрашивать, ты, главное, глаза побольше сделай, мол, и не видели ее даже, а там как-нибудь выкрутимся. Выпили они медвежью заначку. Вечером Медведь обнаружил пропажу и спрашивает - А где моя водка? У Волка глаза по пятаку, а Заяц ему и говорит: - Ну что глазенки-то выпятил, рассказывай все дяде Мише!");
INSERT INTO chat_shutnik VALUES("387","Мужики взбунтовались, взяли вилы, топоры, дубье и поперли к усадьбе. Шумят, матерятся, гул стоит. Подходят к усадьбе. Выходит староста, пытается уговорить мужиков разойтись, потом управляющий - не слушают, матерятся, требуют, чтоб Сам вышел. Выходит помещик, после завтрака, халат расстегнут, левой рукой чешет брюхо, правой зубочистку держит, во рту ковыряется. Мужики притихли. Барин зевает, поворачивается к толпе и негромким голосом спрашивает: - Ну, чего вам, мужики? Мужики стоят молча. Барин смотрит на них, ждет ответа минуты три, потом лениво уходит. Мужики стоят, молчат, потом, спустя полчаса понемногу расходятся. Дня через три один из зачинщиков обедает дома, ест шти. Вдруг посреди обеда останавливается, задумывается, потом бах ложкой об стол и орет: - ЧАВО, ЧАВО, А НИЧАВО!");
INSERT INTO chat_shutnik VALUES("388","- Что можно снять с голой женщины? - Только голого мужчину.");
INSERT INTO chat_shutnik VALUES("389","Учительница прибегает к директору в слезах: - Ах это просто невыносим ! Не ученики - животные, скоты ! А один даже грозился меня изнасиловать ! Представляете ?! Директор встает и идет в класс. Входит. Молча осматривает ряды учеников и тыкает пальцем в Вовочку: - Этот сказал ? Понимаю: этот раз сказал - сделает.");
INSERT INTO chat_shutnik VALUES("390","\"Хуюшки вам, а не Кунашир!\" - сказал японцам Владимир Путин. И остров Хуюшки из Курильской гряды пришлось отдать.");
INSERT INTO chat_shutnik VALUES("391","- Любите ли вы Шекспира? - Трудно сказать. Скорее, мы просто приятели.");
INSERT INTO chat_shutnik VALUES("392","Начало чемнионата России по футболу. Матч \"Динамо\" - \"Спартак\". Опоздавший болельщик - соседу: - Ну и кто из наших лучше всех играет, точнее всех бьет? - Ковтун.\n- Но на табло :, и два гола забил Терехин....\n- Много ты понимаешь! Терехин десять раз ударил и два раза забил, а Ковтун три раза ударил, и для всех троих сезон уже закончился!");
INSERT INTO chat_shutnik VALUES("393","- Кто, в конце концов, в доме хозяин?! - набравшись духу, закричал муж.\n- Я,- спокойно ответила жена,- А что? - Да нет, ничего... Все в порядке. Я просто так спросил.");
INSERT INTO chat_shutnik VALUES("394","- Где у женщин расположен аппендикс? - Как войдешь - налево.");
INSERT INTO chat_shutnik VALUES("395","Где-то загорелся дом. Все тушат. Прибегает хозяин и кричит: - Hа меня ведро воды! Выплеснули на него ведро, вбежал в горящий дом, через какое-то время выскоч ил. Проходит минут , мужик опять: - Hа меня ведро воды! Снова забежал в дом, через некоторое время выскочил. Прошло еще минут , у дома крыша уже обваливается, мужик опять: - Hа меня ведер! Ему говорят, мол, куда ты полезешь, и вещей не спасешь, и сам погибнешь.\n- Какие вещи! Там моя теща, а я ее переворачиваю.");
INSERT INTO chat_shutnik VALUES("396","Однажды пришли к габровцам гости, да слишком засиделись. Не вытерпела хозяйка и громко сказала мужу, чтобы все услышали: - Давай, муженек, ляжем спать, а то, наверное, гости уже хотят идти домой!..");
INSERT INTO chat_shutnik VALUES("397","Революция кончилась. Петька с Василием Ивановичем думают о новой жизни: - Петька, что бы нам теперь построить? - Построим консерваторию! - Точно! А на крышу пулемет поставим! - А это зачем? - Чтобы все консервы не растащили!");
INSERT INTO chat_shutnik VALUES("398","Мужик жалуется приятелю: - А ведь когда-то у меня было все: деньги, роскошный дом, мерс, красивая женщина, которая меня по-настоящему любила. И всего этого я лишился в одночасье.\n- А что случилось? - Да какой-то козел рассказал об этом моей жене!");
INSERT INTO chat_shutnik VALUES("399","Из письма А. Б. Чубайсу. Уважаемый Анатолий Борисович, пишет вам электрик Эрнест Петрович Сидоров. Сделайте что-нибудь. Ввиду огромного внешнего сходства с вами, мне очень часто бьют морду. С уважением Э. П. Сидоров");
INSERT INTO chat_shutnik VALUES("400","Глубокой ночью Сталин поднимает трубку.\n- Слушай, товарищ Молотов, а ты так же все заикаешься? - Заикаюсь, товарищ Сталин, но если нужно будет для дела строительства социализма, тоЄ - Нет, ничего не надо. Спи спокойно. И кладет трубку. Звонит Микояну.\n- Слушай, товарищ Микоян, сколько там было бакинских комиссаров? - , товарищ СталинЄ - А сколько погибло? - , товарищ Сталин.\n- Ну, спи спокойно, наш двадцать седьмой бакинский комиссар! И кладет трубку. Звонит Берии.\n- Слушай, товарищ Берия, ты Бухарина надежно расстрелял? - Надежно, товарищ Сталин. А что? - Да ничего. Спи спокойно. Кладет трубку и говорит: - Ну вот, их успокоил, теперь можно м самому уснуть.");
INSERT INTO chat_shutnik VALUES("401","Англичанин среднего достатка заходит в респектабельный магазин. Немного оглядевшись спрашивает продавца.\n- Скажите, сколько стоит вон та шляпа? -Тысячу долларов, Сэр.\n-Черт.., А вон та? -Два черта, Сэр. FiL");
INSERT INTO chat_shutnik VALUES("402","Гpузин в pестоpане любуется новыими \"коpочками\" кандидата наук. Официант ехидно спpашивает: - Что, только что купил ? - Вах ! Зачэм стpашиваэш ! Зачэм сpазу: Купиль ! Дpуззя подаpиль !!");
INSERT INTO chat_shutnik VALUES("403","Встречаются два директора советского и японского предприятий. Предприятия изготавливают совершенно одинаковую продукцию и в одинаковых количествах. Директор нашего завода спрашивает: - Сколько людей у тебя работает? - Девять. А у тебя? У нашего вообще-то пятьсот, но он говорит: - Десять! На следующий день японец говорит: - Слушай, я всю ночь думал и никак не могу понять: что у тебя этот десятый делает?");
INSERT INTO chat_shutnik VALUES("404","\"Фанта. Вкус апельсина.\" До сих пор не могу понять, что именно дает этот вкус. То ли вода с сахаром и диоксидом углерода, то ли регулятор кислотности и стабилизатор гуммиарабик. А может, изо-бутират ацетат сахарозы с антиоксидантом аскорбиновая кислота? Хотя, вероятнее всего, краситель \"желтый солнечный загар\" с идентичными натуральным ароматизаторами... Нет, наверное, все-таки бензоат натрия!..");
INSERT INTO chat_shutnik VALUES("405","Жена: - Не могли бы мы как-нибудь сходить в кино ? Муж: - Мы же были в кино.\n- Да, но теперь там идут звуковые фильмы...");
INSERT INTO chat_shutnik VALUES("406","Садятся старик со старухой ужинать. Старуха поставила перед стариком сковородку картошки. Он поковырялся вилкой, взял сковородку да как треснет старухе по лбу.\n- Старик, ты одурел, что ли? - Как вспомню что не целкой взял, так аппетит пропадает!!!");
INSERT INTO chat_shutnik VALUES("407","У минетчицы спрашивают: - как дела? - Да вот вот хреново! Всякая пошлятина в голову лезет!");
INSERT INTO chat_shutnik VALUES("408","Выполз уж из ресторана: \"Гав. Неа.. Ку-ка-реку Неа.. Мяу Неа... Шшшш, бля буду, шшшшш!\"");
INSERT INTO chat_shutnik VALUES("409","Леди не захочет, джентльмен не вскочит.");
INSERT INTO chat_shutnik VALUES("410","- Ва-ань, а Ва-ань, ты за ско-олько доходишь от кровати до двери? - Я - за час, а ты за сколько? - За полчаса! - Ну, ты вообще, как метеор!");
INSERT INTO chat_shutnik VALUES("411","Фиpма, пpодающая пилюли для похудения, получила письмо: \"Ваши пилюли бесподобны. За пеpвые две недели моя жена похудела на шесть кг, а вскоpе исчезла вообще.\"");
INSERT INTO chat_shutnik VALUES("412","Врач - пациенту, глядя в историю болезни: - Э-э ,батенька, с сегодняшнего дня бросайте курить - положение серьезное! - Доктор, но я не курю! Не люблю.\n- Да? Тогда ни капли спиртного!! - Но, доктор, я не пью! Не люблю! - Да??... Но что-нибудь вы любите!!?? - Картошку...\n- Так вот! С сегодняшнего дня я вам решительно запрещаю есть картошку!!!");
INSERT INTO chat_shutnik VALUES("413","- Рабинович, говорят, вы большой интриган? - Да, а кто это ценит...");
INSERT INTO chat_shutnik VALUES("414","Социальная реклама Мы yже не pаз обманывали вас. Вы защищали нас осенью -го, мы стpеляли в вас осенью -го. Мы pазвалили вашy стpанy в -м, обокpали в -м, надyли с двyмя Волгами в -м, с помощью МММ-ов pаскpyтили на бабки в -м, посылали ваших детей на бойню в -м, неплохо \"повтоpничали\" в -м, и полностью огpабили в -м. Hо y нас опять кончились деньги. Пожалyйста, заплатите налоги...");
INSERT INTO chat_shutnik VALUES("415","- Дорогой! Наш сосед подарил тебе на день рождения двухрожковую люстру! - Это он на что намекает?!");
INSERT INTO chat_shutnik VALUES("416","Недавно на ж/д переезде № пожарный инспектор Василий М. обнаружил цистерну со спиртом, близкую к самовозгоранию. Лишь к вечеру силами жителей семи окрестных сел риск самовозгорания уменьшился ровно наполовину.");
INSERT INTO chat_shutnik VALUES("417","Молодой фермер, призванный на военную службу, в письме домой написал: \"Эта армейская жизнь - сплошное удовольствие. Можно валяться в постели до пяти часов утра\".");
INSERT INTO chat_shutnik VALUES("418","- Что вы будете делать, сержант Тейер, если запасы воды в вашем взводе окажутся зараженными? - Лучшим выходом было бы перейти на пиво.");
INSERT INTO chat_shutnik VALUES("419","Встречаются две подруги. Одна две недели назад вышла замуж. Вторая любопытствует: - Ну и как тебе семейная жизнь? - Да так себе, ничего. Только вот, представляешь, а Жан-то, оказывается, пьет...\n- Как пьет! Вы же два года были знакомы! И ты не знала? - Так ведь два года все было нормально, но вот вчера он пришел трезвым!");
INSERT INTO chat_shutnik VALUES("420","Почему евреи так популярны у женщин? Потому, что у них есть длинный, большой и толстый... Нет, не то, о чем Вы подумали: длинный - рубль, большой - счет в банке, а толстый - бумажник! Голем");
INSERT INTO chat_shutnik VALUES("421","\"micro soft works for micro soft windows\" означает \"Микро программное обеспечение работает для микро окон программного обеспечения\" (Перевод выполнен ПО Stylus for Windows , в. .)");
INSERT INTO chat_shutnik VALUES("422","Больной вызывает врача в три часа ночи. После осмотра врач задумывается, потом говорит: - Вы составили завещание? - Нет, доктор.\n- Так вызовите, пожалуйста, нотариуса и двух свидетелей.\n- Боже мой, это так серьезно? - Нет, но я не хотел бы быть единственным дураком, которого вы подняли в три часа ночи.");
INSERT INTO chat_shutnik VALUES("423","Ж) - Смотри какие тени длинные, и облака тяжелые... Х) - Длинные - потому что уже поздно, а тяжелые потому что мы уже -й день пьем.");
INSERT INTO chat_shutnik VALUES("424","- Хаим, я слышал - вы женитесь! - Таки-да! - И как вам ваша будущая жена? - Ой, сколько людей, столько и мнений. Маме нравится, мне - нет.");
INSERT INTO chat_shutnik VALUES("425","Племянник разговаривает с Лениным: - Дядя Вова, у тебя такая большая умная голова!? - Да, Витенька, ей я думаю, как людям лучше жить.\n- У тебя такие руки!? - Да, Витенька, ими я указываю людям верную дорогу.\n- А усы тебе зачем? - А чтобы тетю Надю щекотать!");
INSERT INTO chat_shutnik VALUES("426","Один еврей рассказывает: - Представляешь, прихожу домой, а там жена с любовником. А глаза у них хитрые-хитрые... Думаю, что за черт! Бегу прямо к холодильнику, открываю его, так и есть! Всю фаршированную рыбу съели, сволочи!");
INSERT INTO chat_shutnik VALUES("427","Дочка спрашивает у мамы: - Мама, а что такое фаллоимитатор? Мама, немного смутившись, отвечает - Ну, доченька, это прибор, который заменяет мужа. Дочка (с восхищением): - Классно! И он сам по ночам жрет котлеты из холодильника и храпит?");
INSERT INTO chat_shutnik VALUES("428","Встречаются два приятеля: - Говорят, ты женился на девушке, о которой даже не мог и мечтать.\n- Правильно говорят... Неужели ты думаешь, что я мог мечтать о такой стерве?");
INSERT INTO chat_shutnik VALUES("429","Начальник лагеря объявляет: - Сегодня день смены белья. Первый барак меняется со вторым.");
INSERT INTO chat_shutnik VALUES("430","Вышел как-то Брежнев на балкон - на звезды посмотреть. Глянул - а луна-то не красная! Он позвонил кому надо, ему ответили, мол, все ОК, будет сделано! Выходит на следующий день - луна красная, как мак! Ильич лег спать довольным. На следующий день вышел - у луны снизу треугольник белый и надпись черным - Marlboro. Он звонит, ему - будет сделано! Он ложится спать. На следующий день - красная луна, белый треугольник, Мальборо и подпись внизу - \"московская фабрика Дукат\". Ильич ложится довольным. Следующий день. Глянул Брежнев - красная луна, Мальборо, фабрика Дукат, а внизу подпись - по лицензии компании Phillip Morris Ltd. Звонит, ему - будет сделано. Следующий день. Брежнев на балконе. Красная луна, белый треугольник, надпись Marlboro, подпись \"московская фабрика Дукат\", еще подпись \"по лицензии компании Phillip Morris Ltd.\", а внизу крупными буквами - МИНИСТЕРСТВО ОБОРОНЫ СССР ПРЕДУПРЕЖДАЕТ...");
INSERT INTO chat_shutnik VALUES("431","Вовочка пpедлагает Машеньке: - Машка, а давай мы с тобой в семью поигpаем? - А как? - Сначала потp#хаемся - а потом хаpактеpами не сойдёмся!");
INSERT INTO chat_shutnik VALUES("432","После того, как хирург сделал даме пластическую операцию, удалив двойной подбородок и придав носу классическую форму, она попросила, чтобы он расширил ей глаза.\n- Это уже лишнее, - заявил хирург, - у вас глаза станут и без того широкими, когда вы увидите счет за две первые операции.");
INSERT INTO chat_shutnik VALUES("433","Новый русский приходит к дантисту. Садится в кресло, открывает рот и дантист обалдевает: верхняя челюсть платиновая, а нижняя - золотая! Обалдевши дантист спрашивает: - А чем я могу помочь !??? - Как чем? Ты сигнализатцию поставь.");
INSERT INTO chat_shutnik VALUES("434","И настали в России смутные времена - лица кавказской национальности стали проверять прописку у работников милиции, а гаишники давать взятки водителям...");
INSERT INTO chat_shutnik VALUES("435","- Что-нибудь поймали? - интересуется прохожий.\n- Да, - мрачно отвечает рыбак.\n- Поймал одного и бросил в реку.\n- Наверное, маленький был? - Да, ростом примерно с вас и такой же назойливый.");
INSERT INTO chat_shutnik VALUES("436","- Мадам, почему вы уменьшили свой возраст на шесть лет? - Дело в том, что первые шесть лет я не умела считать.");
INSERT INTO chat_shutnik VALUES("437","Ленин с Крупской сидят и пьют чай. Вдруг на лестнице раздался страшный грохот и лязг.\n- Наденька, кажется, в прихожей упал несгораемый шкаф...\n- Нет, Володя, это железный Феликс на перилах катается.");
INSERT INTO chat_shutnik VALUES("438","Вопрос: Почему большинство женщин не может уснуть после оргазма? Ответ: Потому что им нужно еще до дома добираться!");
INSERT INTO chat_shutnik VALUES("439","- Доктор, я после ампутации не чувствую правую ногу.\n- Как же вы, голубчик, хотите ее чувствовать, если она у вас ампутирована?.\n- Так мне же ампутировали левую!");
INSERT INTO chat_shutnik VALUES("440","С завистью про одну знакомую: - Она только что вернулась с черноморского побережья с чудесно загоревшим языком!");
INSERT INTO chat_shutnik VALUES("441","Винни-Пух полез за медом и застрял.\n- Пятачок! Пятачок! Отдери меня! Ну Пятачок и отодрал. Через два дня пошел дождь, Винни-Пух отлип и упал.");
INSERT INTO chat_shutnik VALUES("442","Как пытают Саддама Хусейна? - показывают портрет Мадлен Олбрайт");
INSERT INTO chat_shutnik VALUES("443","У нового рyсского спрашивают: \"За сколько минимyм Вы пробежите метровкy?\" (HР): \"Минимyм за $.\"");
INSERT INTO chat_shutnik VALUES("444","\"Как я учился трахаться\" - руководство по установке \"Windows\"");
INSERT INTO chat_shutnik VALUES("445","Парочка едет на спортивном автомобиле. Она: - Дорогой, не надо ехать так быстро, я боюсь. Он: - А ты закрой глаза, как я.");
INSERT INTO chat_shutnik VALUES("446","Вопpос к аpмянскому pадио: - Женятся ли онанисты? Ответ: - Да. Hа дояpках!");
INSERT INTO chat_shutnik VALUES("447","Солдат стройбата берет пачку \"Беломора\" и по слогам читает: - Минздрав предупреждает...\n- прикурил, затянулся, поглядел мечтательно вдаль и произнес: - Вот же гады, на лопатах-то такое не пишут.");
INSERT INTO chat_shutnik VALUES("448","- Pядовой Петpов - выйти из cтpоя - шагов впеpед! - Pаз, два, тpи... Cемь! Дальше не могy, товаpищ майоp, - стена! - А дальше и не надо! Pота - ПЛИ !!!");
INSERT INTO chat_shutnik VALUES("449","Все хорошо, что хорошо конча...");
INSERT INTO chat_shutnik VALUES("450","Встречаются два друга. Один спрашивает другого: - Ты, я вижу, к Интернету подключился! - Как ты узнал? - По глазам.\n- Стали умнее? - Нет, краснее... (с) АС");
INSERT INTO chat_shutnik VALUES("451","Нынче очень легко стало отличить КТО есть КТО в американской политике. Демократы называют его Кеннет Старр, а Республиканцы уважительно Судья Старр...");
INSERT INTO chat_shutnik VALUES("452","К врачу приходит пациент с полностью черным языком.\n- Что это с вами? - Да вот, пролил водку на свежеуложенный асфальт...");
INSERT INTO chat_shutnik VALUES("453","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("454","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("455","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("456","В кабинет врача входит девушка: - Раздевайтесь, пожалуйста, - говорит ей врач.\n- Зачем?! - вспыхивает девушка.\n- У меня ведь болит ухо! - В таком случае вам не ко мне, - отвечает врач.\n- Я глазник.");
INSERT INTO chat_shutnik VALUES("457","Похороны. Катафалк, после того как на него погрузили гроб, трогается с места. Случайные свидетели наблюдают такую душераздирающую сцену: за катафалком бежит мальчуган лет восьми и рыдает: - Папа, папочка, куда же ты, не оставляй меня, я хочу с тобой!!! Но тут вдруг катафалк останавливается, из кабины выходит шофер и орет мальчику: - А ну марш домой, кому сказал! Не сделаешь уроки к моему приходу - я тебе ремня дам!");
INSERT INTO chat_shutnik VALUES("458","Сдают мужики сперму в больнице. Очередь большая. Вдруг подходит девушка и становится молча в очередь. Пять минут стоит и молчит. Десять. Народ удивляется. Подходит к ней мужик и спрашивает: - А вы что, тоже сперму сдаете ? А она отвечает, не раскрывая рта: - Угу.");
INSERT INTO chat_shutnik VALUES("459","Приходит барышня к гинекологу.\n- Доктор, вы мне вчера спиральку поставили...\n- Да, помню.\n- Но она слишком длинная.\n- Присядьте пока, через минут поменяю. Барышня садится: пау-уау-уау!");
INSERT INTO chat_shutnik VALUES("460","Тяпница (день недели - время выпить)");
INSERT INTO chat_shutnik VALUES("461","Три секретарши в кафе обсуждают своего негодяя-босса.\n- Я вылила пузырек чернил в ящик его письменного стола.\n- А я нашла у него в столе презерватив и проколола его иглой. Третья падает в обморок.");
INSERT INTO chat_shutnik VALUES("462","Чукча приехал домой из Москвы и говорит: - Чукча в Москве был, чукча умным стал, все знает. Оказывается, Карл, Маркс, Фридрих, Энгельс не четыре человека, а два, а Слава КПСС - вообще не человек.");
INSERT INTO chat_shutnik VALUES("463","Если бы люди водили автомобили также, как они работают на компьютерах (разговор по телефону Водителя и Техника из тех. поддержки) Техник: Водительская тех. поддержка. Чем можем помочь? Водитель: Эта... Машина у меня не заводится. Техник: Ясненько. Какая у вашей машины марка, модель, и год выпуска? Водитель: А я... хрен его знает! Я ее купил в магазин ездить, откуда мне знать... Техник: Хорошо-хорошо, успокойтесь. Попробуем обойтись без этой информации... (вздох) У вас есть бензин в баке? Водитель: Гм... Бензин в баке, говоришь... А как я узнаю? Техник: На передней панели посмотрите. Куда стрелка показывает, на \"Е\" или на \"F\"? Водитель: А где передняя панель? Техник: Она находится сразу за рулем если вы сидите в водительском кресле. Водитель: А! Вижу. .. Тэкс... А тут стрелок много, которую из них смотреть? Техник: Смотрите на ту, рядом с которой написано Е или F. Там еще может быть бензоколонка нарисована. Водитель: Ааа! Вижу. Стрелка показывает на ноль. Техник: Как на ноль? Водитель: Ага. Прямо на ноль. А ещ");
INSERT INTO chat_shutnik VALUES("464","- Алло! Это \"секс по-телефону\"? - Да.\n- Значит, так. Hикаких кружевных трусиков, чулочек. Ты - блондинка, толстая, раскрасневшаяся. Абсолютно голая, но в резиновых сапогах. Звать тебя Клава. Hедавно кончилась война, примерно сорок шестой год. Мы - на сеновале. Пахнет конским навозом. Лучик света сквозь дыру в крыше упал на мою спину... Поехали, Клавка!");
INSERT INTO chat_shutnik VALUES("465","Отправляют первого китайца в космос. В напутствие ему говорят: Летишь ты не надолго, но еды мы тебе дадим много - кушай сколько хочешь, а мешочек (для естественных отходов организма) в скафандр пришили небольшой (ну на сутки, зачем большой?)... Приземлятся китайский космонавт. Еда нетронута, а вот мешочек порвался :( (c) Toha, onliner.by");
INSERT INTO chat_shutnik VALUES("466","Разговор мужа и жены: - Слушай, что мы подарим на этот раз моей маме на день рождения ? - А что мы дарили в прошлый раз ? - В прошлый раз мы подарили ей стул.\n- Hу а теперь подведем к нему электричество.");
INSERT INTO chat_shutnik VALUES("467","- Моня, ты что делаешь сегодня вечером? - Да, вроде, ничего.\n- Давай пойдем в клуб \"Кому за тридцать\". Договорились, но Моня не пришел. Встречаются на другой день.\n- Ну чего же ты не пришел? Я так хорошо провел время, там такие женщины...\n- Хаим, а я померил, у меня только двадцать четыре... Ну я и не пошел.");
INSERT INTO chat_shutnik VALUES("468","На еврейском кладбище в Одессе три землекопа присели отдохнуть у трех могил известных людей.\n- Хотел бы я лежать вот здесь, рядом с Рабиновичем, а ты? - говорит один.\n- Нет, я предпочел бы рядом с Абрамовичем.\n- А я предпочел бы прямо сейчас лежать с женой Когана...\n- Так она же жива! - Вот и я про то же!");
INSERT INTO chat_shutnik VALUES("469","Один приятель другому: - Ты знаешь, я когда в командировку последний раз уезжал, в шкафу капкан на медведя оставил. Представляешь - приезжаю и сразу к шкафу бегу, смотрю - сидит красавец! - Кто? Любовник? - Да нет... Медведь!");
INSERT INTO chat_shutnik VALUES("470","Явлинский-Болдырев-Лукин - ЯБЛоко. Немцов-Хакамада-Чубайс - НеХаЧу. Коалиция: \"НЕХАЧУ ЯБЛОКО\". &copy; Хрюн");
INSERT INTO chat_shutnik VALUES("471","- У этой пьесы был счастливый конец? - Конечно, все были так рады, что она закончилась.");
INSERT INTO chat_shutnik VALUES("472","Как называется человек, который не дарит подарков своей любовнице? Ответ: Дармоёб");
INSERT INTO chat_shutnik VALUES("473","- Доктоp, я пеpестала получать удовольствие от колбасы.\n- А что вы с ней, пpостите, делаете? - Я ее ем...");
INSERT INTO chat_shutnik VALUES("474","Пришел муж домой, уставший с работы. Поел и лег с женой спать. Всю ночь жена ластится к нему и так, и сяк, а он ворчит: - Отстань, Машка, у меня еще колосок не созрел... Спать хочу! На следующую ночь повторяется то же самое. На третью ночь муж начал сам к ней ластиться - и так, и сяк. А она ему отвечает: - Чё пристал? - Колосок-то созрел, - отвечает муж.\n- Ну вот еще, - ворчит жена, - буду из-за одного колоска весь комбайн заводить!");
INSERT INTO chat_shutnik VALUES("475","Два часа ночи. Звонок в дверь. Жена открывает дверь и... тело мужа падает в коридор.\n- Свинья! Ну что за радость каждый раз напиваться до полусмерти..!? - Прасти, драгая, ккак вседа денег неххватило....!!!");
INSERT INTO chat_shutnik VALUES("476","Заходит мужик в аптеку. М. У вас бананы есть? А. Нет. Здесь дорогой аптека и бананов не бывает. а следующий день снова он же заходит в аптеку. М. У вас Бананы есть? А. Да нет же здесь аптека здесь лекарства разные банки и т.д. Так повторяется в течении пяти дней, заебанный аптекарь на большом ватмане крупными буквами пишет объявление \"БАНАНОВ НЕТ! \" Заходит тот же мужчина, внимательно читает объявление, Подходит к Аптекарю и с обидой говорит \"А значит были бананы!\"");
INSERT INTO chat_shutnik VALUES("477","Дерется Чебурашка с Кощеем Бессмертным. Кощей говорит: - Все равно ты меня не убьешь. У меня смерть в яйце. Последовал удар.\n- У... да не в том!!!");
INSERT INTO chat_shutnik VALUES("478","В роддоме. Из операционной выходит молоденькая медсестра и говорит мужчине, ждущему результатов родов своей жены: - Поздравляю вас! У вас родился сын с шестью кулачками. Мужик побледнел и чуть не упал в обморок. А медсестра, хохоча: - Обманули дурачка на четыре кулачка!");
INSERT INTO chat_shutnik VALUES("479","Двое охранителей купили Мерседесы. И сразу же возник вопрос: дескать, как мы эти Мерседесы отличать будем? Вот один и говорит: - Послушай, давай разобьем у твоего левую фару, а у моего - правую. Так и будем отличать... Другой согласился. Так и сделали. Второй посмотрел-посмотрел и спрашивает: - Послушай, братан. Фары-то мы разбили, а ты помнишь, какая фара у твоей разбита - правая или левая? - Не-а.\n- Давай разобьем и другую фару. Разбили обе фары обеих машин, сидят и смотрят...\n- Послушай, братан, а ведь опять машины не отличишь.У обеих обе фары разбиты! - Ну, слушай, надоело с этими Мерседесами цацкаться. Ты бери черную, а мне таки-да достанется белая.");
INSERT INTO chat_shutnik VALUES("480","- Эй мужик, ты пиво будешь? - Буду, конечно! - Когда будешь, то меня позови...");
INSERT INTO chat_shutnik VALUES("481","Осмотрев кран, сантехник говорит девушке - хозяйке квартиры: - А прокладку-то вам пора менять! Девушка, смущенно покраснев, бормочет: - А вы-то откуда знаете?");
INSERT INTO chat_shutnik VALUES("482","Приходит Вовочка из школы и говорит отцу: - Мне двойку по биологии поставили. Папаша: - За что? - Да спросили у кого самые большие яйца.\n- Ну а ты? - Я сказал у верблюда.\n- Правильно, а учительница? - А она говорит что у страуса. Отец (задумчиво): - У Страуса ... так вот он почему такие медленные вальсы писал.");
INSERT INTO chat_shutnik VALUES("483","Когда АбрамОвич родился, АбрАмович три дня плакал...");
INSERT INTO chat_shutnik VALUES("484","Приходит женщина к врачу: - Доктор, я хотела бы подправить форму одной груди. А то они у меня не одинаковые.\n- Ну показывайте.\n- Вот эта (вытаскивает) нормальная.\n- Вполне.\n- А вот эта (вытаскивает, грудь пля-ф-ф-ф-ф на пол) видите, какая? Доктор чешет в затылке: - Да, такое я в первый раз вижу.\n- Это, наверно, из-за моего мужа. Он, понимаете, не может заснуть, если за мою грудь не держится.\n- Ну что вы такое рассказываете? Я вам признаюсь, у меня самого есть такая маленькая мания, но у моей супруги грудь нормальная.\n- Так вы, наверно, доктор, с женой в одной комнате спите?");
INSERT INTO chat_shutnik VALUES("485","В нью-йоркском отеле вывешено объявление: \"Гасите сигареты! Помните о пожаре в Чикаго!\" Под этим объявлением кто-то подписал: \"Hе плюйте на пол, помните о весенних разливах Миссисипи!\"");
INSERT INTO chat_shutnik VALUES("486","По дороге на мопеде ехал \"голубой\". Ну и заглох его мопед. Встал он на обочине, пригорюнился. Тут к нему на \"Мерседесе\" подъезжает \"крутой\" и небрежно так открывая окно спрашивает: - Ну что, мужик, толкнем твое говно? Педик (с радостью в голосе): - Конечно, толкнем!! А потом и мопед починим!!");
INSERT INTO chat_shutnik VALUES("487","Мужик, недавно купивший себе \"Феppаpи\", несется на этой машине с огpомной скоpостью, наслаждаясь мощью двигателя. Вдpуг он видит табличку: \"Сбавь скоpость - км\". Мужик думает: \"Можно ведь было пpосто установить соответствующий запpещающий знак. А pаз они этого не сделали, значит, тут что-то сеpьезное и скоpость действительно надо сбавить\". Сбавляет он скоpость до км/ч - и чеpез некотоpое вpемя видит еще одну табличку: \"Сбавь скоpость - км\". Он и на этот pаз сбавляет скоpость до км/ч, хоть и с большой неохотой. Чеpез полчаса - опять табличка: \"Сбавь скоpость км\". Пpоклиная все на свете, он замедляется до км/ч. А еще чеpез час он видит такую вывеску: \"Добpо пожаловать в пpидоpожный pестоpан \"Сбавь скоpость!\"\"");
INSERT INTO chat_shutnik VALUES("488","В испанском публичном доме \"мадам\" кричит: - Донна Мария, дон Педро все еще на вас? - Да.\n- Не давайте ему кончить, он заплатил фальшивыми купюрами.");
INSERT INTO chat_shutnik VALUES("489","Пришел мужчина на пляж. Снимает майку - вся спина искусана. Народ: - Мужик, что у тебя со спиной-то?! Мужик, отмахиваясь: - Да вчера тут голубого трахал, дык всю спину изгрыз, зараза!");
INSERT INTO chat_shutnik VALUES("490","Мужик приходит в фирму по объявлению \"Требуется менеджер\". Показывает боссу свои дипломы - финансовый институт, школа управления, курсы менеджмента и т.п. Босс: - Это хорошо. Мне нужен сообразительный управленец. Он должен взять на себя главный наш больной вопрос - финансы. Кандидат: - С моим образованием это без проблем. А как насчет заработка? - Ну, вы начинающий, предполагаю вам пока положить $.\n- Да? Но откуда же ваша маленькая фирма берет средства, чтобы платить такие деньги? - Вот. Вот это первый вопрос, который вам предстоит решить.");
INSERT INTO chat_shutnik VALUES("491","Когда мужчины спрашивали ее о возрасте, она кокетливо смеялась и отвечала, что женщине столько лет, на сколько она выглядит. Некоторые ей верили и имели большие проблемы - паршивке еще не было -ти.");
INSERT INTO chat_shutnik VALUES("492","И волки сыты, и овцы целы. Светлая память пастуху!");
INSERT INTO chat_shutnik VALUES("493","\"Все зло от Б.А.Б.!\" В.В.П.");
INSERT INTO chat_shutnik VALUES("494","Заяц отслужил на флоте и возвращается домой. Идет по лесу, поет песню: - На побывку едет молодой моряк! В кустах его поджидает Волк, который тоже служил на флоте, и тоже тихонько напевает: - Напрасно старушка ждет сына домой!");
INSERT INTO chat_shutnik VALUES("495","В бане два маленьких мальчика увидели голого мужчину с большим животом. Спрашивают его: - Дядя, а что у тебя в животе? - Бомба. Один тихо говорит другому: - Давай взорвем ее.\n- Опасно очень короткий фитиль.");
INSERT INTO chat_shutnik VALUES("496","Два бpаконьеpа: - Вчеpа поймал огpомного осетpа. Закинyл его на спинy и идy домой.\n- Hy? - А тyт из-за кyстов - инспектоp pыбнадзоpа! - Hy?! - А я осетpа со спины - и в каpман!");
INSERT INTO chat_shutnik VALUES("497","- Твоя собака, сосед, укусила мою жену за ногу. Придется тебе заплатить штраф.\n- За то, что может быть возмещено,- отвечает Насреддин,- нельзя требовать выкупа. Пришли свою собаку, пусть она укусит за ногу мою жену. И мы в расчете!");
INSERT INTO chat_shutnik VALUES("498","Ползут по пустыне два унитаза. Один говорит другому: - Ген, а Ген ! Давай приколупаемся к той черепахе ! - Hе надо, Чебурашка, Мы уже к старику Хотабычу приколупались !");
INSERT INTO chat_shutnik VALUES("499","У Моллы был длиннорогий бык. Целые дни и ночи Молла думал: как бы хоть раз сесть быку на голову, между рогами. Но удачного случая не представлялось. Однажды ночью Молла вышел во двор и видит: бык лежит на земле, пережевывая свою жвачку. Вот подходящий момент! -подумал Молла. Подобрав полы своей чохи, он вскочил быку на голову и уселся между рогами. Бык, испугавшись, вскочил и, мотнув головой, сбросил Моллу на землю. Молла закричал и упал в обморок. Услышав крик Моллы, жена его выбежала из дому и видит: муж ее лежит в крови, без сознания. Она подняла крик. Сбежался народ. Моллу привели в чувство. Оказалось, он сломал ногу. Его подняли, внесли в дом и уложили в постель. Молла огляделся по сторонам и заметил, что жена плачет. Он поднял голову и сказал ей: - Жена, не плачь. Хотя я упал и разбился, но зато желание мое исполнилось.");
INSERT INTO chat_shutnik VALUES("500","Идет мужик пьяный, смотрит - лужа, а в луже луна отражается.\n- У, сейчас на луне покатаюсь. Сел на нее и сидит. Идет милиционер, увидел мужика и спрашивает: - Эй, мужик, ты что тут делаешь? - На луне сижу.\n- Ну сиди, сиди, сейчас луноход подойдет.");



DROP TABLE IF EXISTS `chat_vopros`;

CREATE TABLE `chat_vopros` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `vopros` varchar(1024) NOT NULL,
  `otvet` varchar(32) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=502 DEFAULT CHARSET=utf8;

INSERT INTO chat_vopros VALUES("2","Сильная жара.","зной");
INSERT INTO chat_vopros VALUES("3","Пояс, территория с какими-либо общими признаками.","зона");
INSERT INTO chat_vopros VALUES("4","Медицинский инструмент для исследования внутренностей организма.","зонд");
INSERT INTO chat_vopros VALUES("5","Метеорологический воздушный шар.","зонд");
INSERT INTO chat_vopros VALUES("6","Крупный дикий лесной бык.","зубр");
INSERT INTO chat_vopros VALUES("7","Легкая рябь на водной поверхности.","зыбь");
INSERT INTO chat_vopros VALUES("8","Южный ветер, юг.","зюйд");
INSERT INTO chat_vopros VALUES("9","Поле, вспаханное с осени для посева яровых.","зябь");
INSERT INTO chat_vopros VALUES("10","Мысль, намерение, план.","идея");
INSERT INTO chat_vopros VALUES("11","Язык части евреев.","идиш");
INSERT INTO chat_vopros VALUES("12","Статуя, предмет, которому поклоняются как божеству.","идол");
INSERT INTO chat_vopros VALUES("13","Сушеные ягоды винограда.","изюм");
INSERT INTO chat_vopros VALUES("14","Жестокий древнеиудейский царь.","ирод");
INSERT INTO chat_vopros VALUES("15","Помесь лошади и осла.","ишак");
INSERT INTO chat_vopros VALUES("16","Осел или мул.","ишак");
INSERT INTO chat_vopros VALUES("17","Невысокая упрямая лошадь.","осел");
INSERT INTO chat_vopros VALUES("18","Исторически сложившаяся группа человечества с общими наследственными признаками.","раса");
INSERT INTO chat_vopros VALUES("19","Буква греческого алфавита.","йота");
INSERT INTO chat_vopros VALUES("20","Ледяная корка на снегу.","наст");
INSERT INTO chat_vopros VALUES("21","Представитель черной расы.","негр");
INSERT INTO chat_vopros VALUES("22","Углубление в стене, скате горы, берега.","ниша");
INSERT INTO chat_vopros VALUES("23","Число, деление на которое невозможно.","нуль");
INSERT INTO chat_vopros VALUES("24","В древнегреческой мифологии богиня победы.","ника");
INSERT INTO chat_vopros VALUES("25","Женское имя (греч. победительница).","ника");
INSERT INTO chat_vopros VALUES("26","Зазор между сопряженными поверхностями частей машин.","люфт");
INSERT INTO chat_vopros VALUES("27","Единица освещенности.","люкс");
INSERT INTO chat_vopros VALUES("28","Лучший номер в гостинице.","люкс");
INSERT INTO chat_vopros VALUES("29","Внутренняя часть коры липы, ивы.","лыко");
INSERT INTO chat_vopros VALUES("30","Материал для плетения лаптей.","лыко");
INSERT INTO chat_vopros VALUES("31","Буддийский монах.","лама");
INSERT INTO chat_vopros VALUES("32","Южноамериканское вьючное животное.","лама");
INSERT INTO chat_vopros VALUES("33","Южное вечнозеленое душистое растение, листья которого употребляются как специя.","лавр");
INSERT INTO chat_vopros VALUES("34","Стройное быстрое животное сем. оленей.","лань");
INSERT INTO chat_vopros VALUES("35","Ребро чеканной монеты.","гурт");
INSERT INTO chat_vopros VALUES("36","Стадо домашних животных.","гурт");
INSERT INTO chat_vopros VALUES("37","Духовный наставник, учитель.","гуру");
INSERT INTO chat_vopros VALUES("38","Туго натянутая веревка на судне, предохраняющая от падения людей за борт.","леер");
INSERT INTO chat_vopros VALUES("39","Ограждение вдоль бортов судна.","леер");
INSERT INTO chat_vopros VALUES("40","Край диска звезды, планеты.","лимб");
INSERT INTO chat_vopros VALUES("41","Кольцо с делениями для отсчета углов в угломерных инструментах.","лимб");
INSERT INTO chat_vopros VALUES("42","Пеньковый трос для корабельных снастей.","линь");
INSERT INTO chat_vopros VALUES("43","Пресноводная рыба сем. карповых с толстым слизистым телом.","линь");
INSERT INTO chat_vopros VALUES("44","Медоносное лиственное дерево.","липа");
INSERT INTO chat_vopros VALUES("45","Старинный струнный музыкальный инструмент.","лира");
INSERT INTO chat_vopros VALUES("46","Созвездие Северного полушария.","лира");
INSERT INTO chat_vopros VALUES("47","Денежная единица Италии, Турции.","лира");
INSERT INTO chat_vopros VALUES("48","Хитрая хищница с пушистым хвостом.","лиса");
INSERT INTO chat_vopros VALUES("49","Венгерский композитор, дирижер, создатель нового направления в пианизме, симфонии \"Орфей\", \"Прометей\".","лист");
INSERT INTO chat_vopros VALUES("50","Часть кроны дерева.","лист");
INSERT INTO chat_vopros VALUES("51","Метрическая единица объема.","литр");
INSERT INTO chat_vopros VALUES("52","Подъемник с кабиной для перемещения грузов, людей.","лифт");
INSERT INTO chat_vopros VALUES("53","Неправда, обман.","ложь");
INSERT INTO chat_vopros VALUES("54","Высший дворянский наследственный титул в Англии.","лорд");
INSERT INTO chat_vopros VALUES("55","Попугай, питающийся нектаром.","лори");
INSERT INTO chat_vopros VALUES("56","Самый крупный олень.","лось");
INSERT INTO chat_vopros VALUES("57","Крупный олень с широкими рогами.","лось");
INSERT INTO chat_vopros VALUES("58","Сохатый.","лось");
INSERT INTO chat_vopros VALUES("59","Ямка с водой.","лужа");
INSERT INTO chat_vopros VALUES("60","Корзинка бильярдного стола.","луза");
INSERT INTO chat_vopros VALUES("61","Увеличительное стекло.","лупа");
INSERT INTO chat_vopros VALUES("62","Наружное лекарство.","мазь");
INSERT INTO chat_vopros VALUES("63","Состав для натирания различных участков тела.","мазь");
INSERT INTO chat_vopros VALUES("64","Французский художник-импрессионист, картины \"Завтрак на траве\", \"Олимпия\".","мане");
INSERT INTO chat_vopros VALUES("65","Планета Солнечной системы.","марс");
INSERT INTO chat_vopros VALUES("66","В древнеримской мифологии бог войны.","марс");
INSERT INTO chat_vopros VALUES("67","Площадка на верху мачты для наблюдения над горизонтом.","марс");
INSERT INTO chat_vopros VALUES("68","Выдающаяся французская эстрадная певица.","пиаф");
INSERT INTO chat_vopros VALUES("69","Пресная сухая лепешка у евреев.","маца");
INSERT INTO chat_vopros VALUES("70","Береговой ориентир для судов.","маяк");
INSERT INTO chat_vopros VALUES("71","Непрозрачность воздуха из-за пыли, дыма, метели, сумерек.","мгла");
INSERT INTO chat_vopros VALUES("72","Ночной сумрак.","мгла");
INSERT INTO chat_vopros VALUES("73","Спортивное состязание.","матч");
INSERT INTO chat_vopros VALUES("74","Ковкий химический элемент красновато-желтого цвета.","медь");
INSERT INTO chat_vopros VALUES("75","Граница земельных участков.","межа");
INSERT INTO chat_vopros VALUES("76","Основная единица длины.","метр");
INSERT INTO chat_vopros VALUES("77","Английская морская единица длины = 1,852 км.","миля");
INSERT INTO chat_vopros VALUES("78","Английская единица длины = 1,60934 км.","миля");
INSERT INTO chat_vopros VALUES("79","Непрочная, быстропроходящая популярность.","мода");
INSERT INTO chat_vopros VALUES("80","Бабочка, вредитель вещей.","моль");
INSERT INTO chat_vopros VALUES("81","Единица количества вещества.","моль");
INSERT INTO chat_vopros VALUES("82","Французский художник-импрессионист, картина \"Кувшинки\".","моне");
INSERT INTO chat_vopros VALUES("83","Английский писатель, мастер новеллы, роман \"Луна и грош\".","моэм");
INSERT INTO chat_vopros VALUES("84","Плотная шелковая ткань, переливающаяся на свету.","муар");
INSERT INTO chat_vopros VALUES("85","В греческой мифологии одна из девяти муз, покровительница истории.","клио");
INSERT INTO chat_vopros VALUES("86","Надоедливое двукрылое насекомое.","муха");
INSERT INTO chat_vopros VALUES("87","Созвездие Южного полушария.","муха");
INSERT INTO chat_vopros VALUES("88","Моющее средство.","мыло");
INSERT INTO chat_vopros VALUES("89","Грызун, вредитель сельского хозяйства.","мышь");
INSERT INTO chat_vopros VALUES("90","Периферийное устройство компьютера.","мышь");
INSERT INTO chat_vopros VALUES("91","Нестабильная заряженная элементарная частица.","мюон");
INSERT INTO chat_vopros VALUES("92","Часть туши убитого животного, употребляемая в пищу.","мясо");
INSERT INTO chat_vopros VALUES("93","Основной источник белка в питании человека.","мясо");
INSERT INTO chat_vopros VALUES("94","Душистое лекарственное растение.","мята");
INSERT INTO chat_vopros VALUES("95","Выпуклая замкнутая плоская кривая без изломов.","овал");
INSERT INTO chat_vopros VALUES("96","Зодиакальное созвездие (март).","овен");
INSERT INTO chat_vopros VALUES("97","Домашнее жвачное животное.","овца");
INSERT INTO chat_vopros VALUES("98","Полевое земляное укрытие личного состава.","окоп");
INSERT INTO chat_vopros VALUES("99","Государство на Аравийском полуострове.","оман");
INSERT INTO chat_vopros VALUES("100","Буква греческого алфавита.","бета");
INSERT INTO chat_vopros VALUES("101","Областной центр, порт на реке Иртыш.","омск");
INSERT INTO chat_vopros VALUES("102","Аморфный драгоценный камень.","опал");
INSERT INTO chat_vopros VALUES("103","Накопленные знания и навыки.","опыт");
INSERT INTO chat_vopros VALUES("104","Научный эксперимент.","опыт");
INSERT INTO chat_vopros VALUES("105","Плод в скорлупе.","орех");
INSERT INTO chat_vopros VALUES("106","Роман Войнич .","овод");
INSERT INTO chat_vopros VALUES("107","Двукрылое насекомое, личинки которого паразитируют в теле животных.","овод");
INSERT INTO chat_vopros VALUES("108","Трудноискоренимый сорняк.","осот");
INSERT INTO chat_vopros VALUES("109","Крупная сорная колючая трава.","осот");
INSERT INTO chat_vopros VALUES("110","Способность воспринимать звуковые колебания.","слух");
INSERT INTO chat_vopros VALUES("111","Прибор для коррекции зрения.","очки");
INSERT INTO chat_vopros VALUES("112","Американские авиаконструкторы, братья, пионеры авиации.","райт");
INSERT INTO chat_vopros VALUES("113","Звание, чин.","ранг");
INSERT INTO chat_vopros VALUES("114","Кровососущее насекомое, паразит.","клоп");
INSERT INTO chat_vopros VALUES("115","Пьеса В.Маяковского .","клоп");
INSERT INTO chat_vopros VALUES("116","Связанные между собой плавучие предметы для перевозки грузов, людей.","плот");
INSERT INTO chat_vopros VALUES("117","Скрепленные между собой бревна для переправы.","плот");
INSERT INTO chat_vopros VALUES("118","Маршрут в один конец.","рейс");
INSERT INTO chat_vopros VALUES("119","Большой водный поток, текущий в русле.","река");
INSERT INTO chat_vopros VALUES("120","Порода короткошерстных кроликов.","рекс");
INSERT INTO chat_vopros VALUES("121","Способность человека говорить.","речь");
INSERT INTO chat_vopros VALUES("122","Металлический оклад на иконе.","риза");
INSERT INTO chat_vopros VALUES("123","Темп, скорость музыки.","ритм");
INSERT INTO chat_vopros VALUES("124","Твердые выросты на голове копытных животных.","рога");
INSERT INTO chat_vopros VALUES("125","Яровой злак.","рожь");
INSERT INTO chat_vopros VALUES("126","Декоративный душистый цветок с шипами на стебле.","роза");
INSERT INTO chat_vopros VALUES("127","Воплощенный актером образ.","роль");
INSERT INTO chat_vopros VALUES("128","Параллелограмм с равными сторонами.","ромб");
INSERT INTO chat_vopros VALUES("129","Река в Швейцарии и Франции.","рона");
INSERT INTO chat_vopros VALUES("130","Конденсат на почве, траве.","роса");
INSERT INTO chat_vopros VALUES("131","Английские полярные исследователи, дядя и племянник.","росс");
INSERT INTO chat_vopros VALUES("132","Японская национальная борьба.","сумо");
INSERT INTO chat_vopros VALUES("133","Небольшой лесной массив лиственных деревьев.","роща");
INSERT INTO chat_vopros VALUES("134","Минеральное полезное ископаемое, горная порода.","руда");
INSERT INTO chat_vopros VALUES("135","Поворотное устройство машин, судов.","руль");
INSERT INTO chat_vopros VALUES("136","Состриженная сплошным пластом шерсть овцы.","руно");
INSERT INTO chat_vopros VALUES("137","Водное позвоночное.","рыба");
INSERT INTO chat_vopros VALUES("138","Зодиакальное созвездие (февраль).","рыбы");
INSERT INTO chat_vopros VALUES("139","Способ бега лошади.","рысь");
INSERT INTO chat_vopros VALUES("140","Хищник с кисточками на ушах.","рысь");
INSERT INTO chat_vopros VALUES("141","Созвездие Северного полушария.","рысь");
INSERT INTO chat_vopros VALUES("142","Государство в Южной Америке.","перу");
INSERT INTO chat_vopros VALUES("143","Сладкая вязкая масса с орехами.","нуга");
INSERT INTO chat_vopros VALUES("144","Санитарка в лечебном учреждении.","няня");
INSERT INTO chat_vopros VALUES("145","Работница по уходу за детьми.","няня");
INSERT INTO chat_vopros VALUES("146","Тюремная кровать.","нары");
INSERT INTO chat_vopros VALUES("147","Немецкий писатель, мыслитель и естествоиспытатель, трагедия \"Фауст\".","гете");
INSERT INTO chat_vopros VALUES("148","Французский писатель, роман \"Отверженные\".","гюго");
INSERT INTO chat_vopros VALUES("149","Широкие массы населения.","низы");
INSERT INTO chat_vopros VALUES("150","Нижняя конечность человека.","нога");
INSERT INTO chat_vopros VALUES("151","Северный ветер, север.","норд");
INSERT INTO chat_vopros VALUES("152","Западный ветер, запад.","вест");
INSERT INTO chat_vopros VALUES("153","То же, что характер.","нрав");
INSERT INTO chat_vopros VALUES("154","Прием пищи в середине дня.","обед");
INSERT INTO chat_vopros VALUES("155","Резкий толчок.","удар");
INSERT INTO chat_vopros VALUES("156","Административно-территориальная единица в составе губернии в дореволюционной России.","уезд");
INSERT INTO chat_vopros VALUES("157","Чувство сильного страха.","ужас");
INSERT INTO chat_vopros VALUES("158","Вечерняя еда.","ужин");
INSERT INTO chat_vopros VALUES("159","Часть сбруи.","узда");
INSERT INTO chat_vopros VALUES("160","Постановление верховного органа власти, имеющее силу закона.","указ");
INSERT INTO chat_vopros VALUES("161","То же, что инъекция.","укол");
INSERT INTO chat_vopros VALUES("162","Упрек, порицание.","укор");
INSERT INTO chat_vopros VALUES("163","Военнослужащий легкой кавалерии в русской армии.","улан");
INSERT INTO chat_vopros VALUES("164","Количество пойманной рыбы, дичи.","улов");
INSERT INTO chat_vopros VALUES("165","Селение в Средней Азии и некоторых районах Сибири.","улус");
INSERT INTO chat_vopros VALUES("166","Белый медведь.","умка");
INSERT INTO chat_vopros VALUES("167","Учебный час в школе.","урок");
INSERT INTO chat_vopros VALUES("168","Сушеные абрикосы с косточками.","урюк");
INSERT INTO chat_vopros VALUES("169","Ложный слух.","утка");
INSERT INTO chat_vopros VALUES("170","Водоплавающая птица.","утка");
INSERT INTO chat_vopros VALUES("171","Начало дня.","утро");
INSERT INTO chat_vopros VALUES("172","Прибор для глаженья.","утюг");
INSERT INTO chat_vopros VALUES("173","Регистрация наличия чего-либо.","учет");
INSERT INTO chat_vopros VALUES("174","Небольшая кадка.","ушат");
INSERT INTO chat_vopros VALUES("175","В греческой мифологии царица богов, жена Зевса.","гера");
INSERT INTO chat_vopros VALUES("176","У мусульман человек иной веры.","гяур");
INSERT INTO chat_vopros VALUES("177","В старину налог с побежденных.","дань");
INSERT INTO chat_vopros VALUES("178","Календарное время какого-либо события.","дата");
INSERT INTO chat_vopros VALUES("179","Загородный участок с летним домом.","дача");
INSERT INTO chat_vopros VALUES("180","Здание, сооружение для ж/д подвижного состава.","депо");
INSERT INTO chat_vopros VALUES("181","Заросший травой верхний слой почвы.","дерн");
INSERT INTO chat_vopros VALUES("182","Волокнистое растение для изготовления, веревок канатов.","джут");
INSERT INTO chat_vopros VALUES("183","Укрепленная оборонительная огневая точка.","дзот");
INSERT INTO chat_vopros VALUES("184","Взятое взаймы.","долг");
INSERT INTO chat_vopros VALUES("185","Денежная единица Вьетнама.","донг");
INSERT INTO chat_vopros VALUES("186","Тяжелая плотная шерстяная ткань.","драп");
INSERT INTO chat_vopros VALUES("187","Близкий, верный товарищ.","друг");
INSERT INTO chat_vopros VALUES("188","Часть кривой линии.","дуга");
INSERT INTO chat_vopros VALUES("189","Часть окружности.","дуга");
INSERT INTO chat_vopros VALUES("190","Ствол огнестрельного оружия.","дуло");
INSERT INTO chat_vopros VALUES("191","Сорт небольших груш.","дуля");
INSERT INTO chat_vopros VALUES("192","Мысль, размышление.","дума");
INSERT INTO chat_vopros VALUES("193","Музыкальное произведение для двух исполнителей.","дуэт");
INSERT INTO chat_vopros VALUES("194","Старинное орудие пытки, на котором истязуемого растягивали.","дыба");
INSERT INTO chat_vopros VALUES("195","Бахчевая культура.","дыня");
INSERT INTO chat_vopros VALUES("196","Низший служитель в православной церкви.","дьяк");
INSERT INTO chat_vopros VALUES("197","Английская единица длины = 2,54 см.","дюйм");
INSERT INTO chat_vopros VALUES("198","Английская единица длины = 1/12 фута.","дюйм");
INSERT INTO chat_vopros VALUES("199","Полярная морская птица с ценным пухом.","гага");
INSERT INTO chat_vopros VALUES("200","Полярная утка.","гага");
INSERT INTO chat_vopros VALUES("201","Выжженное место в лесу.","гарь");
INSERT INTO chat_vopros VALUES("202","В греческой мифологии богиня вечной юности, супруга Геракла.","геба");
INSERT INTO chat_vopros VALUES("203","Студенистое вещество.","гель");
INSERT INTO chat_vopros VALUES("204","В западноевропейской мифологии карлик, охраняющий подземные сокровища.","гном");
INSERT INTO chat_vopros VALUES("205","Старая мера аптекарского веса = 62,21 мг.","гран");
INSERT INTO chat_vopros VALUES("206","Крупная хищная птица, питающаяся падалью.","гриф");
INSERT INTO chat_vopros VALUES("207","Часть музыкального инструмента, над которой натянуты струны.","гриф");
INSERT INTO chat_vopros VALUES("208","Сладкий разбавленный горячий напиток из рома или коньяка.","грог");
INSERT INTO chat_vopros VALUES("209","Старинная медная монета в полкопейки.","грош");
INSERT INTO chat_vopros VALUES("210","Очень подвижная рыбка.","вьюн");
INSERT INTO chat_vopros VALUES("211","Поклажа для перевозки на спине животных.","вьюк");
INSERT INTO chat_vopros VALUES("212","Сплетение нескольких букв в один сложный знак.","вязь");
INSERT INTO chat_vopros VALUES("213","Вспомогательный якорь на судне.","верп");
INSERT INTO chat_vopros VALUES("214","Древнегреческие счеты.","абак");
INSERT INTO chat_vopros VALUES("215","Монгольский крестьянин-скотовод.","арат");
INSERT INTO chat_vopros VALUES("216","Испанский гротескный живописец, гравер.","гойя");
INSERT INTO chat_vopros VALUES("217","Раскраска, оформление лица.","грим");
INSERT INTO chat_vopros VALUES("218","Тяжесть, тяжелый предмет.","груз");
INSERT INTO chat_vopros VALUES("219","Игральная карта.","дама");
INSERT INTO chat_vopros VALUES("220","Дерево с твердой древесиной сем. березовых.","граб");
INSERT INTO chat_vopros VALUES("221","Норвежский композитор, пианист, дирижер, сюита \"Пер Гюнт\".","григ");
INSERT INTO chat_vopros VALUES("222","Русский советский писатель, повесть \"Алые паруса\".","грин");
INSERT INTO chat_vopros VALUES("223","Действительное происшествие в прошлом.","быль");
INSERT INTO chat_vopros VALUES("224","Правдивая история.","быль");
INSERT INTO chat_vopros VALUES("225","Большие весы для тяжелых предметов.","вага");
INSERT INTO chat_vopros VALUES("226","Листья папоротников.","вайя");
INSERT INTO chat_vopros VALUES("227","Общее собрание горожан на Руси.","вече");
INSERT INTO chat_vopros VALUES("228","Индийский струнный щипковый музыкальный инструмент из сушеной тыквы.","вина");
INSERT INTO chat_vopros VALUES("229","Проступок, преступление.","вина");
INSERT INTO chat_vopros VALUES("230","Карточная игра.","вист");
INSERT INTO chat_vopros VALUES("231","Самая распространенная на земле жидкость.","вода");
INSERT INTO chat_vopros VALUES("232","Растаявший лед.","вода");
INSERT INTO chat_vopros VALUES("233","Короткий густой пушок на ткани.","ворс");
INSERT INTO chat_vopros VALUES("234","Материал для постройки пчелиных сот.","воск");
INSERT INTO chat_vopros VALUES("235","Путешествие, поездка.","вояж");
INSERT INTO chat_vopros VALUES("236","Ночная болотная птица.","выпь");
INSERT INTO chat_vopros VALUES("237","Небесная даль.","высь");
INSERT INTO chat_vopros VALUES("238","Французский композитор, опера \"Ромео и Джульетта\".","гуно");
INSERT INTO chat_vopros VALUES("239","Правый приток Амударьи.","вахш");
INSERT INTO chat_vopros VALUES("240","Приданое жены.","вено");
INSERT INTO chat_vopros VALUES("241","Французский математик, разработчик элементарной алгебры.","виет");
INSERT INTO chat_vopros VALUES("242","Приятная расслабленность.","кайф");
INSERT INTO chat_vopros VALUES("243","Боевое построение пехоты четырехугольником.","каре");
INSERT INTO chat_vopros VALUES("244","Столица Египта.","каир");
INSERT INTO chat_vopros VALUES("245","Порт во Франции.","кале");
INSERT INTO chat_vopros VALUES("246","Пресноводная рыба, одомашненный сазан.","карп");
INSERT INTO chat_vopros VALUES("247","Гоночный микролитражный автомобиль без кузова.","карт");
INSERT INTO chat_vopros VALUES("248","Спортивные матерчатые ботинки на резиновой подошве.","кеды");
INSERT INTO chat_vopros VALUES("249","Образец породы из скважины при бурении.","керн");
INSERT INTO chat_vopros VALUES("250","Женщина, которой Пушкин посвятил \"Я помню чудное мгновенье...\".","керн");
INSERT INTO chat_vopros VALUES("251","Дальневосточная лососевая рыба.","кета");
INSERT INTO chat_vopros VALUES("252","Ароматный и сочный тропический фрукт.","киви");
INSERT INTO chat_vopros VALUES("253","Субтропический ароматный и сочный плод.","киви");
INSERT INTO chat_vopros VALUES("254","Новозеландская бескрылая птица.","киви");
INSERT INTO chat_vopros VALUES("255","Балка днища судна от носа до кормы.","киль");
INSERT INTO chat_vopros VALUES("256","Часть хвостового оперения самолета, ракеты.","киль");
INSERT INTO chat_vopros VALUES("257","Созвездие Южного полушария.","киль");
INSERT INTO chat_vopros VALUES("258","То же, что фильм.","кино");
INSERT INTO chat_vopros VALUES("259","Зарытые, спрятанные сокровища.","клад");
INSERT INTO chat_vopros VALUES("260","Мафиозная семья.","клан");
INSERT INTO chat_vopros VALUES("261","Родовая или семейная община.","клан");
INSERT INTO chat_vopros VALUES("262","Расширение юбки, брюк, пальто внизу.","клеш");
INSERT INTO chat_vopros VALUES("263","Цепкое мелкое членистоногое животное.","клещ");
INSERT INTO chat_vopros VALUES("264","Кусок дерева, металла с сужающимся плоским концом.","клин");
INSERT INTO chat_vopros VALUES("265","Призыв, возглас.","клич");
INSERT INTO chat_vopros VALUES("266","Торчащая прядь.","клок");
INSERT INTO chat_vopros VALUES("267","Копия организма.","клон");
INSERT INTO chat_vopros VALUES("268","Культурно-просветительное учреждение.","клуб");
INSERT INTO chat_vopros VALUES("269","Зуб, расположенный сразу за резцом.","клык");
INSERT INTO chat_vopros VALUES("270","Челюсти у птиц.","клюв");
INSERT INTO chat_vopros VALUES("271","Знак в начале нотной строки.","ключ");
INSERT INTO chat_vopros VALUES("272","Приспособление для отпирания замков.","ключ");
INSERT INTO chat_vopros VALUES("273","Тряпка, насильно засовываемая в рот для предупреждения крика.","кляп");
INSERT INTO chat_vopros VALUES("274","Насильно засунутая в рот тряпка.","кляп");
INSERT INTO chat_vopros VALUES("275","Большая плеть.","кнут");
INSERT INTO chat_vopros VALUES("276","Наружный покров тела человека, животного.","кожа");
INSERT INTO chat_vopros VALUES("277","Твердое топливо.","кокс");
INSERT INTO chat_vopros VALUES("278","Столица Украины.","киев");
INSERT INTO chat_vopros VALUES("279","Украинское название волынки.","коза");
INSERT INTO chat_vopros VALUES("280","Домашнее парнокопытное животное.","коза");
INSERT INTO chat_vopros VALUES("281","То же, что рудник.","копи");
INSERT INTO chat_vopros VALUES("282","Вес чистого благородного металла в монете.","корн");
INSERT INTO chat_vopros VALUES("283","Сплетеные в виде жгута волосы.","коса");
INSERT INTO chat_vopros VALUES("284","Ручное сельскохозяйственное орудие.","коса");
INSERT INTO chat_vopros VALUES("285","Ручное сельскохозяйственное орудие для срезания травы.","коса");
INSERT INTO chat_vopros VALUES("286","Береговая отмель.","коса");
INSERT INTO chat_vopros VALUES("287","Короткохвостый рак.","краб");
INSERT INTO chat_vopros VALUES("288","Десятиногое ракообразное животное.","краб");
INSERT INTO chat_vopros VALUES("289","Эмблема на форменной фуражке моряков.","краб");
INSERT INTO chat_vopros VALUES("290","Крупная административно-территориальная единица.","край");
INSERT INTO chat_vopros VALUES("291","Обладатель несметных богатств.","крез");
INSERT INTO chat_vopros VALUES("292","Наклон судна набок.","крен");
INSERT INTO chat_vopros VALUES("293","Задняя часть туловища лошади.","круп");
INSERT INTO chat_vopros VALUES("294","Гряда холмов.","кряж");
INSERT INTO chat_vopros VALUES("295","Невысокая горная цепь.","кряж");
INSERT INTO chat_vopros VALUES("296","Крестная мать по отношению к родителям крестника.","кума");
INSERT INTO chat_vopros VALUES("297","Река в Дагестане.","кума");
INSERT INTO chat_vopros VALUES("298","Отделение в пассажирском вагоне.","купе");
INSERT INTO chat_vopros VALUES("299","Направление движения, путь транспорта.","курс");
INSERT INTO chat_vopros VALUES("300","Биржевая цена ценных бумаг.","курс");
INSERT INTO chat_vopros VALUES("301","Ветвистое травянистое растение.","куст");
INSERT INTO chat_vopros VALUES("302","Католический приходской священник.","кюре");
INSERT INTO chat_vopros VALUES("303","Жена помещика, барина в старину на Украине, в Польше.","пани");
INSERT INTO chat_vopros VALUES("304","Отец.","папа");
INSERT INTO chat_vopros VALUES("305","Глава католической церкви.","папа");
INSERT INTO chat_vopros VALUES("306","Спор с каким-либо условием.","пари");
INSERT INTO chat_vopros VALUES("307","Титул высших сановников и генералов в древней Турции.","паша");
INSERT INTO chat_vopros VALUES("308","Прежнее название клоуна.","паяц");
INSERT INTO chat_vopros VALUES("309","Торчащий из земли остаток спиленного дерева.","пень");
INSERT INTO chat_vopros VALUES("310","Орудие для письма в старину.","перо");
INSERT INTO chat_vopros VALUES("311","Стреловидный лист лука, чеснока.","перо");
INSERT INTO chat_vopros VALUES("312","Сооружение для отопления помещения.","печь");
INSERT INTO chat_vopros VALUES("313","Созвездие Южного полушария.","печь");
INSERT INTO chat_vopros VALUES("314","Род копья.","пика");
INSERT INTO chat_vopros VALUES("315","Крутое снижение самолета.","пике");
INSERT INTO chat_vopros VALUES("316","Черная масть в картах.","пики");
INSERT INTO chat_vopros VALUES("317","Зубчатый режущий инструмент.","пила");
INSERT INTO chat_vopros VALUES("318","Декоративный яркий цветок семейства лютиковых.","пион");
INSERT INTO chat_vopros VALUES("319","Нестабильная элементарная частица.","пион");
INSERT INTO chat_vopros VALUES("320","Портовое причальное сооружение.","пирс");
INSERT INTO chat_vopros VALUES("321","14-й президент США.","пирс");
INSERT INTO chat_vopros VALUES("322","Непромокаемое пальто.","плащ");
INSERT INTO chat_vopros VALUES("323","Дорожное одеяло.","плед");
INSERT INTO chat_vopros VALUES("324","Знак сложения в математике.","плюс");
INSERT INTO chat_vopros VALUES("325","Ткань с ворсом.","плюш");
INSERT INTO chat_vopros VALUES("326","Лиановое растение.","плющ");
INSERT INTO chat_vopros VALUES("327","Положение тела.","поза");
INSERT INTO chat_vopros VALUES("328","Безлесная равнинная территория.","поле");
INSERT INTO chat_vopros VALUES("329","Участок земли под посевы.","поле");
INSERT INTO chat_vopros VALUES("330","Ответственная должность.","пост");
INSERT INTO chat_vopros VALUES("331","Воздержание от скоромной пищи.","пост");
INSERT INTO chat_vopros VALUES("332","Место постоянного дежурства.","пост");
INSERT INTO chat_vopros VALUES("333","Автор стихов.","поэт");
INSERT INTO chat_vopros VALUES("334","Ремень на талии.","пояс");
INSERT INTO chat_vopros VALUES("335","Зона на Земле с одинаковым временем.","пояс");
INSERT INTO chat_vopros VALUES("336","Французский физик, вместе с женой исследовавший радиоактивность.","кюри");
INSERT INTO chat_vopros VALUES("337","Единица активности радиоактивных изотопов.","кюри");
INSERT INTO chat_vopros VALUES("338","Тонкая ветка без листьев.","прут");
INSERT INTO chat_vopros VALUES("339","Левый приток Дуная.","прут");
INSERT INTO chat_vopros VALUES("340","Неуравновешенный или душевнобольной человек.","псих");
INSERT INTO chat_vopros VALUES("341","Напиток из рома с приправами.","пунш");
INSERT INTO chat_vopros VALUES("342","Момент приведения в движение.","пуск");
INSERT INTO chat_vopros VALUES("343","Веревка, ремни, стягивающие тело пленника.","путы");
INSERT INTO chat_vopros VALUES("344","Густой труднопроходимый лес.","пуща");
INSERT INTO chat_vopros VALUES("345","Протертая масса из фруктов, ягод или овощей.","пюре");
INSERT INTO chat_vopros VALUES("346","Мелкое волнение водной поверхности.","рябь");
INSERT INTO chat_vopros VALUES("347","Открытое повреждение тканей тела.","рана");
INSERT INTO chat_vopros VALUES("348","То же, что войско.","рать");
INSERT INTO chat_vopros VALUES("349","Гитлеровская империя.","рейх");
INSERT INTO chat_vopros VALUES("350","Столица Латвии.","рига");
INSERT INTO chat_vopros VALUES("351","Французский композитор, балет \"Жизель\".","адан");
INSERT INTO chat_vopros VALUES("352","Французская писательница, роман \"Консуэло\".","санд");
INSERT INTO chat_vopros VALUES("353","Мать жены.","теща");
INSERT INTO chat_vopros VALUES("354","Полосатый полудрагоценный камень.","агат");
INSERT INTO chat_vopros VALUES("355","Работник по уходу за коровами.","дояр");
INSERT INTO chat_vopros VALUES("356","Государство в Центральной Африке.","заир");
INSERT INTO chat_vopros VALUES("357","Французский писатель, роман \"Жерминаль\".","золя");
INSERT INTO chat_vopros VALUES("358","Один из изобретателей телефона, шотландец.","белл");
INSERT INTO chat_vopros VALUES("359","Порт на реке Луара во Франции.","нант");
INSERT INTO chat_vopros VALUES("360","Столбообразное тело в жерле вулкана.","некк");
INSERT INTO chat_vopros VALUES("361","Премьер-министр Индии, сподвижник М.К.Ганди.","неру");
INSERT INTO chat_vopros VALUES("362","Французский композитор, музыка \"Марсельеза\".","лиль");
INSERT INTO chat_vopros VALUES("363","Французский композитор, опера \"Сон в летнюю ночь\".","тома");
INSERT INTO chat_vopros VALUES("364","Место переправы через реку.","брод");
INSERT INTO chat_vopros VALUES("365","Роман Ф.М.Достоевского .","бесы");
INSERT INTO chat_vopros VALUES("366","Роман Э.Золя .","нана");
INSERT INTO chat_vopros VALUES("367","Колдовство, волшебство.","чары");
INSERT INTO chat_vopros VALUES("368","Стихотворение С.Есенина .","чары");
INSERT INTO chat_vopros VALUES("369","Опера Ж.Массне .","таис");
INSERT INTO chat_vopros VALUES("370","Американский писатель, роман \"Приключения Гекльберри Финна\".","твен");
INSERT INTO chat_vopros VALUES("371","Древнегреческий баснописец.","эзоп");
INSERT INTO chat_vopros VALUES("372","Русский советский писатель, соавтор романа \"12 стульев\".","ильф");
INSERT INTO chat_vopros VALUES("373","Английский математик, разработавший алгебру логики.","буль");
INSERT INTO chat_vopros VALUES("374","Французский писатель-фантаст, роман \"Планета обезьян\".","буль");
INSERT INTO chat_vopros VALUES("375","Французский писатель, роман \"Набоб\".","доде");
INSERT INTO chat_vopros VALUES("376","Французский писатель, роман \"Калигула\".","камю");
INSERT INTO chat_vopros VALUES("377","Немецкий писатель, роман \"Будденброки\".","манн");
INSERT INTO chat_vopros VALUES("378","Картофельная крупа.","саго");
INSERT INTO chat_vopros VALUES("379","Столица Перу.","лима");
INSERT INTO chat_vopros VALUES("380","Порт во Франции у слияния рек Рона и Сона.","лион");
INSERT INTO chat_vopros VALUES("381","Река в Прикаспийской низменности.","урал");
INSERT INTO chat_vopros VALUES("382","Марка отечественного автомобиля .","урал");
INSERT INTO chat_vopros VALUES("383","Горная система на границе Европы и Азии.","урал");
INSERT INTO chat_vopros VALUES("384","Русский живописец, картина \"Бородино\".","рубо");
INSERT INTO chat_vopros VALUES("385","Русский художник, панорама \"Бородинская битва\".","рубо");
INSERT INTO chat_vopros VALUES("386","В греческой мифологии супруга спартанского царя Тиндарея.","леда");
INSERT INTO chat_vopros VALUES("387","Спутник Юпитера.","леда");
INSERT INTO chat_vopros VALUES("388","Спутник Сатурна.","феба");
INSERT INTO chat_vopros VALUES("389","Созвездие Южного полушария.","чаша");
INSERT INTO chat_vopros VALUES("390","Округлый сосуд.","чаша");
INSERT INTO chat_vopros VALUES("391","Сделка с немедленной оплатой.","спот");
INSERT INTO chat_vopros VALUES("392","Женское имя (лат. пышная, сноп).","юлия");
INSERT INTO chat_vopros VALUES("393","Тело убитого крупного зверя.","туша");
INSERT INTO chat_vopros VALUES("394","Двухмачтовое судно с прямыми парусами.","бриг");
INSERT INTO chat_vopros VALUES("395","Восковые ячейки пчелиного жилища.","соты");
INSERT INTO chat_vopros VALUES("396","Помещение для мытья с парилкой.","баня");
INSERT INTO chat_vopros VALUES("397","Запряженная ишаком двухколесная повозка.","арба");
INSERT INTO chat_vopros VALUES("398","Чернокожий, негр.","арап");
INSERT INTO chat_vopros VALUES("399","Библейский первый мужчина.","адам");
INSERT INTO chat_vopros VALUES("400","Строительный материал, балка.","брус");
INSERT INTO chat_vopros VALUES("401","Отчаянный высокий вопль.","визг");
INSERT INTO chat_vopros VALUES("402","Способность осуществлять поставленные перед собой цели.","воля");
INSERT INTO chat_vopros VALUES("403","Грузовое помещение на корабле.","трюм");
INSERT INTO chat_vopros VALUES("404","Река в Германии.","рейн");
INSERT INTO chat_vopros VALUES("405","Отец одного из супругов по отношению к родителям другого супруга.","сват");
INSERT INTO chat_vopros VALUES("406","Город и река в Коми.","инта");
INSERT INTO chat_vopros VALUES("407","Женское имя (др. евр. радость).","анна");
INSERT INTO chat_vopros VALUES("408","Легендарный бразильский футболист.","пеле");
INSERT INTO chat_vopros VALUES("409","Ловкий, искусный прием.","трюк");
INSERT INTO chat_vopros VALUES("410","Столица Индии.","дели");
INSERT INTO chat_vopros VALUES("411","Река в Московской области, левый приток Оки.","нара");
INSERT INTO chat_vopros VALUES("412","Первая столица Японии.","нара");
INSERT INTO chat_vopros VALUES("413","Освежающий летний напиток.","квас");
INSERT INTO chat_vopros VALUES("414","Южная птица отряда голенастых.","ибис");
INSERT INTO chat_vopros VALUES("415","В древнегреческой мифологии бог любви.","эрот");
INSERT INTO chat_vopros VALUES("416","Королевский футбольный клуб Испании .","реал");
INSERT INTO chat_vopros VALUES("417","Старинная испанская серебряная монета.","реал");
INSERT INTO chat_vopros VALUES("418","Бывшая столица Германии.","бонн");
INSERT INTO chat_vopros VALUES("419","Спутник Юпитера.","теба");
INSERT INTO chat_vopros VALUES("420","Спутник Юпитера.","фива");
INSERT INTO chat_vopros VALUES("421","Отклонение в сторону повышения рыночной цены золота.","ажио");
INSERT INTO chat_vopros VALUES("422","Деталь затвора огнестрельного оружия.","боек");
INSERT INTO chat_vopros VALUES("423","Островное государство в Центральной Америке.","куба");
INSERT INTO chat_vopros VALUES("424","Курортный город в Грузии.","поти");
INSERT INTO chat_vopros VALUES("425","Город в Германии, в котором родился К. Маркс.","трир");
INSERT INTO chat_vopros VALUES("426","Город в Италии с \"падающей башней\".","пиза");
INSERT INTO chat_vopros VALUES("427","Прежнее название поэта.","пиит");
INSERT INTO chat_vopros VALUES("428","Сибирские валенки.","пимы");
INSERT INTO chat_vopros VALUES("429","Меховые сапоги у северных народов.","пимы");
INSERT INTO chat_vopros VALUES("430","Американский полярный исследователь.","пири");
INSERT INTO chat_vopros VALUES("431","Государство в Западной Азии.","ирак");
INSERT INTO chat_vopros VALUES("432","Государство в Западной Африке.","мали");
INSERT INTO chat_vopros VALUES("433","Государство в Юго-Восточной Азии.","лаос");
INSERT INTO chat_vopros VALUES("434","Государство в Западной Африке.","того");
INSERT INTO chat_vopros VALUES("435","Областной центр в Забайкалье.","чита");
INSERT INTO chat_vopros VALUES("436","Серия советских космических кораблей .","союз");
INSERT INTO chat_vopros VALUES("437","Служебное слово, соединяющее преложения и слова внутри предложения.","союз");
INSERT INTO chat_vopros VALUES("438","Государственное или общественное объединение.","союз");
INSERT INTO chat_vopros VALUES("439","Объединение, союз.","уния");
INSERT INTO chat_vopros VALUES("440","Объединение православной и католической церквей.","уния");
INSERT INTO chat_vopros VALUES("441","Польский парламент.","сейм");
INSERT INTO chat_vopros VALUES("442","Список блюд в ресторане.","меню");
INSERT INTO chat_vopros VALUES("443","Единица измерения.","мера");
INSERT INTO chat_vopros VALUES("444","Старая русская единица емкости сыпучих тел.","мера");
INSERT INTO chat_vopros VALUES("445","Часть чего-либо.","доля");
INSERT INTO chat_vopros VALUES("446","Участь, судьба.","доля");
INSERT INTO chat_vopros VALUES("447","Французский изобретатель телеграфа.","бодо");
INSERT INTO chat_vopros VALUES("448","Итальянский композитор, основатель русского балета, балет \"Конек-Горбунок\".","пуни");
INSERT INTO chat_vopros VALUES("449","Тонкий слой древесины, получаемый лущением.","шпон");
INSERT INTO chat_vopros VALUES("450","Многослойная фанера.","шпон");
INSERT INTO chat_vopros VALUES("451","Гробница для хранения святых мощей.","рака");
INSERT INTO chat_vopros VALUES("452","Первая выгонка вина из барды.","рака");
INSERT INTO chat_vopros VALUES("453","Тонкие волнообразные листы.","гофр");
INSERT INTO chat_vopros VALUES("454","Знакомство и связи, используемые в личных интересах.","блат");
INSERT INTO chat_vopros VALUES("455","Стальная заготовка квадратного сечения.","блюм");
INSERT INTO chat_vopros VALUES("456","Снасть, укрепляемая на концах рея для его поворота.","брас");
INSERT INTO chat_vopros VALUES("457","Минерал для очистки металлов при пайке.","бура");
INSERT INTO chat_vopros VALUES("458","Сложенные в виде вала и укрытые для хранения овощи, корнеплоды.","бурт");
INSERT INTO chat_vopros VALUES("459","Хлопчатобумажная плотная ткань.","бязь");
INSERT INTO chat_vopros VALUES("460","Наполнение легких воздухом.","вдох");
INSERT INTO chat_vopros VALUES("461","Часть теннисной партии.","гейм");
INSERT INTO chat_vopros VALUES("462","Клинообразная дощечка с пазами для покрытия крыши.","гонт");
INSERT INTO chat_vopros VALUES("463","Прорванное или проломанное отверстие.","дыра");
INSERT INTO chat_vopros VALUES("464","Женское имя (греч. вторая).","алла");
INSERT INTO chat_vopros VALUES("465","Псевдоним Н.В.Гоголя.","алов");
INSERT INTO chat_vopros VALUES("466","Марка немецкого автомобиля .","ауди");
INSERT INTO chat_vopros VALUES("467","Марка французского автомобиля .","пежо");
INSERT INTO chat_vopros VALUES("468","Марка американского автомобиля .","додж");
INSERT INTO chat_vopros VALUES("469","Марка шведского автомобиля .","сааб");
INSERT INTO chat_vopros VALUES("470","Марка итальянского автомобиля .","фиат");
INSERT INTO chat_vopros VALUES("471","Марка американского автомобиля .","форд");
INSERT INTO chat_vopros VALUES("472","38-й президент США.","форд");
INSERT INTO chat_vopros VALUES("473","Марка отечественного легкового автомобиля .","лада");
INSERT INTO chat_vopros VALUES("474","Богиня красоты, любви и брака у древних славян.","лада");
INSERT INTO chat_vopros VALUES("475","Отец.","батя");
INSERT INTO chat_vopros VALUES("476","Французский математик, труды по теории алгебраических уравнений.","безу");
INSERT INTO chat_vopros VALUES("477","Герой одесских рассказов Исаака Бабеля.","беня");
INSERT INTO chat_vopros VALUES("478","Столица Швейцарии.","берн");
INSERT INTO chat_vopros VALUES("479","Поперечная балка, соединяющая борта корабля.","бимс");
INSERT INTO chat_vopros VALUES("480","Тонкая лепешка, знаменитое блюдо русской кухни.","блин");
INSERT INTO chat_vopros VALUES("481","Холодный приморский ветер со склонов гор.","бора");
INSERT INTO chat_vopros VALUES("482","Боковая стенка корпуса судна.","борт");
INSERT INTO chat_vopros VALUES("483","Хозяин, начальник, руководитель.","босс");
INSERT INTO chat_vopros VALUES("484","Нидерландский живописец, картина \"Искушение святого Антония\".","босх");
INSERT INTO chat_vopros VALUES("485","Химический элемент, едкая дымящаяся жидкость с неприятным запахом.","бром");
INSERT INTO chat_vopros VALUES("486","Самое сухое шампанское.","брют");
INSERT INTO chat_vopros VALUES("487","Маленький сигнальный плавучий поплавок.","буек");
INSERT INTO chat_vopros VALUES("488","Солдат, боец.","воин");
INSERT INTO chat_vopros VALUES("489","Денежная единица Кореи.","вона");
INSERT INTO chat_vopros VALUES("490","Молочные железы коровы.","вымя");
INSERT INTO chat_vopros VALUES("491","Самое простонародное имя у немцев.","ганс");
INSERT INTO chat_vopros VALUES("492","Дощечки для покрытия крыш.","гарт");
INSERT INTO chat_vopros VALUES("493","Типографский сплав.","гарт");
INSERT INTO chat_vopros VALUES("494","Составитель словаря русского языка.","даль");
INSERT INTO chat_vopros VALUES("495","Английское холодное оружие, короткое метательное копье, дротик.","дарт");
INSERT INTO chat_vopros VALUES("496","Знаток, мастер своего дела.","дока");
INSERT INTO chat_vopros VALUES("497","Лицо женского пола по отношению к своим родителям.","дочь");
INSERT INTO chat_vopros VALUES("498","Порт в Великобритании у пролива Па-де-Кале.","дувр");
INSERT INTO chat_vopros VALUES("499","Вирусная болезнь парнокопытных животных.","ящур");
INSERT INTO chat_vopros VALUES("500","Выдающийся советский вратарь.","яшин");
INSERT INTO chat_vopros VALUES("501","Левый приток Москва-реки.","яуза");



DROP TABLE IF EXISTS `chat_who`;

CREATE TABLE `chat_who` (
  `id_user` int(11) NOT NULL,
  `room` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`room`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO chat_who VALUES("1","2","1594744859");
INSERT INTO chat_who VALUES("324","1","1593192424");
INSERT INTO chat_who VALUES("344","1","1593633379");
INSERT INTO chat_who VALUES("402","1","1594924973");
INSERT INTO chat_who VALUES("425","1","1596306492");
INSERT INTO chat_who VALUES("431","1","1597121729");
INSERT INTO chat_who VALUES("432","0","1593838954");
INSERT INTO chat_who VALUES("433","1","1596995785");
INSERT INTO chat_who VALUES("505","1","1594787659");
INSERT INTO chat_who VALUES("506","1","1593748058");
INSERT INTO chat_who VALUES("512","1","1594442907");
INSERT INTO chat_who VALUES("516","1","1595097958");
INSERT INTO chat_who VALUES("521","1","1593335945");
INSERT INTO chat_who VALUES("523","1","1593362005");
INSERT INTO chat_who VALUES("533","1","1593434214");
INSERT INTO chat_who VALUES("534","1","1593604947");
INSERT INTO chat_who VALUES("541","0","1597489548");
INSERT INTO chat_who VALUES("550","1","1595589770");
INSERT INTO chat_who VALUES("554","1","1594667002");
INSERT INTO chat_who VALUES("561","3","1594269899");
INSERT INTO chat_who VALUES("568","1","1595098834");
INSERT INTO chat_who VALUES("585","1","1596309143");
INSERT INTO chat_who VALUES("603","1","1597520021");



DROP TABLE IF EXISTS `child_action`;

CREATE TABLE `child_action` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `voz` int(11) NOT NULL,
  `keystr` varchar(16) NOT NULL,
  `stat` enum('0','1') NOT NULL DEFAULT '0',
  `time_summ` int(11) NOT NULL,
  `time_val` int(11) NOT NULL,
  `time_k` int(11) NOT NULL,
  `name1` varchar(32) DEFAULT NULL,
  `name2` varchar(32) DEFAULT NULL,
  `type` enum('0','1') NOT NULL DEFAULT '0',
  `cost` int(11) NOT NULL DEFAULT '0',
  `val` varchar(16) NOT NULL DEFAULT 'balls',
  `gigiena` float(11,4) DEFAULT '0.0000',
  `bodr` float(11,4) DEFAULT '0.0000',
  `nastr` float(11,4) DEFAULT '0.0000',
  `obrazov` float(11,4) DEFAULT '0.0000',
  `obchen` float(11,4) DEFAULT '0.0000',
  `sitost` float(11,4) DEFAULT '0.0000',
  PRIMARY KEY (`id`),
  KEY `voz` (`voz`),
  KEY `keystr` (`keystr`)
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=utf8 COMMENT='таблица действий для потребностей детей';

INSERT INTO child_action VALUES("35","1","bodr","1","25200","7","3600","Ночной сон","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("34","1","obchen","1","3600","60","60","Играть в песочнице","Играет в песочнице","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("33","1","obchen","1","2400","40","60","Поиграть в мяч","Играет в мяч","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("30","1","sitost","1","600","10","60","Накормить манной кашей","Кушает манную кашу","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","24.0000");
INSERT INTO child_action VALUES("31","1","obchen","1","1800","30","60","Почитать книгу","Слушать чтение книги","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("21","1","gigiena","1","1800","30","60","Принять ванну","Купаеться","1","2000","balls","2.5600","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("22","1","gigiena","1","2400","40","60","Принять душь","Принимает душь","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("24","1","gigiena","1","420","7","60","Чистить зубы","Чистит зубы","1","2000","balls","68.5714","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("32","1","obchen","1","1800","30","60","Поиграть с катёнком","Играть с катёнком","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("40","1","sitost","1","420","7","60","Накормить блинчиками","Кушает блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("37","1","bodr","1","3600","1","3600","Уложить спать","Дремлет","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("41","1","sitost","1","600","10","60","Накормить рыбкой","Кушает рыбку","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("42","1","sitost","1","360","6","60","Накормить тортиком","Кушает тортик","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("43","1","sitost","1","240","4","60","Накормить арбузом","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("44","1","sitost","1","600","10","60","Накормить круассаном","Кушает круассан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("45","1","sitost","1","480","8","60","Накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("46","1","sitost","1","900","15","60","Накормить рисом с мясом","Кушает рис с мясом","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("47","1","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("48","1","nastr","1","1200","20","60","Покатать на качели","Кататься на качели","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("50","1","bodr","1","10800","3","3600","Уложить спать","Дневной сон","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("53","1","obchen","1","600","10","60","Поиграть с куклой","Играет с куклой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("54","2","gigiena","1","900","15","60","Принять ванну","Принимает ванну","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("55","2","gigiena","1","2400","40","60","Принять душь","Принимает душь","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("56","2","gigiena","1","540","9","60","Чтстит зубы","Чистит зубы","1","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("57","2","sitost","1","900","15","60","Кушает манную кашу","Накормить манкой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("58","2","obchen","1","2400","40","60","Играть с мячем","Играть с мячем","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("59","2","obchen","1","1800","30","60","Почитать книгу","Слушает чтение книги","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("60","2","obchen","1","1800","30","60","Играть с котенком","Играет с котенком","1","3000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("61","2","sitost","1","300","5","60","Накормить арбузом","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("62","2","sitost","1","600","10","60","Накормить круассаном","Кушает круассан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("63","2","obchen","1","2400","40","60","Играть в песочнеце","Играет в песочнеце","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("64","2","bodr","1","25200","7","3600","Ночной сон","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("65","2","bodr","1","3600","1","3600","Уложить спать","Спит","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("66","2","sitost","1","420","7","60","Накормить блинчиками","Кушает блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("67","2","sitost","1","600","10","60","Накормить рыбой","Кушает рыбу","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("68","2","sitost","1","360","6","60","Накормить тортиком","Кушает тортик","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("69","2","sitost","1","480","8","60","Накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("70","2","sitost","1","900","15","60","Накормить рисом с мясом","Кушает рис с мясом","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("71","2","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("72","2","nastr","1","900","15","60","Катать на качели","Кататься на качели","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("73","2","bodr","1","10800","3","3600","Дневной сон","Уложить спать","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("74","2","obchen","1","600","10","60","Поиграть с куклой","Играет с куклой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("75","2","nastr","1","10800","3","3600","В гостях у бабушки и дедушке","В гостях у бабушки и дедушке","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("76","2","nastr","1","600","10","60","Посадить в шезлонг","Сидит в шезлонге","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("77","3","nastr","1","480","8","60","Кататься на качели","Покатать на качели","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("78","3","nastr","1","1800","30","60","Пойти в басейн","В басейне","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("79","3","nastr","1","1800","30","60","Пойти в бассейн","В бассейне","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("80","3","nastr","1","1800","30","60","Посадить в шезлонг","сидит в шезлонге","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("81","3","obchen","1","18000","5","3600","В гостях у бабули и дедули","Гостит у бабушки и дедушки","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("82","3","nastr","1","1500","25","60","Играть с куклой","Играет с куклой","0","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("83","3","bodr","1","10800","3","3600","Дневной сон","Спит","0","0","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("84","3","sitost","1","600","10","60","Накормить Рис с мясом","Кушает рис с мясом","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("85","3","sitost","1","480","8","60","Накормить апельсином","Кушает апельсин","0","0","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("86","3","obchen","1","2400","40","60","Играет с мамой","Поиграть с мамой","0","2000","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("87","3","gigiena","1","1800","30","60","принять ванну","Принять ванну","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("88","3","gigiena","1","2400","40","60","Душ","Принять душ","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("89","3","gigiena","1","1200","20","60","Чистить зубы","Почистить зубы","0","2000","balls","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("90","3","sitost","1","900","15","60","Кушать манку","накормить манкой","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("91","3","nastr","1","1200","20","60","Играть в песочнице","Играть в песочнице","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("92","3","nastr","1","1200","20","60","играть с котиком","Поиграть  с катёнком","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("93","3","nastr","1","1500","25","60","почитать книгу","Читать книгу","0","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("94","3","sitost","1","360","6","60","накормить арбуз","Кушает арбуз","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("95","3","sitost","1","600","10","60","накормить круасманом","Круассан кушать","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("96","3","nastr","1","1500","25","60","играть в песочнице","Поиграть в песочнице","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("97","3","bodr","1","25200","7","3600","Ночной сон","Ночной сон","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("98","3","bodr","1","7200","2","3600","дремать","Дремает","1","2000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("99","3","sitost","1","600","10","60","Блинчики","Кушать блинчики","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("100","3","sitost","1","900","15","60","Кушать  рыбку","Накормить рыбкой","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("101","3","sitost","1","1200","20","60","накормить тортом","Кушает торт","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("102","3","sitost","1","1080","18","60","накормить бананом","Кушает банан","1","2000","balls","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("103","3","nastr","1","480","8","60","покатать на качели","катать на качели","1","2000","balls","0.0000","0.0000","18000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("104","2","obchen","1","10800","3","3600","На прогулку с родителями","На прогулку с родителями","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("105","2","obchen","1","2400","40","60","На прогулке с папой","Гуляет с папой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("106","3","obchen","1","10800","3","3600","играть с мамой","Поиграть с мамой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("107","3","obchen","1","10800","3","3600","На прогулку с родителями","На прогулке с родителями","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("108","2","obchen","1","10800","3","3600","Пойти на прогулку с папой","На прогулке с папой","1","2500","balls","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("109","3","obrazov","1","1800","30","60","Рисовать красками","Рисует красками","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("110","3","obrazov","1","1800","30","60","Лепка из пластелина","Лепить из пластелина","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("111","3","obrazov","1","1800","30","60","На урок английского","Занятия английским языком","1","2000","balls","0.0000","0.0000","0.0000","43200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("112","4","sitost","1","900","15","60","Накормить рассольником","Кушает рассольник","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("113","4","sitost","1","900","15","60","Накормить картошкой фри","Кушает картошку фри","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("114","4","nastr","1","1800","30","60","Пойти с папой в спортзал","В спортзале с папой","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("115","4","nastr","1","2400","40","60","Пойти с папой в гораж","С папой в гораже","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("116","4","bodr","1","25200","7","3600","Уложить спать","Ночной сон","1","3000","balls","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("117","4","bodr","1","300","5","60","Уложить дремать","Дремлет","1","3000","money","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("118","4","bodr","1","10800","3","3600","Дневной сон","Дневной сон","1","3000","money","0.0000","21600.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("119","4","gigiena","1","1200","20","60","Искупаться в ванне","Купаться в ванне","1","3000","money","28800.0000","0.0000","0.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("120","4","obchen","1","1200","20","60","Отвести в бассейн","В бассейне","1","3000","money","0.0000","0.0000","0.0000","0.0000","43200.0000","0.0000");
INSERT INTO child_action VALUES("121","4","obrazov","1","18000","5","3600","В гости к бабушке дедушке","Гостит у бабушки дедушки","1","3000","money","0.0000","0.0000","0.0000","30200.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("122","4","nastr","1","900","15","60","Пойти на атракцион","Катаеться  на атракционе","1","3000","balls","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");
INSERT INTO child_action VALUES("123","4","sitost","1","720","12","60","Накормить мармеладом","Кушает мармелад","1","3000","money","0.0000","0.0000","0.0000","0.0000","0.0000","14400.0000");
INSERT INTO child_action VALUES("124","4","nastr","1","2400","40","60","На прогулку с папой","Пойти на прогулку с папой","1","3000","money","0.0000","0.0000","36000.0000","0.0000","0.0000","0.0000");



DROP TABLE IF EXISTS `child_newchild`;

CREATE TABLE `child_newchild` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `read` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='таблица заявок (предложений) завести ребенка ';




DROP TABLE IF EXISTS `child_offer`;

CREATE TABLE `child_offer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `kto` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `child` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `komu` (`komu`),
  KEY `kto` (`kto`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Таблица предложений одиночкам стать папой мамой ребенку';




DROP TABLE IF EXISTS `child_pers`;

CREATE TABLE `child_pers` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mother` int(11) NOT NULL,
  `father` int(11) NOT NULL,
  `opekun_0` int(11) DEFAULT '0',
  `opekun_1` int(11) NOT NULL DEFAULT '0',
  `dopmsg` int(11) NOT NULL DEFAULT '0',
  `s_time` int(11) NOT NULL,
  `r_time` int(11) NOT NULL,
  `name` varchar(16) NOT NULL,
  `pol` enum('0','1') NOT NULL,
  `voz` smallint(1) NOT NULL DEFAULT '0',
  `detsad` enum('0','1') NOT NULL DEFAULT '0',
  `detsadstop` int(11) NOT NULL DEFAULT '0',
  `detdom` enum('0','1') NOT NULL DEFAULT '0',
  `nani` int(11) NOT NULL,
  `gigiena` float(22,6) DEFAULT '0.000000',
  `bodr` float(22,6) DEFAULT '0.000000',
  `nastr` float(22,6) DEFAULT '0.000000',
  `obrazov` float(22,6) DEFAULT '0.000000',
  `obchen` float(22,6) DEFAULT '0.000000',
  `sitost` float(22,6) DEFAULT '0.000000',
  `uptime` int(11) NOT NULL,
  `act_stop` int(11) DEFAULT '0',
  `act_id` int(11) DEFAULT '0',
  `act_name` varchar(32) NOT NULL,
  `next_voz` int(11) DEFAULT NULL,
  `full` smallint(3) NOT NULL,
  `countnull` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `mother` (`mother`),
  KEY `father` (`father`),
  KEY `opekun_0` (`opekun_0`),
  KEY `opekun_1` (`opekun_1`),
  KEY `uptime` (`uptime`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='таблица детей';




DROP TABLE IF EXISTS `child_prof`;

CREATE TABLE `child_prof` (
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `child_count` int(11) DEFAULT '0',
  `opekun_count` int(11) DEFAULT '0',
  `pol` enum('0','1') NOT NULL,
  `plan_pol` smallint(1) NOT NULL DEFAULT '-1',
  `r_time` int(11) NOT NULL,
  `deprivation` int(11) NOT NULL DEFAULT '0',
  `countuh` int(11) NOT NULL DEFAULT '0',
  `countuh_all` int(11) NOT NULL DEFAULT '0',
  `day` varchar(8) NOT NULL,
  PRIMARY KEY (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Таблица профиля родителей (опекунов)';

INSERT INTO child_prof VALUES("1","1524379362","1","1","0","-1","1595744959","0","0","0","16");
INSERT INTO child_prof VALUES("29","1524639295","0","0","1","-1","1524552895","0","0","0","");
INSERT INTO child_prof VALUES("48","1524642775","0","0","0","-1","1524556375","0","0","0","25");
INSERT INTO child_prof VALUES("45","1524652724","1","1","0","-1","1525429033","0","3","3","18");
INSERT INTO child_prof VALUES("60","1524721179","0","0","0","-1","1524634779","0","0","0","05");
INSERT INTO child_prof VALUES("71","1524724855","0","0","1","-1","1524638455","0","0","0","");
INSERT INTO child_prof VALUES("18","1524735089","0","0","0","-1","1524648689","0","0","0","26");
INSERT INTO child_prof VALUES("110","1524750489","0","0","1","-1","1524664089","0","0","0","26");
INSERT INTO child_prof VALUES("65","1524768259","0","0","0","-1","1524681859","0","0","0","28");
INSERT INTO child_prof VALUES("36","1524768661","0","0","1","-1","1524682261","0","0","0","26");
INSERT INTO child_prof VALUES("10","1524890584","0","0","0","-1","1524804184","0","0","0","28");
INSERT INTO child_prof VALUES("134","1524937295","0","0","0","-1","1524850895","0","0","0","02");
INSERT INTO child_prof VALUES("11","1524946506","0","0","1","-1","1524860106","0","0","0","");
INSERT INTO child_prof VALUES("115","1524989114","0","0","1","-1","1524902714","0","0","0","");
INSERT INTO child_prof VALUES("129","1525087111","0","0","0","-1","1525000711","0","0","0","30");
INSERT INTO child_prof VALUES("217","1525159976","0","0","0","-1","1525073576","0","0","0","");
INSERT INTO child_prof VALUES("222","1525197529","0","0","1","-1","1525111129","0","0","0","04");
INSERT INTO child_prof VALUES("237","1525254386","0","0","0","-1","1525167986","0","0","0","05");
INSERT INTO child_prof VALUES("86","1525327379","0","0","1","-1","1525240979","0","0","0","03");
INSERT INTO child_prof VALUES("182","1525367032","0","0","1","-1","1525280632","0","0","0","05");
INSERT INTO child_prof VALUES("275","1525447526","0","0","0","-1","1525361126","0","0","0","04");
INSERT INTO child_prof VALUES("148","1525492014","0","0","0","-1","1525405614","0","0","0","06");
INSERT INTO child_prof VALUES("296","1525514962","0","0","1","-1","1525428562","0","0","0","12");
INSERT INTO child_prof VALUES("276","1525529702","0","0","0","-1","1525443302","0","0","0","11");
INSERT INTO child_prof VALUES("7","1525544175","0","0","1","-1","1525457775","0","0","0","");
INSERT INTO child_prof VALUES("211","1525577208","0","0","0","0","1525490808","0","0","0","06");
INSERT INTO child_prof VALUES("17","1525637181","1","1","0","-1","1525746989","0","4","4","17");
INSERT INTO child_prof VALUES("6","1525660589","1","1","1","-1","1525574189","0","0","0","09");
INSERT INTO child_prof VALUES("103","1525820808","0","0","0","-1","1525734408","0","0","0","09");
INSERT INTO child_prof VALUES("278","1525937439","0","0","0","-1","1525851039","0","0","0","10");
INSERT INTO child_prof VALUES("158","1526050035","0","0","1","-1","1525963635","0","0","0","11");
INSERT INTO child_prof VALUES("167","1526066812","0","0","0","-1","1525980412","0","0","0","11");
INSERT INTO child_prof VALUES("353","1531329001","0","0","1","-1","1531242601","0","0","0","11");
INSERT INTO child_prof VALUES("368","1540735165","0","0","1","-1","1540648765","0","0","0","");
INSERT INTO child_prof VALUES("15","1562600534","0","0","1","-1","1562514134","0","0","0","12");
INSERT INTO child_prof VALUES("16","1562688516","0","0","1","-1","1562602116","0","0","0","14");
INSERT INTO child_prof VALUES("22","1563596925","0","0","1","-1","1563510525","0","0","0","22");
INSERT INTO child_prof VALUES("37","1563855078","0","0","0","-1","1563768678","0","0","0","29");
INSERT INTO child_prof VALUES("38","1563864067","0","0","1","-1","1563777667","0","0","0","02");
INSERT INTO child_prof VALUES("41","1563889048","0","0","0","-1","1563802648","0","0","0","28");
INSERT INTO child_prof VALUES("46","1564060559","0","0","0","-1","1563974159","0","0","0","");
INSERT INTO child_prof VALUES("58","1564389062","1","0","0","-1","1564676227","1","0","0","03");
INSERT INTO child_prof VALUES("67","1564543616","0","0","0","-1","1564457216","0","0","0","");
INSERT INTO child_prof VALUES("69","1564567749","0","0","0","-1","1564481349","0","0","0","");
INSERT INTO child_prof VALUES("19","1564589826","0","0","1","-1","1564503426","0","0","0","31");
INSERT INTO child_prof VALUES("54","1564676491","0","0","1","-1","1564590091","0","0","0","01");
INSERT INTO child_prof VALUES("72","1564688395","0","0","1","-1","1564601995","0","0","0","13");
INSERT INTO child_prof VALUES("74","1564821354","0","1","0","-1","1564734954","0","0","0","30");
INSERT INTO child_prof VALUES("87","1565258570","0","0","0","-1","1565172170","0","0","0","");
INSERT INTO child_prof VALUES("97","1565792895","0","0","0","-1","1565706495","0","0","0","");
INSERT INTO child_prof VALUES("116","1566748789","0","0","1","-1","1566662389","0","0","0","");
INSERT INTO child_prof VALUES("120","1567016594","0","0","1","-1","1566930194","0","0","0","28");
INSERT INTO child_prof VALUES("113","1567066902","0","0","0","1","1566980502","0","0","0","23");
INSERT INTO child_prof VALUES("5","1567177258","0","0","0","-1","1567090858","0","0","0","");
INSERT INTO child_prof VALUES("156","1568215802","0","0","0","-1","1568129402","0","0","0","11");
INSERT INTO child_prof VALUES("142","1568230516","0","0","0","-1","1568144116","0","0","0","");
INSERT INTO child_prof VALUES("91","1568856520","0","0","0","-1","1568770120","0","0","0","");
INSERT INTO child_prof VALUES("99","1569459349","0","0","0","-1","1569372949","0","0","0","05");
INSERT INTO child_prof VALUES("185","1570397396","0","0","1","-1","1570310996","0","0","0","");
INSERT INTO child_prof VALUES("232","1576414463","0","0","1","-1","1576328063","0","0","0","15");
INSERT INTO child_prof VALUES("256","1576488129","0","0","0","-1","1576401729","0","0","0","16");
INSERT INTO child_prof VALUES("258","1576770371","0","0","1","-1","1576683971","0","0","0","19");
INSERT INTO child_prof VALUES("331","1590787785","0","0","0","-1","1590701385","0","0","0","30");
INSERT INTO child_prof VALUES("340","1590918641","0","0","0","-1","1590832241","0","0","0","17");
INSERT INTO child_prof VALUES("339","1591052205","0","0","0","-1","1590965805","0","0","0","13");
INSERT INTO child_prof VALUES("362","1591128426","0","0","0","-1","1591042026","0","0","0","06");
INSERT INTO child_prof VALUES("444","1592497412","1","0","1","0","1592411012","1","0","0","02");
INSERT INTO child_prof VALUES("312","1592548679","0","0","0","-1","1595744959","1","0","0","22");
INSERT INTO child_prof VALUES("271","1593867222","0","0","1","-1","1593780822","0","0","0","");
INSERT INTO child_prof VALUES("550","1595607843","1","1","1","0","1595521443","0","0","0","08");
INSERT INTO child_prof VALUES("557","1595744932","0","0","1","-1","1595744932","0","0","0","02");
INSERT INTO child_prof VALUES("590","1596366926","0","0","1","-1","1596366926","0","0","0","02");
INSERT INTO child_prof VALUES("604","1597517962","0","0","0","-1","1597517962","0","0","0","15");
INSERT INTO child_prof VALUES("608","1597532630","0","0","1","-1","1597532630","0","0","0","");



DROP TABLE IF EXISTS `child_rodn`;

CREATE TABLE `child_rodn` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `child` int(11) NOT NULL,
  `user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `rname` varchar(16) NOT NULL,
  `accept` enum('0','1') DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `child` (`child`),
  KEY `user` (`user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `chr`;

CREATE TABLE `chr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `num` int(5) DEFAULT '0',
  `cena` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan`;

CREATE TABLE `clan` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `admin` int(11) DEFAULT NULL,
  `name` varchar(128) COLLATE utf8_unicode_ci DEFAULT NULL,
  `about` varchar(250) COLLATE utf8_unicode_ci DEFAULT NULL,
  `time` int(11) DEFAULT '0',
  `level` int(11) DEFAULT '1',
  `reit` int(11) DEFAULT '0',
  `allreit` int(11) NOT NULL DEFAULT '0',
  `bank` int(11) DEFAULT '0',
  `upbank` int(11) NOT NULL DEFAULT '0',
  `twix` float DEFAULT '0',
  `pobed` int(11) DEFAULT '0',
  `poraj` int(11) DEFAULT '0',
  `nicka` int(11) DEFAULT '0',
  `stat` varchar(16) COLLATE utf8_unicode_ci DEFAULT 'moder',
  `ico` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'ico0.png',
  `logo` varchar(64) COLLATE utf8_unicode_ci NOT NULL DEFAULT 'klan0.png',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;




DROP TABLE IF EXISTS `clan_achat`;

CREATE TABLE `clan_achat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `kto` int(11) DEFAULT NULL,
  `komu` int(11) DEFAULT '0',
  `post` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_chat`;

CREATE TABLE `clan_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `kto` int(11) DEFAULT NULL,
  `komu` int(11) DEFAULT '0',
  `post` varchar(256) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_lenta`;

CREATE TABLE `clan_lenta` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) DEFAULT NULL,
  `msg` varchar(512) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_news`;

CREATE TABLE `clan_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `mtime` int(11) NOT NULL,
  `head` varchar(128) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_news_comm`;

CREATE TABLE `clan_news_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `news` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `msg` varchar(512) NOT NULL,
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_transfer`;

CREATE TABLE `clan_transfer` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `klan` int(11) NOT NULL,
  `admin` int(11) NOT NULL,
  `komu` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `clan_user`;

CREATE TABLE `clan_user` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `klan` int(11) DEFAULT NULL,
  `level` smallint(6) DEFAULT '0',
  `reit` int(11) DEFAULT '0',
  `nreit` int(11) NOT NULL,
  `allreit` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  `pobed` int(11) DEFAULT '0',
  `poraj` int(11) DEFAULT '0',
  `nicka` int(11) DEFAULT '0',
  `op` int(11) DEFAULT NULL,
  `stat` varchar(16) DEFAULT 'moder',
  `zvan` smallint(2) NOT NULL DEFAULT '0',
  `chattime` int(11) NOT NULL DEFAULT '0',
  `achattime` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cms_garem`;

CREATE TABLE `cms_garem` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_garem` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=496 DEFAULT CHARSET=utf8;

INSERT INTO cms_garem VALUES("202","246","213","1576154071");
INSERT INTO cms_garem VALUES("207","264","45","1577349648");
INSERT INTO cms_garem VALUES("140","17","170","1569463802");
INSERT INTO cms_garem VALUES("108","56","71","1567369817");
INSERT INTO cms_garem VALUES("19","29","71","1564590847");
INSERT INTO cms_garem VALUES("191","224","223","1574257479");
INSERT INTO cms_garem VALUES("165","38","52","1570550040");
INSERT INTO cms_garem VALUES("136","60","170","1569434352");
INSERT INTO cms_garem VALUES("73","42","74","1566377597");
INSERT INTO cms_garem VALUES("121","138","61","1568005264");
INSERT INTO cms_garem VALUES("180","52","38","1572523642");
INSERT INTO cms_garem VALUES("80","19","74","1566378299");
INSERT INTO cms_garem VALUES("17","53","71","1564590510");
INSERT INTO cms_garem VALUES("18","69","71","1564590559");
INSERT INTO cms_garem VALUES("21","58","19","1564591066");
INSERT INTO cms_garem VALUES("164","59","38","1570365913");
INSERT INTO cms_garem VALUES("27","44","38","1564695878");
INSERT INTO cms_garem VALUES("110","73","71","1567369873");
INSERT INTO cms_garem VALUES("201","45","86","1575874803");
INSERT INTO cms_garem VALUES("91","112","74","1566593049");
INSERT INTO cms_garem VALUES("32","80","74","1564841026");
INSERT INTO cms_garem VALUES("175","94","170","1571955038");
INSERT INTO cms_garem VALUES("34","78","38","1564859508");
INSERT INTO cms_garem VALUES("35","81","74","1564914672");
INSERT INTO cms_garem VALUES("40","86","45","1565114924");
INSERT INTO cms_garem VALUES("41","88","74","1565123703");
INSERT INTO cms_garem VALUES("54","85","43","1565939430");
INSERT INTO cms_garem VALUES("43","83","74","1565123844");
INSERT INTO cms_garem VALUES("44","82","74","1565123938");
INSERT INTO cms_garem VALUES("45","77","74","1565124068");
INSERT INTO cms_garem VALUES("46","34","45","1565142614");
INSERT INTO cms_garem VALUES("199","245","214","1575725878");
INSERT INTO cms_garem VALUES("163","97","38","1570365703");
INSERT INTO cms_garem VALUES("153","99","170","1569963698");
INSERT INTO cms_garem VALUES("51","89","104","1565916202");
INSERT INTO cms_garem VALUES("155","43","170","1569971703");
INSERT INTO cms_garem VALUES("57","104","43","1566042713");
INSERT INTO cms_garem VALUES("55","108","104","1565998303");
INSERT INTO cms_garem VALUES("59","111","74","1566373285");
INSERT INTO cms_garem VALUES("60","110","74","1566373359");
INSERT INTO cms_garem VALUES("61","109","74","1566373509");
INSERT INTO cms_garem VALUES("62","105","74","1566373888");
INSERT INTO cms_garem VALUES("63","100","74","1566376338");
INSERT INTO cms_garem VALUES("64","76","74","1566376738");
INSERT INTO cms_garem VALUES("65","75","74","1566376797");
INSERT INTO cms_garem VALUES("66","72","74","1566376890");
INSERT INTO cms_garem VALUES("67","70","74","1566376985");
INSERT INTO cms_garem VALUES("68","66","74","1566377081");
INSERT INTO cms_garem VALUES("69","62","74","1566377209");
INSERT INTO cms_garem VALUES("70","54","74","1566377310");
INSERT INTO cms_garem VALUES("71","48","74","1566377389");
INSERT INTO cms_garem VALUES("72","47","74","1566377495");
INSERT INTO cms_garem VALUES("74","36","74","1566377758");
INSERT INTO cms_garem VALUES("75","31","74","1566377929");
INSERT INTO cms_garem VALUES("188","141","146","1573001962");
INSERT INTO cms_garem VALUES("77","25","74","1566378078");
INSERT INTO cms_garem VALUES("78","23","74","1566378144");
INSERT INTO cms_garem VALUES("79","22","74","1566378213");
INSERT INTO cms_garem VALUES("81","18","74","1566378363");
INSERT INTO cms_garem VALUES("82","16","74","1566378420");
INSERT INTO cms_garem VALUES("83","15","74","1566378522");
INSERT INTO cms_garem VALUES("84","14","74","1566378720");
INSERT INTO cms_garem VALUES("85","13","74","1566378796");
INSERT INTO cms_garem VALUES("86","7","74","1566378866");
INSERT INTO cms_garem VALUES("87","6","74","1566378961");
INSERT INTO cms_garem VALUES("94","116","74","1566764065");
INSERT INTO cms_garem VALUES("129","113","159","1568522963");
INSERT INTO cms_garem VALUES("95","27","93","1566826935");
INSERT INTO cms_garem VALUES("192","142","226","1574328599");
INSERT INTO cms_garem VALUES("98","123","74","1566982410");
INSERT INTO cms_garem VALUES("197","74","239","1574853643");
INSERT INTO cms_garem VALUES("100","124","32","1567072134");
INSERT INTO cms_garem VALUES("101","127","74","1567088005");
INSERT INTO cms_garem VALUES("116","121","71","1567370084");
INSERT INTO cms_garem VALUES("104","10","71","1567369585");
INSERT INTO cms_garem VALUES("105","21","71","1567369641");
INSERT INTO cms_garem VALUES("106","28","71","1567369695");
INSERT INTO cms_garem VALUES("128","160","159","1568488744");
INSERT INTO cms_garem VALUES("109","67","71","1567369845");
INSERT INTO cms_garem VALUES("112","95","71","1567369961");
INSERT INTO cms_garem VALUES("113","92","71","1567369980");
INSERT INTO cms_garem VALUES("114","107","71","1567370028");
INSERT INTO cms_garem VALUES("115","115","71","1567370053");
INSERT INTO cms_garem VALUES("117","117","71","1567370102");
INSERT INTO cms_garem VALUES("122","146","141","1568094325");
INSERT INTO cms_garem VALUES("193","226","142","1574365749");
INSERT INTO cms_garem VALUES("132","166","141","1569043999");
INSERT INTO cms_garem VALUES("133","167","170","1569353662");
INSERT INTO cms_garem VALUES("134","91","170","1569378664");
INSERT INTO cms_garem VALUES("135","151","170","1569428348");
INSERT INTO cms_garem VALUES("184","200","211","1572723186");
INSERT INTO cms_garem VALUES("139","170","99","1569461652");
INSERT INTO cms_garem VALUES("142","173","170","1569511506");
INSERT INTO cms_garem VALUES("143","174","170","1569519607");
INSERT INTO cms_garem VALUES("144","175","170","1569519763");
INSERT INTO cms_garem VALUES("182","180","209","1572652975");
INSERT INTO cms_garem VALUES("150","182","170","1569898082");
INSERT INTO cms_garem VALUES("154","183","170","1569963887");
INSERT INTO cms_garem VALUES("158","51","166","1570216058");
INSERT INTO cms_garem VALUES("159","184","166","1570218226");
INSERT INTO cms_garem VALUES("160","178","166","1570218508");
INSERT INTO cms_garem VALUES("161","129","166","1570219845");
INSERT INTO cms_garem VALUES("449","8","431","1596434605");
INSERT INTO cms_garem VALUES("170","24","170","1570948406");
INSERT INTO cms_garem VALUES("173","190","170","1571086990");
INSERT INTO cms_garem VALUES("174","197","170","1571492377");
INSERT INTO cms_garem VALUES("185","212","211","1572723220");
INSERT INTO cms_garem VALUES("186","57","170","1572747683");
INSERT INTO cms_garem VALUES("187","213","170","1572891582");
INSERT INTO cms_garem VALUES("189","211","200","1573081435");
INSERT INTO cms_garem VALUES("196","239","203","1574794112");
INSERT INTO cms_garem VALUES("198","242","214","1575183731");
INSERT INTO cms_garem VALUES("203","251","45","1576160426");
INSERT INTO cms_garem VALUES("204","247","1","1576426057");
INSERT INTO cms_garem VALUES("205","84","254","1576469133");
INSERT INTO cms_garem VALUES("208","286","291","1584381955");
INSERT INTO cms_garem VALUES("209","300","299","1585336244");
INSERT INTO cms_garem VALUES("411","316","554","1595075608");
INSERT INTO cms_garem VALUES("212","349","350","1590989333");
INSERT INTO cms_garem VALUES("463","341","554","1596467534");
INSERT INTO cms_garem VALUES("218","359","350","1591111143");
INSERT INTO cms_garem VALUES("248","355","427","1592065070");
INSERT INTO cms_garem VALUES("219","358","350","1591112549");
INSERT INTO cms_garem VALUES("220","357","350","1591113813");
INSERT INTO cms_garem VALUES("226","372","350","1591258220");
INSERT INTO cms_garem VALUES("231","399","396","1591621542");
INSERT INTO cms_garem VALUES("232","396","399","1591621574");
INSERT INTO cms_garem VALUES("365","350","535","1593531075");
INSERT INTO cms_garem VALUES("259","437","419","1592322352");
INSERT INTO cms_garem VALUES("236","403","339","1591733384");
INSERT INTO cms_garem VALUES("402","402","271","1594574606");
INSERT INTO cms_garem VALUES("238","409","403","1591820079");
INSERT INTO cms_garem VALUES("239","414","350","1591879123");
INSERT INTO cms_garem VALUES("478","330","351","1597090714");
INSERT INTO cms_garem VALUES("383","351","346","1594022127");
INSERT INTO cms_garem VALUES("285","421","442","1592558174");
INSERT INTO cms_garem VALUES("245","425","350","1592018405");
INSERT INTO cms_garem VALUES("246","426","350","1592018579");
INSERT INTO cms_garem VALUES("308","428","362","1592639843");
INSERT INTO cms_garem VALUES("250","435","350","1592193171");
INSERT INTO cms_garem VALUES("254","427","355","1592266736");
INSERT INTO cms_garem VALUES("255","391","350","1592281428");
INSERT INTO cms_garem VALUES("301","380","468","1592621159");
INSERT INTO cms_garem VALUES("266","457","350","1592459000");
INSERT INTO cms_garem VALUES("268","459","350","1592468386");
INSERT INTO cms_garem VALUES("269","288","442","1592469620");
INSERT INTO cms_garem VALUES("334","506","505","1593199617");
INSERT INTO cms_garem VALUES("302","471","468","1592621517");
INSERT INTO cms_garem VALUES("371","445","431","1593742129");
INSERT INTO cms_garem VALUES("292","463","468","1592584314");
INSERT INTO cms_garem VALUES("294","340","468","1592584699");
INSERT INTO cms_garem VALUES("295","379","468","1592584781");
INSERT INTO cms_garem VALUES("296","469","468","1592590704");
INSERT INTO cms_garem VALUES("303","397","468","1592621835");
INSERT INTO cms_garem VALUES("486","4","609","1597542921");
INSERT INTO cms_garem VALUES("315","453","445","1592666472");
INSERT INTO cms_garem VALUES("427","487","433","1595755672");
INSERT INTO cms_garem VALUES("389","432","433","1594190874");
INSERT INTO cms_garem VALUES("493","320","608","1597666161");
INSERT INTO cms_garem VALUES("323","493","350","1592880928");
INSERT INTO cms_garem VALUES("327","500","350","1593051292");
INSERT INTO cms_garem VALUES("328","446","350","1593051508");
INSERT INTO cms_garem VALUES("329","501","350","1593051688");
INSERT INTO cms_garem VALUES("330","325","350","1593056739");
INSERT INTO cms_garem VALUES("331","458","350","1593057019");
INSERT INTO cms_garem VALUES("333","505","506","1593193799");
INSERT INTO cms_garem VALUES("335","507","362","1593210190");
INSERT INTO cms_garem VALUES("367","542","350","1593657404");
INSERT INTO cms_garem VALUES("340","510","511","1593319452");
INSERT INTO cms_garem VALUES("343","511","510","1593341107");
INSERT INTO cms_garem VALUES("348","520","350","1593349312");
INSERT INTO cms_garem VALUES("349","521","350","1593349387");
INSERT INTO cms_garem VALUES("350","523","350","1593357950");
INSERT INTO cms_garem VALUES("477","512","554","1596948834");
INSERT INTO cms_garem VALUES("354","488","350","1593420119");
INSERT INTO cms_garem VALUES("356","531","350","1593429081");
INSERT INTO cms_garem VALUES("357","346","351","1593482259");
INSERT INTO cms_garem VALUES("405","534","473","1594736484");
INSERT INTO cms_garem VALUES("361","535","350","1593505459");
INSERT INTO cms_garem VALUES("369","508","362","1593689739");
INSERT INTO cms_garem VALUES("374","344","533","1593808723");
INSERT INTO cms_garem VALUES("373","543","350","1593763182");
INSERT INTO cms_garem VALUES("488","433","351","1597552786");
INSERT INTO cms_garem VALUES("378","552","362","1593955372");
INSERT INTO cms_garem VALUES("483","1","554","1597511231");
INSERT INTO cms_garem VALUES("408","516","528","1595026020");
INSERT INTO cms_garem VALUES("381","556","350","1594003076");
INSERT INTO cms_garem VALUES("388","271","402","1594130685");
INSERT INTO cms_garem VALUES("390","560","350","1594264742");
INSERT INTO cms_garem VALUES("391","559","350","1594264845");
INSERT INTO cms_garem VALUES("392","561","350","1594265004");
INSERT INTO cms_garem VALUES("409","514","554","1595060081");
INSERT INTO cms_garem VALUES("437","497","351","1596283085");
INSERT INTO cms_garem VALUES("440","554","433","1596302024");
INSERT INTO cms_garem VALUES("403","564","350","1594652507");
INSERT INTO cms_garem VALUES("404","339","519","1594656151");
INSERT INTO cms_garem VALUES("406","473","534","1594736871");
INSERT INTO cms_garem VALUES("407","567","350","1594904301");
INSERT INTO cms_garem VALUES("412","570","554","1595090902");
INSERT INTO cms_garem VALUES("413","562","554","1595126129");
INSERT INTO cms_garem VALUES("414","574","350","1595131507");
INSERT INTO cms_garem VALUES("415","573","350","1595131590");
INSERT INTO cms_garem VALUES("416","572","350","1595131675");
INSERT INTO cms_garem VALUES("417","528","516","1595179690");
INSERT INTO cms_garem VALUES("418","584","576","1595491974");
INSERT INTO cms_garem VALUES("429","576","584","1595844785");
INSERT INTO cms_garem VALUES("422","423","554","1595617087");
INSERT INTO cms_garem VALUES("423","583","431","1595651253");
INSERT INTO cms_garem VALUES("425","565","431","1595651471");
INSERT INTO cms_garem VALUES("428","278","586","1595818234");
INSERT INTO cms_garem VALUES("441","589","431","1596340554");
INSERT INTO cms_garem VALUES("442","585","431","1596345856");
INSERT INTO cms_garem VALUES("443","580","431","1596345919");
INSERT INTO cms_garem VALUES("444","579","431","1596345954");
INSERT INTO cms_garem VALUES("445","577","431","1596345974");
INSERT INTO cms_garem VALUES("446","571","431","1596346033");
INSERT INTO cms_garem VALUES("447","274","431","1596390165");
INSERT INTO cms_garem VALUES("450","298","431","1596434811");
INSERT INTO cms_garem VALUES("451","273","431","1596434853");
INSERT INTO cms_garem VALUES("452","279","431","1596434903");
INSERT INTO cms_garem VALUES("453","315","431","1596435026");
INSERT INTO cms_garem VALUES("454","309","431","1596435059");
INSERT INTO cms_garem VALUES("455","322","431","1596435102");
INSERT INTO cms_garem VALUES("456","336","431","1596435185");
INSERT INTO cms_garem VALUES("457","331","431","1596435224");
INSERT INTO cms_garem VALUES("458","343","431","1596435285");
INSERT INTO cms_garem VALUES("460","347","431","1596435386");
INSERT INTO cms_garem VALUES("461","345","431","1596435434");
INSERT INTO cms_garem VALUES("464","353","431","1596470117");
INSERT INTO cms_garem VALUES("465","365","431","1596470138");
INSERT INTO cms_garem VALUES("466","366","431","1596470169");
INSERT INTO cms_garem VALUES("467","363","431","1596470184");
INSERT INTO cms_garem VALUES("469","361","431","1596470224");
INSERT INTO cms_garem VALUES("470","373","431","1596470254");
INSERT INTO cms_garem VALUES("471","370","431","1596470351");
INSERT INTO cms_garem VALUES("472","368","431","1596470368");
INSERT INTO cms_garem VALUES("473","367","431","1596470405");
INSERT INTO cms_garem VALUES("476","416","350","1596702047");
INSERT INTO cms_garem VALUES("481","595","350","1597116079");
INSERT INTO cms_garem VALUES("482","422","362","1597495175");
INSERT INTO cms_garem VALUES("484","606","605","1597522937");
INSERT INTO cms_garem VALUES("485","603","605","1597523111");
INSERT INTO cms_garem VALUES("489","611","605","1597554091");
INSERT INTO cms_garem VALUES("495","605","603","1597670292");
INSERT INTO cms_garem VALUES("491","614","605","1597601812");
INSERT INTO cms_garem VALUES("492","289","605","1597658989");



DROP TABLE IF EXISTS `cms_garem_zapret`;

CREATE TABLE `cms_garem_zapret` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=19 DEFAULT CHARSET=utf8;

INSERT INTO cms_garem_zapret VALUES("1","51","1567292583");
INSERT INTO cms_garem_zapret VALUES("2","32","1590604434");
INSERT INTO cms_garem_zapret VALUES("3","102","1568456030");
INSERT INTO cms_garem_zapret VALUES("4","98","1567881885");
INSERT INTO cms_garem_zapret VALUES("5","71","1570048590");
INSERT INTO cms_garem_zapret VALUES("6","156","1569510346");
INSERT INTO cms_garem_zapret VALUES("7","258","1579108893");
INSERT INTO cms_garem_zapret VALUES("8","179","1579976589");
INSERT INTO cms_garem_zapret VALUES("10","404","1594930930");
INSERT INTO cms_garem_zapret VALUES("11","428","1593245842");
INSERT INTO cms_garem_zapret VALUES("12","506","1595884864");
INSERT INTO cms_garem_zapret VALUES("13","510","1593946227");
INSERT INTO cms_garem_zapret VALUES("14","519","1619507668");
INSERT INTO cms_garem_zapret VALUES("16","473","1595947328");
INSERT INTO cms_garem_zapret VALUES("17","431","1621398629");
INSERT INTO cms_garem_zapret VALUES("18","576","1598523280");



DROP TABLE IF EXISTS `coded_article`;

CREATE TABLE `coded_article` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `content` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `coded_comm`;

CREATE TABLE `coded_comm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `id_new` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL,
  `msg` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `coded_razdel`;

CREATE TABLE `coded_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests`;

CREATE TABLE `contests` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(2000) NOT NULL,
  `name` varchar(32) NOT NULL,
  `ntime` int(11) NOT NULL,
  `ktime` int(11) NOT NULL,
  `pol` set('0','1','2') NOT NULL,
  `type` set('0','1','2') NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests_golos`;

CREATE TABLE `contests_golos` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_golos` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `golos` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `contests_users`;

CREATE TABLE `contests_users` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_contest` int(11) NOT NULL,
  `text` varchar(2000) NOT NULL,
  `time` int(11) NOT NULL,
  `golos` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `cron`;

CREATE TABLE `cron` (
  `id` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO cron VALUES("clear_tmp_dir","1597687251");
INSERT INTO cron VALUES("visit","1487329071");
INSERT INTO cron VALUES("everyday","1597687545");
INSERT INTO cron VALUES("backup_mysql","1597687628");
INSERT INTO cron VALUES("birthday","1597648732");



DROP TABLE IF EXISTS `derevolove_stena`;

CREATE TABLE `derevolove_stena` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `id_ank` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `dialog`;

CREATE TABLE `dialog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `message` text NOT NULL,
  `type` char(10) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `discussions`;

CREATE TABLE `discussions` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `avtor` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `count` int(11) DEFAULT '0',
  `msg` varchar(1024) NOT NULL,
  `time` int(11) NOT NULL,
  `type` varchar(100) NOT NULL,
  `id_sim` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `discussions_set`;

CREATE TABLE `discussions_set` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `disc_status` int(11) DEFAULT '1',
  `disc_foto` int(11) DEFAULT '1',
  `disc_files` int(11) DEFAULT '1',
  `disc_forum` int(11) DEFAULT '1',
  `disc_notes` int(11) DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `dogmat`;

CREATE TABLE `dogmat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `mid` int(11) NOT NULL,
  `kid` int(11) NOT NULL,
  `iconse` varchar(21) NOT NULL,
  `time` int(11) NOT NULL,
  `text` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=59 DEFAULT CHARSET=utf8;

INSERT INTO dogmat VALUES("37","1","1","4","1572278769","Для меня");
INSERT INTO dogmat VALUES("38","391","391","12","1592282605",")))))");
INSERT INTO dogmat VALUES("39","1","282","15","1593469333","Для тебя ");
INSERT INTO dogmat VALUES("40","1","282","16","1593469593","Все для тебя");
INSERT INTO dogmat VALUES("41","1","1","18","1593469925","Для Натали");
INSERT INTO dogmat VALUES("42","1","324","16","1593495418","Для тебя");
INSERT INTO dogmat VALUES("43","324","1","16","1593495440","Просто так");
INSERT INTO dogmat VALUES("44","1","1","18","1593858678","Для тебя ");
INSERT INTO dogmat VALUES("45","271","1","16","1593859181","Тест тест тест тест тест тест тест тест тест");
INSERT INTO dogmat VALUES("46","1","1","18","1593859245","Тебе");
INSERT INTO dogmat VALUES("47","1","271","6","1593859420","Вот для тебя");
INSERT INTO dogmat VALUES("48","1","271","6","1593859859","Вот вот ");
INSERT INTO dogmat VALUES("49","1","271","6","1593860172","Ку ");
INSERT INTO dogmat VALUES("50","1","271","6","1593860390","Привет");
INSERT INTO dogmat VALUES("51","1","271","6","1593860760","Вот вот");
INSERT INTO dogmat VALUES("52","271","1","2","1593861083","Тест тест тест тест тест тест тест тест тест тест тест тест тест");
INSERT INTO dogmat VALUES("53","1","1","18","1595194541","Для тебя ");
INSERT INTO dogmat VALUES("54","557","550","4","1596616664","пробник");
INSERT INTO dogmat VALUES("55","1","550","17","1596637239","Для тебя родной");
INSERT INTO dogmat VALUES("56","550","1","16","1596637281","Проба будет");
INSERT INTO dogmat VALUES("57","1","590","6","1597406873","Привет ");
INSERT INTO dogmat VALUES("58","1","590","16","1597406996","Привета");



DROP TABLE IF EXISTS `doktor`;

CREATE TABLE `doktor` (
  `klu4` int(11) NOT NULL,
  `night_act` varchar(512) NOT NULL,
  PRIMARY KEY (`klu4`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `duel`;

CREATE TABLE `duel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_opponent` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `win` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `duel_new`;

CREATE TABLE `duel_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_opponent` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `duel_stat`;

CREATE TABLE `duel_stat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_duel` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `voted` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `durak`;

CREATE TABLE `durak` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `id_prot` int(11) NOT NULL,
  `stav` int(11) DEFAULT '0',
  `hod` int(11) DEFAULT '0',
  `kozar` int(11) DEFAULT '0',
  `karta` varchar(3) DEFAULT NULL,
  `read` int(3) DEFAULT '0',
  `over_hod` int(11) DEFAULT NULL,
  `game_over` int(1) DEFAULT NULL,
  `status` int(1) DEFAULT '0',
  `koloda` varchar(20) DEFAULT 'default',
  `chat` int(20) DEFAULT '0',
  `level` int(11) DEFAULT '0',
  `bit` int(11) DEFAULT '0',
  `hodit` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_chat`;

CREATE TABLE `durak_chat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `msg` varchar(512) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  `time` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_game`;

CREATE TABLE `durak_game` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `karta` varchar(11) DEFAULT '0',
  `sila` int(11) DEFAULT '0',
  `mast` int(11) DEFAULT '0',
  `on` int(1) DEFAULT '0',
  `time` int(12) DEFAULT NULL,
  `id_game` int(11) DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=37 DEFAULT CHARSET=utf8;

INSERT INTO durak_game VALUES("1","41","Dp","7","3","0","1374153695","4");
INSERT INTO durak_game VALUES("2","41","10p","5","3","0","1374153696","4");
INSERT INTO durak_game VALUES("3","41","Vb","6","4","0","1374153697","4");
INSERT INTO durak_game VALUES("4","41","6k","1","1","0","1374153698","4");
INSERT INTO durak_game VALUES("5","41","Tp","9","3","0","1374153699","4");
INSERT INTO durak_game VALUES("6","41","Vc","6","2","0","1374153700","4");
INSERT INTO durak_game VALUES("7","60","10c","5","2","0","1374153701","4");
INSERT INTO durak_game VALUES("8","60","7k","2","1","1","1374153704","4");
INSERT INTO durak_game VALUES("9","60","10b","5","4","0","1374153703","4");
INSERT INTO durak_game VALUES("10","60","7b","2","4","0","1374153704","4");
INSERT INTO durak_game VALUES("11","60","9b","4","4","0","1374153705","4");
INSERT INTO durak_game VALUES("12","60","Db","7","4","0","1374153706","4");
INSERT INTO durak_game VALUES("13","0","Tc","9","2","0","1374153707","4");
INSERT INTO durak_game VALUES("14","0","Vp","6","3","0","1374153708","4");
INSERT INTO durak_game VALUES("15","0","8k","3","1","0","1374153709","4");
INSERT INTO durak_game VALUES("16","0","9c","4","2","0","1374153710","4");
INSERT INTO durak_game VALUES("17","0","8p","3","3","0","1374153711","4");
INSERT INTO durak_game VALUES("18","0","Kp","8","3","0","1374153712","4");
INSERT INTO durak_game VALUES("19","0","Dk","7","1","0","1374153713","4");
INSERT INTO durak_game VALUES("20","0","6c","1","2","0","1374153714","4");
INSERT INTO durak_game VALUES("21","0","9k","4","1","0","1374153715","4");
INSERT INTO durak_game VALUES("22","0","Kc","8","2","0","1374153716","4");
INSERT INTO durak_game VALUES("23","0","Vk","6","1","0","1374153717","4");
INSERT INTO durak_game VALUES("24","0","Kk","8","1","0","1374153718","4");
INSERT INTO durak_game VALUES("25","0","Dc","7","2","0","1374153719","4");
INSERT INTO durak_game VALUES("26","0","10k","5","1","0","1374153720","4");
INSERT INTO durak_game VALUES("27","0","Tb","9","4","0","1374153721","4");
INSERT INTO durak_game VALUES("28","0","7p","2","3","0","1374153722","4");
INSERT INTO durak_game VALUES("29","0","9p","4","3","0","1374153723","4");
INSERT INTO durak_game VALUES("30","0","Kb","8","4","0","1374153724","4");
INSERT INTO durak_game VALUES("31","0","8c","3","2","0","1374153725","4");
INSERT INTO durak_game VALUES("32","0","Tk","9","1","0","1374153726","4");
INSERT INTO durak_game VALUES("33","0","6b","1","4","0","1374153727","4");
INSERT INTO durak_game VALUES("34","0","7c","2","2","0","1374153728","4");
INSERT INTO durak_game VALUES("35","0","6p","1","3","0","1374153729","4");
INSERT INTO durak_game VALUES("36","0","8b","3","4","0","1374153730","4");



DROP TABLE IF EXISTS `durak_hod`;

CREATE TABLE `durak_hod` (
  `name` varchar(4) DEFAULT NULL,
  `num` int(11) DEFAULT '0',
  `id_game` int(11) DEFAULT '0',
  `kozar` int(1) DEFAULT '0',
  `sila` int(3) DEFAULT '0',
  `id_user` int(3) DEFAULT '0',
  `mast` int(3) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `durak_karty`;

CREATE TABLE `durak_karty` (
  `name` varchar(4) DEFAULT NULL,
  `sila` int(3) DEFAULT '0',
  `mast` int(3) DEFAULT '0'
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO durak_karty VALUES("Tp","9","3");
INSERT INTO durak_karty VALUES("Kb","8","4");
INSERT INTO durak_karty VALUES("9b","4","4");
INSERT INTO durak_karty VALUES("6b","1","4");
INSERT INTO durak_karty VALUES("Tb","9","4");
INSERT INTO durak_karty VALUES("10b","5","4");
INSERT INTO durak_karty VALUES("Kp","8","3");
INSERT INTO durak_karty VALUES("Db","7","4");
INSERT INTO durak_karty VALUES("8b","3","4");
INSERT INTO durak_karty VALUES("7b","2","4");
INSERT INTO durak_karty VALUES("Vb","6","4");
INSERT INTO durak_karty VALUES("Dp","7","3");
INSERT INTO durak_karty VALUES("9p","4","3");
INSERT INTO durak_karty VALUES("Tc","9","2");
INSERT INTO durak_karty VALUES("10c","5","2");
INSERT INTO durak_karty VALUES("7k","2","1");
INSERT INTO durak_karty VALUES("6c","1","2");
INSERT INTO durak_karty VALUES("Vk","6","1");
INSERT INTO durak_karty VALUES("10p","5","3");
INSERT INTO durak_karty VALUES("6p","1","3");
INSERT INTO durak_karty VALUES("Vc","6","2");
INSERT INTO durak_karty VALUES("8k","3","1");
INSERT INTO durak_karty VALUES("7c","2","2");
INSERT INTO durak_karty VALUES("Dk","7","1");
INSERT INTO durak_karty VALUES("8p","3","3");
INSERT INTO durak_karty VALUES("Kc","8","2");
INSERT INTO durak_karty VALUES("9c","4","2");
INSERT INTO durak_karty VALUES("6k","1","1");
INSERT INTO durak_karty VALUES("Tk","9","1");
INSERT INTO durak_karty VALUES("10k","5","1");
INSERT INTO durak_karty VALUES("Vp","6","3");
INSERT INTO durak_karty VALUES("7p","2","3");
INSERT INTO durak_karty VALUES("Dc","7","2");
INSERT INTO durak_karty VALUES("9k","4","1");
INSERT INTO durak_karty VALUES("8c","3","2");
INSERT INTO durak_karty VALUES("Kk","8","1");



DROP TABLE IF EXISTS `f_message`;

CREATE TABLE `f_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `tid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `user` int(11) NOT NULL DEFAULT '0',
  `whoedit` int(11) NOT NULL DEFAULT '0',
  `date` char(20) NOT NULL,
  `podforum` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `best` tinyint(1) NOT NULL DEFAULT '0',
  `worse` tinyint(1) NOT NULL DEFAULT '0',
  `path` char(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_pod`;

CREATE TABLE `f_pod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `pid` int(11) NOT NULL DEFAULT '0',
  `name` char(50) NOT NULL DEFAULT '',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_razdel`;

CREATE TABLE `f_razdel` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` char(50) NOT NULL DEFAULT '',
  `ico` char(6) NOT NULL,
  `opis` char(70) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_them`;

CREATE TABLE `f_them` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rid` int(11) NOT NULL DEFAULT '0',
  `name` char(255) NOT NULL DEFAULT '',
  `author` int(11) NOT NULL DEFAULT '0',
  `close` smallint(2) NOT NULL DEFAULT '0',
  `whoedit` int(11) NOT NULL DEFAULT '0',
  `date` int(11) NOT NULL DEFAULT '0',
  `firstpost` text NOT NULL,
  `fix` smallint(2) NOT NULL DEFAULT '0',
  `razdel_id` int(11) NOT NULL DEFAULT '0',
  `last` int(11) NOT NULL DEFAULT '0',
  `quest` char(255) NOT NULL,
  `var1` char(30) NOT NULL,
  `var2` char(30) NOT NULL,
  `var3` char(30) NOT NULL,
  `var4` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `f_votes`;

CREATE TABLE `f_votes` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `them` int(11) NOT NULL DEFAULT '0',
  `var` smallint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `farm_ambar`;

CREATE TABLE `farm_ambar` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1235 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_conf`;

CREATE TABLE `farm_conf` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `weather` enum('1','2','3','4','5') DEFAULT '1',
  `time_weather` int(11) NOT NULL DEFAULT '0' COMMENT 'Время до следующего обновления погоды',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=17 DEFAULT CHARSET=utf8;

INSERT INTO farm_conf VALUES("3","3","1327857813");
INSERT INTO farm_conf VALUES("4","1","1593867194");
INSERT INTO farm_conf VALUES("5","3","1593967262");
INSERT INTO farm_conf VALUES("6","2","1594060171");
INSERT INTO farm_conf VALUES("7","5","1594668343");
INSERT INTO farm_conf VALUES("8","3","1594970847");
INSERT INTO farm_conf VALUES("9","4","1595093450");
INSERT INTO farm_conf VALUES("10","3","1595355194");
INSERT INTO farm_conf VALUES("11","2","1595595386");
INSERT INTO farm_conf VALUES("12","2","1595748141");
INSERT INTO farm_conf VALUES("13","5","1596141721");
INSERT INTO farm_conf VALUES("14","5","1596284334");
INSERT INTO farm_conf VALUES("15","2","1596315266");
INSERT INTO farm_conf VALUES("16","5","1596380292");



DROP TABLE IF EXISTS `farm_dog`;

CREATE TABLE `farm_dog` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1053 DEFAULT CHARSET=cp1251;

INSERT INTO farm_dog VALUES("1040","271","");
INSERT INTO farm_dog VALUES("1041","1","");
INSERT INTO farm_dog VALUES("1042","362","");
INSERT INTO farm_dog VALUES("1043","551","");
INSERT INTO farm_dog VALUES("1044","506","");
INSERT INTO farm_dog VALUES("1045","501","");
INSERT INTO farm_dog VALUES("1046","516","");
INSERT INTO farm_dog VALUES("1047","572","");
INSERT INTO farm_dog VALUES("1048","550","");
INSERT INTO farm_dog VALUES("1049","557","");
INSERT INTO farm_dog VALUES("1050","585","");
INSERT INTO farm_dog VALUES("1051","590","");
INSERT INTO farm_dog VALUES("1052","425","");



DROP TABLE IF EXISTS `farm_event`;

CREATE TABLE `farm_event` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=1131 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `farm_gr`;

CREATE TABLE `farm_gr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `woter` int(11) NOT NULL DEFAULT '0',
  `time_water` int(11) DEFAULT NULL COMMENT 'Время полива',
  `kol` varchar(1024) DEFAULT NULL COMMENT 'Количество урожая',
  `time` varchar(1024) DEFAULT NULL,
  `vskop` enum('1','0') NOT NULL DEFAULT '0' COMMENT 'Скопана ли грядка??',
  `sezon` int(11) NOT NULL DEFAULT '1' COMMENT 'Сезон растения на грядке',
  `udobr` enum('1','0') NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1129 DEFAULT CHARSET=cp1251;

INSERT INTO farm_gr VALUES("1063","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1064","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1065","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1066","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1067","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1068","271","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1069","1","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1070","1","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1071","1","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1072","1","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1073","1","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1074","362","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1075","362","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1076","362","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1077","362","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1078","362","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1079","551","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1080","551","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1081","551","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1082","551","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1083","551","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1084","506","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1085","506","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1086","506","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1087","506","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1088","506","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1089","501","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1090","501","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1091","501","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1092","501","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1093","501","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1094","516","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1095","516","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1096","516","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1097","516","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1098","516","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1099","572","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1100","572","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1101","572","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1102","572","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1103","572","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1104","550","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1105","550","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1106","550","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1107","550","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1108","550","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1109","557","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1110","557","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1111","557","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1112","557","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1113","557","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1114","585","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1115","585","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1116","585","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1117","585","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1118","585","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1119","590","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1120","590","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1121","590","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1122","590","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1123","590","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1124","425","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1125","425","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1126","425","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1127","425","0","0","0","","","0","1","0");
INSERT INTO farm_gr VALUES("1128","425","0","0","0","","","0","1","0");



DROP TABLE IF EXISTS `farm_plant`;

CREATE TABLE `farm_plant` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) NOT NULL,
  `opis` varchar(1024) DEFAULT NULL,
  `cena` int(11) NOT NULL,
  `dohod` varchar(1024) NOT NULL,
  `rand1` varchar(1024) NOT NULL,
  `rand2` varchar(1024) NOT NULL,
  `oput` varchar(1024) NOT NULL,
  `xp` float NOT NULL DEFAULT '0' COMMENT 'Сколько здоровья за единицу',
  `let` int(11) NOT NULL DEFAULT '1',
  `time` varchar(1024) DEFAULT NULL,
  `level` int(10) unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=53 DEFAULT CHARSET=utf8;

INSERT INTO farm_plant VALUES("1","Горох","Самый быстросозреваемый и простойпродукт на ферме","50","4","19","20","1","1.8","1","10800","0");
INSERT INTO farm_plant VALUES("2","Свекла","Неплохой выбор для начала","50","5","20","22","1","3.6","1","14400","1");
INSERT INTO farm_plant VALUES("3","Морковь","Неплохой выбор для начала","25","1.8","24","25","1","5","1","18000","2");
INSERT INTO farm_plant VALUES("4","Оливки","Помогает быстро набрать опыта","30","5","24","25","1","1.8","1","21600","2");
INSERT INTO farm_plant VALUES("5","Огурец","Приносит неплохое количество опыта","50","5","29","30","1","1.2","1","14400","3");
INSERT INTO farm_plant VALUES("6","Фасоль","Хороший друг фермеров","30","6","24","25","1","3","1","21600","3");
INSERT INTO farm_plant VALUES("7","Салат","Прибыльное растение","70","5","37","38","1","0.6","1","14400","4");
INSERT INTO farm_plant VALUES("8","Перец Индало","Малоурожайный, но приносящий много опыта перец","22","31","3","4","6","1.5","1","14400","4");
INSERT INTO farm_plant VALUES("9","Чеснок","Хороший овощ для обогащения","30","7","34","35","1","1.2","1","21600","5");
INSERT INTO farm_plant VALUES("10","Зелёный перец","Дорогой и выгодным фермерам овощ","30","15","29","30","3","1.2","1","50400","5");
INSERT INTO farm_plant VALUES("11","Арахис","Хороший и выгодный по многимпараметрам","30","4","57","58","1","0.9","1","28800","5");
INSERT INTO farm_plant VALUES("12","Лук","Довольно выгодный овощ по многимпараметрам","115","10","39","40","2","0.9","1","28800","6");
INSERT INTO farm_plant VALUES("13","Усатый горох","Очень скороспелый и неплохосбалансированный","75","6","29","30","1","0.9","1","10800","7");
INSERT INTO farm_plant VALUES("14","Помидор","Очень плодовитый овощ","100","9","64","65","2","1.2","1","43200","8");
INSERT INTO farm_plant VALUES("15","Болгарский перец","Очень полезный овощ в плане обучения инабирания опыта","125","30","20","21","6","1.3","1","43200","9");
INSERT INTO farm_plant VALUES("16","Китайский лук","Очень быстро растет","52","6","36","37","1","0.3","1","14400","10");
INSERT INTO farm_plant VALUES("17","Перец чили","Долго растет и не очень урожайный,затовесьма дорогой","270","65","20","21","11","1.6","1","86400","11");
INSERT INTO farm_plant VALUES("18","Кукуруза","Долго растет,зато весьма выгодна","340","31","60","61","7","0.9","1","115200","12");
INSERT INTO farm_plant VALUES("19","Капуста","Достаточно быстро растет","315","31","27","28","6","1.5","1","36000","13");
INSERT INTO farm_plant VALUES("20","Кабачок","Быстро созревает,но мало чему учит вплане опыта","170","25","25","26","6","1.8","1","28800","14");
INSERT INTO farm_plant VALUES("21","Лук батун","Созревает быстро.Цена и получаемыйопыт средние","100","19","32","33","6","0.9","1","28800","15");
INSERT INTO farm_plant VALUES("22","Американский картофель","Недорогой и практичный овощ","150","23","41","42","7","3","1","43200","16");
INSERT INTO farm_plant VALUES("23","Брюссельская капуста","Довольно выгодный сорт капусты","80","57","20","21","16","1.8","1","57600","17");
INSERT INTO farm_plant VALUES("24","Укроп","Один из самых быстровырастаемыхжителей ваших грядок","103","12","31","32","3","0.6","1","14400","18");
INSERT INTO farm_plant VALUES("25","Слива","Первое из многолетних растений","15000","41","59","60","7","0.7","15","64800","19");
INSERT INTO farm_plant VALUES("26","Дикая яблоня","Растет достаточно быстро длямноголетних","800","30","44","45","7","0.9","5","50400","20");
INSERT INTO farm_plant VALUES("27","Клубника","Многолетняя ягода","2850","53","34","35","7","0.9","3","36000","21");
INSERT INTO farm_plant VALUES("28","Дикая груша","Этот фрукт созревает обычно достаточнобыстро","4900","45","38","39","8","0.9","8","43200","22");
INSERT INTO farm_plant VALUES("29","Антоновка","Распространенный сорт яблок","13000","60","50","51","13","0.6","20","86400","23");
INSERT INTO farm_plant VALUES("30","Лимон","Растет чуть дольше,чем большинстводругих,но более выгоден","40000","152","34","35","31","0.4","5","86400","24");
INSERT INTO farm_plant VALUES("31","Грецкий орех","Как и лимон,растет дольше,но в планеопыта очень хорош","14000","91","44","45","46","5","15","93600","25");
INSERT INTO farm_plant VALUES("32","Апельсин","Весьма плодовитый","34000","79","64","65","30","6","15","79200","26");
INSERT INTO farm_plant VALUES("33","Банан","Не такие прибыльные,зато полезные дляопыта","10200","60","44","45","27","10","10","43200","27");
INSERT INTO farm_plant VALUES("34","Ананас","Сбалансированный фрукт","2500","63","59","60","51","7","15","86400","28");
INSERT INTO farm_plant VALUES("35","Папайя","Долгосозревающий фрукт","14200","120","49","50","117","12","12","108000","29");
INSERT INTO farm_plant VALUES("36","Манго","Долго созревает","12200","500","14","15","545","35","8","126000","30");
INSERT INTO farm_plant VALUES("37","Вишня","Практичная и недорогая","800","60","54","55","81","10","15","64800","31");
INSERT INTO farm_plant VALUES("38","Малазийский арбуз","Созревает весьма быстро","3700","94","19","20","79","32","5","21600","32");
INSERT INTO farm_plant VALUES("39","Лайм","Хорошо восстанавливает здоровье иочень полезен","7500","200","24","25","153","65","8","50400","33");
INSERT INTO farm_plant VALUES("40","Маракуйя","Недолговечный,но выгодный фрукт","6350","250","19","20","256","25","4","61200","34");
INSERT INTO farm_plant VALUES("41","Белая клубника","Быстро вырастает","2150","200","9","10","321","15","6","28800","34");
INSERT INTO farm_plant VALUES("42","Груша Моренцо","Сбалансированный по опыту и прибылифрукт","11000","200","19","20","231","20","12","54000","35");
INSERT INTO farm_plant VALUES("43","Киви","Высокоурожайное растение","11300","80","64","65","98","12","8","64800","36");
INSERT INTO farm_plant VALUES("44","Амазонская дыня","Быстро созревает и недолго живет","6100","300","9","10","267","30","4","25200","37");
INSERT INTO farm_plant VALUES("45","Яблоко Голиафа","Долго созревает,но саженцы стоятнедорого","200","173","49","50","314","5","10","144000","38");
INSERT INTO farm_plant VALUES("46","Мандариновый апельсин","Позволяет получить много опыта исозревает достаточно быстро","4600","85","34","35","136","6","12","43200","39");
INSERT INTO farm_plant VALUES("47","Смородина","Дешевая и выгодная ягода","750","115","19","20","201","15","8","36000","40");
INSERT INTO farm_plant VALUES("48","Фисташки","Долгосозревающее и такжедолгоживущее растение","13000","550","15","16","975","20","40","129600","41");
INSERT INTO farm_plant VALUES("49","Сладкий лимон","Очень плодоносное растение,хотя инедолговечное.","14400","102","79","80","139","30","5","86400","42");
INSERT INTO farm_plant VALUES("50","Мисакр","Экзотичная ягода с хорошимихарактеристиками","5000","84","44","45","164","10","8","50400","43");
INSERT INTO farm_plant VALUES("51","Патомак","У этого растения, в отличие отбольшинства ценятся именно корни,а нелистья или плоды. Оно быстро созревает,неплохо плодоносит, но и живет тоженедолго.","4960","70","49","50","95","5","3","28800","44");
INSERT INTO farm_plant VALUES("52","Мягоцвет","Очень быстро созревающая трава. Пустьона не очень плодоносная, зато скоростьее роста многое окупает.","600","112","9","10","293","1","3","14400","45");



DROP TABLE IF EXISTS `farm_semen`;

CREATE TABLE `farm_semen` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `semen` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  `sezon` int(11) NOT NULL DEFAULT '1' COMMENT 'Сезон растения на грядке',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1078 DEFAULT CHARSET=cp1251;

INSERT INTO farm_semen VALUES("1077","1","1","10","1");



DROP TABLE IF EXISTS `farm_udobr`;

CREATE TABLE `farm_udobr` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `udobr` int(11) NOT NULL,
  `kol` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1047 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `farm_udobr_name`;

CREATE TABLE `farm_udobr_name` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(1024) NOT NULL,
  `cena` varchar(1024) NOT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;

INSERT INTO farm_udobr_name VALUES("1","Курник","50","3600");
INSERT INTO farm_udobr_name VALUES("2","Торф","200","14400");
INSERT INTO farm_udobr_name VALUES("3","Компост","500","18000");
INSERT INTO farm_udobr_name VALUES("4","Азот","1000","36000");
INSERT INTO farm_udobr_name VALUES("5","Коровяк","3000","54000");



DROP TABLE IF EXISTS `farm_user`;

CREATE TABLE `farm_user` (
  `uid` int(11) NOT NULL DEFAULT '0',
  `posadka` int(11) NOT NULL DEFAULT '0',
  `posadka_1` enum('1','0') NOT NULL DEFAULT '0',
  `posadka_2` enum('1','0') NOT NULL DEFAULT '0',
  `posadka_3` enum('1','0') NOT NULL DEFAULT '0',
  `poliv` int(11) NOT NULL DEFAULT '0',
  `poliv_1` enum('1','0') NOT NULL DEFAULT '0',
  `poliv_2` enum('1','0') NOT NULL DEFAULT '0',
  `poliv_3` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie` int(11) NOT NULL DEFAULT '0',
  `udobrenie_1` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie_2` enum('1','0') NOT NULL DEFAULT '0',
  `udobrenie_3` enum('1','0') NOT NULL DEFAULT '0',
  `gems` int(11) NOT NULL DEFAULT '0',
  `xp` int(11) NOT NULL DEFAULT '100',
  `gold` int(11) NOT NULL DEFAULT '10000',
  `exp` int(11) NOT NULL DEFAULT '0',
  `lеvеl` int(11) NOT NULL DEFAULT '0',
  `k_poliv` int(11) NOT NULL DEFAULT '0',
  `k_posadka` int(11) NOT NULL DEFAULT '0',
  `k_posadka_time` int(11) NOT NULL DEFAULT '0',
  `k_poliv_time` int(11) NOT NULL DEFAULT '0',
  `zabor_time` int(11) NOT NULL DEFAULT '0',
  `teplica` enum('1','0') NOT NULL DEFAULT '0',
  `razvedka` enum('1','0') NOT NULL DEFAULT '0',
  `selection` enum('0','1','2','3','4','5') NOT NULL DEFAULT '0',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO farm_user VALUES("271","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("1","0","0","0","0","0","0","0","0","0","0","0","0","0","100","9500","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("362","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("551","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("506","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("501","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("516","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("572","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("550","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("557","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("585","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("590","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");
INSERT INTO farm_user VALUES("425","0","0","0","0","0","0","0","0","0","0","0","0","0","100","10000","0","0","0","0","0","0","0","0","0","0");



DROP TABLE IF EXISTS `farm_vor`;

CREATE TABLE `farm_vor` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `gr` int(11) DEFAULT NULL,
  `time` varchar(1024) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=1037 DEFAULT CHARSET=cp1251;




DROP TABLE IF EXISTS `fk`;

CREATE TABLE `fk` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(111) DEFAULT NULL,
  `rules` varchar(1111) DEFAULT NULL,
  `id_user` int(11) NOT NULL,
  `start_time` int(11) NOT NULL,
  `end_time` int(11) NOT NULL,
  `kol_vo` int(11) NOT NULL,
  `skolko` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `pobeda` int(11) NOT NULL,
  `pobeda2` int(11) NOT NULL,
  `pobeda3` int(11) NOT NULL,
  `uchastie` int(11) NOT NULL,
  `golosue` int(11) NOT NULL,
  `images` varchar(111) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;

INSERT INTO fk VALUES("1","Любовь  зто","Участвуйте в новом фотоконкурсе, выкладывайте фотографии с тем, что или кого вы любите больше всего! serdce\r\nЛюбовь - это... крепкие объятия и нежные поцелуи.\r\nИли: любовь - это ... улыбка ребёнка? А может, любовь - это... свежеиспечённый мамой пирог? Что любите вы?\r\n","324","1590679018","1591111018","10","3","0","35000","30000","20000","5000","1000","15906791641.jpg");
INSERT INTO fk VALUES("2","Ночной город","Загружаете картинки и фото город, поселок в ночное время","324","1590949182","1591381182","30","3","0","50000","40000","30000","5000","2000","15909492041.jpg");
INSERT INTO fk VALUES("3","Летний отдых","Загружайте фото и картинки, где хотели бы отдохнуть летом","324","1591093389","1591525389","30","3","0","10000","8000","6000","2000","1000","15910934101.jpg");
INSERT INTO fk VALUES("4","Цветы","Загружайте фото и картинки разных цветов","324","1591292775","1591724775","30","3","0","10000","8000","6000","2000","1000","15912927961.jpg");
INSERT INTO fk VALUES("5","Такое разное небо","На тот фотоконкурс, принимаются фотографии с изображением неба ! Фото из инета разрешены! Но возможно у вас есть свои фотографии , заката, рассвета или просто красивого голубого неба!","324","1591429695","1591861695","30","3","0","7000","5000","3000","1000","500","15914297301.jpg");
INSERT INTO fk VALUES("6","Живописный вечер"," на конкурс принимаются фотографии с изображением вечернего пейзажа","324","1591879245","1592311245","15","3","0","5000","4000","3000","1000","500","15918792791.jpg");
INSERT INTO fk VALUES("7","Фонтаны",": Уважаемые пользователи нашего сайта. Приглашаем вас принять участие в фотоконкурсе Фонтаны, Загружаем фоточки или картинки на заданную тему. Фото с рекламой другого ресурса будет заблокировано или удалено без предупреждения. Всем желаем удачи и победы!","324","1591881016","1592313016","15","3","0","5000","4000","3000","1000","500","15918810321.jpg");
INSERT INTO fk VALUES("8","Искусство граффити","Грузим изображения по заданной теме","324","1592196515","1592628515","15","3","0","5000","4000","3000","1000","700","15921967051.jpg");
INSERT INTO fk VALUES("9","Храм","Грузим храмы всего мира","324","1592197315","1592629315","15","3","0","5000","4000","3000","1000","700","15921973361.jpg");
INSERT INTO fk VALUES("10","Мистер сайта","Принимаются только настоящие и реальные ваши фотографии,а не те картинки которые у многих на Аве!","362","1592312791","1593608791","20","1","0","15000","10000","5000","2000","1000","15923128591.jpg");
INSERT INTO fk VALUES("11","Мисс сайта","Принимаются только ваши настоящие и реальные фотографии,а не те картинки которые у некоторых на Аве!","362","1592313419","1593609419","20","1","0","15000","10000","5000","2000","1000","15923134471.jpg");
INSERT INTO fk VALUES("12","Моё любимое мороженое","Загружаем картинки на заданную тему!","362","1592332890","1593196890","12","4","0","13000","10000","5000","2000","1000","15923329041.jpg");
INSERT INTO fk VALUES("13","натюрморт","Загружаем картинки и фото по заданной теме","324","1593337277","1593769277","30","3","0","7000","5000","3000","1000","500","15933373061.jpg");
INSERT INTO fk VALUES("14","клубничное лето","Устроим в этом фотоконкурсе клубничный бум! Добавляйте фотографии этой вкусной, летней ягоды! Фото из инета разрешены!","324","1593337437","1593769437","30","3","0","7000","5000","3000","1000","500","15933374561.jpg");



DROP TABLE IF EXISTS `fk_discus`;

CREATE TABLE `fk_discus` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fk_foto`;

CREATE TABLE `fk_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `golosov` int(11) NOT NULL,
  `active` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `images` varchar(111) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=32 DEFAULT CHARSET=utf8;

INSERT INTO fk_foto VALUES("1","1","328","2","1","1590679711","15906797111.jpeg");
INSERT INTO fk_foto VALUES("2","2","345","2","1","1590951639","15909516391.jpg");
INSERT INTO fk_foto VALUES("3","2","339","1","1","1590953143","15909531431.jpg");
INSERT INTO fk_foto VALUES("4","3","326","1","1","1591098553","15910985531.jpg");
INSERT INTO fk_foto VALUES("5","2","357","1","1","1591100810","15911008101.jpg");
INSERT INTO fk_foto VALUES("6","2","326","0","1","1591118428","15911184281.jpg");
INSERT INTO fk_foto VALUES("7","4","325","1","1","1591303988","15913039881.gif");
INSERT INTO fk_foto VALUES("8","4","362","1","1","1591462980","15914629801.gif");
INSERT INTO fk_foto VALUES("9","5","362","1","1","1591463337","15914633371.jpg");
INSERT INTO fk_foto VALUES("10","6","411","1","1","1591888483","15918884831.jpg");
INSERT INTO fk_foto VALUES("11","7","326","1","1","1591902637","15919026371.jpg");
INSERT INTO fk_foto VALUES("12","7","339","2","1","1591976431","15919764311.jpg");
INSERT INTO fk_foto VALUES("13","7","391","1","1","1592018850","15920188501.gif");
INSERT INTO fk_foto VALUES("14","6","391","2","1","1592019018","15920190181.jpg");
INSERT INTO fk_foto VALUES("15","8","391","2","1","1592197586","15921975861.jpeg");
INSERT INTO fk_foto VALUES("16","9","391","2","1","1592312188","15923121881.jpg");
INSERT INTO fk_foto VALUES("17","11","391","3","1","1592313686","15923136861.jpg");
INSERT INTO fk_foto VALUES("19","8","362","2","1","1592328998","15923289981.jpg");
INSERT INTO fk_foto VALUES("20","9","362","2","1","1592329285","15923292851.jpg");
INSERT INTO fk_foto VALUES("21","11","380","2","1","1592401562","15924015621.jpg");
INSERT INTO fk_foto VALUES("23","11","431","0","1","1592532641","15925326411.jpg");
INSERT INTO fk_foto VALUES("24","11","506","2","1","1593196765","15931967651.jpg");
INSERT INTO fk_foto VALUES("25","11","509","0","1","1593202428","15932024281.jpeg");
INSERT INTO fk_foto VALUES("26","14","505","5","1","1593339075","15933390761.jpg");
INSERT INTO fk_foto VALUES("27","13","505","3","1","1593339375","15933393751.jpg");
INSERT INTO fk_foto VALUES("28","10","519","0","1","1593342414","15933424141.gif");
INSERT INTO fk_foto VALUES("29","13","512","3","1","1593348044","15933480441.jpg");
INSERT INTO fk_foto VALUES("30","14","512","3","1","1593348081","15933480811.jpg");
INSERT INTO fk_foto VALUES("31","13","506","3","1","1593350590","15933505901.jpg");



DROP TABLE IF EXISTS `fk_golos`;

CREATE TABLE `fk_golos` (
  `id_foto` int(11) NOT NULL,
  `id_fk` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO fk_golos VALUES("1","1","324","1590680793");
INSERT INTO fk_golos VALUES("1","1","326","1590691012");
INSERT INTO fk_golos VALUES("2","2","326","1590952731");
INSERT INTO fk_golos VALUES("3","2","324","1590954059");
INSERT INTO fk_golos VALUES("2","2","324","1590954064");
INSERT INTO fk_golos VALUES("4","3","324","1591100224");
INSERT INTO fk_golos VALUES("5","2","324","1591111510");
INSERT INTO fk_golos VALUES("7","4","324","1591384461");
INSERT INTO fk_golos VALUES("8","4","324","1591466569");
INSERT INTO fk_golos VALUES("9","5","324","1591466602");
INSERT INTO fk_golos VALUES("10","6","324","1591892663");
INSERT INTO fk_golos VALUES("11","7","324","1591985392");
INSERT INTO fk_golos VALUES("12","7","324","1591985396");
INSERT INTO fk_golos VALUES("13","7","324","1592197526");
INSERT INTO fk_golos VALUES("14","6","324","1592197602");
INSERT INTO fk_golos VALUES("15","8","324","1592197655");
INSERT INTO fk_golos VALUES("12","7","432","1592240624");
INSERT INTO fk_golos VALUES("14","6","432","1592240714");
INSERT INTO fk_golos VALUES("19","8","326","1592341638");
INSERT INTO fk_golos VALUES("15","8","326","1592341654");
INSERT INTO fk_golos VALUES("19","8","324","1592385628");
INSERT INTO fk_golos VALUES("16","9","324","1592385648");
INSERT INTO fk_golos VALUES("20","9","324","1592385654");
INSERT INTO fk_golos VALUES("16","9","440","1592493165");
INSERT INTO fk_golos VALUES("17","11","324","1592385752");
INSERT INTO fk_golos VALUES("21","11","326","1592415192");
INSERT INTO fk_golos VALUES("17","11","396","1592464521");
INSERT INTO fk_golos VALUES("20","9","440","1592493172");
INSERT INTO fk_golos VALUES("17","11","431","1592532675");
INSERT INTO fk_golos VALUES("24","11","505","1593235821");
INSERT INTO fk_golos VALUES("21","11","507","1593236982");
INSERT INTO fk_golos VALUES("26","14","512","1593341738");
INSERT INTO fk_golos VALUES("26","14","504","1593343850");
INSERT INTO fk_golos VALUES("29","13","324","1593349455");
INSERT INTO fk_golos VALUES("27","13","324","1593349477");
INSERT INTO fk_golos VALUES("30","14","324","1593349531");
INSERT INTO fk_golos VALUES("26","14","324","1593349567");
INSERT INTO fk_golos VALUES("31","13","505","1593350762");
INSERT INTO fk_golos VALUES("24","11","512","1593377271");
INSERT INTO fk_golos VALUES("29","13","519","1593610472");
INSERT INTO fk_golos VALUES("27","13","519","1593610485");
INSERT INTO fk_golos VALUES("31","13","519","1593610512");
INSERT INTO fk_golos VALUES("30","14","505","1593610546");
INSERT INTO fk_golos VALUES("26","14","506","1593683955");
INSERT INTO fk_golos VALUES("30","14","431","1593741914");
INSERT INTO fk_golos VALUES("26","14","431","1593741917");
INSERT INTO fk_golos VALUES("31","13","431","1593741931");
INSERT INTO fk_golos VALUES("29","13","431","1593741935");
INSERT INTO fk_golos VALUES("27","13","431","1593741938");



DROP TABLE IF EXISTS `fl_notifs`;

CREATE TABLE `fl_notifs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `mail` int(11) NOT NULL DEFAULT '1',
  `notifications` int(11) NOT NULL DEFAULT '1',
  `new_friends` int(11) NOT NULL DEFAULT '1',
  `lst_mail_id` int(11) NOT NULL DEFAULT '0',
  `lst_notifications_id` int(11) NOT NULL DEFAULT '0',
  `lst_new_friends_id` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  UNIQUE KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COMMENT='Всплывающие уведомления';




DROP TABLE IF EXISTS `fo_cat`;

CREATE TABLE `fo_cat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` char(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=9 DEFAULT CHARSET=utf8;

INSERT INTO fo_cat VALUES("1","Программы wap-мастеру");
INSERT INTO fo_cat VALUES("2","Скрипты php");
INSERT INTO fo_cat VALUES("3","Скрипты ajax и javascript");
INSERT INTO fo_cat VALUES("4","Темы для CMS");
INSERT INTO fo_cat VALUES("5","Модули для CMS");
INSERT INTO fo_cat VALUES("6","Аудио/Видео уроки");
INSERT INTO fo_cat VALUES("7","JAR Учебники");
INSERT INTO fo_cat VALUES("8","Все для дизайна и дизайнеров");



DROP TABLE IF EXISTS `fo_files`;

CREATE TABLE `fo_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `url` char(100) NOT NULL,
  `time` int(11) NOT NULL,
  `clicks` int(11) NOT NULL DEFAULT '0',
  `author` int(11) NOT NULL,
  `title` char(100) NOT NULL,
  `info` text NOT NULL,
  `parol` char(10) DEFAULT NULL,
  `moder` smallint(2) NOT NULL DEFAULT '0',
  `rid` int(11) NOT NULL DEFAULT '0',
  `cat` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fo_komm`;

CREATE TABLE `fo_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `uid` int(11) NOT NULL DEFAULT '0',
  `msg` text NOT NULL,
  `date` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `fo_pod`;

CREATE TABLE `fo_pod` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL DEFAULT '0',
  `title` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=43 DEFAULT CHARSET=utf8;

INSERT INTO fo_pod VALUES("1","1","JAVA программы");
INSERT INTO fo_pod VALUES("2","1","Софт для WindowsMobile");
INSERT INTO fo_pod VALUES("3","1","Программы для ANDROID");
INSERT INTO fo_pod VALUES("4","1","Программы для Symbian");
INSERT INTO fo_pod VALUES("5","1","Программы для WINDOWS ПК");
INSERT INTO fo_pod VALUES("6","1","Системы защиты php кода");
INSERT INTO fo_pod VALUES("7","2","Скрипты php web");
INSERT INTO fo_pod VALUES("8","2","Скрипты php wap");
INSERT INTO fo_pod VALUES("9","6","Как эффективно продвинуть сайт в интернете");
INSERT INTO fo_pod VALUES("10","6","SeO раскрутка, анализ, ключевые слова");
INSERT INTO fo_pod VALUES("11","6","Как устроен GOOGLE + История");
INSERT INTO fo_pod VALUES("12","6","Оптимизация, ТиЦ и PR");
INSERT INTO fo_pod VALUES("13","6","Создание и раскрутка сайта / блога");
INSERT INTO fo_pod VALUES("14","3","ASP скрипты");
INSERT INTO fo_pod VALUES("15","3","Ajax скрипты");
INSERT INTO fo_pod VALUES("16","3","JavaScript");
INSERT INTO fo_pod VALUES("17","4","DCMS 6.6.x");
INSERT INTO fo_pod VALUES("18","4","DCMS 6.7.x");
INSERT INTO fo_pod VALUES("19","4","Wap-Motor");
INSERT INTO fo_pod VALUES("20","4","DCMS 7.0.x");
INSERT INTO fo_pod VALUES("21","4","MobileCMS");
INSERT INTO fo_pod VALUES("22","4","JohnCMS");
INSERT INTO fo_pod VALUES("23","4","php bb wap");
INSERT INTO fo_pod VALUES("24","5","DCMS модули");
INSERT INTO fo_pod VALUES("25","5","Wap-Motor модули");
INSERT INTO fo_pod VALUES("26","5","Wap-Engine");
INSERT INTO fo_pod VALUES("27","5","JohnCMS модули");
INSERT INTO fo_pod VALUES("28","5","MobileCMS");
INSERT INTO fo_pod VALUES("29","5","RotorCMS");
INSERT INTO fo_pod VALUES("30","5","phpBB-WAP моды");
INSERT INTO fo_pod VALUES("31","5","Разные CMS");
INSERT INTO fo_pod VALUES("32","7","WML");
INSERT INTO fo_pod VALUES("33","7","HTML");
INSERT INTO fo_pod VALUES("34","7","PHP");
INSERT INTO fo_pod VALUES("35","7","CSS");
INSERT INTO fo_pod VALUES("36","7","JAVA");
INSERT INTO fo_pod VALUES("37","7","MySQL");
INSERT INTO fo_pod VALUES("38","8","Дизайнеру + CSS");
INSERT INTO fo_pod VALUES("39","8","Иконки и графика");
INSERT INTO fo_pod VALUES("40","8","Touch (Тач) дизайны");
INSERT INTO fo_pod VALUES("41","2","Скрипты Вобля");
INSERT INTO fo_pod VALUES("42","2","Чаты");



DROP TABLE IF EXISTS `fortune`;

CREATE TABLE `fortune` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `v` int(11) NOT NULL,
  `cena` int(11) NOT NULL,
  `rating` int(11) NOT NULL,
  `fart` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8;

INSERT INTO fortune VALUES("1","Обезьянка","0","100","4","2");
INSERT INTO fortune VALUES("4","Котёнок","2","2","4","2");
INSERT INTO fortune VALUES("2","Цветок","0","100","3","1");
INSERT INTO fortune VALUES("3","Подарок","0","100","5","3");
INSERT INTO fortune VALUES("5","Пламя","0","50","2","2");
INSERT INTO fortune VALUES("6","Монеты","0","200","2","3");
INSERT INTO fortune VALUES("7","Бабочка","1","1000","4","2");
INSERT INTO fortune VALUES("8","Пара","0","50","5","3");
INSERT INTO fortune VALUES("9","Девушка","0","70","4","2");
INSERT INTO fortune VALUES("10","Банкрот","0","100","10","5");



DROP TABLE IF EXISTS `fortune_history`;

CREATE TABLE `fortune_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `msg` varchar(1024) CHARACTER SET utf8 COLLATE utf8_unicode_ci DEFAULT NULL,
  `f` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=7772 DEFAULT CHARSET=utf8;

INSERT INTO fortune_history VALUES("7602","1","1591422440","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7603","1","1591422440"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7604","1","1591422444","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7605","1","1591422564","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7606","1","1591422564"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7607","1","1591422749","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7608","1","1591422749"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7609","1","1591422826","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7610","1","1591422826"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7611","1","1591422895"," сектор [b] Бабочка [/b]   + 1000 баллов  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7612","1","1591422895","[b] Бабочка [/b]\r\n+ 1000 баллов\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7613","1","1591423029","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7614","1","1591423029"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7615","324","1591423100","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7616","373","1591423114","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7617","324","1591423119","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7618","324","1591423119"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7619","373","1591423134","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7620","373","1591423134"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7621","1","1591423199","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7622","1","1591423199"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7623","324","1591423209","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7624","324","1591423209"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7625","373","1591423234","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7626","373","1591423234"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7627","1","1591423242","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7628","324","1591423370","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7629","324","1591423370"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7630","373","1591423373","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7631","373","1591423373"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7632","373","1591423442","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7633","373","1591423442"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7634","373","1591423562"," сектор [b] Бабочка [/b]   + 1000 баллов  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7635","373","1591423562","[b] Бабочка [/b]\r\n+ 1000 баллов\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7636","373","1591423665","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7637","373","1591423665"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7638","373","1591423733","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7639","373","1591423747","[b] Девушка [/b]\r\n+ 70 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7640","373","1591423747"," сектор [b] Девушка [/b]   + 70 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7641","1","1591423817","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7642","1","1591423817"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7643","1","1591424498","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7644","1","1591424498"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7645","324","1591428587","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7646","324","1591428587"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7647","373","1591430504","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7648","373","1591430504"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7649","373","1591430581","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7650","373","1591430581"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7651","373","1591430704","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7652","373","1591430704"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7653","373","1591430710","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7654","373","1591430779"," сектор [b] Бабочка [/b]   + 1000 баллов  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7655","373","1591430779","[b] Бабочка [/b]\r\n+ 1000 баллов\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7656","373","1591430847","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7657","373","1591430847"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7658","373","1591430956","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7659","373","1591430956"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7660","373","1591431036","[b] Девушка [/b]\r\n+ 70 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7661","373","1591431036"," сектор [b] Девушка [/b]   + 70 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7662","373","1591431103","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7663","373","1591431103"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7664","373","1591431274","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7665","373","1591431274"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7666","373","1591431278","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7667","373","1591431344","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7668","373","1591431344"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7669","373","1591431414","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7670","373","1591431414"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7671","373","1591431536","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7672","373","1591431536"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7673","373","1591431621","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7674","373","1591431621"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7675","373","1591431694","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7676","373","1591431694"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7677","373","1591431702","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7678","373","1591431970","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7679","373","1591431970"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7680","373","1591432033","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7681","373","1591432033"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7682","373","1591432105"," сектор [b] Бабочка [/b]   + 1000 баллов  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7683","373","1591432105","[b] Бабочка [/b]\r\n+ 1000 баллов\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7684","373","1591432187","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7685","373","1591432187"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7686","373","1591432634"," сектор [b] Бабочка [/b]   + 1000 баллов  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7687","373","1591432634","[b] Бабочка [/b]\r\n+ 1000 баллов\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7688","373","1591432714","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7689","373","1591432714"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7690","373","1591432802","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7691","373","1591432802"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7692","373","1591432809","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7693","373","1591432907","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7694","373","1591432907"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7695","373","1591432978","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7696","373","1591432978"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7697","373","1591433045","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7698","373","1591433045"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7699","373","1591433140","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7700","373","1591433140"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7701","373","1591433214","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7702","373","1591433214"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7703","373","1591433294","[b] Девушка [/b]\r\n+ 70 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7704","373","1591433294"," сектор [b] Девушка [/b]   + 70 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7705","373","1591433299","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7706","373","1591433413","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7707","373","1591433413"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7708","373","1591433634","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7709","373","1591433634"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7710","373","1591433700","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7711","373","1591433700"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7712","373","1591433793","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7713","373","1591433793"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7714","373","1591433868","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7715","373","1591433868"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7716","373","1591433996","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7717","373","1591433996"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7718","373","1591434087","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7719","373","1591434087"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7720","373","1591434091","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7721","373","1591435820","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7722","373","1591435820"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7723","373","1591435901","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7724","373","1591435901"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7725","373","1591435991","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7726","373","1591435991"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7727","373","1591436065","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7728","373","1591436065"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7729","373","1591436130","[b] Подарок [/b]\r\n+ 100 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7730","373","1591436130"," сектор [b] Подарок [/b]   + 100 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7731","373","1591436223","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7732","373","1591436223"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7733","373","1591436344","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7734","373","1591436344"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7735","373","1591436349","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7736","373","1591436413","[b] Девушка [/b]\r\n+ 70 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7737","373","1591436413"," сектор [b] Девушка [/b]   + 70 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7738","373","1591436527","[b] Обезьянка [/b]\r\n+ 100 монет\r\n+ 4 рейтинга\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7739","373","1591436527"," сектор [b] Обезьянка [/b]   + 100 монет  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7740","373","1591436598","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7741","373","1591436598"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7742","373","1591436696","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7743","373","1591436696"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7744","324","1591448313","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7745","324","1591448313"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7746","373","1591451108","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7747","373","1591451108"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7748","373","1591451221","[b] Монеты [/b]\r\n+ 200 монет\r\n+ 2 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7749","373","1591451221"," сектор [b] Монеты [/b]   + 200 монет  + 2 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7750","373","1591451483","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7751","373","1591451483"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7752","373","1591451587","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7753","373","1591451587"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7754","373","1591451592","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7755","373","1591451655","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7756","373","1591451655"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7757","373","1591451722","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7758","373","1591451722"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7759","373","1591451836","[b] Пламя [/b]\r\n- 50 монет\r\n- 2 рейтинга игры\r\n- 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7760","373","1591451836"," сектор [b] Пламя [/b]   -50 монет  - 2 рейт. - 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7761","373","1591451903","[b] Пара [/b]\r\n+ 50 монет\r\n+ 5 рейтинга\r\n+ 3 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7762","373","1591451903"," сектор [b] Пара [/b]   + 50 монет  + 5 рейт. + 3 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7763","373","1591451907","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7764","373","1591452006","[b] Котёнок [/b]\r\n+ 2 руб.\r\n+ 4 рейтинга игры\r\n+ 2 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7765","373","1591452006"," сектор [b] Котёнок [/b]   + 2 руб  + 4 рейт. + 2 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7766","373","1591452158","[b] Банкрот [/b]\r\n- 100 монет\r\n- 10 рейтинга игры\r\n- 5 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7767","373","1591452158"," сектор [b] Банкрот [/b]   -100 монет  - 10 рейт. - 5 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7768","351","1591453739","Покупка + 10 сердец\r\n","0");
INSERT INTO fortune_history VALUES("7769","351","1591453757","[b] Цветок [/b]\r\n+ 100 монет\r\n+ 3 рейтинга\r\n+ 1 фарта.\r\n","0");
INSERT INTO fortune_history VALUES("7770","351","1591453757"," сектор [b] Цветок [/b]   + 100 монет  + 3 рейт. + 1 фарта.\r\n","1");
INSERT INTO fortune_history VALUES("7771","362","1591460085","Покупка + 10 сердец\r\n","0");



DROP TABLE IF EXISTS `fortune_us`;

CREATE TABLE `fortune_us` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `fart` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3665 DEFAULT CHARSET=utf8;

INSERT INTO fortune_us VALUES("3588","1","2");
INSERT INTO fortune_us VALUES("3589","1","4");
INSERT INTO fortune_us VALUES("3590","1","1");
INSERT INTO fortune_us VALUES("3591","1","8");
INSERT INTO fortune_us VALUES("3592","1","7");
INSERT INTO fortune_us VALUES("3593","1","5");
INSERT INTO fortune_us VALUES("3594","324","1");
INSERT INTO fortune_us VALUES("3595","373","3");
INSERT INTO fortune_us VALUES("3596","1","10");
INSERT INTO fortune_us VALUES("3597","324","6");
INSERT INTO fortune_us VALUES("3598","373","3");
INSERT INTO fortune_us VALUES("3599","324","8");
INSERT INTO fortune_us VALUES("3600","373","5");
INSERT INTO fortune_us VALUES("3601","373","10");
INSERT INTO fortune_us VALUES("3602","373","7");
INSERT INTO fortune_us VALUES("3603","373","5");
INSERT INTO fortune_us VALUES("3604","373","9");
INSERT INTO fortune_us VALUES("3605","1","2");
INSERT INTO fortune_us VALUES("3606","1","6");
INSERT INTO fortune_us VALUES("3607","324","4");
INSERT INTO fortune_us VALUES("3608","373","5");
INSERT INTO fortune_us VALUES("3609","373","6");
INSERT INTO fortune_us VALUES("3610","373","10");
INSERT INTO fortune_us VALUES("3611","373","7");
INSERT INTO fortune_us VALUES("3612","373","6");
INSERT INTO fortune_us VALUES("3613","373","5");
INSERT INTO fortune_us VALUES("3614","373","9");
INSERT INTO fortune_us VALUES("3615","373","10");
INSERT INTO fortune_us VALUES("3616","373","10");
INSERT INTO fortune_us VALUES("3617","373","4");
INSERT INTO fortune_us VALUES("3618","373","2");
INSERT INTO fortune_us VALUES("3619","373","8");
INSERT INTO fortune_us VALUES("3620","373","10");
INSERT INTO fortune_us VALUES("3621","373","5");
INSERT INTO fortune_us VALUES("3622","373","3");
INSERT INTO fortune_us VALUES("3623","373","8");
INSERT INTO fortune_us VALUES("3624","373","7");
INSERT INTO fortune_us VALUES("3625","373","5");
INSERT INTO fortune_us VALUES("3626","373","7");
INSERT INTO fortune_us VALUES("3627","373","6");
INSERT INTO fortune_us VALUES("3628","373","5");
INSERT INTO fortune_us VALUES("3629","373","3");
INSERT INTO fortune_us VALUES("3630","373","5");
INSERT INTO fortune_us VALUES("3631","373","2");
INSERT INTO fortune_us VALUES("3632","373","1");
INSERT INTO fortune_us VALUES("3633","373","3");
INSERT INTO fortune_us VALUES("3634","373","9");
INSERT INTO fortune_us VALUES("3635","373","10");
INSERT INTO fortune_us VALUES("3636","373","2");
INSERT INTO fortune_us VALUES("3637","373","6");
INSERT INTO fortune_us VALUES("3638","373","2");
INSERT INTO fortune_us VALUES("3639","373","4");
INSERT INTO fortune_us VALUES("3640","373","4");
INSERT INTO fortune_us VALUES("3641","373","10");
INSERT INTO fortune_us VALUES("3642","373","1");
INSERT INTO fortune_us VALUES("3643","373","6");
INSERT INTO fortune_us VALUES("3644","373","8");
INSERT INTO fortune_us VALUES("3645","373","1");
INSERT INTO fortune_us VALUES("3646","373","3");
INSERT INTO fortune_us VALUES("3647","373","10");
INSERT INTO fortune_us VALUES("3648","373","5");
INSERT INTO fortune_us VALUES("3649","373","9");
INSERT INTO fortune_us VALUES("3650","373","1");
INSERT INTO fortune_us VALUES("3651","373","6");
INSERT INTO fortune_us VALUES("3652","373","6");
INSERT INTO fortune_us VALUES("3653","324","6");
INSERT INTO fortune_us VALUES("3654","373","6");
INSERT INTO fortune_us VALUES("3655","373","6");
INSERT INTO fortune_us VALUES("3656","373","4");
INSERT INTO fortune_us VALUES("3657","373","10");
INSERT INTO fortune_us VALUES("3658","373","5");
INSERT INTO fortune_us VALUES("3659","373","4");
INSERT INTO fortune_us VALUES("3660","373","5");
INSERT INTO fortune_us VALUES("3661","373","8");
INSERT INTO fortune_us VALUES("3662","373","4");
INSERT INTO fortune_us VALUES("3663","373","10");
INSERT INTO fortune_us VALUES("3664","351","2");



DROP TABLE IF EXISTS `forum_f`;

CREATE TABLE `forum_f` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(32) NOT NULL,
  `pos` int(11) NOT NULL,
  `opis` varchar(512) NOT NULL,
  `adm` set('0','1') NOT NULL DEFAULT '0',
  `icon` varchar(30) DEFAULT 'default',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=16 DEFAULT CHARSET=utf8;

INSERT INTO forum_f VALUES("1","Музыка","7","Все,что связано с музыкой .музон.","0","f_music.gif");
INSERT INTO forum_f VALUES("2","Игры и развлечения","4","Игры и конкурсы сайта .болельщица.","0","f_mobil.gif");
INSERT INTO forum_f VALUES("3","Любовь/ Секс/ Дружба/ Отношения","5","Все о любви, дружбе, отношении и сексе!.ах.","0","F_seks.gif");
INSERT INTO forum_f VALUES("4","Досуг и увличения","6","Отдых, Туризм, Кино, Авто/Мото и многое другое .пишу.","0","f_dosug.gif");
INSERT INTO forum_f VALUES("5"," Мобильные телефоны","8","Обсуждение телефонов,покупка продажа! .чит3.","0","f_vse_mobil.gif");
INSERT INTO forum_f VALUES("6","Тематические форумы","3","Обо всем на свете! .чит2.","0","f_tematijka.gif");
INSERT INTO forum_f VALUES("7","Общение и знакомство ","2","Общение между пользователями нашего сайта .дружба.","0","f_obshenie.gif");
INSERT INTO forum_f VALUES("8","НоВоСтИ ФоРуМа","1",".ор.","0","f_news.gif");
INSERT INTO forum_f VALUES("9","Компьютеры","9","Все о компьютерах .чит.","0","f_jkomp.gif");
INSERT INTO forum_f VALUES("10","Беспредел","10","No comments... .дразнилка.","0","bespredel.gif");
INSERT INTO forum_f VALUES("11","Помощь НОВЕЧКАМ","11","ЧИТАТЬ ВСЕМ","0","default.png");
INSERT INTO forum_f VALUES("12",".игрыраз. ","12","Играем и выигрываем","0","f_dosug.gif");
INSERT INTO forum_f VALUES("13","Кулинария","6","Разные рецепты","0","f_news.gif");



DROP TABLE IF EXISTS `forum_files`;

CREATE TABLE `forum_files` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_post` int(11) NOT NULL,
  `name` varchar(64) DEFAULT NULL,
  `ras` varchar(32) NOT NULL,
  `size` int(11) NOT NULL,
  `type` varchar(32) NOT NULL,
  `count` int(11) NOT NULL DEFAULT '0',
  `rating` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_post` (`id_post`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;

INSERT INTO forum_files VALUES("1","79","1671539oR7Mc6rF","jpg","10006","image/jpeg","0","0");



DROP TABLE IF EXISTS `forum_files_rating`;

CREATE TABLE `forum_files_rating` (
  `id_file` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `rating` int(11) DEFAULT '0',
  KEY `id_file` (`id_file`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `forum_p`;

CREATE TABLE `forum_p` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  `cit` int(11) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`),
  KEY `time` (`time`),
  KEY `id_forum` (`id_forum`),
  KEY `id_razdel` (`id_razdel`),
  KEY `id_them` (`id_them`),
  FULLTEXT KEY `msg` (`msg`)
) ENGINE=MyISAM AUTO_INCREMENT=566 DEFAULT CHARSET=utf8;

INSERT INTO forum_p VALUES("1","2","11","2","324","1590598907","МосквА","0");
INSERT INTO forum_p VALUES("2","2","11","3","324","1590599023","МариЯ","0");
INSERT INTO forum_p VALUES("3","2","11","5","324","1590599186","Черный ворон","0");
INSERT INTO forum_p VALUES("4","2","11","7","324","1590599405","Лошадь","0");
INSERT INTO forum_p VALUES("5","2","11","22","324","1590682248","Крылатая ракета","0");
INSERT INTO forum_p VALUES("6","2","11","23","324","1590682421","НКВД","0");
INSERT INTO forum_p VALUES("23","2","12","44","368","1591181082",".2. ","0");
INSERT INTO forum_p VALUES("24","2","12","44","362","1591219859",".3..","0");
INSERT INTO forum_p VALUES("21","2","12","44","367","1591179224","1.ор.","0");
INSERT INTO forum_p VALUES("22","2","11","6","367","1591179311","Сом.глазами.","0");
INSERT INTO forum_p VALUES("9","6","5","49","325","1590972882","Волосы и ногти\r\n10. Волосы на лице растут быстрее, чем где бы то ни было еще.\r\n11. Ежедневно человек теряет в среднем от 60 до 100 волос.\r\n12. Диаметр женских волос вдвое меньше, чем мужских.\r\n13. Человеческий волос может выдержать вес в 100 г.\r\n14. Ноготь на среднем пальце растет быстрее остальных.\r\n15. На квадратном сантиметре тела человека волос столько же, сколько на квадратном сантиметре тела шимпанзе.\r\n16. У блондинов больше волос.\r\n17. Ногти на руках растут примерно в 4 раза быстрее, чем на ногах.\r\n18. Средняя продолжительность жизни человеческого волоса — 3—7 лет.\r\n19. Нужно облысеть по меньшей мере наполовину, чтобы это стало заметным.\r\n20. Человеческие волосы практически не поддаются разрушению.","0");
INSERT INTO forum_p VALUES("10","6","5","49","325","1590972993","Внутренние органы\r\n21. Самый большой внутренний орган — тонкий кишечник.\r\n22. Человеческое сердце создает давление, которого достаточно, чтобы кровь брызнула на семь с половиной метров вперед.\r\n23. Кислота, содержащаяся в желудке, может растворить бритвенные лезвия.\r\n24. Длина всех кровеносных сосудов человеческого тела — около 96 000 км.\r\n25. Желудок полностью обновляется каждые 3—4 дня.\r\n26. Площадь поверхности легких человека равна площади теннисного корта.\r\n27. Женское сердце бьется быстрее мужского.\r\n28. Ученые говорят, что у печени более 500 функций.\r\n29. Аорта имеет диаметр, почти равный диаметру садового шланга.\r\n30. Левое легкое меньше правого — чтобы было место для сердца.\r\n31. Можно удалить большую часть внутренних органов и жить дальше.\r\n32. Надпочечники меняют размер на протяжении всей человеческой жизни.","0");
INSERT INTO forum_p VALUES("11","6","5","49","325","1590973273","Мозг\r\n33. Нервные импульсы двигаются со скоростью 270 км/ч.\r\n34. Для работы мозгу требуется столько же энергии, сколько 10-ваттной лампочке.\r\n35. Клетка человеческого мозга может хранить в пять раз больше информации, чем любая энциклопедия.\r\n36. Мозг использует 20% всего кислорода, который поступает в кровеносную систему.\r\n37. Ночью мозг гораздо активнее, чем днем.\r\n38. Ученые говорят, что чем выше уровень IQ, тем чаще люди видят сны.\r\n39. Нейроны продолжают расти в течение всей жизни человека.\r\n40. Информация проходит по разным нейронам с разной скоростью.\r\n41. Сам мозг не чувствует боли.\r\n42. На 80% мозг состоит из воды.","0");
INSERT INTO forum_p VALUES("12","6","5","49","325","1590973368","Секс и продолжение рода\r\n43. Каждый божий день в мире происходит 120 миллионов половых актов.\r\n44. Самая большая клетка человека — яйцеклетка, а самая маленькая — сперматозоид.\r\n45. Во время первого триместра беременности женщины чаще всего видят во сне лягушек, червей и растения.\r\n46. Зубы начинают расти за шесть месяцев до появления на свет.\r\n47. Почти все дети рождаются с голубыми глазами.\r\n48. Дети сильны, как быки.\r\n49. Один из 2 000 детей рождается с зубом.\r\n50. Плод приобретает отпечатки пальцев в возрасте трех месяцев.\r\n51. Каждый человек полчаса своей жизни был одной-единственной клеткой.\r\n52. У большинства мужчин эрекция происходит каждый час или каждые полтора часа во время сна: ведь ночью мозг гораздо активнее.","0");
INSERT INTO forum_p VALUES("13","6","5","49","325","1590973507","\r\n53. После сытного обеда мы хуже слышим.\r\n54. Лишь у одной трети всех людей стопроцентное зрение.\r\n55. Если слюна не может что-то растворить, Вы не почувствуете вкуса.\r\n56. У женщин от рождения обоняние развито лучше, чем у мужчин.\r\n57. Нос помнит 50 000 различных ароматов.\r\n58. Зрачки расширяются даже из-за небольших помех.\r\n59. У всех людей есть свой уникальный запах.","0");
INSERT INTO forum_p VALUES("14","6","5","49","325","1590973598","Молодость и старение\r\n60. Масса пепла кремированного человека может достигать 4 кг.\r\n61. К шестидесяти годам большинство людей утрачивает примерно половину вкусовых рецепторов.\r\n62. Глаза всю жизнь одного размера, а вот нос и уши растут всю жизнь.\r\n63. В 60 лет 60% мужчин и 40% женщин будут храпеть.\r\n64. Голова ребенка составляет четверть его роста, а к 25 годам длина головы — только восьмая часть всей длины тела.","0");
INSERT INTO forum_p VALUES("15","6","5","49","325","1590973694","Болезни и травмы\r\n65. Чаще всего сердечные приступы происходят в понедельник.\r\n66. Люди гораздо дольше могут обходиться без еды, чем без сна.\r\n67. Когда Вы сгораете на солнце, это повреждает кровеносные сосуды.\r\n68. 90% болезней возникает из-за стресса.\r\n69. Человеческая голова остается в сознании в течение 15—20 секунд после того, как ее отрубили.","0");
INSERT INTO forum_p VALUES("16","6","5","49","325","1590973767","Мышцы и кости\r\n70. Вы напрягаете 17 мышц, чтобы улыбнуться, и 43, чтобы нахмуриться. Если Вы не хотите напрягать лицо — улыбайтесь. Тот, кто часто и подолгу ходит с кислой миной, знает, как это тяжко.\r\n71. Дети рождаются с 300 костями, а у взрослых их всего 206.\r\n72. Утром мы на сантиметр выше, чем вечером.\r\n73. Самый сильный мускул человеческого тела — язык.\r\n74. Самая тяжелая кость человеческого тела — челюстная.\r\n75. Чтобы сделать шаг, Вы задействуете 200 мышц.\r\n76. Зуб — единственный орган, неспособный к регенерации.\r\n77. Мышцы уменьшаются вдвое медленнее, чем накачиваются.\r\n78. Некоторые кости прочнее стали.\r\n79. В стопах содержится четверть всех костей человеческого тела.","0");
INSERT INTO forum_p VALUES("17","6","5","49","325","1590973810","На клеточном уровне\r\n80. На квадратном сантиметре тела содержится 16 000 бактерий.\r\n81. Каждые 27 дней Вы буквально меняете кожу.\r\n82. Каждую минуту в человеческом теле умирает 3 000 000 клеток.\r\n83. Люди теряют около 600 000 частиц кожи каждый час.\r\n84. Каждый день организм взрослого человека производит 300 миллиардов новых клеток.\r\n85. Все отпечатки языка уникальны.\r\n86. В теле достаточно железа, чтобы сделать из него 6-сантиметровый гвоздь.\r\n87. Самая распространенная группа крови в мире — первая.\r\n88. Губы красные, потому что под кожей много капилляров.","0");
INSERT INTO forum_p VALUES("18","6","5","49","325","1590973920","Разное\r\n89. Чем холоднее в комнате, где Вы спите, тем выше вероятность, что Вам приснится кошмар.\r\n90. В слезах и слизях содержится фермент лизоцим, разрушающий клеточные стенки многих бактерий.\r\n91. За полчаса тело выделяет столько энергии, сколько потребуется, чтобы вскипятить полтора литра воды.\r\n92. Уши выделяют больше ушной серы, когда Вы боитесь.\r\n93. Нельзя пощекотать самого себя.\r\n94. Расстояние между вытянутыми в стороны руками — это и есть Ваш рост.\r\n95. Человек — единственное животное, которое плачет из-за эмоций.\r\n96. Правши живут в среднем на девять лет дольше левшей.\r\n97. Женщины сжигают жир медленнее мужчин — примерно на 50 калорий в день.\r\n98. Ямка между носом и губой имеет название — носовой желобок.","0");
INSERT INTO forum_p VALUES("19","6","5","60","324","1591175194","16. Золото съедобно (а в особом своем состоянии может благотворно влиять на организм при приеме внутрь... вот только организм аннунаков (медная кровь) - или же людей тоже?..).\r\n17. Золото обнаружено на всех континентах нашей планеты.\r\n18. Золото часто попадает в воду во время землетрясений из-за давления глубоко внутри земной коры.\r\n19. В листьях эвкалиптовых деревьев находили следы золота.\r\n20. Три олимпийских бассейна способны вместить все золото, добытое за всю историю человечества.\r\n21. Почти половина этого золота была добыта в одном месте – Витватерсранде в ЮАР.\r\n22. Аурофобия – это боязнь золота.\r\n23. Индийские домохозяйки владеют почти 11 процентами всего мирового золота. Это больше, чем в США, Швейцарии, Германии и Международном валютном фонде, вместе взятых.\r\n24. Самый большой слиток золота весит 250 кг.\r\n25. Наше тело содержит около 0,2 мг золота, в основном в крови.","0");
INSERT INTO forum_p VALUES("20","2","12","45","367","1591179127","1:)","0");
INSERT INTO forum_p VALUES("25","2","12","45","362","1591219941","2..бла2.","0");
INSERT INTO forum_p VALUES("26","2","11","86","324","1591274292","0-дайте мне соль","0");
INSERT INTO forum_p VALUES("27","2","11","87","324","1591274595","Стена","0");
INSERT INTO forum_p VALUES("28","2","11","88","324","1591274760","1.","0");
INSERT INTO forum_p VALUES("29","2","11","89","324","1591275237","Деревянное железо","0");
INSERT INTO forum_p VALUES("30","2","11","90","324","1591275728","Хочу мир вовсем  мире","0");
INSERT INTO forum_p VALUES("31","2","11","89","362","1591296102","Железный дуб","0");
INSERT INTO forum_p VALUES("32","2","11","88","362","1591296156","3.","0");
INSERT INTO forum_p VALUES("33","2","11","87","362","1591296201","Насорог","0");
INSERT INTO forum_p VALUES("34","2","11","86","373","1591313024","Один — в поле господин ))","0");
INSERT INTO forum_p VALUES("35","8","1","91","373","1591339452","Дубль: чёрный ящик колеса фортуны не работает.\r\nПо игре выходит что ящиков у меня нет, а их 36 уже","0");
INSERT INTO forum_p VALUES("36","8","1","91","373","1591340056","Ошибка номер раз ))","0");
INSERT INTO forum_p VALUES("37","13","29","103","362","1591548159","Вкусняшка!.миг.","0");
INSERT INTO forum_p VALUES("38","2","12","107","362","1591548290",".01..","0");
INSERT INTO forum_p VALUES("39","2","12","108","362","1591548330",".00..","0");
INSERT INTO forum_p VALUES("40","2","12","105","362","1591548368",".01..","0");
INSERT INTO forum_p VALUES("41","2","12","109","362","1591548749",".01.груша.","0");
INSERT INTO forum_p VALUES("42","2","12","105","350","1591601589","  .2.*","0");
INSERT INTO forum_p VALUES("43","2","12","105","362","1591601637","Серый, лови монеты..ор.","0");
INSERT INTO forum_p VALUES("44","2","12","107","350","1591602556",".2.*","0");
INSERT INTO forum_p VALUES("45","2","12","109","395","1591615672","  2 Маску","0");
INSERT INTO forum_p VALUES("46","2","12","107","362","1591631218",".03.","0");
INSERT INTO forum_p VALUES("47","2","12","107","339","1591776713"," .4я.","0");
INSERT INTO forum_p VALUES("48","2","12","107","351","1591807030",".5.","0");
INSERT INTO forum_p VALUES("49","2","12","107","339","1591866938","6","0");
INSERT INTO forum_p VALUES("50","2","12","107","351","1591945357","Семь.","0");
INSERT INTO forum_p VALUES("51","2","12","107","362","1591945673",".08.","0");
INSERT INTO forum_p VALUES("52","2","12","107","351","1591962498",".9.","0");
INSERT INTO forum_p VALUES("58","2","12","133","391","1592106271",".1а.","0");
INSERT INTO forum_p VALUES("59","2","12","133","422","1592106793",".2я.","0");
INSERT INTO forum_p VALUES("60","2","12","133","391","1592106893",".3а.","0");
INSERT INTO forum_p VALUES("63","2","12","134","391","1592107832"," .мнену.","0");
INSERT INTO forum_p VALUES("64","2","12","133","362","1592153554",".04.","0");
INSERT INTO forum_p VALUES("65","2","12","133","422","1592154100",".5я.","0");
INSERT INTO forum_p VALUES("67","2","12","135","362","1592162186",".01.","0");
INSERT INTO forum_p VALUES("68","2","12","136","362","1592163131",".01.сигареты","0");
INSERT INTO forum_p VALUES("69","2","12","136","422","1592163281",".2я. Салат","0");
INSERT INTO forum_p VALUES("70","2","12","137","362","1592165976",".01.","0");
INSERT INTO forum_p VALUES("71","2","12","137","350","1592198307",".2.***","0");
INSERT INTO forum_p VALUES("72","2","12","134","350","1592209146","ответ: Губин.Андрей.","0");
INSERT INTO forum_p VALUES("73","2","12","134","391","1592213820","Серый, .дада. Верно","0");
INSERT INTO forum_p VALUES("74","2","12","134","391","1592214664",".мнену2.","0");
INSERT INTO forum_p VALUES("76","2","12","134","350","1592283658","похоже на Лайму Вайкуле.\r\nвроде бы как....","0");
INSERT INTO forum_p VALUES("77","2","12","134","391","1592284246","Серый, Вроде бы как верно +100 монет ","0");
INSERT INTO forum_p VALUES("78","2","12","134","391","1592284682",".мнену4.","0");
INSERT INTO forum_p VALUES("80","2","12","136","419","1592321573","шашлык","0");
INSERT INTO forum_p VALUES("81","2","12","134","379","1592387923","Niletto Данил Прытков","0");
INSERT INTO forum_p VALUES("83","2","12","134","391","1592388799","blonda, Да","0");
INSERT INTO forum_p VALUES("84","2","12","134","391","1592390688",".мнену5.","0");
INSERT INTO forum_p VALUES("85","2","12","134","444","1592394705","Girl Style, Стас Пьеха","0");
INSERT INTO forum_p VALUES("86","2","12","134","391","1592396266","Skazo4nik, Верно","0");
INSERT INTO forum_p VALUES("87","2","12","134","444","1592396335","Girl Style, .миг.","0");
INSERT INTO forum_p VALUES("88","8","2","138","444","1592397231","о,да тут есть тема.))) мне графник,заявляю.лол.","0");
INSERT INTO forum_p VALUES("89","8","2","138","391","1592397942","Skazo4nik, Условия читали? От вас нужна картинка png","0");
INSERT INTO forum_p VALUES("90","8","2","138","444","1592398032","Girl Style, будешь выкать..накажу.лол.нет,не читали. но стаким успехом и сам сделаю по свободному времени","0");
INSERT INTO forum_p VALUES("91","8","2","138","391","1592398243","Skazo4nik, Хорошо. Делайте","0");
INSERT INTO forum_p VALUES("92","8","2","138","444","1592398321","Girl Style, размеры какие у вас допустимы?","0");
INSERT INTO forum_p VALUES("93","2","12","135","444","1592400135","-2-","0");
INSERT INTO forum_p VALUES("94","2","12","137","444","1592409461","-3-","0");
INSERT INTO forum_p VALUES("95","2","12","136","444","1592409980","4.Метлу.лол.","0");
INSERT INTO forum_p VALUES("96","2","12","136","451","1592423662","5.стриптизера.ах.","0");
INSERT INTO forum_p VALUES("97","2","11","89","451","1592423773","Дубовый комп))","0");
INSERT INTO forum_p VALUES("98","2","11","87","451","1592423822","ОгрызОК","0");
INSERT INTO forum_p VALUES("99","2","11","86","451","1592423860","Два,купите мне слона)))","0");
INSERT INTO forum_p VALUES("100","2","11","23","451","1592423970","Наташа\r\nКоле\r\nВечно\r\nДает.лол.","0");
INSERT INTO forum_p VALUES("101","2","11","23","451","1592423995","ФСБ","0");
INSERT INTO forum_p VALUES("102","2","11","22","451","1592424041","Ракетное топливо","0");
INSERT INTO forum_p VALUES("103","2","11","21","451","1592424102","ОфигевАТЬ","0");
INSERT INTO forum_p VALUES("104","2","11","5","451","1592424352","Белая ворона","0");
INSERT INTO forum_p VALUES("105","2","11","4","451","1592424437","АлмаЗ","0");
INSERT INTO forum_p VALUES("106","2","11","3","451","1592424462","ЯрослаВ","0");
INSERT INTO forum_p VALUES("107","2","11","2","451","1592424487","АшхабаД","0");
INSERT INTO forum_p VALUES("108","2","33","140","362","1592490253",".01.","0");
INSERT INTO forum_p VALUES("109","2","33","140","422","1592491887",".2я.","0");
INSERT INTO forum_p VALUES("110","2","33","140","463","1592570136","3.","0");
INSERT INTO forum_p VALUES("111","2","33","140","428","1592570179",".4.","0");
INSERT INTO forum_p VALUES("112","2","33","140","463","1592590089","5.","0");
INSERT INTO forum_p VALUES("113","2","33","140","444","1592590262","6.","0");
INSERT INTO forum_p VALUES("114","2","33","140","428","1592590266",".6.","0");
INSERT INTO forum_p VALUES("115","2","33","140","362","1592590317",".08.","0");
INSERT INTO forum_p VALUES("116","2","33","140","444","1592590392","9.","0");
INSERT INTO forum_p VALUES("117","2","33","141","350","1592795717",".1.*\r\nПн.","0");
INSERT INTO forum_p VALUES("118","2","33","141","422","1592799585","Я +","0");
INSERT INTO forum_p VALUES("119","2","12","158","442","1592812587",".1.","0");
INSERT INTO forum_p VALUES("120","2","12","156","442","1592812659","1)","0");
INSERT INTO forum_p VALUES("121","2","12","158","325","1592814001",".2.","0");
INSERT INTO forum_p VALUES("122","2","12","156","435","1592818054","2…","0");
INSERT INTO forum_p VALUES("123","2","12","158","442","1592821023","3)","0");
INSERT INTO forum_p VALUES("124","2","12","156","350","1592880648",".3.*","0");
INSERT INTO forum_p VALUES("125","2","12","156","435","1592896771","4…","0");
INSERT INTO forum_p VALUES("126","2","12","156","494","1592898133","5@","0");
INSERT INTO forum_p VALUES("127","2","12","157","494","1592898420","1)","0");
INSERT INTO forum_p VALUES("128","2","12","157","351","1592898488","2\'","0");
INSERT INTO forum_p VALUES("129","2","12","156","442","1592903639","6)","0");
INSERT INTO forum_p VALUES("130","2","12","156","350","1592990260",".7.*","0");
INSERT INTO forum_p VALUES("131","2","12","157","504","1593170665","3..","0");
INSERT INTO forum_p VALUES("132","2","12","156","442","1593171628","8)","0");
INSERT INTO forum_p VALUES("133","2","12","156","362","1593210548","9..","0");
INSERT INTO forum_p VALUES("134","2","12","156","1","1593210631","10","0");
INSERT INTO forum_p VALUES("136","2","12","156","350","1593223196",".1..1.*\r\n.","0");
INSERT INTO forum_p VALUES("137","2","12","155","506","1593230707",".1. ДОрога","0");
INSERT INTO forum_p VALUES("138","2","12","157","506","1593230832","5.","0");
INSERT INTO forum_p VALUES("139","2","12","158","506","1593230886","4.","0");
INSERT INTO forum_p VALUES("140","2","12","156","362","1593236111","12.","0");
INSERT INTO forum_p VALUES("141","2","12","156","1","1593237141","13","0");
INSERT INTO forum_p VALUES("142","2","12","156","362","1593250674","14.","0");
INSERT INTO forum_p VALUES("143","2","12","158","362","1593250711","5..","0");
INSERT INTO forum_p VALUES("144","2","12","158","1","1593251812","6 .ор.","0");
INSERT INTO forum_p VALUES("145","2","12","156","1","1593252060","15","0");
INSERT INTO forum_p VALUES("146","2","12","158","362","1593276514","7..","0");
INSERT INTO forum_p VALUES("147","2","12","158","1","1593276551","8 ","0");
INSERT INTO forum_p VALUES("148","2","12","157","362","1593276661","6.","0");
INSERT INTO forum_p VALUES("149","2","12","157","1","1593276730","7 ","0");
INSERT INTO forum_p VALUES("150","2","12","156","330","1593278347","16","0");
INSERT INTO forum_p VALUES("151","2","12","156","1","1593278468","17","0");
INSERT INTO forum_p VALUES("152","2","12","156","350","1593316235","18.","0");
INSERT INTO forum_p VALUES("154","2","12","158","1","1593325865","10","0");
INSERT INTO forum_p VALUES("155","2","12","156","1","1593325888","19","0");
INSERT INTO forum_p VALUES("156","2","12","156","362","1593329716","20.","0");
INSERT INTO forum_p VALUES("157","2","12","156","1","1593329800","21","0");
INSERT INTO forum_p VALUES("158","2","12","158","362","1593329861","11.","0");
INSERT INTO forum_p VALUES("159","2","12","158","1","1593329984","12","0");
INSERT INTO forum_p VALUES("160","2","12","157","520","1593332371","8×","0");
INSERT INTO forum_p VALUES("161","2","12","157","1","1593332458","9 ","0");
INSERT INTO forum_p VALUES("162","2","12","157","512","1593334080","10","0");
INSERT INTO forum_p VALUES("163","2","12","157","1","1593334267","11","0");
INSERT INTO forum_p VALUES("164","2","12","155","512","1593334590","2 РЕка","0");
INSERT INTO forum_p VALUES("165","2","12","155","1","1593334713","3. МИтяй ","0");
INSERT INTO forum_p VALUES("166","2","12","156","512","1593341890","22","0");
INSERT INTO forum_p VALUES("167","2","12","156","504","1593344992","23..","0");
INSERT INTO forum_p VALUES("168","2","12","156","1","1593345752","24","0");
INSERT INTO forum_p VALUES("169","2","12","156","350","1593349117","25..","0");
INSERT INTO forum_p VALUES("170","2","12","157","512","1593351969","12","0");
INSERT INTO forum_p VALUES("171","2","12","157","1","1593352620","13","0");
INSERT INTO forum_p VALUES("172","2","12","156","1","1593352691","26","0");
INSERT INTO forum_p VALUES("173","2","12","156","516","1593357461","27","0");
INSERT INTO forum_p VALUES("174","2","12","157","516","1593357488","14","0");
INSERT INTO forum_p VALUES("175","2","12","158","516","1593357526","13","0");
INSERT INTO forum_p VALUES("176","2","33","140","516","1593357781","10","0");
INSERT INTO forum_p VALUES("177","2","12","158","1","1593363577","14","0");
INSERT INTO forum_p VALUES("178","2","12","157","1","1593365539","15","0");
INSERT INTO forum_p VALUES("179","2","12","156","1","1593365570","28","0");
INSERT INTO forum_p VALUES("180","2","12","157","512","1593377200","16","0");
INSERT INTO forum_p VALUES("181","2","12","156","350","1593398645","29.","0");
INSERT INTO forum_p VALUES("182","2","33","141","350","1593398901",".апл2.\r\nПн.   .1.*\r\n.","0");
INSERT INTO forum_p VALUES("183","2","12","158","350","1593399048","15.*","0");
INSERT INTO forum_p VALUES("184","2","12","156","516","1593429086","30","0");
INSERT INTO forum_p VALUES("185","2","12","156","1","1593430508","31","0");
INSERT INTO forum_p VALUES("186","2","12","157","1","1593430562","17","0");
INSERT INTO forum_p VALUES("187","2","33","141","512","1593434659","Понедельник","0");
INSERT INTO forum_p VALUES("188","2","12","156","512","1593434706","32","0");
INSERT INTO forum_p VALUES("189","2","12","156","350","1593434710","32.    где невесты???","0");
INSERT INTO forum_p VALUES("190","2","12","156","350","1593434959","_Solnyshko_ прости 33","0");
INSERT INTO forum_p VALUES("191","2","12","156","1","1593437805","34","0");
INSERT INTO forum_p VALUES("192","2","12","156","350","1593441465",".3..5.*","0");
INSERT INTO forum_p VALUES("193","2","12","157","505","1593450147","18","0");
INSERT INTO forum_p VALUES("194","2","33","141","428","1593451371","Ну поехали! Понедельник ","0");
INSERT INTO forum_p VALUES("195","2","12","157","1","1593452581","19","0");
INSERT INTO forum_p VALUES("196","2","12","156","1","1593452607","36","0");
INSERT INTO forum_p VALUES("197","2","12","156","362","1593453025","37.","0");
INSERT INTO forum_p VALUES("198","2","12","156","1","1593454043","38","0");
INSERT INTO forum_p VALUES("199","2","33","140","505","1593482673","11.привет.","0");
INSERT INTO forum_p VALUES("200","2","33","141","350","1593486524","Вт.\r\n.2.\r\n.","0");
INSERT INTO forum_p VALUES("201","2","33","140","506","1593493007","12","0");
INSERT INTO forum_p VALUES("202","2","33","141","512","1593494253","Вторник","0");
INSERT INTO forum_p VALUES("203","2","12","157","512","1593494288","20","0");
INSERT INTO forum_p VALUES("204","2","12","156","350","1593494320","39.","0");
INSERT INTO forum_p VALUES("205","2","12","156","512","1593496310","40","0");
INSERT INTO forum_p VALUES("206","2","12","156","350","1593501860","41.  _Solnyshko_","0");
INSERT INTO forum_p VALUES("207","2","12","156","535","1593502993","42","0");
INSERT INTO forum_p VALUES("208","2","12","157","535","1593503085","21","0");
INSERT INTO forum_p VALUES("209","2","33","140","535","1593503248","13","0");
INSERT INTO forum_p VALUES("210","2","12","158","535","1593503426","16","0");
INSERT INTO forum_p VALUES("211","2","12","156","350","1593505737","43.","0");
INSERT INTO forum_p VALUES("212","2","12","158","505","1593506630","17","0");
INSERT INTO forum_p VALUES("213","2","12","156","535","1593511535","44","0");
INSERT INTO forum_p VALUES("214","2","12","158","535","1593511617","18","0");
INSERT INTO forum_p VALUES("215","2","12","137","505","1593519416",";4;","0");
INSERT INTO forum_p VALUES("216","2","12","44","505","1593519630","4.миг.","0");
INSERT INTO forum_p VALUES("217","2","12","156","350","1593520932","45.\r\n.","0");
INSERT INTO forum_p VALUES("218","2","12","156","535","1593521257","46","0");
INSERT INTO forum_p VALUES("219","2","12","44","535","1593521411",".5.","0");
INSERT INTO forum_p VALUES("220","2","12","137","535","1593521560",".5.","0");
INSERT INTO forum_p VALUES("221","2","12","156","350","1593525558","47.","0");
INSERT INTO forum_p VALUES("222","2","12","156","535","1593526593","48","0");
INSERT INTO forum_p VALUES("223","2","12","158","362","1593527420","19.","0");
INSERT INTO forum_p VALUES("224","2","12","157","362","1593527449","22.","0");
INSERT INTO forum_p VALUES("225","2","12","158","535","1593527757","20","0");
INSERT INTO forum_p VALUES("226","2","12","157","535","1593528007","23","0");
INSERT INTO forum_p VALUES("227","2","12","44","512","1593528124","6\"","0");
INSERT INTO forum_p VALUES("228","2","12","157","512","1593528157","24","0");
INSERT INTO forum_p VALUES("229","2","12","137","512","1593528501","_6_","0");
INSERT INTO forum_p VALUES("230","2","12","156","350","1593528516","49.","0");
INSERT INTO forum_p VALUES("231","2","12","158","350","1593529158",".поц1.\r\n        NEMESIS","0");
INSERT INTO forum_p VALUES("232","2","12","156","535","1593529330","50","0");
INSERT INTO forum_p VALUES("233","2","12","137","535","1593529864",".7","0");
INSERT INTO forum_p VALUES("234","2","12","158","535","1593529989","Серый, .ах.","0");
INSERT INTO forum_p VALUES("235","2","12","157","535","1593530406","25","0");
INSERT INTO forum_p VALUES("236","2","12","44","535","1593530618",".7","0");
INSERT INTO forum_p VALUES("237","2","12","44","512","1593541637",";8;","0");
INSERT INTO forum_p VALUES("238","2","12","157","512","1593541674","_2__6_","0");
INSERT INTO forum_p VALUES("239","2","12","157","535","1593544422","27","0");
INSERT INTO forum_p VALUES("240","2","33","141","350","1593570481","Ср.\r\n.3.\r\n.","0");
INSERT INTO forum_p VALUES("241","2","33","141","512","1593589076","Среда ","0");
INSERT INTO forum_p VALUES("242","2","12","137","350","1593592897","8.","0");
INSERT INTO forum_p VALUES("243","2","12","157","512","1593594864",".2..8.","0");
INSERT INTO forum_p VALUES("244","2","12","137","362","1593631314","9..","0");
INSERT INTO forum_p VALUES("245","2","12","158","362","1593631396","21.","0");
INSERT INTO forum_p VALUES("246","2","33","141","350","1593657032","Чт.\r\n.4.\r\n.","0");
INSERT INTO forum_p VALUES("247","2","12","158","350","1593657132","22.","0");
INSERT INTO forum_p VALUES("248","2","12","137","350","1593657213",".1..0.***","0");
INSERT INTO forum_p VALUES("249","2","12","156","350","1593661828",".1.\r\n.","0");
INSERT INTO forum_p VALUES("250","2","12","156","516","1593714751","2,","0");
INSERT INTO forum_p VALUES("251","2","33","141","350","1593743492","Пт.\r\n.5.\r\n","0");
INSERT INTO forum_p VALUES("252","2","12","156","350","1593743568",".3.","0");
INSERT INTO forum_p VALUES("253","2","12","137","543","1593752799","1 .ор...готовь бабосики .лол","0");
INSERT INTO forum_p VALUES("254","2","11","21","543","1593753185","Атаковать","0");
INSERT INTO forum_p VALUES("255","2","12","156","543","1593766822","4 .ор...где этот счастливчик .лол.","0");
INSERT INTO forum_p VALUES("256","2","12","156","350","1593767573",".5.тут","0");
INSERT INTO forum_p VALUES("257","2","12","156","512","1593772158",";6;","0");
INSERT INTO forum_p VALUES("258","2","33","141","512","1593772430","Пятница","0");
INSERT INTO forum_p VALUES("259","2","12","156","362","1593774815",".06.","0");
INSERT INTO forum_p VALUES("260","2","12","156","350","1593779860","*7*","0");
INSERT INTO forum_p VALUES("261","2","11","160","543","1593780009","Я начинаю.ор. СОМ ","0");
INSERT INTO forum_p VALUES("262","2","12","137","350","1593782327","12.","0");
INSERT INTO forum_p VALUES("263","2","11","160","505","1593783373",".миг.","0");
INSERT INTO forum_p VALUES("264","2","11","21","505","1593783667","Вставать.изпола.","0");
INSERT INTO forum_p VALUES("265","2","11","21","512","1593784389","Кричать ","0");
INSERT INTO forum_p VALUES("266","2","11","160","543","1593784648","На последняю букву нужно .ор.","0");
INSERT INTO forum_p VALUES("267","2","11","160","543","1593784669","МАК ","0");
INSERT INTO forum_p VALUES("268","2","11","160","512","1593784907","Куб","0");
INSERT INTO forum_p VALUES("269","2","11","160","505","1593785340","бук.лыба6.","0");
INSERT INTO forum_p VALUES("270","2","11","21","505","1593785527","Молчать","0");
INSERT INTO forum_p VALUES("271","2","11","160","350","1593786245","кук.","0");
INSERT INTO forum_p VALUES("272","2","11","160","1","1593789694","КоК","0");
INSERT INTO forum_p VALUES("273","2","11","160","350","1593790275","как ?","0");
INSERT INTO forum_p VALUES("274","2","11","160","1","1593791067","Кут ","0");
INSERT INTO forum_p VALUES("275","2","11","160","350","1593791494","таз.","0");
INSERT INTO forum_p VALUES("276","2","11","160","1","1593791874","ЗаЗ","0");
INSERT INTO forum_p VALUES("277","2","12","156","516","1593797000","8\"","0");
INSERT INTO forum_p VALUES("278","2","11","21","512","1593798129","Советовать ","0");
INSERT INTO forum_p VALUES("279","2","11","160","543","1593815645","Зам .язык.","0");
INSERT INTO forum_p VALUES("280","2","33","141","350","1593829235","Сб.\r\n.6.\r\n.","0");
INSERT INTO forum_p VALUES("281","2","12","156","350","1593829334","9.","0");
INSERT INTO forum_p VALUES("282","2","11","160","350","1593836332","маз.","0");
INSERT INTO forum_p VALUES("283","2","11","160","1","1593837216","Зоб","0");
INSERT INTO forum_p VALUES("284","2","33","141","512","1593839432","Суббота","0");
INSERT INTO forum_p VALUES("285","2","11","160","512","1593839940","Бак","0");
INSERT INTO forum_p VALUES("286","2","11","160","543","1593843984","Кок ","0");
INSERT INTO forum_p VALUES("287","2","11","160","1","1593850307","КиК","0");
INSERT INTO forum_p VALUES("288","2","11","160","350","1593855041","   кир.\r\nа игра на что?призы какие?","0");
INSERT INTO forum_p VALUES("289","2","12","137","512","1593871234","_1__3_","0");
INSERT INTO forum_p VALUES("290","2","12","156","512","1593871340","_1__0_","0");
INSERT INTO forum_p VALUES("291","2","12","156","350","1593878403",".1..1.\r\n.","0");
INSERT INTO forum_p VALUES("292","2","12","156","512","1593888012","_1__2_","0");
INSERT INTO forum_p VALUES("293","2","11","21","505","1593889479","плясать","0");
INSERT INTO forum_p VALUES("294","2","11","21","512","1593889816","Скакать ","0");
INSERT INTO forum_p VALUES("295","2","11","160","505","1593895701","рок","0");
INSERT INTO forum_p VALUES("296","2","33","141","350","1593915447","Вс.\r\n.7.","0");
INSERT INTO forum_p VALUES("297","2","12","137","350","1593915499","14.","0");
INSERT INTO forum_p VALUES("298","2","12","156","350","1593915660","_Solnyshko_ √ 1","0");
INSERT INTO forum_p VALUES("299","2","11","160","543","1593918853","Кит .ор.","0");
INSERT INTO forum_p VALUES("300","2","11","160","505","1593925393","том","0");
INSERT INTO forum_p VALUES("301","2","11","160","512","1593931908","Мак","0");
INSERT INTO forum_p VALUES("302","2","33","141","512","1593931938","Воскресенье","0");
INSERT INTO forum_p VALUES("303","2","11","160","1","1593934289","Коп","0");
INSERT INTO forum_p VALUES("304","2","11","160","512","1593948607","Лак","0");
INSERT INTO forum_p VALUES("305","2","11","21","505","1593951703","Раздевать","0");
INSERT INTO forum_p VALUES("306","2","11","21","512","1593956237","Одевать :)","0");
INSERT INTO forum_p VALUES("307","2","11","160","1","1593958021","Кум ","0");
INSERT INTO forum_p VALUES("308","2","11","160","512","1593958846","Мел","0");
INSERT INTO forum_p VALUES("309","2","11","160","1","1593959069","Лук","0");
INSERT INTO forum_p VALUES("310","2","11","160","512","1593959217","Куш","0");
INSERT INTO forum_p VALUES("311","2","11","160","1","1593959316","Шок","0");
INSERT INTO forum_p VALUES("312","2","33","140","512","1593959363","_1__4_","0");
INSERT INTO forum_p VALUES("313","2","11","160","512","1593959588","Кит ","0");
INSERT INTO forum_p VALUES("314","2","11","160","1","1593960546","ТиР","0");
INSERT INTO forum_p VALUES("315","2","11","160","512","1593963475","Рак ","0");
INSERT INTO forum_p VALUES("316","2","11","160","1","1593963867","Ком","0");
INSERT INTO forum_p VALUES("317","2","11","160","512","1593963932","Мир","0");
INSERT INTO forum_p VALUES("318","2","11","160","1","1593969172","Ром ","0");
INSERT INTO forum_p VALUES("319","2","11","160","512","1593971140","Мат ","0");
INSERT INTO forum_p VALUES("320","2","11","160","1","1593971249","Том","0");
INSERT INTO forum_p VALUES("321","2","33","141","350","1594002808","Пн.\r\n.1.\r\n.","0");
INSERT INTO forum_p VALUES("322","2","33","141","362","1594009925","Серый, лови баллы и рубли..ор.","0");
INSERT INTO forum_p VALUES("323","2","33","140","552","1594045605","15","0");
INSERT INTO forum_p VALUES("324","2","33","140","362","1594046309","16..","0");
INSERT INTO forum_p VALUES("325","2","33","140","505","1594046993","17.","0");
INSERT INTO forum_p VALUES("326","2","33","140","506","1594047358","18..","0");
INSERT INTO forum_p VALUES("327","2","33","140","505","1594047441","19...","0");
INSERT INTO forum_p VALUES("328","2","33","140","506","1594047692","20..","0");
INSERT INTO forum_p VALUES("329","2","33","140","506","1594047808","sany777, .целует.","0");
INSERT INTO forum_p VALUES("330","2","11","160","505","1594047854","мул","0");
INSERT INTO forum_p VALUES("331","2","33","141","350","1594083165","Вт.\r\n.2.*","0");
INSERT INTO forum_p VALUES("332","2","12","156","350","1594083315",".1..4.","0");
INSERT INTO forum_p VALUES("333","2","33","141","350","1594173755","Ср.\r\n.3.\r\n...","0");
INSERT INTO forum_p VALUES("334","2","11","21","506","1594213608","Бухать.ржу.","0");
INSERT INTO forum_p VALUES("335","2","11","21","512","1594235092","Бегать","0");
INSERT INTO forum_p VALUES("336","2","11","160","512","1594235160","Лом","0");
INSERT INTO forum_p VALUES("337","2","33","141","350","1594262964","Чт.\r\n.4.\r\n....","0");
INSERT INTO forum_p VALUES("338","2","12","156","561","1594266364",".1..5.","0");
INSERT INTO forum_p VALUES("339","2","11","160","561","1594268907","Мел","0");
INSERT INTO forum_p VALUES("340","2","11","21","561","1594269003","КовАТЬ","0");
INSERT INTO forum_p VALUES("341","2","33","140","561","1594269129",",21","0");
INSERT INTO forum_p VALUES("342","2","11","21","512","1594274082","Спать ","0");
INSERT INTO forum_p VALUES("343","2","11","160","512","1594274407","Лес ","0");
INSERT INTO forum_p VALUES("344","2","12","156","350","1594284783","16.","0");
INSERT INTO forum_p VALUES("345","2","11","160","1","1594315035","Сук","0");
INSERT INTO forum_p VALUES("346","2","11","21","506","1594319005","лежать","0");
INSERT INTO forum_p VALUES("347","2","12","156","330","1594340533",".1..17.","0");
INSERT INTO forum_p VALUES("348","2","33","141","350","1594343474","Пт.\r\n.5.\r\n.","0");
INSERT INTO forum_p VALUES("349","2","12","156","350","1594343596","18...","0");
INSERT INTO forum_p VALUES("350","2","33","140","506","1594358920","22..","0");
INSERT INTO forum_p VALUES("351","2","11","160","512","1594401076","Кот","0");
INSERT INTO forum_p VALUES("352","2","11","21","512","1594401141","Ломать","0");
INSERT INTO forum_p VALUES("353","2","33","140","512","1594401238","23","0");
INSERT INTO forum_p VALUES("354","2","33","140","505","1594411254","24","0");
INSERT INTO forum_p VALUES("355","2","33","141","350","1594433247","Сб.\r\n.6.\r\n,,,","0");
INSERT INTO forum_p VALUES("356","2","33","140","506","1594436377","25..","0");
INSERT INTO forum_p VALUES("357","2","33","141","505","1594474831","_Solnyshko_, привет.дарюрозу. лови рубли и баллы за семь дней.миг.","0");
INSERT INTO forum_p VALUES("358","2","33","140","505","1594475280","26","0");
INSERT INTO forum_p VALUES("359","2","11","21","505","1594475432","работать","0");
INSERT INTO forum_p VALUES("360","2","11","160","505","1594475792","топ","0");
INSERT INTO forum_p VALUES("361","2","11","160","505","1594475873","_Solnyshko_, самая активная.яху. приз твой.миг.","0");
INSERT INTO forum_p VALUES("362","2","11","21","505","1594476150","за активность в игре, приз получает _Solnyshko_, \r\n.яху.","0");
INSERT INTO forum_p VALUES("363","2","11","160","512","1594477325","sany777, спасибочки .ор.","0");
INSERT INTO forum_p VALUES("364","2","11","21","512","1594477351","sany777, спасибочки .ор.","0");
INSERT INTO forum_p VALUES("365","2","33","141","512","1594477396","sany777, спасибочки .ор.","0");
INSERT INTO forum_p VALUES("366","2","11","160","512","1594492811","Пёс","0");
INSERT INTO forum_p VALUES("367","2","11","21","512","1594492871","Отдыхать ","0");
INSERT INTO forum_p VALUES("368","2","12","137","512","1594492991","_1__5_","0");
INSERT INTO forum_p VALUES("369","2","11","21","351","1594496447","СпАТЬ.","0");
INSERT INTO forum_p VALUES("370","2","12","137","351","1594496569","16.","0");
INSERT INTO forum_p VALUES("371","2","11","160","351","1594496653","Сом.","0");
INSERT INTO forum_p VALUES("372","2","33","140","351","1594496780","27.","0");
INSERT INTO forum_p VALUES("373","2","11","21","512","1594503913","Вставать ","0");
INSERT INTO forum_p VALUES("374","2","12","137","512","1594503947","_1__7_","0");
INSERT INTO forum_p VALUES("375","2","11","160","512","1594503982","Маг","0");
INSERT INTO forum_p VALUES("376","2","33","140","512","1594504018","_2__8_","0");
INSERT INTO forum_p VALUES("377","2","33","141","350","1594518963","Вс.\r\n.7.\r\n...","0");
INSERT INTO forum_p VALUES("378","2","33","140","351","1594546226","29\'\'\"","0");
INSERT INTO forum_p VALUES("379","2","11","160","351","1594546331","Мул,,","0");
INSERT INTO forum_p VALUES("380","2","12","137","351","1594546435","18\"\"\'","0");
INSERT INTO forum_p VALUES("381","2","11","21","351","1594546917","ЛежАТЬ.","0");
INSERT INTO forum_p VALUES("382","2","11","160","1","1594557546","Лак","0");
INSERT INTO forum_p VALUES("383","2","33","141","512","1594600752","Понедельник  .потелефону.","0");
INSERT INTO forum_p VALUES("384","2","33","141","350","1594605282","Пн.\r\n.1.\r\n...","0");
INSERT INTO forum_p VALUES("385","2","33","141","506","1594625102","Серый, тебе за недельку 2000 бал. и 50 руб.","0");
INSERT INTO forum_p VALUES("386","2","11","21","512","1594653367","Читать","0");
INSERT INTO forum_p VALUES("387","2","11","160","512","1594653433","Кок","0");
INSERT INTO forum_p VALUES("388","2","12","137","512","1594653869","_1__9_","0");
INSERT INTO forum_p VALUES("389","2","33","141","512","1594703152","Вторник  .танц.","0");
INSERT INTO forum_p VALUES("390","2","33","141","350","1594704781","Вт..\r\n.2.\r\n..","0");
INSERT INTO forum_p VALUES("391","2","33","140","512","1594709523","_3__0_","0");
INSERT INTO forum_p VALUES("392","2","11","21","506","1594711643","МечтАТЬ","0");
INSERT INTO forum_p VALUES("393","2","12","137","350","1594739792"," 2..0.\r\n...","0");
INSERT INTO forum_p VALUES("394","2","12","137","505","1594740243","21..","0");
INSERT INTO forum_p VALUES("395","2","11","160","1","1594744127","Ксю","0");
INSERT INTO forum_p VALUES("396","2","12","137","362","1594749556","Серый, лови подарок..ор.","0");
INSERT INTO forum_p VALUES("397","2","33","141","512","1594795832","Среда .жарко.","0");
INSERT INTO forum_p VALUES("398","2","33","141","512","1594911194","Четверг.","0");
INSERT INTO forum_p VALUES("399","2","11","160","554","1594913380","Ювентус","0");
INSERT INTO forum_p VALUES("400","2","11","160","1","1594918283","Юпи","0");
INSERT INTO forum_p VALUES("401","2","12","137","350","1594976755","22.\r\n.","0");
INSERT INTO forum_p VALUES("402","2","33","141","512","1594982221","Пятница.","0");
INSERT INTO forum_p VALUES("403","2","12","137","501","1595031979","23","0");
INSERT INTO forum_p VALUES("404","2","11","160","501","1595032042","Сыр","0");
INSERT INTO forum_p VALUES("405","2","11","21","501","1595032099","Играть","0");
INSERT INTO forum_p VALUES("406","2","33","140","501","1595032144","31","0");
INSERT INTO forum_p VALUES("407","2","11","160","1","1595068526","Руб ","0");
INSERT INTO forum_p VALUES("408","2","33","141","512","1595080975","Суббота.","0");
INSERT INTO forum_p VALUES("409","2","11","160","512","1595081029","Боб","0");
INSERT INTO forum_p VALUES("410","2","11","21","512","1595081058","Бегать","0");
INSERT INTO forum_p VALUES("411","2","33","140","512","1595081104","32","0");
INSERT INTO forum_p VALUES("412","2","12","137","512","1595081132","24","0");
INSERT INTO forum_p VALUES("413","2","11","160","1","1595081449","Бро","0");
INSERT INTO forum_p VALUES("414","2","11","160","554","1595091806","Икра","0");
INSERT INTO forum_p VALUES("415","2","12","137","575","1595146227","25","0");
INSERT INTO forum_p VALUES("416","2","11","88","575","1595146318"," 5","0");
INSERT INTO forum_p VALUES("417","2","11","87","575","1595146377","Окурок ","0");
INSERT INTO forum_p VALUES("418","2","12","158","575","1595146494","23","0");
INSERT INTO forum_p VALUES("419","2","12","158","1","1595168729","24","0");
INSERT INTO forum_p VALUES("420","2","11","87","1","1595168836","Окно","0");
INSERT INTO forum_p VALUES("421","2","11","87","501","1595211853","Нота","0");
INSERT INTO forum_p VALUES("422","2","12","158","501","1595211899","25","0");
INSERT INTO forum_p VALUES("423","2","11","88","501","1595211968",". 7","0");
INSERT INTO forum_p VALUES("424","2","12","137","501","1595212001","26","0");
INSERT INTO forum_p VALUES("425","2","12","137","550","1595253145","27","0");
INSERT INTO forum_p VALUES("426","2","12","156","569","1595369221","19","0");
INSERT INTO forum_p VALUES("427","2","12","158","569","1595369281","26","0");
INSERT INTO forum_p VALUES("428","2","12","137","569","1595369344","28","0");
INSERT INTO forum_p VALUES("429","2","12","158","573","1595525509","27","0");
INSERT INTO forum_p VALUES("430","2","12","156","573","1595525875",".а2..а0.","0");
INSERT INTO forum_p VALUES("431","2","11","87","573","1595525978","ТЕма","0");
INSERT INTO forum_p VALUES("432","2","12","156","350","1595557828","21.\r\n.","0");
INSERT INTO forum_p VALUES("433","2","12","156","1","1595661976","22 :)","0");
INSERT INTO forum_p VALUES("434","2","12","156","350","1595730207","23.","0");
INSERT INTO forum_p VALUES("435","2","11","87","586","1595739098","Матрёшка","0");
INSERT INTO forum_p VALUES("436","2","12","158","586","1595739476","28","0");
INSERT INTO forum_p VALUES("437","2","12","156","586","1595824882","24","0");
INSERT INTO forum_p VALUES("438","2","12","137","586","1595825081","29","0");
INSERT INTO forum_p VALUES("439","2","11","88","586","1595825213",".9.","0");
INSERT INTO forum_p VALUES("440","2","12","156","554","1595843634","25","0");
INSERT INTO forum_p VALUES("441","2","12","156","586","1595854883","26","0");
INSERT INTO forum_p VALUES("442","2","12","156","1","1595869964","27","0");
INSERT INTO forum_p VALUES("443","2","11","88","1","1595870062","11","0");
INSERT INTO forum_p VALUES("444","2","12","156","350","1595938065","28.","0");
INSERT INTO forum_p VALUES("445","2","12","137","350","1595946211","30.","0");
INSERT INTO forum_p VALUES("446","2","12","156","1","1595946494","29","0");
INSERT INTO forum_p VALUES("447","2","12","156","586","1595958975","30","0");
INSERT INTO forum_p VALUES("448","2","12","156","330","1595987374",".3..1.","0");
INSERT INTO forum_p VALUES("449","2","12","156","350","1595988707","32\r\n_НеЖнАя_ФиАлКа_","0");
INSERT INTO forum_p VALUES("450","2","33","141","350","1595988888","Ср.\r\n.1.\r\n,,,,","0");
INSERT INTO forum_p VALUES("451","2","12","156","433","1596006050","33","0");
INSERT INTO forum_p VALUES("452","2","12","156","550","1596013304","34","0");
INSERT INTO forum_p VALUES("453","2","12","156","433","1596019713","35","0");
INSERT INTO forum_p VALUES("454","2","12","156","330","1596027069","36","0");
INSERT INTO forum_p VALUES("455","2","12","156","433","1596033244","37","0");
INSERT INTO forum_p VALUES("456","2","12","156","554","1596049433","38","0");
INSERT INTO forum_p VALUES("457","2","33","141","350","1596077700","Чт.\r\n.2.","0");
INSERT INTO forum_p VALUES("458","2","12","156","330","1596089123","39","0");
INSERT INTO forum_p VALUES("459","2","12","156","585","1596128904","40","0");
INSERT INTO forum_p VALUES("460","2","12","156","1","1596128909","40","0");
INSERT INTO forum_p VALUES("461","2","11","88","585","1596130395",",,, 13,,,","0");
INSERT INTO forum_p VALUES("462","2","12","158","585","1596141311","29","0");
INSERT INTO forum_p VALUES("463","2","33","141","350","1596164543","Пт.\r\n.3.","0");
INSERT INTO forum_p VALUES("464","2","12","156","350","1596164615","42.","0");
INSERT INTO forum_p VALUES("465","2","12","156","554","1596164632","41","0");
INSERT INTO forum_p VALUES("466","2","12","158","350","1596164781","30.","0");
INSERT INTO forum_p VALUES("467","2","12","156","330","1596181568","42.","0");
INSERT INTO forum_p VALUES("468","2","12","156","554","1596206869","43","0");
INSERT INTO forum_p VALUES("469","2","12","158","554","1596216863","31","0");
INSERT INTO forum_p VALUES("470","2","12","156","433","1596257965","44","0");
INSERT INTO forum_p VALUES("471","2","12","156","554","1596274888","45","0");
INSERT INTO forum_p VALUES("472","2","12","158","589","1596281726","32","0");
INSERT INTO forum_p VALUES("473","2","12","156","433","1596283641","46","0");
INSERT INTO forum_p VALUES("474","2","12","156","554","1596286693","47","0");
INSERT INTO forum_p VALUES("475","2","12","156","433","1596287747","48","0");
INSERT INTO forum_p VALUES("476","2","12","156","554","1596300610","49","0");
INSERT INTO forum_p VALUES("477","2","12","158","554","1596301135","33","0");
INSERT INTO forum_p VALUES("478","2","12","158","570","1596356604","34","0");
INSERT INTO forum_p VALUES("479","2","12","158","554","1596365597","35","0");
INSERT INTO forum_p VALUES("480","2","12","158","351","1596413402","36","0");
INSERT INTO forum_p VALUES("481","2","12","158","554","1596467454","37","0");
INSERT INTO forum_p VALUES("482","2","12","156","433","1596553620","napapidgi,\r\n50.ржу.","0");
INSERT INTO forum_p VALUES("483","2","12","156","554","1596570766","И шо теперь надо делать?","0");
INSERT INTO forum_p VALUES("484","2","12","158","554","1596641957","39","0");
INSERT INTO forum_p VALUES("485","2","12","156","433","1596645928","napapidgi,\r\nЖениться.лол.","0");
INSERT INTO forum_p VALUES("486","2","12","156","433","1596645939","1.ор.","0");
INSERT INTO forum_p VALUES("487","2","12","156","554","1596648301",".бреется. ","0");
INSERT INTO forum_p VALUES("488","2","12","156","350","1596858598",".3.\r\n*","0");
INSERT INTO forum_p VALUES("489","2","12","156","512","1596927157","4.","0");
INSERT INTO forum_p VALUES("490","2","12","158","512","1596927243","40.","0");
INSERT INTO forum_p VALUES("491","2","12","156","350","1596944912","*5*","0");
INSERT INTO forum_p VALUES("492","2","12","156","554","1596948752","6.","0");
INSERT INTO forum_p VALUES("493","2","33","141","350","1597030215","Пнд.\r\n.1.\r\n*","0");
INSERT INTO forum_p VALUES("494","2","33","141","350","1597115786","Вт.\r\n.2.\r\n*","0");
INSERT INTO forum_p VALUES("495","2","12","156","350","1597115865",".7.","0");
INSERT INTO forum_p VALUES("496","2","12","156","554","1597159398","8.","0");
INSERT INTO forum_p VALUES("497","2","33","141","350","1597208884","Ср.\r\n.3.\r\n*","0");
INSERT INTO forum_p VALUES("498","2","12","156","330","1597278454",".9.","0");
INSERT INTO forum_p VALUES("499","2","12","156","554","1597332137","10","0");
INSERT INTO forum_p VALUES("500","2","12","158","554","1597332435","41","0");
INSERT INTO forum_p VALUES("501","2","12","156","330","1597368860","11","0");
INSERT INTO forum_p VALUES("502","2","12","156","1","1597377690","12","0");
INSERT INTO forum_p VALUES("503","2","12","158","1","1597377731","42","0");
INSERT INTO forum_p VALUES("504","2","11","88","1","1597377775","15","0");
INSERT INTO forum_p VALUES("505","2","12","158","554","1597417850","43.","0");
INSERT INTO forum_p VALUES("506","2","12","156","554","1597417900","13","0");
INSERT INTO forum_p VALUES("507","2","12","156","350","1597464669","14.","0");
INSERT INTO forum_p VALUES("508","2","12","156","1","1597507538","15...","0");
INSERT INTO forum_p VALUES("509","2","12","137","603","1597515807","1.","0");
INSERT INTO forum_p VALUES("510","2","12","158","603","1597515946","44","0");
INSERT INTO forum_p VALUES("511","2","11","88","603","1597516016","17","0");
INSERT INTO forum_p VALUES("512","2","11","88","1","1597519587","19","0");
INSERT INTO forum_p VALUES("513","2","12","158","1","1597519651","45","0");
INSERT INTO forum_p VALUES("514","2","12","156","605","1597521283","16","0");
INSERT INTO forum_p VALUES("515","2","12","158","605","1597521335","46","0");
INSERT INTO forum_p VALUES("516","2","11","88","605","1597521529","21","0");
INSERT INTO forum_p VALUES("517","2","11","88","1","1597521761","23","0");
INSERT INTO forum_p VALUES("518","2","12","158","1","1597521787","47","0");
INSERT INTO forum_p VALUES("519","2","12","158","605","1597521831","48","0");
INSERT INTO forum_p VALUES("520","2","11","88","605","1597521860","25","0");
INSERT INTO forum_p VALUES("521","2","11","88","1","1597521930","27","0");
INSERT INTO forum_p VALUES("522","2","12","158","1","1597521997","49..","0");
INSERT INTO forum_p VALUES("523","2","12","156","1","1597522026","17 ...","0");
INSERT INTO forum_p VALUES("524","2","12","137","1","1597522068","2 .ор.","0");
INSERT INTO forum_p VALUES("525","2","12","156","605","1597522277","18","0");
INSERT INTO forum_p VALUES("526","2","11","88","605","1597522350","29","0");
INSERT INTO forum_p VALUES("527","2","12","158","605","1597523070","50?","0");
INSERT INTO forum_p VALUES("528","2","12","158","1","1597523688","виталька, да .яху. ","0");
INSERT INTO forum_p VALUES("529","2","12","158","1","1597523708","И так поехали 1 .ор. ","0");
INSERT INTO forum_p VALUES("530","2","11","88","1","1597523927","31","0");
INSERT INTO forum_p VALUES("531","2","12","156","1","1597523966","19...","0");
INSERT INTO forum_p VALUES("532","2","12","158","605","1597526040","2 сибки","0");
INSERT INTO forum_p VALUES("533","2","12","156","605","1597526192","20","0");
INSERT INTO forum_p VALUES("534","2","12","156","1","1597527955","21 ...","0");
INSERT INTO forum_p VALUES("535","2","12","156","605","1597550357","22","0");
INSERT INTO forum_p VALUES("536","2","11","88","605","1597550394","33","0");
INSERT INTO forum_p VALUES("537","2","12","137","605","1597550440","3*","0");
INSERT INTO forum_p VALUES("538","2","12","137","603","1597550654","4.","0");
INSERT INTO forum_p VALUES("539","2","11","88","603","1597550688","35","0");
INSERT INTO forum_p VALUES("540","2","11","88","605","1597551037","37","0");
INSERT INTO forum_p VALUES("541","2","12","137","605","1597551076",".5.","0");
INSERT INTO forum_p VALUES("542","2","12","156","554","1597552303","23","0");
INSERT INTO forum_p VALUES("543","2","12","158","554","1597552537","3.","0");
INSERT INTO forum_p VALUES("544","2","12","156","605","1597552949","24","0");
INSERT INTO forum_p VALUES("545","2","12","158","605","1597553001","4.","0");
INSERT INTO forum_p VALUES("546","2","12","158","603","1597574672","5.","0");
INSERT INTO forum_p VALUES("547","2","12","156","603","1597574825","25","0");
INSERT INTO forum_p VALUES("548","2","12","137","603","1597574917",".6","0");
INSERT INTO forum_p VALUES("549","2","11","88","603","1597574964","39","0");
INSERT INTO forum_p VALUES("550","2","12","156","605","1597578885","26.","0");
INSERT INTO forum_p VALUES("551","2","11","88","605","1597578935","41","0");
INSERT INTO forum_p VALUES("552","2","12","137","605","1597578991","7.","0");
INSERT INTO forum_p VALUES("553","2","12","158","605","1597579050","6.","0");
INSERT INTO forum_p VALUES("554","2","33","141","350","1597626801",".1.Пнд.\r\n*****","0");
INSERT INTO forum_p VALUES("555","2","12","158","603","1597634148","7.","0");
INSERT INTO forum_p VALUES("556","2","12","137","603","1597634186","8.","0");
INSERT INTO forum_p VALUES("557","2","11","88","603","1597634208","43","0");
INSERT INTO forum_p VALUES("558","2","12","156","603","1597634235","27","0");
INSERT INTO forum_p VALUES("559","2","12","156","605","1597647796","28+","0");
INSERT INTO forum_p VALUES("560","2","12","158","605","1597647875","8+","0");
INSERT INTO forum_p VALUES("561","2","12","156","603","1597670353","29","0");
INSERT INTO forum_p VALUES("562","2","12","156","605","1597674844","30+","0");
INSERT INTO forum_p VALUES("563","2","11","88","605","1597674900","45","0");
INSERT INTO forum_p VALUES("564","2","12","137","605","1597674936","9.","0");
INSERT INTO forum_p VALUES("565","2","12","156","554","1597692240","31.","0");



DROP TABLE IF EXISTS `forum_r`;

CREATE TABLE `forum_r` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`time`)
) ENGINE=MyISAM AUTO_INCREMENT=34 DEFAULT CHARSET=utf8;

INSERT INTO forum_r VALUES("1","8","Баги/ошибки","1591340056");
INSERT INTO forum_r VALUES("2","8","Акции","1592398321");
INSERT INTO forum_r VALUES("3","8","Предложения","1590598419");
INSERT INTO forum_r VALUES("4","7","Общение","1590598438");
INSERT INTO forum_r VALUES("5","6","Факты","1592767366");
INSERT INTO forum_r VALUES("6","6","Психология","1591253717");
INSERT INTO forum_r VALUES("7","6","Субкультура","1591273244");
INSERT INTO forum_r VALUES("8","6","Разное","1592767730");
INSERT INTO forum_r VALUES("24","6","Наука","1592029212");
INSERT INTO forum_r VALUES("10","6","Мистика","1591254179");
INSERT INTO forum_r VALUES("11","2","Игры форума","1597674900");
INSERT INTO forum_r VALUES("12","2","Игры на валюту","1597692240");
INSERT INTO forum_r VALUES("13","2","Конкурсы","1590598569");
INSERT INTO forum_r VALUES("14","3","Любовь","1592766299");
INSERT INTO forum_r VALUES("15","3","Дружба","1592808270");
INSERT INTO forum_r VALUES("16","3","Флирт","1592992711");
INSERT INTO forum_r VALUES("17","3","Отношения","1592807858");
INSERT INTO forum_r VALUES("18","4","Авто/мото","1590598668");
INSERT INTO forum_r VALUES("19","4","Рыбалка/охота","1590598688");
INSERT INTO forum_r VALUES("20","4","Увлечения","1590598705");
INSERT INTO forum_r VALUES("21","4","Животный  мир","1590598723");
INSERT INTO forum_r VALUES("22","5","Браузеры","1590657442");
INSERT INTO forum_r VALUES("23","5","Новинки","1590657875");
INSERT INTO forum_r VALUES("25","6","Медицина/здоровье","1591253905");
INSERT INTO forum_r VALUES("26","8","Конкурсы","1591017640");
INSERT INTO forum_r VALUES("27","13","Выпечка","1591353497");
INSERT INTO forum_r VALUES("28","13","Закатки на зиму","1591352990");
INSERT INTO forum_r VALUES("29","13","Десерты","1591805407");
INSERT INTO forum_r VALUES("33","2","Игры от Администрации","1597626801");



DROP TABLE IF EXISTS `forum_t`;

CREATE TABLE `forum_t` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_forum` int(11) NOT NULL,
  `id_razdel` int(11) DEFAULT NULL,
  `name` varchar(32) NOT NULL,
  `id_user` int(11) DEFAULT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `up` set('0','1') NOT NULL DEFAULT '0',
  `close` set('0','1') NOT NULL DEFAULT '0',
  `text` varchar(2000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_forum` (`id_forum`,`id_razdel`),
  FULLTEXT KEY `name` (`name`)
) ENGINE=MyISAM AUTO_INCREMENT=161 DEFAULT CHARSET=utf8;

INSERT INTO forum_t VALUES("1","2","11","Игра, битва полов","324","1590598835","1590598835","0","0","Итак, битва Мужчин против Женщин! Начинаем с 500...\r\nЕсли ты парень, то прибавляешь +2 к последнему посту!\r\nесли ты девушка, то отнимаешь -2 от последнего поста!\r\nДевушки выигрывают если в итоге получится 0\r\nПарни выигрывают если в итоге получится 1000. Подряд писать одному запрещено!!");
INSERT INTO forum_t VALUES("2","2","11","Игра Города","324","1592424487","1590598897","0","0","Всем известная с детства игра в города, правила надеюсь знают все");
INSERT INTO forum_t VALUES("3","2","11","Игра Имен","324","1592424462","1590599007","0","0","Всем privet\r\nСуть игры очень проста. Пишем любое необычное имя, затем следующий участник пишет имя на последнюю букву предыдтщего.\r\nНапример: ЯрослаВ - ВладилеН.");
INSERT INTO forum_t VALUES("4","2","11","Игра, 3-х литровая банка","324","1592424437","1590599089","0","0","\r\nПишем предмет,который войдёт в\r\nбанку.Начало нового слова-\r\nпоследняя буква\r\nпредыдущего.. я первый-- АвторучкА...\r\nP.S. По возможности не повторять.");
INSERT INTO forum_t VALUES("5","2","11","Игра чёрное белое","324","1592424352","1590599174","0","0","Играем так : называем всё-всё,что\r\nможет\r\nбыть чёрного или белого цвета.\r\nнапример: белый снег,чёрный\r\nуголь и тд.");
INSERT INTO forum_t VALUES("6","2","11","Игра, пирамида","324","1591179311","1590599254","0","0","Пишем слова размером от 3-х до 10 букв,потом идём по\r\nубывающей от 10 букв до 3-х букв.Причём каждое новое\r\nслово должно начинаться с последней буквы предыдущего\r\nслова и быть на одну букву больше/меньше(в зависимости от\r\nситуации).\r\nПример:\r\nКот-3\r\nТема-4\r\nАрена-5\r\nАнанас-6\r\nСуффикс-7\r\nСходство-8\r\nОранжерея-9\r\nЯровизация-10\r\nЯзычество-9\r\nОдежонка-8\r\nАбсцисса-7\r\nАромат-6\r\nТорос-5\r\nСекс-4\r\nсок-3");
INSERT INTO forum_t VALUES("7","2","11","Игра, шифр","324","1590599405","1590599395","0","0","ПРАВИЛА ИГРЫ: Дается слово. Например, стул. Следующий участник пишет осмысленно предложение, желательно юморное, каждое слово которого начинает по порядку с букв в слове «стул». Например: Старый тюлень ускусил лошадь. Последнее слово расшифровки - шифр для следующего игрока. То есть, следующий расшифровывает слово «лошадь». ъ, ь, ы – не считаем.");
INSERT INTO forum_t VALUES("8","3","14","Женщина старше","324","1590656367","1590656367","0","0","\r\nПоследнее время очень часто вижу такие пары,в которых женщина значительно старше своего мужчины... Они женятся,женщина даже рожает ребенка,причем желанного ребенка для обоих,несмотря на то,что уже довольно не молодая...Как вы считаете с чем это связано? Почему столько молодых,красивых женщин,но при этом они одиноки,а ровесницы их мам живут в окружении молодых поклонников...?");
INSERT INTO forum_t VALUES("9","3","14","Если любишь, все простишь","324","1590656433","1590656433","0","0","Многие говорят,если любишь..всё простить можно. Я в корне с этим не согласна. А как вы считаете,всё ли можно простить любимому человеку?\r\n");
INSERT INTO forum_t VALUES("10","3","14","Существует любовь с первого взгл","324","1590656501","1590656501","0","0","\r\nВопрос о существовании любви будоражит умы миллионов. Конечно, большинство людей считает, что настоящая любовь есть, ведь все её испытывали. Более того, её можно увидеть. Она хорошо читается в глазах влюбленных. Огонь страсти и желания окутывает сердца влюбленных, заставляя их биться чаще. Так существует ли настоящая любовь, спросите вы. Этот ответ каждый должен найти для себя сам.\r\nСуществует ли любовь с первого взгляда\r\nЛюбовь бывает только лишь с первого взгляда. Для того чтобы влюбиться человеку достаточно тридцати секунд. Этот факт подтвержден учеными. За это время легко можно успеть оценить внешность (фигуру, рост, цвет волос…) и склад ума человека противоположного пола. Многие могут возразить, сказав, что они были знакомы со своим партнером несколько лет и лишь потом влюбились друг в друга. И у этого факта есть объяснение. Наш мозг постоянно строит нам козни. Вы просто могли быть не готовы для этих отношений или вовлечены в другие. Только когда сознание полноценно обработает информацию, заложенную в подсознание, о том, что этот человек вам нравится, только тогда возможно развитие отношений и, конечно, влюбленность. Именно поэтому можно утверждать, что всякая любовь случается с первого взгляда, а проявляется только тогда, когда человек готов к ней.");
INSERT INTO forum_t VALUES("11","3","14","Виртуальная любовь","324","1590656563","1590656563","0","0","Есть много людей,которые могут сказать\"\"Я влюбился в интернете!\"\"\r\nЧто такое витруальная любовь на самом деле?\r\nТы не можешь прикоснуться к нему или к ней,не знаешь,что она или он чувствует в эту минуту...\r\nЛюбишь,страдаешь и не знаешь,реальна ли твоя любовь.\r\nА может нет этой любви?\r\nМожет это всё выдумка?\r\nУ кого была она,эта синтетическая любовь?");
INSERT INTO forum_t VALUES("12","3","17","О ревности","324","1590656676","1590656676","0","0","Ревность-всепоглощающее чувство, разрушившее немало пар и браков. Давайте посмотрим со стороны на ревнивцев и оценим, к каким результатам приводит ревность, если ее не обуздать. Начнем со статистики. Половина бытовых преступлений внутри семьи совершается на почве ревности. Большая часть разводов тоже происходит на почве ревности. Так что же такое ревность? Каковы причины, как ее подавить, как с ней бороться?\r\nКак известно, испокон веков «Воду в руках не удержать», так и ревнивцы забывают напрочь, что их партнер сделал осознанный выбор находиться и идти по жизни с Вами. Ревность базируется на ложном чувстве собственности и желании, чтоб партнер принадлежал только Вам. Но история человеческих взаимоотношений наглядно демонстрирует нам, что никто никому не принадлежит. Каждый волен выбирать того, с кем хочет жить признание в любви, заключение брака, венчание, штамп в паспорте никому и ничего не гарантируют. Только уважительное отношение к партнеру и его потребностям могут быть залогом успешной пары, и дать шанс, а не гарантировать длительные взаимные отношения.\r\nРевность дестабилизирует, взвинчивает и провоцирует агрессию и депрессию. А причина ее всегда заключается в ревнивце, в его комплексах, проблемах, недоверии, ложном чувстве собственника, эгоизме и девиациях.");
INSERT INTO forum_t VALUES("13","3","14","Недостатки  и достоинства","324","1590656800","1590656800","0","0","У каждого человека есть свои недостатки и достоинства.Вопрос в том,чего больше.Бывают люди,за достоинствами которых просто не замечаешь недостатки.Но есть те,один недостаток которых перечеркнет все достоинства! А КАКИЕ НЕДОСТАТКИ ГОТОВЫ НЕ ЗАМЕЧАТЬ ВЫ В ЛЮБИМОМ ЧЕЛОВЕКЕ И КАКИЕ ДОСТОИНСТВА ДЛЯ ВАС СТОЯТ НА ПЕРВОМ МЕСТЕ ?\r\n");
INSERT INTO forum_t VALUES("14","3","17","Об отношениях друг к другу","324","1590656873","1590656873","0","0","Самая большая ошибка в отношениях — это думать, что если человек тебя любит, то он никуда не денется...\r\nВ начале, когда люди только начинают узнавать друг друга, в отношениях присутствует уважение, нежность каждый старается не показывать свои недостатки...\r\nА потом всё уходит... на место приходит эгоизм, когда человек настолько расслабляется, что уже не следит за своими словами, поступками, всю злость, плохое настроение, эмоции срывает на близких...\r\nКажется, да ладно, куда он от меня денется… Исчезло внимание, забота, приятные мелочи и не мудрено, что скоро исчезнет и любимый человек…Если недостаёт теплоты, мы вынужденны искать их рядом с другими людьми... не допускайте этого... Берегите, тех кто рядом... Судьба предоставляет таких людей лишь раз..\r\n");
INSERT INTO forum_t VALUES("15","3","17","Доверие в отношениях","324","1590656950","1590656950","0","0","Доверие в\r\nотношениях мужчины и\r\nженщины играют очень\r\nважную роль. Эти сегменты, по\r\nсути, являются фундаментом,\r\nкоторый должен быть заложен\r\nс самого начала. Иначе, здание\r\nназываемое идеальными\r\nотношениями разрушится от\r\nпервого землетрясения\r\n(проблемы). Проще говоря,\r\nесли ваша любимая поздно\r\nприходит домой, значит, она\r\nбыла на совещании, а если ваш\r\nвозлюбленный говорит, что эта\r\nкрасавица является подругой\r\nприятеля, значит это так!\r\nКонечно, понятно, что, вступая\r\nв близкие отношения, у вас в\r\nжизни происходят серьёзные\r\nперемены. Вы начинаете\r\nзаботиться о своём партнере,\r\nно главное, чтобы это светлое\r\nчувство не переросло в\r\nкаверзное чувство ревности.\r\nБезусловно, ваш любимый\r\nможет сам нагнетать\r\nобстановку, путём каких либо\r\nзадержек на работе или\r\nночных посиделок с друзьями.\r\nНо попытайтесь понять, что у\r\nнего до вас была своя жизнь,\r\nсвои интересы. Как говорится,\r\nчеловек без прошлого не\r\nимеет бедующего.\r\nЕсли же всё-таки такое\r\nпроисходит в ваших\r\nотношениях совсем не\r\nобязательно закатывать\r\nистерики, достаточно задать\r\nнесколько ненавязчивых\r\nвопросов, чтобы всё\r\nразъяснить. Ведь поспешные\r\nвыводы еще никогда не\r\nприводили к верному\r\nрешению создавшейся\r\nпроблемы. Верьте, друг другу и\r\nвсё у вас будет хорошо!\r\nДоверие в отношениях самое\r\nглавное!\r\n");
INSERT INTO forum_t VALUES("16","3","17","Что хуже","324","1590657053","1590657053","0","0","Как Вы считаете, что хуже, ненависть или равнодушие?\r\nСчитаю, что оба чувства невыносимы. Но если человека ненавидят, он переживает, отчаивается, входит в депрессию, а вот когда к человеку равнодушны, трудно не сойти с ума, дабы не знаешь как привлечь к себе внимание, в котором ты очень нуждаешься, трудно выносить бездействие по отношению к тебе, иногда даже хочется чтобтебя лучше ненавидели, чем игнорировали...Равнодушие - это тупик, ты не знаешь что делать и начинаешь отчаиваться. В ненависти тоже больно. Другой вопрос в том, как сам человек реагирует на ненависть и равнодушие. Одним лучше равнодушие, другим ненависть. Но плюс ненависти в том,что человек знает как к нему относятся, нет неожиданности и незнания, минус в том, что у некоторых слабая психика. В равнодушии же плюс в том, что человека никто не тиранит, не оскорбляет, он живёт спокойно, но худшее в том, что безразличие-оно просто убивает. Пожалуй самое худшее-это неизвестность. Но если выбрать между равнодушием и ненавистью,то для меня хуже равнодушие.");
INSERT INTO forum_t VALUES("17","5","22","Браузеры на , Android","324","1590657292","1590657292","0","0","Данная тема посвящена интернет-\r\nбраузерам для Android OS.\r\nОбсуждаем здесь достоинства и\r\nнедостатки различных браузеров,\r\nделимся советами по их\r\nнастройке, ну и конечно помогаем\r\nрешить проблемы, возникающие\r\nпри их использовании.\r\nПри написании вопроса, совета,\r\nлибо просто при высказывании\r\nсвоего мнения рекомендуется\r\nуказывать модель устройства (по\r\nданым в пункте \"О телефоне/\r\nустройстве\" в настройках), версию\r\nОС (название прошивки, если\r\nкастом) и название и версию\r\nиспользуемого браузера. Если\r\nзадаете вопрос (описываете\r\nпроблему) соблюдение данной\r\nрекомендации обязательно");
INSERT INTO forum_t VALUES("18","5","22","Пользователи были обмануты","324","1590657442","1590657442","0","0"," более 300 тысяч устройств под управлением операционной системы Android подверглись атакам злоумышленников через браузер Chrome. Методы распространителей вредоносного ПО рассчитаны на людей, плохо понимающих принцип работы своего смартфона, и скорее всего, нашим читателям атака не грозит, но знать о ней стоит.\r\nПользователи Android становятся жертвами злоумышленника во время интернет-серфинга. На разных страницах и сайтах может появиться всплывающая реклама. Реклама, с которой были связаны многочисленные атаки за последние два месяца, говорит о наличии в вашем смартфоне вируса, хотя, скорее всего, никакого вируса в вашем смартфоне нет. Разумеется, реклама любезно предлагает избавить вас от вируса.\r\n318 тысяч пользователей Android поверили рекламе и тапнули на всплывающий баннер. Очевидно, что это очень доверчивые люди, которые не способны отличить всплывающий баннер от важного системного сообщения. Этим самым доверчивым людям дается пошаговая инструкция по активации установки приложений из непроверенных источников. После того как пользователи выполнят все советы злоумышленников, на их смартфон будет загружена и установлена вредоносная программа, собирающая данные.\r\nКак реагирует Google на появление подобных угроз? Достаточно оперативно. Лаборатория Касперского в понедельник передала компании Google информацию о трояне Svpeng, который распространялся с помощью Google AdSense. Поисковый гиганты быстро отреагировал, объявления, созданные злоумышленниками, были удалены.\r\nНо можете не сомневаться в том, что появятся новые. Конечно, вам они не страшны, но они могут доставить неприятности вашим родственникам. Лучшее, что вы можете сделать в борьбе против злоумышленников сегодня, самостоятельно принять и донести до всех близких вам пользователей Android – установки приложений из неизвестных источников нужно избегать.\r\n");
INSERT INTO forum_t VALUES("19","5","23","Новый смартфон от Polaroid","324","1590657655","1590657655","0","0","Американская компания Polaroid привезла на выставку Consumer Electronics Show 2016 два новых смартфона под управлением операционной системы Android. Первым стал Polaroid Snap, который будет выпущен сразу в трёх модификациях: с дисплеем диагональю 5 дюймов, 5,5 дюйма и 6 дюймов. Независимо от диагонали экрана все версии имеют разрешение 1280х720 пикселей. Остальные технические характеристики трёх моделей Polaroid Snap идентичны.\r\nPolaroid Snap получил четырёхъядерный процессор, 2 ГБ оперативной памяти, 16 ГБ встроенной памяти, 13-мегапиксельную основную и 5-мегапиксельную фронтальную камеры. Стоить смартфон будет будет от $129,99 до $179,99 в зависимости от размера экрана.\r\nВторой новинкой стал Polaroid Power, получивший 6-дюймовый Full HD-дисплей, 64-разрядный восьмиядерный процессор, 3 ГБ оперативной памяти, 32 ГБ встроенной памяти, аккумулятор ёмкостью 3 000 мАч, 13-мегапиксельную основную и 8-мегапиксельную фронтальную камеры. Оба смартфона будут поставляться с предустановленной версией операционной системы Android 5.1 Lollipop.\r\nPolaroid Power будет продаваться по цене $249,99. О доступности и сроках начала продаж смартфонов пока ничего не сообщается.\r\n");
INSERT INTO forum_t VALUES("20","5","23","Наушники блютуз","324","1590657875","1590657875","0","0","Monster Beats в очередной рас решила нас порадовать добавив в свою линейку беспроводных наушников новинку YP-702 .Теперь в новинку встроили MP3 (microSD до 32ГБ), FM радио и Bluetooth\r\nБеспроводные наушники Monster Beats с встроенным blutooth, MP3 и FM радио\r\nБлагодаря беспроводным стереофоническим Bluetooth наушникам YP-702 Вы сможете:\r\n-Без проводов слушать стереофоническую музыку со своего любымого музыкального полеера, мобильного телелефона,ПК и или любого другого гаджета;\r\n-Использовать в качестве беспроводной гарнитуры для совершения звонков с мобильного телефона или общения в Skype через ПК;\r\n-Удобное дистанционное управление основными функцициями музыкального плеера (воспроизвидение, остановка,переключение треков,регулировка громкости и др.);\r\n-Bluetooth версии 2:1 + EDR воспроизведет высококачественный звук без помех и болие низким энергопотреблением на растоянии до 10 метров(в зависимости от условий);\r\n");
INSERT INTO forum_t VALUES("21","2","11","Игра, слова на АТЬ","324","1595081058","1590682018","0","0","Игра заключается в следующем: Каждый участник пишет любое слово, заканчивающееся на окончание АТЬ.\r\nНапример: ДержАТЬ, страдАТЬ, бежАТЬ и так далее. В словх-примерах выделены окончания, для ясности, но в комментариях нужно писать правильно, обычное слово и не писать окончание \"ать\" заглавными буквами. Так же запрещено вставлять заглавные буквы в слова и какие-либо символы: точки, запятые, скобки и так далее.\r\nсамый активный за 5 дней получит награду: .5я. рублей.");
INSERT INTO forum_t VALUES("22","2","11","Игра, цепочка слов","324","1592424041","1590682231","0","0","ПРАВИЛА ИГРЫ: igra\r\n1. Играющий превращает существительное из последнего словосочетания в прилагательное и создаёт новое словосочетание.\r\n2. Если из существительного последнего словосочетания нельзя создать прилагательное, то вместо него берется синоним.\r\n___________________________\r\nПример построения цепочки:\r\nведущий:ОСТРОЕ СТЕКЛО\r\nследующий игрок: СТЕКЛЯННАЯ ДВЕРЬ\r\nследующий: ДВЕРНАЯ РУЧКА\r\nследующий: РУЧНАЯ СОБАКА....\r\n...СОБАЧЬЯ РАДОСТЬ ...\r\nПопробуем?\r\n");
INSERT INTO forum_t VALUES("23","2","11","Игра, расшифруй абвиатуру","324","1592423995","1590682408","0","0","\r\nИгра проста. Задаёться абвиатура и её расшифровка зависит от Вашей фантазии и чувством юмора, но без мата и пошлости.\r\nИ как пример:\r\nВЛКСМ: Виконт лакомился криветками с мартини.\r\nВарианты зависят от вашей изобретательности.\r\nКогда фантазия иссякнет Вы пишите свою абвиатуру а другие пускай ломают голову.\r\nУдачи.");
INSERT INTO forum_t VALUES("24","6","24","Под землёй есть горы","324","1590740652","1590740652","0","0","Ландшафт Земли невероятно разнообразен: на ее поверхности есть как гладкие равнины, так и глубокие впадины и огромные горы. Как показало исследование геофизиков из США и Китая, все это — ничто, по сравнению с видами, которые открываются на глубине сотен километров под нашими ногами. Они считают, что там есть массив огромных гор, высота которых намного превышает высоту 1916-метровой горной системы Аппалачи.\r\nЭто открытие было сделано в ходе изучения мощного землетрясения 1994 года, произошедшего в Боливии. Архивные данные показали, что его подземные толчки были настолько мощными, что их волны достигли глубины 410-660 километров. Именно там находится слой Земли под названием «переходная зона» — граница между верхней и нижней мантией планеты. Изучив отражение сейсмических волн от подземных поверхностей, ученые смогли составить видение подземной структуры.\r\nВыяснилось, что верхняя граница зоны на глубине 410 километров имеет относительно гладкую поверхность. Однако, поверхность на глубине 660 километров оказалась крайне неровной, с резкими изменениями высот до 3,2 километров. Исходя из этих данных было выдвинуто предположение, что глубины Земли имеют гораздо больше неровностей, чем ее поверхность.\r\nНаличие такого рельефа намекает на то, что породы нижнего слоя мантии практически не перемешиваются с твердой оболочкой Земли. Получается, что со времен образования планеты они сохранились практически в первозданном виде. Исследователи намерены продолжить исследования чтобы выявить исторические процессы формирования Земли.\r\n");
INSERT INTO forum_t VALUES("25","6","24","Найденна загадка возникновение ж","324","1590740768","1590740768","0","0","Международная группа ученых пришла к выводу, что 3,5 млрд лет назад микробная жизнь на Земле процветала, а не находилась на грани вымирания.\r\nОни проанализировали изотопный состав серы в древних отложениях. Известно, что в анаэробных условиях микроорганизмы потребляют сульфаты, выделяя сульфиды.\r\nПри этом от типа метаболизма зависит соотношение изотопов серы в продуктах жизнедеятельности, пишет\r\nУченые связали выявленные в древних горных породах соотношения стабильных изотопов серы (сера-32, сера-33 и сера-34) с бактериальным метаболизмом и выяснили, что признаки жизни прослеживаются в течение более чем трех миллиардов лет.\r\nЭто согласуется с тем предсказанием, что древние микроорганизмы были широко распространены по Земле.\r\nКак сообщал OBOZREVATEL, ученые из США определили, что\r\nтвердому ядру Земли — 565 миллионов лет.\r\n");
INSERT INTO forum_t VALUES("26","6","24","Смелая гипотеза о планете Х","324","1590740903","1590740903","0","0","\r\nВыдвинута еще одна смелая гипотеза о планете Х\r\nСпециалисты из американского университета Бейрута в Ливане и Университета Кембриджа заявили о том, что за планетой Нептун может находиться не один большой объект, а крупная группа очень мелких объектов пояса Койпера.\r\nКак информирует replyua.net , физики считают, что необычным орбитам объектов внешней области Солнечной системы может быть альтернативное объяснение.\r\nОни утверждают, что с помощью специальных вычислений смогли объяснить особенности странных орбит объектов, но при этом они учитывали влияние всех известных планет Солнечной системы. Ученые, занимавшиеся изучением карликовой планеты в поясе Койпера, обнаружили несколько объектов за Нептуном, которые избавились от гравитационного притяжения газовых гигантов. При этом орбиты открытых объектов отличались от орбит остальных тел в поясе Койпера. У физиков создалось впечатление, что какая-то особенная сила притянула объекты и поставила их в таком положении.\r\nПри помощи компьютерного моделирования ученые установили, что контролирует этот процесс невидимая планета гигант. До сих пор эта гипотетическая планета ускользает от астрономов, но в этом нет ничего необычного. Довольно сложно разглядеть настолько слабо освещенный объект на таком большом расстоянии, особенно когда мы не особо представляем его местоположение.\r\n");
INSERT INTO forum_t VALUES("27","6","24","Этого незнали в 21 веке","324","1590740995","1590740995","0","0","\r\nНемецкие ученые нашли ранее неведомую в теле человека сеть мелких кровеносных сосудов, которая находится в костях.\r\nДанные сосуды помогают быстро и эффективно распространять кровь по организму, передает\r\nСиенс Алерт.\r\nЭто действительно неожиданно - найти новую центральную анатомическую структуру, которая не была описана ни в одном учебнике в 21 веке, − рассказал один из авторов исследования иммунолог Маттиас Гунцер.\r\nСперва был проведен эксперимент на мышах. Исследователи использовали световую флуоресцентную и рентгеновскую микроскопию, чтобы сделать кости прозрачными. Так ученые увидели несколько сотен капилляров, названных транскортикальными сосудами.\r\nПо словам исследователей, большая берцовая кость мыши может содержать более тысячи таких кровеносных сосудов, при этом через них проходит более 80 процентов артериальной и 59 процентов венозной крови.\r\nПозже данный опыт провели и на человеке. В результате в большой берцовой кости обнаружили похожую систему с более толстыми кровеносными сосудами. Однако, по признанию исследователей, для определения их точных функций требуются дальнейшие эксперименты.\r\nУказано, что данное открытие может объяснить, каким образом инъекции лекарств в костный мозг способствуют их распространению по всему организму.");
INSERT INTO forum_t VALUES("28","6","24","Успех зависит от генов","324","1590743841","1590743841","0","0","\r\nУченые выяснили, что движение вверх по социальной лестнице отчасти запрограммировано в наших генах.\r\nК исследованию привлекли более 20 тыс. человек в Великобритании, США и Новой Зеландии. Оно показало, что люди с определенными генетическими вариациями зарабатывают больше денег, добиваются бόльших успехов в карьере и дальше продвигаются в образовании, сообщает Daily Mail .\r\nНезависимо от классового происхождения, их гены могут помочь им быть успешнее по жизни, чем были их родители.\r\nЭто исследование придает вес теории, что природа в большей степени, чем воспитание, определяет, насколько больших успехов добиваются люди.\r\nИсследователи искали тысячи крошечных изменений в генетическом коде людей, ранее соотнесенных с успехом в школе, сообщают авторы. Они обнаружили, что мужчины и женщины с \"образовательными генами\" - или высоким полигенным баллом - лучше учились.\r\n");
INSERT INTO forum_t VALUES("29","6","24","Анизотропный мир","324","1590743922","1590743922","0","0","\r\nКак устроен наш Мир? Почему важны не\r\nвещи, а принципы симметрий? Откуда\r\nберутся истоки непостижимой\r\nэффективности математики в\r\nестественных науках? Есть ли научные\r\nподтверждения идее Пифагора, что все\r\nсущее – числа? Этими и другими\r\nвопросами задаются авторы научно-\r\nпопулярного фильма «Анизотропный\r\nмир».\r\nСвои ответы они пытаются искать в\r\nнаправлении замены обычной геометрии\r\nпространства-времени на финслерову, в\r\nкоторой, образно говоря, теорема\r\nПифагора связывает не квадраты, а\r\nчетвертые степени катетов и гипотенуз. В\r\nфильме представлены точки зрения\r\nпрофессиональных физиков,\r\nобъединенных желанием искать\r\nестественные расширения теории\r\nотносительности Эйнштейна, не\r\nвходящие в концептуальные\r\nпротиворечия с последней. В некотором\r\nсмысле, это продолжение фильма\r\n«Геометрия вселенной с разных точек\r\nзрения».");
INSERT INTO forum_t VALUES("30","6","24","Сердце Марса","324","1590744052","1590744052","0","0","На Земле есть места, похожие на\r\nповерхность Марса, но и на красной\r\nпланете есть территории, напоминающие\r\nнаш Дом.\r\nОрбитальному космическому аппарату\r\nMars Reconnaissance Orbiter удалось\r\nсделать снимок гор, покрывающих\r\nпланету. Этот кадр уникален, потому что\r\nобычно материковые породы скрыты под\r\nслоем мелкозернистых пород и\r\nпесчаными дюнами.\r\nМарсианские тектонические плиты\r\nотличаются от земных тем, что\r\nпрактически неподвижны. Единственное\r\nокошко, позволяющее изучить\r\nгеологическое пошлое планеты, вот такие\r\nкадры открытой горной породы.\r\nИзображение было получено с помощью\r\nкамеры High Resolution Imaging Science\r\nExperiment (HiRISE) и искусственно\r\nраскрашено. Аппарат Mars Reconnaissance\r\nOrbiter вышел на орбиту Марса в 2006\r\nгоду и находится на высоте около 300\r\nкилометров.");
INSERT INTO forum_t VALUES("31","6","24","Как появилась луна","324","1590744100","1590744100","0","0","Есть версия, что Луна слеплена из множе­\r\nства обломков, которые на протяжении\r\nмиллионов лет возникали после\r\nстолкновений космических тел с Землей\r\nтекст: GEO Россия\r\nЛуна, возможно, не «отпочковалась» от\r\nЗемли в результате одного столкновения\r\nс каким-то другим объектом, а\r\n«склеилась» из множества маленьких\r\n«лун».\r\nПо самой распространенной версии Луна\r\nобразовалась из обломков Земли и Тейи\r\n— гипотетической планеты, которая\r\nоколо 4,5 миллиардов лет назад\r\nврезалась в нашу планету. При этом Луна\r\nдолжна была почти на две трети\r\nсформироваться именно из обломков\r\nтаинственной Тейи.\r\nОднако израильский планетолог Ралука\r\nРуфу и ее коллеги в статье,\r\nопубликованной в журнале Nature\r\nGeoscience, отмечают: во-первых, Луна\r\nслишком уж подозрительно похожа по\r\nсвоему изотопному составу именно на\r\nЗемлю. Во-вторых, для такого сценария\r\nдолжно было совпасть очень много\r\nобстоятельств, а значит, вероятность его\r\nневелика.\r\nВместо этого ученые предлагают\r\nальтернативную историю событий:\r\nпоследовательный «обстрел» Земли\r\nнебольшими космическими телами,\r\nкоторые оставляли за собой кольцо из\r\nобломков вокруг планеты. Из этого\r\nмусора возникали небольшие спутники,\r\nкоторые постепенно «слились» в Луну.\r\nТакой сценарий, как показало\r\nматематическое моделирование, намного\r\nболее вероятен, чем одно «удачное»\r\nстолкновение Земли и Тейи.\r\n\r\n");
INSERT INTO forum_t VALUES("32","6","24","Как погибнет наша Галактика","324","1590744241","1590744241","0","0","Специалисты Колумбийского университета рассказали о том, как исчезнет жизнь на Земле, а затем и наша галактика, пишет Space.com. Оказывается, по космическим меркам Млечному пути осталось недолго.\r\nГАЛАКТИКИ СТОЛКНУТСЯ\r\nТеория Большого взрыва, объясняющая начало Вселенной, — общепринятая, но не единственная космологическая модель. Согласно ей, после Большого взрыва образовалось облако из пыли и газа, из которого через девять миллиардов лет сформировалась Вселенная.\r\nЗемля находится в Солнечной системе, а та – в галактике Млечный путь, которая является частью Вселенной. Все объекты подвижны и взаимодействуют между собой.\r\nНесколько десятилетий назад ученые установили, что наша галактика движется к галактике Андромеда с огромной скоростью. Их столкновение произойдет через 2,5 млрд лет, после чего обе галактики прекратят свое существование.\r\nВпрочем, населению Земли переживать не стоит – жизнь на планете исчезнет раньше. По мнению ученых, через 1 млрд лет Солнце будет выделять слишком большое количество тепла, из-за чего запасы воды на Земле исчезнут, а вместе с ними – и все живые организмы.\r\nПозднее Солнце расширится, станет в сотни раз больше по объему, превратится в Красный гигант и поглотит другие небесные тела, расположенные на небольшом расстоянии от него. После этого звезда сожмется и станет Белым карликом.\r\n");
INSERT INTO forum_t VALUES("33","6","24","Темная материя","324","1590744305","1590744305","0","0","Если мы копнем историю, то найдется множество астрономических\r\nоткрытий, достойных Нобелевской премии, как то законы\r\nпланетарного движения Кеплера, обнаружение расширения\r\nВселенной начала 20 века, классификация звезд по их\r\nспектральным отпечаткам. Но открытие темной материи —\r\nотносительно свежее достижение, которое грубо обделил вниманием Нобелевский комитет. В 1970-х годах Вера Рубин и Кент Форд увидели, что звезды по\r\nкраям галактик двигались так же быстро, как и звезды около\r\nцентра — другими словами, галактики вращаются так быстро, что\r\nдолжны были разлететься… если только что-то невидимое не\r\nдобавляет гравитации, удерживающей их вместе от разбегания. Это нечто невидимое стало известно как темная материя\r\n— загадочная субстанция, на долю которой приходится почти 90%\r\nмассы Вселенной. Она не излучает и не отражает свет,\r\nвзаимодействуя с обычной материей только посредством\r\nгравитации. Из-за своей скрытной и непонятной природы, частицы темной\r\nматерии тоже остаются неуловимыми. Короче говоря, ученые\r\nточно не знают, что это такое. Возможно, эта неопределенность\r\nявляется причиной, по которой Нобелевский комитет умалчивает\r\nоб открытии темной материи, хотя премия по физике в 2011 году\r\nдосталась за похожее загадочное космологическое открытие.");
INSERT INTO forum_t VALUES("34","6","24","5 фактов о марсе","324","1590744392","1590744392","0","0","Марс – четвертая планета солнечной системы. За свой кроваво-красный цвет он получил имя римского бога войны — Марса. В средние века, когда «красная планета» появлялась на небосклоне, гадальщики предсказывали войны и тысячи несчастий. Теперь же Марс, утратив свое магическое значение, остается. Давайте познакомимся с некоторыми научными данными, связанными с нашим ближайшим соседом – Марсом.\r\nГравитация Марса\r\nГравитация на Марсе в 3 раза меньше Земной, а всё потому что размеры и масса планеты Марса меньше нашей. Благодаря этому космонавт может прыгать в 3 раза выше А как вы знаете, чем громадней объект, тем больше его масса, а следовательно и сильнее притяжение.\r\nЖизнь на Марсе\r\nНи одно из обитаемых на Земле существ не смогло бы выжить в разреженной атмосфере Марса. Давление на поверхности планеты настолько низкое, что кислород в крови моментально превратился бы в пузырьки газа, что вызвало бы газовую эмболию и неминуемую смерть.\r\nУжасные условия\r\nСмертельные дозы радиации на Марсе из-за отсутствия озонового слоя. При восходе Солнца, планета получает смертельные дозы радиации. Кроме того, отсутствие защитного слоя сказывается и на температурном режиме планеты. В полдень, температура поднимается до +30, зато ночью опускается до -80.\r\nЖизнь? Была ли она когда-то?\r\nКогда-то на Марсе были озера и реки, благодаря чему строятся предположения что планета была, прародиной человечества, а так же наличие на этой планете высохших русел рек и озер.\r\nСильнейшие бури\r\nНа Марсе очень часто случаются сильнейшие пыльные бури, во время которых скорость ветра достигает 180 км в час. Продолжаться такие бури могут в течение нескольких недель и охватывают всю планету. Причиной для их возникновения является приближение Марса к Солнцу.\r\n\r\n");
INSERT INTO forum_t VALUES("35","6","24","Цыфры _58_  на луне и марсе","324","1590744524","1590744524","0","0","\r\nИсследователи фотоснимков НАСА сумели обнаружить таинственные арабские цифры сразу на двух планетах — на Луне и на Марсе. На обеих планетах отчетливо различимы цифры \"58\". Что бы это могло означать?.. Почему именно эти цифры?\r\nАвтором уникальной находки выступил Сандра Елена Андраде, которая обнаружила цифры исследуя планеты в сервисе Google. Андраде опубликовала видео на своем канале YouTube в качестве подтверждения правдивости полученной информации.\r\nСтоит заметить, что выглядят цифры подозрительно одинаково на обоих планетах. Начертанные на поверхности Красной планеты цифры 58 расположены на 1 градусе 29 минутах и 8 секундах северной широты и 23 градусах 0 минутах и 11 секундах западной долготы. Ученые уже успели отозваться: да, такой феномен присутствует, но объяснения ему пока нет. Координаты же цифр на Луне пока остаются не подтвержденными.\r\nС интересным заявлением выступил уфолог Скотт Уоринг, который мало того, что сообщил, будто прежде находил и другие цифры и готов это подтвердить снимками. Так, по его словам, на Марсе он обнаружил цифру 6, также неизвестного происхождения. Однако, помимо этого, исследователь выдвинул предположение, которое может объяснить появление этих таинственных знаков на поверхности планет.\r\nЯкобы, внутри знаменитой «Зоны 51» существовала «Зона S4». Здесь военные учили новобранцев о существовании 56 известных инопланетных цивилизаций. Возможно, что люди могли оказаться 58-ми - тогда и цифры являются своеобразной меткой принадлежности планет людям. Представители NASA пока никак не прокомментировали эту версию.\r\n");
INSERT INTO forum_t VALUES("36","6","10","Древние подземные тунели","324","1590932626","1590932626","0","0","Подземные туннели которые находят на всех континентах Земли. Загадка рукотворных сооружений до сих пор не разгадана специалистами. С какой целью и кто соорудил их специалистам не известно. \r\nдревние туннели расположены по всей планете, в том числе и на дне океанов. Эти туннели как будто выжжены в тверди земной. Стены туннелей это затвердевший расплав горных пород, очень похожий на стекло. Современным специалистам пока неизвестна такая горнопроходческая технология. Возраст самых древних туннелей около миллиона лет...\r\n \r\nНедавно были обнаружены огромные неизученные пустоты в Египте под пирамидами на плато Гиза. Эти туннели расходятся в разные стороны: на север к Черному морю, к Тибету на восток и на запад к Атлантическому океану. Где они и соединяются с американской системой. \r\nОбнаруженные туннели в Западной Европе возрастом 12 тысяч лет никак не могли соорудить первобытные люди...у них просто не было знаний и подходящих технологий...Остается только предполагать, что на Земле в древности существовала высокоразвитая цивилизация, которая исчезла по неизвестным причинам.\r\nЕсть ещё одна невероятная мысль,которую высказывают многие учёные,глубоко под землёю есть своя флора и фауна, свои моря. Теоретически современная наука допускает о существовании под землей самодостаточной биосферы,т.е неизвестной нам пока жизни.\r\nУченые считаю что уровень подземной цивилизации выше нашего. \r\nПодземный мир где живут люди миллионы лет для ученых остается загадкой. Но вполне возможно эту загадку давно разгадали спецслужбы и не исключено, что она уже давно поддерживают связь с его жителями.");
INSERT INTO forum_t VALUES("37","6","10","Зона Прейзера","324","1590932761","1590932761","0","0","Зона Прейзера - аномальное место, расположенное в Калифорнии в городе Санта-Крус (США) и обнаруженное в 1940 году Джорджем Прейзером. Сегодня небольшая территория на склоне холма, заросшего исполинскими эвкалиптами, стала местом паломничества туристов. У входа на аномальный участок земли лежит бетонная балка. Один ее конец находится в зоне действия загадочных сил, другой вне ее. С помощью имеющегося у гида уровня каждый может убедиться, что балка лежит абсолютно горизонтально.\r\nОднако если на противоположные концы балки поставить двух человек примерно одинакового роста, то находящийся в зоне будет выглядеть значительно ниже, а поменявшись местами со своим напарником - гораздо выше его. Внутри зоны стоит небольшая деревянная хижина, которую Прейзер построил 40 лет назад.\r\nОна сильно перекошена. При подходе к ней посетители чувствуют усиливающееся давление, так что приходится наклоняться вперед, чтобы удержать равновесие. Компас в зоне ведет себя весьма странно: в метре от земли он точно показывает стороны света, но стоит его опустить чуть ниже, стрелка меняет свое положение на 180 градусов.\r\nТяжелый металлический шар, с силой пущенный по желобу (наклоненному к центру зоны), не проделав и половину пути, останавливается и с ускорением катится обратно. Точно также, нарушая закон гравитации, ведут себя и неметаллические предметы. Все эти явления максимально усиливаются в центре зоны - внутри хижины.\r\nНаиболее мощное воздействие ощущается людьми там же. Их клонит к земле с такой силой, что складывается зрительное впечатление, будто они парят в воздухе.");
INSERT INTO forum_t VALUES("38","6","10","Кайлас неразгаданная тайна","324","1590932869","1590932869","0","0","Загадки планеты. Гора Кайлас \r\nЭто одно из загадочных мест в мире, высота которого – 6666 метров.\r\nНа противоположной стороне земли от горы Кайлас находится остров Пасхи, что славится своими каменными идолами.\r\nВозле Кайласа люди быстрее стареют (12 часов идет приблизительно за 2 недели), об этом свидетельствует рост волос и ногтей.\r\nА также гора меняет целевые установки: тех, кто к ней близко подходит, она «посылает» обратно. Еще ни одного альпиниста она не пустила на свою вершину. Тех, кто пытался, гора «скидывала».\r\nРядом с горой находится два озера: Манасаровар (живой и чистой воды) и Ракшас таль (по-тибетски – лханаг цо, «озеро демона»).\r\nВ озере Манасаровар (пресное), что расположено на высоте 4560 м над уровнем моря, можно купаться, пить воду, его считают священным; в любую пору года при любой погоде на нем штиль.\r\nРакшас (соленое озеро) – 4515 м над уровнем моря. Считается озером мертвой воды, которую нельзя не только пить, но и прикасаться к ней; в любое время года и при любой погоде на этом озере шторм.\r\nГора Кайлас разбита двумя огромными гребнями-трещинами, которые особенно в вечерние часы с помощью тени от выступов скалы образуют собой огромное изображение свастики.\r\nТот факт, что гора Кайлас является пирамидой (которая, так же как и остальные пирамиды, четко ориентирована по сторонам света), уже давно не новшество. Все ученые, которые побывали возле Кайласа, не сомневаются в ее пирамидальности.\r\nМногие исследователи уверены в том, что у подножья и на серединном уровне гора имеет пустоты. \r\nЭто предположение дает основание считать: Кайлас – это неприродное образование, возведенное с неизвестной целью неизвестно кем...\r\nОт горы Кайлас до монумента Стоунхендж (Англия) – 6666 км.\r\nДо Северного полюса – 6666 км.\r\nОт горы до Южного полюса – два раза по 6666 км.\r\nсамой «таинственной» тайной Кайлас является примыкающей к ней саркофаг Нанду. \r\nПроведя ряд исследований, ученые установили наличие полостей внутри саркофага. \r\n");
INSERT INTO forum_t VALUES("39","6","10","Пирамиды на дне океана","324","1590932951","1590932951","0","0","Бермудский треугольник: аномалии 2012 года \r\nИсчезновение людей, природные аномалии, невыясненные факты, засвидетельствованные очевидцами. Новые открытия, которые больше задают новые вопросы, чем дают ответы. Не одно десятилетие человеческие взоры, разговоры и внимание приковывает бермудский треугольник.\r\nВсего лишь несколько месяцев назад, 10 октября 2012 года, мир потрясло новое открытие: канадская фирма Advaanced Digital Commenikation нашла на дне бермудского треугольника построения необычного города, с дорогами, тоннелями, полуразрушенными стенами и пирамидами.\r\nНа глубине около 60 м нашли две гигантские пирамиды. Океанографам удалось выяснить, что одна из них состоит из вещества, похожего на стекло. Напоминают они знаменитые египетские пирамиды, однако по размерам намного больше пирамиды Хеопса.\r\nЕщё большей загадкой является возраст пирамид: по мнению учёных, им не более 500 лет. Кто их создал и с какой целью остаётся тайной. По гипотезам учёных, пирамиды — это аккумуляторы для накопления неизвестной нам энергии.\r\nИсследователи бермудского треугольника решили сопоставить координаты таких мест на карте земли. В результате проявилась закономерность: все аномальные районы с промежутком в 72 градуса покрывают нашу планету — пять районов приходится на северное полушарие и пять на южное.\r\nИ если соединить эти точки с полюсами земли, то сетка этих зон будет иметь вид кристалла.\r\nСпециалисты выяснили и то, что почти во всех точках есть и пирамиды: в Бермудах, на Кайласе в Тибете, на острове Йонагуни в Японии, в Египте и Мексике.  \r\nЕсть предположение, что такие места — это своеобразные порталы в другие измерения...\r\nБермудский треугольник... Что кроется за ним? Какие силы или законы, недоступные пока человеческому пониманию?\r\nКто и когда даст ответ?\r\nИзвестно одно — пока существует тайна, не угаснет стремление человека разгадать её.");
INSERT INTO forum_t VALUES("40","6","8","Почему люди лгут","324","1590933247","1590933247","0","0","Почему люди лгут? Зачем нужна ложь? Почему мы не всегда хотим говорить правду? Каждый из нас неоднократно задумывался над этими вопросами. Подумайте, как бы мог существовать мир, в котором люди будут говорить друг другу только правду? Как ни крути, а ложь нам так же необходима, как и правда, для чего спросите Вы? Для поддержания внутреннего баланса. Только не стоит путать ложь во благо, личные секреты и фантазию с подлым обманом. \r\nЛожь сама по себе отличается от одноликой истины тем, что она многолика, она имеет сотни тысяч обличий и не имеет пределов. В большинстве случаев жертва обмана не может заметить просчетов лжеца, и отдает предпочтение тому, что бы объяснять неясности поведения в выгодном для себя свете, таким образом, тайно попустительствуя лжи, избегая при этом неприятной ситуации разоблачения обмана. В основном обманываясь (или же разоблачая обман), люди как получают что-то, так и теряют. Эта закономерность является одной из известных, из-за нее не всегда принимаются верные решения. Так давайте поговорим о том почему мы обманываем и до какой до какой степени можем обмануть и почему мы сами готовы обманываться?");
INSERT INTO forum_t VALUES("41","6","8","Мнение окружающих","324","1590933366","1590933366","0","0","Поскольку жизнь в обществе подразумевает общение с другими людьми, невольно приходится прислушиваться к тому, что о нас говорят окружающие. А поговорить люди любят и далеко не всегда приятное. Но как быть с этими разговорами? Как воспринимать их? А может и вовсе игнорировать….\r\nПочему многие еще слушают социум,боятся что о них подумают другие? Ведь это наша жизнь и мы её живем! Ваше мнение по этому поводу?");
INSERT INTO forum_t VALUES("42","6","8","Просто будте счастливы","324","1590933525","1590933525","0","0","Почему нельзя держа за руку просто сказать “Я люблю тебя”?! \r\nПочему нужно постоянно жить в страхе… \r\n“А вдруг я много даю?\r\nА вдруг ему надоест? \r\nА вдруг не время говорить?”\r\nК чёрту игры, сознание, воспитание....отдайся чистоте помыслов и силе чувств. Что мешает?\r\nЧто ты боишься потерять?\r\nИ ты будешь счастлива от того, что вот оно - ЕДИНСТВО ДУШ… Рядом… И ты залезешь ему под руку, прячась от всего мира там, где ты всегда уверена – он тебя чувствует… Каждое биение твоего сердца у него в сознании…\r\nОн не оставит без внимания ни радость, ни боль в твоих глазах с длинными ресницами… Он не отвернется, и не будет раздумывать, когда ты протянешь руку, и скажешь “давай мириться”.\r\nОн просто посмотрит в глаза и обнимет… молча. И в этом молчании будет весь мир… и ты услышишь больше, чем ты слышала с уст всего человечества…\r\nЦените самое важное...сколько энергетики имеет сила любви, сколько эмоций, переполняющих душу…\r\nЧто мешает?\r\nНу неужели тебе нужен рядом человек, который не поймет тебя, не прочувствует твою душу…?\r\nНет.\r\nТогда зачем игры?...\r\nЗачем?\r\nЕсли можно найти человека, с которым ты сможешь кричать в 3 часа ночи на балконе “Я тебя люблю всей душой”…\r\nА такого человека можно найти...Ищите!");
INSERT INTO forum_t VALUES("43","6","8","Ошо о смысле жизни","324","1590933596","1590933596","0","0","Ошо говорил, что жизнь состоит исключительно из бессмысленных вещей, которые не имеют цели (с точки зрения зрения современного прагматичного общества). Другими словами, жизнь существенна сама по себе. Средства и цели составляют одно целое, их нельзя разделить. Так говорил Ошо. Разделение всегда было стратегией тех, кто жаждет власти.\r\nЧеловек сам и есть смысл. Жизнь совершенна сама по себе и не нуждается, чтобы к ней добавляли ещё что-то. Всё, что нужно жизни – это, чтобы вы прожили её тотально. Если вы живёте вполсилы, тогда вы не сможете почувствовать волнение от самого факта жизни. Это как любой механизм, в котором работает лишь его часть. Такой механизм не выполнит своего предназначения.\r\nВ жизни часто людьми проживаются лишь отдельные её фрагменты. Недостаточно лишь производить шум или двигать руками-ногами – песни или танца от этого не получится. Песня, танец, значимость возникают тогда, когда целое начинает функционировать в гармонии, согласованно. Тогда вам не нужно задавать вопрос: «Есть ли у жизни цель?». Ответ на него вам будет известен: жизнь сама по себе и является целью. Другой цели не существует. Смысл должен исходить не из цели, а из самой жизни. Тогда чтобы вы ни делали, в самом совершении действия уже есть награда.\r\nТак говорил Ошо. Он стремился сделать человека неделимым целым, чтобы человек жил ради самой жизни.");
INSERT INTO forum_t VALUES("44","2","12","Игра Считалочка","324","1593541637","1590952025","0","0"," считаем  до 500, каждый 100-й пост получает- 10000 баллов и 300 монет! затем, продолжаем считать заново...  Поехали!");
INSERT INTO forum_t VALUES("45","2","12","Игра сто  смайликов","324","1591219941","1590952357","0","0","Новая игра-считалочка Сто смайлов   Суть игры в том, что мы считаем от 1 до 100  по прядку, добавляя к цифре смайлик.. Но! СМАЙЛЫ НЕ ДОЛЖНЫ ПОВТОРЯТСЯ! ЕСЛИ СМАЙЛ ПОВТОРИЛИ , ТО ОТСЧЕТ НАЧИНАЕТСЯ СНАЧАЛА!!! поэтому будте внимательней, добавляя пост! (Главное , чтоб смайлы не повторялись в одной сотне!!! )Пример: 1:) , 2.дружба.и так далее! Чей пост будет сотым  тот получает 5000 баллов + 1000 монет Далее начинаем всё сначала, заодно и смайлы выучим  Надеюсь всё понятно..поехали!");
INSERT INTO forum_t VALUES("46","6","5","Факты о Черной мамбе","325","1590962350","1590962350","0","0","[URL=http://vfl.ru/fotos/7458a91630680246.html][IMG]http://images.vfl.ru/ii/1590962526/7458a916/30680246_m.jpg[/IMG][/URL]\r\n\r\nЧёрная мамба — самая быстрая в мире змея. Она способна развить скорость до 20 км/ч, если возникнет такая необходимость.\r\nМамбы других видов живут преимущественно на деревьях, но только не чёрные — они предпочитают обитать на земле.\r\nВ качестве гнезда черные мамбы иногда используют не только пустые дупла, но и заброшенные термитники.\r\nВ Африке в результате расширения сельскохозяйственных угодий люди вторглись на земли, где обитают черные мамбы, но змеи никуда не уходят, поэтому случаи нападения на крестьян случаются всё чаще.\r\nДлина черной мамбы может достигать трёх метров. Ходят слухи и о пятиметровых экземплярах, но доказательств существования мамб таких размеров пока нет.\r\nВопреки своему названию, чёрные мамбы отнюдь не чёрного цвета. Своё наименование они получили благодаря чёрной окраске пасти, которую они широко раскрывают перед атакой.\r\nВ Африке каждый год восемь-десять тысяч человек погибают от укуса чёрной мамбы.\r\nНесмотря на предыдущий пункт, первой мамба на человека нападает редко. Обычно она атакует лишь в том случае, если её потревожить.\r\n\r\nЯд чёрной мамбы смертелен, если вскоре после укуса не ввести противоядие.\r\nОхотясь, чёрная мамба сперва кусает жертву, а потом отползает в сторону и ждёт, когда яд сделает своё дело.\r\nОснову рациона черной мамбы составляют птицы, мелкие грызуны и ящерицы.\r\nВ брачный период самцы чёрной мамбы сражаются между собой ради внимания самки, не применяя при этом, однако, своих ядовитых клыков.\r\nНоворожденная чёрная мамба может достигать в длину полуметра. Причём спустя пару часов после вылупления из яйца она уже готова охотиться.\r\nЗлейшие враги чёрных мамб — мангусты, которые безжалостно истребляют этих змей.");
INSERT INTO forum_t VALUES("47","6","5","Факты о страусах","325","1590965309","1590965309","0","0","[URL=http://vfl.ru/fotos/d73a7ac830680359.html][IMG]http://images.vfl.ru/ii/1590965297/d73a7ac8/30680359_m.jpg[/IMG][/URL]\r\nЗа один прыжок страус может преодолеть расстояние в 3-4 м.\r\nАфриканские страусы считаются самыми большими птицами на планете.\r\nТо, что страусы во время опасности якобы прячут свои головы в песок является мифом.\r\nВ безвыходных ситуациях страусы начинают атаковать своих противников ногами. Любопытно, что хищник может умереть всего от одного мощного удара.\r\nВысота страусов может достигать 270 см, при весе до 160 кг.\r\nНесмотря на то, что у страусов есть крылья, летать они совершенно не умеют.\r\nИнтересен факт, что страусы нередко пасутся вместе с зебрами и антилопами.\r\nОбычно семья страусов состоит из одного самца, 4-5 самок и птенцов.\r\nВ случае необходимости страусы могут развивать скорость до 70 км/ч.\r\nЗнаете ли вы, что порою страусы намеренно проглатывают гладкие камни, которые помогают им перемалывать пищу?\r\nСредняя продолжительность жизни страусов составляет порядка 40-50 лет.\r\nСредний вес яйца птицы достигает 1,2-1,3 кг.\r\nПомимо растений, страусы также могут питаться грызунами, рептилиями и насекомыми.\r\nЛюбопытно, что глаз страуса больше чем его мозг.\r\nЧтобы избавиться от паразитов, находящихся на поверхности кожи, страусы начинают валяться в пыли.\r\nСтраусы являются единственными птицами, имеющими на ногах всего по 2 пальца.");
INSERT INTO forum_t VALUES("48","6","5","Факты о коронавирусе","325","1590968130","1590968130","0","0","1. COVID-19 обычно не распространяется на большие расстояния. Заражение воздушно‑капельным путём наиболее вероятно лишь при тесном контакте с больным. Именно поэтому в самом начале заболевали члены семьи инфицированного.\r\n\r\n2. Большинство из 2 055 заразившихся работников больниц были инфицированы либо дома, либо на ранней стадии вспышки в Ухане, когда ещё не были приняты все меры предосторожности.\r\n\r\n3. Продолжительность болезни обычно составляет две недели. В тяжёлых случаях — от 3 до 6 недель.\r\n\r\n4. На сегодняшний день в провинции Хубэй, столицей которой является город Ухань, заражено более 65 тысяч человек. Из других провинций туда отправили около 40 тысяч сотрудников медучреждений.\r\n\r\n5. Инфицированных обслуживают 45 больниц, 6 из которых предназначены для пациентов в критическом состоянии, а 39 — для тяжелобольных и людей старше 65 лет. За короткое время были построены две новые больницы на 2 600 мест. Поскольку у 80% инфицированных наблюдаются лишь легкие признаки заболевания, для них были созданы 10 временных больниц в гимназиях и выставочных залах.\r\n\r\n6. В настоящее время Китай еженедельно может производить 1,6 миллиона наборов для диагностики коронавируса. Тест даёт результат в тот же день. По всей стране каждый, кто идёт к врачу с температурой, проверяется на наличие вируса. В провинции Гуандун, которая далеко от Уханя, было протестировано 320 000 человек, 0,14% из них оказались заражены.\r\n\r\n7. Случаи, когда у инфицированных не проявлялись симптомы заболевания, очень редки. Чаще всего вирус даёт о себе знать в течение нескольких дней после заражения.\r\n\r\n8. Наиболее распространёнными симптомами являются: жар (88%) и сухой кашель (68%), недомогание (38%), отхаркивание слизи при кашле (33%), одышка (18%), боль в горле (14%), головные боли (14%), мышечные боли (14%), озноб (11%). Реже наблюдается тошнота и рвота (5%), заложенность носа (5%) и диарея (4%). Насморк не является симптомом COVID-19");
INSERT INTO forum_t VALUES("49","6","5","Факты о человеке","325","1590973920","1590972796","0","0","Скорость чихания составляет 160 км/ч.\r\n2. Скорость кашля может достигать даже 900 км/ч.\r\n3. Женщины моргают вдвое чаще мужчин.\r\n4. Полный мочевой пузырь достигает размера мячика для софтбола.\r\n5. Примерно на 75% продукты человеческой жизнедеятельности состоят из воды.\r\n6. На ногах находится примерно 500 000 потовых желез, они могут производить до литра пота в день!\r\n\r\n7. За всю жизнь человек производит столько слюны, что ею можно заполнить пару бассейнов.\r\n8. В среднем человек выпускает газы 14 раз в день.\r\n9. Ушная сера необходима для здоровья ушей.\r\n\r\nВолосы и ногти\r\nПо сути, это не живые органы, однако вспомните, как женщины трясутся над своими ногтями и волосами, сколько денег они тратят на уход за ними! При случае можете рассказать своей даме пару таких фактов, наверняка она оценит.\r\n\r\n\r\n10. Волосы на лице растут быстрее, чем где бы то ни было еще.\r\n11. Ежедневно человек теряет в среднем от 60 до 100 волос.\r\n12. Диаметр женских волос вдвое меньше, чем мужских.\r\n13. Человеческий волос может выдержать вес в 100 г.\r\n14. Ноготь на среднем пальце растет быстрее остальных.\r\n15. На квадратном сантиметре тела человека волос столько же, сколько на квадратном сантиметре тела шимпанзе.\r\n16. У блондинов больше волос.\r\n17. Ногти на руках растут примерно в 4 раза быстрее, чем на ногах.\r\n18. Средняя продолжительность жизни человеческого волоса — 3—7 лет.\r\n19. Нужно облысеть по меньшей мере наполовину, чтобы это стало заметным.\r\n20. Человеческие волосы практически не поддаются разрушению.");
INSERT INTO forum_t VALUES("50","6","25","Кому опасно носить медицинские м","324","1591001843","1591001843","0","0","Опасно постоянно носить медицинскую маску тем людям, которые страдают хронической обструктивной болезнью легких (ХОБЛ). У таких людей могут возникнуть проблемы с дыханием. Об этом пишет ТАСС со ссылкой на главу лор-клиники, кандидата медицинских наук, врача высшей категории Владимира Зайцева.\r\nМедик пояснил, что медицинские маски опасны для всех, кому и в обычном состоянии дышать тяжело. Особенно опасны многоразовые маски.\r\nНапомним, с 1 июня 2020 года будет усилен масочный режим – средства индивидуальной защиты необходимо будет носить даже на улице.");
INSERT INTO forum_t VALUES("51","6","25","Фруктовые соки назвали опасными","324","1591001920","1591001920","0","0","Они могут вызвать преждевременную смерть. У людей среднего возраста, пьющих много газировки, подслащенных фруктовых напитков и соков, повышен риск преждевременной смерти, прежде всего от сердечно-сосудистых болезней. Результаты исследования ученых из Университета Эмори (США) представлены на очередных Научных сессиях Американской ассоциации по изучению болезней сердца");
INSERT INTO forum_t VALUES("52","6","25","Как вы спите","324","1591001975","1591001975","0","0","\r\n1. Одна из лучших поз для сна – на спине\r\nИменно в таком положении голове, шее и позвоночнику комфортнее всего, поскольку они остаются в нейтральном положении и не подвергаются чрезмерному давлению. Доктор Майкл Бреус, специалист в области медицины сна, рекомендует принимать именно эту позу во время ночного отдыха. Помимо нейтральности положения тела, такая поза позволяет избежать утренней помятости, которая наблюдается, если человек спит, упершись щекой в подушку. Однако храпящему человеку или пациентам, страдающим апноэ сна, такая поза не подходит.\r\n2. Поза во время сна, занимающая второе место, – на боку\r\nАпноэ сна, храп, беременность, боли в шее и спине – в таких случаях врачи рекомендуют приобщиться ко сну на боку. На каком?\r\nДело в том, что при лежании на правом боку может усиливаться изжога, а сон на левом боку может нагружать печень, легкие и желудок. При этом сон на левом боку облегчает кислотный рефлюкс, а беременным такую позу рекомендуют для оптимизации тока крови.\r\n3. На животе – пожалуй, худшая поза во время сна\r\nМногие люди выбирают именно сон на животе, однако проблема в том, что данная поза не поддерживает естественные изгибы позвоночника. Это может привести к чрезмерному напряжению позвоночных структур. Помимо этого, в суставах и мышцах в силу неестественности положения позвоночника может чувствоваться боль, онемение и покалывание. Циркуляция крови и нормальное дыхание во время сна на животе также нарушается. Особенно противопоказан сон в таком положении страдающим болями в шее или спине.\r\n4. Что специалисты говорят о позе зародыша?\r\nСон на боку с коленями у груди обладает успокаивающим эффектом, однако такая поза во время сна может привести (и часто приводит) к появлению боли в шее и спине, поскольку она нагружает спину и суставы. Эксперты считают, что плечи и шея во время сна должны находиться на одном уровне – так можно предотвратить появление боли в суставах и мышцах.");
INSERT INTO forum_t VALUES("53","6","25","Чем полезны яблоки","324","1591002279","1591002279","0","0","● В яблоке содержится большое количество витаминов, прежде всего, витамин A, витамин C, витамин B1.\r\n● Яблоко содержит большое количество микроэлементов, в том числе, железо, кальций, калий, магний и многие другие.\r\n● Яблоки богаты органическими кислотами.\r\n● Яблоки получили широкую известность как средство понижающее уровень холестерина в крови.\r\n● Яблоки являются отличным диетическим продуктом, благодаря наличию большого количества пищевых волокон, полезным свойствам и высокой питательной ценности.\r\n● Регулярное употребление яблок снижает риск возникновения и развития онкологических заболеваний.\r\n● Яблоки прекрасно помогают при различных расстройствах желудочно-кишечного тракта.\r\n● Яблоко отличное средство для повышения защитных сил организма.\r\n● Употребление яблок оберегает нашу сердечнососудистую систему от инфарктов и инсультов.\r\n\r\nПолезные свойства яблок изучены досконально, и можно утверждать, что яблоки - это отличный фрукт, который поможет вам поправить или сохранить здоровье!");
INSERT INTO forum_t VALUES("54","6","25","Лечимся сиренью","324","1591002410","1591002410","0","0","Из майской сирени вы легко можете изготовить впрок ценное лечебное средство, проверенное веками.\r\nСоберите 1 стакан цветков сирени, залейте 0,5 л водки, плотно закройте бутылку емкостью 0,8 л и настаивайте в темном месте 10-12 дней, периодически встряхивая содержимое. Потом процедите. У вас получится настойки, которая пригодится в острых ситуациях.\r\nНастигнет простуда или обострение бронхита - пейте ее по 30 капель (не более!) на 1/4 стакана теплой воды трижды в день за полчаса до еды. Помните: насколько сирень красива, настолько и ядовита при передозировке!\r\nПоявится боль в суставах из-за отложения солей или дадут знать о себе пяточные шпоры - доставайте эту настойку и используйте ее для компрессов на проблемные места.\r\nЕсли кто-то из ваших родственников или друзей, не дай Бог, окажется надолго прикован к постели , раз в день протирайте сиреневой настойкой тело лежачего больного - у него не будет пролежней!\r\nА многие люди, страдающие бронхиальной астмой , даже не подозревают, как облегчают дыхание молодые листья сирени, появившиеся во время ее цветения. Достаточно заварить 2-3 листика кипятком и пить как теплый чай.\r\nБудьте здоровы!!!");
INSERT INTO forum_t VALUES("55","6","25","Почему смех продлевает здоровье","324","1591002534","1591002534","0","0","То, что смех продлевает жизнь подтверждают исследования, проведенные учеными разных стран мира. Смех обладает оздоровительным и общеукрепляющим действием, идаже влияет на происходящие в организме биологические про цессы, стимулируя выделение эндорфинов, дофамина и серотонина. Помимо того, что смех заряжает человека энергиейи повышает настроение, по словам исследователей, он еще может стать персональным тренером для всего организма. Поэтому (если говорить максимально приближенно к науке, но условно) на вопрос, насколько смех продлевает жизнь, можно ответить: минута смеха продлевает жизнь на 5 минут.\r\n«Хохочущее тело» приводит в действие около 80 мышц, тренируя при этом пресс, плечи, груди и диафрагму, проходят головная боль и напряжение, повышается иммунитет, улучшается качество дыхания и кровоснабжения тканей и органов, а также снижается уровень холестерина. И это еще не все. Доктора утверждают, что смех чудодейственен: ему подвластны не только психологические проблемы, но и физические страдания. Известны даже случаи излечения от онкологических заболеваний.");
INSERT INTO forum_t VALUES("56","6","25","Чем полезны бананы","324","1591002631","1591002631","0","0","1. Бананы помогают бороться с депрессией. В них много триптофана - вещества, из которого вырабатывается серотонин - гормон счастья. Поэтому съев банан легко улучшить настроение.\r\n2. Бананы - единственный фрукт, который даже у младенцев не дает аллергической реакции.\r\n3. Укрепление костей. Бананы задерживают кальций в организме, он не выводится вместе с мочой, а остается в организме и используется для укрепления костей. Это особенно важно для любителей кофе, который наоборот вымывает кальций из организма.\r\n4. Улучшение микрофлоры кишечника. Благодаря ферментам, которые входят в состав бананов вещества, которые попадают в организм с основной пищей, усваиваются организмом быстрее.\r\n5. Запоры. Бананы очень полезны для тех, кто страдает от запоров. Регулярное потребление бананов избавит от этой проблемы.\r\n6. Бананы помогают избавиться от такой проблемы как изжога.\r\n7. Язва желудка. Бананы при употреблении обволакивают стенки желудка и тем самым защищают его от агрессивных веществ и кислот в пище, это способствует заживлению и рубцеванию язв в желудке.\r\n8. При диарее. Тем, кто страдает диареей, советуют употреблять бананы. Это очень хороший восстанавливающий продукт.\r\n9. Большое содержание калия в мякоти банана спасает от судорог икроножных мышц тех, кто много тренируется.\r\n10. Отеки. Употребление бананов значительно уменьшает отеки у тех, кто страдает от этого.\r\n11. Источник энергии. Если съесть бананы перед тренировкой, то можно будет заниматься более эффективно - уровень сахара будет подниматься не очень быстро и энергии хватит до конца тренировки.\r\n12. Улучшение пищеварения. Пектины и хелаты, которые входят в состав бананов, хорошо выводят токсины и другие вредные вещества, тем самым улучшая пищеварение.\r\n13. Для женщин. Серотонин и другие полезные вещества, которые есть в бананах, отменно снимают симптомы ПМС. Если съесть банан во время месячных, то можно избавиться от плохого настроения и неприятных симптомов");
INSERT INTO forum_t VALUES("57","8","26","Конкурс","324","1591017640","1591017640","0","0",".свойкон11.\r\nКонкурс- Самый активный пользователь нашего сайта!\r\nС сегодняшнего дня будет проходить конкурс на самого активного пользователя нашего сайта. Пользователь должен принимать участие в  общении в беседке, в форуме и так далее.\r\nВ конце недели подведём итоги и выберем самого активного пользователя , вознаграждение будет большим, удачи всем!\r\nС уважением администрация сайта!\r\n.буактивен.");
INSERT INTO forum_t VALUES("58","6","8","Акула монстр, живёт до сих пор","324","1591174928","1591174928","0","0","Американские исследователи заявили, что 18-метровая акула мегалодон вымерла не из климатических изменений, как считалось ранее, а из-за другого морского хищника, который до сих пор живет на планете. Об этом пишет Громадське.\r\nГруппа ученых из США и Великобритании считает, что существо, которое стало причиной исчезновения акулы-монстра мегалодона, может все еще находиться в Мировом океане. Они утверждают, что 18-метровый мегалодон исчез около 2600000 лет назад из-за климатических изменений. Впрочем исследователи нашли остатки животного на берегу океана, и теперь считают, что предварительные выводы были неверны.\r\nПалеонтолог Роберт Боссенекер рассказал, что мегалодон мог вымереть примерно на миллион лет раньше начала климатических изменений. Причиной смерти акулы могла стать белая акула-людоед кархародон, которая победила в борьбе за территории. Впрочем исследователи считают, что теорию нужно проверить и на других видах акул. Поскольку они думают, что один вид акул не мог привести к исчезновению всех мегалодонов.");
INSERT INTO forum_t VALUES("59","6","8","Лучьшее моющее средство","324","1591175025","1591175025","0","0","Росконтроль назвал марку лучшего средства для мытья посуды\r\nFairy, «Минута плюс» и AOS получили замечания.\r\nРосконтроль провёл исследование средств для мытья посуды. Специалисты изучали Pril, AOS, Fairy, Sorti, Frosch, «Минуту плюс» и «Просто».\r\n«Неудивительно, что потребителей так волнует токсичность моющих средств. Ведь пользуясь посудой, обработанной моющими средствами, мы каждый раз неизбежно проглатываем их остаточные количества», — отметил Андрей Мосов, руководитель аналитического бюро экспертного центра Союза потребителей.\r\nКомпоненты бытовой химии могут причинить вред здоровью, если не будут удалены с тарелок и чашек полностью, отмечают эксперты. Они помыли тарелки и определили, какое количество вещества остается на посуде.\r\nПо результатам исследования смываемость у всех образцов соответствует требованиям. Самые лучшие результаты по этому показателю у Pril, AOS, Frosch, «Просто» (95, 94 и 92 процента удалённых с поверхности загрязнений соответственно). Худшая эффективность у «Минуты плюс» — 83%.\r\nДороже всего из образцов Pril — 159,9 рубля. «Просто» стоит 13,9 рубля.\r\nFairy, «Минута плюс» и AOS получили замечания, так как они не соответствуют нормам токсичности, несмотря на то, что последнее средство вошло в число лучших по смываемости.");
INSERT INTO forum_t VALUES("60","6","5","Редкие факты о золоте","324","1591175194","1591175114","0","0","1. Из одной тонны старых мобильных телефонов можно добыть больше золота, чем из тонны золотой руды.\r\n2. Если бы мы добыли все золото океана, то на каждого человека в мире пришлось бы по 4 кг золота.\r\n3. Венгерский химик Дьёрдь де Хевеши растворил золотые нобелевские медали немецких физиков Макса фон Лауэ и Джеймса Франка , чтобы спрятать их от конфискации нацистами. После войны медали заново отлили.\r\n4. Моряки часто носили золотые серьги, так как в случае если они тонули и их выбрасывало на берег, серьги служили своего рода оплатой должного захоронения по-христиански.\r\n5. Олимпийская золотая медаль всего на 1 процент состоит из золота.\r\n6. В Дубае есть банкоматы, выдающие золотые слитки.\r\n7. Большая часть золота в земной коре попала туда благодаря падениям астероидов.\r\n8. Большая часть золота на Земле находится в ядре, так как оно опустилось к центру, когда формировалась наша планета.\r\n9. В 1859 году золотодобытчики в Скалистых горах проснулись в 1 час ночи, чтобы позавтракать. Полярное сияние было настолько ярким, что они подумали, что наступило утро.\r\n10. Дегустаторы мороженого используют золотые ложки, чтобы избежать послевкусия, остающегося от обычных ложек.\r\n11. За голову римского политика Гая Гракха была назначена награда, равная золоту весом с его голову. Хотя голова была доставлена, награда не была выплачена, так как захватчик наполнил голову свинцом.\r\n12. Алюминий считался самым ценным металлом на Земле. Богатые люди ели из алюминиевой посуды, в то время как бедные пользовались золотой.\r\n13. Манса Муса – правитель империи Мали однажды потратил так много золота в Египте, что обесценил его и практически разрушил экономику.\r\n14. Китайских заключенных заставляют добывать золото в World of Warcraft. Согласно некоторым источникам, по всей стране насчитывается около 100 000 виртуальных золотодобытчиков.\r\n15. Компания LEGO когда-то давала своим сотрудникам кирпич из золота весом 25,65 грамм за 25 лет службы у них.\r\n");
INSERT INTO forum_t VALUES("61","6","5","Факты о кока-коле","324","1591175273","1591175273","0","0","1. Активный ингредиент Колы -\r\nфосфорная кислота. Ее рН равен 2.8. За 4\r\nдня она может растворить ваши ногти.\r\n2. Для перевозки концентрата Колы\r\nгрузовик должен быть оборудован\r\nспециальными поддонами,\r\nпредназначенными для\r\nвысококоррозионных материалов.\r\n3. Дистрибьюторы Колы уже 20 лет\r\nиспользуют ее для очистки моторов\r\nсвоих грузовиков.\r\n4. Во многих штатах (в США) дорожная\r\nполиция всегда имеет в патрульной\r\nмашине 2 галлона Колы, чтобы смывать\r\nкровь с шоссе после аварии.\r\n5. Положите в тарелку с Колой стейк - и\r\nчерез 2 дня вы его там не найдете.\r\n6. Чтобы почистить туалет, вылейте\r\nбанку Колы в раковину и... не смывайте в\r\nтечение часа.\r\n7. Лимонная кислота в Коле удалит пятна\r\nс фаянса.\r\n8. Чтобы удалить ржавые пятна с\r\nхромированного бампера машины,\r\nпотрите бампер смятым листом\r\nалюминиевой фольги, смоченным в Коле.\r\n9. Чтобы удалить коррозию с батарей в\r\nавтомобиле, полейте батареи банкой\r\nКолы, и коррозия исчезнет.\r\n10. Чтобы раскрутить заржавевший болт,\r\nсмочите тряпку Колой и обмотайте ею\r\nболт на несколько минут.\r\n11. Чтобы очистить одежду от\r\nзагрязнения, вылейте банку Колы на\r\nгруду грязной одежды, добавьте\r\nстиральный порошок и постирайте в\r\nмашине как обычно. Кола поможет\r\nизбавиться от пятен. Она также очистит\r\nстекла в автомобиле от дорожной пыли.");
INSERT INTO forum_t VALUES("62","6","5","Стоматология интересные факты","324","1591175445","1591175445","0","0","Стоматология. Интересные факты.\r\nЧтобы повысить заинтересованность в сохранении здоровых зубов и десен среди двенадцатимиллионного населения, в Китае был установлен национальный праздник, название которого можно перевести как \"День любви к своим зубам\" и который проходит каждый год 20-го сентября. \r\nАбсолютная сила жевательных мышц на одной стороне равна 195 кг. Конечно, такое давление не сможет выдерживать пародонт, и поэтому обычное жевательное давление равняется 9-15 кг (ну максимум 100 кг, если вы грызёте орехи). \r\nЕсли вы правша, то большую часть пищи вы пережевываете на правой стороне челюсти, и наоборот, если вы левша, то на левой. \r\nЕсли у одного из однояйцовых близнецов не хватает того или иного зуба, как правило, такой же зуб отсутствует и у другого близнеца.\r\nДо того как в XIX веке была изобретена технология изготовления искусственных керамических зубов, в качестве материала для зубных протезов использовались зубы солдат, павших на поле сражения. Так, после гражданской войны в США английские стоматологи получали целые бочки таких грузов. \r\nТакая чудная вещь как электрический стул тоже была изобретена стоматологом. \r\nАмериканскими стоматологами используется около 13 тонн золота в год для изготовления коронок, мостов, вкладок и зубных протезов. \r\nСамым дорогим зубом стал зуб Исаака Ньютона, проданный в 1816 году за 730 фунтов стерлингов (примерно 3,241$ сегодня), после чего он был вправлен в перстень купившим его аристократом.\r\nДревние японские стоматологи удаляли зубы голыми руками. \r\nНесколько советов средневековых стоматологов: - Чтобы зубы не разрушались, используйте в качестве полоскания \"отвар\" из собачьих зубов в вине. - Для укрепления расшатанных зубов привяжите к челюсти лягушку. - Чтобы облегчить боль в деснах, потрите их зубом человека, умершего насильственной смертью. (О процессе добывания лекарства лучше не задумываться). \r\nНе так давно зубные протезы были популярным свадебным подарком на Британских островах.");
INSERT INTO forum_t VALUES("63","6","5","Факты о цветной реке","324","1591175527","1591175527","0","0","Вы когда-нибудь видели цветную реку? Тогда смотрите - эта река называется Cano Cristales и находится в горной цепи Колумбии. Несомненно она является самой необычной рекой в мире.\r\nВ сезон засухи река высыхает и увидеть ничего невозможно, но когда начинаются дожди, она вспыхивает всеми цветами радуги. В течение сезона дождей река показывает захватывающее множество цветов. Цвета располагаются от темно-красного, желтого и розового к синему и зеленому цвету. Эти цвета могут быть приписаны мхам и морским водорослям, которые растут на русле реки в течение сухого сезона.\r\nВ течение сезона дождей они набирают достаточно влаги и окрашивают воду в незабываемые оттенки.\r\nЭто привлекает много туристов, которые приезжают, чтобы увидеть это необычное зрелище.");
INSERT INTO forum_t VALUES("64","6","5","Самое мертвое море","324","1591175580","1591175580","0","0","Cамым мертвым морем на\r\nпланете Земля считается\r\nзлополучное озеро Смерти -\r\nбольшой водоем, расположенный\r\nна Сицилии. Его берега и воды\r\nлишены всякой растительности и\r\nживности, даже птицы не\r\nпролетают над свинцово-серой\r\nводой. Купаться в нем смертельно\r\nопасно. Любое живое существо,\r\nпопавшее в воду этого жуткого\r\nозера, мгновенно погибает.\r\nЧеловек, на секунду опустивший в\r\nводу кисть руки, с ужасом\r\nнаблюдает, как она краснеет,\r\nпокрывается волдырями, кожа\r\nслазит, обнажая окровавленные\r\nкости, лопающиеся вены и сосуды.\r\nА дело в том, что в воде в\r\nогромной концентрации\r\nсодержится... серная кислота. Очень\r\nопасные исследования,\r\nпроведенные учеными в 1999 году,\r\nпозволили сделать ошеломляющий\r\nвывод: концентрированная серная\r\nкислота выбрасывается в озеро\r\nдвумя источниками, находящимися\r\nна его дне. Неудивительно, что свои\r\nжертвы сицилийская мафия\r\nиспокон веков прятала в этих\r\nсмертоносных водах: час - и от\r\nчеловека даже зубов не остается.");
INSERT INTO forum_t VALUES("65","6","5","Опилки в соке","324","1591175635","1591175635","0","0","Аудитор крупного банка рассказал, что в ходе проверки одного крупного западноукраинского предприятия по производству соков, чья продукция хорошо известна на территории Украины и в ближнем зарубежье, обнаружил, что фирма регулярно тратит заметные суммы на покупку опилок. Причем опилки, которое покупало предприятие были дорогими и импортными. Мимо такого факта он не мог пройти и запросил уточнение назначения этих опилок.\r\nОказывается мелкодисперсные обессмоленные опилки используются для создания «мякоти» в соках.\r\nАудитор немного замялся и сказал, что как ему объяснили, в этом нет ничего необычного – и то – целлюлоза и то – целлюлоза. Осталось только добавить сахарный сироп, краситель, ароматизатор, модификаторы вкуса и для проформы – некоторое количество концентрата яблочного сока. Просто добавим опилки, они разбухнут – и вот будет прекрасный сок с мякотью.");
INSERT INTO forum_t VALUES("66","6","6","Душа светлая и темная","324","1591253587","1591253587","0","0","- Почему об одних людях говорят, что у них светлая душа, а о других, что темная, \r\n- спросила дочь, \r\n- ведь в душу человека заглянуть нельзя. Люди могут притворяться. \r\nМать ответила: \r\n- Когда встречаешь человека со светлой душой, то тебе становится светло. Если ты чувствуешь какую-то душевную боль, то рядом с таким человеком она стихает. Такой человек будет укреплять веру в Бога, веру в себя, ты чувствуешь тихую радость и надежду на счастье, хочется всех любить и творить добро. \r\n- А если вроде бы человек говорит все правильно, но мне от его правильности становится плохо? Опускаются руки и жизнь кажется какой-то беспросветной? \r\nЗначит ли это, что человек лицемерен и зол? \r\n- Нет, доченька. Это значит, что душе этого человека не хватает света. Что этот человек несчастен, и общаясь с тобой неосознанно делится с тобой своей бедой. \r\n- И что мне делать тогда? \r\n- Светить самой для этого человека. И чем больше усилий ты будешь прикладывать, чтобы светить, тем больше света тебе дастся! Запомни, свет – это не только разговоры о Вере и Боге, свет \r\n– это приветливая Улыбка, Доброе слово, Поддержка и Помощь.");
INSERT INTO forum_t VALUES("67","6","6","Нужно поверить","324","1591253717","1591253717","0","0","Почему не у всех получается воплотить свои желания в реальность?\r\nПочему сколько бы человек не говорил себе,что он умен,красив,богат...а воз и ныне там.Почему?\r\nДа потому что говоря все это,он просто не верит в глубине души в свои же слова.Потому что,когда он уговаривает себя-млин,да я красив и строен,а внутренний голос ржет в ответ-ага  ты когда последний раз в зеркало смотрел,чумаход?То кроме разочарования ничего этот человек не добьется.\r\nНадо верить в себя,визуализировать свои желания,заткнуть нафиг голос логики,если хотите,дать установку себе...я верю в себя...я все смогу...да хрен я успокоюсь.\r\nВот тогда желаемое станет действительным");
INSERT INTO forum_t VALUES("68","6","25","Кому опасно носить маски","324","1591253905","1591253905","0","0","Опасно постоянно носить медицинскую маску тем людям, которые страдают хронической обструктивной болезнью легких (ХОБЛ). У таких людей могут возникнуть проблемы с дыханием. Об этом пишет ТАСС со ссылкой на главу лор-клиники, кандидата медицинских наук, врача высшей категории Владимира Зайцева.\r\nМедик пояснил, что медицинские маски опасны для всех, кому и в обычном состоянии дышать тяжело. Особенно опасны многоразовые маски.\r\nНапомним, с 1 июня 2020 года будет усилен масочный режим – средства индивидуальной защиты необходимо будет носить даже на улице.");
INSERT INTO forum_t VALUES("69","6","8","Самые опасные смартфоны","324","1591253995","1591253995","0","0","В Федеральной комиссии по связи США проверили уровень излучения и составили рейтинг самых опасных смартфонов. Специалисты замеряли удельный коэффициент поглощения электромагнитного излучения тканями тела человека\r\nУровень САР зависит от многих факторов, к примеру, от качества связи: чем она чище, тем сильнее излучение. Показатель возрастает при переключении телефона между вышками связи, передает Фром юа ком.\r\nКак именно влияет электромагнитное излучение на здоровье человека, пока не до конца понятно. Среди самых распространенных версий последствий такого воздействия – отмирание клеток мозга, раковые опухоли и бесплодие у мужчин, которые носят смартфон в кармане брюк.\r\nСамую большую опасность САР-излучение представляет для головы и мозга. Под воздействием волн температура воды, которая входит в состав клеток организма, повышается и провоцирует необратимые процессы.\r\nПо мнению авторов эксперимента, самым опасным оказался смартфон модели Google Pixel 3 Икс Л с уровнем излучения в 1,35 Вт/кг. Второе место поделили смартфон Google Pixel 3 и китайский ОнПлюс 6T.\r\nПо влиянию на все тело пользователя лидером оказался Google Pixel 3, который фонит на 1,34 Вт/кг. Ему уступают LG V40 и Google Pixel 3 Икс Л, показатели которых не превышают 1,28 Вт/кг.\r\nТакже в американский «черный список» попали все модели Apple iPhone Икс С, Самсунг Галакси Note 9/Эс9, Huawei Mate 20 Pro.\r\nСамым безопасным по влиянию на голову человека признали LG G7 с показателем в 0,22 Вт/кг, на все тело – китайский пиво НЕКСТ (0,29 Вт/кг).\r\nДовольно низкие показатели излучения также у Галакси Нот 9 и Самсунг Галакси Эс 9.");
INSERT INTO forum_t VALUES("70","6","8","Земля утопает в мусоре","324","1591254067","1591254067","0","0","Земля утопает в мусоре: эксперты подсчитали, сколько тонн отходов будет на планете к 2050 году\r\nСегодня, 03:01 Просмотров: ...\r\nК 2050 году количество мусора на Земле вырастет на 70% и составит 3,4 миллиарда тонн\r\nТемпы генерации мусора на планете растут. К 2050 году количество мусора вырастет на 70% и составит 3,4 млрд тонн. Таковы результаты исследования, проведенного Всемирным банком.\r\nВ 2016 году города мира произвели 2,01 миллиарда тонн твердого мусора. То есть ежедневно каждый человек на планете оставлял о себе память в виде 0,74 килограмма мусора. К 2050 году количество мусора на Земле вырастет на 70% и составит 3,4 миллиарда тонн.\r\nПо данным авторов исследования, в менее развитых странах, особенно в бедных городских районах таких стран, люди испытывают наиболее серьезное негативное воздействие от мусора, который там не собирается и не убирается должным образом.");
INSERT INTO forum_t VALUES("71","6","10","Священная гора Кайлас","324","1591254179","1591254179","0","0","Священная гора, которая полна загадок и мистицизма (Фото)\r\nГора Кайлас расположена в высокогорной долине Тибета на юго-западе Китая. Эта священная земля полна загадок и мистицизма. Именно сюда приезжают паломники со всего света для совершения коры – ритуального обхода вокруг Кайласа. До сих пор ученые спорят об истории возникновения этой удивительной горы. Кайлас искусственно созданная пирамида или гора естественного происхождения? На сегодня нет достоверных сведений об этом, как и том, сколько лет назад зародился Кайлас и почему он имеет форму пирамиды, грани которой точно указывают на части света. Удивительно и необъяснимо еще и то, что высота горы составляет 6666 м, расстояние от Кайласа до монумента Стоунхендж – 6666 км, и столько же до Северного полюса, а до Южного – 13 332 км (6666*2).");
INSERT INTO forum_t VALUES("72","6","8","Мозги","324","1591254311","1591254311","0","0","Мозг мужчины не может решать много задач единовременно, заявили ученые из Университета исследований психологии в Ванкувере.\r\nЖенский мозг, напротив, ориентирован на решение сразу нескольких задач, причем в одно время. Такая теория касается в частности определения экономических терминов и использования их в жизни.\r\nПо наблюдениям ученых, сильный пол чаще не может решить простейшие математические задачи, в которых необходимо использовать комбинацию методов.\r\nДля подкрепления предположения специалисты провели ряд исследований с участием 400 человек. добровольцев разделили на две группы – мужскую и женскую. Всем испытуемым было предложено решить простейшую экономическую задачу, для которой необходимы комбинации методов.\r\nКак оказалось, мужской мозг автоматически раскладывает задачу на несколько действий, и выполняет их с определенной последовательностью. В то же время прекрасная половина человечества старается сразу найти ответ, задействуя при этом все ресурсы головного мозга.");
INSERT INTO forum_t VALUES("73","6","8","У карточных королей есть имена","324","1591254988","1591254988","0","0","Каждый король в карточной колоде имеет собственное имя. Король пик символизирует израильского царя Давида, король червей - Карла Великого, король бубен - Юлия Цезаря, а король треф - Александра Македонского.\r\nКарточные короли имели имена, начиная с 15 века. Эта традиция пошла из средневековой Франции. Она распространилась на Англию и прочие европейские государства и продержалась вплоть до 19 века.\r\nВ некоторых странах король червей носит прозвище «самоубийца» - из-за того, что он изображается с мечом, приставленным к голове. При этом он - единственный из всех королей, который не имеет усов.\r\nКороля бубен, как и его прообраза - Юлия Цезаря, в отличие от остальных королей, принято изображать в профиль.\r\nВ традиционной испанской карточной колоде король бубен имеет масть монет, король пик - масть мечей, король треф - масть жезлов, а король червей - масть кубков.");
INSERT INTO forum_t VALUES("74","6","8","Последний писк","324","1591255068","1591255068","0","0","В социальных сетях набирает популярность новый тренд – волосатые цветные подмышки.\r\nДевушки со всего мира не только отращивают волосы в подмышечных впадинах, но и окрашивают их в яркие броские цвета. Особенно стильные особы выбирают один тон для волос на голове и в подмышках.\r\nДля наведения красоты в подмышках появились даже\r\nспециальные мастера. Среди них американская парикмахер Рокси Хант из Сиэттла, которая с недавнего времени перестала красить волосы своим клиенткам и переключилась только на подмышечные впадины. По её словам, цветные подмышки выбирают женщины, которые не боятся ломать стандарты красоты.\r\nДерматологи не разделают эйфории от цветных подмышек. Однако они не берутся оценивать, насколько цветные подмышки могут навредить коже и здоровью девушки.\r\n- Это маразм, на мой взгляд, - считает врач дерматокосметолог, трихолог клиники Uniwell Наталья Шиханова. - Чтобы сказать, вредно это для кожи или нет, надо знать, какой краской пользуется девушка. Если это краска для волос, то здесь тоже всё сложно. Кожа в подмышках очень нежная, более чувствительная, чем на голове.\r\nПо словам врача, каждый случай индивидуален, главные факторы при оценке вреда от цветных подмышек - особенности кожи и состав краски.\r\nТем не менее, многие девушки уже опубликовали и продолжают выкладывать фото цветных подмышек в Сети.\r\nНе теряют времени и видеоблогеры, на YouTube уже появились уроки, как правильно сделать цветные подмышки");
INSERT INTO forum_t VALUES("75","6","8","Почему платина дороже золота","324","1591255126","1591255126","0","0","Этот драгоценный металл люди знают более 4 000 лет, но в те времена он не нашел своего применения из-за своей тугоплавкости. Название — platina — уменьшительное слово от испанского plata — серебро. В Европу в большом количестве платина попала в XVIII веке из испанских рудников в Южной Америке. Использовать это «серебришко» не могли, так как ни растворить, ни расплавить его не умели. Отделяли его от серебра и золота вручную, а добытую платину по приказу испанского короля высыпали в море. Долго платину считали порождением сатаны, ибо в мире не должно быть металла тяжелее золота.\r\nВ начале XIX века платиновые россыпи были найдены на Урале. Громадную роль в судьбе металла сыграло открытие русскими учеными Любарским и Соболевским порошковой металлургии. Ограниченным тиражом в первой половине XIX века монетный двор выпускал монеты из платины достоинством 3, 6 и 12 рублей, представляющие большую нумизматическую редкость.\r\nСейчас платина ценится именно благодаря тем качествам, которые были недостатками ранее: тугоплавкость (температура плавления 1773,5 градуса) и химическая стойкость. В основном ее используют для изготовления посуды для химических лабораторий и в качестве катализаторов, в том числе в двигателях автомобилей");
INSERT INTO forum_t VALUES("76","6","8","Змеиное вино","324","1591255181","1591255181","0","0","Такой необычный алкогольный\r\nнапиток, как вино из змей, привычное\r\nдело для вьетнамцев. Кстати, не\r\nтолько во Вьетнаме, но и в других\r\nстранах Дальнего Востока, принято\r\nсчитать, что змеиный яд обладает\r\nразличными лечебными качествами.\r\nЛюди верят в то, что змеиная\r\nнастойка способна на невероятное: по\r\nих мнению, такой аперитив повышает\r\nпотенцию и быстро останавливает\r\nвыпадение волос. Стоит отметить, что\r\nранее в вино добавляли не только\r\nзмей, но и ящериц, и скорпионов.\r\nЗмея издавна считалась символом\r\nдолголетия и мудрости. Вьетнамцы\r\nсвято верят, что вместе с таким\r\nвином человеку передаются эти\r\nкачества.\r\nЗмеиный напиток разделяется на два\r\nвида:\r\nСмешанный. Всевозможные соки из\r\nтела змеи перемешивают с вином.\r\nУпотреблять такой напиток\r\nнеобходимо маленькими порциями.\r\nГотовится данный аперитив\r\nследующим образом: на теле змеи\r\nделают надрез, выпуская всю кровь в\r\nсосуд. Затем смешивают ее со\r\nспиртом или же с рисовым вином.\r\nПеребродившие напитки. Для этого необходима ядовитая змея\r\nкрупного размера. Ее помещают в\r\nбольшой сосуд, наполненный\r\nрисовым вином. К этому «коктейлю»\r\nпринято еще добавлять, например,\r\nразличных насекомых, птиц,\r\nмаленьких змей или черепах. Затем\r\nсосуд с содержимым оставляют на\r\nодин месяц. Употреблять такое вино\r\nрекомендуют маленькими\r\nрюмочками.\r\nХотя и для изготовления такого\r\nнеобычного вина используют только\r\nядовитых змей, напиток безопасный.\r\nДело в том, что этиловый спирт\r\nразрушает все ядовитые вещества.\r\nКроме того, в такую настойку\r\nдобавляют различные травы. Этим\r\nизготовители не только украшают\r\nаперитив. Травы придают змеиному\r\nвину приятный запах и лечебный\r\nэффект.");
INSERT INTO forum_t VALUES("77","6","8","Самый понтовый телефон в мире","324","1591255318","1591255318","0","0","Что делать, если у вас есть несколько лишних миллионов долларов, а начинка платиновых коммуникаторов Vertu под управлением Android OS оставляет желать лучшего? Конечно, лучшим выходом из этой ситуации заказать дизайнерский вариант любимого смартфона с применением эксклюзивных материалов корпуса. Именно так и поступил неназываемый китайский бизнесмен, для которого в Великобритании сделали уникальный Apple iPhone 5.\r\nДевайс выполнен из 24-каратного золота, вместо кнопки Home используется самый настоящий чёрный бриллиант и ещё 600 обычных бриллиантов поменьше расположены по всему корпусу, 53 из которых составляют логотип Apple. Экран защищён сапфировым стеклом, которое гораздо твёрже любого Gorilla Glass - такой материал действительно просто невозможно поцарапать, даже специально. Вся работа над устройством заняла у дизайнера 9 недель.\r\nЗаказчик из Китая уже владел чёрным бриллиантом, так что ему не пришлось платить полную стоимость всех использованных материалов и iPhone 5 ему обошёлся довольно ДЁШЕВО - всего в 15 миллионов долларов. Так, что если у кого-то вдруг есть чёрный бриллиант, почему бы не заказать аналогичную переделку?");
INSERT INTO forum_t VALUES("78","6","5","Факты","324","1591272644","1591272644","0","0","1. Из 1 грамма золота можно вытянуть проволоку длиной 3,5 километра.\r\n2. Самая старая убийца в мире – 92-летняя китаянка Клара Тан.\r\n3. Мама Гитлера хотела сделать аборт, но доктор уговорил её этого не делать.\r\n4. Если погаснет Солнце, Земля погибнет всего через.. 8 минут 20 секунд.\r\n5. В 97% банкнот США имеются следы кокаина.\r\n6. 95% людей сначала надевают левый носок, потом правый.\r\n7. Леонардо да Винчи рисовал губы Моны Лизы 12 лет\r\n8. Уинстон Черчилль родился на дискотеке в женском туалете\r\n9. В одном году 31 557 600 секунд.\r\n10. 1111111 х 1111111 = 1234567654321\r\n11. Анатидаефобия — это навязчивый страх, что где-то в мире есть утка, следящая за вами\r\n12. Если кричать на стакан воды в течении 80 лет, то можно его вскипятить.\r\n13. Каждый палец человека за время жизни сгибается примерно 25 миллионов раз.\r\n14. Самая дорогая игрушка в мире — это Hello Kitty стоимостью $167 000\r\n15. Самая большая бутылка водки в мире - 200 литров.\r\n16. Один миллиард секунд - это примерно 37 лет.\r\n17. В мире потребляется порядка 4,5 миллиардов литров бензина в день.\r\n18. Если у вас одна ноздря закрыта в течение 72 часов, вы будете медленно терять способность видеть цвета.\r\n19. Чаще всего жены миллионеров – учителя.\r\n20. У парков аттракционов после инцидентов со смертельным исходом увеличивается посещаемость\r\n21. За всю свою жизнь человек вырабатывает столько слюны, что ее хватило бы на 2 больших бассейна.\r\n22. На острове Окинава проживает около 500 людей в возрасте 100 лет и старше.\r\n23. Научное название процесса поцелуя – филематология.\r\n24. Самый тяжёлый день недели — это вторник.\r\n25. Общение в интернете способствует «быстрому сексу»\r\n26. Название острова Манхэттен переводится как «место пьянства».\r\n27. Стоимость Земли — пять квадриллионов долларов.\r\n28. Люди тратят две недели жизни в ожидании зеленого сигнала светофора.");
INSERT INTO forum_t VALUES("79","6","8","Яйца","324","1591272723","1591272723","0","0","В мире существует столько необычной еды, которую даже не хочется пробовать...\r\nНапример, эти яйца под названием Тунцзыдань, сваренные в моче мальчиков.\r\nЭто блюдо очень популярно в китайской провинции Чжэцзян.\r\nКаждую весну производители подобных яиц ставят в местных школах специальные ведра.\r\nВсе мальчики младше 10 лет должны ходить в туалет по-маленькому именно в них.\r\nЗатем эти ведра забирают и варят в них яйца.\r\n\r\nГлавное не забыть слегка разбить яйца, чтобы в них впитался \"рассол\".\r\nВ воздухе стоит запах мочи, который местные называют ароматом весны...\r\nЯйца уходят по 23 цента за штучку, как горячие пирожки.\r\nМестные жители сметают с прилавков все яйца, которые есть в наличии.");
INSERT INTO forum_t VALUES("80","6","8","Шрек реальный","324","1591272779","1591272779","0","0","Вы думали что Шрек – это просто мультяшный герой, которого нарисовали с помощью компьютера? Да уж нет! Он настоящий! Его имя — Морис Тилле!\r\nМорис Тилле (1903-1955 г.г.) — родился в России, но так складывались обстоятельства, что его семья вынуждена была уехать во Францию и там они остались жить. Он был очень интеллигентным человеком, знал более 14 иностранных языков, умел писать красивые и трогательные стихи.\r\nМечтой Мориса стало его непреодолимое желание стать актёром. И все было бы хорошо, если бы этому молодому и очень образованному человеку врачи не вынесли неутешный вердикт…\r\n«Акромегалия» – таков был приговор людей в белых халатах. Этим заболеванием страдают не многие жители планеты. «Акромегалия» — это когда рост частей тела и костей является не совсем пропорциональным, а так же, нарушения функции гипофиза.");
INSERT INTO forum_t VALUES("81","6","8","Самый дорогой сыр","324","1591272904","1591272904","0","0","Вы не поверите, но самым дорогой сыр в мире делают не из козлиного или коровьего молока, а из ослиного. Интересный факт, что самый дорогой сыр в мире делают из ослов, не правда ли так и хочется добавить и для ослов. Но не думайте сыр все же делают не из ослов, а из молока ослиц. А делают такой специфический сыр на одной из ферм в Сербии. Pule Cheese делают из молока Балканских ослиц по цене $ 2000 за килограмм! Этот рассыпчатый белый сыр, пользуется огромной популярностью из-за его интенсивного аромата и природной солености.\r\nВо всем мире этот сыр делается только из одного стада балканских ослов, которые живут на ферме в специальном заказнике в Сербии. И еще одна причина, почему этот сыр настолько дорогой, что все же ослицы не дают так много молока, как козы или коровы. К тому же все они доятся вручную, три раза в день. Судя по всему, 15 ослов дают около 4 литров молока в день. А необходимо 24 литра молока, чтобы сделать один килограмм этого сыра. Вот и считайте сколько нужно подоить ослиц чтобы сделать всего килограмм этого дорогого сыра. Ослов в этом Сербском заповеднике не так много, поэтому всего производится около 100 кг этого сыра в год. Поэтому он такой дорогой и его достаточно трудно купить.");
INSERT INTO forum_t VALUES("82","6","7","Байкеры","324","1591273034","1591273034","0","0","Байкеры (англ. biker, от bike ← motorbike ← motorbicycle «мотоцикл») — любители и поклонники мотоциклов. В отличие от обычных мотоциклистов, у байкеров мотоцикл является частью образа жизни. Характерным также является объединение с единомышленниками на основе этого образа жизни. Байкерское движение зародилось в 1950-х годах в США, проникло в Европу и Россию (в СССР в 1980-х годах их называли «рокеры»), какое-то время входило в состав субкультуры, когда байкеры были разделены на несколько агрессивных и враждующих группировок. До недавнего времени понятие «байкер» распространялось исключительно на владельцев чопперов и непременно ассоциировалось с вынесенным далеко вперед передним колесом, обилием хрома, кожи, длинными волосами и бородой мотоциклиста. Однако, с конца 90-х годов на дорогах все чаще стали появляться мотоциклы с высокооборотистыми двигателями и улучшенной пластиковыми обтекателями аэродинамикой — спортбайки, или «спортачи». На протяжении долгого времени спортбайкеры не признавались «истинными» байкерами как члены байкерского сообщества, даже такой жест, как приветственное поднятие руки при встрече на дороге, на них не распространялся. За характерную посадку водителя спортбайк и его водитель удостоились звания «креветка». В ответ на это чопперисты были прозваны «чоперастами». Причина такой конфронтации крылась в облике мотоцикла и манере езды. Высокая скорость спортбайка и мотоциклист в полной экипировке, больше похожий на космонавта в скафандре, не вязались в понимании байкеров старой формации с обликом настоящего байкера.");
INSERT INTO forum_t VALUES("83","6","7","Хиппи","324","1591273099","1591273099","0","0","Хиппи (англ. hippy или hippie; от разг. hip или hep, — «понимающий, знающий» (hipster — старое название субкультуры поклонников бибопа) — философия и субкультура, изначально возникшая в 1960-х годах в США.\r\nРасцвет движения пришелся на конец 1960-х — начало 1970-х годов. Первоначально хиппи протестовали против пуританской морали некоторых протестантских церквей, а также пропагандировали стремление вернуться к природной чистоте через любовь и пацифизм. Один из самых известных лозунгов хиппи: «Make love, not war!», что означает: «Распространяйте любовь вместо войны!» или «Занимайтесь любовью, а не войной!».\r\nХиппи верит:\r\nчто человек должен быть свободным;\r\nчто достичь свободы можно, лишь изменив внутренний строй души;\r\nчто душевному освобождению способствуют наркотики;\r\nчто поступки внутренне раскованного человека определяются стремлением оберегать свою свободы как величайшую драгоценность;\r\nчто красота и свобода тождественны друг другу и что реализация того и другого — чисто духовная проблема;\r\nчто все, кто разделяют сказанное выше, образуют духовную общину;\r\nчто духовная община — идеальная форма общежития;\r\nчто все, думающие иначе, заблуждаются.");
INSERT INTO forum_t VALUES("84","6","7","Панк-Рок","324","1591273167","1591273167","0","0","Музыкальное направление панк-рок возникло в самом начале 1970-х. Родиной панка принято считать США. В Англии данный жанр набрал популярность немного позже. Слово Punk в английском языке изначально имело резко негативную окраску. На жаргоне так называли девиц легкого поведения. В Америке таким обозначением клеймили заключенных низшей касты преступного мира. Войдя в обиходный лексикон, термин получил значение «грязный», «гнилой», «мусорные отбросы».\r\nЭпоха «гаражного рока»\r\nВ самом конце 50-х возникло большое количество любительских музыкальных групп и коллективов. Это явление имело очень простую основу. Популярность великих Beatles и The Rolling Stones заставляла молодых исполнителей браться за музыкальные инструменты.\r\n«Гаражный рок» еще принято называть «прото-панком», ведь именно он стал основой для будущего массового движения. Название «гаражный» он получил по причине того, что начинающие коллективы репетировали в обычных гаражах на примитивной аппаратуре. Музыка отличалась композиционной простотой, грубостью, жесткостью и крайней небрежностью во время исполнения. Практически отсутствовало понятие о музыкальной теории. Главным было желание, а не умение играть. Исполнители творили для себя и узкого круга знакомых и друзей. Так начинали формироваться первые предпосылки для панк-тусовки.\r\nСамыми популярными в прото-панке можно считать коллективы The Sonics, Monks, The Who. Будущие мировые звезды, такие как Игги Поп и Патти Смит, начали оттачивать свое мастерство именно в этот ранний период.");
INSERT INTO forum_t VALUES("85","6","7","Эмо","324","1591273244","1591273244","0","0","Внезапно появившееся молодежное направление в музыке, стиле одежды, манере поведения Эмо. Что же может таить в себе это слово из трех букв. В этой статье мы попробуем разобраться и оценить все мнения и их причины, сложившиеся за это время. Эмо, как субкультура начинает развиваться в 90-ых годах и продолжает достигать популярности и по сей день.\r\nЭмоциональность. Эмоции. Эмоциональный. Все это –своего рода синонимы термина «эмо». \r\nПочему же молодежь сейчас так критична к людям, которые решили отнести себя к этой субкультуре? Потому что изначально сложившееся НЕПРАВИЛЬНОЕ мнение выражается в нелюбви к пессимизму, слезах и грусти – именно такими эмо-кидов видят окружающие. Но неужели для вас эмоции тоже могут значить лишь негатив, тянущийся за человеком, как тень? Конечно, нет. Ведь именно эмоции вносят в нашу жизнь разнообразие, доставляют эстетическое удовольствие. \r\nНевероятная картина, написанная искусным художником заставляет испытать эмоции? Безусловно. Первые шаги ребенка? Тоже. А чем отличаются подростки? Они хотят радоваться жизни, наслаждаться ею. Но зачастую, дети становятся замкнутыми и боятся показать то, что происходит у них внутри, а это может послужить фактам суицида. Эмо-киды же не скрывают своих впечатлений, они не боятся людей. Смех, слёзы – всё на лице, все открыто для других. Стремление поделиться своими чувствами с другими – это прекрасно. А все эти слухи про вскрывание вен и другие способы перебросить себя из этого мира в мир иной – это лишь сказки, придуманные людьми, как раз закованными в оковы собственных чувств.");
INSERT INTO forum_t VALUES("86","2","11","Игра цифры в рифму","324","1592423860","1591274242","0","0","Смысл игры: пишем цифру по очереди и придумываем к ней рифму! пример: 56...красивых девушек не счесть ; 71 - снова я один и так далее..\r\n");
INSERT INTO forum_t VALUES("87","2","11","Игра добаалялка","324","1595739098","1591274583","0","0","Правила:продолжаем слово, используя последние две буквы предыдущего слова как начальные следующего.\r\nПример: Астра - радость      \r\nначну:");
INSERT INTO forum_t VALUES("88","2","11","Игра нечётное число","324","1597674900","1591274737","0","0","Я решил создать форумную игру на основе игры \"досчитай до 1000\"...\r\nВ этой игре правила просты : люди по очереди говорят нечётные числа.\r\nПример :\r\nПервый человек : один (можно цифрами писать).\r\nВторой человек : три.\r\nТретий человек : пять.\r\nЧетвёртый человек : семь.\r\nИ так далее... Прошу в этой теме не нарушать правила форума.\r\nПриятной игры!!");
INSERT INTO forum_t VALUES("89","2","11","Игра Мешалка","324","1592423773","1591275221","0","0","То есть создаем бессмысленные сочетания,которым в жизни нет места.\r\nСледующий игрок берет существительное из предыдущего сообщения и превращает его в прилагательное,добавляя новое существительное,бессмысленное по смыслу.\r\n\r\nПример\r\n\r\n-ледовый песок\r\n-песочная радуга\r\n-радужная пыль\r\n-пыльное электричество\r\n-электрический арбуз\r\n-арбузный бутерброд\r\n\r\nИтак поехали!");
INSERT INTO forum_t VALUES("90","2","11","Игра будни джина","324","1591275728","1591275699","0","0","Суть такова:\r\nПользователь 1 загадывает желание, 2ой пользователь исполняет, но делает это так, чтобы 1ый от исполненного желания удовольствия не получил и загадывает своё желание. ит.д.\r\nНапример:\r\n1ый: Хочу много холодного пива.\r\n2ой: Исполнено. Теперь ты проболеешь ангиной до осени. Хочу...\r\n\r\nПравило: к игре относиться с юмором, никаких обид и наездов\r\nЖелания можно повторять, но не слишком часто(подождать хотя бы 10 постов от предыдущего высказывания оного)\r\nНу что, понеслася? ");
INSERT INTO forum_t VALUES("91","8","1","Ошибки","324","1591340056","1591335199","0","0","Если что-то не работает или увидели ошибку, в этой теме оставляйте коментарии");
INSERT INTO forum_t VALUES("92","3","17","Почему люди лгут","324","1591352532","1591352532","0","0","Почему люди лгут? Зачем нужна ложь? Почему мы не всегда хотим говорить правду? Каждый из нас неоднократно задумывался над этими вопросами. Подумайте, как бы мог существовать мир, в котором люди будут говорить друг другу только правду? Как ни крути, а ложь нам так же необходима, как и правда, для чего спросите Вы? Для поддержания внутреннего баланса. Только не стоит путать ложь во благо, личные секреты и фантазию с подлым обманом. \r\nЛожь сама по себе отличается от одноликой истины тем, что она многолика, она имеет сотни тысяч обличий и не имеет пределов. В большинстве случаев жертва обмана не может заметить просчетов лжеца, и отдает предпочтение тому, что бы объяснять неясности поведения в выгодном для себя свете, таким образом, тайно попустительствуя лжи, избегая при этом неприятной ситуации разоблачения обмана. В основном обманываясь (или же разоблачая обман), люди как получают что-то, так и теряют. Эта закономерность является одной из известных, из-за нее не всегда принимаются верные решения. Так давайте поговорим о том почему мы обманываем и до какой до какой степени можем обмануть и почему мы сами готовы обманываться?");
INSERT INTO forum_t VALUES("93","3","17","Просто будте счастливы","324","1591352601","1591352601","0","0","Почему нельзя держа за руку просто сказать “Я люблю тебя”?! \r\nПочему нужно постоянно жить в страхе… \r\n“А вдруг я много даю?\r\nА вдруг ему надоест? \r\nА вдруг не время говорить?”\r\nК чёрту игры, сознание, воспитание....отдайся чистоте помыслов и силе чувств. Что мешает?\r\nЧто ты боишься потерять?\r\nИ ты будешь счастлива от того, что вот оно - ЕДИНСТВО ДУШ… Рядом… И ты залезешь ему под руку, прячась от всего мира там, где ты всегда уверена – он тебя чувствует… Каждое биение твоего сердца у него в сознании…\r\nОн не оставит без внимания ни радость, ни боль в твоих глазах с длинными ресницами… Он не отвернется, и не будет раздумывать, когда ты протянешь руку, и скажешь “давай мириться”.\r\nОн просто посмотрит в глаза и обнимет… молча. И в этом молчании будет весь мир… и ты услышишь больше, чем ты слышала с уст всего человечества…\r\nЦените самое важное...сколько энергетики имеет сила любви, сколько эмоций, переполняющих душу…\r\nЧто мешает?\r\nНу неужели тебе нужен рядом человек, который не поймет тебя, не прочувствует твою душу…?\r\nНет.\r\nТогда зачем игры?...\r\nЗачем?\r\nЕсли можно найти человека, с которым ты сможешь кричать в 3 часа ночи на балконе “Я тебя люблю всей душой”…\r\nА такого человека можно найти...Ищите!");
INSERT INTO forum_t VALUES("94","13","27","Рыбный пирог","324","1591353020","1591353020","0","0","ВКУСНЕЙШИЙ БЮДЖЕТНЫЙ Рыбный ПИРОГ\r\nИнгредиенты для теста:\r\n●кефир 1ст.,\r\n●сырое яйцо 1 шт.,\r\n●мука 1 ст.,\r\n●сода ½ ч.л.\r\nНачинка:\r\n●рыбные консервы 1 б., МОЖНО по ВКУСУ и ЛЮБЫЕ.\r\n●отварные яйца 2 шт.,\r\n●любая зелень, сыр 50 г.\r\nПриготовление:\r\nНачинаем с приготовления теста. \r\nСмешиваем все ингредиенты и выливаем в смазанную маслом форму.\r\nРыбу отделяем от масла и разминаем вилкой. \r\nДобавляем мелко нарезанные яйца и зелень. \r\nСыр натираем на мелкой терке.\r\nНачинку выкладываем в форму, стараясь оставить свободную тонкую полоску теста у бортика.\r\nФорму ставим в разогретую духовку минут на 20. \r\nДостаем почти готовый пирог и посыпаем его сыром, потом вновь отправляем в духовку на 5 минут.\r\nПирог готов. \r\nОн вкусный как в теплом, так и в холодном виде.");
INSERT INTO forum_t VALUES("95","13","27","Пончики","324","1591353094","1591353094","0","0","Пышные, нежные, очень высокие, медовые пончики на молоке — этот домашний десерт намного вкуснее, чем аналогичный из кофейни или магазина! Попробуйте приготовить такие пончики хотя бы раз и уже не сможете оторваться!\r\nИнгредиенты для медовых пончиков:\r\n260-280 мл теплого молока;\r\n3 ч. л. дрожжей (9 грамм);\r\n3 яичных желтка;\r\n550 гр муки;\r\n1 ч. л. разрыхлителя;\r\n3 ст. л. жидкого меда, 45 гр;\r\n3 ст. л. сливочного масла или маргарина, около 70 грамм;\r\nщепотка соли.\r\n\r\nПриступаем к приготовлению:\r\n1. В тёплое молоко вливаем 3 желтка и дрожжи, всё перемешиваем, накрываем ёмкость полотенцем и оставляем в тёплом месте на 10-15 минут.\r\n2. Когда на поверхности появятся небольшие пузыри, добавляем всю просеянную муку, разрыхлитель и жидкий мёд.\r\n3. Замешиваем тесто. Добавляем размягчённое масло или маргарин и щепотку соли. Снова замешиваем эластичное тесто, мнем его руками несколько минут. Добавлять масло или маргарин следует именно в конце, чтобы пончики получились пышными.\r\n4. Отщипываем или отрезаем кусочек теста весом около 45 грамм и формируем из него шарик, загибая края теста назад. Проделываем то же самое со всем тестом, затем оставляем шарики отдыхать в течение 45 минут, накрыв полотенцем или пищевой плёнкой. За это время они увеличатся минимум в два раза.\r\n5. Теперь окунаем палец в муку и делаем отверстие в центре будущего пончика. После этого оставляем пончики ещё на 10 минут отдыхать.\r\n6. Осталось лишь пожарить готовые пончики на масле без запаха. Масло в сковороде должно покрывать пончики наполовину. Не делайте слишком высокий огонь, чтобы не спалить их! Жарьте их, как обычные пирожки, с двух сторон, по паре минут с каждой стороны до характерного цвета.");
INSERT INTO forum_t VALUES("96","13","27","Пирожки с картошкой и сыром","324","1591353198","1591353198","0","0","Потрясающе вкусные\r\nпирожки-лепешки с\r\nкартошкой и сыром\r\nИнгредиенты:\r\nТертый сыр — 100 г\r\nКартофель — 700–800 г\r\nЗелень — 1 пучок\r\nЛук — 1 шт.\r\nДля теста:\r\nЯйца — 2 шт.\r\nСоль — по вкусу\r\nКефир — 1 стак.\r\nМука — 1,5–2 стак.\r\nПриготовление:\r\n1. Ставим отваривать очищенный картофель,чтобы приготовить мятую картошку для начинки.\r\n2. Жарим мелко нарезанный лук до золотистого цвета,кладем его в картошку.\r\nДобавляем зелень и тертый сыр, зелень по вкусу и все тщательно перемешиваем.\r\nНачинка готова.\r\n3.Замешиваем пресное тесто из муки, 2 яиц и стакана кефира.Добавляем соль по вкусу.\r\n4. Тесто замешиваем, разрезаем его на кружочки, скалкой раскатаем каждый кружочек.\r\n5. Кладем начинку, лепим пирожок, края защипнем, а потом придавливаем пирожок с двух сторон так, чтобы получилась лепешка.\r\n6. Готовые лепешки обжариваем на сковородке с двух сторон до образования хрустящей корочки.\r\nПриятного аппетита!");
INSERT INTO forum_t VALUES("97","13","29","Лимонный пирог","324","1591353271","1591353271","0","0","пирог из серии быстро вкусно)))\r\nИнгредиенты: Мука — 300 г\r\nЛимон — 1 шт.\r\nМасло сливочное — 180 г\r\nСахарная пудра — 230 г\r\nРазрыхлитель теста – 8 г\r\nЯйцо — 3 шт\r\nПриготовление: \r\n1. В большой миске смешиваем муку, разрыхлитель и 100 г сахарной пудры. Оставшиеся 130 г сахарной пудры пойдут в лимонный крем.Добавляем 150 г масла сливочного. Еще останется 30 г масла для крема.Руками растираем все в крошку.Добавляем 1 яйцо. Оставшиеся 2 яйца пойдут в лимонный крем.Быстрыми движениями замешиваем тесто. Оно получается податливым, мягким и нежным.Тесто кладем в пищевой пакет и отправляем в холодильник на полчаса. \r\n2.Займемся лимонным кремом. Для начала выжимаем сок из лимона.Затем сок процеживаем. Это удобно делать сквозь ситечко.Оставшиеся 30 г сливочного масла растапливаем. Если у вас мало опыта в приготовлении кремов и соусов, лучше делать это на водяной бане)))\r\n3. К растопленному маслу добавляем процеженный лимонный сок.Затем всыпаем оставшиеся 130 г сахарной пудры.Туда же отправляем оставшиеся 2 яйца.Постоянно помешивая, готовим крем на маленьком огне (или водяной бане), пока он чуть не загустеет. Это занимает около 5-6 минут. Снимаем крем с огня. \r\n4. Форму для запекания застилаем пекарской бумагой. Выкладываем в нее две трети теста и пальцами распределяем его по дну формы, попутно формируя бортики.Выкладываем на тесто лимонный крем.Оставшуюся часть теста раскатываем и нарезаем на полоски/ у меня кружечки Выкладываем полоски на пирог в виде сетки.Выпекаем лимонный пирог в разогретой до 180°C духовке 30-35 минут.");
INSERT INTO forum_t VALUES("98","13","29","Банановое печенье","324","1591353327","1591353327","0","0","Ингредиенты:\r\nБанан — 2 шт.\r\nОвсяные хлопья — 1 стак.\r\nОрехи, цукаты, изюм — по вкусу\r\nПриготовление:\r\n1. Очисти бананы, положи в миску и хорошо разомни вилкой. Добавь туда же овсяные хлопья, а также по желанию орехи, изюм, цукаты, корицу и еще раз тщательно помни.\r\n2. Сформируй из этой смеси печенье. Затем выложи на противень, застеленный пергаментом (смазанным маслом) и выпекай при температуре 180°C 15 минут. Если у тебя газовая духовка, тогда, возможно, придется выпекать 20 минут.");
INSERT INTO forum_t VALUES("99","13","29","Манные кексики","324","1591353365","1591353365","0","0","Пышные, воздушные и вкусные манные кексы - проще рецепта не найти!\r\nЕсли у вас мало времени, а готовить что-то на утро все равно ведь надо, то советую приготовить манные кексы.\r\nВкуснейшие кексы покоряют своей простотой и оригинальным нежным вкусом. Готовятся кексы очень легко, а получается вкуснейшая домашняя выпечка.\r\nИнгредиенты:\r\n- 1 стакан манной крупы\r\n- 1 стакан кефира\r\n- 1 яйцо\r\n- сода\r\n- 1 стакан сахара\r\n- 1 стакан муки\r\nСтакан манной крупы залить стаканом кефира, дать настояться минут 40.\r\nЗатем добавить 1 яйцо, размешать.\r\nДобавить половину чайной ложки соды (загасить уксусом), теперь отправить туда 1 стакан сахара и 1 стакан муки.\r\nЭту смесь хорошенько вымешать (блендером), нагреваем духовку до 200 градусов, тем временем наполняем формочки на 2/3 и отправляем в духовку на 40-50 минут.");
INSERT INTO forum_t VALUES("100","13","29","Йогуртный торт","324","1591353435","1591353435","0","0","Очень воздушный, не приторный и лёгкий тортик!!!!!\r\nДля формы 26 см.нам понадобится:\r\nтесто:\r\nяйцо 2 шт\r\nсахар 100 гр\r\nкефир 100 мл\r\nмука 150 гр\r\nванильный сахар 0,5 ч.л\r\nразрыхлитель 0,5 ч.л\r\nрастительное масло 25 мл\r\nсуфле:\r\nйогурт питьевой (у меня черничный) 800 мл\r\nсахар 50 гр\r\nжелатин 20 гр\r\nмолоко 50 мл\r\nсвежая черника 1 стакан\r\nЯйца взбить с сахаром, добавить ванильный сахар, кефир, масло и ещё раз хорошо взбить. Муку просеять и смешать с разрыхлителем. Соединить две смеси и перемешать ложкой. Вылить тесто в разъёмную форму и выпекать в заранее разогретой духовке при 180С примерно 25 минут (готовность проверить сухой зубочисткой). Достать корж из духовки и оставить его в форме до полного остывания.\r\nПриготовить суфле: желатин залить молоком и оставить для набухания, затем поставить на огонь и прогреть до полного растворения (не кипятить!). Йогурт смешать с сахаром. Влить тонкой струйкой тёплый желатин в йогурт. Хорошо перемешать. Добавить ягоды и перемешать.\r\nВылить смесь на остывший корж. Поставить торт в холодильник до полного застывания. Достать наш торт и аккуратно снять бортики. Украсить можно по Вашему желанию.");
INSERT INTO forum_t VALUES("101","13","27","Сосиски в картошке","324","1591353497","1591353497","0","0","Ингредиенты:\r\n4 средних, отваренных в мундире картофелины;\r\n3 сосиски;\r\n2 яйца;\r\n3-4 ст. л. муки (и немного муки для панировки);\r\n1-2 зубчика чеснока;\r\nрастительное масло (для жарки);\r\nсоль, чёрный свежесмолотый перец - по вкусу.\r\nПриготовление:\r\nГотовим картофельное тесто для сосиски. Картофель очистить, натереть на тёрке. Добавить яйца, соль, перец, тщательно перемешать. Добавить муку, перемешать. Картофельное \"тесто\" готово. Подготовить сосиски.\r\nВлажными руками взять немного картофельного теста, распределить по руке, положить сосиску и распределить картофельное тесто так, чтобы оно закрыло сосиску со всех сторон. Запанировать полученную \"палочку\" в муке. Аналогично повторить для остальных \"палочек\". Растительное масло разогреть, добавить к нему крупно нарезанный чеснок и прокалить. Следить, чтобы чеснок не подгорел. Чеснок убрать из масла. На чесночном масле обжарить сосиску в картошке до устойчивой золотистой корочки. Выложить на бумажные салфетки, чтобы удалить излишки масла. Нарезать на порционные кусочки и подавать к столу с вашими любимыми соусами.\r\nПриятного аппетита!");
INSERT INTO forum_t VALUES("102","13","29","Манный лимонник","324","1591353579","1591353579","0","0","Вы не любите манку? Да в пирог её! Сейчас приготовим, будет вкусно.\r\nВам потребуется:\r\n- 1 стакан сухой манной крупы;\r\n- 1 стакан кефира;\r\n- 1 стакан сахара;\r\n- 2 яйца;\r\n- 1 крупный лимон;\r\n- Щепотка соли;\r\n- 1 пакетик ванильного сахара;\r\n- 1 ст. ложка разрыхлителя для теста;\r\n- 2 столовых ложки муки;\r\n- Масло или маргарин для смазки формы;\r\n- Сахарная пудра для присыпки.\r\nКак готовить:\r\n1. Манную крупу смешаем с кефиром и оставим на полчасика для набухания. Через некоторое время приступим к дальнейшему приготовлению.\r\n2. В отдельной посуде разотрём яйца с сахаром, солью, и ванильным сахаром.\r\n3. Лимон натрём на крупной тёрке вместе с цедрой.\r\n4. А теперь всё смешаем. Тесто получается жидковатым, поэтому добавим пару ложек муки и одну ложку разрыхлителя для теста. Пробовала делать на соде, мне не понравилось, лучше приобрести разрыхлитель или приготовить его самостоятельно.\r\n5. Форму для пирога выстелем пергаментной бумагой, смажем маслом, присыплем сухарями. Силиконовую форму достаточно просто смазать топлёным маслом или сливочным маргарином. Выльем тесто в форму для пирога.\r\n6. Отправим в заранее прогретую духовку. Температура в печи не более 200 градусов. Верх у манника всегда бледнее, чем низ, поэтому пусть вас не обманет не подрумянившийся верх, через 15-20 минут проверьте спичкой или зубочисткой на готовность, если спичка сухая – вынимайте. Готовый пирог выложим на блюдо, присыплем сахарной пудрой.\r\nПриятного аппетита!");
INSERT INTO forum_t VALUES("103","13","29","Банановый пирог","324","1591548159","1591353701","0","0","Для приготовления\r\nбананового пирога Вам\r\nпонадобятся следующие\r\nпродукты:\r\nТесто:\r\n- банан – 3 шт;\r\n- яйца – 1 шт;\r\n- сахар – 1 столовая ложка;\r\n- соль - 1 чайная ложка;\r\n- молоко - 3 столовых ложки;\r\n- растительное масло - 0,5\r\nстоловых ложки;\r\n- мука - 2 столовых ложки;\r\n- разрыхлитель- 1 чайная\r\nложка;\r\n- стружки кокосовые - 3\r\nчайные ложки;\r\n- Ванилин\r\nКрем:\r\n- сахар - 1-1,5 столовых ложки;\r\n- вода - 0,5-1 столовых ложки;\r\n- сок лимонный - 2 столовых\r\nложки;\r\n- стружки кокосовые - 1\r\nстоловая ложка.\r\nТехнология приготовления\r\nбананового пирога:\r\nПриготовление теста:\r\n1) Возьмите бананы и\r\nразомните их в кашицу, после\r\nчего добавьте яйцо, сахар,\r\nсоль, масло, молоко,\r\nразрыхлитель и ванилин\r\n2) Постоянно помешивая,\r\nдобавьте в массу кокос и муку.\r\n3) Все компоненты тщательно\r\nперемешайте, после чего\r\nвылейте тесто на смазанную\r\nформу (в качестве формы\r\nподойдет противень для\r\nлазаньи), затем поставьте в\r\nпредварительно прогретую\r\nдуховку: нижний+Верхний тен,\r\nтемпература 170 градусов, по\r\nвремени выпекайте примерно\r\n1 ч. 10 мин.\r\nКрем:\r\n4) Возьмите сахар, залейте его\r\nводой и вскипятите, при этом\r\nпостоянно помешивая, до тех\r\nпор, пока он слегка не\r\nзагустеет.\r\n5) Снимите массу с огня и\r\nдобавьте кокос и лимонный\r\nсок.\r\n6) Массу перемешайте и затем\r\nнамажьте на остывающий\r\nпирог и посыпьте сверху\r\nкокосовыми стружками.\r\n7) Крем лучше сделайте\r\nбыстрее и сразу намажьте на\r\nвыпечку, так как крем может\r\nзастыть.\r\nПрекрасный банановый пирог\r\nготов и его можно подавать к\r\nстолу.\r\nПриятного аппетита!");
INSERT INTO forum_t VALUES("105","2","12","Игра Считалочка-Сюрприз","362","1591601637","1591537881","0","0","Предлагаю поиграть в интересную и дружескую игру.\r\nПравила игры.\r\nСчитаем от 1 до 10 по порядку.\r\n1 дарит 4-му вип подарок.\r\n2 получает 1000 монет.\r\n3 целует на странице 10.\r\n4 получает 5000 баллов.\r\n5 награждает 9.\r\n6 получает 20 рублей.\r\n7 совершает действие 3.\r\n8 получает подарок.\r\n9 присылает угощение 6.\r\n10 целует на странице 3.\r\nПоехали?!\r\n.1.");
INSERT INTO forum_t VALUES("107","2","12","Игра Эйфелева Башня","362","1591962498","1591541295","0","0","Вместе весело шагать по ступенькам.\r\nВ знаменитой Эйфелевой Башне 500 ступенек.\r\nКто поднимется первый получает 50 руб.,500 монет и вип подарок.\r\nЖелаю удачи!.миг.");
INSERT INTO forum_t VALUES("108","2","12","Игра \"Спуск\"","362","1591548330","1591546442","0","0","Дорогие друзья!\r\nВедём счёт от 200 до 0.Каждый 50 дарит предыдущему участнику подарок и получает за это медаль на страничку и 2000 баллов!.ор.");
INSERT INTO forum_t VALUES("109","2","12","Игра \"Поехали за покупками\"","362","1591615672","1591548691","0","0","Мы за покупками .ор.ты с нами???\r\nА мест то всего 20.\r\nПравила:\r\nВедём отсчёт того что нужно кому купить.Ставим цифру и пишем то что нужно вам купить.В поезде 20 мест.20-ому пассажиру 2000 баллов за проезд.\r\nНу что?\r\nПоехали?!.ор.");
INSERT INTO forum_t VALUES("110","13","29","Десерт из творога с печеньем","324","1591804630","1591804630","0","0","Десерт из творога с печеньем\r\nбез выпечки\r\nИнгредиенты:\r\n- Печенье любое квадратной\r\nформы 20-25 шт.\r\n- Желатин 1 ч.л.\r\n- Творог 2 пачки\r\n- Сахар, ванилин\r\n- Сливки 200 гр.\r\nПриготовление:\r\n1. Желатин растворить\r\nсначала в холодной воде до\r\nразбухания, затем подогреть\r\nдо полного растворения.\r\n2. Затем взбить сливки,\r\nдобавить остальные\r\nингредиенты, кроме печенья.\r\n3. Все тщательно взбить\r\nмиксером. Получившуюся\r\nначинку положить на\r\nпеченье (3*7) и сверху\r\nнакрыть 2-й печенькой.\r\nУбрать в холодильник минут\r\nна 40-60.\r\n4. Украсить тёртым\r\nшоколадом.");
INSERT INTO forum_t VALUES("111","13","29","Бланманже творожное","324","1591804717","1591804717","0","0","Нежный десерт, который нравится взрослым и детям. Этот изумительный десерт готовится без выпечки.\r\nДля приготовления бланманже творожного понадобится:\r\n0,5 стакана молока;\r\n1 пакетик (15 г) желатина;\r\n1 пакетик (10 г) ванильного сахара;\r\n250 г творога;\r\n0,5 стакана сметаны;\r\n0,5 стакана сахарной пудры;\r\n2 колечка ананаса (или другие фрукты). Я взяла клубнику\r\nВ молоке развести желатин и оставить для набухания на 20 минут.\r\nТворог смешать с сахарной пудрой, сметаной и ванильным сахаром в пышную однородную массу.\r\nКолечки ананаса (в нашем случае ягоды) нарезать кусочками.\r\nЖелатин нагреть до горячего состояния, но не кипятить.\r\nОсторожно влить желатин в творожную массу, тщательно перемешать. Добавить кусочки ананасов (ягоды) и снова перемешать.\r\nВыложить массу в форму (или в порционные формы) и поставить в холодильник для застывания на 4-5 часов. Чтобы десерт из формы вышел без повреждений, форму нужно окунуть в горячую воду на несколько секунд, бланманже легко отделится от стенок формы.\r\nБланманже творожное готово.");
INSERT INTO forum_t VALUES("112","13","29","Банан в шоколаде","324","1591804848","1591804848","0","0","Ингредиенты:\r\nБанан - 2 шт.\r\nШоколад (любой) - 100г\r\nКокосовая стружкаорехихлопья\r\nПриготовление:\r\nКаждый банан режем на 2-3-4 части.\r\nШоколад растапливаем на водяной бане или в микроволновке (мощность 450, 2-3 минуты).\r\nОрехи измельчаем\r\nКусочки бананов насаживаем на деревянные палочки и обмакиваем в шоколад. Затем обваливаем в кокосовой стружкеорехаххлопьях, кладем на пергамент и отправляем в холодильник, чтобы шоколад застыл.");
INSERT INTO forum_t VALUES("115","13","29","Творожный торт","324","1591805247","1591805247","0","0","Ингредиенты:\r\n400 г творог (домашний)\r\n1 ст. + 1 ст. сахар (тесто+крем)\r\n4 шт. яйца куриные (тесто - желтки, крем-белки)\r\n2 ч. л. сода\r\n2,5-3 ст. мука\r\n1 ст.л. крахмал кукурузный\r\n900 мл молоко коровье\r\n300 г масло сливочное (комнатной температуры)\r\n2 пакетика ванильный сахар\r\n1 ст.л. лимонный сок\r\n150-200 г грецкий орех\r\nПроцесс приготовления\r\nЭтот нежный и очень вкусный домашний торт всегда на моем праздничном столе. Приготовить тесто. Творог (у меня жирный домашний) хорошо растереть с сахаром (1 ст.). Если творог суховат, желательно тротереть его через сито. Добавить к творожной массе желтки, соду (погасить соком лимона).\r\nМассу оставить при комнатной температуре на 20-30 минут, чтобы она увеличилась примерно в два-три раза. Муку всыпать небольшими партиями к творожной массе, каждый раз качественно перемешивая. Добавлять муку до тех пор, пока тесто не станет послушным, то есть будет скатываться в хороший шар, не прилипая к рукам. Выложить тесто на подпыленную мукой поверхность, разделить на 10-12 равных частей, из каждой части раскатать тонкие круглые коржи.\r\nВыпекать коржи в предварительно нагретой до 180 градусов духовке. Никуда не отходите: коржи тонкие и пекутся буквально несколько минут!\r\nПриготовить крем. Белки хорошо размешать с 1 стакана сахара и ванильным сахаром. Добавить 2 ст. ложки (под нож) муки и ложку крахмала (предварительно размешанные в небольшом количестве холодного молока, чтобы не было комочков). Молоко вскипятить, помешивая, добавить белки и сварить заварной крем. Остудить. (Чем больше муки или крахмала - тем гуще получится крем. Густота крема и сладость регулируется по вкусу). Далее в большой миске взбить миксером сливочное масло комнатной температуры до пышности. Не прекращая взбивания, постепенно по ложке добавлять охлажденный крем во взбитое масло. Взбить крем до однородности. Готовым кремом перемазать коржи.\r\nСверху торт украсить измельченным печеньем или орехами.");
INSERT INTO forum_t VALUES("116","13","29","Шоколадно малиновый блинный торт","324","1591805407","1591805407","0","0","Ингредиенты:\r\nДля блинов:\r\nЯйцо – 6 шт\r\nСливки – 1 стакан\r\nКокосовое молоко – ? стакана\r\nВанилин – 1 чайная ложка\r\nМука – 1 стакан\r\nСоль – 1/8 чайной ложки\r\nСахарная пудра – ? стакана\r\nШоколадный крем:\r\nГорький шоколад – 510 г\r\nЖирные сливки – 2 стакана\r\nВанилин – 1 чайная ложка\r\nДополнительно:\r\nМалиновый джем или варенье\r\nКакао-порошок\r\nПриготовление:\r\nШоколад мелко нарубите. Сливки c ванилином поставьте на водяную баню на средний огонь. Доведенные до кипения сливки вылейте на шоколад и перемешайте, чтобы шоколад полностью растворился. Остудите крем перед использованием.\r\nНанесите слой шоколадного крема и тонкий слой джема между каждым блином. Последним слоем торта должен быть блин, а не крем. Смажьте шоколадом также и по всей поверхности торта, а оставшийся крем поставьте в холодильник, а затем слепите небольшие шоколадные трюфели, обваляйте их в какао-порошке и выложите поверх торта. Весь торт также присыпьте обильно какао-порошком.\r\nПеред подачей дайте торту хорошенько охладиться");
INSERT INTO forum_t VALUES("117","6","8","Первый компьютер","324","1591882424","1591882424","0","0","Первый в мире компьютер со всей необходимой для его работы инфраструктурой весил 30 тонн. Это был американский программируемый компьютер, который создал в 1941 году гарвардский математик Говард Эйксон на основе идей Чарльза Бэббиджа и при сотрудничестве четырёх инженеров компании IBM.\r\nСтоимость этого компьютера составила 500 тысяч долларов. Компьютер собран в корпусе из нержавеющей стали и стекла, имел длину около 17 метров, высоту более 2,5 метров, площадь занимал несколько десятков метров. Компьютер Марк 1 содержал в себе электромеханические переключатели, реле и прочие детали в количестве 765 тысяч штук.");
INSERT INTO forum_t VALUES("118","6","8","Голубой пруд","324","1591882603","1591882603","0","0","Голубой пруд, Япония ...\r\nЭтот удивительный водоём находится на японском острове Хоккайдо, который является вторым по величине в данном регионе. На острове расположились около 20-ти Национальных парков и все они охраняются государством, поддерживающим флору и фауну острова в естественном состоянии, что привлекает огромное количество экотуристов со всего мира.\r\nОтличительной особенностью этого пруда является насыщенный голубой цвет воды. Стоит отметить, что в разное время суток и в различных природных условиях голубой цвет переливается множественными оттенками, создавая просто невероятное зрелище. Такой цвет воды обусловлен богатыми залежами алюминия, расположенными в непосредственной близости с водоёмом. Впадающие в пруд реки приносят с собой микрочастицы этого алюминия, которые оседают на дне и отражают солнечный свет, подсвечивая воду и придавая ей голубой оттенок");
INSERT INTO forum_t VALUES("119","6","8","500 оттенков серого","324","1591882738","1591882738","0","0","Человеческий глаз может различить 500 оттенков серого! Вообще, глаза человека — очень сложный и удивительный орган, о всех необычных свойствах которого мало кто догадывается. Вот еще несколько интересных фактов о наших глазах:\r\nПри взгляде на любимого человека, зрачки наши расширяются на 45%.\r\nЧихать с открытыми глазами не получается ни у кого.\r\nСреди мужчин каждый 12-й — дальтоник, не различающий некоторые цвета или их оттенки.\r\nЧеловек способен воспринимать лишь три части спектра: синий, зеленый, красный. Видимое нами многообразие оттенков — это всего лишь производные названных цветов.\r\nГлаза навсегда остаются такого же размера, как и при рождении, а уши и нос растут всю жизнь.\r\nЗа всю жизнь человек видит примерно 24 млн. разных изображений.");
INSERT INTO forum_t VALUES("120","6","8","Наушники блютуз","324","1592028908","1592028908","0","0","Monster Beats в очередной рас решила нас порадовать добавив в свою линейку беспроводных наушников новинку YP-702 .Теперь в новинку встроили MP3 (microSD до 32ГБ), FM радио и Bluetooth\r\nБеспроводные наушники Monster Beats с встроенным blutooth, MP3 и FM радио\r\nБлагодаря беспроводным стереофоническим Bluetooth наушникам YP-702 Вы сможете:\r\n-Без проводов слушать стереофоническую музыку со своего любымого музыкального полеера, мобильного телелефона,ПК и или любого другого гаджета;\r\n-Использовать в качестве беспроводной гарнитуры для совершения звонков с мобильного телефона или общения в Skype через ПК;\r\n-Удобное дистанционное управление основными функцициями музыкального плеера (воспроизвидение, остановка,переключение треков,регулировка громкости и др.);\r\n-Bluetooth версии 2:1 + EDR воспроизведет высококачественный звук без помех и болие низким энергопотреблением на растоянии до 10 метров(в зависимости от условий);");
INSERT INTO forum_t VALUES("121","6","24","Почему хочется выпить","324","1592029212","1592029212","0","0","Чрезмерное употребление спиртных напитков, а также хронический алкоголизм приводят к длительным изменениям в активности генов.\r\nВ результате у человека возникает еще большая тяга к алкоголю. К такому выводу пришли ученые Ратгерского университета (США), сообщает\r\n\"Лента.ру\".\r\nОни изучили гены, участвующие в регуляции поведения: PER2 и POMC. Первый отвечает за работу биологических часов организма, а второй формирует реакцию на стресс.\r\nВ исследовании приняли участие умеренно пьющие, а также люди, употребляющие значительное количество алкоголя (что определяется как пьянство), и алкоголики.\r\nОказалось, что при пьянстве и алкоголизме наблюдается повышенный уровень метилирования, подавляющего работу генов и снижающего скорость, с которой эти гены производят белки. Чем больше человек употреблял спиртное, тем сильнее были изменения.\r\nКроме того, после просмотра картинок, изображающих стрессовую ситуацию, люди с тягой к алкоголю испытывали большее желание выпить.\r\nКак сообщал OBOZREVATEL, ранее ученые выяснили, что умеренное употребление алкоголя уменьшает риск смерти пожилых людей, которым была диагностирована сердечная недостаточность.");
INSERT INTO forum_t VALUES("122","6","8","Обнаженная грудь лечит болезни","324","1592029624","1592029624","0","0","Немецкие учёные пришли к сенсационному выводу. Они доказали, что мужчины, которые имеют возможность регулярно видеть обнаженную женскую грудь, меньше подвержены риску инфаркта или инсульта (риск заполучить эти болезни сокращается на 50 процентов). Согласно полученным данным, десятиминутное созерцание женской груди заменяет для представителей сильного пола получасовую тренировку. Так же, по мнению немцев, регулярное созерцание столь аппетитной части женского тела способно увеличить продолжительность жизни мужчин. Возможно, в связи с этой новостью руководители многих компаний пересмотрят дрес-код своих сотрудниц. К примеру, позволят им несколько раз в неделю носить декольте для поддержания нормальной рабочей атмосферы в офисах. В качестве антикризисных мер.\r\nЧто тут добавить? Милые дамы! не стесняйтесь показывать вашим любимым мужчинам вашу грудь... если хотите чтобы они были здоровыми и жили дольше.");
INSERT INTO forum_t VALUES("123","6","8","Черты лица, брови","324","1592029843","1592029843","0","0","Брови. Идеальными считаются\r\nширокие, длинные брови.\r\nПропорциональное развитие бровей\r\n(форма, цвет, густота) указывает на\r\nсбалансированность эмоций, ума и\r\nхарактера. Жесткие щетинистые\r\nброви свидетельствуют о\r\nпротивоположном. Брови отражают\r\nвзаимоотношение с окружающими.\r\nПриятная форма бровей говорит, что\r\nих обладатель ладит с окружающими.\r\nКогда густые брови внешними\r\nконцами дыбом поднимаются вверх,\r\nговорят, что это признак щедрости\r\nдуши и мужества. Такого человека\r\nсчитают рожденным для успеха.\r\nОпускающиеся внешние концы\r\nуказывают на застенчивость. Когда же\r\nструктура и цвет таких бровей\r\nкажутся безжизненными, считается,\r\nчто это от истощения внутренней\r\nэнергии. Если у мужчины ровные и\r\nдлинные брови, выступающие на фоне\r\nприятной кожи, то он слывет\r\nинтеллектуалом. Женщина с такими\r\nбровями считается кокеткой, от нее\r\nможно ждать любых выходок.\r\nКороткие брови всегда обозначают\r\nпротивоположное. Короткие но густые\r\nброви говорят о взрывной натуре.\r\nЕсли брови густые и щетинистые, то\r\nих обладатель - человек с\r\n\"дьявольской\" натурой. Щетинистые\r\nброви всегда указывают на\r\nстроптивость, упрямство,\r\nбескомпромиссность. Густые тяжелые\r\nсоединяющиеся брови означают\r\nнеодолимое стремление к\r\nдоминированию. Женщина с такими\r\nбровями обладает сильным\r\nхарактером, ей не подходит роль\r\nдомашней хозяйки. Высоко\r\nрасположенные брови говорят о\r\nцелеустремленности. Брови, сидящие\r\nслишком низко - об обратном. Если у\r\nженщины брови с уголком по середине\r\n- это признак независимости и\r\nзагадочности.");
INSERT INTO forum_t VALUES("124","6","8","Черты лица, уши","324","1592029903","1592029903","0","0","Хорошо оформленное ухо говорит о\r\nсчастливом детстве. Бесформенность\r\nи бледность говорят об обратном.\r\nСлишком большие уши - изъяны в\r\nличности, слишком маленькие -\r\nпризнак неблагополучия.\r\nПоложение уха на голове: Выше\r\nуровня бровей - высокий интеллект на\r\nуровне от бровей до глаз - интеллект\r\nвыше среднего ниже уровня глаз-\r\nинтеллект ниже среднего.\r\nУхо без хорошо оформленной мочки-\r\nнесбалансированность личности.\r\nДлинная мочка - беспечность.\r\nМаловыраженная мочка -\r\nщепетильность. Люди с очень\r\nбольшими мочками - мудрецы. Если\r\nмочка слегка подается вперед-\r\nдушевность. Если внутренний ободок\r\nуха втянут - сдержанность, если\r\nвыпячен- несдержанность. Розовый\r\nцвет уха -здоровье. Родинки внутри\r\nуха-неблагополучие.");
INSERT INTO forum_t VALUES("125","6","5","Факты о палачах","324","1592030176","1592030176","0","0","1. Традиционный головной убор палача является вымыслом. На самом деле палачи не прятали своих лиц. Исключением можно назвать лишь казнь некоторых средневековых королей.\r\n2. Палач имел право проводить венчание.\r\n3. Палач имел доходы с казненных. Сначала ему было дозволено брать лишь то, что находилось под поясом, потом они получили право на всю одежду осужденных.\r\n4. Палач имел право брать на рынках съестные припасы даром. Это право было предоставлено для того, чтобы он мог получать еду, которую не мог купить, так как многие отказывались принимать деньги из рук палача.\r\n5. Палач в средневековье мог заниматься экзорцизмом (процедурой изгнания бесов, вселившихся в человека). Дело в том, что одним из надежнейших способов изгнать злого духа, завладевшего телом, считалась пытка. Причиняя боль телу, люди как бы пытали демона, заставляя его покинуть это тело.\r\n6. В церкви палач должен был стоять позади всех, у самой двери, а к причастию подходить последним.\r\n7. Во Франции встречались и женщины-палачи. В приказе Людовика Святого от 1264 года сказано, «что тот, кто злословил или поступил противозаконно, по судейскому решению будет высечен розгами лицом его пола, а именно: мужчина — мужчиной, а женщина — женщиной, без присутствия мужчин».\r\n8. Если палач уходил на покой, он был обязан предложить городу кандидатуру на свой пост.\r\n9. По своему положению в обществе палач был близок к таким низшим слоям общества, как проститутки и актеры. Даже случайное соприкосновение с палачом было неприятно людям.\r\n10. Палач нередко оказывал горожанам услуги. Он торговал частями трупов и снадобьями, изготовленными из них, а также различными деталями, относящимися к казни. Такие вещи, как «рука славы» (кисть, отрубленная у преступника) и кусок веревки, на которой был повешен преступник, часто упоминаются в различных книгах по магии и алхимии.");
INSERT INTO forum_t VALUES("126","6","8","История селёдки под шубой","324","1592030483","1592030483","0","0","Одно из самых почетных мест на новогоднем столе занимает, как правило, блюдо с «селедкой под шубой». Вряд ли кто в праздничный день задумывался о таком необычном названии. А большинство людей предполагает, что «шубой» называются ингредиенты, которые покрывают сельдь. Но всё не так просто.\r\nВ 19-ом веке трактиры на Руси были местом, где можно было и поесть, и пообщаться. В том числе, и на революционные темы. Причем, нередко, споры достигали такого апогея, что заканчивались массовыми драками.\r\nВ один прекрасный зимний день, уже после революции, владельцу нескольких трактиров в Москве Анастасу Богомилову пришла в голову идея, как утихомирить посетителей. Как сделать атмосферу в его заведениях более спокойной. Секрет был тривиален – надо насытить желудок посетителей.\r\nИдею простого блюда, но со скрытым подтекстом, подсказал повар одного из трактиров – Аристарх Прокопцев. Селедка была дешевым и доступным продуктом для пролетариата, картофель, лук и морковь олицетворяли крестьянство, а свекла – красное революционное знамя. Французский майонез связывал их воедино.\r\nЧто касается слова «шуба», то это была аббревиатура начальных букв выражения «Шовинизму и Упадку – Бойкот и Анафема».\r\nНедорогой революционный салат появился в трактирах в канун 1919-го года.");
INSERT INTO forum_t VALUES("127","6","8","Фак, история появления","324","1592030598","1592030598","0","0","Существует легенда, что во время Столетней войны, французы отрезали средние и указательные пальцы захваченным английским и валийским лучникам. Таким образом, те не могли использовать лук для стрельбы по французам. После битвы при Азенкуре победившие англичане показывали французам средние и указательные пальцы, демонстрируя, что они на месте. Согласно другому варианту этой легенды, перед указанной битвой французы грозились одолеть англичан, причём особо похвалялись арбалетчиками как главной своей ударной силой (спуск арбалета нажимается средним пальцем). После того как французы проиграли битву, англичане издевательски напоминали им об их похвальбе, показывая им средние пальцы.");
INSERT INTO forum_t VALUES("134","2","12","Угадай Певицу/Певца","391","1592396335","1592107414","0","0","[background=Magenta][size=20][color=Aqua][b][center]\r\n.лин39.\r\nДРУЗЬЯ,КТО ОТГАДАЕТ ПЕВИЦУ/ПЕВЦА ПЕРВЫМ,\r\nТОТ ПОЛУЧИТ НАГРАДУ:\r\n.бон43.\r\n.лин39.\r\n[/size][/center][/b][/color][/background]");
INSERT INTO forum_t VALUES("133","2","12","Игра \"Высотка\".","362","1592156953","1592080026","0","0","Приветик друзья!\r\nПредлагаю вам новую игру!\r\nЯ живу на 50 этаже.. улыбка.\r\nНу занесла меня нелёгкая так высоко..шинк.\r\nИ я решила пригласить вас в гости.\r\nСчитаем от 1 до 50.\r\nКаждому 10-му я буду загадывать желание.Если желание выполнено,то ты получишь приз.\r\nНапример,за 10-й этаж-10 руб.,20-й уже будет 20 руб и так далее...\r\nКто доберётся ко мне на 50 этаж получит особую награду:500 монет,100 рублей,1000 баллов.\r\nДавай не зевай,в гости ко мне заползай..ор.");
INSERT INTO forum_t VALUES("135","2","12","Игра \"Досчитай до 1000\"","362","1592400135","1592162164","0","0","Правила:\r\nСчитаем от 1 до 1000\r\nПризы:\r\nКаждому 100-1000 баллов\r\nКаждому 200-подарок\r\nКаждому 300-вип подарок\r\nКаждому 400-действие\r\nКаждому 500-вип статус\r\nКаждому 600-800 монет\r\nКаждому 700-авторитет\r\nКаждому 800-1000 монет\r\nКаждому 900-3000 баллов\r\nКаждому 1000-100 рублей и медалька.\r\nПосты подряд от одного участника игры запрещены..ор.");
INSERT INTO forum_t VALUES("136","2","12","Игра \"Вечеринка\"","362","1592423662","1592163071","0","0","Вас пригласили на вечеринку:D\r\nГде каждый что то должен принести.\r\nОно должно начинаться на первую букву вашего имени.\r\nИ ведём счёт принесенного, каждому 100 приз:500 баллов,300 монет,100 рублей.\r\nНу что,гульнем?!.ор.");
INSERT INTO forum_t VALUES("137","2","12","Игра \"Счастливчик\"","362","1597674936","1592165947","0","0","Дорогие друзья!\r\nДавайте поиграем?:)\r\nПишите цифры от 1 до 30.\r\nКаждому 10 дарю 10 рублей.\r\nКаждому 20 дарю подарок.\r\nКаждому 30 дарю 5000 баллов.\r\nПоехали?!\r\nПосты подряд от одного участника игры запрещены..ор.");
INSERT INTO forum_t VALUES("138","8","2","ЗАКАЗ Графника","391","1592398321","1592224928","0","0","[background=DarkRed][color=Moccasin][b][size=20][center]\r\n.мнену3.\r\nОставляем заявочку в данной теме!\r\nЛибо пишите мне.\r\nЖМИ НА НИК-КАРТИНКУ\r\n[url=http://aklove.ru/info.php?id=391]Girl Style[/url]\r\n[/center][/size][/b][/color][/background]");
INSERT INTO forum_t VALUES("140","2","33","Игра \"Обнимашки\"","362","1595081104","1592490212","0","0","Считаем от 1 до 50.\r\n10 ый обнимает 9 ого.\r\n20 ый обнимает 19 ого и т.д.\r\n50 участник получает 100 рублей.\r\nОбнимаем .поц78..ах.");
INSERT INTO forum_t VALUES("141","2","33",".акция1.\"Семёрочка\"","362","1597626801","1592730198","0","0","Отмечаемся в этой теме семь дней подряд начиная с понедельника!Кто отметиться без пропуска получит 2000 баллов и 50 рублей!.ор.");
INSERT INTO forum_t VALUES("142","2","33",".привдруг.","362","1592731520","1592731520","0","0",".привдруг1.За каждого приведённого друга вознаграждение 1000 монет..ор.Ник друга которого вы привели писать мне в личку и я проверю..ор.");
INSERT INTO forum_t VALUES("143","6","8","Оскорбление личности","324","1592766177","1592766177","0","0","Не так много людей задумывается о последствии своих действий, высказываний и постов на различных сайтах, форумах, в блогах и уж тем более в комментариях на новостных сайтах и в социальных сетях. Множество людей не стесняется в выражениях и пишет грубые, оскорбительные посты в шутку и всерьез, с целью «троллинга» или просто по причине плохого настроения. Особенно множество споров и гневных, расистских комментариев с использованием нецензурных слов вызывают статьи на темы, связанные с мигрантами, националистами или преступлениями, совершенными приезжими или жителями кавказских республик.\r\nИ после опубликования таких комментариев мало кто вспоминает о статье 282 Уголовного кодекса РФ — возбуждение ненависти либо вражды, а равно унижение человеческого достоинства. \r\nПреступными признаются действия, направленные на возбуждение ненависти либо вражды, а также на унижение достоинства человека либо группы лиц по признакам пола, расы, национальности, языка, происхождения, отношения к религии, а равно принадлежности к какой-либо социальной группе, совершенные публично или с использованием средств массовой информации.\r\nЧитатель скажет: «Да ерунда это все. Интернет – это не публичное место, а моя страничка «ВКонтакте» или мой пост, комментарий на новостном сайте уж тем более».\r\nНо вот только, к сожалению, это не так. Согласно Постановлению Пленума Верховного Суда РФ от 28.06.2011 N 11 публично совершенными действиями по смыслу статьи 282 УК РФ признаются действия, совершенные в информационно-телекоммуникационных сетях общего пользования, включая сеть Интернет, и иные подобные действия.\r\nТо есть если к посту (или комментарию, сообщению) имеет доступ большое количество людей, этот пост может прочитать большое количество людей, то такой пост, размещенный на сайтах, в блогах или на форумах, является публичным.\r\n\r\nВаше мнение по этому поводу, Вы можете высказать в комментариях к этой теме");
INSERT INTO forum_t VALUES("144","3","14","Виртуальная любовь","324","1592766299","1592766299","0","0","Что такое виртуальная любовь? Еще какие-то 15-20 лет назад о существовании подобного явления никто и не мог подозревать, ведь, по сути, его и не существовало. А существует ли виртуальная любовь сегодня? Трудно ответить на этот вопрос, так же, как и в точном определении изложить ее основную суть, ведь даже понятие реальной любви, для многих, что-то непостижимое и необъяснимое.\r\nЛюбовь охватывает все чувства, затуманивает мозг, человек перестает воспринимать происходящее адекватно, его единственная и важная цель – увидеть, почувствовать и дотронуться до любимого человека .По поводу данного понятия существует огромное количество споров и пересудов, кто-то считает, что у виртуальной любви большое количество реальных плюсов, кто-то же, напротив, настроен негативно и видит сплошные минусы подобного явления. Но как на самом деле? Имеет ли такое она право на существование и стоит ли вообще считать ее важной составляющей жизни современного человека? Возможно и у Вас она случалась, расскажите о ней....");
INSERT INTO forum_t VALUES("145","6","8","Чудо банкомат","324","1592766411","1592766411","0","0","В Москве поломанный банкомат выдал мужчине полмиллиона рублей.\r\nОб этом сообщается на сайте МВД России по Москве.\r\nВ полиции установили, что 40-летний безработный, приехавший из Белгородской области, собирался снять четыре тысячи рублей, однако банкомат выдал ему 20 тысяч. Воспользовавшись техническим сбоем, он в общей сложности снял 500 тысяч рублей.\r\nКогда в банке обнаружили это, то заявили в полицию о краже. Подозреваемого задержали в одном из отделений банка, когда он собирался оплачивать кредит.\r\nПолиция возбудила уголовное дело за кражу, а мужчина находится на подписке о невыезде.");
INSERT INTO forum_t VALUES("146","3","16","Кокетство","324","1592767104","1592767104","0","0","Кокетство, по-моему, это способ обратить на себя внимание самца, привлечь его, а в последствии зацепится за него с целью выжить. Это историческая сущность, идущая от древних времен, времен тотальной зависимости женщин от мужчин. Сегодня, кокетсво существует в виде игры… увлекательной, но во многих случаях бесполезной. В сущности, кокетство - это обман одной стороны и самообман другой. При разном понимании и возрастном соотношении сторон оно может быть истолковано как аванс. Ваше мнение о кокетстве в общем?");
INSERT INTO forum_t VALUES("147","6","5","Интересные факты","324","1592767366","1592767366","0","0","1. Абдул Кассим Исмаил – великий визирь Персии (Х век) всегда находился рядом со своей библиотекой. Если он куда-то отправлялся, то библиотека следовала за ним. 117 тысяч книжных томов перевозились на верблюдах. Причем книги (т.е. верблюды) располагались в алфавитном порядке.\r\n2. У правителя Вавилона существовала интересная церемония ежегодного «переизбрания». Для этого он приходил в храм Мардука, главного вавилонского божества, и произносил речь, в которой утверждал, что не сделал в свое правление ничего плохого. При этом он стоял на коленях, а главный жрец срывал с него регалии, шлепал его по щекам и дергал за уши. После ряда других церемоний правитель считался прошедшим проверку и продолжал царствовать.\r\n3. Следуя старой традиции французских монархов, «Король-Солнце» Людовик XIV ежегодно в Страстной Четверг мыл ноги 12 нищим, обтирал их и целовал. Правда, нищие предварительно тщательно отбирались придворными врачами.\r\n4. Когда король Франции чувствовал себя при смерти, его любовницу (или любовниц) отсылали от двора – монарх должен был предстать перед Богом чистым от греха. Если король все же выздоравливал, любовницы возвращались обратно.\r\n5. Интересны предписания Атиллы, полученные на случай его смерти. Могила его должна была оставаться неизвестной. Гроб его состоял из трех вложенных друг в друга металлического, золотого и серебряного ящиков. Захоронение произошло в отдаленной местности, без опознавательных знаков, после чего всех участвующих умертвили…\r\n6. Великий Ганнибал умер, приняв яд, когда узнал, что римляне пришли, чтобы его убить. Такое поведение никого не удивило, поскольку в течение долгого времени самоубийство было первейшим средством от публичного позора.\r\n7. Впрочем, яд был и средством казни. Добровольно принять яд заставили знаменитого философа Сократа, которого несправедливо обвинили в государственной измене.\r\n");
INSERT INTO forum_t VALUES("148","6","8","Профессии которые скоро исчезнут","324","1592767730","1592767730","0","0","Всего каких-то 8-10 лет и традиционные для сегодняшнего общества профессии исчезнут. Уже сегодня человечество внедряет на некоторые рабочие места роботов, которые вскоре и вовсе заменят людей.\r\nЭксперты портала Staff опубликовали список профессий, которые в скором времени станут никому не нужны.\r\n1. Таксисты\r\nГод исчезновения: 2038.\r\nСамоуправляющиеся машины станут массовым продуктом – а значит, нужды в таксистах просто не будет.\r\n2. Бухгалтеры\r\nГод исчезновения: 2028.\r\nБухгалтерские программы на основе искусственного интеллекта станут настолько сильными и настолько дешевыми, что «живые» бухгалтеры не смогут с ними соревноваться.\r\n3. Помощники юристов\r\nГод исчезновения: 2026.\r\nЮристам будет проще работать с автоматизированными помощниками – они быстрее, больше знают и не уходят на больничный.\r\n4. Сотрудники парковок\r\nГод исчезновения: 2028.\r\nСначала местные власти будут сопротивляться этой идее, но новые технологии позволят автоматически отслеживать, когда машина стоит на парковке дольше оплаченного времени, и после льготного 5-минутного периода взимает с владельца автомобиля дополнительную плату.\r\n5. Туроператоры\r\nГод исчезновения: 2025.\r\nВы заходите в онлайновое турагентство, рассказываете о намеченной поездке, потом сайт задает все нужные вопросы, чтобы уточнить план и маршрут. А еще через полминуты показывает вам более дешевые варианты.\r\n6. Переводчики\r\nГод исчезновения: 2031.\r\nК 2028 году Google создаст точную систему перевода устной речи, неотличимую от работы лучших переводчиков. Человеческий перевод уйдет в историю.");
INSERT INTO forum_t VALUES("149","3","17","Отношения","324","1592807858","1592807858","0","0","В наш современный век интернет прочно вошёл в нашу жизнь и стал ее частью. Появились сайты знакомств. И отношения тоже перекочевали в интернет. Как относиться к этому явлению?\r\nНадо отметить, что страсти разгораются нешуточные. Есть истории с хорошим концом – когда люди познакомились в виртуале, встретились и стали семьей. А чаще всего можно встретить знакомства в интернете, после которых душевные раны еще очень долго напоминают о себе. Что же это такое и с чем это едят — отношения в пространстве интернета. Сколько в них процент жизни и сколько фантазии, на что можно опереться в понимании ситуации и насколько она реальна. А самое главное, как быть и жить дальше, когда матрица свернулась или удалилась – и на другом конце эфира больше никого нет. А чувства, внутри живы и кажется живее, чем в реальных отношениях.\r\nвиртуальные отношения\r\nКакие же плюсы виртуальных отношений нам дает интернет?\r\nОпределенно – вы выкладываете самые лучшие фотографии, и выглядите моложе.\r\nБольшой диапазон возможности познакомиться с человеком не только из своего города, другого города, даже с человеком из другой страны.\r\nДоступность — если вы стеснительны, расстояние и интернет помогают вам избежать это неприятное ощущение, притупляя непереносимое чувство, делая жизнь боле комфортной.");
INSERT INTO forum_t VALUES("150","3","15","О дружбе","324","1592808061","1592808061","0","0","Люди могут выбирать себе друзей уже с девятимесячного возраста.\r\nУченые утверждают, что уже в этом возрасте младенцы умеют выделять сверстников, у которых схожие интересы.\r\nЧем больше у человека друзей, тем меньше риск, что он будет страдать бессонницей и ощущать хроническую усталость.\r\n***\r\nМужчины намного терпимее к своим друзьям, чем женщины к подругам. Видимо поэтому мужчины реже меняют друзей, чем женщины.\r\n***\r\nУ хороших друзей ДНК похожи, почти как у родственников. Об этом заявили генетики из США (штат Массачусетс), которые провели генетические исследования почти 2000 людей. Ученые выяснили, что у друзей гены имеют больше сходства, чем с другими посторонними людьми");
INSERT INTO forum_t VALUES("151","3","15","Дружба сближает людей","324","1592808270","1592808270","0","0","Друзья лучше чувствуют друг друга\r\nСпособность ставить себя на место другого — одна из ключевых нравственных характеристик человека. Но с друзьями она выходит на новый уровень. Отсканировав мозг у 22 разных людей, получавших небольшие электрические разряды, ученые из Вирджинии обнаружили, что друзья намного лучше чувствуют боль друг друга, нежели чем у незнакомцев. Мозг человека, у которого его друг получал разряд на его глазах, реагировал на боль почти так же, как если бы электрический удар пришелся на него.\r\nЭто объясняется тем, что хорошая дружба сильно сближает людей, вплоть до эмоционального уровня. Психологи утверждают, что близкие друзья могут стать частью нас самих. И это не красивая метафора, а реальность. Этот факт связан с проблемой выживания и сходства. Чем крепче и дольше отношения, тем друзья становятся более близкими и лучше чувствуют друг друга, в том числе боль и угрозу.");
INSERT INTO forum_t VALUES("152","2","12","Игра, Генетики","324","1592809211","1592809211","0","0","Что будет, если скрестить...  \r\nПравила игры:\r\nМы,неадекватные генетики, скрещиваем всё подряд\r\nПервый участник пишет название двух подопытных экземпляра\r\nВторой придумывает название получившемуся после скрещивания мутанту и называет два других варианта следующему участнику.\r\nНапример:\r\n1-й: Крокодил и панда\r\n2-й: Кропан\r\nАдмин и модер\r\n3-й: Адмод\r\nЖенщина и динозавр...\r\nИ т.д.\r\nСамые оригинальные предложения для генетического преобразования,естественно вознаградим");
INSERT INTO forum_t VALUES("153","2","12","Игра, ищем таланты","324","1592809364","1592809364","0","0","Приглашаем выступить на сцене данной темы \r\nПишите или нуууу,поете любое четверостишие о сайте,и не важно,гугловское оно,или собственное,а мы вам премию в виде \r\n✴✴✴50 рублей\r\n✴✴✴\r\nМалооо?\r\nА пойте больше ");
INSERT INTO forum_t VALUES("154","2","12","Игра готовимся к карантину","324","1592809467","1592809467","0","0","По алфавиту это будем делать чтоб ничего не забыть\r\n✴✴✴\r\nА Б В Г Д Е Ё Ж З И К Л М Н\r\nО П Р С Т У Ф Х Ц Ч Ш Щ Э Ю Я\r\n✴✴✴\r\nПоследнему купившему продукт на =Я=,дадим на закупку \r\n✴✴✴\r\n10 МОНЕТ\r\n✴✴✴\r\nИиии сначала начнем закупать с буквы =А=");
INSERT INTO forum_t VALUES("155","2","12","Игра муз пауза","324","1593334713","1592809607","0","0","Устроим муз.паузу \r\nНо необычно\r\nПлюс заработаем \r\nИтак,начинаем\r\nДОберман\r\nРЕзина\r\nМИмоза\r\nИ т.д.\r\nКому попадет СИ,получает\r\n✴500 монет✴\r\nИ начинаем заново");
INSERT INTO forum_t VALUES("156","2","12","Игра брак на сутки","324","1597692240","1592809856","0","0","УСЛОВИЯ:\r\nВедем счет от 1 до 50\r\n \r\n49 и 50\r\nвступают в брак на СУТКИ!!! \r\n \r\nОт админов сайта\r\nВам скромный сюрпрайз\r\n1000 баллов \r\n500 монет\r\n50 рублей \r\n(при условии,\r\nчто брак простоит сутки)\r\n \r\nP.S:\r\nКто в браке не ставят призовые числа\r\n-За отказ от брака, \r\nкому отказали(кто отказался-передает 1000 баллов и 20 монет) \r\n-Играем по принципу:\r\n-Парень\r\n-Девушка\r\n-Парень и т.д");
INSERT INTO forum_t VALUES("157","2","12","Игра, красная шапочка","324","1593594864","1592810061","0","0","Шапочка держит путь к бабушке а пирожки слямзил волк.\r\n\r\nВаша задача:\r\nНадо собрать пирожки\r\nв количестве 50 штук.\r\n\r\nКто последний соберет\r\n50 пирожок ~тому и приз в руки\r\n5000 баллов\r\n500 монет!!! \r\n \r\nБыстро собираем, друзья!!");
INSERT INTO forum_t VALUES("158","2","12","Игра поцелуи","324","1597647875","1592810170","0","0","Поиграем в Поцелуйки!!! \r\n\r\n\r\n \r\nВедем счет от 1 до 50\r\n \r\n-8 целует10\r\n-15 целует 20\r\n-25 целует 30\r\n-35 целует 40\r\nУ кого выпадает 50\r\nТому дарю 5000 баллов и 500 монет");
INSERT INTO forum_t VALUES("159","3","16","Вопрос всем","488","1592992711","1592992711","0","0","Считается ли флирт и горячая переписка в социальных сетях изменой?");
INSERT INTO forum_t VALUES("160","2","11","Игра - три буквы ","543","1595091806","1593779826","0","0","[background=LawnGreen] \r\n        .разд30. Правила игры: Пишем слова из трёх букв .Например : кот-ток-кит и тд..\r\nсамому активному игроку за пять дней приз:      .5я. рублей.ор.\r\n..разд31.[/background]");



DROP TABLE IF EXISTS `forum_zakl`;

CREATE TABLE `forum_zakl` (
  `id_user` int(11) NOT NULL,
  `id_them` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `time_obn` int(11) NOT NULL,
  KEY `id_user` (`id_user`,`id_them`,`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO forum_zakl VALUES("350","105","1591778223","1591601637");
INSERT INTO forum_zakl VALUES("350","107","1591602557","1591962498");
INSERT INTO forum_zakl VALUES("350","137","1595988780","1597674936");
INSERT INTO forum_zakl VALUES("350","141","1597626801","1597626801");
INSERT INTO forum_zakl VALUES("350","158","1597115914","1597647875");
INSERT INTO forum_zakl VALUES("350","156","1597626940","1597692240");
INSERT INTO forum_zakl VALUES("488","159","1592992718","1592992718");



DROP TABLE IF EXISTS `frends`;

CREATE TABLE `frends` (
  `user` int(11) NOT NULL DEFAULT '0',
  `frend` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  `i` int(1) DEFAULT '0',
  `lenta_forum` int(11) NOT NULL DEFAULT '1',
  `lenta_obmen` int(11) NOT NULL DEFAULT '1',
  `lenta_foto` int(11) NOT NULL DEFAULT '1',
  `lenta_notes` int(11) NOT NULL DEFAULT '1',
  `lenta_avatar` int(11) DEFAULT '1',
  `lenta_frends` int(1) DEFAULT '1',
  `lenta_status` int(1) DEFAULT '1',
  `lenta_status_like` int(1) DEFAULT '1',
  `disc_forum` int(11) NOT NULL DEFAULT '1',
  `disc_obmen` int(11) NOT NULL DEFAULT '1',
  `disc_foto` int(11) NOT NULL DEFAULT '1',
  `disc_notes` int(11) NOT NULL DEFAULT '1',
  `disc_frends` int(1) DEFAULT '1',
  `disc_status` int(1) DEFAULT '1',
  `lenta_poll` int(1) DEFAULT '1',
  `lenta_poll_like` int(1) DEFAULT '1',
  `lenta_poll_vote` int(1) DEFAULT '1',
  PRIMARY KEY (`user`,`frend`),
  KEY `time` (`time`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO frends VALUES("2","10","1562347501","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("10","2","1562347501","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("5","2","1563203474","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("2","5","1563203474","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("29","38","1563986121","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("38","29","1563986121","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("54","53","1564071384","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("53","54","1564071384","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("56","51","1564205902","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("51","56","1564205902","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("17","57","1564237127","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","17","1564237127","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("5","57","1564305427","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","5","1564305427","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("64","51","1564503642","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("51","64","1564503642","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("65","57","1564516350","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","65","1564516350","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("63","57","1564534216","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","63","1564534216","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("58","19","1564595963","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("19","58","1564595963","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("15","57","1564599816","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","15","1564599816","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("70","58","1564627448","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("58","70","1564627448","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("52","38","1564770847","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("38","52","1564770847","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("76","1","1564872255","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","76","1564872255","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("76","51","1564947734","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("51","76","1564947734","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","86","1565113512","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("86","45","1565113512","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("74","93","1565292133","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","74","1565292133","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("56","93","1565299335","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","56","1565299335","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("64","57","1565368565","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","64","1565368565","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("76","64","1565380349","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("64","76","1565380349","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("56","94","1565530281","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("94","56","1565530281","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","38","1565687988","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("38","97","1565687988","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("60","93","1565700929","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","60","1565700929","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","97","1565749067","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","99","1565749067","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","77","1565749070","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("77","99","1565749070","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("43","104","1565962558","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("104","43","1565962558","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("43","93","1566084865","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","43","1566084865","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","57","1566253854","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","45","1566253854","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("74","121","1566902394","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("121","74","1566902394","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","121","1566918548","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("121","57","1566918548","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("123","74","1566985414","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("74","123","1566985414","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("123","97","1566985417","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","123","1566985417","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("74","120","1567010522","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("120","74","1567010522","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("113","93","1567055413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","113","1567055413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("131","54","1567311145","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("54","131","1567311145","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("61","144","1567756976","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("144","61","1567756976","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","147","1567834795","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("147","97","1567834795","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","61","1568005310","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("61","97","1568005310","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("151","147","1568016630","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("147","151","1568016630","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("146","141","1568137936","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("141","146","1568137936","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("97","156","1568203552","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("156","97","1568203552","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("141","156","1568214200","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("156","141","1568214200","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("156","86","1568232449","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("86","156","1568232449","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("156","13","1568239531","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("13","156","1568239531","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("159","141","1568458934","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("141","159","1568458934","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("159","160","1568484356","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("160","159","1568484356","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("141","160","1568507216","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("160","141","1568507216","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","91","1569508195","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("91","170","1569508195","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("34","45","1569519626","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","34","1569519626","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","175","1569606399","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("175","170","1569606399","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("175","176","1569661199","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("176","175","1569661199","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("180","176","1569770215","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("176","180","1569770215","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","170","1569809448","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","99","1569809448","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("183","170","1570044224","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","183","1570044224","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("38","59","1570365884","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("59","38","1570365884","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","186","1570460807","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("186","99","1570460807","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("24","153","1570899978","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("153","24","1570899978","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","186","1570913062","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("186","170","1570913062","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","45","1571219912","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","1","1571219912","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("43","170","1571236747","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("170","43","1571236747","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("27","93","1572118308","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("93","27","1572118308","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("27","45","1572118375","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","27","1572118375","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("27","57","1572118378","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("57","27","1572118378","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("146","137","1572132074","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("137","146","1572132074","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("193","43","1572551133","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("43","193","1572551133","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("218","213","1573042140","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("213","218","1573042140","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("213","172","1573141463","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","213","1573141463","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","172","1573175840","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","99","1573175840","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("218","172","1573202788","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","218","1573202788","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("142","209","1574270230","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("209","142","1574270230","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("226","142","1574308359","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("142","226","1574308359","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("142","227","1574351164","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("227","142","1574351164","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("226","227","1574358933","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("227","226","1574358933","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("56","172","1574440842","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","56","1574440842","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("230","172","1574447734","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","230","1574447734","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("214","27","1574447797","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("27","214","1574447797","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","172","1574488135","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","1","1574488135","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("214","1","1574661779","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","214","1574661779","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("74","172","1574679265","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","74","1574679265","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("217","172","1574784138","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","217","1574784138","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("61","1","1574790313","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","61","1574790313","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("241","172","1574867495","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("172","241","1574867495","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","242","1575161650","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("242","45","1575161650","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("242","214","1575184876","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("214","242","1575184876","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("213","214","1575701264","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("214","213","1575701264","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","247","1576129883","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("247","1","1576129883","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("249","213","1576131515","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("213","249","1576131515","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("213","246","1576142782","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("246","213","1576142782","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("251","45","1576169354","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("45","251","1576169354","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","251","1576248003","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("251","1","1576248003","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","257","1576476366","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("257","1","1576476366","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("256","257","1576488262","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("257","256","1576488262","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("99","257","1576492578","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("257","99","1576492578","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("219","257","1576695184","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("257","219","1576695184","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("331","330","1590776018","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","331","1590776018","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("324","325","1590989723","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("325","324","1590989723","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("345","350","1590989754","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","345","1590989754","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("353","350","1591076224","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","353","1591076224","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("326","330","1591093291","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","326","1591093291","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("358","350","1591112510","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","358","1591112510","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("339","362","1591199761","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","339","1591199761","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","350","1591421737","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","330","1591421737","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","330","1591453181","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","351","1591453181","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("393","362","1591564206","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","393","1591564206","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("399","396","1591622159","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("396","399","1591622159","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("398","350","1591627269","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","398","1591627269","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","362","1591734747","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","351","1591734747","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("402","350","1591771391","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","402","1591771391","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("316","350","1591816291","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","316","1591816291","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("403","339","1591845304","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("339","403","1591845304","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("414","350","1591866534","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","414","1591866534","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("400","350","1591888872","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","400","1591888872","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("418","339","1591948656","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("339","418","1591948656","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","424","1591988664","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","362","1591988664","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("402","424","1592022086","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","402","1592022086","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("391","424","1592025513","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","391","1592025513","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("414","424","1592027069","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","414","1592027069","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","419","1592030966","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("419","362","1592030966","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("426","350","1592032397","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","426","1592032397","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("428","391","1592041667","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("391","428","1592041667","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("425","350","1592048080","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","425","1592048080","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","428","1592054602","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("428","362","1592054602","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("391","362","1592059221","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","391","1592059221","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("355","427","1592067839","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("427","355","1592067839","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("425","424","1592068687","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","425","1592068687","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("435","391","1592191301","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("391","435","1592191301","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("435","350","1592192198","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","435","1592192198","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("430","350","1592194629","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","430","1592194629","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("391","350","1592194799","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","391","1592194799","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("396","362","1592201413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","396","1592201413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("402","362","1592215850","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","402","1592215850","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","402","1592245447","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("402","1","1592245447","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","442","1592323724","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("442","351","1592323724","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("324","362","1592325382","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","324","1592325382","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("396","419","1592365719","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("419","396","1592365719","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("445","444","1592409670","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("444","445","1592409670","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("453","448","1592444529","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("448","453","1592444529","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("435","424","1592448993","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","435","1592448993","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("445","450","1592453864","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("450","445","1592453864","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("396","424","1592464143","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","396","1592464143","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("457","350","1592465691","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","457","1592465691","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("458","350","1592467601","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","458","1592467601","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("358","424","1592492713","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","358","1592492713","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("444","362","1592505384","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","444","1592505384","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("378","424","1592515882","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","378","1592515882","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("324","442","1592558168","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("442","324","1592558168","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("428","435","1592577285","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("435","428","1592577285","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("422","442","1592662202","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("442","422","1592662202","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("464","422","1592673081","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("422","464","1592673081","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("453","445","1592677045","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("445","453","1592677045","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("448","424","1592678031","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","448","1592678031","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("454","351","1592744748","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","454","1592744748","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("487","442","1592842175","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("442","487","1592842175","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("493","350","1592887891","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","493","1592887891","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("320","427","1592927044","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("427","320","1592927044","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("339","424","1593179790","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","339","1593179790","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","505","1593190520","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","506","1593190520","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","344","1593197107","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("344","1","1593197107","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","506","1593197113","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","1","1593197113","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","505","1593197530","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","1","1593197530","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("463","350","1593197977","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","463","1593197977","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("508","1","1593200210","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","508","1593200210","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("508","344","1593200560","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("344","508","1593200560","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("325","1","1593204866","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","325","1593204866","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("497","424","1593214842","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("424","497","1593214842","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("509","350","1593225970","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","509","1593225970","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","350","1593237382","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","1","1593237382","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("422","1","1593243201","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","422","1593243201","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("325","505","1593263084","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","325","1593263084","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("325","506","1593274485","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","325","1593274485","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("324","515","1593276326","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("515","324","1593276326","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","515","1593278410","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("515","1","1593278410","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","516","1593285182","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("516","1","1593285182","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("339","515","1593291155","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("515","339","1593291155","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("511","506","1593319068","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","511","1593319068","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("511","510","1593319072","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("510","511","1593319072","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("519","1","1593331109","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","519","1593331109","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("519","325","1593331470","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("325","519","1593331470","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","506","1593334381","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","512","1593334381","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","505","1593334712","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","512","1593334712","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("520","350","1593350685","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","520","1593350685","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("516","506","1593357011","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","516","1593357011","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("523","350","1593358302","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","523","1593358302","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","350","1593370298","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","512","1593370298","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","528","1593404276","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("528","505","1593404276","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("521","350","1593405905","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","521","1593405905","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("344","533","1593437282","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("533","344","1593437282","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","533","1593437348","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("533","1","1593437348","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("531","350","1593438305","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","531","1593438305","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("527","516","1593455993","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("516","527","1593455993","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("527","1","1593460004","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","527","1593460004","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("535","350","1593499022","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","535","1593499022","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("346","351","1593503488","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","346","1593503488","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","346","1593508258","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("346","505","1593508258","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("534","350","1593530172","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","534","1593530172","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("534","505","1593530174","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","534","1593530174","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","528","1593542508","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("528","1","1593542508","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("491","350","1593641828","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","491","1593641828","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("542","350","1593658463","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","542","1593658463","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("501","350","1593757010","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","501","1593757010","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("501","488","1593757013","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("488","501","1593757013","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("543","350","1593766630","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","543","1593766630","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("543","1","1593769164","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","543","1593769164","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("432","512","1593778076","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","432","1593778076","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("533","505","1593803552","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","533","1593803552","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","533","1593895733","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("533","506","1593895733","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","533","1593896716","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("533","512","1593896716","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","422","1593927420","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("422","362","1593927420","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("432","505","1593951874","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","432","1593951874","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","506","1593952869","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","362","1593952869","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("552","512","1593955883","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("512","552","1593955883","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","473","1593957510","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("473","1","1593957510","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("362","505","1593963853","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","362","1593963853","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("516","528","1593976958","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("528","516","1593976958","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("355","1","1593989869","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","355","1593989869","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("432","433","1594221589","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("433","432","1594221589","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("558","505","1594222855","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","558","1594222855","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("561","505","1594263207","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","561","1594263207","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("561","350","1594264947","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","561","1594264947","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("561","506","1594266002","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","561","1594266002","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("560","350","1594268273","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","560","1594268273","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("559","350","1594293400","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","559","1594293400","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("562","505","1594413076","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("505","562","1594413076","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("402","271","1594576079","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("271","402","1594576079","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("564","350","1594666895","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","564","1594666895","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("562","350","1594723814","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","562","1594723814","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("534","473","1594736483","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("473","534","1594736483","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("565","506","1594847453","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","565","1594847453","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("567","350","1594907901","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","567","1594907901","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("355","516","1594960244","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("516","355","1594960244","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","355","1594962990","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("355","550","1594962990","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","560","1594965752","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("560","550","1594965752","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("433","506","1595045094","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("506","433","1595045094","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("514","554","1595057587","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("554","514","1595057587","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("570","554","1595060410","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("554","570","1595060410","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("281","330","1595071645","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","281","1595071645","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("572","350","1595131891","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","572","1595131891","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("577","550","1595211600","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","577","1595211600","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("573","350","1595274412","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","573","1595274412","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("508","320","1595356352","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("320","508","1595356352","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("584","576","1595498281","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("576","584","1595498281","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","584","1595507653","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("584","550","1595507653","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","585","1595526413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("585","550","1595526413","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("584","330","1595533090","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","584","1595533090","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("425","584","1595534085","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("584","425","1595534085","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("585","431","1595610253","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("431","585","1595610253","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","554","1595630531","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("554","330","1595630531","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("550","330","1595672699","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","550","1595672699","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("507","330","1595674225","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","507","1595674225","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("576","431","1595694652","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("431","576","1595694652","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","584","1595705461","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("584","1","1595705461","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("403","330","1596081239","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","403","1596081239","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("589","351","1596208070","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("351","589","1596208070","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("425","554","1596285354","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("554","425","1596285354","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("433","554","1596301875","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("554","433","1596301875","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("557","330","1596367940","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("330","557","1596367940","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("497","422","1596540813","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("422","497","1596540813","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("416","350","1596693312","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","416","1596693312","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","593","1596742163","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("593","1","1596742163","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","598","1597348306","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("598","1","1597348306","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","594","1597428524","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("594","1","1597428524","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("595","350","1597498215","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("350","595","1597498215","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","320","1597503605","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("320","1","1597503605","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","602","1597521031","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("602","1","1597521031","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","605","1597522111","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("605","1","1597522111","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("607","1","1597530019","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","607","1597530019","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("608","607","1597533863","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("607","608","1597533863","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("603","605","1597549791","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("605","603","1597549791","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("1","609","1597566611","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("609","1","1597566611","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("611","602","1597575822","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("602","611","1597575822","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("320","608","1597666815","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");
INSERT INTO frends VALUES("608","320","1597666815","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1","1");



DROP TABLE IF EXISTS `frends_new`;

CREATE TABLE `frends_new` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `to` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `time` (`time`)
) ENGINE=MyISAM AUTO_INCREMENT=527 DEFAULT CHARSET=utf8 COLLATE=utf8_unicode_ci;

INSERT INTO frends_new VALUES("1","1","7","1561796576");
INSERT INTO frends_new VALUES("9","1","18","1563479288");
INSERT INTO frends_new VALUES("10","22","23","1563664462");
INSERT INTO frends_new VALUES("21","57","48","1564236966");
INSERT INTO frends_new VALUES("36","38","44","1564695942");
INSERT INTO frends_new VALUES("37","38","73","1564724421");
INSERT INTO frends_new VALUES("63","77","17","1565560999");
INSERT INTO frends_new VALUES("68","104","108","1566040382");
INSERT INTO frends_new VALUES("104","45","169","1569259552");
INSERT INTO frends_new VALUES("110","176","121","1569830125");
INSERT INTO frends_new VALUES("114","38","32","1570366494");
INSERT INTO frends_new VALUES("117","186","167","1570454609");
INSERT INTO frends_new VALUES("119","186","183","1570461053");
INSERT INTO frends_new VALUES("126","113","204","1572339620");
INSERT INTO frends_new VALUES("127","209","180","1572653002");
INSERT INTO frends_new VALUES("135","172","211","1573140193");
INSERT INTO frends_new VALUES("139","213","222","1573724179");
INSERT INTO frends_new VALUES("143","1","224","1574257430");
INSERT INTO frends_new VALUES("144","172","17","1574268846");
INSERT INTO frends_new VALUES("150","229","186","1574458473");
INSERT INTO frends_new VALUES("175","257","255","1576389331");
INSERT INTO frends_new VALUES("176","257","252","1576389365");
INSERT INTO frends_new VALUES("177","257","243","1576389430");
INSERT INTO frends_new VALUES("178","257","233","1576389475");
INSERT INTO frends_new VALUES("179","257","230","1576389512");
INSERT INTO frends_new VALUES("181","257","218","1576389580");
INSERT INTO frends_new VALUES("182","257","216","1576389639");
INSERT INTO frends_new VALUES("183","257","207","1576389688");
INSERT INTO frends_new VALUES("184","257","202","1576389729");
INSERT INTO frends_new VALUES("185","257","197","1576389763");
INSERT INTO frends_new VALUES("186","257","194","1576389794");
INSERT INTO frends_new VALUES("187","257","190","1576389820");
INSERT INTO frends_new VALUES("188","257","182","1576389869");
INSERT INTO frends_new VALUES("189","257","180","1576389896");
INSERT INTO frends_new VALUES("190","257","167","1576389960");
INSERT INTO frends_new VALUES("191","257","156","1576390027");
INSERT INTO frends_new VALUES("192","257","153","1576390048");
INSERT INTO frends_new VALUES("193","257","152","1576390075");
INSERT INTO frends_new VALUES("194","257","150","1576390107");
INSERT INTO frends_new VALUES("195","257","149","1576390125");
INSERT INTO frends_new VALUES("196","257","148","1576390150");
INSERT INTO frends_new VALUES("197","257","141","1576390205");
INSERT INTO frends_new VALUES("198","257","126","1576390288");
INSERT INTO frends_new VALUES("199","257","115","1576390414");
INSERT INTO frends_new VALUES("202","172","149","1577025543");
INSERT INTO frends_new VALUES("205","299","300","1585336485");
INSERT INTO frends_new VALUES("239","350","372","1591258166");
INSERT INTO frends_new VALUES("255","324","404","1591734887");
INSERT INTO frends_new VALUES("257","403","409","1591820091");
INSERT INTO frends_new VALUES("270","424","267","1591985048");
INSERT INTO frends_new VALUES("275","424","353","1591988548");
INSERT INTO frends_new VALUES("280","424","398","1592018788");
INSERT INTO frends_new VALUES("281","424","404","1592019268");
INSERT INTO frends_new VALUES("295","350","429","1592106076");
INSERT INTO frends_new VALUES("316","424","445","1592419709");
INSERT INTO frends_new VALUES("323","362","447","1592483554");
INSERT INTO frends_new VALUES("337","350","477","1592709549");
INSERT INTO frends_new VALUES("346","350","500","1593051246");
INSERT INTO frends_new VALUES("347","350","446","1593051585");
INSERT INTO frends_new VALUES("385","350","341","1593348874");
INSERT INTO frends_new VALUES("395","459","530","1593416513");
INSERT INTO frends_new VALUES("396","350","488","1593420068");
INSERT INTO frends_new VALUES("407","519","538","1593587913");
INSERT INTO frends_new VALUES("412","363","289","1593771072");
INSERT INTO frends_new VALUES("426","350","556","1594003013");
INSERT INTO frends_new VALUES("427","528","466","1594066441");
INSERT INTO frends_new VALUES("437","1","559","1594391791");
INSERT INTO frends_new VALUES("453","554","574","1595126879");
INSERT INTO frends_new VALUES("454","403","574","1595131100");
INSERT INTO frends_new VALUES("455","350","574","1595131535");
INSERT INTO frends_new VALUES("474","586","341","1595817968");
INSERT INTO frends_new VALUES("475","586","4","1595818181");
INSERT INTO frends_new VALUES("476","586","278","1595818253");
INSERT INTO frends_new VALUES("478","330","586","1595987246");
INSERT INTO frends_new VALUES("480","330","587","1596089961");
INSERT INTO frends_new VALUES("486","431","274","1596390106");
INSERT INTO frends_new VALUES("496","578","282","1597523886");
INSERT INTO frends_new VALUES("498","607","512","1597530122");
INSERT INTO frends_new VALUES("499","607","4","1597530142");
INSERT INTO frends_new VALUES("500","607","281","1597530158");
INSERT INTO frends_new VALUES("501","607","282","1597530172");
INSERT INTO frends_new VALUES("502","607","514","1597530327");
INSERT INTO frends_new VALUES("503","607","573","1597530972");
INSERT INTO frends_new VALUES("504","607","330","1597531009");
INSERT INTO frends_new VALUES("505","607","283","1597531065");
INSERT INTO frends_new VALUES("506","607","344","1597531523");
INSERT INTO frends_new VALUES("513","609","589","1597546029");
INSERT INTO frends_new VALUES("524","602","613","1597585845");
INSERT INTO frends_new VALUES("525","605","289","1597659009");



DROP TABLE IF EXISTS `friends`;

CREATE TABLE `friends` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user` int(11) NOT NULL DEFAULT '0',
  `who` int(11) NOT NULL DEFAULT '0',
  `zajavka` smallint(2) NOT NULL DEFAULT '0',
  `group` char(15) NOT NULL,
  `friendtext` char(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `g_rajt`;

CREATE TABLE `g_rajt` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL DEFAULT '0',
  `id_ank` int(11) NOT NULL DEFAULT '0',
  `ocenka` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gallery`;

CREATE TABLE `gallery` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_user` int(11) NOT NULL,
  `name` varchar(32) NOT NULL,
  `time_create` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `opis` varchar(256) NOT NULL,
  `pass` varchar(11) DEFAULT NULL,
  `privat` int(11) NOT NULL,
  `privat_komm` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_user` (`id_user`)
) ENGINE=MyISAM AUTO_INCREMENT=346 DEFAULT CHARSET=utf8;

INSERT INTO gallery VALUES("1","271","Ghgggg","1581698549","1581698588","","","0","0");
INSERT INTO gallery VALUES("317","1","Картинки","1596164199","1596166643","","","0","0");
INSERT INTO gallery VALUES("3","274","Фотки","1581719571","1581721208","","","1","1");
INSERT INTO gallery VALUES("4","269","Strong ","1581727685","1581727715","Strong ","","0","0");
INSERT INTO gallery VALUES("5","273","Avatar","1581769063","1581769125","","","2","2");
INSERT INTO gallery VALUES("6","278","Foto1","1581876535","1581876550","","","1","1");
INSERT INTO gallery VALUES("7","279","Moи","1582277276","1582277369","","","0","0");
INSERT INTO gallery VALUES("8","281","Angel","1582388522","1595071755","Qwer","","0","0");
INSERT INTO gallery VALUES("9","283","Image","1582495013","1595055801","","","1","1");
INSERT INTO gallery VALUES("10","288","hdhdhdu","1584194696","1595073907","","","0","0");
INSERT INTO gallery VALUES("11","290","аватарки","1584339851","1584339944","","","1","0");
INSERT INTO gallery VALUES("14","293","так","1584601894","1584601894","","","0","0");
INSERT INTO gallery VALUES("15","294","ava","1584629345","1584629477","","","0","0");
INSERT INTO gallery VALUES("16","295","Ава","1584727242","1584727286","","","0","0");
INSERT INTO gallery VALUES("17","298","Ава","1584869027","1593018419","","","1","1");
INSERT INTO gallery VALUES("18","299","Трон","1585308564","1585308664","","","0","0");
INSERT INTO gallery VALUES("19","300","Фиалка","1585335002","1585335184","","","0","0");
INSERT INTO gallery VALUES("20","302","UIGBLO","1585695904","1585695927","","","0","0");
INSERT INTO gallery VALUES("22","308","Яааа","1586109487","1586109572","","","0","0");
INSERT INTO gallery VALUES("23","309","приколы ","1586117915","1586117954","","","0","0");
INSERT INTO gallery VALUES("24","307","Бдлл","1586146463","1586146482","Ллшшш","","2","2");
INSERT INTO gallery VALUES("25","310","fgf","1586161142","1586161205","","","0","0");
INSERT INTO gallery VALUES("26","300","Елизавета","1586339692","1586339962","","","0","0");
INSERT INTO gallery VALUES("27","312","Тут","1586526239","1591167796","","","0","0");
INSERT INTO gallery VALUES("30","315","потом","1587401367","1587401385","jhk","","1","1");
INSERT INTO gallery VALUES("31","316","Фото","1587722451","1589567190","","","2","2");
INSERT INTO gallery VALUES("32","318","Shhshdb","1588585226","1588585251","Bdhdhdb","","0","0");
INSERT INTO gallery VALUES("33","319","Ведьмочка","1588880819","1588880819","","","1","0");
INSERT INTO gallery VALUES("34","320"," ава","1589572673","1597517258","","","0","0");
INSERT INTO gallery VALUES("35","321","Ава","1590087763","1590087800","","","0","0");
INSERT INTO gallery VALUES("36","322","Авы","1590164734","1590164748","","","0","0");
INSERT INTO gallery VALUES("37","323","Avatar","1590558721","1590558735","","","0","0");
INSERT INTO gallery VALUES("219","508","Вот он я","1593199853","1593199881","","","0","0");
INSERT INTO gallery VALUES("47","336",".....","1590837884","1590838148","","","0","0");
INSERT INTO gallery VALUES("40","326","авка","1590606168","1590606230","","","0","0");
INSERT INTO gallery VALUES("41","327","Разное","1590607155","1590607155","","","0","0");
INSERT INTO gallery VALUES("45","333","Праетипитритоь","1590696785","1590696785","","","0","0");
INSERT INTO gallery VALUES("44","330","Фото","1590679590","1596509988","","","0","0");
INSERT INTO gallery VALUES("46","331","..... ","1590776154","1590776202","","","0","0");
INSERT INTO gallery VALUES("48","338","Фото","1590917043","1590917256","","","0","0");
INSERT INTO gallery VALUES("49","339","Просто так ","1590918084","1593160763","","","0","0");
INSERT INTO gallery VALUES("50","341","Фото","1590923391","1590923519","","","1","1");
INSERT INTO gallery VALUES("51","342","ящик для фото","1590927502","1590927698","","","2","2");
INSERT INTO gallery VALUES("52","343","Ава","1590943333","1590943377","","","0","0");
INSERT INTO gallery VALUES("54","345","Fggghf","1590947785","1590947946","","","0","0");
INSERT INTO gallery VALUES("55","346","АЛЬБОМ","1590951023","1591023062","","","2","2");
INSERT INTO gallery VALUES("57","347","Foto","1590965287","1590965446","","","1","1");
INSERT INTO gallery VALUES("58","349","3333333","1590977223","1590977247","","","2","2");
INSERT INTO gallery VALUES("59","350","345#","1590988541","1590988604","","","2","2");
INSERT INTO gallery VALUES("60","353","Просто","1591034293","1591034388","","","0","0");
INSERT INTO gallery VALUES("61","354","Яяяяяяя","1591042073","1591042139","Чччччччч","","0","0");
INSERT INTO gallery VALUES("62","355","Просто так","1591050431","1593033158","","","0","0");
INSERT INTO gallery VALUES("64","351","Рррр","1591102682","1593592672","","","1","0");
INSERT INTO gallery VALUES("65","358","Misty","1591107763","1591107823","","","0","0");
INSERT INTO gallery VALUES("71","364","ЛЕВ","1591150371","1591150429","","","0","0");
INSERT INTO gallery VALUES("214","362","Ава","1593110583","1593110638","","","1","1");
INSERT INTO gallery VALUES("69","363","Avatarka","1591124845","1593770786","","","0","0");
INSERT INTO gallery VALUES("70","361","Альбом","1591145144","1591145212","","","0","0");
INSERT INTO gallery VALUES("72","365","Ava","1591167865","1591167918","","","0","0");
INSERT INTO gallery VALUES("73","366","Как то так","1591168627","1591168657","","","0","0");
INSERT INTO gallery VALUES("74","360","Ммм","1591176518","1591176589","","","0","0");
INSERT INTO gallery VALUES("75","367","Альбом","1591178608","1591178632","","","2","2");
INSERT INTO gallery VALUES("76","368","Ава","1591180584","1591180604","","","1","1");
INSERT INTO gallery VALUES("87","377","Raznoe","1591292753","1591292885","","","0","0");
INSERT INTO gallery VALUES("78","371","fts","1591205733","1591205756","","","0","0");
INSERT INTO gallery VALUES("79","372","Ава","1591212174","1591212206","","","0","0");
INSERT INTO gallery VALUES("80","370","Фото","1591213683","1591213714","","","0","0");
INSERT INTO gallery VALUES("81","373","✽ ","1591256224","1591352186","","nexlazat$§","0","0");
INSERT INTO gallery VALUES("83","376","Бородач","1591276205","1591276216","","","0","0");
INSERT INTO gallery VALUES("84","378","Hjkk","1591280576","1591280631","","","0","0");
INSERT INTO gallery VALUES("85","380","Фото","1591286527","1591286641","","","2","2");
INSERT INTO gallery VALUES("86","379","blonda","1591287655","1591287733","ava","","1","1");
INSERT INTO gallery VALUES("88","382","Yaa","1591300999","1591301025","","","0","0");
INSERT INTO gallery VALUES("89","383","Ава","1591305080","1591305167","Ава","","0","0");
INSERT INTO gallery VALUES("90","384","Supergif","1591348069","1591348082","","","1","1");
INSERT INTO gallery VALUES("91","386","5555555","1591436483","1591436503","","","0","0");
INSERT INTO gallery VALUES("92","387","Альбом","1591438035","1591438060","","","0","0");
INSERT INTO gallery VALUES("93","388","Ето я","1591446099","1591446257","","","1","1");
INSERT INTO gallery VALUES("94","388","Маё","1591454750","1591454814","","","1","1");
INSERT INTO gallery VALUES("95","391","Girl Style ","1591540594","1592312739","589t4","","0","0");
INSERT INTO gallery VALUES("96","393","54455555","1591560755","1591560966","","","2","2");
INSERT INTO gallery VALUES("97","394","Разное","1591583512","1591583539","","","0","0");
INSERT INTO gallery VALUES("106","403","Vsp","1591641925","1591641968","","","0","0");
INSERT INTO gallery VALUES("99","396","Мой альбом","1591617932","1591623405","","","0","0");
INSERT INTO gallery VALUES("100","397","Сделать главной","1591618217","1591618369","","","0","0");
INSERT INTO gallery VALUES("101","398","@@@","1591619768","1591620524","","","0","0");
INSERT INTO gallery VALUES("102","399","Ава","1591621395","1591625105","","","0","0");
INSERT INTO gallery VALUES("103","400","Фото","1591627004","1591627046","","","0","0");
INSERT INTO gallery VALUES("105","402","...","1591639320","1591639965","","","1","1");
INSERT INTO gallery VALUES("107","405","Моё фото","1591737847","1591737916","Эт я","","0","0");
INSERT INTO gallery VALUES("108","406","картинка","1591740680","1591740698","","","0","0");
INSERT INTO gallery VALUES("109","407","Ава","1591772954","1591773003","","","0","0");
INSERT INTO gallery VALUES("110","409","Ava","1591776445","1591776478","","","2","0");
INSERT INTO gallery VALUES("111","405","Фото","1591776690","1591776722","Моё фото","","0","0");
INSERT INTO gallery VALUES("112","411","Моё!","1591843378","1591843516","","","0","0");
INSERT INTO gallery VALUES("113","411","Улыбнись !","1591843854","1591853807","","","0","0");
INSERT INTO gallery VALUES("114","401","Ната","1591854548","1591854585","","","0","0");
INSERT INTO gallery VALUES("139","432","111111","1592155060","1592155105","","","0","0");
INSERT INTO gallery VALUES("116","415","✓ЗОЛОТАЯ РЫБКА✓","1591876283","1591876304","","","0","0");
INSERT INTO gallery VALUES("146","433","Ава","1592258654","1595744695","","","0","0");
INSERT INTO gallery VALUES("119","418","Lpog","1591947394","1591947542","","","0","0");
INSERT INTO gallery VALUES("124","419","FOTOSHOK","1591961891","1591961992","","","0","0");
INSERT INTO gallery VALUES("122","420","Хочу","1591956535","1591956556","","","0","0");
INSERT INTO gallery VALUES("123","421","Фото ","1591958791","1591958846","","","0","0");
INSERT INTO gallery VALUES("126","422","Аватар","1591975417","1592516480","","","0","0");
INSERT INTO gallery VALUES("127","423","Вот...","1591978795","1591978875","...","","0","0");
INSERT INTO gallery VALUES("128","424","мой","1591984508","1592018667","","","1","1");
INSERT INTO gallery VALUES("129","425","Ava","1591993405","1595535061","","","0","0");
INSERT INTO gallery VALUES("130","426","Ава","1591996588","1591996621","","","0","0");
INSERT INTO gallery VALUES("132","427","SEGAL","1592029319","1592029437","","","0","0");
INSERT INTO gallery VALUES("135","429","578456","1592104651","1592104963","","","0","0");
INSERT INTO gallery VALUES("136","430","Темень","1592116125","1592116198","","","0","0");
INSERT INTO gallery VALUES("138","431","Милый ангел.","1592140419","1596469559","","","0","0");
INSERT INTO gallery VALUES("140","434","11111111@1","1592160927","1592246786","","","0","0");
INSERT INTO gallery VALUES("141","435","Млплил","1592182865","1592182940","","","1","1");
INSERT INTO gallery VALUES("142","416","Vvvvvvvvv","1592206464","1592206518","","","0","0");
INSERT INTO gallery VALUES("143","437","Авка","1592214434","1592214463","","","1","1");
INSERT INTO gallery VALUES("144","436","Ава","1592216674","1592216715","","","0","0");
INSERT INTO gallery VALUES("145","391","Фото ","1592220562","1592220590","Фото ","","1","1");
INSERT INTO gallery VALUES("147","440","Чего то там","1592266404","1592266458","Без описания","","0","0");
INSERT INTO gallery VALUES("149","442","Авка","1592310982","1592394438","","","1","0");
INSERT INTO gallery VALUES("152","444","Avk","1592389950","1592420227","","","0","0");
INSERT INTO gallery VALUES("153","445","...","1592390264","1592494497","","","1","0");
INSERT INTO gallery VALUES("154","447","1967","1592402901","1592402945","","","0","0");
INSERT INTO gallery VALUES("155","451","Ава","1592412658","1592412836","","","0","0");
INSERT INTO gallery VALUES("156","452","мое","1592414843","1592414865","","","0","0");
INSERT INTO gallery VALUES("157","453","Воадаб","1592416112","1592660956","","","1","1");
INSERT INTO gallery VALUES("158","454","Avka","1592418210","1592418233","","","1","1");
INSERT INTO gallery VALUES("159","455","arhiv$$$","1592420675","1592420713","","","2","2");
INSERT INTO gallery VALUES("160","448","Онлайн))","1592421421","1592421480","","","2","2");
INSERT INTO gallery VALUES("161","456","albom","1592445482","1592445482","","","1","1");
INSERT INTO gallery VALUES("162","457","разное","1592450672","1592450747","","","0","0");
INSERT INTO gallery VALUES("163","450","Djdk","1592452255","1592452281","","","0","0");
INSERT INTO gallery VALUES("164","458","Ава","1592458850","1592458863","","46009642114","1","0");
INSERT INTO gallery VALUES("165","461","Ава","1592472183","1592472202","","","0","0");
INSERT INTO gallery VALUES("166","444","Статусы","1592476031","1592476072","","","0","0");
INSERT INTO gallery VALUES("167","463","Ава","1592490053","1595081124","","","0","0");
INSERT INTO gallery VALUES("168","464","Мои Новые Новенькие Аватарочки.","1592499831","1592499927","","","0","0");
INSERT INTO gallery VALUES("169","464","Мои Фотографии","1592500114","1592500187","","","0","0");
INSERT INTO gallery VALUES("170","465","Ава","1592503038","1592503053","","","2","2");
INSERT INTO gallery VALUES("171","466","Авва","1592548711","1592548866","","","2","0");
INSERT INTO gallery VALUES("173","468","TroY","1592581743","1592581778","","","0","0");
INSERT INTO gallery VALUES("174","470","foto","1592589283","1592589283","","","0","0");
INSERT INTO gallery VALUES("175","469","+++++","1592592074","1592592137","","","0","0");
INSERT INTO gallery VALUES("178","474","Яяя","1592652249","1592652665","Мои","","0","0");
INSERT INTO gallery VALUES("177","473","Хостер","1592608843","1592608926","","","1","1");
INSERT INTO gallery VALUES("180","449","@@@@","1592670705","1592671215","","","0","0");
INSERT INTO gallery VALUES("181","475","На аву","1592676569","1592676591","","","0","0");
INSERT INTO gallery VALUES("182","476","111","1592677804","1592677855","","","0","0");
INSERT INTO gallery VALUES("183","477","))) ","1592691480","1592691499","","","1","1");
INSERT INTO gallery VALUES("184","472","AvaTS","1592695673","1592695740","","","0","0");
INSERT INTO gallery VALUES("185","375","фото","1592715273","1592715758","","","0","0");
INSERT INTO gallery VALUES("186","356","Мой","1592721351","1592721384","","","0","0");
INSERT INTO gallery VALUES("187","479","love","1592722412","1592722523","","","1","1");
INSERT INTO gallery VALUES("188","480","Прр","1592722707","1592722742","","","0","0");
INSERT INTO gallery VALUES("189","481","тто","1592724931","1592724931","","","0","0");
INSERT INTO gallery VALUES("190","482","Gduebdh","1592728282","1592728341","","","0","0");
INSERT INTO gallery VALUES("191","483","Яяя","1592729098","1592729126","","","0","0");
INSERT INTO gallery VALUES("192","484","Ava","1592732950","1592733472","","","0","0");
INSERT INTO gallery VALUES("196","487","Ава","1592763411","1592904164","","","2","2");
INSERT INTO gallery VALUES("197","488","Люблю себя","1592771478","1592771516","","","0","0");
INSERT INTO gallery VALUES("198","489","Ава","1592814832","1592814919","","","1","1");
INSERT INTO gallery VALUES("199","492","разное","1592846482","1594858109","","","0","0");
INSERT INTO gallery VALUES("200","493","Ава","1592848613","1592848642","","","0","0");
INSERT INTO gallery VALUES("250","534","moy","1593458390","1593530300","","","1","1");
INSERT INTO gallery VALUES("202","494","Ava","1592885474","1592885505","","","0","0");
INSERT INTO gallery VALUES("203","495","Ни о чем ","1592897796","1592898101","","","0","0");
INSERT INTO gallery VALUES("204","488","Взгляд жизни","1592912445","1593079479","","","0","0");
INSERT INTO gallery VALUES("205","497","разное","1592931909","1592931982","","","0","0");
INSERT INTO gallery VALUES("206","395","Фото","1592934299","1592934299","","","0","0");
INSERT INTO gallery VALUES("207","498","ghjjyr","1592950764","1592950764","nnvcxc","","0","0");
INSERT INTO gallery VALUES("208","499","Мой","1592954449","1592954501","","","0","0");
INSERT INTO gallery VALUES("209","500","Ххххххх","1592966922","1592966945","","","2","2");
INSERT INTO gallery VALUES("218","507","фото","1593197356","1593197569","","","0","0");
INSERT INTO gallery VALUES("211","501","Кисс","1592991661","1592991708","","","0","0");
INSERT INTO gallery VALUES("212","502","яяя","1593063514","1593063536","","","0","0");
INSERT INTO gallery VALUES("234","519","Мои фото","1593328061","1593940763","","","0","0");
INSERT INTO gallery VALUES("261","516","ГрЕшНиЦа","1593706700","1596275079","","","0","0");
INSERT INTO gallery VALUES("241","529","ххх","1593381440","1593381583","","","0","0");
INSERT INTO gallery VALUES("223","510","Мой","1593208329","1593208369","","","0","0");
INSERT INTO gallery VALUES("224","1","Гифки ","1593213441","1597606433","","","1","1");
INSERT INTO gallery VALUES("257","511","Авки","1593621118","1595789766","","","0","0");
INSERT INTO gallery VALUES("226","512","Авка","1593247990","1593248007","","","0","0");
INSERT INTO gallery VALUES("227","459","////////","1593255694","1593255724","","","2","2");
INSERT INTO gallery VALUES("228","513","Ава","1593258570","1593258589","","","0","0");
INSERT INTO gallery VALUES("229","514","Бот","1593269898","1595057735","","","0","0");
INSERT INTO gallery VALUES("230","515","Юра","1593272307","1593272307","","","0","0");
INSERT INTO gallery VALUES("312","585","Личное","1595520748","1595785146","@@@@","","0","0");
INSERT INTO gallery VALUES("258","542","Юлечка","1593632811","1597504218","","","0","0");
INSERT INTO gallery VALUES("233","518","Ава","1593312057","1593312261","","","0","0");
INSERT INTO gallery VALUES("235","520","Destiny","1593328872","1593328918","Destiny","","1","1");
INSERT INTO gallery VALUES("236","522","парк","1593347284","1593350913","","","0","0");
INSERT INTO gallery VALUES("237","523","авки","1593359428","1593359592",".цветок2.","","0","0");
INSERT INTO gallery VALUES("244","531","Это я ","1593423468","1593494321","","","0","0");
INSERT INTO gallery VALUES("239","524","ford","1593362820","1593362860","","","0","0");
INSERT INTO gallery VALUES("240","528","Ава","1593375495","1593375571","","","0","0");
INSERT INTO gallery VALUES("242","498","trfxvhj","1593381934","1593382241","jhgvv","","0","0");
INSERT INTO gallery VALUES("243","530","Kkoo","1593416709","1593416730","","","0","0");
INSERT INTO gallery VALUES("245","532","Avatara ","1593427993","1593428026","","","2","2");
INSERT INTO gallery VALUES("247","344","Qweasd","1593433725","1593433756","","","0","0");
INSERT INTO gallery VALUES("248","527","Авка","1593455859","1593455881","","","0","0");
INSERT INTO gallery VALUES("264","544","жесть ","1593763720","1593763863","","","2","2");
INSERT INTO gallery VALUES("251","535","Ава","1593460149","1593460215","","","0","0");
INSERT INTO gallery VALUES("252","536","Ава","1593527294","1593527320","","","0","0");
INSERT INTO gallery VALUES("253","538","Брр","1593587643","1593587758","Брр","","0","0");
INSERT INTO gallery VALUES("254","539","Аватар ","1593590459","1593590500","","","0","0");
INSERT INTO gallery VALUES("262","543","Альбом","1593751696","1593751901","","","0","0");
INSERT INTO gallery VALUES("321","541","Bon_jor_no ","1596397198","1596753819","","","0","0");
INSERT INTO gallery VALUES("259","491",")))) ","1593641775","1593641800","","","0","0");
INSERT INTO gallery VALUES("260","533","Фото","1593664023","1593664405","","","2","2");
INSERT INTO gallery VALUES("265","545","Картинки","1593775705","1593775752","","","0","0");
INSERT INTO gallery VALUES("266","546","543567","1593778816","1593778831","","","0","0");
INSERT INTO gallery VALUES("267","547","Ппп","1593787704","1593787739","","","0","0");
INSERT INTO gallery VALUES("268","540","====","1593795828","1593935588","","","0","0");
INSERT INTO gallery VALUES("270","8","Кукусики","1593840906","1593841053","","","0","0");
INSERT INTO gallery VALUES("271","521","Авки","1593856408","1593856458","","","0","0");
INSERT INTO gallery VALUES("272","549","Авка","1593857620","1593857660","","","0","0");
INSERT INTO gallery VALUES("273","509","яяяя","1593873485","1593873485","в парке","","0","0");
INSERT INTO gallery VALUES("274","550","Давай Намутим","1593940025","1596044415","","","0","0");
INSERT INTO gallery VALUES("275","552","Аватар","1593953898","1593953980","","","2","0");
INSERT INTO gallery VALUES("276","553","Аватар","1593954965","1593955011","","","0","0");
INSERT INTO gallery VALUES("277","533","Ava","1593966511","1594065895","","","1","1");
INSERT INTO gallery VALUES("278","555","Тест","1593970254","1593970295","Ген","","0","0");
INSERT INTO gallery VALUES("279","556","Альбом","1593970794","1593970962","","","2","2");
INSERT INTO gallery VALUES("280","554","запечатлели","1593976641","1594666325","","","0","0");
INSERT INTO gallery VALUES("281","554","такое оно бывает","1594064141","1594064217","","","0","0");
INSERT INTO gallery VALUES("282","558","Вип","1594204365","1594204404","","","0","0");
INSERT INTO gallery VALUES("283","559","Просто Я))) ","1594205842","1594205915","","","0","0");
INSERT INTO gallery VALUES("284","560","Авки","1594236894","1594237065","","","0","0");
INSERT INTO gallery VALUES("285","561","Авка","1594262588","1594262664","","","0","0");
INSERT INTO gallery VALUES("286","562","Ава","1594412863","1594412914","","","1","1");
INSERT INTO gallery VALUES("287","509","яяя","1594446321","1594446457","еу я это, и что?","","0","0");
INSERT INTO gallery VALUES("288","564","Альбом ","1594580759","1594580804","","","0","0");
INSERT INTO gallery VALUES("289","565","Просто так ","1594794339","1594797936","","","0","0");
INSERT INTO gallery VALUES("290","567","ava","1594826010","1594826076","","","0","0");
INSERT INTO gallery VALUES("291","568","Аватар","1594897580","1594897741","","","1","1");
INSERT INTO gallery VALUES("292","282","Вах","1595020247","1595020276","","","0","0");
INSERT INTO gallery VALUES("293","569","Д....","1595032766","1595033172","","","0","0");
INSERT INTO gallery VALUES("294","4","Для Тебя","1595055476","1595055499","","","2","2");
INSERT INTO gallery VALUES("295","570","Кокаинка","1595059575","1595059604","","","2","2");
INSERT INTO gallery VALUES("296","286","Федя","1595072097","1595072130","","","2","2");
INSERT INTO gallery VALUES("297","287","Красавчик","1595072818","1595072881","","","2","2");
INSERT INTO gallery VALUES("298","571","Ava","1595075693","1595075716","","","2","2");
INSERT INTO gallery VALUES("299","572","Авчик","1595079596","1595079811","","","0","0");
INSERT INTO gallery VALUES("300","575","Ящик для фото ","1595142193","1595142321","","","2","2");
INSERT INTO gallery VALUES("301","506","авка","1595144075","1595144138","","","0","0");
INSERT INTO gallery VALUES("302","557","ava","1595172573","1595172640","","","2","2");
INSERT INTO gallery VALUES("303","577","Ава","1595211420","1595211482","Аватарка","","0","0");
INSERT INTO gallery VALUES("304","526","Хххх","1595224868","1595224893","","","0","0");
INSERT INTO gallery VALUES("305","579","Qeer","1595249353","1595249428","","","0","0");
INSERT INTO gallery VALUES("306","580","Просто","1595252310","1595252436","","","0","0");
INSERT INTO gallery VALUES("307","507","ххх","1595263182","1595317546","","","1","1");
INSERT INTO gallery VALUES("308","582","VIP","1595330714","1595330729","","","0","0");
INSERT INTO gallery VALUES("309","583","Ннннн","1595343271","1595343304","","","0","0");
INSERT INTO gallery VALUES("310","584","Альбом","1595488847","1595488897","","","0","0");
INSERT INTO gallery VALUES("315","585","Юмор","1596126762","1596126762","","","0","0");
INSERT INTO gallery VALUES("313","586","Ава","1595734618","1595734741","","","0","0");
INSERT INTO gallery VALUES("314","587","Gorno","1595738421","1595738490","","","0","0");
INSERT INTO gallery VALUES("316","585","Приветствия","1596126792","1596126792","","","0","0");
INSERT INTO gallery VALUES("318","576","Fotooo","1596173730","1596173748","","","0","0");
INSERT INTO gallery VALUES("319","589","Аватарки","1596207824","1596207915","","","0","0");
INSERT INTO gallery VALUES("320","590","new","1596274718","1596274739","","","0","0");
INSERT INTO gallery VALUES("323","595","Ава","1597062743","1597062782","","","0","0");
INSERT INTO gallery VALUES("324","598","Беко","1597347245","1597347302","","","0","0");
INSERT INTO gallery VALUES("326","601","Максим","1597480090","1597481168","","","0","0");
INSERT INTO gallery VALUES("327","594","Ник","1597481858","1597560756","","","0","0");
INSERT INTO gallery VALUES("328","602","Яяяяя","1597497256","1597497287","","","0","0");
INSERT INTO gallery VALUES("329","603","Альбом","1597512422","1597512440","","","0","0");
INSERT INTO gallery VALUES("330","605","авка","1597518039","1597518105","","","0","0");
INSERT INTO gallery VALUES("331","578","Мой фоты любимые","1597521810","1597521825","","","0","0");
INSERT INTO gallery VALUES("332","606","Авка","1597522570","1597522610","","","0","0");
INSERT INTO gallery VALUES("333","607","Артур","1597529948","1597529993","Мажор","","2","2");
INSERT INTO gallery VALUES("334","608","мой","1597532722","1597532748","","","0","0");
INSERT INTO gallery VALUES("335","609","Мои","1597541882","1597541926","","","0","0");
INSERT INTO gallery VALUES("336","609","Яяяя","1597542348","1597542420","","","0","0");
INSERT INTO gallery VALUES("337","610","Ьгг","1597549505","1597549635","Оолл","","0","0");
INSERT INTO gallery VALUES("338","340","Нюта","1597563126","1597563243","","","0","0");
INSERT INTO gallery VALUES("339","611","Keyt","1597572890","1597572958","","","0","0");
INSERT INTO gallery VALUES("340","614","Ава","1597602025","1597602205","","","0","0");
INSERT INTO gallery VALUES("341","615","фото","1597604596","1597604708","","","0","0");
INSERT INTO gallery VALUES("342","620","Батя","1597645576","1597645601","","","0","0");
INSERT INTO gallery VALUES("343","621","Ава","1597646902","1597646933","","","1","1");
INSERT INTO gallery VALUES("344","619","ХУЛИГАН","1597661422","1597661505","","","0","0");
INSERT INTO gallery VALUES("345","622","Мой","1597675854","1597676106","","","0","0");



DROP TABLE IF EXISTS `gallery_foto`;

CREATE TABLE `gallery_foto` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gallery` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `ras` varchar(4) NOT NULL,
  `type` varchar(64) NOT NULL,
  `opis` varchar(1024) NOT NULL,
  `effects` text,
  `rating` int(11) NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  `avatar` enum('0','1') DEFAULT '0',
  `pass` varchar(11) DEFAULT NULL,
  `people` int(11) DEFAULT NULL,
  `time` int(11) NOT NULL,
  `metka` int(1) DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `id_gallery` (`id_gallery`)
) ENGINE=MyISAM AUTO_INCREMENT=626 DEFAULT CHARSET=utf8;

INSERT INTO gallery_foto VALUES("1","1","Vhhgghh","jpg","image/jpeg","","","0","271","1","","0","1581698588","0");
INSERT INTO gallery_foto VALUES("285","223","cat51","jpg","image/jpeg","","","0","510","1","","0","1593208369","0");
INSERT INTO gallery_foto VALUES("3","3","Фотки","jpg","image/jpeg","","","0","274","0","","0","1581719653","0");
INSERT INTO gallery_foto VALUES("4","3","Фотки","jpg","image/jpeg","","","0","274","1","","0","1581721208","0");
INSERT INTO gallery_foto VALUES("5","4","Strong ","jpg","image/jpeg","Strong ","","0","269","1","","0","1581727715","0");
INSERT INTO gallery_foto VALUES("6","5","2020-01-04-15-52-04","jpg","image/jpeg","","","0","273","0","","0","1581769107","0");
INSERT INTO gallery_foto VALUES("7","5","2020-01-04-15-52-04","jpg","image/jpeg","","","0","273","0","","0","1581769118","0");
INSERT INTO gallery_foto VALUES("8","5","2020-01-04-15-52-04","jpg","image/jpeg","","","0","273","1","","0","1581769125","0");
INSERT INTO gallery_foto VALUES("9","6","Foto","jpg","image/jpeg","","","0","278","1","","0","1581876550","0");
INSERT INTO gallery_foto VALUES("10","7","IMG_20200105_142032","jpg","image/jpeg","","","0","279","1","","0","1582277369","0");
INSERT INTO gallery_foto VALUES("429","8","Фантик","jpg","image/jpeg","","","0","281","1","","0","1595071755","0");
INSERT INTO gallery_foto VALUES("426","9","Вау","jpg","image/jpeg","","","0","283","1","","0","1595055801","0");
INSERT INTO gallery_foto VALUES("432","10","Чупс ","jpg","image/jpeg","","","0","288","1","","0","1595073907","0");
INSERT INTO gallery_foto VALUES("14","11","ава","jpg","image/jpeg","","","0","290","1","","0","1584339944","0");
INSERT INTO gallery_foto VALUES("17","15","ava","jpg","image/jpeg","","","0","294","1","","0","1584629477","0");
INSERT INTO gallery_foto VALUES("18","16","FB_IMG_1584339051162","jpg","image/jpeg","","","0","295","1","","0","1584727286","0");
INSERT INTO gallery_foto VALUES("21","18","Фото","jpg","image/jpeg","","","0","299","1","","0","1585308664","0");
INSERT INTO gallery_foto VALUES("22","19","Фото","jpg","image/jpeg","","","0","300","0","","0","1585335184","0");
INSERT INTO gallery_foto VALUES("23","20","UIGBLO","jpg","image/jpeg","","","0","302","1","","0","1585695927","0");
INSERT INTO gallery_foto VALUES("25","22","foto_4489","jpg","image/jpeg","","","0","308","1","","0","1586109572","0");
INSERT INTO gallery_foto VALUES("26","23","приколы ","jpg","image/jpeg","","","0","309","1","","0","1586117954","0");
INSERT INTO gallery_foto VALUES("27","24","Ддддд","jpg","image/jpeg","Дщщщщ","","0","307","1","","0","1586146482","0");
INSERT INTO gallery_foto VALUES("28","25","tmp-cam-1007118226741705862","jpg","image/jpeg","","","0","310","1","","0","1586161205","0");
INSERT INTO gallery_foto VALUES("29","26","Фото","jpg","image/jpeg","","","0","300","1","","0","1586339962","0");
INSERT INTO gallery_foto VALUES("33","30","потом","jpg","image/jpeg","jkh","","0","315","1","","0","1587401385","1");
INSERT INTO gallery_foto VALUES("35","32","Bdndhdb","jpg","image/jpeg","","","0","318","1","","0","1588585251","0");
INSERT INTO gallery_foto VALUES("36","31","Фото","jpg","image/jpeg","","","0","316","1","","0","1589567190","0");
INSERT INTO gallery_foto VALUES("606","34","ава","jpg","image/jpeg","","","12","320","1","","0","1597517258","0");
INSERT INTO gallery_foto VALUES("39","35","resize","jpg","image/jpeg","","","0","321","1","","0","1590087800","0");
INSERT INTO gallery_foto VALUES("40","36","ezgif-6-eedbe2f0d090","jpg","image/jpeg","","","0","322","1","","0","1590164748","0");
INSERT INTO gallery_foto VALUES("41","37","Avatar","jpg","image/jpeg","","","0","323","1","","0","1590558735","0");
INSERT INTO gallery_foto VALUES("278","218","Фото","jpg","image/jpeg","","","0","507","1","","0","1593197569","0");
INSERT INTO gallery_foto VALUES("50","47","авка","jpg","image/jpeg","","","5","336","1","","0","1590838148","0");
INSERT INTO gallery_foto VALUES("44","40","n8w","jpg","image/jpeg","","","0","326","1","","0","1590606230","0");
INSERT INTO gallery_foto VALUES("48","44","Фото","jpg","image/jpeg","","","39","330","0","","0","1590679618","0");
INSERT INTO gallery_foto VALUES("49","46","tmp-cam-7757730358651586570","jpg","image/jpeg","","","0","331","1","","0","1590776202","0");
INSERT INTO gallery_foto VALUES("52","48","IMG_20190713_191208","jpg","image/jpeg","","","0","338","1","","0","1590917256","0");
INSERT INTO gallery_foto VALUES("54","50","Фото","jpg","image/jpeg","","","0","341","1","","0","1590923519","0");
INSERT INTO gallery_foto VALUES("55","51","авка","jpg","image/jpeg","","","0","342","1","","0","1590927698","0");
INSERT INTO gallery_foto VALUES("56","52","M7cCEiD7f7M","jpg","image/jpeg","","","0","343","1","","0","1590943377","0");
INSERT INTO gallery_foto VALUES("346","264","м66","jpg","image/jpeg","","","0","544","1","","0","1593763863","0");
INSERT INTO gallery_foto VALUES("58","54","Фото","jpg","image/jpeg","","","0","345","1","","0","1590947946","0");
INSERT INTO gallery_foto VALUES("62","57","grafnik","jpg","image/jpeg","","","0","347","0","","0","1590965320","0");
INSERT INTO gallery_foto VALUES("63","57","grafnik","jpg","image/jpeg","","","0","347","1","","0","1590965446","0");
INSERT INTO gallery_foto VALUES("64","58","333333","jpg","image/jpeg","","","0","349","1","","0","1590977247","0");
INSERT INTO gallery_foto VALUES("65","59","55ce3c961fc8af590da812725d919799","jpg","image/jpeg","","","0","350","1","","0","1590988604","0");
INSERT INTO gallery_foto VALUES("66","27","Бебебе","jpg","image/jpeg","","","0","312","0","","0","1591007282","0");
INSERT INTO gallery_foto VALUES("69","60","image","jpg","image/jpeg","","","6","353","1","","0","1591034388","0");
INSERT INTO gallery_foto VALUES("70","61","Яяяяяяя","jpg","image/jpeg","Яяяяяя","","0","354","1","","0","1591042139","0");
INSERT INTO gallery_foto VALUES("83","70","Кузя","jpg","image/jpeg","","","5","361","1","","0","1591145212","0");
INSERT INTO gallery_foto VALUES("74","64","image-44","jpg","image/jpeg","","","5","351","1","","0","1591102826","0");
INSERT INTO gallery_foto VALUES("75","65","Misty","jpg","image/jpeg","","","28","358","0","","0","1591107787","0");
INSERT INTO gallery_foto VALUES("76","65","Misty","jpg","image/jpeg","","","28","358","1","","0","1591107804","0");
INSERT INTO gallery_foto VALUES("77","65","Misty","jpg","image/jpeg","","","22","358","0","","0","1591107823","0");
INSERT INTO gallery_foto VALUES("84","71","images-14","jpg","image/jpeg","","","0","364","1","","0","1591150429","0");
INSERT INTO gallery_foto VALUES("272","214","Ава","jpg","image/jpeg","","","6","362","1","","0","1593110638","0");
INSERT INTO gallery_foto VALUES("81","69","ava","jpg","image/jpeg","","","5","363","0","","0","1591124937","0");
INSERT INTO gallery_foto VALUES("82","62","20200602_232928","jpg","image/jpeg","","","0","355","0","","0","1591129886","0");
INSERT INTO gallery_foto VALUES("85","27","Беее","jpg","image/jpeg","","","12","312","1","","0","1591167796","0");
INSERT INTO gallery_foto VALUES("86","72","Ava","jpg","image/jpeg","","","0","365","1","","0","1591167918","0");
INSERT INTO gallery_foto VALUES("87","73","Как то так","jpg","image/jpeg","","","0","366","1","","0","1591168657","0");
INSERT INTO gallery_foto VALUES("99","83","e82b3ccfaf7ff6546128f2677a18fbb3","jpg","image/jpeg","","","0","376","1","","0","1591276216","0");
INSERT INTO gallery_foto VALUES("89","75","Ава","jpg","image/jpeg","","","0","367","1","","0","1591178632","0");
INSERT INTO gallery_foto VALUES("90","76","666","jpg","image/jpeg","","","0","368","1","","0","1591180604","0");
INSERT INTO gallery_foto VALUES("437","138","149584","jpg","image/jpeg","","","0","431","0","","0","1595129403","0");
INSERT INTO gallery_foto VALUES("105","87","sA75oA-4hNc","jpg","image/jpeg","","","0","377","1","","0","1591292885","0");
INSERT INTO gallery_foto VALUES("151","124","пиздец","jpg","image/jpeg","","","0","419","1","","0","1591961992","0");
INSERT INTO gallery_foto VALUES("95","79","Ава","jpg","image/jpeg","","","5","372","1","","0","1591212206","0");
INSERT INTO gallery_foto VALUES("96","80","13247","jpg","image/jpeg","","","0","370","1","","0","1591213714","0");
INSERT INTO gallery_foto VALUES("97","81","________","jpg","image/jpeg","","","5","373","0","","0","1591256423","0");
INSERT INTO gallery_foto VALUES("100","84","Hliii","jpg","image/jpeg","","","6","378","1","","0","1591280631","0");
INSERT INTO gallery_foto VALUES("101","85","Ршдин","jpg","image/jpeg","","","0","380","1","","0","1591286638","1");
INSERT INTO gallery_foto VALUES("102","85","Ршдин","jpg","image/jpeg","","","0","380","0","","0","1591286639","0");
INSERT INTO gallery_foto VALUES("103","85","Ршдин","jpg","image/jpeg","","","0","380","0","","0","1591286641","0");
INSERT INTO gallery_foto VALUES("104","86","AvA","jpg","image/jpeg","","","0","379","1","","0","1591287733","0");
INSERT INTO gallery_foto VALUES("106","88","Yaa","jpg","image/jpeg","","","0","382","1","","0","1591301025","0");
INSERT INTO gallery_foto VALUES("107","89","Пва","jpg","image/jpeg","Аааа","","0","383","1","","0","1591305167","0");
INSERT INTO gallery_foto VALUES("108","90","Super1","jpg","image/jpeg","","","0","384","1","","0","1591348082","0");
INSERT INTO gallery_foto VALUES("109","81","_________","jpg","image/jpeg","","","0","373","1","","0","1591352186","0");
INSERT INTO gallery_foto VALUES("110","91","5555555","jpg","image/jpeg","","","0","386","1","","0","1591436503","0");
INSERT INTO gallery_foto VALUES("111","92","Фотоо","jpg","image/jpeg","","","0","387","1","","0","1591438060","0");
INSERT INTO gallery_foto VALUES("112","93","Фото0053","jpg","image/jpeg","","","0","388","0","","0","1591446257","0");
INSERT INTO gallery_foto VALUES("113","94","Фото0155","jpg","image/jpeg","","","0","388","1","","0","1591454814","0");
INSERT INTO gallery_foto VALUES("114","95","Girl Style ","jpg","image/jpeg","Girl Style ","","6","391","0","","0","1591540632","0");
INSERT INTO gallery_foto VALUES("115","96","Yamjs9ivRu","jpg","image/jpeg","","","0","393","1","","0","1591560966","0");
INSERT INTO gallery_foto VALUES("203","162","ава","jpg","image/jpeg","","","0","457","1","","0","1592450747","0");
INSERT INTO gallery_foto VALUES("119","99","Ава","jpg","image/jpeg","","","0","396","1","","0","1591617984","0");
INSERT INTO gallery_foto VALUES("120","100","Сделать главной","jpg","image/jpeg","","","0","397","1","","0","1591618369","0");
INSERT INTO gallery_foto VALUES("121","101","Авуська","jpg","image/jpeg","","","11","398","1","","0","1591620524","0");
INSERT INTO gallery_foto VALUES("125","103","Пллалала","jpg","image/jpeg","","","0","400","1","","0","1591627046","0");
INSERT INTO gallery_foto VALUES("123","99","Авка","jpg","image/jpeg","","","0","396","0","","0","1591623405","0");
INSERT INTO gallery_foto VALUES("128","105","IMG_20200323_1041152","jpg","image/jpeg","","","0","402","1","","0","1591639965","0");
INSERT INTO gallery_foto VALUES("129","106","782b8b45f7e2374a0656a783c46fe3e2","jpg","image/jpeg","","","0","403","1","","0","1591641968","0");
INSERT INTO gallery_foto VALUES("131","107","Фото","jpg","image/jpeg","Эт я","","0","405","0","","0","1591737916","0");
INSERT INTO gallery_foto VALUES("132","108","ава","jpg","image/jpeg","","","0","406","1","","0","1591740698","0");
INSERT INTO gallery_foto VALUES("133","109","Ава","jpg","image/jpeg","","","0","407","1","","0","1591773003","0");
INSERT INTO gallery_foto VALUES("134","110","devushka_blondinka_11427","jpg","image/jpeg","","","0","409","1","","0","1591776478","0");
INSERT INTO gallery_foto VALUES("135","111","Авка","jpg","image/jpeg","","","0","405","1","","0","1591776722","0");
INSERT INTO gallery_foto VALUES("136","112","Зайка","jpg","image/jpeg","","","0","411","1","","0","1591843471","0");
INSERT INTO gallery_foto VALUES("137","112","На ультима","jpg","image/jpeg","","","0","411","0","","0","1591843516","0");
INSERT INTO gallery_foto VALUES("138","113","Прикол 1","jpg","image/jpeg","","","0","411","0","","0","1591844074","0");
INSERT INTO gallery_foto VALUES("139","113","Прикол 2","jpg","image/jpeg","","","0","411","0","","0","1591853589","0");
INSERT INTO gallery_foto VALUES("140","113","Прикол","jpg","image/jpeg","","","0","411","0","","0","1591853713","0");
INSERT INTO gallery_foto VALUES("141","113","Прикол 3","jpg","image/jpeg","","","0","411","0","","0","1591853807","0");
INSERT INTO gallery_foto VALUES("173","139","666666","jpg","image/jpeg","","","0","432","1","","0","1592155105","0");
INSERT INTO gallery_foto VALUES("144","116","_20200604_132304","jpg","image/jpeg","","","0","415","1","","0","1591876304","0");
INSERT INTO gallery_foto VALUES("199","158","Avka","jpg","image/jpeg","","","0","454","1","","0","1592418233","0");
INSERT INTO gallery_foto VALUES("146","119","Potg","jpg","image/jpeg","","","0","418","1","","0","1591947542","0");
INSERT INTO gallery_foto VALUES("150","123","Фото ","jpg","image/jpeg","","","0","421","1","","0","1591958846","0");
INSERT INTO gallery_foto VALUES("159","130","5555","jpg","image/jpeg","","","0","426","1","","0","1591996621","0");
INSERT INTO gallery_foto VALUES("154","126","Аватар","jpg","image/jpeg","","","5","422","0","","0","1591975448","0");
INSERT INTO gallery_foto VALUES("155","127","beautiful_girls_48","jpg","image/jpeg","","","24","423","1","","0","1591978875","0");
INSERT INTO gallery_foto VALUES("157","128","13604","jpg","image/jpeg","","","0","424","1","","0","1591988311","0");
INSERT INTO gallery_foto VALUES("158","129","12906266","jpg","image/jpeg","","","0","425","0","","0","1591993437","0");
INSERT INTO gallery_foto VALUES("162","132","2020-04-08-08-46-01","jpg","image/jpeg","","","0","427","1","","0","1592029437","0");
INSERT INTO gallery_foto VALUES("161","128","622","jpg","image/jpeg","","","0","424","0","","0","1592018667","0");
INSERT INTO gallery_foto VALUES("452","138","149594","jpg","image/jpeg","","","0","431","0","","0","1595221368","0");
INSERT INTO gallery_foto VALUES("165","44","Фото","jpg","image/jpeg","","","34","330","0","","0","1592058831","0");
INSERT INTO gallery_foto VALUES("167","62","20190429_120313","jpg","image/jpeg","","","29","355","1","","0","1592068559","0");
INSERT INTO gallery_foto VALUES("168","135","11111","jpg","image/jpeg","","","6","429","1","","0","1592104963","0");
INSERT INTO gallery_foto VALUES("169","136","Мрак","jpg","image/jpeg","","","0","430","1","","0","1592116198","0");
INSERT INTO gallery_foto VALUES("174","141","1zb0-ewcqyw","jpg","image/jpeg","","","5","435","1","","0","1592182940","1");
INSERT INTO gallery_foto VALUES("175","142","Упссс","jpg","image/jpeg","","","0","416","1","","0","1592206518","0");
INSERT INTO gallery_foto VALUES("176","143","1546587536_screenshot_1","jpg","image/jpeg","","","0","437","1","","0","1592214463","0");
INSERT INTO gallery_foto VALUES("177","144","Ава","jpg","image/jpeg","","","0","436","1","","0","1592216715","0");
INSERT INTO gallery_foto VALUES("178","145","Фото ","jpg","image/jpeg","Фото ","","12","391","1","","0","1592220590","0");
INSERT INTO gallery_foto VALUES("180","140","3333333","jpg","image/jpeg","","","0","434","1","","0","1592246786","0");
INSERT INTO gallery_foto VALUES("182","147","2459712393","jpg","image/jpeg","","","0","440","1","","0","1592266458","0");
INSERT INTO gallery_foto VALUES("183","49","Просто так ","jpg","image/jpeg","","","0","339","0","","0","1592292330","0");
INSERT INTO gallery_foto VALUES("185","149","3706","jpg","image/jpeg","","","0","442","0","","0","1592310996","0");
INSERT INTO gallery_foto VALUES("190","153","s1200","jpg","image/jpeg","","","0","445","0","","0","1592390281","0");
INSERT INTO gallery_foto VALUES("192","149","2147491086","jpg","image/jpeg","","","0","442","1","","0","1592394438","0");
INSERT INTO gallery_foto VALUES("193","154","грань","jpg","image/jpeg","","","0","447","1","","0","1592402945","0");
INSERT INTO gallery_foto VALUES("194","155","Ава","jpg","image/jpeg","","","0","451","1","","0","1592412836","0");
INSERT INTO gallery_foto VALUES("195","156","IMG_20200521_180448_162","jpg","image/jpeg","","","6","452","1","","0","1592414865","0");
INSERT INTO gallery_foto VALUES("196","152","Gjbgj","jpg","image/jpeg","","","0","444","1","","0","1592414954","0");
INSERT INTO gallery_foto VALUES("205","164","2147492204","jpg","image/jpeg","","","0","458","1","","0","1592458863","0");
INSERT INTO gallery_foto VALUES("514","138","149655","jpg","image/jpeg","","","0","431","0","","0","1595774117","0");
INSERT INTO gallery_foto VALUES("201","159","avka","jpg","image/jpeg","","","0","455","1","","0","1592420713","0");
INSERT INTO gallery_foto VALUES("202","160","Россия","jpg","image/jpeg","","","0","448","1","","0","1592421480","0");
INSERT INTO gallery_foto VALUES("204","163","Djdk","jpg","image/jpeg","","","0","450","1","","0","1592452281","0");
INSERT INTO gallery_foto VALUES("223","178","Яяя","jpg","image/jpeg","Мои","","0","474","1","","0","1592652338","0");
INSERT INTO gallery_foto VALUES("207","165","ae9d07e1a1bbff","jpg","image/jpeg","","","0","461","1","","0","1592472202","0");
INSERT INTO gallery_foto VALUES("208","166","Jfghgcg","jpg","image/jpeg","","","0","444","0","","0","1592476072","0");
INSERT INTO gallery_foto VALUES("436","167","foto357","jpg","image/jpeg","","","0","463","1","","0","1595081124","0");
INSERT INTO gallery_foto VALUES("210","153","IMG-20200618-WA0014","jpg","image/jpeg","","","0","445","1","","0","1592494497","0");
INSERT INTO gallery_foto VALUES("211","168","b51a38f04940f89fcb8f7cd6f26369d0","jpg","image/jpeg","","","0","464","1","","0","1592499927","0");
INSERT INTO gallery_foto VALUES("212","169","1491840907741","jpg","image/jpeg","","","6","464","0","","0","1592500140","0");
INSERT INTO gallery_foto VALUES("213","169","1491840949647","jpg","image/jpeg","","","6","464","0","","0","1592500173","0");
INSERT INTO gallery_foto VALUES("214","169","1491840929534","jpg","image/jpeg","","","6","464","0","","0","1592500187","0");
INSERT INTO gallery_foto VALUES("215","170","Ава","jpg","image/jpeg","","","0","465","1","","0","1592503053","0");
INSERT INTO gallery_foto VALUES("216","126","Аватар 1","jpg","image/jpeg","","","0","422","1","","0","1592516480","0");
INSERT INTO gallery_foto VALUES("217","171","17015","jpg","image/jpeg","","","0","466","1","","0","1592548866","0");
INSERT INTO gallery_foto VALUES("219","173","Qwert","jpg","image/jpeg","","","0","468","1","","0","1592581778","0");
INSERT INTO gallery_foto VALUES("220","175","IMG_20200603_173052","jpg","image/jpeg","","","0","469","1","","0","1592592137","0");
INSERT INTO gallery_foto VALUES("222","177","Хостер","jpg","image/jpeg","","","0","473","1","","0","1592608926","0");
INSERT INTO gallery_foto VALUES("224","178","Яяя","jpg","image/jpeg","Мои","","0","474","0","","0","1592652665","0");
INSERT INTO gallery_foto VALUES("227","157","BNkhMzBQ-Ro","jpg","image/jpeg","","","0","453","1","","0","1592660956","0");
INSERT INTO gallery_foto VALUES("228","180","muzhchina_spinoj_kapyushon_16591","jpg","image/jpeg","","","0","449","1","","0","1592671215","0");
INSERT INTO gallery_foto VALUES("229","181","Ава ","jpg","image/jpeg","","","0","475","1","","0","1592676591","0");
INSERT INTO gallery_foto VALUES("230","182","В Саратове","jpg","image/jpeg","","","0","476","1","","0","1592677855","0");
INSERT INTO gallery_foto VALUES("231","183","IMG_20200618_223350","jpg","image/jpeg","","","0","477","1","","0","1592691499","0");
INSERT INTO gallery_foto VALUES("232","184","Грусть","jpg","image/jpeg","","","0","472","1","","0","1592695740","0");
INSERT INTO gallery_foto VALUES("233","185","Ава","jpg","image/jpeg","","","0","375","1","","0","1592715758","0");
INSERT INTO gallery_foto VALUES("234","186","IMG_20200617_055916","jpg","image/jpeg","","","0","356","0","","0","1592721384","0");
INSERT INTO gallery_foto VALUES("235","187","love","jpg","image/jpeg","","","0","479","1","","0","1592722523","0");
INSERT INTO gallery_foto VALUES("236","188","5uYJ_D8rKO8","jpg","image/jpeg","","","5","480","1","","0","1592722742","0");
INSERT INTO gallery_foto VALUES("237","190","IMG_20200310_112934_913","jpg","image/jpeg","","","0","482","1","","0","1592728341","0");
INSERT INTO gallery_foto VALUES("238","191","Яяя","jpg","image/jpeg","","","0","483","1","","0","1592729126","0");
INSERT INTO gallery_foto VALUES("239","192","unnamed","jpg","image/jpeg","","","0","484","0","","0","1592733472","0");
INSERT INTO gallery_foto VALUES("265","17","IMG_20200619_112926","jpg","image/jpeg","","","0","298","1","","0","1593018419","0");
INSERT INTO gallery_foto VALUES("244","196","Ава","jpg","image/jpeg","","","0","487","0","","0","1592763572","0");
INSERT INTO gallery_foto VALUES("245","197","Люблю себя","jpg","image/jpeg","","","0","488","0","","0","1592771516","0");
INSERT INTO gallery_foto VALUES("248","198","Ава","jpg","image/jpeg","","","0","489","1","","0","1592814919","0");
INSERT INTO gallery_foto VALUES("249","200","Ава","jpg","image/jpeg","","","0","493","1","","0","1592848642","0");
INSERT INTO gallery_foto VALUES("251","199","16575","jpg","image/jpeg","","","0","492","0","","0","1592882020","1");
INSERT INTO gallery_foto VALUES("252","199","88953784","jpg","image/jpeg","","","0","492","0","","0","1592883230","1");
INSERT INTO gallery_foto VALUES("253","202","Ава","jpg","image/jpeg","","","0","494","1","","0","1592885505","0");
INSERT INTO gallery_foto VALUES("254","203","IMG_20200324_110907","jpg","image/jpeg","","","0","495","1","","0","1592898101","0");
INSERT INTO gallery_foto VALUES("255","196","Ава","jpg","image/jpeg","","","0","487","0","","0","1592904143","0");
INSERT INTO gallery_foto VALUES("256","196","Ава","jpg","image/jpeg","","","0","487","1","","0","1592904164","0");
INSERT INTO gallery_foto VALUES("257","204","388068","jpg","image/jpeg","","","0","488","0","","0","1592912472","0");
INSERT INTO gallery_foto VALUES("258","205","разное","jpg","image/jpeg","","","6","497","1","","0","1592931982","0");
INSERT INTO gallery_foto VALUES("259","208","IMG_20200528_140232_642","jpg","image/jpeg","","","0","499","1","","0","1592954501","0");
INSERT INTO gallery_foto VALUES("260","209","Ххххххх","jpg","image/jpeg","","","0","500","1","","0","1592966945","0");
INSERT INTO gallery_foto VALUES("261","204","387769","jpg","image/jpeg","","","0","488","0","","0","1592982688","0");
INSERT INTO gallery_foto VALUES("263","211","Няшка","jpg","image/jpeg","","","5","501","1","","0","1592991708","0");
INSERT INTO gallery_foto VALUES("264","204","236055","jpg","image/jpeg","","","0","488","0","","0","1592992105","0");
INSERT INTO gallery_foto VALUES("266","204","239838","jpg","image/jpeg","","","0","488","0","","0","1593031401","0");
INSERT INTO gallery_foto VALUES("268","212","яяя","jpg","image/jpeg","","","0","502","1","","0","1593063536","0");
INSERT INTO gallery_foto VALUES("271","204","239839","jpg","image/jpeg","","","0","488","1","","0","1593079479","0");
INSERT INTO gallery_foto VALUES("273","49","Просто так ","jpg","image/jpeg","","","0","339","1","","0","1593160763","0");
INSERT INTO gallery_foto VALUES("371","277","Ava","jpg","image/jpeg","","","0","533","0","","0","1594052579","0");
INSERT INTO gallery_foto VALUES("372","281","FB_IMG_1582150929976","jpg","image/jpeg","","","6","554","1","","0","1594064217","0");
INSERT INTO gallery_foto VALUES("281","219","Какой есть","jpg","image/jpeg","","","0","508","1","","0","1593199881","0");
INSERT INTO gallery_foto VALUES("337","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593706765","0");
INSERT INTO gallery_foto VALUES("306","241","ххх","jpg","image/jpeg","","","0","529","1","","0","1593381583","0");
INSERT INTO gallery_foto VALUES("587","138","149643","jpg","image/jpeg","","","5","431","0","","0","1596433847","0");
INSERT INTO gallery_foto VALUES("318","251","ссс","jpg","image/jpeg","","","0","535","1","","0","1593460215","0");
INSERT INTO gallery_foto VALUES("331","257","2591466880","jpg","image/jpeg","","","6","511","0","","0","1593621213","0");
INSERT INTO gallery_foto VALUES("289","226","IMG_20200624_001711","jpg","image/jpeg","","","0","512","1","","0","1593248007","0");
INSERT INTO gallery_foto VALUES("290","227","17977","jpg","image/jpeg","","","0","459","1","","0","1593255724","0");
INSERT INTO gallery_foto VALUES("291","228","Ллоол","jpg","image/jpeg","","","0","513","1","","0","1593258589","0");
INSERT INTO gallery_foto VALUES("427","229","love","jpg","image/jpeg","","","5","514","1","","0","1595057735","0");
INSERT INTO gallery_foto VALUES("481","312","Чудесного дня","jpg","image/jpeg","","","0","585","0","","0","1595521078","0");
INSERT INTO gallery_foto VALUES("336","260","img","jpg","image/jpeg","","","6","533","0","","0","1593664405","0");
INSERT INTO gallery_foto VALUES("295","233","Ава","jpg","image/jpeg","","","5","518","1","","0","1593312261","0");
INSERT INTO gallery_foto VALUES("297","235","Destiny","jpg","image/jpeg","Destiny","","0","520","1","","0","1593328918","0");
INSERT INTO gallery_foto VALUES("298","234","1850","jpg","image/jpeg","","","0","519","1","","0","1593343019","0");
INSERT INTO gallery_foto VALUES("299","236","олег","jpg","image/jpeg","","","0","522","1","","0","1593350913","0");
INSERT INTO gallery_foto VALUES("300","237","таакк","jpg","image/jpeg","просто","","0","523","1","","0","1593359592","0");
INSERT INTO gallery_foto VALUES("310","244","IMG_20200623_174610","jpg","image/jpeg","","","6","531","0","","0","1593423525","0");
INSERT INTO gallery_foto VALUES("309","243","Nkk","jpg","image/jpeg","","","0","530","1","","0","1593416730","0");
INSERT INTO gallery_foto VALUES("305","240","Ава","jpg","image/jpeg","","","0","528","1","","0","1593375571","0");
INSERT INTO gallery_foto VALUES("307","242","kjjhg","jpg","image/jpeg","mnnbb","","0","498","1","","0","1593382241","0");
INSERT INTO gallery_foto VALUES("311","245","Фото","jpg","image/jpeg","","","0","532","1","","0","1593428026","0");
INSERT INTO gallery_foto VALUES("314","247","Qwsadg","jpg","image/jpeg","","","0","344","1","","0","1593433756","0");
INSERT INTO gallery_foto VALUES("335","260","img","jpg","image/jpeg","","","0","533","0","","0","1593664385","0");
INSERT INTO gallery_foto VALUES("317","248","IElWvEcir7I","jpg","image/jpeg","","","0","527","1","","0","1593455881","0");
INSERT INTO gallery_foto VALUES("319","244","photo","jpg","image/jpeg","","","6","531","1","","0","1593494321","0");
INSERT INTO gallery_foto VALUES("321","252","Ава","jpg","image/jpeg","","","0","536","1","","0","1593527320","0");
INSERT INTO gallery_foto VALUES("322","250","вот","jpg","image/jpeg","","","6","534","1","","0","1593530300","0");
INSERT INTO gallery_foto VALUES("323","253","Ааррр","jpg","image/jpeg","Бррр","","5","538","1","","0","1593587758","0");
INSERT INTO gallery_foto VALUES("324","254","Аватар ","jpg","image/jpeg","","","0","539","1","","0","1593590500","0");
INSERT INTO gallery_foto VALUES("334","259","2FJCRTU0aVg","jpg","image/jpeg","","","0","491","1","","0","1593641800","0");
INSERT INTO gallery_foto VALUES("326","64","image-20E001","jpg","image/jpeg","","","5","351","0","","0","1593592672","0");
INSERT INTO gallery_foto VALUES("333","258","IMG_20200211_194739","jpg","image/jpeg","","","0","542","0","","0","1593632851","0");
INSERT INTO gallery_foto VALUES("338","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593706782","0");
INSERT INTO gallery_foto VALUES("339","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593706809","0");
INSERT INTO gallery_foto VALUES("340","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593706856","0");
INSERT INTO gallery_foto VALUES("341","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593706900","0");
INSERT INTO gallery_foto VALUES("342","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593715526","0");
INSERT INTO gallery_foto VALUES("343","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1593719284","0");
INSERT INTO gallery_foto VALUES("347","261","ГрЕшНиЦа","jpg","image/jpeg","","","5","516","0","","0","1593765358","0");
INSERT INTO gallery_foto VALUES("348","69","ава","jpg","image/jpeg","","","0","363","1","","0","1593770786","0");
INSERT INTO gallery_foto VALUES("349","265","Орион","jpg","image/jpeg","","","0","545","1","","0","1593775752","0");
INSERT INTO gallery_foto VALUES("350","266","543567","jpg","image/jpeg","","","0","546","1","","0","1593778831","0");
INSERT INTO gallery_foto VALUES("351","267","532772231","jpg","image/jpeg","","","0","547","1","","0","1593787739","0");
INSERT INTO gallery_foto VALUES("438","300","Авка","jpg","image/jpeg","","","0","575","1","","0","1595142321","0");
INSERT INTO gallery_foto VALUES("354","270","FB_IMG_1540144381498","jpg","image/jpeg","","","0","8","1","","0","1593841053","0");
INSERT INTO gallery_foto VALUES("355","271","Авка","jpg","image/jpeg","","","0","521","1","","0","1593856458","0");
INSERT INTO gallery_foto VALUES("356","272","Авка","jpg","image/jpeg","","","0","549","1","","0","1593857660","0");
INSERT INTO gallery_foto VALUES("608","331","610a1eb8cdbe2bccaf0536f781b970b6","jpg","image/jpeg","","","0","578","1","","0","1597521825","0");
INSERT INTO gallery_foto VALUES("362","275","16283","jpg","image/jpeg","","","0","552","1","","0","1593953980","0");
INSERT INTO gallery_foto VALUES("363","276","foto_16783","jpg","image/jpeg","","","0","553","1","","0","1593955011","0");
INSERT INTO gallery_foto VALUES("370","277","Ava","jpg","image/jpeg","","","0","533","0","","0","1594042057","0");
INSERT INTO gallery_foto VALUES("365","277","Avatars","jpg","image/jpeg","","","0","533","0","","0","1593966533","0");
INSERT INTO gallery_foto VALUES("366","278","БМВ","jpg","image/jpeg","Ппнн","","0","555","1","","0","1593970295","0");
INSERT INTO gallery_foto VALUES("367","279","Альбом","jpg","image/jpeg","","","0","556","1","","0","1593970962","0");
INSERT INTO gallery_foto VALUES("373","277","Ava","jpg","image/jpeg","","","0","533","1","","0","1594065895","0");
INSERT INTO gallery_foto VALUES("374","282","Пмпп","jpg","image/jpeg","","","0","558","1","","0","1594204404","0");
INSERT INTO gallery_foto VALUES("375","283","IMG_20200707_162459","jpg","image/jpeg","","","5","559","1","","0","1594205915","1");
INSERT INTO gallery_foto VALUES("376","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594230278","0");
INSERT INTO gallery_foto VALUES("377","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594230609","0");
INSERT INTO gallery_foto VALUES("378","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594230655","0");
INSERT INTO gallery_foto VALUES("379","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594230701","0");
INSERT INTO gallery_foto VALUES("380","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594234031","0");
INSERT INTO gallery_foto VALUES("381","284","Авочка","jpg","image/jpeg","","","0","560","1","","0","1594237065","0");
INSERT INTO gallery_foto VALUES("382","285","IMG-20200627-WA0002","jpg","image/jpeg","","","6","561","1","","0","1594262664","0");
INSERT INTO gallery_foto VALUES("383","286","Авка","jpg","image/jpeg","","","0","562","1","","0","1594412914","0");
INSERT INTO gallery_foto VALUES("384","287","hdt1","jpg","image/jpeg","","","0","509","1","","0","1594446457","0");
INSERT INTO gallery_foto VALUES("385","288","Картинка","jpg","image/jpeg","","","0","564","1","","0","1594580804","0");
INSERT INTO gallery_foto VALUES("386","199","Сестра","jpg","image/jpeg","","","0","492","0","","0","1594588574","0");
INSERT INTO gallery_foto VALUES("387","199","1473","jpg","image/jpeg","","","5","492","0","","0","1594589483","0");
INSERT INTO gallery_foto VALUES("388","199","ЯЯЯ-001","jpg","image/jpeg","","","5","492","0","","0","1594590016","1");
INSERT INTO gallery_foto VALUES("390","280","20200508_164940","jpg","image/jpeg","","","11","554","0","","0","1594666305","0");
INSERT INTO gallery_foto VALUES("391","280","20200510_111315","jpg","image/jpeg","","","11","554","0","","0","1594666325","0");
INSERT INTO gallery_foto VALUES("392","289","Просто так ","jpg","image/jpeg","","","0","565","0","","0","1594794388","0");
INSERT INTO gallery_foto VALUES("393","289","Просто так ","jpg","image/jpeg","","","0","565","1","","0","1594797936","0");
INSERT INTO gallery_foto VALUES("394","290","ava","jpg","image/jpeg","","","0","567","1","","0","1594826076","0");
INSERT INTO gallery_foto VALUES("395","199","1473","jpg","image/jpeg","","","0","492","0","","0","1594854499","0");
INSERT INTO gallery_foto VALUES("396","199","4444-подруга","jpg","image/jpeg","","","0","492","0","","0","1594854565","0");
INSERT INTO gallery_foto VALUES("397","199","88953784","jpg","image/jpeg","","","0","492","0","","0","1594854694","0");
INSERT INTO gallery_foto VALUES("398","199","YUliya_Timoshenko","jpg","image/jpeg","","","0","492","0","","0","1594854755","0");
INSERT INTO gallery_foto VALUES("399","199","YUliyaTimoshenko","jpg","image/jpeg","","","0","492","0","","0","1594854837","0");
INSERT INTO gallery_foto VALUES("400","199","Мамик","jpg","image/jpeg","","","0","492","0","","0","1594854928","0");
INSERT INTO gallery_foto VALUES("401","199","Моя попка","jpg","image/jpeg","","","0","492","0","","0","1594855114","0");
INSERT INTO gallery_foto VALUES("402","199","Моя попка","jpg","image/jpeg","","","0","492","0","","0","1594855197","0");
INSERT INTO gallery_foto VALUES("403","199","Незнакомка","jpg","image/jpeg","","","0","492","0","","0","1594855375","0");
INSERT INTO gallery_foto VALUES("404","199","Подруга","jpg","image/jpeg","","","0","492","0","","0","1594855423","0");
INSERT INTO gallery_foto VALUES("405","199","Рачьком 001","jpg","image/jpeg","","","0","492","0","","0","1594855979","0");
INSERT INTO gallery_foto VALUES("406","199","1406","jpg","image/jpeg","","","0","492","0","","0","1594856575","0");
INSERT INTO gallery_foto VALUES("407","199","1473","jpg","image/jpeg","","","0","492","0","","0","1594856642","0");
INSERT INTO gallery_foto VALUES("408","199","1478","jpg","image/jpeg","","","0","492","0","","0","1594856705","0");
INSERT INTO gallery_foto VALUES("409","199","1479","jpg","image/jpeg","","","0","492","0","","0","1594856767","1");
INSERT INTO gallery_foto VALUES("410","199","27515604","jpg","image/jpeg","","","0","492","0","","0","1594856902","0");
INSERT INTO gallery_foto VALUES("411","199","61413480_russia","jpg","image/jpeg","","","0","492","0","","0","1594857019","0");
INSERT INTO gallery_foto VALUES("412","199","8718-","jpg","image/jpeg","","","0","492","0","","0","1594857067","0");
INSERT INTO gallery_foto VALUES("413","199","8761","jpg","image/jpeg","","","0","492","0","","0","1594857364","0");
INSERT INTO gallery_foto VALUES("414","199","Подружка 001","jpg","image/jpeg","","","0","492","0","","0","1594857729","0");
INSERT INTO gallery_foto VALUES("415","199","Изображение 1613","jpg","image/jpeg","","","0","492","1","","0","1594857810","0");
INSERT INTO gallery_foto VALUES("416","199","Любимая подруга","jpg","image/jpeg","","","0","492","0","","0","1594857947","0");
INSERT INTO gallery_foto VALUES("417","199","Лесовоз","jpg","image/jpeg","","","0","492","0","","0","1594858042","0");
INSERT INTO gallery_foto VALUES("418","199","Изображение 047","jpg","image/jpeg","","","0","492","0","","0","1594858109","0");
INSERT INTO gallery_foto VALUES("420","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594920402","0");
INSERT INTO gallery_foto VALUES("419","291","Аватар","jpg","image/jpeg","","","0","568","1","","0","1594897741","0");
INSERT INTO gallery_foto VALUES("421","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1594922176","0");
INSERT INTO gallery_foto VALUES("422","292","love","jpg","image/jpeg","","","0","282","1","","0","1595020276","0");
INSERT INTO gallery_foto VALUES("423","293","f320x240_001","jpg","image/jpeg","","","0","569","1","","0","1595033172","0");
INSERT INTO gallery_foto VALUES("424","44","Фото","jpg","image/jpeg","","","17","330","0","","0","1595043046","0");
INSERT INTO gallery_foto VALUES("425","294","1920x1080","jpg","image/jpeg","","","0","4","1","","0","1595055499","0");
INSERT INTO gallery_foto VALUES("428","295","Пфеее","jpg","image/jpeg","","","0","570","1","","0","1595059604","0");
INSERT INTO gallery_foto VALUES("430","296","Федя","jpg","image/jpeg","","","0","286","1","","0","1595072130","0");
INSERT INTO gallery_foto VALUES("431","297","Красавчик","jpg","image/jpeg","","","0","287","1","","0","1595072881","0");
INSERT INTO gallery_foto VALUES("433","298","Ава","jpg","image/jpeg","","","0","571","1","","0","1595075716","0");
INSERT INTO gallery_foto VALUES("435","299","авчикк","jpg","image/jpeg","","","0","572","1","","0","1595079811","0");
INSERT INTO gallery_foto VALUES("440","138","149585","jpg","image/jpeg","","","0","431","0","","0","1595144231","0");
INSERT INTO gallery_foto VALUES("441","302","ava","jpg","image/jpeg","","","0","557","1","","0","1595172640","0");
INSERT INTO gallery_foto VALUES("442","303","Ава","jpg","image/jpeg","Аватарка","","0","577","1","","0","1595211482","0");
INSERT INTO gallery_foto VALUES("443","138","149586","jpg","image/jpeg","","","0","431","0","","0","1595217551","0");
INSERT INTO gallery_foto VALUES("444","138","149587","jpg","image/jpeg","","","0","431","0","","0","1595219565","0");
INSERT INTO gallery_foto VALUES("446","138","149589","jpg","image/jpeg","","","0","431","0","","0","1595219715","0");
INSERT INTO gallery_foto VALUES("447","138","149588","jpg","image/jpeg","","","0","431","0","","0","1595219816","0");
INSERT INTO gallery_foto VALUES("448","138","149590","jpg","image/jpeg","","","0","431","0","","0","1595219893","1");
INSERT INTO gallery_foto VALUES("449","138","149591","jpg","image/jpeg","","","0","431","0","","0","1595220322","0");
INSERT INTO gallery_foto VALUES("450","138","149592","jpg","image/jpeg","","","0","431","0","","0","1595220511","0");
INSERT INTO gallery_foto VALUES("451","138","149597","jpg","image/jpeg","","","0","431","0","","0","1595220645","0");
INSERT INTO gallery_foto VALUES("453","138","149593","jpg","image/jpeg","","","0","431","0","","0","1595221543","0");
INSERT INTO gallery_foto VALUES("454","138","149595","jpg","image/jpeg","","","0","431","0","","0","1595222500","0");
INSERT INTO gallery_foto VALUES("455","138","149596","jpg","image/jpeg","","","0","431","0","","0","1595222834","0");
INSERT INTO gallery_foto VALUES("456","138","149626","jpg","image/jpeg","","","0","431","0","","0","1595223112","0");
INSERT INTO gallery_foto VALUES("457","138","149598","jpg","image/jpeg","","","0","431","0","","0","1595223196","0");
INSERT INTO gallery_foto VALUES("458","304","Хххх","jpg","image/jpeg","","","6","526","1","","0","1595224893","0");
INSERT INTO gallery_foto VALUES("459","138","149600","jpg","image/jpeg","","","0","431","0","","0","1595228402","0");
INSERT INTO gallery_foto VALUES("460","138","149599","jpg","image/jpeg","","","0","431","0","","0","1595228479","0");
INSERT INTO gallery_foto VALUES("461","138","149583","jpg","image/jpeg","","","0","431","0","","0","1595228851","0");
INSERT INTO gallery_foto VALUES("462","305","Qeer","jpg","image/jpeg","","","5","579","1","","0","1595249428","0");
INSERT INTO gallery_foto VALUES("463","306","Красота","jpg","image/jpeg","","","0","580","1","","0","1595252436","0");
INSERT INTO gallery_foto VALUES("464","307","Foto4307","jpg","image/jpeg","","","0","507","0","","0","1595264423","1");
INSERT INTO gallery_foto VALUES("465","307","Foto1544","jpg","image/jpeg","","","0","507","0","","0","1595264650","1");
INSERT INTO gallery_foto VALUES("466","307","Foto0981","jpg","image/jpeg","","","0","507","0","","0","1595265554","1");
INSERT INTO gallery_foto VALUES("467","138","149580","jpg","image/jpeg","","","0","431","1","","0","1595294947","0");
INSERT INTO gallery_foto VALUES("468","138","149582","jpg","image/jpeg","","","0","431","0","","0","1595295295","0");
INSERT INTO gallery_foto VALUES("469","138","149581","jpg","image/jpeg","","","0","431","0","","0","1595295788","0");
INSERT INTO gallery_foto VALUES("470","307","Foto1887","jpg","image/jpeg","","","0","507","0","","0","1595317339","1");
INSERT INTO gallery_foto VALUES("471","307","Foto2113","jpg","image/jpeg","","","0","507","0","","0","1595317400","1");
INSERT INTO gallery_foto VALUES("472","307","Foto2478","jpg","image/jpeg","","","0","507","0","","0","1595317467","1");
INSERT INTO gallery_foto VALUES("473","307","Atvaizd0443","jpg","image/jpeg","","","0","507","0","","0","1595317546","1");
INSERT INTO gallery_foto VALUES("474","308","VIP","jpg","image/jpeg","","","0","582","1","","0","1595330729","0");
INSERT INTO gallery_foto VALUES("475","309","20200721_174604","jpg","image/jpeg","","","0","583","1","","0","1595343304","0");
INSERT INTO gallery_foto VALUES("476","138","149603","jpg","image/jpeg","","","0","431","0","","0","1595470537","0");
INSERT INTO gallery_foto VALUES("477","138","149605","jpg","image/jpeg","","","0","431","0","","0","1595475392","0");
INSERT INTO gallery_foto VALUES("478","138","149606","jpg","image/jpeg","","","0","431","0","","0","1595476590","0");
INSERT INTO gallery_foto VALUES("479","310","10-8","jpg","image/jpeg","","","0","584","1","","0","1595488897","0");
INSERT INTO gallery_foto VALUES("482","138","149604","jpg","image/jpeg","","","0","431","0","","0","1595527224","0");
INSERT INTO gallery_foto VALUES("483","138","149607","jpg","image/jpeg","","","0","431","0","","0","1595527414","0");
INSERT INTO gallery_foto VALUES("484","138","149608","jpg","image/jpeg","","","0","431","0","","0","1595529727","0");
INSERT INTO gallery_foto VALUES("485","138","149609","jpg","image/jpeg","","","0","431","0","","0","1595529879","0");
INSERT INTO gallery_foto VALUES("486","138","149610","jpg","image/jpeg","","","0","431","0","","0","1595529998","0");
INSERT INTO gallery_foto VALUES("487","138","149614","jpg","image/jpeg","","","0","431","0","","0","1595530235","0");
INSERT INTO gallery_foto VALUES("488","138","149615","jpg","image/jpeg","","","0","431","0","","0","1595530331","0");
INSERT INTO gallery_foto VALUES("489","138","149617","jpg","image/jpeg","","","0","431","0","","0","1595530542","0");
INSERT INTO gallery_foto VALUES("490","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1595533724","0");
INSERT INTO gallery_foto VALUES("491","261","ГрЕшНиЦа","jpg","image/jpeg","","","0","516","0","","0","1595533757","0");
INSERT INTO gallery_foto VALUES("492","129","IMG-20200723-WA0006","jpg","image/jpeg","","","0","425","1","","0","1595535061","0");
INSERT INTO gallery_foto VALUES("493","44","Фото","jpg","image/jpeg","","","17","330","0","","0","1595561701","0");
INSERT INTO gallery_foto VALUES("495","138","149612","jpg","image/jpeg","","","0","431","0","","0","1595647884","0");
INSERT INTO gallery_foto VALUES("496","138","149616","jpg","image/jpeg","","","0","431","0","","0","1595648028","0");
INSERT INTO gallery_foto VALUES("497","138","149622","jpg","image/jpeg","","","0","431","0","","0","1595648150","0");
INSERT INTO gallery_foto VALUES("498","138","149619","jpg","image/jpeg","","","0","431","0","","0","1595648298","0");
INSERT INTO gallery_foto VALUES("499","138","149613","jpg","image/jpeg","","","0","431","0","","0","1595648524","0");
INSERT INTO gallery_foto VALUES("500","138","149611","jpg","image/jpeg","","","0","431","0","","0","1595649043","0");
INSERT INTO gallery_foto VALUES("501","138","149620","jpg","image/jpeg","","","0","431","0","","0","1595649151","0");
INSERT INTO gallery_foto VALUES("502","138","149621","jpg","image/jpeg","","","0","431","0","","0","1595649219","0");
INSERT INTO gallery_foto VALUES("503","138","149623","jpg","image/jpeg","","","0","431","0","","0","1595649828","0");
INSERT INTO gallery_foto VALUES("504","138","149558","jpg","image/jpeg","","","0","431","0","","0","1595649875","0");
INSERT INTO gallery_foto VALUES("505","138","149557","jpg","image/jpeg","","","0","431","0","","0","1595649944","0");
INSERT INTO gallery_foto VALUES("506","138","149601","jpg","image/jpeg","","","0","431","0","","0","1595650102","0");
INSERT INTO gallery_foto VALUES("507","138","149625","jpg","image/jpeg","","","0","431","0","","0","1595650539","0");
INSERT INTO gallery_foto VALUES("508","138","149556","jpg","image/jpeg","","","0","431","0","","0","1595650845","0");
INSERT INTO gallery_foto VALUES("509","138","149624","jpg","image/jpeg","","","0","431","0","","0","1595650941","0");
INSERT INTO gallery_foto VALUES("510","138","149618","jpg","image/jpeg","","","0","431","0","","0","1595651009","0");
INSERT INTO gallery_foto VALUES("511","313","Просто","jpg","image/jpeg","","","0","586","1","","0","1595734741","0");
INSERT INTO gallery_foto VALUES("512","314","Vold","jpg","image/jpeg","","","0","587","1","","0","1595738490","0");
INSERT INTO gallery_foto VALUES("513","146","Ава","jpg","image/jpeg","","","0","433","1","","0","1595744695","0");
INSERT INTO gallery_foto VALUES("516","312","Терплю","jpg","image/jpeg","","","0","585","1","","0","1595785146","0");
INSERT INTO gallery_foto VALUES("515","138","149560","jpg","image/jpeg","","","0","431","0","","0","1595774174","0");
INSERT INTO gallery_foto VALUES("517","257","Рыжик","jpg","image/jpeg","","","6","511","1","","0","1595789766","0");
INSERT INTO gallery_foto VALUES("518","138","149559","jpg","image/jpeg","","","6","431","0","","0","1595808764","0");
INSERT INTO gallery_foto VALUES("519","138","149602","jpg","image/jpeg","","","6","431","0","","0","1595808865","0");
INSERT INTO gallery_foto VALUES("520","138","149562","jpg","image/jpeg","","","6","431","0","","0","1595808989","0");
INSERT INTO gallery_foto VALUES("522","138","149566","jpg","image/jpeg","","","0","431","0","","0","1595920047","0");
INSERT INTO gallery_foto VALUES("523","138","149563","jpg","image/jpeg","","","0","431","0","","0","1595987776","0");
INSERT INTO gallery_foto VALUES("524","44","фото","jpg","image/jpeg","","","17","330","0","","0","1596004967","0");
INSERT INTO gallery_foto VALUES("527","317","Красивое фото","jpg","image/jpeg","","","0","1","0","","0","1596164289","0");
INSERT INTO gallery_foto VALUES("534","319","Девушка в шляпе","jpg","image/jpeg","","","0","589","1","","0","1596207915","0");
INSERT INTO gallery_foto VALUES("530","317","Фоточка","jpg","image/jpeg","","","0","1","0","","0","1596166643","0");
INSERT INTO gallery_foto VALUES("531","138","149565","jpg","image/jpeg","","","0","431","0","","0","1596170619","0");
INSERT INTO gallery_foto VALUES("532","138","149569","jpg","image/jpeg","","","0","431","0","","0","1596170715","0");
INSERT INTO gallery_foto VALUES("533","318","Z0TSsTeK2LY","jpg","image/jpeg","","","0","576","1","","0","1596173748","0");
INSERT INTO gallery_foto VALUES("535","138","149567","jpg","image/jpeg","","","0","431","0","","0","1596248988","0");
INSERT INTO gallery_foto VALUES("536","138","149561","jpg","image/jpeg","","","0","431","0","","0","1596249049","0");
INSERT INTO gallery_foto VALUES("537","320","new","jpg","image/jpeg","","","0","590","1","","0","1596274739","0");
INSERT INTO gallery_foto VALUES("538","261","ГрЕшНиЦа ","jpg","image/jpeg","","","0","516","1","","0","1596275079","0");
INSERT INTO gallery_foto VALUES("539","138","149564","jpg","image/jpeg","","","0","431","0","","0","1596341016","0");
INSERT INTO gallery_foto VALUES("540","138","149568","jpg","image/jpeg","","","0","431","0","","0","1596341155","0");
INSERT INTO gallery_foto VALUES("541","138","149579","jpg","image/jpeg","","","0","431","0","","0","1596341215","0");
INSERT INTO gallery_foto VALUES("544","138","149573","jpg","image/jpeg","","","0","431","0","","0","1596341412","0");
INSERT INTO gallery_foto VALUES("543","138","149572","jpg","image/jpeg","","","0","431","0","","0","1596341342","0");
INSERT INTO gallery_foto VALUES("545","138","149570","jpg","image/jpeg","","","0","431","0","","0","1596341493","0");
INSERT INTO gallery_foto VALUES("546","138","149574","jpg","image/jpeg","","","0","431","0","","0","1596342634","0");
INSERT INTO gallery_foto VALUES("547","138","149571","jpg","image/jpeg","","","0","431","0","","0","1596342791","0");
INSERT INTO gallery_foto VALUES("551","138","149577","jpg","image/jpeg","","","0","431","0","","0","1596343077","0");
INSERT INTO gallery_foto VALUES("549","138","149578","jpg","image/jpeg","","","0","431","0","","0","1596342929","0");
INSERT INTO gallery_foto VALUES("550","138","149575","jpg","image/jpeg","","","0","431","0","","0","1596342998","0");
INSERT INTO gallery_foto VALUES("552","138","149576","jpg","image/jpeg","","","0","431","0","","0","1596343159","0");
INSERT INTO gallery_foto VALUES("553","138","149627","jpg","image/jpeg","","","0","431","0","","0","1596352608","0");
INSERT INTO gallery_foto VALUES("554","138","149628","jpg","image/jpeg","","","0","431","0","","0","1596352726","0");
INSERT INTO gallery_foto VALUES("555","138","149630","jpg","image/jpeg","","","0","431","0","","0","1596352794","0");
INSERT INTO gallery_foto VALUES("556","138","149629","jpg","image/jpeg","","","0","431","0","","0","1596352857","0");
INSERT INTO gallery_foto VALUES("557","138","149635","jpg","image/jpeg","","","0","431","0","","0","1596352923","0");
INSERT INTO gallery_foto VALUES("558","138","149555","jpg","image/jpeg","","","0","431","0","","0","1596353067","0");
INSERT INTO gallery_foto VALUES("559","138","149631","jpg","image/jpeg","","","0","431","0","","0","1596353593","0");
INSERT INTO gallery_foto VALUES("560","138","U_OytKn3Bb8","jpg","image/jpeg","","","0","431","0","","0","1596353647","0");
INSERT INTO gallery_foto VALUES("561","138","149639","jpg","image/jpeg","","","0","431","0","","0","1596353764","0");
INSERT INTO gallery_foto VALUES("562","138","BhS_iiGRQkI","jpg","image/jpeg","","","0","431","0","","0","1596353833","0");
INSERT INTO gallery_foto VALUES("564","138","149636","jpg","image/jpeg","","","0","431","0","","0","1596354019","0");
INSERT INTO gallery_foto VALUES("565","138","149634","jpg","image/jpeg","","","0","431","0","","0","1596354084","0");
INSERT INTO gallery_foto VALUES("566","138","149632","jpg","image/jpeg","","","0","431","0","","0","1596354135","0");
INSERT INTO gallery_foto VALUES("567","138","149637","jpg","image/jpeg","","","0","431","0","","0","1596354189","0");
INSERT INTO gallery_foto VALUES("568","138","149633","jpg","image/jpeg","","","0","431","0","","0","1596354253","0");
INSERT INTO gallery_foto VALUES("569","138","149644","jpg","image/jpeg","","","0","431","0","","0","1596354386","0");
INSERT INTO gallery_foto VALUES("570","138","czEoXWTcf9k","jpg","image/jpeg","","","0","431","0","","0","1596354692","0");
INSERT INTO gallery_foto VALUES("571","138","149652","jpg","image/jpeg","","","0","431","0","","0","1596354726","0");
INSERT INTO gallery_foto VALUES("572","138","149646","jpg","image/jpeg","","","0","431","0","","0","1596354941","0");
INSERT INTO gallery_foto VALUES("573","138","149641","jpg","image/jpeg","","","0","431","0","","0","1596355037","0");
INSERT INTO gallery_foto VALUES("574","138","149648","jpg","image/jpeg","","","0","431","0","","0","1596355109","0");
INSERT INTO gallery_foto VALUES("575","138","149645","jpg","image/jpeg","","","0","431","0","","0","1596355195","0");
INSERT INTO gallery_foto VALUES("576","138","149650","jpg","image/jpeg","","","0","431","0","","0","1596355364","0");
INSERT INTO gallery_foto VALUES("577","138","149647","jpg","image/jpeg","","","0","431","0","","0","1596355600","0");
INSERT INTO gallery_foto VALUES("578","138","149651","jpg","image/jpeg","","","0","431","0","","0","1596355675","0");
INSERT INTO gallery_foto VALUES("579","138","149641","jpg","image/jpeg","","","0","431","0","","0","1596355906","0");
INSERT INTO gallery_foto VALUES("580","138","149640","jpg","image/jpeg","","","0","431","0","","0","1596356151","0");
INSERT INTO gallery_foto VALUES("581","138","149649","jpg","image/jpeg","","","5","431","0","","0","1596356203","0");
INSERT INTO gallery_foto VALUES("582","138","149642","jpg","image/jpeg","","","6","431","0","","0","1596356262","0");
INSERT INTO gallery_foto VALUES("585","321","Bon_jor_no ","jpg","image/jpeg","","","0","541","1","","0","1596397312","0");
INSERT INTO gallery_foto VALUES("588","138","149551","jpg","image/jpeg","","","10","431","0","","0","1596469301","0");
INSERT INTO gallery_foto VALUES("589","138","149553","jpg","image/jpeg","","","5","431","0","","0","1596469513","0");
INSERT INTO gallery_foto VALUES("590","138","149554","jpg","image/jpeg","","","10","431","0","","0","1596469540","0");
INSERT INTO gallery_foto VALUES("591","138","149552","jpg","image/jpeg","","","10","431","0","","0","1596469559","0");
INSERT INTO gallery_foto VALUES("594","224","Фотка","jpg","image/jpeg","","","6","1","0","","0","1596514790","0");
INSERT INTO gallery_foto VALUES("593","44","Фото","jpg","image/jpeg","","","23","330","1","","0","1596509988","0");
INSERT INTO gallery_foto VALUES("597","323","aJaonk4G1mBe","jpg","image/jpeg","","","0","595","1","","0","1597062782","0");
INSERT INTO gallery_foto VALUES("598","324","FB_IMG_1580121997097","jpg","image/jpeg","","","0","598","1","","0","1597347302","0");
INSERT INTO gallery_foto VALUES("600","326","20200812_074234","jpg","image/jpeg","","","5","601","0","","0","1597480221","0");
INSERT INTO gallery_foto VALUES("601","326","IMG_20200815_090123_476","jpg","image/jpeg","","","0","601","1","","0","1597481168","0");
INSERT INTO gallery_foto VALUES("602","327","IMG_20200801_232613","jpg","image/jpeg","","","0","594","0","","0","1597481954","0");
INSERT INTO gallery_foto VALUES("603","328","Яяяяя","jpg","image/jpeg","","","0","602","1","","0","1597497287","0");
INSERT INTO gallery_foto VALUES("604","258","IMG_20200604_195426","jpg","image/jpeg","","","0","542","1","","0","1597504218","0");
INSERT INTO gallery_foto VALUES("605","329","Ава","jpg","image/jpeg","","","0","603","1","","0","1597512440","0");
INSERT INTO gallery_foto VALUES("607","330","виталька","jpg","image/jpeg","","","0","605","1","","0","1597518105","0");
INSERT INTO gallery_foto VALUES("609","332","Авка","jpg","image/jpeg","","","6","606","1","","0","1597522610","0");
INSERT INTO gallery_foto VALUES("610","333","Артур","jpg","image/jpeg","Мажор","","0","607","1","","0","1597529993","0");
INSERT INTO gallery_foto VALUES("611","334","яяя","jpg","image/jpeg","","","0","608","1","","0","1597532748","0");
INSERT INTO gallery_foto VALUES("612","335","1596198169","jpg","image/jpeg","","","0","609","1","","0","1597541926","0");
INSERT INTO gallery_foto VALUES("613","336","IMG_20200810_172613","jpg","image/jpeg","","","5","609","0","","0","1597542382","0");
INSERT INTO gallery_foto VALUES("614","336","FB_IMG_15927491167243607","jpg","image/jpeg","","","5","609","0","","0","1597542420","0");
INSERT INTO gallery_foto VALUES("615","337","Ыыыыы","jpg","image/jpeg","Ыыыыы","","0","610","1","","0","1597549635","0");
INSERT INTO gallery_foto VALUES("616","327","IMG_20200808_231542","jpg","image/jpeg","","","0","594","1","","0","1597560756","0");
INSERT INTO gallery_foto VALUES("617","338","Нюта","jpg","image/jpeg","","","0","340","1","","0","1597563243","0");
INSERT INTO gallery_foto VALUES("618","339","Keyt","jpg","image/jpeg","","","0","611","1","","0","1597572958","0");
INSERT INTO gallery_foto VALUES("619","340","Ава","jpg","image/jpeg","Ава","","0","614","1","","0","1597602205","0");
INSERT INTO gallery_foto VALUES("620","341","Фото","jpg","image/jpeg","","","0","615","1","","0","1597604708","0");
INSERT INTO gallery_foto VALUES("621","224","Ножки","jpg","image/jpeg","","","17","1","1","","0","1597606433","0");
INSERT INTO gallery_foto VALUES("622","342","Батя","jpg","image/jpeg","","","0","620","1","","0","1597645601","0");
INSERT INTO gallery_foto VALUES("623","343","555","jpg","image/jpeg","","","0","621","1","","0","1597646933","0");
INSERT INTO gallery_foto VALUES("624","344","ХУЛИГАН","jpg","image/jpeg","","","0","619","1","","0","1597661505","0");
INSERT INTO gallery_foto VALUES("625","345","IMG_20200528_130844_459","jpg","image/jpeg","","","0","622","1","","0","1597676106","0");



DROP TABLE IF EXISTS `gallery_komm`;

CREATE TABLE `gallery_komm` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  `msg` varchar(1024) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id_foto` (`id_foto`)
) ENGINE=MyISAM AUTO_INCREMENT=22 DEFAULT CHARSET=utf8;

INSERT INTO gallery_komm VALUES("1","75","350","1591367523"," .ангел2. ");
INSERT INTO gallery_komm VALUES("2","75","358","1591373465","Серый, Спасибо)");
INSERT INTO gallery_komm VALUES("3","178","350","1592281110","красава!.");
INSERT INTO gallery_komm VALUES("4","167","427","1592451012","любимка моя.");
INSERT INTO gallery_komm VALUES("5","209","468","1592584335","Красавица :)");
INSERT INTO gallery_komm VALUES("6","155","487","1592764915"," .кис3. ");
INSERT INTO gallery_komm VALUES("8","319","350","1593495228","красава...\r\nцемк.");
INSERT INTO gallery_komm VALUES("9","319","531","1593495774","Серый, спасибо ");
INSERT INTO gallery_komm VALUES("10","322","505","1593533604","где то я это видел.ржу.");
INSERT INTO gallery_komm VALUES("11","322","534","1593593989","sany777, И где же вы это видели? .ржака4. ");
INSERT INTO gallery_komm VALUES("12","322","505","1593594232","_Небо_на_ладони_, .лол. вот там.идея2.");
INSERT INTO gallery_komm VALUES("13","322","534","1593594321","sany777, Вот там...И где же это,если поточнее... .пардон2. ");
INSERT INTO gallery_komm VALUES("15","593","554","1596530034","Ммм какая девочка огонь просто");
INSERT INTO gallery_komm VALUES("16","588","601","1597487405","Ты очень заманчива хороша ");
INSERT INTO gallery_komm VALUES("20","621","609","1597645212","А чьи жто такие чудо ноги? Ноги, к счастьб две дороги)))");
INSERT INTO gallery_komm VALUES("21","621","1","1597651023","Fireball, собственного производства .лол. то что мама с папой слепили ... шо маэмо те маэмо ");



DROP TABLE IF EXISTS `gallery_rating`;

CREATE TABLE `gallery_rating` (
  `id_foto` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `like` int(11) NOT NULL DEFAULT '0',
  `avtor` int(11) NOT NULL DEFAULT '0',
  `ready` int(11) NOT NULL DEFAULT '1',
  `time` int(11) NOT NULL DEFAULT '0',
  `read` int(1) DEFAULT '1',
  KEY `id_foto` (`id_foto`,`id_user`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;

INSERT INTO gallery_rating VALUES("48","342","6","330","1","1590945109","0");
INSERT INTO gallery_rating VALUES("69","1","6","353","1","1591039583","0");
INSERT INTO gallery_rating VALUES("48","369","5","330","1","1591191166","0");
INSERT INTO gallery_rating VALUES("76","369","5","358","1","1591191691","0");
INSERT INTO gallery_rating VALUES("77","369","5","358","1","1591191765","0");
INSERT INTO gallery_rating VALUES("75","369","5","358","1","1591191800","0");
INSERT INTO gallery_rating VALUES("83","369","5","361","1","1591195715","0");
INSERT INTO gallery_rating VALUES("50","369","5","336","1","1591196043","1");
INSERT INTO gallery_rating VALUES("81","369","5","363","1","1591209002","0");
INSERT INTO gallery_rating VALUES("94","369","5","339","1","1591209201","0");
INSERT INTO gallery_rating VALUES("95","369","5","372","1","1591214764","0");
INSERT INTO gallery_rating VALUES("92","339","6","369","1","1591218372","0");
INSERT INTO gallery_rating VALUES("76","353","5","358","1","1591245492","0");
INSERT INTO gallery_rating VALUES("77","353","5","358","1","1591245502","0");
INSERT INTO gallery_rating VALUES("75","353","5","358","1","1591245514","0");
INSERT INTO gallery_rating VALUES("75","350","6","358","1","1591367287","0");
INSERT INTO gallery_rating VALUES("77","350","6","358","1","1591367587","0");
INSERT INTO gallery_rating VALUES("76","350","6","358","1","1591367631","0");
INSERT INTO gallery_rating VALUES("76","1","6","358","1","1591440704","0");
INSERT INTO gallery_rating VALUES("121","324","6","398","1","1591636278","0");
INSERT INTO gallery_rating VALUES("97","324","5","373","1","1591805639","0");
INSERT INTO gallery_rating VALUES("121","411","5","398","1","1591888863","1");
INSERT INTO gallery_rating VALUES("57","411","5","344","1","1591888977","0");
INSERT INTO gallery_rating VALUES("147","414","6","324","1","1591953457","0");
INSERT INTO gallery_rating VALUES("147","362","6","324","1","1592043490","0");
INSERT INTO gallery_rating VALUES("164","362","6","428","1","1592050844","0");
INSERT INTO gallery_rating VALUES("165","326","6","330","1","1592082847","0");
INSERT INTO gallery_rating VALUES("168","350","6","429","1","1592106187","0");
INSERT INTO gallery_rating VALUES("167","427","6","355","1","1592107902","0");
INSERT INTO gallery_rating VALUES("77","424","6","358","1","1592133669","0");
INSERT INTO gallery_rating VALUES("76","424","6","358","1","1592133682","0");
INSERT INTO gallery_rating VALUES("75","424","6","358","1","1592133689","0");
INSERT INTO gallery_rating VALUES("174","350","5","435","1","1592233121","0");
INSERT INTO gallery_rating VALUES("178","324","6","391","1","1592253283","0");
INSERT INTO gallery_rating VALUES("178","350","6","391","1","1592280916","0");
INSERT INTO gallery_rating VALUES("114","351","6","391","1","1592323936","0");
INSERT INTO gallery_rating VALUES("155","424","6","423","1","1592414597","0");
INSERT INTO gallery_rating VALUES("100","424","6","378","1","1592414975","0");
INSERT INTO gallery_rating VALUES("155","455","6","423","1","1592422015","0");
INSERT INTO gallery_rating VALUES("154","464","5","422","1","1592500721","0");
INSERT INTO gallery_rating VALUES("75","1","6","358","1","1592502425","1");
INSERT INTO gallery_rating VALUES("214","422","6","464","1","1592516584","0");
INSERT INTO gallery_rating VALUES("213","422","6","464","1","1592516592","0");
INSERT INTO gallery_rating VALUES("212","422","6","464","1","1592516600","0");
INSERT INTO gallery_rating VALUES("195","468","6","452","1","1592584128","1");
INSERT INTO gallery_rating VALUES("209","468","6","463","1","1592584261","0");
INSERT INTO gallery_rating VALUES("57","468","6","344","1","1592584620","0");
INSERT INTO gallery_rating VALUES("209","351","6","463","1","1592649898","0");
INSERT INTO gallery_rating VALUES("236","486","5","480","1","1592753077","0");
INSERT INTO gallery_rating VALUES("243","486","5","325","1","1592753282","0");
INSERT INTO gallery_rating VALUES("155","351","6","423","1","1592798583","0");
INSERT INTO gallery_rating VALUES("209","350","6","463","1","1593056548","0");
INSERT INTO gallery_rating VALUES("272","424","6","362","1","1593179226","0");
INSERT INTO gallery_rating VALUES("280","422","6","344","1","1593235144","0");
INSERT INTO gallery_rating VALUES("57","422","6","344","1","1593235154","0");
INSERT INTO gallery_rating VALUES("258","422","6","497","1","1593240721","0");
INSERT INTO gallery_rating VALUES("292","515","5","514","1","1593273167","0");
INSERT INTO gallery_rating VALUES("280","515","5","344","1","1593280001","0");
INSERT INTO gallery_rating VALUES("57","515","5","344","1","1593280038","0");
INSERT INTO gallery_rating VALUES("344","515","5","543","1","1593835294","0");
INSERT INTO gallery_rating VALUES("165","515","5","330","1","1593284657","0");
INSERT INTO gallery_rating VALUES("48","515","5","330","1","1593284696","0");
INSERT INTO gallery_rating VALUES("295","515","5","518","1","1593318276","0");
INSERT INTO gallery_rating VALUES("310","351","6","531","1","1593482352","0");
INSERT INTO gallery_rating VALUES("319","350","6","531","1","1593495142","0");
INSERT INTO gallery_rating VALUES("322","505","6","534","1","1593533620","0");
INSERT INTO gallery_rating VALUES("336","1","6","533","1","1593668360","0");
INSERT INTO gallery_rating VALUES("323","515","5","538","1","1593751447","1");
INSERT INTO gallery_rating VALUES("347","515","5","516","1","1593800742","0");
INSERT INTO gallery_rating VALUES("167","515","5","355","1","1593993011","0");
INSERT INTO gallery_rating VALUES("167","505","6","355","1","1594059398","0");
INSERT INTO gallery_rating VALUES("369","519","6","506","1","1594104568","0");
INSERT INTO gallery_rating VALUES("167","553","6","355","1","1594315019","0");
INSERT INTO gallery_rating VALUES("382","554","6","561","1","1594453576","1");
INSERT INTO gallery_rating VALUES("48","554","6","330","1","1594454536","0");
INSERT INTO gallery_rating VALUES("165","554","6","330","1","1594454554","0");
INSERT INTO gallery_rating VALUES("388","515","5","492","1","1594699085","0");
INSERT INTO gallery_rating VALUES("387","515","5","492","1","1594699149","0");
INSERT INTO gallery_rating VALUES("389","515","5","506","1","1594872676","0");
INSERT INTO gallery_rating VALUES("263","515","5","501","1","1595179556","0");
INSERT INTO gallery_rating VALUES("462","515","5","579","1","1595250355","1");
INSERT INTO gallery_rating VALUES("375","350","5","559","1","1595337055","1");
INSERT INTO gallery_rating VALUES("331","510","6","511","1","1595615542","0");
INSERT INTO gallery_rating VALUES("155","554","6","423","1","1595617105","0");
INSERT INTO gallery_rating VALUES("391","576","6","554","1","1595680321","0");
INSERT INTO gallery_rating VALUES("390","576","6","554","1","1595680329","0");
INSERT INTO gallery_rating VALUES("372","576","6","554","1","1595680345","0");
INSERT INTO gallery_rating VALUES("480","554","6","576","1","1595702893","0");
INSERT INTO gallery_rating VALUES("493","576","6","330","1","1595703114","0");
INSERT INTO gallery_rating VALUES("424","576","6","330","1","1595703123","0");
INSERT INTO gallery_rating VALUES("165","576","6","330","1","1595703131","0");
INSERT INTO gallery_rating VALUES("48","576","6","330","1","1595703139","0");
INSERT INTO gallery_rating VALUES("517","510","6","511","1","1595825357","0");
INSERT INTO gallery_rating VALUES("520","576","6","431","1","1595872232","0");
INSERT INTO gallery_rating VALUES("519","576","6","431","1","1595872249","0");
INSERT INTO gallery_rating VALUES("518","576","6","431","1","1595872263","0");
INSERT INTO gallery_rating VALUES("521","584","6","576","1","1595872631","0");
INSERT INTO gallery_rating VALUES("480","584","6","576","1","1595874483","0");
INSERT INTO gallery_rating VALUES("524","554","6","330","1","1596016203","0");
INSERT INTO gallery_rating VALUES("391","433","5","554","1","1596302098","0");
INSERT INTO gallery_rating VALUES("390","433","5","554","1","1596302118","0");
INSERT INTO gallery_rating VALUES("593","554","6","330","1","1596529992","0");
INSERT INTO gallery_rating VALUES("593","326","6","330","1","1596536004","0");
INSERT INTO gallery_rating VALUES("326","589","5","351","1","1596586173","0");
INSERT INTO gallery_rating VALUES("74","589","5","351","1","1596586246","0");
INSERT INTO gallery_rating VALUES("85","554","6","312","1","1596825489","1");
INSERT INTO gallery_rating VALUES("582","576","6","431","1","1596868936","0");
INSERT INTO gallery_rating VALUES("590","350","5","431","1","1597372459","0");
INSERT INTO gallery_rating VALUES("591","601","5","431","1","1597487368","0");
INSERT INTO gallery_rating VALUES("590","601","5","431","1","1597487378","0");
INSERT INTO gallery_rating VALUES("589","601","5","431","1","1597487385","0");
INSERT INTO gallery_rating VALUES("588","601","5","431","1","1597487391","0");
INSERT INTO gallery_rating VALUES("600","497","5","601","1","1597524796","0");
INSERT INTO gallery_rating VALUES("606","594","6","320","1","1597530001","0");
INSERT INTO gallery_rating VALUES("609","594","6","606","1","1597530160","0");
INSERT INTO gallery_rating VALUES("458","594","6","526","1","1597533325","1");
INSERT INTO gallery_rating VALUES("85","594","6","312","1","1597535306","1");
INSERT INTO gallery_rating VALUES("427","609","5","514","1","1597541737","1");
INSERT INTO gallery_rating VALUES("591","609","5","431","1","1597543995","0");
INSERT INTO gallery_rating VALUES("588","609","5","431","1","1597544020","0");
INSERT INTO gallery_rating VALUES("587","609","5","431","1","1597544025","0");
INSERT INTO gallery_rating VALUES("581","609","5","431","1","1597544033","0");
INSERT INTO gallery_rating VALUES("593","609","5","330","1","1597544307","1");
INSERT INTO gallery_rating VALUES("524","609","5","330","1","1597544312","1");
INSERT INTO gallery_rating VALUES("493","609","5","330","1","1597544331","1");
INSERT INTO gallery_rating VALUES("424","609","5","330","1","1597544339","1");
INSERT INTO gallery_rating VALUES("165","609","5","330","1","1597544345","1");
INSERT INTO gallery_rating VALUES("48","609","5","330","1","1597544351","1");
INSERT INTO gallery_rating VALUES("614","603","5","609","1","1597549934","0");
INSERT INTO gallery_rating VALUES("613","603","5","609","1","1597549943","0");
INSERT INTO gallery_rating VALUES("606","554","6","320","1","1597551607","0");
INSERT INTO gallery_rating VALUES("593","602","6","330","1","1597568818","1");
INSERT INTO gallery_rating VALUES("524","602","6","330","1","1597568827","1");
INSERT INTO gallery_rating VALUES("493","602","6","330","1","1597568835","1");
INSERT INTO gallery_rating VALUES("424","602","6","330","1","1597568843","1");
INSERT INTO gallery_rating VALUES("165","602","6","330","1","1597568852","1");
INSERT INTO gallery_rating VALUES("48","602","6","330","1","1597568860","1");
INSERT INTO gallery_rating VALUES("167","602","6","355","1","1597577947","1");
INSERT INTO gallery_rating VALUES("621","609","5","1","1","1597645167","0");
INSERT INTO gallery_rating VALUES("621","602","6","1","1","1597646750","0");
INSERT INTO gallery_rating VALUES("621","605","6","1","1","1597647684","0");
INSERT INTO gallery_rating VALUES("594","605","6","1","1","1597647699","0");



DROP TABLE IF EXISTS `gangs`;

CREATE TABLE `gangs` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `rating` int(11) NOT NULL DEFAULT '0',
  `money` int(11) NOT NULL DEFAULT '0',
  `balls` int(11) NOT NULL DEFAULT '0',
  `status` varchar(250) NOT NULL,
  `name` varchar(50) NOT NULL,
  `block` set('0','1') NOT NULL DEFAULT '0',
  `cena` int(11) NOT NULL DEFAULT '0',
  `time` int(11) NOT NULL DEFAULT '0',
  `divident` int(11) NOT NULL,
  `closed` set('0','1','2','3') NOT NULL DEFAULT '0',
  `type` set('0','1','2') NOT NULL DEFAULT '0',
  `id_user` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `rating` (`rating`)
) ENGINE=MyISAM AUTO_INCREMENT=18 DEFAULT CHARSET=utf8;

INSERT INTO gangs VALUES("12","100","0","0","","Бандиты","0","0","1564500554","0","0","2","1");
INSERT INTO gangs VALUES("14","60","0","0","ДЛЯ НАСТОЯЩИХ ДРУЗЕЙ И ПОДРУГ КОТОРЫЕ НЕ ПРЕДАДУТ И НЕ ПОВЕРЯТ ВРАНЬЮ ПРО ВАС И ЛЖИВЫМ ОБВИНЕНИЯМ ПРО ВАС И ПОДДЕРЖАТ ВАС И ЗАЩИТЯТ!","ДРУЖБА","0","0","1565653290","0","0","1","98");
INSERT INTO gangs VALUES("15","25675","0","0","","Lucky Charm","0","1000","1565705763","1568341609","1","1","97");
INSERT INTO gangs VALUES("16","180","0","540"," Всем мажорам пиздец!","СКОРПИОН","0","0","1566980587","1567193230","0","2","74");
INSERT INTO gangs VALUES("17","3855","0","0","","Strong ","0","0","1581784652","1582175740","0","1","269");



DROP TABLE IF EXISTS `gangs_enemies`;

CREATE TABLE `gangs_enemies` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_invite`;

CREATE TABLE `gangs_invite` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_kont` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `id_gang` int(11) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_minichat`;

CREATE TABLE `gangs_minichat` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `id_user` int(11) NOT NULL,
  `msg` varchar(500) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;




DROP TABLE IF EXISTS `gangs_news`;

CREATE TABLE `gangs_news` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `id_gang` int(11) NOT NULL,
  `msg` varchar(500) NOT NULL,
  `time` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2674 DEFAULT CHARSET=utf8;

INSERT INTO gangs_news VALUES("659","12","[url=/info.php?id=Админ]Админ[/url] поднял рейтинг банды на  15 %.","1564505372");
INSERT INTO gangs_news VALUES("660","12","[url=/info.php?id=71]Виконт[/url] вступил(а) в банду.","1564583123");
INSERT INTO gangs_news VALUES("661","12","[url=/info.php?id=Виконт]Виконт[/url] поднял рейтинг банды на  5 %.","1564583153");
INSERT INTO gangs_news VALUES("662","12","[url=/info.php?id=Виконт]Виконт[/url] поднял рейтинг банды на  5 %.","1564583175");
INSERT INTO gangs_news VALUES("663","14","[url=/info.php?id=98]Маркиза[/url] изменил(а) статус банды.","1565653391");
INSERT INTO gangs_news VALUES("664","14","[url=/info.php?id=Маркиза]Маркиза[/url] поднял рейтинг банды на  15 %.","1565653407");
INSERT INTO gangs_news VALUES("665","14","[url=/info.php?id=Маркиза]Маркиза[/url] поднял рейтинг банды на  15 %.","1565653433");
INSERT INTO gangs_news VALUES("666","14","[url=/info.php?id=Маркиза]Маркиза[/url] поднял рейтинг банды на  15 %.","1565653464");
INSERT INTO gangs_news VALUES("667","14","[url=/info.php?id=Маркиза]Маркиза[/url] поднял рейтинг банды на  15 %.","1565653480");
INSERT INTO gangs_news VALUES("668","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705790");
INSERT INTO gangs_news VALUES("669","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705790");
INSERT INTO gangs_news VALUES("670","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705790");
INSERT INTO gangs_news VALUES("671","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705791");
INSERT INTO gangs_news VALUES("672","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705791");
INSERT INTO gangs_news VALUES("673","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705791");
INSERT INTO gangs_news VALUES("674","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705791");
INSERT INTO gangs_news VALUES("675","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705792");
INSERT INTO gangs_news VALUES("676","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705792");
INSERT INTO gangs_news VALUES("677","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705792");
INSERT INTO gangs_news VALUES("678","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705792");
INSERT INTO gangs_news VALUES("679","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705793");
INSERT INTO gangs_news VALUES("680","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705793");
INSERT INTO gangs_news VALUES("681","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705793");
INSERT INTO gangs_news VALUES("682","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705794");
INSERT INTO gangs_news VALUES("683","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705794");
INSERT INTO gangs_news VALUES("684","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705794");
INSERT INTO gangs_news VALUES("685","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705795");
INSERT INTO gangs_news VALUES("686","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705795");
INSERT INTO gangs_news VALUES("687","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705795");
INSERT INTO gangs_news VALUES("688","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705795");
INSERT INTO gangs_news VALUES("689","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705796");
INSERT INTO gangs_news VALUES("690","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705796");
INSERT INTO gangs_news VALUES("691","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705796");
INSERT INTO gangs_news VALUES("692","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705797");
INSERT INTO gangs_news VALUES("693","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705797");
INSERT INTO gangs_news VALUES("694","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705797");
INSERT INTO gangs_news VALUES("695","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705797");
INSERT INTO gangs_news VALUES("696","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705798");
INSERT INTO gangs_news VALUES("697","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705798");
INSERT INTO gangs_news VALUES("698","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705798");
INSERT INTO gangs_news VALUES("699","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705799");
INSERT INTO gangs_news VALUES("700","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705799");
INSERT INTO gangs_news VALUES("701","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705799");
INSERT INTO gangs_news VALUES("702","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705799");
INSERT INTO gangs_news VALUES("703","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705799");
INSERT INTO gangs_news VALUES("704","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705800");
INSERT INTO gangs_news VALUES("705","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705800");
INSERT INTO gangs_news VALUES("706","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705800");
INSERT INTO gangs_news VALUES("707","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705816");
INSERT INTO gangs_news VALUES("708","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705817");
INSERT INTO gangs_news VALUES("709","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705817");
INSERT INTO gangs_news VALUES("710","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705817");
INSERT INTO gangs_news VALUES("711","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705817");
INSERT INTO gangs_news VALUES("712","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705817");
INSERT INTO gangs_news VALUES("713","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705818");
INSERT INTO gangs_news VALUES("714","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705818");
INSERT INTO gangs_news VALUES("715","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705818");
INSERT INTO gangs_news VALUES("716","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705818");
INSERT INTO gangs_news VALUES("717","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705819");
INSERT INTO gangs_news VALUES("718","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705819");
INSERT INTO gangs_news VALUES("719","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705819");
INSERT INTO gangs_news VALUES("720","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705819");
INSERT INTO gangs_news VALUES("721","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705834");
INSERT INTO gangs_news VALUES("722","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705834");
INSERT INTO gangs_news VALUES("723","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705834");
INSERT INTO gangs_news VALUES("724","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705834");
INSERT INTO gangs_news VALUES("725","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705835");
INSERT INTO gangs_news VALUES("726","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705835");
INSERT INTO gangs_news VALUES("727","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705835");
INSERT INTO gangs_news VALUES("728","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705835");
INSERT INTO gangs_news VALUES("729","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705856");
INSERT INTO gangs_news VALUES("730","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705856");
INSERT INTO gangs_news VALUES("731","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705856");
INSERT INTO gangs_news VALUES("732","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705856");
INSERT INTO gangs_news VALUES("733","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705856");
INSERT INTO gangs_news VALUES("734","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705857");
INSERT INTO gangs_news VALUES("735","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705857");
INSERT INTO gangs_news VALUES("736","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705857");
INSERT INTO gangs_news VALUES("737","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705858");
INSERT INTO gangs_news VALUES("738","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705858");
INSERT INTO gangs_news VALUES("739","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705858");
INSERT INTO gangs_news VALUES("740","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705858");
INSERT INTO gangs_news VALUES("741","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705858");
INSERT INTO gangs_news VALUES("742","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705859");
INSERT INTO gangs_news VALUES("743","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705859");
INSERT INTO gangs_news VALUES("744","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705859");
INSERT INTO gangs_news VALUES("745","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705859");
INSERT INTO gangs_news VALUES("746","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705859");
INSERT INTO gangs_news VALUES("747","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705860");
INSERT INTO gangs_news VALUES("748","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705860");
INSERT INTO gangs_news VALUES("749","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705860");
INSERT INTO gangs_news VALUES("750","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705860");
INSERT INTO gangs_news VALUES("751","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705861");
INSERT INTO gangs_news VALUES("752","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705861");
INSERT INTO gangs_news VALUES("753","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705861");
INSERT INTO gangs_news VALUES("754","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705861");
INSERT INTO gangs_news VALUES("755","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565705862");
INSERT INTO gangs_news VALUES("756","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706178");
INSERT INTO gangs_news VALUES("757","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706178");
INSERT INTO gangs_news VALUES("758","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706178");
INSERT INTO gangs_news VALUES("759","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706178");
INSERT INTO gangs_news VALUES("760","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706179");
INSERT INTO gangs_news VALUES("761","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706179");
INSERT INTO gangs_news VALUES("762","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706179");
INSERT INTO gangs_news VALUES("763","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706179");
INSERT INTO gangs_news VALUES("764","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706180");
INSERT INTO gangs_news VALUES("765","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706180");
INSERT INTO gangs_news VALUES("766","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706180");
INSERT INTO gangs_news VALUES("767","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706180");
INSERT INTO gangs_news VALUES("768","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706180");
INSERT INTO gangs_news VALUES("769","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706181");
INSERT INTO gangs_news VALUES("770","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706181");
INSERT INTO gangs_news VALUES("771","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706181");
INSERT INTO gangs_news VALUES("772","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706182");
INSERT INTO gangs_news VALUES("773","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706182");
INSERT INTO gangs_news VALUES("774","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706182");
INSERT INTO gangs_news VALUES("775","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706182");
INSERT INTO gangs_news VALUES("776","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706182");
INSERT INTO gangs_news VALUES("777","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706183");
INSERT INTO gangs_news VALUES("778","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706183");
INSERT INTO gangs_news VALUES("779","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706183");
INSERT INTO gangs_news VALUES("780","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706183");
INSERT INTO gangs_news VALUES("781","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706184");
INSERT INTO gangs_news VALUES("782","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706184");
INSERT INTO gangs_news VALUES("783","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706184");
INSERT INTO gangs_news VALUES("784","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706185");
INSERT INTO gangs_news VALUES("785","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706185");
INSERT INTO gangs_news VALUES("786","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706185");
INSERT INTO gangs_news VALUES("787","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706185");
INSERT INTO gangs_news VALUES("788","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706185");
INSERT INTO gangs_news VALUES("789","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706186");
INSERT INTO gangs_news VALUES("790","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706186");
INSERT INTO gangs_news VALUES("791","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706186");
INSERT INTO gangs_news VALUES("792","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706186");
INSERT INTO gangs_news VALUES("793","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706186");
INSERT INTO gangs_news VALUES("794","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706187");
INSERT INTO gangs_news VALUES("795","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706187");
INSERT INTO gangs_news VALUES("796","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706187");
INSERT INTO gangs_news VALUES("797","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706187");
INSERT INTO gangs_news VALUES("798","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706187");
INSERT INTO gangs_news VALUES("799","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706188");
INSERT INTO gangs_news VALUES("800","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706188");
INSERT INTO gangs_news VALUES("801","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706188");
INSERT INTO gangs_news VALUES("802","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706189");
INSERT INTO gangs_news VALUES("803","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706189");
INSERT INTO gangs_news VALUES("804","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706189");
INSERT INTO gangs_news VALUES("805","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706189");
INSERT INTO gangs_news VALUES("806","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706190");
INSERT INTO gangs_news VALUES("807","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706190");
INSERT INTO gangs_news VALUES("808","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706190");
INSERT INTO gangs_news VALUES("809","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706190");
INSERT INTO gangs_news VALUES("810","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706190");
INSERT INTO gangs_news VALUES("811","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706191");
INSERT INTO gangs_news VALUES("812","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706191");
INSERT INTO gangs_news VALUES("813","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706191");
INSERT INTO gangs_news VALUES("814","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706191");
INSERT INTO gangs_news VALUES("815","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706191");
INSERT INTO gangs_news VALUES("816","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706192");
INSERT INTO gangs_news VALUES("817","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706192");
INSERT INTO gangs_news VALUES("818","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706192");
INSERT INTO gangs_news VALUES("819","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706192");
INSERT INTO gangs_news VALUES("820","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706193");
INSERT INTO gangs_news VALUES("821","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706193");
INSERT INTO gangs_news VALUES("822","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706193");
INSERT INTO gangs_news VALUES("823","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706193");
INSERT INTO gangs_news VALUES("824","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706193");
INSERT INTO gangs_news VALUES("825","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706194");
INSERT INTO gangs_news VALUES("826","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706194");
INSERT INTO gangs_news VALUES("827","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706194");
INSERT INTO gangs_news VALUES("828","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706195");
INSERT INTO gangs_news VALUES("829","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706195");
INSERT INTO gangs_news VALUES("830","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706195");
INSERT INTO gangs_news VALUES("831","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706195");
INSERT INTO gangs_news VALUES("832","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706196");
INSERT INTO gangs_news VALUES("833","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706196");
INSERT INTO gangs_news VALUES("834","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706196");
INSERT INTO gangs_news VALUES("835","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706196");
INSERT INTO gangs_news VALUES("836","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706197");
INSERT INTO gangs_news VALUES("837","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706197");
INSERT INTO gangs_news VALUES("838","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706197");
INSERT INTO gangs_news VALUES("839","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706197");
INSERT INTO gangs_news VALUES("840","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706198");
INSERT INTO gangs_news VALUES("841","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706198");
INSERT INTO gangs_news VALUES("842","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706198");
INSERT INTO gangs_news VALUES("843","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706198");
INSERT INTO gangs_news VALUES("844","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706198");
INSERT INTO gangs_news VALUES("845","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706199");
INSERT INTO gangs_news VALUES("846","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706199");
INSERT INTO gangs_news VALUES("847","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706199");
INSERT INTO gangs_news VALUES("848","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565706199");
INSERT INTO gangs_news VALUES("849","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("850","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("851","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("852","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("853","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("854","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710145");
INSERT INTO gangs_news VALUES("855","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710146");
INSERT INTO gangs_news VALUES("856","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710146");
INSERT INTO gangs_news VALUES("857","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710146");
INSERT INTO gangs_news VALUES("858","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710147");
INSERT INTO gangs_news VALUES("859","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710147");
INSERT INTO gangs_news VALUES("860","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710147");
INSERT INTO gangs_news VALUES("861","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710147");
INSERT INTO gangs_news VALUES("862","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710148");
INSERT INTO gangs_news VALUES("863","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710148");
INSERT INTO gangs_news VALUES("864","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565710181");
INSERT INTO gangs_news VALUES("865","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753311");
INSERT INTO gangs_news VALUES("866","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753311");
INSERT INTO gangs_news VALUES("867","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753312");
INSERT INTO gangs_news VALUES("868","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753312");
INSERT INTO gangs_news VALUES("869","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753313");
INSERT INTO gangs_news VALUES("870","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753313");
INSERT INTO gangs_news VALUES("871","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753313");
INSERT INTO gangs_news VALUES("872","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753314");
INSERT INTO gangs_news VALUES("873","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753314");
INSERT INTO gangs_news VALUES("874","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753314");
INSERT INTO gangs_news VALUES("875","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753314");
INSERT INTO gangs_news VALUES("876","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753314");
INSERT INTO gangs_news VALUES("877","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753315");
INSERT INTO gangs_news VALUES("878","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753315");
INSERT INTO gangs_news VALUES("879","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753315");
INSERT INTO gangs_news VALUES("880","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753315");
INSERT INTO gangs_news VALUES("881","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753316");
INSERT INTO gangs_news VALUES("882","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753316");
INSERT INTO gangs_news VALUES("883","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753317");
INSERT INTO gangs_news VALUES("884","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753317");
INSERT INTO gangs_news VALUES("885","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753317");
INSERT INTO gangs_news VALUES("886","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753318");
INSERT INTO gangs_news VALUES("887","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753318");
INSERT INTO gangs_news VALUES("888","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753318");
INSERT INTO gangs_news VALUES("889","15","[url=/info.php?id=CRYSTAL]CRYSTAL[/url] поднял рейтинг банды на  15 %.","1565753319");
INSERT INTO gangs_news VALUES("890","15","[url=/info.php?id=97]CRYSTAL[/url] изменил(а) настройки вступления в банду.","1565753352");
INSERT INTO gangs_news VALUES("891","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767729");
INSERT INTO gangs_news VALUES("892","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767731");
INSERT INTO gangs_news VALUES("893","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767731");
INSERT INTO gangs_news VALUES("894","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767731");
INSERT INTO gangs_news VALUES("895","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767731");
INSERT INTO gangs_news VALUES("896","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767731");
INSERT INTO gangs_news VALUES("897","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767732");
INSERT INTO gangs_news VALUES("898","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767732");
INSERT INTO gangs_news VALUES("899","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767733");
INSERT INTO gangs_news VALUES("900","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767733");
INSERT INTO gangs_news VALUES("901","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767733");
INSERT INTO gangs_news VALUES("902","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767733");
INSERT INTO gangs_news VALUES("903","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767734");
INSERT INTO gangs_news VALUES("904","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767734");
INSERT INTO gangs_news VALUES("905","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767734");
INSERT INTO gangs_news VALUES("906","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767735");
INSERT INTO gangs_news VALUES("907","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767735");
INSERT INTO gangs_news VALUES("908","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767735");
INSERT INTO gangs_news VALUES("909","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767735");
INSERT INTO gangs_news VALUES("910","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767736");
INSERT INTO gangs_news VALUES("911","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767736");
INSERT INTO gangs_news VALUES("912","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767736");
INSERT INTO gangs_news VALUES("913","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767737");
INSERT INTO gangs_news VALUES("914","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767737");
INSERT INTO gangs_news VALUES("915","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767737");
INSERT INTO gangs_news VALUES("916","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767738");
INSERT INTO gangs_news VALUES("917","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767738");
INSERT INTO gangs_news VALUES("918","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767738");
INSERT INTO gangs_news VALUES("919","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767738");
INSERT INTO gangs_news VALUES("920","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767739");
INSERT INTO gangs_news VALUES("921","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767739");
INSERT INTO gangs_news VALUES("922","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767739");
INSERT INTO gangs_news VALUES("923","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767739");
INSERT INTO gangs_news VALUES("924","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767740");
INSERT INTO gangs_news VALUES("925","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767740");
INSERT INTO gangs_news VALUES("926","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767740");
INSERT INTO gangs_news VALUES("927","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767741");
INSERT INTO gangs_news VALUES("928","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767741");
INSERT INTO gangs_news VALUES("929","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767741");
INSERT INTO gangs_news VALUES("930","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("931","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("932","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("933","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("934","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("935","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767742");
INSERT INTO gangs_news VALUES("936","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767743");
INSERT INTO gangs_news VALUES("937","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767743");
INSERT INTO gangs_news VALUES("938","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767744");
INSERT INTO gangs_news VALUES("939","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767744");
INSERT INTO gangs_news VALUES("940","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767744");
INSERT INTO gangs_news VALUES("941","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767744");
INSERT INTO gangs_news VALUES("942","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767744");
INSERT INTO gangs_news VALUES("943","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767745");
INSERT INTO gangs_news VALUES("944","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767745");
INSERT INTO gangs_news VALUES("945","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767745");
INSERT INTO gangs_news VALUES("946","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767745");
INSERT INTO gangs_news VALUES("947","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767746");
INSERT INTO gangs_news VALUES("948","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767746");
INSERT INTO gangs_news VALUES("949","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767746");
INSERT INTO gangs_news VALUES("950","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767747");
INSERT INTO gangs_news VALUES("951","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767747");
INSERT INTO gangs_news VALUES("952","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767747");
INSERT INTO gangs_news VALUES("953","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767761");
INSERT INTO gangs_news VALUES("954","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767761");
INSERT INTO gangs_news VALUES("955","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767761");
INSERT INTO gangs_news VALUES("956","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767762");
INSERT INTO gangs_news VALUES("957","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767762");
INSERT INTO gangs_news VALUES("958","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767762");
INSERT INTO gangs_news VALUES("959","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767762");
INSERT INTO gangs_news VALUES("960","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767763");
INSERT INTO gangs_news VALUES("961","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767763");
INSERT INTO gangs_news VALUES("962","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767763");
INSERT INTO gangs_news VALUES("963","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767764");
INSERT INTO gangs_news VALUES("964","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767764");
INSERT INTO gangs_news VALUES("965","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767764");
INSERT INTO gangs_news VALUES("966","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767765");
INSERT INTO gangs_news VALUES("967","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767765");
INSERT INTO gangs_news VALUES("968","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767765");
INSERT INTO gangs_news VALUES("969","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767765");
INSERT INTO gangs_news VALUES("970","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767766");
INSERT INTO gangs_news VALUES("971","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767766");
INSERT INTO gangs_news VALUES("972","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767766");
INSERT INTO gangs_news VALUES("973","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767766");
INSERT INTO gangs_news VALUES("974","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767767");
INSERT INTO gangs_news VALUES("975","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767767");
INSERT INTO gangs_news VALUES("976","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767768");
INSERT INTO gangs_news VALUES("977","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767768");
INSERT INTO gangs_news VALUES("978","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767768");
INSERT INTO gangs_news VALUES("979","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767768");
INSERT INTO gangs_news VALUES("980","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767769");
INSERT INTO gangs_news VALUES("981","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767769");
INSERT INTO gangs_news VALUES("982","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767769");
INSERT INTO gangs_news VALUES("983","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767769");
INSERT INTO gangs_news VALUES("984","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767770");
INSERT INTO gangs_news VALUES("985","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767770");
INSERT INTO gangs_news VALUES("986","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767770");
INSERT INTO gangs_news VALUES("987","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767771");
INSERT INTO gangs_news VALUES("988","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767771");
INSERT INTO gangs_news VALUES("989","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767771");
INSERT INTO gangs_news VALUES("990","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767772");
INSERT INTO gangs_news VALUES("991","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767772");
INSERT INTO gangs_news VALUES("992","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767772");
INSERT INTO gangs_news VALUES("993","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767772");
INSERT INTO gangs_news VALUES("994","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767773");
INSERT INTO gangs_news VALUES("995","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767773");
INSERT INTO gangs_news VALUES("996","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767773");
INSERT INTO gangs_news VALUES("997","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767773");
INSERT INTO gangs_news VALUES("998","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767774");
INSERT INTO gangs_news VALUES("999","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767774");
INSERT INTO gangs_news VALUES("1000","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767774");
INSERT INTO gangs_news VALUES("1001","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767775");
INSERT INTO gangs_news VALUES("1002","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767775");
INSERT INTO gangs_news VALUES("1003","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767776");
INSERT INTO gangs_news VALUES("1004","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565767776");
INSERT INTO gangs_news VALUES("1005","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786936");
INSERT INTO gangs_news VALUES("1006","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786936");
INSERT INTO gangs_news VALUES("1007","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786936");
INSERT INTO gangs_news VALUES("1008","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786936");
INSERT INTO gangs_news VALUES("1009","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786936");
INSERT INTO gangs_news VALUES("1010","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786937");
INSERT INTO gangs_news VALUES("1011","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786937");
INSERT INTO gangs_news VALUES("1012","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786937");
INSERT INTO gangs_news VALUES("1013","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786937");
INSERT INTO gangs_news VALUES("1014","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786938");
INSERT INTO gangs_news VALUES("1015","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786938");
INSERT INTO gangs_news VALUES("1016","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786938");
INSERT INTO gangs_news VALUES("1017","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786938");
INSERT INTO gangs_news VALUES("1018","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786939");
INSERT INTO gangs_news VALUES("1019","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786939");
INSERT INTO gangs_news VALUES("1020","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786939");
INSERT INTO gangs_news VALUES("1021","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786940");
INSERT INTO gangs_news VALUES("1022","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786940");
INSERT INTO gangs_news VALUES("1023","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786940");
INSERT INTO gangs_news VALUES("1024","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786940");
INSERT INTO gangs_news VALUES("1025","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786940");
INSERT INTO gangs_news VALUES("1026","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786941");
INSERT INTO gangs_news VALUES("1027","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786941");
INSERT INTO gangs_news VALUES("1028","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1029","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1030","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1031","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1032","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1033","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565786942");
INSERT INTO gangs_news VALUES("1034","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1035","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1036","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1037","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1038","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1039","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1040","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792397");
INSERT INTO gangs_news VALUES("1041","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1042","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1043","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1044","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1045","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1046","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1047","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792398");
INSERT INTO gangs_news VALUES("1048","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792399");
INSERT INTO gangs_news VALUES("1049","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792399");
INSERT INTO gangs_news VALUES("1050","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792399");
INSERT INTO gangs_news VALUES("1051","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792399");
INSERT INTO gangs_news VALUES("1052","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792399");
INSERT INTO gangs_news VALUES("1053","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792400");
INSERT INTO gangs_news VALUES("1054","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792400");
INSERT INTO gangs_news VALUES("1055","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792400");
INSERT INTO gangs_news VALUES("1056","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792400");
INSERT INTO gangs_news VALUES("1057","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792400");
INSERT INTO gangs_news VALUES("1058","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792401");
INSERT INTO gangs_news VALUES("1059","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792401");
INSERT INTO gangs_news VALUES("1060","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792401");
INSERT INTO gangs_news VALUES("1061","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792401");
INSERT INTO gangs_news VALUES("1062","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792402");
INSERT INTO gangs_news VALUES("1063","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792402");
INSERT INTO gangs_news VALUES("1064","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792402");
INSERT INTO gangs_news VALUES("1065","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792402");
INSERT INTO gangs_news VALUES("1066","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792403");
INSERT INTO gangs_news VALUES("1067","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792403");
INSERT INTO gangs_news VALUES("1068","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792403");
INSERT INTO gangs_news VALUES("1069","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792403");
INSERT INTO gangs_news VALUES("1070","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792403");
INSERT INTO gangs_news VALUES("1071","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792404");
INSERT INTO gangs_news VALUES("1072","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792404");
INSERT INTO gangs_news VALUES("1073","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792404");
INSERT INTO gangs_news VALUES("1074","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792404");
INSERT INTO gangs_news VALUES("1075","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792405");
INSERT INTO gangs_news VALUES("1076","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792405");
INSERT INTO gangs_news VALUES("1077","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792405");
INSERT INTO gangs_news VALUES("1078","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792405");
INSERT INTO gangs_news VALUES("1079","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792405");
INSERT INTO gangs_news VALUES("1080","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792406");
INSERT INTO gangs_news VALUES("1081","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792406");
INSERT INTO gangs_news VALUES("1082","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792406");
INSERT INTO gangs_news VALUES("1083","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792406");
INSERT INTO gangs_news VALUES("1084","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792407");
INSERT INTO gangs_news VALUES("1085","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792407");
INSERT INTO gangs_news VALUES("1086","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792407");
INSERT INTO gangs_news VALUES("1087","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792407");
INSERT INTO gangs_news VALUES("1088","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792407");
INSERT INTO gangs_news VALUES("1089","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792408");
INSERT INTO gangs_news VALUES("1090","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792408");
INSERT INTO gangs_news VALUES("1091","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565792408");
INSERT INTO gangs_news VALUES("1092","15","[url=/info.php?id=97]Better Half[/url] разделил баллы из общака банды. Каждому участнику банды досталось по 20385 баллов.","1565792475");
INSERT INTO gangs_news VALUES("1093","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835358");
INSERT INTO gangs_news VALUES("1094","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835358");
INSERT INTO gangs_news VALUES("1095","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835358");
INSERT INTO gangs_news VALUES("1096","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835359");
INSERT INTO gangs_news VALUES("1097","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835359");
INSERT INTO gangs_news VALUES("1098","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835359");
INSERT INTO gangs_news VALUES("1099","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835359");
INSERT INTO gangs_news VALUES("1100","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835360");
INSERT INTO gangs_news VALUES("1101","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835360");
INSERT INTO gangs_news VALUES("1102","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835360");
INSERT INTO gangs_news VALUES("1103","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1104","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1105","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1106","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1107","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1108","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835361");
INSERT INTO gangs_news VALUES("1109","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835362");
INSERT INTO gangs_news VALUES("1110","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835362");
INSERT INTO gangs_news VALUES("1111","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835362");
INSERT INTO gangs_news VALUES("1112","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835362");
INSERT INTO gangs_news VALUES("1113","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835362");
INSERT INTO gangs_news VALUES("1114","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835363");
INSERT INTO gangs_news VALUES("1115","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835363");
INSERT INTO gangs_news VALUES("1116","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835363");
INSERT INTO gangs_news VALUES("1117","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835364");
INSERT INTO gangs_news VALUES("1118","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835364");
INSERT INTO gangs_news VALUES("1119","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835364");
INSERT INTO gangs_news VALUES("1120","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835364");
INSERT INTO gangs_news VALUES("1121","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835364");
INSERT INTO gangs_news VALUES("1122","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835365");
INSERT INTO gangs_news VALUES("1123","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835365");
INSERT INTO gangs_news VALUES("1124","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835365");
INSERT INTO gangs_news VALUES("1125","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835365");
INSERT INTO gangs_news VALUES("1126","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835366");
INSERT INTO gangs_news VALUES("1127","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835366");
INSERT INTO gangs_news VALUES("1128","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835366");
INSERT INTO gangs_news VALUES("1129","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835367");
INSERT INTO gangs_news VALUES("1130","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835367");
INSERT INTO gangs_news VALUES("1131","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835367");
INSERT INTO gangs_news VALUES("1132","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835367");
INSERT INTO gangs_news VALUES("1133","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835367");
INSERT INTO gangs_news VALUES("1134","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835368");
INSERT INTO gangs_news VALUES("1135","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835368");
INSERT INTO gangs_news VALUES("1136","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835368");
INSERT INTO gangs_news VALUES("1137","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835368");
INSERT INTO gangs_news VALUES("1138","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835369");
INSERT INTO gangs_news VALUES("1139","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835369");
INSERT INTO gangs_news VALUES("1140","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565835369");
INSERT INTO gangs_news VALUES("1141","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858214");
INSERT INTO gangs_news VALUES("1142","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858214");
INSERT INTO gangs_news VALUES("1143","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858214");
INSERT INTO gangs_news VALUES("1144","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858215");
INSERT INTO gangs_news VALUES("1145","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858215");
INSERT INTO gangs_news VALUES("1146","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858215");
INSERT INTO gangs_news VALUES("1147","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858215");
INSERT INTO gangs_news VALUES("1148","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858216");
INSERT INTO gangs_news VALUES("1149","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858216");
INSERT INTO gangs_news VALUES("1150","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858216");
INSERT INTO gangs_news VALUES("1151","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858216");
INSERT INTO gangs_news VALUES("1152","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858216");
INSERT INTO gangs_news VALUES("1153","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858217");
INSERT INTO gangs_news VALUES("1154","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858217");
INSERT INTO gangs_news VALUES("1155","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858217");
INSERT INTO gangs_news VALUES("1156","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858217");
INSERT INTO gangs_news VALUES("1157","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858218");
INSERT INTO gangs_news VALUES("1158","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858218");
INSERT INTO gangs_news VALUES("1159","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858218");
INSERT INTO gangs_news VALUES("1160","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858218");
INSERT INTO gangs_news VALUES("1161","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858218");
INSERT INTO gangs_news VALUES("1162","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858219");
INSERT INTO gangs_news VALUES("1163","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858219");
INSERT INTO gangs_news VALUES("1164","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858219");
INSERT INTO gangs_news VALUES("1165","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858219");
INSERT INTO gangs_news VALUES("1166","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858219");
INSERT INTO gangs_news VALUES("1167","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858220");
INSERT INTO gangs_news VALUES("1168","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858220");
INSERT INTO gangs_news VALUES("1169","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858220");
INSERT INTO gangs_news VALUES("1170","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858220");
INSERT INTO gangs_news VALUES("1171","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858220");
INSERT INTO gangs_news VALUES("1172","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858221");
INSERT INTO gangs_news VALUES("1173","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858221");
INSERT INTO gangs_news VALUES("1174","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858221");
INSERT INTO gangs_news VALUES("1175","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858221");
INSERT INTO gangs_news VALUES("1176","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858221");
INSERT INTO gangs_news VALUES("1177","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858222");
INSERT INTO gangs_news VALUES("1178","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858222");
INSERT INTO gangs_news VALUES("1179","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858222");
INSERT INTO gangs_news VALUES("1180","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858222");
INSERT INTO gangs_news VALUES("1181","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858222");
INSERT INTO gangs_news VALUES("1182","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858223");
INSERT INTO gangs_news VALUES("1183","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858223");
INSERT INTO gangs_news VALUES("1184","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858223");
INSERT INTO gangs_news VALUES("1185","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858223");
INSERT INTO gangs_news VALUES("1186","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858224");
INSERT INTO gangs_news VALUES("1187","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858224");
INSERT INTO gangs_news VALUES("1188","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858224");
INSERT INTO gangs_news VALUES("1189","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858224");
INSERT INTO gangs_news VALUES("1190","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858224");
INSERT INTO gangs_news VALUES("1191","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858225");
INSERT INTO gangs_news VALUES("1192","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858225");
INSERT INTO gangs_news VALUES("1193","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858225");
INSERT INTO gangs_news VALUES("1194","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858225");
INSERT INTO gangs_news VALUES("1195","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858225");
INSERT INTO gangs_news VALUES("1196","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858226");
INSERT INTO gangs_news VALUES("1197","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858226");
INSERT INTO gangs_news VALUES("1198","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858226");
INSERT INTO gangs_news VALUES("1199","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858227");
INSERT INTO gangs_news VALUES("1200","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858227");
INSERT INTO gangs_news VALUES("1201","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858227");
INSERT INTO gangs_news VALUES("1202","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858227");
INSERT INTO gangs_news VALUES("1203","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858227");
INSERT INTO gangs_news VALUES("1204","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858228");
INSERT INTO gangs_news VALUES("1205","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858228");
INSERT INTO gangs_news VALUES("1206","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858228");
INSERT INTO gangs_news VALUES("1207","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858228");
INSERT INTO gangs_news VALUES("1208","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858228");
INSERT INTO gangs_news VALUES("1209","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858229");
INSERT INTO gangs_news VALUES("1210","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858229");
INSERT INTO gangs_news VALUES("1211","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858229");
INSERT INTO gangs_news VALUES("1212","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858229");
INSERT INTO gangs_news VALUES("1213","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858230");
INSERT INTO gangs_news VALUES("1214","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858230");
INSERT INTO gangs_news VALUES("1215","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858230");
INSERT INTO gangs_news VALUES("1216","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858230");
INSERT INTO gangs_news VALUES("1217","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858230");
INSERT INTO gangs_news VALUES("1218","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858231");
INSERT INTO gangs_news VALUES("1219","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858231");
INSERT INTO gangs_news VALUES("1220","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858231");
INSERT INTO gangs_news VALUES("1221","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858231");
INSERT INTO gangs_news VALUES("1222","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858231");
INSERT INTO gangs_news VALUES("1223","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858249");
INSERT INTO gangs_news VALUES("1224","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858249");
INSERT INTO gangs_news VALUES("1225","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858250");
INSERT INTO gangs_news VALUES("1226","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858250");
INSERT INTO gangs_news VALUES("1227","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858250");
INSERT INTO gangs_news VALUES("1228","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858250");
INSERT INTO gangs_news VALUES("1229","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858251");
INSERT INTO gangs_news VALUES("1230","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858251");
INSERT INTO gangs_news VALUES("1231","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858251");
INSERT INTO gangs_news VALUES("1232","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858251");
INSERT INTO gangs_news VALUES("1233","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858251");
INSERT INTO gangs_news VALUES("1234","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858252");
INSERT INTO gangs_news VALUES("1235","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858252");
INSERT INTO gangs_news VALUES("1236","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858252");
INSERT INTO gangs_news VALUES("1237","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858252");
INSERT INTO gangs_news VALUES("1238","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858252");
INSERT INTO gangs_news VALUES("1239","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858253");
INSERT INTO gangs_news VALUES("1240","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858253");
INSERT INTO gangs_news VALUES("1241","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858253");
INSERT INTO gangs_news VALUES("1242","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858253");
INSERT INTO gangs_news VALUES("1243","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858254");
INSERT INTO gangs_news VALUES("1244","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858254");
INSERT INTO gangs_news VALUES("1245","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858254");
INSERT INTO gangs_news VALUES("1246","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858254");
INSERT INTO gangs_news VALUES("1247","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858255");
INSERT INTO gangs_news VALUES("1248","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858255");
INSERT INTO gangs_news VALUES("1249","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858255");
INSERT INTO gangs_news VALUES("1250","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858255");
INSERT INTO gangs_news VALUES("1251","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858255");
INSERT INTO gangs_news VALUES("1252","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858256");
INSERT INTO gangs_news VALUES("1253","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858256");
INSERT INTO gangs_news VALUES("1254","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858256");
INSERT INTO gangs_news VALUES("1255","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858256");
INSERT INTO gangs_news VALUES("1256","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858257");
INSERT INTO gangs_news VALUES("1257","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858257");
INSERT INTO gangs_news VALUES("1258","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858257");
INSERT INTO gangs_news VALUES("1259","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858257");
INSERT INTO gangs_news VALUES("1260","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858257");
INSERT INTO gangs_news VALUES("1261","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858258");
INSERT INTO gangs_news VALUES("1262","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858258");
INSERT INTO gangs_news VALUES("1263","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858258");
INSERT INTO gangs_news VALUES("1264","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858258");
INSERT INTO gangs_news VALUES("1265","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858258");
INSERT INTO gangs_news VALUES("1266","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858259");
INSERT INTO gangs_news VALUES("1267","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858259");
INSERT INTO gangs_news VALUES("1268","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858259");
INSERT INTO gangs_news VALUES("1269","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858259");
INSERT INTO gangs_news VALUES("1270","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858260");
INSERT INTO gangs_news VALUES("1271","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858260");
INSERT INTO gangs_news VALUES("1272","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858260");
INSERT INTO gangs_news VALUES("1273","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858260");
INSERT INTO gangs_news VALUES("1274","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858260");
INSERT INTO gangs_news VALUES("1275","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858261");
INSERT INTO gangs_news VALUES("1276","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858261");
INSERT INTO gangs_news VALUES("1277","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858261");
INSERT INTO gangs_news VALUES("1278","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858261");
INSERT INTO gangs_news VALUES("1279","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858261");
INSERT INTO gangs_news VALUES("1280","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858262");
INSERT INTO gangs_news VALUES("1281","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858262");
INSERT INTO gangs_news VALUES("1282","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858262");
INSERT INTO gangs_news VALUES("1283","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858262");
INSERT INTO gangs_news VALUES("1284","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858263");
INSERT INTO gangs_news VALUES("1285","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858263");
INSERT INTO gangs_news VALUES("1286","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858263");
INSERT INTO gangs_news VALUES("1287","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858263");
INSERT INTO gangs_news VALUES("1288","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858263");
INSERT INTO gangs_news VALUES("1289","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858264");
INSERT INTO gangs_news VALUES("1290","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858264");
INSERT INTO gangs_news VALUES("1291","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858264");
INSERT INTO gangs_news VALUES("1292","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858264");
INSERT INTO gangs_news VALUES("1293","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858264");
INSERT INTO gangs_news VALUES("1294","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858265");
INSERT INTO gangs_news VALUES("1295","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858265");
INSERT INTO gangs_news VALUES("1296","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858281");
INSERT INTO gangs_news VALUES("1297","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858281");
INSERT INTO gangs_news VALUES("1298","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858281");
INSERT INTO gangs_news VALUES("1299","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858281");
INSERT INTO gangs_news VALUES("1300","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858282");
INSERT INTO gangs_news VALUES("1301","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858282");
INSERT INTO gangs_news VALUES("1302","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858282");
INSERT INTO gangs_news VALUES("1303","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858282");
INSERT INTO gangs_news VALUES("1304","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858282");
INSERT INTO gangs_news VALUES("1305","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858283");
INSERT INTO gangs_news VALUES("1306","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858283");
INSERT INTO gangs_news VALUES("1307","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858283");
INSERT INTO gangs_news VALUES("1308","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858284");
INSERT INTO gangs_news VALUES("1309","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858284");
INSERT INTO gangs_news VALUES("1310","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858284");
INSERT INTO gangs_news VALUES("1311","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858284");
INSERT INTO gangs_news VALUES("1312","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858285");
INSERT INTO gangs_news VALUES("1313","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858285");
INSERT INTO gangs_news VALUES("1314","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858285");
INSERT INTO gangs_news VALUES("1315","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858285");
INSERT INTO gangs_news VALUES("1316","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858286");
INSERT INTO gangs_news VALUES("1317","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858286");
INSERT INTO gangs_news VALUES("1318","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858286");
INSERT INTO gangs_news VALUES("1319","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858286");
INSERT INTO gangs_news VALUES("1320","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858286");
INSERT INTO gangs_news VALUES("1321","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858287");
INSERT INTO gangs_news VALUES("1322","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858287");
INSERT INTO gangs_news VALUES("1323","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858287");
INSERT INTO gangs_news VALUES("1324","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858287");
INSERT INTO gangs_news VALUES("1325","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858288");
INSERT INTO gangs_news VALUES("1326","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565858288");
INSERT INTO gangs_news VALUES("1327","15","[url=/info.php?id=Better Half]Better Half[/url] поднял рейтинг банды на  15 %.","1565