<?php 
define('SERVER','localhost');
define('USER','mysql');
define('PASS','mysql');
define('DBNAME','base');

class base
{
	public $db_link; // Идентификатор соединения
	public $debugging = true;//Режим отладки
	//Подключается к базе:
	public function __construct()
	{
        $this->db_link = @mysqli_connect(SERVER, USER, PASS, DBNAME);
		// О нет!! переменная connect_errno существует, а это значит, что соединение не было успешным!
		if (mysqli_connect_errno()) {
			$set['title'] = 'Помогите!';
			require_once '/sys/head.php';
			echo "<div class='PageBlock main'>";
			echo "Не удалось создать соединение с базой данных<br/>\n";
			echo "Код ошибки - <b>".mysqli_connect_errno()."</b>.</center>\n";
			echo "</div>";
			require_once '/sys/foot.php';
		}
	}

    //Выполнение запроса к базе
    public function query($query)
    {

        # Выполняем запрос
        $result = mysqli_query($this->db_link, $query) or
        
		$this->error($query . PHP_EOL . mysqli_error($this->db_link));

        return $result;
    }
	//Получение одной ячейки
    public function get_one($query)
    {
        $result = $this->query($query);
        if ($row = mysqli_fetch_row($result)) {
            return stripslashes($row[0]);
        }
        return FALSE;
    }
	//Получение строки
    public function get_row($query, $restype = MYSQLI_ASSOC)
    {
        $result = $this->query($query);
        if ($row = mysqli_fetch_array($result, $restype)) {
            return array_map('stripslashes', $row);
        }
        return FALSE;
    }

    //Получение нескольких строк
    public function get_array($query)
    {
        $data = array();
        $result = $this->query($query);
        while ($row = $this->fetch_array($result)) {
            $data[] = array_map('stripslashes', $row);
        }
        return $data;
    }
	
	//Получение нескольких строк
    public function quote($query)
    {
        $result = mysqli_real_escape_string($this->db_link, $query);
        return $result;
    }
	//Последний вставленный id
    public function insert_id()
    {
        return mysqli_insert_id($this->db_link);
    }
		
	//Аналог mysql_fetch_array()
    public function fetch_array($result)
    {
        return mysqli_fetch_array($result);
    }

    //Аналог mysql_num_rows()
    public function num_rows($result)
    {
        return mysqli_num_rows($result);
    }
	
	public function fetch_quote($result)
    {
        return mysqli_real_escape_string($result);
    }
	
	/**
     * Вывод ошибки и завершение работы
     * @param string $error
     */
    protected function error($error)
    {
        if ($this->debugging) {
            print "<pre>" . $error . "</pre>";
        }
        exit;
    }
}
?>